; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /F, a    ;hold fwd while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;               command = ~30
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their engine.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted


;-| Super Motions |--------------------------------------------------------
[Command]             ;K.F.M.S.W.A
name = QCF_ab
command = ~D, DF, F, a+b

[Command]             ;Xp[N[U[
name = YOG_b
command = ~B,D, DF, F, b

[Command]             ;V[guX^[
name = QCBF_b
command = ~D, DB, B, F, b

;-| Special Motions |------------------------------------------------------
[Command]             ;}VKV[^[
name = FBF_a
command = ~F, B, F, a

[Command]             ;GlM[Vbg
name = BF_b
command = ~B, F, b

[Command]             ;GlM[a
name = ANN_b
command = ~B, DB, D, b

[Command]             ;[TgXvbV
name = YOG_a
command = ~B,D, DF, F, a

[Command]             ;XJCUbp[
name = QCF_x
command = ~D, DF, F, x

[Command]             ;XbVCi[
name = QCF_a
command = ~D, DF, F, a

[Command]             ;gUGlM[e
name = QCB_b
command = ~D, DB, B, b

[Command]             ;tgXgCN
name = FBDU_a
command = ~F, B, D, U, a
time =20

;-| Double Tap |-----------------------------------------------------------
[Command]
name = FF      ;Required (do not remove)
command = F, F
time = 10

[Command]
name = BB       ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = recovery ;Required (do not remove)
command = a+b
time = 1

[Command]
name = ab
command = a+b
time = 1

[Command]             ;C
name = ax
command = a+x
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = fwd_a
command = /F,a
time = 1

[Command]
name = fwd_b
command = /F,b
time = 1

[Command]
name = fwd_c
command = /F,c
time = 1

[Command]
name = downfwd_a
command = /DF,a
time = 1

[Command]
name = downfwd_b
command = /DF,b
time = 1

[Command]
name = back_a
command = /B,a
time = 1

[Command]
name = back_b
command = /B,b
time = 1

[Command]
name = back_c
command = /B,c
time = 1

[Command]
name = down_a
command = /$D,a
time = 1

[Command]
name = down_b
command = /$D,b
time = 1

[Command]
name = down_c
command = /$D,c
time = 1

[Command]
name = fwd_ab
command = /F, a+b
time = 1

[Command]
name = fwd_x
command = /F, x
time = 1

[Command]
name = back_ab
command = /B, a+b
time = 1

[Command]
name = holda 
command = /a
time = 1

[Command]
name = holdx 
command = /x
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = a
command = a
time = 1

[Command]
name = b
command = b
time = 1

[Command]
name = c
command = c
time = 1

[Command]
name = x
command = x
time = 1

[Command]
name = y
command = y
time = 1

[Command]
name = z
command = z
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = holdfwd  ;Required (do not remove)
command = /$F
time = 1

[Command]
name = holdback ;Required (do not remove)
command = /$B
time = 1

[Command]
name = holdup   ;Required (do not remove)
command = /$U
time = 1

[Command]
name = holddown ;Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1]                  ;Don't change this
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
;K.F.M.S.W.A
[State -1]
type = ChangeState
value = 3000
triggerall = command = QCF_ab
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA
trigger2 = movecontact = 1
trigger3 = stateno = 5120   ;iNオ蒆j
trigger4 = stateno = 1000
trigger4 = Time = [0, 33]
trigger4 = movecontact = 1
trigger5 = stateno = 1005
trigger5 = Time > 60
trigger5 = movecontact = 1

;Xp[N[U[
[State -1]
type = ChangeState
value = 3010
triggerall = command = YOG_b
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA
trigger2 = movecontact = 1
trigger3 = stateno = 5120   ;iNオ蒆j
trigger4 = stateno = 1000
trigger4 = Time = [0, 33]
trigger4 = movecontact = 1
trigger5 = stateno = 1005
trigger5 = Time > 60
trigger5 = movecontact = 1

;V[guX^[
[State -1]
type = ChangeState
value = 3020
triggerall = command = QCBF_b
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA
trigger2 = movecontact = 1
trigger3 = stateno = 5120   ;iNオ蒆j
trigger4 = stateno = 1000
trigger4 = Time = [0, 33]
trigger4 = movecontact = 1
trigger5 = stateno = 1005
trigger5 = Time > 60
trigger5 = movecontact = 1

;===========================================================================
;---------------------------------------------------------------------------
;XJCUbp[
[State -1]
type = ChangeState
value = 1000
triggerall = command = QCF_x
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;XJCUbp[iLZj
[State -1]
type = ChangeState
value = 1000
triggerall = command = QCF_x
triggerall = movecontact = 1
trigger1 = stateno = 200
trigger2 = stateno = 201
trigger3 = stateno = 210
trigger4 = stateno = 211
trigger5 = stateno = 212
trigger6 = stateno = 400
trigger7 = stateno = 410

;---------------------------------------------------------------------------
;[TgXvbV
[State -1]
type = ChangeState
value = 1010
triggerall = command = YOG_a
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 150   ;iK[hj
trigger3 = stateno = 151   ;iK[hj

----------------------------------------------------------------------------
;[TgXvbViLZj
[State -1]
type = ChangeState
value = 1010
triggerall = command = YOG_a
triggerall = movecontact = 1
trigger1 = stateno = 200
trigger2 = stateno = 201
trigger3 = stateno = 210
trigger4 = stateno = 211
trigger5 = stateno = 212
trigger6 = stateno = 400
trigger7 = stateno = 410

;---------------------------------------------------------------------------
;XbVCi[
[State -1]
type = ChangeState
value = 1005
triggerall = command = QCF_a
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;XbVCi[iLZj
[State -1]
type = ChangeState
value = 1005
triggerall = command = QCF_a
triggerall = movecontact = 1
trigger1 = stateno = 200
trigger2 = stateno = 201
trigger3 = stateno = 210
trigger4 = stateno = 211
trigger5 = stateno = 212
trigger6 = stateno = 400
trigger7 = stateno = 410

;---------------------------------------------------------------------------
;V[vV[^[
[State -1]
type = ChangeState
value = 1020
triggerall = command = FBF_a
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;V[vV[^[iLZj
[State -1]
type = ChangeState
value = 1020
triggerall = command = FBF_a
triggerall = movecontact = 1
trigger1 = stateno = 200
trigger2 = stateno = 201
trigger3 = stateno = 210
trigger4 = stateno = 211
trigger5 = stateno = 212
trigger6 = stateno = 400
trigger7 = stateno = 410

;---------------------------------------------------------------------------
;GlM[a
[State -1]
type = ChangeState
value = 1070
triggerall = command = ANN_b
trigger1 = ctrl = 1
trigger1 = statetype != A
trigger2 = stateno = 1030
trigger2 = Time  > 10
trigger2 = Power > 0
trigger3 = stateno = 1050
trigger3 = Time  > 25
trigger3 = Power > 0

----------------------------------------------------------------------------
;GlM[aiLZj
[State -1]
type = ChangeState
value = 1070
triggerall = command = ANN_b
triggerall = movecontact = 1
trigger1 = stateno = 200
trigger2 = stateno = 201
trigger3 = stateno = 210
trigger4 = stateno = 211
trigger5 = stateno = 212
trigger6 = stateno = 400
trigger7 = stateno = 410
trigger8 = stateno = 1020
trigger9 = stateno = 3000
trigger10 = stateno = 1000
trigger10 = Time = [0, 33]
trigger11 = stateno = 1005
trigger11 = Time > 60

;---------------------------------------------------------------------------
;GlM[Vbg
[State -1]
type = ChangeState
value = 1060
triggerall = command = BF_b
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 1060
trigger2 = Time  >= 15
trigger2 = Power > 0

----------------------------------------------------------------------------
;GlM[VbgiLZj
[State -1]
type = ChangeState
value = 1060
triggerall = command = BF_b
triggerall = movecontact = 1
trigger1 = stateno = 200
trigger2 = stateno = 201
trigger3 = stateno = 210
trigger4 = stateno = 211
trigger5 = stateno = 212
trigger6 = stateno = 400
trigger7 = stateno = 410
trigger8 = stateno = 1020
trigger9 = stateno = 3000
trigger10 = stateno = 1000
trigger10 = Time = [0, 33]
trigger11 = stateno = 1005
trigger11 = Time > 60

;---------------------------------------------------------------------------
;gUGlM[e
[State -1]
type = ChangeState
value = 1050
triggerall = command = QCB_b
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 1030
trigger2 = Time  > 10
trigger2 = Power > 0
trigger3 = stateno = 1070
trigger3 = Time  > 14
trigger3 = Power > 0

;---------------------------------------------------------------------------
;GlM[e
[State -1]
type = ChangeState
value = 1030
trigger1 = command = b
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;C
[State -1]
type = ChangeState
value = 1040
trigger1 = command = holda
trigger1 = command = holdx
trigger1 = statetype = S
trigger1 = ctrl = 1

;===========================================================================
;---------------------------------------------------------------------------
;_bV
[State -1]
type = ChangeState
value = 100
trigger1 = command = FF
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;obN_bV
[State -1]
type = ChangeState
value = 105
trigger1 = command = BB
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;
[State -1]
type = ChangeState
value = 1080
triggerall = statetype = S
triggerall = ctrl = 1
triggerall = command = fwd_x  
trigger1 = p2bodydist X <= 10

;---------------------------------------------------------------------------
;tgXgCN
[State -1]
type = ChangeState
value = 1090
triggerall = command = FBDU_a
trigger1 = ctrl = 1
trigger2 = stateno = 40   ;iWvJnj  

;---------------------------------------------------------------------------
;Air_Throw1
;[State -1]
;type = ChangeState
;value = 950
;triggerall = statetype = A
;triggerall = ctrl = 1
;trigger1 = command = fwd_ab
;trigger2 = command = back_ab

;---------------------------
;Air_Throw1 (second set of commands)
;[State -1]
;type = ChangeState
;value = 950
;triggerall = statetype = A
;triggerall = ctrl = 1
;triggerall = p2bodydist X < 9
;triggerall = p2bodydist Y > -22
;triggerall = p2bodydist Y < 22
;triggerall = p2statetype = A
;triggerall = p2movetype != H
;trigger1 = command = fwd_b
;trigger2 = command = back_b


;===========================================================================
;---------------------------------------------------------------------------
;p`iΒnAj
[State -1]
type = ChangeState
value = 200
triggerall = command = x
triggerall = command != holddown
triggerall = p2bodydist X > 20
triggerall = p2bodydist Y >= 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 201
trigger2 = movecontact = 1
trigger3 = stateno = 211
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;p`iΒnAߋj
[State -1]
type = ChangeState
value = 201
triggerall = command = x
triggerall = command != holddown
triggerall = p2bodydist X <= 20
triggerall = p2bodydist Y >= 0
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;p`i΋j
[State -1]
type = ChangeState
value = 202
triggerall = command = x
triggerall = command != holddown
triggerall = p2bodydist Y < 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 410
trigger2 = movecontact = 1
trigger3 = stateno = 212
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;LbNiΒnAj
[State -1]
type = ChangeState
value = 210
triggerall = command = a
triggerall = command != holddown
triggerall = p2bodydist X > 20
triggerall = p2bodydist Y >= 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 201
trigger3 = movecontact = 1
trigger4 = stateno = 211
trigger4 = movecontact = 1
trigger5 = stateno = 400
trigger5 = movecontact = 1

;---------------------------------------------------------------------------
;LbNiΒnAߋj
[State -1]
type = ChangeState
value = 211
triggerall = command = a
triggerall = command != holddown
triggerall = p2bodydist X <= 20
triggerall = p2bodydist Y >= 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 201
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;LbNi΋j
[State -1]
type = ChangeState
value = 212
triggerall = command = a
triggerall = command != holddown
triggerall = p2bodydist Y < 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 410
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;p`
[State -1]
type = ChangeState
value = 400
triggerall = command = x
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;LbN
[State -1]
type = ChangeState
value = 410
triggerall = command = a
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 201 
trigger2 = movecontact = 1
trigger3 = stateno = 211
trigger3 = movecontact = 1
trigger4 = stateno = 400
trigger4 = movecontact = 1
trigger5 = stateno = 200 
trigger5 = movecontact = 1
trigger6 = stateno = 210
trigger6 = movecontact = 1

;---------------------------------------------------------------------------
;Wvp`
[State -1]
type = ChangeState
value = 600
triggerall = command = x
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 202 
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;WvLbN
[State -1]
type = ChangeState
value = 610
triggerall = command = a
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 202 
trigger2 = movecontact = 1
trigger3 = stateno = 600 
trigger3 = movecontact = 1
