'
'                     Eamon Adventure #10
'                    -> Magic Kingdom <-
'
'                     by David Cook
'
'                     Revised 12-03-90
'
    DECLARE SUB PGPRT (SP, LIT$)
REM $$INCL:'\EAMON\COPY\CHARDEF4.BAS'
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
	'   Module:  CHARDEF.BAS
	'   Eamon Version:  Eamon-QB (or Eamon-PC)
	' ------------------------------------------------------------
	'  Character Definition for Eamon QB/PC
	'        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
	'                        or BASIC 7.0 PDS
	'       uses Field statements for record description
	'       This module will work for QBasic, but QBasic cannot
	'       support $INCLUDE: statements, so module must be copied
	'       into programs manually or merged using a utility
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
TYPE WeaponRec
	Nam             AS STRING * 20
	Wpntyp          AS INTEGER
	Odds            AS INTEGER
	Dice            AS INTEGER
	Sides           AS INTEGER
END TYPE

TYPE CharacterRecord
	Nam             AS STRING * 30
	Hd              AS INTEGER
	Ag              AS INTEGER
	Ch              AS INTEGER
	SA1             AS INTEGER
	SA2             AS INTEGER
	SA3             AS INTEGER
	SA4             AS INTEGER
	WA1             AS INTEGER
	WA2             AS INTEGER
	WA3             AS INTEGER
	WA4             AS INTEGER
	WA5             AS INTEGER
	Sex             AS STRING * 1
	Gold            AS LONG
	Bank            AS LONG
	AE              AS INTEGER
	ArmNam          AS STRING * 20
	ArmHit          AS INTEGER
	Armadj          AS INTEGER
	ShdNam          AS STRING * 20
	ShdHit          AS INTEGER
	ShdAdj          AS INTEGER
	Wpn1Nam         AS STRING * 20
	Wpn1typ         AS INTEGER
	Wpn1Wpntyp      AS INTEGER
	Wpn1odds        AS INTEGER
	Wpn1Dice        AS INTEGER
	Wpn1Sides       AS INTEGER
	Wpn2Nam         AS STRING * 20
	Wpn2typ         AS INTEGER
	Wpn2Wpntyp      AS INTEGER
	Wpn2odds        AS INTEGER
	Wpn2Dice        AS INTEGER
	Wpn2Sides       AS INTEGER
	Wpn3Nam         AS STRING * 20
	Wpn3typ         AS INTEGER
	Wpn3Wpntyp      AS INTEGER
	Wpn3odds        AS INTEGER
	Wpn3Dice        AS INTEGER
	Wpn3Sides       AS INTEGER
	Wpn4Nam         AS STRING * 20
	Wpn4typ         AS INTEGER
	Wpn4Wpntyp      AS INTEGER
	Wpn4odds        AS INTEGER
	Wpn4Dice        AS INTEGER
	Wpn4Sides       AS INTEGER
	Filler          AS STRING * 23
END TYPE
DIM Char AS CharacterRecord
TYPE CharControl
	NbrChar         AS INTEGER
	Filler          AS STRING * 254
END TYPE
DIM CharCtl AS CharControl

    '------- (end of include file) -------    
 ' 
    DEFINT A-Z
    RANDOMIZE TIMER
REM $$INCL:'\EAMON\COPY\COLORRTN.BAS'
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     GOTO Colorset
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
Colorset:

    '------- (end of include file) -------    
 ' 
    DEF FNR (X) = (INT(X * RND(1)) + 1)
'    INPUT "Path:", Path$
    CLS
REM $$INCL:'\EAMON\COPY\READCTL.BAS'	
     CLOSE 1
     OPEN "DESC.R0" FOR INPUT AS #1
     INPUT #1, NR
     INPUT #1, NZ
     INPUT #1, NE
     INPUT #1, NM
     INPUT #1, ND
     INPUT #1, MAX.RM
     INPUT #1, MAX.ART
     INPUT #1, MAX.EFF
     INPUT #1, Max.Mon
     INPUT #1, Rm.Len
     INPUT #1, Rmn.Len
     INPUT #1, Mon.Len
     INPUT #1, Art.Len
     INPUT #1, Desc.Len
     INPUT #1, Mon.Flds
     INPUT #1, Art.Flds
     INPUT #1, RM.Flds
     INPUT #1, MN.Len
     INPUT #1, AN.Len
     CLOSE 1
     NA = NZ
     ART.ADJ = MAX.RM
     EFF.ADJ = MAX.RM + MAX.ART
     MON.ADJ = MAX.RM + MAX.ART + MAX.EFF
     EMB.ADJ = MAX.RM + MAX.ART
     INS.ADJ = MAX.RM
     HID.ADJ = MAX.RM * 2 + MAX.ART
     BURY.ADJ = MAX.RM * 3 + MAX.ART

    '------- (end of include file) -------    
 ' 
    DIM AN$(NA + 6), AD%(NA + 6, 9)
    DIM MON$(12)
    DIM MN$(NM), MD%(NM, 15)
    DIM FD%(3), TD%(3), SA%(4), WA%(5), S2%(4), RD%(6), RF.DIR$(10)
    GOSUB READ.ARTIFACTS
    NW = NW + 6
    DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
    READ NC
    DIM C$(NC)
    FOR C = 1 TO NC
    READ C$(C)
    NEXT
    DIM V%(NR)
    GOTO INITIALIZE.RTN
Main.Loop:
    PGPRT 1, " "
    IF SPD > 0 THEN SPD = SPD - 1: IF SPD = 0 THEN MD%(0, 2) = MD%(0, 2) / 2: MD%(0, 10) = MD%(0, 10) - 2 * MD%(0, 2): IF RND(1) > .8 THEN PGPRT 2, "Your Speed spell has just expired!"
    IF INT(V%(Room) / 2) <> V%(Room) / 2 THEN
	GET #3, Room
	A$ = RTRIM$(RN$)
	PGPRT 2, "You are " + A$
    ELSE
	GET #2, Room
	A$ = RTRIM$(DESC$)
	PGPRT 2, A$
	V%(Room) = V%(Room) + 1
    END IF
    FOR M = 1 TO NM
	IF MD%(M, 5) = Room THEN
	    IF MD%(M, 15) = 1 THEN
		PGPRT 2, MN$(M) + " is here."
	    ELSE
		GET #2, M + 300
		A$ = RTRIM$(DESC$)
		PGPRT 2, A$
		MD%(M, 15) = 1
	    END IF
	END IF
    NEXT
    FOR A = 1 TO NZ
       IF AD%(A, 4) = Room THEN
	   IF AD%(A, 9) <> 0 THEN
	       PGPRT 2, "You see " + AN$(A) + "."
	   ELSE
	       GET #2, A + 100
	       A$ = RTRIM$(DESC$)
	       PGPRT 2, A$
	       AD%(A, 9) = 1
	   END IF
       END IF
    NEXT
    FOR A = A TO NA
       IF AD%(A, 4) = Room THEN PGPRT 2, "Your " + AN$(A) + " is here."
    NEXT
205   IF Room = 25 THEN 600
Get.Command:
    PGPRT 0, " "
    PGPRT 1, " "
    COLOR hfg%, hbg%
    PRINT " Your Command ";
    COLOR fgc%, bgc%
    LINE INPUT " ", A$
    A$ = LTRIM$(RTRIM$(A$))
    IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 16: PRINT A$
    IF A$ = "" THEN GOTO LIST.COMMANDS
    A$ = UCASE$(A$)
    CZ$ = A$
    V$ = ""
    A = INSTR(A$, " ")
    IF A > 0 THEN V$ = LEFT$(A$, A - 1): S$ = MID$(A$, A + 1)
    IF A = 0 THEN V$ = A$: S$ = ""
    S$ = LTRIM$(S$)
    C = 0
    FOR X = 1 TO 6
    IF LEFT$(UCASE$(C$(X)), LEN(V$)) = V$ THEN C = X
    NEXT
    IF C > 0 THEN GOTO APPROP.RTN
    F = 0
    FOR X = 7 TO NC
    IF UCASE$(C$(X)) = V$ THEN C = X: F = 1: X = NC: GOTO NEXT.CMD
    IF LEFT$(UCASE$(C$(X)), LEN(V$)) = V$ THEN F = F + 1: C = X
NEXT.CMD:
    NEXT
    IF F = 1 THEN GOTO APPROP.RTN
LIST.COMMANDS:
    PRINT
    PRINT "Huh? I only understand these commands --- ";
    FOR C = 1 TO NC
    PRINT C$(C); SPC(20 - LEN(C$(C)));
    NEXT
    PRINT
    PRINT
    GOTO Get.Command
    IF C$(C) = S$ THEN S$ = V$: V$ = C$(C)
APPROP.RTN:
    ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 6 GOTO GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN, LOOK.RTN, ATTACK.RTN
    ON C - 12 GOTO FLEE.RTN, Give.Rtn, INVENTORY.RTN, BLAST.SPELL, HEAL.SPELL
    ON C - 17 GOTO POWER.SPELL, SPEED.SPELL, SMILE.RTN, SMILE.RTN, SAY.SOMETHING
    ON C - 22 GOTO Read.Rtn, READY.WEAPON, Eat.Rtn, Drink.Rtn, Free.Rtn
300
Get.Back:
REM $$INCL:'\EAMON\COPY\NEWBATL.BAS'
    IF TT > 0 THEN TT = TT - 1: GOTO End.Battle
    IF NBTL = 0 THEN GOTO End.Battle
    FOR M = 1 TO NM
        IF MD%(M, 5) = ROOM AND TT = 0 THEN
            MR = FD%(MD%(M, 14)) / TD%(MD%(M, 14)) - FD%(4 - MD%(M, 14)) / TD%(4 - MD%(M, 14)) / 5 + INT(41 * RND(1) - 20)
            IF MD%(M, 4) < MR THEN
                GOSUB Find.Exit
                IF R2 > 0 THEN
                    PGPRT 2, MN$(M) + " flees!"
                    GOSUB MONSTER.LEAVES
                    EXIT FOR
                END IF
            END IF
            IF MD%(M, 14) = 3 THEN
                GOSUB GoodGuys.Attack
            ELSE
                GOSUB BadGuys.Attack
            END IF
        END IF
        NBTL = (FD%(1) < TD%(1))
        IF NBTL = 0 THEN EXIT FOR
    NEXT M
End.Battle:
    IF TT > 0 THEN TT = TT - 1
    GOTO End.Loop
BadGuys.Attack:
    OF = M
    IF TD%(1) = MD%(0, 1) THEN DF = 0: GOSUB Take.a.Swing: RETURN
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 3 AND RND(1) < .25 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    IF DF < 0 THEN DF = 0: GOSUB Take.a.Swing
    RETURN
GoodGuys.Attack:
    OF = M
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 1 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    RETURN
End.Loop:

    '------- (end of include file) -------    
 ' 
    GOTO Main.Loop
    '  Walked into King's Chambers...
600   IF AD%(24, 4) = -1 THEN KS = 2    '  if carrying the Princess
605   ON KS GOTO 630, 650, 670
'    First time thru - drops into code below...
610   PRINT "You see a man dressed in robes. He says,'I am the king of the Magic Kingdom. I  know a magic word that will let you out of the kingdom. My duaghter, Princess"
620   PRINT "Julene, has been missing for 5 years.   If you find her and bring her to me, I  will say the word and release you from  the kingdom. If she is alive, I will    also give you a reward."
625  KS = 1: GOTO Get.Command
'    After the King has offered his help - you get this message...   (KS = 1)
630  PRINT "The king says 'You have heard my terms. Do you want to hear them again ?        (Y OR N) ";
     S$ = INPUT$(1): PRINT S$
     IF S$ = "Y" THEN 610
640   GOTO Get.Command
'    If the King's daughter is dead - you see this message...    (KS = 2)
650   PRINT : PRINT "The king weeps at the sight of his dead daughter.": PRINT
655   PRINT "He says a word that you can't understandand you are teleported to the main hall."
660  DIE = 0: GOTO 2000
'    If daughter is back - you see this...    (KS = 3)
670  PRINT "The king is overjoyed to see his daughter. He gives you 1000 gold pieces and says a magic word you cannot understand and you are teleported to the main hall"
680  GOLD = GOLD + 1000 
     DIE = 0
     GOTO 2000
REM $$INCL:'\EAMON\COPY\MONLEAVE.BAS'
MONSTER.LEAVES:
    MD%(M, 5) = R2
    M2 = MD%(M, 14)
    TD%(M2) = TD%(M2) - MD%(M, 1)
    FD%(M2) = FD%(M2) - MD%(M, 13)
    NBTL = (FD%(1) < TD%(1))
    RETURN

    '------- (end of include file) -------    
 ' 
INITIALIZE.RTN:
    GOSUB READ.MONSTERS
REM $$INCL:'\Eamon\COPY\READMEAT.BAS'
    OPEN "MEAT" FOR INPUT AS #2
    INPUT #2, Nbr.Party
    INPUT #2, REC
    INPUT #2, MN$(0)
    INPUT #2, MD%(0, 1)
    INPUT #2, MD%(0, 2)
    INPUT #2, MD%(0, 3)
    CH = MD%(0, 3)
    FOR X = 1 TO 4
    INPUT #2, SA%(X)
    S2%(X) = SA%(X)
    NEXT
    FOR X = 1 TO 5
    INPUT #2, WA%(X)
    NEXT
    INPUT #2, SEX$
    INPUT #2, GOLD&
    INPUT #2, BANK&
    INPUT #2, AE
    INPUT #2, ArmNam$
    INPUT #2, ArmHit
    INPUT #2, ArmAdj
    INPUT #2, ShdNam$
    INPUT #2, ShdHit
    INPUT #2, ShdAdj
    FOR X = 1 TO 4
      INPUT #2, A$
      IF RTRIM$(A$) = "" THEN A$ = "NONE"
      WN$(X) = A$
      INPUT #2, WT%(X)
      INPUT #2, WC%(X)
      INPUT #2, WD%(X)
      INPUT #2, WS%(X)
      IF A$ <> "NONE" THEN
          NA = NA + 1
          AN$(NA) = WN$(X)
          AD%(NA, 2) = 2
          AD%(NA, 3) = 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
      END IF
    NEXT
    IF ArmHit <> 0 THEN
          WN$(5) = ArmNam$ + " Armor"
          WT%(5) = 1
          WD%(5) = ArmHit
          WC%(5) = ArmAdj
          NA = NA + 1
          MD%(0, 8) = ArmHit
          Armptr = NA
          AN$(NA) = WN$(5)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    IF ShdHit <> 0 THEN
          WN$(6) = ShdNam$ + " Shield"
          WT%(6) = 2
          WD%(6) = ShdHit
          WC%(6) = ShdAdj
          NA = NA + 1
          MD%(0, 8) = MD%(0, 8) + ShdHit
          Shdptr = NA
          AN$(NA) = WN$(6)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    INPUT #2, MastPath$
    CLOSE 2
    EA = -(ArmAdj + ShdAdj)
    MD%(0, 8) = ArmHit + ShdHit
    IF NA > NZ THEN
        MD%(0, 10) = MD%(0, 2) * 2 + WC%(1) + WA%(WT%(1)) + (EA + AE) * ABS(-EA > AE)
        MD%(0, 7) = 0
        MD%(0, 9) = NZ + 1
        MD%(0, 11) = WD%(1)
        MD%(0, 12) = WS%(1)
        MD%(0, 14) = 3
    END IF

    '------- (end of include file) -------    
 ' 
    GOSUB OPEN.DESC
    GOSUB OPEN.ROOMS
    GOSUB OPEN.RMNAMES
    PRINT
    ND = 6
    Room = 1
    R2 = 1
    GOTO Move.It
GET.OVERRIDE:
    PRINT
    GOSUB Press.any.key
    IF A$ = CHR$(15) THEN OV = -1: PRINT : RETURN
    OV = 0
    RETURN
Press.any.key:
    PRINT "(Press any key to continue)";
    A$ = INPUT$(1)
    RETURN
    DATA 27
    DATA north,south,east,west,up,down,get,take,drop
    DATA look,examine,attack,flee,give,inventory,blast
    DATA heal,power,speed,smile,wave,say,read,ready,drink,eat,free
GAME.OVER:
2000
    PRINT
    PRINT "(Press any key to continue)   ";
    A$ = INPUT$(1)
    PRINT
CLOSE.DOWN:
    CLOSE
    IF SPD > 0 THEN MD%(0, 2) = MD%(0, 2) / 2
    IF DIE THEN GOTO GET.MASTER
    FOR W = 1 TO 4
    WN$(W) = "NONE"
    NEXT
    W2 = 1
    FOR A = 1 TO NA
    IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 AND AD%(A, 4) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, 4) = 0
    NEXT A
    IF W2 < 6 THEN GOTO SELL.TREASURE
SELL.WEAPONS:
    CLS
    LOCATE 5, 1
    PRINT "As you start to enter the Main Hall, Lord William Misslefire appears and"
    PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
    PRINT
    PRINT "Your weapons are--"
    FOR W = 1 TO W2 - 1
    PRINT SPC(4); W; "--"; WN$(W)
    NEXT
    PRINT
    PRINT "Enter the number of the weapon to sell     (1-"; W2 - 1; ") "
GET.NBR.SELL:
    LOCATE CSRLIN - 1, 52
    INPUT A$
    W5 = VAL(A$)
    IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO GET.NBR.SELL
    AD%(WP%(W5), 4) = -1
    WN$(W5) = WN$(W2 - 1)
    WP%(W5) = WP%(W2 - 1)
    W2 = W2 - 1
    IF W2 > 5 THEN GOTO SELL.WEAPONS
SELL.TREASURE:
    FOR W = 1 TO 4
    IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
    NEXT W
    CLS
    LOCATE 5, 1
    PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
    PRINT "things, he examines your goods and pays you ";
    TP = 0
    FOR A = 1 TO NA
    IF AD%(A, 4) <> -1 THEN GOTO NEXT.TREAS
    IF A = ArmPtr OR A = ShdPtr THEN GOTO NEXT.TREAS
    IF AD%(A, 2) <> 0 THEN
       IF CH > 20 THEN
	   AD%(A, 1) = AD%(A, 1) * 2
       ELSE
	   AD%(A, 1) = AD%(A, 1) * CH / 10
       END IF
    END IF
    TP = TP + AD%(A, 1)
NEXT.TREAS:
    NEXT A
    PRINT TP; " gold pieces."
    PRINT
    GOLD& = GOLD& + TP
    IF GOLD& < 0 THEN GOLD& = 0
    PRINT
    PRINT "(HIT ANY KEY TO CONTINUE)  ";
    A$ = INPUT$(1)
    PRINT
GET.MASTER:
    CLS
    LOCATE 5, 1
 '  PRINT "  Insert Eamon Master Diskette, and press <RETURN>  OR     "
 '  PRINT
 '  PRINT "  Enter Path of Master ===> ";
 '  INPUT "", MastPath$
    IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
    IF MastPath$ <> "" THEN CHDIR MastPath$
    ON ERROR GOTO Invalid.Path
    IF DIE THEN KILL "ADVENT": GOTO RUN.HALL
    CLOSE
    GOSUB OPEN.CHARACTERS
    Nam$ = MN$(0)
    HD = MD%(0, 1)
    AG = MD%(0, 2)
    GOSUB WRITE.CHARACTER
    OPEN Path$ + "ADVENT" FOR OUTPUT AS #2
    WRITE #2, MN$(0)
    WRITE #2, REC
    CLOSE
RUN.HALL:
    RUN "HALL"
Invalid.Path:
    PRINT
    PRINT "Invalid Path, or Master Not Found. Please re-try ..."
    PRINT " (press any key to continue)";
    A$ = INPUT$(1)
    RESUME GET.MASTER
MOVE.RTN:
    IF NBTL <> 0 AND S$ <> "FLEE" THEN PGPRT 2, "You don't want to turn your back here.": GOTO Main.Loop
    R2 = RD%(C)
    IF R2 > 100 THEN GOTO PASSAGE.BLOCKED
CHK.MOVE:
    IF R2 > 0 THEN GOTO Move.It
' ///SPECIAL MOVES
    IF R2 = -99 THEN PGPRT 2, "You successfully ride off into the sunset.": GOTO GAME.OVER
    IF R2 = 0 THEN GOTO CANT.GO
3070   IF R2 > -50 THEN PRINT "A STRANGE MIST SURROUNDS YOU AND YOU ARETELEPORTED TO THE PARK.": R2 = 1: GOTO Move.It
3080   PRINT "You see one of the most beautiful sightsin the world of Eamon, The waterfall of the kingdom! A beautiful 1000 foot drop into the plains below from a river that ";
3090   PRINT "flows out of the ice-capped mountains   and flows trough the plateau where most of the magic kingdom is located.too bad you were on the river": DIE = 1: GOTO 2000
    GOTO CANT.GO
PASSAGE.BLOCKED:
    PBL = R2 - 100
    IF AD%(PBL, 7) = 0 THEN R2 = AD%(PBL, 5): GOTO CHK.MOVE
    IF AD%(PBL, 6) = 0 THEN R2 = AD%(PBL, 5): GOTO CHK.MOVE
    PGPRT 2, "The " + AN$(PBL) + " blocks the way!"
    GOTO Main.Loop
CANT.GO:
    PGPRT 2, "You can't go that way!"
    V%(Room) = 0
    GOTO Main.Loop
Move.It:
    R3 = Room
    Room = R2
    GOSUB CHK.REACTIONS
    GET #1, Room
    NX = 0
    FOR X = 1 TO ND
    RD%(X) = CVI(RF.DIR$(X))
    IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
    NEXT
    NL = -1
    LT = NL OR LM
    GOTO Main.Loop
CHK.REACTIONS:
    TD%(1) = 0
    TD%(3) = MD%(0, 1)
    FD%(1) = 0
    FD%(3) = MD%(0, 13)
    FOR M = 1 TO NM
    IF MD%(M, 5) = R3 THEN IF MD%(M, 14) = 3 OR (MD%(M, 14) = 1 AND FNR(200) < MD%(M, 4)) THEN MD%(M, 5) = Room: GOTO ADD.SIDE
    IF MD%(M, 5) <> Room THEN GOTO NEXT.REACT
    IF MD%(M, 14) THEN GOTO ADD.SIDE
    FR = MD%(M, 3)
    IF FR AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
    MD%(M, 14) = 1
    IF FR > FNR(100) THEN MD%(M, 14) = 2: IF FR > FNR(100) THEN MD%(M, 14) = 3
ADD.SIDE:
    A = MD%(M, 14)
    FD%(A) = FD%(A) + MD%(M, 13)
    TD%(A) = TD%(A) + MD%(M, 1)
NEXT.REACT:
    NEXT M
    NBTL = (TD%(1) > 0)
    RETURN
GET.RTN:
    GOSUB Get.Subj
    IF S$ = "ALL" THEN GOTO GET.ALL
    IF S$ = "TORCH" THEN PGPRT 2, "All torches are bolted to the wall and cannot be removed.": GOTO Get.Back
    EMB = Room + 200
    WH = Room
    HA = Room
    GOSUB LOCATE.ART
    IF FO = 0 THEN PGPRT 2, "I see no " + LCASE$(S$) + " here!": GOTO Main.Loop
    GOSUB GET.SURPRISE
    IF NOT GT THEN GOTO Main.Loop
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, "It is too heavy for you.": GOTO Main.Loop
    PGPRT 2, "Got it."
    AD%(A, 4) = -1
    SZ = SZ + AD%(A, 0)
    WT = WT + AD%(A, 3)
    PGPRT 1, " "
    IF AD%(A, 2) >= 2 AND AD%(A, 2) <= 3 AND MD%(0, 9) = -1 THEN GOTO READY.WEAPON
    GOTO Get.Back
GET.ALL:
    PGPRT 1, " "
    FOR A = 1 TO NA
    IF AD%(A, 4) <> Room THEN GOTO GET.NEXT
    GOSUB GET.SURPRISE
    IF NOT GT THEN GOTO GET.NEXT
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 1, AN$(A) + " is too heavy.": GOTO GET.NEXT
    PGPRT 1, AN$(A) + " taken."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
GET.NEXT:
    NEXT
    PGPRT 1, " "
    GOTO Get.Back
GET.SURPRISE:
    GT = -1
' -1=successful get it ; 0=failure to get it
    RETURN
MONSTER.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
    FO = 0
    SL = LEN(S$)
    FOR X = 1 TO NM
    IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = Room OR MD%(X, 5) = HA) THEN FO = FO + 1: M = X: IF S$ = MN$(X) THEN X = 999
    NEXT
    RETURN
ARTIFACT.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
LOCATE.ART:
    FO = 0
    SL = LEN(S$)
    FOR X = 1 TO NA
    IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = EMB OR AD%(X, 4) = HA) THEN FO = FO + 1: A = X: IF S$ = AN$(X) THEN X = 999
    NEXT
    RETURN
Get.Subj:
    IF S$ = "" THEN PRINT : PRINT C$(C); " WHAT"; : INPUT S$: PGPRT 2, "": GOTO Get.Subj
    RETURN
DROP.RTN:
    GOSUB Get.Subj
    IF S$ = "ALL" THEN GOTO DROP.ALL
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ART
    IF FO = 0 THEN PGPRT 2, "You aren't carrying a " + LCASE$(S$): GOTO Main.Loop
5065   IF KS = 2 THEN 600
5067   IF A = 11 AND MD%(10, 5) = Room THEN
	    MD%(10, 5) = 0
	    PGPRT 2, "The dragon ate the poisonous doughnut!"
	    AD%(11, 4) = 0
	    DF = 10
	    GOSUB IS.DEAD
	    IF NTBL THEN NTBL = 0
	END IF
    WT = WT - AD%(A, 3)
    AD%(A, 4) = Room
    PGPRT 2, AN$(A) + " dropped."
    IF A = LS THEN LS = 0: LC = 0: LM = 0: LT = NL: PGPRT 2, "The " + AN$(A) + " goes out."
CHK.WT:
    IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAP:
    IF MD%(0, 9) > 0 THEN IF AD%(MD%(0, 9), 4) <> -1 THEN MD%(0, 9) = -1
    GOTO Get.Back
DROP.ALL:
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN PGPRT 2, AN$(A) + " dropped.": AD%(A, 4) = Room
    NEXT A
    WT = 0
    GOTO CHK.DROP.WEAP
LOOK.RTN:
    LK = 0
    IF S$ = "" THEN GOTO GENERAL.LOOK
    GOSUB ARTIFACT.SEARCH
    IF FO = 0 THEN GOTO CHK.LK.MON
    IF A = 11 THEN PGPRT 1, "You see a label below it. It says       ": COLOR hfg%, hbg%: PGPRT 1, "' Poisons dragons among other things '": COLOR fgc%, bgc%: GOSUB EXAM.ART
    LK = -1
    AD%(A, 9) = 1
    IF AD%(A, 4) = EMB THEN AD%(A, 4) = Room
    IF LK THEN GOTO Get.Back
CHK.LK.MON:
    GOSUB MONSTER.SEARCH
    IF FO <> 0 THEN GOSUB EXAM.MON: LK = -1
    IF LK THEN GOTO Get.Back
    IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
GENERAL.LOOK:
    FOR X = 1 TO ND
	IF RD%(X) < 0 AND ABS(RD%(X)) <= NR THEN PGPRT 2, "You found a secret passage " + LCASE$(C$(X)) + "!": RD%(X) = ABS(RD%(X)): V%(Room) = 2
    NEXT
    WH = Room + 300
    HA = WH
    EMB = WH
    GOSUB LOCATE.ART
    IF FO <> 0 THEN AD%(A, 4) = Room: PGPRT 2, "You found something.": GOTO Get.Back
    V%(Room) = V%(Room) + 1
    GOTO Get.Back
EXAM.ART:
    IF A = 3 OR A = 13 THEN PGPRT 2, "The bottle says, 'Healing Potion'": RETURN
    GET #2, A + 100
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    RETURN
EXAM.MON:
    GET #2, M + 300
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    LK = -1
    RETURN
NOTHIN.TA.SEE:
    V%(Room) = V%(Room) + 1
    GOTO Get.Back
' Secret Passage - PUT MESSAGE HERE IF NEEDED
    PGPRT 2, "You found a secret passage " + LCASE$(C$(X)) + "!"
    RD%(X) = ABS(RD%(X))
    V%(Room) = 2
    RETURN
ATTACK.RTN:
    GOSUB Get.Subj
    IF S$ = "KING" THEN PGPRT 2, "You suddenly realize that he is your only chance of getting out of here": GOTO 300
    IF LT = 0 THEN PGPRT 2, "You swing wild --- nothing hit.": GOTO Get.Back
    GOSUB MONSTER.SEARCH
    IF FO = 0 THEN GOTO CHK.ATT.ART
    GOTO ATTACK.MONSTER
CHK.ATT.ART:
    WH = Room
    HA = Room
    EMB = Room + 200
    GOSUB LOCATE.ART
    IF FO = 0 THEN PGPRT 2, "Attack who?": GOTO Main.Loop
    '  If we are not attacking a gate/door or a chest:
    IF AD%(A, 2) <> 8 AND AD%(A, 2) <> 4 THEN
	IF A > NZ - NM THEN PGPRT 2, "He's dead, already... let him rest in peace!": GOTO Main.Loop
	PGPRT 2, "Are you crazy?!"
	GOTO Main.Loop
    END IF
    S = 7
    K = 6
    IF AD%(A, 2) = 4 THEN S = S - 1: K = K - 1
    D2 = 0
    FOR X = 1 TO MD%(0, 11)
    D2 = D2 + FNR(MD%(0, 12))
    NEXT
    AD%(A, S) = AD%(A, S) - D2
    IF AD%(A, S) <= 0 THEN AD%(A, S) = 0: AD%(A, K) = 0: PGPRT 2, "The " + AN$(A) + " shatters!": GOTO Get.Back
    PGPRT 2, "WHAM!! You hit the " + AN$(A) + "!"
    GOTO Get.Back
ATTACK.MONSTER:
    IF MD%(0, 9) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO Main.Loop
    OF = 0
    DF = M
GOSUB TAKE.A.SWING
    IF NOT HIT THEN GOTO CHK.ATT.FRIEND
    IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
    IF -EA <= AE THEN GOTO Get.Back
    IF FNR(100) <= MD%(0, 10) THEN GOTO CHK.ATT.FRIEND
    A = 2
    IF EA + AE = -1 THEN A = 1
    AE = AE + A
    MD%(0, 10) = MD%(0, 10) + A
CHK.ATT.FRIEND:
    IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO Get.Back
    MD%(DF, 3) = MD%(DF, 3) / 2
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
    NEXT M
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO Get.Back
MON.GET.GUN:
    IF MD%(OF, 10) = 0 THEN RETURN
    FOR A = 1 TO NA
    IF AD%(A, 4) = Room AND (AD%(A, 2) = 2 OR AD%(A, 2) = 3) THEN PGPRT 2, MN$(OF) + " picks up " + AN$(A) + ".": AD%(A, 4) = 0: MD%(OF, 9) = A: MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5): MD%(OF, 4) = MD%(OF, 4) * 2: A = NA
    NEXT
    RETURN
TAKE.A.SWING:
    HIT = 0
    IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
    PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
    PRINT " --";
    RL = FNR(100)
    HIT = 0
    IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = -1
    IF HIT THEN GOTO A.HIT
    IF RL < 97 THEN PGPRT 1, "a miss.": RETURN
    PGPRT 1, "a Fumble!"
    FR = FNR(100)
    IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PGPRT 1, "  fumble recovered.": RETURN
    IF FR < 76 THEN PGPRT 1, "  weapon dropped!": AD%(MD%(OF, 9), 4) = Room: MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5): MD%(OF, 9) = -1: MD%(OF, 4) = MD%(OF, 4) / 2: RETURN
    IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PGPRT 2, "Sparks fly from " + AN$(W) + "!": RETURN
    IF FR > 95 THEN GOTO HURT.SELF
    PGPRT 1, "  weapon broken!"
    AD%(MD%(OF, 9), 4) = 0
    MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
    MD%(OF, 9) = -1
    MD%(OF, 4) = MD%(OF, 4) / 2
    IF RND(1) > .5 THEN PGPRT 1, " ": RETURN
    PGPRT 1, "  broken weapon hurts user!"
HURT.SELF:
    IF FR = 100 THEN GOTO SELF.YEOW
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    DF = OF
    A = 1
    GOTO DO.DAMAGE
SELF.YEOW:
    D = MD%(OF, 11) * 2
    S = MD%(OF, 12)
    DF = OF
    A = 0
    GOTO DO.DAMAGE
A.HIT:
    INC = (FNR(100) > MD%(OF, 10))
    MD%(OF, 10) = MD%(OF, 10) + 2 * ABS(INC)
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    A = 1
    IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO DO.DAMAGE
    PGPRT 1, "A Critical Hit!"
    R2 = FNR(100)
    IF R2 < 51 THEN A = 0: GOTO DO.DAMAGE
    IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
    IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
    IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
    GOTO IS.DEAD
DO.DAMAGE:
    D2 = 0
    FOR D3 = 1 TO D
    D2 = D2 + FNR(S)
    NEXT
    D2 = D2 - A * MD%(DF, 8)
    IF D2 < 1 THEN PGPRT 1, " blow bounces off armour!": RETURN
    MD%(DF, 13) = MD%(DF, 13) + D2
    IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO IS.DEAD
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + D2
SHOW.CONDITION:
    PRINT MN$(DF);
    ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:
    PGPRT 1, " is still in good shape."
    RETURN
HURTING:
    PGPRT 1, " is hurting."
    RETURN
IN.PAIN:
    PGPRT 1, " is in pain."
    RETURN
BADLY.INJURED:
    PGPRT 1, " is very badly injured!"
    RETURN
DEATHS.DOOR:
    PGPRT 1, " is at death's door, knocking loudly!"
    RETURN
IS.DEAD:
    PGPRT 1, MN$(DF) + " is dead!"
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
    MD%(DF, 5) = 0
    FOR AJ = 1 TO NA
    IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = Room
    NEXT
    IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = Room: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
    IF DF = 0 THEN DIE = 1: GOTO GAME.OVER
7800   IF DF = 4 THEN AD%(6, 4) = Room
7850   IF DF = 11 THEN KS = 0   ' if Pricess dies reset KS?
    A2 = DF + NZ - NM
    AD%(A2, 4) = Room
' PUT DEAD BODY IN ROOM
    PGPRT 1, " "
    RETURN
FLEE.RTN:
    IF NBTL = 0 THEN PGPRT 2, "There's no reason to run!": GOTO Main.Loop
    IF NX = 0 THEN PGPRT 2, "There's no place to go!": GOTO Main.Loop
8020   IF Room = 11 OR Room = 16 THEN PGPRT 2, "You can't flee!": GOTO Main.Loop
    IF S$ <> "" THEN
	C = 0
	FOR D = 1 TO ND
	    IF S$ = LEFT$(UCASE$(C$(D)), LEN(S$)) THEN C = D: Exit For
	NEXT
	IF C > 0 THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
    END IF
    GOSUB FIND.EXIT
    GOTO Move.It
FIND.EXIT:
    IF NX = 0 THEN R2 = Room: PGPRT 1, " ... but can't find an exit!": RETURN
    D = FNR(ND)
    R2 = RD%(D)
    IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
    RETURN
Give.Rtn:     '  ///GIVE COMMAND
       A2 = 1
Give.Who:
       Found = 0
       FOR M = 1 TO NM
	   IF LEFT$(S$, LEN(MN$(M))) = UCASE$(MN$(M)) AND MD%(M, 5) = Room THEN Found = M: EXIT FOR
       NEXT
       IF Found THEN GOTO Give.To
       IF A2 = 1 THEN A2 = 2: S$ = "": GOSUB Get.Subj: GOTO Give.Who
       IF Room <> 25 AND S$ <> "KING" THEN PGPRT 2, "Nobody here by that name!": GOTO Main.Loop
Give.To:
       IF S$ = "DRAGON" THEN DG = 1
       IF S$ = "KING" THEN KG = 1
       S$ = LTRIM$(MID$(S$, LEN(MN$(M)) + 1))
Give.What:
       IF VAL(S$) > 0 THEN GOTO Give.Gold
       Found = 0
       FOR A = 1 TO NA
	   IF LEFT$(S$, LEN(AN$(A))) = UCASE$(AN$(A)) AND AD%(A, 4) = -1 THEN Found = A: EXIT FOR
       NEXT
       IF A2 = 2 THEN A2 = 3: S$ = "": GOSUB Get.Subj: GOTO Give.What
       IF Found THEN GOTO Give.Item
       PGPRT 2, "You aren't carrying a " + S$ + "!"
       GOTO Main.Loop
Give.Item:     
       IF A = MD%(0, 9) THEN MD%(0, 9) = -1
       PGPRT 2, "OKAY."
       AD%(A, 4) = 0
       MD%(M, 14) = 0
       MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
       IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN
	   MD%(M, 9) = A
	   MD%(M, 10) = MD%(M, 9) + AD%(A, 5)
	   MD%(M, 4) = 2 * MD%(M, 4)
       END IF
Give.Check:
       IF S$ <> "DOUGHNUT" AND DG <> 1 THEN R3 = Room: GOSUB CHK.REACTIONS: GOTO CHK.WT
       PRINT "The dragon ate the poisonous doughnut!"
       PRINT
       DF = 10
       GOSUB IS.DEAD
       GOSUB CHK.REACTIONS
       GOTO CHK.WT
Give.Gold:
       IF VAL(S$) > GOLD THEN
	   PRINT
	   PRINT "You aren't carrying that much gold of your own!"
	   PRINT
	   GOTO Get.Back
       END IF
      GOLD = INT(GOLD - VAL(S$))
      IF KG <> 1 THEN MD%(M, 14) = 0: MD%(M, 3) = MD%(M, 3) * (1 + VAL(S$) / 100): GOTO Give.Check
      KB = KB + INT(VAL(S$))
      IF KB >= 1000 THEN KS = 2: KG = 0: GOTO CHK.WT
      GOTO Get.Back
INVENTORY.RTN:
    PGPRT 2, "You are carrying the following ---"
    A0 = 0
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN PGPRT 1, " " + AN$(A) + LEFT$(" (Ready weapon)", 1 + 20 * ABS(A = MD%(0, 9)))
    IF A = ArmPtr THEN PGPRT 1, AN$(A) + " (Worn Armour)"
    IF A = ShdPtr THEN PGPRT 1, AN$(A) + " (Your Shield"
    NEXT
    GOTO Get.Back
BLAST.SPELL:
    GOSUB Get.Subj
    GOSUB MONSTER.SEARCH
    IF FO = 0 THEN GOTO CANT.BLAST
    S = 1
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO Get.Back
    PGPRT 2, "Direct Hit!"
    S = 6
    D = 1
    DF = M
    A = 0
    GOSUB DO.DAMAGE
    GOTO Get.Back
CANT.BLAST:
    PGPRT 2, "You can't Blast " + S$ + "!"
    GOTO Main.Loop
CAST.SPELL:
    SUC = 0
    IF SA%(S) THEN RL = FNR(100): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN GOTO FORGET.IT
    IF SUC = 0 THEN PGPRT 2, "Nothing happened.": RETURN
    RL = FNR(100)
    IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
    S2%(S) = S2%(S) / 2
    RETURN
FORGET.IT:
    PGPRT 2, "The strain of attempting to cast this spell overloads your brain and you"
    PGPRT 1, " forget it completely."
    SA%(S) = 0
    RETURN
HEAL.SPELL:
    S = 2
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO Get.Back
    IF MD%(0, 13) THEN PGPRT 2, "Some of your wounds seem to clear up."
    MD%(0, 13) = MD%(0, 13) - FNR(10)
    IF MD%(0, 13) < 0 THEN MD%(0, 13) = 0
    DF = 0
    GOSUB SHOW.CONDITION
    GOTO Get.Back
POWER.SPELL:
    S = 4
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO Get.Back
    RAISE = 0
    FOR M = 1 TO NM
    M2 = NZ - NM + M
    IF AD%(M2, 4) = Room OR AD%(M2, 4) = -1 THEN RAISE = 1: GOSUB RAISE.DEAD
    NEXT M
    IF RAISE THEN R3 = Room: GOSUB CHK.REACTIONS: GOTO Get.Back
    FOR A = 1 TO NA
    IF AD%(A, 4) = Room THEN RAISE = -1: PGPRT 1, AN$(A) + " vanishes!": AD%(A, 4) = 0
    NEXT A
    IF RAISE THEN PGPRT 1, " ": GOTO Get.Back
    RR = FNR(100)
    IF RR < 11 THEN PGPRT 2, "The section of tunnel you are in collapses and you die.": DIE = 1: GOTO GAME.OVER
    IF RR < 86 THEN PGPRT 2, "You hear a very loud sonic boom that echoes through the tunnels.": GOTO Get.Back
    IF RR > 95 THEN PGPRT 2, "All of your wounds are healed.": MD%(0, 13) = 0: GOTO Get.Back
    GOTO DO.SPEED
RAISE.DEAD:
    PGPRT 1, MN$(M) + " comes to life!"
    AD%(M2, 4) = 0
    MD%(M, 5) = Room
    MD%(M, 13) = 0
    IF AD%(M2, 4) = -1 THEN WT = WT - AD%(M2, 3)
    RETURN
SPEED.SPELL:
    S = 3
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO Get.Back
DO.SPEED:
    IF SPD = 0 THEN MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2): MD%(0, 2) = 2 * MD%(0, 2)
    SPD = SPD + FNR(25) + 10
    PGPRT 2, "You can feel the new agility flowing through you!"
    GOTO Get.Back
SMILE.RTN:
    PGPRT 1, " "
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room THEN ON MD%(M, 14) GOSUB GROWL, IGNORE, SMILE
    NEXT
    GOTO Get.Back
GROWL:
    PGPRT 1, MN$(M) + " growls at you!"
    RETURN
IGNORE:
    PGPRT 1, MN$(M) + " ignores you."
    RETURN
SMILE:
    PGPRT 1, MN$(M) + " " + LCASE$(V$) + "s back."
    RETURN
SAY.SOMETHING:
    GOSUB Get.Subj
    IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
    IF S$ = "HEAL" THEN GOTO HEAL.SPELL
    IF S$ = "POWER" THEN GOTO POWER.SPELL
    IF S$ = "SPEED" THEN GOTO SPEED.SPELL
    PGPRT 2, "Okay, " + CHR$(34) + S$ + CHR$(34)
    GOTO Get.Back
READY.WEAPON:
    GOSUB Get.Subj
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ART
    IF FO = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO Main.Loop
    IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PGPRT 2, "That isn't a legal weapon!": GOTO Main.Loop
    MD%(0, 10) = (EA + AE) * (-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
    MD%(0, 9) = A
    MD%(0, 11) = AD%(A, 7)
    MD%(0, 12) = AD%(A, 8)
    PGPRT 2, "Readied."
    GOTO Get.Back
Eat.Rtn:   ' ///EAT COMMAND
18010   GOSUB Get.Subj
18020   IF S$ = "DOUGHNUT" THEN 18040
18030   PGPRT 2, "Are you crazy? How can you do that?": GOTO Main.Loop
18040   IF AD%(11, 4) <> Room AND AD%(11, 4) <> -1 THEN GOTO NoFood
18050   PRINT "THE DOUGHNUT TASTED DELICIOUS. TOO BAD  IT WAS POISONOUS.": DIE = 1: GOTO 2000
NoFood:
	PGPRT 2, "I see no " + S$ + " here !": GOTO Main.Loop
Drink.Rtn:
19000   REM   ///DRINK COMMAND
19010   GOSUB Get.Subj
19020   IF S$ <> "COFFEE" AND S$ <> "CUP" THEN GOTO 18020
19025   IF AD%(4, 4) <> Room AND AD%(4, 4) <> -1 THEN GOTO NoFood
19030   PGPRT 2, "The magic cup of coffee increases all your attributes by one!"
19035   PGPRT 1, "After you drink the coffee the cup vanishes!"
19040   CH = CH + 1: MD%(0, 1) = MD%(0, 1) + 1: MD%(0, 2) = MD%(0, 2) + 1: MD%(0, 3) = MD%(0, 3) + 1
19050   AD%(4, 4) = 0: WT = WT - AD%(4, 3): GOTO Get.Back
Free.Rtn:
20000   REM   ///FREE COMMAND
20010   GOSUB Get.Subj
20020   IF S$ <> "PRINCESS" AND S$ <> "PRINCESS JULENE" AND S$ <> "WOMAN" AND S$ <> "JULENE" AND S$ <> "THE PRINCESS" THEN 18030
20030  AD%(29, 4) = 0: MD%(11, 5) = Room: AD%(12, 4) = Room
20040  MD%(11, 14) = 3
20045  KS = 3
20047   GOSUB CHK.REACTIONS
20050   GOTO Main.Loop
Read.Rtn:
21000   REM   ///READ COMMAND
21010   GOSUB Get.Subj
21020   IF S$ <> "INSCRIPTION" OR Room <> 15 THEN GOTO 18030
21030   COLOR hfg%, hbg%: PRINT "A WORD TO THE WISE:": PRINT "YOU SHOULD ALWAYS EXAMINE YOUR FOOD BEFORE YOU EAT IT.":
	COLOR fgc%, bgc%: GOTO Get.Back
PRINT.EFFECT:
    GET #2, R + 200
    A$ = RTRIM$(DESC$)
    PGPRT 1, A$
    RETURN
REM $$INCL:'\Eamon\COPY\CHARIO.BAS'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  CHARIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Character File I/O Routines for Eamon QB/PC
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        or BASIC 7.0 PDS
        '       uses User defined types for record definition
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
OPEN.CHARACTERS:
      OPEN "CHARACT.DAT" FOR RANDOM AS #1 LEN = LEN(Char)
      RETURN
READ.NBR.CHARS:
      GET #1, 1, CharCtl
      NC = CharCtl.NbrChar
      IF NC > LOF(1) \ LEN(Char) THEN NC = LOF(1) \ LEN(Char) - 1
      RETURN
READ.CHARACTER:
      GET #1, REC, Char
      Nam$ = RTRIM$(Char.Nam$)
      HD = Char.Hd
      AG = Char.Ag
      CH = Char.Ch
      SA%(1) = Char.SA1
      SA%(2) = Char.SA2
      SA%(3) = Char.SA3
      SA%(4) = Char.SA4
      WA%(1) = Char.WA1
      WA%(2) = Char.WA2
      WA%(3) = Char.WA3
      WA%(4) = Char.WA4
      WA%(5) = Char.WA5
      SEX$ = Char.SEX
      GOLD& = Char.GOLD
      BANK& = Char.BANK
      AE = Char.AE
      ArmNam$ = RTRIM$(Char.ArmNam)
      ArmHit = Char.ArmHit
      ArmAdj = Char.ArmAdj
      ShdNam$ = RTRIM$(Char.ShdNam)
      ShdHit = Char.ShdHit
      ShdAdj = Char.ShdAdj
      WN$(1) = RTRIM$(Char.Wpn1Nam)
      WR%(1) = Char.Wpn1Typ
      WT%(1) = Char.Wpn1WpnTyp
      WC%(1) = Char.Wpn1Odds
      WD%(1) = Char.Wpn1Dice
      WS%(1) = Char.Wpn1Sides
      WN$(2) = RTRIM$(Char.Wpn2Nam)
      WR%(2) = Char.Wpn2Typ
      WT%(2) = Char.Wpn2WpnTyp
      WC%(2) = Char.Wpn2Odds
      WD%(2) = Char.Wpn2Dice
      WS%(2) = Char.Wpn2Sides
      WN$(3) = RTRIM$(Char.Wpn3Nam)
      WR%(3) = Char.Wpn3Typ
      WT%(3) = Char.Wpn3WpnTyp
      WC%(3) = Char.Wpn3Odds
      WD%(3) = Char.Wpn3Dice
      WS%(3) = Char.Wpn3Sides
      WN$(4) = RTRIM$(Char.Wpn4Nam)
      WR%(4) = Char.Wpn4Typ
      WT%(4) = Char.Wpn4WpnTyp
      WC%(4) = Char.Wpn4Odds
      WD%(4) = Char.Wpn4Dice
      WS%(4) = Char.Wpn4Sides
      RETURN
WRITE.CHARACTER:
      Char.Nam = Nam$
      Char.Hd = HD
      Char.Ag = AG
      Char.Ch = CH
      Char.SA1 = SA%(1)
      Char.SA2 = SA%(2)
      Char.SA3 = SA%(3)
      Char.SA4 = SA%(4)
      Char.WA1 = WA%(1)
      Char.WA2 = WA%(2)
      Char.WA3 = WA%(3)
      Char.WA4 = WA%(4)
      Char.WA5 = WA%(5)
      Char.SEX = SEX$
      Char.GOLD = GOLD&
      Char.BANK = BANK&
      Char.AE = AE
      Char.ArmNam = ArmNam$
      Char.ArmHit = ArmHit
      Char.ArmAdj = ArmAdj
      Char.ShdNam = ShdNam$
      Char.ShdHit = ShdHit
      Char.ShdAdj = ShdAdj
      Char.Wpn1Nam = WN$(1)
      Char.Wpn1Typ = WR%(1)
      Char.Wpn1WpnTyp = WT%(1)
      Char.Wpn1Odds = WC%(1)
      Char.Wpn1Dice = WD%(1)
      Char.Wpn1Sides = WS%(1)
      Char.Wpn2Nam = WN$(2)
      Char.Wpn2Typ = WR%(2)
      Char.Wpn2WpnTyp = WT%(2)
      Char.Wpn2Odds = WC%(2)
      Char.Wpn2Dice = WD%(2)
      Char.Wpn2Sides = WS%(2)
      Char.Wpn3Nam = WN$(3)
      Char.Wpn3Typ = WR%(3)
      Char.Wpn3WpnTyp = WT%(3)
      Char.Wpn3Odds = WC%(3)
      Char.Wpn3Dice = WD%(3)
      Char.Wpn3Sides = WS%(3)
      Char.Wpn4Nam = WN$(4)
      Char.Wpn4Typ = WR%(4)
      Char.Wpn4WpnTyp = WT%(4)
      Char.Wpn4Odds = WC%(4)
      Char.Wpn4Dice = WD%(4)
      Char.Wpn4Sides = WS%(4)
      PUT #1, REC, Char
      RETURN
WRITE.NBR.CHARS:
      CharCtl.NbrChar = NC
      PUT #1, 1, CharCtl
      RETURN

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\Eamon\copy\Advenio.old'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  ADVENIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Adventure I/O Routines for Eamon Base Adventure Program
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        BASIC 7.0 PDS
        '       uses Field statements for record description
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
READ.ARTIFACTS:    ' ----- READ ARTIFACTS ---------------------
       IF Art.Len = 0 THEN Art.Len = 128
       IF Art.Flds = 0 THEN Art.Flds = 8
       IF AN.Len = 0 THEN AN.Len = 20
       OPEN "ARTIF.TXT" FOR RANDOM AS #3 LEN = Art.Len
       FIELD 3, AN.Len AS AF.NAME$
       DIM AF.DATA$(Art.Flds)
       FOR A2 = 1 TO Art.Flds
       FIELD 3, AN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS AF.DATA$(A2)
       NEXT
       FOR A = 1 TO NA
           GET #3, A
           AN$(A) = RTRIM$(AF.NAME$)
           FOR A2 = 1 TO Art.Flds
               AD%(A, A2) = CVI(AF.DATA$(A2))
           NEXT A2
           IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 THEN NW = NW + 1
       NEXT
       CLOSE 3
       RETURN
READ.MONSTERS:  ' ------------- READ MONSTERS    ---------------------
       IF MON.LEN = 0 THEN MON.LEN = 128
       IF Mon.Flds = 0 THEN Mon.Flds = 12
       IF MN.Len = 0 THEN MN.Len = 20
       OPEN "MONST.TXT" FOR RANDOM AS #3 LEN = MON.LEN
       FIELD 3, MN.Len AS MF.NAME$
       DIM MF.DATA$(Mon.Flds)
       FOR A2 = 1 TO Mon.Flds
           FIELD 3, MN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS MF.DATA$(A2)
       NEXT
       FOR A = 1 TO NM
           GET #3, A
           MN$(A) = RTRIM$(MF.NAME$)
           FOR A2 = 1 TO Mon.Flds
               MD%(A, A2) = CVI(MF.DATA$(A2))
           NEXT A2
           IF MD%(A, 3) < 0 THEN               ' Force nuetral if < 0
              MD%(A, 3) = ABS(MD%(A, 3)) - 1
              MD%(A, 14) = 2
           END IF
       NEXT
       CLOSE 3
       RETURN
OPEN.DESC:       ' ----------------- OPEN DESC FILE -------------------
       IF Desc.Len = 0 THEN Desc.Len = 256
       OPEN "DESC.TXT" FOR RANDOM AS #2 LEN = Desc.Len
       FIELD 2, Desc.Len - 1 AS Desc$
       RETURN
OPEN.RMNAMES:    ' ---------------- OPEN ROOM NAMES -------------------
       IF RMN.Len = 0 THEN RMN.Len = 64
       OPEN "RMNAMES.TXT" FOR RANDOM AS #3 LEN = RMN.Len
       FIELD 3, RMN.Len AS RN$
       RETURN
OPEN.ROOMS:      ' ---------------- OPEN ROOMS FILE -------------------
       IF RM.LEN = 0 THEN RM.LEN = 64
       OPEN "ROOMS.TXT" FOR RANDOM AS #1 LEN = RM.LEN
       FOR D = 1 TO 10
           FIELD 1, (D - 1) * 2 AS X$, 2 AS RF.DIR$(D)
       NEXT
       FIELD 1, 20 AS X$, 1 AS RF.LT$
       RETURN
Read.Room:
       GET #1, Room
       IF ND = 0 THEN ND = 6
       NX = 0
       FOR X = 1 TO ND
           RD%(X) = CVI(RF.DIR$(X))
           IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
       NEXT
       NL = VAL(RF.LT$)
       GET #3, Room
       RETURN
    '------- (end of include file) -------

    '------- (end of include file) -------    
 ' 

DEFSNG A-Z
SUB PGPRT (SP, LIT$)
    STATIC LINE.PG
    IF SP = 0 THEN LINE.PG = 0: EXIT SUB
    IF LIT$ = "" THEN LINE.PG = LINE.PG + SP: EXIT SUB
    IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	LINE.PG = LINE.PG + 1
	NEXT
    END IF
    IF LINE.PG > 20 THEN
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-")
	A$ = INPUT$(1)
	LOCATE CSRLIN - 1, 1
	PRINT SPC(79);
	LINE.PG = 0
    END IF
    PRINT LIT$
    LINE.PG = LINE.PG + LEN(LIT$) / 79 + 1
END SUB

