'               Eamon QB Adventure #19
'                   Death Trap
'
'
'                 by John Nelson
'
'                DDD VERSION 6.2
'
    DEFINT A-Z
    DECLARE SUB PGPRT (SP, LIT$)
REM $$INCL:'\eamon\copy\chardef.bas'
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
	'   Module:  CHARDEF.BAS
	'   Eamon Version:  Eamon-QB (or Eamon-PC)
	' ------------------------------------------------------------
	'  Character Definition for Eamon QB/PC
	'        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
	'                        or BASIC 7.0 PDS
	'       uses Field statements for record description
	'       This module will work for QBasic, but QBasic cannot
	'       support $INCLUDE: statements, so module must be copied
	'       into programs manually or merged using a utility
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
TYPE WeaponRec
	Nam             AS STRING * 20
	Wpntyp          AS INTEGER
	Odds            AS INTEGER
	Dice            AS INTEGER
	Sides           AS INTEGER
END TYPE

TYPE CharacterRecord
	Nam             AS STRING * 30
	Hd              AS INTEGER
	Ag              AS INTEGER
	Ch              AS INTEGER
	SA1             AS INTEGER
	SA2             AS INTEGER
	SA3             AS INTEGER
	SA4             AS INTEGER
	WA1             AS INTEGER
	WA2             AS INTEGER
	WA3             AS INTEGER
	WA4             AS INTEGER
	WA5             AS INTEGER
	Sex             AS STRING * 1
	Gold            AS LONG
	Bank            AS LONG
	AE              AS INTEGER
	ArmNam          AS STRING * 20
	ArmHit          AS INTEGER
	Armadj          AS INTEGER
	ShdNam          AS STRING * 20
	ShdHit          AS INTEGER
	ShdAdj          AS INTEGER
	Wpn1Nam         AS STRING * 20
	Wpn1typ         AS INTEGER
	Wpn1Wpntyp      AS INTEGER
	Wpn1odds        AS INTEGER
	Wpn1Dice        AS INTEGER
	Wpn1Sides       AS INTEGER
	Wpn2Nam         AS STRING * 20
	Wpn2typ         AS INTEGER
	Wpn2Wpntyp      AS INTEGER
	Wpn2odds        AS INTEGER
	Wpn2Dice        AS INTEGER
	Wpn2Sides       AS INTEGER
	Wpn3Nam         AS STRING * 20
	Wpn3typ         AS INTEGER
	Wpn3Wpntyp      AS INTEGER
	Wpn3odds        AS INTEGER
	Wpn3Dice        AS INTEGER
	Wpn3Sides       AS INTEGER
	Wpn4Nam         AS STRING * 20
	Wpn4typ         AS INTEGER
	Wpn4Wpntyp      AS INTEGER
	Wpn4odds        AS INTEGER
	Wpn4Dice        AS INTEGER
	Wpn4Sides       AS INTEGER
	Filler          AS STRING * 23
END TYPE
DIM Char AS CharacterRecord
TYPE CharControl
	NbrChar         AS INTEGER
	Filler          AS STRING * 254
END TYPE
DIM CharCtl AS CharControl

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\eamon\copy\colorrtn.bas'
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     GOTO Colorset
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
Colorset:

    '------- (end of include file) -------    
 ' 
    CLS
    DEF FNR (X) = INT(RND(1) * X) + 1
REM $$INCL:'\EAMON\COPY\READCTL.BAS'
     CLOSE 1
     OPEN "DESC.R0" FOR INPUT AS #1
     INPUT #1, NR
     INPUT #1, NZ
     INPUT #1, NE
     INPUT #1, NM
     INPUT #1, ND
     INPUT #1, MAX.RM
     INPUT #1, MAX.ART
     INPUT #1, MAX.EFF
     INPUT #1, Max.Mon
     INPUT #1, Rm.Len
     INPUT #1, Rmn.Len
     INPUT #1, Mon.Len
     INPUT #1, Art.Len
     INPUT #1, Desc.Len
     INPUT #1, Mon.Flds
     INPUT #1, Art.Flds
     INPUT #1, RM.Flds
     INPUT #1, MN.Len
     INPUT #1, AN.Len
     CLOSE 1
     NA = NZ
     ART.ADJ = MAX.RM
     EFF.ADJ = MAX.RM + MAX.ART
     MON.ADJ = MAX.RM + MAX.ART + MAX.EFF
     EMB.ADJ = MAX.RM + MAX.ART
     INS.ADJ = MAX.RM
     HID.ADJ = MAX.RM * 2 + MAX.ART
     BURY.ADJ = MAX.RM * 3 + MAX.ART

    '------- (end of include file) -------    
 ' 
    DIM V%(NR), RD%(10), FD%(3), TD%(3), SA%(4), S2%(4), WA%(5), RF.DIR$(10)
    DIM FWN$(4), FWT$(4), FWC$(4), FWD$(4), FWS$(4), FWA$(5), FSA$(5)
    DIM AN$(NA + 6), AD%(NA + 6, 9)
    DIM MN$(NM + 10), MD%(NM + 10, 16)
    GOSUB READ.ART.REC ' LOAD ARTIFACT TABLE
    GOSUB READ.MON.REC ' LOAD MONSTER TABLE
    NW = NW + 6
    DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
    MM% = INT(RND(1) * 120) + 50
    A = 0: FOR W = 1 TO 4: A = A + WS%(W) * WD%(W): NEXT: IF A > 50 THEN GOTO MAKE.HARDER
    IF MD%(0, 1) + MD%(0, 2) + CH < 57 THEN MD%(17, 5) = INT(RND(1) * 20 + 14): MD%(17, 3) = 100
    GOTO CONT.INIT
MAKE.HARDER:
    REM  /// BRING IN MORE MONSTERS (THE ADVENTURER IS LOADED FOR BEAR)
    B = 0
    FOR M = 1 TO NM
      IF MD%(M, 5) = 0 AND A / 4 > (MD%(M, 1) + B) / 2 THEN MD%(M, 5) = INT(RND(1) * 40 + 10): B = B + MD%(M, 1)
    NEXT
CONT.INIT:
    READ NC
    DIM C$(NC)
    FOR C = 1 TO NC
    READ C$(C)
    NEXT
    R2 = 1
    CONST GOLD.ART = 0
    CONST TREASURE.ART = 1
    CONST WEAPON.ART = 2
    CONST MAG.WEAPON = 3
    CONST CONTAIN.ART = 4
    CONST LIGHT.ART = 5
    CONST HEAL.ART = 6
    CONST READ.ART = 7
    CONST DOOR.ART = 8
    CONST KEY.ART = 9
    CONST BOUND.MON.ART = 10
    CONST ARMOR.ART = 11
    CONST FOOD.ART = 12
    CONST DRINK.ART = 13   ' DRINKABLE ARTIFACT --- PUT IN YOUR OWN EFFECTS
    GOTO INITIALIZE
DONT.UNDERSTAND:
    PGPRT 2, "I don't understand."
' ---------------------------------------------------------------------------
MAIN.LOOP:
'    = MAIN =
    IF SPD THEN SPD = SPD - 1: IF SPD = 0 THEN MD%(0, 2) = MD%(0, 2) / 2: MD%(0, 10) = MD%(0, 10) - 2 * MD%(0, 2): PGPRT 2, "YOUR SPEED SPELL HAS JUST EXPIRED!"
    IF IV THEN PGPRT 2, "You're invisible.": VC = VC + 1: IF VC > 5 THEN VC = 0: D2 = 3: DF = 0: GOSUB APPLY.DAMAGE
SHOW.ROOM:      ' SHOW.ROOM
    IF V%(ROOM) <> 0 THEN GET #3, ROOM: A$ = RTRIM$(RN$): PGPRT 2, "You are " + A$
    IF V%(ROOM) = 0 THEN GOSUB SPECIAL.ROOM.CHK
    IF CL% THEN
	CL% = 0
	PGPRT 2, "The reflection in the mirror steps out of the mirror. It is an exact duplicate   of you."
	PGPRT 1, MID$("hisher", ABS(SEX$ = "F") * 3 + 1, 3) + " name is " + MN$(NM) + "."
    END IF
    IF MB <> 0 AND ROOM = 42 THEN PGPRT 2, "The mirror is smashed to pieces."
    FOR M = 1 TO NM
    IF MD%(M, 5) <> ROOM THEN GOTO NEXT.MON
    IF MD%(M, 15) = 1 THEN PGPRT 2, MN$(M) + " is here."
    IF MD%(M, 15) = 2 THEN PGPRT 2, MN$(M) + " is lying here."
    IF MD%(M, 15) = 0 THEN
	GET #2, M + MON.ADJ
	A$ = RTRIM$(DESC$)
	PGPRT 2, A$
	MD%(M, 15) = 1
    END IF
NEXT.MON:      ' NEXT.MON
    NEXT
    IF MD%(37, 5) = ROOM AND RM = 0 THEN PGPRT 2, "You have turned to stone! You are dead.": DIE = -1: GOTO GAME.OVER
    FOR A = 1 TO NZ
    IF AD%(A, 4) <> ROOM THEN GOTO NEXT.ART
    IF AD%(A, 9) THEN
	PGPRT 2, "You see " + AN$(A) + "."
    ELSE
	GET #2, A + ART.ADJ
	A$ = RTRIM$(DESC$)
	PGPRT 2, A$
	AD%(A, 9) = 1
    END IF
NEXT.ART:      ' NEXT.ART
    NEXT
    FOR A = A TO NA
    IF AD%(A, 4) = ROOM THEN
	PGPRT 2, "Your " + AN$(A) + " is here."
    END IF
    NEXT
    PRINT
    IF MR% > MM% THEN
	MR% = 0
	PGPRT 2, "The magic ring on your finger vanished! The forcefield is gone!!"
	AD%(3, 4) = 0
	MD%(0, 8) = AC
    END IF
GET.COMMAND:      ' GET.COMMAND
    PGPRT 0, ""
    PRINT
    COLOR hfg%, hbg%
    PRINT "  Your Command ";
    COLOR fgc%, bgc%
    LINE INPUT " ", A$
    A$ = LTRIM$(RTRIM$(UCASE$(A$)))
    IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 17: PRINT A$
    IF A$ = "" THEN GOTO LIST.COMMANDS
    CZ$ = A$
    A = INSTR(A$, " ")
    IF A = 0 THEN A = LEN(A$) + 1
    V$ = LEFT$(A$, A - 1)
    S$ = MID$(A$, A + 1)
    S$ = LTRIM$(S$)
    IF V$ = "WEAR" THEN GOTO WEAR.RTN
    IF V$ = "REMOVE" THEN GOTO REMOVE.RTN
    C = 0
    FOR A = 1 TO ND
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN C = A: A = ND
    NEXT
    IF C <> 0 THEN GOTO BRANCH.RTN
    F = 0
    FOR A = ND + 1 TO NC
    IF UCASE$(C$(A)) = V$ THEN C = A: A = NC
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN
	F = F + 1
	C = A
	IF F > 1 THEN C = 0: A = NC
    END IF
    NEXT
    IF C = 0 THEN GOTO LIST.COMMANDS
    GOTO BRANCH.RTN
LIST.COMMANDS:      ' LIST.COMMANDS
    PRINT
    PRINT "Huh? I only understand these commands ... "
    FOR C = 1 TO NC
    PRINT C$(C); SPC(20 - LEN(C$(C)));
    NEXT
    PRINT
    PRINT
    GOTO GET.COMMAND
    IF UCASE$(C$(C)) = S$ THEN S$ = V$: V$ = C$(C)
BRANCH.RTN:      ' BRANCH.RTN
    ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 7 GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN
    ON C - 14 GOTO LOOK.RTN, ATTACK.RTN, FLEE.RTN, GIVE.RTN, INVENTORY.RTN
    ON C - 19 GOTO BLAST.SPELL, HEAL.SPELL, POWER.SPELL, SPEED.SPELL, SMILE.RTN
    ON C - 24 GOTO SMILE.RTN, SAY.SOMETHING, READ.RTN, READY.WEAPON, OPEN.RTN
    ON C - 29 GOTO PUT.RTN, FREE.RTN, EAT.RTN, DRINK.RTN, WEAR.RTN
    ON C - 34 GOTO THROW.RTN, DIG.RTN, SAVE.GAME, RESTORE.GAME, QUIT.RTN
GET.BACK:      ' GET.BACK
REM $$INCL:'\EAMON\COPY\NEWBATL.BAS'
    IF TT > 0 THEN TT = TT - 1: GOTO End.Battle
    IF NBTL = 0 THEN GOTO End.Battle
    FOR M = 1 TO NM
        IF MD%(M, 5) = ROOM AND TT = 0 THEN
            MR = FD%(MD%(M, 14)) / TD%(MD%(M, 14)) - FD%(4 - MD%(M, 14)) / TD%(4 - MD%(M, 14)) / 5 + INT(41 * RND(1) - 20)
            IF MD%(M, 4) < MR THEN
                GOSUB Find.Exit
                IF R2 > 0 THEN
                    PGPRT 2, MN$(M) + " flees!"
                    GOSUB MONSTER.LEAVES
                    EXIT FOR
                END IF
            END IF
            IF MD%(M, 14) = 3 THEN
                GOSUB GoodGuys.Attack
            ELSE
                GOSUB BadGuys.Attack
            END IF
        END IF
        NBTL = (FD%(1) < TD%(1))
        IF NBTL = 0 THEN EXIT FOR
    NEXT M
End.Battle:
    IF TT > 0 THEN TT = TT - 1
    GOTO End.Loop
BadGuys.Attack:
    OF = M
    IF TD%(1) = MD%(0, 1) THEN DF = 0: GOSUB Take.a.Swing: RETURN
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 3 AND RND(1) < .25 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    IF DF < 0 THEN DF = 0: GOSUB Take.a.Swing
    RETURN
GoodGuys.Attack:
    OF = M
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 1 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    RETURN
End.Loop:

    '------- (end of include file) -------    
 ' 
    IF MD%(16, 5) = ROOM AND ROOM < 51 AND ROOM > 10 AND RND(1) > .88 THEN GOTO LJ.TELEPORTS
    GOTO MAIN.LOOP
LJ.TELEPORTS:
    IF ljaw THEN ljaw = 0: GOTO MAIN.LOOP
    PGPRT 2, "You hear a crackle of energy and see a flash of light!!"
    PGPRT 1, "Lockjaw has transported you somewhere!!"
    R2 = FNR(40) + 10
    ljaw = -1
    GOTO MOVE.IT
REM $$INCL:'\EAMON\COPY\MONLEAVE.BAS'
MONSTER.LEAVES:
    MD%(M, 5) = R2
    M2 = MD%(M, 14)
    TD%(M2) = TD%(M2) - MD%(M, 1)
    FD%(M2) = FD%(M2) - MD%(M, 13)
    NBTL = (FD%(1) < TD%(1))
    RETURN

    '------- (end of include file) -------    
 ' 
' ---------------------------------------------------------------------------
INITIALIZE:
REM $$INCL:'\Eamon\COPY\READMEAT.BAS'
    OPEN "MEAT" FOR INPUT AS #2
    INPUT #2, Nbr.Party
    INPUT #2, REC
    INPUT #2, MN$(0)
    INPUT #2, MD%(0, 1)
    INPUT #2, MD%(0, 2)
    INPUT #2, MD%(0, 3)
    CH = MD%(0, 3)
    FOR X = 1 TO 4
    INPUT #2, SA%(X)
    S2%(X) = SA%(X)
    NEXT
    FOR X = 1 TO 5
    INPUT #2, WA%(X)
    NEXT
    INPUT #2, SEX$
    INPUT #2, GOLD&
    INPUT #2, BANK&
    INPUT #2, AE
    INPUT #2, ArmNam$
    INPUT #2, ArmHit
    INPUT #2, ArmAdj
    INPUT #2, ShdNam$
    INPUT #2, ShdHit
    INPUT #2, ShdAdj
    FOR X = 1 TO 4
      INPUT #2, A$
      IF RTRIM$(A$) = "" THEN A$ = "NONE"
      WN$(X) = A$
      INPUT #2, WT%(X)
      INPUT #2, WC%(X)
      INPUT #2, WD%(X)
      INPUT #2, WS%(X)
      IF A$ <> "NONE" THEN
          NA = NA + 1
          AN$(NA) = WN$(X)
          AD%(NA, 2) = 2
          AD%(NA, 3) = 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
      END IF
    NEXT
    IF ArmHit <> 0 THEN
          WN$(5) = ArmNam$ + " Armor"
          WT%(5) = 1
          WD%(5) = ArmHit
          WC%(5) = ArmAdj
          NA = NA + 1
          MD%(0, 8) = ArmHit
          Armptr = NA
          AN$(NA) = WN$(5)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    IF ShdHit <> 0 THEN
          WN$(6) = ShdNam$ + " Shield"
          WT%(6) = 2
          WD%(6) = ShdHit
          WC%(6) = ShdAdj
          NA = NA + 1
          MD%(0, 8) = MD%(0, 8) + ShdHit
          Shdptr = NA
          AN$(NA) = WN$(6)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    INPUT #2, MastPath$
    CLOSE 2
    EA = -(ArmAdj + ShdAdj)
    MD%(0, 8) = ArmHit + ShdHit
    IF NA > NZ THEN
        MD%(0, 10) = MD%(0, 2) * 2 + WC%(1) + WA%(WT%(1)) + (EA + AE) * ABS(-EA > AE)
        MD%(0, 7) = 0
        MD%(0, 9) = NZ + 1
        MD%(0, 11) = WD%(1)
        MD%(0, 12) = WS%(1)
        MD%(0, 14) = 3
    END IF

    '------- (end of include file) -------    
 ' 
    ND = 10                 ' Number of directions - change to 10 for ten dir
    GOSUB OPEN.DESC
    GOSUB OPEN.ROOM.NAMES
    GOSUB OPEN.ROOMS
    ROOM = 1
    MD%(31, 14) = 2
    GOTO MOVE.IT
    DATA 39
    DATA North,South,East,West,Up,Down,NE,NW,SE,SW
    DATA Get,Take,Drop,Look,Examine
    DATA Attack,Flee,Give,Inventory
    DATA Blast,Heal,Power,Speed,Smile
    DATA Wave,Say,Read,Ready,Open
    DATA Put,Free,Eat,Drink,Wear
    DATA Throw,Dig,Save,Restore,Quit
' ---------------------------------------------------------------------------
GAME.OVER:      ' GAME.OVER
    PRINT
    PRINT "(Press any key to continue) ";
    A$ = INPUT$(1)
    PRINT
    CLOSE
    IF SPD THEN MD%(0, 2) = MD%(0, 2) / 2
    IF DIE <> 0 AND SAVED <> 0 THEN
	PRINT "Do you want to restart (Y/N)  ";
	YN$ = INPUT$(1)
	IF UCASE$(YN$) = "Y" THEN RUN
    END IF
    IF DIE <> 0 THEN GOTO GET.MASTER
    GOSUB CHK.SUCCESS
    FOR W = 1 TO 4
    WN$(W) = "NONE"
    NEXT
    W2 = 1
    FOR A = 1 TO NA
    IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 AND AD%(A, 4) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, 4) = 0
    NEXT A
    IF W2 < 6 THEN GOTO SELL.TREASURE
PLAYER.RETURNS:
    CLS
    LOCATE 5, 1
    PRINT "As you start to enter the main hall, Lord William Misslefire appears and"
    PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
    PRINT
    PRINT "Your weapons are--"
    FOR W = 1 TO W2 - 1
    PRINT SPC(4); W; "--"; WN$(W)
    NEXT
    PRINT
    PRINT "Enter the number of the weapon to sell  (1-"; W2 - 1; ") "
SELL.WEAPON:
    LOCATE CSRLIN - 1, 53
    INPUT A$
    W5 = VAL(A$)
    IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO SELL.WEAPON
    AD%(WP%(W5), 4) = -1
    WN$(W5) = WN$(W2 - 1)
    WP%(W5) = WP%(W2 - 1)
    W2 = W2 - 1
    IF W2 > 5 THEN GOTO PLAYER.RETURNS
SELL.TREASURE:
    IF MD%(0, 8) > AC THEN MD%(0, 8) = AC
    FOR W = 1 TO 4
    IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
    NEXT W
    CLS
    LOCATE 5, 1
    PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
    PRINT "things, he examines your goods and pays you ";
    TP = 0
    FOR A = 1 TO NA
    IF A = ArmPtr OR A = ShdPtr THEN GOTO NEXT.TREASURE 
    IF AD%(A, 4) <> -1 THEN GOTO NEXT.TREASURE
    IF AD%(A, 2) <> 0 THEN AD%(A, 1) = AD%(A, 1) * CH / 10
    TP = TP + AD%(A, 1)
NEXT.TREASURE:
    NEXT A
    PRINT TP; " gold pieces."
    PRINT
    GOLD& = GOLD& + TP
    IF GOLD& < 0 THEN GOLD& = 0
    PRINT
    PRINT "(Press any key to continue)  ";
    A$ = INPUT$(1)
    PRINT
GET.MASTER:
    CLS
    LOCATE 5, 1
  ' PRINT "  Insert Eamon Master Diskette, and press <RETURN>  OR     "
  ' PRINT
  ' PRINT "  Enter Path of Master ===> ";
  ' INPUT "", MastPath$
    IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
    IF MastPath$ <> "" THEN CHDIR MastPath$
    ON ERROR GOTO Invalid.Path
    IF DIE THEN
	OPEN PATH$ + "ADVENT" FOR OUTPUT AS #1
	CLOSE
	KILL PATH$ + "ADVENT"
	RUN PATH$ + "WORLD"
    END IF
    CLOSE
    GOSUB OPEN.CHARACTERS
    Nam$ = MN$(0)
    HD = MD%(0, 1)
    AG = MD%(0, 2)
    GOSUB WRITE.CHARACTER
    CLOSE
    OPEN PATH$ + "ADVENT" FOR OUTPUT AS #1
    PRINT #1, MN$(0)
    PRINT #1, REC
    CLOSE
    RUN PATH$ + "HALL"
Invalid.Path:
    PRINT
    PRINT "Invalid Path, or Master Not Found. Please re-try ..."
    PRINT " (press any key to continue)";
    A$ = INPUT$(1)
    RESUME GET.MASTER
QUIT.RTN:
    PRINT "Do you want to Quit this game? (Y/N) ";
    A$ = INPUT$(1)
    IF UCASE$(A$) = "N" THEN GOTO GET.COMMAND
    CLOSE
    END
CHK.SUCCESS:
    A = 0: FOR X = 1 TO NR: A = A + V%(X): NEXT: IF A < NR * .8 THEN PRINT : PRINT "You did not explore the cave thoroughly. You do not win the 10000 gp bet.": RETURN
    CLS : PRINT "Some of you friends helped you collect your bet, since Black Bart was somewhat": PRINT "reluctant to pay.": GOLD& = GOLD& + 10000
    GOTO MISSION.OVER
MISSION.OVER:
    PRINT
    PRINT " (PRESS ANY KEY)      ";
    A$ = INPUT$(1)
    PRINT
    RETURN
' --------------------------------------------------------------------------
MOVE.RTN:
    IF MR% AND MM% > 1000 THEN NBTL = 0
    IF IV = 0 THEN
	IF NBTL AND S$ <> "FLEE" THEN
	    IF TT = 0 THEN
		PGPRT 2, "You can't do that with unfriendlies about!"
		GOTO MAIN.LOOP
	    END IF
	END IF
    END IF
    D = C
    R2 = RD%(D)
    IF R2 > 100 AND R2 < 200 THEN GOTO PASSAGE.BLOCKED
CHK.SPECIAL.MOVES:      ' CHK.SPECIAL.MOVES
'     /// SPECIAL MOVES
    IF R2 = -99 THEN PGPRT 2, "You successfully ride off into the sunset.": GOTO GAME.OVER
    IF (R2 = 9 AND ROOM = 51) OR (R2 = 51 AND ROOM = 9) THEN IF DC < 3 THEN GOTO MAIN.LOOP
    IF ROOM = 10 AND BE AND D = 1 THEN R2 = 9: GOTO MOVE.IT
    IF ROOM = 66 AND D = 2 AND L6 THEN R2 = 9: GOTO MOVE.IT
    IF ROOM = 3 AND D = 5 AND UP <> 0 THEN R2 = 4
    IF R2 = 4 AND UP = 0 AND ROOM = 3 THEN PGPRT 2, "The rope has not been fastened.": GOTO MAIN.LOOP
    IF R2 = 42 THEN GOSUB CLONE.RTN
    IF R2 = 38 AND ROOM = 13 AND L0 = 0 THEN GOTO MAIN.LOOP
    IF R2 = -52 AND L1 THEN R2 = -R2
    IF R2 = -61 AND L3 THEN R2 = -R2
    IF R2 = -62 AND L2 THEN R2 = -R2
    IF R2 > 0 AND R2 <= NR THEN GOTO MOVE.IT
'    /// INSERT HERE SPECIAL ROOM MOVE CHECKING
    GOTO CANT.GO
CLONE.RTN:
     IF MB THEN RETURN
     NM = NM + 1: CL% = 1: MD%(NM, 15) = 1: SW% = 0: CL = CL + 1
     Y = 0: FOR X = 1 TO NA: IF AD%(X, 2) > 1 AND AD%(X, 5) = -1 AND (AD%(X, 7) * AD%(X, 8)) > Y THEN Y = AD%(X, 7) * AD%(X, 8): SW% = X
     NEXT X
     MW% = MD%(0, 9): IF MD%(0, 9) = -1 THEN MW% = 0: MD%(NM, 10) = 80: MD%(NM, 11) = 1: MD%(NM, 12) = 8
     MN$(NM) = "": FOR X = LEN(MN$(0)) TO 1 STEP -1: MN$(NM) = MN$(NM) + MID$(MN$(0), X, 1): NEXT: MD%(NM, 1) = MD%(0, 1): MD%(NM, 2) = MD%(0, 2): MD%(NM, 8) = AC
     IF MD%(0, 9) > 0 THEN MD%(NM, 10) = 2 * MD%(NM, 2) + WA%(AD%(MD%(0, 9), 6)) + AD%(MD%(0, 9), 5)
     IF MD%(0, 9) > 0 THEN MD%(NM, 11) = AD%(MD%(0, 9), 7): MD%(NM, 12) = AD%(MD%(0, 9), 8)
     IF MD%(0, 9) < 0 THEN MD%(NM, 11) = 1: MD%(NM, 12) = 6
     MD%(NM, 6) = -1: IF MR% THEN MD%(NM, 8) = 100
     MD%(NM, 5) = 42
     MD%(NM, 4) = INT(RND(1) * 80)
     RETURN
PASSAGE.BLOCKED:
    GT = R2 - 100
    IF AD%(GT, 4) <> ROOM THEN R2 = AD%(GT, 5): GOTO CHK.SPECIAL.MOVES
    PGPRT 2, "The " + AN$(GT) + " blocks the way!"
    GOTO MAIN.LOOP
CANT.GO:
    PGPRT 2, "You can't go that way!"
    V%(ROOM) = 0
    GOTO MAIN.LOOP
MOVE.IT:
    R3 = ROOM
    ROOM = R2
    GOSUB CHK.REACTIONS
    GET #1, ROOM
    NX = 0
    FOR X = 1 TO ND
    RD%(X) = CVI(RF.DIR$(X))
    IF RD%(X) < 0 AND RD%(X) > -NR AND V%(ROOM) > 1 THEN RD%(X) = ABS(RD%(X))
COUNT.EXITS:      ' COUNT.EXITS
    IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
    NEXT
    LT = -1
    GOTO END.LOOP
CHK.REACTIONS:
    TD%(1) = 0
    TD%(3) = MD%(0, 1)
    FD%(1) = 0
    FD%(3) = MD%(0, 13)
    FOR MX = 1 TO NM
    IF MD%(MX, 15) = 2 AND MD%(MX, 5) = ROOM THEN GOTO MONSTER.NOT.HERE
    IF MD%(MX, 5) = R3 THEN IF MD%(MX, 14) = 3 OR (MD%(MX, 14) = 1 AND 200 * RND(1) < MD%(MX, 4)) THEN MD%(MX, 5) = ROOM: GOTO ADD.SIDES
MONSTER.REACTS:      ' MONSTER.REACTS
    IF MD%(MX, 5) <> ROOM THEN GOTO MONSTER.NOT.HERE
    IF MD%(MX, 14) > 0 THEN GOTO ADD.SIDES
    FR = MD%(MX, 3)
    IF FR > 0 AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
    MD%(MX, 14) = 1
    IF FR > (100 * RND(1)) THEN MD%(MX, 14) = 2: IF FR > (100 * RND(1)) THEN MD%(MX, 14) = 3
ADD.SIDES:      ' ADD.SIDES
    A = MD%(MX, 14)
    FD%(A) = FD%(A) + MD%(MX, 13)
    TD%(A) = TD%(A) + MD%(MX, 1)
MONSTER.NOT.HERE:
    NEXT
    GOTO SET.NBTL
SET.NBTL:
    NBTL = (TD%(1) > 0)
    RETURN
BRING.IN.BEASTS:
    MD%(M, 5) = ROOM
    MD%(M, 13) = 0
    R3 = ROOM
    GOSUB CHK.REACTIONS
    RETURN
' --------------------------------------------------------------------------
GET.RTN:
    GOSUB GET.SUBJ
    IF V$ = "TAKE" THEN
	IF S$ = "OFF RING" OR S$ = "RING OFF" OR S$ = "OFF MAGIC RING" OR S$ = "MAGIC RING OFF" THEN
	    S$ = "MAGIC RING"
	    GOTO REMOVE.RTN
	END IF
    END IF
    IF LT = 0 THEN PGPRT 2, "You can't find anything.": GOTO MAIN.LOOP
    IF S$ = "ALL" THEN GOTO GET.ALL
    EMB = ROOM + 200
    WH = ROOM
    HA = -1
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "I see no " + LCASE$(S$) + " here!": GOTO MAIN.LOOP
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO MAIN.LOOP
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, "You can't budge it!": GOTO MAIN.LOOP
    PGPRT 2, "Got it."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
    IF (AD%(A, 2) = 2 OR AD%(A, 2) = 3) AND MD%(0, 9) = -1 THEN GOTO CALCULATE.ODDS
    GOTO GET.BACK
GET.ALL:      ' GET.ALL
    FOR A = 1 TO NA
    IF AD%(A, 4) <> ROOM OR AD%(A, 2) = 10 THEN GOTO GET.NEXT
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO GET.NEXT
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, AN$(A) + " can't be moved.": GOTO GET.NEXT
    PGPRT 1, AN$(A) + " taken."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
GET.NEXT:      ' GET.NEXT
    NEXT
    GOTO GET.BACK
GET.SURPRISE:      ' GET.SURPRISE
'    /// INSERT HERE SPECIAL EFFECTS OF PICKING SOMETHING UP
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 1 AND ArmPtr = 0 THEN 
    	ArmPtr = A
    	GOSUB Ready.Armor
    END IF	
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 2 AND ShdPtr = 0 THEN 
    	ShdPtr = A
    	GOSUB Ready.Armor
    END IF	
    IF A = 19 AND V$ = "TAKE" THEN
	IF AD%(19, 4) = -1 THEN
	    PGPRT 2, "You have taken the " + S$
	    AD%(19, 4) = 0
	    IF MD%(0, 13) > 0 THEN
		PGPRT 2, "All your wounds have suddenly healed."
		MD%(0, 13) = 0
		GT = 0
		RETURN
	    ELSE
		PGPRT 2, "Nothing Happens."
	    END IF
	END IF
    END IF
    IF A = 14 AND MD%(31, 5) = ROOM THEN PGPRT 2, MN$(31) + " won't let you pick up " + AN$(14) + ".": GT = 0: MD%(31, 14) = 1: GOSUB CHK.REACTIONS: RETURN
    IF A = 33 AND MD%(38, 5) = 0 AND MD%(38, 13) = 0 THEN
	PGPRT 2, "One of the gold coins jumps up and bites you!!"
	MD%(38, 5) = ROOM
	GOSUB CHK.REACTIONS
	D = 1
	S = 4
	DF = 0
	OF = 38
	GOSUB DO.DAMAGE
	GT = 0
	RETURN
    END IF
    GT = 1
    IF IV THEN GOSUB RATTLE.MONSTER
    RETURN
RATTLE.MONSTER:      ' RATTLE.MONSTER
    FOR M = 1 TO NM
    IF MD%(M, 5) = ROOM THEN
	PGPRT 1, MN$(M) + " is slightly unnerved!"
	MD%(M, 4) = MD%(M, 4) - 10
    END IF
    NEXT
    RETURN
SPECIAL.ROOM.CHK:      ' SPECIAL.ROOM.CHK
'    /// SPECIAL ROOM?
    GET #2, ROOM
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    V%(ROOM) = V%(ROOM) + 1
    RETURN
' ---------------------------------------------------------------------------
MONSTER.SEARCH:
    WH = ROOM
    HA = -1
    EMB = ROOM
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NM
    IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = WH OR MD%(X, 5) = HA) THEN FOUND = FOUND + 1: M = X: IF S$ = UCASE$(MN$(X)) THEN X = 9999
    NEXT
    IF FOUND > 1 THEN PGPRT 2, "Not sure which one."
    RETURN
' ---------------------------------------------------------------------------
ARTIFACT.SEARCH:
    WH = ROOM
    HA = -1
    EMB = ROOM
LOCATE.ARTIFACT:
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NA
      IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = HA OR AD%(X, 4) = EMB) THEN FOUND = FOUND + 1: A = X: IF S$ = UCASE$(AN$(X)) THEN X = 9999
    NEXT
    IF FOUND > 1 THEN PGPRT 2, "Not sure which one."
    RETURN
' --------------------------------------------------------------------------
GET.SUBJ:
    WHILE S$ = ""
      PRINT
      PRINT C$(C); " What";
      INPUT S$
      PGPRT 2, ""
    WEND
    S$ = UCASE$(S$)
    RETURN
' --------------------------------------------------------------------------
DROP.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO DROP.ALL
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying a " + LCASE$(S$) + "!": GOTO MAIN.LOOP
    WT = WT - AD%(A, 3)
    AD%(A, 4) = ROOM
    PGPRT 2, AN$(A) + " dropped."
    GOSUB DROP.SPECIAL
CHK.WGHT:      ' CHK.WGHT
    IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAPON:
    IF MD%(0, 9) > 0 THEN IF AD%(MD%(0, 9), 4) <> -1 THEN MD%(0, 9) = -1
    GOTO GET.BACK
DROP.ALL:       ' DROP.ALL
    SR = ROOM
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN
	PGPRT 2, AN$(A) + " dropped."
	AD%(A, 4) = ROOM
	GOSUB DROP.SPECIAL
    END IF
    NEXT
    WT = 0
    GOTO CHK.DROP.WEAPON
DROP.SPECIAL:
    IF A = ARMPTR OR A = SHDPTR THEN GOSUB DROP.ARMOR
    IF IV THEN GOSUB RATTLE.MONSTER
    RETURN
Drop.Armor:
    IF A = ArmPtr THEN ArmPtr = 0
    IF A = ShdPtr THEN ShdPtr = 0
    MD%(0, 8) = MD%(0, 8) - AD%(A, 7)
    EA = EA + AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
Ready.Armor:
    MD%(0, 8) = MD%(0, 8) + AD%(A, 7)
    EA = EA - AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
' ---------------------------------------------------------------------------
LOOK.RTN:
    IF LT = 0 THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    LK = 0
    IF S$ = "" THEN GOTO GENERAL.LOOK
    GOSUB EXAMINE.NONART
    IF LK THEN GOTO GET.BACK
    WH = ROOM
    HA = -1
    EMB = ROOM + 200
    GOSUB LOCATE.ARTIFACT
    IF FOUND AND AD%(A, 4) = EMB THEN AD%(A, 4) = ROOM
    IF FOUND THEN GOSUB EXAMINE.ARTIFACT: GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOSUB EXAMINE.MONSTER
GENERAL.LOOK:      ' GENERAL.LOOK
    IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
    IF ROOM = 13 THEN L0 = 1: PGPRT 2, "You see a dark hole to the south!!": GOTO GET.BACK
    IF ROOM = 31 THEN PRINT : PGPRT 2, "The east wall seems to be made of paper.": GOTO GET.BACK
    IF ROOM = 26 THEN L1 = 1: PGPRT 2, "You found a secret passage to the east!": GOTO GET.BACK
    IF ROOM = 66 THEN L6 = 1: PGPRT 2, "You see a strange mist to the south.": GOTO GET.BACK
    FOR A = 1 TO NA
    IF AD%(A, 4) = 300 + ROOM THEN LK = -1: GOSUB FIND.ARTIFACT
    NEXT
    IF LK THEN PGPRT 2, "You found something.": GOTO GET.BACK
    FOR X = 1 TO ND
    IF RD%(X) < 0 AND RD%(X) >= -NR THEN GOSUB SECRET.PASSAGE
    NEXT
NOTHIN.TA.SEE:      ' NOTHIN.TA.SEE
    V%(ROOM) = 0
    GOTO GET.BACK
EXAMINE.MONSTER:      ' EXAMINE.MONSTER
    R = M + 100
    GOSUB PRINT.EFFECT
    RETURN
EXAMINE.NONART:      ' EXAMINE.NONART (S$)
    RETURN
SECRET.PASSAGE:
    RD%(X) = ABS(RD%(X))
    V%(ROOM) = 2
    IF LK = 0 THEN PGPRT 2, "You found a secret passage " + C$(X) + "!": NX = NX + 1
    RETURN
EXAMINE.ARTIFACT:
    IF A = 24 THEN
	PGPRT 2, "The cover of the book says:   Book of Evil    ":
	PGPRT 2, "The book seems to be sealed shut."
	GOTO MAIN.LOOP
    END IF
    IF A = 19 THEN PGPRT 2, "The pill has a small 'RX' symbol on it.": LK = 1: RETURN
    IF A = 33 AND MD%(38, 5) = 0 AND MD%(38, 13) = 0 THEN PGPRT 2, "One of the coins is really a bug with a golden shell. He's also poisonous!": MD%(38, 5) = ROOM: GOSUB CHK.REACTIONS
    IF A > NZ THEN PGPRT 2, "This is your " + AN$(A) + "."
    IF A > NZ - NM THEN PGPRT 2, "Yes, he's dead!": RETURN
    GET #2, A + ART.ADJ
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    LK = -1
    AD%(A, 9) = 1
    RETURN
FIND.ARTIFACT:      ' FIND.ARTIFACT
'      == DISCOVER ARTIFACT A HIDDEN IN ROOM!
'    --- INSERT HERE ANY SPECIAL DISCOVERY MESSAGES ---
'        SUCH AS "YOU FOUND SOMETHING UNDER THE BED"
    LK = -1
    AD%(A, 4) = ROOM
    RETURN
' ---------------------------------------------------------------------------
ATTACK.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You swing wild --- nothing hit.": GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOTO ATTACK.MON
    IF S$ = "MIRROR" AND ROOM = 42 AND MB = 0 THEN
	MB = 1
	PGPRT 2, "The mirror breaks."
	AD%(25, 4) = ROOM
	NM = NM - CL
	IF CL > 0 THEN
	    PGPRT 2, "The clone" + MID$("s", 1, ABS(CL > 1)) + " crumble" + MID$("s", 1, ABS(CL = 1)) + "."
	    R3 = ROOM
	    GOSUB CHK.REACTIONS
	    CL = 0
	    GOTO GET.BACK
	END IF
    END IF
    IF S$ = "MIRROR" THEN GOTO GET.BACK
    IF S$ = "ENTRANCE" AND MD%(0, 9) = 20 AND ROOM = 10 THEN PGPRT 2, "You blasted the entrance open!!": BE = 1: GOTO GET.BACK
    TA = 0
    GOTO ASSAULT.ARTIFACT
ATTACK.MON:
    IF MD%(0, 9) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO MAIN.LOOP
    OF = 0
    DF = M
    GOSUB TAKE.A.SWING
    IF HIT = 0 THEN GOTO MISSED
    IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
    IF -EA <= AE THEN GOTO GET.BACK
    IF INT(100 * RND(1) + 1) <= MD%(0, 10) THEN GOTO MISSED
    A = 2
    IF EA + AE = -1 THEN A = 1
    AE = AE + A
    MD%(0, 10) = MD%(0, 10) + A
MISSED:
    IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO GET.BACK
    MD%(DF, 3) = MD%(DF, 3) / 2
    FOR M = 1 TO NM
    IF MD%(M, 5) = ROOM AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
    NEXT
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
MON.GET.GUN:      ' MON.GET.GUN
'    -- MONSTER PICK-UP WEAPON
    IF MD%(OF, 10) = 0 THEN RETURN
    A = 0
    FOR X = 1 TO NA
    IF X = 14 AND OF <> 31 AND MD%(31, 5) = ROOM THEN GOTO PU.NEXT
    IF AD%(X, 4) = ROOM AND (AD%(X, 2) = 2 OR AD%(X, 2) = 3) THEN A = X: X = NA
PU.NEXT:
    NEXT
    IF A = 0 THEN RETURN
    PGPRT 2, MN$(OF) + " picks up " + AN$(A) + "."
    AD%(A, 4) = 0
    MD%(OF, 9) = A
    MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5)
    MD%(OF, 4) = MD%(OF, 4) * 2
    RETURN
TAKE.A.SWING:
    HIT = 0
    IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
    IF DF = 0 AND IV THEN RETURN
    PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
    PRINT " --";
    IF DF = 17 AND MD%(OF, 9) > 0 THEN GOTO ATTACK.HULK
    RL = INT(100 * RND(1) + 1)
    HIT = 0
    IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = 1
    IF HIT THEN GOTO A.HIT
    IF RL < 97 THEN PGPRT 1, " A miss!": RETURN
    PGPRT 1, "A fumble!"
    FR = INT(100 * RND(1) + 1)
    IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PGPRT 1, "   fumble recovered.": RETURN
    IF FR < 76 THEN
	PGPRT 1, "  weapon dropped!"
	AD%(MD%(OF, 9), 4) = ROOM
	MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
	MD%(OF, 9) = -1
	MD%(OF, 4) = MD%(OF, 4) / 2
	RETURN
    END IF
    IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PGPRT 1, "Sparks fly from " + AN$(W) + "!": RETURN
    IF FR > 95 THEN GOTO SELF.OUCH
    PGPRT 1, "  weapon breaks!"
    AD%(MD%(OF, 9), 4) = 0
    MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
    MD%(OF, 9) = -1
    MD%(OF, 4) = MD%(OF, 4) / 2
    IF RND(1) > .5 THEN RETURN
    PGPRT 1, "  broken weapon hurts user!"
SELF.OUCH:
    IF FR = 100 THEN GOTO SELF.YEOW
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    DF = OF
    A = 1
    GOTO DO.DAMAGE
SELF.YEOW:
    D = MD%(OF, 11) * 2
    S = MD%(OF, 12)
    DF = OF
    A = 0
    GOTO DO.DAMAGE
ATTACK.HULK:
    PGPRT 2, MN$(17) + " takes " + AN$(MD%(OF, 9)) + " and eats it!!":
    PGPRT 2, CHR$(34) + MN$(17) + " likes " + AN$(MD%(OF, 9)) + "! - It's chewy!!" + CHR$(34)
    AD%(MD%(OF, 9), 4) = 0
    MD%(OF, 9) = -1
    RETURN
A.HIT:
    INC = ABS(INT(100 * RND(1) + 1) > MD%(OF, 10))
    MD%(OF, 10) = MD%(OF, 10) + 2 * INC
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    A = 1
    IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO DO.DAMAGE
    PGPRT 1, "A critical hit!"
    R2 = INT(100 * RND(1) + 1)
    IF R2 < 51 THEN A = 0: GOTO DO.DAMAGE
    IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
    IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
    IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
    GOTO IS.DEAD
DO.DAMAGE:      ' DO.DAMAGE
    D2 = 0
    FOR D3 = 1 TO D
    D2 = D2 + INT(S * RND(1) + 1)
    NEXT
    IF (DF = 5 AND MD%(OF, 9) = 10) OR (DF = 13 AND MD%(OF, 9) = 27) THEN D2 = MD%(DF, 1): GOTO APPLY.DAMAGE
    IF MD%(DF, 8) = 100 THEN
	PGPRT 2, "   blow bounces off magic force field!"
	IF DF = 0 THEN MR% = MR% + D2
	RETURN
    END IF
    D2 = D2 - A * MD%(DF, 8)
    IF D2 < 1 THEN PGPRT 1, "   blow bounces off armour.": RETURN
APPLY.DAMAGE:      ' APPLY.DAMAGE
    MD%(DF, 13) = MD%(DF, 13) + D2
    IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO IS.DEAD
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + D2
SHOW.CONDITION:
    A$ = MN$(DF)
    ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:      ' GOOD.SHAPE
    PGPRT 2, A$ + " is still in good shape."
    RETURN
HURTING:      ' HURTING
    PGPRT 2, A$ + " is hurting."
    RETURN
IN.PAIN:      ' IN.PAIN
    PGPRT 2, A$ + " is in pain."
    RETURN
BADLY.INJURED:      ' BADLY.INJURED
    PGPRT 2, A$ + " is very badly injured."
    RETURN
DEATHS.DOOR:      ' DEATHS.DOOR
    PGPRT 2, A$ + " is at death's door, knocking loudly."
    RETURN
IS.DEAD:      ' IS.DEAD
    IF MD%(DF, 2) < 50 THEN PGPRT 2, MN$(DF) + " is dead!"
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
    MD%(DF, 5) = 0
    IF MD%(DF, 6) > 0 THEN A2 = DF + NZ - NM + CL: AD%(A2, 4) = ROOM
    IF MD%(DF, 6) < 0 THEN PGPRT 2, "The body disintegrates.": CL = CL - 1: IF DF = NM OR CL = 0 THEN NM = NM - 1
    IF DF = 17 THEN RETURN
    FOR AJ = 1 TO NA
    IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = ROOM
    NEXT
    IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = ROOM: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
GET.BODY:
    A2 = DF + NZ - NM
    IF DF = 0 THEN DIE = 1: GOTO GAME.OVER
    IF DF = 5 AND MD%(OF, 9) <> 10 THEN GOTO WEREWOLF.RECOVERS
    IF DF = 5 THEN PGPRT 2, "As the werewolf dies, a chain falls off his neck.": AD%(26, 4) = ROOM
    IF DF = 36 THEN MD%(DF, 13) = 0: PGPRT 2, "The Genie reenters his bottle."
    IF DF = 13 AND MD%(OF, 9) <> 27 THEN PRINT MN$(13); " stands up!": GOTO Undead
    AD%(A2, 4) = ROOM
    RETURN
WEREWOLF.RECOVERS:
    PGPRT 2, "You hear a low growl, followed by a loud snarl as the werewolf comes back           to life!!"
Undead:
    MD%(DF, 5) = ROOM
    MD%(DF, 13) = 0
    AD%(A2, 4) = 0
    R3 = ROOM
    GOSUB CHK.REACTIONS
    RETURN
FLEE.RTN:
    IF NBTL = 0 THEN PGPRT 2, "There's nothing to flee from!": GOTO MAIN.LOOP
    IF NX = 0 THEN PGPRT 2, "There's no place to go!": GOTO MAIN.LOOP
    IF S$ <> "" THEN
	C = 0
	FOR D = 1 TO ND
	    IF S$ = LEFT$(UCASE$(C$(D)), LEN(S$)) THEN C = D: Exit For
	NEXT
	IF C > 0 THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
    END IF
    GOSUB FIND.EXIT
    GOTO MOVE.IT
FIND.EXIT:
    IF NX = 0 THEN R2 = ROOM: PGPRT 1, " ... but can't find an exit!": RETURN
    IF ROOM = 31 AND L1 = 0 THEN R2 = 30: RETURN
    IF ROOM = 13 AND L0 <> 1 THEN R2 = 12: RETURN
    R2 = RD%(ND * RND(1) + 1)
    IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
    RETURN
' ---------------------------------------------------------------------------
GIVE.RTN:
    IF S$ = "" THEN GOSUB GET.SUBJ
    A = 0
    M = 0
    M$ = ""
    A$ = ""
    SEP = INSTR(S$, " TO ")
    IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
    END IF
    SEP = INSTR(S$, " ")
    IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF FOUND THEN
	      M$ = S$
	      A$ = MID$(SAVE.S$, SP)
	      GOTO READY.SEARCH.GIVE
	  END IF
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
	    A$ = MID$(S$, SEP + 1)
	    M$ = LEFT$(S$, SEP - 1)
	ELSE
	    GOSUB GIVE.WHO
	    GOSUB GIVE.WHAT
	END IF
    ELSE
	GOSUB ARTIFACT.SEARCH
	IF FOUND THEN
	    A$ = AN$(A)
	ELSE
	    GOSUB MONSTER.SEARCH
	    IF FOUND THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
	    END IF
	END IF
    END IF
READY.SEARCH.GIVE:
    GOSUB GIVE.WHO
    GOSUB GIVE.WHAT
    IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
    END IF
    IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
	    S$ = A$
	    GOSUB ARTIFACT.SEARCH
	END IF
    END IF
    IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
    IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
    PGPRT 2, "I don't know what you mean."
    GOTO MAIN.LOOP
RESOLVE.GIVE:      ' RESOLVE.GIVE
    PGPRT 2, "Okay."
    POP = 0
    GOSUB GIVE.ART.MON
    IF POP <> 0 THEN GOTO MAIN.LOOP
    IF A = MD%(0, 9) THEN MD%(0, 9) = -1
    AD%(A, 4) = -M - 1
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
    IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO CHK.WGHT
GIVE.ART.MON:
 ' PUT SPECIAL CODE HERE FOR GIVING ITEM (A) TO MONSTER (M)
 ' IF MONSTER REFUSES OR SOME SPECIAL ACTION WHERE ITEM DOESN'T CHANGE
 ' HANDS OCCURS, THEN SET POP = -1 AND RETURN FROM THIS ROUTINE.
    IF A = ARMPTR OR A = SHDPTR THEN GOSUB DROP.ARMOR
    RETURN
GIVE.GOLD:
    IF VAL(A$) > GOLD& THEN PGPRT 2, "You aren't carrying that much gold!": GOTO GET.BACK
    GOLD& = INT(GOLD& - VAL(A$))
    MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
    GOTO COMPLETE.GIVE
GIVE.WHO:
    IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
    RETURN
GIVE.WHAT:
    IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
    RETURN
' ---------------------------------------------------------------------------
' ---------------------------------------------------------------------------
INVENTORY.RTN:
    IF IV THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    PGPRT 2, "You are carrying the following--"
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN
	PRINT " " + AN$(A);
	IF A = MD%(0, 9) THEN PRINT " (Ready weapon)";
	IF A = ARMPTR THEN PRINT " (Worn Armor)";
	IF A = SHDPTR THEN PRINT " (Your Shield)";
	PGPRT 1, " "
    END IF
    NEXT
    PGPRT 1, STR$(GOLD&) + " gold pieces."
    GOTO GET.BACK
' --------------------------------------------------------------------------
BLAST.SPELL:
    GOSUB GET.SUBJ
    GOSUB MONSTER.SEARCH
    IF FOUND = 0 THEN GOTO BLASTED.DOOR
    S = 1
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    PGPRT 2, "Direct Hit!"
    S = 5
    D = 2
    DF = M
    A = 0
    GOSUB DO.DAMAGE
    GOTO GET.BACK
BLASTED.DOOR:
'    /// BLAST DOOR/GATE OR CONTAINER?
    TA = 1
    GOTO ASSAULT.ARTIFACT
' ---------------------------------------------------------------------------
CAST.SPELL:
    SUC = 0
    IF SA%(S) THEN RL = INT(100 * RND(1) + 1): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN SUC = 0
    IF SUC = 0 THEN PGPRT 2, "Nothing happened.": RETURN
    RL = INT(100 * RND(1) + 1)
    IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
    S2%(S) = S2%(S) * .8
    RETURN
' ---------------------------------------------------------------------------
HEAL.SPELL:
    S = 2
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
HEAL.WOUNDS:
    M = 0
    IF S$ <> "" THEN GOSUB MONSTER.SEARCH
    IF M = 0 THEN S$ = "your" ELSE S$ = MN$(M) + "'s"
    IF MD%(M, 13) THEN
	PGPRT 2, "Some of " + S$ + " wounds seem to clear up."
	MD%(M, 13) = MD%(M, 13) - INT(10 * RND(1) + 1)
    END IF
    IF MD%(M, 13) < 0 THEN MD%(M, 13) = 0
    DF = M
    GOSUB SHOW.CONDITION
    GOTO GET.BACK
' --------------------------------------------------------------------------
POWER.SPELL:
    S = 4
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    RR = INT(RND(1) * 100 + 1)
    SA = 0
    IF MD%(0, 13) > MD%(0, 1) * .65 AND RND(1) > .7 THEN PGPRT 2, "All your wounds have healed.": MD%(0, 13) = 0: GOTO GET.BACK
    IF RND(1) < .85 THEN GOTO POWER.2
    PGPRT 2, "You hear a booming voice say:  'Do you surrender?' "
    PGPRT 1, "Input Y or N :"
    A$ = ""
    WHILE A$ <> "Y" AND A$ <> "N"
      A$ = INKEY$
      A$ = UCASE$(A$)
    WEND
    IF A$ = "Y" THEN PGPRT 2, "You cannot be blamed. Many of the best warriors can't make it thru this cave.": GOTO GAME.OVER
    IF A$ = "T" THEN PGPRT 2, "You hear a booming voice say:  'You are wise beyond your years.'": PGPRT 2, " 'You shall survive.'": MD%(0, 8) = 100: MM% = 32500: MR% = 1: GOTO GET.BACK
    IF RND(0) < .45 THEN GOTO POWER.3
POWER.2:
    PGPRT 2, "Your body generates a sudden flash of intense energy!! It strikes everything    in the room!"
    D = 3
    S = 4
    OF = 0
    FOR DF = 1 TO NM
	IF MD%(DF, 5) = ROOM THEN PGPRT 1, "It strikes " + MN$(DF): GOSUB DO.DAMAGE
    NEXT
    GOTO GET.BACK
POWER.3:
    IF RND(1) < .6 THEN GOTO POWER.4
    PGPRT 2, "A blinding flash of light appears!!"
    PGPRT 1, "and then vanishes."
    FOR X = 1 TO 4: SA%(X) = 80: S2%(X) = 80: NEXT: GOTO GET.BACK
POWER.4:
      IF AD%(28, 4) = ROOM THEN PGPRT 2, "The statue comes to life!": MD%(39, 5) = ROOM: AD%(28, 4) = 0: GOSUB CHK.REACTIONS: GOTO GET.BACK
      PGPRT 2, "Nothing happened.": GOTO GET.BACK
' --------------------------------------------------------------------------
SPEED.SPELL:
    S = 3
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    IF SPD <> 0 THEN PGPRT 2, "Nothing Happens.": GOTO MAIN.LOOP
    MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2)
    MD%(0, 2) = 2 * MD%(0, 2)
    SPD = SPD + INT(25 * RND(1) + 10)
    PGPRT 2, "You can feel the new agility flowing through you!"
    GOTO GET.BACK
' --------------------------------------------------------------------------
SMILE.RTN:
    IF IV THEN GOTO GET.BACK
    PGPRT 1, " "
    FOR M = 1 TO NM
      IF MD%(M, 5) = ROOM AND MD%(M, 15) <= 1 THEN
	  ON MD%(M, 14) GOSUB GROWLS, IGNORES, SMILES
      END IF
    NEXT
    PGPRT 1, " "
    GOTO GET.BACK
GROWLS:
    PGPRT 1, MN$(M) + " growls at you!"
    RETURN
IGNORES:
    PGPRT 1, MN$(M) + " ignores you."
    RETURN
SMILES:
    PGPRT 1, MN$(M) + " " + LCASE$(C$(C)) + "s back."
    RETURN
' --------------------------------------------------------------------------
SAY.SOMETHING:
    GOSUB GET.SUBJ
    IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
    IF S$ = "HEAL" THEN GOTO HEAL.SPELL
    IF S$ = "POWER" THEN GOTO POWER.SPELL
    IF S$ = "SPEED" THEN GOTO SPEED.SPELL
    PGPRT 2, "Okay, " + CHR$(34) + S$ + CHR$(34)
    IF IV THEN GOSUB RATTLE.MONSTER
    GOTO GET.BACK
' --------------------------------------------------------------------------
READY.WEAPON:
    GOSUB GET.SUBJ
    IF S$ = "MIRROR" THEN GOTO READY.MIRROR
    WH = -1
    HA = WH
    EMB = HA
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO MAIN.LOOP
    IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PGPRT 2, "That isn't a weapon!": GOTO MAIN.LOOP
CALCULATE.ODDS:
    MD%(0, 10) = (EA + AE) * ABS(-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
    MD%(0, 9) = A
    MD%(0, 11) = AD%(A, 7)
    MD%(0, 12) = AD%(A, 8)
    PGPRT 2, "Readied."
    GOTO GET.BACK
READY.MIRROR:
    IF AD%(25, 4) = -1 THEN RM = 1: PGPRT 2, "O.K. You are viewing through the mirror": GOTO MAIN.LOOP
    GOTO DONT.UNDERSTAND
' --------------------------------------------------------------------------
THROW.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ROPE" THEN GOTO THROW.ROPE
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying " + S$: GOTO MAIN.LOOP
    IF AD%(A, 2) > 1 THEN GOTO THROW.WEAPON
ALLOW.THROW:
    PGPRT 2, S$ + " thrown.": AD%(A, 4) = ROOM
    IF NBTL THEN PGPRT 2, " --A MISS."
    GOTO GET.BACK
THROW.ROPE:
    IF AD%(6, 4) <> -1 THEN PGPRT 2, "You aren't carrying a rope.": GOTO MAIN.LOOP
    M = 0
    IF ROOM > 5 THEN GOTO ALLOW.THROW
    PGPRT 2, "Rope thrown."
    IF FNR(24) > MD%(0, 2) THEN PGPRT 2, "You missed the rock outcrop.": M = 1
    IF FNR(100) > 90 AND MD%(0, 1) < FNR(48) THEN PGPRT 2, "You have lost your grip on the rope supporting your body, and plunged to your      death!!": DIE = -1: GOTO GAME.OVER
    IF M THEN GOTO GET.BACK
    PGPRT 2, "The rope catches the rock.": UP = -1: GOTO GET.COMMAND
THROW.WEAPON:
    PGPRT 2, "Throwing weapons is not allowed. You might hurt somebody!!": GOTO GET.BACK
    GOTO GET.BACK
DIG.RTN:
    IF AD%(5, 4) <> -1 THEN GOTO TOO.HARD
    IF ROOM = 36 OR ROOM = 37 OR ROOM = 51 THEN GOTO DIG.HOLE
    IF ROOM = 68 OR ROOM = 71 THEN PGPRT 2, "You found nothing.": GOTO MAIN.LOOP
    GOTO SOLID.ROCK
DIG.HOLE:
    IF ROOM = 36 AND AD%(7, 4) = 0 THEN PGPRT 2, "You found a box buried in the ground.": AD%(7, 4) = ROOM: GOTO MAIN.LOOP
    IF ROOM = 51 THEN GOTO DIG.WHICH.WAY
    IF ROOM = 37 AND AD%(8, 4) = 0 THEN PGPRT 2, "You found something!": AD%(8, 4) = ROOM: GOTO MAIN.LOOP
    IF ROOM = 71 AND AD%(25, 4) = 0 THEN PGPRT 2, "You found something.": AD%(25, 4) = ROOM: GOTO MAIN.LOOP
DIG.WHICH.WAY:
    PRINT "Which way do you want to dig?";
    INPUT "", DR$
    IF LEN(DR$) < 2 THEN DR$ = DR$ + " "
    D = 0
    FOR X = 1 TO 20 STEP 2
    IF DR$ = MID$("N S E W U D NENWSESW", D, 2) THEN D = INT((X + 1) / 2)
    NEXT
    IF D = 0 THEN PRINT "Invalid direction.": GOTO DIG.WHICH.WAY
    IF D <> 7 THEN PGPRT 2, "You only got a couple of feet and struck solid rock.": GOTO MAIN.LOOP
    DC = DC + 1
    IF DC = 3 THEN PGPRT 2, "You have broken out to daylight!!": GOTO MAIN.LOOP
    PGPRT 2, "You got a couple of feet dug out."
    GOTO MAIN.LOOP
TOO.HARD:
    PGPRT 2, "The ground is too hard to dig with your fingers.": GOTO GET.BACK
SOLID.ROCK:
    PRINT : PRINT "The walls and floor are solid rock.": GOTO GET.BACK
OPEN.RTN:
      GOSUB GET.SUBJ
      IF S$ = "BOX" THEN GOTO OPEN.BOX
      IF S$ = "BOTTLE" THEN GOTO OPEN.BOTTLE
      IF S$ = "BOOK" THEN GOTO OPEN.BOOK
      IF RIGHT$(S$, 4) = "DOOR" THEN GOTO OPEN.DOOR
      PGPRT 2, "I don't know what you mean."
      GOTO MAIN.LOOP
OPEN.BOX:
      IF AD%(7, 4) = ROOM OR AD%(7, 4) = -1 THEN
	  IF AD%(9, 4) = 0 THEN
	      AD%(9, 4) = ROOM
	      PGPRT 2, "You found something inside."
	      GOTO MAIN.LOOP
	  END IF
      ELSE
	  PGPRT 2, "I see no box here."
      END IF
      GOTO MAIN.LOOP
OPEN.BOTTLE:
      IF MD%(36, 5) <= 0 AND MD%(36, 13) = 0 AND AD%(70, 4) = -1 THEN GOTO BOTTLE.OPENS
      IF AD%(70, 4) <> -1 THEN PGPRT 2, "I don't know what you're talking about!": GOTO MAIN.LOOP
      PRINT "The bottle is already open.": GOTO MAIN.LOOP
BOTTLE.OPENS:
      PGPRT 2, "As you open the bottle, a puff of smoke rises from it and forms into a powerful": PGPRT 1, "Genie!": MD%(36, 5) = ROOM: GOSUB CHK.REACTIONS: GOTO MAIN.LOOP
OPEN.BOOK:
      IF OB THEN PRINT "O.K. The book is open.": GOTO MAIN.LOOP
      PGPRT 2, "As you open the book, the pictures of a pack of monsters greets you. - The      monsters in the picture grow until they reach full size and then they step out": PRINT "of the book!"
      OB = 1: MD%(7, 5) = ROOM: PRINT : MD%(13, 5) = ROOM: MD%(35, 5) = ROOM: MD%(12, 5) = ROOM: GOSUB CHK.REACTIONS: GOTO MAIN.LOOP
OPEN.DOOR:
      IF ROOM = 60 AND S$ = "DOOR" THEN GOTO WHICH.DOOR
      IF ROOM = 64 THEN PRINT "It is dark in there, but something seems to be moving.": GOTO MAIN.LOOP
      IF ROOM = 60 AND (LEFT$(S$, 2) = "OA" OR LEFT$(S$, 2) = "NO") THEN L3 = 1: GOTO DOORS.OPEN
      IF ROOM = 60 AND (LEFT$(S$, 2) = "HI" OR LEFT$(S$, 2) = "EA") THEN L2 = 1: GOTO DOORS.OPEN
WHICH.DOOR:
      PRINT "East or North door?";
      A$ = ""
      WHILE A$ <> "N" AND A$ <> "E"
	A$ = INPUT$(1)
	A$ = UCASE$(A$)
      WEND
      PRINT A$: IF A$ = "E" THEN L2 = 1: GOTO DOORS.OPEN
      L3 = 1
DOORS.OPEN:
      PGPRT 2, "The door is open.": GOTO MAIN.LOOP
WEAR.RTN:
      GOSUB GET.SUBJ
      GOSUB ARTIFACT.SEARCH
      IF FOUND = 0 THEN PGPRT 2, "I don't know what you're talking about.": GOTO MAIN.LOOP
      IF S$ = "MAGIC RING" OR S$ = "RING" THEN GOTO WEAR.RING
      PGPRT 2, "Are you kidding?": GOTO MAIN.LOOP
WEAR.RING:
      IF AD%(3, 4) <> -1 THEN PGPRT 2, "You don't have any " + LCASE$(S$) + ".": GOTO MAIN.LOOP
      MR% = 1: PGPRT 2, "Magic ring donned.": PGPRT 2, "You feel a protective field envelope you.": MD%(0, 8) = 100
      GOTO GET.BACK
REMOVE.RTN:
      IF MR% THEN PGPRT 2, "Magic ring has been removed.": MD%(0, 8) = AC: MM% = MM% - MR%: MR% = 0: GOTO GET.BACK
      GOTO DONT.UNDERSTAND
ASSAULT.ARTIFACT:
    IF TA = 0 THEN PGPRT 2, "Attack who?": GOTO MAIN.LOOP
    PGPRT 2, "You can't blast " + LCASE$(S$) + "!"
    GOTO MAIN.LOOP
' --------------------------------------------------------------------------
PUT.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ON MAGIC RING" OR S$ = "MAGIC RING ON" OR S$ = "ON RING" OR S$ = "RING ON" THEN
	S$ = "MAGIC RING"
	GOTO WEAR.RTN
    END IF
    GOTO DONT.UNDERSTAND
' ---------------------------------------------------------------------------
READ.RTN:
    GOSUB GET.SUBJ
    IF (S$ = "DOOR" OR S$ = "WARNING") AND ROOM = 64 THEN PGPRT 2, CHR$(34) + "BEFRUAU AUN VAUN MEDUSA NIC GEH" + CHR$(34): GOTO MAIN.LOOP
    IF S$ = "BOOK" AND AD%(24, 4) = -1 THEN PGPRT 2, "The cover of the book says:": PGPRT 2, "    BOOK OF EVIL    ": PGPRT 2, "The book seems to be sealed shut.": GOTO MAIN.LOOP
    IF LEFT$(S$, 5) = "HYROG" AND ROOM = 53 THEN PGPRT 2, "You can't read them.": GOTO MAIN.LOOP
    WH = ROOM
    HA = -1
    EMB = ROOM + 200
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN GOTO READ.NONART
    IF AD%(A, 2) = 7 THEN GOTO READ.ARTIFACT
    PGPRT 2, "You can't read it."
    GOTO GET.BACK
READ.NONART:
'   ...  NON-ART - INSERT HERE SPECIAL READING ...
'   ...  EXAMPLE: READING WALLS OR CEILING, DOORS, ETC ...
    GOTO DONT.UNDERSTAND
READ.ARTIFACT:
'    /// READING A READABLE ARTIF.
    R = AD%(A, 5) + AD%(A, 7) - 1
    GOSUB PRINT.EFFECT
    AD%(A, 7) = AD%(A, 7) + 1
    IF AD%(A, 7) > AD%(A, 6) THEN AD%(A, 7) = 1
    GOTO GET.BACK
' --------------------------------------------------------------------------
PRINT.EFFECT:
    GET #2, R + EFF.ADJ
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    RETURN
' --------------------------------------------------------------------------
FREE.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.UNDERSTAND
    IF AD%(A, 2) <> 10 THEN GOTO DONT.UNDERSTAND
    M = AD%(A, 5)
    K = AD%(A, 6)
    G = AD%(A, 7)
    IF AD%(A, 4) <> ROOM THEN PGPRT 2, "I don't know what you are talking about.": GOTO MAIN.LOOP
    IF MD%(G, 5) = ROOM THEN PGPRT 2, MN$(G) + " won't let you do that!": GOTO GET.BACK
    IF AD%(K, 4) <> -1 AND K <> 0 THEN PGPRT 2, "You don't have the key!": GOTO MAIN.LOOP
    PGPRT 2, "You have freed " + MN$(M) + "."
    MD%(M, 5) = ROOM
    AD%(A, 4) = 0
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
' ---------------------------------------------------------------------------
EAT.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO NOT.HUNGRY
    IF AD%(A, 2) <> FOOD.ART THEN GOTO NOT.HUNGRY
    PGPRT 2, "Okay. You eat the " + LCASE$(AN$(A)) + "."
    AD%(A, 4) = 0
    GOTO GET.BACK
NOT.HUNGRY:
    PGPRT 2, "You aren't THAT hungry!"
    GOTO GET.BACK
' ---------------------------------------------------------------------------
DRINK.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN PRINT : PRINT "I don't understand.": GOTO MAIN.LOOP
    IF AD%(A, 2) <> 6 THEN PGPRT 2, "You can't do that!": GOTO MAIN.LOOP
    IF AD%(A, 7) <= 0 THEN PGPRT 2, "There isn't any left.": GOTO GET.BACK
    IF AD%(A, 5) > FNR(100) THEN GOTO DRINK.HEAL
    PRINT
    PRINT "Nothing seems to happen."
    GOTO GET.BACK
DRINK.HEAL:
    AD%(A, 7) = AD%(A, 7) - 1
    MD%(0, 13) = MD%(0, 13) - AD%(A, 6)
    IF MD%(0, 13) < 0 THEN MD%(0, 13) = 0
    PRINT
    PRINT "Your wounds seem to "; MID$("openheal", ABS(AD%(A, 6) > 0) * 4 + 1, 4); "!"
    GOTO GET.BACK
' ---------------------------------------------------------------------------
' ---------------------------------------------------------------------------
SAVE.GAME:
    INPUT "Do you want to save this game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO SAVE.IT
    GOTO MAIN.LOOP
SAVE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
REM $$INCL:'\Eamon\COPY\SAVEGAME.BAS'
'        Eamon Save Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR OUTPUT AS #1
        PRINT #1, LT
        PRINT #1, LM
        PRINT #1, LC
        PRINT #1, LS
        PRINT #1, ROOM
        PRINT #1, SPD
        PRINT #1, TT
        PRINT #1, ArmNam$
        PRINT #1, ArmHit
        PRINT #1, ArmAdj
        PRINT #1, ShdNam$
        PRINT #1, ShdHit
        PRINT #1, ShdAdj
        PRINT #1, AE
        FOR X = 1 TO 4
        PRINT #1, SA%(4)
        NEXT
        FOR X = 1 TO 4
        PRINT #1, S2%(4)
        NEXT
        FOR X = 1 TO 5
        PRINT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        PRINT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        PRINT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        PRINT #1, V%(V)
        NEXT V
        PRINT #1, GOLD&
        PRINT #1, BANK&

    '------- (end of include file) -------    
 ' 
    PRINT #1, VC
    PRINT #1, IC
    PRINT #1, IV
    PRINT "Game is saved. To restore it, use restore command."
    SAVED = -1
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MAIN.LOOP
RESTORE.GAME:
    INPUT "Do you want to Restore a game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO RESTORE.IT
    GOTO MAIN.LOOP
RESTORE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
REM $$INCL:'\Eamon\COPY\RESTGAME.BAS'
'        Eamon Restore Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR INPUT AS #1
        INPUT #1, LT
        INPUT #1, LM
        INPUT #1, LC
        INPUT #1, LS
        INPUT #1, ROOM
        INPUT #1, SPD
        INPUT #1, TT
        INPUT #1, ArmNam$
        INPUT #1, ArmHit
        INPUT #1, ArmAdj
        INPUT #1, ShdNam$
        INPUT #1, ShdHit
        INPUT #1, ShdAdj
        INPUT #1, AE
        FOR X = 1 TO 4
        INPUT #1, SA%(X)
        NEXT
        FOR X = 1 TO 4
        INPUT #1, S2%(X)
        NEXT
        FOR X = 1 TO 5
        INPUT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        INPUT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        INPUT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        INPUT #1, V%(V)
        NEXT V
        INPUT #1, GOLD&
        INPUT #1, BANK&
    CLOSE 1

    '------- (end of include file) -------    
 ' 
    INPUT #1, VC
    INPUT #1, IC
    INPUT #1, IV
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MOVE.IT
GET.GAME.ID:
    PRINT
    INPUT "File Name: ", GAME.ID$
    IF LEN(GAME.ID$) > 8 THEN GOTO GET.GAME.ID
    GAME.ID$ = UCASE$(GAME.ID$)
    IF LEFT$(GAME.ID$, 1) < "A" OR LEFT$(GAME.ID$, 1) > "Z" THEN GOTO GET.GAME.ID
    GAME.ID$ = GAME.ID$ + ".GAM"
    RETURN
' ---------------------------------------------------------------------------
REM $$INCL:'\Eamon\COPY\CHARIO.BAS'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  CHARIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Character File I/O Routines for Eamon QB/PC
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        or BASIC 7.0 PDS
        '       uses User defined types for record definition
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
OPEN.CHARACTERS:
      OPEN "CHARACT.DAT" FOR RANDOM AS #1 LEN = LEN(Char)
      RETURN
READ.NBR.CHARS:
      GET #1, 1, CharCtl
      NC = CharCtl.NbrChar
      IF NC > LOF(1) \ LEN(Char) THEN NC = LOF(1) \ LEN(Char) - 1
      RETURN
READ.CHARACTER:
      GET #1, REC, Char
      Nam$ = RTRIM$(Char.Nam$)
      HD = Char.Hd
      AG = Char.Ag
      CH = Char.Ch
      SA%(1) = Char.SA1
      SA%(2) = Char.SA2
      SA%(3) = Char.SA3
      SA%(4) = Char.SA4
      WA%(1) = Char.WA1
      WA%(2) = Char.WA2
      WA%(3) = Char.WA3
      WA%(4) = Char.WA4
      WA%(5) = Char.WA5
      SEX$ = Char.SEX
      GOLD& = Char.GOLD
      BANK& = Char.BANK
      AE = Char.AE
      ArmNam$ = RTRIM$(Char.ArmNam)
      ArmHit = Char.ArmHit
      ArmAdj = Char.ArmAdj
      ShdNam$ = RTRIM$(Char.ShdNam)
      ShdHit = Char.ShdHit
      ShdAdj = Char.ShdAdj
      WN$(1) = RTRIM$(Char.Wpn1Nam)
      WR%(1) = Char.Wpn1Typ
      WT%(1) = Char.Wpn1WpnTyp
      WC%(1) = Char.Wpn1Odds
      WD%(1) = Char.Wpn1Dice
      WS%(1) = Char.Wpn1Sides
      WN$(2) = RTRIM$(Char.Wpn2Nam)
      WR%(2) = Char.Wpn2Typ
      WT%(2) = Char.Wpn2WpnTyp
      WC%(2) = Char.Wpn2Odds
      WD%(2) = Char.Wpn2Dice
      WS%(2) = Char.Wpn2Sides
      WN$(3) = RTRIM$(Char.Wpn3Nam)
      WR%(3) = Char.Wpn3Typ
      WT%(3) = Char.Wpn3WpnTyp
      WC%(3) = Char.Wpn3Odds
      WD%(3) = Char.Wpn3Dice
      WS%(3) = Char.Wpn3Sides
      WN$(4) = RTRIM$(Char.Wpn4Nam)
      WR%(4) = Char.Wpn4Typ
      WT%(4) = Char.Wpn4WpnTyp
      WC%(4) = Char.Wpn4Odds
      WD%(4) = Char.Wpn4Dice
      WS%(4) = Char.Wpn4Sides
      RETURN
WRITE.CHARACTER:
      Char.Nam = Nam$
      Char.Hd = HD
      Char.Ag = AG
      Char.Ch = CH
      Char.SA1 = SA%(1)
      Char.SA2 = SA%(2)
      Char.SA3 = SA%(3)
      Char.SA4 = SA%(4)
      Char.WA1 = WA%(1)
      Char.WA2 = WA%(2)
      Char.WA3 = WA%(3)
      Char.WA4 = WA%(4)
      Char.WA5 = WA%(5)
      Char.SEX = SEX$
      Char.GOLD = GOLD&
      Char.BANK = BANK&
      Char.AE = AE
      Char.ArmNam = ArmNam$
      Char.ArmHit = ArmHit
      Char.ArmAdj = ArmAdj
      Char.ShdNam = ShdNam$
      Char.ShdHit = ShdHit
      Char.ShdAdj = ShdAdj
      Char.Wpn1Nam = WN$(1)
      Char.Wpn1Typ = WR%(1)
      Char.Wpn1WpnTyp = WT%(1)
      Char.Wpn1Odds = WC%(1)
      Char.Wpn1Dice = WD%(1)
      Char.Wpn1Sides = WS%(1)
      Char.Wpn2Nam = WN$(2)
      Char.Wpn2Typ = WR%(2)
      Char.Wpn2WpnTyp = WT%(2)
      Char.Wpn2Odds = WC%(2)
      Char.Wpn2Dice = WD%(2)
      Char.Wpn2Sides = WS%(2)
      Char.Wpn3Nam = WN$(3)
      Char.Wpn3Typ = WR%(3)
      Char.Wpn3WpnTyp = WT%(3)
      Char.Wpn3Odds = WC%(3)
      Char.Wpn3Dice = WD%(3)
      Char.Wpn3Sides = WS%(3)
      Char.Wpn4Nam = WN$(4)
      Char.Wpn4Typ = WR%(4)
      Char.Wpn4WpnTyp = WT%(4)
      Char.Wpn4Odds = WC%(4)
      Char.Wpn4Dice = WD%(4)
      Char.Wpn4Sides = WS%(4)
      PUT #1, REC, Char
      RETURN
WRITE.NBR.CHARS:
      CharCtl.NbrChar = NC
      PUT #1, 1, CharCtl
      RETURN

    '------- (end of include file) -------    
 ' 
READ.ART.REC: ' ------------- READ ARTIFACTS ---------------------
       OPEN PATH$ + "ARTIF.TXT" FOR RANDOM AS #3 LEN = 128
       DIM AF.DATA$(8)
       FIELD 3, 20 AS AF.NAME$, 2 AS AF.DATA$(1), 2 AS AF.DATA$(2), 2 AS AF.DATA$(3), 2 AS AF.DATA$(4), 2 AS AF.DATA$(5), 2 AS AF.DATA$(6), 2 AS AF.DATA$(7), 2 AS AF.DATA$(8)
       FOR A = 1 TO NA
       GET #3, A
       AN$(A) = AF.NAME$
       AN$(A) = RTRIM$(AN$(A))
       FOR A2 = 1 TO 8: AD%(A, A2) = CVI(AF.DATA$(A2)): NEXT A2
       IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 THEN NW = NW + 1
       NEXT
       CLOSE
       RETURN
READ.MON.REC: ' ------------- READ MONSTERS ---------------------
       OPEN PATH$ + "MONST.TXT" FOR RANDOM AS #3 LEN = 128
       DIM MF.DATA$(12)
       FIELD 3, 20 AS MF.NAME$
       FOR A2 = 1 TO 12
       FIELD 3, 20 AS X$, (A2 - 1) * 2 AS X$, 2 AS MF.DATA$(A2)
       NEXT
       FOR A = 1 TO NM: GET #3, A: MN$(A) = RTRIM$(LEFT$(MF.NAME$, 1) + LCASE$(MID$(MF.NAME$, 2)))
       FOR A2 = 1 TO 12: MD%(A, A2) = CVI(MF.DATA$(A2)): NEXT A2
       IF MD%(A, 3) < 0 THEN MD%(A, 3) = ABS(MD%(A, 3)) - 1: MD%(A, 14) = 2
       NEXT
       CLOSE 3
       RETURN
OPEN.DESC: ' ----------------- OPEN DESC FILE -------------------
       OPEN PATH$ + "DESC.TXT" FOR RANDOM AS #2 LEN = 256:
       FIELD 2, 255 AS DESC$
       RETURN
OPEN.ROOM.NAMES: ' ---------------- OPEN ROOM NAMES -------------------
       OPEN PATH$ + "RMNAMES.TXT" FOR RANDOM AS #3 LEN = 64
       FIELD 3, 64 AS RN$
       RETURN
OPEN.ROOMS: ' ---------------- OPEN ROOMS FILE -------------------
       OPEN PATH$ + "ROOMS.TXT" FOR RANDOM AS #1 LEN = 64
       FOR D = 1 TO ND
       FIELD 1, (D - 1) * 2 AS X$, 2 AS RF.DIR$(D)
       NEXT
       FIELD 1, (ND * 2) AS X$, 2 AS RF.LT$
       RETURN

SUB PGPRT (SP, LIT$)

STATIC PG.CNT
    IF SP = 0 THEN PG.CNT = 0: EXIT SUB
    IF LIT$ = "" THEN PG.CNT = PG.CNT + SP: EXIT SUB
    IF PG.CNT > 18 THEN
	LOCATE 24, 1
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-");
	A$ = INPUT$(1)
	PG.CNT = 0
	LOCATE CSRLIN, 1
	PRINT SPC(79);
    END IF
    IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	PG.CNT = PG.CNT + 1
	NEXT
    END IF
    PRINT LIT$
    PG.CNT = PG.CNT + INT(LEN(LIT$) / 80) + 1
END SUB

