'        Eamon Adventure #120
'
'            Orb of My Life
'
'           by John Nelson
'
'        DDD VERSION 6.2
'
    ' +--------------------------------------------------------------+
    ' |                National Eamon User's Club                    |
    ' |                  Log of Program Changes                      |
    ' |                                        |
    ' |                                                              |
    ' |   Date     Version      Description of Change                |
    ' | --------   -------     ------------------------------------- |
    ' | 06/22/88     2.00      New Base Program used, new give rtn   |
    ' | 01/29/89     2.01      Path input commented out              |
    ' | 12/03/90     2.02      Color Screens Allowed                 |
    ' |  4/21/91     2.03      Hard Disk Support Installed           |
    ' +--------------------------------------------------------------+
     DEFINT A-Z
     DECLARE SUB PGPRT (SP, LIT$)
REM $$INCL:'\EAMON\COPY\CHARDEF.BAS'
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
	'   Module:  CHARDEF.BAS
	'   Eamon Version:  Eamon-QB (or Eamon-PC)
	' ------------------------------------------------------------
	'  Character Definition for Eamon QB/PC
	'        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
	'                        or BASIC 7.0 PDS
	'       uses Field statements for record description
	'       This module will work for QBasic, but QBasic cannot
	'       support $INCLUDE: statements, so module must be copied
	'       into programs manually or merged using a utility
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
TYPE WeaponRec
	Nam             AS STRING * 20
	Wpntyp          AS INTEGER
	Odds            AS INTEGER
	Dice            AS INTEGER
	Sides           AS INTEGER
END TYPE

TYPE CharacterRecord
	Nam             AS STRING * 30
	Hd              AS INTEGER
	Ag              AS INTEGER
	Ch              AS INTEGER
	SA1             AS INTEGER
	SA2             AS INTEGER
	SA3             AS INTEGER
	SA4             AS INTEGER
	WA1             AS INTEGER
	WA2             AS INTEGER
	WA3             AS INTEGER
	WA4             AS INTEGER
	WA5             AS INTEGER
	Sex             AS STRING * 1
	Gold            AS LONG
	Bank            AS LONG
	AE              AS INTEGER
	ArmNam          AS STRING * 20
	ArmHit          AS INTEGER
	Armadj          AS INTEGER
	ShdNam          AS STRING * 20
	ShdHit          AS INTEGER
	ShdAdj          AS INTEGER
	Wpn1Nam         AS STRING * 20
	Wpn1typ         AS INTEGER
	Wpn1Wpntyp      AS INTEGER
	Wpn1odds        AS INTEGER
	Wpn1Dice        AS INTEGER
	Wpn1Sides       AS INTEGER
	Wpn2Nam         AS STRING * 20
	Wpn2typ         AS INTEGER
	Wpn2Wpntyp      AS INTEGER
	Wpn2odds        AS INTEGER
	Wpn2Dice        AS INTEGER
	Wpn2Sides       AS INTEGER
	Wpn3Nam         AS STRING * 20
	Wpn3typ         AS INTEGER
	Wpn3Wpntyp      AS INTEGER
	Wpn3odds        AS INTEGER
	Wpn3Dice        AS INTEGER
	Wpn3Sides       AS INTEGER
	Wpn4Nam         AS STRING * 20
	Wpn4typ         AS INTEGER
	Wpn4Wpntyp      AS INTEGER
	Wpn4odds        AS INTEGER
	Wpn4Dice        AS INTEGER
	Wpn4Sides       AS INTEGER
	Filler          AS STRING * 23
END TYPE
DIM Char AS CharacterRecord
TYPE CharControl
	NbrChar         AS INTEGER
	Filler          AS STRING * 254
END TYPE
DIM CharCtl AS CharControl

    '------- (end of include file) -------    
 ' 
     RANDOMIZE TIMER
REM $$INCL:'\EAMON\COPY\COLORRTN.BAS'
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     GOTO Colorset
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
Colorset:

    '------- (end of include file) -------    
 ' 
     CLS
REM $$INCL:'\EAMON\COPY\READCTL.BAS'
     CLOSE 1
     OPEN "DESC.R0" FOR INPUT AS #1
     INPUT #1, NR
     INPUT #1, NZ
     INPUT #1, NE
     INPUT #1, NM
     INPUT #1, ND
     INPUT #1, MAX.RM
     INPUT #1, MAX.ART
     INPUT #1, MAX.EFF
     INPUT #1, Max.Mon
     INPUT #1, Rm.Len
     INPUT #1, Rmn.Len
     INPUT #1, Mon.Len
     INPUT #1, Art.Len
     INPUT #1, Desc.Len
     INPUT #1, Mon.Flds
     INPUT #1, Art.Flds
     INPUT #1, RM.Flds
     INPUT #1, MN.Len
     INPUT #1, AN.Len
     CLOSE 1
     NA = NZ
     ART.ADJ = MAX.RM
     EFF.ADJ = MAX.RM + MAX.ART
     MON.ADJ = MAX.RM + MAX.ART + MAX.EFF
     EMB.ADJ = MAX.RM + MAX.ART
     INS.ADJ = MAX.RM
     HID.ADJ = MAX.RM * 2 + MAX.ART
     BURY.ADJ = MAX.RM * 3 + MAX.ART

    '------- (end of include file) -------    
 ' 
     DIM V%(NR), RD%(10), FD%(3), TD%(3), SA%(4), S2%(4), WA%(5), RF.DIR$(10)
     DIM AN$(NA + 6), AD%(NA + 6, 9)
     DIM MN$(NM), MD%(NM, 16)
     GOSUB READ.ARTIFACTS ' LOAD ARTIFACT TABLE
     GOSUB READ.MONSTERS ' LOAD MONSTER TABLE
     NW = NW + 6
     DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
     READ NC
     DIM C$(NC)
     FOR C = 1 TO NC
     READ C$(C)
     NEXT
     R2 = 1
     CONST BLIND.PRIEST = 3
     CONST TOLOR = 13
     OPEN PATH$ + "MAGIC.TXT" FOR INPUT AS #1
     INPUT #1, MW$, TW$, CW$
     CLOSE
     GOTO INITIALIZE
DONT.UNDERSTAND:
     PGPRT 2, "I don't understand."
     GOTO MAIN.LOOP
ArentCarrying:
     PGPRT 2, "You aren't carrying it.": GOTO MAIN.LOOP
MustOpen:  
     PGPRT 2, "You must first open it.": GOTO MAIN.LOOP
CantDo:
     PGPRT 2, "You can't " + C$(C) + " " + LCASE$(S$): GOTO MAIN.LOOP
Nobody:
     PGPRT 2, "Nobody here by that name!": GOTO MAIN.LOOP
' ---------------------------------------------------------------------------
MAIN.LOOP:
'    = MAIN =
    IF ROOM = 68 THEN
	V%(ROOM) = V%(ROOM) + 1
	IF V%(ROOM) > 9 THEN R = 35: GOSUB PRINT.EFFECT: DIE = -1: GOTO Game.Over
    END IF
    IF SPD THEN
	SPD = SPD - 1
	IF SPD = 0 THEN
	    MD%(0, 2) = MD%(0, 2) / 2
	    MD%(0, 10) = MD%(0, 10) - 2 * MD%(0, 2)
	    PGPRT 2, "Your Speed spell has just expired!"
	END IF
    END IF
    IF ROOM = 49 AND IC = 0 THEN PGPRT 2, "The light hurts your eyes.": GOTO SHOW.ROOM
    IF IC THEN
	PRINT "Your eyes are closed. ";
	IF DD = 0 THEN PRINT "You can't see.": GOTO GET.COMMAND
    END IF
    IF IV THEN
	PGPRT 2, "You're invisible."
	VC = VC + 1
	IF VC > 5 THEN VC = 0: D2 = 3: DF = 0: GOSUB APPLY.DAMAGE   ' Do 3 points of damage every 5 rounds
    END IF
    IF IC THEN PGPRT 1, " "
SHOW.ROOM:      ' SHOW.ROOM
    IF V%(ROOM) <> 0 THEN
	GET #3, ROOM
	A$ = RTRIM$(RN$)
	PGPRT 2, "You are " + A$
    END IF
    IF V%(ROOM) = 0 THEN GOSUB SPECIAL.ROOM.CHK
    IF AD%(13, 9) AND AD%(13, 4) = ROOM THEN AD%(13, 9) = AD%(13, 9) + 1
    IF ROOM = 33 AND MD%(3, 5) = ROOM AND AD%(13, 4) = ROOM AND AD%(13, 9) > 3 THEN M = 3: MD%(3, 5) = 36: R = 13: GOSUB PRINT.EFFECT: GOSUB MONSTER.LEAVES
    FOR M = 1 TO NM
	IF MD%(M, 5) = ROOM THEN GOSUB MonsterAction
    NEXT
    FOR A = 1 TO NZ
	IF AD%(A, 4) = ROOM THEN GOSUB ArtifactAction
    NEXT
    FOR A = A TO NA
    IF AD%(A, 4) = ROOM THEN PGPRT 2, "Your " + AN$(A) + " is here."
    NEXT
    IF ROOM = 57 THEN GOTO GET.COMMAND
    IF DD = 0 AND ROOM <> 3 THEN GOTO GET.COMMAND
    C = 0
    PRINT "Exits are ";
    FOR X = 1 TO ND
    IF RD%(X) > 0 AND RD%(X) <= NR THEN PRINT C$(X); ", "; : C = 1
    IF RD%(X) = -99 THEN C = C + 10
    NEXT
    IF C = 0 THEN PRINT "Non-existent  ";
    IF C = 100 THEN PRINT "everywhere  ";
    PRINT CHR$(29); CHR$(29); ".";
    PRINT
GET.COMMAND:      ' GET.COMMAND
    PGPRT 0, ""
    PRINT
    COLOR hfg%, hbg%
    PRINT "  Your Command ";
    COLOR fgc%, bgc%
    LINE INPUT " ", A$
    A$ = LTRIM$(RTRIM$(UCASE$(A$)))
    IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 17: PRINT A$
    IF A$ = "" THEN GOTO LIST.COMMANDS
    IF A$ = "EXIT NOW" THEN GOTO Game.Over
    CZ$ = A$
    A = INSTR(A$, " ")
    IF A = 0 THEN A = LEN(A$) + 1
    V$ = LEFT$(A$, A - 1)
    S$ = MID$(A$, A + 1)
    S$ = LTRIM$(S$)
    C = 0
    FOR A = 1 TO ND
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN C = A: A = ND
    NEXT
    IF C <> 0 THEN GOTO BRANCH.RTN
    F = 0
    FOR A = ND + 1 TO NC
    IF UCASE$(C$(A)) = V$ THEN C = A: A = NC
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN
	F = F + 1
	C = A
	IF F > 1 THEN C = 0: A = NC
    END IF
    NEXT
    IF C = 0 THEN GOTO LIST.COMMANDS
    GOTO BRANCH.RTN
LIST.COMMANDS:      ' LIST.COMMANDS
    PRINT "Huh? I only understand these commands ... ";
    FOR C = 1 TO NC
    PRINT C$(C); SPC(20 - LEN(C$(C)));
    NEXT
    PRINT
    PRINT
    GOTO GET.COMMAND
    IF UCASE$(C$(C)) = S$ THEN S$ = V$: V$ = C$(C)
BRANCH.RTN:      ' BRANCH.RTN
    ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 5 GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 10 GOTO GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN, LOOK.RTN
    ON C - 15 GOTO ATTACK.RTN, FLEE.RTN, GIVE.RTN, INVENTORY.RTN, BLAST.SPELL
    ON C - 20 GOTO HEAL.SPELL, POWER.SPELL, SPEED.SPELL, SMILE.RTN, SMILE.RTN
    ON C - 25 GOTO SAY.SOMETHING, READ.RTN, READY.WEAPON, OPEN.RTN, PUT.RTN
    ON C - 30 GOTO FREE.RTN, CLOSE.RTN, WEAR.RTN, SAVE.GAME, RESTORE.GAME
    GOTO QUIT.RTN
GET.BACK:      ' GET.BACK
REM $$INCL:'\EAMON\COPY\NEWBATL.BAS'
    IF TT > 0 THEN TT = TT - 1: GOTO End.Battle
    IF NBTL = 0 THEN GOTO End.Battle
    FOR M = 1 TO NM
        IF MD%(M, 5) = ROOM AND TT = 0 THEN
            MR = FD%(MD%(M, 14)) / TD%(MD%(M, 14)) - FD%(4 - MD%(M, 14)) / TD%(4 - MD%(M, 14)) / 5 + INT(41 * RND(1) - 20)
            IF MD%(M, 4) < MR THEN
                GOSUB Find.Exit
                IF R2 > 0 THEN
                    PGPRT 2, MN$(M) + " flees!"
                    GOSUB MONSTER.LEAVES
                    EXIT FOR
                END IF
            END IF
            IF MD%(M, 14) = 3 THEN
                GOSUB GoodGuys.Attack
            ELSE
                GOSUB BadGuys.Attack
            END IF
        END IF
        NBTL = (FD%(1) < TD%(1))
        IF NBTL = 0 THEN EXIT FOR
    NEXT M
End.Battle:
    IF TT > 0 THEN TT = TT - 1
    GOTO End.Loop
BadGuys.Attack:
    OF = M
    IF TD%(1) = MD%(0, 1) THEN DF = 0: GOSUB Take.a.Swing: RETURN
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 3 AND RND(1) < .25 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    IF DF < 0 THEN DF = 0: GOSUB Take.a.Swing
    RETURN
GoodGuys.Attack:
    OF = M
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 1 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    RETURN
End.Loop:

    '------- (end of include file) -------    
 ' 
    IF SCR THEN PGPRT 2, "The witch's scream is driving you crazy!": SCR = SCR - 1: IF SCR = 0 THEN PGPRT 2, "Your ears (and brain) overload!!": PGPRT 2, "You are dead!": DIE = -1: GOTO Game.Over
    IF ROOM > 49 AND IC = 0 THEN PGPRT 2, "The sights and sensations are driving you insane!": INSANE = INSANE - 1: IF INSANE = 0 THEN PGPRT 2, "Your brain overloads!!": PGPRT 2, "You are dead!": DIE = -1: GOTO Game.Over
    GOTO MAIN.LOOP
MonsterAction:
    IF M = 17 THEN PGPRT 2, "A " + MN$(M) + " is here, with a gleam in it's eye.": RETURN
    IF M = 5 AND MD%(1, 5) = ROOM AND MD%(1, 15) < 2 AND AD%(10, 4) = -6 THEN
	TC = TC + 1
	IF TC > 2 THEN
	    MD%(1, 15) = 2:
	    R = 18: GOSUB PRINT.EFFECT
	    X = M:
	    M2 = MD%(M, 14)
	    TD%(M2) = TD%(M2) - MD%(M, 1)
	    FD%(M2) = FD%(M2) - MD%(M, 13)
	END IF
	RETURN
    END IF
    IF M = 22 THEN RETURN
    IF MD%(M, 15) = 1 THEN PGPRT 2, MN$(M) + " is here."
    IF MD%(M, 15) = 2 THEN PGPRT 2, MN$(M) + " is lying here."
    IF MD%(M, 15) = 0 THEN GET #2, M + 300: A$ = RTRIM$(DESC$): PGPRT 2, A$: MD%(M, 15) = 1
    RETURN
REM $$INCL:'\EAMON\COPY\MONLEAVE.BAS'
MONSTER.LEAVES:
    MD%(M, 5) = R2
    M2 = MD%(M, 14)
    TD%(M2) = TD%(M2) - MD%(M, 1)
    FD%(M2) = FD%(M2) - MD%(M, 13)
    NBTL = (FD%(1) < TD%(1))
    RETURN

    '------- (end of include file) -------    
 ' 
ArtifactAction:
    IF A = 9 AND FL <> 0 THEN PGPRT 2, "The forcefield vanishes!!": AD%(A, 4) = 0: AD%(23, 4) = ROOM: RETURN
    IF AD%(A, 9) THEN
	PGPRT 2, "You see " + AN$(A) + "."
    ELSE
	GET #2, A + 100
	A$ = RTRIM$(DESC$)
	PGPRT 2, A$
	AD%(A, 9) = 1
    END IF
    RETURN
' ---------------------------------------------------------------------------
INITIALIZE:
REM $$INCL:'\Eamon\COPY\READMEAT.BAS'
    OPEN "MEAT" FOR INPUT AS #2
    INPUT #2, Nbr.Party
    INPUT #2, REC
    INPUT #2, MN$(0)
    INPUT #2, MD%(0, 1)
    INPUT #2, MD%(0, 2)
    INPUT #2, MD%(0, 3)
    CH = MD%(0, 3)
    FOR X = 1 TO 4
    INPUT #2, SA%(X)
    S2%(X) = SA%(X)
    NEXT
    FOR X = 1 TO 5
    INPUT #2, WA%(X)
    NEXT
    INPUT #2, SEX$
    INPUT #2, GOLD&
    INPUT #2, BANK&
    INPUT #2, AE
    INPUT #2, ArmNam$
    INPUT #2, ArmHit
    INPUT #2, ArmAdj
    INPUT #2, ShdNam$
    INPUT #2, ShdHit
    INPUT #2, ShdAdj
    FOR X = 1 TO 4
      INPUT #2, A$
      IF RTRIM$(A$) = "" THEN A$ = "NONE"
      WN$(X) = A$
      INPUT #2, WT%(X)
      INPUT #2, WC%(X)
      INPUT #2, WD%(X)
      INPUT #2, WS%(X)
      IF A$ <> "NONE" THEN
          NA = NA + 1
          AN$(NA) = WN$(X)
          AD%(NA, 2) = 2
          AD%(NA, 3) = 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
      END IF
    NEXT
    IF ArmHit <> 0 THEN
          WN$(5) = ArmNam$ + " Armor"
          WT%(5) = 1
          WD%(5) = ArmHit
          WC%(5) = ArmAdj
          NA = NA + 1
          MD%(0, 8) = ArmHit
          Armptr = NA
          AN$(NA) = WN$(5)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    IF ShdHit <> 0 THEN
          WN$(6) = ShdNam$ + " Shield"
          WT%(6) = 2
          WD%(6) = ShdHit
          WC%(6) = ShdAdj
          NA = NA + 1
          MD%(0, 8) = MD%(0, 8) + ShdHit
          Shdptr = NA
          AN$(NA) = WN$(6)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    INPUT #2, MastPath$
    CLOSE 2
    EA = -(ArmAdj + ShdAdj)
    MD%(0, 8) = ArmHit + ShdHit
    IF NA > NZ THEN
        MD%(0, 10) = MD%(0, 2) * 2 + WC%(1) + WA%(WT%(1)) + (EA + AE) * ABS(-EA > AE)
        MD%(0, 7) = 0
        MD%(0, 9) = NZ + 1
        MD%(0, 11) = WD%(1)
        MD%(0, 12) = WS%(1)
        MD%(0, 14) = 3
    END IF

    '------- (end of include file) -------    
 ' 
    GOSUB OPEN.DESC
    GOSUB OPEN.RMNAMES
    GOSUB OPEN.ROOMS
    FOR S = 1 TO 4
    S2%(S) = SA%(S)
    NEXT
    ROOM = 1
    ND = 10
    DIM DN$(10)
    FOR X = 1 TO 10
    READ DN$(X)
    NEXT
    GOTO MOVE.IT
    DATA 36
    DATA North,South,East,West,Up,Down,NE,NW,SE,SW,Get,Take,Drop,Look,Examine
    DATA Attack,Flee,Give,Inventory
    DATA Blast,Heal,Power,Speed,Smile,Wave,Say,Read,Ready,Open,Put,Free
    DATA Close,Wear,Save,Restore,Quit
    DATA Gargoyle,Minor Demon,Horror,Spirit,Zombie,Rabbit,Raccoon,Wolf,Cougar,Bear
' ---------------------------------------------------------------------------
Game.Over:      ' GAME.OVER
    PRINT
    PRINT "(Press any key to continue) ";
    A$ = INPUT$(1)
    PRINT
    CLOSE
    IF SPD THEN MD%(0, 2) = MD%(0, 2) / 2
    IF DIE <> 0 AND SAVED <> 0 THEN
	PRINT "Do you want to restart (Y/N)  ";
	YN$ = INPUT$(1)
	IF UCASE$(YN$) = "Y" THEN RUN
    END IF
    IF DIE <> 0 THEN GOTO GET.MASTER
    GOSUB CHK.SUCCESS
    FOR W = 1 TO 4
    WN$(W) = "NONE"
    NEXT
    W2 = 1
    FOR A = 1 TO NA
    IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 AND AD%(A, 4) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, 4) = 0
    NEXT A
    IF W2 < 6 THEN GOTO SELL.TREASURE
PLAYER.RETURNS:
    CLS
    LOCATE 5, 1
    PRINT "As you start to enter the royal palace, Lord Harvey Killabrew appears and"
    PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
    PRINT
    PRINT "Your weapons are--"
    FOR W = 1 TO W2 - 1
    PRINT SPC(4); W; "--"; WN$(W)
    NEXT
    PRINT
    PRINT "Enter the number of the weapon to sell  (1-"; W2 - 1; ") "
SELL.WEAPON:
    LOCATE CSRLIN - 1, 53
    INPUT A$
    W5 = VAL(A$)
    IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO SELL.WEAPON
    AD%(WP%(W5), 4) = -1
    WN$(W5) = WN$(W2 - 1)
    WP%(W5) = WP%(W2 - 1)
    W2 = W2 - 1
    IF W2 > 5 THEN GOTO PLAYER.RETURNS
SELL.TREASURE:
    IF MD%(0, 8) > AC THEN MD%(0, 8) = AC
    FOR W = 1 TO 4
    IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
    NEXT W
    CLS
    LOCATE 5, 1
    PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
    PRINT "things, he examines your goods and pays you ";
    TP = 0
    FOR A = 1 TO NA
    IF A = ArmPtr OR A = ShdPtr THEN GOTO NEXT.TREASURE 
    IF AD%(A, 4) <> -1 THEN GOTO NEXT.TREASURE
    IF AD%(A, 2) <> 0 THEN AD%(A, 1) = AD%(A, 1) * CH / 10
    TP = TP + AD%(A, 1)
NEXT.TREASURE:
    NEXT A
    PRINT TP; " gold pieces."
    PRINT
    GOLD& = GOLD& + TP
    IF GOLD& < 0 THEN GOLD& = 0
    PRINT
    PRINT "(Press any key to continue)  ";
    A$ = INPUT$(1)
    PRINT
GET.MASTER:
    CLS
    LOCATE 5, 1
 '  PRINT "  Insert Eamon Master Diskette, and press <RETURN>  OR     "
 '  PRINT
 '  PRINT "  Enter Path of Master ===> ";
 '  INPUT "", MastPath$
    IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
    IF MastPath$ <> "" THEN CHDIR MastPath$
    ON ERROR GOTO Invalid.Path
    IF DIE THEN KILL "ADVENT": RUN "WORLD"
    CLOSE
    GOSUB OPEN.CHARACTERS
    Nam$ = MN$(0)
    HD = MD%(0, 1)
    AG = MD%(0, 2)
    GOSUB WRITE.CHARACTER
    CLOSE
    OPEN PATH$ + "ADVENT" FOR OUTPUT AS #1
    PRINT #1, MN$(0)
    PRINT #1, REC
    CLOSE
    RUN "HALL"
Invalid.Path:
    PRINT
    PRINT "Invalid Path, or Master Not Found. Please re-try ..."
    PRINT " (press any key to continue)";
    A$ = INPUT$(1)
    RESUME GET.MASTER
QUIT.RTN:
    PRINT "Do you want to Quit this game? (Y/N) ";
    A$ = INPUT$(1)
    IF UCASE$(A$) = "N" THEN GOTO GET.COMMAND
    CLOSE
    END
CHK.SUCCESS:
'    /// SUCCESSFUL?
    IF AD%(23, 4) = -1 AND RC THEN PGPRT 2, "The wizard takes back his Orb and congratulates you on a job well done.": GOTO MISSION.OVER
    IF AD%(23, 4) = -1 THEN PGPRT 2, "The wizard uses the power of the Orb to set the Eamon world aright. Well done.": GOTO MISSION.OVER
    PGPRT 2, "The wizard is very disappointed in you. He asks the King to send him another volunteer."
    GOTO MISSION.OVER
MISSION.OVER:
    PRINT
    PRINT " (PRESS ANY KEY)      ";
    A$ = INPUT$(1)
    PRINT
    RETURN
' --------------------------------------------------------------------------
MOVE.RTN:      ' MOVE.RTN
'     ///MOVE
    IF IV = 0 THEN
	IF NBTL AND S$ <> "FLEE" THEN
	    IF TT = 0 THEN
		PGPRT 2, "You can't do that with unfriendlies about!"
		GOTO MAIN.LOOP
	    END IF
	END IF
    END IF
    D = C
    R2 = RD%(D)
    IF R2 > 100 AND R2 < 200 THEN GOTO PASSAGE.BLOCKED
    IF R2 = 29 AND ROOM = 1 THEN R = 23: GOSUB PRINT.EFFECT: R2 = 29: GOTO MOVE.IT
CHK.SPECIAL.MOVES:      ' CHK.SPECIAL.MOVES
    IF R2 > 0 AND R2 <= NR THEN GOTO MOVE.IT
'     /// SPECIAL MOVES
    IF R2 = -99 THEN PGPRT 2, "You successfully ride off into the sunset.": GOTO Game.Over
    IF R2 = 0 THEN GOTO CANT.GO
    IF R2 = 201 THEN R = 4: GOSUB PRINT.EFFECT: DIE = -1: GOTO Game.Over
'    /// INSERT HERE SPECIAL ROOM MOVE CHECKING
    GOTO CANT.GO
PASSAGE.BLOCKED:
    GT = R2 - 100
    IF GT = 13 AND IC THEN AD%(GT, 4) = 0
    IF AD%(GT, 4) <> ROOM THEN R2 = AD%(GT, 5): GOTO CHK.SPECIAL.MOVES
    PGPRT 2, "The " + AN$(GT) + " blocks the way!"
    GOTO MAIN.LOOP
CANT.GO:
    PGPRT 2, "You can't go that way!"
    V%(ROOM) = 0
    GOTO MAIN.LOOP
MOVE.IT:
    IF R2 = 51 AND WT > 10 THEN R = 5: GOSUB PRINT.EFFECT: DIE = -1: GOTO Game.Over
    R3 = ROOM
    ROOM = R2
    GOSUB CHK.REACTIONS
    IF ROOM = 3 THEN GOTO MAKE.EXITS
    IF ROOM = 57 THEN GOTO MAKE.RANDOM.EXITS
    GET #1, ROOM
    NX = 0
    FOR X = 1 TO ND
    RD%(X) = CVI(RF.DIR$(X))
    IF ROOM = 44 OR ROOM = 38 THEN GOTO COUNT.EXITS
    IF RD%(X) < 0 AND RD%(X) > -NR AND V%(ROOM) > 1 THEN RD%(X) = ABS(RD%(X))
COUNT.EXITS:      ' COUNT.EXITS
    IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
    NEXT
    DD = VAL(RF.DD$)
    GOTO END.LOOP
CHK.REACTIONS:
    TD%(1) = 0
    TD%(3) = MD%(0, 1)
    FD%(1) = 0
    FD%(3) = MD%(0, 13)
    FOR M = 1 TO NM
    IF MD%(M, 15) = 2 AND MD%(M, 5) = ROOM THEN GOTO MONSTER.NOT.HERE
    IF M = 22 THEN GOTO MONSTER.REACTS
    IF MD%(M, 5) = R3 THEN IF MD%(M, 14) = 3 OR (MD%(M, 14) = 1 AND 200 * RND(1) < MD%(M, 4)) THEN MD%(M, 5) = ROOM: GOTO ADD.SIDES
MONSTER.REACTS:      ' MONSTER.REACTS
    IF MD%(M, 5) <> ROOM THEN GOTO MONSTER.NOT.HERE
    IF MD%(M, 14) THEN GOTO ADD.SIDES
    FR = MD%(M, 3)
    IF FR AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
    MD%(M, 14) = 1
    IF FR > (100 * RND(1)) THEN MD%(M, 14) = 2: IF FR > (100 * RND(1)) THEN MD%(M, 14) = 3
ADD.SIDES:      ' ADD.SIDES
    A = MD%(M, 14)
    FD%(A) = FD%(A) + MD%(M, 13)
    TD%(A) = TD%(A) + MD%(M, 1)
MONSTER.NOT.HERE:
    NEXT
    GOTO SET.NBTL
MAKE.RANDOM.EXITS:      ' MAKE.RANDOM.EXITS
    FOR X = 1 TO ND
    RD%(X) = 0
    NEXT
    RD%(NX) = 62
    RD%(ND - NX + 1) = 27
    NX = NX - 1
    IF NX < 1 THEN NX = ND
    GOTO END.LOOP
SET.NBTL:      ' SET.NBTL
    NBTL = (TD%(1) > 0)
    RETURN
MAKE.EXITS:      ' MAKE.EXITS
    FOR R = 1 TO ND
    RD%(R) = 0
    NEXT
    NX = INT(RND(1) * 8) + 1
    FOR D = 1 TO NX
    RD%(INT(RND(1) * 8)) = 3
    NEXT
    IF INT(RND(1) * 100) > 50 THEN RD%(INT(RND(1) * 8)) = 35
    IF INT(RND(1) * 100) < 89 OR MD%(17, 5) <> 0 THEN GOTO MAIN.LOOP
    GOSUB BRING.IN.BEASTS
    GOTO MAIN.LOOP
BRING.IN.BEASTS:
  ' BRING.IN.BEASTS
  '    IF IN ROOM 3 (FOREST), BEASTS ARE WEAKER THAN IF IN DREAM DIMENSION
    MF = INT(RND(1) * 5 + 1) + 5 * ABS(ROOM = 3)
    D = ABS(ROOM <> 3) * 8 + 17
    MD%(D, 5) = ROOM
    MD%(D, 1) = (MF + (5 * ABS(ROOM <> 3)) - (5 * ABS(ROOM = 3))) * 4 + 1
    MN$(D) = DN$(MF)
    MD%(D, 13) = 0
    MD%(D, 9) = 0
    GOSUB CHK.REACTIONS
    RETURN
' --------------------------------------------------------------------------
GET.RTN:
    GOSUB GET.SUBJ
    IF (IC AND DD = 0) THEN PGPRT 2, "You can't find anything.": GOTO MAIN.LOOP
    IF S$ = "ALL" THEN GOTO GET.ALL
    IF S$ = "BOOKS" AND ROOM = 2 AND AD%(3, 4) > 200 THEN PGPRT 2, "There is only one loose one.": GOTO MAIN.LOOP
    IF S$ = "BOOKS" AND ROOM = 2 THEN PGPRT 2, "They are held fast.": GOTO MAIN.LOOP
    EMB = ROOM + 200
    WH = ROOM
    HA = ROOM
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "I see no " + LCASE$(S$) + " here!": GOTO MAIN.LOOP
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO MAIN.LOOP
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, "You can't budge it!": GOTO MAIN.LOOP
    PGPRT 2, "Got it."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
    IF (AD%(A, 2) = 2 OR AD%(A, 2) = 3) AND MD%(0, 9) = -1 THEN GOTO CALCULATE.ODDS
    GOTO GET.BACK
GET.ALL:      ' GET.ALL
    FOR A = 1 TO NA
    IF AD%(A, 4) <> ROOM OR AD%(A, 2) = 10 THEN GOTO GET.NEXT
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO GET.NEXT
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, AN$(A) + " can't be moved.": GOTO GET.NEXT
    PGPRT 1, AN$(A) + " taken."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
GET.NEXT:      ' GET.NEXT
    NEXT
    SR = 0
    GOTO GET.BACK
GET.SURPRISE:      ' GET.SURPRISE
'    /// INSERT HERE SPECIAL EFFECTS OF PICKING SOMETHING UP
    GT = 1
    IF A = 10 AND MD%(6, 5) = ROOM THEN R = 19: GOSUB PRINT.EFFECT: GT = 0: RETURN
    IF IV THEN GOSUB RATTLE.MONSTER
    IF A = 9 AND IV = 0 THEN GT = 0: PGPRT 2, "You can't!": RETURN
    IF A = 39 AND AD%(32, 4) > 200 THEN AD%(32, 4) = ROOM
    IF A = 9 THEN AD%(9, 4) = 0: AD%(23, 4) = ROOM: A = 23: RETURN
    RETURN
RATTLE.MONSTER:      ' RATTLE.MONSTER
    FOR M = 1 TO NM
    IF MD%(M, 5) = ROOM THEN PGPRT 1, MN$(M) + " is slightly unnerved!": MD%(M, 4) = MD%(M, 4) - 10
    NEXT
    RETURN
SPECIAL.ROOM.CHK:      ' SPECIAL.ROOM.CHK
'    /// SPECIAL ROOM?
    GET #2, ROOM
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    IF ROOM = 13 THEN R = 7: GOSUB PRINT.EFFECT
    IF ROOM = 50 THEN R = 15: GOSUB PRINT.EFFECT
    IF ROOM = 34 THEN R = 32: GOSUB PRINT.EFFECT: DIE = -1: GOTO Game.Over
    V%(ROOM) = V%(ROOM) + 1
    RETURN
' ---------------------------------------------------------------------------
MONSTER.SEARCH:
    WH = ROOM
    HA = -1
    EMB = ROOM
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NM
    IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = WH OR MD%(X, 5) = HA) THEN FOUND = FOUND + 1: M = X: IF S$ = MN$(X) THEN X = 9999
    NEXT
    RETURN
' ---------------------------------------------------------------------------
ARTIFACT.SEARCH:
    WH = ROOM
    HA = -1
    EMB = ROOM
LOCATE.ARTIFACT:
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NA
    IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = HA OR AD%(X, 4) = EMB) THEN FOUND = FOUND + 1: A = X: IF S$ = AN$(X) THEN X = 9999
    NEXT
    RETURN
' --------------------------------------------------------------------------
GET.SUBJ:
    WHILE S$ = ""
      PRINT
      PRINT C$(C); " Who or What";
      INPUT S$
      PGPRT 2, ""
    WEND
    S$ = UCASE$(S$)
    RETURN
' --------------------------------------------------------------------------
DROP.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO DROP.ALL
    WH = -1
    HA = -1
    EM = -1
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying a " + LCASE$(S$) + "!": GOTO MAIN.LOOP
    WT = WT - AD%(A, 3)
    AD%(A, 4) = ROOM
    PGPRT 2, AN$(A) + " dropped."
    GOSUB DROP.SPECIAL
CHK.WGHT:      ' CHK.WGHT
    IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAPON:      ' CHK.DROP.WEAPON
    IF MD%(0, 9) > 0 THEN IF AD%(MD%(0, 9), 4) <> -1 THEN MD%(0, 9) = -1
    GOTO GET.BACK
DROP.ALL:       ' DROP.ALL
    SR = ROOM
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN PGPRT 2, AN$(A) + " dropped.": AD%(A, 4) = ROOM: GOSUB DROP.SPECIAL
    NEXT
    WT = 0
    GOTO CHK.DROP.WEAPON
DROP.SPECIAL:      ' DROP.SPECIAL
'    /// DROP SPECIAL?
    IF A = 11 AND ROOM = 56 THEN R = 22: GOSUB PRINT.EFFECT: R = 1: AD%(A, 4) = 0: RC = 1
    IF A = 8 AND MD%(13, 5) = ROOM THEN R = 25: GOSUB PRINT.EFFECT: AD%(8, 4) = 0: AD%(31, 4) = ROOM: MD%(13, 3) = 0: MD%(13, 14) = 0: GOTO CHK.REACTIONS
    IF A = 8 THEN R = 26: GOSUB PRINT.EFFECT: AD%(8, 4) = 0: AD%(31, 4) = ROOM: RETURN
    IF A = 11 THEN IV = 0: VC = 0
    IF IV THEN GOSUB RATTLE.MONSTER
    RETURN
' ---------------------------------------------------------------------------
LOOK.RTN:
    IF IC AND DD = 0 THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    LK = 0
    IF S$ = "" THEN GOTO GENERAL.LOOK
    GOSUB EXAMINE.NONART
    IF LK THEN GOTO GET.BACK
    WH = ROOM
    HA = -1
    EMB = ROOM + 200
    GOSUB LOCATE.ARTIFACT
    IF FOUND AND AD%(A, 4) = EMB THEN AD%(A, 4) = ROOM
    IF FOUND THEN GOSUB EXAMINE.ARTIFACT: GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOSUB EXAMINE.MONSTER
GENERAL.LOOK:      ' GENERAL.LOOK
    IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
    IF ROOM = 3 THEN GOTO FIND.CLEARING
    FOR A = 1 TO NA
    IF AD%(A, 4) = 300 + ROOM THEN LK = -1: GOSUB FIND.ARTIFACT
    NEXT
    IF LK THEN PGPRT 2, "You found something.": GOTO GET.BACK
    IF ROOM = 38 OR ROOM = 44 THEN GOTO NOTHIN.TA.SEE
    FOR X = 1 TO ND
    IF RD%(X) < 0 AND RD%(X) >= -NR THEN GOSUB SECRET.PASSAGE
    NEXT
NOTHIN.TA.SEE:      ' NOTHIN.TA.SEE
    V%(ROOM) = 0
    GOTO GET.BACK
EXAMINE.MONSTER:      ' EXAMINE.MONSTER
    IF M = 22 THEN IF AD%(35, 4) = 0 THEN AD%(35, 4) = ROOM: RETURN
    R = M + 100
    GOSUB PRINT.EFFECT
    RETURN
EXAMINE.NONART:      ' EXAMINE.NONART
'    == EXAMINE S$
    IF (S$ = "FIREPLACE" OR S$ = "STONE FIREPLACE") AND ROOM = 44 THEN R = 29: GOSUB PRINT.EFFECT: RD%(2) = 46: LK = -1: RETURN
    IF (S$ = "SHELF" OR S$ = "SHELVES") AND ROOM = 38 THEN R = 30: GOSUB PRINT.EFFECT: RD%(2) = 8: LK = -1: RETURN
    IF LEFT$(S$, 4) = "BEAR" AND ROOM = 44 AND AD%(40, 4) = 0 THEN PGPRT 2, "You find a paper stuffed in its mouth!": AD%(40, 4) = ROOM: LK = -1: RETURN
    IF LEFT$(S$, 5) = "TABLE" AND ROOM = 25 AND AD%(39, 4) > 200 THEN AD%(39, 4) = ROOM: LK = -1: RETURN
    IF (LEFT$(S$, 5) = "FEATH" OR LEFT$(S$, 6) = "MATTRE") AND ROOM = 1 THEN PGPRT 2, "The feathers are nice!": RETURN
    IF S$ = "BED" THEN PGPRT 2, "The bed is soft.": RETURN
    IF LEFT$(S$, 4) = "SILK" THEN PGPRT 2, "Nice, huh?": RETURN
    RETURN
SECRET.PASSAGE:      ' SECRET.PASSAGE
'     == SECRET PASSAGE ==
    RD%(X) = ABS(RD%(X))
    V%(ROOM) = 2
    IF ROOM = 1 THEN PGPRT 2, "You discover a sliding panel on the east wall.": RETURN
    IF LK = 0 THEN PGPRT 2, "You found a secret passage " + C$(X) + "!": NX = NX + 1
    RETURN
EXAMINE.ARTIFACT:      ' EXAMINE.ARTIFACT
'     === EXAM ART A
    IF A > NZ THEN PGPRT 2, "This is your " + AN$(A) + "."
    IF A > NZ - NM THEN PGPRT 2, "Yes, he's dead!": RETURN
    IF A = 8 THEN R = 10: GOTO PRINT.EFFECT
    IF A = 6 AND AN$(6) = "SILVER TUBE" THEN AN$(6) = "SWORD OF LIGHT": R = 24: GOSUB PRINT.EFFECT: LK = -1: RETURN
    IF A = 18 THEN R = 12: GOSUB PRINT.EFFECT: RETURN
    IF A = 33 AND AD%(5, 4) = 0 THEN PGPRT 2, "You find something on the log!": AD%(5, 4) = ROOM: RETURN
    GET #2, A + 100
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    LK = -1
    AD%(A, 9) = 1
    RETURN
FIND.ARTIFACT:      ' FIND.ARTIFACT
'      == DISCOVER ARTIFACT A HIDDEN IN ROOM!
'    --- INSERT HERE ANY SPECIAL DISCOVERY MESSAGES ---
'        SUCH AS "YOU FOUND SOMETHING UNDER THE BED"
    LK = -1
    AD%(A, 4) = ROOM
    RETURN
FIND.CLEARING:      ' FIND.CLEARING
    FOR X = 1 TO ND
    IF RD%(X) <> 3 AND RD%(X) <> 0 THEN PGPRT 2, "You see a slight clearing " + C$(X) + "!"
    NEXT
    GOTO MAIN.LOOP
' ---------------------------------------------------------------------------
ATTACK.RTN:
'    ATTACK
    GOSUB GET.SUBJ
    IF IC AND DD = 0 THEN PGPRT 2, "You swing wild --- nothing hit.": GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOTO ATTACK.MON
    TA = 0
    GOTO ASSAULT.ARTIFACT
ATTACK.MON:
    IF MD%(0, 9) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO MAIN.LOOP
    OF = 0
    DF = M
    GOSUB TAKE.A.SWING
    IF HIT = 0 THEN GOTO MISSED
    IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
    IF -EA <= AE THEN GOTO GET.BACK
    IF INT(100 * RND(1) + 1) <= MD%(0, 10) THEN GOTO MISSED
    A = 2
    IF EA + AE = -1 THEN A = 1
    AE = AE + A
    MD%(0, 10) = MD%(0, 10) + A
MISSED:
    IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO GET.BACK
    MD%(DF, 3) = MD%(DF, 3) / 2
    FOR M = 1 TO NM
    IF MD%(M, 5) = ROOM AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
    NEXT
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
MON.GET.GUN:      ' MON.GET.GUN
'    -- MONSTER PICK-UP WEAPON
    IF MD%(OF, 10) = 0 THEN RETURN
    A = 0
    FOR X = 1 TO NA
    IF AD%(X, 4) = ROOM AND (AD%(X, 2) = 2 OR AD%(X, 2) = 3) THEN A = X: X = NA
    NEXT
    IF A = 0 THEN RETURN
    PGPRT 2, MN$(OF) + " picks up " + AN$(A) + "."
    AD%(A, 4) = 0
    MD%(OF, 9) = A
    MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5)
    MD%(OF, 4) = MD%(OF, 4) * 2
    RETURN
TAKE.A.SWING:
    HIT = 0
    IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
    IF DF = 0 AND IV THEN RETURN
    PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
    PRINT " --";
    RL = INT(100 * RND(1) + 1)
    HIT = 0
    IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = 1
    IF HIT THEN GOTO A.HIT
    IF RL < 97 THEN PGPRT 1, " A miss!": RETURN
    PGPRT 1, "A fumble!"
    FR = INT(100 * RND(1) + 1)
    IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PGPRT 1, "   fumble recovered.": RETURN
    IF FR < 76 THEN
	PGPRT 1, "  weapon dropped!"
	AD%(MD%(OF, 9), 4) = ROOM
	MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
	MD%(OF, 9) = -1
	MD%(OF, 4) = MD%(OF, 4) / 2
	RETURN
    END IF
    IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PGPRT 1, "Sparks fly from " + AN$(W) + "!": RETURN
    IF FR > 95 THEN GOTO SELF.OUCH
    PGPRT 1, "  weapon breaks!"
    AD%(MD%(OF, 9), 4) = 0
    MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
    MD%(OF, 9) = -1
    MD%(OF, 4) = MD%(OF, 4) / 2
    IF RND(1) > .5 THEN RETURN
    PGPRT 1, "  broken weapon hurts user!"
SELF.OUCH:
    IF FR = 100 THEN GOTO SELF.YEOW
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    DF = OF
    A = 1
    GOTO DO.DAMAGE
SELF.YEOW:
    D = MD%(OF, 11) * 2
    S = MD%(OF, 12)
    DF = OF
    A = 0
    GOTO DO.DAMAGE
A.HIT:
    INC = ABS(INT(100 * RND(1) + 1) > MD%(OF, 10))
    MD%(OF, 10) = MD%(OF, 10) + 2 * INC
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    A = 1
    IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO DO.DAMAGE
    PGPRT 1, "A critical hit!"
    R2 = INT(100 * RND(1) + 1)
    IF R2 < 51 THEN A = 0: GOTO DO.DAMAGE
    IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
    IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
    IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
    GOTO IS.DEAD
DO.DAMAGE:      ' DO.DAMAGE
    D2 = 0
    FOR D3 = 1 TO D
    D2 = D2 + INT(S * RND(1) + 1)
    NEXT
    D2 = D2 - A * MD%(DF, 8)
    IF DF > 8 AND DF < 13 AND OF = 0 AND MD%(0, 9) = 6 THEN D2 = D2 + 2
    IF D2 < 1 THEN PGPRT 1, "   blow bounces off armour.": RETURN
APPLY.DAMAGE:      ' APPLY.DAMAGE
    MD%(DF, 13) = MD%(DF, 13) + D2
    IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO DEAD.RTN
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + D2
SHOW.CONDITION:
    A$ = MN$(DF)
    ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:      ' GOOD.SHAPE
    PGPRT 2, A$ + " is still in good shape."
    RETURN
HURTING:      ' HURTING
    PGPRT 2, A$ + " is hurting."
    RETURN
IN.PAIN:      ' IN.PAIN
    PGPRT 2, A$ + " is in pain."
    RETURN
BADLY.INJURED:      ' BADLY.INJURED
    PGPRT 2, A$ + " is very badly injured."
    GOTO CALLS.HELP
DEATHS.DOOR:      ' DEATHS.DOOR
    PGPRT 2, A$ + " is at death's door, knocking loudly."
    GOTO CALLS.HELP
CALLS.HELP:      ' CALLS.HELP
    IF SCR THEN RETURN
    IF ((DF > 8 AND DF < 13) OR (DF = 1)) AND MD%(25, 5) <> ROOM THEN PGPRT 1, MN$(DF) + " waves his hand and ...": R = 27: GOSUB PRINT.EFFECT: GOSUB BRING.IN.BEASTS
    RETURN
DEAD.RTN:      ' DEAD.RTN
    IF DF = 0 THEN PGPRT 2, "You are dead!": GOTO GET.BODY
IS.DEAD:      ' IS.DEAD
'    /// MONSTER DIES
    PGPRT 2, MN$(DF) + " is dead!"
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
    MD%(DF, 5) = 0
    IF DF = 1 THEN FL = -1
    IF DF = 17 THEN RETURN
    FOR AJ = 1 TO NA
    IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = ROOM
    NEXT
    IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = ROOM: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
GET.BODY:
    IF DF = 0 THEN DIE = 1: GOTO Game.Over
    A2 = DF + NZ - NM
    AD%(A2, 4) = ROOM
    RETURN
FLEE.RTN:
    IF NBTL = 0 THEN PGPRT 2, "There's nothing to flee from!": GOTO MAIN.LOOP
    FOR D = 1 TO ND
    IF S$ = UCASE$(C$(D)) THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
    NEXT
    IF NX = 0 THEN PGPRT 2, "There's no place to go!": GOTO MAIN.LOOP
    IF ROOM = 13 THEN R2 = 11: GOTO MOVE.IT
    GOSUB FIND.EXIT
    GOTO MOVE.IT
FIND.EXIT:
    IF NX = 0 THEN R2 = ROOM: PGPRT 1, " ... but can't find an exit!": RETURN
    R2 = RD%(ND * RND(1) + 1)
    IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
    RETURN
' ---------------------------------------------------------------------------
GIVE.RTN:
    IF S$ = "" THEN GOSUB GET.SUBJ
    A = 0
    M = 0
    M$ = ""
    A$ = ""
    SEP = INSTR(S$, " TO ")
    IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
    END IF
    SEP = INSTR(S$, " ")
    IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF FOUND THEN
	      M$ = S$
	      A$ = MID$(SAVE.S$, SP)
	      GOTO READY.SEARCH.GIVE
	  END IF
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
	    A$ = MID$(S$, SEP + 1)
	    M$ = LEFT$(S$, SEP - 1)
	ELSE
	    GOSUB GIVE.WHO
	    GOSUB GIVE.WHAT
	END IF
    ELSE
	GOSUB ARTIFACT.SEARCH
	IF FOUND THEN
	    A$ = AN$(A)
	ELSE
	    GOSUB MONSTER.SEARCH
	    IF FOUND THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
	    END IF
	END IF
    END IF
READY.SEARCH.GIVE:
    GOSUB GIVE.WHO
    GOSUB GIVE.WHAT
    IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
    END IF
    IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
	    S$ = A$
	    GOSUB ARTIFACT.SEARCH
	END IF
    END IF
    IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
    IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
    PGPRT 2, "I don't know what you mean."
    GOTO MAIN.LOOP
RESOLVE.GIVE:      ' RESOLVE.GIVE
    PGPRT 2, "Okay."
    POP = 0
    GOSUB GIVE.ART.MON
    IF POP <> 0 THEN GOTO MAIN.LOOP
    IF A = MD%(0, 9) THEN MD%(0, 9) = -1
    AD%(A, 4) = -M - 1
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
    IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO CHK.WGHT
GIVE.GOLD:
    IF VAL(A$) > GOLD& THEN PGPRT 2, "You aren't carrying that much gold!": GOTO GET.BACK
    GOLD& = INT(GOLD& - VAL(A$))
    MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
    GOTO COMPLETE.GIVE
GIVE.WHO:
    IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
    RETURN
GIVE.WHAT:
    IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
    RETURN
GIVE.ART.MON:
    IF A = 10 AND M = 5 THEN PGPRT 2, "The witch takes it and gives you something.": AD%(14, 4) = -1: MD%(5, 3) = 100: MD%(5, 14) = 0: RETURN
    IF A = 5 AND M = 6 AND AD%(10, 4) = ROOM THEN PGPRT 2, "The council takes the key and hands you the box.": AD%(10, 4) = -1: AD%(5, 4) = -7: POP = -1: GOTO CHK.WGHT
    IF M = 5 THEN MD%(5, 3) = 0
    IF M = 13 THEN PGPRT 2, MN$(13) + " says 'No thanks.'": POP = -1: RETURN
    RETURN
' ---------------------------------------------------------------------------
INVENTORY.RTN:
    IF IV THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    PGPRT 2, "You are carrying the following--"
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN
	PRINT " "; AN$(A);
	IF A = MD%(0, 9) THEN PRINT " (Ready weapon)";
	IF A = ArmPtr THEN PRINT " (Your Armor)";
	IF A = ShdPtr THEN PRINT " (Your Shield)";
	PGPRT 1, " "
    END IF
    NEXT
    PGPRT 1, STR$(GOLD&) + " gold pieces."
    GOTO GET.BACK
' --------------------------------------------------------------------------
BLAST.SPELL:
    GOSUB GET.SUBJ
    GOSUB MONSTER.SEARCH
    IF FOUND = 0 THEN GOTO BLASTED.DOOR
    S = 1
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    PGPRT 2, "Direct Hit!"
    IF M = 12 THEN PGPRT 2, "The demon crumbles to dust!": MD%(M, 5) = 0: GOSUB MONSTER.LEAVES: GOTO GET.BACK
    S = 5
    D = 2
    DF = M
    A = 0
    GOSUB DO.DAMAGE
    GOTO GET.BACK
BLASTED.DOOR:
'    /// BLAST DOOR/GATE OR CONTAINER?
    TA = 1
    GOTO ASSAULT.ARTIFACT
' ---------------------------------------------------------------------------
CAST.SPELL:
    SUC = 0
    IF SA%(S) THEN RL = INT(100 * RND(1) + 1): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN SUC = 0
    IF SUC = 0 THEN PGPRT 2, "Nothing happened.": RETURN
    RL = INT(100 * RND(1) + 1)
    IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
    S2%(S) = S2%(S) * .8
    RETURN
' ---------------------------------------------------------------------------
HEAL.SPELL:
    S = 2
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    M = 0
    IF S$ <> "" THEN GOSUB MONSTER.SEARCH
    IF MD%(M, 13) THEN
	PGPRT 2, "Some of " + MN$(M) + "'s wounds seem to clear up."
	MD%(M, 13) = MD%(M, 13) - INT(10 * RND(1) + 1)
    END IF
    IF MD%(M, 13) < 0 THEN MD%(M, 13) = 0
    DF = M
    GOSUB SHOW.CONDITION
    GOTO GET.BACK
' --------------------------------------------------------------------------
POWER.SPELL:
    S = 4
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    RR = INT(RND(1) * 100 + 1)
    IF ROOM = 68 THEN R = 34: GOSUB PRINT.EFFECT: R2 = 65: GOTO MOVE.IT
' --------------------------------------------------------------------------
SPEED.SPELL:
    S = 3
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    IF SPD = 0 THEN MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2): MD%(0, 2) = 2 * MD%(0, 2)
    SPD = SPD + INT(25 * RND(1) + 10)
    PGPRT 2, "You can feel the new agility flowing through you!"
    GOTO GET.BACK
' --------------------------------------------------------------------------
SMILE.RTN:
    IF IC AND DD = 0 THEN PGPRT 2, "You " + LCASE$(C$(C)) + ".": GOTO MAIN.LOOP
    IF IV THEN GOTO GET.BACK
    PGPRT 1, " "
    FOR M = 1 TO NM
      IF MD%(M, 5) = ROOM AND MD%(M, 15) <= 1 THEN
	  ON MD%(M, 14) GOSUB GROWLS, IGNORES, SMILES
      END IF
    NEXT
    PGPRT 1, " "
    GOTO GET.BACK
GROWLS:
    IF M = BLIND.PRIEST THEN PGPRT 1, " The Blind Priest can't see.": RETURN
    PGPRT 1, MN$(M) + " growls at you!"
    RETURN
IGNORES:
    IF M = BLIND.PRIEST THEN PGPRT 1, " The Blind Priest can't see.": RETURN
    PGPRT 1, MN$(M) + " ignores you."
    RETURN
SMILES:
    IF M = BLIND.PRIEST THEN PGPRT 1, " The Blind Priest can't see.": RETURN
    PGPRT 1, MN$(M) + " " + LCASE$(C$(C)) + "s back."
    RETURN
' --------------------------------------------------------------------------
SAY.SOMETHING:
    GOSUB GET.SUBJ
    IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
    IF S$ = "HEAL" THEN GOTO HEAL.SPELL
    IF S$ = "POWER" THEN GOTO POWER.SPELL
    IF S$ = "SPEED" THEN GOTO SPEED.SPELL
    IF S$ = MW$ AND AD%(12, 4) = -1 AND JT > 0 AND IC THEN GOTO SAY.MAGIC
    IF S$ = TW$ AND AD%(23, 4) = -1 THEN R = 1: GOSUB PRINT.EFFECT: R2 = 45: GOTO MOVE.IT
    IF S$ = CW$ AND ROOM = 45 THEN GOTO SAY.CW
    IF S$ = "REOME" AND AD%(14, 4) = -1 THEN FOR X = 1 TO ND: RD%(X) = -99: NEXT: PGPRT 2, "Magic exits open in all directions!": GOTO GET.BACK
    IF S$ = "ROVATHA" AND MD%(2, 5) = ROOM THEN GOTO SAY.ROVATHA
    GOTO MINDLESS.DRIVEL
SAY.MAGIC:
'    === ENTER D.D.
    IF ROOM = 50 THEN R = 11: GOSUB PRINT.EFFECT: R2 = 49: GOTO MOVE.IT
    IF ROOM = 49 THEN R = 11: GOSUB PRINT.EFFECT: R2 = 50: INSANE = 10: GOTO MOVE.IT
    GOTO MINDLESS.DRIVEL
SAY.ROVATHA:
    IF SR THEN GOTO FETCH.YOUR.STUFF
    IF AD%(10, 4) = ROOM THEN A = 10: GOTO HERO.STEALS
    IF AD%(9, 4) = ROOM THEN R = 20: GOSUB PRINT.EFFECT: M = 2: GOSUB MONSTER.LEAVES: MD%(M, 5) = 0: GOTO MAIN.LOOP
    IF AD%(23, 4) = ROOM THEN A = 23: GOTO HERO.STEALS
    IF MD%(9, 5) = ROOM AND AD%(11, 4) = -10 THEN A = 11: GOTO HERO.STEALS
    PGPRT 2, "Nothing happens."
    GOTO MAIN.LOOP
HERO.STEALS:
    A$ = "into your hands"
HERO.WORKS:
    PGPRT 2, "Hero circles the room, picks up " + AN$(A)
    PGPRT 1, "and drops it " + A$ + "!"
    IF A <> 0 THEN AD%(A, 4) = -1
    GOTO GET.BACK
SAY.CW:
    IF AD%(11, 4) = ROOM THEN R = 22: GOSUB PRINT.EFFECT: RC = 1: AD%(11, 4) = 0: GOTO GET.BACK
    IF IV THEN PGPRT 2, "You flash visible and invisible as the cloak spins around your neck!": GOSUB RATTLE.MONSTER: GOTO GET.BACK
MINDLESS.DRIVEL:
    PGPRT 2, "Okay, " + CHR$(34) + S$ + CHR$(34)
    IF IV THEN GOSUB RATTLE.MONSTER
    GOTO GET.BACK
FETCH.YOUR.STUFF:
    FOR X = 1 TO NA
    IF AD%(X, 4) = SR THEN AD%(X, 4) = ROOM
    NEXT
    SR = 0
    A = 0
    AN$(A) = "your stuff"
    A$ = "at your feet"
    GOTO HERO.WORKS
' --------------------------------------------------------------------------
READY.WEAPON:
    GOSUB GET.SUBJ
    WH = -1
    HA = WH
    EM = HA
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO MAIN.LOOP
    IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PGPRT 2, "That isn't a weapon!": GOTO MAIN.LOOP
CALCULATE.ODDS:
    MD%(0, 10) = (EA + AE) * ABS(-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
    MD%(0, 9) = A
    MD%(0, 11) = AD%(A, 7)
    MD%(0, 12) = AD%(A, 8)
    PGPRT 2, "Readied."
    GOTO GET.BACK
' --------------------------------------------------------------------------
OPEN.RTN:
    GOSUB GET.SUBJ
    POP = 0
    GOSUB CHK.OPEN.SPECIAL
    IF POP THEN GOTO MAIN.LOOP
    WH = ROOM
    HA = -1
    EMB = ROOM + 200
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN GOTO CHK.OPEN.DOOR
    IF A = 10 THEN GOTO OPEN.CONTAINER
    IF AD%(A, 2) = 4 THEN GOTO OPEN.CONTAINER
    IF AD%(A, 2) = 7 THEN PGPRT 2, "Try reading it.": GOTO MAIN.LOOP
    IF AD%(A, 2) = 1 THEN PGPRT 2, "You'll make a mess. Wait till you leave.": GOTO MAIN.LOOP
    IF AD%(A, 2) = 8 THEN GOTO OPEN.DOOR
    PGPRT 2, "That's not what you do with it."
    GOTO MAIN.LOOP
OPEN.EYES:
    IF IC THEN IC = 0: PGPRT 2, "You open your eyes.": GOTO EYES.ARE.OPEN
    PGPRT 2, "You already have your eyes open."
    RETURN
OPEN.CONTAINER:
'    CONT.
    IF A = 10 AND SCR = 0 THEN R = 21: GOSUB PRINT.EFFECT: SCR = 5: GOTO GET.BACK
    IF A = 10 THEN PGPRT 2, "It is already open!": GOTO MAIN.LOOP
    IF AD%(A, 5) THEN IF AD%(AD%(A, 5), 4) <> -1 THEN PGPRT 2, "It's locked!": GOTO MAIN.LOOP
    LK = 0
    FOR X = 1 TO NA
    IF AD%(X, 4) = A + 100 THEN AD%(X, 4) = ROOM: LK = -1:
    NEXT
    PGPRT 2, "You find " + MID$("nosome", ABS(LK) * 2 + 1, 2 + 2 * ABS(LK)) + "thing inside."
    GOTO GET.BACK
CHK.OPEN.DOOR:  ' LABEL.CHK.OPEN.DOOR
    IF S$ = "DOOR" OR S$ = "GATE" THEN PGPRT 2, "It will open when you approach.": GOTO MAIN.LOOP
    PGPRT 2, "I don't know how to open " + LCASE$(S$) + "."
    GOTO MAIN.LOOP
OPEN.DOOR:
'    DOOR/GATE
    IF A = 13 AND IC = 0 THEN PGPRT 2, "As you reach for the gate, the light causes your hands severe pain.": GOTO MAIN.LOOP
    IF A = 13 THEN PGPRT 2, "You don't feel any gate.": GOTO MAIN.LOOP
    IF AD%(A, 6) THEN IF AD%(AD%(A, 6), 4) <> -1 THEN PGPRT 2, "It's locked!": GOTO MAIN.LOOP
    AD%(A, 6) = 0
    PGPRT 2, "You've opened the " + AN$(A) + "."
    FOR X = 1 TO ND
    IF RD%(X) = A + 100 THEN RD%(X) = AD%(A, 5)
    NEXT
    GOTO GET.BACK
ASSAULT.ARTIFACT:
'      /// ATTACKING A CONTAINER OR DOOR?
    IF TA = 0 THEN PGPRT 2, "Attack who?": GOTO MAIN.LOOP
    PGPRT 2, "You can't blast " + LCASE$(S$) + "!"
    GOTO MAIN.LOOP
EYES.ARE.OPEN:
'    --- OPEN EYES
    IF MD%(7, 5) = ROOM THEN PGPRT 2, MN$(7) + " vanishes!": M = 7: GOSUB MONSTER.LEAVES: MD%(M, 5) = 0
    IF MD%(8, 5) = ROOM THEN PGPRT 2, MN$(8) + " vanishes!": M = 8: GOSUB MONSTER.LEAVES: MD%(M, 5) = 0
    RETURN
CHK.OPEN.SPECIAL:
    IF S$ = "EYES" OR S$ = "MY EYES" THEN POP = -1: GOTO OPEN.EYES
    IF S$ = "PANEL" OR S$ = "SLIDING PANEL" AND ROOM = 1 AND RD%(3) > 0 THEN PGPRT 2, "It's already open!": POP = -1: RETURN
    RETURN
' --------------------------------------------------------------------------
PUT.RTN:
    IF S$ = "" THEN GOTO GET.PUT.DATA
    IF INSTR(S$, " INTO") > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 6): GOTO PUT.AWAY
    IF INSTR(S$, " IN") > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 3): GOTO PUT.AWAY
GET.PUT.DATA:      ' GET.PUT.DATA
    PRINT
    INPUT "Put what?"; A$
    INPUT "Put into what?"; B$
    PGPRT 3, ""
    GOTO PUT.AWAY
PUT.AWAY:
    S$ = A$
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.UNDERSTAND
    Z = A
    S$ = B$
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 OR A = Z THEN GOTO PUT.WHAT
    IF AD%(A, 2) = 4 THEN AD%(X, 4) = A + 100: PGPRT 2, "Okay.": GOTO GET.BACK
PUT.WHAT:      ' PUT.WHAT
    PGPRT 2, "You can't do that."
    GOTO GET.BACK
' ---------------------------------------------------------------------------
READ.RTN:
    IF IC <> 0 AND DD = 0 THEN PGPRT 2, "You can't see.": GOTO MAIN.LOOP
    GOSUB GET.SUBJ
    WH = ROOM
    HA = -1
    EMB = ROOM + 200
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN GOTO READ.NONART
    IF A = 40 THEN PGPRT 2, "The paper says:": PGPRT 2, TW$: PGPRT 2, CW$: GOTO GET.BACK
    IF AD%(A, 2) = 7 THEN GOTO READ.ARTIFACT
    PGPRT 2, "You can't read it."
    GOTO GET.BACK
READ.NONART:
'    /// NON-ART - INSERT HERE SPECIAL READING
'        EXAMPLE: READING WALLS OR CEILING, DOORS, ETC
    GOTO DONT.UNDERSTAND
READ.ARTIFACT:
'    /// READING A READABLE ARTIF.
    R = AD%(A, 5) + AD%(A, 7) - 1
    GOSUB PRINT.EFFECT
    IF A = 3 AND AD%(A, 7) > 1 THEN
	PRINT MID$(TW$ + CW$, 1 + LEN(TW$) * ABS(AD%(A, 7) = 3), LEN(TW$) * ABS(AD%(A, 7) = 2) + LEN(CW$) * ABS(AD%(A, 7) = 3))
	PGPRT 1, ""
    END IF
    AD%(A, 7) = AD%(A, 7) + 1
    IF AD%(A, 7) > AD%(A, 6) THEN AD%(A, 7) = 1
    IF A = 4 THEN PGPRT 1, SPACE$(12) + MW$
    GOTO GET.BACK
' --------------------------------------------------------------------------
PRINT.EFFECT:
    GET #2, R + 200
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    RETURN
' --------------------------------------------------------------------------
FREE.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.UNDERSTAND
    IF AD%(A, 2) <> 10 THEN GOTO DONT.UNDERSTAND
    M = AD%(A, 5)
    K = AD%(A, 6)
    G = AD%(A, 7)
    IF AD%(A, 4) <> ROOM THEN PGPRT 2, "I don't know what you are talking about.": GOTO MAIN.LOOP
    IF MD%(G, 5) = ROOM THEN PGPRT 2, MN$(G) + " won't let you do that!": GOTO GET.BACK
    IF AD%(K, 4) <> -1 AND K <> 0 THEN PGPRT 2, "You don't have the key!": GOTO MAIN.LOOP
    PGPRT 2, "You have freed " + MN$(M) + "."
    MD%(M, 5) = ROOM
    AD%(A, 4) = 0
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
' ---------------------------------------------------------------------------
CLOSE.RTN:
    GOSUB GET.SUBJ
    IF S$ = "EYES" OR S$ = "MY EYES" THEN IC = 1: PGPRT 2, "You close your eyes.": GOTO GET.BACK
    A = 0
    FOUND = 0
    FOR X = 10 TO 13
    SL = LEN(S$)
    IF (LEFT$(AN$(X), SL) = S$ OR RIGHT$(AN$(X), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = HA OR AD%(X, 4) = EMB) THEN FOUND = FOUND + 1: A = X: IF S$ = AN$(X) THEN X = 9999
    NEXT
    IF FOUND THEN IF A = 11 OR A = 12 THEN GOTO DONT.UNDERSTAND
    IF A = 10 AND SCR THEN SCR = 0: PGPRT 2, "You close the box and the scream stops.": GOTO GET.BACK
    IF A = 10 THEN PGPRT 2, "It isn't open.": GOTO MAIN.LOOP
    IF AD%(A, 4) = ROOM THEN PGPRT 2, "It isn't open.": GOTO MAIN.LOOP
    GOTO DONT.UNDERSTAND
' ---------------------------------------------------------------------------
WEAR.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.UNDERSTAND
    IF A = 11 THEN GOTO WEAR.CLOAK.DARKNESS
    IF A = 15 THEN GOTO WEAR.JADED.TALIS
    IF A = 17 THEN GOTO WEAR.CLOAK.LEVI
    PGPRT 2, "You can't wear that and stay respectable."
    GOTO MAIN.LOOP
WEAR.CLOAK.DARKNESS:
    PGPRT 2, "You vanish, but feel weaker!"
    IV = 1
    VC = 0
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
WEAR.JADED.TALIS:
    PGPRT 2, "You put the Jaded Talisman on."
    JT = 1
    GOTO GET.BACK
WEAR.CLOAK.LEVI:
    PGPRT 2, "You put on the cloak of levitation!"
    PGPRT 2, "You feel much lighter!"
    CL = 1
    WT = 0
    GOTO GET.BACK
' ---------------------------------------------------------------------------
SAVE.GAME:
    INPUT "Do you want to save this game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO SAVE.IT
    GOTO MAIN.LOOP
SAVE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
REM $$INCL:'\Eamon\COPY\SAVEGAME.BAS'
'        Eamon Save Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR OUTPUT AS #1
        PRINT #1, LT
        PRINT #1, LM
        PRINT #1, LC
        PRINT #1, LS
        PRINT #1, ROOM
        PRINT #1, SPD
        PRINT #1, TT
        PRINT #1, ArmNam$
        PRINT #1, ArmHit
        PRINT #1, ArmAdj
        PRINT #1, ShdNam$
        PRINT #1, ShdHit
        PRINT #1, ShdAdj
        PRINT #1, AE
        FOR X = 1 TO 4
        PRINT #1, SA%(4)
        NEXT
        FOR X = 1 TO 4
        PRINT #1, S2%(4)
        NEXT
        FOR X = 1 TO 5
        PRINT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        PRINT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        PRINT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        PRINT #1, V%(V)
        NEXT V
        PRINT #1, GOLD&
        PRINT #1, BANK&

    '------- (end of include file) -------    
 ' 
    PRINT #1, VC
    PRINT #1, IC
    PRINT #1, DD
    PRINT #1, IV
    PRINT #1, FL
    PRINT #1, MN$(17)
    PRINT #1, SCR
    PRINT #1, SR
    PRINT #1, RC
    PRINT #1, INSANE
    PRINT #1, JT
    PRINT "Game is saved. To restore it, use restore command."
    SAVED = -1
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MAIN.LOOP
RESTORE.GAME:
    INPUT "Do you want to Restore a game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO RESTORE.IT
    GOTO MAIN.LOOP
RESTORE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
REM $$INCL:'\Eamon\COPY\RESTGAME.BAS'
'        Eamon Restore Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR INPUT AS #1
        INPUT #1, LT
        INPUT #1, LM
        INPUT #1, LC
        INPUT #1, LS
        INPUT #1, ROOM
        INPUT #1, SPD
        INPUT #1, TT
        INPUT #1, ArmNam$
        INPUT #1, ArmHit
        INPUT #1, ArmAdj
        INPUT #1, ShdNam$
        INPUT #1, ShdHit
        INPUT #1, ShdAdj
        INPUT #1, AE
        FOR X = 1 TO 4
        INPUT #1, SA%(X)
        NEXT
        FOR X = 1 TO 4
        INPUT #1, S2%(X)
        NEXT
        FOR X = 1 TO 5
        INPUT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        INPUT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        INPUT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        INPUT #1, V%(V)
        NEXT V
        INPUT #1, GOLD&
        INPUT #1, BANK&
    CLOSE 1

    '------- (end of include file) -------    
 ' 
    INPUT #1, VC
    INPUT #1, IC
    INPUT #1, DD
    INPUT #1, IV
    INPUT #1, FL
    INPUT #1, MN$(17)
    INPUT #1, SCR
    INPUT #1, SR
    INPUT #1, RC
    INPUT #1, INSANE
    INPUT #1, JT
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MOVE.IT
GET.GAME.ID:
    PRINT
    INPUT "File Name: ", GAME.ID$
    IF LEN(GAME.ID$) > 8 THEN GOTO GET.GAME.ID
    GAME.ID$ = UCASE$(GAME.ID$)
    IF LEFT$(GAME.ID$, 1) < "A" THEN GOTO GET.GAME.ID
    GAME.ID$ = GAME.ID$ + ".GAM"
    RETURN
' ---------------------------------------------------------------------------
REM $$INCL:'\Eamon\COPY\CHARIO.BAS'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  CHARIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Character File I/O Routines for Eamon QB/PC
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        or BASIC 7.0 PDS
        '       uses User defined types for record definition
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
OPEN.CHARACTERS:
      OPEN "CHARACT.DAT" FOR RANDOM AS #1 LEN = LEN(Char)
      RETURN
READ.NBR.CHARS:
      GET #1, 1, CharCtl
      NC = CharCtl.NbrChar
      IF NC > LOF(1) \ LEN(Char) THEN NC = LOF(1) \ LEN(Char) - 1
      RETURN
READ.CHARACTER:
      GET #1, REC, Char
      Nam$ = RTRIM$(Char.Nam$)
      HD = Char.Hd
      AG = Char.Ag
      CH = Char.Ch
      SA%(1) = Char.SA1
      SA%(2) = Char.SA2
      SA%(3) = Char.SA3
      SA%(4) = Char.SA4
      WA%(1) = Char.WA1
      WA%(2) = Char.WA2
      WA%(3) = Char.WA3
      WA%(4) = Char.WA4
      WA%(5) = Char.WA5
      SEX$ = Char.SEX
      GOLD& = Char.GOLD
      BANK& = Char.BANK
      AE = Char.AE
      ArmNam$ = RTRIM$(Char.ArmNam)
      ArmHit = Char.ArmHit
      ArmAdj = Char.ArmAdj
      ShdNam$ = RTRIM$(Char.ShdNam)
      ShdHit = Char.ShdHit
      ShdAdj = Char.ShdAdj
      WN$(1) = RTRIM$(Char.Wpn1Nam)
      WR%(1) = Char.Wpn1Typ
      WT%(1) = Char.Wpn1WpnTyp
      WC%(1) = Char.Wpn1Odds
      WD%(1) = Char.Wpn1Dice
      WS%(1) = Char.Wpn1Sides
      WN$(2) = RTRIM$(Char.Wpn2Nam)
      WR%(2) = Char.Wpn2Typ
      WT%(2) = Char.Wpn2WpnTyp
      WC%(2) = Char.Wpn2Odds
      WD%(2) = Char.Wpn2Dice
      WS%(2) = Char.Wpn2Sides
      WN$(3) = RTRIM$(Char.Wpn3Nam)
      WR%(3) = Char.Wpn3Typ
      WT%(3) = Char.Wpn3WpnTyp
      WC%(3) = Char.Wpn3Odds
      WD%(3) = Char.Wpn3Dice
      WS%(3) = Char.Wpn3Sides
      WN$(4) = RTRIM$(Char.Wpn4Nam)
      WR%(4) = Char.Wpn4Typ
      WT%(4) = Char.Wpn4WpnTyp
      WC%(4) = Char.Wpn4Odds
      WD%(4) = Char.Wpn4Dice
      WS%(4) = Char.Wpn4Sides
      RETURN
WRITE.CHARACTER:
      Char.Nam = Nam$
      Char.Hd = HD
      Char.Ag = AG
      Char.Ch = CH
      Char.SA1 = SA%(1)
      Char.SA2 = SA%(2)
      Char.SA3 = SA%(3)
      Char.SA4 = SA%(4)
      Char.WA1 = WA%(1)
      Char.WA2 = WA%(2)
      Char.WA3 = WA%(3)
      Char.WA4 = WA%(4)
      Char.WA5 = WA%(5)
      Char.SEX = SEX$
      Char.GOLD = GOLD&
      Char.BANK = BANK&
      Char.AE = AE
      Char.ArmNam = ArmNam$
      Char.ArmHit = ArmHit
      Char.ArmAdj = ArmAdj
      Char.ShdNam = ShdNam$
      Char.ShdHit = ShdHit
      Char.ShdAdj = ShdAdj
      Char.Wpn1Nam = WN$(1)
      Char.Wpn1Typ = WR%(1)
      Char.Wpn1WpnTyp = WT%(1)
      Char.Wpn1Odds = WC%(1)
      Char.Wpn1Dice = WD%(1)
      Char.Wpn1Sides = WS%(1)
      Char.Wpn2Nam = WN$(2)
      Char.Wpn2Typ = WR%(2)
      Char.Wpn2WpnTyp = WT%(2)
      Char.Wpn2Odds = WC%(2)
      Char.Wpn2Dice = WD%(2)
      Char.Wpn2Sides = WS%(2)
      Char.Wpn3Nam = WN$(3)
      Char.Wpn3Typ = WR%(3)
      Char.Wpn3WpnTyp = WT%(3)
      Char.Wpn3Odds = WC%(3)
      Char.Wpn3Dice = WD%(3)
      Char.Wpn3Sides = WS%(3)
      Char.Wpn4Nam = WN$(4)
      Char.Wpn4Typ = WR%(4)
      Char.Wpn4WpnTyp = WT%(4)
      Char.Wpn4Odds = WC%(4)
      Char.Wpn4Dice = WD%(4)
      Char.Wpn4Sides = WS%(4)
      PUT #1, REC, Char
      RETURN
WRITE.NBR.CHARS:
      CharCtl.NbrChar = NC
      PUT #1, 1, CharCtl
      RETURN

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\EAMON\COPY\ADVENIO.OLD'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  ADVENIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Adventure I/O Routines for Eamon Base Adventure Program
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        BASIC 7.0 PDS
        '       uses Field statements for record description
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
READ.ARTIFACTS:    ' ----- READ ARTIFACTS ---------------------
       IF Art.Len = 0 THEN Art.Len = 128
       IF Art.Flds = 0 THEN Art.Flds = 8
       IF AN.Len = 0 THEN AN.Len = 20
       OPEN "ARTIF.TXT" FOR RANDOM AS #3 LEN = Art.Len
       FIELD 3, AN.Len AS AF.NAME$
       DIM AF.DATA$(Art.Flds)
       FOR A2 = 1 TO Art.Flds
       FIELD 3, AN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS AF.DATA$(A2)
       NEXT
       FOR A = 1 TO NA
           GET #3, A
           AN$(A) = RTRIM$(AF.NAME$)
           FOR A2 = 1 TO Art.Flds
               AD%(A, A2) = CVI(AF.DATA$(A2))
           NEXT A2
           IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 THEN NW = NW + 1
       NEXT
       CLOSE 3
       RETURN
READ.MONSTERS:  ' ------------- READ MONSTERS    ---------------------
       IF MON.LEN = 0 THEN MON.LEN = 128
       IF Mon.Flds = 0 THEN Mon.Flds = 12
       IF MN.Len = 0 THEN MN.Len = 20
       OPEN "MONST.TXT" FOR RANDOM AS #3 LEN = MON.LEN
       FIELD 3, MN.Len AS MF.NAME$
       DIM MF.DATA$(Mon.Flds)
       FOR A2 = 1 TO Mon.Flds
           FIELD 3, MN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS MF.DATA$(A2)
       NEXT
       FOR A = 1 TO NM
           GET #3, A
           MN$(A) = RTRIM$(MF.NAME$)
           FOR A2 = 1 TO Mon.Flds
               MD%(A, A2) = CVI(MF.DATA$(A2))
           NEXT A2
           IF MD%(A, 3) < 0 THEN               ' Force nuetral if < 0
              MD%(A, 3) = ABS(MD%(A, 3)) - 1
              MD%(A, 14) = 2
           END IF
       NEXT
       CLOSE 3
       RETURN
OPEN.DESC:       ' ----------------- OPEN DESC FILE -------------------
       IF Desc.Len = 0 THEN Desc.Len = 256
       OPEN "DESC.TXT" FOR RANDOM AS #2 LEN = Desc.Len
       FIELD 2, Desc.Len - 1 AS Desc$
       RETURN
OPEN.RMNAMES:    ' ---------------- OPEN ROOM NAMES -------------------
       IF RMN.Len = 0 THEN RMN.Len = 64
       OPEN "RMNAMES.TXT" FOR RANDOM AS #3 LEN = RMN.Len
       FIELD 3, RMN.Len AS RN$
       RETURN
OPEN.ROOMS:      ' ---------------- OPEN ROOMS FILE -------------------
       IF RM.LEN = 0 THEN RM.LEN = 64
       OPEN "ROOMS.TXT" FOR RANDOM AS #1 LEN = RM.LEN
       FOR D = 1 TO 10
           FIELD 1, (D - 1) * 2 AS X$, 2 AS RF.DIR$(D)
       NEXT
       FIELD 1, 20 AS X$, 1 AS RF.LT$
       RETURN
Read.Room:
       GET #1, Room
       IF ND = 0 THEN ND = 6
       NX = 0
       FOR X = 1 TO ND
           RD%(X) = CVI(RF.DIR$(X))
           IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
       NEXT
       NL = VAL(RF.LT$)
       GET #3, Room
       RETURN
    '------- (end of include file) -------

    '------- (end of include file) -------    
 ' 

SUB PGPRT (SP, LIT$)

STATIC PG.CNT
    IF SP = 0 THEN PG.CNT = 0: EXIT SUB
    IF LIT$ = "" THEN PG.CNT = PG.CNT + SP: EXIT SUB
    IF PG.CNT > 18 THEN
	LOCATE 24, 1
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-");
	A$ = INPUT$(1)
	PG.CNT = 0
	LOCATE CSRLIN - 1, 1
	PRINT SPC(79);
    END IF
    IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	PG.CNT = PG.CNT + 1
	NEXT
    END IF
    PRINT LIT$
    PG.CNT = PG.CNT + INT(LEN(LIT$) / 80) + 1
END SUB

