

























                         Eamon-QB Dungeon Designer's Guide



                               Copyright (c) 1984

                                 by John Nelson


                           National Eamon User's Club
                           2701 Arnold Road
                           Des Moines, Iowa  50310


























        All  rights  reserved.  No  part  of  this  publication  may   be
        reproduced,  stored in a retrieval system, or transmitted in  any
        form  or  by  any means,  electronic,  mechanical,  photocopying,
        recording  or otherwise without the prior written  permission  of
        the  publishers,  with the exception that the program  changes  /
        listings  may  be  entered, stored and  executed  in  a  computer
        system, but they may not be reproduced for publication.


        This  guide  is  intended to give the user  all  the  information
        he/she  will  need  to  be  able  to  design  interesting   Eamon
        adventures.  It  will  include examples of all  features  and  an
        entire adventure will be designed from beginning to end.




        Table of Contents


        Section I.  How the Eamon system works

                Part 1 --- The Eamon Master Diskette
                Part 2 --- Passing control to the adventure
                Part 3 --- The Eamon character
                Part 4 --- The adventure itself

        Section II.  The Eamon Files

                Part 1 --- Overview of all files
                Part 2 --- Creating the files
                Part 3 --- Master Diskette files
                           CHARACT
                           ADVENT
                           MEAT

                Part 4 --- Adventure Files
                           EAMON.NAM
                           DESC.R0
                           DESC.TXT
                           ROOMS.TXT
                           RMNAMES.TXT
                           MONST.TXT
                           ARTIF.TXT

        Section III. The Eamon Programs

                Part 1 --- Master Diskette Programs
                            WORLD  - Intro Program
                            CREATE - Create New Character
                            HALL   - Main Hall
                            MASTER - Utilities

                Part 2 --- Adventure diskettes
                            Boot program
                            Adventure description
                            Main Program

                Part 3 --- Designer Programs
                            DUNGMENU - Menu Program
                            DUNGINIT - Dungeon Initialize
                            DUNGEDIT - Dungeon Edit
                            DUNGLIST - Dungeon List
                            LEADIN   - Leadin Program
                            MAINPGM  - Main Adventure Program
                            CVTCTRL  - Convert Controls




        Section IV. Designer Overview

                Part 1 --- Story and Mission
                Part 2 --- Plans, Characters, Artifacts
                Part 3 --- Initializing the files
                Part 4 --- Editing the files
                Part 5 --- Modifying the base program
                Part 6 --- Listing the adventure
                Part 7 --- Submitting to the Library

        Section V. Modifying the Main Program

                Part 1 --- Routine locations
                Part 2 --- Common modifications
                Part 3 --- Testing the changes

        Section VI.  An entire adventure design example

                Part 1 --- Layout of idea and features
                Part 2 --- Initializing and Beginning
                Part 3 --- Editing the files
                Part 4 --- Special programming
                Part 5 --- Testing




        Section I.  How the Eamon System Works

          Part 1.  The Eamon Master Diskette

        The  Eamon  system  is  a series of programs  that  when  run  in
        sequence produce the simulation of a life in an adventurous world
        of magic and excitement.

        The Master Diskette is where life begins in Eamon. When you begin
        the  game, you will be presented with a description of where  you
        are and be asked whether you want to join some men drinking  beer
        at  the  bar or go to the desk to sign in.

        On  the  IBM version of the Eamon Master, you do not  "boot"  the
        diskette,  but  rather boot a system master and then  insert  the
        Eamon-QB master and type MASTER and press return. You will get  a
        menu  with  the utility options. You may press  '1'  and  confirm
        starting the game with a 'C'.

        You will eventually have to sign in. The man behind the desk will
        mumble  something as he looks through the book to see if you  are
        in  it.  If the name you give him matches one he already  has  on
        file,  the character is brought out of the file and you are  sent
        on  your  way. This is the way the Eamon  connects  your  current
        visit  (or game) with a possible previous trip to Eamon.  If  you
        have never been to Eamon before or were killed, the man will  not
        be able to locate your character's name. If this happens, he will
        ask  if that's the name you always use. This is the programs  way
        of checking that you did not make a spelling mistake on the name.

        When you are new to the Eamon world (the name you gave was not on
        the file) the program CREATE is run. The name you gave the man is
        passed to the CREATE program in a small text file called  ADVENT.
        This  file  will be read by the CREATE program and  you  will  be
        asked  if you are male or female. The program will then  generate
        your character's attributes and write your character out into the
        Characters file. It will then re-write ADVENT file to contain not
        only  the name, but the record number of the character. That  is,
        the record slot in the file CHARACT where that adventurer can  be
        found. The program then runs HALL.




        Once you have a character located or created the system runs  the
        main  hall  program.  This program is where you buy  all  of  the
        supplies needed to prepare yourself for a life of adventure.

        This includes buying weapons and armour, learning spells from  an
        old wizard, depositing or withdrawing gold pieces with the  local
        banker,  or examining your characters attributes,  abilities  and
        possessions.

        When  you are ready for adventure, you select go on an  adventure
        and  the HALL program will delete the character from the  charac-
        ters file and ask you to insert the adventure diskette. Actually,
        to  delete  the character, the program simply places  '*DEAD'  in
        front of the characters name. All other programs are designed  to
        think this is a dead character.




          Part 2. Passing control to the adventure

        Once  the  player has changed diskettes, the  main  hall  program
        creates  a file called MEAT and writes all the  character's  data
        into  that file. A listing of what this data is can be  found  in
        Section II Eamon Files.

        The program then opens a file called EAMON.NAM and reads the file
        name  and  the adventure name. The file name is the name  of  the
        program  file that is to be run next. The adventure name  is  the
        name  of  the adventure that it will print on the  screen.  These
        must be two different fields because a file name may ony e  eight
        characters  long,  while the name of the adventure  may  be  much
        longer. The program then runs the program by the name of (whatev-
        er the file name in EAMON.NAM was.)




        Part 3. The Eamon Character

        The  game  of  Eamon  revolves around  a  central  figure  -  the
        adventurer.  The name of this character does not have to be  your
        real name, of course. (i.e. something as dull as John). It can be
        any  exciting  name  you want. The  character  is  given  certain
        qualities when it is created. Some of these qualities will remain
        the  same,  such  as  hardiness,  agility  and  charisma  (unless
        modified by some mysttic means) and others will naturally  change
        through  experience, such as weapon abilities, armour  expertise,
        and spell ability.

        The  fields  that  make  up an Eamon  character  are  listed  and
        described below:

             Name            Name of the character (up to 20 char.)
             Hardiness       The character's strength, durability
             Agility         The character's agilness.
             Charisma        How charming he/she is.
             Blast Ability   If blast spell not known, = 0
             Heal Ability    If Heal spell not known, = 0
             Speed Ability   If Speed spell not known, = 0
             Power Ability   If Power not known, = 0
             Axe Expertise   Ability at using an axe type weapon
             Bow Expertise   Ability at a bow type weapon
             Mace Expertise  Ability to use a mace or club
             Spear Expertise Ability at using a spear type weapon
             Sword Expertise Ability at using a sword
             Armour Exper.   Experience at wearing armour
             Sex             String - "M" or "F"
             Gold#           Number of gold pieces carried
             Bank#           Number of Gold pieces in bank
             Armour Class    Type of armour worn
             Weapons Carried Up to four weapons, each containing:
               Weapon Name   Name of the weapon
               Weapon Type    1=axe, 2=bow, 3=mace, 4=spear, 5=sword
               Complexity     weapon odds adjustment
               Dice           number of dice rolled
               Sides          number of sides on each die




        Part 3. The Adventure itself

        The  Eamon  adventure  is of couuse, the purpose  of  the  entire
        system.  All Eamon adventures are different, but they  all  share
        certain  general  features. The adventures  function  by  reading
        information about a scenario from the diskette. This  information
        includes  information about the adventures rooms,  artifacts  and
        monsters  from files kept on the Eamon adventure  diskette.  This
        information,  along  with a customized base program  provide  the
        parameters of the adventure.

        The  adventure  program reads the artifact data and  the  monster
        data  from  the  diskette files and stores it  in  tables.  These
        tables  are  then  accessed by the program to  provide  the  data
        needed  to  act  on  these  things.  The  tables  are  both  two-
        dimensional with the first subscript being the identifying number
        of  the item and the second number having a special  meaning  for
        this item.

        The table subscripts are given below:

                Artifact Table
                0  - Not used
                1  - Value of the artifact when sold
                2  - Type of artifact
                3  - Weight of the artifact
                4  - Room that artifact starts in
                5  - Complexity - if a weapon
                6  - Weapon Type - if a weapon
                7  - dice - if a weapon
                8  - sides - if a weapon
                9  - seen flag

        The monster table subscripts are :

                0  - Not used
                1  - Hardiness
                2  - Agility
                3  - Friendliness
                4  - Courage
                5  - Room number
                6  - Weight
                7  - Defensive Odds
                8  - Armour
                9  - Weapon number
                10 - Offensive odds - chance to hit
                11 - Dice
                12 - Sides
                13 - Damage
                14 - Reaction (1=enemy, 2=nuetral, 3=friend)
                15 - Met flag




        The main adventure program analyzes this data to determine how to
        treat the items. In addition to the tables above, there are  name
        tables  for  the  monster names and the  artifact  names.  If  an
        adventurer tries to pick up an artifact, the program searches the
        name table for the item he asked for. If it finds something  that
        matches,  it  then check to see if that item is in  the  room  by
        checking  field 4 to see if it is equal to the room  number  that
        the adventurer is currently in.

        When the adventure is over, the program will pass control back to
        the HALL. If the character is dead, all that needs to be done  is
        to  delete  the  file  ADVENT and run  WORLD.  If  the  character
        survived,  then  his/her record must be  re-written.  Once  these
        things are done, the program runs the HALL.




        Section II. The Eamon Files

        Part 1 - Overview of all the files ...

        This section discusses all of the Eamon Text files, how they  are
        used  and what information is contained in them. This  is  broken
        down first by diskette, so that you may see which files are  used
        on each diskette, then a description of each file.

        Master Diskette - The master diskette contains the following text
        files:

                CHARACT         length 256 Random access
                ADVENT          sequential
                MEAT            sequential

        Adventure Diskette

                EAMON.NAM        sequential
                DESC.R0          sequential
                DESC.TXT         length 256 random access
                RMNAMES.TXT      length 64  random access
                ROOMS.TXT        length 64  random access
                MONST.TXT        length 128 random access
                ARTIF.TXT        length 128 random access

        Part 2 - Creating the files ...

        The  files  on the master diskette are created in  a  variety  of
        ways.

        CHARACT is created by the program INIT on the Master Diskette.

        ADVENT is created as it is needed by WORLD, CREATE, and MAINPGM.

        MEAT is created as it is needed by the MAIN HALL.

        Files  on  the  adventure  diskettes  are  creating  during   the
        initialization  process  by the Dungeon Designer  Diskette.  When
        these  files are created, they are totally empty except  for  the
        file DESC.R0. and the EAMON.NAM file.




        Part 3 - Master Diskette files ...

        CHARACT

        The  characters  file contains all of the  characters  that  have
        already  been created. It is a random access file with  a  record
        length of 256. Each record contains one character. It is  created
        by a program called INIT. It is maintained by the CREATE program,
        and  HALL  and  the main adventure program. The  fields  in  each
        character are listed below:

                NAM$        Name of the character
                HD          Hardiness - normally 3-24
                AG          Agility - normally 3-24
                CH          Charisma - normally 3-24
                SA%(1)      Blast spell
                SA%(2)      Heal spell
                SA%(3)      Speed spell ability
                SA%(4)      Power spell ability
                WA%(1)      Axe ability
                WA%(2)      Bow ability
                WA%(3)      Mace ability
                WA%(4)      Spear ability
                WA%(5)      Sword ability
                AE          Armour Expertise
                SEX$        Sex - string "M" or "F"
                GOLD        Gold pieces in hand
                BANK        Gold pieces in bank
                AC          Armour Class (or type)
                WN$(1)      Weapon Name
                WT%(1)      Weapon type
                WC%(1)      Weapon Odds (Sometimes used as WO%())
                WD%(1)      Weapon Dice
                WS%(1)      Weapon Sides
                WN$(2)      Weapon Name----- second weapon --------
                WT%(2)      Weapon type
                WC%(2)      Weapon Odds (Sometimes used as WO%())
                WD%(2)      Weapon Dice
                WS%(2)      Weapon Sides
                WN$(3)      Weapon Name----- third weapon --------
                WT%(3)      Weapon type
                WC%(3)      Weapon Odds (Sometimes used as WO%())
                WD%(3)      Weapon Dice
                WS%(3)      Weapon Sides
                WN$(4)      Weapon Name----- fourth weapon -------
                WT%(4)      Weapon type
                WC%(4)      Weapon Odds (Sometimes used as WO%())
                WD%(4)      Weapon Dice
                WS%(4)      Weapon Sides





        ADVENT

        This is a temporary sequential file that contains the  characters
        name  and record number. When it is first created in the  program
        WORLD,  it  does not contain a record number  when  passing  into
        CREATE.  This file is deleted by the main adventure program  when
        an adventurer dies.
        MEAT

        This  is another temporary sequential file used only for  passing
        data from the MAIN HALL to the adventure. It contains the players
        record number and all the players attributes. The first field  is
        the record number and the rest of the fields match the  character
        record exactly field-for-field.




        Part 4 - Adventure files ...

        These files are contained on the individual adventure  diskettes.
        Because  adventures may be totally different from each other  and
        are written by different individuals, there may be some variation
        as  to  the  files found on a particular adventure  or  even  the
        format  of  each  of these files. The files given  here  are  the
        standard ones.

        EAMON.NAM

        This  file  is  a  sequential file containing  the  name  of  the
        adventure  and  the  file  name of the program  to  be  run  when
        transferring to the adventure.

        DESC.TXT

        This  file  contains all the descriptions for  rooms,  artifacts,
        effects and monsters. The first 100 records are reserved for room
        descriptions.  The  next 100 records are  reserved  for  artifact
        descriptions.  The next 100 records are reserved for effects  and
        the  last  100 records are reserved for monsters.  This  makes  a
        total  of  400 possible records. This is not a  practical  limit,
        however,  since you would run out of disk space long  before  all
        were used.

        While  most of the adventures have 100 as the maximum  number  of
        rooms,  artifacts,  effects and monsters, it is possible  at  the
        time  you  initialize  your adventure to set  these  maximums  to
        higher  (or lower) numbers. This may be done only at the time  an
        adventure  is  initialized. If you get an  adventure  created  or
        partially  created and then decide you don't have enough in  your
        maximums, you must use the program CVTCTRL to convert the  adven-
        ture. But this will also require that you re-edit everything that
        is  currently in the file to ensure the special room  codes,  etc
        are set up properly.

        More usual sizes may fall in the following ranges:

                Rooms       40 - 80
                Artifacts   30 - 70
                Monsters    16 - 35
                Effects      0 - 12





        DESC.R0  -  is used for the number of items of each type  in  the
        following order.

                Number of Rooms
                Number of Artifacts
                Number of Effects
                Number of Monsters
                Number of Directions
                Maximum Number of Rooms
                Maximum Number of Artifacts
                Maximum Number of Effects
                Room File Record Length
                Room Name File Record Length
                Monster File Record Length
                Artifact File Record Length
                Description File Record Length
                Number of Monster Fields
                Number of Artifact Fields
                Number of Room Fields (other than directions)
                Monster Name Length
                Artifact Name Length




        RMNAMES.TXT

        This  file contains the names of all the rooms in  an  adventure.
        It is a random access file with a standard record length of 64.

        Each record contains only one field - a string - with the name of
        that room.

        ROOMS.TXT

        This  file  contains  the room connection data. It  is  a  random
        access  file  with a standard record length of 64. It  tells  the
        program what room you will enter for each direction of  movement.
        For ten direction dungeons, there are ten fields in each  record.
        For  six direction dungeons there are six fields in each  record.
        There  is  an additional field at the end of  these  fields  that
        tells  whether there is light in that room or not.  In  addition,
        the  designer may enter additional information depending  on  the
        variable number of Room Fields (found in DESC.R0).

        The fields are:
                North room
                South room
                East room
                West room
                Above room (up)
                Below room (down)
                Northeast (optional)
                Northwest (optional)
                Southeast (optional)
                Southwest (optional)
                Light indicator
                (optional user fields)




        MONST.TXT

        This  file is a random access file with a standard record  length
        of 128.

        In  standard Eamon adventures, each monster is defined by a  name
        and  twelve  data fields. This can be changed, however  when  the
        dungeon is initialized.

        When you do this, you have to change the program to handle  these
        additional  fields,  however.  The fields added  are  up  to  the
        designer to maintain and only very experienced designer's  should
        attempt  this. The additional fields must be defined  before  the
        first  monster  is added to the file. To help the  designer  keep
        track of these additional fields, the DUNGEDIT program saves  the
        fields available.

              MN$       Monster Name
                1  -    Hardiness
                2  -    Agility
                3  -    Friendliness
                4  -    Courage
                5  -    Room
                6  -    Weight
                7  -    Defensive odds
                8  -    Armour
                9  -    Weapon number
                10 -    Offensive odds or chance to hit
                11 -    Dice
                12 -    Sides




        ARTIF.TXT

        This  file is a random access file with a standard record  length
        of  128.  For each artifact there is an artifact name  and  eight
        data fields. The fields are listed and explained below:

                1 - Value
                2 - Type
                3 - Weight
                4 - Room
                5 - variable data - depends on artifact type.
                6 - variable data - depends on artifact type.
                7 - variable data - depends on artifact type.
                8 - variable data - depends on artifact type.

        Value - This is the value of the item if traded for gold  pieces.
        For  fixed  treasure (type 0) this will always be the  amount  of
        gold  the  adventurer  will  receive for  this  treasure.  For  a
        variable treasure, this is a guideline for the average price. For
        other artifact types this value is considered an average price.

        Type - This tells the adventure program what sort of artifact  it
        is. There were 4 types of artifacts in the original Eamon  (prior
        to  the  IBM version). In the IBM version there are 15  types  of
        artifacts  with  the capability to create your  own  types.  Only
        weapons are allowed to be carried out of an adventure. The  types
        of artifacts are:

                Type    Field Use
                 0      Gold and fixed treasure
                 1      Treasure
                 2      Non-magic weapon
                 3      Magic weapon (unbreakable)
                 4      Container
                 5      Light
                 6      Healing
                 7      Readable
                 8      Door/Gate
                 9      Key
                10      Bound monster
                11      Armor / worn items
                12      food
                13      drink
                14      monster in disguise
                15      booby trap


        Weight  -  The  next field is the weight  of  the  artifact.  All
        artifacts have a weight and the adventurer is restricted to being
        able to carry 10 times his hardiness.





        Room - This is the room number that the artifact starts in. If an
        artifact  is in limbo until some special action occurs,  you  may
        set the room number to 0. If the adventurer is to be carrying the
        item,  set the room number to -1. If it is carried by  a  monster
        (and  will be dropped when he is killed) it should be -(M  +  1).
        For example if monster 24 is carrying it, it's room number  would
        be -25. Additional room codes are

                  +100 Inside a container
                  +200 Embedded in the room description
                  +300 Hidden in a room
                  +400 Buried in the room
                  +500 Worn by a monster

        In  the  Apple version of the program, it is  important  to  know
        these room codes, because you have to enter them this way. On the
        IBM,  the  program has been set up to allow you to  select  these
        room codes by pressing the appropriate Function key before enter-
        ing the information. The program will then take care of  encoding
        and de-coding the room codes.

        For example an artifact inside a container would have a room code
        in  the 100 - 199 range. The difference between 100 and the  room
        number would be the number of the container. (e.g. a jewel inside
        a box (artifact #3) would be coded 103).

        An  artifact that you do not want listed as a separate item,  but
        are  depending  on  the description of the  room  to  notify  the
        adventurer  of its presence would be coded in the range of 200  -
        299.  As  an  example of this, lets say you  have  the  following
        items: A statue of a warrior in a room full of weapons:

        Description of room 9:

        You have entered a large rectangular room with weapons  scattered
        around  on  the  floor.  Some  of  the  weapons  are  broken  and
        fragmented.  In the middle of the room stands a statue of  bronze
        of a great warrior. The exit is to the south.

        If  you want to make the statue a separate artifact (so that  you
        could do something special with it (such as examine it, open  it,
        turn it or something) or allow the adventurer to get it), but did
        not want its real presence to be too obvious, you could code  the
        room number as 209. You might even want to place some weapons  in
        the room as embedded items so that the player could interact with
        them also.

        The  hidden code is for placing items in a room, but  making  the
        adventurer look for them before they are discovered. For example,
        you  could code the room number for a silver spear as 308 and  it
        would  only  be discovered if you were in room 8 and did  a  LOOK
        command.




        Weapons use fields 5 through 8 as shown below:

                5 - Odds / Complexity
                6 - weapon type
                7 - dice
                8 - sides

        Otherwise,  fields 5 - 8 are used for various automatic  handling
        by  Main  Program.  These fields are used  differently  for  each
        different artifact type.

        To  handle  these, the DUNGEDIT program reads a  definition  file
        ARTTYPE.DEF.  These definitions are what is used  when  prompting
        for  the data in the edit program. The base program knows how  to
        use these data fields to simulate special activities.





        Section III. THE EAMON PROGRAMS

        The  Eamon programs are inter-connected programs that as a  whole
        simulate  the world of adventure. They are linked together  by  a
        process  of writing information into text files and  running  the
        next program in sequence.

        There are four general groups of Eamon programs:

                1. Master diskette programs
                2. Adventure programs
                3. Designer programs
                4. Utilities programs

        Part 1 --- Master Diskette programs

        The main programs on the Master Diskette are:

                WORLD
                CREATE
                HALL
                MASTER
                INIT

        WORLD  -  This  program is the one that, gets  the  name  of  the
        adventurer  from the player and looks the character up to see  if
        they are already on file. If so, it runs the program HALL. If the
        player is not on the file, the program allows you to try again or
        to say that you are new. If you are new, the program runs CREATE.
        If  you do something you're not supposed to do, it will kill  you
        and that ends the game.

        CREATE  - This program generates the attributes of the  character
        and  optionally  gives  the new  player  instructions.  When  the
        character has been fully generated, this program runs HALL.

        HALL  - This is the central core of the Eamon world. All  activi-
        ties  necessary to prepare your character for adventure  is  done
        here.  When  the  character is ready to go on  an  adventure  the
        program deletes the character from the CHARACT file and transfers
        the  character  to an adventure. The file used for  the  transfer
        process is MEAT.

        MASTER - This program may be run to display all characters on the
        diskette, and to perform utility functions on the characters.




        Part 2 --- Adventure diskette programs

        These  programs are the standard programs found on an  individual
        adventure  diskette. The programs are set up by the designer  and
        modified before being saved to the adventure diskette. One of the
        prorams  will  assume  the name of the adventure.  It  should  be
        adapted  from the program LEADIN from the DDD. The  main  program
        should be called MAINPGM and will contain the bulk of the  adven-
        ture.

        The  standard set of programs contained on the various  adventure
        diskettes are:

                (advname).EXE
                MAINPGM.EXE

        The name of the lead-in program on the adventure diskette varies.
        The  use  of  this program is fairly standard, but  it  may  vary
        somewhat from adventure to adventure. Some adventures may contain
        additional programs.

        advname - The name of this program will be identical to the  name
        found  in EAMON.NAM, whatever it may be. It will give a  descrip-
        tion  of  the adventure and pass control to  the  main  adventure
        program (usually called MAIN PGM).




        MAINPGM  -  This is the program that will  actually  control  the
        action portion of the adventure. It is a fairly large complicated
        program designed to read the various Eamon text files and control
        the activities taking place. It consists of the following parts:

                Initialization  -  set up tables and  read  monsters  and
        artifacts into these tables for processing. Reads the  adventurer
        from MEAT and stores his attributes in entry 0 of the table. Then
        branches to the main loop.

                Main  Loop  -  This routine is where all  of  the  normal
        every-turn  processing takes place. It read the descriptions  and
        names  of the rooms and displays them, reads the descriptions  of
        the  monsters  and  artifacts that you  encounter,  and  displays
        these.  It gets a command from the player and looks it up in  the
        table of commands. It then braches to the appropriate routine  to
        process  the  command  that was selected.  When  the  command  is
        finished, assuming you don't die, control is then passed back  to
        the  bottom half of the main loop. This bottom half of  the  main
        loop then checks to see if battle is to be carried on and if  so,
        generates  attacks  for  all the monsters to  take  part  in  the
        battle.  It then branches back up to tha top of the main loop  to
        continue.

                End of adventure - Termination routine. - This portion of
        the  program closes the files, determines the outcome  -  whether
        the   adventurer  died,  or  earned  gold,  etc  and  takes   the
        appropriate  response.  If the adventurer died, it  is  a  simple
        matter  of requesting the Master Diskette and deleting  the  file
        ADVENT  before  running  the  HALL  program.  If  the  adventurer
        survived, it determines what he is carrying and if more than four
        weapons  are  carried,  make  the  player  sell  some.  It   then
        determines how much gold was earned and pays it and requests  the
        master  diskette. The program then writes the  updated  character
        into the CHARACT file and runs HALL.

                The  rest  of the program is made up  of  the  individual
        command routines. The standard ones are:

                MOVE (NORTH, SOUTH, EAST, WEST, UP, DOWN ...)
                GET or TAKE
                DROP
                EXAMINE or LOOK
                ATTACK
                FLEE
                GIVE
                INVENTORY
                MAGIC (BLAST, HEAL, SPEED, POWER)
                SMILE or WAVE
                SAY
                READY
                OPEN
                DRINK
                LIGHT




        Part 3 --- Designer programs

        The designer programs consist of the following programs:

                DUNGMENU.EXE
                DUNGINIT.EXE
                DUNGEDIT.EXE
                CVTCTRL.EXE
                MAINPGM.EXE
                LEADIN.EXE

        A  second designer diskette contains the source code for  MAINPGM
        and LEADIN.

        The  DUNGMENU  program presents a menu for selecting one  of  the
        other programs.

        DUNGINIT  allows to to begin a new adventure. It initializes  the
        files on a pre-formatted diskette for you. When the  initializing
        process  is  completed, you should copy the LEADIN.EXE  from  the
        designer diskette to your adventure diskette and rename it to the
        file  name you gave the initialization program. Then the  MAINPGM
        should  be  copied to your adventure diskette under the  name  of
        MAINPGM.

        DUNGEDIT is where the rooms, artifacts, effects and monsters  are
        entered. Special editing capabilities have been built into it  to
        make the adventure creating process as painless as possible.

        LEADIN is on the DDD for the convenience of the designer. It is a
        skeleton  program  that  can  be  easily  modified  to  give  the
        description of the adventure and pass control to the MAINPGM.  It
        reads  a  file called MISSION.TXT and prints the  contents.  This
        text file should contain a descriptin of the mission. It also has
        a  routine  to  read the adventurer from the  MEAT  file,  to  do
        headings and to run the MAIN PGM already built in.





        Section IV. Designer Overview

        The  process of designing and creating an adventure for Eamon  is
        not  difficult  if  you  follow  the  correct  procedures.  Those
        procedures will be outlined and explained here.

        The designer process includes the following steps.

                1. Come up with a story and mission for the adventure.

                2. Layout the plans, characters, and artifacts needed.

                3. Initialize and set up diskette

                4. Edit the data files

                5. Modify base program

                6. Test the adventure

                7. Compile the Main Pgm and create an executable program


        Part 1 --- Story and Mission

        This part sounds like it is the easiest part, but actually it  is
        not  as  easy  as  it sounds. It is certainly  one  of  the  most
        important steps (aside from possibly testing). Let's first take a
        look at the difference between story and mission. The mission  is
        what you as the adventurer are supposed to accomplish. The  story
        is  the  reason behind why you are to do it. It is  important  to
        know  this difference because general types of missions are  very
        limited, but the stories behind these missions are not. The story
        is going to make the adventure exciting or boring, complicated or
        simple. The mission is necessary to give the adventurer a goal  -
        something  to let him know when he is done. It should not be  too
        easy, but if it is too difficult, few will want to play it often.

        The story should be interesting and complicated enough to capture
        the players interest. It should be more complicated than a simple
        "So-and-So  must  found and killed '. It  should  have  tangible,
        recognizable sub-tasks that let the adventurer know he is on  the
        right  track.  Enough complexities should be put in  to  make  it
        thought provoking, but if you make it too tough, you'll frustrate
        and lose players.

        Possible missions normally boil down to:

                Rescue a person
                Capture or kill a villain
                Bring back some artifact
                Destroy some artifact
                Seek an audience with some powerful figure
                Escape from a capture/imprisonment





        Part 2 --- Plans, characters and artifacts needed

        This step will entail coming up with the kinds of characters  and
        specific characters to support your story. The monsters should be
        related to the story and you should have no unrelated monsters if
        they  do  not belong in the environment you've chosen.  You  will
        need  to figure out what you will need for artifacts as  well  as
        monsters.  You will then need to set up a map for the  adventure.
        This map will have to be detailed enough for you to key the  data
        into  the computer from. Things you should keep in mind are  what
        types of rooms would be needed in the environment you have chosen
        and  what types of areas or rooms you would naturally  encounter.
        Visualize the types of rooms that would occur in your setting.

        Additional artifacts will be needed for the normal functioning of
        the  adventure. Things like gates or doors, furniture if  it  may
        conceal something, etc.

        Make  a list of all of the monsters you will have and all of  the
        artifacts  you will have. Then draw a map and label  where  these
        items will be placed.




        Part 3 --- Initializing the files

        Once  you  have  all of the groundwork set up you  are  ready  to
        start.  Run the DUNGINIT program. Follow the screen prompts  very
        carefully.

        It will ask you questions about the adventure. You will be  asked
        for  the  name  of the adventure, your  name  and  the  adventure
        number.  The  adventure number will be changed  later  when  your
        adventure is released to the world, so you can set it to anything
        for now.

        When  this  step  is finished, you will almost  have  a  prepared
        adventure diskette. There are three steps left before you will be
        ready to add data to the files:

                1.  Copy  LEADIN.EXE  from  the  DDD  to  your  adventure
        diskette.

                2. Type an explanation of the mission into MISSION.TXT. A
        word processor or text editor may be used to do this , or you may
        use the DOS copy function to copy console to disk.

                3. Copy MAINPGM from the DDD to your adventure.

        You now have a diskette ready to edit the data files onto.




        Part 4 --- Editing the files

        The next step is to edit the files on the adventure diskette. The
        rooms, artifacts, effects and monsters will be added to the files
        in this manner.

        To do this you run the program DUNGEDIT.

        The  DUNGEDIT  program has all the functions needed  to  add  all
        items  you need to the adventure. You may add or change any  item
        on the diskette, but you cannot actually delete anything.

        The functions available in this program are:

                Add a room, artifact, effect or monster
                Edit a room, artifact, effect or monster
                List names of rooms, artifacts or monsters.
                List effects
                Replace a room, artifact, effect or monster
                Duplicate a room, artifact, effect or monster
                Generate dead bodies


        The  normal  functions you would be using a lot are add  a  room,
        artifact,  and monsters; editing rooms, artifacts  and  monsters;
        and possibly listing names of rooms, artifacts and monsters.  The
        other functions are nice to have and are useful, but are not used
        repeatedly.

        When  you  add a room, artifact or monster, you will be  given  a
        screen with the next number on the list and be asked for the name
        of the item. The name should be from 1 to 20 characters.

        Room  names will be preceeded by "You are " when printed  by  the
        base  program  later,  so  you  should  make  your   descriptions
        something  like "in a ..." or "standing ...". Monster  names  and
        artifact names are not preceeded by anything when printed by  the
        base program.

        You  will then be asked for a description of the item.  You  have
        255  characters (approximately 3 lines) to use  for  description.
        Commas and colons are allowed, but quotes are not.

        The next fields will be the data required for that type of  item.
        For rooms it will be the room numbers you may enter from the room
        currently   being  edited.  For  monsters  it  will  be   his/her
        hardiness,   agility,   friendliness,  courage,   room,   weight,
        defensive  odds, armour, weapon number, offensive odds, dice  and
        sides. For artifacts it will be the value, type, weight and  room
        as  well as any additional information the program may  need  for
        the type of artifact being entered.





        Part 5 - Modifying the Base program

        When  you  have the files built the way you want them,  you  must
        decide what programming must be done to make the special  effects
        happen.

        This  is the trickiest part of making your own adventure, but  is
        the most fun and makes the adventure unique.

        The  first thing you have to do is lay out exactly what you  want
        to do. You also have to know how much the program will do for you
        without any programming.

        In order to do the program changes, you will need to know how the
        program  works,  what variables are available and what  they  are
        used for, where each of the routines are and how they work.

        The main routines in the program are:

                INIT.RTN - Initialize routine
                GAME.OVER - End of game
                MOVE.RTN - Move routine
                GET.RTN - Get routine
                DROP.RTN - Drop routine
                LOOK.RTN - Examine/Look routine
                ATTACK.RTN - Attack routine
                TAKE.A.SWING - attack subroutine
                FLEE.RTN - Flee
                GIVE.RTN - Give
                INVENTORY - Inventory items carried
                BLAST.SPELL - Blast Spell routine
                HEAL.SPELL - Heal Spell Routine
                POWER.SPELL - Power Spell Routine
                SPEED.SPELL - Speed Spell Routine
                SMILE.RTN - Smile
                SAY.SOMETHING - Say routine
                READY.WEAPON - Ready a weapon
                LIGHT.RTN - Light a torch or lantern
                OPEN.RTN - Open a container or door
                DRINK.RTN - Drink a healing potion
                PUT.RTN - Put something into a container
                FREE.RTN - Free a bound monster
                READ.RTN - Read a book, or other item


