    '                     CVTEAMON
    '
    '                   Version 2.00
    '
    '      Convert Sequential Eamon Files to Random
    ' 
    '                  for the IBM-PC
    '
    '                  by John Nelson
    '
DECLARE SUB textio (I$, DF$, ESC, BK)
    CLS
    LOCATE 6, 1
    LINE INPUT "Insert Diskette with sequential files and enter PATH:", PATH.S$
    CLS
    LOCATE 6, 1
    LINE INPUT "Insert Eamon Adventure and enter PATH:", PATH.R$
    OPEN PATH.S$ + "DESC.R0" FOR INPUT AS #1
    INPUT #1, N.ROOM
    INPUT #1, N.ART
    INPUT #1, N.EFF
    INPUT #1, N.MON
    CLOSE 1
    ND = 0
    WHILE ND <> 6 AND ND <> 10
    CLS
    LOCATE 6, 1
    LINE INPUT "Number of directions (6/10):", ND$
    ND = VAL(ND$)
    WEND
    CLS
    LOCATE 6, 1
    PRINT "Does ROOMS file have a separator record between each rooms"
    PRINT "directions? If so, enter 'Y' else enter 'N' or '?'";
    A$ = INPUT$(1)
    IF A$ = "?" THEN
        OPEN PATH.S$ + "ROOMS.SEQ" FOR INPUT AS #1
        INPUT #1, X$
        IF X$ = "" THEN A$ = "Y" ELSE A$ = "N"
        LOCATE 7, 52
        PRINT A$
        CLOSE
    END IF
    RM.ID$ = UCASE$(A$)
    LOCATE 8, 1
    PRINT "Edit Descriptions (y/n):";
    YN$ = ""
    WHILE UCASE$(YN$) <> "Y" AND UCASE$(YN$) <> "N"
      YN$ = INKEY$
      EDIT.MODE$ = UCASE$(YN$)
    WEND
    PRINT EDIT.MODE$
    LOCATE 10, 1
    PRINT "Convert Rooms (Y/N):";
    CVT.ROOM$ = ""
    WHILE CVT.ROOM$ <> "Y" AND CVT.ROOM$ <> "N"
      YN$ = INKEY$
      CVT.ROOM$ = UCASE$(YN$)
    WEND
    PRINT CVT.ROOM$
    LOCATE 12, 1
    PRINT "Convert Room Names (Y/N):";
    CVT.RMN$ = ""
    WHILE CVT.RMN$ <> "Y" AND CVT.RMN$ <> "N"
      YN$ = INKEY$
      CVT.RMN$ = UCASE$(YN$)
    WEND
    PRINT CVT.RMN$
    LOCATE 14, 1
    PRINT "Convert Artifacts (Y/N):";
    CVT.ART$ = ""
    WHILE CVT.ART$ <> "Y" AND CVT.ART$ <> "N"
      YN$ = INKEY$
      CVT.ART$ = UCASE$(YN$)
    WEND
    PRINT CVT.ART$
    LOCATE 16, 1
    PRINT "Convert Monsters (Y/N):";
    CVT.MON$ = ""
    WHILE CVT.MON$ <> "Y" AND CVT.MON$ <> "N"
      YN$ = INKEY$
      CVT.MON$ = UCASE$(YN$)
    WEND
    PRINT CVT.MON$
    LOCATE 18, 1
    PRINT "Convert Descriptions (Y/N):";
    CVT.DESC$ = ""
    WHILE CVT.DESC$ <> "Y" AND CVT.DESC$ <> "N"
      YN$ = INKEY$
      CVT.DESC$ = UCASE$(YN$)
    WEND
    PRINT CVT.DESC$
    IF CVT.DESC$ = "N" THEN GOTO DO.CONVERSION
    LOCATE 20, 1
    PRINT "Adjust Description Spacing (best guess) (Y/N):";
    ADJ.SPACE$ = ""
    WHILE ADJ.SPACE$ <> "Y" AND ADJ.SPACE$ <> "N"
        YN$ = INKEY$
        ADJ.SPACE$ = UCASE$(YN$)
    WEND
    PRINT ADJ.SPACE$
DO.CONVERSION:
    CLS
    GOSUB CONVERT.ROOMS
    GOSUB CONVERT.RMNAMES
    GOSUB CONVERT.ART
    GOSUB CONVERT.MON
    GOSUB CONVERT.DESC
    GOTO END.JOB
CONVERT.ROOMS:
    IF CVT.ROOM$ = "N" THEN RETURN
    LOCATE 1, 1
    PRINT "Converting Rooms ...               "
    LOCATE 3, 4
    PRINT "Room "
    OPEN PATH.S$ + "ROOMS.SEQ" FOR INPUT AS #1
    OPEN "R", #2, PATH.R$ + "ROOMS.TXT", 64
    DIM RD$(10), RD%(10)
    FOR D = 1 TO ND
    FIELD #2, (D - 1) * 2 AS X$, 2 AS RD$(D)
    NEXT
    FOR R = 1 TO N.ROOM
    LOCATE 3, 17
    PRINT USING "###"; R
    IF RM.ID$ = "Y" THEN
        INPUT #1, R.ID$
        LOCATE 3, 21
        PRINT R.ID$
        IF VAL(R.ID$) > 0 THEN
            LOCATE 24, 1
            PRINT "Error --- Room id is numeric MAY BE MIS-ALIGNED"
            CLOSE
            END
        END IF
    END IF
    FOR D = 1 TO ND
    INPUT #1, RD%(D)
    NEXT
    FOR D = 1 TO ND
    RSET RD$(D) = MKI$(RD%(D))
    NEXT
    PUT #2, R
    NEXT
    CLOSE
    LOCATE 3, 21
    PRINT "Complete" + SPACE$(50)
    RETURN
CONVERT.RMNAMES:
    IF CVT.RMN$ = "N" THEN RETURN
    LOCATE 1, 1
    PRINT "Converting Room Names ...       "
    LOCATE 5, 4
    PRINT "Room Name"
    OPEN PATH.S$ + "RMNAMES.SEQ" FOR INPUT AS #1
    OPEN "R", #2, PATH.R$ + "RMNAMES.TXT", 64
    FIELD #2, 64 AS RMNM$
    FOR R = 1 TO N.ROOM
    LOCATE 5, 17
    PRINT USING "###"; R
    INPUT #1, RM$
    LOCATE 5, 21
    PRINT LCASE$(RM$) + SPACE$(60 - LEN(RM$))
    LSET RMNM$ = LCASE$(RM$)
    PUT #2, R
    NEXT
    LOCATE 5, 21
    PRINT "Complete" + SPACE$(50)
    CLOSE
    RETURN
CONVERT.ART:
    IF CVT.ART$ = "N" THEN RETURN
    LOCATE 1, 1
    PRINT "Converting Artifacts ..."
    LOCATE 7, 4
    PRINT "Artifact"
    OPEN PATH.S$ + "ARTIF.SEQ" FOR INPUT AS #1
    OPEN "R", #2, PATH.R$ + "ARTIF.TXT", 128
    DIM ART$(8), AD%(8)
    FIELD #2, 20 AS ARTNAM$, 2 AS ART$(1), 2 AS ART$(2), 2 AS ART$(3), 2 AS ART$(4), 2 AS ART$(5), 2 AS ART$(6), 2 AS ART$(7), 2 AS ART$(8)
    FOR R = 1 TO N.ART
    LOCATE 7, 17
    PRINT USING "###"; R
    INPUT #1, AN$
    LOCATE 7, 21
    PRINT LEFT$(LCASE$(AN$) + SPACE$(60), 58)
    FOR M = 1 TO 8
    INPUT #1, AD%(M)
    NEXT
    GOSUB PROCESS.ART.NAME
    LSET ARTNAM$ = AN$
    FOR M = 1 TO 8
    LSET ART$(M) = MKI$(AD%(M))
    NEXT
    PUT #2, R
    NEXT
    LOCATE 7, 21
    PRINT "Completed" + SPACE$(50)
    CLOSE
    RETURN
PROCESS.ART.NAME:
    IF UCASE$(LEFT$(AN$, 5)) <> "DEAD " THEN AN$ = LCASE$(AN$): RETURN
    MN$ = MID$(AN$, 6)
    GOSUB PROCESS.MON.NAME
    AN$ = "dead " + MN$
    RETURN
CONVERT.MON:
    IF CVT.MON$ = "N" THEN RETURN
    LOCATE 1, 1
    PRINT "Converting Monsters ...                 "
    LOCATE 9, 4
    PRINT "Monster"
    OPEN PATH.S$ + "MONST.SEQ" FOR INPUT AS #1
    OPEN "R", #2, PATH.R$ + "MONST.TXT", 128
    DIM MON$(12), MD%(12)
    FIELD #2, 20 AS MONNAM$, 2 AS MON$(1), 2 AS MON$(2), 2 AS MON$(3), 2 AS MON$(4), 2 AS MON$(5), 2 AS MON$(6), 2 AS MON$(7), 2 AS MON$(8), 2 AS MON$(9), 2 AS MON$(10), 2 AS MON$(11), 2 AS MON$(12)
    FOR R = 1 TO N.MON
        LOCATE 9, 17
        PRINT USING "###"; R
        INPUT #1, MN$
        GOSUB PROCESS.MON.NAME
        LOCATE 9, 21
        PRINT LEFT$(MN$ + SPACE$(50), 50)
        FOR M = 1 TO 12
          INPUT #1, MD%(M)
        NEXT
        LSET MONNAM$ = MN$
      FOR M = 1 TO 12
        LSET MON$(M) = MKI$(MD%(M))
      NEXT
      PUT #2, R
    NEXT
    CLOSE
    RETURN
PROCESS.MON.NAME:
    MN$ = UCASE$(LEFT$(MN$, 1)) + LCASE$(MID$(MN$, 2))
    MN$ = RTRIM$(MN$)
    S = 1
FIND.EMB.SPC.MN:       '  Find embedded spaces in monster name
    SF = INSTR(S, MN$, " ")
    IF SF = 0 THEN RETURN
    S = SF + 1
    MID$(MN$, S, 1) = UCASE$(MID$(MN$, S, 1))
    GOTO FIND.EMB.SPC.MN
CONVERT.DESC:
    IF CVT.DESC$ = "N" THEN RETURN
    OPEN PATH.S$ + "DESC.SEQ" FOR INPUT AS #1
    OPEN "R", #2, PATH.R$ + "DESC.TXT", 256
    FIELD #2, 255 AS DF.DESC$
' -------------------------------------------------------------------
'                    Convert Room Descriptions
' -------------------------------------------------------------------
    LOCATE 1, 1
    PRINT "Converting Descriptions ... "
    LOCATE 11, 4
    PRINT "Description"
    FOR R = 1 TO N.ROOM
    LOCATE 11, 17
    PRINT "Room"
    LOCATE 11, 27
    PRINT USING "###"; R
    INPUT #1, DESC$
    LOCATE 18, 1
    PRINT DESC$ + SPACE$(255)
    N = 1
    GOSUB PROCESS.DESC
    IF ADJ.SPACE$ = "Y" THEN GOSUB SPACE.DESC
    LOCATE 18, 1
    PRINT DESC$
    IF LEFT$(EDIT.MODE$, 1) = "Y" THEN GOSUB CONVERT.LC
    LSET DF.DESC$ = DESC$
    PUT #2, R
    NEXT
' -------------------------------------------------------------------
'                    Convert Artifact Descriptions
' -------------------------------------------------------------------
    FOR R = 1 TO N.ART
    LOCATE 12, 17
    PRINT "Artifact"
    LOCATE 12, 27
    PRINT USING "###"; R
    INPUT #1, DESC$
    LOCATE 18, 1
    PRINT DESC$ + SPACE$(255)
    GOSUB PROCESS.DESC
    IF ADJ.SPACE$ = "Y" THEN GOSUB SPACE.DESC
    LOCATE 18, 1
    PRINT DESC$
    IF LEFT$(EDIT.MODE$, 1) = "Y" THEN GOSUB CONVERT.LC
    LSET DF.DESC$ = DESC$
    PUT #2, R + 100
    NEXT
' -------------------------------------------------------------------
'                       Convert Effects
' -------------------------------------------------------------------
    FOR R = 1 TO N.EFF
    LOCATE 13, 17
    PRINT "Effect"
    LOCATE 13, 27
    PRINT USING "###"; R
    INPUT #1, DESC$
    LOCATE 18, 1
    PRINT DESC$ + SPACE$(255)
    GOSUB PROCESS.DESC
    IF ADJ.SPACE$ = "Y" THEN GOSUB SPACE.DESC
    LOCATE 18, 1
    PRINT DESC$
    IF LEFT$(EDIT.MODE$, 1) = "Y" THEN GOSUB CONVERT.LC
    LSET DF.DESC$ = DESC$
    PUT #2, R + 200
    NEXT
' -------------------------------------------------------------------
'                    Convert Monster Descriptions
' -------------------------------------------------------------------
    FOR R = 1 TO N.MON
    LOCATE 14, 17
    PRINT "Monster"
    LOCATE 14, 27
    PRINT USING "###"; R
    INPUT #1, DESC$
    LOCATE 18, 1
    PRINT DESC$ + SPACE$(255)
    N = 1
    GOSUB PROCESS.DESC
    IF ADJ.SPACE$ = "Y" THEN GOSUB SPACE.DESC
    LOCATE 18, 1
    PRINT DESC$
    IF LEFT$(EDIT.MODE$, 1) = "Y" THEN GOSUB CONVERT.LC
    LSET DF.DESC$ = DESC$
    PUT #2, R + 300
    NEXT
    RETURN
CONVERT.LC:
    DF$ = DESC$
    GOSUB EDIT.IT
    DESC$ = I$
    RETURN
EDIT.IT:
    LOCATE 18, 1
    PRINT SPACE$(255)
    LOCATE 18, 1
    ESC = 0
    BK = 0
    textio I$, DF$, ESC, BK
    RETURN
END.JOB:
    CLOSE
    LOCATE 20, 10
    PRINT "Conversion Complete"
    END
PROCESS.DESC:
    IF DESC$ = "" THEN RETURN
    DESC$ = LCASE$(DESC$)
    MID$(DESC$, 1, 1) = UCASE$(MID$(DESC$, 1, 1))
find.per:
    pf = INSTR(N, DESC$, ".")
    xf = INSTR(N, DESC$, "!")
    qf = INSTR(N, DESC$, "?")
    IF pf = 0 AND xf = 0 AND qf = 0 AND N < LEN(DESC$) THEN DESC$ = DESC$ + ".": GOTO find.per
    IF pf > 0 THEN p = pf ELSE p = LEN(DESC$)
    IF xf > 0 AND xf < p THEN p = xf
    IF qf > 0 AND qf < p THEN p = qf
    IF p > 0 THEN N = p + 1
    IF N >= LEN(DESC$) THEN RETURN
    WHILE (MID$(DESC$, N, 1) < "a" OR MID$(DESC$, N, 1) > "z") AND N <= LEN(DESC$)
        N = N + 1
    WEND
    IF N >= LEN(DESC$) THEN RETURN
    MID$(DESC$, N, 1) = UCASE$(MID$(DESC$, N, 1))
    GOTO find.per
SPACE.DESC:
    abd = 0
    FOR X = 40 TO LEN(DESC$) STEP 40
        IF MID$(DESC$, X, 1) <> " " THEN
            DESC$ = LEFT$(DESC$, X + abd) + " " + MID$(DESC$, X + 1 + abd)
            abd = abd + 1
        END IF
    NEXT
    RETURN


    SUB textio (I$, DF$, ESC, BK) STATIC
'                This is a generic text build I/O routine
'
'
'
'
' -------------------------------------------------------------------
'                   TEXTIO Routine
' -------------------------------------------------------------------
TEXTIO.RTN:
     V% = CSRLIN: H% = POS(1)
     TRUE = -1
     BK = 0
     INS.CHR$ = CHR$(0) + CHR$(82)
     DEL.CHR$ = CHR$(0) + CHR$(83)
     UP.CHR$ = CHR$(0) + CHR$(72)
     DN.CHR$ = CHR$(0) + CHR$(80)
     END.CHR$ = CHR$(0) + CHR$(79)
     HOME.CHR$ = CHR$(0) + CHR$(71)
     LEFT.CHR$ = CHR$(0) + CHR$(75)
     RIGHT.CHR$ = CHR$(0) + CHR$(77)
     CTL.END$ = CHR$(0) + CHR$(117)
     UPPER.CASE$ = CHR$(21)
     LOWER.CASE$ = CHR$(12)
     SHIFT$ = CHR$(19)
     FIND.CHR$ = CHR$(6)
     ESC.CHR$ = CHR$(27)
BUILD.TEXT:
     LOCATE V%, H%
     PRINT DF$;
     LOCATE V%, H%
     I$ = ""
BLD.TEXT:
     GOSUB TIO.GET.BYTE
     IF A$ = FIND.CHR$ THEN
         STP = 2
         GOSUB FIND.A.CHAR
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(13) THEN
         LOCATE , , 0
         I$ = I$ + DF$
         DF$ = ""
         LOCATE V%, H%
         PRINT I$;
         EXIT SUB
     END IF
     IF A$ = ESC.CHR$ AND LEN(I$) = 0 THEN
         ESC = TRUE
         EXIT SUB
     END IF
     IF A$ = ESC.CHR$ THEN EXIT SUB
     IF A$ >= CHR$(32) THEN
         I$ = I$ + A$
         DF$ = MID$(DF$, 2)
         PRINT A$;
         GOTO BLD.TEXT
     END IF
     IF A$ = END.CHR$ THEN
         I$ = I$ + DF$
         DF$ = ""
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = CTL.END$ THEN
         S.V = CSRLIN
         S.H = POS(1)
         LOCATE , , 0
         SP = LEN(DF$)
         IF SP > 0 THEN PRINT SPC(SP);
         DF$ = ""
         LOCATE S.V, S.H
         GOTO BLD.TEXT
     END IF
     IF A$ = HOME.CHR$ THEN
         DF$ = I$ + DF$
         I$ = ""
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = LEFT.CHR$ AND LEN(I$) > 1 THEN
         DF$ = RIGHT$(I$, 1) + DF$
         I$ = LEFT$(I$, LEN(I$) - 1)
         PRINT CHR$(29);
         GOTO BLD.TEXT
     END IF
     IF A$ = LEFT.CHR$ AND LEN(I$) = 1 THEN
         DF$ = I$ + DF$
         I$ = ""
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = LEFT.CHR$ AND LEN(I$) < 1 THEN
         BK = -1
         I$ = I$ + DF$
         EXIT SUB
     END IF
     IF A$ = RIGHT.CHR$ AND LEN(DF$) > 0 THEN
         I$ = I$ + LEFT$(DF$, 1)
         DF$ = MID$(DF$, 2)
         PRINT RIGHT$(I$, 1);
         GOTO BLD.TEXT
     END IF
     IF A$ = DN.CHR$ THEN
         I$ = I$ + LEFT$(DF$ + SPACE$(80), 80)
         DF$ = RTRIM$(MID$(DF$ + SPACE$(80), 81))
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = UP.CHR$ AND LEN(I$) >= 80 THEN
         DF$ = RIGHT$(I$, 80) + DF$
         I$ = LEFT$(I$, LEN(I$) - 80)
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = INS.CHR$ AND LEN(I$) > 0 THEN
         DF$ = " " + DF$
         LOCATE V%, H%
         PRINT I$ + DF$ + STRING$(LEN(DF$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = INS.CHR$ AND LEN(I$) = 0 THEN
         LOCATE V%, H%
         PRINT " " + DF$;
         DF$ = " " + DF$
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = DEL.CHR$ AND LEN(I$) = 0 THEN
         DF$ = MID$(DF$, 2)
         LOCATE V%, H%
         PRINT DF$ + " " + STRING$(LEN(DF$) + 1, 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = DEL.CHR$ THEN
         DF$ = MID$(DF$, 2)
         LOCATE V%, H%
         PRINT I$ + DF$ + " " + STRING$(LEN(DF$) + 1, 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = UPPER.CASE$ THEN
         I$ = UCASE$(I$)
         DF$ = UCASE$(DF$)
         LOCATE V%, H%
         PRINT I$ + DF$ + STRING$(LEN(DF$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = LOWER.CASE$ THEN
         I$ = LCASE$(I$)
         DF$ = LCASE$(DF$)
         LOCATE V%, H%
         PRINT I$ + DF$ + STRING$(LEN(DF$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = SHIFT$ THEN
         IF LEFT$(DF$, 1) >= "A" THEN
             DF$ = CHR$(ASC(LEFT$(DF$, 1)) - 32) + MID$(DF$, 2)
             PRINT LEFT$(DF$, 1) + CHR$(29);
             GOTO BLD.TEXT
        ELSE
             IF LEFT$(DF$, 1) >= "A" AND LEFT$(DF$, 1) <= "Z" THEN
                 DF$ = CHR$(ASC(LEFT$(DF$, 1)) + 32) + DF$
                 PRINT LEFT$(DF$, 1) + CHR$(29);
                 GOTO BLD.TEXT
             END IF
        END IF
     END IF
     BEEP
     GOTO BLD.TEXT
FIND.A.CHAR:
     GOSUB TIO.GET.BYTE
     SAVE.FIND$ = A$
LOOK.AGAIN:
     A = INSTR(STP, DF$, SAVE.FIND$)
     IF A = 0 THEN
         I$ = I$ + DF$
         DF$ = ""
         LOCATE V%, H%
         PRINT I$;
         RETURN
     END IF
     I$ = I$ + LEFT$(DF$, A - 1)
     DF$ = MID$(DF$, A)
     LOCATE V%, H%
     PRINT I$;
     GOSUB TIO.GET.BYTE
     IF A$ <> SAVE.FIND$ THEN RETURN
     GOTO LOOK.AGAIN
TIO.GET.BYTE:
     LOCATE , , 1, 4, 7
     A$ = ""
     WHILE A$ = ""
         A$ = INKEY$
     WEND
     RETURN
END SUB

