    '                     CVTEAMON 2
    '
    '                   Version 1.00
    '
    '      Convert Eamon Files from Field usage to Record usage
    '
    '                  for the IBM-PC
    '
    '                  by John Nelson
    '
    DECLARE SUB textio (I$, DF$, ESC, BK)
    REM $INCLUDE: '\eamon\copy\advrecs.bas'
    CLS
    LOCATE 6, 1
    LINE INPUT "Input adventure number:", Advno$
    PATH$ = "ADV" + RIGHT$("000" + RTRIM$(LTRIM$(Advno$)), 3) + "\"
    OPEN PATH$ + "DESC.R0" FOR INPUT AS #1
    INPUT #1, N.ROOM
    INPUT #1, N.ART
    INPUT #1, N.EFF
    INPUT #1, N.MON
    CLOSE 1
    CLS
DO.CONVERSION:
    CLS
    GOSUB CONVERT.ROOMS
    GOSUB CONVERT.ART
    GOSUB CONVERT.MON
    GOSUB CONVERT.DESC
    GOTO END.JOB
CONVERT.ROOMS:
    LOCATE 1, 1
    PRINT "Converting Rooms ...               "
    LOCATE 3, 4
    PRINT "Room "
    OPEN PATH$ + "RMNAMES.TXT" FOR RANDOM AS #3 LEN = 64
    FIELD #3, 64 AS RMNM$
    OPEN PATH$ + "ROOMS.TXT" FOR RANDOM AS #1 LEN = 64
    OPEN PATH$ + "ROOMS.DAT" FOR RANDOM AS #2 LEN = LEN(Room)
    DIM RD$(10), RD%(10)
    FOR D = 1 TO ND
    FIELD #2, (D - 1) * 2 AS X$, 2 AS RD$(D)
    NEXT
    FOR R = 1 TO N.ROOM
      LOCATE 3, 17
      PRINT USING "###"; R
      GET #1, R
      GET #3, R
      FOR D = 1 TO 6
        RD%(D) = VAL(RD$(D))
      NEXT
      Room.Nam = RMNM$
      Room.North = RD%(1)
      Room.South = RD%(2)
      Room.East = RD%(3)
      Room.West = RD%(4)
      Room.UP = RD%(5)
      Room.Down = RD%(6)
      Room.NE = RD%(7)
      Room.NW = RD%(8)
      Room.SE = RD%(9)
      Room.SW = RD%(10)
      PUT #2, R, Room
    NEXT
    CLOSE
    LOCATE 3, 21
    PRINT "Complete" + SPACE$(50)
    RETURN
CONVERT.ART:
    LOCATE 1, 1
    PRINT "Converting Artifacts ..."
    LOCATE 7, 4
    PRINT "Artifact"
    OPEN PATH$ + "ARTIF.TXT" FOR RANDOM AS #2 LEN = 128
    OPEN PATH$ + "Artif.Dat" FOR RANDOM AS #3 LEN = LEN(Artifact)
    DIM art$(8), AD%(8)
    FIELD #2, 20 AS Artnam$, 2 AS art$(1), 2 AS art$(2), 2 AS art$(3), 2 AS art$(4), 2 AS art$(5), 2 AS art$(6), 2 AS art$(7), 2 AS art$(8)
    FOR R = 1 TO N.ART
    LOCATE 7, 17
    PRINT USING "###"; R
    GET #2, R
    LOCATE 7, 21
    PRINT LEFT$(LCASE$(AN$) + SPACE$(60), 58)
    Artifact.Value = VAL(art$(1))
    Artifact.typ = VAL(art$(2))
    Artifact.Weight = VAL(art$(3))
    Artifact.Room = VAL(art$(4))
    Artifact.wpntyp = VAL(art$(5))
    Artifact.odds = VAL(art$(6))
    Artifact.Dice = VAL(art$(7))
    Artifact.Sides = VAL(art$(8))
    Artifact.Nam = Artnam$
    PUT #3, R, Artifact
    NEXT
    LOCATE 7, 21
    PRINT "Completed" + SPACE$(50)
    CLOSE
    RETURN
CONVERT.MON:
    LOCATE 1, 1
    PRINT "Converting Monsters ...                 "
    LOCATE 9, 4
    PRINT "Monster"
    OPEN PATH$ + "MONST.txt" FOR RANDOM AS #1 LEN = 128
    OPEN PATH$ + "MONST.dat" FOR RANDOM AS #2 LEN = 128
    DIM mon$(12), MD%(12)
    FIELD #1, 20 AS MONNAM$, 2 AS mon$(1), 2 AS mon$(2), 2 AS mon$(3), 2 AS mon$(4), 2 AS mon$(5), 2 AS mon$(6), 2 AS mon$(7), 2 AS mon$(8), 2 AS mon$(9), 2 AS mon$(10), 2 AS mon$(11), 2 AS mon$(12)
    FOR R = 1 TO N.MON
        LOCATE 9, 17
        PRINT USING "###"; R
        GET #1, R
        LOCATE 9, 21
        PRINT LEFT$(MN$ + SPACE$(50), 50)
        Monster.Hd = VAL(mon$(1))
        Monster.Ag = VAL(mon$(2))
        Monster.Friend = VAL(mon$(3))
        Monster.Courage = VAL(mon$(4))
        Monster.Room = VAL(mon$(5))
        Monster.Weight = VAL(mon$(6))
        Monster.DefOdds = VAL(mon$(7))
        Monster.Armor = VAL(mon$(8))
        Monster.Weapon = VAL(mon$(9))
        Monster.OffOdds = VAL(mon$(10))
        Monster.Dice = VAL(mon$(11))
        Monster.Sides = VAL(mon$(12))
        Monster.Nam = MONNAM$
        PUT #2, R, Monster
    NEXT
    CLOSE
    RETURN
CONVERT.DESC:
    IF CVT.DESC$ = "N" THEN RETURN
    OPEN PATH$ + "DESC.TXT" FOR RANDOM AS #1 LEN = 256
    OPEN "Desc.Dat" FOR RANDOM AS #2 LEN = LEN(Desc)
    FIELD #1, 255 AS DF.Desc$
' -------------------------------------------------------------------
'                    Convert Room Descriptions
' -------------------------------------------------------------------
    LOCATE 1, 1
    PRINT "Converting Descriptions ... "
    LOCATE 11, 4
    PRINT "Description"
    FOR R = 1 TO N.ROOM
    LOCATE 11, 17
    PRINT "Room"
    LOCATE 11, 27
    PRINT USING "###"; R
    GET #1, R
    LOCATE 18, 1
    PRINT DF.Desc$ + SPACE$(255)
    N = 1
    LOCATE 18, 1
    Desc.Desc = DF.Desc$
    PUT #2, R, Desc
    NEXT
' -------------------------------------------------------------------
'                    Convert Artifact Descriptions
' -------------------------------------------------------------------
    FOR R = 1 TO N.ART
    LOCATE 12, 17
    PRINT "Artifact"
    LOCATE 12, 27
    PRINT USING "###"; R
    GET #1, R + 100
    LOCATE 18, 1
    PRINT DF.Desc$ + SPACE$(255)
    LOCATE 18, 1
    PRINT DF.Desc$
    Desc.Desc$ = DF.Desc$
    PUT #2, R + 100, Desc
    NEXT
' -------------------------------------------------------------------
'                       Convert Effects
' -------------------------------------------------------------------
    FOR R = 1 TO N.EFF
    LOCATE 13, 17
    PRINT "Effect"
    LOCATE 13, 27
    PRINT USING "###"; R
    GET #1, R + 200
    LOCATE 18, 1
    PRINT DF.Desc$ + SPACE$(255)
    LOCATE 18, 1
    PRINT DF.Desc$
    Desc.Desc$ = DF.Desc$
    PUT #2, R + 200, Desc
    NEXT
' -------------------------------------------------------------------
'                    Convert Monster Descriptions
' -------------------------------------------------------------------
    FOR R = 1 TO N.MON
    LOCATE 14, 17
    PRINT "Monster"
    LOCATE 14, 27
    PRINT USING "###"; R
    GET #1, R + 300
    LOCATE 18, 1
    PRINT DF.Desc$ + SPACE$(255)
    N = 1
    LOCATE 18, 1
    PRINT DF.Desc$
    Desc.Desc$ = DF.Desc$
    PUT #2, R + 300, Desc
    NEXT
    RETURN
END.JOB:
    CLOSE
    LOCATE 20, 10
    PRINT "Conversion Complete"
    END

    SUB textio (I$, DF$, ESC, BK) STATIC
'                This is a generic text build I/O routine
'
'
'
'
' -------------------------------------------------------------------
'                   TEXTIO Routine
' -------------------------------------------------------------------
TEXTIO.RTN:
     V% = CSRLIN: H% = POS(1)
     TRUE = -1
     BK = 0
     INS.CHR$ = CHR$(0) + CHR$(82)
     DEL.CHR$ = CHR$(0) + CHR$(83)
     UP.CHR$ = CHR$(0) + CHR$(72)
     DN.CHR$ = CHR$(0) + CHR$(80)
     END.CHR$ = CHR$(0) + CHR$(79)
     HOME.CHR$ = CHR$(0) + CHR$(71)
     LEFT.CHR$ = CHR$(0) + CHR$(75)
     RIGHT.CHR$ = CHR$(0) + CHR$(77)
     CTL.END$ = CHR$(0) + CHR$(117)
     UPPER.CASE$ = CHR$(21)
     LOWER.CASE$ = CHR$(12)
     SHIFT$ = CHR$(19)
     FIND.CHR$ = CHR$(6)
     ESC.CHR$ = CHR$(27)
BUILD.TEXT:
     LOCATE V%, H%
     PRINT DF$;
     LOCATE V%, H%
     I$ = ""
BLD.TEXT:
     GOSUB TIO.GET.BYTE
     IF A$ = FIND.CHR$ THEN
         STP = 2
         GOSUB FIND.A.CHAR
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(13) THEN
         LOCATE , , 0
         I$ = I$ + DF$
         DF$ = ""
         LOCATE V%, H%
         PRINT I$;
         EXIT SUB
     END IF
     IF A$ = ESC.CHR$ AND LEN(I$) = 0 THEN
         ESC = TRUE
         EXIT SUB
     END IF
     IF A$ = ESC.CHR$ THEN EXIT SUB
     IF A$ >= CHR$(32) THEN
         I$ = I$ + A$
         DF$ = MID$(DF$, 2)
         PRINT A$;
         GOTO BLD.TEXT
     END IF
     IF A$ = END.CHR$ THEN
         I$ = I$ + DF$
         DF$ = ""
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = CTL.END$ THEN
         S.V = CSRLIN
         S.H = POS(1)
         LOCATE , , 0
         SP = LEN(DF$)
         IF SP > 0 THEN PRINT SPC(SP);
         DF$ = ""
         LOCATE S.V, S.H
         GOTO BLD.TEXT
     END IF
     IF A$ = HOME.CHR$ THEN
         DF$ = I$ + DF$
         I$ = ""
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = LEFT.CHR$ AND LEN(I$) > 1 THEN
         DF$ = RIGHT$(I$, 1) + DF$
         I$ = LEFT$(I$, LEN(I$) - 1)
         PRINT CHR$(29);
         GOTO BLD.TEXT
     END IF
     IF A$ = LEFT.CHR$ AND LEN(I$) = 1 THEN
         DF$ = I$ + DF$
         I$ = ""
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = LEFT.CHR$ AND LEN(I$) < 1 THEN
         BK = -1
         I$ = I$ + DF$
         EXIT SUB
     END IF
     IF A$ = RIGHT.CHR$ AND LEN(DF$) > 0 THEN
         I$ = I$ + LEFT$(DF$, 1)
         DF$ = MID$(DF$, 2)
         PRINT RIGHT$(I$, 1);
         GOTO BLD.TEXT
     END IF
     IF A$ = DN.CHR$ THEN
         I$ = I$ + LEFT$(DF$ + SPACE$(80), 80)
         DF$ = RTRIM$(MID$(DF$ + SPACE$(80), 81))
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = UP.CHR$ AND LEN(I$) >= 80 THEN
         DF$ = RIGHT$(I$, 80) + DF$
         I$ = LEFT$(I$, LEN(I$) - 80)
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = INS.CHR$ AND LEN(I$) > 0 THEN
         DF$ = " " + DF$
         LOCATE V%, H%
         PRINT I$ + DF$ + STRING$(LEN(DF$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = INS.CHR$ AND LEN(I$) = 0 THEN
         LOCATE V%, H%
         PRINT " " + DF$;
         DF$ = " " + DF$
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = DEL.CHR$ AND LEN(I$) = 0 THEN
         DF$ = MID$(DF$, 2)
         LOCATE V%, H%
         PRINT DF$ + " " + STRING$(LEN(DF$) + 1, 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = DEL.CHR$ THEN
         DF$ = MID$(DF$, 2)
         LOCATE V%, H%
         PRINT I$ + DF$ + " " + STRING$(LEN(DF$) + 1, 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = UPPER.CASE$ THEN
         I$ = UCASE$(I$)
         DF$ = UCASE$(DF$)
         LOCATE V%, H%
         PRINT I$ + DF$ + STRING$(LEN(DF$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = LOWER.CASE$ THEN
         I$ = LCASE$(I$)
         DF$ = LCASE$(DF$)
         LOCATE V%, H%
         PRINT I$ + DF$ + STRING$(LEN(DF$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = SHIFT$ THEN
         IF LEFT$(DF$, 1) >= "A" THEN
             DF$ = CHR$(ASC(LEFT$(DF$, 1)) - 32) + MID$(DF$, 2)
             PRINT LEFT$(DF$, 1) + CHR$(29);
             GOTO BLD.TEXT
        ELSE
             IF LEFT$(DF$, 1) >= "A" AND LEFT$(DF$, 1) <= "Z" THEN
                 DF$ = CHR$(ASC(LEFT$(DF$, 1)) + 32) + DF$
                 PRINT LEFT$(DF$, 1) + CHR$(29);
                 GOTO BLD.TEXT
             END IF
        END IF
     END IF
     BEEP
     GOTO BLD.TEXT
FIND.A.CHAR:
     GOSUB TIO.GET.BYTE
     SAVE.FIND$ = A$
LOOK.AGAIN:
     A = INSTR(STP, DF$, SAVE.FIND$)
     IF A = 0 THEN
         I$ = I$ + DF$
         DF$ = ""
         LOCATE V%, H%
         PRINT I$;
         RETURN
     END IF
     I$ = I$ + LEFT$(DF$, A - 1)
     DF$ = MID$(DF$, A)
     LOCATE V%, H%
     PRINT I$;
     GOSUB TIO.GET.BYTE
     IF A$ <> SAVE.FIND$ THEN RETURN
     GOTO LOOK.AGAIN
TIO.GET.BYTE:
     LOCATE , , 1, 4, 7
     A$ = ""
     WHILE A$ = ""
         A$ = INKEY$
     WEND
     RETURN
END SUB

