        '
        '                  EXPAND Program
        '
        '   Read QuickBASIC program, expand $Include Files
        '   and write to output file so that user can run programs
        '   using QBASIC.
        '
        '
        '       by John Nelson
        '
        '
        DEFINT A-Z
        DECLARE SUB MakeStdInc (Lin$, I, FilNo)
        DECLARE SUB ProcessInclude (Lin$, I, FilNo)
        COLOR 15, 1
        DIM Prg$(50), Dirnm$(250)
        CLS
        PRINT "You may elect to expand a single directory, a single file or"
        PRINT "all Eamon directories.  If you expand a single directory you"
        PRINT "must enter the directory name.  If you expand a single file,"
        PRINT "or a directory you must be logged to the directory you want."
        PRINT
        PRINT "Do 1 File, a Directory or all Eamon directories?"
        PRINT " (Enter '1' or 'D' or 'A') ";
        DO
        A$ = INPUT$(1)
        LOOP UNTIL A$ = "1" OR UCASE$(A$) = "A" OR UCASE$(A$) = "D"
        PRINT A$
        MenuOpt$ = UCASE$(A$)
        AllFlg = 0
        IF MenuOpt$ = "A" THEN
            CHDIR "\EAMON"
            AllFlg = -1
            GOSUB LoadADirs
        END IF
        path$ = ""
        IF MenuOpt$ = "1" THEN
            PRINT "Enter the File name (w/o .BAS extension:):";
            INPUT "", Progname$
            IF Progname$ = "" THEN PRINT "Nothing to do.": END
            Progname$ = Progname$
            GOTO Expand.A.File
        END IF
        ' =======================================================
        '     Doing a full directory - get all .BAS file names
        ' -------------------------------------------------------
ProcessDir:
        SHELL "DIR " + path$ + "*.BAS >BASFILES"
        p = 0
        OPEN "BASFILES" FOR INPUT AS #1
ReadBF:
        IF EOF(1) THEN GOTO EndBF
        LINE INPUT #1, BFLin$
        IF INSTR(BFLin$, "BAS") = 0 THEN GOTO ReadBF
        Progname$ = LEFT$(BFLin$, INSTR(BFLin$, " "))
        p = p + 1
        Prg$(p) = Progname$
        GOTO ReadBF
EndBF:
        CLOSE 1                 '  done tabling .BAS file names
        maxp = p                '  set maxp = nbr bas files found
        p = 0                   ' initialize pointer to zero
Expand.Next.File:
        p = p + 1
        IF p > maxp THEN GOTO NextDir
        Progname$ = RTRIM$(Prg$(p))   ' get next file name
Expand.A.File:
        CLS
        LOCATE 4, 12
        PRINT "Program: "; path$ + Progname$
Doafile:
        OPEN path$ + Progname$ + ".BAS" FOR INPUT AS #1
        OPEN path$ + "tempout" FOR OUTPUT AS #2
        FilNo = 3
        WHILE NOT EOF(1)
                LINE INPUT #1, Lin$
                I1 = INSTR(Lin$, "$$INCL:")
                IF I1 THEN
                    MakeStdInc Lin$, I1, FilNo
                ELSE
                    I = INSTR(Lin$, "$INCLUDE:")
                    IF I > 0 THEN
                        ProcessInclude Lin$, I, FilNo
                    ELSE
                        PRINT #2, Lin$
                    END IF
                END IF
        WEND
        PRINT "Completed."
        CLOSE 1, 2
        ON ERROR GOTO CheckAlready
        NAME path$ + "tempout" AS path$ + Progname$ + ".QB"
NextPgm:
        IF MenuOpt$ = "1" THEN END
        GOTO Expand.Next.File
NextDir:
        IF AllFlg = 0 THEN END
        d = d + 1
        IF d > maxd THEN END
        path$ = RTRIM$(Dirnm$(d)) + "\"
        GOTO ProcessDir
CheckAlready:
        IF ERR = 58 THEN
            PRINT "Files already converted."
            PRINT "Overwrite file? (Y/N)"
            DO
                A$ = INPUT$(1)
            LOOP UNTIL UCASE$(A$) = "Y" OR UCASE$(A$) = "N"
            IF UCASE$(A$) = "Y" THEN
                KILL Progname$ + ".QB"
                RESUME
            ELSE
                KILL "tempout"
                RESUME
            END IF
        END IF
        PRINT "Error "; ERR
        RESUME
        STOP
LoadADirs:
        SHELL "DIR ADV* >ADIRS"
        OPEN "ADIRS" FOR INPUT AS #1
ReadAD:
        IF EOF(1) THEN GOTO EndAD
        LINE INPUT #1, ADLin$
        IF INSTR(ADLin$, "<DIR>") = 0 THEN GOTO ReadAD
        Dirnam$ = LEFT$(ADLin$, INSTR(ADLin$, " "))
        d = d + 1
        Dirnm$(d) = Dirnam$
        GOTO ReadAD
EndAD:
       CLOSE 1
       maxd = d
       d = 0
       RETURN

SUB MakeStdInc (Lin$, I, FilNo)
       
        PRINT #2, LEFT$(Lin$, I - 1); "$INCLUDE: "; MID$(Lin$, I + 7)
        DO
            LINE INPUT #1, Lin$
            I1 = INSTR(Lin$, "end of include")
            IF I1 THEN LINE INPUT #1, Lin$: EXIT DO
        LOOP

END SUB

SUB ProcessInclude (Lin$, I, FilNo)
        PRINT #2, "REM $$INCL:"; MID$(Lin$, I + 10)
        I = I + 9
        DO
          I = I + 1
        LOOP UNTIL MID$(Lin$, I, 1) = "'" OR I > LEN(Lin$)
        IF I > LEN(Lin$) THEN EXIT SUB
        IncFile$ = MID$(Lin$, I + 1)
        I2 = INSTR(IncFile$, "'")
        IF I2 > 0 THEN IncFile$ = LEFT$(IncFile$, I2 - 1)
        OPEN IncFile$ FOR INPUT AS FilNo
        WHILE NOT EOF(FilNo)
            LINE INPUT #FilNo, InLin$
            IX = INSTR(InLin$, "$INCLUDE:")
            IF IX > 0 THEN
                F2 = FilNo + 1
                ProcessInclude InLin$, IX, F2
            ELSE
                PRINT #2, InLin$
            END IF
        WEND
        PRINT #2, "    '------- (end of include file) -------    "
        PRINT #2, " ' "
        CLOSE FilNo

END SUB

