.286
.model tiny
.code
org 100h

Start:
;********** Main code *************
                mov    al,13h
                int    10h
                push   0A000h
                pop    es
                xor    ax,ax
                int    1Ah
                mov    word ptr [Memory+8],dx
                call   GenerateBackground
@MainLoop:
; ** Call to ShowPower **
; ** --==:PLAYER 1:==-- **
                push   TGPower TGShield TGAPower
                push   1 190
                call   ShowStatus
                add    sp,10
; ** --==:PLAYER 2:==-- **
                push   TBPower TBShield TBAPower
                push   268 190
                call   ShowStatus
                add    sp,10
; ** Call to CalcHeigth **
; ** --==:PLAYER 1:==-- **
                push   [TGCoordX]
                call   CalcHeight
                add    sp,2
                mov    [TGCoordY],ax
; ** --==:PLAYER 2:==-- **
                push   [TBCoordX]
                call   CalcHeight
                add    sp,2
                mov    [TBCoordY],ax
; ** Call to GetSprite **
; ** --==:PLAYER 1:==-- **
                push   (offset [Memory+TGBuffer])
                mov    ax,[TGCoordX]
                sub    ax,6
                push   ax
                mov    ax,[TGCoordY]
                sub    ax,11
                push   ax 19 16
                call   GetSprite
                add    sp,10
; ** --==:PLAYER 2:==-- **
                push   (offset [Memory+TBBuffer])
                mov    ax,[TBCoordX]
                sub    ax,6
                push   ax
                mov    ax,[TBCoordY]
                sub    ax,11
                push   ax 19 16
                call   GetSprite
                add    sp,10
; ** Call to PutSprite **
; ** --==:PLAYER 1:==-- **
                push   (offset [TankGood])
                push   ([TGCoordX])
                push   ([TGCoordY])
                push   6 5
                call   PutSprite
                add    sp,10
; ** --==:PLAYER 2:==-- **
                push   (offset [TankGood])
                push   ([TBCoordX])
                push   ([TBCoordY])
                push   6 5
                call   PutSprite
                add    sp,10
; ** Call to DrawCanon **
; ** --==:PLAYER 1:==-- **
                push   [TGAngle]
                mov    ax,[TGCoordX]
                add    ax,3
                push   ax
                mov    ax,[TGCoordY]
                dec    ax
                push   ax
                call   DrawCanon
                add    sp,6
; ** --==:PLAYER 2:==-- **
                push   [TBAngle]
                mov    ax,[TBCoordX]
                add    ax,3
                push   ax
                mov    ax,[TBCoordY]
                dec    ax
                push   ax
                call   DrawCanon
                add    sp,6
; ** Call FBAnimate if needed**
                test   [FFlags],00000001b
                jz     @NoFire
                test   [FFlags],00001000b
                jnz    @CompFire
                push   ([TGCoordX])
                push   ([TGCoordY])
                push   ([TGAngle])
                push   ([TGAPower])
                mov    [TGAPower],0
                jmp    short @Animate
@CompFire:
                push   ([TBCoordX])
                push   ([TBCoordY])
                push   ([TBAngle])
                push   ([TBAPower])
                mov    [TBAPower],0
@Animate:
                call   FBAnimate
                add    sp,8
@NoFire:
; ** Call to WaitRetrace **
                call   WaitRetrace

; ** Call to PutBlock **
; ** --==:PLAYER 1:==-- **
                push   (offset [Memory+TGBuffer])
                mov    ax,[TGCoordX]
                sub    ax,6
                push   ax
                mov    ax,[TGCoordY]
                sub    ax,11
                push   ax 19 16
                call   PutBlock
                add    sp,10
; ** --==:PLAYER 2:==-- **
                push   (offset [Memory+TBBuffer])
                mov    ax,[TBCoordX]
                sub    ax,6
                push   ax
                mov    ax,[TBCoordY]
                sub    ax,11
                push   ax 19 16
                call   PutBlock
                add    sp,10

; ** Begin checking key if turn**
                test   [FFlags],00001000b
                jz     @PlayerTurn
                jmp    @Nothing
@PlayerTurn:
                mov    ah,1
                int    16h
                jnz    @KeyStart
                jmp    @Nothing
@KeyStart:
                xor    ax,ax
                int    16h
; ** If 'q' was pressed **
                cmp    al,"q"
                jnz    @Key1
                jmp    @Exit
@Key1:
; ** If '8' was pressed **
                cmp    al,"8"
                jnz    @Key2
                cmp    [TGAngle],179
                jb     @KJNext
                jmp    @Nothing
@KJNext:
                inc    [TGAngle]
@Key2:
; ** If '2' was pressed **
                cmp    al,"2"
                jnz    @Key3
                cmp    [TGAngle],1
                jnz    @KJN1
                jmp    @Nothing
@KJN1:
                dec    [TGAngle]
@Key3:
; ** If '4' was pressed **
                cmp    al,"4"
                jnz    @Key4
                cmp    [TGCoordX],10
                ja     @KKj1
                jmp    @Nothing
@KKj1:
                cmp    [TGPower],5
                jae    @KKj2
                jmp    @Nothing
@KKj2:
                dec    [TGCoordX]
                sub    [TGPower],5
                mov    ax,[TGPower]
                cmp    [TGAPower],ax
                jbe    @KKOk1
                mov    [TGAPower],ax
@KKOk1:
@Key4:
; ** If '6' was pressed **
                cmp    al,"6"
                jnz    @Key5
                cmp    [TGCoordX],300
                jae    @Nothing
                cmp    [TGPower],5
                jb     @Nothing
                sub    [TGPower],5
                inc    [TGCoordX]
                mov    ax,[TGPower]
                cmp    [TGAPower],ax
                jbe    @KKOk2
                mov    [TGAPower],ax
@KKOk2:
@Key5:
; ** If ' ' was pressed **
                cmp    al," "
                jnz    @Key6
                cmp    [TGAPower],0
                jz     @Nothing
                or     [FFlags],00000001b
                mov    ax,[TGAPower]
                sub    [TGPower],ax
@Key6:
; ** If 'a' was pressed **
                cmp    al,"a"
                jnz    @Key7
                mov    ax,[TGPower]
                cmp    [TGAPower],ax
                jae    @Nothing
                inc    [TGAPower]
@Key7:
; ** If 'z' was pressed **
                cmp    al,"z"
                jnz    @Key8
                cmp    [TGAPower],0
                jz     @Nothing
                dec    [TGAPower]
@Key8:
; ** If 'e' was pressed **
                cmp    al,"e"
                jnz    @Key9
                or     [FFlags],00001000b
                mov    [TBPower],50
                mov    word ptr [Memory+TAIPower],0
@Key9:
@Nothing:

; ********************   /|
; ** Computer turn! **  <#|########
; ********************   \|

                test   [FFlags],00001000b
                jnz    @ComputerTurn
                jmp    @BackToML
@ComputerTurn:
                cmp    [TBPower],0
                jg     @CTNext
                and    [FFlags],11110111b
                mov    [TGPower],50
                jmp    @BackToML
@CTNext:
                cmp    word ptr [Memory+TAIPower],0
                jnz    @CTPowerSet
                mov    bx,7530h
                call   rand
                cmp    ax,3A97h
                jae    @CTSetPower

                cmp    ax,1D4Ch
                jbe    @CTMoveleft
                cmp    [TBCoordX],300
                jae    @CTMoveleft
                cmp    [TBPower],5
                jae    @CTw1
                jmp    @BackToML
@CTw1:
                sub    [TBPower],5
                inc    [TBCoordX]
                jmp    @BackToML
@CTMoveleft:
                cmp    [TBCoordX],10
                ja     @CTw2
                jmp    @BackToML
@CTw2:
                cmp    [TGPower],5
                jae    @CTw3
                jmp    @BackToML
@CTw3:
                dec    [TBCoordX]
                sub    [TBPower],5
                jmp    @BackToML
@CTSetPower:
                mov    bx,[TBPower]
                mov    word ptr [Memory+TAIPower],bx
@CTPowerSet:
                mov    ax,word ptr [Memory+TAIPower]
                cmp    ax,[TBAPower]
                jbe    @CTAngleSet
                inc    [TBAPower]
                jmp    @BackToML
@CTAngleSet:

                mul    ax
                xchg   cx,ax
                mov    ax,[TBCoordX]
                sub    ax,[TGCoordX]
                mov    bx,490
                mul    bx
                div    cx
                cmp    ax,100
                jbe    @CTCas
;                and    [FFlags],11110111b
;                mov    [TGPower],50
;                mov    ax,45
                mov    [TBAPower],0
                mov    word ptr [Memory+TAIPower],0
                jmp    short @BackToML
@CTCas:
                mov    si,offset [SinTable]
@CTArcsin:
                cmp    byte ptr [si],al
                jb     @CTArcN
                mov    cx,si
                sub    cx,offset [SinTable]
                shr    cx,1
                jmp    @CTAOut
@CTArcN:
                inc    si
                jmp    short @CTArcsin
@CTAOut:
                mov    ax,90
                add    ax,cx

                cmp    [TBAngle],ax
                jae    @CTq1
                inc    [TBAngle]
                jmp    short @BackToML
@CTq1:
                je     @CTq2
                dec    [TBAngle]
                jmp    short @BackToML
@CTq2:
                or     [FFlags],00000001b
                mov    ax,[TBAPower]
                sub    [TBPower],ax
                mov    word ptr [Memory+TAIPower],0
@BackToML:
                jmp    @MainLoop

@Exit:
                int    20h

;********** Procedures ************
; ****************************************************************************
; * FBAnimate procedure - visualize the fireball's fly with real             *
; * physical model trajectory, using:                                        *
; *    X Y Angle Power                                                            *
; ****************************************************************************
FBAnimate proc near
                push   bp
                mov    bp,sp
; ** Set up trigs values **
                mov    bx,[bp+6]
; ** Configure Sine **
                xor    dl,dl
                cmp    bx,90
                jbe    FBAtn1
                mov    ax,180
                sub    ax,bx
                xchg   ax,bx
                inc    dl
FBAtn1:
                mov    al,byte ptr [SinTable+bx]
                mov    byte ptr [Memory+FBTrigs],al
; ** Configure Cosine **
                mov    ax,90
                sub    ax,bx
                xchg   ax,bx
                xor    ah,ah
                mov    al,byte ptr [SinTable+bx]
                or     dl,dl
                jz     FBAtn2
                or     al,10000000b
FBAtn2:
                mov    byte ptr [Memory+FBTrigs+1],al


; ** Zeros in FBSecs **
                xor    ax,ax
                mov    cx,10
                push   es
                push   ds
                pop    es
                mov    di,offset [Memory+FBSecs]
                rep    stosw
                pop    es
                mov    word ptr [Memory+FBSecs],1

; ** Canon coords **
                mov    cl,0Ah
                mov    al,byte ptr [Memory+FBTrigs+1]
                and    al,01111111b
                xor    ah,ah
                div    cl
                xor    ah,ah
                add    ax,3
                mov    bx,[bp+10]
                test   [Memory+FBTrigs+1],10000000b
                jz     FBACadd
                sub    bx,ax
                jmp    short FBACabort
FBACadd:
                add    bx,ax
FBACabort:
                mov    word ptr [Memory],bx
                mov    al,byte ptr [Memory+FBTrigs]
                div    cl
                xor    ah,ah
                add    ax,3
                mov    bx,[bp+8]
                sub    bx,ax
                mov    word ptr [Memory+2],bx
; ** Start FBA Loop **

                and    [FFlags],11111101b
FBALoop:
; ** Here calculates <X> coordinate **
; ** like: x = x0 + power * cos(angle) * t / 10 **
                mov    ax,[bp+4]
                mov    cl,byte ptr [Memory+FBTrigs+1]
                and    cx,0000000001111111b
                mul    cx
                mul    word ptr [Memory+FBSecs]
                mov    bx,1F4h;3E8h
                div    bx
                mov    bx,word ptr [Memory]
                test   byte ptr [Memory+FBTrigs+1],10000000b
                jz     FBAadd
                sub    bx,ax
                jmp    short FBAno
FBAadd:
                add    bx,ax
FBAno:
                mov    word ptr [Memory+FBcX],bx

                add    bx,7
                cmp    bx,319
                jb     FBACmp1
                or     [FFlags],00000010b
FBACmp1:
                sub    bx,9
                cmp    bx,0
                jg     FBACmp2
                or     [FFlags],00000010b
FBACmp2:

; ** Here calculates <Y> coordinate **
; ** like y = y0 - (power * sin(angle) * t / 10) + (g * t * t / 2)

                mov    ax,[bp+4]
                mov    cl,byte ptr [Memory+FBTrigs]
                xor    ch,ch
                mul    cx
                mul    word ptr [Memory+FBSecs]
                mov    bx,1F4h;3E8h
                div    bx
                push   ax
                mov    ax,98
                mul    word ptr [Memory+FBSecs]
                mul    word ptr [Memory+FBSecs]
                mov    bx,3E8h;7D0h
                div    bx
                xchg   ax,cx
                pop    ax
                mov    bx,word ptr [Memory+2]
                sub    bx,ax
                add    bx,cx

                mov    word ptr [Memory+FBcY],bx

                add    bx,7
                cmp    bx,199
                jl     FBACmp3
                or     [FFlags],00000010b
FBACmp3:

; ** Check if GROOM **
                push   2 2
                push   (word ptr [Memory+FBcX])
                push   (word ptr [Memory+FBcY])
                push   6 6
                call   CheckPixels
                add    sp,12
                or     al,al
                jz     FBANoGROOM
                or     [FFlags],00000110b
FBANoGROOM:

; ** Now DRAW it **
                push   offset [FireBall]
                push   offset [Memory+FBBuf]
                push   (word ptr [Memory+FBcX])
                push   (word ptr [Memory+FBcY])
                push   6 6
                call   SpriteGAP
                add    sp,12

                call   WaitRetrace

                push   offset [Memory+FBBuf]
                push   (word ptr [Memory+FBcX])
                push   (word ptr [Memory+FBcY])
                push   6 6
                call   PutBlock
                add    sp,10

                inc    word ptr [Memory+FBSecs]

                test   [FFlags],00000010b
                jnz    FBABreak
                jmp    FBALoop
FBABreak:
                test   [FFlags],00000100b
                jnz    FBAExplosion
                jmp    FBANoExplosion
FBAExplosion:
; ***************************************
; ** Explosion: Destroy the landscape! **
; ***************************************
; ** Prepare explosion sprite **
                sub    word ptr [Memory+FBcX],3
                sub    word ptr [Memory+FBcY],3

                mov    si,offset [FireBall]
                mov    di,offset [Memory+FBExp]
                push   es
                push   ds
                pop    es
                xor    cx,cx

                mov    cl,6
FBAECopyB:
                push   cx
                mov    cl,6
FBAECopyA:
                lodsb
                mov    ah,al
                stosw
                add    di,10
                stosw
                sub    di,12
                loop   FBAECopyA
                add    di,12
                pop    cx
                loop   FBAECopyB

                pop    es

; ** Display explosion sprite **

                push   offset [Memory+FBExp]
                push   offset [Memory+FBEBuf]
                push   word ptr [Memory+FBcX]
                push   word ptr [Memory+FBcY]
                push   12 12
                call   SpriteGAP
                add    sp,12

                mov    cx,25
FBADelay:
                call   WaitRetrace
                loop   FBADelay

                push   offset [Memory+FBEBuf]
                push   (word ptr [Memory+FBcX])
                push   (word ptr [Memory+FBcY])
                push   12 12
                call   PutBlock
                add    sp,10

; ** Destroy landscape **
                mov    bx,word ptr [Memory+FBcX]
                mov    dx,word ptr [Memory+FBcY]
                call   CalcDI
                xor    dx,dx
                mov    dl,12
                xor    cx,cx
FBAELoopY:
                mov    cl,12
                push   di
FBAELoopX:
                mov    al,byte ptr es:[di]
                cmp    al,2
                jnz    FBAENod
                mov    ax,dx
                dec    ax
                mov    bl,12
                mul    bl
                add    ax,cx
                dec    ax
                xchg   ax,bx
                test   byte ptr [Memory+FBExp+bx],0FFh
                jz     FBAENod
                mov    byte ptr es:[di],10
FBAENod:
                pusha
                cmp    al,11
                jz     FBAETank
                cmp    al,9
                jz     FBAETank
                cmp    al,8
                jz     FBAETank
                cmp    al,7
                jz     FBAETank
                cmp    al,15
                jz     FBAETank
                jmp    short FBAENoTank
FBAETank:
                test   [FFlags],00001000b
                jnz    FBAEGTank

                mov    ax,word ptr [Memory+FBcX]
                sub    ax,[TGCoordX]
                cmp    ax,0
                jge    FBAENch1
                neg    ax
FBAENch1:
                cmp    ax,15
                jb     FBAENoTank

                cmp    [TBShield],2
                jae    FBAEdam1
                mov    ax,[TBCoordX]
                mov    word ptr [Memory],ax
                mov    ax,[TBCoordY]
                mov    word ptr [Memory+2],ax
                call   DEATH
FBAEdam1:
                sub    [TBShield],2
                jmp    short FBAENoTank
FBAEGTank:
                mov    ax,word ptr [Memory+FBcX]
                sub    ax,[TBCoordX]
                cmp    ax,0
                jge    FBAENch2
                neg    ax
FBAENch2:
                cmp    ax,15
                jb     FBAENoTank

                cmp    [TGShield],2
                jae    FBAEdam2
                mov    ax,[TGCoordX]
                mov    word ptr [Memory],ax
                mov    ax,[TGCoordY]
                mov    word ptr [Memory+2],ax
                call   DEATH
FBAEdam2:
                sub    [TGShield],2
FBAENoTank:
                popa
                inc    di
                dec    cx
                jz     FBAEEndL
                jmp    FBAELoopX
FBAEEndL:
                pop    di
                add    di,320
                dec    dl
                jz     FBAEBreak
                jmp    FBAELoopY
FBAEBreak:

FBANoExplosion:
                and    [FFlags],11111000b

                pop    bp
                ret
FBAnimate endp
; ****************************************************************************
; *  SpriteGAP procedure used to simplify action of Get-And-Put Sprite       *
; *  [Sprite] [Background] X Y Width Heigth                                  *
; *                                                                          *
; ****************************************************************************
SpriteGAP proc near
                push   bp
                mov    bp,sp
                push   word ptr [bp+12]
                push   word ptr [bp+10]
                push   word ptr [bp+8]
                push   word ptr [bp+6]
                push   word ptr [bp+4]
                call   GetSprite
                add    sp,10
                push   word ptr [bp+14]
                push   word ptr [bp+10]
                push   word ptr [bp+8]
                push   word ptr [bp+6]
                push   word ptr [bp+4]
                call   PutSprite
                add    sp,10
                pop    bp
                ret
SpriteGAP endp
; ****************************************************************************
; * CkeckPixels function - check if a group of pixels is inside a box, using:*
; * LeftPixel RightPixel X Y Width Height                                    *
; *                                                                          *
; ****************************************************************************
CheckPixels proc near
                push   bp
                mov    bp,sp
                call   IsLegal
                or     al,al
                jnz    CPOut
                mov    bx,[bp+10]
                mov    dx,[bp+8]
                call   CalcDI
                xor    ax,ax
                mov    dx,[bp+4]
CPLoopY:
                mov    cx,[bp+6]
                push   di dx
CPLoopX:
                mov    ah,byte ptr es:[di]
                inc    di
                mov    bx,[bp+12]
                sub    bx,[bp+14]
CPLoopC:
                mov    dx,bx
                add    dx,[bp+14]
                cmp    ah,dl
                jnz    CPBypass
CPBoom:
                inc    al
                pop    dx di
                jmp    short CPExit
CPBypass:
                cmp    ah,9
                jz     CPBoom
                cmp    ah,8
                jz     CPBoom
                cmp    ah,7
                jz     CPBoom

                loop   CPLoopX
                pop    dx di
                add    di,320
                dec    dx
                jnz    CPLoopY

                jmp    short CPExit
CPOut:
                xor    al,al
CPExit:
                pop    bp
                ret
CheckPixels endp
; ****************************************************************************
; * ShowStatus procedure - puts two status bars onto the screen using:       *
; * [Power] [Shield] [APower] X Y                                            *
; *                                                                          *
; ****************************************************************************
ShowStatus proc near
                push   bp
                mov    bp,sp
                xor    dx,dx
                mov    ax,170
SSPower:
                push   dx ax
                mov    bx,[bp+6]
                add    bx,dx
                mov    cx,[bp+4]
                push   bx cx bx
                add    cx,2
                push   cx ax
                call   Line
                add    sp,10
                pop    ax dx
                inc    dx
                cmp    ax,170
                jae    SSNorm
                mov    ax,170
SSNorm:
                inc    ax
                cmp    dx,[bp+8]
                jae    SSPASkip
                mov    al,01
SSPASkip:
                cmp    dx,[bp+12]
                jbe    SSPSkip
                mov    al,2
SSPSkip:
                cmp    dx,50
                jb     SSPower

                xor    dx,dx
                mov    ax,170
SSShield:
                push   dx ax
                mov    bx,[bp+6]
                add    bx,dx
                mov    cx,[bp+4]
                add    cx,4
                push   bx cx bx
                add    cx,2
                push   cx ax
                call   Line
                add    sp,10
                pop    ax dx
                inc    dx
                inc    ax
                cmp    dx,[bp+10]
                jbe    SSSSkip
                mov    al,2
SSSSkip:
                cmp    dx,50
                jb     SSShield

                pop    bp
                ret
ShowStatus endp
; ****************************************************************************
; * CalcHeight function - calculates the Y coordinate using X coord and      *
; * already generated background landscape                                   *
; *     CoordX                                                               *
; ****************************************************************************
CalcHeight proc near
                push   bp
                mov    bp,sp
                mov    bx,[bp+4]
                add    bx,3
                mov    dx,180
                push   dx
                call   CalcDI
                pop    dx
CHLoop:
                mov    al,byte ptr es:[di]
                cmp    al,2
                jnz    CHBreak
                cmp    dx,20
                jbe    CHBreak
                sub    di,320
                dec    dx
                jmp    short CHLoop
CHBreak:
                sub    dl,6
                xchg   ax,dx

                pop    bp
                ret
CalcHeight endp
; ****************************************************************************
; * GenerateBackground procedure - generates and draws a random              *
; * background landscape                                                     *
; *                                                                          *
; ****************************************************************************
GenerateBackground proc near
; ** Set RED Palette **
                mov    byte ptr [Memory+Palette],10
                mov    byte ptr [Memory+Palette+1],0
                mov    byte ptr [Memory+Palette+2],30
                mov    byte ptr [Memory+Palette+3],0
                call   SetColor

                mov    cx,63
                mov    byte ptr [Memory+Palette+1],63
                mov    byte ptr [Memory+Palette+2],0
                mov    byte ptr [Memory+Palette+3],0
GBPal:
                inc    byte ptr [Memory+Palette+2]
                mov    al,cl
                add    al,169
                mov    byte ptr [Memory+Palette],al
                call   SetColor
                loop   GBPal
; ** Set SKY Palette **
                xor    cx,cx
                mov    dx,1
                xor    di,di
                mov    byte ptr [Memory+Palette+1],0
                mov    byte ptr [Memory+Palette+2],0
                mov    byte ptr [Memory+Palette+3],63
GBsp1:
                dec    dx
                jnz    GBSkip
                mov    dx,3
                inc    byte ptr [Memory+Palette+2]
                mov    ax,100
                add    al,byte ptr [Memory+Palette+2]
                push   ax dx
                mov    byte ptr [Memory+Palette],al
                call   SetColor
                pop    dx ax
GBSkip:
                push   cx
                mov    cx,160
                mov    ah,al
                rep    stosw
                pop    cx
                inc    cx
                cmp    cx,189
                jb     GBsp1

; ** Draw LANDSCAPE Palette **

                mov    bx,130
                call   rand
                add    ax,50
                mov    word ptr [Memory+cell5],ax
                mov    cx,32
GBLoop:
                push   cx
                mov    bl,0Ah
                mov    al,cl
                imul   bl
                dec    ax
                push   ax
                push   word ptr [Memory+cell5]
                sub    ax,09h
                push   ax
                mov    bx,130
                call   rand
                add    ax,50
                mov    word ptr [Memory+cell5],ax
                push   ax
                push   02
                call   Line
                add    sp,10
                pop    cx
                loop   GBLoop

; ** Now paint the landscape **

                xor    dx,dx
GBPlx:
                mov    di,0F8C0h
                add    di,dx
GBPLoop:
                mov    al,byte ptr es:[di]
                cmp    al,2
                jz     GBPBreak
                mov    al,2
                stosb
                sub    di,321
                jmp    short GBPLoop
GBPBreak:
                inc    dx
                cmp    dx,320
                jb     GBPlx

                ret
GenerateBackground endp
; ****************************************************************************
; * DrawCanon procedure - draws a canon onto a specified tank, using:        *
; *    Angle, X, Y                                                           *
; *                                                                          *
; ****************************************************************************
DrawCanon proc near
                push   bp
                mov    bp,sp

                push   [bp+6]
                push   [bp+4]

                xor    dl,dl
                mov    bx,[bp+8]
                cmp    bx,90
                jbe    DCNORM
                mov    bx,90
                sub    bx,[bp+8]
                add    bx,90
                mov    dl,-1
DCNORM:
                mov    cl,0Ah

                mov    si,90
                sub    si,bx
                mov    al,[SinTable+si]
                xor    ah,ah
                div    cl
                xor    ah,ah
                or     dl,dl
                jz     DCNORM2
                neg    ax
DCNORM2:
                add    ax,[bp+6]
                push   ax

                xor    ah,ah
                mov    al,[SinTable+bx]
                div    cl
                xor    ah,ah
                mov    bx,[bp+4]
                sub    bx,ax
                push   bx

                push   15
                call   Line
                add    sp,10

                pop    bp
                ret
DrawCanon endp
; ****************************************************************************
; * PutBlock procedure - place an image onto the screen, using:              *
; *    [offset] X Y Width Heigth                                             *
; *                                                                          *
; ****************************************************************************
PutBlock proc near
                push   bp
                mov    bp,sp
                call   IsLegal
                or     al,al
                jnz    PBOut

                mov    si,[bp+12]
                mov    bx,[bp+10]
                mov    dx,[bp+8]
                call   CalcDI
                mov    dx,[bp+4]
PBLoopY:
                push   di
                mov    cx,[bp+6]
PBLoopX:
                mov    al,byte ptr es:[di]
                inc    di
                inc    si
                cmp    al,10
                jz     PBNext
                dec    di
                dec    si
                movsb
PBNext:
                loop   PBLoopX
                pop    di
                add    di,320
                dec    dx
                jnz    PBLoopY

PBOut:
                pop    bp
                ret
PutBlock endp
; ****************************************************************************
; * PutSprite procedure - puts a sprite onto the screen, using:              *
; *    [offset] X Y Width Heigth                                             *
; *                                                                          *
; ****************************************************************************
PutSprite proc near
                push   bp
                mov    bp,sp
                call   IsLegal
                or     al,al
                jnz    PSOut

                mov    si,[bp+12]
                mov    bx,[bp+10]
                mov    dx,[bp+8]
                call   CalcDI
                mov    dx,[bp+4]
PSLoopy:
                mov    cx,[bp+6]
                push   di
PSLoopx:
                inc    di
                lodsb
                or     al,al
                jz     PSNot
                dec    di
                stosb
PSNot:
                loop   PSLoopx
                pop    di
                add    di,320
                dec    dx
                jnz    PSLoopy
PSOut:
                pop    bp
                ret
PutSprite endp
; ****************************************************************************
; * GetSprite procedure - grab a sprite from the screen, using:              *
; *    [offset] X Y Width Heigth                                             *
; *                                                                          *
; ****************************************************************************
GetSprite proc near
                push   bp
                mov    bp,sp
                call   IsLegal
                or     al,al
                jnz    GSOut

                mov    si,[bp+12]
                mov    bx,[bp+10]
                mov    dx,[bp+8]
                call   CalcDI
                mov    dx,[bp+4]
GSLoopy:
                mov    cx,[bp+6]
                push   di
GSLoopx:
                mov    al,byte ptr es:[di]
                mov    byte ptr [si],al
                inc    di
                inc    si
                loop   GSLoopx
                pop    di
                add    di,320
                dec    dx
                jnz    GSLoopy

GSOut:
                pop    bp
                ret
GetSprite endp
; ****************************************************************************
; * Line procedure - draws a line using parameters: xs,ys,xe,ye,color        *
; *                                                                          *
; *                                                                          *
; ****************************************************************************
Line proc near
                push   bp
                mov    bp,sp

                mov    bx,[bp+12]
                mov    dx,[bp+10]
                cmp    bx,[bp+8]
                jnz    @Lc
                cmp    dx,[bp+6]
                jnz    @Lc
                jmp    LineEnd
@Lc:
                call   CalcDI
                xor    bx,bx

                mov    cx,[bp+8]
                cmp    cx,[bp+12]
                jae    LineC3
                mov    cx,[bp+12]
                sub    cx,[bp+8]
                inc    cx
                mov    word ptr [Memory],-2
                jmp    short LineC4
LineC3:
                sub    cx,[bp+12]
                inc    cx
                mov    word ptr [Memory],0
LineC4:
                mov    dx,[bp+6]
                cmp    dx,[bp+10]
                jae    LineC5
                mov    dx,[bp+10]
                sub    dx,[bp+6]
                inc    dx
                mov    word ptr [Memory+2],-320
                jmp    short LineC6
LineC5:
                sub    dx,[bp+10]
                inc    dx
                mov    word ptr [Memory+2],320
LineC6:
                mov    ax,[bp+4]
                mov    word ptr [Memory+4],cx
                mov    word ptr [Memory+6],dx
                cmp    cx,dx
                jb     LineYL
LineXL:
                stosb
                add    di,word ptr [Memory]
                add    bx,dx
                cmp    bx,word ptr [Memory+4]
                jb     LineXLC
                add    di,word ptr [Memory+2]
                sub    bx,word ptr [Memory+4]
LineXLC:
                loop   LineXL
                jmp    short LineEnd
LineYL:
                push   di
                stosb
                pop    di
                add    di,word ptr [Memory+2]
                add    bx,cx
                cmp    bx,word ptr [Memory+6]
                jbe    LineYLC
                inc    di
                add    di,word ptr [Memory]
                sub    bx,word ptr [Memory+6]
LineYLC:
                dec    dx
                jnz    LineYL
LineEnd:
                pop    bp
                ret
Line endp
; ****************************************************************************
; *                                                                          *
; *  CalcDI function: calculates position using X and Y coords               *
; *                                                                          *
; ****************************************************************************
CalcDI proc near
                mov    di,bx
                mov    bx,dx
                mov    dh,dl
                xor    dl,dl
                shl    bx,6
                add    dx,bx
                add    di,dx
                ret
CalcDI endp
; ****************************************************************************
; *                                                                          *
; *  rand function: generate the random number in range 0-bx                 *
; *                                                                          *
; ****************************************************************************
rand proc near
                push   bx
                mov    dx,word ptr [Memory+10]
                mov    ax,word ptr [Memory+8]
                mov    cx,0015Ah
                mov    bx,04E35h

                call   randplus

                add    ax,00001h
                adc    dx,000h
                mov    word ptr [Memory+10],dx
                mov    word ptr [Memory+8],ax
                xor    dx,dx
                mov    ax,word ptr [Memory+10]
                and    ax,07FFFh
                pop    bx
                div    bx
                xchg   ax,dx
                ret
rand endp
; ****************************************************************************
; *                                                                          *
; *  randplus function: using by the random function                         *
; *                                                                          *
; ****************************************************************************
randplus proc near
                push   si
                xchg   si,ax
                xchg   dx,ax
                test   ax,ax
                je     RPJ1
                mul    bx
RPJ1:
                xchg   cx,ax
                test   ax,ax
                je     RPJ2
                mul    si
                add    cx,ax
RPJ2:
                xchg   si,ax
                mul    bx
                add    dx,cx
                pop    si
                ret
randplus endp
; ****************************************************************************
; *                                                                          *
; *  IsLegal function - check possibility to put something (uses bp pointer) *
; *                                                                          *
; ****************************************************************************
IsLegal proc near
                xor    al,al
                cmp    word ptr [bp+10],0
                jg     IL1
                inc    al
IL1:
                cmp    word ptr [bp+8],0
                jg     IL2
                inc    al
IL2:
                mov    bx,[bp+10]
                add    bx,[bp+6]
                cmp    bx,319
                jl     IL3
                inc    al
IL3:
                mov    bx,[bp+8]
                add    bx,[bp+4]
                cmp    bx,199
                jl     IL5
                inc    al
IL5:
                ret
IsLegal endp
; ****************************************************************************
; * Death of the tank. Draws some explosions around the dead tank and        *
; * waits for any key.                                                       *
; * Wants: [cell1] as [X] and [cell2] as [Y]                                 *
; ****************************************************************************
DEATH proc
                mov    cx,5
Dsome:
                push   cx
                push   offset [Memory+FBExp]
                mov    bx,19
                call   rand
                add    ax,word ptr [Memory]
                sub    ax,12
                push   ax
                mov    bx,18
                call   rand
                add    ax,word ptr [Memory+2]
                sub    ax,12
                push   ax
                push   12 12
                call   PutSprite
                add    sp,10
                mov    cx,10
DDelay:
                call   WaitRetrace
                loop   DDelay

                pop    cx
                loop   Dsome
                xor    ax,ax
                int    16h
                int    20h
                ret
DEATH endp
; ****************************************************************************
; *                                                                          *
; *  SetColor - set a color using Palette structure                          *
; *                                                                          *
; ****************************************************************************
SetColor proc
                mov    dx,03C8h
                mov    al,byte ptr [Memory+Palette]
                out    dx,al
                inc    dx
                mov    al,byte ptr [Memory+Palette+1]
                out    dx,al
                mov    al,byte ptr [Memory+Palette+2]
                out    dx,al
                mov    al,byte ptr [Memory+Palette+3]
                out    dx,al
                ret
SetColor endp
; ****************************************************************************
; *                                                                          *
; *  WaitRetrace procedure: waits for the verticle retrace                   *
; *                                                                          *
; ****************************************************************************
WaitRetrace proc
                mov    dx,03DAh;
WR1:
                in     al,dx
                and    al,08h
                jnz    WR1

WR2:
                in     al,dx
                and    al,08h
                jz     WR2

                ret
WaitRetrace endp
;*****************************************************************************

;********** Data segment **********
FireBall        db     000h,0E8h,0E8h,0E8h,0E8h,000h
                db     0E8h,0D8h,0C8h,0C8h,0D8h,0E8h
                db     0E8h,0C8h,0AAh,0AAh,0C8h,0E8h
                db     0E8h,0C8h,0AAh,0AAh,0C8h,0E8h
                db     0E8h,0D8h,0C8h,0C8h,0D8h,0E8h
                db     000h,0E8h,0E8h,0E8h,0E8h,000h

TankGood        db     00,03,11,11,03,00
                db     00,09,09,09,09,00
                db     01,09,09,09,09,01
                db     08,07,07,07,07,08
                db     00,08,08,08,08,00

TGAngle         dw     45
TGCoordX        dw     30
TGCoordY        dw     10
TGPower         dw     50
TGShield        dw     50
TGAPower        dw     0

TBAngle         dw     135
TBCoordX        dw     289
TBCoordY        dw     10
TBPower         dw     50
TBShield        dw     50
TBAPower        dw     0

SinTable        db     0,1,3,5,6,8,10,12,13,15
                db     17,19,20,22,24,25,27,29,30,32
                db     34,35,37,39,40,42,43,45,46,48
                db     49,51,52,54,55,57,58,60,61,62
                db     64,65,66,68,69,70,71,73,74,75
                db     76,77,78,79,80,81,82,83,84,85
                db     86,87,88,89,89,90,91,92,92,93
                db     93,94,95,95,96,96,97,97,97,98
                db     98,98,99,99,99,99,99,99,99,99,100
FFlags          db     0
;********** Not linked segment ****
Memory          db     0
;cell1           dw     ?  0-2
;cell2           dw     ?  2-4
;cell3           dw     ?  4-6
;cell4           dw     ?  6-8
;RandCell1       dw     ?  8-10
;RandCell2       dw     0  10-12
TGBuffer         EQU    12 ;-316
cell5            EQU    316;-318
Palette          EQU    318;-322
FBBuf            EQU    322;-682
FBTrigs          EQU    682;-684
FBSecs           EQU    684;-686
FBcX             EQU    686;-688
FBcY             EQU    688;-690
FBExp            EQU    690;-834
FBEBuf           EQU    834;-978
TBBuffer         EQU    978;-1282
TAIPower         EQU    1282;-1284

End Start
End