'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
'QuickBASIC Raycaster Engine - Version 1.0
'Coder: Matthew River Knight
'Date started: 13 June, 2000
'Date completed: 13 June, 2000
'Last modified: 8 July, 2000
'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DIM Sine%(359)
DIM Cosine%(359)
DIM Map%(1 TO 10, 1 TO 10)

'Create SIN and COS tables.
FOR Angle% = 0 TO 359
  Sine%(Angle%) = SIN(Angle% * .017453) * 100
  Cosine%(Angle%) = COS(Angle% * .017453) * 100
NEXT

'READ the world data into our map array.
FOR Y% = 1 TO 10
  FOR X% = 1 TO 10
    READ Map%(X%, Y%)
    IF Map%(X%, Y%) = -1 THEN Map%(X%, Y%) = 0: PX% = X%: PY% = Y%
  NEXT
NEXT

PX% = PX% * 1000
PY% = PY% * 1000

SCREEN 13

DO
  GOSUB Raycast
  K$ = INKEY$
  K% = INP(96)
  OPX% = PX%: OPY% = PY%
  IF K% = 72 THEN PX% = PX% - Cosine%(ViewAngle%): PY% = PY% - Sine%(ViewAngle%)
  IF K% = 80 THEN PX% = PX% + Cosine%(ViewAngle%): PY% = PY% + Sine%(ViewAngle%)
  IF K% = 75 THEN ViewAngle% = ViewAngle% - 3
  IF K% = 77 THEN ViewAngle% = ViewAngle% + 3
  IF K% = 1 THEN END
  IF Map%(PX% \ 1000, PY% \ 1000) THEN PX% = OPX%: PY% = OPY%
LOOP

Raycast:  'The main raycasting routine.
S% = -5
IF ViewAngle% < 0 THEN ViewAngle% = ViewAngle% + 360
IF ViewAngle% > 359 THEN ViewAngle% = ViewAngle% - 360
FOR Angle% = ViewAngle% - 31 TO ViewAngle% + 32
  A% = Angle%
  IF A% > 359 THEN A% = A% - 360
  IF A% < 0 THEN A% = A% + 360
  S% = S% + 5
  XX% = PX%
  YY% = PY%
  Dist% = 0
  DO
    XX% = XX% - Cosine%(A%)
    YY% = YY% - Sine%(A%)
    MapColor% = Map%(XX% \ 1000, YY% \ 1000)
    Dist% = Dist% + 1
  LOOP UNTIL MapColor%
  W% = 1000 \ Dist%
  'Draw the sky.
  LINE (S%, 0)-(S% + 4, 100 - W%), 1, BF
  'Draw the wall strip.
  LINE (S%, 100 - W%)-(S% + 4, 100 + W%), MapColor%, BF
  'Draw the ground.
  LINE (S%, 100 + W%)-(S% + 4, 200), 2, BF
NEXT
RETURN

'The world data.
DATA 3, 9, 3, 9, 3, 9, 3, 9, 3, 9
DATA 9, 0, 0, 0, 0, 0, 0, 0, 0, 3
DATA 3, 0, 9, 0, 6, 8, 8, 0, 0, 9
DATA 9, 9, 8, 0, 0, 0, 6, 0, 0, 3
DATA 3, 0, 0, 0, 0, 0, 8, 0, 0, 9
DATA 9, 0, 0, 0, 0, 0, 0, 0, 0, 3
DATA 3, 0, 0, 0, 0, 0, 0, 0,-1, 9
DATA 9, 0, 0, 0, 0, 9, 4, 9, 0, 3
DATA 3, 0, 0, 0, 0, 8, 0, 0, 0, 9
DATA 9, 3, 9, 3, 9, 3, 9, 3, 9, 3

