include         constant.inc
include		keyscan.inc

comment $

 issues:
	a) incomplete sound  (and no way to turn it off!)
	b) not speed throttled per machine.  hardcoded delay.
	c) no joystick support
	d) no 16 color graphics on VGA machines
	e) LOTS and LOTS of commenting/unwravelling



found on a sector on original diskette:
 looks like specific code for level 5, vampire

CSEG	SEGMENT
	ASSUME	CS:CSEG,DS:CSEG,ES:CSEG
	INCLUDE	J:JUMPTBLE.ASM
	ORG	9300H
LEVEL_NUM	DB	'05'		;0-1
SCREEN_DRW	DW	SCR_TABLE	;2-3
TARGET_LIST	DW	TAR_LIST	;4-5
JUMPMAN_AREA	DW	JMA		;6-7
JMC1		DW	FJM1		;8-9
JMC2		DW	FJM2		;a-b
NUM_TARGETS	DB	14		;930c
NUM_BULLETS	DB	0		;d
BONUS_VALUE     DB      '15'            ;930e-f
PRE_PLAY:       JMP     INITS           ;9310h
PLAY:           JMP     STARTS          ;9313h
POST_PLAY:      JMP     DONES           ;9316h
PLAYER_LIST	DW	PLAYERS		;15-16
START_POS	DW	152,94		;17-1a
BULLET_LIST	DW	0		;1b-1c
SCR_TABLE:
	DW	128,12,1,136,10,2,152,8,2,168,10,2,184,12,1,8,32,3,56,32,5
	DW	96,34,1,104,36,1,112,38,1,120,40,1,128,42,1,136,44,1,144,46,1
	DW	152,48,2,168,46,1,176,44,1,184,42,1,192,40,1,200,38,1,208,36,1
	DW	216,34,1,224,32,5,288,32,3,8,64,3,32,66,1,40,68,1,48,70,1
	DW	56,72,6,136,72,6,216,72,6,264,70,1,272,68,1,280,66,1,288,64,3
	DW	24,104,10,136,104,6,216,104,10,16,136,9,120,136,10,232,136,9
	DW	8,176,8,104,176,2,120,174,1,128,172,1,136,170,1,144,168,4
	DW	176,170,1,184,172,1,192,174,1,200,176,2,248,176,8,0FFFFH
	DW	72,24,10,232,24,10,32,96,10,152,96,9,272,96,10,0FFFFH
	DW	0FFFFH,8,28,3,308,28,3,0FFFFH
	DW	16,26,1
$


hstable		EQU	02c24h		; offset of highscore data





HWLIST		EQU	10h
INT9		EQU	9*4		; interrupt vector for keyboard
INT1C		EQU	1Ch*4		; interrupt vector for timer (int 1c)
KEYSTATS	EQU	18h		; keyboard status byte in BDA

;data_11e	equ	0
;PSP_free_seg	equ	2
;data_12e	equ	8
;data_13e	equ	10h
data_14e	equ	12h
data_15e	equ	13h
data_16e	equ	15h
data_17e	equ	16h
data_18e	equ	18h
;data_19e	equ	19h
data_20e	equ	1Eh
data_21e	equ	1Fh
data_22e	equ	26h
data_23e	equ	2Eh
data_24e	equ	2Fh
data_25e	equ	30h
data_26e	equ	31h
data_27e	equ	0ABh
;data_400e	equ	8101h			;*
data_412e	equ	0B400h			;*
data_413e	equ	0BE00h			;*
data_414e	equ	0D600h			;*
data_415e	equ	0E200h			;*
data_416e	equ	50h
BDASEG		EQU	40h			; segment of bios data area
BIOSSEG		EQU	0F000h			; segment of BIOS region
MACHINE_ID	EQU	0FFFEh			; machine type @ f000:fffe


STACKSEG SEGMENT STACK USE16 'Stack'
;db 50 dup (0)
;db	0beh
dw	14*1024 dup(0)
STACKSEG ENDS


codeseg		segment	byte public
		assume	cs:codeseg, ds:codeseg
		assume  ss:stackseg

	    	org	00h

_1		proc	far

main:
                jmp     start          ;0-2
                jmp     put2screen     ;3-5
                jmp     sub_51         ;6-8
                jmp     putplayer      ;9-b
                jmp     sub_53         ;c-e
                jmp     loc_51         ;f-11
                jmp     loc_254        ;12-14
                jmp     checkeol       ;15-17
                jmp     gettimestamp   ;18-1a
		jmp	sub_49_	       ;1b-1d
		jmp	sub_47	       ;1e-20
		jmp	sub_54	       ;21-23
		jmp	loc_376	       ;24-26
		jmp	sub_50	       ;27-29
                jmp     sub_8	       ;2a-2c
		jmp	loc_457	       ;2e-31
		jmp	sub_40	       ;31-33
		jmp	copy2screen    ;34-26
                jmp     expandlevel    ;37-39
		jmp	sub_35	       ;3a-3c
                jmp     sub_3	       ;3d-3f
                jmp     sub_48_	       ;40-42
                jmp     sub_6	       ;43-45
                jmp     loc_541        ;46-48
                jmp     loc_230        ;49-4b
                jmp     loc_630        ;4c-4e
                jmp     playtone1      ;4f-51
		jmp	playtone2      ;52-54

		
		
screenchar        dw      0        
		
		
		
		db	14 dup (0) ;was 16
		
		dw	offset dispstats1	;83h, 53h 	;@64h
		dw	offset dispstats2 	;85h, 53h
		dw	offset dispstats0	;db	 81h, 53h
                dw      offset gfxcount       ;db      87h, 53h
		
		dw	offset ibmlogo1 	;0C0h, 6Eh
		dw	offset on_object	;0B8h, 0Ch
		dw	offset vcb4		;0B4h, 0Ch,
		dw	offset vcb6		;0B6h, 0Ch,
		dw	offset vcd8		;0D8h, 0Ch
		dw	offset sto7		; 11h, 66h 
                dw      offset stob             ; 13h, 66h 
		dw	offset stoa		; 15h, 66h
		dw	offset sto1		; 23h, 66h 
		dw	offset sto5		; 1Dh, 66h 
		dw	offset sto6		; 1Fh, 66h
		dw	offset sto4		; 21h, 66h 
		dw	offset sto3		; 27h, 66h 
		dw	offset sto8	;	' 10h, 66h
		dw	offset v6630	;30h, 66h 
                dw      offset startseg   ;98h, 53h 
		dw	offset vcb2	;0B2h, 0Ch
		dw	offset v5e1 ;@8e db	0E1h, 05h
		dw  	offset ibmlogo6	;5Ah, 70h 
		dw	offset ibmlogo12 ;46h, 72h
		dw	offset ibmlogo13	; 98h, 72h
		dw	offset somevar1	;0BAh, 58h
		dw	offset somevar0	;0B8h, 58h
		dw	offset v5e2	;0E2h, 05h 
		dw	offset xpos	;92h, 53h 
		dw	offset ypos 	;94h, 53h
		dw	offset gfxoffset	; 89h, 53h 
		dw	offset dunno4	; 9Ch, 53h
		dw	offset dunno6	; 0A0h, 53h
		dw	offset dunno5 	; 9Eh, 53h
		dw	offset dunno7 	; 0A2h, 53h
		dw	offset dunno8 	; 0A4h, 53h
		dw	offset mon_type	;@acdb	0D5h, 05h 
		dw	offset pcjr?	;@ae	db	28h, 06h
		dw	offset v1dd0	; 0D0h, 1Dh

;
;
;                       External Entry Point
;
;

start:
		mov	ax, cs
		mov	ds, ax
		sti				; Enable interrupts
		cld				; Clear direction
; i think this code is a bug.
; it may destroy the vector for INT4.
; I think ES should be 40h instead of 0  

		
       ;		mov	ax, 0			;
       ;		mov	es, ax			;
       ;		mov	ax, es:[10h]		; 
       ;		and	ax, 0FFCFh
       ;		or	al, BIT5		; 
       ;		mov	es:[10h], ax		; save it back


;end bug.

		mov	ax, BIOSSEG		; look for a PCjr
		mov	es,ax
		cmp	byte ptr es:[MACHINE_ID],0FDh	; PCjr?
		je	is_pcjr			; jmp if yes
		
                mov     ds:[pcjr?],0  		; set machine type variable
       ;		mov	ax, BDASEG
       ;		mov	ds, ax
       ;		mov	ax, 10h
       ;		and	al, NOT BIT4+BIT5	; clear video installed bits
       ;		or	al, BIT4
       ;		mov	ds: [HWLIST],ax
		mov	ax,4
		int	10h			; Video display   ah=functn 00h
						;  set display mode in al
		jmp	@f
               	nop
is_pcjr:
                mov     ds:[pcjr?],-1  		; set machine type=PCjr
		mov	byte ptr ds:[unused],2
@@:
		mov	ax, cs
		mov	es, ax
		mov	ds, ax





	     	call    systeminit		; revector keyboard and timer
                
	      	mov     word ptr ds:[screenchar],0   ; [5379]
                call    clearscreen

		
		
		
		
		
	; read highscore table
	     ;	mov	ah, 2			; to CS:2c24
	     ;	mov	al, 1
	     ;	mov	dl, 0
	     ;	mov	dh, 0
	     ;	mov	cl, 3
	     ;	mov	ch, 0
	     ;	mov	bx, HSTABLE
	     ;	int	13h			
		; call	loadhighscores		; later...

		call	welcomeScreen		; display logos and credits
		mov	ah,0
		int	1Ah			; Real time clock   ah=func 00h
						;  get system timer count cx,dx
                mov     word ptr ds:[timerval],dx  ; random number seed
		mov	byte ptr ds:[skilllevel],1    ; why is this programed?
		nop

		
playerstart:	
		mov	byte ptr ds:[highscoreflag],0	; not a high score
		mov	byte ptr ds:[gameover],0	; not game over

		
	    	call	playtone4	;sub_60
		call	inputplayeroptions	;<-get players and start level
		




		; reset all variables to 0

		mov	cx,4
		mov	di, offset zerobuffer	;5F8h			; after press enter+0000's

	

locloop_5:
		push	cx
		mov	si, offset v5EC		; 07 04 
		mov	cx, 0Ch
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		pop	cx
		loop	locloop_5		; Loop if cx > 0

		mov	byte ptr ds:[playernum], "1"	; 5d1
		mov	si, offset zerobuffer   ;5F8h
		mov	di, offset livesleft	;5E0h
		mov	cx, 0Ch
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]

		
loc_6:

                call    hidecursor              ; prepare for graphics
		call	loadlevel		; load level from disk
		call	printplayernumber	; print player x msg + delay
		
		
                mov     word ptr ds:[startseg],ss
		mov	bx, offset endflag+0eh  ;data_408e 930e; point to level data
		mov	al, [bx]    		; "bonus value"
		mov	byte ptr ds:[bonushigh],al ; grab bonus start 
		mov	al,[bx+1]		; save it to variables
		mov	byte ptr ds:[bonuslow],al

		
		call	setmode			; set graphics mode
		
		
		call	expandlevel	; decompress level data into memory?
		
		call	sub_6		; ?
		
                mov     byte ptr ds:[t_bonustimer], 100 ;load up temp timer
		
loc_7:		
		mov	byte ptr ds:[flag0],0FFh	; 14d6h
	    	call	displayplayerstats	       ; draws player's lives left and score
		
		

		mov	word ptr ds:[v5B1B], offset bigbuffer ;5b23h
		mov	word ptr ds:[v5fdb], offset bigbuffer2sFFFF ;data_266,5FDDh
                mov     al,byte ptr ds:[t_bonustimer]	; temp bonus timer
                mov     byte ptr ds:[bonustimer],al	; put into real timer
                mov     word ptr ds:[on_object],0
                mov     word ptr ds:[vcb4],0
                mov     word ptr ds:[vcb6],0
		
                
		
                ; run level specific init code
	       	mov	bx, offset endflag+10h ;9310h 	;offset sub_61	;*
		call	bx	  ;<-displays screen		;*
		
	      



	        mov	bx, offset endflag + 6 	; data_403e
		mov	bx,[bx]
		mov	di, offset endflag + 1bh	;data_410e
		mov	ax,[di]
		mov	[bx+2],ax
		add	ax,0Fh
		mov	[bx+1Ch],ax
		mov	ax,[di+2]
		mov	[bx+4],ax
		add	ax,9
		mov	ax,[bx+1Eh]
		mov	word ptr [bx+8],offset IBMlogo1 ;6EC0h
		mov	word ptr [bx+18h],0A6h

		

		call	sub_51	       ;<?
                call    putplayer         ; put player on screen
		call	sub_53	       ; ?
		call	sub_2	       ; ?
		mov	byte ptr ds:[v22D4],0Dh


		
loc_8:         ; this is the main loop
	       call	getkeypress
               call    systemdelay

                ; run more level specific play code

		mov	bx, offset endflag+13h
	   	call	bx			
		
		call	sub_10
		
		
		; check to see if we have gotten all the bombs
		
		mov	bx, offset endflag + 0ch  ; #targets data_406e
		cmp	byte ptr [bx],0
		je	winner 			; Jump if equal
		
		
		call	printbonusleft		;sub_9
                
		
		; this happens when you run off the edge of a platform
                test    word ptr ds:[on_object],100h
		jnz	diediedie	;loc_15	
		
		

		; ESC=pause.
		test	byte ptr [flagc], 0FFh	; data_293
		jnz	pausegame			; Jump if not zero
		
		test	byte ptr ds:[gameover], 1
		jz	loc_8			; Jump if zero
		jmp	loc_13
                
pausegame:	;loc_9:
	        mov     al,byte ptr ds:[bonustimer]
		call	playtone4	;sub_60

;wait for the escape key to be pressed again.
	
loc_10:
	    ;	test	byte ptr [keypress],0FFh
	    ;	jnz	loc_10			; Jump if not zero
loc_11:	    ;
            ;    test    byte ptr [keypress],0FFh
	    ;	jz	loc_11			; Jump if zero
loc_12:	    ;
            ;    test    byte ptr [keypress],0FFh
	    ;	jnz	loc_12			; Jump if not zero
;restore bonus timer and return to program.
                mov     byte ptr ds:[bonustimer],al
		jmp	loc_8

		
		
loc_13:
                test    byte ptr [keypress],0FFh
		jnz	loc_13			; Jump if not zero

		test	byte ptr ds:[highscoreflag],80h
		jnz	loc_14			; Jump if not zero
		mov	data_161,15h
		call	displaytopscores
                call    wait4enter
loc_14:
		jmp	playerstart		;loc_4 input start level + go!
;loc_15:
;		jmp	diediedie		;loc_34	; death
winner:	
                test    word ptr ds:[on_object],2
		jz	loc_17			; Jump if zero
                mov     al, byte ptr ds:[v5d4]
                mov     byte ptr ds:[v5e1], al
loc_17:
		mov	bx, offset v3586
		mov	cx,4

@@:     
		mov	word ptr [bx+8],0
                add     bx, 20h
                loop    @b       	             ; Loop if cx > 0

		mov	bx, offset endflag + 6 ; data_403e
		mov	bx,[bx]
		mov	word ptr [bx+6],0
		call	sub_51
                call    putplayer
		call	sub_53
		mov	al,byte ptr ds:[bonushigh]
		sub	al, 30h			; '0'
		add	byte ptr ds:[v5E8],al
		add	byte ptr ds:[v5E3],al
		mov	al,byte ptr ds:[bonuslow]
		sub	al, 30h			; '0'
		add	byte ptr ds:[v5E9],al
		add	byte ptr ds:[v5E4],al
		call	sub_8
                
		

		call    gettimestamp
		and	dh,3
		call	playtone4	;sub_60
		
		
		cli				; Disable interrupts
		cmp	dh,0
		je	loc_21			; Jump if equal
		cmp	dh,1
		je	loc_20			; Jump if equal
		cmp	dh,2
		je	loc_19			; Jump if equal

		mov     word ptr ds:[sto7],offset music1	;6A40h
                mov     word ptr ds:[stob], offset music2	;6A72h
		mov	ax,word ptr ds:[sound0]	  		;6a70
                mov     word ptr ds:[stoa],ax
		mov	word ptr ds:[v6617],offset v6AA2
                mov     [v6619],6AB6h            ; 6619  data_278
		mov	ax,word ptr ds:[music3]	  ; 6ab4
                mov     [v661b],ax               ; 661b  data_279
		jmp	short loc_22
                nop
loc_19:
                mov     word ptr ds:[sto7],6AC8h
                mov     word ptr ds:[stob],6AE2h
		mov	ax,word ptr ds:[6AE0h]
                mov     word ptr ds:[stoa],ax
		mov	word ptr ds:[v6617],6AFAh
                mov     [v6619],6B12h             ;6619 
		mov	ax,word ptr ds:[6B10h]
                mov     [v661b], ax                ;661b
		jmp	loc_22
                
loc_20:
                mov     word ptr ds:[sto7],6B28h
                mov     word ptr ds:[stob],6B4Ah
                mov     ax, offset v6b48	;data_319                ;6b48
                mov     word ptr ds:[stoa],ax
		mov	word ptr ds:[v6617],6B6Ah
                mov     [v6619],6B7Eh             ;6619
                mov     ax, data_320                ;6b7c
                mov     [v661b],ax                ;661b
		jmp	loc_22
                
loc_21:
                mov     word ptr ds:[sto7],6B90h
                mov     word ptr ds:[stob],6BB0h
                mov     ax, offset v6bae	;data_321         ;6bae
                mov     word ptr ds:[stoa],ax
		mov	word ptr ds:[v6617],6BCEh
                mov     [v6619],6BE4h        ;6619
                mov     ax,data_322           ;6be2
                mov     [v661b],ax           ;661b
loc_22:
                mov     sto1,0FFFEh
                mov     sto2,0FFFEh
                or      byte ptr [v6630],1
                or      byte ptr [v6630],2
                mov     byte ptr ds:[sto8],1
		sti				; Enable interrupts

; i think this waits until the music is finished playing		
		
loc_23:
      ;jl temp          cmp     byte ptr [v6630],0
      ;jl		jne	loc_23			; Jump if not equal
		

		

		cmp	byte ptr ds:[skilllevel],1
		je	loc_24			; Jump if equal
		cmp	byte ptr ds:[skilllevel],2
		je	loc_25			; Jump if equal
		cmp	byte ptr ds:[skilllevel],3
		je	loc_26			; Jump if equal
		cmp	byte ptr ds:[skilllevel],4
		je	loc_27			; Jump if equal
		jmp	loc_28
                
loc_24:
		cmp	byte ptr ds:[currentlevel], 8	; ef5h
		jne	loc_28			; Jump if not equal
                mov     byte ptr ds:[v5d8],1	; signal for end of game congrats?
		mov     byte ptr ds:[v5d9],0
		jmp	loc_45
loc_25:
		cmp	byte ptr ds:[currentlevel], 18
		jne	loc_28			; Jump if not equal
                mov     byte ptr ds:[v5d8],2
		mov     byte ptr ds:[v5d9],5
		jmp	loc_45
loc_26:
		cmp	byte ptr ds:[currentlevel], 30 
		jne	loc_28			; Jump if not equal
                mov     byte ptr ds:[v5d8],5
		mov     byte ptr ds:[v5d9],0
		jmp	loc_45
loc_27:
		cmp	byte ptr ds:[currentlevel], 30 
		jne	loc_28			; Jump if not equal
                mov     byte ptr ds:[v5d8],7
		mov     byte ptr ds:[v5d9],5
		jmp	loc_45

		
		
loc_28:
                mov     byte ptr ds:[v5d2],0
		mov	cl,byte ptr ds:[playernum]
                mov     byte ptr ds:[v5da],cl	; get player ascii value
		sub	cl,30h			; make it decimal for loop
		xor	ch,ch			; 
		mov	bx,5F8h
		sub	bx,0Ch

locloop_29:
		add	bx,0Ch
		loop	locloop_29		; Loop if cx > 0

		mov	si,5E0h
		mov	di,bx
		mov	cx,0Ch
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
loc_30:
                inc     byte ptr ds:[v5da]
                inc     byte ptr ds:[v5d2]
		add	bx,0Ch
                mov     al,byte ptr ds:[totalplayers]
                cmp     byte ptr ds:[v5da],al
		jle	loc_31			; Jump if < or =
                mov     byte ptr ds:[v5da], "1"	;
		nop
		mov	bx,5F8h
		mov	byte ptr ds:[someflag],1
		nop
loc_31:
                cmp     byte ptr ds:[v5d2],5
		jne	loc_33			; Jump if not equal
		test	byte ptr ds:[highscoreflag],80h
		jnz	loc_32			; Jump if not zero
		mov	data_161,15h
		call	displaytopscores
                call    wait4enter
loc_32:
		jmp	playerstart		;loc_4 input player options...
loc_33:
		cmp	byte ptr [bx],0
		je	loc_30			; Jump if equal
                mov     al,byte ptr ds:[v5da]
		mov	byte ptr ds:[playernum],al
		mov	si,bx
		mov	di,5E0h
		mov	cx,0Ch
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		jmp	loc_6

diediedie:	;loc_34:
                mov     al,byte ptr ds:[bonustimer]    ; save timer count 
                mov     byte ptr ds:[t_bonustimer],al  ; to temporary variable
                mov     ah,byte ptr ds:[v5d4]
                mov     byte ptr ds:[v5e1],ah
		call	playtone4	;sub_60
		
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6BF8
                mov     word ptr ds:[stob], offset v6C1A
		mov	ax,  [v6c18]	;data_323	   ;6c18
                mov     word ptr ds:[stoa],ax	;6615
                mov     sto1,0FFFEh	   
		or	byte ptr [v6630],1	    ;6630 data_290
		mov	word ptr ds:[v6617], offset v6C3A
		mov	data_278, offset v6C5C
		mov	ax, data_324
		mov	data_279, ax
                mov     sto2,0FFFEh
                or      byte ptr [v6630],2
                mov     byte ptr ds:[sto8],1
		sti				; Enable interrupts
		
		
		mov	byte ptr ds:[v5CE],14h
		nop
loc_35:
		mov	cx, 1200h
                test    word ptr ds:[pcjr?], -1 
		jnz	locloop_36		; Jump if not zero
		mov	cx, 3000h

locloop_36:
                mov     ah,[keypress]
		cmp	ah,2
		jb	loc_37			; Jump if below
		cmp	ah,9
		ja	loc_37			; Jump if above
		dec	ah
                mov     byte ptr ds:[v5e1],ah
loc_37:
		loop	locloop_36		; Loop if cx > 0




		mov	bx, offset endflag + 06 ; data_403e
		mov	bx,[bx]
		mov	word ptr [bx+6],0
		cmp	word ptr [bx+8], offset ibmlogo18	;7432h
		jne	loc_38			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo19	;7484h
		jmp	short loc_39
loc_38:
		mov	word ptr [bx+8], offset ibmlogo18	;7432h
loc_39:
		call	sub_51			; rotate dots above head
                call    putplayer
		call	sub_53
		dec	byte ptr ds:[v5CE]	; decrement dot count
		jnz	loc_35			; Jump if not zero
loc_40:
       ;jl temp         cmp     byte ptr [v6630],0     ; wait for end of music?
       ;jl         jne     loc_40                  ; interrupts when done?

                test    word ptr ds:[on_object],8000h
		jz	loc_41			; Jump if zero
		jmp	loc_23
loc_41:
		dec	byte ptr ds:[livesleft]	; subtract 1 dude (5e0)
		jz	loc_42			; if none left, exit game
		jmp	loc_7			; jump back to start of level
loc_42:
		mov	bx, offset v3586
		mov	cx, 4

locloop_43:
		mov	word ptr [bx+8],0
		add	bx,20h
		loop	locloop_43		; Loop if cx > 0

loc_44:
		call	highscore? 	;sub_25
		jmp	loc_28

		
; 		
		
		
loc_45:
		mov	cl, byte ptr ds:[livesleft]
		xor	ch, ch			

locloop_46:
		mov	byte ptr ds:[highscoreflag],1
                mov     al,byte ptr ds:[v5d8]
		add	byte ptr ds:[v5E4],al
                mov     al,byte ptr ds:[v5d9]
		add	byte ptr ds:[v5E5],al
		cmp	byte ptr ds:[livesleft],1
		je	loc_47			; Jump if equal
		dec	byte ptr ds:[livesleft]
loc_47:
		call	sub_8
		call	sub_15
		push	cx
		mov	cx,0

;locloop_48:
		loop	$		; Loop if cx > 0

		mov	cx,0

;locloop_49:
		loop	$ ;locloop_49		; Loop if cx > 0

		pop	cx
		loop	locloop_46		; Loop if cx > 0

		mov	byte ptr ds:[livesleft],0
		nop
		jmp	short loc_44

_1		endp

;
;                              SUBROUTINE
;

wait4enter      proc    near
		push	bx
		push	dx
		push	di
		mov	bl, 0Eh		; color
		mov	dh, 18h		; row
		mov	dl, 8		; col
		mov	di, offset entermsg	; 5B6h
                call    printline
loc_50:
	  ;	cmp	byte ptr data_295,0
	  ;	je	loc_50			; Jump if equal
	  
	  
	  	; temporary keyboard fix

		xor	ax, ax
		int 	16h
	  
	  
	  	pop	di
		pop	dx
		pop	bx
		retn
wait4enter      endp

entermsg	db	'PRESS ENTER TO CONTINUE',-1   ;@5b6

		
v5ce		db	00	; 5ce
skilllevel	db	00h	; 5cf 1=beginner...4=grandloop, 5=random
totalplayers    db      00h     ; 5d0
playernum	db	31h	; 5d1	; ascii current player# value
v5d2            db      00h     ; 5d2
someflag	db	0	; 5d3
v5d4            db      0       ; 5d4
mon_type	db	0	; 5d5
gameover	db	0	; 5d6	; flag
t_bonustimer    db      0       ; 5d7	; temporary storage for bonus time
					; saved during long delays and
					; when player dies.
v5d8            db      0       ; 5d8
v5d9            db      0       ; 5d9
v5da            db      0       ; 5da
bonuscount	db	30h	; 5db
bonushigh	db	30h	; 5dc
bonuslow	db	30h	; 5dd
		db	30h	; 5de
		db	30h	; 5df
livesleft	db	00h	; 5e0
v5e1            db      00h     ; 5e1
v5e2		db	0 	;10 dup(30h) 	; 5e2-5eb
v5e3		db	0
v5e4		db	0
v5e5		db	0
v5e6		db	0
v5e7		db	0
v5e8		db	0
v5e9		db	0
v5ea		db	0
v5eb		db	0
v5ec		db	07h    ;5ec
unused		db	04h    ;5ed
		db	10 dup (30h) ;5ee-5f7
zerobuffer	db	8 dup (0)    ;5f8
data_66         db      40 dup (0)
pcjr?           dw      0		;@628 i think.  level data checks too
		db	0,0,0,0,0,0








runtime:



;routine is jumped to from level data.
; this is the main control routine

loc_51:
		
		mov	bx, offset endflag + 06 	;data_403e
		mov	bx,[bx]
                mov     word ptr ds:[vce6],bx
		call	sub_3
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+6],0
                test    word ptr ds:[on_object],2
		jz	loc_52			; Jump if zero
		jmp	loc_125
loc_52:
                test    word ptr ds:[on_object],4
		jz	loc_53			; Jump if zero
		jmp	loc_107
loc_53:
                test    word ptr ds:[on_object],800h
		jz	loc_56			; Jump if zero
		mov	word ptr [bx+6],0
		call	sub_51
		call	sub_3
                test    word ptr ds:[vcb4],8
		jz	loc_54			; Jump if zero
		jmp	loc_106
loc_54:
		dec	word ptr ds:[vCB2]
		jnz	loc_55			; Jump if not zero
                and     word ptr ds:[on_object],0F7FFh
loc_55:
		jmp	loc_ret_139

		

		

		
loc_56:
		or	byte ptr ds:[v52C6],10h
                mov     ax,word ptr ds:[beatsme1]
		dec	ax
                mov     word ptr ds:[vcba],ax
                mov     ax,word ptr ds:[beatsme3]
		dec	ax
		mov	word ptr ds:[vCBC],ax
		
		cmp	byte ptr ds:[usejoystick],0
		je	loc_57			; Jump if equal
		call	readjoystick	;sub_44
		
		mov	ax,word ptr ds:[v52C2]
                mov     word ptr ds:[vcba],ax
		mov	ax,word ptr ds:[v52C4]
		mov	word ptr ds:[vCBC],ax


loc_57:
		test	byte ptr [keypress+key_space], -1 ;data_299,0FFh	; 666c
		jz	loc_58			; Jump if zero
		and	byte ptr ds:[v52C6],0EFh
loc_58:
		test	byte ptr [keypress+key_up], -1	;data_300,0FFh	  ;667b  UP!
		jz	loc_59			; Jump if zero
                mov     ax,word ptr ds:[beatsme4]   ;ypos 
		dec	ax
		mov	word ptr ds:[vCBC],ax
loc_59:
		test	byte ptr [keypress+key_down], -1 ;data_303,0FFh	  ;6683
		jz	loc_60			; Jump if zero
                
		int 3
		     
		mov     ax,word ptr ds:[beatsme3]
		inc	ax
		mov	word ptr ds:[vCBC],ax
loc_60:
		test	byte ptr [keypress+key_left], -1 ;data_301,0FFh	  ;667e
		jz	loc_61			; Jump if zero
                mov     ax,word ptr ds:[beatsme2]
		dec	ax
                mov     word ptr ds:[vcba],ax
loc_61:
		test	byte ptr [keypress+key_right], -1 ;data_302,0FFh	  ;6680
		jz	loc_62			; Jump if zero
                mov     ax,word ptr ds:[beatsme1]
		inc	ax
                mov     word ptr ds:[vcba],ax
loc_62:
		
		test	byte ptr ds:[v52C6],10h
		jz	loc_63			; Jump if zero
		jmp	loc_69
loc_63:
                cmp     word ptr ds:[vcb4],0
		jne	loc_64			; Jump if not equal
                cmp     word ptr ds:[vcb6],0
		jne	loc_64			; Jump if not equal
		jmp	loc_69
                
loc_64:
                mov     bx,word ptr ds:[vce6]
		mov	word ptr ds:[vCD8],0
                or      word ptr ds:[on_object],4
                and     word ptr ds:[on_object],0FF7Fh
                and     word ptr ds:[on_object],0FFDFh
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme4]
		jge	loc_65			; Jump if > or =
		mov	word ptr [bx+8], offset ibmlogo6	;705Ah
		jmp	loc_67
                
loc_65:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme2]
		jge	loc_66			; Jump if > or =
		mov	word ptr [bx+8], offset ibmlogo12	;7246h
		jmp     loc_67
                
loc_66:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme1]
		jl	loc_68			; Jump if <
		mov	word ptr [bx+8], offset ibmlogo13	;7298h
loc_67:
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C88
                mov     word ptr ds:[stob],offset v6C98
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C96]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
		jmp	loc_107
loc_68:
                and     word ptr ds:[on_object],0FFFBh
		jmp	loc_82
loc_69:
                test    word ptr ds:[vcb4],1
		jnz	loc_70			; Jump if not zero
		jmp	loc_82
loc_70:
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme4]
		jle	loc_71			; Jump if < or =
		jmp	loc_81
loc_71:
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],0FFh
loc_72:
                test    word ptr ds:[on_object],80h
		jnz	loc_74			; Jump if not zero
                mov     bx, [somevar0]
loc_73:
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		cmp	byte ptr [di],1
		jne	loc_73			; Jump if not equal
		mov	ax,[di+2]
                mov     bx,word ptr ds:[vce6]
		call	sub_54
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],0Fh
		mov	bx, offset endflag + 8 ; data_404e
		mov	bx,[bx]
		add	ax,4
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],7
		mov	bx,offset endflag + 0ah ;data_405e
		mov	bx,[bx]
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],7
                or      word ptr ds:[on_object],80h
loc_74:
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo6	;705Ah
		jne	loc_75			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo7	;70ACh
		jmp	loc_79
                
loc_75:
		cmp	ax, offset ibmlogo7	;70ACh
		jne	loc_76			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo8 ;70FEh
		mov	[bx+0Ah],ax
		jmp	loc_79
                
loc_76:
		cmp	ax, offset ibmlogo8	;70FEh
		jne	loc_78			; Jump if not equal
		mov	ax,[bx+0Ah]
		cmp	ax, offset ibmlogo7	;70ACh
		jne	loc_77			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo9	;7150h
		jmp	loc_79
                
loc_77:
		mov	word ptr [bx+8], offset ibmlogo7	;70ACh
		jmp	loc_79
                
loc_78:
		mov	word ptr [bx+8], offset ibmlogo8	;70FEh
		mov	[bx+0Ah],ax
loc_79:
                test    byte ptr [v6630],1
		jnz	loc_80			; Jump if not zero
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C82
                mov     word ptr ds:[stob], offset v6C86
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C84]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
loc_80:
		jmp	loc_96
loc_81:
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme3]
		jl	loc_82			; Jump if <
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],1
		jmp	loc_72
loc_82:
                test    word ptr ds:[vcb4],4
		jz	loc_84			; Jump if zero
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],1
		mov	ax,[bx+8]
		cmp	ax,offset ibmlogo10	;71A2h
		jne	loc_83			; Jump if not equal
		mov	word ptr [bx+8],offset ibmlogo11	;71F4h
		jmp	loc_86
                
loc_83:
		mov	word ptr [bx+8], offset ibmlogo10	;71A2h
		jmp	loc_86
               
loc_84:
                test    word ptr ds:[vcb4],2
		jz	loc_86			; Jump if zero
                test    word ptr ds:[vcb4],1
		jnz	loc_86			; Jump if not zero
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],0FFh
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo10	;71A2h
		jne	loc_85			; Jump if not equal
		mov	word ptr [bx+8],offset ibmlogo11	;71F4h
		jmp	loc_86
                
loc_85:		
		mov	word ptr [bx+8], offset ibmlogo10	;71A2h
loc_86:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme2]
		jg	loc_89			; Jump if >
                test    word ptr ds:[vcb4],2
		jnz	loc_87			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jnz	loc_87			; Jump if not zero
		jmp	loc_94
loc_87:
                and     word ptr ds:[on_object],0FF7Fh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],0FFh
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo2	;6F12h
		jne	loc_88			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo3	;6F64h
		jmp	loc_92
                
loc_88:
		mov	word ptr [bx+8], offset ibmlogo2	;6F12h
		jmp	loc_92
                
loc_89:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme1]
		jl	loc_94			; Jump if <
                test    word ptr ds:[vcb4],2
		jnz	loc_90			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jz	loc_94			; Jump if zero
loc_90:
                and     word ptr ds:[on_object],0FF7Fh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],1
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo4	;6FB6h
		jne	loc_91			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo5 	;7008h
		jmp	loc_92

loc_91:
		mov	word ptr [bx+8], offset ibmlogo4	;6FB6h
loc_92:
                test    byte ptr [v6630],1
		jnz	loc_93			; Jump if not zero
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C7C
                mov     word ptr ds:[stob], offset v6C80
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C7E]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
loc_93:
		jmp	loc_96
		
loc_94:
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],0
                test    word ptr ds:[vcb4],1
		jnz	loc_95			; Jump if not zero
                cmp     word ptr ds:[vcb4],0
		jne	loc_96			; Jump if not equal
		mov	word ptr [bx+8],offset IBMlogo1	;6EC0h
		mov	byte ptr [bx+7],0
		jmp	short loc_96
		db	90h
loc_95:
		mov	byte ptr [bx+7],0
		mov	word ptr [bx+8], offset ibmlogo6	;705Ah
loc_96:
                mov     bx,word ptr ds:[vce6]
                test    word ptr ds:[on_object],400h
		jnz	loc_97			; Jump if not zero
		call	sub_51	    ;<-plays a note
		jmp	loc_98
		
loc_97:
		call	sub_51
		call	sub_53	    ;<turns off speaker
                call    putplayer
loc_98:
		call	sub_2
		call	sub_3
                test    word ptr ds:[vcb4],8
		jz	loc_99			; Jump if zero
		jmp	loc_106
		
loc_99:
                cmp     word ptr ds:[vcb4],0
		jne	loc_100			; Jump if not equal
                test    word ptr ds:[vcb6],2
		jz	loc_101			; Jump if zero
loc_100:
                and     word ptr ds:[on_object],0FFFEh
		jmp	loc_ret_139
loc_101:
                test    word ptr ds:[on_object],1
		jnz	loc_106			; Jump if not zero
                or      word ptr ds:[on_object],1
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+6],100h
                call    putplayer
		call	sub_53
                test    word ptr ds:[on_object],400h
		jnz	loc_102			; Jump if not zero
		call	sub_51
		jmp	loc_103
loc_102:
		call	sub_51
		call	sub_53
                call    putplayer
loc_103:
		call	sub_2
		call	sub_3
                cmp     word ptr ds:[vcb4],0
		jne	loc_104			; Jump if not equal
                cmp     word ptr ds:[vcb6],0
		je	loc_105			; Jump if equal
loc_104:
                and     word ptr ds:[on_object],0FFFEh
loc_105:
		jmp	loc_ret_139
loc_106:
                and     word ptr ds:[on_object],0FBFFh
                and     word ptr ds:[on_object],0FFFBh
                and     word ptr ds:[on_object],0F7FFh
                or      word ptr ds:[on_object],2
                mov     ah,byte ptr ds:[v5e1]
                mov     byte ptr ds:[v5d4],ah
                mov     byte ptr ds:[v5e1],2
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+18h],0ACh
		jmp	loc_ret_139
loc_107:
		
		

		cmp	word ptr ds:[vCD8],0Dh
		jne	loc_108			; Jump if not equal
		jmp	loc_116
loc_108:
		cmp	word ptr ds:[vCD8],5
		jl	loc_113			; Jump if <
		call	sub_3
                test    word ptr ds:[on_object],20h
		jnz	loc_109			; Jump if not zero
                test    word ptr ds:[vcb4],1
		jz	loc_111			; Jump if zero
                test    word ptr ds:[on_object],10h
		jnz	loc_111			; Jump if not zero
                or      word ptr ds:[on_object],20h
		jmp	short loc_111
loc_109:
                mov     bx, [somevar0]
loc_110:
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		cmp	byte ptr [di],1
		jne	loc_110			; Jump if not equal
                mov     bx,word ptr ds:[vce6]
		mov	ax,[bx+2]
		cmp	ax,[di+2]
		je	loc_116			; Jump if equal
loc_111:
                test    word ptr ds:[vcb4],4
		jz	loc_112			; Jump if zero
                test    word ptr ds:[on_object],8
		jz	loc_116			; Jump if zero
loc_112:
                test    word ptr ds:[vcb4],2
		jnz	loc_116			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jnz	loc_116			; Jump if not zero
loc_113:
                mov     bx,word ptr ds:[vce6]
		mov	di,word ptr ds:[vCD8]
		mov	al,byte ptr ds:[vCBE][di]
		mov	[bx+7],al
		mov	al,byte ptr ds:[vCCB][di]
		mov	[bx+11h],al
		cmp	word ptr [bx+8], offset ibmlogo6	;705Ah
		jne	loc_114			; Jump if not equal
		mov	byte ptr [bx+6],0
		jmp	short loc_117
loc_114:
		cmp	word ptr [bx+8],offset ibmlogo12	;7246h
		jne	loc_115			; Jump if not equal
		mov	byte ptr [bx+6],0FFh
		jmp	short loc_117

loc_115:
		mov	byte ptr [bx+6],1
		jmp	short loc_117

loc_116:
                and     word ptr ds:[on_object],0FFFBh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+11h],2
		jmp	loc_96
loc_117:
                test    word ptr ds:[vcb4],1
		jz	loc_118			; Jump if zero
                or      word ptr ds:[on_object],10h
		jmp	short loc_119
loc_118:
                and     word ptr ds:[on_object],0FFEFh
loc_119:
                test    word ptr ds:[vcb4],4
		jz	loc_120			; Jump if zero
                or      word ptr ds:[on_object],8
		jmp	short loc_121
loc_120:
                and     word ptr ds:[on_object],0FFF7h
loc_121:
                test    word ptr ds:[on_object],400h
		jnz	loc_122			; Jump if not zero
		call	sub_51
		jmp	short loc_123
loc_122:
		call	sub_51
		call	sub_53
                call    putplayer
loc_123:
		call	sub_2
		call	sub_3
		inc	word ptr ds:[vCD8]
                test    word ptr ds:[vcb4],8
		jz	loc_124			; Jump if zero
		jmp	loc_106
loc_124:
		jmp	loc_ret_139
loc_125:
                mov     bx,word ptr ds:[vce6]
                test    word ptr ds:[on_object],40h
		jz	loc_126			; Jump if zero
		jmp	loc_134
loc_126:
		mov	word ptr [bx+6],100h
		mov	word ptr [bx+10h],204h
		cmp	word ptr [bx+8], offset ibmlogo14	;72EAh
		je	loc_127			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo15	;733Ch
		je	loc_127			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo16	;738Eh
		je	loc_127			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo17 ;73E0h
		je	loc_127			; Jump if equal
		mov	word ptr [bx+8], offset ibmlogo14	;72EAh
loc_127:
		call	sub_51
		call	sub_2
		call	sub_3
		mov	ax,[bx+18h]
		cmp	ax,[bx+4]
		jne	loc_128			; Jump if not equal
                or      word ptr ds:[on_object],100h
		jmp	loc_ret_139
loc_128:
                test    word ptr ds:[on_object],40h
		jz	loc_129			; Jump if zero
		jmp	loc_ret_139
loc_129:
                cmp     word ptr ds:[vcb4],0
		jne	loc_130			; Jump if not equal
		jmp	loc_ret_139
loc_130:
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset something0	;6EB2h
                mov     word ptr ds:[stob], offset something1	;6EB6h
		mov	ax,data_332
                mov     word ptr ds:[stoa],ax
                mov     sto1,0FFFEh
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
		mov	word ptr ds:[vCE4],0
                or      word ptr ds:[on_object],40h
loc_131:
                call    gettimestamp
		and	dh,3
		cmp	dh,2
		jg	loc_131			; Jump if >
		cmp	dh,0
		jne	loc_132			; Jump if not equal
		mov	byte ptr ds:[vCDA],0
		nop
		jmp	loc_ret_139
loc_132:
		cmp	dh,1
		jne	loc_133			; Jump if not equal
		mov	byte ptr ds:[vCDA],1
		nop
		jmp	loc_ret_139
		
loc_133:
		mov	byte ptr ds:[vCDA],0FFh
		nop
		jmp	loc_ret_139
loc_134:
		cmp	word ptr ds:[vCE4],9
		je	loc_138			; Jump if equal
		mov	di,word ptr ds:[vCE4]
		mov	al,byte ptr ds:[vCDA]
		mov	[bx+6],al
		mov	al,byte ptr ds:[vCDB][di]
		mov	[bx+7],al
		inc	word ptr ds:[vCE4]
		cmp	word ptr [bx+8], offset ibmlogo14	;72EAh
		je	loc_135			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo15	;733Ch
		je	loc_136			; Jump if equal
		cmp	word ptr [bx+8],offset ibmlogo16	;738Eh
		je	loc_137			; Jump if equal
		mov	word ptr [bx+8], offset ibmlogo14	;72EAh
		jmp	loc_127
loc_135:
		mov	word ptr [bx+8], offset ibmlogo15	;733Ch
		jmp	loc_127
loc_136:
		mov	word ptr [bx+8], offset ibmlogo16	;738Eh
		jmp	loc_127
loc_137:
		mov	word ptr [bx+8], offset ibmlogo17 ;73E0h
		jmp	loc_127
loc_138:
                and     word ptr ds:[on_object],0FFBFh
		jmp	loc_125

loc_ret_139:
		retn

vcb2		dw	0		;@cb2-3
vcb4		dw	0 		;@cb4-5
vcb6		dw	0		;@cb6-7
on_object       dw      0               ;@cb8-9h
vcba            dw      0               ;@cba-b
vcbc		dw	0		;@cbc-d
vcbe		dw	-1		;@cbe-f
		dw	-1 		;@cc0-1
		dw	0		;@cc2-3
		dw	0101h		;@cc4-5
		dw	0101h		;@cc6-7
		dw	0101h		;@cc8-9
		db	04		;@cca
vccb		db	01h		;@ccb
		dw	0402h		;@ccc-d
		dw	0002h		;@cce-f
		dw	0200h		;@cd0-1
		dw	0402h		;@cd2-3
		dw	0404h		;@cd4-5
		dw	0404h		;@cd6-7
vcd8		dw	0000h		;@cd8-9
vcda		db	0ffh		;@cda
vcdb		db	0		;@cdb

	       ;	db	 00h, 02h, 02h, 04h, 04h, 04h
	       ;	db	 04h, 04h, 00h, 00h, 00h,0FFh
		db	0FFh, 00h, 00h, 01h, 01h, 01h
		db	01, 01		
vce4		dw	00h		;@ce4
vce6		dw	0 ;00h, 00h	;@ce6

;
;                              SUBROUTINE
;

sub_2		proc	near
		push	bx
		push	cx
		push	dx
		push	di
                mov     bx,word ptr ds:[vce6]
		mov	cx,[bx+2]
		mov	dx,[bx+4]
		mov	di, offset endflag + 8 ;data_404e  ;FJM1
		mov	di,[di]
		mov	bx,offset endflag +0ah	;data_405e  ;FJM2
		mov	bx,[bx]
		add	cx,4
		mov	[di+2],cx
		mov	[bx+2],cx
		add	cx,7
		mov	[di+1Ch],cx
		mov	[bx+1Ch],cx
		mov	[di+4],dx
		add	dx,9
		mov	[di+1Eh],dx
		inc	dx
		mov	[bx+4],dx
		mov	[bx+1Eh],dx
		pop	di
		pop	dx
		pop	cx
		pop	bx
		retn
sub_2		endp


;
;                              SUBROUTINE
;

sub_3		proc	near
;loc_140:
		push	ax
		push	bx
		push	cx
		push	di
                mov     word ptr ds:[vcb4],0
                mov     word ptr ds:[vcb6],0
		mov	bx,offset endflag + 0ah	;data_405e
		mov	bx,[bx]
		call	sub_50
                mov     bx, [somevar0]
loc_141:
		cmp	bx,0
		je	loc_142			; Jump if equal
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		mov	al,[di]
		dec	al
		mov	cl,al
		mov	ax,1
		shl	ax,cl			; Shift w/zeros fill
                or      word ptr ds:[vcb6],ax
		jmp	short loc_141
loc_142:
		mov	bx, offset endflag + 8 ;data_404e
		mov	bx,[bx]
		call	sub_50
                mov     bx, [somevar0]
loc_143:
		cmp	bx,0
		je	loc_144			; Jump if equal
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		mov	al,[di]
		dec	al
		mov	cl,al
		mov	ax,1
		shl	ax,cl			; Shift w/zeros fill
                or      word ptr ds:[vcb4],ax
		jmp	short loc_143
loc_144:
		pop	di
		pop	cx
		pop	bx
		pop	ax
		retn
sub_3		endp


;
; loadlevel SUBROUTINE 
;

loadlevel	proc	near
		push	ax
		push	bx
		push	cx
		push	dx
		push	es
		cmp	byte ptr ds:[someflag],0	; need to load flag?
		jne	@f				; Jump if not equal
		mov	ah, byte ptr ds:[currentlevel]
                push    ax
		jmp	loc_150
@@:
		mov	byte ptr ds:[someflag],0
		
		mov	di, offset levelbar1
		mov	dh, 0Ah	   ; row
		mov	dl, 0	   ; start col
		mov	bl, 0Ch	   ; color 0c=RED
                call    printline
		
		mov	di, offset nextlvlmsg	
		mov	dh, 0Ah	   ; row
		mov	dl, 0Fh	   ; start col
		mov	bl, 0Eh	   ; color 0e=yellow
                call    printline
		
		mov	di, offset levelbar1
		mov	dh, 0Ah	   ; row
		mov	dl, 1Ah	   ; startcol
		mov	bl, 0Ch	   ; color 
                call    printline

		cmp	byte ptr ds:[skilllevel],5	; randomizer?
		jne	@f				; Jump if not equal
randomizer:
                call    gettimestamp                    ; get random#
		and	dh, 1Fh				; make<=31
		cmp	dh, 29				; > 29?
		jg	randomizer			; try again
		cmp	dh, 2				; < 2?	seems wrong.
		jl	randomizer			; try again
		cmp	dh, byte ptr ds:[currentlevel]	; same as current?
		je	randomizer			; try again
		mov	ah, dh				; put new level # in AH
		jmp	foundalevel
		
@@: 
		inc	byte ptr ds:[currentlevel]
		mov	ah,byte ptr ds:[currentlevel]
foundalevel:
		mov	di, offset levelbar2		; 0F05h
		mov	bl, 9 		; color
		mov	dh, 0Ch		; row
		mov	dl, 0		; col
                call    printline
		mov	di, offset levelbar1 + 1	; 1 less char than
		mov	bl, 9		; color		; higher bar
		mov	dh, 0Dh		; row
		mov	dl, 0		; col 
                call    printline
		
		mov	byte ptr ds:[currentlevel],ah	; 
		push	ax
		
		mov	cl, ah
		xor	ch, ch				; Zero register
		mov	di, offset levelnames
		sub	di, 15h				; prepare 4 loop

levelnameloop:
		add	di,15h
		loop	levelnameloop			; calculate offset
							; of level name
		mov	dh, 0Dh		; row
		mov	dl, 0Ah		; col
		mov	bh, 0		; ?
		mov	bl, 0Fh		; color
                call    printline
		
		mov	di, offset levelbar1 + 1
		mov	bl, 9		; color
		mov	dh, 0Dh		; row
		mov	dl, 1Eh		; col
                call    printline
		
		mov	di, offset levelbar2	
		mov	bl, 9		; color
		mov	dh, 0Eh		; row
		mov	dl, 0		; col
                call    printline
loc_150:
                pop     ax
                call      readlevelfromdisk
	     ;	mov	ax, 980h		; load level to 980:0
	     
       ;	     	mov	bx, offset endflag

		
	     ;	mov	es, ax			;
	     ;	xor	bx, bx			; Zero register
       ;	     	mov	dl, 0
       ;	     	mov	dh, 0
       ;	     	pop	ax
       ;	     	push	ax
       ;	     	mov	ch, ah			; level #
       ;	     	mov	cl, 1
       ;	     	mov	ah, 2
       ;	     	mov	al, 8
       ;	     	int	13h			
       ;		jc	loc_150			; added jl
		
       ;	     	cmp	ah,0
       ;	     	jne	loc_150			; re-read if error

loc_151:
	     ;	mov	ax,0A80h		; read 2nd half of level
	     
       ;	     	mov	bx, offset endflag
       ;		add	bx, 512*8
			 
	     
	      ;	mov	es,ax
	      ;	xor	bx,bx			; 
       ;	     	mov	dl,0
       ;	     	mov	dh,1			; from 2nd side of disk
       ;	     	pop	ax
       ;	     	push	ax
       ;	     	mov	ch,ah
       ;	     	mov	cl,1
       ;	     	mov	ah,2
       ;	     	mov	al,8
       ;	     	int	13h			; Disk  dl=drive a  ah=func 02h
       ;		jc	loc_151	   ;added jl	;  read sectors to memory es:bx
						;   al=#,ch=cyl,cl=sectr,dh=head
       ;	     	cmp	ah,0
       ;	     	jne	loc_151			; re-read if error
	      
	     
       ;	     	pop	ax

	     ; wimpy delay.  change to wait41sec or something
	     
	     	mov	cx,0

locloop_152:
		loop	locloop_152		; Loop if cx > 0

		mov	cx,0

locloop_153:
		loop	locloop_153		; Loop if cx > 0


		; point BX to start of level data
	      	; check to see if this is level 25 (mystery maze)
		; if so, grab a random number from 0-2


		mov	bx, offset endflag ; data_401e
		
		cmp	byte ptr [bx],32h	; '2' looks like level #?
		jne	loc_157			; Jump if not equal
		
		cmp	byte ptr [bx+1],35h	; '5'
		jne	loc_157			; Jump if not equal
loc_154:
                call    gettimestamp
		and	dh,3
		jz	loc_154			; Jump if zero
		cmp	dh,1
		je	loc_155			; Jump if equal
		cmp	dh,2
		je	loc_156			; Jump if equal
		
	       ;	mov	bx,data_402e
		
	        mov	bx, offset endflag+2 ; added jl

		mov	di,[bx]
		mov	ax,[di+4]
		mov	[bx],ax
		
		mov	bx, offset endflag+19 	;added jl
		;mov	bx,data_409e
		
		mov	di,[bx]
		mov	ax,[di+4]
		mov	[bx],ax
		jmp	short loc_157
			                        ;* No entry point to code
		nop
loc_155:
		mov	bx, offset endflag+2 ; added jl data_402e
		mov	di,[bx]
		mov	ax,[di]
		mov	[bx],ax
		mov	bx,offset endflag+19	; added jl data_409e
		mov	di,[bx]
		mov	ax,[di]
		mov	[bx],ax
		jmp	short loc_157
			                        ;* No entry point to code
		nop
loc_156:
		mov	bx,offset endflag +2 ;added jl data_402e
		mov	di,[bx]
		mov	ax,[di+2]
		mov	[bx],ax
		mov	bx,offset endflag+19 ; data_409e
		mov	di,[bx]
		mov	ax,[di+2]
		mov	[bx],ax
loc_157:
		




	; another wimpy delay.

		mov	cx,0

locloop_158:
		loop	locloop_158		; Loop if cx > 0

		mov	cx,0

locloop_159:
		loop	locloop_159		; Loop if cx > 0

	
		
		pop	es
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		retn
loadlevel	endp








currentlevel	db	00h			; variable for current lvl#
levelbar1	db	14 dup (0DBh), -1
levelbar2	db	40 dup (0DBh),-1
nextlvlmsg	db	'NEXT LEVEL',-1
levelnames	db	'    EASY DOES IT    ',-1
		db	'      ROBOTS I      ',-1
		db	'     BOMBS AWAY     ',-1
		db	'   JUMPING BLOCKS   ',-1
		db	'      VAMPIRE.      ',-1
		db	'      INVASION      ',-1
		db	'   GRAND PUZZLE I   ',-1
		db	'      BUILDER.      ',-1
		db	'   LOOK OUT BELOW   ',-1
		db	'      HOT FOOT      ',-1
		db	'      RUNAWAY.      ',-1
		db	'     ROBOTS II.     ',-1
		db	'     HAILSTONES     ',-1
		db	'   DRAGON SLAYER.   ',-1
		db	'  GRAND PUZZLE II.  ',-1
		db	'    RIDE AROUND.    ',-1
		db	'     THE ROOST.     ',-1
		db	'    ROLL ME OVER    ',-1
		db	'  LADDER CHALLENGE  ',-1
		db	'      FIGURIT.      ',-1
		db	'     JUMP-N-RUN     ',-1
		db	'       FREEZE       ',-1
		db	' FOLLOW THE LEADER. ',-1
		db	'       JUNGLE       ',-1
		db	'    MYSTERY MAZE    ',-1
		db	'     GUNFIGHTER     ',-1
		db	'     ROBOTS III     ',-1
		db	' NOW YOU SEE IT ... ',-1
		db	'    GOING DOWN ?    ',-1
		db	'  GRAND PUZZLE III  ',-1


;
;                              SUBROUTINE
;

; this rountine loads the compressed data from the level and expands it into
; memory.  I think.



expandlevel		proc	near
;loc_160:
		
		push	ax
		push	bx
		push	cx
                push    word ptr ds:[startseg]            ; stack
                mov     word ptr ds:[startseg], ss        ; put stack in stack
		mov	word ptr ds:[dunno4], 0		; =0
		mov	word ptr ds:[dunno6], 13Fh	;data_240,13Fh=0
		mov	word ptr ds:[dunno5], 0		;=0
		mov	word ptr ds:[dunno7], 0B5h	;=0
		mov	word ptr ds:[dunno8], 0		;=0 data_242,0
		call	sub_35
                pop     word ptr ds:[startseg]            ;=stack
		
		mov	bx, offset endflag+2 ;data_402e	;=9302
		mov	bx,[bx]		                ;=9321
loc_161:
		cmp	word ptr [bx],0FFFFh
		jz	loc_163			         ; Jump if zero
		
		mov	ax,[bx]			        ;=08 
                mov     word ptr ds:[xpos],ax     	;xpos
		mov	ax,[bx+2]		        ;=18
                mov     word ptr ds:[ypos],ax           ;ypos
		mov	cx,[bx+4]		        ;=5
                mov     word ptr ds:[gfxoffset], offset ibmcgaoffset2 ;7518h	;

locloop_162:
		call	sub_40			    ; display data
                add     word ptr ds:[xpos],8      ; counter
		loop	locloop_162		    ; Loop if cx > 0

		add	bx,6			    ; point to next data array
		jmp	short loc_161
loc_163:
		add	bx,2
loc_164:
		cmp	word ptr [bx],0FFFFh
		jz	loc_166			; Jump if zero
		mov	ax,[bx]
                mov     word ptr ds:[xpos],ax
		mov	ax,[bx+2]
                mov     word ptr ds:[ypos],ax
		mov	cx,[bx+4]
                mov     word ptr ds:[gfxoffset], offset ibmcgaoffset3 ;74D6h

locloop_165:
		call	sub_40
                add     word ptr ds:[ypos],8
		loop	locloop_165		; Loop if cx > 0

		add	bx,6
		jmp	short loc_164
loc_166:
		add	bx,2
loc_167:
		cmp	word ptr [bx],0FFFFh
		jz	loc_169			; Jump if zero
		mov	ax,[bx]
                mov     word ptr ds:[xpos],ax
		mov	ax,[bx+2]
                mov     word ptr ds:[ypos],ax
		mov	cx,[bx+4]
                mov     word ptr ds:[gfxoffset], offset ibmcgaoffset5 ;7540h

locloop_168:
		call	sub_40
                add     word ptr ds:[ypos],8
		loop	locloop_168		; Loop if cx > 0

		add	bx,6
		jmp	short loc_167
loc_169:
		add	bx,2
loc_170:
		cmp	word ptr [bx],0FFFFh
		jz	loc_172			; Jump if zero
		mov	ax,[bx]
                mov     word ptr ds:[xpos],ax
		mov	ax,[bx+2]
                mov     word ptr ds:[ypos],ax
		mov	cx,[bx+4]
                mov     word ptr ds:[gfxoffset], offset ibmcgaoffset6 ;7552h

locloop_171:
		call	sub_40
                add     word ptr ds:[ypos],8
		loop	locloop_171		; Loop if cx > 0

		add	bx,6
		jmp	loc_170
loc_172:
		add	bx,2
loc_173:
		cmp	word ptr [bx],0FFFFh
		jz	loc_175			; Jump if zero
		cmp	word ptr [bx],0
		je	loc_174			; Jump if equal
		mov	ax,[bx]
                mov     word ptr ds:[xpos],ax
		mov	ax,[bx+2]
                mov     word ptr ds:[ypos],ax
                mov     word ptr ds:[gfxoffset], offset ibmcgaoffset1 ;7532h
                call    copy2screen
loc_174:
		add	bx,4
		jmp	short loc_173
loc_175:
		pop	cx
		pop	bx
		pop	ax
		retn
expandlevel	endp


;
;                              SUBROUTINE
;

sub_6		proc	near
;loc_176:
		push	ax
		push	bx
		call	sub_48_
		mov	bx, offset endflag+8	;FJMC1 ?
		mov	ax,[bx]
		call	sub_49_
		mov	bx,offset endflag + 0ah	;FJMC2 ?
		mov	ax,[bx]
		call	sub_49_
		mov	bx,offset endflag + 19h ;startpos Y postion.?
		mov	bx,[bx]
loc_177:
		cmp	word ptr [bx],0FFFFh
		jz	loc_178			; Jump if zero
		mov	ax,bx
		call	sub_49_
		add	bx,20h
		jmp	loc_177
loc_178:
		pop	bx
		pop	ax
		retn
sub_6		endp


;
;                              SUBROUTINE
;

sub_7		proc	near
		push	ax
		call	readjoystick	;sub_44
		mov	ax,word ptr ds:[v52C2]
                mov     word ptr ds:[beatsme1],ax
                mov     word ptr ds:[beatsme2],ax
		mov	ax,word ptr ds:[v52C4]
                mov     word ptr ds:[beatsme3],ax
                mov     word ptr ds:[beatsme4],ax
                mov     ax,word ptr ds:[beatsme1]
		shr	ax,1			; Shift w/zeros fill
                add     word ptr ds:[beatsme1],ax
                sub     word ptr ds:[beatsme1],2
                sub     word ptr ds:[beatsme2],ax
                add     word ptr ds:[beatsme2],2
                mov     ax,word ptr ds:[beatsme3]
		shr	ax,1			; Shift w/zeros fill
                add     word ptr ds:[beatsme3],ax
                add     word ptr ds:[beatsme3],2
                sub     word ptr ds:[beatsme4],ax
                sub     word ptr ds:[beatsme4],2
		pop	ax
		retn
sub_7		endp

beatsme1	dw	0
beatsme2	dw	0
beatsme3	dw	0   ;@cba i think
beatsme4	dw	0
beatsme5	dw	0
beatsme6	dw	0
beatsme7	dw	0
beatsme8	dw	0
		db	1 (0)

;
;                              SUBROUTINE
;

sub_8		proc	near
;loc_179:
		push	bx
		push	cx
		push	di
loc_180:
		cmp	byte ptr ds:[v5E6],3Ah	; ':'
		jl	loc_181			; Jump if <
		sub	byte ptr ds:[v5E6], 10
		inc	byte ptr ds:[v5E5]
		jmp	short loc_180
loc_181:
		cmp	byte ptr ds:[v5E5],3Ah	; ':'
		jl	loc_182			; Jump if <
		sub	byte ptr ds:[v5E5], 10
		inc	byte ptr ds:[v5E4]
		jmp	short loc_181
loc_182:
		cmp	byte ptr ds:[v5E4],3Ah	; ':'
		jl	loc_183			; Jump if <
		sub	byte ptr ds:[v5E4], 10
		inc	byte ptr ds:[v5E3]
		jmp	short loc_182
loc_183:
		cmp	byte ptr ds:[v5E3],3Ah	; ':'
		jl	loc_184			; Jump if <
		sub	byte ptr ds:[v5E3], 10
		inc	byte ptr ds:[v5E2]
		inc	byte ptr ds:[livesleft]
		call	sub_15
		jmp	short loc_183
loc_184:
		mov	byte ptr ds:[flag2],0
		nop
                mov     word ptr ds:[xpos],108h
                mov     word ptr ds:[ypos],0BAh
		mov	cx,5
		mov	di, offset v5E2		; not sure if this should be
						; offset of v5e2

locloop_185:
		xor	bh,bh			; Zero register
		mov	bl,[di]
		cmp	cx,1
		je	loc_186			; Jump if equal
		cmp	bl,30h			; '0'
		jne	loc_186			; Jump if not equal
		cmp	byte ptr ds:[flag2],0
		je	loc_187			; Jump if equal
loc_186:
                call    xlatcharacter
                call    char2gfx
		mov	byte ptr ds:[flag2],0FFh
		nop
loc_187:
                add     word ptr ds:[xpos],8
		inc	di
		loop	locloop_185		; Loop if cx > 0

                mov     bx,word ptr ds:[xpos]
		sub	bx,28h
                mov     dx,word ptr ds:[ypos]
                call    checkeol
                mov     word ptr ds:[dispstats1],bp
                mov     word ptr ds:[dispstats2],bp
                mov     word ptr ds:[dispstats0],5
                mov     word ptr ds:[gfxcount],0Ah
                call    put2screen
		pop	di
		pop	cx
		pop	bx
		retn
sub_8		endp


;
;sub_9                              SUBROUTINE
;

; the "bonus timer" is a ~ 5 second countdown that is decremented by the RTC
; INT 1C routine.



printbonusleft		proc	near
		push	bx
		push	cx
		push	di
                cmp     byte ptr ds:[bonustimer],0   ; counter = 0?
		je	loc_188			; Jump if equal
		jmp	loc_196
loc_188:
		cmp	byte ptr ds:[flag0],0	; out of time completely?
		jne	loc_189			; don't update screen
		jmp	loc_196
loc_189:
		mov	word ptr ds:[dunno4], 108h
		mov	word ptr ds:[dunno6], 130h	; data_240,130h
		mov	word ptr ds:[dunno5], 0C2h
		mov	word ptr ds:[dunno7], 0C6h
		mov	word ptr ds:[dunno8], 0		;data_242,0
		call	sub_35			; locate to position?         
						; erase last value?

					 

		dec	byte ptr ds:[bonuslow]	; bonus value
		cmp	byte ptr ds:[bonuslow],"0" -1 	; need to borrow?
		jg	loc_190			; Jump if >
		mov	byte ptr ds:[bonuslow],"9"	; '9' make into 9
		dec	byte ptr ds:[bonushigh]	; borrow from upper
loc_190:
		cmp	byte ptr ds:[bonushigh],"0" -1	;   upper > 0? 
		jg	loc_191			; still ok
		mov	byte ptr ds:[bonushigh],"0"	; '0'	  make 0

loc_191:
		mov	byte ptr ds:[flag2],0
		nop
                mov     word ptr ds:[xpos],108h
                mov     word ptr ds:[ypos],0C2h
		mov	cx,5			; print 4 chars of bonus
		mov	di,offset bonuscount	;5DBh

locloop_192:
		cmp	cx,1
		jne	loc_193			; Jump if not equal
		cmp	byte ptr ds:[flag2],0	; 14d8
		jne	loc_193			; Jump if not equal
		mov	byte ptr ds:[flag0],0
		nop
loc_193:
		xor	bh,bh			; Zero register
		mov	bl,[di]
		cmp	cx,1
		je	loc_194			; Jump if equal
		cmp	bl, "0"			; '0'
		jne	loc_194			; Jump if not equal
		cmp	byte ptr ds:[flag2],0
		je	loc_195			; Jump if equal
loc_194:
                call    xlatcharacter
                call    char2gfx
		mov	byte ptr ds:[flag2],0FFh
		nop
loc_195:
                add     word ptr ds:[xpos],8
		inc	di
		loop	locloop_192		; Loop if cx > 0

                mov     bx,word ptr ds:[xpos]
		sub	bx,28h
                mov     dx,word ptr ds:[ypos]
                call    checkeol
                mov     word ptr ds:[dispstats1],bp
                mov     word ptr ds:[dispstats2],bp
                mov     word ptr ds:[dispstats0],5
                mov     word ptr ds:[gfxcount],0Ah
                call    put2screen
                mov     byte ptr ds:[bonustimer], 100 ; 14d7  reload 5 sec timer 
		nop
loc_196:
		pop	di
		pop	cx
		pop	bx
		retn
printbonusleft		endp

flag0		db	0	; 14d6
bonustimer      db      0       ;@14d7
flag2		db	0	; 14d8

;
;                              SUBROUTINE
;

sub_10		proc	near
		push	ax
		push	bx
		push	cx
		push	dx
		push	di
                test    word ptr ds:[vcb4],10h
		jnz	loc_197			; Jump if not zero
		jmp	loc_219
loc_197:
		mov	bx,offset endflag + 8 ;data_404e
		mov	bx,[bx]
		call	sub_50
                mov     bx, [somevar0]
loc_198:
		cmp	bx,0
		jne	loc_199			; Jump if not equal
		jmp	loc_219
loc_199:
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		cmp	byte ptr [di],5
		je	loc_200			; Jump if equal
		jmp	loc_198
loc_200:
		mov	ax,di
		call	sub_47
		cmp	word ptr [di+6],0
		jne	loc_201			; Jump if not equal
		mov	ax,[di+2]
		mov	word ptr ds:[dunno4],ax
		add	ax,7
		mov	word ptr ds:[dunno6], ax	;data_240,ax
		mov	ax,[di+4]
		mov	word ptr ds:[dunno5],ax
		add	ax,5
		mov	word ptr ds:[dunno7], ax	;data_241,ax
		mov	word ptr ds:[dunno8], 0		;data_242,0
		call	sub_35
		mov	bx,word ptr ds:[dunno4]
		mov	dx,word ptr ds:[dunno5]
                call    checkeol
                mov     word ptr ds:[dispstats1],bp
                mov     word ptr ds:[dispstats2],bp
                mov     word ptr ds:[dispstats0],6
                mov     word ptr ds:[gfxcount],2
                call    put2screen
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+6],0

		call	sub_51
                call    putplayer
		call	sub_53
		jmp	loc_202
loc_201:
		mov	bx,di
		mov	ax,[bx+8]
		mov	word ptr [bx+8], offset ibmcgaoffset1 	;7532h
		call	sub_54
		mov	[bx+8],ax
loc_202:
		mov	word ptr [di+0Ch],1
		mov	bx,[di+8]
		push	di
		mov	bx,[bx+2]
loc_203:
		cmp	word ptr [bx],0FFFFh
		jnz	loc_204			; Jump if not zero
		jmp	loc_213
loc_204:
		cmp	word ptr [bx],0
		jne	loc_205			; Jump if not equal
		jmp	loc_212
loc_205:
		cmp	word ptr [bx],1
		je	loc_207			; Jump if equal
		cmp	word ptr [bx],2
		je	loc_208			; Jump if equal
		cmp	word ptr [bx],3
		je	loc_209			; Jump if equal
		cmp	word ptr [bx],4
		je	loc_206			; Jump if equal
                mov     word ptr ds:[gfxoffset], offset ibmcgaoffset1 ;7532h
		mov	ax,[bx+2]
                mov     word ptr ds:[xpos],ax
		mov	ax,[bx+4]
                mov     word ptr ds:[ypos],ax
                call    copy2screen
		push	bx
		mov	dx,[bx+4]
		mov	bx,[bx+2]
                call    checkeol
		pop	bx
                mov     word ptr ds:[dispstats1],bp
                mov     word ptr ds:[dispstats2],bp
                mov     word ptr ds:[dispstats0],6
                mov     word ptr ds:[gfxcount],2
                call    put2screen
		add	bx,6
		jmp	loc_203
loc_206:
                mov     word ptr ds:[gfxoffset], offset ibmcgaoffset2 ;7518h
		jmp	loc_210
loc_207:
                mov     word ptr ds:[gfxoffset], offset ibmcgaoffset3 ;74D6h
		jmp	loc_210
loc_208:
                mov     word ptr ds:[gfxoffset], offset ibmcgaoffset5 ;7540h
		jmp	loc_210
loc_209:
                mov     word ptr ds:[gfxoffset], offset ibmcgaoffset6 ;7552h
loc_210:
		mov	ax,[bx+2]
                mov     word ptr ds:[xpos],ax
		mov	ax,[bx+4]
                mov     word ptr ds:[ypos],ax
		mov	ax,[bx+6]
		mov	word ptr ds:[v1744],ax
		mov	ax,[bx+8]
		mov	word ptr ds:[v1746],ax
		mov	cx,[bx+0Ah]

locloop_211:
		call	sub_40
		mov	ax,word ptr ds:[v1744]
                add     word ptr ds:[xpos],ax
		mov	ax,word ptr ds:[v1746]
                add     word ptr ds:[ypos],ax
		loop	locloop_211		; Loop if cx > 0

		push	bx
		mov	dx,[bx+4]
		mov	bx,[bx+2]
                call    checkeol
		pop	bx
                mov     word ptr ds:[dispstats1],bp
                mov     word ptr ds:[dispstats2],bp
		mov	ax,[bx+0Ch]
                mov     word ptr ds:[dispstats0],ax
		mov	ax,[bx+0Eh]
                mov     word ptr ds:[gfxcount],ax
                call    put2screen
		add	bx,10h
		jmp	loc_203
loc_212:
		mov	ax,[bx+2]
		mov	word ptr ds:[dunno4],ax
		mov	ax,[bx+4]
		mov	word ptr ds:[dunno6], ax	;data_240,ax
		mov	ax,[bx+6]
		mov	word ptr ds:[dunno5],ax
		mov	ax,[bx+8]
		mov	word ptr ds:[dunno7], ax	;data_241,ax
		mov	word ptr ds:[dunno8], 0		;data_242,0
		call	sub_35
		push	bx
		mov	bx,word ptr ds:[dunno4]
		mov	dx,word ptr ds:[dunno5]
                call    checkeol
		pop	bx
                mov     word ptr ds:[dispstats1],bp
                mov     word ptr ds:[dispstats2],bp
		mov	ax,[bx+0Ah]
                mov     word ptr ds:[dispstats0],ax
		mov	ax,[bx+0Ch]
                mov     word ptr ds:[gfxcount],ax
                call    put2screen
		add	bx,0Eh
		jmp	loc_203
loc_213:
		pop	di
		mov	bx,[di+8]
		mov	bx,[bx]
loc_214:
		cmp	word ptr [bx],0FFFFh
		jz	loc_217			; Jump if zero
		cmp	word ptr [bx],0
		je	loc_215			; Jump if equal
		mov	ax,[bx+2]
		call	sub_49_
		jmp	loc_216
loc_215:
		mov	ax,[bx+2]
		call	sub_47
loc_216:
		add	bx,4
		jmp	loc_214

loc_217:
		mov	bx,[di+8]
		mov	di,[di+0Ah]
		mov	bx,[bx+4]
		call	bx			;*
		inc	byte ptr ds:[v5E4]
		call	sub_8
		mov	bx, offset endflag + 0ch  ;data_406e #targets
		dec	byte ptr [bx]		  ; got one, 1 less.
                
		test    word ptr ds:[pcjr?], -1
		jnz	loc_218			; Jump if not zero
		call	playtone4	;sub_60
		
		cli				; Disable interrupts
                mov     word ptr ds:[sto7],6CA6h
                mov     word ptr ds:[stob],6CB8h
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[6CB6h]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
		
		jmp	short loc_219
loc_218:
		cli				; Disable interrupts
		mov	word ptr ds:[v6617],6CA6h
		mov	data_278,6CB8h
                mov     sto2,0FFFEh
		mov	ax,word ptr ds:[6CB6h]
		mov	data_279,ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],2
		sti				; Enable interrupts
loc_219:
		pop	di
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		retn
sub_10		endp

v1744		dw	0	       ;	db	0, 0, 0, 0
v1746		dw	0
;
;                              SUBROUTINE
;

printline          proc    near
		push	ax
		push	bx
		push	cx
		mov	bh,0
loc_220:
		push	bx
		push	di
		mov	ah,2
		int	10h			; Video display   ah=functn 02h
						;  set cursor location in dx
		inc	dl
		pop	di
		pop	bx
		mov	al,[di]
		mov	cx,1
		mov	ah,9
		push	di
		int	10h			; Video display   ah=functn 09h
						;  set char al & attrib bl @curs
						;   cx=# of chars to replicate
		pop	di
		inc	di
		cmp	byte ptr [di],0FFh
		jne	loc_220			; Jump if not equal
		pop	cx
		pop	bx
		pop	ax
		retn
printline          endp


;
; printtext_gfx SUBROUTINE print text on a graphics screen
;
; input: di points to -1 terminated text
; xpos and ypos variables filled in

printtext_gfx          proc    near
		push	bx
		push	di
@@:
		xor	bh, bh			; Zero register
		mov	bl, [di]		; get byte to print
		cmp	bl, -1 			; end of line?
		je	@f			; Jump if equal
                call    xlatcharacter                  ; offset of graphics for char?
                call    char2gfx
                add     word ptr ds:[xpos],8
		inc	di
		jmp	@b
@@:
		pop	di
		pop	bx
		retn
printtext_gfx          endp


;
;                              SUBROUTINE
;

char2gfx          proc    near
		push	bx
		push	si
		push	cx
		push	ax
		cmp	byte ptr ds:[char2gfxtbl+bx], 0 ;[17E4h][bx],0=01
		je	loc_224			; exit if zero
		shl	bx, 1			; Shift w/zeros fill
		mov	si, 2 			; PSP_free_seg
                mov     cx, 0Ah			; counter
		mov	ax, word ptr ds:[chartable+bx]	
		mov	bx, ax				
		add	bx, 2

locloop_223:
		mov	al, [bx]			; 1937=0F
		and	al, byte ptr ds:[aflag]	; = FF mask maybe?
		mov	byte ptr ds:[bflag][si],al	; 17d8+2=00 x 10,1,0,1x12
		inc	bx			; copies to scratch pad?
		inc	si
		loop	locloop_223		; Loop if cx > 0

                mov     word ptr ds:[gfxoffset],offset bflag ;17D8h=878e
                call    copy2screen		;878e=5c012c000000ffffffffffffff0fffffffffffff00
loc_224:
		pop	ax
		pop	cx
		pop	si
		pop	bx
		retn
char2gfx          endp


;
;                              SUBROUTINE
;
; entry: BL=char to print


xlatcharacter          proc    near
		cmp	bx, " "			; is char a space?
		jb	@f ;loc_226			; Jump if below
		cmp	bx, "Z"			; is > Z? (5ah)
		ja	@f ;loc_226			; Jump if above
		
		sub	bx, 20h
		mov	bl, byte ptr [bx+charxlat]	;[bx+data_120]=1e

;loc_ret_225:
		retn
@@: ;loc_226:
		mov	bx,0
		ret			; jmp	loc_ret_225
xlatcharacter          endp


aflag		db	0		; 17d7
bflag		db	2		; 17d8
		

		db	5 
		db	10 dup (0)
		
char2gfxtbl	db	1, 0		; 17e4
		db	12 dup (1)
		db	0, 0
		db	10 dup (1)
		db	0, 0, 0, 0, 1
		db	8 dup (1)
		db	0, 1, 0, 0, 0, 1
		db	9 dup (1)
		db	0, 0, 0, 1
		db	13 dup (0)
		db	1, 1, 1, 0
		db	8 dup (1)
		db	 00h, 00h
		
chartable	db	0E1h, 18h 
		db	00h, 00h		; 1839
		db	0EDh, 18h
		db	0E5h, 1Ah
		db	0E5h, 1Ah
		db	0E5h, 1Ah
		db	0E5h, 1Ah
		db	0E5h, 1Ah
		db	0E5h, 1Ah
		db	0E5h, 1Ah
		dw	offset letter_pl	;parenthesis left
		dw	offset letter_pr	;parenthesis right
		db	8 dup (0)
		
		dw	offset letterq  ;0F5h, 19h
		dw	offset letterw	;, 3Dh, 1Ah, 
		dw	offset lettere	;65 19
		dw	offset letterr	;01 1a
		dw	offset lettert	;19h, 1Ah, 
		dw	offset lettery	;55h, 1Ah
		dw	offset letteru  ;25h, 1Ah, 
		dw	offset letteri 	;95h, 19h
		dw	offset lettero	;,0DDh, 19h
		dw	offset letterp	;0E9h, 19h
		db	8 dup (0)
		
		dw	offset lettera ;35h, 19h, 
		dw	offset letters ;0Dh, 1Ah
		dw	offset letterd	;59h, 19h
		dw	offset letterf ;71h, 19h, 
		dw	offset letterg ;7Dh, 19h
		dw	offset letterh ;, 89h, 19h
		dw 	offset letterj ;0A1h, 19h
		dw	offset letterk ;,0ADh, 19h
		dw	offset letterl ;,0B9h, 19h
		db	10 dup (0)

		dw	offset letterz ; 61h, 1Ah, 
		dw	offset letterx ; 49h, 1Ah, 
		dw	offset letterc ; 4Dh, 19h
		dw	offset letterv ; 31h, 1Ah, 
		dw	offset letterb ;41h, 19h
		dw	offset lettern ;0D1h, 19h
		dw	offset letterm ;0C5h, 19h
		dw	offset lettercma ;, 11h, 19h 
		dw	offset letterper ;, 1Dh, 19h 
		db	8 dup (0)
		
		dw	offset spacechar	;0E5h, 1Ah
		db	26 dup (0)
		dw	offset letter7 ;cma	;0B5h, 1Ah
		dw	offset letter8 ;0C1h, 1Ah,
		dw	offset letter9 ;0CDh, 1Ah
		db	 00h, 00h 
		dw	offset letter4 ;91h, 1Ah
		dw	offset letter5 ;9Dh, 1Ah
		dw	offset letter6 ;0A9h, 1Ah, 
		dw      offset letterdot ;29h, 19h, 
		dw      offset letter1 ;6Dh, 1Ah
		dw	offset letter2 ;79h, 1Ah
		dw      offset letter3 ;85h, 1Ah
		dw      offset letter0 ;0D9h, 1Ah  
		db	 00h, 00h 
		
        	db 02h, 05h, 00h, 00h, 0FFh, 00h,0FFh, 00h,0FFh, 00h, 00h, 00h 
        	db 02h, 05h, 0Fh, 00h, 0Fh, 00h, 0Fh, 00h, 00h, 00h, 0Fh, 00h
letter_pl	db 02h, 05h, 0Fh, 00h, 0F0h, 00h,0F0h, 00h,0F0h, 00h, 0Fh, 00h 
letter_pr	db 02h, 05h, 0Fh, 00h, 00h,0F0h, 00h,0F0h, 00h,0F0h, 0Fh, 00h 
lettercma	db 02h, 05h, 00h, 00h, 00h, 00h, 00h, 00h, 0Fh, 00h, 0F0h, 00h 
letterper	db 02h, 05h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0Fh, 00h 
letterdot      	db 02h, 05h, 00h, 00h, 0Fh, 00h,0FFh,0F0h, 0Fh, 00h, 00h, 00h 

lettera		db 02h, 05h, 0Fh, 00h, 0F0h,0F0h,0FFh,0F0h,0F0h,0F0h,0F0h,0F0h 
letterb		db 02h, 05h,0FFh, 00h, 0F0h,0F0h,0FFh, 00h,0F0h,0F0h,0FFh, 00h 
letterc		db 02h, 05h, 0Fh,0F0h, 0F0h, 00h,0F0h, 00h,0F0h, 00h,0Fh,0F0h
letterd		db 02h, 05h,0FFh, 00h, 0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0FFh, 00h
lettere		db 02h, 05h,0FFh,0F0h, 0F0h, 00h,0FFh, 00h,0F0h, 00h,0FFh,0F0h 
letterf		db 02h, 05h,0FFh,0F0h, 0F0h, 00h,0FFh, 00h,0F0h, 00h,0F0h, 00h 
letterg		db 02h, 05h, 0Fh,0F0h, 0F0h, 00h,0FFh,0F0h,0F0h,0F0h,0Fh,0F0h 
letterh		db 02h, 05h,0F0h,0F0h, 0F0h,0F0h,0FFh,0F0h,0F0h,0F0h,0F0h,0F0h
letteri		db 02h, 05h,0FFh,0F0h, 0Fh, 00h, 0Fh, 00h, 0Fh, 00h,0FFh,0F0h 
letterj		db 02h, 05h, 00h,0F0h, 00h,0F0h, 00h,0F0h,0F0h,0F0h,0Fh,0F0h
letterk		db 02h, 05h,0F0h,0F0h, 0FFh, 00h,0FFh, 00h,0F0h,0F0h,0F0h,0F0h
letterl		db 02h, 05h,0F0h, 00h, 0F0h, 00h,0F0h, 00h,0F0h, 00h,0FFh,0F0h
letterm		db 02h, 05h,0F0h,0F0h, 0FFh,0F0h,0FFh,0F0h,0F0h,0F0h,0F0h,0F0h
lettern		db 02h, 05h,0FFh, 00h, 	8 dup (0F0h)
lettero		db 02h, 05h, 0Fh, 00h,0F0h,0F0h, 0F0h,0F0h,0F0h,0F0h, 0Fh, 00h
letterp		db 02h, 05h,0FFh, 00h,0F0h,0F0h, 0FFh, 00h,0F0h,00h,0F0h, 00h 
letterq		db 02h, 05h, 0Fh, 00h,0F0h,0F0h,0F0h,0F0h,0F0h, 0F0h, 0Fh,0F0h
letterr		db 02h, 05h,0FFh, 00h,0F0h,0F0h,0FFh, 00h,0F0h, 0F0h,0F0h,0F0h
letters		db 02h, 05h, 0Fh, 0F0h,0F0h, 00h, 0Fh, 00h, 00h, 0F0h,0FFh, 00h
lettert		db 02h, 05h,0FFh, 0F0h, 0Fh, 00h, 0Fh, 00h, 0Fh,  00h, 0Fh, 00h
letteru		db 02h, 05h,0F0h, 0F0h,0F0h,0F0h,0F0h,0F0h,0F0h, 0F0h,0FFh,0F0h
letterv		db 02h, 05h, 8 dup (0F0h), 0Fh, 00h
letterw		db 02h, 05h,0F0h,0F0h, 0F0h,0F0h,0FFh,0F0h,0FFh,0F0h, 0F0h,0F0h
letterx		db 02h, 05h,0F0h,0F0h, 0F0h,0F0h, 0Fh, 00h,0F0h,0F0h, 0F0h,0F0h
lettery		db 02h, 05h,0F0h,0F0h, 0F0h,0F0h, 0Fh, 00h, 0Fh, 00h, 0Fh, 00h 
letterz		db 02h, 05h,0FFh,0F0h, 00h,0F0h, 0Fh, 00h,0F0h, 00h, 0FFh,0F0h

letter1		db 02h, 05h, 0Fh, 00h, 0FFh, 00h, 0Fh, 00h, 0Fh, 00h,0FFh,0F0h
letter2		db 02h, 05h,0FFh,0F0h, 00h,0F0h,0FFh, 00h,0F0h, 00h,0FFh,0F0h
letter3		db 02h, 05h,0FFh,0F0h, 00h,0F0h, 0Fh,0F0h, 00h,0F0h,0FFh,0F0h
letter4		db 02h, 05h,0F0h,0F0h,0F0h,0F0h,0FFh,0F0h, 00h,0F0h,00h,0F0h
letter5		db 02h, 05h,0FFh,0F0h,0F0h, 00h,0FFh, 00h, 00h,0F0h,0FFh, 00h
letter6		db 02h, 05h,0FFh,0F0h,0F0h, 00h,0FFh,0F0h,0F0h,0F0h,0FFh,0F0h
letter7		db 02h, 05h,0FFh,0F0h,00h,0F0h, 0Fh, 00h, 0Fh, 00h,0Fh, 00h 
letter8		db 02h, 05h,0FFh,0F0h,0F0h,0F0h,0FFh,0F0h,0F0h,0F0h,0FFh,0F0h
letter9		db 02h, 05h,0FFh,0F0h,0F0h,0F0h,0FFh,0F0h, 00h,0F0h,00h,0F0h
letter0		db 02h, 05h,0FFh,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0FFh,0F0h

spacechar	db 02h, 05h,10 dup (0)
		
charxlat	db	 39h, 00h, 00h, 00h, 00h, 00h
		db	 00h, 00h, 0Ah, 0Bh, 00h, 00h
		db	 33h, 00h
		db	'45ROPQKLMGHI'
		db	7 dup (4Eh)
		db	 1Eh, 30h, 2Eh, 20h, 12h, 21h
		db	 22h, 23h, 17h, 24h, 25h, 26h
		db	 32h, 31h, 18h, 19h, 10h, 13h
		db	 1Fh, 14h, 16h, 2Fh, 11h, 2Dh
		db	 15h, 2Ch,0FFh

;
;                              SUBROUTINE
;

sub_15		proc	near
		push	cx
		mov	word ptr ds:[dunno4], 0
		mov	word ptr ds:[dunno6], 0a0h	;data_240,0A0h
		mov	word ptr ds:[dunno5], 0B8h
		mov	word ptr ds:[dunno7], 0c7h	;data_241,0C7h
		mov	word ptr ds:[dunno8], 0		;data_242,0
		call	sub_35
		xor	ch,ch			; Zero register
		mov	cl,byte ptr ds:[livesleft]
loc_227:
		dec	cx
		jz	loc_229			; Jump if zero
		cmp	cx,6
		jg	loc_227			; Jump if >
                mov     word ptr ds:[gfxoffset], offset ibmlogo1 ;6EC0h
                mov     word ptr ds:[xpos],8
                mov     word ptr ds:[ypos],0BBh

locloop_228:
		call	sub_40
                add     word ptr ds:[xpos],10h
		loop	locloop_228		; Loop if cx > 0

loc_229:
		mov	bx, 8	;data_12e
		mov	dx, 0BBh
                call    checkeol
		mov	word ptr ds:[dispstats1], bp ; [5383h],bp  
		mov	word ptr ds:[dispstats2], bp ; [5385h],bp
                mov     word ptr ds:[gfxcount], 18h   ;5387h],18h
		mov	word ptr ds:[dispstats0], 0ah	;5381h],0Ah
                call    put2screen     ; display a graphic
		pop	cx
		retn
sub_15		endp


;
;                              SUBROUTINE
;

displayplayerstats		proc	near
		push	bx
		push	cx
		push	dx
		push	di
		mov	word ptr ds:[dunno4], 0
		mov	word ptr ds:[dunno6], 13fh	;data_240,13Fh
		mov	word ptr ds:[dunno5], 0B8h
		mov	word ptr ds:[dunno7], 0c7h	;data_241,0C7h
		mov	word ptr ds:[dunno8], 0 	;data_242,0
		call	sub_35
		call	sub_15				; display guys
		
                mov     byte ptr ds:[aflag], 0FFh        ; 17d7h
                mov     word ptr ds:[xpos], 78h
                mov     word ptr ds:[ypos], 0BAh
                mov     bx, 25	;data_19e
                call    char2gfx
                
                add     word ptr ds:[xpos],8
		mov	bx,data_22e
                call    char2gfx
                
                add     word ptr ds:[xpos],8
		mov	bx,data_20e
                call    char2gfx
                
                add     word ptr ds:[xpos],8
		mov	bx,data_16e
                call    char2gfx
                
                add     word ptr ds:[xpos],8
		mov	bx,data_14e
                call    char2gfx
                
                add     word ptr ds:[xpos],8
		mov	bx,data_15e
                call    char2gfx
                
                add     word ptr ds:[xpos],10h
		xor	bh,bh			; Zero register
		mov	bl,byte ptr ds:[playernum]
                call    xlatcharacter
                call    char2gfx
                mov     word ptr ds:[xpos],78h
                mov     word ptr ds:[ypos],0C2h
		mov	bx,data_22e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_14e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_24e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_14e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_22e
                call    char2gfx
                add     word ptr ds:[xpos],10h
		mov	di, offset endflag  ;data_401e
		mov	bl,[di]
		xor	bh,bh			; Zero register
                call    xlatcharacter
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bl,[di+1]
		xor	bh,bh			; Zero register
                call    xlatcharacter
                call    char2gfx
                mov     word ptr ds:[xpos],0D8h
                mov     word ptr ds:[ypos],0BAh
		mov	bx,data_21e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_23e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_18e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_15e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_14e
                call    char2gfx
		call	sub_8
                mov     word ptr ds:[xpos],0D8h
                mov     word ptr ds:[ypos],0C2h
		mov	bx,data_25e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_18e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_26e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_17e
                call    char2gfx
                add     word ptr ds:[xpos],8
		mov	bx,data_21e
                call    char2gfx
		inc	byte ptr ds:[bonuslow]
                mov     byte ptr ds:[bonustimer],0
		call	printbonusleft	;updatestats	;sub_9
		mov	bx, 0	;data_11e
		mov	dx,0B8h
                call    checkeol
                mov     word ptr ds:[dispstats1],bp
                mov     word ptr ds:[dispstats2],bp
                mov     word ptr ds:[dispstats0],10h
                mov     word ptr ds:[gfxcount],50h
                call    put2screen
		pop	di
		pop	dx
		pop	cx
		pop	bx
		retn
displayplayerstats	endp

loc_230:
		push	ax
		push	cx
loc_231:
;*		cmp	word ptr [di],0FFFFh
		db	 81h, 3Dh,0FFh,0FFh	;  Fixup - byte match
		jz	loc_233			; Jump if zero
		cmp	word ptr [di],0
		je	loc_232			; Jump if equal
		mov	ax,[di+2]
		call	sub_49_
		add	di,4
		jmp	short loc_231
loc_232:
		mov	ax,[di+2]
		call	sub_47
		add	di,4
		jmp	short loc_231
loc_233:
		add	di,2
;*		cmp	word ptr [di],0FFFFh
		db	 81h, 3Dh,0FFh,0FFh	;  Fixup - byte match
		jz	loc_236			; Jump if zero
		mov	ax,[di]
		mov	word ptr ds:[dunno4],ax
		mov	cx,[di+4]

locloop_234:
;*		add	ax,8
		db	5, 8, 0			;  Fixup - byte match
		loop	locloop_234		; Loop if cx > 0

		dec	ax
		mov	word ptr ds:[dunno6], ax	;data_240,ax
		mov	ax,[di+2]
;*		sub	ax,2
		db	 2Dh, 02h, 00h		;  Fixup - byte match
		mov	word ptr ds:[dunno5],ax
;*		add	ax,5
		db	5, 5, 0			;  Fixup - byte match
		mov	word ptr ds:[dunno7], ax	;data_241,ax
		mov	word ptr ds:[dunno8], 0		;data_242,0
		call	sub_35
		mov	ax,[di]
                mov     word ptr ds:[xpos],ax
		mov	ax,[di+2]
                mov     word ptr ds:[ypos],ax
                mov     word ptr ds:[gfxoffset], offset ibmcgaoffset2	;7518h
		mov	cx,[di+4]

locloop_235:
		call	sub_40
                add     word ptr ds:[xpos],8
		loop	locloop_235		; Loop if cx > 0

		mov	bx,[di]
		mov	dx,[di+2]
		sub	dx,2
                call    checkeol
                mov     word ptr ds:[dispstats1],bp
                mov     word ptr ds:[dispstats2],bp
                mov     word ptr ds:[dispstats0],8
                mov     word ptr ds:[gfxcount],10h
                call    put2screen
		add	di,6
loc_236:
		add	di,2
		pop	cx
		pop	ax
		retn
v1dd0		db	 00h	;@1dd0
v1dd1		db	0e6h
v1dd2		db	0f0h

;
;  sub_17                            SUBROUTINE
;
; play a note or tone on PCjr
playtone1	proc	near
;loc_237:
		push	ax
		push	dx
		cmp	byte ptr [v662f], 4eh	;data_289,4Eh	; 'N' quiet mode?
		je	loc_238			; Jump if equal
                cmp     word ptr ds:[pcjr?],0
		jne	loc_239			; Jump if not equal
loc_238:
		pop	dx
		pop	ax
		retn
loc_239:
		mov	dx,0C0h
		mov	al,byte ptr ds:[v1DD1]
		out	dx,al			; port 0C0h, pcjr tone gen
		mov	al,byte ptr ds:[v1DD2]
		or	al,byte ptr ds:[v1DD0]
		out	dx,al			; port 0C0h, pcjr tone gen
		jmp	short loc_238
playtone1	endp


;
;       sub_18                       SUBROUTINE
;

playtone2	proc	near
;loc_240:
		push	ax
		push	dx
                cmp     word ptr ds:[pcjr?],0
		je	loc_241			; Jump if equal
		mov	dx,0C0h
		mov	al,0FFh
		out	dx,al			; port 0C0h, pcjr tone gen
loc_241:
		pop	dx
		pop	ax
		retn
playtone2		endp

		db	7 dup (0)

;
;                              SUBROUTINE
;

inputPlayerOptions	proc	near
		push	ax
		push	bx
		push	cx
		push	dx
		push	di
                call    hidecursor
                mov     word ptr ds:[screenchar],0
                call    clearscreen
		
		mov	bl, 0Fh		; color
		mov	dh, 2		; row
		mov	dl, 0		; col
		mov	di, offset stars 	;1F81h
                call    printline
		
		mov	bl, 0Ch		; color
		mov	dh, 2		; row 
		mov	dl, 0Ah		; col
		mov	di, offset gameoptmsg	;1F6Ch
                call    printline
		
		mov	bl, 0Fh		; color
		mov	dh, 2		; row
		mov	dl, 1Fh		; col
		mov	di, offset stars 	;1F81h
                call    printline
		
		mov	bl, 0Eh		; color
		mov	dh, 5		; row
		mov	dl, 0Ch		; col
		mov	di, offset beginmsg		;1F8Bh
                call    printline
		
		mov	bl, 0Eh		; color
		mov	dh, 7		; row
		mov	dl, 0Ch		; col
		mov	di, offset intrmsg	;1F9Ch
                call    printline
		
		mov	bl, 0Eh		; color
		mov	dh, 9		; row
		mov	dl, 0Ch		; col
		mov	di, offset advmsg	;1FADh
                call    printline
		
		mov	bl, 0Eh		; color
		mov	dh, 0Bh		; row
		mov	dl, 0Ch		; col
		mov	di, offset grandmsg	;1FBEh
                call    printline
		
		mov	bl, 0Eh		; color
		mov	dh, 0Dh		; row
		mov	dl, 0Ch		; col
		mov	di, offset randmsg	;1FCFh
                call    printline
		
		mov	bl, 2		; color
		mov	dh, 10h		; row
		mov	dl, 3		; col
		mov	di, offset selectmsg	;1FE0h
                call    printline
loc_242:
;                mov     ah,[keypress]

		; temp keyboard patch
		xor	ax, ax
		int 	16h			; return char in ah
		
		cmp	ah,2
		jl	loc_242			; Jump if <
		cmp	ah,6
		jg	loc_242			; Jump if >
loc_243:
            ;    cmp     byte ptr [keypress],0
	    ;	jne	loc_243			; Jump if not equal
	    
	    	dec	ah
		xor	ch, ch			; Zero register
		mov	cl, ah
		
		push	ax			; prepare for loop
		mov	ax, 2

locloop_244:					; get ready to display box
		add	ax, 2			; based on selection
		loop	locloop_244		 

		mov	bl, 0Ch		; color
		mov	dl, 0Bh		; col
		mov	dh, al		; row=loopresults
		mov	di, offset topofbox	;2024h
		call    printline
		
		mov	bl, 0Ch	    	; color (red)
		mov	dl, 0Bh		; col
		mov	dh, al		; row
		add	dh, 2		 
		mov	di, offset bottomofbox		;2037h
                call    printline
		
		mov	bl, 0Ch		; color
		mov	dl, 0Bh		; col
		mov	dh, al		; row
		inc	dh
		mov	di, offset sideofbox		;204Ah
                call    printline
		
		mov	bl, 0Ch		; color
		mov	dl, 1Ch		; col
		mov	dh, al		; row
		inc	dh
		mov	di, offset sideofbox		;204Ah
                call    printline
		
		pop	ax
		mov	byte ptr ds:[skilllevel],ah	; save startinglevel
		
		mov	bl, 9		; color
		mov	dh, 15h		; row
		mov	dl, 4		; col
		mov	di, offset playersmsg		;2003h
                call    printline


loc_245:

		; temp keyboard patch

		xor	ax, ax
		int	16h
		cmp	ah, 2
		jl 	loc_245

		cmp	ah, 5
		jg	loc_245


;                cmp     byte ptr [keypress],0
;		jne	loc_245			; Jump if not equal
;loc_246:
;                cmp     byte ptr [keypress],2
;		jl	loc_246			; Jump if <
;                cmp     byte ptr [keypress],5
;		jg	loc_246			; Jump if >
;loc_247:
;                mov     ah,[keypress]
;		cmp	ah,0
;		je	loc_247			; Jump if equal
;loc_248:


;		cmp     byte ptr [keypress],0
;		jne	loc_248			; Jump if not equal
;		cmp	ah,2
;		jl	loc_247			; Jump if <
;		cmp	ah,5
;		jg	loc_247			; Jump if >


		add	ah,2Fh			; '/'

                mov     byte ptr ds:[totalplayers],ah
		cmp	byte ptr ds:[skilllevel],1
		je	Setbeginner		; 
		cmp	byte ptr ds:[skilllevel],2
		je	Setintermediate
		cmp	byte ptr ds:[skilllevel],3
		je	Setadvanced		; 
		mov	byte ptr ds:[currentlevel],0
		jmp	exitoptions
		
Setadvanced:
		mov	byte ptr ds:[currentlevel],12h
		jmp	exitoptions
		
Setintermediate:
		mov	byte ptr ds:[currentlevel],8
		jmp	exitoptions
		
Setbeginner:
		mov	byte ptr ds:[currentlevel],1 ;jl test only should be 1
exitoptions:
		mov	byte ptr ds:[someflag],1
		pop	di
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		retn
inputPlayerOptions	endp

gameoptmsg	db	'JUMPMAN GAME OPTIONS',-1
stars		db	'*********',-1
beginmsg	db	'1. BEGINNER.....',-1
intrmsg		db	'2. INTERMEDIATE.',-1
advmsg		db	'3. ADVANCED.....',-1
grandmsg	db	'4. GRAND LOOP...',-1
randmsg		db	'5. RANDOMIZER...',-1
selectmsg	db	'PRESS 1 - 5 TO SELECT GAME OPTION.',-1
playersmsg 	db	'SELECT NUMBER OF PLAYERS (1 - 4)',-1
topofbox       	db	'ͻ',-1 
bottomofbox	db	'ͼ',-1 
sideofbox	db	'',-1
blanks		db	'                  ',-1
	       
;
;                              SUBROUTINE
;

setpcjrvid      proc    near
		push	ax
		mov	ah, 0			; set mode 8
		mov	al, 8			; PCjr 160x200x16 colors
		int	10h			; 
						; 
		pop	ax
		retn
setpcjrvid      endp


;
;                              SUBROUTINE
;

hidecursor      proc    near
		push	ax
		push	cx
@@:
		mov	dx, 3DAh
		in	al, dx			; port 3DAh, CGA/EGA vid status
		test	al, BIT3		; look for verticle retrace
		jz	@b			; try again if so.

		mov	ah, 0			; set video to 320x200 graphics
		mov	al, 1			;
		int	10h			
		
		mov	ah, 1
		mov	ch, 20h			; set cursor size/shape
		mov	cl, 0			; (hide cursor)
		int	10h			 
						
		pop	cx
		pop	ax
		retn
hidecursor      endp






loc_254:
		cmp	byte ptr ds:[v22D4],0
		je	loc_255			; Jump if equal
		dec	byte ptr ds:[v22D4]
		cmp	byte ptr ds:[v22D4],0Ch
		je	loc_255			; Jump if equal
		retn
loc_255:
		push	ax
		push	bx
		push	cx
		push	dx
		push	di
		mov	bx,offset endflag + 0dh	;data_407e
		mov	cl,[bx]
		xor	ch,ch			; Zero register
		mov	bx,offset endflag + 01fh	;data_411e
		mov	bx,[bx]

locloop_256:
		cmp	word ptr [bx+6],0
		jne	loc_263			; Jump if not equal
		jmp	loc_269
loc_257:
		add	bx,20h
		loop	locloop_256		; Loop if cx > 0

		jmp	loc_285
loc_258:
		push	bx
		push	cx
                test    word ptr ds:[pcjr?], -1
		jnz	loc_260			; Jump if not zero
		mov	cx,1000h
		mov	bx,0FAh
		call	playtone3	;sub_59

                loop    $ 	                ; Loop if cx > 0

		call	playtone4	;sub_60
                jmp     loc_262     
loc_260:
		mov	cx,1100h
		mov	byte ptr ds:[v1DD0],1
		call	playtone1 	; sub_17


		loop	$ 

		call	playtone2 ;sub_18
loc_262:
		pop	cx
		pop	bx
                jmp     loc_267      
                
loc_263:
		cmp	byte ptr [bx+10h],6
		je	loc_267			; Jump if equal
		cmp	byte ptr [bx+11h],3
		je	loc_267			; Jump if equal
		mov	di, offset endflag + 06 ;data_403e
		mov	di,[di]
		mov	ax,[di+2]
                add     ax,8
		cmp	[bx+2],ax
		jne	loc_265			; Jump if not equal
		mov	ax,[di+4]
		add	ax,4
		cmp	[bx+4],ax
		jl	loc_264			; Jump if <
		mov	word ptr [bx+6],0FF00h
		mov	word ptr [bx+10h],300h
                jmp     loc_258      
loc_264:
		mov	word ptr [bx+6],100h
		mov	word ptr [bx+10h],300h
                jmp     loc_258      
loc_265:
		mov	ax,[di+4]
		add	ax,3
		cmp	[bx+4],ax
		jne	loc_267			; Jump if not equal
		mov	ax,[di+2]
		add	ax,4
		cmp	[bx+2],ax
		jl	loc_266			; Jump if <
		mov	word ptr [bx+6],0FFh
		mov	word ptr [bx+10h],6
		jmp	loc_258
loc_266:
		mov	word ptr [bx+6],1
		mov	word ptr [bx+10h],6
		jmp	loc_258
loc_267:
		mov	ax,[bx+2]
		cmp	[bx+12h],ax
		je	loc_268			; Jump if equal
		cmp	[bx+16h],ax
		je	loc_268			; Jump if equal
		mov	ax,[bx+4]
		cmp	[bx+14h],ax
		je	loc_268			; Jump if equal
		cmp	[bx+18h],ax
		je	loc_268			; Jump if equal
		call	sub_51
		inc	word ptr [bx+1Ch]
		jmp	loc_257
loc_268:
		mov	word ptr [bx+6],0
		mov	dx,[bx+4]
		push	bx
		mov	bx,[bx+2]
                call    checkeol
		pop	bx
                mov     word ptr ds:[dispstats1],bp
                mov     word ptr ds:[dispstats2],bp
                mov     word ptr ds:[dispstats0],2
                mov     word ptr ds:[gfxcount],1
                call    put2screen
		jmp	loc_257
loc_269:
                call    gettimestamp
		and	dh,3
		cmp	dh,2
		jg	loc_269			; Jump if >
		cmp	dh,0
		je	loc_275			; Jump if equal
		cmp	dh,1
		je	loc_270			; Jump if equal
		jmp	loc_280
loc_270:
		mov	word ptr [bx+4],1
		mov	word ptr [bx+1Eh],2
loc_271:
                call    gettimestamp
		and	dx,1FFh
		cmp	dx,13Fh
		jg	loc_271			; Jump if >
		and	dx,0FFFEh
		mov	[bx+2],dx
		inc	dx
		mov	[bx+1Ch],dx
loc_272:
                call    gettimestamp
		and	dh,3
		cmp	dh,2
		jg	loc_272			; Jump if >
		cmp	dh,0
		je	loc_273			; Jump if equal
		cmp	dh,1
		je	loc_274			; Jump if equal
		mov	word ptr [bx+6],1
		mov	word ptr [bx+10h],2
		jmp	loc_267
loc_273:
		mov	word ptr [bx+6],0FFh
		mov	word ptr [bx+10h],2
		jmp	loc_267
loc_274:
		mov	word ptr [bx+6],100h
		mov	word ptr [bx+10h],100h
		jmp	loc_267
loc_275:
		mov	word ptr [bx+2],2
		mov	word ptr [bx+1Ch],3
loc_276:
                call    gettimestamp
		and	dx,0FFh
		cmp	dx,0AEh
		jg	loc_276			; Jump if >
		mov	[bx+4],dx
		inc	dx
		mov	[bx+1Eh],dx
loc_277:
                call    gettimestamp
		and	dh,3
		cmp	dh,2
		jg	loc_277			; Jump if >
		cmp	dh,0
		je	loc_278			; Jump if equal
		cmp	dh,1
		je	loc_279			; Jump if equal
		mov	word ptr [bx+6],100h
		mov	word ptr [bx+10h],100h
		jmp	loc_267
loc_278:
		mov	word ptr [bx+6],0FF00h
		mov	word ptr [bx+10h],100h
		jmp	loc_267
loc_279:
		mov	word ptr [bx+6],1
		mov	word ptr [bx+10h],2
		jmp	loc_267
loc_280:
		mov	word ptr [bx+2],13Ch
		mov	word ptr [bx+1Ch],13Dh
loc_281:
                call    gettimestamp
		and	dx,0FFh
		cmp	dx,0AEh
		jg	loc_281			; Jump if >
		mov	[bx+4],dx
		inc	dx
		mov	[bx+1Eh],dx
loc_282:
                call    gettimestamp
		and	dh,3
		cmp	dh,2
		jg	loc_282			; Jump if >
		cmp	dh,0
		je	loc_283			; Jump if equal
		cmp	dh,1
		je	loc_284			; Jump if equal
		mov	word ptr [bx+6],100h
		mov	word ptr [bx+10h],100h
		jmp	loc_267
loc_283:
		mov	word ptr [bx+6],0FF00h
		mov	word ptr [bx+10h],100h
		jmp	loc_267
loc_284:
		mov	word ptr [bx+6],0FFh
		mov	word ptr [bx+10h],2
		jmp	loc_267
loc_285:
		pop	di
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		retn

v22d4		db	0	;@22d4

;
;                              SUBROUTINE
;

printplayernumber	proc	near
		push	ax
		push	bx
		push	cx
		push	dx
		push	di
                mov     word ptr ds:[screenchar],0
                call    clearscreen
                call    hidecursor
		
		mov	cl, byte ptr ds:[playernum]  ; ascii player number
		xor	ch, ch			; 
		sub	cx, 30h			; make decimal
		mov	di, offset playermsg	; point to player msg
		sub	di, 0Ah			; prepare for loop

playermsgloop:
		add	di, 0Ah
		loop	playermsgloop		; point DI to current player#

		mov	bl, 0Fh		; color
		mov	dh, 0Bh		; row
		mov	dl, 0Fh		; col
                call    printline
		


		; wait for a keypress, timeout if none and return
		; what keypresses?  



		mov	cx,1
                test    word ptr ds:[pcjr?], -1
		jnz	locloop_287		; Jump if not zero
						; wait less if in game?
		mov	cx,3			; main counter loop val

locloop_287:
		push	cx
		mov	cx,0

locloop_288:
                mov     ah,[keypress]
		cmp	ah,2
		jb	loc_289			; Jump if below
		cmp	ah,9
		ja	loc_289			; Jump if above
		dec	ah
                mov     byte ptr ds:[v5e1],ah
loc_289:
		loop	locloop_288		; Loop if cx > 0

		pop	cx
		loop	locloop_287		; Loop if cx > 0

		pop	di
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		retn
printplayernumber	endp

			                        
playermsg	db	'PLAYER  1',-1
		db	'PLAYER  2',-1
		db	'PLAYER  3',-1
		db	'PLAYER  4',-1
	
;
; print2monoscreen SUBROUTINE only called when there is no CGA.
; point SI to text to be displayed (FF terminated)
;

print2monoscreen	proc	near
		mov	dl,byte ptr ds:[23A7h]
		dec	dl
		mov	bh,0
		push	si
loc_290:
		inc	dl
		cmp	dl,28h			; '('
		je	loc_291			; Jump if equal
                jmp     loc_292     
loc_291:
		mov	dl,byte ptr ds:[23A7h]
		dec	dl
		add	dh,byte ptr ds:[23A6h]
                jmp     loc_290      
loc_292:
		mov	ah,2
		int	10h			; Video display   ah=functn 02h
						;  set cursor location in dx
		mov	cx,1
		mov	ax,word ptr ds:[23A8h]
		cmp	dh,al
		jl	loc_293			; Jump if <
		mov	bl,byte ptr ds:[23A5h]
                jmp     loc_294       
loc_293:
		mov	bl,byte ptr ds:[23A4h]  ; start of 12 bytes below
loc_294:
		pop	si
		mov	al,[si]
		cmp	al,0FFh
		je	loc_ret_295		; Jump if equal
		inc	si
		push	si
		mov	ah,0Ah
		int	10h			; Video display   ah=functn 0Ah
						;  set char al at present curs
						;   cx=# of chars to replicate
                jmp     loc_290    

loc_ret_295:
		retn
print2monoscreen	endp

                db      12 dup (0)              ; 23ax 
		db	3

;
; Welcome Screen SUBROUTINE  Display logos and wait for keypresses
;

welcomeScreen	proc	near
		push	ax
		push	bx
		push	cx
		push	dx
		push	di
		push	word ptr ds:[VIDSEG]
		push	es
		mov	ax, 0B800h
		mov	es, ax
		mov	byte ptr es:[50],14h 	; test for color video
		cmp	byte ptr es:[50],14h
		je	gotCGA			; Jump if equal
		
		mov	ax, BDASEG
		mov	es, ax
		mov	ax, es:[HWLIST]		; data_6e
		or	ax, 30h
		mov	es:[HWLIST], ax		; data_6e,ax
		xor	ax,ax			; Zero register
		int	10h			; Video display   ah=functn 00h
		
		
						;  set display mode in al

		; this prolly displays the message below and hangs.
		mov	byte ptr ds:[23A6h],2	; column
		mov	word ptr ds:[23A8h],14h	; row
		mov	byte ptr ds:[23A4h],3	; color?
		mov	si, offset notCGAmsg
		mov	dl, 0
		call	print2monoscreen

                jmp     $
notCGAmsg	db	' You must have a color card installed'
		db	'      in order to execute this program.    ',-1
gotCGA:
		pop	es
		mov	word ptr ds:[VIDSEG],0B800h
                mov     word ptr ds:[screenchar],0
                call    clearscreen
                call    hidecursor
                test    word ptr ds:[pcjr?], -1
		jnz	loc_299			; Jump if not zero
		
		mov	bl, 0Fh	  		; color
		mov	dh, 5			; row
		mov	dl, 9			; col
		lea	di, offset monitormsg	; 26CEh
                call    printline
		
		mov	bl, 0Fh			; color
		mov	dh, 7			; row
		mov	dl, 0Dh			; col
		lea	di, offset rgbmsg	; 26E5h
                call    printline
		
		mov	bl, 0Fh			; color
		mov	dh, 8			; row
		mov	dl, 0Dh			; col
		lea	di, offset compmsg	; 26EDh
                call    printline
		
		mov	bl, 0Fh			; color
		mov	dh, 9			; row
		mov	dl, 0Dh			; col
		lea	di, offset tvmsg	;26FBh
                call    printline
loc_298:
              ;  mov     al,[keypress]
	      ;	cmp	al,0
	      ;	je	loc_298			; Jump if equal
		
	      ;temporary keyboard patch
	      	
	      	xor	ax, ax
		int 	16h
	      	xchg	al, ah
	      
	      
	      	cmp	al,13h			; 'R'
		je	loc_300			; Jump if equal
		cmp	al,14h			; 'T'
		je	loc_299			; Jump if equal
		cmp	al,2Eh			; 'C'
		jne	loc_298			; Jump if not equal
loc_299:
		mov	byte ptr ds:[mon_type],0  ; [5d5] TV/composite
                jmp     loc_301      
                
loc_300:
		
		mov	byte ptr ds:[mon_type],1	; [5d5]	 ;RGB
	  	call	convertlogos	  
loc_301:
                mov     word ptr ds:[screenchar],0
		call	clearscreen  		;sub_41
		mov	bl, 0Fh	  		; color
		mov	dh, 5	  		; row
		mov	dl, 2	  		; col
                lea     di, joymsg              ;270Ah
                call    printline
loc_302:
             ;   mov     ah,[keypress]
             ;   cmp     ah,0
             ;   je      loc_302                 ; Jump if equal

	      ;temporary keyboard patch
	      	
	      	xor	ax, ax
		int 	16h
	      
	      


        	cmp	ah,15h			; yes
		je	loc_303			; Jump if equal
		cmp	ah,31h			; no
		je	nojoystick 
                jmp     loc_302         
loc_303:
		call	initjoystick	;sub_29	 ; test joystick?
		cmp	bx,0
		je	loc_305			; Jump if equal
		mov	bl, 0Fh	    		; color
		mov	dl, 1			; row
		mov	dh, 0Ah			; col
		mov	di, offset joytestmsg  
                call    printline
loc_304:
		cmp	byte ptr data_295,0
		je	loc_304			; Jump if equal
                jmp     loc_301       
loc_305:
		mov	bl, 0Fh
		mov	dh, 8
		mov	dl, 3
		mov	di, 272Fh
                call    printline
		
		mov	bl, 0Fh
		mov	dh, 9
		mov	dl, 4
		mov	di, 2752h
                call    printline
loc_306:
                cmp     byte ptr [keypress],1Ch
		jne	loc_306			; Jump if not equal
		call	sub_7
		mov	byte ptr ds:[usejoystick],1
		nop
                jmp     loc_308         
                
nojoystick:
                mov     word ptr ds:[beatsme2], 5
                mov     word ptr ds:[beatsme1], 0Fh
                mov     word ptr ds:[beatsme4], 5
                mov     word ptr ds:[beatsme3], 0Fh
loc_308:
                mov     word ptr ds:[screenchar],0
                call    clearscreen
		call	setmode
                
                mov     word ptr ds:[xpos], 46h  		;xpos
                mov     word ptr ds:[ypos], 0Ah  		;ypos
                mov     word ptr ds:[gfxoffset], offset epyxlogo   ;878Eh  
                mov     word ptr ds:[dunno0b],0
                
                call    putagfxlogo   ; draw EPYX logo to screen
		

	    	
		mov	byte ptr ds:[aflag],0FFh
                mov     word ptr ds:[xpos],90h
                mov     word ptr ds:[ypos],4Bh
                mov     di, offset andmsg       ;<---point DI to "and"
                call    printtext_gfx   
                
		
                mov     word ptr ds:[xpos],46h
                mov     word ptr ds:[ypos],64h
                mov     word ptr ds:[gfxoffset],offset IBMlogo ;7F3Ch
                call    putagfxlogo   ;<---draw IBM logo to screen
                
		mov     di, offset present  ;<-point to "present"
                mov     word ptr ds:[xpos],80h
                mov     word ptr ds:[ypos],0AAh
                call    printtext_gfx
		
	



		 ;temporary keyboard patch
                xor ax,ax
                int 16h



		
	      	mov	cx,6
                cmp     word ptr ds:[pcjr?],0
	      	je	locloop_309		; Jump if equal
	      	mov	cx,3


             ; should timeout after x seconds or keypress




locloop_309:
              ;  push    cx
              ;  mov     cx,0



;locloop_310:

                ; wait for keypress
              ;  cmp     byte ptr [keypress],0
              ;  jne     loc_311                 ; Jump if not equal
              ;  loop    locloop_310             ; Loop if cx > 0

              ;  pop     cx
              ;  loop    locloop_309             ; Loop if cx > 0

              ;  jmp     loc_312         
loc_311:
              ;  pop     cx
loc_312:   
		mov     word ptr ds:[screenchar],0
                call    clearscreen
           
		mov     word ptr ds:[xpos],14h
                mov     word ptr ds:[ypos],14h
                mov     word ptr ds:[gfxoffset],offset ibmcgaoffset4 ;7564h
                call    putagfxlogo  ;<---print jumpman logo to screen
           
	   	mov     di, offset IBMver ;<point to "IBM VERSION BY"
                mov     word ptr ds:[xpos],60h
                mov     word ptr ds:[ypos],9Ah
                call    printtext_gfx
                
		mov     di, offset Mirror ;<- point to "mirror images software"
                mov     word ptr ds:[xpos],30h
                mov     word ptr ds:[ypos],0A2h
                call    printtext_gfx
                
		mov     di,offset IBMcopyright      ;<-point to "(C)opywrite IBM"
                mov     word ptr ds:[xpos],30h
                mov     word ptr ds:[ypos],0AAh
                call    printtext_gfx
                
	   	mov     di,offset Epyxcopyright     ;<-point to "copywrite EPYX"
                mov     word ptr ds:[xpos],28h
                mov     word ptr ds:[ypos],0B2h
                call    printtext_gfx
            
		mov     di,offset jumpmanTM         ;<-"jumpman is a trademark"
                mov     word ptr ds:[xpos],38h
                mov     word ptr ds:[ypos],0BAh
                call    printtext_gfx
            
		mov     di,offset epyxinc            ; <-"Epyx INC"
                mov     word ptr ds:[xpos],70h
                mov     word ptr ds:[ypos],0C2h
                call    printtext_gfx
            
	    	call    playtone4	                  



                ;?wtf?

       ;         cli				; Disable interrupts
       ;         mov     word ptr ds:[sto7],6CC8h
       ;         mov     word ptr ds:[stob],6D2Eh
       ;         mov     ax,word ptr ds:[6D2Ch]
       ;         mov     word ptr ds:[stoa],ax
       ;         mov     sto1,0FFFEh
       ;         or      byte ptr [v6630],1
       ;         mov     word ptr ds:[v6617],6D92h
       ;         mov     data_278,6DE8h
       ;         mov     ax,data_330
       ;         mov     data_279,ax
       ;         mov     sto2,0FFFEh
       ;         or      byte ptr [v6630],2
       ;         mov     data_280,6E3Ch
       ;         mov     data_281,6E78h
       ;         mov     ax,data_331
       ;         mov     data_282,ax
       ;         mov     sto3,0FFFEh
       ;         or      byte ptr [v6630],4
       ;         mov     byte ptr ds:[sto8],1
       ;         sti                             ; Enable interrupts
                ;?wtf? end

;loc_313:
                ; wait forr a key or timeout

                ; temporary keyboard patch

		xor ax,ax
		int 16h







             ;   cmp     byte ptr [keypress],0
             ;   jne     loc_314                 ; Jump if not equal
             ;   cmp     byte ptr [v6630],0
             ;   jne     loc_313                 ; Jump if not equal
loc_314:
                pop     word ptr ds:[startseg]
		pop	di
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		retn
welcomeScreen	endp


monitormsg      db      'MONITOR TYPE?  (R/C/T)',-1
rgbmsg     	db	'R - RGB',-1 
compmsg         db      'C - COMPOSITE',-1
tvmsg		db	'T - TELEVISION',-1
joymsg          db      'DO YOU WISH TO USE A JOYSTICK? (Y/N)',-1
joytestmsg	db	'MAKE SURE THE JOYSTICK IS ATTACHED',-1
		db	'AND CENTERED, THEN PRESS ENTER.',-1
		db	'JOYSTICK IS NOT ATTACHED. PRESS ENTER.',-1
usejoystick     db       00h	;@2799
andmsg          db      'AND',-1
present         db       'PRESENT',-1 
Mirror          db      'MIRROR IMAGES SOFTWARE, INC.',-1
IBMver          db      'IBM VERSION BY',-1
EpyxCopyright   db      '(C) COPYRIGHT EPYX, INC. 1983',-1
IBMCopyright    db      '(C) COPYRIGHT IBM CORP. 1984',-1
jumpmanTM       db      'JUMPMAN IS A TRADEMARK OF',-1
epyxinc         db      'EPYX, INC.',-1

starsmsg        db      '**************************',-1  ;@2382
congratsmsg     db      'CONGRATULATIONS!',-1            ;@284d
completedmsg    db      'YOU HAVE COMPLETED THE',-1      ;@285e
beginnermsg     db      '         BEGINNER',-1           ;@2875
intermediatemsg db      '       INTERMEDIATE',-1         ;@2887
advancedmsg     db      '         ADVANCED',-1           ;@289b
grandloopmsg    db      '        GRAND LOOP',-1          ;@28ad
levelmsg        db      'JUMPMAN LEVEL.',-1              ;@28c0


;
;  sub_25                            SUBROUTINE
;

highscore?	proc	near
		push	ax
		push	bx
		push	cx
		push	dx
		push	di
		test	byte ptr ds:[highscoreflag],1
                jnz     loc_315                 ; Jump if not zero
		jmp	loc_322
loc_315:
		mov	byte ptr ds:[highscoreflag],0
                call    hidecursor
                mov     word ptr ds:[screenchar],0
                call    clearscreen

                mov     bl, 4           ; color
                mov     dl, 7           ; col
                mov     dh, 6           ; row
                mov     di, offset starsmsg             ;2832h
                call    printline

                mov     dl, 0Ch         ; col
                mov     dh, 8           ; row
                mov     bl, 0Eh         ; color
                mov     di, offset congratsmsg   	;284Dh
                call    printline

                mov     dl, 9           ; col
                mov     dh, 0Ah         ; row
                mov     bl, 0Fh         ; color
                mov     di, offset completedmsg         ;285Eh
                call    printline

                cmp	byte ptr ds:[skilllevel],1
                je      printbeginnermsg        ; Jump if equal

                cmp	byte ptr ds:[skilllevel],2
                je      printintermediatemsg    ; Jump if equal

		cmp	byte ptr ds:[skilllevel],3
                je      printadvancedmsg        ; Jump if equal

                mov     di, offset grandloopmsg         ;28ADh
                jmp     printit

printbeginnermsg:
                mov     di, offset beginnermsg          ;2875h
                jmp     printit    

printintermediatemsg:
                mov     di, offset intermediatemsg      ;2887h
                jmp     printit    

printadvancedmsg:
                mov     di, offset advancedmsg          ;289Bh

printit:
                mov     dl, 7         ; col
                mov     dh, 0Ch       ; row
                mov     bl, 9         ; color
                call    printline

                mov     dl, 0Dh       ; col
                mov     dh, 0Eh       ; row
                mov     bl, 0Fh       ; color
                mov     di, offset levelmsg             ;28C0h
                call    printline

                mov     dl, 7         ; col
                mov     dh, 10h       ; row
                mov     bl, 4         ; color
                mov     di, offset starsmsg             ;2832h
                call    printline

                mov     cx, 18h                         ; loop 18h times
                cmp     word ptr ds:[pcjr?],0           ; unless pcjr
                je      locloop_320                     ; 
                shr     cx,1                            ; then only loop 9h

locloop_320:
		push	cx
		mov	cx,0

                loop    $       

		pop	cx
		loop	locloop_320		; Loop if cx > 0


; no congrats msg!  you suck!
loc_322:
                mov     dx, 15h
		mov	di, HSTABLE
                add     di, data_27e          ;***********
loc_323:
		mov	si, offset v5E2	
                mov     bp, 0	;data_11e          ;**************
		mov	cx,5

locloop_324:
		mov	ah,cs:[bp+di+3]
		cmp	ah,cs:[bp+si]
		jl	loc_325			; Jump if <
		jg	loc_326			; Jump if >
		inc	bp
		loop	locloop_324		; Loop if cx > 0

                jmp     loc_326     
loc_325:
		dec	dx
		mov	cx,9
		mov	si,di
		add	di,9
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		sub	di,1Bh
		cmp	dx,1
		jne	loc_323			; Jump if not equal
loc_326:
		add	di,9
		cmp	dx,15h
		jne	loc_327			; Jump if not equal
		jmp	loc_332
loc_327:
		mov	word ptr [di],2020h
		mov	byte ptr [di+2],20h	; ' '
		mov	si, offset v5E2
		add	di,3
		mov	cx,5
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		mov	byte ptr [di],20h	; ' '
		mov	bl,byte ptr ds:[skilllevel]
		xor	bh,bh			; Zero register
                mov     al,byte ptr ds:[v2AF8][bx]
		mov	[di],al
		inc	di
                mov     data_161,15h            ;*****************
		sub	data_161,dx
		or	byte ptr ds:[highscoreflag],80h
		call	displaytopscores
		push	bx
		push	dx
		push	di

                mov     bl, 0Eh        ; color
                mov     dh, 18h        ; row
                mov     dl, 3          ; col
                mov     di, offset initialsmsg   ;2A67h
                call    printline

		pop	di
		pop	dx
		pop	bx
		add	dx,2
		sub	di,9
		mov	dh,dl
		mov	dl,0Fh
loc_328:
                call    getkeypress
                mov     ah,[keypress]
		cmp	ah,0
		je	loc_328			; Jump if equal
loc_329:
            ;    cmp     byte ptr [keypress],0
	    ;	jne	loc_329			; Jump if not equal
		
		cmp	ah,1Ch	   ; enter
		je	loc_331			; Jump if equal
		cmp	ah,0Eh	   ;backspace?
		jne	loc_330			; Jump if not equal
		cmp	dl,0Fh
		je	loc_328			; Jump if equal
		dec	dl
		dec	di
		jmp	short loc_328
loc_330:
		mov	bl,ah
		xor	bh,bh			; Zero register
                mov     al,byte ptr ds:[v2A8C+bx]
		cmp	al,0
		je	loc_328			; Jump if equal
                mov     byte ptr ds:[v2A8A],al
		mov	[di],al
		mov	bl,0Ch
		push	di
                mov     di, offset v2A8A
                call    printline
		
		
		pop	di
		inc	di
		cmp	dl,12h
		jl	loc_328			; Jump if <
		dec	dl
		dec	di
		jmp	short loc_328
loc_331:

						; write new high score table
		mov	ah,3
		mov	al,1
		mov	dl,0
		mov	dh,0
		mov	cl,3
		mov	ch,0
		mov	bx, HSTABLE
        ;;        int     13h                     ; Disk  dl=drive a  ah=func 03h
						;  write sectors from mem es:bx
						;   al=#,ch=cyl,cl=sectr,dh=head
loc_332:
		pop	di
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		retn
highscore?	endp




initialsmsg     db      'TYPE YOUR INITIALS AND PRESS ENTER',-1
v2a8a           db      ' '      ;2a8a
                db      -1       ;2a8b
v2a8c           db      0        ;2a8c?
                db      0
		db	'1234567890-='
		db	0, 0
		db	'QWERTYUIOP[]'
		db	0, 0
		db	'ASDFGHJKL;'
		db	 00h, 00h, 00h, 5Ch, 5Ah
data_161	dw	4358h
		db	 56h, 42h, 4Eh, 4Dh, 2Ch, 2Eh
		db	 2Fh, 00h, 00h, 00h
		db	20h
                db      50 dup (0) ;2ac6-2af7
v2af8           db       20h    ; 2af8
                db       42h, 49h, 41h, 47h, 52h
highscoreflag	db	 00h	; 2afeh

;
; sub_26                             SUBROUTINE
;

displaytopscores	proc	near
		push	ax
		push	bx
		push	cx
		push	dx
		push	di
                mov     word ptr ds:[screenchar],0
                call    clearscreen
                call    hidecursor
		
		mov	bl, 0Eh		; color
		mov	dh, 1		; row
		mov	dl, 0Fh		; col
		mov	di, offset topscoresmsg	;2BBBh
                call    printline

		mov	byte ptr ds:[2C23h],3
		nop
		mov	si, HSTABLE
		mov	ax,2BC6h
		mov	cx,14h
loc_333:
		push	cx
		mov	bl,9
		mov	dh,byte ptr ds:[2C23h]
		mov	dl,0Bh
		mov	di,ax
                call    printline
		
		add	ax,4
		
		mov	di,2C16h
		mov	cx,3
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		mov	bl,0Fh
		mov	dh,byte ptr ds:[2C23h]
		mov	dl,0Fh
		mov	di,2C16h
                call    printline
		mov	di,2C1Bh
		mov	cx,5
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		mov	byte ptr ds:[2C1Ah],20h	; ' '
		nop
		cmp	byte ptr ds:[2C1Bh],3Ah	; ':'
		jl	loc_335			; Jump if <
loc_334:
		sub	byte ptr ds:[2C1Bh],0Ah
		inc	byte ptr ds:[2C1Ah]
		cmp	byte ptr ds:[2C1Bh],39h	; '9'
		jg	loc_334			; Jump if >
		add	byte ptr ds:[2C1Ah],10h
loc_335:
		mov	bl,0Fh
		pop	cx
		push	cx
		cmp	cx,data_161
		jne	loc_336			; Jump if not equal
		mov	bl,0Ch
loc_336:
		mov	dh,byte ptr ds:[2C23h]
		mov	dl,14h
		mov	di,2C1Ah
                call    printline
		mov	di,2C21h
		mov	cl,[si]
		mov	[di],cl
		inc	si
		mov	dh,byte ptr ds:[2C23h]
		mov	dl,1Bh
		mov	di,2C21h
                call    printline
		inc	byte ptr ds:[2C23h]
		pop	cx
		dec	cx
		jz	loc_337			; Jump if zero
		jmp	loc_333
loc_337:
		pop	di
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		retn
displaytopscores	endp



		db	0, 0
topscoresmsg	db	'TOP SCORES',-1	     ;@2bbb
		db	' 1.',-1
		db	' 2.',-1
		db	' 3.',-1
                db      ' 4.',-1
                db      ' 5.',-1
                db      ' 6.',-1
                db      ' 7.',-1
                db      ' 8.',-1
                db      ' 9.',-1
                db      '10.',-1
                db      '11.',-1
                db      '12.',-1
                db      '13.',-1
                db      '14.',-1
                db      '15.',-1
                db      '16.',-1
                db      '17.',-1
                db      '18.',-1
                db      '19.',-1
                db      '20.',-1
                db      '   ',-1
		db	'      ',-1
		db	' ',-1,0,' '
		db	'      0        0        0       '
		db	' 0        0        0        0   '
		db	'     0        0        0        '
		db	'0        0        0        0    '
		db	'    0        0        0        0'
		db	'        0        0 '
		db	158 dup (0)
		db	174 dup (0)			; Data table (indexed access)

;
;                              SUBROUTINE
;

setmode		proc	near
		push	ax
		push	bx
		push	cx
		push	dx
                test    word ptr ds:[pcjr?], -1   ; pcjr?
		jnz	pcjrvid			  ; Jump if yes
		
		mov	dx, 3D8h
		mov	al, 0
		out	dx, al			; port 3D8h, CGA video control
		cmp	byte ptr ds:[mon_type],0   ;[5d5] TV/composite
		je	@f			; Jump if equal

		mov	ax, 4			; set mode 4
		int	10h			; 320x200x4 CGA colors
		mov	dx, 3D8h
		mov	al, 0Ah
		out	dx, al			; port 3D8h, CGA video control
                jmp     exitsetmode   
                
@@:
		mov	ax, 6			; set mode 6
		int	10h			; 640x200x2 colors (b/w)
						; 
		mov	dx, 3D8h
		mov	al, 1Ah			; set 640x280 graphics mode bit
		out	dx, al			; port 3D8h, CGA video control
                jmp     exitsetmode   
                
pcjrvid:
                call    setpcjrvid		; set mode 8
		mov	cx, 16
		mov	bx, 10h			; data_13e

locloop_340:					; output series of data
		mov	ah, bl			; values to CGA register
		mov	al, byte ptr [pcjrtweak+bx]	;data_171[bx]
		mov	dx, 3DAh
		push	ax
@@:
		in	al, dx			; in CGA h-refresh? 
		test	al, BIT3		; wait if so
		jz	@b			; 
		
		pop	ax
		push	ax
		mov	al, ah
		out	dx, al			; port 3DAh, VGA feature contrl
		pop	ax
		out	dx, al			; port 3DAh, VGA feature contrl
		push	ax
		mov	al, 0Eh
		out	dx, al			; port 3DAh, VGA feature contrl
		in	al, dx			; port 3DAh, CGA/EGA vid status
		inc	bx
		pop	ax
		loop	locloop_340		; Loop if cx > 0

exitsetmode:
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		retn
setmode		endp

PCJrtweak:
		db	 00h, 02h, 01h, 03h, 05h, 04h
		db	 09h, 03h, 06h, 09h, 03h, 05h
		db	 0Ch, 0Eh, 0Eh, 0Fh

;
; sub_28                             SUBROUTINE
;
; converts IBM logo to CGA graphics from composite video I think.
; first step is to erase all attribute information from graphics data.

convertlogos	proc	near
		push	bx
		push	cx
		push	di
		mov	di, offset ibmcgaoffsettable ;2FB3h
loc_343:
		cmp	word ptr [di],0FFFFh
		jz	loc_345			; Jump if zero
		mov	cx, 28h
		mov	bx, [di]
		add	bx, 3

@@:
		mov	byte ptr [bx],0
		add	bx,2
		loop	@b		; Loop if cx > 0

		add	di,2
		jmp	loc_343

		


		; convert all atributes to 50h unless FF or 0F.

		
		
loc_345:
		mov	bx, offset ibmcgaoffset2	;data_350
		add	bx, 3
		mov	cx, 0Ch

@@:	;locloop_346:
		test	byte ptr [bx],0FFh
		jz	loc_349			; Jump if zero
		test	byte ptr [bx],0Fh
		jz	loc_347			; Jump if zero
		mov	al, 55h			; 'U'
                jmp     loc_348   
                
loc_347:
		mov	al,50h			; 'P'
loc_348:
		mov	[bx],al
loc_349:
		add	bx,2
		loop	@b	;locloop_346		; Loop if cx > 0




	        ; convert all non FF's to AA's


		mov	bx, offset ibmcgaoffset3 ;data_348
		add	bx, 3
		mov	cx, 20h

@@: ;locloop_350:
		test	byte ptr [bx], 0FFh
		jz	loc_351			; Jump if zero
		mov	byte ptr [bx], 0AAh
loc_351:
		add	bx, 2
		loop	@b	;locloop_350		; Loop if cx > 0


		; convert all non F0's to F0.


		mov	bx,offset ibmcgaoffset1	;data_352
		add	bx,2
		mov	cx,0Ch

@@: ;locloop_352:
		test	byte ptr [bx],0F0h
		jz	loc_353			; Jump if zero
		mov	byte ptr [bx],0F0h
                jmp     loc_354  
                
loc_353:
		mov	byte ptr [bx],0Fh
loc_354:
		inc	bx
		loop	@b ;locloop_352		; Loop if cx > 0







		; convert just about everything to 55's by oring 5.

		mov	bx,offset ibmlogo	; 
		add	bx,4
		mov	cx,848h

@@: ;locloop_355:
		test	byte ptr [bx],0F0h
		jz	loc_356			; Jump if zero
		and	byte ptr [bx],0Fh
		or	byte ptr [bx],50h	; 'P'
loc_356:
		test	byte ptr [bx],0Fh
		jz	loc_357			; Jump if zero
		and	byte ptr [bx],0F0h
		or	byte ptr [bx],5
loc_357:
		inc	bx
		loop	@b	;locloop_355		; Loop if cx > 0






		mov	bx,offset ibmcgaoffset4	   ; i think this is IBMlogo
		add	bx,4
		mov	cx,9D4h

@@: ;locloop_358:
		mov	al,[bx]
		and	al,0Fh
		cmp	al,1
		jne	loc_359			; Jump if not equal
		or	byte ptr [bx],4
loc_359:
		mov	al,[bx]
		and	al,0F0h
		cmp	al,10h
		jne	loc_360			; Jump if not equal
		or	byte ptr [bx],40h	; '@'
loc_360:
		inc	bx
		loop	@b	;locloop_358		; Loop if cx > 0








		mov	bx,offset ibmcgaoffset5	;data_353
		add	bx,3
		mov	cx,8

@@: ;locloop_361:
		test	byte ptr [bx],0F0h
		jz	loc_362			; Jump if zero
		and	byte ptr [bx],0Fh
loc_362:
		test	byte ptr [bx],0Fh
loc_363:
		jz	loc_365			; Jump if zero
		and	byte ptr [bx],0F0h
loc_365:
		add	bx,2
loc_366:
		loop	@b ;locloop_361		; Loop if cx > 0





		mov	bx,offset ibmcgaoffset6	;data_355
		add	bx,3
		mov	cx,8

@@: ;locloop_368:
		test	byte ptr [bx],0F0h
		jz	loc_369			; Jump if zero
		and	byte ptr [bx],0A0h
loc_369:
		test	byte ptr [bx],0Fh
		jz	loc_370			; Jump if zero
		and	byte ptr [bx],0Ah
loc_370:
		add	bx,2
		loop	@b ;locloop_368		; Loop if cx > 0

		pop	di
		pop	cx
		pop	bx
		retn
convertlogos    endp


;
; sub_29                             SUBROUTINE
;

initjoystick	proc	near
		push	dx
		push	cx
		push	ax
		xor	ax,ax			; Zero register
		xor	bx,bx			; Zero register
		mov	cx,1000h
		mov	dx,201h
		out	dx,al			; port 201h, start game 1-shots
		cli				; Disable interrupts

locloop_371:
		in	al,dx			; port 201h, start game 1-shots
		test	al,3
		jz	loc_372			; Jump if zero
		loop	locloop_371		; Loop if cx > 0

		mov	bx,1
loc_372:
		cmp	cx,1000h
		jne	loc_373			; Jump if not equal
		mov	bx,1
loc_373:
		sti				; Enable interrupts
		pop	ax
		pop	cx
		pop	dx
		retn
initjoystick	endp




ibmcgaoffsettable:
		dw	offset ibmlogo1		;db      0C0h, 6Eh, 
		dw	offset ibmlogo2 	;12h, 6Fh
		dw	offset ibmlogo3 	;64h, 6f
		dw	offset ibmlogo4 	;0B6h, 6Fh
		dw	offset ibmlogo5 	;08h, 70h
		dw	offset ibmlogo6 	;5Ah, 70h
		dw	offset ibmlogo7 	;0ACh, 70h, 
		dw	offset ibmlogo8 	;0feh, 70h, 
		dw	offset ibmlogo9  	;50h, 71h, 
		dw	offset ibmlogo10 	;0a2h, 71h, 
		dw	offset ibmlogo11 	;0f4h, 71h, 
		dw	offset ibmlogo12 	;46h, 72h
		dw	offset ibmlogo13 	;98h, 72h
		dw	offset ibmlogo14 	;0EAh, 72h
		dw	offset ibmlogo15 	;3Ch, 73h
		dw	offset ibmlogo16 	;8Eh, 73h
		dw	offset ibmlogo17 	;0E0h, 73h
		dw	offset ibmlogo18 	;32h, 74h
		dw	offset ibmlogo19	;84h, 74h
		dw	-1 
                
		db 00h, 00h, 00h
                db 00h, 00h
loc_376:
		cmp	byte ptr ds:[3585h],0
		je	loc_377			; Jump if equal
		dec	byte ptr ds:[3585h]
loc_377:
		mov	bx, offset endflag + 06 ; data_403e
		mov	bx,[bx]
                mov     word ptr ds:[vce6],bx
		or	byte ptr ds:[v52C6],10h
                mov     ax,word ptr ds:[beatsme1]
		dec	ax
                mov     word ptr ds:[vcba],ax
                mov     ax,word ptr ds:[beatsme3]
		dec	ax
		mov	word ptr ds:[vCBC],ax
		cmp	byte ptr ds:[usejoystick],0
loc_378:
		je	loc_382			; Jump if equal
		call	readjoystick	;sub_44
		mov	ax,word ptr ds:[v52C2]
loc_380:
                mov     word ptr ds:[vcba],ax
		mov	ax,word ptr ds:[v52C4]
		mov	word ptr ds:[vCBC],ax
loc_382:
		test	byte ptr [keypress+key_space], -1	;data_299,0FFh
		jz	loc_383			; Jump if zero
		and	byte ptr ds:[v52C6],0EFh
loc_383:
		test	byte ptr [keypress+key_up], -1	;data_300,0FFh
		jz	loc_384			; Jump if zero
                mov     ax,word ptr ds:[beatsme4]
		dec	ax
		mov	word ptr ds:[vCBC],ax
		jmp	short loc_385
		db	90h
loc_384:
		test	byte ptr [keypress+key_down], -1	;data_303,0FFh
		jz	loc_385			; Jump if zero
                mov     ax,word ptr ds:[beatsme3]
		inc	ax
		mov	word ptr ds:[vCBC],ax
loc_385:
		test	byte ptr [keypress+key_left], -1	;data_301,0FFh
		jz	loc_386			; Jump if zero
                mov     ax,word ptr ds:[beatsme2]
		dec	ax
                mov     word ptr ds:[vcba],ax
		jmp	short loc_387
		db	90h
loc_386:
		test	byte ptr [keypress+key_right], 01	;data_302,0FFh
		jz	loc_387			; Jump if zero
                mov     ax,word ptr ds:[beatsme1]
		inc	ax
                mov     word ptr ds:[vcba],ax
loc_387:
		test	byte ptr ds:[v52C6],10h
		jnz	loc_388			; Jump if not zero
		cmp	byte ptr ds:[3585h],0
		je	loc_389			; Jump if equal
loc_388:
		jmp	loc_399
loc_389:
		mov	bx, offset v3586
		mov	di,offset endflag 	;data_401e
		cmp	byte ptr [di],32h	; '2'
		je	loc_390			; Jump if equal
		mov	cx,4
		jmp	short locloop_391
		db	90h
loc_390:
		mov	cx,1

locloop_391:
		cmp	word ptr [bx+8],0
		je	loc_392			; Jump if equal
		add	bx,20h
		loop	locloop_391		; Loop if cx > 0

		jmp	short loc_399
		db	90h
loc_392:
		mov	byte ptr ds:[3585h],3
		mov	word ptr [bx+6],0
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme1]
		jg	loc_393			; Jump if >
                cmp     ax,word ptr ds:[beatsme2]
		jl	loc_394			; Jump if <
		jmp	short loc_395
		db	90h
loc_393:
		mov	byte ptr [bx+6],1
		jmp	short loc_398
		db	90h
loc_394:
		mov	byte ptr [bx+6],0FFh
		jmp	short loc_398
		db	90h
loc_395:
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme3]
		jg	loc_396			; Jump if >
                cmp     ax,word ptr ds:[beatsme4]
		jl	loc_397			; Jump if <
		jmp	short loc_398
		db	90h
loc_396:
		mov	byte ptr [bx+7],1
		jmp	short loc_398
		db	90h
loc_397:
		mov	byte ptr [bx+7],0FFh
loc_398:
		cmp	word ptr [bx+6],0
		je	loc_399			; Jump if equal
                mov     di,word ptr ds:[vce6]
		mov	ax,[di+2]
;*		add	ax,6
		db	5, 6, 0			;  Fixup - byte match
		mov	[bx+2],ax
		mov	ax,[di+4]
;*		add	ax,4
		db	5, 4, 0			;  Fixup - byte match
		mov	[bx+4],ax
		mov	word ptr [bx+8],3616h
		mov	ax,bx
		call	sub_49_
loc_399:
		call	sub_3
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+6],0
                test    word ptr ds:[on_object],2
		jz	loc_400			; Jump if zero
		jmp	loc_434
loc_400:
                test    word ptr ds:[vcb4],1
		jnz	loc_401			; Jump if not zero
		jmp	loc_413
loc_401:
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme4]
		jle	loc_402			; Jump if < or =
		jmp	loc_412
loc_402:
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],0FFh
loc_403:
                test    word ptr ds:[on_object],80h
		jnz	loc_405			; Jump if not zero
                mov     bx, [somevar0]
loc_404:
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		cmp	byte ptr [di],1
		jne	loc_404			; Jump if not equal
		mov	ax,[di+2]
                mov     bx,word ptr ds:[vce6]
		mov	dx,[bx+4]
		push	bx
		mov	bx,[bx+2]
                call    checkeol
                mov     word ptr ds:[dispstats2],bp
                mov     word ptr ds:[dispstats1],bp
                mov     word ptr ds:[dispstats0],0Ah
                mov     word ptr ds:[gfxcount],8
                call    put2screen
		pop	bx
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],0Fh
		mov	bx, offset endflag + 8	;data_404e
		mov	bx,[bx]
;*		add	ax,4
		db	5, 4, 0			;  Fixup - byte match
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],7
		mov	bx,offset endflag + 0ah	;data_405e
		mov	bx,[bx]
		mov	[bx+2],ax
;*		add	ax,7
		db	5, 7, 0			;  Fixup - byte match
		mov	[bx+1Ch],ax
                or      word ptr ds:[on_object],80h
loc_405:
                mov     bx,word ptr ds:[vce6]
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo6	;705Ah
		jne	loc_406			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo7	;70ACh
		jmp	loc_410
		
loc_406:
		cmp	ax, offset ibmlogo7	;70ACh
		jne	loc_407			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo8	;70FEh
		mov	[bx+0Ah],ax
		jmp	loc_410
		
loc_407:
		cmp	ax, offset ibmlogo8	;70FEh
		jne	loc_409			; Jump if not equal
		mov	ax,[bx+0Ah]
		cmp	ax, offset ibmlogo7	;70ACh
		jne	loc_408			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo9	;7150h
		jmp	loc_410
		
loc_408:
		mov	word ptr [bx+8], offset ibmlogo7	;70ACh
		jmp	loc_410
		
loc_409:
		mov	word ptr [bx+8], offset ibmlogo8	;70FEh
		mov	[bx+0Ah],ax
loc_410:
                test    byte ptr [v6630],1
		jnz	loc_411			; Jump if not zero
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C82
                mov     word ptr ds:[stob], offset v6C86
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C84]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
loc_411:
		jmp	loc_427
loc_412:
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme3]
		jl	loc_413			; Jump if <
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],1
		jmp	loc_403
loc_413:
                test    word ptr ds:[vcb4],4
		jz	loc_415			; Jump if zero
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],1
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo10	;71A2h
		jne	loc_414			; Jump if not equal
		mov	word ptr [bx+8],offset ibmlogo11	;71F4h
		jmp	loc_417
		
loc_414:
		mov	word ptr [bx+8], offset ibmlogo10	;71A2h
		jmp	loc_417
		
loc_415:
                test    word ptr ds:[vcb4],2
		jz	loc_417			; Jump if zero
                test    word ptr ds:[vcb4],1
		jnz	loc_417			; Jump if not zero
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],0FFh
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo10	;71A2h
		jne	loc_416			; Jump if not equal
		mov	word ptr [bx+8],offset ibmlogo11	;71F4h
		jmp	loc_417
		
loc_416:
		mov	word ptr [bx+8], offset ibmlogo10	;71A2h
loc_417:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme2]
		jg	loc_420			; Jump if >
                test    word ptr ds:[vcb4],2
		jnz	loc_418			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jnz	loc_418			; Jump if not zero
		jmp	loc_425
loc_418:
                and     word ptr ds:[on_object],0FF7Fh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],0FFh
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo2	;6F12h
		jne	loc_419			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo3	;6F64h
		jmp	loc_423
		
loc_419:
		mov	word ptr [bx+8], offset ibmlogo2	;6F12h
		jmp	loc_423

loc_420:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme1]
		jl	loc_425			; Jump if <
                test    word ptr ds:[vcb4],2
		jnz	loc_421			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jz	loc_425			; Jump if zero
loc_421:
                and     word ptr ds:[on_object],0FF7Fh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],1
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo4	;6FB6h
		jne	loc_422			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo5	;7008h
		jmp	short loc_423
		db	90h
loc_422:
		mov	word ptr [bx+8], offset ibmlogo4	;6FB6h
loc_423:
                test    byte ptr [v6630],1
		jnz	loc_424			; Jump if not zero
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C7C
                mov     word ptr ds:[stob], offset v6C80
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C7E]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
loc_424:
		jmp	short loc_427
		db	90h
loc_425:
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],0
                test    word ptr ds:[vcb4],1
		jnz	loc_426			; Jump if not zero
                cmp     word ptr ds:[vcb4],0
		jne	loc_427			; Jump if not equal
		mov	word ptr [bx+8],offset IBMlogo1	;6EC0h
		mov	byte ptr [bx+7],0
		jmp	short loc_427
		db	90h
loc_426:
		mov	byte ptr [bx+7],0
		mov	word ptr [bx+8], offset ibmlogo6	;705Ah
loc_427:
                mov     bx,word ptr ds:[vce6]
		call	sub_51
		call	sub_2
		call	sub_3
                test    word ptr ds:[vcb4],8
		jz	loc_428			; Jump if zero
		jmp	short loc_433
		db	90h
loc_428:
                cmp     word ptr ds:[vcb4],0
		jne	loc_429			; Jump if not equal
                test    word ptr ds:[vcb6],2
		jz	loc_430			; Jump if zero
loc_429:
                and     word ptr ds:[on_object],0FFFEh
		jmp	loc_448
loc_430:
                test    word ptr ds:[on_object],1
		jnz	loc_433			; Jump if not zero
                or      word ptr ds:[on_object],1
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+6],100h
                call    putplayer
		call	sub_53
		call	sub_51
		call	sub_2
		call	sub_3
                cmp     word ptr ds:[vcb4],0
		jne	loc_431			; Jump if not equal
                cmp     word ptr ds:[vcb6],0
		je	loc_432			; Jump if equal
loc_431:
                and     word ptr ds:[on_object],0FFFEh
loc_432:
		jmp	loc_448
loc_433:
                and     word ptr ds:[on_object],0FFFBh
                or      word ptr ds:[on_object],2
                mov     ah,byte ptr ds:[v5e1]
                mov     byte ptr ds:[v5d4],ah
                mov     byte ptr ds:[v5e1],2
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+18h],0ACh
		jmp	loc_448
loc_434:
                mov     bx,word ptr ds:[vce6]
                test    word ptr ds:[on_object],40h
		jz	loc_435			; Jump if zero
		jmp	loc_443
loc_435:
		mov	word ptr [bx+6],100h
		mov	word ptr [bx+10h],204h
		cmp	word ptr [bx+8], offset ibmlogo14	;72EAh
		je	loc_436			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo15	;733Ch
		je	loc_436			; Jump if equal
		cmp	word ptr [bx+8],offset ibmlogo16	;738Eh
		je	loc_436			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo17 ;73E0h
		je	loc_436			; Jump if equal
		mov	word ptr [bx+8], offset ibmlogo14	;72EAh
loc_436:
		call	sub_51
		call	sub_2
		call	sub_3
		mov	ax,[bx+18h]
		cmp	ax,[bx+4]
		jne	loc_437			; Jump if not equal
                or      word ptr ds:[on_object],100h
		jmp	loc_448
loc_437:
                test    word ptr ds:[on_object],40h
		jz	loc_438			; Jump if zero
		jmp	loc_448
loc_438:
                cmp     word ptr ds:[vcb4],0
		jne	loc_439			; Jump if not equal
		jmp	loc_448
loc_439:
		cli				; Disable interrupts
                mov     word ptr ds:[sto7],offset something0	;6EB2h
                mov     word ptr ds:[stob],offset something1	;6EB6h
		mov	ax,data_332
                mov     word ptr ds:[stoa],ax
                mov     sto1,0FFFEh
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
		mov	word ptr ds:[vCE4],0
                or      word ptr ds:[on_object],40h
loc_440:
                call    gettimestamp
		and	dh,3
		cmp	dh,2
		jg	loc_440			; Jump if >
		cmp	dh,0
		jne	loc_441			; Jump if not equal
		mov	byte ptr ds:[vCDA],0
		jmp	short loc_448
loc_441:
		cmp	dh,1
		jne	loc_442			; Jump if not equal
		mov	byte ptr ds:[vCDA],1
		jmp	short loc_448
loc_442:
		mov	byte ptr ds:[vCDA],0FFh
		jmp	short loc_448
loc_443:
		cmp	word ptr ds:[vCE4],9
		je	loc_447			; Jump if equal
		mov	di,word ptr ds:[vCE4]
		mov	al,byte ptr ds:[vCDA]
		mov	[bx+6],al
		mov	al,byte ptr ds:[vCDB][di]
		mov	[bx+7],al
		inc	word ptr ds:[vCE4]
		cmp	word ptr [bx+8], offset ibmlogo14	;72EAh
		je	loc_444			; Jump if equal
		cmp	word ptr [bx+8],offset ibmlogo15	;733Ch
		je	loc_445			; Jump if equal
		cmp	word ptr [bx+8],offset ibmlogo16	;738Eh
		je	loc_446			; Jump if equal
		mov	word ptr [bx+8], offset ibmlogo14	;72EAh
		jmp	loc_436
loc_444:
		mov	word ptr [bx+8],offset ibmlogo15	;733Ch
		jmp	loc_436
loc_445:
		mov	word ptr [bx+8], offset ibmlogo16	;738Eh
		jmp	loc_436
loc_446:
		mov	word ptr [bx+8], offset ibmlogo17	;73E0h
		jmp	loc_436
loc_447:
                and     word ptr ds:[on_object],0FFBFh
		jmp	loc_434
loc_448:
		mov	bx, offset v3586
		mov	di, offset endflag 	;data_401e
		cmp	byte ptr [di],32h	; '2'
		je	loc_449			; Jump if equal
		mov	cx,4
		jmp	short locloop_450
loc_449:
		mov	cx,1

locloop_450:
		cmp	word ptr [bx+8],0
		je	loc_451			; Jump if equal
		mov	ax,[bx+2]
		cmp	[bx+12h],ax
		je	loc_452			; Jump if equal
		cmp	[bx+16h],ax
		je	loc_452			; Jump if equal
		mov	ax,[bx+4]
		cmp	[bx+14h],ax
		je	loc_452			; Jump if equal
		cmp	[bx+18h],ax
		je	loc_452			; Jump if equal
loc_451:
		add	bx,20h
		loop	locloop_450		; Loop if cx > 0

		jmp	loc_453

loc_452:
		call	sub_54
		mov	ax,bx
		call	sub_47
		mov	word ptr [bx+8],0
		jmp	short loc_451
loc_453:
		mov	bx, offset v3586
		mov	di,offset endflag	;data_401e
		cmp	byte ptr [di],32h	; '2'
		je	loc_454			; Jump if equal
		mov	cx,4
		jmp	locloop_455
		
loc_454:
		mov	cx,1

locloop_455:
		cmp	word ptr [bx+8],0
		je	loc_456			; Jump if equal
		call	sub_51
loc_456:
		add	bx,20h
		loop	locloop_455		; Loop if cx > 0

		retn
		db	0 
		
v3586		db	6, 0, 0
		db	9 dup (0)
		db	 1Ch, 36h, 00h, 00h, 06h, 03h
		db	 00h, 00h, 00h, 00h, 38h, 01h
		db	0B0h, 00h, 06h, 36h, 00h, 00h
		db	 00h, 00h, 06h, 00h, 00h
		db	9 dup (0)
		db	 1Ch, 36h, 00h, 00h, 06h, 03h
		db	 00h, 00h, 00h, 00h, 38h, 01h
		db	0B0h, 00h, 0Ah, 36h, 00h, 00h
		db	 00h, 00h, 06h, 00h, 00h
		db	9 dup (0)
		db	 1Ch, 36h, 00h, 00h, 06h, 03h
		db	 00h, 00h, 00h, 00h, 38h, 01h
		db	0B0h, 00h, 0Eh, 36h, 00h, 00h
		db	 00h, 00h, 06h, 00h, 00h
		db	9 dup (0)
		db	 1Ch, 36h, 00h, 00h, 06h, 03h
		db	 00h, 00h, 00h, 00h, 38h, 01h
		db	0B0h, 00h, 12h
		db	36h
		db	20 dup (0)
		db	 01h, 02h,0F0h, 00h,0F0h, 00h
		db	 01h, 02h, 0Fh, 00h, 0Fh
		db	15 dup (0)
loc_457:
		mov	bx, offset endflag + 06 ;data_403e
		mov	bx,[bx]
                mov     word ptr ds:[vce6],bx
		call	sub_3
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+6],0
                test    word ptr ds:[on_object],2
		jz	loc_458			; Jump if zero
		jmp	loc_526
loc_458:
                test    word ptr ds:[on_object],4
		jz	loc_459			; Jump if zero
		jmp	loc_509
loc_459:
		or	byte ptr ds:[v52C6],10h
                mov     ax,word ptr ds:[beatsme1]
		dec	ax
                mov     word ptr ds:[vcba],ax
                mov     ax,word ptr ds:[beatsme3]
		dec	ax
		mov	word ptr ds:[vCBC],ax
		cmp	byte ptr ds:[usejoystick],0
		je	loc_460			; Jump if equal
		call	readjoystick	;sub_44
		mov	ax,word ptr ds:[v52C2]
                mov     word ptr ds:[vcba],ax
		mov	ax,word ptr ds:[v52C4]
		mov	word ptr ds:[vCBC],ax
loc_460:
		cmp	byte ptr [keypress+key_space], 0	;data_299,0
		je	loc_461			; Jump if equal
		and	byte ptr ds:[v52C6],0EFh
loc_461:
		cmp	byte ptr [keypress+key_up], 0	;data_300,0
		je	loc_462			; Jump if equal
                mov     ax,word ptr ds:[beatsme4]
		dec	ax
		mov	word ptr ds:[vCBC],ax
loc_462:
		cmp	byte ptr [keypress+key_down], 0	;data_303,0
		je	loc_463			; Jump if equal
                mov     ax,word ptr ds:[beatsme3]
		inc	ax
		mov	word ptr ds:[vCBC],ax
loc_463:
		cmp	byte ptr [keypress+key_left], 0	;data_301,0
		je	loc_464			; Jump if equal
                mov     ax,word ptr ds:[beatsme2]
		dec	ax
                mov     word ptr ds:[vcba],ax
loc_464:
		cmp	byte ptr [keypress+key_right], 0	;data_302,0
		je	loc_465			; Jump if equal
                mov     ax,word ptr ds:[beatsme1]
		inc	ax
                mov     word ptr ds:[vcba],ax
loc_465:
		test	byte ptr ds:[v52C6],10h
		jz	loc_466			; Jump if zero
		jmp	loc_472
loc_466:
                cmp     word ptr ds:[vcb4],0
		jne	loc_467			; Jump if not equal
                cmp     word ptr ds:[vcb6],0
		jne	loc_467			; Jump if not equal
		jmp	short loc_472
		db	90h
loc_467:
                mov     bx,word ptr ds:[vce6]
		mov	word ptr ds:[vCD8],0
                or      word ptr ds:[on_object],4
                and     word ptr ds:[on_object],0FF7Fh
                and     word ptr ds:[on_object],0FFDFh
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme4]
		jge	loc_468			; Jump if > or =
		mov	word ptr [bx+8], offset ibmlogo6	;705Ah
		jmp	short loc_470
		db	90h
loc_468:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme2]
		jge	loc_469			; Jump if > or =
		mov	word ptr [bx+8],offset ibmlogo12	;7246h
		jmp	short loc_470
		db	90h
loc_469:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme1]
		jl	loc_471			; Jump if <
		mov	word ptr [bx+8], offset ibmlogo13	;7298h
loc_470:
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C88
                mov     word ptr ds:[stob],offset v6C98
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C96]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
		jmp	loc_509
loc_471:
                and     word ptr ds:[on_object],0FFFBh
		jmp	loc_485
loc_472:
                test    word ptr ds:[vcb4],1
		jnz	loc_473			; Jump if not zero
		jmp	loc_485
loc_473:
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme4]
		jle	loc_474			; Jump if < or =
		jmp	loc_484
loc_474:
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],0FFh
loc_475:
                test    word ptr ds:[on_object],80h
		jnz	loc_477			; Jump if not zero
                mov     bx, [somevar0]
loc_476:
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		cmp	byte ptr [di],1
		jne	loc_476			; Jump if not equal
		mov	ax,[di+2]
                mov     bx,word ptr ds:[vce6]
		mov	dx,[bx+4]
		push	bx
		mov	bx,[bx+2]
                call    checkeol
                mov     word ptr ds:[dispstats2],bp
                mov     word ptr ds:[dispstats1],bp
                mov     word ptr ds:[dispstats0],0Ah
                mov     word ptr ds:[gfxcount],8
                call    put2screen
		pop	bx
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],0Fh
		mov	bx,offset endflag + 8	;data_404e
		mov	bx,[bx]
;*		add	ax,4
		db	5, 4, 0			;  Fixup - byte match
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],7
		mov	bx,offset endflag + 0ah	;data_405e
		mov	bx,[bx]
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],7
                or      word ptr ds:[on_object],80h
loc_477:
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo6	;705Ah
		jne	loc_478			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo7	;70ACh
		jmp	short loc_482
		db	90h
loc_478:
		cmp	ax, offset ibmlogo7	;70ACh
		jne	loc_479			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo8	;70FEh
		mov	[bx+0Ah],ax
		jmp	short loc_482
		db	90h
loc_479:
		cmp	ax, offset ibmlogo8	;70FEh
		jne	loc_481			; Jump if not equal
		mov	ax,[bx+0Ah]
		cmp	ax, offset ibmlogo7	;70ACh
		jne	loc_480			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo9	;7150h
		jmp	short loc_482
		db	90h
loc_480:
		mov	word ptr [bx+8], offset ibmlogo7	;70ACh
		jmp	short loc_482
		db	90h
loc_481:
		mov	word ptr [bx+8], offset ibmlogo8	;70FEh
		mov	[bx+0Ah],ax
loc_482:
                test    byte ptr [v6630],1
		jnz	loc_483			; Jump if not zero
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C82
                mov     word ptr ds:[stob], offset v6C86
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C84]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
loc_483:
		jmp	loc_499
loc_484:
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme3]
		jl	loc_485			; Jump if <
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],1
		jmp	loc_475
loc_485:
                test    word ptr ds:[vcb4],4
		jz	loc_487			; Jump if zero
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],1
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo10	;71A2h
		jne	loc_486			; Jump if not equal
		mov	word ptr [bx+8],offset ibmlogo11	;71F4h
		jmp	loc_489
loc_486:
		mov	word ptr [bx+8], offset ibmlogo10	;71A2h
		jmp	loc_489
loc_487:
                test    word ptr ds:[vcb4],2
		jz	loc_489			; Jump if zero
                test    word ptr ds:[vcb4],1
		jnz	loc_489			; Jump if not zero
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],0FFh
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo10	;71A2h
		jne	loc_488			; Jump if not equal
		mov	word ptr [bx+8],offset ibmlogo11	;71F4h
		jmp	loc_489
loc_488:
		mov	word ptr [bx+8], offset ibmlogo10	;71A2h
loc_489:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme2]
		jg	loc_492			; Jump if >
                test    word ptr ds:[vcb4],2
		jnz	loc_490			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jnz	loc_490			; Jump if not zero
		jmp	loc_497
loc_490:
                and     word ptr ds:[on_object],0FF7Fh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],0FFh
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo2	;6F12h
		jne	loc_491			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo3	;6F64h
		jmp	loc_495
loc_491:
		mov	word ptr [bx+8], offset ibmlogo2	;6F12h
		jmp	loc_495
loc_492:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme1]
		jl	loc_497			; Jump if <
                test    word ptr ds:[vcb4],2
		jnz	loc_493			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jz	loc_497			; Jump if zero
loc_493:
                and     word ptr ds:[on_object],0FF7Fh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],1
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo4	;6FB6h
		jne	loc_494			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo5	;7008h
		jmp	loc_495
loc_494:
		mov	word ptr [bx+8], offset ibmlogo4	;6FB6h
loc_495:
                test    byte ptr [v6630],1
		jnz	loc_496			; Jump if not zero
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C7C
                mov     word ptr ds:[stob], offset v6C80
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C7E]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
loc_496:
		jmp	loc_499
loc_497:
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],0
                test    word ptr ds:[vcb4],1
		jnz	loc_498			; Jump if not zero
                cmp     word ptr ds:[vcb4],0
		jne	loc_499			; Jump if not equal
		mov	word ptr [bx+8],offset IBMlogo1	;6EC0h
		mov	byte ptr [bx+7],0
		jmp	loc_499
loc_498:
		mov	byte ptr [bx+7],0
		mov	word ptr [bx+8], offset ibmlogo6	;705Ah
loc_499:
                test    word ptr ds:[on_object],200h
		jz	loc_500			; Jump if zero
		mov	bx, offset v3CF6
                mov     di,word ptr ds:[vce6]
		mov	ax,[di+2]
		mov	[bx+2],ax
		mov	ax,[di+4]
		inc	ax
		mov	[bx+4],ax
		mov	ax,[di+10h]
		mov	[bx+10h],ax
		mov	ax,[di+6]
		mov	[bx+6],ax
		call	sub_51
loc_500:
                mov     bx,word ptr ds:[vce6]
		call	sub_51
		call	sub_2
		call	sub_3
                test    word ptr ds:[vcb4],8
		jz	loc_501			; Jump if zero
		jmp	loc_507
loc_501:
                cmp     word ptr ds:[vcb4],0
		jne	loc_502			; Jump if not equal
                test    word ptr ds:[vcb6],2
		jz	loc_503			; Jump if zero
loc_502:
                and     word ptr ds:[on_object],0FFFEh
		jmp	loc_ret_540
loc_503:
                test    word ptr ds:[on_object],1
		jnz	loc_507			; Jump if not zero
                or      word ptr ds:[on_object],1
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+6],100h
                call    putplayer
		call	sub_53
                test    word ptr ds:[on_object],200h
		jz	loc_504			; Jump if zero
		mov	bx, offset v3CF6
                mov     di,word ptr ds:[vce6]
		mov	ax,[di+2]
		mov	[bx+2],ax
		mov	ax,[di+4]
		inc	ax
		mov	[bx+4],ax
		mov	ax,[di+10h]
		mov	[bx+10h],ax
		mov	ax,[di+6]
		mov	[bx+6],ax
		call	sub_51
loc_504:
                mov     bx,word ptr ds:[vce6]
		call	sub_51
		call	sub_2
		call	sub_3
                cmp     word ptr ds:[vcb4],0
		jne	loc_505			; Jump if not equal
                cmp     word ptr ds:[vcb6],0
		je	loc_506			; Jump if equal
loc_505:
                and     word ptr ds:[on_object],0FFFEh
loc_506:
		jmp	loc_ret_540
loc_507:
                test    word ptr ds:[on_object],200h
		jz	loc_508			; Jump if zero
		mov	bx, offset v3CF6
		call	sub_54
loc_508:
                and     word ptr ds:[on_object],0FDFFh
                and     word ptr ds:[on_object],0FFFBh
                or      word ptr ds:[on_object],2
                mov     ah,byte ptr ds:[v5e1]
                mov     byte ptr ds:[v5d4],ah
                mov     byte ptr ds:[v5e1],2
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+18h],0ACh
		jmp	loc_ret_540
loc_509:
		cmp	word ptr ds:[vCD8],0Dh
		jne	loc_510			; Jump if not equal
		jmp	loc_518
loc_510:
		cmp	word ptr ds:[vCD8],5
		jl	loc_515			; Jump if <
		call	sub_3
                test    word ptr ds:[on_object],20h
		jnz	loc_511			; Jump if not zero
                test    word ptr ds:[vcb4],1
		jz	loc_513			; Jump if zero
                test    word ptr ds:[on_object],10h
		jnz	loc_513			; Jump if not zero
                or      word ptr ds:[on_object],20h
		jmp	loc_513
loc_511:
                mov     bx, [somevar0]
loc_512:
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		cmp	byte ptr [di],1
		jne	loc_512			; Jump if not equal
                mov     bx,word ptr ds:[vce6]
		mov	ax,[bx+2]
		cmp	ax,[di+2]
		je	loc_518			; Jump if equal
loc_513:
                test    word ptr ds:[vcb4],4
		jz	loc_514			; Jump if zero
                test    word ptr ds:[on_object],8
		jz	loc_518			; Jump if zero
loc_514:
                test    word ptr ds:[vcb4],2
		jnz	loc_518			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jnz	loc_518			; Jump if not zero
loc_515:
                mov     bx,word ptr ds:[vce6]
		mov	di,word ptr ds:[vCD8]
		mov	al,byte ptr ds:[vCBE][di]
		mov	[bx+7],al
		mov	al,byte ptr ds:[vCCB][di]
		mov	[bx+11h],al
		cmp	word ptr [bx+8], offset ibmlogo6	;705Ah
		jne	loc_516			; Jump if not equal
		mov	byte ptr [bx+6],0
		jmp	short loc_519
loc_516:
		cmp	word ptr [bx+8],offset ibmlogo12	;7246h
		jne	loc_517			; Jump if not equal
		mov	byte ptr [bx+6],0FFh
		jmp	short loc_519
loc_517:
		mov	byte ptr [bx+6],1
		jmp	loc_519
loc_518:
                and     word ptr ds:[on_object],0FFFBh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+11h],2
		jmp	loc_499
loc_519:
                test    word ptr ds:[vcb4],1
		jz	loc_520			; Jump if zero
                or      word ptr ds:[on_object],10h
		jmp	loc_521
loc_520:
                and     word ptr ds:[on_object],0FFEFh
loc_521:
                test    word ptr ds:[vcb4],4
		jz	loc_522			; Jump if zero
                or      word ptr ds:[on_object],8
		jmp	loc_523
loc_522:
                and     word ptr ds:[on_object],0FFF7h
loc_523:
                test    word ptr ds:[on_object],200h
		jz	loc_524			; Jump if zero
		mov	bx, offset v3CF6
                mov     di,word ptr ds:[vce6]
		mov	ax,[di+2]
		mov	[bx+2],ax
		mov	ax,[di+4]
		inc	ax
		mov	[bx+4],ax
		mov	ax,[di+10h]
		mov	[bx+10h],ax
		mov	ax,[di+6]
		mov	[bx+6],ax
		call	sub_51
loc_524:
                mov     bx,word ptr ds:[vce6]
		call	sub_51
		call	sub_2
		call	sub_3
		inc	word ptr ds:[vCD8]
                test    word ptr ds:[vcb4],8
		jz	loc_525			; Jump if zero
		jmp	loc_507
loc_525:
		jmp	loc_ret_540
loc_526:
                mov     bx,word ptr ds:[vce6]
                test    word ptr ds:[on_object],40h
		jz	loc_527			; Jump if zero
		jmp	loc_535
loc_527:
		mov	word ptr [bx+6],100h
		mov	word ptr [bx+10h],204h
		cmp	word ptr [bx+8], offset ibmlogo14	;72EAh
		je	loc_528			; Jump if equal
		cmp	word ptr [bx+8],offset ibmlogo15	;733Ch
		je	loc_528			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo16	;738Eh
		je	loc_528			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo17 ;73E0h
		je	loc_528			; Jump if equal
		mov	word ptr [bx+8], offset ibmlogo14	;72EAh
loc_528:
		call	sub_51
		call	sub_2
		call	sub_3
		mov	ax,[bx+18h]
		cmp	ax,[bx+4]
		jne	loc_529			; Jump if not equal
                or      word ptr ds:[on_object],100h
		jmp	loc_ret_540
loc_529:
                test    word ptr ds:[on_object],40h
		jz	loc_530			; Jump if zero
		jmp	loc_ret_540
loc_530:
                cmp     word ptr ds:[vcb4],0
		jne	loc_531			; Jump if not equal
		jmp	loc_ret_540
loc_531:
		cli				; Disable interrupts
                mov     word ptr ds:[sto7],offset something0	;6EB2h
                mov     word ptr ds:[stob],offset something1	;6EB6h
		mov	ax,data_332
                mov     word ptr ds:[stoa],ax
                mov     sto1,0FFFEh
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
		mov	word ptr ds:[vCE4],0
                or      word ptr ds:[on_object],40h
loc_532:
                call    gettimestamp
		and	dh,3
		cmp	dh,2
		jg	loc_532			; Jump if >
		cmp	dh,0
		jne	loc_533			; Jump if not equal
		mov	byte ptr ds:[vCDA],0
		jmp	short loc_ret_540
		db	90h
loc_533:
		cmp	dh,1
		jne	loc_534			; Jump if not equal
		mov	byte ptr ds:[vCDA],1
		jmp	short loc_ret_540
		db	90h
loc_534:
		mov	byte ptr ds:[vCDA],0FFh
		jmp	short loc_ret_540
		db	90h
loc_535:
		cmp	word ptr ds:[vCE4],9
		je	loc_539			; Jump if equal
		mov	di,word ptr ds:[vCE4]
		mov	al,byte ptr ds:[vCDA]
		mov	[bx+6],al
		mov	al,byte ptr ds:[vCDB][di]
		mov	[bx+7],al
		inc	word ptr ds:[vCE4]
		cmp	word ptr [bx+8], offset ibmlogo14	;72EAh
		je	loc_536			; Jump if equal
		cmp	word ptr [bx+8],offset ibmlogo15	;733Ch
		je	loc_537			; Jump if equal
		cmp	word ptr [bx+8],offset ibmlogo16	;738Eh
		je	loc_538			; Jump if equal
		mov	word ptr [bx+8], offset ibmlogo14	;72EAh
		jmp	loc_528
loc_536:
		mov	word ptr [bx+8], offset ibmlogo15	;733Ch
		jmp	loc_528
loc_537:
		mov	word ptr [bx+8],offset ibmlogo16	;738Eh
		jmp	loc_528
loc_538:
		mov	word ptr [bx+8], offset ibmlogo17 ;73E0h
		jmp	loc_528
loc_539:
                and     word ptr ds:[on_object],0FFBFh
		jmp	loc_526

loc_ret_540:
		retn
v3cf6		dw	0
		db	6 dup (0)
		dw	offset ibmcgaoffset3	;0D6h, 74h
		db	8 dup (0)
		db	0FCh,0FFh,0F0h,0FFh, 34h, 01h
		db	0ADh, 00h, 16h, 3Dh, 00h, 00h
		db	44 dup (0)

		
		
		
		

		


		
loc_541:
		mov	bx, offset endflag + 06 ;data_403e
		mov	bx,[bx]
                mov     word ptr ds:[vce6],bx
		call	sub_3
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+6],0
                test    word ptr ds:[on_object],2
		jz	loc_542			; Jump if zero
		jmp	loc_611
loc_542:
                test    word ptr ds:[on_object],4
		jz	loc_543			; Jump if zero
		jmp	loc_593
loc_543:
		or	byte ptr ds:[v52C6],10h
                mov     ax,word ptr ds:[beatsme1]
		dec	ax
                mov     word ptr ds:[vcba],ax
                mov     ax,word ptr ds:[beatsme3]
		dec	ax
		mov	word ptr ds:[vCBC],ax
		cmp	byte ptr ds:[usejoystick],0
		je	loc_544			; Jump if equal
		call	readjoystick	;sub_44
		mov	ax,word ptr ds:[v52C2]
                mov     word ptr ds:[vcba],ax
		mov	ax,word ptr ds:[v52C4]
		mov	word ptr ds:[vCBC],ax
loc_544:
		cmp	byte ptr [keypress+key_space], 0	;data_299,0
		je	loc_545			; Jump if equal
		and	byte ptr ds:[v52C6],0EFh
loc_545:
		cmp	byte ptr [keypress+key_up],0	;data_300,0
		je	loc_546			; Jump if equal
                mov     ax,word ptr ds:[beatsme4]
		dec	ax
		mov	word ptr ds:[vCBC],ax
loc_546:
		cmp	byte ptr [keypress+key_down], 0	;data_303,0
		je	loc_547			; Jump if equal
                mov     ax,word ptr ds:[beatsme3]
		inc	ax
		mov	word ptr ds:[vCBC],ax
loc_547:
		cmp	byte ptr [keypress+key_left], 0	;data_301,0
		je	loc_548			; Jump if equal
                mov     ax,word ptr ds:[beatsme2]
		dec	ax
                mov     word ptr ds:[vcba],ax
loc_548:
		cmp	byte ptr [keypress+key_right], 0	;data_302,0
		je	loc_549			; Jump if equal
                mov     ax,word ptr ds:[beatsme1]
		inc	ax
                mov     word ptr ds:[vcba],ax
loc_549:
		test	byte ptr ds:[v52C6],10h
		jz	loc_550			; Jump if zero
		jmp	loc_557
loc_550:
                mov     ax,word ptr ds:[vcba]
                cmp     word ptr ds:[beatsme1],ax
		jl	loc_552			; Jump if <
                cmp     word ptr ds:[beatsme2],ax
		jg	loc_551			; Jump if >
		jmp	loc_554
loc_551:
		cmp	byte ptr ds:[v447F],0
		jne	loc_554			; Jump if not equal
                mov     bx,word ptr ds:[vce6]
		mov	ax,[bx+2]
		sub	ax,6
		mov	word ptr ds:[v447B],ax
		mov	word ptr ds:[v4495],ax
		mov	byte ptr ds:[v447F],0FFh
		mov	word ptr ds:[v4481], offset v44AD
		mov	word ptr ds:[v4483], offset v44AD
		mov	word ptr ds:[v4485], offset v44C7
		mov	word ptr ds:[v4487], offset v44C7
		jmp	loc_553
loc_552:
		cmp	byte ptr ds:[v447F],0
		jne	loc_554			; Jump if not equal
                mov     bx,word ptr ds:[vce6]
		mov	ax,[bx+2]
		add	ax,6
		mov	word ptr ds:[v447B],ax
		mov	word ptr ds:[v4495],ax
		mov	byte ptr ds:[v447F],1
		mov	word ptr ds:[v4481], offset v44E7
		mov	word ptr ds:[v4483], offset v44E7
		mov	word ptr ds:[v4485], offset v4501
		mov	word ptr ds:[v4487], offset v4501
loc_553:
		mov	ax,[bx+4]
		dec	ax
		mov	word ptr ds:[v447D],ax
		mov	word ptr ds:[v4497],ax
		mov	ax, offset v4479
		call	sub_49_
		mov	word ptr ds:[v4477], offset v445F
loc_554:
                cmp     word ptr ds:[vcb4],0
		jne	loc_555			; Jump if not equal
                cmp     word ptr ds:[vcb6],0
		jne	loc_555			; Jump if not equal
		jmp	loc_557
loc_555:
                mov     bx,word ptr ds:[vce6]
		mov	word ptr ds:[vCD8],0
                or      word ptr ds:[on_object],4
                and     word ptr ds:[on_object],0FF7Fh
                and     word ptr ds:[on_object],0FFDFh
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme4]
		jge	loc_556			; Jump if > or =
		mov	word ptr [bx+8], offset ibmlogo6	;705Ah
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C88
                mov     word ptr ds:[stob], offset v6C98
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C96]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
		jmp	loc_593
loc_556:
                and     word ptr ds:[on_object],0FFFBh
		jmp	loc_570
loc_557:
                test    word ptr ds:[vcb4],1
		jnz	loc_558			; Jump if not zero
		jmp	loc_570
loc_558:
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme4]
		jle	loc_559			; Jump if < or =
		jmp	loc_569
loc_559:
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],0FFh
loc_560:
                test    word ptr ds:[on_object],80h
		jnz	loc_562			; Jump if not zero
                mov     bx, [somevar0]
loc_561:
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		cmp	byte ptr [di],1
		jne	loc_561			; Jump if not equal
		mov	ax,[di+2]
                mov     bx,word ptr ds:[vce6]
		call	sub_54
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],0Fh
		mov	bx,offset endflag + 8	;data_404e
		mov	bx,[bx]
		add	ax,4
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],7
		mov	bx,offset endflag + 0ah ;data_405e
		mov	bx,[bx]
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],7
                or      word ptr ds:[on_object],80h
loc_562:
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo6	;705Ah
		jne	loc_563			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo7	;70ACh
		jmp	loc_567
loc_563:
		cmp	ax, offset ibmlogo7	;70ACh
		jne	loc_564			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo8	;70FEh
		mov	[bx+0Ah],ax
		jmp	loc_567
loc_564:
		cmp	ax, offset ibmlogo8	;70FEh
		jne	loc_566			; Jump if not equal
		mov	ax,[bx+0Ah]
		cmp	ax, offset ibmlogo7	;70ACh
		jne	loc_565			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo9	;7150h
		jmp	loc_567
loc_565:
		mov	word ptr [bx+8], offset ibmlogo7	;70ACh
		jmp	loc_567
loc_566:
		mov	word ptr [bx+8], offset ibmlogo8	;70FEh
		mov	[bx+0Ah],ax
loc_567:
                test    byte ptr [v6630],1
		jnz	loc_568			; Jump if not zero
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C82
                mov     word ptr ds:[stob], offset v6C86
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C84]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
loc_568:
		jmp	loc_584
loc_569:
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme3]
		jl	loc_570			; Jump if <
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],1
		jmp	loc_560
loc_570:
                test    word ptr ds:[vcb4],4
		jz	loc_572			; Jump if zero
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],1
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo10	;71A2h
		jne	loc_571			; Jump if not equal
		mov	word ptr [bx+8],offset ibmlogo11	;71F4h
		jmp	loc_574
loc_571:
		mov	word ptr [bx+8], offset ibmlogo10	;71A2h
		jmp	loc_574
loc_572:
                test    word ptr ds:[vcb4],2
		jz	loc_574			; Jump if zero
                test    word ptr ds:[vcb4],1
		jnz	loc_574			; Jump if not zero
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],0FFh
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo10	;71A2h
		jne	loc_573			; Jump if not equal
		mov	word ptr [bx+8],offset ibmlogo11	;71F4h
		jmp	loc_574
loc_573:
		mov	word ptr [bx+8], offset ibmlogo10	;71A2h
loc_574:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme2]
		jg	loc_577			; Jump if >
                test    word ptr ds:[vcb4],2
		jnz	loc_575			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jnz	loc_575			; Jump if not zero
		jmp	loc_582
loc_575:
                and     word ptr ds:[on_object],0FF7Fh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],0FFh
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo2	;6F12h
		jne	loc_576			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo3	;6F64h
		jmp	loc_580
loc_576:
		mov	word ptr [bx+8], offset ibmlogo2	;6F12h
		jmp	loc_580
loc_577:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme1]
		jl	loc_582			; Jump if <
                test    word ptr ds:[vcb4],2
		jnz	loc_578			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jz	loc_582			; Jump if zero
loc_578:
                and     word ptr ds:[on_object],0FF7Fh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],1
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo4	;6FB6h
		jne	loc_579			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo5	;7008h
		jmp	loc_580
loc_579:
		mov	word ptr [bx+8], offset ibmlogo4	;6FB6h
loc_580:
                test    byte ptr [v6630],1
		jnz	loc_581			; Jump if not zero
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C7C
                mov     word ptr ds:[stob], offset v6C80
		mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C7E]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
loc_581:
		jmp	loc_584
loc_582:
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],0
                test    word ptr ds:[vcb4],1
		jnz	loc_583			; Jump if not zero
                cmp     word ptr ds:[vcb4],0
		jne	loc_584			; Jump if not equal
		mov	word ptr [bx+8],offset IBMlogo1	;6EC0h
		mov	byte ptr [bx+7],0
		jmp	loc_584
loc_583:
		mov	byte ptr [bx+7],0
		mov	word ptr [bx+8], offset ibmlogo6	;705Ah
loc_584:
                mov     bx,word ptr ds:[vce6]
                test    word ptr ds:[on_object],400h
		jnz	loc_585			; Jump if not zero
		call	sub_51
		jmp	loc_586
loc_585:
		call	sub_51
		call	sub_53
                call    putplayer
loc_586:
		call	sub_2
		call	sub_3
                test    word ptr ds:[vcb4],8
		jz	loc_587			; Jump if zero
		jmp	loc_592
		
loc_587:
                cmp     word ptr ds:[vcb4],0
		jne	loc_588			; Jump if not equal
                test    word ptr ds:[vcb6],2
		jz	loc_589			; Jump if zero
loc_588:
                and     word ptr ds:[on_object],0FFFEh
		jmp	loc_625
loc_589:
                test    word ptr ds:[on_object],1
		jnz	loc_592			; Jump if not zero
                or      word ptr ds:[on_object],1
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+6],100h
                call    putplayer
		call	sub_53
		call	sub_51
		call	sub_2
		call	sub_3
                cmp     word ptr ds:[vcb4],0
		jne	loc_590			; Jump if not equal
                cmp     word ptr ds:[vcb6],0
		je	loc_591			; Jump if equal
loc_590:
                and     word ptr ds:[on_object],0FFFEh
loc_591:
		jmp	loc_625
loc_592:
                and     word ptr ds:[on_object],0FBFFh
                and     word ptr ds:[on_object],0FFFBh
                and     word ptr ds:[on_object],0F7FFh
                or      word ptr ds:[on_object],2
                mov     ah,byte ptr ds:[v5e1]
                mov     byte ptr ds:[v5d4],ah
                mov     byte ptr ds:[v5e1],2
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+18h],0ACh
		jmp	loc_625
loc_593:
		cmp	word ptr ds:[vCD8],0Dh
		jne	loc_594			; Jump if not equal
		jmp	loc_602
loc_594:
		cmp	word ptr ds:[vCD8],5
		jl	loc_599			; Jump if <
		call	sub_3
                test    word ptr ds:[on_object],20h
		jnz	loc_595			; Jump if not zero
                test    word ptr ds:[vcb4],1
		jz	loc_597			; Jump if zero
                test    word ptr ds:[on_object],10h
		jnz	loc_597			; Jump if not zero
                or      word ptr ds:[on_object],20h
		jmp	loc_597
loc_595:
                mov     bx, [somevar0]
loc_596:
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		cmp	byte ptr [di],1
		jne	loc_596			; Jump if not equal
                mov     bx,word ptr ds:[vce6]
		mov	ax,[bx+2]
		cmp	ax,[di+2]
		je	loc_602			; Jump if equal
loc_597:
                test    word ptr ds:[vcb4],4
		jz	loc_598			; Jump if zero
                test    word ptr ds:[on_object],8
		jz	loc_602			; Jump if zero
loc_598:
                test    word ptr ds:[vcb4],2
		jnz	loc_602			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jnz	loc_602			; Jump if not zero
loc_599:
                mov     bx,word ptr ds:[vce6]
		mov	di,word ptr ds:[vCD8]
		mov	al,byte ptr ds:[vCBE][di]
		mov	[bx+7],al
		mov	al,byte ptr ds:[vCCB][di]
		mov	[bx+11h],al
		cmp	word ptr [bx+8], offset ibmlogo6	;705Ah
		jne	loc_600			; Jump if not equal
		mov	byte ptr [bx+6],0
		jmp	loc_603
loc_600:
		cmp	word ptr [bx+8],offset ibmlogo12	;7246h
		jne	loc_601			; Jump if not equal
		mov	byte ptr [bx+6],0FFh
		jmp	loc_603
loc_601:
		mov	byte ptr [bx+6],1
		jmp	loc_603
loc_602:
                and     word ptr ds:[on_object],0FFFBh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+11h],2
		jmp	loc_584
loc_603:
                test    word ptr ds:[vcb4],1
		jz	loc_604			; Jump if zero
                or      word ptr ds:[on_object],10h
		jmp	loc_605
loc_604:
                and     word ptr ds:[on_object],0FFEFh
loc_605:
                test    word ptr ds:[vcb4],4
		jz	loc_606			; Jump if zero
                or      word ptr ds:[on_object],8
		jmp	loc_607
loc_606:
                and     word ptr ds:[on_object],0FFF7h
loc_607:
                test    word ptr ds:[on_object],400h
		jnz	loc_608			; Jump if not zero
		call	sub_51
		jmp	loc_609
loc_608:
		call	sub_51
		call	sub_53
                call    putplayer
loc_609:
		call	sub_2
		call	sub_3
		inc	word ptr ds:[vCD8]
                test    word ptr ds:[vcb4],8
		jz	loc_610			; Jump if zero
		jmp	loc_592
loc_610:
		jmp	loc_625
loc_611:
                mov     bx,word ptr ds:[vce6]
                test    word ptr ds:[on_object],40h
		jz	loc_612			; Jump if zero
		jmp	loc_620
loc_612:
		mov	word ptr [bx+6],100h
		mov	word ptr [bx+10h],204h
		cmp	word ptr [bx+8], offset ibmlogo14	;72EAh
		je	loc_613			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo15	;733Ch
		je	loc_613			; Jump if equal
		cmp	word ptr [bx+8],offset ibmlogo16	;738Eh
		je	loc_613			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo17	;73E0h
		je	loc_613			; Jump if equal
		mov	word ptr [bx+8], offset ibmlogo14	;72EAh
loc_613:
		call	sub_51
		call	sub_2
		call	sub_3
		mov	ax,[bx+18h]
		cmp	ax,[bx+4]
		jne	loc_614			; Jump if not equal
                or      word ptr ds:[on_object],100h
		jmp	loc_625
loc_614:
                test    word ptr ds:[on_object],40h
		jz	loc_615			; Jump if zero
		jmp	loc_625
loc_615:
                cmp     word ptr ds:[vcb4],0
		jne	loc_616			; Jump if not equal
		jmp	loc_625
loc_616:
		cli				; Disable interrupts
                mov     word ptr ds:[sto7],offset something0	;6EB2h
                mov     word ptr ds:[stob],offset something1	;6EB6h
		mov	ax,data_332
                mov     word ptr ds:[stoa],ax
                mov     sto1,0FFFEh
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
		mov	word ptr ds:[vCE4],0
                or      word ptr ds:[on_object],40h
loc_617:
                call    gettimestamp
		and	dh,3
		cmp	dh,2
		jg	loc_617			; Jump if >
		cmp	dh,0
		jne	loc_618			; Jump if not equal
		mov	byte ptr ds:[vCDA],0
		jmp	short loc_625
			                        ;* No entry point to code
		nop
loc_618:
		cmp	dh,1
;*		jne	loc_619			;*Jump if not equal
		db	 75h, 08h		;  Fixup - byte match
		mov	byte ptr ds:[vCDA],1
		jmp	short loc_625
data_196	dw	0C690h
data_197	dw	0DA06h
data_198	dw	0FF0Ch
data_199	dw	5BEBh
		db	90h
loc_620:
		cmp	word ptr ds:[vCE4],9
		je	loc_624			; Jump if equal
		mov	di,word ptr ds:[vCE4]
		mov	al,byte ptr ds:[vCDA]
		mov	[bx+6],al
		mov	al,byte ptr ds:[vCDB][di]
		mov	[bx+7],al
		inc	word ptr ds:[vCE4]
		cmp	word ptr [bx+8],offset ibmlogo14	;72EAh
		je	loc_621			; Jump if equal
		cmp	word ptr [bx+8],offset ibmlogo15	;733Ch
		je	loc_622			; Jump if equal
		cmp	word ptr [bx+8],offset ibmlogo16	;738Eh
		je	loc_623			; Jump if equal
		mov	word ptr [bx+8],offset ibmlogo14	;72EAh
		jmp	loc_613
loc_621:
		mov	word ptr [bx+8],offset ibmlogo15	;733Ch
		jmp	loc_613
loc_622:
		mov	word ptr [bx+8], offset ibmlogo16	;738Eh
		jmp	loc_613
loc_623:
		mov	word ptr [bx+8], offset ibmlogo17 ;73E0h
		jmp	loc_613
loc_624:
                and     word ptr ds:[on_object],0FFBFh
		jmp	loc_611
loc_625:
		cmp	byte ptr ds:[v447F],0
		je	loc_ret_629		; Jump if equal
		mov	di,word ptr ds:[v4477]
		mov	al,[di]
		mov	byte ptr ds:[v4480],al
		inc	di
		cmp	byte ptr [di],2
		jne	loc_626			; Jump if not equal
		mov	byte ptr ds:[v447F],0
		mov	bx, offset v4479
		call	sub_54
		mov	ax,bx
		call	sub_47
		jmp	short loc_ret_629
		db	90h
loc_626:
		mov	word ptr ds:[v4477],di
		mov	ax,word ptr ds:[v447B]
		cmp	data_196,ax
		je	loc_627			; Jump if equal
		cmp	data_198,ax
		je	loc_627			; Jump if equal
		mov	ax,word ptr ds:[v447D]
		cmp	data_197,ax
		je	loc_627			; Jump if equal
		cmp	data_199,ax
		jne	loc_628			; Jump if not equal
loc_627:
		mov	bx, offset v4479
		call	sub_54
		mov	word ptr ds:[v4481],offset v4521
		mov	word ptr ds:[v4483],offset v4521
		mov	word ptr ds:[v4485],offset v4521
		mov	word ptr ds:[v4487],offset v4521
loc_628:
		mov	bx, offset v4479
		call	sub_51

loc_ret_629:
		retn

		db	0

v445f		db	00h,0FFh, 00h,0FFh, 00h
		db	0FFh, 00h, 00h, 00h, 01h, 00h
		db	 01h, 00h, 01h, 00h, 01h, 00h
		db	 01h, 01h, 01h, 01h, 01h, 01h
		db	 02h, 
		
v4477		dw	offset v445f

v4479		db	06h, 0 ;@4479-7a
v447b		dw	0
v447d		dw	0
v447f		db	0
v4480		db	0		
v4481		dw	0
v4483		dw	0
v4485		dw	0
v4487 		dw	0


		db	 05h, 02h, 00h, 00h,0F8h,0FFh
		db	 34h, 01h,0B4h, 00h, 99h
		db	44h
v4495		dw	0
		
v4497		dw	0
		db	20 dup (0)

v44ad		db	 04h, 03h, 0Fh, 0Bh, 00h, 00h
		db	 00h, 00h, 00h, 00h,0FFh,0BBh
		db	0FFh,0BBh,0FFh,0BBh,0FFh,0BBh
		db	 0Fh, 0Bh, 00h, 00h, 00h, 00h
		db	 00h, 00h
		
v44c7		db	05h, 03h, 00h, 00h
		db	0F0h,0B0h, 00h, 00h, 00h, 00h
		db	 00h, 00h, 0Fh, 0Bh,0FFh,0BBh
		db	0FFh,0BBh,0FFh,0BBh,0F0h,0B0h
		db	 00h, 00h,0F0h,0B0h, 00h, 00h
		db	 00h, 00h, 00h, 00h
		
v44e7		db	04h, 03h
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	0F0h,0B0h,0FFh,0BBh,0FFh,0BBh
		db	0FFh,0BBh,0FFh,0BBh, 00h, 00h
		db	 00h, 00h, 00h, 00h,0F0h,0B0h

v4501		db	 05h, 03h, 00h, 00h, 00h, 00h
		db	 00h, 00h, 0Fh, 0Bh, 00h, 00h
		db	 0Fh, 0Bh,0FFh,0BBh,0FFh,0BBh
		db	0FFh,0BBh,0F0h,0B0h, 00h, 00h
		db	 00h, 00h, 00h, 00h, 0Fh, 0Bh
		db	 00h, 00h
v4521		db	01h, 01h, 00h
		db	12 dup (0)
loc_630:
		cmp	byte ptr ds:[4D82h],0
		jne	loc_631			; Jump if not equal
		mov	byte ptr ds:[4D82h],1
		nop
		cmp	byte ptr ds:[mon_type],0;[5d5]
		je	loc_631			; Jump if equal
		call	sub_30
loc_631:
		mov	bx, offset endflag + 06	;data_403e
		mov	bx,[bx]
                mov     word ptr ds:[vce6],bx
		call	sub_3
                mov     bx,word ptr ds:[vce6]
		mov	bx,[bx+1Ah]
		add	bx,3
		mov	cx,0Ah

locloop_632:
		cmp	word ptr [bx],0
		jne	loc_633			; Jump if not equal
		add	bx,4
		loop	locloop_632		; Loop if cx > 0

                mov     word ptr ds:[vcb4],0
loc_633:
		mov	bx,offset endflag + 0ah	;data_405e
		mov	bx,[bx]
		mov	dx,[bx+4]
		mov	bx,[bx+2]
                call    checkeol
		cmp	word ptr [bp],0
		jne	loc_634			; Jump if not equal
                mov     word ptr ds:[vcb6],0
loc_634:
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+6],0
                test    word ptr ds:[on_object],2
		jz	loc_635			; Jump if zero
		jmp	loc_714
loc_635:
                test    word ptr ds:[on_object],4
		jz	loc_636			; Jump if zero
		jmp	loc_689
loc_636:
		or	byte ptr ds:[v52C6],10h
                mov     ax,word ptr ds:[beatsme1]
		dec	ax
                mov     word ptr ds:[vcba],ax
                mov     ax,word ptr ds:[beatsme3]
		dec	ax
		mov	word ptr ds:[vCBC],ax
		cmp	byte ptr ds:[usejoystick],0
		je	loc_637			; Jump if equal
		call	readjoystick	;sub_44
		mov	ax,word ptr ds:[v52C2]
                mov     word ptr ds:[vcba],ax
		mov	ax,word ptr ds:[v52C4]
		mov	word ptr ds:[vCBC],ax
loc_637:
		cmp	byte ptr [keypress+key_space], 0	;data_299,0
		je	loc_638			; Jump if equal
		and	byte ptr ds:[v52C6],0EFh
loc_638:
		cmp	byte ptr [keypress+key_up],0	;data_300,0
		je	loc_639			; Jump if equal
                mov     ax,word ptr ds:[beatsme4]
		dec	ax
		mov	word ptr ds:[vCBC],ax
loc_639:
		cmp	byte ptr [keypress+key_down], 0	;data_303,0
		je	loc_640			; Jump if equal
                mov     ax,word ptr ds:[beatsme3]
		inc	ax
		mov	word ptr ds:[vCBC],ax
loc_640:
		cmp	byte ptr [keypress+key_left], 0	;data_301,0
		je	loc_641			; Jump if equal
                mov     ax,word ptr ds:[beatsme2]
		dec	ax
                mov     word ptr ds:[vcba],ax
loc_641:
		cmp	byte ptr [keypress+key_right], 0	;data_302,0
		je	loc_642			; Jump if equal
                mov     ax,word ptr ds:[beatsme1]
		inc	ax
                mov     word ptr ds:[vcba],ax
loc_642:
		test	byte ptr ds:[v52C6],10h
		jz	loc_643			; Jump if zero
		jmp	loc_649
loc_643:
                cmp     word ptr ds:[vcb4],0
		jne	loc_644			; Jump if not equal
                cmp     word ptr ds:[vcb6],0
		jne	loc_644			; Jump if not equal
		jmp	loc_649
loc_644:
                mov     bx,word ptr ds:[vce6]
		mov	word ptr ds:[vCD8],0
                or      word ptr ds:[on_object],4
                and     word ptr ds:[on_object],0FF7Fh
                and     word ptr ds:[on_object],0FFDFh
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme4]
		jge	loc_645			; Jump if > or =
		mov	word ptr [bx+8], offset ibmlogo6	;705Ah
		jmp	loc_647

loc_645:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme2]
		jge	loc_646			; Jump if > or =
		mov	word ptr [bx+8],offset ibmlogo12	;7246h
		jmp	loc_647

loc_646:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme1]
		jl	loc_648			; Jump if <
		mov	word ptr [bx+8], offset ibmlogo13	;7298h
loc_647:
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C88
                mov     word ptr ds:[stob], offset v6C98
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C96]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
		mov	word ptr ds:[somedata1], 1	;4D8Bh],1
		jmp	loc_689
loc_648:
                and     word ptr ds:[on_object],0FFFBh
		jmp	loc_662
loc_649:
                test    word ptr ds:[vcb4],1
		jnz	loc_650			; Jump if not zero
		jmp	loc_662
loc_650:
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme4]
		jle	loc_651			; Jump if < or =
		jmp	loc_661
loc_651:
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],0FFh
loc_652:
                test    word ptr ds:[on_object],80h
		jnz	loc_654			; Jump if not zero
                mov     bx, [somevar0]
loc_653:
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		cmp	byte ptr [di],1
		jne	loc_653			; Jump if not equal
		mov	ax,[di+2]
                mov     bx,word ptr ds:[vce6]
		call	sub_54
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],0Fh
		mov	bx,offset endflag + 8	;data_404e
		mov	bx,[bx]
;*		add	ax,4
		db	5, 4, 0			;  Fixup - byte match
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],7
		mov	bx,offset endflag + 0ah	;data_405e
		mov	bx,[bx]
		mov	[bx+2],ax
		mov	[bx+1Ch],ax
		add	word ptr [bx+1Ch],7
                or      word ptr ds:[on_object],80h
loc_654:
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo6	;705Ah
		jne	loc_655			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo7	;70ACh
		jmp	short loc_659
		db	90h
loc_655:
		cmp	ax, offset ibmlogo7	;70ACh
		jne	loc_656			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo8	;70FEh
		mov	[bx+0Ah],ax
		jmp	short loc_659
		db	90h
loc_656:
		cmp	ax, offset ibmlogo8	;70FEh
		jne	loc_658			; Jump if not equal
		mov	ax,[bx+0Ah]
		cmp	ax, offset ibmlogo7	;70ACh
		jne	loc_657			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo9	;7150h
		jmp	short loc_659
		db	90h
loc_657:
		mov	word ptr [bx+8], offset ibmlogo7	;70ACh
		jmp	short loc_659
		db	90h
loc_658:
		mov	word ptr [bx+8], offset ibmlogo8	;70FEh
		mov	[bx+0Ah],ax
loc_659:
                test    byte ptr [v6630],1
		jnz	loc_660			; Jump if not zero
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C82
                mov     word ptr ds:[stob], offset v6C86
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C84]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
loc_660:
		jmp	loc_676
loc_661:
		mov	ax,word ptr ds:[vCBC]
                cmp     ax,word ptr ds:[beatsme3]
		jl	loc_662			; Jump if <
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],1
		jmp	loc_652
loc_662:
                test    word ptr ds:[vcb4],4
		jz	loc_664			; Jump if zero
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],1
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo10	;71A2h
		jne	loc_663			; Jump if not equal
		mov	word ptr [bx+8],offset ibmlogo11	;71F4h
		jmp	short loc_666
		db	90h
loc_663:
		mov	word ptr [bx+8], offset ibmlogo10	;71A2h
		jmp	short loc_666
		db	90h
loc_664:
                test    word ptr ds:[vcb4],2
		jz	loc_666			; Jump if zero
                test    word ptr ds:[vcb4],1
		jnz	loc_666			; Jump if not zero
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+7],0FFh
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo10	;71A2h
		jne	loc_665			; Jump if not equal
		mov	word ptr [bx+8],offset ibmlogo11	;71F4h
		jmp	short loc_666
		db	90h
loc_665:
		mov	word ptr [bx+8], offset ibmlogo10	;71A2h
loc_666:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme2]
		jg	loc_669			; Jump if >
                test    word ptr ds:[vcb4],2
		jnz	loc_667			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jnz	loc_667			; Jump if not zero
		jmp	loc_674
loc_667:
                and     word ptr ds:[on_object],0FF7Fh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],0FFh
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo2	;6F12h
		jne	loc_668			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo3	;6F64h
		jmp	short loc_672
		db	90h
loc_668:
		mov	word ptr [bx+8], offset ibmlogo2	;6F12h
		jmp	short loc_672
		db	90h
loc_669:
                mov     ax,word ptr ds:[vcba]
                cmp     ax,word ptr ds:[beatsme1]
		jl	loc_674			; Jump if <
                test    word ptr ds:[vcb4],2
		jnz	loc_670			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jz	loc_674			; Jump if zero
loc_670:
                and     word ptr ds:[on_object],0FF7Fh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],1
		mov	ax,[bx+8]
		cmp	ax, offset ibmlogo4	;6FB6h
		jne	loc_671			; Jump if not equal
		mov	word ptr [bx+8], offset ibmlogo5	;7008h
		jmp	short loc_672
		db	90h
loc_671:
		mov	word ptr [bx+8], offset ibmlogo4	;6FB6h
loc_672:
                test    byte ptr [v6630],1
		jnz	loc_673			; Jump if not zero
		cli				; Disable interrupts
                mov     word ptr ds:[sto7], offset v6C7C
                mov     word ptr ds:[stob], offset v6C80
                mov     sto1,0FFFEh
		mov	ax,word ptr ds:[v6C7E]
                mov     word ptr ds:[stoa],ax
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
loc_673:
		jmp	short loc_676
		db	90h
loc_674:
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+6],0
                test    word ptr ds:[vcb4],1
		jnz	loc_675			; Jump if not zero
                cmp     word ptr ds:[vcb4],0
		jne	loc_676			; Jump if not equal
		mov	word ptr [bx+8],offset IBMlogo1	;6EC0h
		mov	byte ptr [bx+7],0
		jmp	short loc_676
		db	90h
loc_675:
		mov	byte ptr [bx+7],0
		mov	word ptr [bx+8], offset ibmlogo6	 ; 705Ah
loc_676:
                mov     bx,word ptr ds:[vce6]
		call	sub_51
		call	sub_2
		call	sub_3
		mov	bx,offset endflag + 0ah	;data_405e
		mov	bx,[bx]
		mov	dx,[bx+4]
		mov	bx,[bx+2]
                call    checkeol
		cmp	word ptr [bp],0
		jne	loc_677			; Jump if not equal
                mov     word ptr ds:[vcb6],0
loc_677:
                test    word ptr ds:[vcb4],8
		jz	loc_678			; Jump if zero
		jmp	loc_688
loc_678:
                mov     bx,word ptr ds:[vce6]
		mov	bx,[bx+1Ah]
		add	bx,3
		mov	cx,0Ah

locloop_679:
		cmp	word ptr [bx],0
		jne	loc_680			; Jump if not equal
		add	bx,4
		loop	locloop_679		; Loop if cx > 0

                mov     word ptr ds:[vcb4],0
loc_680:
                cmp     word ptr ds:[vcb4],0
		jne	loc_681			; Jump if not equal
                test    word ptr ds:[vcb6],2
		jz	loc_682			; Jump if zero
loc_681:
                and     word ptr ds:[on_object],0FFFEh
		jmp	loc_ret_733
loc_682:
                test    word ptr ds:[on_object],1
		jnz	loc_688			; Jump if not zero
                or      word ptr ds:[on_object],1
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+6],100h
                call    putplayer
		call	sub_53
		call	sub_51
		call	sub_2
		call	sub_3
                mov     bx,word ptr ds:[vce6]
		mov	bx,[bx+1Ah]
		add	bx,3
		mov	cx,0Ah

locloop_683:
		cmp	word ptr [bx],0
		jne	loc_684			; Jump if not equal
		add	bx,4
		loop	locloop_683		; Loop if cx > 0

                mov     word ptr ds:[vcb4],0
loc_684:
		mov	bx,offset endflag + 0ah	;data_405e
		mov	bx,[bx]
		mov	dx,[bx+4]
		mov	bx,[bx+2]
                call    checkeol
		cmp	word ptr [bp],0
		jne	loc_685			; Jump if not equal
                mov     word ptr ds:[vcb6],0
loc_685:
                cmp     word ptr ds:[vcb4],0
		jne	loc_686			; Jump if not equal
                cmp     word ptr ds:[vcb6],0
		je	loc_687			; Jump if equal
loc_686:
                and     word ptr ds:[on_object],0FFFEh
loc_687:
		jmp	loc_ret_733
loc_688:
                and     word ptr ds:[on_object],0FBFFh
                and     word ptr ds:[on_object],0FFFBh
                and     word ptr ds:[on_object],0F7FFh
                or      word ptr ds:[on_object],2
                mov     ah,byte ptr ds:[v5e1]
                mov     byte ptr ds:[v5d4],ah
                mov     byte ptr ds:[v5e1],2
                mov     bx,word ptr ds:[vce6]
		mov	word ptr [bx+18h],0ACh
		jmp	loc_ret_733
loc_689:
		cmp	word ptr ds:[somedata1],1	;4D8Bh],1
		jne	loc_690			; Jump if not equal
                mov     bx,word ptr ds:[vce6]
		mov	ax,[bx+2]
                mov     word ptr ds:[somedata3],ax      ;4d85h]
		mov	ax,[bx+4]
;*		add	ax,8
		db	5, 8, 0			;  Fixup - byte match
                mov     word ptr ds:[somedata2], ax     ;4D87h],ax
                mov     word ptr ds:[somedata1], offset moredata0 ;4da3h  ;4D8Bh],4DA3h
		mov	bx,4D83h
		call	sub_51
		jmp	short loc_691
		db	90h
loc_690:
                cmp     word ptr ds:[somedata1], offset moredata0 ;4da3h  ;4D8Bh],4DA3h
		jne	loc_691			; Jump if not equal
                mov     word ptr ds:[somedata1], offset moredata1 ;4dc5h  ;4D8Bh],4DC5h
		mov	bx,4D83h
		call	sub_51
		mov	word ptr ds:[somedata1], 0	;4D8Bh],0
loc_691:
		cmp	word ptr ds:[vCD8],0Dh
		jne	loc_692			; Jump if not equal
		jmp	loc_704
loc_692:
		cmp	word ptr ds:[vCD8],5
		jge	loc_693			; Jump if > or =
		jmp	loc_701
loc_693:
		call	sub_3
                mov     bx,word ptr ds:[vce6]
		mov	bx,[bx+1Ah]
		add	bx,3
		mov	cx,0Ah

locloop_694:
		cmp	word ptr [bx],0
		jne	loc_695			; Jump if not equal
		add	bx,4
		loop	locloop_694		; Loop if cx > 0

                mov     word ptr ds:[vcb4],0
loc_695:
		mov	bx,offset endflag + 0ah	;data_405e
		mov	bx,[bx]
		mov	dx,[bx+4]
		mov	bx,[bx+2]
                call    checkeol
		cmp	word ptr [bp],0
		jne	loc_696			; Jump if not equal
                mov     word ptr ds:[vcb6],0
loc_696:
                test    word ptr ds:[on_object],20h
		jnz	loc_697			; Jump if not zero
                test    word ptr ds:[vcb4],1
		jz	loc_699			; Jump if zero
                test    word ptr ds:[on_object],10h
		jnz	loc_699			; Jump if not zero
                or      word ptr ds:[on_object],20h
		jmp	loc_699
loc_697:
                mov     bx, [somevar0]
loc_698:
		dec	bx
		dec	bx
		mov	di,[somevar1+bx]	;data_258[bx]
		cmp	byte ptr [di],1
		jne	loc_698			; Jump if not equal
                mov     bx,word ptr ds:[vce6]
		mov	ax,[bx+2]
		cmp	ax,[di+2]
		je	loc_704			; Jump if equal
loc_699:
                test    word ptr ds:[vcb4],4
		jz	loc_700			; Jump if zero
                test    word ptr ds:[on_object],8
		jz	loc_704			; Jump if zero
loc_700:
                test    word ptr ds:[vcb4],2
		jnz	loc_704			; Jump if not zero
                test    word ptr ds:[vcb6],2
		jnz	loc_704			; Jump if not zero
loc_701:
                mov     bx,word ptr ds:[vce6]
		mov	di,word ptr ds:[vCD8]
                mov     al,byte ptr ds:[vCBE][di]
		mov	[bx+7],al
                mov     al,byte ptr ds:[vCCB][di]
		mov	[bx+11h],al
		cmp	word ptr [bx+8], offset ibmlogo6	;705Ah
		jne	loc_702			; Jump if not equal
		mov	byte ptr [bx+6],0
		jmp	short loc_705
loc_702:
		cmp	word ptr [bx+8],offset ibmlogo12	;7246h
		jne	loc_703			; Jump if not equal
		mov	byte ptr [bx+6],0FFh
		jmp	loc_705
loc_703:
		mov	byte ptr [bx+6],1
		jmp	loc_705
loc_704:
                and     word ptr ds:[on_object],0FFFBh
                mov     bx,word ptr ds:[vce6]
		mov	byte ptr [bx+11h],2
		jmp	loc_676
loc_705:
                test    word ptr ds:[vcb4],1
		jz	loc_706			; Jump if zero
                or      word ptr ds:[on_object],10h
		jmp	loc_707
loc_706:
                and     word ptr ds:[on_object],0FFEFh
loc_707:
                test    word ptr ds:[vcb4],4
		jz	loc_708			; Jump if zero
                or      word ptr ds:[on_object],8
		jmp     loc_709
loc_708:
                and     word ptr ds:[on_object],0FFF7h
loc_709:
		call	sub_51
		call	sub_2
		call	sub_3
		mov	bx,offset endflag + 0ah	;data_405e
		mov	bx,[bx]
		mov	dx,[bx+4]
		mov	bx,[bx+2]
                call    checkeol
		cmp	word ptr [bp],0
		jne	loc_710			; Jump if not equal
                mov     word ptr ds:[vcb6],0
loc_710:
		inc	word ptr ds:[vCD8]
                test    word ptr ds:[vcb4],8
		jz	loc_711			; Jump if zero
		jmp	loc_688
loc_711:
                mov     bx,word ptr ds:[vce6]
		mov	bx,[bx+1Ah]
		add	bx,3
		mov	cx,0Ah

locloop_712:
		cmp	word ptr [bx],0
		jne	loc_713			; Jump if not equal
		add	bx,4
		loop	locloop_712		; Loop if cx > 0

                mov     word ptr ds:[vcb4],0
loc_713:
		jmp	loc_ret_733
loc_714:
		cmp	word ptr ds:[somedata1], 1	;4D8Bh],1
		jne	loc_715			; Jump if not equal
                mov     bx,word ptr ds:[vce6]
		mov	ax,[bx+2]
                mov     word ptr ds:[somedata3],ax
		mov	ax,[bx+4]
;*		add	ax,8
		db	5, 8, 0			;  Fixup - byte match
                mov     word ptr ds:[somedata2],ax
                mov     word ptr ds:[somedata1], offset moredata0 ;4da3h  ;4D8Bh],4DA3h
		mov	bx,4D83h
		call	sub_51
		jmp	short loc_716
		db	90h
loc_715:
                cmp     word ptr ds:[somedata1], offset moredata0 ;4da3h  ;4D8Bh],4DA3h
		jne	loc_716			; Jump if not equal
                mov     word ptr ds:[somedata1], offset moredata1       ;4dc5h  ;4D8Bh],4DC5h
		mov	bx,4D83h
		call	sub_51
		mov	word ptr ds:[somedata1], 0	;4D8Bh],0
loc_716:
                mov     bx,word ptr ds:[vce6]
                test    word ptr ds:[on_object],40h
		jz	loc_717			; Jump if zero
		jmp	loc_728
loc_717:
		mov	word ptr [bx+6],100h
		mov	word ptr [bx+10h],204h
		cmp	word ptr [bx+8],offset ibmlogo14	;72EAh
		je	loc_718			; Jump if equal
		cmp	word ptr [bx+8],offset ibmlogo15	;733Ch
		je	loc_718			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo16	;738Eh
		je	loc_718			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo17	;73E0h
		je	loc_718			; Jump if equal
		mov	word ptr [bx+8],offset ibmlogo14	;72EAh
loc_718:
		call	sub_51
		call	sub_2
		call	sub_3
                mov     bx,word ptr ds:[vce6]
		mov	bx,[bx+1Ah]
		add	bx,3
		mov	cx,0Ah

locloop_719:
		cmp	word ptr [bx],0
		jne	loc_720			; Jump if not equal
		add	bx,4
		loop	locloop_719		; Loop if cx > 0

                mov     word ptr ds:[vcb4],0
loc_720:
		mov	bx,offset endflag + 0ah	;data_405e
		mov	bx,[bx]
		mov	dx,[bx+4]
		mov	bx,[bx+2]
                call    checkeol
		cmp	word ptr [bp],0
		jne	loc_721			; Jump if not equal
                mov     word ptr ds:[vcb6],0
loc_721:
                mov     bx,word ptr ds:[vce6]
		mov	ax,[bx+18h]
		cmp	ax,[bx+4]
		jne	loc_722			; Jump if not equal
                or      word ptr ds:[on_object],100h
		jmp	loc_ret_733
loc_722:
                test    word ptr ds:[on_object],40h
		jz	loc_723			; Jump if zero
		jmp	loc_ret_733
loc_723:
                cmp     word ptr ds:[vcb4],0
		jne	loc_724			; Jump if not equal
		jmp	loc_ret_733
loc_724:
		cli				; Disable interrupts
                mov     word ptr ds:[sto7],offset something0	;6EB2h
                mov     word ptr ds:[stob],offset something1	;6EB6h
		mov	ax,data_332
                mov     word ptr ds:[stoa],ax
                mov     sto1,0FFFEh
                mov     byte ptr ds:[sto8],1
                or      byte ptr [v6630],1
		sti				; Enable interrupts
		mov	word ptr ds:[vCE4],0
                or      word ptr ds:[on_object],40h
loc_725:
                call    gettimestamp
		and	dh,3
		cmp	dh,2
		jg	loc_725			; Jump if >
		cmp	dh,0
		jne	loc_726			; Jump if not equal
		mov	byte ptr ds:[vCDA],0
		jmp	short loc_ret_733
		db	90h
loc_726:
		cmp	dh,1
		jne	loc_727			; Jump if not equal
		mov	byte ptr ds:[vCDA],1
		jmp	short loc_ret_733
		db	90h
loc_727:
		mov	byte ptr ds:[vCDA],0FFh
		jmp	short loc_ret_733
		db	90h
loc_728:
		cmp	word ptr ds:[vCE4],9
		je	loc_732			; Jump if equal
		mov	di,word ptr ds:[vCE4]
		mov	al,byte ptr ds:[vCDA]
		mov	[bx+6],al
		mov	al,byte ptr ds:[vCDB][di]
		mov	[bx+7],al
		inc	word ptr ds:[vCE4]
		cmp	word ptr [bx+8], offset ibmlogo14	;72EAh
		je	loc_729			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo15	;733Ch
		je	loc_730			; Jump if equal
		cmp	word ptr [bx+8], offset ibmlogo16	;738Eh
		je	loc_731			; Jump if equal
		mov	word ptr [bx+8], offset ibmlogo14	;72EAh
		jmp	loc_718
loc_729:
		mov	word ptr [bx+8], offset ibmlogo15	;733Ch
		jmp	loc_718
loc_730:
		mov	word ptr [bx+8], offset ibmlogo16	;738Eh
		jmp	loc_718
loc_731:
		mov	word ptr [bx+8], offset ibmlogo17	;73E0h
		jmp	loc_718
loc_732:
                and     word ptr ds:[on_object],0FFBFh
		jmp	loc_714

loc_ret_733:
		retn

;
;                              SUBROUTINE
;

sub_30		proc	near
		push	ax
		push	bx
		push	cx
		push	dx
		push	di
		mov	di, offset somedata	;4D7Eh
loc_734:
		mov	bx,[di]
		cmp	bx,0FFFFh
		jz	loc_739			; Jump if zero
		mov	dl,[bx]
		mov	cl,[bx+1]
		xor	ch,ch			; Zero register
		xor	dh,dh			; Zero register
		xor	ax,ax			; Zero register

locloop_735:
		add	ax,dx
		loop	locloop_735		; Loop if cx > 0

		mov	cx,ax
		add	bx,3

locloop_736:
		mov	al,[bx]
		test	al,0F0h
		jz	loc_737			; Jump if zero
		and	byte ptr [bx],0Fh
loc_737:
		test	al,0Fh
		jz	loc_738			; Jump if zero
		and	byte ptr [bx],0F0h
loc_738:
		add	bx,2
		loop	locloop_736		; Loop if cx > 0

		add	di,2
		jmp	short loc_734
loc_739:
		pop	di
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		retn
sub_30		endp

somedata	dw	offset moredata0	;@4d7e	(was 4da3)
		dw	0FFFFh
		db	00h


		dw	0			;@4d83-4
somedata3       dw      0                       ;@4d85-6
somedata2       dw      0                       ;@4d87-8
		dw	0			;@4d89-a
somedata1	dw	0			;@4d8b-c

		db	12 dup (0)		;@4d8d->
		db	 3Ch, 01h,0B6h, 00h, 00h, 00h
		db	 00h, 00h, 00h, 00h
		
moredata0	db	04h, 04h			;@4da3
		db	0FFh, 11h,0FFh, 11h,0FFh, 11h
		db	0FFh, 11h, 00h, 00h,0FFh, 11h
		db	0FFh, 11h, 00h, 00h, 0Fh, 01h
		db	 0Fh, 01h,0F0h, 10h,0F0h, 10h
		db	0F0h, 10h, 0Fh, 01h,0F0h, 10h
                db       0Fh, 01h

moredata1       db      04h, 04h,0FFh                   ;@4dc5
		db	7 dup (0FFh)
		db	 00h, 00h,0FFh,0FFh,0FFh,0FFh
		db	 00h, 00h, 0Fh, 0Fh, 0Fh, 0Fh
		db	0F0h,0F0h,0F0h,0F0h,0F0h,0F0h
		db	 0Fh, 0Fh,0F0h,0F0h, 0Fh, 0Fh
		db	9 dup (0)

;
; checkeol (sub_31)           SUBROUTINE
;
;unknown purpose
; looks like it may check to see if a graphic is to be placed off the screen
; and wrap it if so?
; BP and DX are required in entry



checkeol          proc    near
;loc_740:
		push	bx
		push	bx
		mov	bx, dx
		shl	bx, 1			; mul *2 make word ptr?
		mov	bp, word ptr ds:[bx+wacked1] ;[5445h][bx]=0
		pop	bx
		test	bx, 8000h
		jz	loc_742			; Jump if zero
		cmp	bp, 2000h
		jl	loc_741			; Jump if <
		sub	bp, 3FB0h
loc_741:
		add	bp, 1FB0h
		add	bx, 140h     ;=320d  next line on gfx maybe?
loc_742:
		sar	bx, 1			; Shift w/sign fill
		sar	bx, 1			; Shift w/sign fill
		add	bp, bx
		pop	bx
		retn




		;? 

		push	bx
		mov	bx,dx
		shl	bx,1			; Shift w/zeros fill
		mov	bp,word ptr ds:[bx+wacked1]	;[5445h][bx]
		pop	bx
		add	bp,bx
		retn
			                        ;* No entry point to code
		push	es
		push	bp
		push	cx
		push	bx
		push	ax
                mov     ax,word ptr ds:[startseg]
		mov	es,ax
                call    checkeol
		and	bx,3
		mov	al,byte ptr ds:[bx+wacked2]	;53E8h][bx]
		mov	ah,es:[bp]
		and	ah,al
		mov	bx,cx
		mov	cl,byte ptr ds:[bx+wacked0]	; 53ECh][bx]
		not	al
		and	cl,al
		or	ah,cl
		mov	es:[bp],ah
		pop	ax
		pop	bx
		pop	cx
		pop	bp
		pop	es
		retn
checkeol          endp

;
;                              SUBROUTINE
;

sub_32		proc	near
		push	bp
		push	bx
		push	ax
		and	bx, 3
		mov	al, byte ptr ds:[bx+wacked2]	;[53E8h][bx]
		mov	ah, es:[bp]
		and	ah, al
		mov	bx, cx
		not	al
		and	bl, al
		or	ah, bl
		mov	es: [bp],ah
		pop	ax
		pop	bx
		pop	bp
		retn
sub_32		endp

		db	0, 0, 0, 0

;
;                              SUBROUTINE
;

sub_33		proc	near
		push	bp
		push	ax
		sub	ax,dx
		inc	ax
                call    checkeol
loc_743:
		call	sub_32
		cmp	bp,2000h
		jl	loc_744			; Jump if <
		sub	bp,3FB0h
loc_744:
		add	bp,2000h
		dec	ax
		jnz	loc_743			; Jump if not zero
		pop	ax
		pop	bp
		retn
sub_33		endp


;
;                              SUBROUTINE
;

sub_34		proc	near
		push	di
		push	bp
		push	dx
		push	cx
		push	bx
		push	ax
                call    checkeol
		mov	dh,cl
		sub	ax,bx
		inc	ax
		and	bx,3
loc_745:
		cmp	bx, 0
		je	loc_747			; Jump if equal
		call	sub_32
		dec	ax
		jz	loc_749			; Jump if zero
		inc	bx
		and	bx,3
		cmp	bx,0
		jne	loc_746			; Jump if not equal
		inc	bp
loc_746:
		jmp	short loc_745
loc_747:
		mov	cx, ax
		mov	al, dh
		mov	bx, cx
		shr	cx, 1			; Shift w/zeros fill
		shr	cx, 1			; Shift w/zeros fill
		cmp	cx, 0
		mov	di, bp
		jz	loc_748			; Jump if zero
		rep	stosb			; Rep when cx >0 Store al to es:[di]
loc_748:
		and	bx, 3
		shl	bx, 1			; Shift w/zeros fill
		mov	ah, byte ptr ds:[bx+wacked3]	;53DFh][bx]=0
		mov	al, es:[di]		;=be
		and	dh, ah
		not	ah
		and	al, ah
		or	al, dh
		stosb				; Store al to es:[di]
loc_749:
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	bp
		pop	di
		retn
sub_34		endp

			                        ;* No entry point to code
		push	es
		push	dx
		push	cx
		push	bx
		push	ax
                mov     ax,word ptr ds:[startseg]
		mov	es,ax
		mov	bx,word ptr ds:[dunno8]		;data_242
		xor	cx,cx			; Zero register
		mov	cl,byte ptr ds:[bx+wacked0]	;[53ECh][bx]
		mov	dx,word ptr ds:[dunno5]
		mov	bx,word ptr ds:[dunno4]
		mov	ax,word ptr ds:[dunno7]	;data_241
		cmp	dx,ax
		jl	loc_750			; Jump if <
		xchg	dx,ax
loc_750:
		call	sub_33
		mov	bx,word ptr ds:[dunno6]		;data_240
		call	sub_33
		mov	ax,word ptr ds:[dunno4]
		cmp	bx,ax
		jl	loc_751			; Jump if <
		xchg	bx,ax
loc_751:
		mov	dx,word ptr ds:[dunno5]
		call	sub_34
		mov	dx,word ptr ds:[dunno7]	;data_241
		call	sub_34
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	es
		retn

;
;                              SUBROUTINE
;

sub_35		proc	near
;loc_752:
		push	es
		push	bp
		push	dx
		push	cx
		push	bx
		push	ax
                mov     ax,word ptr ds:[startseg]  ;stack
		mov	es,ax
		mov	bx,word ptr ds:[dunno8]	;data_242=0 (offset prolly)
		xor	cx,cx			; 
		mov	cl,byte ptr ds:[bx+wacked0] ;[53ECh][bx]=0
		mov	ax,word ptr ds:[dunno6]		;data_240 =13f
		mov	bx,word ptr ds:[dunno4]		;=0 start?
		cmp	bx,ax				;   end?
		jl	loc_753			; Jump if <
		xchg	bx,ax
loc_753:
		mov	bp, word ptr ds:[dunno7]	;data_241=b5
		mov	dx,word ptr ds:[dunno5]		;=0
		cmp	dx,bp
		jl	loc_754			; Jump if <
		xchg	bp,dx
loc_754:
		sub	bp,dx
		inc	bp
loc_755:
		call	sub_34
		inc	dx
		dec	bp
		jnz	loc_755			; Jump if not zero
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	bp
		pop	es
		retn
sub_35		endp


;
;                              SUBROUTINE
;

; display graphics to screen

putagfxlogo          proc    near
		push	di
		push	si
		push	bp
		push	dx
		push	cx
		push	bx
		push	ax
		cld				; Clear direction
                mov     bx, word ptr ds:[xpos]
                mov     dx, word ptr ds:[ypos]  ; 
                mov     si, word ptr ds:[gfxoffset]  ;0
                mov     ax, word ptr ds:[dunno0b]  ;0
                mov     di, word ptr ds:[dunno0a]  ; 0  ; 538b
		mov	cx, [si]			; count = 15c
                mov     word ptr ds:[dunno0c], cx   	; save count
		mov	cx, [si+2]	     		;=2c
		cmp	ah, 0
		je	loc_756				; Jump if equal
		
		mov	[di+2],cx
		push	cx
                mov     cx, word ptr ds:[dunno0c]  	; restore count
		mov	[di], cx
		pop	cx
loc_756:
		mov	ch, cl
		push	bx
		and	bx, 3
		mov	cl, bl
		shl	cl, 1				; 
                mov     bx, word ptr es:[dunno0c] 	; get count
		add	bx, 7				; add 7
		shr	bx, 1				; multiply * 8
		shr	bx, 1				; 
		shr	bx, 1				; 
		cmp	cl, 0
		je	loc_758				; Jump if equal
		
		push	cx
                add     cx, word ptr es:[dunno0c] ;=15c	; + count
		cmp	cx, 9
		jl	loc_757				; Jump if <
		inc	bl
loc_757:
		pop	cx
loc_758:
		mov	byte ptr ds:[dunno0byte],bl	; 5391=0
		pop	bx
                call    checkeol
		add	si,4
		add	di,4
                mov     bx,word ptr ds:[dunno0b]   ;=538d=0
		xor	bh,bh			; Zero register
		cmp	bl,3
		jle	loc_759			; Jump if < or =
		xor	bl,bl			; Zero register
loc_759:
		
		cmp	bl, byte ptr [v53a6]    ;=0 53a6 data_243
		je	loc_760			; Jump if equal
		jmp	short loc_764
		
loc_760:
		call	sub_37
		call	sub_38
                mov     bx, word ptr ds:[dunno0b]
		cmp	bh, 0			; blank line?
		je	loc_761			; Jump if equal
		call	putgraphics		; display actual graphics
loc_761:
		cmp	bp,2000h
		jl	loc_762			; Jump if <
		sub	bp,1FB0h
		jmp	loc_763
		
loc_762:
		add	bp,2000h
loc_763:
		dec	ch
		jnz	loc_760			; Jump if not zero
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	bp
		pop	si
		pop	di
		retn
loc_764:
		mov	[v53a6], bl		; data_243,bl
		shl	bl,1			; Shift w/zeros fill
		push	cx
		push	si
		push	di
		add	bx, 53D7h
		mov	si,[bx]
		mov	di, 510Fh
		mov	cx, 3
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		mov	di, 5128h
		mov	cx, 6
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		mov	di, 514Bh
		mov	cx, 3
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		pop	di
		pop	si
		pop	cx
		jmp	short loc_760
putagfxlogo          endp


;
;                              SUBROUTINE
;

sub_37		proc	near
		push	di
                mov     dx, word ptr ds:[dunno0c] ; = 15c (counter)
		xor	bx, bx			; Zero register
		mov	bh, byte ptr ds:[dunno0byte]	; 5391=2d
		mov	di, offset lottabytes ; data_251
		cmp	cl, 0
		je	loc_768			; Jump if equal
		xor	al, al			; Zero register
		mov	ah, [si]	    ;   =8792=0000FF*8...
		cmp	dx, 8
		jge	loc_765			; Jump if > or =
		xchg	bx,dx
		add	bx, word ptr ds:[wacked3] ;53DFh
		mov	dl, [bx]
		and	ah, dl
		xchg	bx, dx
loc_765:
		shr	ax, cl			; Shift w/zeros fill
		mov	[di], ah	       ;=55d5=0 (lottabytes)
		mov	bl, al
		inc	di
		inc	si
		dec	bh
		cmp	bh,1
		jle	loc_767			; Jump if < or =
		dec	bh
loc_766:
		xor	ax, ax			; Zero register
		mov	ah, [si]		; =8793=0,FF*8,0f...
		shr	ax, cl			; Shift w/zeros fill
		or	bl, ah
		mov	[di],bl			; 55d6=0
		mov	bl,al
		inc	di
		inc	si
		dec	bh
		jnz	loc_766			; Jump if not zero
loc_767:
		mov	es:[di],bl
		jmp	short loc_770

loc_768:
		cmp	dx,8
		jge	loc_769			; Jump if > or =
		mov	bx,dx
		add	bx,word ptr ds:[wacked3] ;53DFh
		mov	al,[si]
		mov	dl,[bx]
		and	al,dl
		mov	[di],al
		jmp	loc_770

loc_769:
		push	cx
		mov	cl,bh
		xor	ch,ch			; Zero register
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		pop	cx
loc_770:
		pop	di
		retn
sub_37		endp


;
;                              SUBROUTINE
;
; draws graphics on the screen

sub_38		proc	near
		push	es
		push	di
		push	si
		mov	si,offset lottabytes	;data_251
                mov     ax,word ptr ds:[startseg]
		mov	es,ax
		mov	di,bp
		mov	bx,cx
		xor	bh,bh			; Zero register
		add	bx,word ptr ds:[wacked3] ;53DFh
		mov	dl,[bx]
                mov     bx,word ptr ds:[dunno0c]
		mov	al,es:[di]
		mov	ah,[si]
		mov	[si],al
		cmp	bx,8
		jge	loc_771			; Jump if > or =
		mov	dh,bl
		add	dh,cl
		cmp	dh,8
		jge	loc_771			; Jump if > or =
		push	bx
		mov	bl,dh
		add	bx,word ptr ds:[wacked3] ;53DFh
		mov	dh,[bx]
		not	dh
		or	dl,dh
		pop	bx
loc_771:
		and	al,dl
		or	ah,al
		mov	es:[di],ah
		inc	si
		inc	di
		mov	dl,8
		xor	dh,dh			; Zero register
		sub	dl,cl
		sub	bx,dx
		cmp	bx,8
		jl	loc_773			; Jump if <
loc_772:
		mov	al,es:[di]
		nop
		nop
		nop
		nop
		nop
		nop
		movsb				; Mov [si] to es:[di]
		mov	[si-1],al
		sub	bx,8
		cmp	bx,7
		jg	loc_772			; Jump if >
loc_773:
		mov	ah,[si]
		add	bx,word ptr ds:[wacked3]	;53DFh
		mov	dl,[bx]
		and	ah,dl
		mov	al,es:[di]
		mov	[si],al
		not	dl
		and	al,dl
		or	ah,al
		mov	es:[di],ah
		pop	si
		pop	di
		pop	es
		retn
sub_38		endp


;
;                              SUBROUTINE
;

putgraphics		proc	near
		push	si
		xor	bx,bx			; Zero register
		mov	bh,byte ptr ds:[dunno0byte] ;5391
		mov	si,offset lottabytes	;data_251
		cmp	cl,0
		je	loc_775			; Jump if equal
		xor	al,al			; Zero register
		mov	ah,[si]
		mov	al,[si+1]
		shl	ax,cl			; Shift w/zeros fill
		mov	[di],ah
		mov	bl,al
		inc	di
		inc	si
		inc	si
		dec	bh
		dec	bh
		cmp	bh,1
		jl	loc_776			; Jump if <
loc_774:
		xor	ax,ax			; Zero register
		mov	al,[si]
		shl	ax,cl			; Shift w/zeros fill
		or	bl,ah
		mov	[di],bl
		mov	bl,al
		inc	di
		inc	si
		dec	bh
		jnz	loc_774			; Jump if not zero
		jmp	loc_776
		
loc_775:
		push	cx
		mov	cl,bh
		xor	ch,ch			; Zero register
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		pop	cx
loc_776:
		pop	si
		retn
putgraphics	endp


;
;                              SUBROUTINE
;

sub_40		proc	near
;loc_777:
		push	es
		push	si
		push	di
		push	bp
		push	dx
		push	cx
		push	bx
		push	ax
                mov     bx,word ptr ds:[xpos]
                mov     dx,word ptr ds:[ypos]
                call    checkeol
                mov     si,word ptr ds:[gfxoffset]
		mov	di,bp
		mov	cl,[si]
		inc	si
		mov	ch,[si]
		inc	si
                mov     ax,word ptr ds:[startseg]
		mov	es,ax
loc_778:
		push	di
		push	cx
		xor	ch,ch			; Zero register

locloop_779:
		mov	ah,es:[di]
		lodsb				; String [si] to al
		or	ah,al
		lodsb				; String [si] to al
		xor	ah,al
		mov	al,ah
		stosb				; Store al to es:[di]
		loop	locloop_779		; Loop if cx > 0

		pop	cx
		pop	di
		dec	ch
		jz	loc_781			; Jump if zero
		cmp	di,2000h
		jl	loc_780			; Jump if <
		sub	di,3FB0h
loc_780:
		add	di,2000h
		jmp	loc_778
loc_781:
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	bp
		pop	di
		pop	si
		pop	es
		retn
sub_40		endp


;
; clearscreen SUBROUTINE   uses screenchar variable for display value
;

clearscreen     proc    near
		push	es
		push	di
		push	cx
		push	ax
		mov	ax, word ptr ds:[VIDSEG]	; b800
		mov	es, ax
		mov	cx, 2000h
                mov     ax, word ptr ds:[screenchar] 	;<-0
		mov	di, 0
		rep	stosw				; 
		pop	ax
		pop	cx
		pop	di
		pop	es
		retn
clearscreen     endp


;
;                              SUBROUTINE
;

copy2screen     proc    near
;loc_782:
		push	es
		push	di
		push	si
		push	bp
		push	dx
		push	cx
		push	bx
		push	ax
                mov     bx, word ptr ds:[xpos] ;90
                mov     dx, word ptr ds:[ypos]        ;4b
                call    checkeol
                mov     si, word ptr ds:[gfxoffset]
		mov	di, bp
                mov     ax, word ptr ds:[startseg] ; b800h
		mov	es, ax
		mov	al, [si]
		inc	si
		mov	ah, [si]
		inc	si
		xor	cx, cx			; Zero register
loc_783:
		mov	cl, al
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		dec	ah
		jz	loc_785			; Jump if zero
		cmp	bp,2000h
		jl	loc_784			; Jump if <
		sub	bp,3FB0h
loc_784:
		add	bp,2000h
		mov	di,bp
		jmp	short loc_783
loc_785:
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	bp
		pop	si
		pop	di
		pop	es
		retn
copy2screen     endp


;
;                              SUBROUTINE
;

sub_43		proc	near
		push	ds
		push	di
		push	si
		push	bp
		push	dx
		push	cx
		push	bx
		push	ax
                mov     bx,word ptr ds:[xpos]
                mov     dx,word ptr ds:[ypos]
                call    checkeol
                mov     di,word ptr ds:[dunno0a] ; 538b
		mov	si,bp
                mov     ax,word ptr ds:[startseg]
		mov	ds,ax
		mov	al,es:[di]
		inc	di
		mov	ah,es:[di]
		inc	di
		xor	cx,cx			; Zero register
loc_786:
		mov	cl,al
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		dec	ah
		jz	loc_788			; Jump if zero
		cmp	bp,2000h
		jl	loc_787			; Jump if <
		sub	bp,3FB0h
loc_787:
		add	bp,2000h
		mov	si,bp
		jmp	short loc_786
loc_788:
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	bp
		pop	si
		pop	di
		pop	ds
		retn
sub_43		endp



; this is a small routine that never seems to get called.

		db	6
		dw	571Eh	
		dw	5156h	
		dw	3E8Bh	
		db	77h	
		db	 53h,0BEh, 00h, 00h, 8Bh, 0Eh
		db	 98h, 53h, 8Eh,0C1h, 8Bh, 0Eh
		db	 9Ah, 53h, 8Eh,0D9h,0B9h, 00h
		db	 40h,0F3h,0A4h, 59h, 5Eh, 5Fh
		db	 1Fh, 07h,0C3h 

		
		
v52c2		dw	0 
v52c4		dw	0 
v52c6		db	00h

;
;   sub_44                           SUBROUTINE
;

readjoystick	proc	near
		push	dx
		push	cx
		push	bx
		push	ax
		xor	ax,ax			; Zero register
		xor	bx,bx			; Zero register
		xor	cx,cx			; Zero register
		mov	word ptr ds:[v52C2],0
		mov	word ptr ds:[v52C4],0
		mov	dx,201h
		out	dx,al			; port 201h, start game 1-shots
		cli				; Disable interrupts
loc_789:
		in	al,dx			; port 201h, start game 1-shots
		test	al,3
		jz	loc_790			; Jump if zero
		ror	al,1			; Rotate
		adc	bx,0
		ror	al,1			; Rotate
		adc	cx,0
		jmp	loc_789
loc_790:
		sti				; Enable interrupts
		mov	word ptr ds:[v52C2],bx
		mov	word ptr ds:[v52C4],cx
		mov	byte ptr ds:[v52C6],al
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		retn
readjoystick	endp

			                        ;* No entry point to code
		push	ax
		mov	ax,4
		int	10h			; Video display   ah=functn 00h
						;  set display mode in al
		pop	ax
		retn
			                        ;* No entry point to code
		push	ax
		mov	ax,3
		int	10h			; Video display   ah=functn 00h
						;  set display mode in al
		pop	ax
		retn

;
;                              SUBROUTINE
;

put2screen      proc    near
		push	ds
		push	es
		push	di
		push	si
		push	dx
		push	cx
		push	ax
                mov     dx,word ptr ds:[dispstats0]    ; vertical count?
                mov     si,word ptr ds:[dispstats1]    ; startig offset?
                mov     di,word ptr ds:[dispstats2]    ; ending offset
		mov	ax,word ptr ds:[VIDSEG]	;539Ah]
		mov	es,ax
                mov     ax,word ptr ds:[startseg]
		mov	ds,ax
loc_792:
                mov     cx,word ptr cs:[gfxcount]
		push	di
		push	si
		rep	movsb			; Rep when cx >0 Mov [si] to es:[di]
		pop	si
		pop	di
		dec	dx
		jz	loc_795			; Jump if zero
		cmp	si,2000h
		jl	loc_793			; Jump if <
		sub	si,3FB0h
loc_793:
		add	si,2000h
		cmp	di,2000h
		jl	loc_794			; Jump if <
		sub	di,3FB0h
loc_794:
		add	di,2000h
		jmp	loc_792
loc_795:
		pop	ax
		pop	cx
		pop	dx
		pop	si
		pop	di
		pop	es
		pop	ds
		retn
put2screen      endp


;
;gettimestamp  SUBROUTINE returns a seemingly random # in DX
;

gettimestamp	proc	near

		push	ax
                mov     ax,word ptr ds:[timerval]
		mul	word ptr ds:[timermul]	; dx:ax = data * ax
		add	ax,569h
                mov     word ptr ds:[timerval],ax
		mov	dx,ax
		pop	ax
		retn
gettimestamp	endp


		dw	0
		dw	0
timerval	dw	1bh
timermul	dw	09d5h
		
                db      00h 
		db	01h 	; 5380
dispstats0	dw	0C8h	; 5381-2
dispstats1	dw	0	; 5383-4
dispstats2	dw	0  	; 5385-6
gfxcount      dw      50h     ; 5387-8
		


gfxoffset       dw      0	; 5389-8a
dunno0a         dw      0	; 538b-c
dunno0b         dw      0	; 538d-e
dunno0c         dw      0       ; 538f-90
dunno0byte	db	0	; 5391
xpos            dw      0	; 5392-3
ypos            dw      0	; 5394-5
		dw	0	; 5396-7
startseg        dw      0b800h  ; 5398-9        ; segment
VIDSEG		dw	0b800h	; 539a-b
dunno4		dw	0	; 539c-d
dunno5		dw	0	; 539e-f
dunno6		dw	0	; 53a0-1
dunno7		dw	0	; 53a2-3
dunno8		dw	0	; 53a4-5
v53a6		db      0	; 53a6
     		db	22h	; 53a7

		
		db 0C2h, 0Ah, 90h, 90h, 90h
		db	 90h, 90h, 90h, 22h,0C2h, 0Ah
		db	 90h, 90h, 32h, 8Ah, 24h, 32h
		db	0E0h, 88h, 24h, 90h, 90h, 32h
		db	 0Ah,0E2h, 22h, 8Ah, 24h, 22h
		db	0E0h, 88h, 24h, 0Ah,0E2h, 22h
		db	 90h, 90h, 0Ah, 8Ah, 24h, 0Ah
		db	0E0h, 88h, 24h, 90h, 90h, 0Ah
		db	0A7h, 53h,0B3h, 53h,0CBh, 53h
		db	0BFh 	;
		db	53h 	;
wacked3		db	00h 	; 53df
		db	80h	; 53e0
		db	0C0h	; 53e1
		db	0E0h	; 53e2
		db	0F0h	; 53e3
		db	0F8h	; 53e4
		db	0FCh	; 53e5
		db	0FEh	; 53e6
		db	0FFh 	; 53e7
wacked2		db	3Fh	; 53e8
		db	0CFh	; 53e9
		db	0F3h	; 53ea
		db	0FCh	; 53eb
wacked0		db	00h	; 53ec
		db	11h	; 53ed
		db	22h	; 53ef
		db	 33h, 44h, 55h, 66h, 77h, 88h
		db	 99h,0AAh,0BBh,0CCh,0DDh,0EEh
		db	0FFh,0D0h,0E0h, 55h,0AAh,0FFh
		db	 33h,0CCh, 0Fh,0F0h, 3Ch,0C3h
		db	 22h, 88h, 0Ah,0A0h, 28h, 82h
		db	 11h, 44h, 05h, 50h, 14h, 41h
		db	 77h,0DDh, 5Fh,0F5h, 7Dh,0D7h
		db	 66h, 99h, 5Ah,0A5h, 69h, 96h
		db	0BBh,0EEh,0AFh,0FAh,0BEh,0EBh
		db	 80h,0FDh, 80h, 1Dh,0D0h,0FDh
		db	0D0h, 1Dh, 20h,0FEh, 20h, 1Eh
		db	 70h,0FEh, 70h, 1Eh,0C0h,0FEh
		db	0C0h, 1Eh, 10h,0FFh, 10h, 1Fh
		db	 60h,0FFh, 60h, 1Fh,0B0h,0FFh
		db	0B0h, 1Fh

		
wacked1		dw	0 		; 5445
		db	00h, 20h
		db	 50h, 00h, 50h, 20h,0A0h, 00h
		db	0A0h, 20h,0F0h, 00h,0F0h, 20h
		db	 40h, 01h, 40h, 21h, 90h, 01h
		db	 90h, 21h,0E0h, 01h,0E0h, 21h
		db	 30h, 02h, 30h, 22h, 80h, 02h
		db	 80h, 22h,0D0h, 02h,0D0h, 22h
		db	 20h, 03h, 20h, 23h, 70h, 03h
		db	 70h, 23h,0C0h, 03h,0C0h, 23h
		db	 10h, 04h, 10h, 24h, 60h, 04h
		db	 60h, 24h,0B0h, 04h,0B0h, 24h
		db	 00h, 05h, 00h, 25h, 50h, 05h
		db	 50h, 25h,0A0h, 05h,0A0h, 25h
		db	0F0h, 05h,0F0h, 25h, 40h, 06h
		db	 40h, 26h, 90h, 06h, 90h, 26h
		db	0E0h, 06h,0E0h, 26h, 30h, 07h
		db	 30h, 27h, 80h, 07h, 80h, 27h
		db	0D0h, 07h,0D0h
		db	27h, ' ', 8, ' (p', 8, 'p('
		db	0C0h, 08h,0C0h, 28h, 10h, 09h
		db	 10h, 29h, 60h, 09h, 60h, 29h
		db	0B0h, 09h,0B0h, 29h, 00h, 0Ah
		db	 00h, 2Ah, 50h, 0Ah, 50h, 2Ah
		db	0A0h, 0Ah,0A0h, 2Ah,0F0h, 0Ah
		db	0F0h
		db	2Ah
		db	40h	; data 251
		db	 0Bh, 40h, 2Bh, 90h, 0Bh, 90h
		db	 2Bh,0E0h, 0Bh,0E0h, 2Bh, 30h
		db	 0Ch, 30h, 2Ch, 80h, 0Ch, 80h
		db	 2Ch,0D0h, 0Ch,0D0h
		db	', ', 0Dh, ' -p', 0Dh, 'p-'
		db	0C0h, 0Dh,0C0h, 2Dh, 10h, 0Eh
		db	 10h, 2Eh, 60h, 0Eh, 60h, 2Eh
		db	0B0h, 0Eh,0B0h, 2Eh, 00h, 0Fh
		db	 00h, 2Fh, 50h, 0Fh, 50h, 2Fh
		db	0A0h, 0Fh,0A0h, 2Fh,0F0h, 0Fh
		db	0F0h, 2Fh, 40h, 10h, 40h, 30h
		db	 90h, 10h, 90h, 30h,0E0h, 10h
		db	0E0h, 30h, 30h, 11h, 30h, 31h
		db	 80h, 11h, 80h, 31h,0D0h, 11h
		db	0D0h, 31h, 20h, 12h, 20h, 32h
		db	 70h, 12h, 70h, 32h,0C0h, 12h
		db	0C0h, 32h, 10h, 13h, 10h, 33h
		db	 60h, 13h, 60h, 33h,0B0h, 13h
		db	0B0h, 33h, 00h, 14h, 00h, 34h
		db	 50h, 14h, 50h, 34h,0A0h, 14h
		db	0A0h, 34h,0F0h, 14h,0F0h, 34h
		db	 40h, 15h, 40h, 35h, 90h, 15h
		db	 90h, 35h,0E0h, 15h,0E0h, 35h
		db	 30h, 16h, 30h, 36h, 80h, 16h
		db	 80h, 36h,0D0h, 16h,0D0h, 36h
		db	 20h, 17h, 20h, 37h, 70h, 17h
		db	 70h, 37h,0C0h, 17h,0C0h, 37h
		db	 10h, 18h, 10h
		db	38h
data_252	db	60h
		db	18h
data_253	dw	3860h
data_254	dw	18B0h
		db	0B0h, 38h, 00h, 19h, 00h, 39h
		db	 50h, 19h, 50h, 39h,0A0h, 19h
		db	0A0h, 39h,0F0h, 19h,0F0h, 39h
		db	 40h, 1Ah, 40h, 3Ah, 90h, 1Ah
		db	 90h, 3Ah,0E0h, 1Ah,0E0h, 3Ah
		db	 30h, 1Bh, 30h, 3Bh, 80h, 1Bh
		db	 80h, 3Bh,0D0h, 1Bh,0D0h, 3Bh
		db	 20h, 1Ch, 20h, 3Ch, 70h, 1Ch
		db	 70h, 3Ch,0C0h, 1Ch,0C0h, 3Ch
		db	 10h, 1Dh, 10h, 3Dh, 60h, 1Dh
		db	 60h, 3Dh,0B0h, 1Dh,0B0h, 3Dh
		db	 00h, 1Eh, 00h, 3Eh, 50h, 1Eh
		db	 50h, 3Eh,0A0h, 1Eh,0A0h, 3Eh
		db	0F0h, 1Eh,0F0h
		db	3Eh

lottabytes	db	91 dup (0)	;55d5

;
;                              SUBROUTINE
;

sub_47		proc	near

		push	si
		push	bx
		push	cx
                mov     si,offset tempvar0
		mov	bx,[si+2]
loc_798:
		cmp	bx,0
		je	loc_800			; Jump if equal
		cmp	ax,[bx]
		je	loc_799			; Jump if equal
		mov	si,bx
		mov	bx,[si+2]
		jmp	short loc_798
loc_799:
		mov	cx,[bx+2]
		mov	[si+2],cx
		mov	cx,data_254
		mov	[bx+2],cx
		mov	data_254,bx
loc_800:
		pop	cx
		pop	bx
		pop	si
		retn
sub_47		endp


;
;                              SUBROUTINE
;

sub_48_		proc	near
;loc_801:
		push	bx
		push	cx
		mov	word ptr ds:[tempvar],0 ;data_253,0   ;567f
		mov	bx,offset tempbuffer	;data_254
		add	bx,4
		mov	[bx-4],bx
		mov	cx,66h

@@:	
		mov	[bx-2],bx
		add	bx,4
		loop	@b	 	; Loop if cx > 0

		pop	cx
		pop	bx
		retn
sub_48_		endp


tempvar0	dw	0		; 567d-e
tempvar		dw	0 		; 567f-80
		
tempbuffer	dw	0
		db	309 dup (0)	; 5681->
		dw	0	;data_257	dw	0
data_258	dw	0			; Data table (indexed access)
		db	105 dup (0)

;
;                              SUBROUTINE
;

sub_49_		proc	near

		push	si
		push	di
		push	cx
		push	bx
		push	ax
		mov	si,offset tempvar0	; 567d data_252
		mov	bx,[si+2]
loc_804:
		cmp	bx,0
		je	loc_805			; Jump if equal
		mov	di, ax
		mov	cx, [di+2]
		mov	di, [bx]
		cmp	cx, [di+2]
		ja	loc_805			; Jump if above
		mov	si,bx
		mov	bx, [si+2]
		jmp	loc_804
loc_805:
		push	ax
		mov	di, [tempbuffer]	;=5681 data_254
		mov	ax, [di+2]
		mov	[tempbuffer], ax	; data_254, ax
		pop	ax
		mov	[si+2], di
		mov	[di+2], bx
		mov	[di], ax
		pop	ax
		pop	bx
		pop	cx
		pop	di
		pop	si
		retn
sub_49_		endp


;
;                              SUBROUTINE
;

sub_50		proc	near
;loc_806:
		push	si
		push	di
		push	bx
		push	ax
		mov	di,bx
                mov     [somevar0],0
		mov	si,offset tempvar0		;data_252
		mov	bx,[si+2]
loc_807:
		cmp	bx,0
		je	loc_809			; Jump if equal
		mov	si,[bx]
		cmp	di,si
		je	loc_808			; Jump if equal
		mov	ax,[di+1Ch]
		cmp	ax,[si+2]
		jl	loc_808			; Jump if <
		mov	ax,[di+2]
		cmp	ax,[si+1Ch]
		jg	loc_808			; Jump if >
		mov	ax,[di+1Eh]
		cmp	ax,[si+4]
		jl	loc_808			; Jump if <
		mov	ax,[di+4]
		cmp	ax,[si+1Eh]
		jg	loc_808			; Jump if >
		push	di
                mov     di, [somevar0]
		mov	[somevar1+di], si	;data_258[di],si
                add     [somevar0],2
		pop	di
loc_808:
		mov	bx,[bx+2]
		jmp	short loc_807
loc_809:
		pop	ax
		pop	bx
		pop	di
		pop	si
		retn
sub_50		endp

somevar0	dw	0  	; 58b8
somevar1	dw	0	; 58ba
		db	212 dup (0)

;
;                              SUBROUTINE
;

; this controls player motion somehow,

sub_51		proc	near
		push	si
		push	di
		push	dx
		push	cx
		push	bx
		push	ax
		mov	si,[bx+2]		;=0098
		mov	[v5fd5], si		;data_263,si ;5fd5
		mov	[v5fd3], si		;data_262,si
		mov	ax,[bx+4]
		mov	[v5fd7], ax		;data_264,ax
		mov	[v5fd9], ax		; data_265,ax
                mov     word ptr ds:[ypos],ax
		mov	dh,[bx+6]
		mov	dl,[bx+7]
		xor	ax,ax			; Zero register
		cmp	dh,0
		je	loc_812			; Jump if equal
		mov	ch,[bx+10h]
		cmp	dh,1
		je	loc_811			; Jump if equal
		mov	al,ch
		sub	si,ax
		mov	[v5fd5], si		; data_263,si
		mov	di,[bx+12h]
		cmp	si,di
		jge	loc_812			; Jump if > or =
		mov	si,di
		mov	[v5fd5], si		; data_263,si
		jmp	loc_812
loc_811:
		mov	al,ch
		add	si,ax
		mov	[v5fd3], si		; data_262,si
		mov	di,[bx+16h]
		cmp	si,di
		jle	loc_812			; Jump if < or =
		mov	si,di
                mov     [v5fd3],si
loc_812:
		mov	cx,si
		mov	[bx+2],si
		and	cx,3
                mov     word ptr ds:[xpos],si
		shl	cx,1			; Shift w/zeros fill
		add	cx,8
		add	bx,cx
		mov	ax,[bx]
                mov     word ptr ds:[gfxoffset],ax
		sub	bx,cx
		push	ax
		xor	ch,ch			; Zero register
                mov     ax,word ptr ds:[ypos]
		cmp	dl,0
		je	loc_814			; Jump if equal
		mov	cl,[bx+11h]
		cmp	dl,1
		je	loc_813			; Jump if equal
		sub	ax,cx
		mov	[v5fd7], ax		; data_264,ax
		mov	di,[bx+14h]
		cmp	ax,di
		jge	loc_814			; Jump if > or =
		mov	ax,di
		mov	[v5fd7], ax		; data_264,ax
		jmp	loc_814
		
loc_813:
		add	ax,cx
		mov	[v5fd9], ax		; data_265,ax
		mov	di,[bx+18h]
		cmp	ax,di
		jle	loc_814			; Jump if < or =
		mov	ax,di
		mov	[v5fd9], ax		; data_265,ax
loc_814:
                mov     word ptr ds:[ypos],ax
		mov	[bx+4],ax
		pop	di
		xor	ch,ch			; Zero register
		xor	dh,dh			; Zero register
		mov	cl,[bx+1]
		mov	dl,[di+1]
		push	si
		push	ax
		cmp	cl,0
		jne	loc_815			; Jump if not equal
		mov	cl,[di]
		shr	si,1			; Shift w/zeros fill
		shr	si,1			; Shift w/zeros fill
		add	si,cx
		shl	si,1			; Shift w/zeros fill
		shl	si,1			; Shift w/zeros fill
		dec	si
		jmp	loc_816
		
loc_815:
		dec	cx
		add	si,cx
		mov	cl,[di]
loc_816:
		add	ax,dx
		mov	[bx+1Ch],si
		mov	[bx+1Eh],ax
		pop	ax
		pop	si
		xor	di,di			; Zero register
		cmp	word ptr [bx+1Ah],0
		je	loc_817			; Jump if equal
		mov	di,[bx+1Ah]
		mov	[di],cl
		mov	[di+1],dl
                mov     word ptr ds:[dunno0a],di        ; 538b
		call	sub_43
		mov	bx,word ptr ds:[v5B1B]
		mov	[bx],di
		mov	[bx+2],si
		mov	[bx+4],ax
		add	bx,6
		mov	word ptr ds:[v5B1B],bx
loc_817:
		call	sub_40

              
		add	word ptr [v5fdb], 6
		mov	di, [v5fdb]


                mov     bx, [v5fd5]              ; data_263
                mov     dx, [v5fd7]              ; data_264
		push	dx
                cmp     dx, 0
		jge	loc_818			; Jump if > or =
                mov     dx, 0
loc_818:
                cmp     bx, 0
		jge	loc_819			; Jump if > or =
                mov     bx, 0 ;data_11e
loc_819:
                call    checkeol
		mov	[di],bp
                mov     ax, [v5fd3]
                sub     ax, [v5fd5]
                add     ax, 3
                shr     ax, 1                    ; Shift w/zeros fill
                shr     ax, 1                    ; Shift w/zeros fill
                mov     cx, bx
                mov     bx, word ptr ds:[gfxoffset]
                xor     dh, dh                   ; Zero register
                mov     dl, [bx]
                add     ax, dx
                shr     cx, 1                    ; Shift w/zeros fill
                shr     cx, 1                    ; Shift w/zeros fill
                add     cx, ax
                cmp     cx, 51h
		jl	loc_820			; Jump if <
                sub     cx, 50h
                sub     ax, cx
loc_820:
		mov	[di+2],ax
                mov     ax,[v5fd9]              ;data_265
                sub     ax,[v5fd7]              ;data_264
		mov	dl,[bx+1]
		add	ax,dx
		pop	dx
		add	dx,ax
		cmp	dx,0C8h
		jl	loc_821			; Jump if <
		sub	dx,0C7h
		sub	ax,dx
loc_821:
		mov	[di+4],ax
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	di
		pop	si
		retn
sub_51		endp



v5b1b           dw      offset bigbuffer        ;=ed 5b29h       ;5b1b-c
		dw	-1
		dw	0
                dw	0

              ;  dw      0
               ; dw      0
               ; dw      0

bigbuffer       db      938 dup (0)     ; 5b29
                dw      0               ; data_262        dw      0
                dw      0               ; data_263        dw      0
                dw      0               ; data_264        dw      0
                dw      0               ; data_265        dw      0
		dw	0		; data_266
		db	246 dup (0)

v5fd3		dw	0		;@5fd3-4
v5fd5		dw	0		;@5fd5-6
v5fd7		dw	0  		;@5fd7-8
v5fd9		dw	0  		;@5fd9-a
						
v5fdb		dw	offset bigbuffer2	;;@5fdb-5fdc
bigbuffer2sFFFF dw	-1		; 5fdd-5fde
                dw      0           ; 5fdf
                dw      0

bigbuffer2      db      1078 dup (0)  ;@5fe3
data_268	db	0
data_269	db	0
data_270	dw	0
data_271	dw	0
		db	26 dup (0)
data_272	dw	0
		db	84 dup (0)

;
; sub_52                           SUBROUTINE
;

;puts a sprite on the screen, not always a player.

putplayer          proc    near
		push	ax
		push	bx
@@:
		mov	bx, [v5fdb]		; data_266
		mov	ax, [bx]
		cmp	ax, -1
		jz	@f			; Jump if zero
                mov     word ptr ds:[dispstats1],ax  ; starting offset
                mov     word ptr ds:[dispstats2],ax
		mov	ax,[bx+2]
                mov     word ptr ds:[gfxcount],ax
		mov	ax,[bx+4]
                mov     word ptr ds:[dispstats0],ax
                call    put2screen
		sub	[v5fdb],6		; data_266, 6
		jmp	@b
@@:
		pop	bx
		pop	ax
		retn
putplayer          endp


;
;                              SUBROUTINE
;

sub_53		proc	near
		push	bx
		push	ax
@@:
		mov	bx,word ptr ds:[v5B1B]
		mov	ax,[bx-6]
		cmp	ax, -1
		jz	@f			; Jump if zero
                mov     word ptr ds:[gfxoffset],ax
		mov	ax,[bx-4]
                mov     word ptr ds:[xpos],ax
		mov	ax,[bx-2]
                mov     word ptr ds:[ypos],ax
                call    copy2screen
		sub	word ptr ds:[v5B1B],6
		jmp	@b
@@:
		pop	ax
		pop	bx
		retn
sub_53		endp


;
;                              SUBROUTINE
;

sub_54		proc	near
		push	di
		push	bx
		push	ax
		mov	al,[bx+1]
		mov	data_269,al
		mov	ax,[bx+2]
		mov	data_270,ax
		and	ax,3
		shl	ax,1			; Shift w/zeros fill
		mov	di,ax
		add	di,8
		mov	ax,[bx+4]
		mov	data_271,ax
		add	bx,di
		mov	ax,[bx]
		mov	bx,ax
		mov	ax,[bx]
		mov	data_272,ax
		mov	bx,offset data_268
		call	sub_51
		pop	ax
		pop	bx
		pop	di
		retn
sub_54		endp




data_278	dw	103h	       ;@6519
data_279	dw	0
data_280	dw	0
data_281	dw	0
data_282	dw	6539h
;data_283	dw	6539h
;data_284	dw	6539h
;data_285	dw	6539h	       ;@6527-28
		db	0	;data_286	db	0		
		db	0
data_287	dw	0
data_288	dw	0
		db	0	;data_289	db	0
                db      0
data_291	dw	0
                db      0                             ; Data table (indexed access)
		db	0		;data_293	db	0
		db	17 dup (0)
data_294	db	0
		db	8 dup (0)
data_295	db	0
data_296	db	0
		db	0
data_297	db	0
		db	24 dup (0)
data_298	db	0
		db	0	;data_299	db	0
		db	14 dup (0)
		db	0	;data_300	db	0
		db	0, 0
		db	0	;data_301	db	0
		db	0
		db	0	;data_302	db	0
		db	0, 0
		db	0	;data_303	db	0
		db	25 dup (0)
INT1COFF	dw	0
INT1CSEG	dw	0		; storage for original INT 1C vector

INT9SEG 	dw	0
INT9OFF 	dw	0
		dw	0	;data_308	dw	0
data_309	dw	0
data_310	db	0
		db	102 dup (0)
sto0		db	0,0
sto8		db	0	; 6610
sto7		dw	0	; 6611-12
stob            dw      0       ; 6613-4
stoa   		dw	0	; 6615-6
v6617  		dw	0	; 6617-8
v6619           dw      0       ; 6619-a
v661b           dw      0       ; 661b-c
sto5		dw	0	; 661d-e
sto6		dw	0	; 661f-20
sto4		dw	0	; 6621-2
		
sto1		dw	0FFFEh	;6623-4
sto2		dw	0FFFEh	;6625-6
sto3		dw	0FFFEh	;6627-8
v6629		dw	00h 	;6629-a
	       ;	db	00h 	;662a
		db	00h 	;662b
		db	00h 	;662c
		db	00h 	;662d
		db	00h	;662e
v662f		db	59h	;662f

v6630		db	0	;@6630
                db      0       ;@6631
		db	0	;@6632


keypress	db	0	;@6633
flagc		db	0              ;@6634
		dw	0  		;@6635-6

		db	113 dup (0)
un0		db	0,0,0

;
; sub_55                             SUBROUTINE
;
; replace keyboard and timer counter with specific routines.
; initialize (reset?) pcjr tone generator if it has one.

systeminit	proc	near
       



	push	ax
	push	bx
	push	es



	mov 	ah, 35h                        ;get vector function
        mov 	al, 1ch                        ;place interrupt # here.
	int 	21h                           ;

	mov 	INT1CSEG, es                   ;save the old vectors
	mov 	INT1COFF, bx                   ;
	lea 	dx, newint1c                    ;load dx with the new routine
	mov 	ah, 25h
        mov 	al, 1ch                       ;place interrupt # here.
	int 	21h                           ;set new vector


	pop	es
	pop	bx
	pop	ax
	ret

systeminit	endp




comment $



		

		push	es
		push	ax
		


		xor	ax, ax			; Zero register
		mov	es, ax
		mov	ax, es:[INT1C+2]	; load offset of INT 1C	
		mov	[INT1CSEG], ax		; save it 
		mov	ax, es:[INT1C]		; load segment of INT 1C
		mov	[INT1COFF], ax		; save it
	  ;?why	mov	data_308,0
	  ;	mov	ax, es:[INT9+2]		; load offset of INT 9
	  ;	mov	[INT9SEG], ax		; save it
	  ;	mov	ax, es:[INT9]		; load segment of INT 9
	  ;	mov	[INT9OFF], ax		; save it
		mov	ax, cs






		cli				; Disable interrupts
	    	mov	es:[INT1C+2],ax		; revector INT9,1C
		mov	es:[INT9+2],ax		; write segment to current CS
	   ;	lea	ax, offset newint9	; replace with LEA
	   ;	mov	es:[INT9],ax
		lea	ax, offset newint1C     ; 67AAh  replace with LEA
	    	mov	es:[INT1C],ax
		
		

	    ;	mov	ds:[sto1],0FFFEh	;data_283
	    ;	mov	ds:[sto2],0FFFEh	;data_284
	    ;	mov	ds:[sto3],0FFFEh	;data_285
	    ;	mov	byte ptr ds:[sto0],0	; [6610]
	    ;	mov	[un0],0
	    	sti				; Enable interrupts
           ;;     
	   ;	cmp     word ptr ds:[pcjr?],0
	   ;	je	@f			; Jump if equal
	   ;	
	   ;	mov	al,78h			; 'x'
	   ;	out	61h,al			; port 61h, 8255 B - spkr, etc
	   ;	mov	al,9Fh
	   ;	out	0C0h,al			; port 0C0h, pc jr tone gen
	   ;	mov	al,0BFh
	   ;	out	0C0h,al			; port 0C0h, pcjr tone gen
	   ;	mov	al,0DFh
	   ;	out	0C0h,al			; port 0C0h, pcjr tone gen
	   ; 	mov	al,0FFh
	   ; 	out	0C0h,al			; port 0C0h, pcjr tone gen
@@:


		pop	ax
		pop	es
		retn
systeminit	endp



;Interrupt 9 routine.  called for every keypress.
;

newint9:					;* No entry point to code


		sti				; Enable interrupts
		push	si
		push	ds
		push	cx
		push	bx
		push	ax
		push	es
		mov	cx, ax
		mov	ax, cs
		mov	ds, ax
                cmp     word ptr ds:[pcjr?],0
		je	loc_830			; Jump if equal

		mov	ax, BDASEG
		mov	es, ax
		and	byte ptr es:[KEYSTATS], NOT BIT3  ; clear pause active
		mov	ax, cx
		mov	ah, al
		jmp	short loc_831
		
loc_830:
		cli				; Disable interrupts
		xor	cx,cx			; Zero register
		in	al,60h			; port 60h, keybd scan or sw1
		mov	ah,al
		

		; clear keyboard IRQ if pending.  
		in	al,61h			; port 61h, 8255 port B, read
		mov	bl,al
		or	al,80h
		out	61h,al			; port 61h, 8255 B - spkr, etc
		
		; restore state
		mov	al,bl
		out	61h,al			; port 61h, 8255 B - spkr, etc
						;  al = 0, speaker off
		sti				; Enable interrupts
loc_831:
		cmp	ah,6Ah			; 'j'
		jg	loc_835			; Jump if >
		test	ah, BIT7
		jz	loc_832			; Jump if zero
		
		and	ah, NOT BIT7
		mov	al,0
		jmp	loc_833
		nop
loc_832:
		mov	al,1
loc_833:
		xor	bh, bh			; Zero register
		mov	bl, ah
                mov     [keypress][bx],al       ; save keypress val
		cmp	al,0
		jne	loc_834			; Jump if not equal
		mov	bl,0
loc_834:
                mov     [keypress],bl

		; check for reset
		
	     ;	cmp	bl,53h			; del key?
	     ;	jne	loc_835			; Jump if not equal
	     ;
	     ;	cmp	data_296,1 ;6650 ctlr=1d		; control key held down?
	     ;	jne	loc_835			; Jump if not equal
	     ;	
	     ;	cmp	data_298,1 ;666b alt=38		; alt key held?
	     ;	jne	loc_835			; Jump if not equal
 
		; reset system
		
;*	    ;	jmp	far ptr loc_858		;*
	    ;	db	0EAh
	    ;	dw	0, 0FFFFh		;  Fixup - byte match
loc_835:
		mov	al,20h			; ' '
		out	20h,al			; port 20h, 8259-1 int command
						;  al = 20h, end of interrupt
		pop	es
		pop	ax
		pop	bx
		pop	cx
		pop	ds
		pop	si
		iret				; Interrupt return
		
$		
         
		
newint1c:						;* No entry point to code

		; first, do the actual INT 1C ISR

.386
		pushf
		call	dword ptr cs:INT1COFF
    


		sti				; Enable interrupts
		push	ax
		push	bx
		push	ds
		push	es
		push	si
		push	cx
		mov	ax,cs
		mov	ds,ax
                cmp     byte ptr ds:[bonustimer],0
		je	loc_836			; Jump if equal
                dec     byte ptr ds:[bonustimer]
loc_836:
		cmp	data_310,0	   ; 66a9
		je	loc_837			; Jump if equal
		dec	data_310
loc_837:
		test	data_296,0FFh	   ; 6650
		jz	loc_840			; Jump if zero
		test	data_297,0FFh	   ; 6652
		jz	loc_839			; Jump if zero
		cmp	data_310,0	   ; 66a9
		jne	loc_840			; Jump if not equal
		mov	data_310,6	   ; 66a9
		cmp	[v662f], 59h	 ;data_289,59h	   ; 662f
		je	loc_838			; Jump if equal
		mov	[v662f], 59h	;data_289,59h		; 'Y'
		jmp	loc_840
		
loc_838:
		call	playtone4	;sub_60
		mov	[v662f], 4eh	;data_289,4Eh	   ;662f	; 'N'
		jmp	loc_840
		
loc_839:
		test	data_294,0FFh	       ;6646
		jz	loc_840			; Jump if zero
		mov	byte ptr ds:[gameover],1
loc_840:
                cmp     [v6630],0
		jne	loc_841			; Jump if not equal
		call	playtone4	;sub_60
		jmp	loc_852
loc_841:
                cmp     byte ptr ds:[sto8],0
		jne	loc_842			; Jump if not equal
		call	playtone4	;sub_60
		jmp	loc_852
loc_842:
                test    [v6630],1
		jz	loc_845			; Jump if zero
		cmp	word ptr v6629, 0	;data_286,0
		ja	loc_844			; Jump if above
                mov     bx,sto1
                cmp     bx,word ptr ds:[stoa]
		jne	loc_843			; Jump if not equal
                and     [v6630],0FEh
                call    pcjrtone1
                jmp     loc_845
                
loc_843:
                inc     sto1
                inc     sto1
                mov     si,word ptr ds:[sto7]
                mov     bx,sto1
		mov	ax,[bx+si]
                mov     si,word ptr ds:[stob]
		mov	cx,[bx+si]
		dec	cx
		mov	word ptr v6629, cx	;data_286,cx   ; 6629
		mov	bx,ax
		mov	data_291,0
		call	playtone3	;sub_59
                jmp     loc_845
                
loc_844:
		dec	word ptr [v6629]	;data_286
loc_845:
                cmp     word ptr ds:[pcjr?],0
		jne	loc_846			; Jump if not equal
                and     [v6630],0FDh
                and     [v6630],0FBh
		jmp	loc_852
loc_846:
                test    [v6630],2
		jz	loc_849			; Jump if zero
		cmp	data_287,0
		ja	loc_848			; Jump if above
                mov     bx,sto2
		cmp	bx,data_279
		jne	loc_847			; Jump if not equal
                and     [v6630],0FDh
                call    pcjrtone2
		jmp	loc_849
		
loc_847:
                inc     sto2
                inc     sto2
		mov	si,word ptr ds:[v6617]
                mov     bx,sto2
		mov	ax,[bx+si]
		mov	si,data_278
		mov	cx,[bx+si]
		dec	cx
		mov	data_287,cx
		mov	bx,ax
		mov	data_291,1
		call	playtone3	;sub_59
		jmp	loc_849
		
loc_848:
		dec	data_287
loc_849:
                test    [v6630],4
		jz	loc_852			; Jump if zero
		cmp	data_288,0
		ja	loc_851			; Jump if above
                mov     bx,sto3
		cmp	bx,data_282
		jne	loc_850			; Jump if not equal
                and     [v6630],0FBh
                call    pcjrtone3
		jmp	loc_852
		
loc_850:
                inc     sto3
                inc     sto3
		mov	si,data_280
                mov     bx,sto3
		mov	ax,[bx+si]
		mov	si,data_281
		mov	cx,[bx+si]
		dec	cx
		mov	data_288,cx
		mov	bx,ax
		mov	data_291,2
		call	playtone3	;sub_59
		jmp	short loc_852
		nop
loc_851:
		dec	data_288
loc_852:

		pop	cx
		pop	si
		pop	es
		pop	ds
		pop	bx
		pop	ax
		iret				; Interrupt return


;
;                              SUBROUTINE
;

pcjrtone1       proc    near
		push	ax
		mov	al,9Fh
		out	0C0h,al			; port 0C0h, PCjr noise/tone
		pop	ax			; generator
		retn
pcjrtone1       endp


;
;                              SUBROUTINE
;

pcjrtone2       proc    near
		push	ax
		mov	al,0BFh
		out	0C0h,al			; port 0C0h, PCjr noise/tone
		pop	ax			; generator
		retn
pcjrtone2       endp


;
;                              SUBROUTINE
;

pcjrtone3       proc    near
		push	ax
		mov	al,0DFh
		out	0C0h,al			; port 0C0h, PCjr noise/tone
		pop	ax			; generator
		retn
pcjrtone3       endp


;
; sub_59                             SUBROUTINE
;

playtone3 	proc	near
		cmp	[v662f], 4eh	;data_289,4Eh		; 'N'  ; silent mode selected?
		jne	loc_853			; Jump if not equal
		retn
		db	 00h, 00h, 80h, 00h, 93h
loc_853:
		push	ax
		push	bx
		push	cx
                cmp     word ptr ds:[pcjr?],0
		je	loc_854			; Jump if equal
		
		mov	byte ptr ds:[6955h],80h
		mov	byte ptr ds:[6956h],0
		mov	byte ptr ds:[6957h],82h
		mov	ax,data_291
		mov	cx,5
		shl	ax,cl			; Shift w/zeros fill
		or	byte ptr ds:[6955h],al
		add	ax,10h
		or	byte ptr ds:[6957h],al
		mov	ax,bx
		and	ax,0Fh
		or	byte ptr ds:[6955h],al
		mov	ax,bx
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		shr	ax,1			; Shift w/zeros fill
		and	ax,3Fh
		or	byte ptr ds:[6956h],al
		mov	al,byte ptr ds:[6955h]
		out	0C0h,al			; port 0C0h, PCjr tone gen
		mov	al,byte ptr ds:[6956h]
		out	0C0h,al			; port 0C0h, PCjr tone gen
		mov	al,byte ptr ds:[6957h]
		out	0C0h,al			; port 0C0h, PCjr tone gen
		jmp	loc_855
		
loc_854:
		shl	bx,1			; Shift w/zeros fill
		mov	ax,bx
		shl	bx,1			; Shift w/zeros fill
		shl	bx,1			; Shift w/zeros fill
		in	al,61h			; port 61h, 8255 port B, read
		and	al,0FCh
		out	61h,al			; port 61h, 8255 B - spkr, etc
		mov	al,0B6h
		out	43h,al			; port 43h, 8253 timer control
		mov	ax,bx
		out	42h,al			; port 42h, 8253 timer 2 spkr
		mov	al,ah
		out	42h,al			; port 42h, 8253 timer 2 spkr
		in	al,61h			; port 61h, 8255 port B, read
		or	al,3
		out	61h,al			; port 61h, 8255 B - spkr, etc
loc_855:
		pop	cx
		pop	bx
		pop	ax
		retn
playtone3	endp


;
;        sub_60                      SUBROUTINE
;

playtone4		proc	near
		push	ax
		in	al,61h			; port 61h, 8255 port B, read
		and	al,0FCh
		out	61h,al			; port 61h, 8255 B - spkr, etc
		mov	al,9Fh
		out	0C0h,al			; port 0C0h, pcjr tone gen
		mov	al,0BFh
		out	0C0h,al			; port 0C0h, pcjrtone gen
		mov	al,0DFh
		out	0C0h,al			; port 0C0h, pcjr tone gen
		pop	ax
                mov     byte ptr ds:[sto8],0
                mov     [v6630],0
                mov     sto1,0FFFEh
                mov     sto2,0FFFEh
                mov     sto3,0FFFEh
                mov     word ptr ds:[sto7],0
		mov	word ptr ds:[v6617],0
		mov	data_280,0
		mov	word ptr v6629,0	; data_286,0
		mov	data_287,0
		mov	data_288,0
                mov     word ptr ds:[stob],0
		mov	data_278,0
		mov	data_281,0
		retn
playtone4		endp





;below here be lotsa data.


                           ;6axx prolly.



		db	 00h, 00h, 00h 

		db	 00h, 00h,0ACh
		db	 01h, 3Bh, 02h,0ACh, 01h, 3Bh

		
music1		db	 02h, 0ach, 01			;@6a40
		db	 3Bh, 02h, 57h, 03h, 3Bh, 02h
		db	 1Dh, 01h, 2Eh, 01h, 1Dh, 01h
		db	 0Dh, 01h, 1Dh, 01h, 0Dh, 01h
		db	0FEh, 00h, 0Dh, 01h,0FEh, 00h
		db	0F0h, 00h,0FEh, 00h,0F0h, 00h
		db	0D6h, 00h, 1Dh, 01h,0D6h, 00h
		db	 03h, 00h, 
		
sound0		dw	2Eh				;@6a70

music2		db	 06h, 00h			;@6a72
		db	 06h, 00h, 06h, 00h, 06h, 00h
		db	 06h, 00h
data_320	dw	6
		db	 06h, 00h, 06h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		
v6aa2		db	 03h, 00h,0ACh, 01h, 3Bh, 02h	;@6aa2
		db	0ACh, 01h, 3Bh, 02h,0ACh, 01h
        	db	03bh, 02h, 57h, 03h, 3Bh, 02h
		
		
music3		db	 10h, 00h			;@6ab4
		db	 30h, 00h, 06h, 00h, 06h, 00h
		db	 06h, 00h, 06h, 00h, 06h, 00h
		db	 06h, 00h, 06h, 00h, 06h, 00h
		db	0ABh, 01h, 53h, 01h, 1Dh, 01h
		db	 53h, 01h, 40h, 01h, 53h, 01h
		db	 40h, 01h, 53h, 01h, 40h, 01h
		db	 1Dh, 01h, 53h, 01h,0ABh, 01h
		db	 16h, 00h
data_322	dw	9
		db	 06h, 00h, 12h, 00h, 03h, 00h
		db	 06h, 00h, 03h, 00h, 06h, 00h
		db	 03h, 00h, 06h, 00h, 03h, 00h
		db	 06h, 00h, 09h, 00h, 57h, 03h
		db	0FAh, 02h,0A7h, 02h, 3Bh, 02h
		db	0ABh, 01h, 3Bh, 02h,0A7h, 02h
		db	 81h, 02h,0A7h, 02h, 3Bh, 02h
		db	 57h, 03h, 14h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h
		dw	6	;data_323	dw	6
		db	 09h, 00h, 09h, 00h, 03h, 00h
		db	 18h, 00h, 03h, 00h, 06h, 00h
		db	 09h, 00h,0ABh, 01h, 53h, 01h
		db	 1Dh, 01h,0D6h, 00h,0BEh, 00h
		db	0D6h, 00h,0F0h, 00h,0E2h, 00h
		db	 1Dh, 01h, 40h, 01h, 7Dh, 01h
		db	0C5h, 01h,0ABh, 01h, 53h, 01h
		db	 1Dh, 01h,0D6h, 00h
v6b48		db	 1Eh, 00h	   		;@6b48
		db	 05h, 00h, 05h, 00h, 05h, 00h
		db	 0Ah, 00h, 05h, 00h, 05h, 00h
		db	 05h, 00h, 05h, 00h
data_324	dw	0Ah
		db	 0Ah, 00h, 0Ah, 00h, 05h, 00h
		db	 05h, 00h, 05h, 00h, 05h, 00h
		db	 14h, 00h,0ABh, 01h, 3Bh, 02h
		db	0ABh, 01h, 1Dh, 01h, 3Bh, 02h
		db	 7Dh, 01h, 3Bh, 02h, 7Dh, 01h
		db	0ABh
loc_856:
db 01h, 10h                  ;         add     [bx+si],dx
db 00h, 0Fh                  ;         add     [bx],cl
db 00h, 0Ah                 ;          add     [bp+si],cl
db 00h, 0Ah                  ;         add     [bp+si],cl
db 00h, 05h                  ;         add     [di],al
db 00h, 0Fh                  ;        add     [bx],cl
db 00h, 0Ah                  ;         add     [bp+si],cl
db 00h, 0Ah                  ;         add     [bp+si],cl
db 00h, 05h                  ;         add     [di],al
db 00h, 23h                  ;         add     [bp+di],ah
db 00h, 0D6h                 ;          add     dh,dl
db 00h, 0A0h, 00, 00         ;          add     ds:data_406e[bx+si],ah  ; (9401:B400=1Eh)
db 00h, 0D6h                 ;          add     dh,dl
db 00h, 0Dh                  ;         add     [di],cl
db 01h, 0F0h                 ;          add     ax,si
db 00h, 0Dh                  ;         add     [di],cl
db 01h, 0E2h                 ;          add     dx,sp
db 00h, 0B4h, 00, 0e2h       ;                       add     ds:data_408e[si],dh     ; (9401:E200=20h)
db 00h, 0F0h                 ;          add     al,dh
db 00h, 0Dh                  ;         add     [di],cl
db 01h, 40h, 01              ;           add     [bx+si+1],ax
db 0Dh, 01h, 40h, 01             ;           or      ax,4001h





















v6bae:		
db 01Ch                       ;    add     [si],bx
db 000h, 00Ah                 ;          add     [bp+si],cl
db 000h, 006h, 00, 0ah        ;                      add     byte ptr ds:[0A00h],al  ; (9401:0A00=47h)
db 000h, 00Ah                 ;          add     [bp+si],cl
db 000h, 003h                 ;          add     [bp+di],al
db 000h, 006h, 00, 03         ;                     add     byte ptr ds:[300h],al   ; (9401:0300=0D3h)
db 000h, 00Ah                 ;          add     [bp+si],cl
db 000h, 00Ah                 ;          add     [bp+si],cl
db 000h, 003h                 ;          add     [bp+di],al
db 000h, 003h                 ;          add     [bp+di],al
db 000h, 003h                 ;          add     [bp+di],al
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 010h		      ;		add	[bx+si],dl
db 000h, 0ABh, 01, 81h	      ;			add	[bp+di-7EFFh],ch
db 002h, 01Bh		      ;		add	bl,[bp+di]
db 002h, 0E0h		      ;		add	ah,al
db 001h, 01Bh		      ;		add	[bp+di],bx
db 002h, 027h		      ;		add	ah,[bx]
db 003h, 01Bh		      ;		add	bx,[bp+di]
db 002h, 0E0h		      ;		add	ah,al
db 001h, 01Bh		      ;		add	[bp+di],bx
db 002h, 080h, 02, 12h	      ;			add	al,data_88[bx+si]	; (9401:1202=20h)
db 000h, 00Ah		      ;		add	[bp+si],cl
db 000h, 010h		      ;		add	[bx+si],dl
db 000h, 00Ah		      ;		add	[bp+si],cl
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 00Ah		      ;		add	[bp+si],cl
db 000h, 010h		      ;		add	[bx+si],dl
db 000h, 00Ah		      ;		add	[bp+si],cl
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 00Ah		      ;		add	[bp+si],cl
db 000h, 00Ah		      ;		add	[bp+si],cl
db 000h 

v6bf8	db 0D6h		      ;		add	dh,dl
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 0D6h		      ;		add	dh,dl
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 0D6h		      ;		add	dh,dl
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 0D6h		      ;		add	dh,dl
db 000h, 0B4h, 00, 0BEh	      ;			add	ds:data_407e[si],dh	; (9401:BE00=0)
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 0BEh, 00, 0D6h	      ;			add	[bp-2A00h],bh
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 0D6h		      ;		add	dh,dl
db 000h, 0E2h		      ;		add	dl,ah
db 000h, 0D6h		      ;		add	dh,dl
db 000h 
v6c18	dw	01Eh 
v6c1a	db 	07	      ;			add	data_65,bl		; (9401:0700=0)
db 000h, 001h		      ;		add	[bx+di],al
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 001h		      ;		add	[bx+di],al
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 001h		      ;		add	[bx+di],al
db 000h, 008h		      ;		add	[bx+si],cl
db 000h, 004h		      ;		add	[si],al
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 001h		      ;		add	[bx+di],al
db 000h, 004h		      ;		add	[si],al
db 000h, 003h		      ;		add	[bp+di],al
db 000h, 001h		      ;		add	[bx+di],al
db 000h, 004h		      ;		add	[si],al
db 000h, 004h		      ;		add	[si],al
db 000h, 010h		      ;		add	[bx+si],dl
db 000h, 


v6c3a	db 0ACh, 01, 3Bh	      ;			add	byte ptr ds:[3B01h][si],ch	; (9401:3B01=0Ch)
db 002h, 0ACh, 01, 3Bh	      ;			add	ch,byte ptr ds:[3B01h][si]	; (9401:3B01=0Ch)
db 002h, 0ACh, 01, 3Bh	      ;			add	ch,byte ptr ds:[3B01h][si]	; (9401:3B01=0Ch)
db 002h, 0ACh, 01, 3Bh	      ;			add	ch,byte ptr ds:[3B01h][si]	; (9401:3B01=0Ch)
db 002h, 0ACh, 01, 3Bh	      ;			add	ch,byte ptr ds:[3B01h][si]	; (9401:3B01=0Ch)
db 002h, 0ACh, 01, 3Bh	      ;			add	ch,byte ptr ds:[3B01h][si]	; (9401:3B01=0Ch)
db 002h, 0ACh, 01, 3Bh	      ;			add	ch,byte ptr ds:[3B01h][si]	; (9401:3B01=0Ch)
db 002h, 057h, 03	      ;			add	dl,[bx+3]
db 03Bh, 002h		      ;		cmp	ax,[bp+si]
db 01Eh			      ;		push	ds

v6c5c 	db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h, 04h		      ;		add	[si],al
db 000h 


v6c7c		db 6Ch, 02	      ;			add	[si+2],ch
v6c7e		dw	00h		      ;		add	[bx+si],al

v6c80		db 001h, 00h		      ;		add	[bx+si],ax
		
v6c82		db	30h, 02h
v6c84		dw	0
v6c86		db	01, 00


v6c88		db	0D6h, 00h,0AAh, 00h, 8Fh, 00h
		db	 6Bh, 00h, 8Fh, 00h,0AAh, 00h
		db	0D6h, 00h 
v6c96		dw	000ch
		
v6c98		db	01h, 00h
		db	 01h, 00h, 01h, 00h, 01h, 00h
		db	 01h, 00h, 01h, 00h, 01h, 00h
		db	 6Bh, 00h, 8Fh, 00h, 6Bh, 00h
		db	 8Fh, 00h, 6Bh, 00h, 8Fh, 00h
		db	 6Bh, 00h, 8Fh, 00h, 0Eh, 00h
		db	 01h, 00h, 01h, 00h, 01h, 00h
		db	 01h, 00h, 01h, 00h, 01h, 00h
		db	 01h, 00h, 01h, 00h, 03h, 00h
		db	0ABh, 01h, 53h, 01h, 1Dh, 01h
		db	0D6h, 00h, 03h, 00h, 1Dh, 01h
		db	 40h, 01h, 53h, 01h, 7Dh, 01h
		db	0ABh, 01h, 1Dh, 01h, 40h, 01h
		db	 53h, 01h, 7Dh, 01h
data_330	dw	140h
		db	 53h, 01h,0ABh, 01h, 40h, 01h
		db	 53h, 01h, 7Dh, 01h, 40h, 01h
		db	 53h, 01h,0ABh, 01h, 03h, 00h
		db	0ABh, 01h, 03h, 00h,0ABh, 01h
		db	 03h, 00h,0ABh, 01h, 7Dh, 01h
		db	 53h, 01h, 1Dh, 01h,0D6h, 00h
		db	 03h, 00h,0D6h, 00h, 1Dh, 01h
		db	 53h, 01h, 1Dh, 01h,0ABh, 01h
		db	 03h, 00h,0ABh, 01h, 7Dh, 01h
		db	 53h, 01h, 40h, 01h, 1Dh, 01h
		db	0FEh, 00h,0E2h, 00h, 1Dh, 01h
		db	0D6h, 00h, 62h, 00h, 01h, 00h
		db	 0Ch, 00h, 0Ch, 00h, 0Ch, 00h
		db	 0Bh, 00h, 01h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 0Ch, 00h, 0Ch, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 06h, 00h, 06h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 06h, 00h, 05h, 00h, 01h, 00h
		db	 0Bh, 00h, 01h, 00h, 0Bh, 00h
		db	 01h, 00h, 03h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 0Bh, 00h
		db	 01h, 00h, 03h, 00h
data_331	dw	3
		db	 03h, 00h, 03h, 00h, 0Bh, 00h
		db	 01h, 00h, 03h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 18h, 00h, 03h, 00h,0ABh, 01h
		db	 03h, 00h, 53h, 01h, 7Dh, 01h
		db	 93h, 01h,0C5h, 01h,0ABh, 01h
		db	 3Bh, 02h,0ABh, 01h, 7Dh, 01h
		db	0ABh, 01h, 3Bh, 02h, 57h, 03h
		db	 03h, 00h, 57h, 03h,0ABh, 01h
data_332	dw	23Bh
		db	 57h, 03h, 3Bh, 02h,0ABh, 01h
		db	 3Bh, 02h, 57h, 03h,0ABh, 01h
		db	 3Bh, 02h,0ABh, 01h, 3Bh, 02h
		db	0ABh, 01h, 3Bh, 02h, 57h, 03h
		db	 03h, 00h, 57h, 03h, 03h, 00h
		db	 57h, 03h,0FAh, 02h,0A7h, 02h
		db	 81h, 02h, 3Bh, 02h,0FCh, 01h
		db	0C5h, 01h, 3Bh, 02h,0ABh, 01h
		db	 52h, 00h, 0Dh, 00h, 23h, 00h
		db	 01h, 00h, 03h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 06h, 00h
		db	 06h, 00h, 06h, 00h, 06h, 00h
		db	 03h, 00h, 03h, 00h, 05h, 00h
		db	 01h, 00h, 0Ch, 00h, 03h, 00h
		db	 03h, 00h, 06h, 00h, 06h, 00h
		db	 06h, 00h, 0Ch, 00h, 0Ch, 00h
		db	 06h, 00h, 06h, 00h, 06h, 00h
		db	 06h, 00h, 06h, 00h, 06h, 00h
		db	 05h, 00h, 01h, 00h, 05h, 00h
		db	 01h, 00h, 03h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 03h, 00h, 03h, 00h, 03h, 00h
		db	 18h, 00h, 03h, 00h, 53h, 01h
		db	 03h, 00h, 1Dh, 01h, 40h, 01h
		db	 53h, 01h, 7Dh, 01h, 03h
loc_857:
db 00h, 057h, 03h		       
db 03Bh, 02h			       
db 03h, 00			       
db 03Bh, 02			       
db 0A7h			       
db 02h, 03			       
db 00h, 057h, 03		       
db 03Bh, 02			       
db 03h, 00			       
db 03Bh, 02			       
db 0A7h			       
db 02h, 03			       
db 00h, 03Bh			       
db 02h, 03			       
db 00h, 03Bh			       
db 02h, 057h, 03		       
db 057h			       
db 03h, 03			       
db 00h, 0ABh, 01, 03bh		       
db 02h, 057h, 03		       
db 038h, 00			       
db 019h, 00			       
db 017h			       
db 00, 01			       
db 00, 03			       
db 00, 03			       
db 00, 03			       
db 00, 03			       
db 00, 06, 00, 0ch		       
db 00, 011h			       
db 00, 01			       
db 00, 06, 00, 06		       
db 00, 06, 00, 0ch		       
db 00, 011h			       
db 00, 01			       
db 00, 06, 00, 06		       
db 00, 06, 00, 0bh		       
db 00, 01			       
db 00, 0Ch			       
db 00, 0Ch			       
db 00, 06, 00, 18h		       
db 00, 06, 00, 06		       
db 00, 0Ch			       
db 00, 

something0	db	0BCh, 02, 00, 00	;bc@6eb2	       
something1	db	02			       

	
		db	9 dup (0)
		
ibmlogo1	db	 04h, 0Ah, 00h, 00h, 0Fh, 00h	;@6ec0
		db	0F0h, 00h, 00h, 00h, 00h, 00h
		db	 0Fh, 00h,0F0h, 00h, 00h, 00h
		db	 00h, 00h,0FFh,0BBh,0FFh,0BBh
		db	 00h, 00h, 0Fh, 0Bh, 0Fh, 0Bh
		db	0F0h,0B0h,0F0h,0B0h, 00h, 00h
		db	0FFh, 0Bh,0FFh,0B0h, 00h, 00h
		db	 00h, 00h, 0Fh, 0Dh,0F0h,0D0h
		db	 00h, 00h, 00h, 00h, 0Fh, 0Dh
		db	0F0h,0D0h, 00h, 00h, 00h, 00h
		db	 0Fh, 0Dh,0F0h,0D0h, 00h, 00h
		db	 00h, 00h, 0Fh, 0Dh,0F0h,0D0h
		db	 00h, 00h, 00h, 00h,0FFh, 00h
		db	0FFh, 00h, 00h, 00h
		
ibmlogo2	db	04h, 0Ah			; 6f12
		db	 00h, 00h, 0Fh, 00h,0F0h
		db	7 dup (0)
		db	0F0h, 00h, 00h, 00h,0F0h, 00h
		db	0FFh,0BBh,0FFh,0BBh, 00h, 00h
		db	 0Fh, 0Bh, 0Fh, 0Bh,0F0h,0B0h
		db	0F0h,0B0h, 00h, 00h, 0Fh, 0Bh
		db	0FFh,0B0h, 00h, 00h, 00h, 00h
		db	 0Fh, 0Dh,0F0h,0D0h, 00h, 00h
		db	 00h, 00h,0FFh,0DDh,0FFh,0DDh
		db	 00h, 00h, 00h, 00h,0F0h,0D0h
		db	 0Fh, 0Dh, 00h, 00h, 00h, 00h
		db	0F0h,0D0h, 00h, 00h,0F0h,0D0h
		db	 0Fh, 00h,0F0h, 00h, 0Fh, 00h
		db	0F0h, 00h 
		
ibmlogo3	db	04h, 0Ah, 00h, 00h		; @6f64
		db	 0Fh, 00h,0F0h
		db	7 dup (0)
		db	0F0h, 00h, 00h, 00h, 00h, 00h
		db	 0Fh, 0Bh,0FFh,0BBh, 00h, 00h
		db	 00h, 00h, 0Fh, 0Bh,0F0h,0B0h
		db	0F0h,0B0h, 00h, 00h,0FFh, 0Bh
		db	0F0h,0B0h, 0Fh, 00h, 00h, 00h
		db	 0Fh, 0Dh,0F0h,0D0h, 00h, 00h
		db	 00h, 00h, 0Fh, 0Dh,0FFh,0DDh
		db	 00h, 00h, 00h, 00h, 0Fh, 0Dh
		db	 00h, 00h,0F0h,0D0h, 00h, 00h
		db	 0Fh, 0Dh, 00h, 00h, 0Fh, 0Dh
		db	 00h, 00h,0FFh, 00h, 00h, 00h
		db	0FFh, 00h
		
ibmlogo4	db	04h, 0Ah, 00h, 00h		;@6fb6
		db	 0Fh, 00h,0F0h, 00h, 00h, 00h
		db	 00h, 00h, 0Fh
		db	7 dup (0)
		db	0FFh,0BBh,0FFh,0BBh, 0Fh, 00h
		db	 0Fh, 0Bh, 0Fh, 0Bh,0F0h,0B0h
		db	0F0h,0B0h, 00h, 00h,0FFh, 0Bh
		db	0F0h,0B0h, 00h, 00h, 00h, 00h
		db	 0Fh, 0Dh,0F0h,0D0h, 00h, 00h
		db	 00h, 00h,0FFh,0DDh,0FFh,0DDh
		db	 00h, 00h, 00h, 00h,0F0h,0D0h
		db	 0Fh, 0Dh, 00h, 00h, 0Fh, 0Dh
		db	 00h, 00h, 0Fh, 0Dh, 00h, 00h
		db	 0Fh, 00h,0F0h, 00h, 0Fh, 00h
		db	0F0h, 00h 
		
ibmlogo5	db	04h, 0Ah, 00h, 00h		;@7008
		db	 0Fh, 00h,0F0h, 00h, 00h, 00h
		db	 00h, 00h, 0Fh
		db	7 dup (0)
		db	0FFh,0BBh,0F0h,0B0h, 00h, 00h
		db	 0Fh, 0Bh, 0Fh, 0Bh,0F0h,0B0h
		db	 00h, 00h,0F0h, 00h, 0Fh, 0Bh
		db	0FFh,0B0h, 00h, 00h, 00h, 00h
		db	 0Fh, 0Dh,0F0h,0D0h, 00h, 00h
		db	 00h, 00h,0FFh,0DDh,0F0h,0D0h
		db	 00h, 00h, 0Fh, 0Dh, 00h, 00h
		db	0F0h,0D0h, 00h, 00h,0F0h,0D0h
		db	 00h, 00h,0F0h,0D0h, 00h, 00h
		db	0FFh, 00h, 00h, 00h,0FFh, 00h
		db	 00h, 00h 

ibmlogo6	db	04h, 0Ah,0F0h, 00h		;@705a
		db	 0Fh, 00h,0F0h, 00h, 0Fh, 00h
		db	 0Fh, 0Bh, 0Fh, 00h,0F0h, 00h
		db	0F0h,0B0h, 00h, 00h,0FFh,0BBh
		db	0FFh,0BBh, 00h, 00h, 00h, 00h
		db	 0Fh, 0Bh,0F0h,0B0h, 00h, 00h
		db	 00h, 00h, 0Fh, 0Bh,0F0h,0B0h
		db	 00h, 00h, 00h, 00h, 0Fh, 0Dh
		db	0F0h,0D0h, 00h, 00h, 00h, 00h
		db	0FFh,0DDh,0FFh,0DDh, 00h, 00h
		db	 00h, 00h,0F0h,0D0h, 0Fh, 0Dh
		db	 00h, 00h, 0Fh, 0Dh, 00h, 00h
		db	 00h, 00h,0F0h,0D0h,0FFh, 00h
		db	 00h, 00h, 00h, 00h,0FFh, 00h
		
ibmlogo7	db	 04h, 0Ah, 00h, 00h, 0Fh, 00h	 ;@70ac
		db	0F0h, 00h, 0Fh, 00h, 00h, 00h
		db	 0Fh, 00h, 00h, 00h,0F0h,0B0h
		db	 00h, 00h,0FFh,0BBh,0FFh,0BBh
		db	 00h, 00h, 0Fh, 0Bh, 0Fh, 0Bh
		db	0F0h,0B0h, 00h, 00h,0F0h, 00h
		db	 0Fh, 0Bh,0F0h,0B0h, 00h, 00h
		db	 00h, 00h, 0Fh, 0Dh,0F0h,0D0h
		db	 00h, 00h, 0Fh, 0Dh,0FFh,0DDh
		db	0FFh,0DDh, 00h, 00h,0FFh, 00h
		db	 00h, 00h, 0Fh, 0Dh, 00h, 00h
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	0F0h,0D0h, 00h, 00h, 00h, 00h
		db	 00h, 00h,0FFh, 00h 
		
ibmlogo8	db	04h, 0Ah			 ;@70fe
		db	 00h
		db	9 dup (0)
		db	 0Fh, 00h,0F0h, 00h, 00h, 00h
		db	 00h, 00h,0FFh,0BBh,0FFh,0BBh
		db	 00h, 00h, 0Fh, 0Bh, 0Fh, 0Bh
		db	0F0h,0B0h,0F0h,0B0h,0F0h, 00h
		db	 0Fh, 0Bh,0F0h,0B0h, 0Fh, 00h
		db	 00h, 00h, 0Fh, 0Dh,0F0h,0D0h
		db	 00h, 00h, 00h, 00h,0FFh,0DDh
		db	0FFh,0DDh, 00h, 00h, 00h, 00h
		db	0F0h,0D0h, 0Fh, 0Dh, 00h, 00h
		db	 0Fh, 0Dh, 00h, 00h, 00h, 00h
		db	0F0h,0D0h,0FFh, 00h, 00h, 00h
		db	 00h, 00h,0FFh, 00h 

ibmlogo9	db	04h, 0Ah
		db	0F0h, 00h, 0Fh, 00h,0F0h, 00h
		db	 00h, 00h, 0Fh, 0Bh, 00h, 00h
		db	0F0h, 00h, 00h, 00h, 00h, 00h
		db	0FFh,0BBh,0FFh,0BBh, 00h, 00h
		db	 00h, 00h, 0Fh, 0Bh,0F0h,0B0h
		db	0F0h,0B0h, 00h, 00h, 0Fh, 0Bh
		db	0F0h,0B0h, 0Fh, 00h, 00h, 00h
		db	 0Fh, 0Dh,0F0h,0D0h, 00h, 00h
		db	 00h, 00h,0FFh,0DDh,0FFh,0DDh
		db	0F0h,0D0h, 00h, 00h,0F0h,0D0h
		db	 00h, 00h,0FFh, 00h, 0Fh, 0Dh
		db	 00h, 00h, 00h, 00h, 00h, 00h
		db	0FFh
		db	7 dup (0)

ibmlogo10	db	 04h, 0Ah, 00h, 00h, 0Fh, 00h   ;@71a2
		db	0FFh, 00h, 00h, 00h, 00h, 00h
		db	 0Fh, 00h, 00h, 00h,0F0h,0B0h
		db	 00h, 00h,0FFh,0BBh,0FFh,0BBh
		db	 00h, 00h, 0Fh, 0Bh, 0Fh, 0Bh
		db	0F0h,0B0h, 00h, 00h, 00h, 00h
		db	0FFh, 0Bh,0F0h,0B0h, 00h, 00h
		db	 00h, 00h, 0Fh, 0Dh,0F0h,0D0h
		db	 00h, 00h, 00h, 00h, 0Fh, 0Dh
		db	0FFh,0DDh, 00h, 00h, 00h, 00h
		db	 0Fh, 0Dh, 00h, 00h,0F0h,0D0h
		db	 00h, 00h, 0Fh, 0Dh, 0Fh, 00h
		db	 00h, 00h, 00h, 00h,0FFh, 00h
		db	 00h, 00h, 00h, 00h 

ibmlogo11	db	04h, 0Ah                       ;@71f4
		db	 00h, 00h,0FFh, 00h,0F0h, 00h
		db	 00h, 00h, 0Fh, 0Bh, 00h, 00h
		db	0F0h, 00h, 00h, 00h, 00h, 00h
		db	0FFh,0BBh,0FFh,0BBh, 00h, 00h
		db	 00h, 00h, 0Fh, 0Bh,0F0h,0B0h
		db	0F0h,0B0h, 00h, 00h, 0Fh, 0Bh
		db	0FFh,0B0h, 00h, 00h, 00h, 00h
		db	 0Fh, 0Dh,0F0h,0D0h, 00h, 00h
		db	 00h, 00h,0FFh,0DDh,0F0h,0D0h
		db	 00h, 00h, 0Fh, 0Dh, 00h, 00h
		db	0F0h,0D0h, 00h, 00h, 00h, 00h
		db	0F0h, 00h,0F0h,0D0h, 00h, 00h
		db	 00h, 00h, 00h, 00h,0FFh, 00h
		db	 00h, 00h 
		
ibmlogo12	db	04h, 0Ah, 00h, 00h	       ;@7246
		db	0FFh, 00h, 00h, 00h, 00h, 00h
		db	0F0h, 00h, 0Fh, 00h,0F0h, 00h
		db	 00h, 00h, 0Fh, 0Bh,0FFh,0BBh
		db	0FFh,0BBh, 00h, 00h, 00h, 00h
		db	 0Fh, 0Bh,0F0h,0B0h,0F0h,0B0h
		db	 00h, 00h, 0Fh, 0Bh,0F0h,0B0h
		db	0F0h, 00h, 00h, 00h, 0Fh, 0Dh
		db	0F0h,0D0h, 00h, 00h, 0Fh, 0Dh
		db	0FFh,0DDh,0FFh,0DDh, 00h, 00h
		db	0FFh, 00h, 00h, 00h, 00h, 00h
		db	0F0h,0D0h, 00h, 00h, 00h, 00h
		db	 00h, 00h, 0Fh
		db	9 dup (0)
		
ibmlogo13	db	 04h, 0Ah, 00h, 00h, 00h, 00h  ;@7298
		db	0FFh, 00h, 00h, 00h, 00h, 00h
		db	 0Fh, 00h,0F0h, 00h, 0Fh, 00h
		db	 00h, 00h,0FFh,0BBh,0FFh,0BBh
		db	0F0h,0B0h, 0Fh, 0Bh, 0Fh, 0Bh
		db	0F0h,0B0h, 00h, 00h, 0Fh, 00h
		db	 0Fh, 0Bh,0F0h,0B0h, 00h, 00h
		db	 00h, 00h, 0Fh, 0Dh,0F0h,0D0h
		db	 00h, 00h, 00h, 00h,0FFh,0DDh
		db	0FFh,0DDh,0F0h,0D0h, 0Fh, 0Dh
		db	 00h, 00h, 00h, 00h,0FFh, 00h
		db	0F0h
		db	15 dup (0)
	 
ibmlogo14	db	 04h, 0Ah
		db	16 dup (0)
		db	0F0h, 00h, 0Fh, 00h,0F0h, 00h
		db	 0Fh, 00h, 0Fh, 0Bh, 0Fh, 00h
		db	0F0h, 00h,0F0h,0B0h, 00h, 00h
		db	0FFh,0BBh,0FFh,0BBh, 00h, 00h
		db	 00h, 00h, 0Fh, 0Bh,0F0h,0B0h
		db	 00h, 00h,0F0h, 00h, 0Fh, 0Dh
		db	0F0h,0D0h, 0Fh, 00h,0FFh,0DDh
		db	0FFh,0DDh,0FFh,0DDh,0FFh,0DDh
		db	16 dup (0)
	 
ibmlogo15	db	 04h, 0Ah
		db	8 dup (0)
		db	 0Fh, 00h, 00h, 00h, 0Fh, 00h
		db	0F0h,0D0h, 00h, 00h,0F0h,0B0h
		db	 00h, 00h,0F0h,0D0h, 00h, 00h
		db	 0Fh, 0Bh, 00h, 00h,0F0h,0D0h
		db	 0Fh, 00h,0FFh, 0Bh,0FFh,0BDh
		db	0F0h,0D0h, 0Fh, 00h,0FFh, 0Bh
		db	0FFh,0BDh,0F0h,0D0h, 00h, 00h
		db	 0Fh, 0Bh, 00h, 00h,0F0h,0D0h
		db	 00h, 00h,0F0h,0B0h, 00h, 00h
		db	0F0h,0D0h, 0Fh, 00h, 00h, 00h
		db	 0Fh, 00h,0F0h,0D0h, 00h
		db	7 dup (0)
		
ibmlogo16	db	 04h, 0Ah
		db	16 dup (0)
		db	0FFh,0DDh,0FFh,0DDh,0FFh,0DDh
		db	0FFh,0DDh,0F0h, 00h, 0Fh, 0Dh
		db	0F0h,0D0h, 0Fh, 00h, 00h, 00h
		db	 0Fh, 0Bh,0F0h,0B0h, 00h, 00h
		db	 00h, 00h,0FFh,0BBh,0FFh,0BBh
		db	 00h, 00h, 0Fh, 0Bh, 0Fh, 00h
		db	0F0h, 00h,0F0h,0B0h,0F0h, 00h
		db	 0Fh, 00h,0F0h, 00h, 0Fh
		db	7 dup (0)
		db	0
		db	9 dup (0)
		
ibmlogo17	db	 04h, 0Ah			;@73e0
		db	8 dup (0)
		db	 0Fh, 0Dh,0F0h, 00h, 00h, 00h
		db	0F0h, 00h, 0Fh, 0Dh, 00h, 00h
		db	 0Fh, 0Bh, 00h, 00h, 0Fh, 0Dh
		db	 00h, 00h,0F0h,0B0h, 00h, 00h
		db	 0Fh, 0Dh,0FFh,0DBh,0FFh,0B0h
		db	0F0h, 00h, 0Fh, 0Dh,0FFh,0DBh
		db	0FFh,0B0h,0F0h, 00h, 0Fh, 0Dh
		db	 00h, 00h,0F0h,0B0h
        	db	0  
		db	 00h, 0Fh, 0Dh, 00h, 00h, 0Fh
		db	 0Bh, 00h, 00h, 0Fh, 0Dh,0F0h
		db	 00h, 00h, 00h,0F0h
		db	9 dup (0)
	
ibmlogo18	db	4
		db	 0Ah, 00h, 00h,0F0h, 00h, 0Fh
		db	 00h, 00h, 00h,0F0h, 00h, 00h
		db	 00h
		db	0
		db	 00h, 0Fh
		db	9 dup (0)
		db	 0Fh, 00h, 0Fh, 00h,0F0h, 00h
		db	0F0h
		db	 00h, 00h, 00h, 0Fh, 00h,0F0h
		db	 00h, 00h, 00h, 00h, 00h,0FFh
		db	0BBh,0FFh,0BBh, 00h, 00h
		db	0Fh
		db	 0Bh, 0Fh, 0Bh,0F0h,0B0h,0F0h
		db	0B0h,0F0h, 00h, 0Fh, 0Bh,0F0h
		db	0B0h, 0Fh, 00h,0F0h, 00h, 0Fh
		db	 0Dh,0F0h,0D0h, 0Fh, 00h,0FFh
		db	0DDh,0FFh,0DDh,0FFh,0DDh,0FFh
		db	0DDh 
		
ibmlogo19	db	04h, 0Ah, 0Fh, 00h, 00h
		db	 00h,0F0h, 00h,0F0h
		db	9 dup (0)
		db	0F0h, 00h, 00h, 00h, 00h, 00h
		db	 0Fh, 00h, 00h, 00h,0FFh, 00h
		db	0FFh, 00h, 00h, 00h, 00h, 00h
		db	 0Fh, 00h,0F0h, 00h, 00h, 00h
		db	 00h, 00h,0FFh,0BBh,0FFh,0BBh
		db	 00h, 00h, 0Fh, 0Bh, 0Fh, 0Bh
		db	0F0h,0B0h,0F0h,0B0h,0F0h, 00h
		db	 0Fh, 0Bh,0F0h,0B0h, 0Fh, 00h
		db	0F0h, 00h, 0Fh, 0Dh,0F0h,0D0h
		db	 0Fh, 00h,0FFh,0DDh,0FFh,0DDh
		db	0FFh,0DDh,0FFh,0DDh

ibmcgaoffset3	db	04h, 08h
		db	0FFh, 99h, 00h, 00h, 00h, 00h
		db	0FFh, 99h,0FFh, 99h, 00h, 00h
		db	 00h, 00h,0FFh, 99h,0FFh, 99h
		db	 00h, 00h, 00h, 00h,0FFh, 99h
		db	0FFh, 99h, 00h, 00h, 00h, 00h
		db	0FFh, 99h,0FFh, 99h,0FFh, 99h
		db	0FFh, 99h,0FFh, 99h,0FFh, 99h
		db	0FFh, 99h,0FFh, 99h,0FFh, 99h
		db	0FFh, 99h, 00h, 00h, 00h, 00h
		db	0FFh, 99h,0FFh, 99h, 00h, 00h
		db	 00h, 00h,0FFh, 99h

ibmcgaoffset2	db	02h, 06h 			;@7518
		db	0FFh,0EEh,0FFh,0EEh,0FFh,0EEh
		db	0FFh,0EEh,0F0h,0E0h,0F0h,0E0h
		db	0F0h,0E0h,0F0h,0E0h,0FFh,0EEh
		db	0FFh,0EEh,0FFh,0EEh,0FFh,0EEh
		
ibmcgaoffset1	db	 02h, 06h, 08h, 80h, 08h, 80h   ;@7532
		db	 80h, 08h, 80h, 08h, 08h, 80h
		db	 08h, 80h 
		
ibmcgaoffset5	db	01h, 08h,0F0h,0C0h		;@7540
		db	0F0h,0C0h, 0Fh, 0Ch, 0Fh, 0Ch
		db	0F0h,0C0h,0F0h,0C0h, 0Fh, 0Ch
		db	 0Fh, 0Ch 
		
ibmcgaoffset6	db	01h, 08h,0F0h,0B0h		;@7552
		db	0F0h,0B0h,0F0h,0B0h,0F0h,0B0h
		db	 0Fh, 0Bh, 0Fh, 0Bh, 0Fh, 0Bh
		db	 0Fh, 0Bh
		
ibmcgaoffset4	db	 20h, 02h, 25h, 00h
		db	 00h, 00h, 00h,0FFh,0FFh,0F0h
		db	 0Fh,0FFh,0FFh, 00h, 0Fh,0FFh
		db	0FFh, 00h,0FFh,0FFh,0F0h, 00h
		db	 00h, 00h, 00h, 00h,0FFh,0FFh
		db	0F0h, 0Fh,0FFh,0FFh,0FFh,0FFh
		db	0F0h, 00h, 00h, 00h,0FFh,0FFh
		db	0F0h, 00h, 00h, 00h, 00h, 00h
		db	0FFh,0FFh,0F0h, 00h, 00h, 00h
		db	 0Fh,0FFh,0FFh, 00h, 00h, 00h
		db	 00h,0FFh,0FFh,0F0h, 00h, 00h
		db	0FFh,0FFh,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0F0h, 00h, 00h, 00h, 00h
		db	 00h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 11h, 11h, 11h, 1Fh,0F0h, 00h
		db	 00h,0F1h, 11h,0F0h, 00h, 00h
		db	 00h, 00h, 00h,0F1h, 11h,0F0h
		db	 00h, 00h, 00h, 0Fh, 11h, 1Fh
		db	 00h, 00h, 00h, 00h,0F1h, 11h
		db	0F0h, 00h, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 1Fh, 00h, 00h, 00h, 00h
		db	 0Fh, 11h, 11h,0F0h, 0Fh, 11h
		db	 11h, 11h, 11h, 11h, 1Fh, 00h
		db	 00h,0F1h, 11h, 1Fh, 00h, 00h
		db	 00h, 00h, 0Fh, 11h, 11h,0F0h
		db	 00h, 00h, 00h, 0Fh, 11h, 1Fh
		db	 00h, 00h, 00h, 00h,0F1h, 11h
		db	 1Fh, 00h, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 1Fh, 00h, 00h, 00h, 00h
		db	 0Fh, 11h, 11h,0F0h, 0Fh, 11h
		db	 11h, 11h, 11h, 11h, 1Fh, 00h
		db	 00h,0F1h, 11h, 1Fh, 00h, 00h
		db	 00h, 00h, 0Fh, 11h, 11h,0F0h
		db	 00h, 00h, 00h, 0Fh, 11h, 1Fh
		db	 00h, 00h, 00h, 00h,0F1h, 11h
		db	 1Fh, 00h, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 1Fh, 00h, 00h, 00h, 00h
		db	 0Fh, 11h, 11h,0F0h, 0Fh, 11h
		db	 11h, 11h, 11h, 11h, 1Fh, 00h
		db	 00h,0F1h, 11h, 1Fh, 00h, 00h
		db	 00h, 00h, 0Fh, 11h, 11h,0F0h
		db	 00h, 00h, 00h,0F1h, 11h, 11h
		db	0F0h, 00h, 00h, 00h,0F1h, 11h
		db	 1Fh, 00h, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 1Fh, 00h, 00h, 00h, 00h
		db	 0Fh, 11h, 11h,0F0h, 0Fh, 11h
		db	 1Fh,0FFh,0FFh, 11h, 11h,0F0h
		db	 00h,0F1h, 11h, 1Fh, 00h, 00h
		db	 00h, 00h, 0Fh, 11h, 11h,0F0h
		db	 00h, 00h, 00h,0F1h, 11h, 11h
		db	0F0h, 00h, 00h, 00h,0F1h, 11h
		db	 1Fh, 00h, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 11h,0F0h, 00h, 00h, 00h
		db	0F1h, 11h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h,0F1h, 11h,0F0h
		db	 00h,0F1h, 11h, 11h,0F0h, 00h
		db	 00h, 00h,0F1h, 11h, 11h,0F0h
		db	 00h, 00h, 00h,0F1h, 11h, 11h
		db	0F0h, 00h, 00h, 00h,0F1h, 11h
		db	 11h,0F0h, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 11h,0F0h, 00h, 00h, 00h
		db	0F1h, 11h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h,0F1h, 11h,0F0h
		db	 00h,0F1h, 11h, 11h,0F0h, 00h
		db	 00h, 00h,0F1h, 11h, 11h,0F0h
		db	 00h, 00h, 00h,0F1h, 11h, 11h
		db	0F0h, 00h, 00h, 00h,0F1h, 11h
		db	 11h,0F0h, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 11h,0F0h, 00h, 00h, 00h
		db	0F1h, 11h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 0Fh, 11h, 1Fh
		db	 00h,0F1h, 11h, 11h,0F0h, 00h
		db	 00h, 00h,0F1h, 11h, 11h,0F0h
		db	 00h, 00h, 00h,0F1h, 11h, 11h
		db	0F0h, 00h, 00h, 00h,0F1h, 11h
		db	 11h,0F0h, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 11h,0F0h, 00h, 00h, 00h
		db	0F1h, 11h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 0Fh, 11h, 1Fh
		db	 00h,0F1h, 11h, 11h,0F0h, 00h
		db	 00h, 00h,0F1h, 11h, 11h,0F0h
		db	 00h, 00h, 00h,0F1h, 11h, 11h
		db	0F0h, 00h, 00h, 00h,0F1h, 11h
		db	 11h,0F0h, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 11h, 1Fh, 00h, 00h, 0Fh
		db	 11h, 11h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 0Fh, 11h, 1Fh
		db	 00h,0F1h, 11h, 11h, 1Fh, 00h
		db	 00h, 0Fh, 11h, 11h, 11h,0F0h
		db	 00h, 00h, 0Fh, 11h, 11h, 11h
		db	 1Fh, 00h, 00h, 00h,0F1h, 11h
		db	 11h, 1Fh, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 11h, 1Fh, 00h, 00h, 0Fh
		db	 11h, 11h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 0Fh, 11h, 1Fh
		db	 00h,0F1h, 11h, 11h, 1Fh, 00h
		db	 00h, 0Fh, 11h, 11h, 11h,0F0h
		db	 00h, 00h, 0Fh, 11h, 11h, 11h
		db	 1Fh, 00h, 00h, 00h,0F1h, 11h
		db	 11h, 1Fh, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 11h, 1Fh, 00h, 00h, 0Fh
		db	 11h, 11h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 0Fh, 11h, 1Fh
		db	 00h,0F1h, 11h, 11h, 1Fh, 00h
		db	 00h, 0Fh, 11h, 11h, 11h,0F0h
		db	 00h, 00h, 0Fh, 11h, 11h, 11h
		db	 1Fh, 00h, 00h, 00h,0F1h, 11h
		db	 11h, 1Fh, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 11h, 1Fh, 00h, 00h, 0Fh
		db	 11h, 11h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 0Fh, 11h, 1Fh
		db	 00h,0F1h, 11h, 11h, 1Fh, 00h
		db	 00h, 0Fh, 11h, 11h, 11h,0F0h
		db	 00h, 00h, 0Fh, 11h, 11h, 11h
		db	 1Fh, 00h, 00h, 00h,0F1h, 11h
		db	 11h, 1Fh, 00h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 11h, 11h,0F0h, 00h,0F1h
		db	 11h, 11h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 0Fh, 11h, 1Fh
		db	 00h,0F1h, 11h, 11h, 11h,0F0h
		db	 00h,0F1h, 11h, 11h, 11h,0F0h
		db	 00h, 00h, 0Fh, 11h, 11h, 11h
		db	 1Fh, 00h, 00h, 00h,0F1h, 11h
		db	 11h, 11h,0F0h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h, 11h, 11h,0F0h, 00h,0F1h
		db	 11h, 11h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 0Fh, 11h, 1Fh
		db	 00h,0F1h, 11h, 11h, 11h,0F0h
		db	 00h,0F1h, 11h, 11h, 11h,0F0h
		db	 00h, 00h, 0Fh, 11h, 11h, 11h
		db	 1Fh, 00h, 00h, 00h,0F1h, 11h
		db	 11h, 11h,0F0h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0F1h, 11h,0F0h, 00h,0F1h
		db	 11h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h,0F1h, 11h,0F0h
		db	 00h,0F1h, 11h,0F1h, 11h,0F0h
		db	 00h,0F1h, 11h,0F1h, 11h,0F0h
		db	 00h, 00h,0F1h, 11h, 11h, 11h
		db	 11h,0F0h, 00h, 00h,0F1h, 11h
		db	0F1h, 11h,0F0h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0F1h, 11h,0F0h, 00h,0F1h
		db	 11h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h,0F1h, 11h,0F0h
		db	 00h,0F1h, 11h,0F1h, 11h,0F0h
		db	 00h,0F1h, 11h,0F1h, 11h,0F0h
		db	 00h, 00h,0F1h, 11h, 1Fh, 11h
		db	 11h,0F0h, 00h, 00h,0F1h, 11h
		db	0F1h, 11h,0F0h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0F1h, 11h, 1Fh, 0Fh, 11h
		db	 11h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 1Fh,0FFh,0FFh, 11h, 11h,0F0h
		db	 00h,0F1h, 11h,0F1h, 11h, 1Fh
		db	 0Fh, 11h, 11h,0F1h, 11h,0F0h
		db	 00h, 00h,0F1h, 11h,0F0h,0F1h
		db	 11h,0F0h, 00h, 00h,0F1h, 11h
		db	0F1h, 11h, 1Fh,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0F1h, 11h, 1Fh, 0Fh, 11h
		db	 11h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 11h, 11h, 11h, 11h, 1Fh, 00h
		db	 00h,0F1h, 11h,0F1h, 11h, 1Fh
		db	 0Fh, 11h, 11h,0F1h, 11h,0F0h
		db	 00h, 00h,0F1h, 11h,0F0h,0F1h
		db	 11h,0F0h, 00h, 00h,0F1h, 11h
		db	0F1h, 11h, 1Fh,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0FFh, 11h, 1Fh, 0Fh, 11h
		db	 1Fh,0F1h, 11h,0F0h, 0Fh, 11h
		db	 11h, 11h, 11h, 11h, 1Fh, 00h
		db	 00h,0F1h, 11h,0FFh, 11h, 1Fh
		db	 0Fh, 11h, 1Fh,0F1h, 11h,0F0h
		db	 00h, 00h,0F1h, 11h,0F0h,0F1h
		db	 11h,0F0h, 00h, 00h,0F1h, 11h
		db	0FFh, 11h, 1Fh,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0FFh, 11h, 1Fh, 0Fh, 11h
		db	 1Fh,0F1h, 11h,0F0h, 0Fh, 11h
		db	 11h, 11h, 11h, 11h, 1Fh, 00h
		db	 00h,0F1h, 11h,0FFh, 11h, 1Fh
		db	 0Fh, 11h, 1Fh,0F1h, 11h,0F0h
		db	 00h, 00h,0F1h, 11h,0F0h,0F1h
		db	 11h,0F0h, 00h, 00h,0F1h, 11h
		db	0FFh, 11h, 1Fh,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0FFh, 11h, 11h,0F1h, 11h
		db	 1Fh,0F1h, 11h,0F0h, 0Fh, 11h
		db	 11h, 11h, 11h, 1Fh,0F0h, 00h
		db	 00h,0F1h, 11h,0FFh, 11h, 11h
		db	0F1h, 11h, 1Fh,0F1h, 11h,0F0h
		db	 00h, 0Fh, 11h, 1Fh, 00h, 0Fh
		db	 11h, 1Fh, 00h, 00h,0F1h, 11h
		db	0FFh, 11h, 11h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0FFh,0F1h, 11h,0F1h, 11h
		db	0FFh,0F1h, 11h,0F0h, 0Fh, 11h
		db	 1Fh,0FFh,0FFh,0F0h, 00h, 00h
		db	 00h,0F1h, 11h,0FFh,0F1h, 11h
		db	0F1h, 11h,0FFh,0F1h, 11h,0F0h
		db	 00h, 0Fh, 11h, 1Fh,0FFh,0FFh
		db	 11h, 1Fh, 00h, 00h,0F1h, 11h
		db	0FFh,0F1h, 11h,0F1h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0F0h,0F1h, 11h, 11h, 11h
		db	0F0h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 00h, 00h, 00h
		db	 00h,0F1h, 11h,0F0h,0F1h, 11h
		db	 11h, 11h,0F0h,0F1h, 11h,0F0h
		db	 00h, 0Fh, 11h, 11h, 11h, 11h
		db	 11h, 1Fh, 00h, 00h,0F1h, 11h
data_382	db	0F0h			; Data table (indexed access)
		db	0F1h, 11h, 11h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0F0h,0F1h, 11h, 11h, 11h
		db	0F0h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 00h, 00h, 00h
		db	 00h,0F1h, 11h,0F0h,0F1h, 11h
		db	 11h, 11h,0F0h,0F1h, 11h,0F0h
		db	 00h, 0Fh, 11h, 11h, 11h, 11h
		db	 11h, 1Fh, 00h, 00h,0F1h, 11h
		db	0F0h,0F1h, 11h, 11h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0F0h, 0Fh, 11h, 11h, 1Fh
		db	 00h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 00h, 00h, 00h
		db	 00h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 11h, 1Fh, 00h,0F1h, 11h,0F0h
		db	 00h, 0Fh, 11h, 11h, 11h, 11h
		db	 11h, 1Fh, 00h, 00h,0F1h, 11h
		db	0F0h, 0Fh, 11h, 11h, 11h,0F0h
		
		db	8 dup (0)
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0F0h, 0Fh, 11h, 11h, 1Fh
		db	 00h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 00h, 00h, 00h
		db	 00h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 11h, 1Fh, 00h,0F1h, 11h,0F0h
		db	 00h, 0Fh, 11h, 11h, 11h, 11h
		db	 11h, 1Fh, 00h, 00h,0F1h, 11h
		db	0F0h, 0Fh, 11h, 11h, 11h,0F0h
		db	 00h, 00h, 00h, 00h, 00h,0FFh
		db	0FFh,0F0h,0F1h, 11h,0F0h, 0Fh
		db	 11h, 1Fh, 00h, 0Fh, 11h, 1Fh
		db	 00h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 11h, 1Fh, 00h,0F1h, 11h,0F0h
		db	 0Fh, 11h, 1Fh, 00h, 00h, 00h
		db	 00h, 00h, 00h,0F1h, 11h,0F0h
		db	 0Fh, 11h, 11h, 1Fh, 00h,0F1h
		db	 11h,0F0h, 00h,0F1h, 11h, 1Fh
		db	0FFh,0FFh, 11h, 11h,0F0h, 00h
		db	0F1h, 11h,0F0h, 0Fh, 11h, 11h
		db	 11h,0F0h, 00h, 00h, 00h, 00h
		db	 00h,0F1h, 11h,0F0h,0F1h, 11h
		db	0F0h, 0Fh, 11h, 1Fh, 00h, 0Fh
		db	 11h, 1Fh, 00h,0F1h, 11h,0F0h
		db	 00h,0F1h, 11h,0F0h, 00h,0F1h
		db	 11h,0F0h, 0Fh, 11h, 1Fh, 00h
		db	 00h, 00h, 00h, 00h, 00h,0F1h
		db	 11h,0F0h, 00h,0F1h, 11h,0F0h
		db	 00h,0F1h, 11h,0F0h, 00h,0F1h
		db	 11h, 1Fh, 00h, 0Fh, 11h, 11h
		db	0F0h, 00h,0F1h, 11h,0F0h, 00h
		db	0F1h, 11h, 11h,0F0h, 00h, 00h
		db	 00h, 00h, 00h,0F1h, 11h,0F0h
		db	0F1h, 11h,0F0h, 0Fh, 11h, 1Fh
		db	 00h, 0Fh, 11h, 1Fh, 00h,0F1h
		db	 11h,0F0h, 00h,0F1h, 11h,0F0h
		db	 00h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 00h, 00h, 00h
		db	 00h,0F1h, 11h,0F0h, 00h,0F1h
		db	 11h,0F0h, 00h,0F1h, 11h,0F0h
		db	 00h,0F1h, 11h, 1Fh, 00h, 0Fh
		db	 11h, 11h,0F0h, 00h,0F1h, 11h
		db	0F0h, 00h,0F1h, 11h, 11h,0F0h
		db	 00h, 00h, 00h, 00h, 00h,0F1h
		db	 11h, 1Fh, 11h, 11h,0F0h, 0Fh
		db	 11h, 11h,0FFh,0F1h, 11h, 1Fh
		db	 00h,0F1h, 11h,0F0h, 00h,0F1h
		db	 11h,0F0h, 00h,0F1h, 11h,0F0h
		db	 0Fh, 11h, 1Fh, 00h, 00h, 00h
		db	 00h, 00h, 00h,0F1h, 11h,0F0h
		db	 00h,0F1h, 11h,0F0h, 00h,0F1h
		db	 11h,0F0h, 00h,0F1h, 11h,0F0h
		db	 00h, 00h,0F1h, 11h,0F0h, 00h
		db	0F1h, 11h,0F0h, 00h,0F1h, 11h
		db	 11h,0F0h, 00h, 00h, 00h, 00h
		db	 00h,0F1h, 11h, 11h, 11h, 11h
		db	0F0h, 0Fh, 11h, 11h, 11h, 11h
		db	 11h, 1Fh, 00h,0F1h, 11h,0F0h
		db	 00h, 0Fh, 1Fh, 00h, 00h,0F1h
		db	 11h,0F0h, 0Fh, 11h, 1Fh, 00h
		db	 00h, 00h, 00h, 00h, 00h,0F1h
		db	 11h,0F0h, 00h, 0Fh, 1Fh, 00h
		db	 00h,0F1h, 11h,0F0h, 00h,0F1h
		db	 11h,0F0h, 00h, 00h,0F1h, 11h
		db	0F0h, 00h,0F1h, 11h,0F0h, 00h
		db	 0Fh, 11h, 11h,0F0h, 0Fh,0FFh
		db	 0Fh, 00h, 0Fh, 0Fh, 11h, 11h
		db	 11h, 1Fh, 00h, 00h,0F1h, 11h
		db	 11h, 11h, 11h,0F0h, 00h,0F1h
		db	 11h
        	db	0F0h
		db	 00h, 0Fh, 1Fh, 00h, 00h,0F1h
		db	 11h,0F0h, 0Fh, 11h, 1Fh, 00h
		db	 00h, 00h, 00h, 00h, 00h,0F1h
		db	 11h,0F0h, 00h, 0Fh, 1Fh, 00h
		db	 00h,0F1h, 11h,0F0h, 00h,0F1h
		db	 11h,0F0h, 00h, 00h,0F1h, 11h
		db	0F0h, 00h,0F1h, 11h,0F0h, 00h
		db	 0Fh, 11h, 11h,0F0h, 00h,0F0h
		db	 0Fh,0F0h,0FFh, 0Fh, 11h, 11h
		db	 11h, 1Fh, 00h, 00h,0F1h, 11h
		db	 11h, 11h, 11h,0F0h, 00h,0F1h
		db	 11h,0F0h, 00h, 0Fh, 1Fh, 00h
		db	 00h,0F1h, 11h,0F0h, 0Fh, 11h
		db	 1Fh, 00h, 00h, 00h, 00h, 00h
		db	 00h,0F1h, 11h,0F0h, 00h, 0Fh
		db	 1Fh, 00h, 00h,0F1h, 11h,0F0h
		db	 0Fh, 11h, 11h,0F0h, 00h, 00h
		db	0F1h, 11h, 1Fh, 00h,0F1h, 11h
		db	0F0h, 00h, 0Fh, 11h, 11h,0F0h
		db	 00h,0F0h, 0Fh, 0Fh, 0Fh, 00h
		db	0F1h, 11h, 11h,0F0h, 00h, 00h
		db	 0Fh, 11h, 11h, 11h, 1Fh, 00h
		db	 00h,0F1h, 11h,0F0h, 00h, 00h
		db	0F0h, 00h, 00h,0F1h, 11h,0F0h
		db	 0Fh, 11h, 1Fh, 00h, 00h, 00h
		db	 00h, 00h, 00h,0F1h, 11h,0F0h
		db	 00h, 00h,0F0h, 00h, 00h,0F1h
		db	 11h,0F0h, 0Fh, 11h, 1Fh, 00h
		db	 00h, 00h, 0Fh, 11h, 1Fh, 00h
		db	0F1h, 11h,0F0h, 00h, 00h,0F1h
		db	 11h,0F0h, 00h,0F0h, 0Fh, 00h
		db	 0Fh, 00h, 0Fh,0FFh,0FFh, 00h
		db	 00h, 00h, 00h,0FFh,0FFh,0FFh
		db	0F0h, 00h, 00h,0FFh,0FFh,0F0h
		db	 00h, 00h,0F0h, 00h, 00h,0FFh
		db	0FFh,0F0h, 0Fh,0FFh,0FFh, 00h
		db	 00h, 00h, 00h, 00h, 00h,0FFh
         	dw	0F0FFh			; Data table (indexed access)
		db	 00h, 00h,0F0h, 00h, 00h,0FFh
		db	0FFh,0F0h, 0Fh,0FFh,0FFh, 00h
		db	 00h, 00h, 0Fh,0FFh,0FFh, 00h
		db	0FFh,0FFh,0F0h, 00h, 00h,0FFh
		db	0FFh
		db	0F0h, 00h,0F0h, 0Fh, 00h
		db	 0Fh 
ibmlogo:		
		db	40h, 01h, 35h, 00h, 22h
		db	 22h, 22h, 22h, 22h, 22h, 22h
		db	 00h
		db	22h
		db	9 dup (22h)
		db	 00h, 00h, 00h, 02h, 22h, 22h
		db	 22h, 22h, 20h, 00h
		db	7 dup (0)
		db	12 dup (22h)
		db	 00h, 22h
		db	9 dup (22h)
		db	 20h, 00h, 00h, 02h, 22h, 22h
		db	 22h, 22h, 20h, 00h
		db	7 dup (0)
		db	12 dup (22h)
		db	 00h, 22h
		db	10 dup (22h)
		db	0, 0, 2
		db	 22h, 22h, 22h, 22h, 22h
		db	7 dup (0)
		db	 02h, 22h
		db	11 dup (22h)
		db	 00h, 22h
		db	10 dup (22h)
		db	 20h, 00h, 02h
		db	 22h, 22h, 22h, 22h, 22h
		db	7 dup (0)
		db	 02h, 22h, 22h, 22h, 22h, 22h
		db	32 dup (0)




logos:

db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 00h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 020h, 02h 
db 022h, 022h, 022h, 022h, 022h, 020h, 00h, 00h, 00h, 00h 
db 00h, 00h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 020h, 02h, 022h, 022h, 022h, 022h, 022h, 020h, 00h, 00h 
db 00h, 00h, 00h, 02h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 020h, 02h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 00h 
db 00h, 00h, 00h, 02h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 020h, 02h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 00h 
db 00h, 00h, 00h, 022h, 022h, 022h, 022h, 022h, 022h, 022h
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h 
db 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h, 00h, 022h, 022h, 022h, 020h, 00h, 00h, 02h, 022h, 022h 
db 022h, 022h, 020h, 00h, 00h, 00h, 00h, 022h, 022h, 022h 
db 022h, 022h, 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h 
db 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h 
db 00h, 022h, 022h, 022h, 020h, 00h, 00h, 02h, 022h, 022h 
db 022h, 022h, 022h, 00h, 00h, 00h, 02h, 022h, 022h, 022h 
db 022h, 022h, 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h 
db 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h 
db 00h, 022h, 022h, 022h, 020h, 00h, 00h, 02h, 022h, 022h 
db 022h, 022h, 022h, 00h, 00h, 00h, 02h, 022h, 022h, 022h 
db 022h, 022h, 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h 
db 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h 
db 00h, 022h, 022h, 022h, 00h, 00h, 00h, 02h, 022h, 022h, 022h, 022h, 022h, 020h, 00h, 00h, 02h, 022h
db 022h, 022h, 022h, 022h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 022h, 022h, 022h, 00h, 00h, 00h, 00h, 00h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 020h, 00h, 00h 
db 00h, 02h, 022h, 022h, 022h, 022h, 022h, 020h, 00h, 02h 
db 022h, 022h, 022h, 022h, 022h, 022h, 00h, 00h, 00h, 00h 
db 022h, 022h, 022h, 00h, 00h, 00h, 00h, 00h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 00h, 00h 
db 00h, 02h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 02h 
db 022h, 022h, 022h, 022h, 022h, 022h, 00h, 00h, 00h, 00h 
db 022h, 022h, 022h, 00h, 00h, 00h, 00h, 00h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 020h, 00h, 00h, 00h 
db 00h, 02h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 02h 
db 022h, 022h, 022h, 022h, 022h, 022h, 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h, 00h, 00h
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 00h 
db 00h, 00h, 00h, 02h, 022h, 022h, 022h, 022h, 022h, 022h 
db 00h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h 
db 00h, 00h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 00h, 00h, 00h, 00h, 00h, 02h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h
db 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h 
db 00h, 00h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 020h, 00h, 00h, 00h, 00h, 02h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h 
db 00h, 00h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 00h, 00h, 00h, 02h, 022h, 022h
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h 
db 00h, 00h, 00h, 00h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 020h, 00h, 00h, 00h, 02h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 022h, 022h 
db 022h, 00h, 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h 
db 00h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h, 02h 
db 022h, 022h, 020h, 00h, 022h, 022h, 022h, 022h, 022h, 020h 
db 00h, 022h, 022h, 022h, 00h, 00h, 00h, 00h, 022h, 022h 
db 022h, 00h, 00h, 00h, 00h, 00h, 022h, 022h, 022h, 00h 
db 00h, 00h, 00h, 022h, 022h, 022h, 020h, 00h, 00h, 02h 
db 022h, 022h, 020h, 00h, 022h, 022h, 022h, 022h, 022h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h, 00h
db 022h, 022h, 022h, 00h, 00h, 00h, 00h, 00h, 022h, 022h 
db 022h, 00h, 00h, 00h, 00h, 022h, 022h, 022h, 020h, 00h 
db 00h, 02h, 022h, 022h, 020h, 00h, 02h, 022h, 022h, 022h 
db 022h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h, 00h 
db 022h, 022h, 022h, 00h, 00h, 00h, 00h, 00h, 022h, 022h 
db 022h, 00h, 00h, 00h, 00h, 022h, 022h, 022h, 020h, 00h 
db 00h, 02h, 022h, 022h, 020h, 00h, 02h, 022h, 022h, 022h 
db 022h, 00h, 00h, 022h, 022h, 022h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 020h, 02h, 022h, 022h, 022h, 022h, 020h, 00h, 00h, 022h 
db 022h, 022h, 020h, 00h, 00h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 00h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h
db 022h, 022h, 020h, 02h, 022h, 022h, 022h, 022h, 020h, 00h 
db 00h, 022h, 022h, 022h, 00h, 00h, 00h, 022h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 00h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 020h, 02h, 022h, 022h, 022h, 022h, 020h, 00h 
db 00h, 02h, 022h, 022h, 00h, 00h, 00h, 022h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 00h 
db 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 020h, 02h, 022h, 022h, 022h, 022h, 020h, 00h 
db 00h, 02h, 022h, 022h, 00h, 00h, 00h, 022h, 022h, 022h 
db 022h, 022h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 00h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 020h, 00h, 02h, 022h, 022h, 022h, 022h, 020h, 00h, 00h, 00h, 022h, 020h, 00h, 00h
db 00h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 00h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 020h, 00h, 02h, 022h, 022h 
db 022h, 022h, 020h, 00h, 00h, 00h, 022h, 020h, 00h, 00h 
db 00h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 00h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 022h, 022h, 00h, 00h, 02h, 022h, 022h 
db 022h, 022h, 020h, 00h, 00h, 00h, 02h, 00h, 00h, 00h 
db 00h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 00h, 022h, 022h, 022h, 022h, 022h, 022h 
db 022h, 022h, 022h, 022h, 020h, 00h, 00h, 02h, 022h, 022h 
db 022h, 022h, 020h, 00h, 00h, 00h, 02h, 00h, 00h, 00h, 00h, 022h, 022h, 022h, 022h, 022h, 00h, 00h
db 00h, 00h, 00h, 00h, 



epyxlogo db 05Ch, 01h, 02Ch, 00h, 00h, 00h 
db 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0Fh, 0FFh 
db 0FFh, 0FFh, 0FFh, 0FFh, 00h, 0Fh, 0FFh, 0F0h, 00h, 00h 
db 00h, 0FFh, 0FFh, 0F0h, 00h, 00h, 00h, 0Fh, 0FFh, 0F0h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 0Fh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh 
db 0FFh, 0FFh, 00h, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 00h 
db 0FFh, 0F0h, 00h, 00h, 00h, 0Fh, 0FFh, 0F0h, 00h, 00h 
db 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0Fh, 0FFh 
db 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 00h, 0FFh, 0FFh, 0FFh 
db 0FFh, 0FFh, 0FFh, 0F0h, 0FFh, 0F0h, 00h, 00h, 00h, 0FFh, 0FFh, 0FFh, 00h, 00h, 00h, 0Fh, 0FFh, 00h
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 0Fh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh 
db 0FFh, 0F0h, 0Fh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0F0h 
db 0FFh, 0F0h, 00h, 00h, 00h, 0FFh, 0FFh, 0FFh, 00h, 00h 
db 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0FFh 
db 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0F0h, 0Fh, 0FFh, 0FFh, 0FFh 
db 0FFh, 0FFh, 0FFh, 0F0h, 0Fh, 0FFh, 00h, 00h, 0Fh, 0FFh 
db 0Fh, 0FFh, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0F0h 
db 0Fh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0F0h, 0Fh, 0FFh, 00h, 00h, 0Fh, 0FFh, 00h, 0FFh, 0F0h, 00h
db 00h, 0FFh, 0F0h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0F0h 
db 00h, 00h, 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h 
db 00h, 00h, 0FFh, 0F0h, 0Fh, 0FFh, 00h, 00h, 0Fh, 0FFh 
db 00h, 0FFh, 0F0h, 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h, 00h, 00h, 00h 
db 0Fh, 0FFh, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 0Fh, 0FFh 
db 00h, 00h, 0FFh, 0F0h, 00h, 0FFh, 0F0h, 00h, 0Fh, 0FFh 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h 
db 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 0Fh, 0FFh, 00h, 00h, 0FFh, 0F0h 
db 00h, 0Fh, 0FFh, 00h, 0FFh, 0F0h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h, 00h, 00h, 00h 
db 0FFh, 0F0h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 0Fh, 0FFh 
db 00h, 0Fh, 0FFh, 00h, 00h, 0Fh, 0FFh, 00h, 0FFh, 0F0h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h, 0Fh 
db 0FFh, 00h, 0Fh, 0FFh, 00h, 0Fh, 0FFh, 00h, 00h, 0Fh 
db 0FFh, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0Fh 
db 0FFh, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 0Fh, 0FFh 
db 00h, 0Fh, 0FFh, 00h, 00h, 00h, 0FFh, 0FFh, 0FFh, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h, 0Fh 
db 0FFh, 00h, 00h, 0FFh, 0F0h, 0FFh, 0F0h, 00h, 00h, 00h 
db 0FFh, 0FFh, 0F0h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0Fh 
db 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 00h, 0FFh, 0F0h 
db 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 0FFh, 0F0h, 0FFh 
db 0F0h, 00h, 00h, 00h, 0FFh, 0FFh, 0F0h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 0Fh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 0FFh
db 0F0h, 00h, 00h, 0FFh, 0FFh, 0FFh, 00h, 00h, 00h, 00h 
db 0Fh, 0FFh, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0Fh 
db 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0F0h, 0Fh, 0FFh, 00h 
db 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 0FFh, 0FFh, 0FFh 
db 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh 
db 0F0h, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h 
db 00h, 0FFh, 0FFh, 0FFh, 00h, 00h, 00h, 00h, 0Fh, 0FFh 
db 0F0h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0F0h, 0Fh, 0FFh, 00h
db 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 0FFh, 0FFh, 0F0h 
db 00h, 00h, 00h, 00h, 0FFh, 0FFh, 0F0h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh 
db 0F0h, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h 
db 00h, 0FFh, 0FFh, 0F0h, 00h, 00h, 00h, 00h, 0FFh, 0FFh 
db 0F0h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h 
db 00h, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h 
db 0Fh, 0FFh, 00h, 00h, 00h, 0FFh, 0FFh, 00h, 00h, 00h 
db 00h, 0Fh, 0FFh, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h, 00h, 00h 
db 00h, 0FFh, 0F0h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h 
db 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 0Fh, 0FFh, 0Fh 
db 0FFh, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h 
db 00h, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h 
db 0Fh, 0FFh, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h 
db 00h, 0FFh, 0F0h, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 0Fh, 0FFh, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh 
db 0F0h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h, 0FFh 
db 0F0h, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 0FFh, 0F0h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h 
db 0Fh, 0FFh, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h 
db 0Fh, 0FFh, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 0Fh, 0FFh, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh 
db 0F0h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 0Fh, 0FFh 
db 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 0FFh, 0F0h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h 
db 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 0FFh, 0F0h 
db 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 0FFh, 0F0h 
db 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
db 0Fh, 0FFh, 00h, 00h, 00h, 00h, 00h, 00h, 0Fh, 0FFh 
db 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 0FFh, 0F0h 
db 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 0Fh, 0FFh 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h 
db 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h, 0Fh, 0FFh, 0F0h 
db 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h, 0Fh, 0FFh, 00h 
db 00h, 00h, 0Fh, 0FFh, 00h, 0Fh, 0FFh, 0Fh, 00h, 0Fh
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0FFh
db 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0F0h, 0Fh, 0FFh, 0FFh, 0FFh 
db 0FFh, 0FFh, 0FFh, 0F0h, 00h, 00h, 0FFh, 0F0h, 00h, 00h 
db 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 0F0h, 0Fh, 0F0h, 0FFh, 00h, 00h, 00h, 00h
db 00h, 00h, 00h, 00h, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh 
db 0FFh, 0F0h, 0Fh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 00h 
db 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h 
db 00h, 00h, 00h, 0FFh, 0F0h, 00h, 0F0h, 0Fh, 0Fh, 0Fh 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0FFh 
db 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0F0h, 0FFh, 0FFh, 0FFh, 0FFh 
db 0FFh, 0FFh, 0FFh, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h 
db 00h, 0FFh, 0F0h, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h 
db 0F0h, 0Fh, 00h, 0Fh, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0F0h 
db 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0F0h, 00h, 00h, 0FFh 
db 0F0h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h, 0F0h, 0Fh, 00h, 0Fh
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0FFh 
db 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 00h, 0FFh, 0FFh, 0FFh, 0FFh 
db 0FFh, 0FFh, 00h, 00h, 00h, 0FFh, 0FFh, 00h, 00h, 00h 
db 0Fh, 0FFh, 0F0h, 00h, 00h, 00h, 00h, 0Fh, 0FFh, 0F0h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 00h 
db 0FFh, 0F0h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0Fh 
db 0FFh, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 0Fh, 0FFh, 00h, 0Fh, 00h, 0Fh, 00h 
db 0F0h, 0F0h, 0FFh, 00h, 0F0h, 0F0h, 0FFh, 0F0h, 0FFh, 0F0h 
db 0FFh, 00h, 00h, 0Fh, 0F0h, 0Fh, 00h, 0FFh, 0F0h, 0FFh 
db 0F0h, 0F0h, 0F0h, 0F0h, 0Fh, 00h, 0FFh, 00h, 0FFh, 0F0h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h
db 0F0h, 0F0h, 0F0h, 0F0h, 0FFh, 0F0h, 0F0h, 0F0h, 0F0h, 0F0h, 0Fh, 00h, 0F0h, 00h, 0F0h, 0F0h, 00h, 0F0h
db 00h, 0F0h, 0F0h, 0F0h, 00h, 0Fh, 00h, 0F0h, 0F0h, 0F0h 
db 0F0h, 0F0h, 0F0h, 0F0h, 0F0h, 00h, 00h, 00h, 00h, 00h
db 00h, 00h, 00h, 0Fh, 0FFh, 00h, 0F0h, 00h, 0F0h, 0F0h 
db 0F0h, 0F0h, 0FFh, 00h, 0F0h, 0F0h, 0Fh, 00h, 0FFh, 00h 
db 0FFh, 00h, 00h, 0Fh, 00h, 0F0h, 0F0h, 0FFh, 00h, 0Fh 
db 00h, 0F0h, 0F0h, 0F0h, 0F0h, 0F0h, 0FFh, 00h, 0FFh, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0Fh, 0FFh, 00h 
db 0F0h, 0F0h, 0F0h, 0F0h, 0F0h, 0F0h, 0F0h, 00h, 0F0h, 0F0h 
db 0Fh, 00h, 0F0h, 00h, 0FFh, 00h, 00h, 00h, 0F0h, 0F0h 
db 0F0h, 0F0h, 00h, 0Fh, 00h, 0F0h, 0F0h, 0F0h, 0FFh, 0F0h 
db 0FFh, 00h, 0F0h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 0Fh, 0FFh, 00h, 0Fh, 00h, 0Fh, 00h, 0F0h, 0F0h, 0F0h, 00h, 0Fh, 0F0h, 0Fh, 00h, 0FFh, 0F0h
db 0F0h, 0F0h, 00h, 0FFh, 00h, 0Fh, 00h, 0F0h, 00h, 0Fh 
db 00h, 0Fh, 0Fh, 00h, 0F0h, 0F0h, 0F0h, 0F0h, 0FFh, 0F0h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 0FFh, 0F0h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 0FFh, 0F0h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 0FFh, 0FFh, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 
db 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h 

keyboardinput	proc
	


	ret
keyboardinput	endp


filename        db      "LEVELxx.DAT",0

readlevelfromdisk	proc




        call    adjustlevelname

	push	ax
	push	bx
	push	cx
	push	dx
	push	bp


	; open file

	lea	dx, filename
        mov     ax, 3d00h
 	int     21h             ; Openfile
        mov     bp, ax          ; save handle in BP


	; read from file
	lea	dx, endflag	; load to ds:9300h
	mov	cx, 8*1024	; levels are always 8k in size
        mov     ax, 3f00h       ;
        mov     bx, bp
        int     21h             ;


	;close file
        mov     bx, bp          ; file handle from BP
        mov     ax, 3e00h
        int     21h             ; close file

	pop	bp
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

readlevelfromdisk	endp

adjustlevelname proc
;modify the asciiz name of the level to load based on the value coming in AH
;


	push    di
        push    ax
        dec	ah		; 
	lea     di, filename
        add     di, 5           ; get past "level"
        mov     al, ah
        call    hex2ascii
        xchg    al, ah
        stosw
        pop     ax
        pop     di
        ret
        
adjustlevelname endp
;===========================================================================
;Procedure: Hex2ASCII
;Purpose:   returns the ASCII value of a hex byte in AL
;           
;Input:     AL=hex value
;           
;Output:    AX=ASCII value
;Example:   AL=3Eh = AX=3345              
;
;Processing: Separate AL nibble into AH, add 30 or 37 to each
;---------------------------------------------------------------------------
hex2ascii       proc
		xor     ah,ah
                shl     ax,1                  ;separate upper nibble of
                shl     ax,1                  ;separate upper nibble of
                shl     ax,1                  ;separate upper nibble of
                shl     ax,1                  ;separate upper nibble of
                shr     al,1                  ;AL into AH
                shr     al,1                  ;AL into AH
                shr     al,1                  ;AL into AH
                shr     al,1                  ;AL into AH
		add     al,"0"
		cmp     al,"0"+10
		jb      alok      
		add     al,7
alok:
		add     ah,"0"
		cmp     ah,"0"+10
		jb      ohok
		add     ah,7
ohok:
		ret
hex2ascii       endp



getkeypress	proc
	push	ax
	push	dx

;        mov     [keypress], 0
	mov 	dl, -1
 	mov 	ah, 6                   
    	int 	21h                     
 	jz	@f
	
	cmp     al, 27			; ESCAPE key pressed?
	jz	exitprogram

	cmp	al, 0
	jnz	notextended

	mov	dl, -1
	mov	ah, 6
	int	21h


notextended:
        mov     ah, al
        cmp     ah, 6Ah                  ; 'j'
        jg      @f      ;loc_835                 ; Jump if >
        test    ah, BIT7
        jz      loc_832                 ; Jump if zero
		
        and     ah, NOT BIT7
        mov     al,0
        jmp     loc_833

loc_832:
        mov     al, 1
loc_833:
        xor     bh, bh                  ; Zero register
        mov     bl, ah



	call	clearkeys
	mov     [keypress+bx],al       ; save keypress val
        cmp     al, 0
        jne     loc_834                 ; Jump if not equal
        mov     bl, 0
loc_834:
        mov     [keypress],bl

@@:
	pop	dx	
	pop	ax
	ret

exitprogram:
	

	mov 	ax, INT1CSEG
	mov	ds, ax 		
	mov 	dx, cs:INT1COFF                   ;
	mov 	ah, 25h
        mov 	al, 1ch                       ;place interrupt # here.
	int 	21h                           ;set new vector



	mov	ah, 4ch
	int	21h
	
	
getkeypress	endp

clearkeys	proc
; temporary?  clear all previous keystrokes when a new one is found

	push	ax
	push	cx
	push	di

	cmp	al, key_space
	jz	@f

	mov	cx, 6ah / 2
	lea 	di, offset [keypress]
	xor	ax, ax
	rep	stosw
@@:
	pop	di
	pop	cx
	pop	ax
	ret
clearkeys	endp




systemdelay     proc
        push    cx
        xor     cx, cx
        loop    $
	loop	$
        pop     cx
        ret
systemdelay endp


ORG	9300h 		; individual levels are loaded at this hardcoded
			; offset.  in order to change this, each of the 30
			; levels would also need to be modified because
			; there is internal code included in each level.
			; one hardcoded offset won't hurt anyone.
			; 
endflag:

codeseg		ends
	end	main

