'$INCLUDE: 'edimix.bi'
ON ERROR GOTO errortrapping
'defines map and tile dimensions
DIM SHARED map(34, 30) AS INTEGER, tiles(50, 65)
DIM SHARED door(50, 8), littledoor(40, 2)
DIM SHARED boxes(8, 9), arrows(20, 4), blue(80), red(80)
DIM SHARED font(8, 53), chrcodes(256) AS INTEGER
DIM SHARED pathsa(4) AS INTEGER, pathsb(4)  AS INTEGER
DIM SHARED phantom(54, 2), bug(48, 2), pac(54, 9)
DIM SHARED ega(16)
DIM SHARED resopt(400), noerase(2500)
DIM MouseIcon$(9)
Mouse$ = SPACE$(57)

changeicon = 1          'if the mouse is too slow change this to 0

FOR i% = 1 TO 47:  READ OBJ$
        h$ = CHR$(VAL("&H" + OBJ$))
        MID$(Mouse$, i%, 1) = h$
NEXT i%

DATA 55,8B,EC,56,8B,76,0C,56,8B,04,8B,76,0A,56,8B,1C
DATA 8B,76,08,56,8B,0C,8B,76,06,8B,14,1E,07,CD,33,89
DATA 14,5E,89,0C,5E,89,1C,5E,89,04,5E,5D,CA,08,00

FOR arrows% = 0 TO 8
        MouseIcon$(arrows%) = SPACE$(64)
        FOR i% = 1 TO 64
                READ q$: q$ = CHR$(VAL("&H" + q$))
                MID$(MouseIcon$(arrows%), i%, 1) = q$
        NEXT i%
NEXT arrows%

'pointer
DATA FF,FE,7F,FC,7F,FC,7F,FC,7F,FC,7F,FC,83,82,01,01
DATA 83,82,FF,FC,7F,FC,7F,FC,7F,FC,7F,FC,FF,FE,FF,FF
DATA 00,00,00,01,00,01,00,01,00,01,00,01,00,00,7C,7C
DATA 00,00,00,01,00,01,00,01,00,01,00,01,00,00,00,00
'DATA 7F,FF,3F,FF,1F,FF,0F,FF,07,FF,03,FF,01,FF,01,FF
'DATA C3,FF,C3,FF,E3,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF
'DATA 80,00,C0,00,A0,00,90,00,88,00,84,00,82,00,EE,00
'DATA 24,00,34,00,1C,00,00,00,00,00,00,00,00,00,00,00
'up arrow
DATA FF,FB,FF,F1,FF,E0,7F,C0,3F,80,1F,00,FF,E0,FF,E0
DATA FF,E0,FF,E0,FF,E0,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF
DATA 00,04,00,0A,00,11,80,20,40,40,E0,F1,00,11,00,11
DATA 00,11,00,11,00,1F,00,00,00,00,00,00,00,00,00,00
'down arrow
DATA FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,E0,FF,E0,FF,E0
DATA FF,E0,FF,E0,1F,00,3F,80,7F,C0,FF,E0,FF,F1,FF,FB
DATA 00,00,00,00,00,00,00,00,00,00,00,1F,00,11,00,11
DATA 00,11,00,11,E0,F1,40,40,80,20,00,11,00,0A,00,04
'left arrow
DATA FF,FB,FF,F3,FF,E3,1F,C0,1F,80,1F,00,1F,80,1F,C0
DATA FF,E3,FF,F3,FF,FB,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF
DATA 00,04,00,0C,00,14,E0,27,20,40,20,80,20,40,E0,27
DATA 00,14,00,0C,00,04,00,00,00,00,00,00,00,00,00,00
'right arrow
DATA DF,FF,CF,FF,C7,FF,03,F8,01,F8,00,F8,01,F8,03,F8
DATA C7,FF,CF,FF,DF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF
DATA 20,00,30,00,28,00,E4,07,02,04,01,04,02,04,E4,07
DATA 28,00,30,00,20,00,00,00,00,00,00,00,00,00,00,00
'up-left arrow
DATA FF,00,FF,01,FF,03,FF,01,FF,00,7F,20,3F,70,7F,F8
DATA FF,FC,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF
DATA 00,FF,00,82,00,84,00,82,00,A1,80,D0,40,88,80,04
DATA 00,03,00,00,00,00,00,00,00,00,00,00,00,00,00,00
'down-left arrow
DATA FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FC
DATA 7F,F8,3F,70,7F,20,FF,00,FF,01,FF,03,FF,01,FF,00
DATA 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,03
DATA 80,04,40,88,80,D0,00,A1,00,82,00,84,00,82,00,FF
'up-right arrow
DATA 00,FF,80,FF,C0,FF,80,FF,00,FF,04,FE,0E,FC,1F,FE
DATA 3F,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF
DATA FF,00,41,00,21,00,41,00,85,00,0B,01,11,02,20,01
DATA C0,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
'down-right arrow
DATA FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,3F,FF
DATA 1F,FE,0E,FC,04,FE,00,FF,80,FF,C0,FF,80,FF,00,FF
DATA 00,00,00,00,00,00,00,00,00,00,00,00,00,00,C0,00
DATA 20,01,11,02,0B,01,85,00,41,00,21,00,41,00,FF,00

FOR kind = 0 TO 15                              'this is for LoadPcx sub. makes my own ega palette
        READ ega(kind)
NEXT kind

DATA 11,0,0,14,10,12,8,7,3,0,0,0,0,0,0,0

'this is for LoadMap and RandomMove subs. defines pac direction
pathsa(0) = -1: pathsa(1) = 0: pathsa(2) = 0: pathsa(3) = 1
pathsb(0) = 0: pathsb(1) = -1: pathsb(2) = 1: pathsb(3) = 0

FOR kind = 0 TO 255                             'these codes identify which graphic letter must be printed
        READ chrcodes(kind)
NEXT kind
                                                                                                   
'<SPACE>'(),-./0123456789:;?@ABCDEFGHIJKLMNOPQRSTUVWXYZ\
DATA 50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,49,50,50,36,50,50,50,39,42,43,51,50,44,45,37,40,00,01,02,03,04,05,06,07,08,09,38,46,50,50,50,41,47,10,11,12,13,14,15,16
DATA 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,50,48,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50
DATA 50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,52,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50
DATA 50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50
                                                                                         
IF NOT MouseInit% THEN
        SCREEN 0: WIDTH 80: CLS
        PRINT "MOUSE IS REQUIRED"
        END
END IF

SCREEN 7, , 0, 1                                '320x200 16 colors mode initialization

LoadPcx "default.pcx"                           'graphics loading

GET (68, 92)-(83, 107), tiles(0, 3)             'red face tile getting

GET (86, 124)-(95, 137), tiles(0, 4)            'food tile getting

GET (52, 109)-(65, 121), tiles(0, 5)            'arrow tiles getting
GET (69, 109)-(81, 121), tiles(0, 6)
GET (86, 109)-(99, 121), tiles(0, 7)
GET (103, 109)-(116, 121), tiles(0, 8)

GET (86, 58)-(101, 71), tiles(0, 9)             'phantom prison door tiles getting
GET (69, 75)-(84, 90), tiles(0, 10)

GET (35, 75)-(50, 90), tiles(0, 11)             'first map tiles getting
GET (52, 92)-(67, 107), tiles(0, 12)
GET (1, 109)-(16, 122), tiles(0, 13)
GET (18, 109)-(33, 122), tiles(0, 14)
GET (1, 58)-(16, 71), tiles(0, 15)
GET (18, 58)-(33, 71), tiles(0, 16)
GET (35, 58)-(50, 71), tiles(0, 17)
GET (52, 58)-(67, 73), tiles(0, 18)
GET (1, 75)-(16, 90), tiles(0, 19)
GET (18, 75)-(33, 90), tiles(0, 20)
GET (52, 75)-(67, 90), tiles(0, 21)
GET (1, 92)-(16, 107), tiles(0, 22)
GET (18, 92)-(33, 107), tiles(0, 23)
GET (35, 92)-(50, 105), tiles(0, 24)
GET (35, 109)-(48, 122), tiles(0, 25)

GET (230, 18)-(245, 33), tiles(0, 26)           'second map tiles getting
GET (247, 35)-(262, 50), tiles(0, 27)
GET (196, 52)-(211, 65), tiles(0, 28)
GET (213, 52)-(228, 65), tiles(0, 29)
GET (196, 1)-(211, 14), tiles(0, 30)
GET (213, 1)-(228, 14), tiles(0, 31)
GET (230, 1)-(245, 14), tiles(0, 32)
GET (247, 1)-(262, 16), tiles(0, 33)
GET (196, 18)-(211, 33), tiles(0, 34)
GET (213, 18)-(228, 33), tiles(0, 35)
GET (247, 18)-(262, 33), tiles(0, 36)
GET (196, 35)-(211, 50), tiles(0, 37)
GET (213, 35)-(228, 50), tiles(0, 38)
GET (230, 35)-(245, 48), tiles(0, 39)
GET (230, 52)-(243, 65), tiles(0, 40)

GET (230, 84)-(245, 99), tiles(0, 41)           'third map tiles getting
GET (247, 101)-(262, 116), tiles(0, 42)
GET (196, 118)-(211, 131), tiles(0, 43)
GET (213, 118)-(228, 131), tiles(0, 44)
GET (196, 67)-(211, 80), tiles(0, 45)
GET (213, 67)-(228, 80), tiles(0, 46)
GET (230, 67)-(245, 80), tiles(0, 47)
GET (247, 67)-(262, 82), tiles(0, 48)
GET (196, 84)-(211, 99), tiles(0, 49)
GET (213, 84)-(228, 99), tiles(0, 50)
GET (247, 84)-(262, 99), tiles(0, 51)
GET (196, 101)-(211, 116), tiles(0, 52)
GET (213, 101)-(228, 116), tiles(0, 53)
GET (230, 101)-(245, 114), tiles(0, 54)
GET (230, 118)-(243, 131), tiles(0, 55)

GET (103, 58)-(118, 73), tiles(0, 56)           'common tiles getting
GET (103, 75)-(116, 90), tiles(0, 57)
GET (86, 92)-(101, 105), tiles(0, 58)
GET (103, 92)-(116, 105), tiles(0, 59)
GET (69, 58)-(84, 71), tiles(0, 60)
GET (86, 75)-(101, 90), tiles(0, 61)
GET (267, 101)-(282, 116), tiles(0, 62)
GET (284, 101)-(299, 116), tiles(0, 63)
GET (301, 101)-(316, 116), tiles(0, 64)

GET (196, 142)-(211, 155), door(0, 0)           'L door graphics getting
GET (212, 142)-(227, 155), door(0, 1)
GET (196, 156)-(211, 171), door(0, 2)
GET (212, 156)-(227, 171), door(0, 3)
GET (261, 142)-(276, 155), door(0, 4)
GET (277, 142)-(286, 155), door(0, 5)
GET (261, 156)-(276, 171), door(0, 6)
GET (277, 156)-(286, 171), door(0, 7)

GET (267, 118)-(279, 131), littledoor(0, 0)
GET (281, 118)-(293, 131), littledoor(0, 1)

GET (196, 133)-(203, 140), boxes(0, 0)          'window boxes graphics getting
GET (205, 133)-(212, 140), boxes(0, 1)
GET (214, 133)-(221, 140), boxes(0, 2)
GET (223, 133)-(230, 140), boxes(0, 3)
GET (232, 133)-(239, 140), boxes(0, 4)
GET (241, 133)-(248, 140), boxes(0, 5)
GET (250, 133)-(257, 140), boxes(0, 6)
GET (259, 133)-(266, 140), boxes(0, 7)
GET (268, 133)-(275, 140), boxes(0, 8)

GET (2, 124)-(8, 131), font(0, 0)               'font graphics getting
GET (10, 124)-(16, 131), font(0, 1)
GET (18, 124)-(24, 131), font(0, 2)
GET (26, 124)-(32, 131), font(0, 3)
GET (34, 124)-(40, 131), font(0, 4)
GET (42, 124)-(48, 131), font(0, 5)
GET (50, 124)-(56, 131), font(0, 6)
GET (58, 124)-(64, 131), font(0, 7)
GET (66, 124)-(72, 131), font(0, 8)
GET (74, 124)-(80, 131), font(0, 9)
GET (2, 133)-(9, 140), font(0, 10)
GET (10, 133)-(17, 140), font(0, 11)
GET (18, 133)-(25, 140), font(0, 12)
GET (26, 133)-(33, 140), font(0, 13)
GET (34, 133)-(41, 140), font(0, 14)
GET (42, 133)-(49, 140), font(0, 15)
GET (50, 133)-(57, 140), font(0, 16)
GET (58, 133)-(65, 140), font(0, 17)
GET (66, 133)-(73, 140), font(0, 18)
GET (74, 133)-(81, 140), font(0, 19)
GET (2, 142)-(9, 149), font(0, 20)
GET (10, 142)-(17, 149), font(0, 21)
GET (18, 142)-(25, 149), font(0, 22)
GET (26, 142)-(33, 149), font(0, 23)
GET (34, 142)-(41, 149), font(0, 36)
GET (42, 142)-(49, 149), font(0, 24)
GET (50, 142)-(57, 149), font(0, 25)
GET (58, 142)-(65, 149), font(0, 26)
GET (66, 142)-(73, 149), font(0, 27)
GET (74, 142)-(81, 149), font(0, 28)
GET (2, 151)-(9, 158), font(0, 29)
GET (10, 151)-(17, 158), font(0, 30)
GET (18, 151)-(25, 158), font(0, 31)
GET (26, 151)-(33, 158), font(0, 32)
GET (34, 151)-(41, 158), font(0, 33)
GET (42, 151)-(49, 158), font(0, 34)
GET (50, 151)-(57, 158), font(0, 35)
GET (58, 151)-(65, 158), font(0, 37)
GET (66, 151)-(73, 158), font(0, 38)
GET (74, 151)-(81, 158), font(0, 39)
GET (2, 160)-(9, 167), font(0, 40)
GET (10, 160)-(17, 167), font(0, 41)
GET (18, 160)-(25, 167), font(0, 42)
GET (26, 160)-(33, 167), font(0, 43)
GET (34, 160)-(41, 167), font(0, 44)
GET (42, 160)-(49, 167), font(0, 45)
GET (50, 160)-(57, 167), font(0, 46)
GET (58, 160)-(65, 167), font(0, 47)
GET (66, 160)-(73, 167), font(0, 48)
GET (74, 160)-(81, 167), font(0, 49)
GET (2, 169)-(9, 176), font(0, 50)
GET (10, 169)-(17, 176), font(0, 51)
GET (19, 169)-(26, 176), font(0, 52)

GET (40, 2)-(55, 17), pac(0, 0)                 'good pac graphics getting
GET (21, 21)-(36, 36), pac(0, 1)
GET (2, 40)-(17, 55), pac(0, 2)
GET (21, 40)-(36, 55), pac(0, 3)

GET (158, 58)-(168, 65), pac(0, 4)              'bad pac graphics getting
GET (39, 1)-(47, 8), pac(0, 5)                  'good pac graphics getting
GET (49, 1)-(49, 8), pac(0, 6)                  'good pac graphics getting
GET (51, 1)-(51, 8), pac(0, 7)                  'good pac graphics getting
GET (53, 1)-(53, 8), pac(0, 8)                  'good pac graphics getting

GET (77, 1)-(86, 8), phantom(0, 0)              'bad phantom graphics getting
GET (116, 2)-(131, 17), phantom(0, 1)

GET (120, 153)-(129, 161), bug(0, 0)            'bug graphics getting
GET (139, 154)-(154, 169), bug(0, 1)
                                     
GET (59, 114)-(65, 120), arrows(0, 0)           'menu arrows graphics getting
GET (75, 114)-(81, 120), arrows(0, 1)
GET (93, 114)-(99, 120), arrows(0, 2)
GET (110, 114)-(116, 120), arrows(0, 3)

GET (267, 82)-(282, 97), blue                   'blue square
GET (289, 82)-(304, 97), red                    'red square

''''''''''''''

VIEW

addlife = 0: phantoms = 0: bugs = 0: badpactime = 59
A = -1: b = -1: aghost = -1: bghost = -1
stagename$ = "": stagetext$ = ""

xmat = 0: ymat = 0: ERASE map: REDIM map(34, 30) AS INTEGER
seestock = 0: selection = 2: material = 0

''''''''''''''

CALL WorkPaper

''''''''''''''

MouseRange 0, 0, 639, 199
CALL MoveScreen
IF changeicon THEN MouseDriver 9, 7, 7, SADD(MouseIcon$(0))
'MouseShow

''''''''''''''

'palette initialization

PALETTE 13, 8
PALETTE 15, 8
PALETTE 6, 2
PALETTE 9, 8
PALETTE 0, 2
PALETTE 3, 0
PALETTE 11, 2

''''''''''''''

Alert ("EDIMIX,THE MADMIX EDITOR      BETA VERSION      ")

Start:
        MouseStatus Lb, Rb, xx, yy
        'IF Lb = -1 THEN MouseHide: MousePut 412, MP - 4
        CALL MouseHide
        IF (Lb = -1 OR Rb = -1) AND yy < 25 AND yy > 6 AND xx > 13 AND xx < 626 THEN
                IF Choice(INT((xx - 14) / 34), INT(Lb)) = 1 THEN
                        GOSUB Menu
                END IF
                xx2 = xx: yy2 = yy
                DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Lb = 0 AND Rb = 0)
                MousePut xx2, yy2
        END IF
        IF Lb = -1 AND yy < 195 AND yy > 26 AND xx > 13 AND xx < 626 THEN
                CALL PutObject(INT((xx - 14) / 34), INT((yy - 27) / 17)): 'DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Lb = 0)
        END IF
        IF Rb = -1 AND yy < 195 AND yy > 26 AND xx > 13 AND xx < 626 THEN
                CALL AIobject(INT((xx - 14) / 34), INT((yy - 27) / 17)): 'DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Rb = 0)
        END IF
        'IF Rb = -1 AND yy > 196 AND xx > 13 AND xx < 626 THEN CALL AIobject(INT((xx - 14) / 34), 9): 'DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Rb = 0)
        'IF Rb = -1 AND yy < 27 AND xx > 13 AND xx < 626 THEN CALL AIobject(INT((xx - 14) / 34), 0): 'DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Rb = 0)
        'IF Rb = -1 AND yy < 195 AND yy > 26 AND xx < 14 THEN CALL AIobject(0, INT((yy - 27) / 17)): 'DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Rb = 0)
        'IF Rb = -1 AND yy < 195 AND yy > 26 AND xx > 625 THEN CALL AIobject(17, INT((yy - 27) / 17)): 'DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Rb = 0)
        SELECT CASE xx
                CASE IS < 4
                border = 1
                xmat = xmat - 1: IF xmat < -17 THEN xmat = 14
                SELECT CASE yy
                        CASE IS > 194
                        IF changeicon THEN MouseDriver 9, 0, 15, SADD(MouseIcon$(6))
                        ymat = ymat + 1: IF ymat > 20 THEN ymat = 20
                        CASE IS < 4
                        IF changeicon THEN MouseDriver 9, 0, 0, SADD(MouseIcon$(5))
                        ymat = ymat - 1: IF ymat < 0 THEN ymat = 0
                        CASE ELSE
                        IF changeicon THEN MouseDriver 9, 0, 5, SADD(MouseIcon$(3))
                END SELECT
                CALL MoveScreen
                CASE IS > 630
                border = 1
                xmat = xmat + 1: IF xmat > 31 THEN xmat = 0
                SELECT CASE yy
                        CASE IS > 194
                        IF changeicon THEN MouseDriver 9, 15, 15, SADD(MouseIcon$(8))
                        ymat = ymat + 1: IF ymat > 20 THEN ymat = 20
                        CASE IS < 4
                        IF changeicon THEN MouseDriver 9, 15, 0, SADD(MouseIcon$(7))
                        ymat = ymat - 1: IF ymat < 0 THEN ymat = 0
                        CASE ELSE
                        IF changeicon THEN MouseDriver 9, 15, 5, SADD(MouseIcon$(4))
                END SELECT
                CALL MoveScreen
                CASE ELSE
                SELECT CASE yy
                        CASE IS < 4
                        border = 1
                        IF changeicon THEN MouseDriver 9, 5, 0, SADD(MouseIcon$(1))
                        ymat = ymat - 1: IF ymat < 0 THEN ymat = 0 ELSE CALL MoveScreen
                        CASE IS > 194
                        border = 1
                        IF changeicon THEN MouseDriver 9, 5, 15, SADD(MouseIcon$(2))
                        ymat = ymat + 1: IF ymat > 20 THEN ymat = 20 ELSE CALL MoveScreen
                        CASE ELSE
                        IF border AND changeicon THEN MouseDriver 9, 7, 7, SADD(MouseIcon$(0)): border = 0
                END SELECT
        END SELECT
        CALL MouseShow
        PCOPY 0, 1
GOTO Start

Menu:
        xx2 = xx: yy2 = yy
        DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Lb = 0)
        MousePut xx2, yy2
        CALL MenuShow
        CALL MouseShow
        DO
                MouseStatus Lb, Rb, xx, yy
                CALL MouseHide
                IF Lb = -1 AND yy > 50 AND yy < 69 AND xx > 401 AND xx < 437 THEN
                        TIMERbefore = TIMER
                        PUT (202, 52), blue
                        CALL MouseShow: PCOPY 0, 1: CALL MouseHide
                        xx2 = xx: yy2 = yy
                        DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Lb = 0)
                        MousePut xx2, yy2: xx = xx2: yy = yy2
                        PUT (96, 48), noerase, PSET
                        DO: LOOP UNTIL TIMER > TIMERbefore
                        RETURN
                END IF
                IF Lb = -1 AND yy > 69 AND yy < 171 AND xx > 201 AND xx < 437 THEN
                        TIMERbefore = TIMER
                        PUT (101, (INT((yy - 69) / 17)) * 17 + 70), resopt
                        CALL MouseShow: PCOPY 0, 1: CALL MouseHide
                        xx2 = xx: yy2 = yy
                        PUT (101, (INT((yy - 69) / 17)) * 17 + 70), resopt
                        DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Lb = 0)
                        MousePut xx2, yy2
                        DO: LOOP UNTIL TIMER > TIMERbefore
                        CALL MenuOpt(INT((yy2 - 69) / 17))
                END IF
                IF Rb = -1 THEN
                        changeicon = 1 - changeicon
                        IF changeicon THEN MouseDriver 9, 7, 7, SADD(MouseIcon$(0)) ELSE xx2 = xx: yy2 = yy: MouseDriver 0, 7, 7, SADD(Mouse$): MousePut xx2, yy2
                        DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Rb = 0)
                END IF
                CALL MouseShow
                PCOPY 0, 1
        LOOP

errortrapping:
        CLOSE
        SELECT CASE ERR
                CASE ELSE:
                Alert ("ERROR" + STR$(ERR) + ":CANNOT CONTINUE")
                SCREEN 0: WIDTH 80: CLS
                END
        END SELECT

REM $DYNAMIC
SUB Alert (txt$)
        DIM acceptcancel(400)
        DIM xx AS INTEGER, yy AS INTEGER
        DIM xx2 AS INTEGER, yy2 AS INTEGER
        DIM Lb AS INTEGER, Rb AS INTEGER
        'PCOPY 1, 0
        txtlen = LEN(txt$)
        IF txtlen > 24 THEN midwidth = 12 ELSE midwidth = txtlen / 2
        ViewWindow 19 - midwidth, 11, 21 + midwidth, 17 + INT(txtlen / 25)
        LINE (117, 119 + INT(txtlen / 25) * 8)-(204, 136 + INT(txtlen / 25) * 8), 8, B
        GET (117, 119 + INT(txtlen / 25) * 8)-(204, 136 + INT(txtlen / 25) * 8), acceptcancel
        ViewText 129, 124 + INT(txtlen / 25) * 8, "ACCEPT"
        FOR F = 0 TO INT(txtlen / 24)
                ViewText 156 - midwidth * 8, 104 + F * 9, MID$(txt$, F * 24 + 1, 24)
        NEXT F
        DO: LOOP UNTIL INKEY$ = ""                      'clears keyboard buffer
        WHILE LookForKey$ <> CHR$(13) AND LookForKey$ <> CHR$(27)
                LookForKey$ = UCASE$(INKEY$)
                MouseStatus Lb, Rb, xx, yy
                IF Lb = -1 AND yy > (118 + INT(txtlen / 25) * 8) AND yy < (137 + INT(txtlen / 25) * 8) AND xx > 232 AND xx < 410 THEN
                        PUT (117, 119 + INT(txtlen / 25) * 8), acceptcancel
                        CALL MouseShow: PCOPY 0, 1: CALL MouseHide
                        xx2 = xx: yy2 = yy
                        DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Lb = 0)
                        MousePut xx2, yy2
                        TIMERbefore = TIMER: DO: LOOP UNTIL TIMER > TIMERbefore
                        LookForKey$ = CHR$(13)
                END IF
                CALL MouseShow: PCOPY 0, 1: CALL MouseHide
        WEND
        CALL MoveScreen: CALL MouseShow
END SUB

REM $STATIC
FUNCTION Choice (region, Lbyn)
        Choice = 0
        TIMERbefore = TIMER
        VIEW
        IF Lbyn THEN
                SELECT CASE region
                        CASE 15, 16
                        badpactime = badpactime + 10: IF badpactime > 499 THEN badpactime = 59
                        LINE (263, 8)-(286, 15), 0, BF
                        ViewText 256, 8, RIGHT$(STR$(badpactime), LEN(STR$(badpactime)) - 1)
                        PUT (15 * 17 + 8, 8), blue: PUT (16 * 17 + 8, 8), blue: shut = 2
                        CASE 12
                        addlife = addlife + 1: IF addlife > 20 THEN addlife = 0
                        LINE (263 - 17 * 3, 8)-(278 - 17 * 3, 15), 0, BF
                        ViewText 205, 8, RIGHT$(STR$(addlife), LEN(STR$(addlife)) - 1)
                        PUT (region * 17 + 8, 8), blue: shut = 1
                        CASE 14
                        bugs = bugs + 1: IF phantoms + bugs > 20 OR aghost = -1 THEN bugs = 0
                        LINE (263 - 17 * 1, 8)-(278 - 17 * 1, 15), 0, BF
                        ViewText 239, 8, RIGHT$(STR$(bugs), LEN(STR$(bugs)) - 1)
                        PUT (region * 17 + 8, 8), blue: shut = 1
                        CASE 17
                        PUT (region * 17 + 8, 8), blue: Choice = 1: shut = 1'EXIT FUNCTION
                        CASE 13
                        phantoms = phantoms + 1: IF phantoms + bugs > 20 OR aghost = -1 THEN phantoms = 0
                        LINE (263 - 17 * 2, 8)-(278 - 17 * 2, 15), 0, BF
                        ViewText 222, 8, RIGHT$(STR$(phantoms), LEN(STR$(phantoms)) - 1)
                        PUT (region * 17 + 8, 8), blue: shut = 1
                        CASE 11
                        seestock = seestock + 1: IF seestock > 69 THEN seestock = 0
                        FOR stock = 3 TO 11
                                LINE (stock * 17 - 9, 8)-(stock * 17 - 9 + 15, 8 + 15), 0, BF
                                takethis = Repeat(stock + seestock)
                                SELECT CASE takethis
                                        CASE 65'CASE 62
                                        PUT (stock * 17 - 9, 8), pac(0, 0), PSET
                                        CASE 66'CASE 63
                                        PUT (stock * 17 - 9, 8), pac(0, 1), PSET
                                        CASE 67'CASE 64
                                        PUT (stock * 17 - 9, 8), pac(0, 2), PSET
                                        CASE 68'CASE 65
                                        PUT (stock * 17 - 9, 8), pac(0, 3), PSET
                                        CASE 69'CASE 66
                                        PUT (stock * 17 - 9, 8), phantom(0, 1), PSET
                                        CASE 70'CASE 67
                                        PUT (stock * 17 - 3, 16), phantom(0, 0)
                                        PUT (stock * 17 - 13, 5), tiles(0, 4)
                                        CASE 71
                                        PUT (stock * 17 - 8, 9), littledoor(0, 0)
                                        CASE 72
                                        PUT (stock * 17 - 7, 9), littledoor(0, 1)
                                        CASE ELSE
                                        PUT (stock * 17 - 9, 8), tiles(0, takethis), PSET
                                END SELECT
                        NEXT stock
                        PUT (region * 17 + 8, 8), blue: shut = 1
                        IF Repeat(selection - seestock + 1) - 1 < 11 AND Repeat(selection - seestock + 1) - 1 > 1 AND selection > -1 THEN PUT ((Repeat(selection - seestock + 1) - 1) * 17 + 8, 8), red
                        CASE 1
                        seestock = seestock - 1: IF seestock < -8 THEN seestock = 61
                        FOR stock = 3 TO 11
                                LINE (stock * 17 - 9, 8)-(stock * 17 - 9 + 15, 8 + 15), 0, BF
                                takethis = Repeat(stock + seestock)
                                SELECT CASE takethis
                                        CASE 65'CASE 62
                                        PUT (stock * 17 - 9, 8), pac(0, 0), PSET
                                        CASE 66'CASE 63
                                        PUT (stock * 17 - 9, 8), pac(0, 1), PSET
                                        CASE 67'CASE 64
                                        PUT (stock * 17 - 9, 8), pac(0, 2), PSET
                                        CASE 68'CASE 65
                                        PUT (stock * 17 - 9, 8), pac(0, 3), PSET
                                        CASE 69'CASE 66
                                        PUT (stock * 17 - 9, 8), phantom(0, 1), PSET
                                        CASE 70'CASE 67
                                        PUT (stock * 17 - 3, 16), phantom(0, 0)
                                        PUT (stock * 17 - 13, 5), tiles(0, 4)
                                        CASE 71
                                        PUT (stock * 17 - 8, 9), littledoor(0, 0)
                                        CASE 72
                                        PUT (stock * 17 - 7, 9), littledoor(0, 1)
                                        CASE ELSE
                                        PUT (stock * 17 - 9, 8), tiles(0, takethis), PSET
                                END SELECT
                        NEXT stock
                        PUT (region * 17 + 8, 8), blue: shut = 1
                        IF Repeat(selection - seestock + 1) - 1 < 11 AND Repeat(selection - seestock + 1) - 1 > 1 AND selection > -1 THEN PUT ((Repeat(selection - seestock + 1) - 1) * 17 + 8, 8), red
                        CASE 0
                        IF selection > -1 THEN
                                IF Repeat(selection - seestock + 1) - 1 < 11 AND Repeat(selection - seestock + 1) - 1 > 1 AND selection > -1 THEN PUT ((Repeat(selection - seestock + 1) - 1) * 17 + 8, 8), red
                                PUT (8, 8), blue: selection = -1': material = 0
                        END IF
                        CASE IS < 11''''''''''''''''
                        IF Repeat(selection - seestock + 1) - 1 < 11 AND Repeat(selection - seestock + 1) - 1 > 1 AND selection > -1 THEN PUT ((Repeat(selection - seestock + 1) - 1) * 17 + 8, 8), red
                        IF selection = -1 THEN PUT (8, 8), blue
                        PUT (region * 17 + 8, 8), red
                        selection = Repeat(region + seestock + 1) - 1
                        SELECT CASE selection
                                CASE 61: material = 0
                                CASE 62: material = 15
                                CASE 63: material = 30
                                CASE ELSE:
                                IF selection < 55 AND INT((selection - 10) / 15) * 15 >= 0 THEN material = INT((selection - 10) / 15) * 15
                                'IF selection > 54 OR material < 0 THEN material = 0
                        END SELECT
                END SELECT
                ELSE
                SELECT CASE region
                        CASE 15, 16
                        badpactime = badpactime - 10: IF badpactime < 59 THEN badpactime = 499
                        LINE (263, 8)-(286, 15), 0, BF
                        ViewText 256, 8, RIGHT$(STR$(badpactime), LEN(STR$(badpactime)) - 1)
                        PUT (15 * 17 + 8, 8), blue: PUT (16 * 17 + 8, 8), blue: shut = 2
                        CASE 12
                        addlife = addlife - 1: IF addlife < 0 THEN addlife = 20
                        LINE (263 - 17 * 3, 8)-(278 - 17 * 3, 15), 0, BF
                        ViewText 205, 8, RIGHT$(STR$(addlife), LEN(STR$(addlife)) - 1)
                        PUT (region * 17 + 8, 8), blue: shut = 1
                        CASE 14
                        IF aghost > -1 THEN
                                bugs = bugs - 1
                                IF bugs < 0 THEN bugs = 20 - phantoms
                        END IF
                        LINE (263 - 17 * 1, 8)-(278 - 17 * 1, 15), 0, BF
                        ViewText 239, 8, RIGHT$(STR$(bugs), LEN(STR$(bugs)) - 1)
                        PUT (region * 17 + 8, 8), blue: shut = 1
                        CASE 13
                        IF aghost > -1 THEN
                                phantoms = phantoms - 1
                                IF phantoms < 0 THEN phantoms = 20 - bugs
                        END IF
                        LINE (263 - 17 * 2, 8)-(278 - 17 * 2, 15), 0, BF
                        ViewText 222, 8, RIGHT$(STR$(phantoms), LEN(STR$(phantoms)) - 1)
                        PUT (region * 17 + 8, 8), blue: shut = 1
                END SELECT
        END IF
        CALL MouseShow: PCOPY 0, 1: CALL MouseHide
        SELECT CASE shut
                CASE 1: PUT (region * 17 + 8, 8), blue
                CASE 2: PUT (15 * 17 + 8, 8), blue: PUT (16 * 17 + 8, 8), blue
        END SELECT
        VIEW SCREEN (6, 26)-(314, 198)
        DO: LOOP UNTIL TIMER > TIMERbefore
END FUNCTION

REM $DYNAMIC
SUB EraseDoorAround (numx, numy, regionx, regiony, remind)
        SELECT CASE map(regionx + xmat + remind + numx + 1, regiony + ymat + numy)
                CASE 99, -5:
                IF regionx + numx < 18 THEN LINE ((regionx + numx + 1) * 17 + 8, (regiony + numy) * 17 + 28)-((regionx + numx + 1) * 17 + 8 + 15, (regiony + numy) * 17 + 28 + 15), 0, BF: LINE ((regionx + numx) * 17 + 8, (regiony + numy) * 17 + 28)-( _
(regionx + numx) * 17 + 8 + 15, (regiony + numy) * 17 + 28 + 15), 0, BF
                IF regionx + numx < 17 AND regiony + numy > 0 AND map(regionx + xmat + remind + 1 + numx, regiony + ymat + numy) = 99 THEN PUT ((regionx + numx + 1) * 17 + 8, (regiony + numy - 1) * 17 + 30), door(0, 5)
                IF regiony + numy > 0 AND regionx + numx < 17 AND map(regionx + xmat + remind + 1 + numx, regiony + ymat + numy) = 99 THEN PUT ((regionx + numx) * 17 + 8, (regiony + numy - 1) * 17 + 30), door(0, 4)
                IF regionx + numx < 18 AND regiony + numy > 0 AND map(regionx + xmat + remind + numx + 1, regiony + ymat + numy) = -5 THEN PUT ((regionx + numx + 1) * 17 + 8, (regiony + numy - 1) * 17 + 30), door(0, 1)
                IF regiony + numy > 0 AND map(regionx + xmat + remind + numx + 1, regiony + ymat + numy) = -5 THEN PUT ((regionx + numx) * 17 + 8, (regiony + numy - 1) * 17 + 30), door(0, 0)
                map(regionx + xmat + remind + 1 + numx, regiony + ymat + numy) = 0
                SELECT CASE (regionx + xmat + remind + 1 + numx)
                        CASE 33: map(1, regiony + ymat + numy) = 0: map(2, regiony + ymat + numy) = 0
                        CASE 1: map(33, regiony + ymat + numy) = 0: map(2, regiony + ymat + numy) = 0
                        CASE 32: map(0, regiony + ymat + numy) = 0: map(33, regiony + ymat + numy) = 0: map(1, regiony + ymat + numy) = 0
                        CASE 31: map(32, regiony + ymat + numy) = 0: map(0, regiony + ymat + numy) = 0
                        CASE ELSE: map(regionx + xmat + remind + 1 + numx + 1, regiony + ymat + numy) = 0
                END SELECT
                CASE 98, -6:
                IF regionx + numx > -1 THEN LINE ((regionx + numx - 1) * 17 + 8, (regiony + numy) * 17 + 28)-((regionx + numx - 1) * 17 + 8 + 15, (regiony + numy) * 17 + 28 + 15), 0, BF: LINE ((regionx + numx) * 17 + 8, (regiony + numy) * 17 + 28)-( _
(regionx + numx) * 17 + 8 + 15, (regiony + numy) * 17 + 28 + 15), 0, BF
                IF regionx + numx > -1 AND regiony + numy > 0 AND map(regionx + xmat + remind + numx + 1, regiony + ymat + numy) = -6 THEN PUT ((regionx + numx - 1) * 17 + 8, (regiony + numy - 1) * 17 + 30), door(0, 4)
                IF regiony + numy > 0 AND map(regionx + xmat + remind + numx + 1, regiony + ymat + numy) = -6 THEN PUT ((regionx + numx) * 17 + 8, (regiony + numy - 1) * 17 + 30), door(0, 5)
                IF regionx + numx > 0 AND regiony + numy > 0 AND map(regionx + xmat + remind + numx + 1, regiony + ymat + numy) = 98 THEN PUT ((regionx + numx - 1) * 17 + 8, (regiony + numy - 1) * 17 + 30), door(0, 0)
                IF regiony + numy > 0 AND regionx + numx > 0 AND map(regionx + xmat + remind + numx + 1, regiony + ymat + numy) = 98 THEN PUT ((regionx + numx) * 17 + 8, (regiony + numy - 1) * 17 + 30), door(0, 1)
                map(regionx + xmat + remind + 1 + numx, regiony + ymat + numy) = 0
                SELECT CASE (regionx + xmat + remind + 1 + numx)
                        CASE 0: map(32, regiony + ymat + numy) = 0: map(31, regiony + ymat + numy) = 0
                        CASE 1: map(33, regiony + ymat + numy) = 0: map(0, regiony + ymat + numy) = 0: map(32, regiony + ymat + numy) = 0
                        CASE 32: map(0, regiony + ymat + numy) = 0: map(31, regiony + ymat + numy) = 0
                        CASE 2: map(1, regiony + ymat + numy) = 0: map(33, regiony + ymat + numy) = 0
                        CASE ELSE: map(regionx + xmat + remind + 1 + numx - 1, regiony + ymat + numy) = 0
                END SELECT
        END SELECT
END SUB

FUNCTION FileBrowser$ (txt$, txtmax, before$)
        DIM acceptcancel(400)
        DIM xx AS INTEGER, yy AS INTEGER
        DIM xx2 AS INTEGER, yy2 AS INTEGER
        DIM Lb AS INTEGER, Rb AS INTEGER
        ViewWindow 7, 10, 32, 16
        LINE (71, 111)-(158, 128), 8, B: LINE (161, 111)-(248, 128), 8, B
        GET (71, 111)-(158, 128), acceptcancel
        ViewText 83, 116, "ACCEPT": ViewText 173, 116, "CANCEL"
        ViewText 64, 96, txt$
        ViewText 64, 86, before$
        DO: LOOP UNTIL INKEY$ = ""                      'clears keyboard buffer
        WHILE LookForKey$ <> CHR$(13) AND LookForKey$ <> CHR$(27)
                DO
                        MouseStatus Lb, Rb, xx, yy
                        LookForKey$ = UCASE$(INKEY$)
                        IF Lb = -1 AND yy > 110 AND yy < 129 AND xx > 141 AND xx < 317 THEN
                                PUT (71, 111), acceptcancel
                                CALL MouseShow: PCOPY 0, 1: CALL MouseHide
                                xx2 = xx: yy2 = yy
                                DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Lb = 0)
                                MousePut xx2, yy2
                                TIMERbefore = TIMER: DO: LOOP UNTIL TIMER > TIMERbefore
                                LookForKey$ = CHR$(13)
                        END IF
                        IF Lb = -1 AND yy > 110 AND yy < 129 AND xx > 321 AND xx < 497 THEN
                                PUT (161, 111), acceptcancel
                                CALL MouseShow: PCOPY 0, 1: CALL MouseHide
                                xx2 = xx: yy2 = yy
                                DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Lb = 0)
                                MousePut xx2, yy2
                                TIMERbefore = TIMER: DO: LOOP UNTIL TIMER > TIMERbefore
                                LookForKey$ = CHR$(27)
                        END IF
                        CALL MouseShow: PCOPY 0, 1: CALL MouseHide
                LOOP WHILE ((LEN(txtwrote$) = 0 AND LookForKey$ = CHR$(8)) OR LookForKey$ = "")
                SELECT CASE ASC(LookForKey$)
                        CASE 8:
                                txtwrote$ = LEFT$(txtwrote$, LEN(txtwrote$) - 1)
                                ViewText 143, 96, RIGHT$(txtwrote$, 12) + RIGHT$(txt$, 1) + CHR$(32)
                        CASE 13:
                                FileBrowser$ = txtwrote$
                        CASE 27:
                                FileBrowser$ = CHR$(27)
                        CASE IS <> 13:
                                SELECT CASE LEN(txtwrote$)
                                        CASE IS >= txtmax
                                        CASE IS < 12:
                                        txtwrote$ = txtwrote$ + LookForKey$
                                        ViewText 143, 96, RIGHT$(txtwrote$, LEN(txtwrote$)) + RIGHT$(txt$, 1) + CHR$(32)
                                        CASE IS < txtmax:
                                        txtwrote$ = txtwrote$ + LookForKey$
                                        ViewText 143, 96, RIGHT$(txtwrote$, 12) + RIGHT$(txt$, 1) + CHR$(32)
                                END SELECT
                END SELECT
        WEND
END FUNCTION

SUB LoadMap (file$)
        OPEN file$ FOR INPUT AS #1
                INPUT #1, maxlev
                INPUT #1, stagename$, stagetext$
                INPUT #1, addlife, phantoms, bugs, badpactime
                FOR ydatabase = 0 TO 29
                        FOR xdatabase = 0 TO 33
                                INPUT #1, map(xdatabase, ydatabase)
                                SELECT CASE map(xdatabase, ydatabase)
                                        'Phantoms Start Over Point
                                        CASE -8: aghost = xdatabase: bghost = ydatabase
                                        'Phantom Variables Initialization
                                        CASE 2: aghost = xdatabase: bghost = ydatabase
                                        'Pac Variables Initialization
                                        CASE -1, -2, -3, -4: A = xdatabase: b = ydatabase
                                        'Phantom Prison Door /*
                                        'CASE 10: xprison = xdatabase: yprison = ydatabase': prisons = prisons + 1
                                END SELECT
                        NEXT xdatabase
                NEXT ydatabase
        CLOSE #1
END SUB

SUB LoadPcx (txt$)
        DIM h AS TH
        DIM dat AS STRING * 1
        OPEN txt$ FOR BINARY AS #1
        GET #1, 1, h
        C = 1
        y = 0: x = 0
        WHILE C <= 64000
                GET #1, , dat
                IF ASC(dat) > 192 AND ASC(dat) <= 255 THEN
                        LPS = ASC(dat) - 192
                        GET #1, , dat
                        value = ASC(dat)
                        WHILE LPS > 0
                                PSET (x, y), ega(value - 241)
                                IF x = 320 THEN x = 1: y = y + 1 ELSE x = x + 1
                                C = C + 1
                                LPS = LPS - 1
                        WEND
                ELSE
                        value = ASC(dat)
                        PSET (x, y), value
                        IF x = 320 THEN x = 1: y = y + 1 ELSE x = x + 1
                        C = C + 1
                END IF
        WEND
        CLOSE #1
END SUB

SUB MenuOpt (region)
        DIM noerasemenu(1500)
        GET (56, 80)-(263, 135), noerasemenu
        SELECT CASE region
                CASE 0
                'IF Alert$("ARE YOU SURE?") = "Y" THEN
                        addlife = 0: phantoms = 0: bugs = 0: badpactime = 59
                        A = -1: b = -1: aghost = -1: bghost = -1
                        stagename$ = "": stagetext$ = ""
                        xmat = 0: ymat = 0: ERASE map: REDIM map(34, 30) AS INTEGER
                        seestock = 0: selection = 2: material = 0
                        CALL WorkPaper: CALL MoveScreen: CALL MenuShow
                        EXIT SUB
                'END IF
                CASE 1
                answer$ = FileBrowser$("OPEN FILE:", 40, "")
                IF answer$ <> "" AND answer$ <> CHR$(27) THEN
                        A = -1: b = -1: aghost = -1: bghost = -1
                        xmat = 0: ymat = 0: ERASE map: REDIM map(34, 30) AS INTEGER
                        seestock = 0: selection = 2: material = 0
                        LoadMap answer$
                        CALL WorkPaper: CALL MoveScreen: CALL MenuShow
                        EXIT SUB
                        ELSE
                        PUT (56, 80), noerasemenu, PSET
                END IF
                CASE 2
                answer$ = FileBrowser$("SAVE FILE:", 40, "")
                IF answer$ <> "" AND answer$ <> CHR$(27) THEN SaveMap answer$
                PUT (56, 80), noerasemenu, PSET
                CASE 3
                answer$ = FileBrowser$("FRST TEXT:", 20, stagename$)
                IF answer$ <> CHR$(27) THEN stagename$ = answer$
                PUT (56, 80), noerasemenu, PSET
                CASE 4
                answer$ = FileBrowser$("SCND TEXT:", 20, stagetext$)
                IF answer$ <> CHR$(27) THEN stagetext$ = answer$
                PUT (56, 80), noerasemenu, PSET
                CASE 5
                SCREEN 0: WIDTH 80: CLS
                PRINT "FOR MORE FUN VISIT MY OWN PAGE HTTP://WWW11.BRINKSTER.COM/FREESOURCE"
                END
        END SELECT
END SUB

SUB MenuShow
        GET (96, 48)-(223, 175), noerase
        ViewWindow 12, 6, 27, 21'LINE (100, 50)-(219, 173), 7, BF
        LINE (201, 51)-(218, 68), 8, B: PUT (207, 56), arrows(0, 2)
        FOR squares = 0 TO 5
                LINE (101, 70 + squares * 17)-(218, 87 + squares * 17), 8, B
        NEXT squares
        GET (101, 70)-(218, 87), resopt
        ViewText 124, 55, "OPTIONS"
        ViewText 124, 75, "NEW MAP"
        ViewText 120, 92, "OPEN MAP"
        ViewText 120, 109, "SAVE MAP"
        ViewText 112, 126, "FIRST TEXT"
        ViewText 108, 143, "SECOND TEXT"
        ViewText 108, 160, "EXIT EDITOR"
        'DO: MouseStatus Lb, Rb, xx, yy: LOOP UNTIL (Lb = 0)
        'PUT (297, 8), blue
        'VIEW SCREEN (6, 26)-(314, 198)
END SUB

DEFLNG A-Z
SUB MouseDriver (ax%, bx%, cx%, dx%)
  DEF SEG = VARSEG(Mouse$)
  Mouse% = SADD(Mouse$)
  CALL Absolute(ax%, bx%, cx%, dx%, Mouse%)
END SUB

SUB MouseHide
 ax% = 2
 MouseDriver ax%, 0, 0, 0
END SUB

FUNCTION MouseInit%
  ax% = 0
  MouseDriver ax%, 0, 0, 0
  MouseInit% = ax%
END FUNCTION

SUB MousePut (x%, y%)
  ax% = 4
  cx% = x%
  dx% = y%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseRange (x1%, y1%, x2%, y2%)
  ax% = 7
  cx% = x1%
  dx% = x2%
MouseDriver ax%, 0, cx%, dx%
  ax% = 8
  cx% = y1%
  dx% = y2%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseShow
  ax% = 1
  MouseDriver ax%, 0, 0, 0
END SUB

SUB MouseStatus (Lb%, Rb%, xMouse%, yMouse%)
  ax% = 3
  MouseDriver ax%, bx%, cx%, dx%
  Lb% = ((bx% AND 1) <> 0)
  Rb% = ((bx% AND 2) <> 0)
  xMouse% = cx%
  yMouse% = dx%
END SUB

DEFSNG A-Z
SUB MoveScreen

        TIMERbefore = TIMER

        CLS

        FOR sx = 7 TO 314 STEP 17
                LINE (sx, 27)-(sx, 197), 7, , &HAAAA
        NEXT sx

        FOR sy = 27 TO 197 STEP 17
                LINE (7, sy)-(314, sy), 7, , &HAAAA
        NEXT sy

        FOR xmap = xmat TO 17 + xmat
                IF xmap = 0 THEN LINE ((17 - ((17 + xmat) - xmap)) * 17 + 7, 27)-((17 - ((17 + xmat) - xmap)) * 17 + 7, 197), 4, , &HAAAA
                IF xmap = 31 THEN LINE ((17 - ((17 + xmat) - xmap)) * 17 + 24, 27)-((17 - ((17 + xmat) - xmap)) * 17 + 24, 197), 4, , &HAAAA
                SELECT CASE xmap
                        CASE IS > 31: remind = -32
                        CASE IS < 0: remind = 32
                        CASE ELSE: remind = 0
                END SELECT
                FOR ymap = ymat TO 9 + ymat
                        IF ymap = 4 THEN LINE (7, (9 - ((9 + ymat) - ymap)) * 17 + 27)-(313, (9 - ((9 + ymat) - ymap)) * 17 + 27), 4, , &HAAAA
                        IF ymap = 25 THEN LINE (7, (9 - ((9 + ymat) - ymap)) * 17 + 44)-(313, (9 - ((9 + ymat) - ymap)) * 17 + 44), 4, , &HAAAA
                        SELECT CASE map(xmap + remind + 1, ymap)
                                CASE -5
                                IF ymap > ymat THEN PUT (xmap * 17 + 8 - xmat * 17, (ymap - 1) * 17 + 28 - ymat * 17 + 2), door(0, 0)
                                IF ymap < 10 + ymat THEN PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), door(0, 2), PSET
                                CASE 98
                                IF ymap > ymat THEN PUT (xmap * 17 + 8 - xmat * 17, (ymap - 1) * 17 + 28 - ymat * 17 + 2), door(0, 1)
                                IF ymap < 10 + ymat THEN PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), door(0, 3), PSET
                                CASE 99
                                IF ymap > ymat THEN PUT (xmap * 17 + 8 - xmat * 17, (ymap - 1) * 17 + 28 - ymat * 17 + 2), door(0, 4)
                                IF ymap < 10 + ymat THEN PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), door(0, 6), PSET
                                CASE -6
                                IF ymap > ymat THEN PUT (xmap * 17 + 8 - xmat * 17, (ymap - 1) * 17 + 28 - ymat * 17 + 2), door(0, 5)
                                IF ymap < 10 + ymat THEN PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), door(0, 7), PSET
                                CASE 2
                                PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), phantom(0, 1)
                                CASE -8
                                PUT (xmap * 17 + 14 - xmat * 17, ymap * 17 + 36 - ymat * 17), phantom(0, 0)
                                PUT (xmap * 17 + 4 - xmat * 17, ymap * 17 + 25 - ymat * 17), tiles(0, 4)
                                CASE -1
                                PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), pac(0, 0)
                                CASE -2
                                PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), pac(0, 3)
                                CASE -3
                                PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), pac(0, 1)
                                CASE -4
                                PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), pac(0, 2)
                                CASE IS > 2
                                PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), tiles(0, map(xmap + remind + 1, ymap))
                        END SELECT
                NEXT ymap
                SELECT CASE map(xmap + remind + 1, ymap)
                        CASE -5
                        IF ymap > ymat THEN PUT (xmap * 17 + 8 - xmat * 17, (ymap - 1) * 17 + 28 - ymat * 17 + 2), door(0, 0)
                        IF ymap < 10 + ymat THEN PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), door(0, 2), PSET
                        CASE 98
                        IF ymap > ymat THEN PUT (xmap * 17 + 8 - xmat * 17, (ymap - 1) * 17 + 28 - ymat * 17 + 2), door(0, 1)
                        IF ymap < 10 + ymat THEN PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), door(0, 3), PSET
                        CASE 99
                        IF ymap > ymat THEN PUT (xmap * 17 + 8 - xmat * 17, (ymap - 1) * 17 + 28 - ymat * 17 + 2), door(0, 4)
                        IF ymap < 10 + ymat THEN PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), door(0, 6), PSET
                        CASE -6
                        IF ymap > ymat THEN PUT (xmap * 17 + 8 - xmat * 17, (ymap - 1) * 17 + 28 - ymat * 17 + 2), door(0, 5)
                        IF ymap < 10 + ymat THEN PUT (xmap * 17 + 8 - xmat * 17, ymap * 17 + 28 - ymat * 17), door(0, 7), PSET
                END SELECT
        NEXT xmap
        DO: LOOP UNTIL TIMER > TIMERbefore
END SUB

FUNCTION MyFormat$ (txt$)
        IF LEFT$(txt$, 1) = "-" THEN MyFormat$ = txt$: EXIT FUNCTION
        IF LEN(txt$) = 2 THEN MyFormat$ = "0" + RIGHT$(txt$, LEN(txt$) - 1) ELSE MyFormat$ = RIGHT$(txt$, LEN(txt$) - 1)
END FUNCTION

FUNCTION Repeat (til)
        SELECT CASE til
                CASE IS < 3: Repeat = 70 + til
                CASE IS > 72: Repeat = til - 70
                CASE ELSE: Repeat = til
        END SELECT
END FUNCTION

SUB SaveMap (file$)
        OPEN file$ FOR OUTPUT AS #2
                PRINT #2, RIGHT$(STR$(1), 1)
                PRINT #2, stagename$
                PRINT #2, stagetext$
                PRINT #2, MyFormat$(STR$(addlife)) + "," + MyFormat$(STR$(phantoms)) + "," + MyFormat$(STR$(bugs)) + "," + MyFormat$(STR$(badpactime))
                FOR ydatabase = 0 TO 29
                        FOR xdatabase = 0 TO 33
                                IF xdatabase = 33 THEN coma$ = "" ELSE coma$ = ","
                                PRINT #2, MyFormat$(STR$(map(xdatabase, ydatabase))) + coma$;
                        NEXT xdatabase
                        IF ydatabase < 29 THEN PRINT #2,
                NEXT ydatabase
        CLOSE #2
END SUB

SUB ViewText (x, y, txt$)
        FOR stepbystep = 1 TO LEN(txt$)
                PUT (x + stepbystep * 8, y), font(0, chrcodes(ASC(MID$(txt$, stepbystep, 1)))), PSET
        NEXT stepbystep
END SUB

SUB ViewWindow (fromx, fromy, tox, toy)
        FOR y = fromy TO toy
                FOR x = fromx TO tox
                        IF x = fromx AND y = fromy THEN PUT (x * 8, y * 8), boxes(0, 2), PSET: GOTO nextfor
                        IF x = tox AND y = fromy THEN PUT (x * 8, y * 8), boxes(0, 3), PSET: GOTO nextfor
                        IF x = fromx AND y = toy THEN PUT (x * 8, y * 8), boxes(0, 0), PSET: GOTO nextfor
                        IF x = tox AND y = toy THEN PUT (x * 8, y * 8), boxes(0, 1), PSET: GOTO nextfor
                        IF x = fromx THEN PUT (x * 8, y * 8), boxes(0, 4), PSET: GOTO nextfor
                        IF x = tox THEN PUT (x * 8, y * 8), boxes(0, 5), PSET: GOTO nextfor
                        IF y = fromy THEN PUT (x * 8, y * 8), boxes(0, 6), PSET: GOTO nextfor
                        IF y = toy THEN PUT (x * 8, y * 8), boxes(0, 7), PSET: GOTO nextfor
                        PUT (x * 8, y * 8), boxes(0, 8), PSET
nextfor:
                NEXT x
        NEXT y
END SUB

SUB WorkPaper
        VIEW: CLS
        FOR squares = 0 TO 18
                LINE (7, 7)-(squares * 17 + 7, 24), 8, B
        NEXT squares
        PAINT (29, 12), 7, 8: PAINT (199, 12), 7, 8
        PUT (29, 12), arrows(0, 1): PUT (199, 12), arrows(0, 0)
        PAINT (301, 12), 7, 8: PUT (301, 12), arrows(0, 3)
        PUT (235, 16), phantom(0, 0): PUT (252, 15), bug(0, 0)
        ViewText 205, 8, RIGHT$(STR$(addlife), LEN(STR$(addlife)) - 1)
        ViewText 204, 16, "*&": LINE (263, 8)-(295, 23), 0, BF
        PUT (285, 16), pac(0, 4): PUT (270, 16), pac(0, 5)
        PUT (280, 16), pac(0, 6): PUT (282, 16), pac(0, 7): PUT (284, 16), pac(0, 8)
        ViewText 256, 8, RIGHT$(STR$(badpactime), LEN(STR$(badpactime)) - 1)
        PAINT (10, 10), CHR$(&HAA) + CHR$(&HAA) + CHR$(&HAA) + CHR$(&HA) + CHR$(&H55) + CHR$(&H55) + CHR$(&H55) + CHR$(&H5), 8
        ViewText 222, 8, RIGHT$(STR$(phantoms), LEN(STR$(phantoms)) - 1)
        ViewText 239, 8, RIGHT$(STR$(bugs), LEN(STR$(bugs)) - 1)
        FOR stock = 3 TO 11
                PUT (stock * 17 - 9, 8), tiles(0, stock)
        NEXT stock
        PAINT (0, 0), 3, 8
        PUT (selection * 17 + 8, 8), red
        VIEW SCREEN (6, 26)-(314, 198)
END SUB

