' Monster Maze
' by John Wantland
'
' This is a shooter-maze game where the object is to escape the maze
' and try to get as many points as possible.  You get points by killing
' monsters and you also get points for how much time is remaining when
' you finish the level.  It has several diffent kinds of enemies, and
' many levels.  I created a level editor called MAZED.BAS specifically
' for the purpose of speeding up the level creation process.  Thanks
' to Dan Campbell whose mouse program I used as a base for my level editor.
' If you want to know more about creating your own levels, open MAZED.BAS.
' I am sorry about the horrible graphics, I just used ASCII characters so I
' could get on with the rest of the program.  I have documented
' this program, which is something I hardly do, so I hope this will make the
' program easier to understand and modify.  Some of the code is kind of
' sloppy, and probably a lot could be optimized, so if you find a better way
' of doing something,  go ahead and change it.  Just have fun with this, and
' I hope everyone enjoys it.
'
' (Sorry, I just love to give long descriptions about my program.)

' Initialization stuff
RANDOMIZE TIMER
DEFINT A-Y
SCREEN 7, , 1, 0

' Arrays to hold graphics
DIM player(1 TO 18)
DIM e1(1 TO 18)
DIM e2(1 TO 18)
DIM e3(1 TO 18)
DIM e4(1 TO 18)
DIM ex1(1 TO 18)
DIM ex2(1 TO 18)
DIM ex3(1 TO 18)
DIM ex4(1 TO 18)

' Get pictures for graphics
' Player picture
LOCATE 1, 1: COLOR 2: PRINT CHR$(1)
GET (0, 0)-(7, 7), player
CLS

' First enemy picture
LOCATE 1, 1: COLOR 3: PRINT CHR$(21)
GET (0, 0)-(7, 7), e1
CLS

' Second enemy picture
LOCATE 1, 1: COLOR 1: PRINT CHR$(15)
GET (0, 0)-(7, 7), e2
CLS

' Third enemy picture
LOCATE 1, 1: COLOR 5: PRINT CHR$(233)
GET (0, 0)-(7, 7), e3
CLS

' Fourth enemy picture
LOCATE 1, 1: COLOR 9: PRINT CHR$(232)
GET (0, 0)-(7, 7), e4
CLS

' Explosion pictures
FOR y = 0 TO 7
FOR x = 0 TO 7
READ c
PSET (x, y), c
NEXT x
NEXT y
GET (0, 0)-(7, 7), ex1
CLS

FOR y = 0 TO 7
FOR x = 0 TO 7
READ c
PSET (x, y), c
NEXT x
NEXT y
GET (0, 0)-(7, 7), ex2
CLS

FOR y = 0 TO 7
FOR x = 0 TO 7
READ c
PSET (x, y), c
NEXT x
NEXT y
GET (0, 0)-(7, 7), ex3
CLS

FOR y = 0 TO 7
FOR x = 0 TO 7
READ c
PSET (x, y), c
NEXT x
NEXT y
GET (0, 0)-(7, 7), ex4
CLS

' Data structure for enemies
TYPE en1
x AS INTEGER            ' x position for enemy
y AS INTEGER            ' y position for enemy
a AS INTEGER            ' whether or not alive
d AS INTEGER            ' direction enemy is facing
f AS INTEGER            ' whether or not firing
fx AS INTEGER           ' bullet x
fy AS INTEGER           ' bullet y
fd AS INTEGER           ' bullet direction
END TYPE
DIM ene1(20) AS en1             ' Enemy type 1
DIM ene2(20) AS en1             ' Enemy type 2
DIM ene3(20) AS en1             ' Enemy type 3
DIM ene4(20) AS en1             ' Enemy type 4

' Variables
px = 8          ' x position for player
py = 8          ' y position for player
exx = 0         ' explosion x position
exy = 0         ' explosion y position
exa = 0         ' explosion animation frame
fire = 0        ' Whether or not player is shooting
d = 2           ' Direction player is facing
zt = 300        ' Game timer
score = 0       ' Score
life = 3        ' Lives left
lev = 0         ' Current level
skill = 0       ' Skill level
max1 = 4        ' Current maximum number of enemy type 1 in level(NOT in game, just per level)
max2 = -1       ' Current maximum number of enemy type 2 in level
max3 = -3       ' Current maximum number of enemy type 3 in level
max4 = -4       ' Current maximum number of enemy type 4 in level
high = 1000     ' Points needed for an extra life
shoot$ = "mbt255l32o4cbagfed"            ' Music to play when firing
death$ = "mbt255l24o1cdfecgab"         ' Music to play on death

CLS
COLOR 15
LOCATE 6, 15: PRINT "Monster Maze"
LOCATE 8, 13: PRINT "By John Wantland"

PCOPY 1, 0

' Alfred Hitchcock theme to set mood
PLAY "MBMNT150L8O2DP8>DL32EL8DC+<B>C+P8DEP8<ADP8>DL32EL8DC+<B"
PLAY "MB>C+P8DEP8<ADP8>FL4AL8GFP8AL4>CL8<A+AP8>CL4EL8DC+<A+AG"
PLAY "MBFE<DP8>DL32EL8DC+<B>C+P8DEP8<ADP8>DL32EL8DC+<B>C+P8DE"
PLAY "MBP4FP8AL4>CL8<A+AGFD+GA+DC+DEP8FL4E.L8D"

' Main menu
menu:
CLS
COLOR 15
LOCATE 6, 15: PRINT "Monster Maze"
LOCATE 8, 13: PRINT "By John Wantland"
LOCATE 12, 15: PRINT "(N)ew Game"
LOCATE 14, 15: PRINT "(H)elp"
PCOPY 1, 0
DO
a$ = INKEY$
IF LCASE$(a$) = "h" THEN GOTO help:
LOOP UNTIL LCASE$(a$) = "n"

' Choose skill menu
CLS
LOCATE 7, 15: PRINT "Choose skill"
LOCATE 11, 16: PRINT "1 -- Easy"
LOCATE 13, 16: PRINT "2 -- Medium"
LOCATE 15, 16: PRINT "3 -- Hard"
PCOPY 1, 0
DO
a$ = INKEY$
IF a$ = "1" THEN skill = 1
IF a$ = "2" THEN skill = 2
IF a$ = "3" THEN skill = 3
LOOP UNTIL skill <> 0

' Skill settings
' Higher skills have more monsters and the intelligent ones are smarter
' Smart determines how likely monster chase player, the lower it is, the
' more likely
IF skill = 1 THEN max1 = 2: max2 = -2: max3 = -4: max4 = -5: smart = 5
IF skill = 2 THEN max1 = 4: max2 = -1: max3 = -2: max4 = -3: smart = 3
IF skill = 3 THEN max1 = 6: max2 = 0: max3 = -1: max4 = -2: smart = 2

' Initialize levels and enemies
OPEN "maze.dat" FOR INPUT AS #1
INPUT #1, levels        ' Gets total number of levels
GOSUB nextlev:

' Main game loop
DO
z = TIMER       ' This keeps track of time for delay routine
CLS
PCOPY 2, 1      ' Copy maze to page 1 to draw on top of

' Handles enemy logic + killing/dying
GOSUB enemies:

' Player input
DEF SEG = 0: POKE &H41A, PEEK(&H41C)    ' Clears out keyboard to avoid beeps
a = INP(&H60)      ' Like a fast version of INKEY$

' Move player
IF a = 72 AND POINT(px, py - 1) = 0 AND POINT(px + 7, py - 1) = 0 THEN py = py - 4: d = 1
IF a = 75 AND POINT(px - 1, py) = 0 AND POINT(px - 1, py + 7) = 0 THEN px = px - 4: d = 3
IF a = 77 AND POINT(px + 8, py) = 0 AND POINT(px + 8, py + 7) = 0 THEN px = px + 4: d = 2
IF a = 80 AND POINT(px, py + 8) = 0 AND POINT(px + 7, py + 8) = 0 THEN py = py + 4: d = 4

' Shoot if able
IF a = 57 AND fire = 0 THEN GOSUB fire:

' End game if ESC
IF a = 1 THEN GOTO gameover:

' Move bullet if shooting
IF fire = 1 THEN GOSUB bullet:

' Check for extra lives
IF score >= high THEN life = life + 1: high = high + 1000

' animate explosion
IF exa > 0 THEN GOSUB explode:

' Draw player
PUT (px, py), player, OR

' Display stats like time left, score, ect.
LOCATE 1, 36: PRINT "Time"
LOCATE 2, 35: PRINT INT(zt)
LOCATE 2, 35: PRINT ""
LOCATE 5, 36: PRINT "Score"
LOCATE 6, 35: PRINT score
LOCATE 6, 35: PRINT ""
LOCATE 10, 36: PRINT "Lives"
LOCATE 11, 37: PRINT life
LOCATE 15, 36: PRINT "Level"
LOCATE 16, 37: PRINT lev

' Check if out of maze and go to next level
IF px >= 280 THEN GOSUB nextlev:

' Flip page from memory to video screen
PCOPY 1, 0

' Delay
GOSUB delay

IF life <= 0 AND exa = 0 THEN GOSUB gameover:

LOOP

' Delay routine
' This routine uses the system timer and a DO-LOOP loop to ensure that
' the game runs the same speed on all computers
delay:
DO
LOOP UNTIL TIMER > z + .005 OR TIMER < z

' This keeps track of the game timer and kills you if you are out of time.
zt = zt - .05
IF zt <= 0 THEN zt = 300: px = 8: py = 8: life = life - 1: IF life <= 0 THEN GOTO gameover:
RETURN

' Fire routine
' This routine shoots a laser if the player presses Spacebar.
' It sets the direction and location of the laser and turns it on.
fire:
fire = 1
fd = d
IF fd = 1 THEN fx = px + 4: fy = py - 1
IF fd = 2 THEN fx = px + 8: fy = py + 4
IF fd = 3 THEN fx = px - 1: fy = py + 4
IF fd = 4 THEN fx = px + 4: fy = py + 8
IF PLAY(0) = 0 THEN PLAY shoot$
RETURN

efire:
ene3(i).f = 1
ene3(i).fd = ene3(i).d
IF ene3(i).fd = 1 THEN ene3(i).fx = ene3(i).x + 4: ene3(i).fy = ene3(i).y - 1
IF ene3(i).fd = 2 THEN ene3(i).fx = ene3(i).x + 8: ene3(i).fy = ene3(i).y + 4
IF ene3(i).fd = 3 THEN ene3(i).fx = ene3(i).x - 1: ene3(i).fy = ene3(i).y + 4
IF ene3(i).fd = 4 THEN ene3(i).fx = ene3(i).x + 4: ene3(i).fy = ene3(i).y + 8
IF PLAY(0) = 0 THEN PLAY shoot$
RETURN

efire2:
ene4(i).f = 1
ene4(i).fd = ene4(i).d
IF ene4(i).fd = 1 THEN ene4(i).fx = ene4(i).x + 4: ene4(i).fy = ene4(i).y - 1
IF ene4(i).fd = 2 THEN ene4(i).fx = ene4(i).x + 8: ene4(i).fy = ene4(i).y + 4
IF ene4(i).fd = 3 THEN ene4(i).fx = ene4(i).x - 1: ene4(i).fy = ene4(i).y + 4
IF ene4(i).fd = 4 THEN ene4(i).fx = ene4(i).x + 4: ene4(i).fy = ene4(i).y + 8
IF PLAY(0) = 0 THEN PLAY shoot$
RETURN

' Bullet routine
' This moves the laser once it has been fired.
bullet:
SELECT CASE fd
CASE 1
fy = fy - 6
IF POINT(fx, fy) = 15 THEN fire = 0
IF fire = 1 THEN LINE (fx, fy)-(fx, fy + 6), 12
CASE 2
fx = fx + 6
IF POINT(fx, fy) = 15 OR fx >= 280 THEN fire = 0
IF fire = 1 THEN LINE (fx, fy)-(fx - 6, fy), 12
CASE 3
fx = fx - 6
IF POINT(fx, fy) = 15 THEN fire = 0
IF fire = 1 THEN LINE (fx, fy)-(fx + 6, fy), 12
CASE 4
fy = fy + 6
IF POINT(fx, fy) = 15 THEN fire = 0:
IF fire = 1 THEN LINE (fx, fy)-(fx, fy - 6), 12
END SELECT
RETURN

ebullet:
SELECT CASE ene3(i).fd
CASE 1
ene3(i).fy = ene3(i).fy - 6
IF POINT(ene3(i).fx, ene3(i).fy) = 15 THEN ene3(i).f = 0
IF ene3(i).f = 1 THEN LINE (ene3(i).fx, ene3(i).fy)-(ene3(i).fx, ene3(i).fy + 6), 12
CASE 2
ene3(i).fx = ene3(i).fx + 6
IF POINT(ene3(i).fx, ene3(i).fy) = 15 OR ene3(i).fx >= 280 THEN ene3(i).f = 0
IF ene3(i).f = 1 THEN LINE (ene3(i).fx, ene3(i).fy)-(ene3(i).fx - 6, ene3(i).fy), 12
CASE 3
ene3(i).fx = ene3(i).fx - 6
IF POINT(ene3(i).fx, ene3(i).fy) = 15 THEN ene3(i).f = 0
IF ene3(i).f = 1 THEN LINE (ene3(i).fx, ene3(i).fy)-(ene3(i).fx + 6, ene3(i).fy), 12
CASE 4
ene3(i).fy = ene3(i).fy + 6
IF POINT(ene3(i).fx, ene3(i).fy) = 15 THEN ene3(i).f = 0:
IF ene3(i).f = 1 THEN LINE (ene3(i).fx, ene3(i).fy)-(ene3(i).fx, ene3(i).fy - 6), 12
END SELECT
RETURN

ebullet2:
SELECT CASE ene4(i).fd
CASE 1
ene4(i).fy = ene4(i).fy - 6
IF POINT(ene4(i).fx, ene4(i).fy) = 15 THEN ene4(i).f = 0
IF ene4(i).f = 1 THEN LINE (ene4(i).fx, ene4(i).fy)-(ene4(i).fx, ene4(i).fy + 6), 12
CASE 2
ene4(i).fx = ene4(i).fx + 6
IF POINT(ene4(i).fx, ene4(i).fy) = 15 OR ene4(i).fx >= 280 THEN ene4(i).f = 0
IF ene4(i).f = 1 THEN LINE (ene4(i).fx, ene4(i).fy)-(ene4(i).fx - 6, ene4(i).fy), 12
CASE 3
ene4(i).fx = ene4(i).fx - 6
IF POINT(ene4(i).fx, ene4(i).fy) = 15 THEN ene4(i).f = 0
IF ene4(i).f = 1 THEN LINE (ene4(i).fx, ene4(i).fy)-(ene4(i).fx + 6, ene4(i).fy), 12
CASE 4
ene4(i).fy = ene4(i).fy + 6
IF POINT(ene4(i).fx, ene4(i).fy) = 15 THEN ene4(i).f = 0:
IF ene4(i).f = 1 THEN LINE (ene4(i).fx, ene4(i).fy)-(ene4(i).fx, ene4(i).fy - 6), 12
END SELECT
RETURN

' Explode routine
' draws explosion animation
explode:
IF exa = 7 AND PLAY(0) = 0 THEN PLAY death$
IF exa = 7 THEN PUT (exx, exy), ex1, OR
IF exa = 6 THEN PUT (exx, exy), ex2, OR
IF exa = 5 THEN PUT (exx, exy), ex3, OR
IF exa = 4 THEN PUT (exx, exy), ex4, OR
IF exa = 3 THEN PUT (exx, exy), ex3, OR
IF exa = 2 THEN PUT (exx, exy), ex2, OR
IF exa = 1 THEN PUT (exx, exy), ex1, OR
exa = exa - 1
RETURN

' Game Over
' Ends game if player quits or loses.
gameover:
CLS
PRINT "                Game Over"
PRINT
PRINT "     It started out as a simple maze"
PRINT "game, where the object was to survive"
PRINT "the monsters and find a way out.  Trying"
PRINT "to escape, you panicked and took a wrong"
PRINT "turn.  You have now entered a place"
PRINT "where score doesn't matter and there is"
PRINT "reset button.  A place where truth is"
PRINT "stranger than fiction, and reality is no"
PRINT "more real than your imagination.  You"
PRINT "have entered...  The Monster Maze Zone."
PRINT
PRINT "Final score:"; score
PCOPY 1, 0
Count = 0
FOR Snd = 500 TO 100 STEP -200
SOUND Snd, 4
NEXT Snd
FOR Bloops = 1 TO 42
Snnd = (RND * 2400)
IF Snnd < 37 OR Snnd > 3700 THEN Snnd = 250
Snd = (RND * 66) + 37
IF Count = 6 THEN SOUND Snnd, 3: Count = 0
SOUND Snd, 4
Count = Count + 1
NEXT Bloops
FOR Snd = 100 TO 500 STEP 200
SOUND Snd, 4
NEXT Snd
FOR x = 1 TO 3
FOR y = 1 TO 3
SOUND 1050, .13: SOUND 1350, 3.5
SOUND 1150, .13: SOUND 1450, 3.5
SOUND 1050, .13: SOUND 1350, 3.5
SOUND 850, .13: SOUND 1150, 3.5
NEXT y
FOR z = 1 TO 5
Svd = (RND * 550) + 37
SOUND Svd, 1.7
NEXT z
NEXT x
FOR i = 1 TO 5
Svd = (RND * 550) + 37
SOUND Svd, 1.7
NEXT i
FOR Snd = 175 TO 37 STEP -10
SOUND Snd, 1
NEXT Snd
SOUND 37, 10
LOCATE 23, 27: PRINT "Press Enter..."
PCOPY 1, 0
DO
a$ = INKEY$
LOOP UNTIL a$ = CHR$(13)
SCREEN 0: WIDTH 80: CLS : END

' Help screen
help:
COLOR 15: CLS
PRINT "     You have been trapped in a huge"
PRINT "maze populated by evil monsters trying"
PRINT "to kill you.  You are only armed with a"
PRINT "state-of-the-art laser pistol to fend"
PRINT "off the monsters with.  The maze is made"
PRINT "up of many smaller mazes.  You must find"
PRINT "a way out of each of these mazes to"
PRINT "escape the Monster Maze."
PRINT
PRINT
PRINT "Arrow keys: Move"
PRINT "Spacebar:   Fire laser pistol"
PRINT "Esc:        Quit game"
PRINT
PRINT "Extra life every 1000 points"
LOCATE 23, 27: PRINT "Press Enter..."
PCOPY 1, 0
DO
a$ = INKEY$
LOOP UNTIL a$ = CHR$(13)
GOTO menu

' Next level routine
' Initializes next level when player starts game or beats level
nextlev:
IF lev <> 0 THEN score = score + INT(zt)        ' Adds remaining time to score
lev = lev + 1           ' Next level
max1 = max1 + 1         ' Add one to number of type 1 enemies in level
max2 = max2 + 1         ' Add one to number of type 2 enemies in level
max3 = max3 + 1         ' Add one to number of type 3 enemies in level
max4 = max4 + 1         ' Add one to number of type 4 enemies in level
IF lev > levels THEN GOTO win:          ' Checks if won game
CLS

' Actually read and draw maze
COLOR 15
FOR y = 1 TO 23
FOR x = 1 TO 35
9 INPUT #1, n: IF n <> 2 AND n <> 1 THEN 9
IF n = 1 THEN LOCATE y, x: PRINT "" ELSE LOCATE y, x: PRINT " "
NEXT x
NEXT y
PCOPY 1, 2      ' Saves maze to page 2(Keeps it from getting drawn on
CLS

' Initial player position and variables(sorry I have most of them twice)
px = 8
py = 8
zt = 300
fire = 0

' Draw maze to video screen
PCOPY 2, 1
PUT (px, py), player    ' Add player to maze
PCOPY 1, 0

' Set enemies(random positions in maze)
' Type 1
IF max1 > 0 THEN        ' Makes sure enemies of this type in level
FOR i = 0 TO max1 - 1
ene1(i).a = 1
ene1(i).d = INT(RND * 4) + 1
GOSUB place1:
NEXT i
END IF

' Type 2
IF max2 > 0 THEN
FOR i = 0 TO max2 - 1
ene2(i).a = 1
ene2(i).d = INT(RND * 4) + 1
GOSUB place2:
NEXT i
END IF

' Type 3
IF max3 > 0 THEN        ' Makes sure enemies of this type in level
FOR i = 0 TO max3 - 1
ene3(i).a = 1
ene3(i).d = INT(RND * 4) + 1
GOSUB place3:
NEXT i
END IF

' Type 4
IF max4 > 0 THEN        ' Makes sure enemies of this type in level
FOR i = 0 TO max4 - 1
ene4(i).a = 1
ene4(i).d = INT(RND * 4) + 1
GOSUB place4:
NEXT i
END IF

RETURN

' If player beats all levels
win:
CLS
PRINT "     Congratulations!!!  You have"
PRINT "successfully escaped from the Monster"
PRINT "Maze.  Now you may continue with your"
PRINT "normal life without having to worry"
PRINT "about vicious monsters eating you"
PRINT "alive.  Th-th-th-th-that's all folks!"
PRINT
PRINT "Final score:"; score
PCOPY 1, 0
PLAY "MST200L8O3E.L16DL8CDED+ECDDDL2D.L8D.L16CL8<B>CDC+D<B>C"
PLAY "CCL2C.L8<G.L16G+L8A.L16G+L8G.L16G+L8A.L16G+L8G>DDL2D."
PLAY "L8<AG+AL4>DEL2G"
DO
LOOP UNTIL PLAY(0) = 0
LOCATE 23, 27: PRINT "Press Enter..."
PCOPY 1, 0
DO
a$ = INKEY$
LOOP UNTIL a$ = CHR$(13)
SCREEN 0: WIDTH 80: CLS : END

' Enemy routine
' Deals with enemies(put it last so it would be easier to get to and add more
' enemies to end of it.)
enemies:

' Type 1(slow and stupid, no gun)
IF max1 > 0 THEN
FOR i = 0 TO max1 - 1
IF ene1(i).a = 1 THEN   ' Make sure alive

' Move enemy
SELECT CASE ene1(i).d
CASE 1
IF POINT(ene1(i).x, ene1(i).y - 1) = 0 AND POINT(ene1(i).x + 7, ene1(i).y - 1) = 0 THEN ene1(i).y = ene1(i).y - 2 ELSE ene1(i).d = INT(RND * 4) + 1
CASE 2
IF POINT(ene1(i).x + 8, ene1(i).y) = 0 AND POINT(ene1(i).x + 8, ene1(i).y + 7) = 0 AND ene1(i).x <= 272 THEN ene1(i).x = ene1(i).x + 2 ELSE ene1(i).d = INT(RND * 4) + 1
CASE 3
IF POINT(ene1(i).x - 1, ene1(i).y) = 0 AND POINT(ene1(i).x - 1, ene1(i).y + 7) = 0 THEN ene1(i).x = ene1(i).x - 2 ELSE ene1(i).d = INT(RND * 4) + 1
CASE 4
IF POINT(ene1(i).x, ene1(i).y + 8) = 0 AND POINT(ene1(i).x + 7, ene1(i).y + 8) = 0 THEN ene1(i).y = ene1(i).y + 2 ELSE ene1(i).d = INT(RND * 4) + 1
END SELECT
IF INT(RND * 50) + 1 = 25 THEN ene1(i).d = INT(RND * 4) + 1     ' Randomly change directions occasionally

' Draw enemy
PUT (ene1(i).x, ene1(i).y), e1, OR: LOCATE 1, 1

' Collision detection with player and lasers
IF ((ene1(i).x >= px AND ene1(i).x <= px + 7) OR (ene1(i).x + 7 >= px AND ene1(i).x + 7 <= px + 7)) AND ((ene1(i).y >= py AND ene1(i).y <= py + 7) OR (ene1(i).y + 7 >= py AND ene1(i).y + 7 <= py + 7)) THEN life = life - 1: exx = px: exy = py: exa = 7: px = 8: py = 8: ene1(i).a = 0: score = score + 25
IF fx >= ene1(i).x AND fx <= ene1(i).x + 8 AND fy >= ene1(i).y AND fy <= ene1(i).y + 8 AND fire = 1 AND ene1(i).a = 1 THEN ene1(i).a = 0: fire = 0: exx = ene1(i).x: exy = ene1(i).y: exa = 7: score = score + 25
END IF
NEXT i
END IF

' Type 2(Fast, smart, still no gun)
IF max2 > 0 THEN
FOR i = 0 TO max2 - 1
IF ene2(i).a = 1 THEN

' Move enemy
SELECT CASE ene2(i).d
CASE 1
IF POINT(ene2(i).x, ene2(i).y - 1) = 0 AND POINT(ene2(i).x + 7, ene2(i).y - 1) = 0 THEN ene2(i).y = ene2(i).y - 4 ELSE ene2(i).d = INT(RND * 4) + 1
CASE 2
IF POINT(ene2(i).x + 8, ene2(i).y) = 0 AND POINT(ene2(i).x + 8, ene2(i).y + 7) = 0 AND ene2(i).x <= 272 THEN ene2(i).x = ene2(i).x + 4 ELSE ene2(i).d = INT(RND * 4) + 1
CASE 3
IF POINT(ene2(i).x - 1, ene2(i).y) = 0 AND POINT(ene2(i).x - 1, ene2(i).y + 7) = 0 THEN ene2(i).x = ene2(i).x - 4 ELSE ene2(i).d = INT(RND * 4) + 1
CASE 4
IF POINT(ene2(i).x, ene2(i).y + 8) = 0 AND POINT(ene2(i).x + 7, ene2(i).y + 8) = 0 THEN ene2(i).y = ene2(i).y + 4 ELSE ene2(i).d = INT(RND * 4) + 1
END SELECT
IF INT(RND * 50) + 1 = 15 THEN ene2(i).d = INT(RND * 4) + 1

' Chase player if visible(not always, but most of time.  Easier to survive that way.)
IF INT(RND * smart) + 1 = 1 THEN
IF ene2(i).x = px AND ene2(i).y > py THEN ene2(i).d = 1
IF ene2(i).x = px AND ene2(i).y < py THEN ene2(i).d = 4
IF ene2(i).y = py AND ene2(i).x > px THEN ene2(i).d = 3
IF ene2(i).y = py AND ene2(i).x < px THEN ene2(i).d = 2
END IF

' Draw enemy
PUT (ene2(i).x, ene2(i).y), e2, OR

' Collision with player and laser
IF ((ene2(i).x >= px AND ene2(i).x <= px + 7) OR (ene2(i).x + 7 >= px AND ene2(i).x + 7 <= px + 7)) AND ((ene2(i).y >= py AND ene2(i).y <= py + 7) OR (ene2(i).y + 7 >= py AND ene2(i).y + 7 <= py + 7)) THEN life = life - 1: exx = px: exy = py: exa = 7: px = 8: py = 8: ene2(i).a = 0: score = score + 35
IF fx >= ene2(i).x AND fx <= ene2(i).x + 8 AND fy >= ene2(i).y AND fy <= ene2(i).y + 8 AND fire = 1 AND ene2(i).a = 1 THEN ene2(i).a = 0: fire = 0: exx = ene2(i).x: exy = ene2(i).y: exa = 7: score = score + 35
END IF
NEXT i
END IF

' Type 3(slow and stupid, gun)
IF max3 > 0 THEN
FOR i = 0 TO max3 - 1
IF ene3(i).a = 1 THEN   ' Make sure alive

' Move enemy
SELECT CASE ene3(i).d
CASE 1
IF POINT(ene3(i).x, ene3(i).y - 1) = 0 AND POINT(ene3(i).x + 7, ene3(i).y - 1) = 0 THEN ene3(i).y = ene3(i).y - 2 ELSE ene3(i).d = INT(RND * 4) + 1
CASE 2
IF POINT(ene3(i).x + 8, ene3(i).y) = 0 AND POINT(ene3(i).x + 8, ene3(i).y + 7) = 0 AND ene3(i).x <= 272 THEN ene3(i).x = ene3(i).x + 2 ELSE ene3(i).d = INT(RND * 4) + 1
CASE 3
IF POINT(ene3(i).x - 1, ene3(i).y) = 0 AND POINT(ene3(i).x - 1, ene3(i).y + 7) = 0 THEN ene3(i).x = ene3(i).x - 2 ELSE ene3(i).d = INT(RND * 4) + 1
CASE 4
IF POINT(ene3(i).x, ene3(i).y + 8) = 0 AND POINT(ene3(i).x + 7, ene3(i).y + 8) = 0 THEN ene3(i).y = ene3(i).y + 2 ELSE ene3(i).d = INT(RND * 4) + 1
END SELECT
IF INT(RND * 50) + 1 = 15 THEN ene3(i).d = INT(RND * 4) + 1     ' Randomly change directions occasionally

' Fire bullet
IF INT(RND * 25) + 1 = 15 AND ene3(i).f = 0 THEN GOSUB efire:
IF ene3(i).f = 1 THEN GOSUB ebullet:
IF ene3(i).fx >= px AND ene3(i).fx <= px + 8 AND ene3(i).fy >= py AND ene3(i).fy <= py + 8 AND ene3(i).f = 1 THEN life = life - 1: exx = px: exy = py: exa = 7: px = 8: py = 8

' Draw enemy
PUT (ene3(i).x, ene3(i).y), e3, OR

' Collision detection with player and lasers
IF ((ene3(i).x >= px AND ene3(i).x <= px + 7) OR (ene3(i).x + 7 >= px AND ene3(i).x + 7 <= px + 7)) AND ((ene3(i).y >= py AND ene3(i).y <= py + 7) OR (ene3(i).y + 7 >= py AND ene3(i).y + 7 <= py + 7)) THEN life = life - 1: exx = px: exy = py: exa = 7: px = 8: py = 8: ene3(i).a = 0: score = score + 50
IF fx >= ene3(i).x AND fx <= ene3(i).x + 8 AND fy >= ene3(i).y AND fy <= ene3(i).y + 8 AND fire = 1 AND ene3(i).a = 1 THEN ene3(i).a = 0: fire = 0: exx = ene3(i).x: exy = ene3(i).y: exa = 7: score = score + 50
END IF
NEXT i
END IF

' Type 4(slow and smart, gun)
IF max4 > 0 THEN
FOR i = 0 TO max4 - 1
IF ene4(i).a = 1 THEN   ' Make sure alive

' Move enemy
SELECT CASE ene4(i).d
CASE 1
IF POINT(ene4(i).x, ene4(i).y - 1) = 0 AND POINT(ene4(i).x + 7, ene4(i).y - 1) = 0 THEN ene4(i).y = ene4(i).y - 2 ELSE ene4(i).d = INT(RND * 4) + 1
CASE 2
IF POINT(ene4(i).x + 8, ene4(i).y) = 0 AND POINT(ene4(i).x + 8, ene4(i).y + 7) = 0 AND ene4(i).x <= 272 THEN ene4(i).x = ene4(i).x + 2 ELSE ene4(i).d = INT(RND * 4) + 1
CASE 3
IF POINT(ene4(i).x - 1, ene4(i).y) = 0 AND POINT(ene4(i).x - 1, ene4(i).y + 7) = 0 THEN ene4(i).x = ene4(i).x - 2 ELSE ene4(i).d = INT(RND * 4) + 1
CASE 4
IF POINT(ene4(i).x, ene4(i).y + 8) = 0 AND POINT(ene4(i).x + 7, ene4(i).y + 8) = 0 THEN ene4(i).y = ene4(i).y + 2 ELSE ene4(i).d = INT(RND * 4) + 1
END SELECT
IF INT(RND * 50) + 1 = 15 THEN ene4(i).d = INT(RND * 4) + 1     ' Randomly change directions occasionally

' Chase player if visible(not always, but most of time.  Easier to survive that way.)
IF INT(RND * smart) + 1 = 1 THEN
IF ene4(i).x = px AND ene4(i).y > py THEN ene4(i).d = 1
IF ene4(i).x = px AND ene4(i).y < py THEN ene4(i).d = 4
IF ene4(i).y = py AND ene4(i).x > px THEN ene4(i).d = 3
IF ene4(i).y = py AND ene4(i).x < px THEN ene4(i).d = 2
END IF

' Fire bullet
IF INT(RND * 25) + 1 = 15 AND ene4(i).f = 0 THEN GOSUB efire2:
IF ene4(i).f = 1 THEN GOSUB ebullet2:
IF ene4(i).fx >= px AND ene4(i).fx <= px + 8 AND ene4(i).fy >= py AND ene4(i).fy <= py + 8 AND ene4(i).f = 1 THEN life = life - 1: exx = px: exy = py: exa = 7: px = 8: py = 8

' Draw enemy
PUT (ene4(i).x, ene4(i).y), e4, OR

' Collision detection with player and lasers
IF ((ene4(i).x >= px AND ene4(i).x <= px + 7) OR (ene4(i).x + 7 >= px AND ene4(i).x + 7 <= px + 7)) AND ((ene4(i).y >= py AND ene4(i).y <= py + 7) OR (ene4(i).y + 7 >= py AND ene4(i).y + 7 <= py + 7)) THEN life = life - 1: exx = px: exy = py: exa = 7: px = 8: py = 8: ene4(i).a = 0: score = score + 50
IF fx >= ene4(i).x AND fx <= ene4(i).x + 8 AND fy >= ene4(i).y AND fy <= ene4(i).y + 8 AND fire = 1 AND ene4(i).a = 1 THEN ene4(i).a = 0: fire = 0: exx = ene4(i).x: exy = ene4(i).y: exa = 7: score = score + 75
END IF
NEXT i
END IF

RETURN

' Randomly place enemy type 1 in maze(when starting out)
place1:
1 ene1(i).x = INT(RND * 280): IF ene1(i).x MOD 8 <> 0 THEN 1
2 ene1(i).y = INT(RND * 179): IF ene1(i).y MOD 8 <> 0 THEN 2
IF POINT(ene1(i).x, ene1(i).y) <> 0 OR (ene1(i).x = 8 AND ene1(i).y = 8) THEN 1
IF ene1(i).x <= 50 AND ene1(i).y <= 50 THEN GOTO 1
RETURN

' Randomly place enemy type 2 in maze(when starting out or killing player
place2:
3 ene2(i).x = INT(RND * 280): IF ene2(i).x MOD 8 <> 0 THEN 3
4 ene2(i).y = INT(RND * 179): IF ene2(i).y MOD 8 <> 0 THEN 4
IF POINT(ene2(i).x, ene2(i).y) <> 0 OR (ene2(i).x = 8 AND ene2(i).y = 8) THEN 3
IF ene2(i).x <= 50 AND ene2(i).y <= 50 THEN GOTO 1
RETURN

' Randomly place enemy type 3 in maze(when starting out)
place3:
5 ene3(i).x = INT(RND * 280): IF ene3(i).x MOD 8 <> 0 THEN 5
6 ene3(i).y = INT(RND * 179): IF ene3(i).y MOD 8 <> 0 THEN 6
IF POINT(ene3(i).x, ene3(i).y) <> 0 OR (ene3(i).x = 8 AND ene3(i).y = 8) THEN 5
IF ene3(i).x <= 50 AND ene3(i).y <= 50 THEN GOTO 1
RETURN

' Randomly place enemy type 3 in maze(when starting out)
place4:
7 ene4(i).x = INT(RND * 280): IF ene4(i).x MOD 8 <> 0 THEN 7
8 ene4(i).y = INT(RND * 179): IF ene4(i).y MOD 8 <> 0 THEN 8
IF POINT(ene4(i).x, ene4(i).y) <> 0 OR (ene4(i).x = 8 AND ene4(i).y = 8) THEN 7
IF ene4(i).x <= 50 AND ene4(i).y <= 50 THEN GOTO 1
RETURN

DATA 0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0
DATA 0,0,0,4,0,0,0,0
DATA 0,0,4,4,4,0,0,0
DATA 0,0,4,14,4,4,0,0
DATA 0,0,0,4,0,0,0,0
DATA 0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0

DATA 0,0,0,0,0,0,0,0
DATA 0,0,0,0,4,0,0,0
DATA 0,0,4,4,4,4,0,0
DATA 0,4,4,14,14,4,4,0
DATA 0,0,4,14,4,4,0,0
DATA 0,0,4,4,4,0,0,0
DATA 0,0,0,0,0,0,0,0
DATA 0,0,0,0,0,0,0,0

DATA 0,0,0,0,0,0,0,0
DATA 0,0,0,4,4,0,0,0
DATA 0,4,4,4,4,4,0,0
DATA 0,4,4,14,4,4,4,0
DATA 0,4,4,14,14,4,4,0
DATA 0,0,4,14,4,4,0,0
DATA 0,0,4,4,4,0,0,0
DATA 0,0,0,0,0,0,0,0

DATA 0,0,4,4,0,0,0,0
DATA 0,4,4,4,4,0,0,0
DATA 4,4,4,14,4,4,0,0
DATA 4,4,14,14,14,4,4,0
DATA 0,4,14,14,14,4,4,4
DATA 4,4,14,14,14,4,0,0
DATA 0,4,4,4,4,0,0,0
DATA 0,0,0,4,0,0,0,0


