'$DYNAMIC

' Graphic constants

TYPE PlayerType
 Mask AS INTEGER
 Pic AS INTEGER
 Ball AS INTEGER
 ayer1U AS INTEGER
 ayer2U AS INTEGER
 ayer1D AS INTEGER
 ayer2D AS INTEGER
 ayer1L AS INTEGER
 ayer2L AS INTEGER
 ayer1R AS INTEGER
 ayer2R AS INTEGER
 ayer1B AS INTEGER
 ayer2B AS INTEGER
 BallB AS INTEGER
END TYPE

TYPE CorType
 Xpos AS INTEGER
 Ypos AS INTEGER
 Score AS INTEGER
END TYPE

' Sub declarations

DECLARE SUB Intro ()
DECLARE SUB CalCPUspeed ()
DECLARE SUB LoadPal (Pfile$)
DECLARE SUB Fprint (Txt$, PXpos%, PYpos%, Size!, Cler%)
DECLARE SUB SetObject (WhatObject%, X%, Y%)
DECLARE SUB LoadPlayersAndBall ()
DECLARE SUB LoadPlayScreen ()
DECLARE SUB PlayGame ()
DECLARE SUB LoadFont ()
DECLARE SUB FadeOut (Colors%, FadeSpeed!)
DECLARE SUB Delay (TimeToWait!)
DECLARE SUB DrawBox (Sx%, Sy%, Ex%, Ey%)
DECLARE SUB GoalSub (P1Moves%, P2Moves%)
DECLARE SUB Winner ()
DECLARE FUNCTION TTT$ (Num%)
DECLARE FUNCTION AIMove% ()
DECLARE FUNCTION Player1Move% ()
DECLARE FUNCTION Player2Move% ()


'
' XLIB
'
' WHILE UNCOMPILED
'DEFLNG A-Z
'DECLARE SUB XBox (Sx, Sy, Stx, Sty, Clr, Segment, Offset)
'DECLARE SUB XCls (TheWidth, TheHeight, Segment, Offset)
'DECLARE SUB XCopy (FSx, FSy, FStx, FSty, TSx, TSy, FSegment, FOffset, TSegment, Toffset, BlockLength)
'DECLARE SUB XEllipse (CenterX!, CenterY!, Xradius!, Yradius!, Clr!, Segment!, Offset!, Stp!)
'DECLARE SUB XFbox (Sx, Sy, Stx, Sty, Clr, Segment, Offset)
'DECLARE SUB XGet (Sx, Sy, Stx, Sty, FSegment, FOffset, TSegment, Toffset, BlockLength)
'DECLARE SUB XLine (Sx!, Sy!, Stx!, Sty!, Clr!, Segment!, Offset!)
'DECLARE SUB XPset (PsetX, PsetY, Clr, Segment, Offset)
'DECLARE SUB XPut (Sx, Sy, FSegment, FOffset, TSegment, Toffset, BlockLength)
'DECLARE FUNCTION XPoint (PointX, PointY, Segment, Offset)
'

' WHEN COMPILED
DEFINT A-Z
DECLARE SUB XBox (Sx, Sy, Stx, Sty, Clr, Segment, Offset)
DECLARE SUB XCls (TheWidth, TheHeight, Segment, Offset)
DECLARE SUB XCopy (FSx, FSy, FStx, FSty, TSx, TSy, FSegment, FOffset, TSegment, Toffset, BlockLength)
DECLARE SUB XEllipse (CenterX!, CenterY!, Xradius!, Yradius!, Clr!, Segment!, Offset!, Stp!)
DECLARE SUB XFbox (Sx, Sy, Stx, Sty, Clr, Segment, Offset)
DECLARE SUB XGet (Sx, Sy, Stx, Sty, FSegment, FOffset, TSegment, Toffset, BlockLength)
DECLARE SUB XLine (Sx!, Sy!, Stx!, Sty!, Clr!, Segment!, Offset!)
DECLARE SUB XPset (PsetX, PsetY, Clr, Segment, Offset)
DECLARE SUB XPut (Sx, Sy, FSegment, FOffset, TSegment, Toffset, BlockLength)
DECLARE FUNCTION XPoint (PointX, PointY, Segment, Offset)
'

' Z-KB HANDLER THINGIES

DECLARE SUB LoadAsm ()
DECLARE SUB Zkbon ()
DECLARE SUB Zkboff ()

DIM SHARED Zkey%(127), Zkbh$(2), kbonflag%, olkbseg%, olkboff%

' COMMON ARRAY DECLARATIONS

PRINT : PRINT
PRINT "ARRAYS AND VARIABLES...";

DIM SHARED Font(1 TO 41) AS STRING * 30
DIM SHARED Pl AS PlayerType
DIM SHARED KeyDisabled(127) AS INTEGER
DIM SHARED Pl1 AS CorType
DIM SHARED Pl2 AS CorType
DIM SHARED TheBall AS CorType
DIM SHARED Pl2AI AS INTEGER
DIM SHARED InstantMove AS INTEGER
DIM SHARED AiAct AS INTEGER
DIM SHARED Goals AS INTEGER
DIM SHARED AiSpeed AS SINGLE
DIM SHARED LastTimer AS SINGLE
DIM SHARED Fps AS DOUBLE
DIM SHARED Pl1Name$
DIM SHARED Pl2Name$

' GRAPHIC ARRAY DECLARATIONS

DIM SHARED Back(13, 9 TO 11) AS DOUBLE
DIM SHARED Player(13, 1 TO 8, 1 TO 2) AS DOUBLE
DIM SHARED Ball(13, 21 TO 22) AS DOUBLE

' Set the player constants

Pl.Pic = 1
Pl.Mask = 2

Pl.ayer1D = 1
Pl.ayer1U = 2
Pl.ayer1R = 3
Pl.ayer1L = 4
Pl.ayer2D = 5
Pl.ayer2U = 6
Pl.ayer2R = 7
Pl.ayer2L = 8
Pl.ayer1B = 9
Pl.ayer2B = 10
Pl.BallB = 11
Pl.Ball = 20

Pl1.Score = 0
Pl2.Score = 0

OPEN "1on1.ini" FOR INPUT AS #1
LINE INPUT #1, Dummy$
INPUT #1, Pl2AI, AiSpeed, Goals, Pl1Name$, Pl2Name$
CLOSE #1

PRINT "DONE"

' START THE Z-KB HANDLER

PRINT "KEY HANDLING ROUTINES...";

LoadAsm
Zkbon

PRINT "DONE"

' CALCULATE CPU SPEED

PRINT "CALCULATING CPU SPEED..";

CalCPUspeed

PRINT "DONE  ( FPS:"; Fps; ")"

FadeOut 15, .01
CLS

' WHOPPEE DOO!

RANDOMIZE TIMER

SCREEN 13

LoadFont
LoadPlayersAndBall

LoadPal "1on1.pal"

Intro

PlayGame

' TURN OFF ZKB

Zkboff

' THE END...

 FadeOut 255, .01
 SCREEN 0
 WIDTH 80
 PALETTE
 LOCATE 5, 40 - LEN("HEHE! WHAT AN EFFECTFUL ENDING!!!") / 2
 PRINT "HEHE! WHAT AN EFFECTFUL ENDING!!!"
 LOCATE 7, 40 - LEN("THANKS FOR TRYING OUT 1ON1") / 2
 PRINT "THANKS FOR TRYING OUT 1ON1"
 LOCATE 9, 40 - LEN("MAIL ME AT funline01@hotmail.com !!!") / 2
 PRINT "MAIL ME AT funline01@hotmail.com !!!"
 PLAY "MFL2cgL4eeL2cL4dd<gg>cg>L2c<L1C"

END

REM $STATIC
' This function decides where the AI player goes -
' first it chooses a Hotspot to move towards, and then moves towards it..
'
'
FUNCTION AIMove
 
 '-----------
 '-------STANDARD MOVEMENT CONTROL AND AREA DEFINITION
 '-----------
 IF (TheBall.Ypos < 20 AND TheBall.Ypos > 2 AND TheBall.Xpos > 7 AND TheBall.Xpos < 14) OR (TheBall.Ypos = 2 AND (TheBall.Xpos <= 7 OR TheBall.Xpos >= 14)) THEN
  HotSpotX = TheBall.Xpos
  HotSpotY = TheBall.Ypos - 1
  Area = 1
 ELSEIF TheBall.Ypos = 2 AND TheBall.Xpos > 7 AND TheBall.Xpos < 14 THEN
  IF Pl2.Xpos - TheBall.Xpos > 0 THEN HotAdd = 1 ELSE HotAdd = -1
  HotSpotX = TheBall.Xpos + HotAdd * 2
  HotSpotY = TheBall.Ypos
  Area = 2
 ELSE
  IF TheBall.Xpos > 13 THEN HotAdd = 1 ELSE HotAdd = -1
  HotSpotX = TheBall.Xpos + HotAdd
  HotSpotY = TheBall.Ypos
  Area = 3
 END IF

 '-----------
 '-------ADVANCED, AREA-DEFINED MOVEMENT CONTROL
 '-----------
 IF Area = 1 THEN
  IF Pl2.Xpos = Pl1.Xpos AND Pl2.Xpos = TheBall.Xpos AND Pl2.Ypos = TheBall.Ypos - 1 AND Pl1.Ypos = TheBall.Ypos + 1 AND INT(RND * 3) = 1 THEN
   HotAdd = 1 - (INT(RND * 2) * 2)
   HotSpotX = Pl2.Xpos + HotAdd
   HotSpotY = Pl2.Ypos
   IF INT(RND * 4) > 0 THEN InstantMove = 1
  ELSEIF (Pl2.Xpos = Pl1.Xpos - 1 OR Pl2.Xpos = Pl1.Xpos + 1) AND Pl1.Xpos = TheBall.Xpos AND Pl2.Ypos = TheBall.Ypos - 1 AND Pl1.Ypos = TheBall.Ypos + 1 AND INT(RND * 4) > 0 THEN
   HotSpotX = Pl2.Xpos
   HotSpotY = Pl2.Ypos + 1
   IF INT(RND * 4) > 0 THEN InstantMove = 1
  ELSEIF (Pl2.Xpos = Pl1.Xpos - 1 OR Pl2.Xpos = Pl1.Xpos + 1) AND Pl1.Xpos = TheBall.Xpos AND Pl2.Ypos = TheBall.Ypos AND Pl1.Ypos = TheBall.Ypos + 1 THEN
   HotSpotX = TheBall.Xpos
   HotSpotY = TheBall.Ypos
   IF INT(RND * 4) > 0 THEN InstantMove = 1
  ELSEIF Pl2.Xpos = TheBall.Xpos AND Pl2.Ypos = TheBall.Ypos + 1 THEN
   HotSpotX = Pl2.Xpos + ((INT(RND * 2) * 2) - 1)
   HotSpotY = Pl2.Ypos
  ELSEIF Pl2.Ypos = TheBall.Ypos AND (Pl2.Xpos = TheBall.Xpos - 1 OR Pl2.Xpos = TheBall.Xpos - 1) THEN
   HotSpotX = Pl2.Xpos
   HotSpotY = Pl2.Ypos - 1
  ELSEIF Pl2.Xpos = TheBall.Xpos AND Pl2.Ypos = TheBall.Ypos - 1 THEN
   HotSpotX = Pl2.Xpos
   HotSpotY = Pl2.Ypos + 1
  END IF
 ELSEIF Area = 2 THEN
  IF NOT (Pl1.Ypos = 3 AND Pl1.Xpos = TheBall.Xpos - HotAdd) THEN
   HotSpotX = TheBall.Xpos
   HotSpotY = TheBall.Ypos
  END IF
 ELSEIF Area = 3 THEN
  IF Pl2.Ypos = TheBall.Ypos AND Pl2.Xpos + HotAdd * 2 = HotSpotX THEN
   HotSpotX = TheBall.Xpos
   HotSpotY = TheBall.Ypos - 1
  ELSEIF Pl2.Ypos = TheBall.Ypos - 1 AND Pl2.Xpos = TheBall.Xpos THEN
   HotSpotX = TheBall.Xpos + HotAdd
   HotSpotY = TheBall.Ypos - 1
  ELSEIF Pl2.Xpos = HotSpotX AND Pl2.Ypos = HotSpotY THEN
   IF NOT ((Pl1.Ypos = Pl2.Xpos - 1 OR Pl1.Ypos = Pl2.Xpos + 1) AND Pl1.Xpos = TheBall.Xpos - HotAdd) THEN
    HotSpotX = TheBall.Xpos
    HotSpotY = TheBall.Ypos
   END IF
  END IF
 END IF

 '-----------
 '-------MOVEMENT EXECUTION
 '-----------
 Xmove = HotSpotX - Pl2.Xpos
 Ymove = HotSpotY - Pl2.Ypos
 IF ABS(Xmove) <= ABS(Ymove) THEN
  IF SGN(Ymove) = -1 THEN AIMove = Pl.ayer2U
  IF SGN(Ymove) = 1 THEN AIMove = Pl.ayer2D
 ELSE
  IF SGN(Xmove) = -1 THEN AIMove = Pl.ayer2L
  IF SGN(Xmove) = 1 THEN AIMove = Pl.ayer2R
 END IF

END FUNCTION

DEFSNG A-Z
SUB CalCPUspeed

 N# = 5000
 DO
  PRINT ".";
  N# = N# * 2
  IF TIMER > 86350 THEN                  'If closing up to midnight,
   DO                                    'wait until past midnight
    Tim! = TIMER
   LOOP UNTIL Tim! > 0 AND Tim! < 100
  END IF
  Tim! = TIMER
 
  FOR D# = 1 TO N#
  NEXT D#
 
  Tim! = TIMER - Tim!
 
 LOOP UNTIL Tim! >= 1
 Fps = N# / Tim!

END SUB

SUB Delay (TimeToWait!)
 N# = Fps# * TimeToWait
 FOR D# = 1 TO N#
 NEXT D#
END SUB

DEFINT A-Z
SUB DrawBox (Sx, Sy, Ex, Ey)
 LINE (Sx + 0, Sy + 0)-(Ex - 0, Ey - 0), 252, B
 LINE (Sx + 1, Sy + 1)-(Ex - 1, Ey - 1), 255, B
 LINE (Sx + 2, Sy + 2)-(Ex - 2, Ey - 2), 255, B
 LINE (Sx + 3, Sy + 3)-(Ex - 3, Ey - 3), 249, B
 LINE (Sx + 4, Sy + 4)-(Ex - 4, Ey - 4), 0, BF
END SUB

SUB FadeOut (Colors, FadeSpeed!)

 A$ = SPACE$((Colors + 1) * 3)
 FOR I = 0 TO Colors
  OUT &H3C7, I
  MID$(A$, I * 3 + 1, 1) = CHR$(INP(&H3C9))
  MID$(A$, I * 3 + 2, 1) = CHR$(INP(&H3C9))
  MID$(A$, I * 3 + 3, 1) = CHR$(INP(&H3C9))
 NEXT I

 FOR I = 63 TO 0 STEP -1
  FOR J = 0 TO Colors
   OUT &H3C8, J
   FOR X = 1 TO 3
    OUT &H3C9, (ASC(MID$(A$, J * 3 + X)) / 63) * I
  NEXT X, J
  Delay FadeSpeed!
 NEXT I

END SUB

SUB Fprint (Txt$, PXpos, PYpos, Size!, Cler)
 DEF SEG = &HA000

 Ntxt$ = UCASE$(Txt$)

 IF Cler > 0 THEN LINE (PXpos, PYpos)-(PXpos + 5 * Size! * LEN(Ntxt$), PYpos + 5 * Size!), Cler, BF
 IF Cler = -1 THEN LINE (PXpos, PYpos)-(PXpos + 5 * Size! * LEN(Ntxt$), PYpos + 5 * Size!), 0, BF

 FOR I = 1 TO LEN(Txt$)
  Skip = 0
  Letter = ASC(MID$(Ntxt$, I, 1))
  IF Letter >= 65 AND Letter <= 90 THEN
   Pletter = Letter - 64
  ELSEIF Letter >= 49 AND Letter <= 57 THEN
   Pletter = Letter - 22
  ELSEIF Letter = 48 THEN
   Pletter = 36
  ELSEIF Letter = 46 THEN
   Pletter = 37
  ELSEIF Letter = 33 THEN
   Pletter = 38
  ELSEIF Letter = 63 THEN
   Pletter = 39
  ELSEIF Letter = 44 THEN
   Pletter = 40
  ELSEIF Letter = 45 THEN
   Pletter = 41
  ELSE
   Skip = 1
  END IF
  IF NOT Skip = 1 THEN
   BaseX = PXpos + (I - 1) * 5 * Size!
   IF BaseX > 320 THEN EXIT FOR
   FOR Y! = 0 TO (5 * Size!) STEP Size!
    FOR X! = 0 TO (4 * Size!) STEP Size!
     Clr = ASC(MID$(Font(Pletter), Y! / Size! * 5 + X! / Size! + 1, 1))
     IF Clr <> 0 THEN LINE (BaseX + X!, PYpos + Y!)-(BaseX + X! + Size! - 1, PYpos + Y! + Size! - 1), Clr, BF
    NEXT X!
   NEXT Y!
  END IF
 NEXT I
 
 DEF SEG
END SUB

SUB GoalSub (P1Moves, P2Moves)

 Fprint TTT$(Pl1.Score), 40, 35, 1, 252
 Fprint TTT$(Pl2.Score), 40, 49, 1, 252

 DIM Scrn(8001) AS DOUBLE
 GET (0, 0)-(319, 199), Scrn

 FOR I = 10 TO 80
  DrawBox 160 - I, 100 - I / 4, 160 + I, 100 + I / 4
  Delay .002
 NEXT I

 FOR I = 1 TO 8
  Fprint LEFT$("GOAL!!!!", I), 105, 90, 3, 0
  Delay .2
 NEXT I

 FOR I = 80 TO 0 STEP -4
  PUT (0, 0), Scrn, PSET
  DrawBox 160 - I, 100 - I / 4, 160 + I, 100 + I / 4
  Delay .02
 NEXT I

 PUT (0, 0), Scrn, PSET

 SetObject Pl.ayer1B, Pl1.Xpos, Pl1.Ypos
 SetObject Pl.ayer2B, Pl2.Xpos, Pl2.Ypos
 SetObject Pl.BallB, TheBall.Xpos, TheBall.Ypos

 Pl1.Xpos = 10
 Pl1.Ypos = 11
 Pl2.Xpos = 10
 Pl2.Ypos = 9
 TheBall.Xpos = 10
 TheBall.Ypos = 10
 P2Moves = Pl.ayer2D
 P1Moves = Pl.ayer1U

 SetObject Pl.Ball, TheBall.Xpos, TheBall.Ypos

END SUB

SUB Intro

 LoadPlayScreen

END SUB

DEFSNG A-Z
SUB LoadAsm
Zkbh$(0) = ""
Zkbh$(0) = Zkbh$(0) + CHR$(&H55)
Zkbh$(0) = Zkbh$(0) + CHR$(&H89) + CHR$(&HE5)
Zkbh$(0) = Zkbh$(0) + CHR$(&HB8) + CHR$(&H9) + CHR$(&H35)
Zkbh$(0) = Zkbh$(0) + CHR$(&HCD) + CHR$(&H21)
Zkbh$(0) = Zkbh$(0) + CHR$(&H31) + CHR$(&HC0)
Zkbh$(0) = Zkbh$(0) + CHR$(&H89) + CHR$(&HD8)
Zkbh$(0) = Zkbh$(0) + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
Zkbh$(0) = Zkbh$(0) + CHR$(&H89) + CHR$(&H7)
Zkbh$(0) = Zkbh$(0) + CHR$(&H8C) + CHR$(&HC0)
Zkbh$(0) = Zkbh$(0) + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
Zkbh$(0) = Zkbh$(0) + CHR$(&H89) + CHR$(&H7)
Zkbh$(0) = Zkbh$(0) + CHR$(&H5D)
Zkbh$(0) = Zkbh$(0) + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)

Zkbh$(1) = ""
Zkbh$(1) = Zkbh$(1) + CHR$(&H55)
Zkbh$(1) = Zkbh$(1) + CHR$(&H1E)
Zkbh$(1) = Zkbh$(1) + CHR$(&H89) + CHR$(&HE5)
Zkbh$(1) = Zkbh$(1) + CHR$(&H8B) + CHR$(&H46) + CHR$(&HA)
Zkbh$(1) = Zkbh$(1) + CHR$(&H8E) + CHR$(&HD8)
Zkbh$(1) = Zkbh$(1) + CHR$(&H8B) + CHR$(&H56) + CHR$(&H8)
Zkbh$(1) = Zkbh$(1) + CHR$(&HB8) + CHR$(&H9) + CHR$(&H25)
Zkbh$(1) = Zkbh$(1) + CHR$(&HCD) + CHR$(&H21)
Zkbh$(1) = Zkbh$(1) + CHR$(&H1F)
Zkbh$(1) = Zkbh$(1) + CHR$(&H5D)
Zkbh$(1) = Zkbh$(1) + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)

Zkbh$(2) = ""
Zkbh$(2) = Zkbh$(2) + CHR$(&H50)
Zkbh$(2) = Zkbh$(2) + CHR$(&H53)
Zkbh$(2) = Zkbh$(2) + CHR$(&H1E)
Zkbh$(2) = Zkbh$(2) + CHR$(&HFB)
Zkbh$(2) = Zkbh$(2) + CHR$(&HB8) + MKI$(VARSEG(Zkey%(0)))
Zkbh$(2) = Zkbh$(2) + CHR$(&H31) + CHR$(&HDB)
Zkbh$(2) = Zkbh$(2) + CHR$(&H8E) + CHR$(&HD8)
Zkbh$(2) = Zkbh$(2) + CHR$(&HE4) + CHR$(&H60)
Zkbh$(2) = Zkbh$(2) + CHR$(&HD0) + CHR$(&HD0)
Zkbh$(2) = Zkbh$(2) + CHR$(&H88) + CHR$(&HC3)
Zkbh$(2) = Zkbh$(2) + CHR$(&HF) + CHR$(&H93) + CHR$(&HC0)
Zkbh$(2) = Zkbh$(2) + CHR$(&H81) + CHR$(&HC3) + MKI$(VARPTR(Zkey%(0)))
Zkbh$(2) = Zkbh$(2) + CHR$(&H88) + CHR$(&H7)
Zkbh$(2) = Zkbh$(2) + CHR$(&HE4) + CHR$(&H61)
Zkbh$(2) = Zkbh$(2) + CHR$(&H80) + CHR$(&HCC) + CHR$(&H82)
Zkbh$(2) = Zkbh$(2) + CHR$(&HE6) + CHR$(&H61)
Zkbh$(2) = Zkbh$(2) + CHR$(&H24) + CHR$(&H7F)
Zkbh$(2) = Zkbh$(2) + CHR$(&HE6) + CHR$(&H61)
Zkbh$(2) = Zkbh$(2) + CHR$(&HB0) + CHR$(&H20)
Zkbh$(2) = Zkbh$(2) + CHR$(&HE6) + CHR$(&H20)
Zkbh$(2) = Zkbh$(2) + CHR$(&H1F)
Zkbh$(2) = Zkbh$(2) + CHR$(&H5B)
Zkbh$(2) = Zkbh$(2) + CHR$(&H58)
Zkbh$(2) = Zkbh$(2) + CHR$(&HCF)
END SUB

SUB LoadFont
 OPEN "RESOURCE.BIN" FOR BINARY AS #1
 Dummy$ = " "
 GET #1, 68000, Dummy$
 FOR I = 1 TO 41
  GET #1, , Font(I)
 NEXT I
 CLOSE #1
END SUB

SUB LoadPal (Pfile$)

 A$ = SPACE$(768)

 OPEN Pfile$ FOR BINARY AS #1
  GET #1, , A$
 CLOSE #1

 OUT &H3C7, 0
 OUT &H3C8, 0
 FOR I = 1 TO 768
  OUT &H3C9, ASC(MID$(A$, I, 1)) \ 4
 NEXT I

END SUB

SUB LoadPlayersAndBall

 OPEN "RESOURCE.BIN" FOR BINARY AS #1

 Dummy$ = " "
 GET #1, 65000, Dummy$

 FOR I = 1 TO 2
  FOR J = 1 TO 8
   FOR X = 0 TO 13
    GET #1, , Player(X, J, I)
 NEXT X, J, I

 Dummy$ = " "
 GET #1, 67000, Dummy$

 FOR I = 21 TO 22
  FOR X = 0 TO 13
    GET #1, , Ball(X, I)
 NEXT X, I

 CLOSE #1
END SUB

DEFINT A-Z
SUB LoadPlayScreen
 DIM Scr(8001) AS DOUBLE

 DIM Page2(8001) AS DOUBLE
 XCls 320, 200, VARSEG(Page2(0)), VARPTR(Page2(0))

 OPEN "Resource.bin" FOR BINARY AS #1
 FOR I = 0 TO 8001
  GET #1, , Scr(I)
 NEXT I
 CLOSE #1

 FSegm = VARSEG(Scr(0))
 FOffs = VARPTR(Scr(0))
 TSegm = VARSEG(Page2(0))
 TOffs = VARPTR(Page2(0))

 FOR I = 0 TO 155
  XCopy 159 - I, 99 - I / 1.65, 160 + I, 99 - I / 1.65, 159 - I, 99 - I / 1.65, FSegm, FOffs, TSegm, TOffs, 500
  XCopy 159 - I, 99 - I / 1.65, 159 - I, 100 + I / 1.65, 159 - I, 99 - I / 1.65, FSegm, FOffs, TSegm, TOffs, 500
  XCopy 159 - I, 100 + I / 1.65, 160 + I, 100 + I / 1.65, 159 - I, 100 + I / 1.65, FSegm, FOffs, TSegm, TOffs, 500
  XCopy 160 + I, 99 - I / 1.65, 160 + I, 100 + I / 1.65, 160 + I, 99 - I / 1.65, FSegm, FOffs, TSegm, TOffs, 500
 
  XBox 159 - (I + 1), 99 - (I + 1) / 1.65, 160 + (I + 1), 100 + (I + 1) / 1.65, 80, TSegm, TOffs
  PUT (0, 0), Page2(0), PSET
  Delay .005
 NEXT I
 PUT (0, 0), Scr(0), PSET
 ERASE Scr, Page2
END SUB

DEFSNG A-Z
SUB Menu







END SUB

DEFINT A-Z
FUNCTION Player1Move

 Player1Move = 0

 IF Zkey%(&H4D) THEN  ELSE KeyDisabled(&H4D) = 0
 IF Zkey%(&H4B) THEN  ELSE KeyDisabled(&H4B) = 0
 IF Zkey%(&H48) THEN  ELSE KeyDisabled(&H48) = 0
 IF Zkey%(&H50) THEN  ELSE KeyDisabled(&H50) = 0

 IF Zkey%(&H4D) AND KeyDisabled(&H4D) = 0 THEN
  Player1Move = Pl.ayer1R
  KeyDisabled(&H4D) = -1
 ELSEIF Zkey%(&H4B) AND KeyDisabled(&H4B) = 0 THEN
  Player1Move = Pl.ayer1L
  KeyDisabled(&H4B) = -1
 ELSEIF Zkey%(&H48) AND KeyDisabled(&H48) = 0 THEN
  Player1Move = Pl.ayer1U
  KeyDisabled(&H48) = -1
 ELSEIF Zkey%(&H50) AND KeyDisabled(&H50) = 0 THEN
  Player1Move = Pl.ayer1D
  KeyDisabled(&H50) = -1
 END IF
END FUNCTION

FUNCTION Player2Move

 IF Pl2AI = 1 THEN
 
  IF TIMER - LastTimer >= AiSpeed THEN
   LastTimer = TIMER
   AiAct = AIMove
   IF InstantMove = 1 THEN
    Player2Move = AiAct
    AiAct = 0
    InstantMove = 0
   END IF
  ELSEIF TIMER - LastTimer >= AiSpeed * .5 AND AiAct <> 0 THEN
   Player2Move = AiAct
   AiAct = 0
  END IF
  EXIT FUNCTION
 END IF

 Player2Move = 0

 IF Zkey%(&H20) THEN  ELSE KeyDisabled(&H20) = 0
 IF Zkey%(&H1E) THEN  ELSE KeyDisabled(&H1E) = 0
 IF Zkey%(&H11) THEN  ELSE KeyDisabled(&H11) = 0
 IF Zkey%(&H1F) THEN  ELSE KeyDisabled(&H1F) = 0

 IF Zkey%(&H20) AND KeyDisabled(&H20) = 0 THEN
  Player2Move = Pl.ayer2R
  KeyDisabled(&H20) = -1
 ELSEIF Zkey%(&H1E) AND KeyDisabled(&H1E) = 0 THEN
  Player2Move = Pl.ayer2L
  KeyDisabled(&H1E) = -1
 ELSEIF Zkey%(&H11) AND KeyDisabled(&H11) = 0 THEN
  Player2Move = Pl.ayer2U
  KeyDisabled(&H11) = -1
 ELSEIF Zkey%(&H1F) AND KeyDisabled(&H1F) = 0 THEN
  Player2Move = Pl.ayer2D
  KeyDisabled(&H1F) = -1
 END IF

END FUNCTION

'
' The GAME
'
'And now a small break...
'
'  The number PI can be calculated in several ways.
'  For example
'
'  -  4 * ATN(1)
'  -  SIN(180 / N) * N (With N as the highest possible number, and SIN in degrees)
'  -  4 * (1/1 - 1/3 + 1/5 - 1/7 + 1/9 - 1/11 (And so on))
'
'  Today, PI is known with about 59 billion decimals. Here is the first part:
'
'  3.141592653589793238462643383279502884197169399375105
'
'  This should be enough to calculate the circumference of the galaxy with
'  the accurancy of the diameter of a hydrogene atom.
'
' The GAME
'
SUB PlayGame

 LastTimer = TIMER

 Pl1.Xpos = 10
 Pl1.Ypos = 11
 TheBall.Xpos = 10
 TheBall.Ypos = 10
 Pl2.Xpos = 10
 Pl2.Ypos = 9

 quit = 0

 SetObject Pl.Ball, TheBall.Xpos, TheBall.Ypos
 SetObject Pl.ayer1U, Pl1.Xpos, Pl1.Ypos
 SetObject Pl.ayer2D, Pl2.Xpos, Pl2.Ypos

 Fprint Pl1Name$, 30, 28, 1, 252
 Fprint TTT$(Pl1.Score), 40, 35, 1, 252
 Fprint Pl2Name$, 30, 42, 1, 252
 Fprint TTT$(Pl2.Score), 40, 49, 1, 252

 DO
  DO
   P1Moves = Player1Move
   P2Moves = Player2Move
   IF Zkey%(&H1) THEN quit = 1
  LOOP UNTIL P1Moves <> 0 OR P2Moves <> 0 OR quit = 1
  IF quit = 1 THEN EXIT DO
 
  IF P1Moves <> 0 THEN
   Xad = 0
   Yad = 0
   IF P1Moves = Pl.ayer1D THEN Yad = 1
   IF P1Moves = Pl.ayer1U THEN Yad = -1
   IF P1Moves = Pl.ayer1R THEN Xad = 1
   IF P1Moves = Pl.ayer1L THEN Xad = -1
   TestX = Pl1.Xpos + Xad
   TestY = Pl1.Ypos + Yad
   SetObject Pl.ayer1B, Pl1.Xpos, Pl1.Ypos
   IF (TestY >= 2 AND TestY <= 19 AND TestX >= 1 AND TestX <= 20) OR ((TestY = 1 OR TestY = 20) AND ((TestX >= 1 AND TestX <= 7) OR (TestX >= 14 AND TestX <= 20))) THEN
    IF TestX = Pl2.Xpos AND TestY = Pl2.Ypos THEN
     '
     Dummy = 0
     '
    ELSEIF TestX = TheBall.Xpos AND TestY = TheBall.Ypos THEN
     BTestX = TheBall.Xpos + Xad
     BTestY = TheBall.Ypos + Yad
     IF (BTestY >= 2 AND BTestY <= 19 AND BTestX >= 2 AND BTestX <= 19) OR ((BTestY = 1 OR BTestY = 20) AND (BTestX > 7 AND BTestX < 14)) THEN
      IF BTestX = Pl2.Xpos AND BTestY = Pl2.Ypos THEN
       '
       Dummy = 0
       '
      ELSE
       SetObject Pl.BallB, TheBall.Xpos, TheBall.Ypos
       Pl1.Xpos = TestX
       Pl1.Ypos = TestY
       TheBall.Xpos = BTestX
       TheBall.Ypos = BTestY
       SetObject Pl.Ball, TheBall.Xpos, TheBall.Ypos
       IF TheBall.Ypos = 1 THEN
        Pl1.Score = Pl1.Score + 1
        GoalSub P1Moves, P2Moves
        SetObject Pl.ayer2D, Pl2.Xpos, Pl2.Ypos
       ELSEIF TheBall.Ypos = 20 THEN
        Pl2.Score = Pl2.Score + 1
        GoalSub P1Moves, P2Moves
        SetObject Pl.ayer2D, Pl2.Xpos, Pl2.Ypos
       END IF
       IF Pl1.Score = Goals OR Pl2.Score = Goals THEN
        Winner
        EXIT DO
       END IF
      END IF
     END IF
    ELSE
     Pl1.Xpos = TestX
     Pl1.Ypos = TestY
    END IF
   END IF
   SetObject P1Moves, Pl1.Xpos, Pl1.Ypos
  END IF
 
  IF P2Moves <> 0 THEN
   Xad = 0
   Yad = 0
   IF P2Moves = Pl.ayer2D THEN Yad = 1
   IF P2Moves = Pl.ayer2U THEN Yad = -1
   IF P2Moves = Pl.ayer2R THEN Xad = 1
   IF P2Moves = Pl.ayer2L THEN Xad = -1
   TestX = Pl2.Xpos + Xad
   TestY = Pl2.Ypos + Yad
   SetObject Pl.ayer2B, Pl2.Xpos, Pl2.Ypos
   IF (TestY >= 2 AND TestY <= 19 AND TestX >= 1 AND TestX <= 20) OR ((TestY = 1 OR TestY = 20) AND ((TestX >= 1 AND TestX <= 7) OR (TestX >= 14 AND TestX <= 20))) THEN
    IF TestX = Pl1.Xpos AND TestY = Pl1.Ypos THEN
     '
     Dummy = 0
     '
    ELSEIF TestX = TheBall.Xpos AND TestY = TheBall.Ypos THEN
     BTestX = TheBall.Xpos + Xad
     BTestY = TheBall.Ypos + Yad
     IF (BTestY >= 2 AND BTestY <= 19 AND BTestX >= 2 AND BTestX <= 19) OR ((BTestY = 1 OR BTestY = 20) AND (BTestX > 7 AND BTestX < 14)) THEN
      IF BTestX = Pl1.Xpos AND BTestY = Pl1.Ypos THEN
       '
       Dummy = 0
       '
      ELSE
       SetObject Pl.BallB, TheBall.Xpos, TheBall.Ypos
       Pl2.Xpos = TestX
       Pl2.Ypos = TestY
       TheBall.Xpos = BTestX
       TheBall.Ypos = BTestY
       SetObject Pl.Ball, TheBall.Xpos, TheBall.Ypos
       IF TheBall.Ypos = 1 THEN
        Pl1.Score = Pl1.Score + 1
        GoalSub P1Moves, P2Moves
        SetObject Pl.ayer1D, Pl1.Xpos, Pl1.Ypos
       ELSEIF TheBall.Ypos = 20 THEN
        Pl2.Score = Pl2.Score + 1
        GoalSub P1Moves, P2Moves
        SetObject Pl.ayer1D, Pl1.Xpos, Pl1.Ypos
       END IF
       IF Pl1.Score = Goals OR Pl2.Score = Goals THEN
        Winner
        EXIT DO
       END IF
      END IF
     END IF
    ELSE
     Pl2.Xpos = TestX
     Pl2.Ypos = TestY
    END IF
   END IF
   SetObject P2Moves, Pl2.Xpos, Pl2.Ypos
  END IF

 LOOP

END SUB

SUB SetObject (WhatObject, X, Y)

 SELECT CASE WhatObject
 CASE 1 TO 8
  IF WhatObject <= 4 THEN BackGround = Pl.ayer1B ELSE BackGround = Pl.ayer2B
  GET (110 + X * 10, Y * 10 - 10)-STEP(9, 9), Back(0, BackGround)
  PUT (110 + X * 10, Y * 10 - 10), Player(0, WhatObject, Pl.Mask), AND
  PUT (110 + X * 10, Y * 10 - 10), Player(0, WhatObject, Pl.Pic), OR
 CASE Pl.ayer1B, Pl.ayer2B, Pl.BallB
  PUT (110 + X * 10, Y * 10 - 10), Back(0, WhatObject), PSET
 CASE Pl.Ball
  GET (110 + X * 10, Y * 10 - 10)-STEP(9, 9), Back(0, Pl.BallB)
  PUT (110 + X * 10, Y * 10 - 10), Ball(0, Pl.Ball + Pl.Mask), AND
  PUT (110 + X * 10, Y * 10 - 10), Ball(0, Pl.Ball + Pl.Pic), OR
 END SELECT

END SUB

FUNCTION TTT$ (Num)
 TTT$ = LTRIM$(RTRIM$(STR$(Num)))
END FUNCTION

SUB Winner
 '
 ' THIS IS SUPPOSED TO BE THE GRAND WINNER SUb WITH EFFECTS AND STUFF...
 '
 '
END SUB

                     ' BEFORE COMPILING, CHANGE TO DEFINT A-Z
SUB XBox (Sx, Sy, Stx, Sty, Clr, Segment, Offset)

 DEF SEG = Segment
  TheWidth = PEEK(Offset) / 8 + PEEK(Offset + 1) * 32
  StepX = SGN(Stx - Sx)
  StepY = SGN(Sty - Sy)

  IF StepX = 0 AND StepY = 0 THEN
    POKE (Sy * TheWidth + Sx + 4 + Offset), Clr
    DEF SEG
    EXIT SUB
  END IF
 
  IF StepX = 0 THEN
   FOR I = Sy TO Sty STEP StepY
    POKE (I * TheWidth + Sx + 4 + Offset), Clr
   NEXT I
   DEF SEG
   EXIT SUB
  ELSEIF StepY = 0 THEN
   FOR I = Sx TO Stx STEP StepX
    POKE (Sy * TheWidth + I + 4 + Offset), Clr
   NEXT I
   DEF SEG
   EXIT SUB
  END IF
 
  FOR I = Sx TO Stx STEP StepX
   POKE (Sy * TheWidth + I + 4 + Offset), Clr
  NEXT I
  FOR I = Sx TO Stx STEP StepX
   POKE (Sty * TheWidth + I + 4 + Offset), Clr
  NEXT I
  FOR I = Sy TO Sty STEP StepY
   POKE (I * TheWidth + Sx + 4 + Offset), Clr
  NEXT I
  FOR I = Sy TO Sty STEP StepY
   POKE (I * TheWidth + Stx + 4 + Offset), Clr
  NEXT I
 DEF SEG
END SUB

                     ' BEFORE COMPILING, CHANGE TO DEFINT A-Z
SUB XCls (TheWidth, TheHeight, Segment, Offset)

 DEF SEG = Segment
  Byte1 = (TheWidth MOD 32) * 8
  Byte2 = (TheWidth - (Byte1 / 8)) / 32
  POKE (Offset), Byte1
  POKE (Offset + 1), Byte2
  POKE (Offset + 2), TheHeight
  POKE (Offset + 3), 0
  FOR I = 1 TO TheWidth * TheHeight
   POKE (I + 3), 0
  NEXT I
 DEF SEG

END SUB

                     ' BEFORE COMPILING, CHANGE TO DEFINT A-Z
SUB XCopy (FSx, FSy, FStx, FSty, TSx, TSy, FSegment, FOffset, TSegment, Toffset, BlockLength)

 DEF SEG = FSegment
  FWidth = PEEK(FOffset) / 8 + PEEK(FOffset + 1) * 32
 DEF SEG
 DEF SEG = TSegment
  TWidth = PEEK(Toffset) / 8 + PEEK(Toffset + 1) * 32
 DEF SEG

 InSx = FSx: InStx = FStx: InSy = FSy: InSty = FSty

 IF InSx > InStx THEN SWAP InSx, InStx
 IF InSy > InSty THEN SWAP InSy, InSty

 Ypos = 0

 TheWidth = (InStx - InSx) + 1
 TheHeight = (InSty - InSy) + 1

 BlockL = BlockLength - (BlockLength MOD TheWidth) + TheWidth
 Block$ = SPACE$(BlockL)

 DO
  BlockPos = 0
  BlockDone = 0
  DEF SEG = FSegment
   FOR I = InSy + Ypos TO InSty
    FOR J = InSx TO InStx
     IF BlockPos = BlockL THEN
      BlockDone = -1
      EndY = I - InSy
      EXIT FOR
     ELSE
      BlockPos = BlockPos + 1
     END IF
     MID$(Block$, BlockPos, 1) = CHR$(PEEK(I * FWidth + J + 4 + FOffset))
    NEXT J
    IF BlockDone THEN EXIT FOR ELSE EndY = TheHeight - 1
   NEXT I
  DEF SEG
  BlockPos = 0
  DEF SEG = TSegment
   FOR I = TSy + Ypos TO TSy + EndY
    FOR J = TSx TO TSx + TheWidth - 1
     BlockPos = BlockPos + 1
     POKE (I * TWidth + J + 4 + Toffset), ASC(MID$(Block$, BlockPos, 1))
    NEXT J
   NEXT I
  DEF SEG
  Ypos = EndY + 1
 LOOP UNTIL EndY = TheHeight - 1
END SUB

DEFSNG A-Z
SUB XEllipse (CenterX, CenterY, Xradius, Yradius, Clr, Segment, Offset, Stp)
 Rad = 3.14159 / 180
 DEF SEG = Segment
  TheWidth = PEEK(Offset) / 8 + PEEK(Offset + 1) * 32
  FOR Angle = 1 TO 360 STEP Stp
   XLine INT(CenterX + SIN(Angle * Rad) * Xradius), INT(CenterY + COS(Angle * Rad) * Yradius), INT(CenterX + SIN((Angle + Stp) * Rad) * Xradius), INT(CenterY + COS((Angle + Stp) * Rad) * Yradius), Clr, Segment, Offset
  NEXT Angle
 DEF SEG
END SUB

DEFINT A-Z
                     ' BEFORE COMPILING, CHANGE TO DEFINT A-Z
SUB XFbox (Sx, Sy, Stx, Sty, Clr, Segment, Offset)

 DEF SEG = Segment
 
  TheWidth = PEEK(Offset) / 8 + PEEK(Offset + 1) * 32
  StepX = SGN(Stx - Sx)
  StepY = SGN(Sty - Sy)

  IF StepX = 0 AND StepY = 0 THEN
    POKE (Sy * TheWidth + Sx + 4 + Offset), Clr
    DEF SEG
    EXIT SUB
  END IF

  IF StepX = 0 THEN
   FOR I = Sy TO Sty STEP StepY
    POKE (I * TheWidth + Sx + 4 + Offset), Clr
   NEXT I
   DEF SEG
   EXIT SUB
  ELSEIF StepY = 0 THEN
   FOR I = Sx TO Stx STEP StepX
    POKE (Sy * TheWidth + I + 4 + Offset), Clr
   NEXT I
   DEF SEG
   EXIT SUB
  END IF

  FOR I = Sy TO Sty STEP StepY
   Y = I * TheWidth
   FOR J = Sx TO Stx STEP StepX
    POKE (Y + J + 4 + Offset), Clr
  NEXT J, I
 DEF SEG
END SUB

                     ' BEFORE COMPILING, CHANGE TO DEFINT A-Z
SUB XGet (Sx, Sy, Stx, Sty, FSegment, FOffset, TSegment, Toffset, BlockLength)

 InSx = Sx: InStx = Stx: InSy = Sy: InSty = Sty

 IF InSx > InStx THEN SWAP InSx, InStx
 IF InSy > InSty THEN SWAP InSy, InSty

 TheWidth = (InStx - InSx) + 1
 TheHeight = (InSty - InSy) + 1
 Byte1 = (TheWidth MOD 32) * 8
 Byte2 = (TheWidth - (Byte1 / 8)) / 32
 CurX = InSx
 CurY = InSy
 BytePos = 4

 BlockL = BlockLength - (BlockLength MOD TheWidth) + TheWidth
 Block$ = SPACE$(BlockL)

 DEF SEG = FSegment
  FWidth = PEEK(FOffset) / 8 + PEEK(FOffset + 1) * 32
 DEF SEG
 DEF SEG = TSegment
  POKE (Toffset), Byte1
  POKE (Toffset + 1), Byte2
  POKE (Toffset + 2), TheHeight
  POKE (Toffset + 3), 0
 DEF SEG

 DO
  DEF SEG = FSegment
   BlockPos = 0
   BlockDone = 0
   FOR Ypos = CurY TO InSty
    FOR Xpos = CurX TO InStx
     IF BlockPos = BlockL THEN
      BlockDone = -1
      CurX = Xpos
      CurY = Ypos
      EXIT FOR
     END IF
     BlockPos = BlockPos + 1
     MID$(Block$, BlockPos, 1) = CHR$(PEEK(Ypos * FWidth + Xpos + FOffset + 4))
    NEXT Xpos
    IF BlockDone THEN EXIT FOR
   NEXT Ypos
  DEF SEG
  DEF SEG = TSegment
   FOR I = 1 TO BlockPos
    POKE (BytePos + I - 1 + Toffset), ASC(MID$(Block$, I, 1))
   NEXT I
   BytePos = BytePos + BlockL
  DEF SEG
 LOOP UNTIL NOT BlockDone
END SUB

DEFSNG A-Z
SUB XLine (Sx, Sy, Stx, Sty, Clr, Segment, Offset)

 Xrange = Stx - Sx
 Yrange = Sty - Sy

 IF Xrange = 0 AND Yrange = 0 THEN
  DEF SEG = Segment
   TheWidth = PEEK(Offset) / 8 + PEEK(Offset + 1) * 32
   POKE (PsetY * TheWidth + PsetX + 4 + Offset), Clr
  DEF SEG
  EXIT SUB
 END IF

 DEF SEG = Segment
  TheWidth = PEEK(Offset) / 8 + PEEK(Offset + 1) * 32
  IF ABS(Stx - Sx) >= ABS(Sty - Sy) THEN
   FOR I = Sx TO Stx STEP SGN(Stx - Sx)
    POKE ((INT(Sy + (I - Sx) * Yrange / Xrange) * TheWidth) + INT(I) + 4 + Offset), Clr
   NEXT I
  ELSE
   FOR I = Sy TO Sty STEP SGN(Sty - Sy)
    POKE ((INT(I) * TheWidth) + INT(Sx + (I - Sy) * Xrange / Yrange) + 4 + Offset), Clr
   NEXT I
  END IF
 DEF SEG
END SUB

DEFINT A-Z
                     ' BEFORE COMPILING, CHANGE TO DEFINT A-Z
FUNCTION XPoint (PointX, PointY, Segment, Offset)
 DEF SEG = Segment
  TheWidth = PEEK(Offset) / 8 + PEEK(Offset + 1) * 32
  XPoint = PEEK(PointY * TheWidth + PointX + 4 + Offset)
 DEF SEG
END FUNCTION

                     ' BEFORE COMPILING, CHANGE TO DEFINT A-Z
SUB XPset (PsetX, PsetY, Clr, Segment, Offset)
 DEF SEG = Segment
  TheWidth = PEEK(Offset) / 8 + PEEK(Offset + 1) * 32
  POKE (PsetY * TheWidth + PsetX + 4 + Offset), Clr
 DEF SEG
END SUB

                     ' BEFORE COMPILING, CHANGE TO DEFINT A-Z
SUB XPut (Sx, Sy, FSegment, FOffset, TSegment, Toffset, BlockLength)

 DEF SEG = FSegment
  FWidth = PEEK(FOffset) / 8 + PEEK(FOffset + 1) * 32
  FHeight = PEEK(FOffset + 2)
 DEF SEG
 DEF SEG = TSegment
  TWidth = PEEK(Toffset) / 8 + PEEK(Toffset + 1) * 32
 DEF SEG

 Block$ = SPACE$(BlockLength)

 Stx = Sx + FWidth - 1
 Sty = Sy + FHeight - 1
 Xpos = Sx - 1
 Ypos = Sy
 Done = 0
 BPos = 4                              ' STARTING AT 0
 TotalBytes = FWidth * FHeight + 3     ' STARTING AT 0

 DO
  DEF SEG = FSegment
   IF BPos + BlockLength > TotalBytes + 1 THEN BL = TotalBytes MOD BlockLength ELSE BL = BlockLength
   FOR I = 1 TO BL
    MID$(Block$, I, 1) = CHR$(PEEK(BPos + (I - 1) + FOffset))
   NEXT I
   BPos = BPos + BL
  DEF SEG
  DEF SEG = TSegment
   FOR I = 1 TO BL
    IF Xpos = Stx THEN
     Xpos = Sx
     IF Ypos = Sty THEN
      Done = -1
      EXIT FOR
     ELSE
      Ypos = Ypos + 1
     END IF
    ELSE
     Xpos = Xpos + 1
    END IF
    POKE (Ypos * TWidth + Xpos + 4), ASC(MID$(Block$, I, 1))
   NEXT I
  DEF SEG
 LOOP UNTIL Done

END SUB

DEFSNG A-Z
SUB Zkboff
IF NOT kbonflag% THEN EXIT SUB
DEF SEG = VARSEG(Zkbh$(1))
CALL ABSOLUTE(BYVAL olkbseg%, BYVAL olkboff%, SADD(Zkbh$(1)))
DEF SEG
END SUB

SUB Zkbon

IF kbonflag% THEN EXIT SUB

DEF SEG = VARSEG(Zkbh$(0))
CALL ABSOLUTE(seg1%, off1%, SADD(Zkbh$(0)))
DEF SEG = VARSEG(Zkbh$(1))
CALL ABSOLUTE(BYVAL VARSEG(Zkbh$(2)), BYVAL SADD(Zkbh$(2)), SADD(Zkbh$(1)))
DEF SEG
OUT &H21, (INP(&H21) AND (255 XOR 2)) 'CLEAR BIT 2 (IRQ 1)

olkbseg% = seg1%
olkboff% = off1%

kbonflag% = -1
END SUB

