'/ gslib routines:

DECLARE SUB gssprite (BYVAL x%, BYVAL y%, BYVAL dseg%, BYVAL dofs%, BYVAL sseg%, BYVAL aryofs)
DECLARE SUB gssolidput (BYVAL x%, BYVAL y%, BYVAL dseg%, BYVAL dofs%, BYVAL sseg%, BYVAL sofs%)
DECLARE SUB gspcopy (BYVAL sseg%, BYVAL sofs%, BYVAL dseg%, BYVAL dofs%)
DECLARE SUB gssetbbox (BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%)
DECLARE SUB gstpcopy (BYVAL sseg%, BYVAL sofs%, BYVAL dseg%, BYVAL dofs%, BYVAL col%)
DECLARE SUB gsboxf (BYVAL dseg%, BYVAL dofs%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL col%)
DECLARE SUB gsbox (BYVAL dseg%, BYVAL dofs%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL col%)
DECLARE SUB gspset (BYVAL x%, BYVAL y%, BYVAL dseg%, BYVAL dofs%, BYVAL col%)
DECLARE SUB gswait (BYVAL num%)

'/ game routines:

DECLARE SUB getmap (mapf$)
DECLARE SUB drwscr ()
DECLARE SUB drwmap ()

DECLARE SUB init ()
DECLARE SUB readgfx (aryseg%, aryofs%)

DECLARE SUB pal13load (palf$)
DECLARE SUB pal13fd (rate%)
DECLARE SUB pal13fto (rate%)
DECLARE SUB pal13put ()

DECLARE SUB fontload (fontf$)
DECLARE SUB fontdrw (txt$, x%, y%, c%, cd%, dseg%, dofs%)
DECLARE SUB fontdrws (txt$, x%, y%, c%, cd%, dseg%, dofs%)
DECLARE SUB fontover (txt$, x%, y%, c%, bc%, dseg%, dofs%)

DECLARE SUB clearkbd ()                 ' clears the keyboard
DECLARE SUB installtimer ()             ' sets up the new timer
DECLARE SUB removetimer ()              ' removes the timer
DECLARE SUB msdelay (BYVAL dur%)        ' delays dur/1000 seconds
DECLARE FUNCTION mstimer% ()            ' put here for debugging...

DECLARE SUB sndplay (fxnum%)
DECLARE FUNCTION sndload% (sndf$)

DECLARE SUB doerror (txt$)
DECLARE SUB dooptions ()
DECLARE SUB dohiscores ()
DECLARE SUB dogame ()
DECLARE SUB doapples ()
DECLARE SUB endgame ()
DECLARE SUB drwbox (x1%, y1%, x2%, y2%, bc%, c%)

DECLARE FUNCTION domenu% ()
DECLARE FUNCTION doplay% ()
DECLARE FUNCTION getname$ (maxlen%, yloc%)


' FM.BI -->

'---setup routines--

DECLARE SUB setupmusic (buffer%())
'setupmusic prepares a buffer that your music will use to play.
'run it once at the very beginning of any program where you want to
'play BAM music. buffer%() is an array that needs to be big enough to
'hold the largest BAM file you will be playing (remeber that an array
'of integers holds 2 bytes per element, so if you DIM musicbuf%(16000)
'you will be able to play any BAM up to 32k. that is a good number, since
'it is the largest file size that either MIDI2BAM.EXE or NOTATE.EXE can
'produce

DECLARE SUB closemusic ()
'run this once at the end of your program. This is the complement to
'setupmusic

DECLARE SUB resetfm ()
'reset the FM chip in your sound card. Call this once right after
'setupmusic.

'---playing routines---

DECLARE SUB loadsong (f$)
'loads a BAM file into memory and starts it playing. f$ is the file name,
'and should be zero-terminated. Example:
'loadsong "MYSONG.BAM"+CHR$(0)

DECLARE SUB stopsong ()
'stop the currently playing song. use it at any time in your program

DECLARE SUB resumesong ()
'restarts the music after you stopped with stopsong

'---volume control---

DECLARE FUNCTION getfmvol ()
'returns the current FM mixer volume. It will be a number between 0 and 15
'on most sound cards, or between 0 and 7 for some older cards

DECLARE SUB setfmvol (BYVAL vol%)
'sets the FM mixer volume to the target volume. vol is a number between
'0 and 15

DECLARE SUB fademusic (BYVAL vol%)
'fades the FM volume towards a target volume.

'---manual control routines---
'If use loadsong() then you do not need any of these manual routines
'You do not need them to play a ready-made BAM file, they are just
'provided for writing BAM utilities

DECLARE SUB FMKeyOn (BYVAL voice%, BYVAL freq%)
'manually turns on voice from 0 to 8, setting its frequency 0 to 127.

DECLARE SUB FMKeyOff (BYVAL voice%)
'manually turns off a voice form 0 to 8.

DECLARE SUB setvoice (BYVAL voice%, inst%())
'set the instrument that a voice uses. inst%() is and array dimentioned
'big enough to hold 11 bytes of instrument data. Example:
'DIM instrument%(6)

DECLARE SUB getvoice (BYVAL voice%, BYVAL index%, ibkfile$, inst%())
'reads an instrument from an IBK file and loads it as the specified voice.
'index% is the number of the instrument in the IBK file.
'inst%() is a buffer big enough to hold 11 bytes like with setvoice()
'The instrument data gets left behind in inst%() so you could save it for
'later use with setvoice().


