'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
'PROGRAM: RW2000.BAS
'PROGRAMMER: Matthew River Knight
'EMAIL: horizonsqb@hotmail.com
'WWW: http://www.darklegends.com
'DATE: June 10, 2000
'COMMENTS: This is the QuickBASIC 4.5 source code of Rockwars 2000. It's very
'sloppy and unoptimized I'm sorry to say... I basically just typed it in,
'pushed F5, and hoped for the best! ^_^ No real optimizations have been made,
'and it's unlikely that they ever will be made as this is just a mini-game.
'However, should you find any of this code usefull, feel free to use it. Just
'remember, however, to give credit where credit is due! ^_^
'
'Please refer to README.TXT for further information. Have fun! :)
'
'Copyright (C), 2000. All rights reserved worldwide. The game and name
'Rockwars 2000 is the exclusive property and copyright of Matthew River Knight
'of Dark Legends Software. The graphics for the explosion is the exclusive
'copyright property of JAWS-V soft, and the background graphics is the
'exclusive copyright property of TopFiero.
'-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

DECLARE SUB AsmPCOPY (FSeg%, FOff%, DSeg%, DOff%)
DECLARE SUB AsmPUT (DSeg%, DOff%, SSeg%, X%, Y%)
DECLARE SUB InitAsm ()
DECLARE SUB LoadImage (File$, DSeg%, DOff%)
DECLARE SUB LoadPal (File$)
DECLARE SUB SetPal ()

TYPE RGB
  R AS INTEGER
  G AS INTEGER
  B AS INTEGER
END TYPE

DIM SHARED Asm1$, Asm2$
DIM SHARED Pal(255) AS RGB

SCREEN 13

'Load all asm routines into memory.
InitAsm

'Load all sprites into memory.
DIM Castle%(559)
DEF SEG = VARSEG(Castle%(0))
BLOAD "CASTLE.TIL", 0

DIM Explode1%(114)
DEF SEG = VARSEG(Explode1%(0))
BLOAD "EXPLODE1.TIL", 0

DIM Explode2%(114)
DEF SEG = VARSEG(Explode2%(0))
BLOAD "EXPLODE2.TIL", 0

DIM Explode3%(114)
DEF SEG = VARSEG(Explode3%(0))
BLOAD "EXPLODE3.TIL", 0

DIM Explode4%(114)
DEF SEG = VARSEG(Explode4%(0))
BLOAD "EXPLODE4.TIL", 0

DIM Rock%(9)
DEF SEG = VARSEG(Rock%(0))
BLOAD "ROCK.TIL", 0

DIM Tank%(64)
DEF SEG = VARSEG(Tank%(0))
BLOAD "TANK.TIL", 0

'Allocate memory for two virtual-screen pages.
DIM VScreen1%(32000)
DIM VScreen2%(32000)

Menu:  'The code for the menu... What did you expect? ;)
LoadPal "MENU.PAL"
SetPal
LoadImage "MENU.BSV", &HA000, 0
DO
Key$ = INKEY$
  IF Key$ = "n" OR Key$ = "N" THEN EXIT DO
  IF Key$ = "v" OR Key$ = "V" THEN
    CLS
    SCREEN 0
    WIDTH 80, 25
    SHELL "CD\"
    SHELL "CD WINDOWS\COMMAND"
    SHELL "START /M http://www.darklegends.com"
    END
  END IF
  IF Key$ = "e" OR Key$ = "E" THEN GOTO EndGame
LOOP

'Initialise the arena.
LoadPal "BGROUND.PAL"
SetPal
LoadImage "BGROUND.BSV", VARSEG(VScreen1%(0)), VARPTR(VScreen1%(0))
RANDOMIZE TIMER
CastleX% = RND * 55 + 220  'Calculate a random location for the enemy castle.
CastleExist% = 1           'Tell the proggy that the enemy castle exists.
RockExist% = 0             'Tell the proggy that no rock is in motion.
TankExist% = 0             'No tanks have been sent yet.
Try% = 0                   'The number of times you've thrown a rock.
AsmPUT VARSEG(VScreen1%(0)), VARPTR(VScreen1%(0)), VARSEG(Castle%(0)), CastleX%, 84

'Main program loop.
DO
  Key$ = INKEY$
  IF Key$ = CHR$(27) THEN CLS : GOTO Menu
  IF Key$ = CHR$(13) AND RockExist% = 0 AND TankExist% = 1 THEN GOSUB UserInput
  AsmPCOPY VARSEG(VScreen1%(0)), VARPTR(VScreen1%(0)), VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0))
  GOSUB MoveTank
  IF RockExist% = 1 THEN GOSUB MoveRock
  Now = TIMER: WHILE Now = TIMER: WEND
  AsmPCOPY VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), &HA000, 0
LOOP

EndGame:  'End the game.
SCREEN 0
WIDTH 80, 25
DEF SEG = &HB800
BLOAD "END.BSV", 0
END

KillCastle:  'Destroy the enemy castle.
FOR Explode% = 1 TO 4
  AsmPCOPY VARSEG(VScreen1%(0)), VARPTR(VScreen1%(0)), VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0))
  IF Explode% = 1 THEN AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Explode1%(0)), CINT(RockX) - 9, CINT(RockY) - 9
  IF Explode% = 2 THEN AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Explode2%(0)), CINT(RockX) - 9, CINT(RockY) - 9
  IF Explode% = 3 THEN AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Explode3%(0)), CINT(RockX) - 9, CINT(RockY) - 9
  IF Explode% = 4 THEN AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Explode4%(0)), CINT(RockX) - 9, CINT(RockY) - 9
  AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Tank%(0)), TankX%, 106
  AsmPCOPY VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), &HA000, 0
  Now = TIMER: WHILE (TIMER - .1) < Now: WEND
NEXT
LoadImage "BGROUND.BSV", VARSEG(VScreen1%(0)), VARPTR(VScreen1%(0))
AsmPCOPY VARSEG(VScreen1%(0)), VARPTR(VScreen1%(0)), VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0))
AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Tank%(0)), TankX%, 106
AsmPCOPY VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), &HA000, 0
CastleExist% = 0
RockExist% = 0
RETURN

KillTank:  'Destroy the current tank.
FOR Explode% = 1 TO 5
  AsmPCOPY VARSEG(VScreen1%(0)), VARPTR(VScreen1%(0)), VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0))
  IF Explode% = 1 THEN AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Explode1%(0)), TankX%, 103
  IF Explode% = 2 THEN AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Explode2%(0)), TankX%, 103
  IF Explode% = 3 THEN AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Explode3%(0)), TankX%, 103
  IF Explode% = 4 THEN AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Explode4%(0)), TankX%, 103
  AsmPCOPY VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), &HA000, 0
  Now = TIMER: WHILE (TIMER - .1) < Now: WEND
NEXT
IF CastleExist% = 0 THEN GOTO YouWin ELSE TankExist% = 0: RockExist% = 0
RETURN

MoveRock:  'Calculate the next position of the rock, and PUT it there.
RockX = RockX + RockXSpeed
RockY = RockY + RockYSpeed
RockYSpeed = RockYSpeed + Gravity / 100
RockXSpeed = RockXSpeed + Wind / 100
IF RockX >= 3 AND RockX <= 313 AND RockY >= 3 AND RockY <= 111 THEN
  AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Rock%(0)), CINT(RockX), CINT(RockY)
END IF
IF RockX <= 3 OR RockX >= 313 OR RockY >= 111 THEN RockExist% = 0
IF RockX >= TankX% AND RockX <= TankX% + 13 AND RockY >= 106 THEN GOSUB KillTank
IF CastleExist% = 1 AND RockX >= CastleX% AND RockX <= CastleX% + 35 AND RockY >= 92 THEN GOSUB KillCastle
RETURN

MoveTank:  'Calculate the next position of the tank, and PUT it there.
IF TankExist% = 1 THEN
  TankX% = TankX% - 1
ELSE
  TankX% = CastleX% + 10
  TankExist% = 1
END IF
AsmPUT VARSEG(VScreen2%(0)), VARPTR(VScreen2%(0)), VARSEG(Tank%(0)), TankX%, 106
IF TankX% = 60 THEN GOTO YouLose
RETURN

UserInput:  'Prompt the user to input certain values necessary for the game.
            'Also set or calculate other needed values.
'Calculate a random wind value and display the results.
LOCATE 19, 1
PRINT "Wind:"
RANDOMIZE TIMER
Wind = RND * 6 + 1
RANDOMIZE TIMER
Direction% = RND
LOCATE 19, 6
IF Direction% = 0 THEN PRINT Wind; "<-": Wind = Wind * -1 ELSE PRINT Wind; "->"

'Prompt the user to input values for the angle and speed of the shot.
DO
  LOCATE 21, 1
  INPUT "Angle (45-90): ", Angle
LOOP UNTIL Angle >= 45 AND Angle <= 90
Angle = Angle * -1
DO
  LOCATE 22, 1
  INPUT "Speed (0-100): ", Speed
LOOP UNTIL Speed >= 0 AND Speed <= 100

Gravity = 9.8    'Gravitational acceleration constant.
RockExist% = 1   'Tell the proggy that a rock is in motion.
RockX = 25       'Starting X coordinate of the rock.
RockY = 110      'Starting Y coordinate of the rock.
Try% = Try% + 1  'Add one to the number of times you've thrown a rock.

'Set the X and Y speeds for the rock.
RockXSpeed = Speed / 10 * COS(Angle * .017453)
RockYSpeed = Speed / 10 * SIN(Angle * .017453)
RETURN

YouLose:  'Bummer... If this code runs, then I guess you lost!
FOR CrappoEffect% = 1 TO 10
  LINE (TankX% + 1, 106)-(41, 92), 68
  Now = TIMER: WHILE Now = TIMER: WEND
  LINE (TankX% + 1, 106)-(41, 92), 16
  Now = TIMER: WHILE Now = TIMER: WEND
NEXT
LOCATE 19, 1
PRINT "You lose! Better luck next time! :)"
PRINT "Press any key to continue..."
SLEEP
CLS
GOTO Menu

YouWin:  'Woohoo! The following code runs if you win! :)
LOCATE 19, 1
PRINT "You have defeated the enemy in"; Try%; "shots!"
PRINT "Press any key to continue..."
SLEEP
CLS
GOTO Menu

SUB AsmPCOPY (FSeg%, FOff%, DSeg%, DOff%)

DEF SEG = VARSEG(Asm1$)
CALL ABSOLUTE(BYVAL FSeg%, BYVAL FOff%, BYVAL DSeg%, BYVAL DOff%, SADD(Asm1$))
DEF SEG

END SUB

SUB AsmPUT (DSeg%, DOff%, SSeg%, X%, Y%)

DEF SEG = VARSEG(Asm2$)
CALL ABSOLUTE(BYVAL DSeg%, BYVAL DOff%, BYVAL SSeg%, BYVAL X%, BYVAL Y%, SADD(Asm2$))
DEF SEG

END SUB

SUB InitAsm

'Machine/Asm code for RW2000 PCOPY.
Asm1$ = ""
Asm1$ = Asm1$ + CHR$(&H1E)                            'PUSH DS
Asm1$ = Asm1$ + CHR$(&H55)                            'PUSH BP
Asm1$ = Asm1$ + CHR$(&H89) + CHR$(&HE5)               'MOV BP,SP
Asm1$ = Asm1$ + CHR$(&H8B) + CHR$(&H46) + CHR$(&HE)   'MOV AX,[BP+0E]
Asm1$ = Asm1$ + CHR$(&H8E) + CHR$(&HD8)               'MOV DS,AX
Asm1$ = Asm1$ + CHR$(&H8B) + CHR$(&H76) + CHR$(&HC)   'MOV SI,[BP+0C]
Asm1$ = Asm1$ + CHR$(&H8B) + CHR$(&H46) + CHR$(&HA)   'MOV AX,[BP+0A]
Asm1$ = Asm1$ + CHR$(&H8E) + CHR$(&HC0)               'MOV ES,AX
Asm1$ = Asm1$ + CHR$(&H8B) + CHR$(&H7E) + CHR$(&H8)   'MOV DI,[BP+08]
Asm1$ = Asm1$ + CHR$(&HB9) + CHR$(&H80) + CHR$(&H3E)  'MOV CX,3E80
Asm1$ = Asm1$ + CHR$(&HF3)                            'REPZ
Asm1$ = Asm1$ + CHR$(&H66) + CHR$(&HA5)               'MOVSD
Asm1$ = Asm1$ + CHR$(&H5D)                            'POP BP
Asm1$ = Asm1$ + CHR$(&H1F)                            'POP DS
Asm1$ = Asm1$ + CHR$(&HCA) + CHR$(&H8) + CHR$(&H0)    'RETF 0008

'Machine/Asm code for RW2000 PUT.
Asm2$ = ""
Asm2$ = Asm2$ + CHR$(&H1E)                            'PUSH DS
Asm2$ = Asm2$ + CHR$(&H55)                            'PUSH BP
Asm2$ = Asm2$ + CHR$(&H89) + CHR$(&HE5)               'MOV BP,SP
Asm2$ = Asm2$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)   'MOV BX,[BP+0C]
Asm2$ = Asm2$ + CHR$(&H8E) + CHR$(&HDB)               'MOV DS,BX
Asm2$ = Asm2$ + CHR$(&H31) + CHR$(&HF6)               'XOR SI,SI
Asm2$ = Asm2$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)  'MOV BX,[BP+10]
Asm2$ = Asm2$ + CHR$(&H8E) + CHR$(&HC3)               'MOV ES,BX
Asm2$ = Asm2$ + CHR$(&H8B) + CHR$(&H56) + CHR$(&HA)   'MOV DX,[BP+0A]
Asm2$ = Asm2$ + CHR$(&H8B) + CHR$(&H46) + CHR$(&H8)   'MOV AX,[BP+08]
Asm2$ = Asm2$ + CHR$(&H89) + CHR$(&HC3)               'MOV BX,AX
Asm2$ = Asm2$ + CHR$(&HB1) + CHR$(&H8)                'MOV CL,08
Asm2$ = Asm2$ + CHR$(&HD3) + CHR$(&HE0)               'SHL AX,CL
Asm2$ = Asm2$ + CHR$(&HB1) + CHR$(&H6)                'MOV CL,06
Asm2$ = Asm2$ + CHR$(&HD3) + CHR$(&HE3)               'SHL BX,CL
Asm2$ = Asm2$ + CHR$(&H1) + CHR$(&HD8)                'ADD AX,BX
Asm2$ = Asm2$ + CHR$(&H1) + CHR$(&HD0)                'ADD AX,DX
Asm2$ = Asm2$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)   'MOV BX,[BP+0E]
Asm2$ = Asm2$ + CHR$(&H1) + CHR$(&HD8)                'ADD AX,BX
Asm2$ = Asm2$ + CHR$(&H89) + CHR$(&HC7)               'MOV DI,AX
Asm2$ = Asm2$ + CHR$(&HAD)                            'LODSW
Asm2$ = Asm2$ + CHR$(&HB1) + CHR$(&H3)                'MOV CL,03
Asm2$ = Asm2$ + CHR$(&HD3) + CHR$(&HE8)               'SHR AX,CL
Asm2$ = Asm2$ + CHR$(&H89) + CHR$(&HC3)               'MOV BX,AX
Asm2$ = Asm2$ + CHR$(&HAD)                            'LODSW
Asm2$ = Asm2$ + CHR$(&H88) + CHR$(&HC4)               'MOV AH,AL
Asm2$ = Asm2$ + CHR$(&HBA) + CHR$(&H40) + CHR$(&H1)   'MOV DX,0140
Asm2$ = Asm2$ + CHR$(&H29) + CHR$(&HDA)               'SUB DX,BX
Asm2$ = Asm2$ + CHR$(&H80) + CHR$(&HFC) + CHR$(&H0)   'Yloop: CMP AH,00
Asm2$ = Asm2$ + CHR$(&H74) + CHR$(&H12)               'JZ Endprog
Asm2$ = Asm2$ + CHR$(&H89) + CHR$(&HD9)               'MOV CX,BX
Asm2$ = Asm2$ + CHR$(&HAC)                            'Xloop: LODSB
Asm2$ = Asm2$ + CHR$(&H3C) + CHR$(&H0)                'CMP AL,00
Asm2$ = Asm2$ + CHR$(&H74) + CHR$(&H2)                'JZ Skippixel
Asm2$ = Asm2$ + CHR$(&HAA)                            'STOSB
Asm2$ = Asm2$ + CHR$(&H4F)                            'DEC DI
Asm2$ = Asm2$ + CHR$(&H47)                            'Skippixel: INC DI
Asm2$ = Asm2$ + CHR$(&HE2) + CHR$(&HF6)               'LOOP Xloop
Asm2$ = Asm2$ + CHR$(&H1) + CHR$(&HD7)                'ADD DI,DX
Asm2$ = Asm2$ + CHR$(&HFE) + CHR$(&HCC)               'DEC AH
Asm2$ = Asm2$ + CHR$(&HEB) + CHR$(&HE9)               'JMP Yloop
Asm2$ = Asm2$ + CHR$(&H5D)                            'Endprog: POP BP
Asm2$ = Asm2$ + CHR$(&H1F)                            'POP DS
Asm2$ = Asm2$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)    'RETF 000A

END SUB

SUB LoadImage (File$, DSeg%, DOff%)

DEF SEG = DSeg%
BLOAD File$, DOff%

END SUB

SUB LoadPal (File$)

DEF SEG = VARSEG(Pal(0))
BLOAD File$, 0

END SUB

SUB SetPal

OUT &H3C8, 0

FOR I = 0 TO 255
  OUT &H3C9, Pal(I).R
  OUT &H3C9, Pal(I).G
  OUT &H3C9, Pal(I).B
NEXT

END SUB

