{ SCHUIFV.PAS : Schuifvierkanten - DOS versie, Nederlands

  Titel   : SCHUIFV
  Taal    : Borland Pascal v7.0 with Objects, plus Turbo Vision v2.0
  Versie  : 1.3
  Datum   : 09 feb 2000
  Auteur  : J R Ferguson
  Download: http://hello.to/ferguson
  E-mail  : j.r.ferguson@iname.com
  Gebruik : MS-DOS real mode applicatie

  Dit programma,  alsmede  de  broncode  ervan,  mag  zonder  vergoeding
  gebruikt  en  gekopieerd  worden,  maar alleen zonder winstoogmerk. De
  auteur is niet aansprakelijk voor enige schade of verlies aan gegevens
  die door het gebruik ervan kan zijn veroorzaakt.

  Opmerking: Dit programma maakt gebruik van unit MSGBOXN, een Nederlandse
  versie van unit MSGBOX van Turbo Vision. Indien U hier niet over beschikt
  kunt U in de Uses clause MsgBoxN vervangen door MsgBox. U krijgt dan
  Engelstalige titels en button teksten in de dialogen die opgeroepen worden
  met de MessageBox functie.
}


{--- Compiler options ---}

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }


PROGRAM SCHUIFV;

uses App, Dialogs, Drivers, Menus, MsgBoxN, Objects, Views, Dos;

const
{ Natuurgegevens }
  C_SecPerDag   = 24 * 60 * 60;

{ Vaste instellingen }
  C_ProgIdent   = 'SCHUIFV v1.3';
  C_ProgTitle   = 'Schuifvierkanten';
  C_Copyright   = '(C) 1996-2000, J.R. Ferguson';
  C_Email       = 'j.r.ferguson@iname.com';
  C_URL         = 'http://hello.to/ferguson';
  C_MinAantal   = 3;       { minimum aantal velden }
  C_MaxAantal   = 5;       { maximum aantal velden }
  C_StapStrMax  = 3;       { stringlengte aantal stappen }
  C_TijdStrMax  = 8;       { stringlengte speeltijd }

{ Default waarden }
  C_DflAantal   = 4;       { aantal velden (C_MinAantal..C_MaxAantal) }
  C_DflMoetUit  = true;    { spel moet uitkomen }
  C_DflStappen  = true;    { aantal stappen bijhouden }
  C_DflToonTijd = true;    { speeltijd bijhouden }

{ Overige konstanten }
  cm_SpelBegin  = 101;
  cm_SpelOpnieuw= 102;
  cm_SpelPauze  = 103;
  cm_SpelInstel = 104;
  cm_HelpUitleg = 111;
  cm_HelpInfo   = 112;
  cm_VeldBase   = 200;

  hc0           = hcNoContext;
  kb0           = kbNoKey;


type
  P_Klok        = ^T_Klok;            { klok om speeltijd bij te houden }
  P_GetalReeks  = ^T_GetalReeks;      { initieel te plaatsen GetalReeks }
  P_MenuBar     = ^T_MenuBar;
  P_StatusLine  = ^T_StatusLine;
  P_InfoDialog  = ^T_InfoDialog;
  P_InstelBuf   = ^T_InstelBuf;
  P_InstelDlg   = ^T_InstelDlg;
  P_FramedText  = ^T_FramedText;
  P_Frame       = ^T_Frame;
  P_Veld        = ^T_Veld;
  P_Bord        = ^T_Bord;
  P_SpelWindow  = ^T_SpelWindow;
  P_Applicatie  = ^T_Applicatie;

  T_StapStr     = String[C_StapStrMax];
  T_TijdStr     = String[C_TijdStrMax];
  T_ScoreStr    = String[C_StapStrMax + 2 + C_TijdStrMax];

  T_Klok        = object(TObject)
    KlokLoopt   : boolean; { tijd wordt bijgehouden en is ingegaan }
    Seconden    : LongInt; { cumulatieve speeltijd in seconden }
    KlokTijd    : LongInt; { laatst gelezen kloktijd in seconden sinds middernacht }
    constructor Init;
    function    Loopt: boolean;
    procedure   Start;
    procedure   Stop;
    procedure   Pauzeer;
    procedure   HerStart;
    procedure   GeefTijdStr(var V_TijdStr: T_TijdStr);
    procedure   LeesTijd;
    function    WerkBij: boolean;
  end;

  T_GetalReeks  = object(TObject)
    reeks       : array[1..C_MaxAantal*C_MaxAantal] of integer;
    constructor Init(V_Aantal: integer; V_Random: boolean);
    function    GeefGetal(V_Index: integer): integer;
  end;

  T_MenuBar     = Object(TMenuBar)
    procedure   Draw; virtual;
  end;

  T_StatusLine  = Object(TStatusLine)
    ScoreStr    : T_ScoreStr;
    Constructor Init(var V_Rect: TRect; V_Defs: PStatusDef);
    procedure   SetScore(V_ScoreStr: T_ScoreStr);
    procedure   Draw; virtual;
  end;

  T_InfoDialog  = Object(TDialog)
    Constructor Init(V_Width,V_Height: integer; V_Title,V_Message: String);
  end;

  T_InstelBuf   = record
    IO_Aantal      : Word;
    IO_Opties      : Word;
  end;

  T_FramedText  = Object(TStaticText)
    Constructor Init(var V_Rect: TRect; V_Title: TTitleStr);
  end;

  T_Frame       = Object(T_FramedText)
    Constructor Init(V_Rect: TRect);
  end;

  T_InstelDlg   = Object(TDialog)
    Constructor Init(var V_Rect: TRect);
  end;

  T_Veld        = Object(TButton)
    Rij, Kolom  : integer;
    Nummer      : integer;
    Constructor Init(var V_Rect: TRect; V_Rij,V_Kolom: integer;
                     V_Nummer: integer);
    function    PlaatsNummer(V_Nummer: integer): boolean;
    procedure   WisNummer;
    procedure   Show; virtual;
    function    GetPalette: PPalette; virtual;
  end;

  T_Bord        = Object(TGroup)
    Aantal      : integer;          { aantal velden horizontaal/vertikaal }
    Veld        : array[1..C_MaxAantal,1..C_MaxAantal] of P_Veld;
    Beginstand  : array[1..C_MaxAantal,1..C_MaxAantal] of integer;
    Constructor Init(var V_Rect: TRect; V_Aantal: integer; V_Random: boolean);
    Destructor  Done; virtual;
    procedure   BewaarStand;
    procedure   HerstelStand;
    function    OpVolgorde: boolean;
    function    LeegVeld: P_Veld;
  end;

  T_SpelWindow  = Object(TDialog)
    Aantal      : integer;
    MoetUit     : boolean;          { spel moet uitkomen }
    ToonStappen : boolean;          { aantal stappen laten zien }
    ToonTijd    : boolean;          { speeltijd laten zien }
    Stappen     : integer;          { aantal stappen tot nu toe }
    Bord        : P_Bord;           { speelbord }
    Klok        : P_Klok;           { klok omn speeltijd bij te houden }
    Shuffling   : boolean;          { bezig met Shuffle: geen Paint uitvoeren }
    Pauze       : boolean;          { spel onderbroken door speler }
    Constructor Init(var V_Rect: TRect);
    Destructor  Done; virtual;
    procedure   BouwOp;
    procedure   BreekAf;
    procedure   NieuwSpel;
    procedure   ZelfdeSpel;
    procedure   Shuffle;
    procedure   RegistreerStap;
    procedure   SchrijfScore;
    procedure   EindBericht;
    function    SchuifNaar(dr,dk: integer): boolean;
    procedure   Draw; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoSpelInstel;
    procedure   DoSpelPauze;
    procedure   DoButtonClick(V_Rij,V_Kolom: integer);
    procedure   DoLinks;
    procedure   DoRechts;
    procedure   DoOmhoog;
    procedure   DoOmlaag;
  end;

  T_Applicatie  = Object(TApplication)
    SpelWindow  : P_SpelWindow;
    Constructor Init;
    Destructor  Done; virtual;
    procedure   InitMenuBar; virtual;
    procedure   InitStatusLine; virtual;
    procedure   Idle; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoHelpUitleg;
    procedure   DoHelpInfo;
  end;


{ --- Algemeen --- }

function IMin(i,j: integer): integer;
begin if i<j then IMin:= i else IMin:= j; end;

function CenterX(var V_Rect: TRect; V_Width : integer): integer;
begin with V_Rect do CenterX:= (B.X - A.X - V_Width ) div 2; end;

function CenterY(var V_Rect: TRect; V_Height: integer): integer;
begin with V_Rect do CenterY:= (B.Y - A.Y - V_Height) div 2; end;

function Commando(V_Rij, V_Kolom: integer): Word;
begin Commando:= cm_VeldBase + (V_Rij-1)*C_MaxAantal + (V_Kolom-1); end;

function RijVan  (V_Commando: Word): integer;
begin
  if V_Commando < cm_VeldBase then RijVan:= 0
  else RijVan  := 1 + (V_Commando - cm_VeldBase) div C_MaxAantal;
end;

function KolomVan(V_Commando: Word): integer;
begin
  if V_Commando < cm_VeldBase then KolomVan:= 0
  else KolomVan:= 1 + (V_Commando - cm_VeldBase) mod C_MaxAantal;
end;


{ --- T_Klok --- }

constructor T_Klok.Init;
begin
  inherited Init;
  Stop;
end;

function    T_Klok.Loopt: boolean;
begin Loopt:= KlokLoopt end;

procedure   T_Klok.Start;
begin Seconden:= 0; LeesTijd; KlokLoopt:= true; end;

procedure   T_Klok.Stop;
begin Seconden:= 0; KlokTijd:= 0; KlokLoopt:= false; end;

procedure   T_Klok.Pauzeer;
begin KlokLoopt:= false; end;

procedure   T_Klok.HerStart;
begin LeesTijd; KlokLoopt:= true; end;

procedure   T_Klok.GeefTijdStr(var V_TijdStr: T_TijdStr);
var tmp: LongInt; u,m,s: word; s0: String[2];
begin
  WerkBij;
  s := Seconden mod 60; tmp:= Seconden div 60;
  m := tmp      mod 60;
  u := tmp      div 60;
  if u > 0 then begin Str(u:2,s0); V_TijdStr:= s0+':'; end
                else  V_TijdStr:= '';
  Str(m:2,s0); if s0[1]=' ' then s0[1]:= '0'; V_TijdStr:= V_TijdStr+s0+':';
  Str(s:2,s0); if s0[1]=' ' then s0[1]:= '0'; V_TijdStr:= V_TijdStr+s0;
end;

procedure   T_Klok.LeesTijd;
var u,m,s,c: Word;
begin GetTime(u,m,s,c); KlokTijd:= (LongInt(u)*60 + LongInt(m))*60 + LongInt(s); end;

function    T_Klok.WerkBij: boolean;
var VorigeTijd: LongInt;
begin
  if Loopt then begin
    VorigeTijd:= KlokTijd; LeesTijd;
    if KlokTijd < VorigeTijd then Inc(Seconden, KlokTijd - VorigeTijd + C_SecPerDag)
                             else Inc(Seconden, KlokTijd - VorigeTijd);
    WerkBij:= KlokTijd <> VorigeTijd;
  end
  else WerkBij:= false;
end;


{ --- T_GetalReeks --- }

constructor T_GetalReeks.Init(V_Aantal: integer; V_Random: boolean);
var i,j,k,max: integer; ok: boolean;
begin
  inherited Init;
  i:= 0; max:= V_Aantal*V_Aantal;
  if V_Random then begin
    repeat
      for i:= 1 to max do reeks[i]:= 0;
      for j:= 0 to max-1 do begin
        for k:= 1 + Random(max-1) downto 0 do begin
          Inc(i); if i>max then i:= 1;
          while reeks[i] <> 0 do begin Inc(i); if i>max then i:= 1; end;
        end;
        reeks[i]:= j;
      end;
      ok:= true; i:= 0; while ok and (i<max) do begin Inc(i); ok:= reeks[i]=i; end;
    until not ok;
  end
  else begin
    for i:= 1 to max-1 do reeks[i]:= i;
    reeks[max]:= 0;
  end;
end;

function    T_GetalReeks.GeefGetal(V_Index: integer): integer;
begin GeefGetal:= reeks[V_Index]; end;


{ --- T_MenuBar --- }

procedure   T_MenuBar.Draw;
var R: TRect;
begin
  Inherited Draw;
  GetExtent(R);
  WriteStr(CenterX(R,Length(C_ProgTitle)),R.A.Y,C_ProgTitle,1);
end;


{ --- T_StatusLine --- }

Constructor T_StatusLine.Init(var V_Rect: TRect; V_Defs: PStatusDef);
begin
  Inherited Init(V_Rect,V_Defs);
  ScoreStr:= '';
end;

procedure   T_StatusLine.SetScore(V_ScoreStr: T_ScoreStr);
begin ScoreStr:= V_ScoreStr; Draw; end;

procedure   T_StatusLine.Draw;
var R: TRect;
begin
  Inherited Draw;
  GetExtent(R);
  WriteStr(R.B.X-Length(ScoreStr)-1,R.A.Y,ScoreStr,1);
end;


{ ---T_InfoDialog --- }

Constructor T_InfoDialog.Init(V_Width,V_Height: integer;
                              V_Title,V_Message: String);
var R: TRect; X,Y,AX,AY: integer;
begin
  DeskTop^.GetExtent(R);
  X:= (R.B.X - R.A.X) div 2; AX:= V_Width  div 2;
  Y:= (R.B.Y - R.A.Y) div 2; AY:= V_Height div 2;
  R.Assign(X-AX,Y-AY,X+AX,Y+AY);
  Inherited Init(R,V_Title);
  GetExtent(R); X:= R.B.X div 2; Y:= R.B.Y - 3;
  R.Grow(-2,-2);
  Insert(New(PStaticText,Init(R,V_Message)));
  R.Assign(X-5,Y,X+5,Y+2);
  Insert(New(PButton,Init(R,'O~K~',cmOK,bfDefault)));
end;


{ --- T_FramedText --- }

Constructor T_FramedText.Init(var V_Rect: TRect; V_Title: TTitleStr);
begin Inherited Init(V_Rect,V_Title); Options:= Options or ofFramed; end;


{ --- T_Frame --- }

Constructor T_Frame.Init(V_Rect: TRect);
begin Inherited Init(V_Rect,''); end;


{ --- T_InstelDlg --- }


Constructor T_InstelDlg.Init(var V_Rect: TRect);
var R: TRect; p: PView; i: integer;
begin {T_InstelDlg.Init}
  Inherited Init(V_Rect,'Instelling');

  R.Assign(03,02,29,06); Insert(New(P_FramedText,Init(R,'Aantal vakken')));
  R.Assign(03,03,29,06); Insert(New(PRadioButtons,Init(R,
    NewSItem('~3~x3',
    NewSItem('~4~x4',
    NewSItem('~5~x5',nil))))));
  R.Assign(03,08,29,12); Insert(New(P_FramedText,Init(R,'Opties')));
  R.Assign(03,09,29,12); Insert(New(PCheckBoxes,Init(R,
    NewSItem('Spel moet ~u~itkomen',
    NewSItem('Aantal ~s~tappen tonen',
    NewSItem('Speel~t~ijd tonen',nil))))));
  R.Assign(34,04,46,06); Insert(New(PButton,Init(R,'O~K~'       ,cmOK    ,bfDefault)));
  R.Assign(34,09,46,11); Insert(New(PButton,Init(R,'~A~nnuleren',cmCancel,bfNormal)));
  SelectNext(false);
end;


{ --- T_Veld --- }

Constructor T_Veld.Init(var V_Rect: TRect; V_Rij,V_Kolom: integer;
                        V_Nummer: integer);
var R: TRect;
begin
  Inherited Init(V_Rect,'  ', Commando(V_Rij,V_Kolom), 0);
  Rij:= V_Rij; Kolom:= V_Kolom; WisNummer; PlaatsNummer(V_Nummer);
end;

function    T_Veld.PlaatsNummer(V_Nummer: integer): boolean;
begin
  if Nummer > 0 then PlaatsNummer:= false
  else begin
    Nummer:= V_Nummer; Str(V_Nummer:2, Title^); Show;
    PlaatsNummer:= true;
  end;
end;

procedure  T_Veld.WisNummer;
begin Nummer:= 0; Title^:= '  '; Hide; end;

procedure  T_Veld.Show;
begin if Nummer > 0 then Inherited Show; end;

function   T_Veld.GetPalette: PPalette;
const C_Palette: string[8] = #10#10#10#10#14#14#14#15;
begin GetPalette:= @C_Palette; end;


{ --- T_Bord --- }

Constructor T_Bord.Init(var V_Rect: TRect; V_Aantal: integer; V_Random: boolean);
var
  p: PView;
  rij,kolom,i: integer;
  X,Y,Ax,Ay,X0,Y0,Ax0,Ay0: integer;
  R,R0: TRect;
  GetalReeks: P_GetalReeks;
begin
  R.Copy(V_Rect);
  X := R.A.X + (R.B.X - R.A.X) div 2;
  Y := R.A.Y + (R.B.Y - R.A.Y) div 2;
  Ax0:= (R.B.X - R.A.X) div (2*V_Aantal); Ax:= Ax0 * V_Aantal; X0:= X - Ax;
  Ay0:= (R.B.Y - R.A.Y) div (2*V_Aantal); Ay:= Ay0 * V_Aantal; Y0:= Y - Ay;

  R.Assign(X0,Y0,X0+2*Ax0*V_Aantal,Y0+2*Ay0*V_Aantal);
  Inc(R.B.X); Inc(R.B.Y);
  Inherited Init(R);
  GetExtent(R); Insert(New(P_Frame,Init(R)));
  Aantal:= V_Aantal;

  New(GetalReeks,Init(Aantal,V_Random)); i:= 0;
  R0.Assign(1,1,2*Ax0+1,2*Ay0+1);
  for rij:= 1 to Aantal do begin
    R.Copy(R0);
    for kolom:= 1 to Aantal do begin
      inc(i);
      New(Veld[rij,kolom], Init(R,rij,kolom,GetalReeks^.GeefGetal(i)));
      Insert(Veld[rij,kolom]);
      R.Move(2*Ax0,0);
    end;
    R0.Move(0,2*Ay0);
  end;
  Dispose(GetalReeks,Done);
end;

Destructor  T_Bord.Done;
var r,k: integer;
begin
  for r:= 1 to Aantal do for k:= 1 to Aantal do begin
    Delete(Veld[r,k]); Dispose(Veld[r,k],Done);
  end;
  Inherited Done;
end;

procedure   T_Bord.BewaarStand;
var r,k: integer;
begin
  for r:= 1 to Aantal do for k:= 1 to Aantal do
    BeginStand[r,k]:= Veld[r,k]^.Nummer;
end;

procedure   T_Bord.HerstelStand;
var r,k: integer;
begin for r:= 1 to Aantal do for k:= 1 to Aantal do with Veld[r,k]^ do begin
  WisNummer; PlaatsNummer(BeginStand[r,k]);
end; end;

function    T_Bord.OpVolgorde: boolean;
var i,r,k: integer; ok: boolean;
begin
  ok:= true; r:= Aantal; k:= Aantal; i:= Aantal*Aantal;
  while ok and (i>1) do begin
    Dec(i); if k>1 then  Dec(k) else begin Dec(r); k:= Aantal; end;
    ok:= Veld[r,k]^.Nummer = i;
  end;
  OpVolgorde:= ok;
end;

function    T_Bord.LeegVeld: P_Veld;
var r,k: integer; ok: boolean;
begin
  ok:= false; r:= 0;
  while (r < Aantal) and not ok do begin
    Inc(r); k:= 0;
    while (k < Aantal) and not ok do begin
      Inc(k); ok:= Veld[r,k]^.Nummer=0;
    end;
  end;
  if ok then LeegVeld:= Veld[r,k] else LeegVeld:= nil;
end;



{ --- T_SpelWindow --- }

Constructor T_SpelWindow.Init(var V_Rect: TRect);
begin
  Inherited Init(V_Rect,'');
  Palette     := dpBlueDialog;
  Flags       := Flags and not (wfMove or wfClose);
  Aantal      := C_DflAantal;
  MoetUit     := C_DflMoetUit;
  ToonStappen := C_DflStappen;
  ToonTijd    := C_DflToonTijd;
  Shuffling   := false;
  Pauze       := false;
  New(Klok, Init);
  BouwOp;
end;

destructor  T_SpelWindow.Done;
begin
  BreekAf;
  Dispose(Klok, Done);
  inherited Done;
end;

procedure   T_SpelWindow.BouwOp;
var R: TRect;
begin
  Stappen:= 0; Klok^.Stop; Pauze:= false;
  GetExtent(R); R.Grow(-14,-1);
  New(Bord,Init(R,Aantal,not MoetUit)); if MoetUit then Shuffle;
  Insert(Bord);
  Bord^.BewaarStand;
end;

procedure   T_SpelWindow.BreekAf;
begin
  Delete(Bord);
  Dispose(Bord,Done);
end;

procedure   T_SpelWindow.NieuwSpel;
begin
  Breekaf; Bouwop;
  Draw;
end;

procedure   T_SpelWindow.ZelfdeSpel;
begin
  Bord^.HerstelStand;
  Stappen:= 0; Klok^.Stop; Pauze:= false;
  Draw;
end;

procedure   T_SpelWindow.Shuffle;
var i: integer;
begin
  Shuffling:= true;
  repeat
    i:= 0;
    while i < 100 *Aantal do case random(4) of
      0: if SchuifNaar( 0,-1) then Inc(i);
      1: if SchuifNaar( 0,+1) then Inc(i);
      2: if SchuifNaar(-1, 0) then Inc(i);
      3: if SchuifNaar(+1, 0) then Inc(i);
    end;
  until not Bord^.OpVolgorde;
  Shuffling:= false;
end;

procedure   T_SpelWindow.RegistreerStap;
begin if not Shuffling then begin
  if not Klok^.Loopt then Klok^.Start;
  Klok^.WerkBij; Inc(Stappen); SchrijfScore;
end end;

procedure   T_SpelWindow.SchrijfScore;
var StapStr  : T_StapStr;
    TijdStr  : T_TijdStr;
    ScoreStr : T_ScoreStr;
begin
  ScoreStr:= '';
  if ToonStappen or ToonTijd then begin
    if ToonTijd then begin Klok^.GeefTijdStr(TijdStr); ScoreStr:=TijdStr end;
    if ToonStappen then begin
      Str(Stappen:3,StapStr);
      if ToonTijd then ScoreStr:=ScoreStr+' '+StapStr else ScoreStr:=StapStr;
    end;
  end;
  P_StatusLine(StatusLine)^.SetScore(ScoreStr);
end;

procedure   T_SpelWindow.EindBericht;
var result: Word;
begin
  result:= MessageBox(
      #3'Goed zo !'#13#13#3'Andere beginstand ?',
      nil,mfYesButton or mfNoButton or mfInformation
     );
  if (result = cmNo) or (result = cmCancel)
    then ZelfdeSpel
    else NieuwSpel;
end;

function    T_SpelWindow.SchuifNaar(dr,dk: integer): boolean;
var p: P_Veld;
begin with Bord^ do begin
  p:= LeegVeld;
  if p = nil then SchuifNaar:= false
  else with p^ do begin
    if (Rij  -dr < 1) or (Rij  -dr > Aantal) or
       (Kolom-dk < 1) or (Kolom-dk > Aantal)
    then SchuifNaar:= false
    else begin
      if Veld[Rij,Kolom]^.PlaatsNummer(Veld[Rij-dr,Kolom-dk]^.Nummer)
      then begin
        Veld[Rij-dr,Kolom-dk]^.WisNummer; RegistreerStap;
        SchuifNaar:= true;
      end
      else SchuifNaar:= false;
    end;
  end;
end end;

procedure   T_SpelWindow.Draw;
begin
  Inherited Draw;
  SchrijfScore;
end;

procedure   T_SpelWindow.HandleEvent(var V_Event: TEvent);
  var Rij, Kolom: integer;
  procedure Clear; begin ClearEvent(V_Event); end;
begin {HandleEvent}
  Inherited HandleEvent(V_Event);
  with V_Event do case What of
    evCommand: case Command of
      cm_SpelInstel  : begin DoSpelInstel;  Clear; end;
      cm_SpelBegin   : begin NieuwSpel;     Clear; end;
      cm_SpelOpnieuw : begin ZelfdeSpel;    Clear; end;
      cm_SpelPauze   : begin DoSpelPauze;   Clear; end;
      else begin
         Rij  := RijVan  (Command);
         Kolom:= KolomVan(Command);
         if (Rij   >= 1) and (Rij   <= Aantal) and
            (Kolom >= 1) and (Kolom <= Aantal)
         then begin DoButtonClick(Rij,Kolom); Clear; end;
      end;
    end;
    evKeyDown: case KeyCode of
      kbLeft         : begin DoLinks;       Clear; end;
      kbRight        : begin DoRechts;      Clear; end;
      kbUp           : begin DoOmhoog;      Clear; end;
      kbDown         : begin DoOmlaag;      Clear; end;
    end;
  end;
end;

procedure   T_SpelWindow.DoSpelInstel;
var R: TRect; InstelBuf: T_InstelBuf; n: integer; uit,stap,tijd: boolean;
begin with InstelBuf do begin
  n:= Aantal; uit:= MoetUit; stap:= ToonStappen; tijd:= ToonTijd;
  IO_Aantal := Aantal - C_MinAantal;
  IO_Opties := Ord(MoetUit)
           or (Ord(ToonStappen) shl 1)
           or (Ord(ToonTijd)    shl 2);
  R.Assign(15,4,65,18);
  if Application^.ExecuteDialog(New(P_InstelDlg,Init(R)),@InstelBuf)
     <> cmCancel
  then begin
    n    := IO_Aantal + C_MinAantal;
    uit  :=(IO_Opties and $01) <> 0;
    stap :=(IO_Opties and $02) <> 0;
    tijd :=(IO_Opties and $04) <> 0;
    if (n <> Aantal) or (uit <> MoetUit) then begin
      Aantal:= n; MoetUit:= uit; NieuwSpel;
    end;
    if (Stap <> ToonStappen) or (tijd <> ToonTijd) then begin
      ToonStappen:= stap; ToonTijd:= tijd;
      Draw;
    end;
  end;
end end;

procedure   T_SpelWindow.DoSpelPauze;
begin
  Pauze:= true; Klok^.Pauzeer;
  Bord^.Hide;
  MessageBox(#13#3'PAUZE',nil,mfOKButton or mfInformation);
  Pauze:= false; if Stappen>0 then Klok^.Herstart;
  Bord^.Show;
end;

procedure   T_SpelWindow.DoButtonClick(V_Rij,V_Kolom: integer);
  function Schuif(dr,dk: integer): boolean;
  var r,k: integer;
  begin
    r:= V_Rij + dr; k:= V_Kolom + dk;
    if (r<1) or (r>Aantal) or (k<1) or (k>Aantal) then Schuif:= false
    else with Bord^ do begin
      if Veld[r,k]^.PlaatsNummer(Veld[V_Rij,V_Kolom]^.Nummer) then begin
        Veld[V_Rij,V_Kolom]^.WisNummer; RegistreerStap;
        Schuif:= true;
      end
      else Schuif:= false;
    end;
  end;
begin if Bord^.Veld[V_Rij,V_Kolom]^.Nummer > 0 then begin {DoButtonClick}
  if Schuif(0,-1) or Schuif(0,+1) or Schuif(-1,0) or Schuif(+1,0) then
    if Bord^.OpVolgorde then EindBericht;
end; end;

procedure   T_SpelWindow.DoLinks;
begin if SchuifNaar(0,-1) then if Bord^.OpVolgorde then EindBericht; end;

procedure   T_SpelWindow.DoRechts;
begin if SchuifNaar(0,+1) then if Bord^.OpVolgorde then EindBericht; end;

procedure   T_SpelWindow.DoOmhoog;
begin if SchuifNaar(-1,0) then if Bord^.OpVolgorde then EindBericht; end;

procedure   T_SpelWindow.DoOmlaag;
begin if SchuifNaar(+1,0) then if Bord^.OpVolgorde then EindBericht; end;


{ --- T_Applicatie --- }

Constructor T_Applicatie.init;
var R: TRect;
begin
  Inherited Init;
  DeskTop^.GetExtent(R); New(SpelWindow,Init(R)); InsertWindow(SpelWindow);
end;

Destructor  T_Applicatie.Done;
begin
  Dispose(SpelWindow,Done); SpelWindow:= nil;
  Inherited Done;
end;

procedure   T_Applicatie.InitMenuBar;
var R: TRect;
begin
  GetExtent(R); R.B.Y:= R.A.Y+1;
  MenuBar:= New(P_MenuBar,Init(R,NewMenu(
    NewSubMenu('~S~pel',hc0,NewMenu(
      NewItem('~N~ieuw spel'    ,''     ,kb0    ,cm_SpelBegin   ,hc0,
      NewItem('~B~eginstand'    ,''     ,kb0    ,cm_SpelOpnieuw ,hc0,
      NewItem('~P~auze'         ,'Alt+P',kbAltP ,cm_SpelPauze   ,hc0,
      NewLine(
      NewItem('~I~nstelling...' ,''     ,kb0    ,cm_SpelInstel  ,hc0,
      NewLine(
      NewItem('~A~fsluiten'     ,'Alt+X',kbAltX ,cmQuit         ,hc0,
    nil)))))))),
    NewSubMenu('~H~elp',hc0,NewMenu(
      NewItem('~U~itleg'        ,'F1'   ,kbF1   ,cm_HelpUitleg  ,hc0,
      NewItem('~I~nformatie'    ,''     ,kb0    ,cm_HelpInfo    ,hc0,
    nil))),
  nil)))));
end;

procedure   T_Applicatie.InitStatusLine;
var R: TRect;
begin
  GetExtent(R); R.A.Y:= R.B.Y-1;
  StatusLine:= New(P_StatusLine,Init(R,
    NewStatusDef($0000,$FFFF,
      NewStatusKey('~F1~ Uitleg'      ,kbF1   ,cm_HelpUitleg,
      NewStatusKey('~F10~ Menu'       ,kbF10  ,cmMenu,
      NewStatusKey('~Alt+P~ Pauze'    ,kbAltP ,cm_SpelPauze,
      NewStatusKey('~Alt+X~ Afsluiten',kbAltX ,cmQuit,
      StdStatusKeys(
    nil))))),
  nil)));
end;

procedure   T_Applicatie.Idle;
begin if SpelWindow <> nil then with SpelWindow^ do begin
  if Klok^.Loopt then if Klok^.WerkBij then SchrijfScore;
end end;

procedure   T_Applicatie.HandleEvent(var V_Event: TEvent);
  procedure Clear; begin ClearEvent(V_Event); end;
begin {HandleEvent}
  Inherited HandleEvent(V_Event);
  with V_Event do case What of
    evCommand: case Command of
      cm_HelpUitleg: begin DoHelpUitleg; Clear; end;
      cm_HelpInfo  : begin DoHelpInfo  ; Clear; end;
    end;
  end;
end;

procedure  T_Applicatie.DoHelpUitleg;
begin
  ExecuteDialog(New(P_InfoDialog,Init(50,14,'Uitleg',
    'Klik een getal naast het lege vak aan om het op te schuiven, ' +
    'of gebruik de pijltoetsen.'#13#13 +
    'Zorg dat de getallen oplopend genummerd komen te staan, in rijen ' +
    'van links naar rechts en van boven naar beneden, met het lege vakje ' +
    'rechtsonder.'
  )),nil);
end;

procedure  T_Applicatie.DoHelpInfo;
begin
  ExecuteDialog(New(P_InfoDialog,Init(40,12,'Informatie',
    #3+C_ProgIdent+#13 +
    #3'Borland Pascal + Turbo Vision'#13#13 +
    #3+C_Copyright+#13 +
    #3+C_Email+#13 +
    #3+C_URL
    )),nil);
end;
(*
var R: TRect;
begin
  R.Assign(20,5,60,16);
  MessageBoxRect(R,
    #3+C_ProgIdent+#13 +
    #3'Borland Pascal + Turbo Vision'#13 +
    #3+C_Copyright+#13 +
    #3+C_Email+#13 +
    #3+C_URL,
    nil,mfInformation or mfOKButton);
end;
*)


{ --- Hoofdprogramma --- }

begin
  Randomize;
  Application:= New(P_Applicatie,Init);
  P_Applicatie(Application)^.Run;
  Dispose(P_Applicatie(Application),Done);
end.
