50 REM *** Shadow Legend, v2.5, Ending ***
60 DECLARE SUB PlayWav (wavefile$)
70 DECLARE SUB ValidWavHeader (FILE$, LenHeader%, dataLen&, nChannels%, nSamplesPerSec&, nAvgBytesPerSec&, ok%)
80 DECLARE SUB WriteToDSP (v%)
90 DECLARE SUB PlayBack (buffer$, size%, freq&, BytesPerSec&, chans%, num%)
100 DECLARE SUB delay (tdelay!)
110 DECLARE FUNCTION GetBlasterAddr% ()
120 DECLARE FUNCTION SBreset% ()
130 COMMON SHARED BlasterAddr%, dma%, repeats%
140 CLS
150 '$DYNAMIC
160 DIM REGISTER%(0), PALT%(0)
170 SCREEN 13
180 CALL AUTOLOAD(".\GRAPHICS\TILES\WALL01.SLG", REGISTER%())
190 PUT (0, 0), REGISTER%
200 CLS
210 OPEN ".\DATA\TRANSFER.A" FOR INPUT AS #1: INPUT #1, SLOT$, SN: CLOSE #1
220 OPEN ".\SAVEGAME\SLOT" + SLOT$ + "\PLAYER.D01" FOR INPUT AS #1: INPUT #1, HP, MAXHP, MP, MAXMP, ST, APOW, DE, DPOW, IN, NLMULT, EP, NEXTL, MAP$, MX, MY: CLOSE #1
230 OPEN ".\SAVEGAME\SLOT" + SLOT$ + "\PLAYER.D02" FOR INPUT AS #1: INPUT #1, WP1, WP2, WP3, WP4, WP5, WP6, WP7, WP8, WP9, WP10, WP11, WP12, EWP$: CLOSE #1: OPEN ".\SAVEGAME\SLOT" + SLOT$ + "\PLAYER.D03" FOR INPUT AS #1: INPUT #1, AR1, AR2, AR3, AR4 _
, AR5, AR6, AR7, AR8, EAR$, LEVEL: CLOSE #1
240 OPEN ".\SAVEGAME\SLOT" + SLOT$ + "\PLAYER.D04" FOR INPUT AS #1: INPUT #1, IT1, IT2, IT3, IT4, IT5, IT6, IT7, IT8, IT9, IT10, IT11, IT12, IT13: CLOSE #1: OPEN ".\SAVEGAME\SLOT" + SLOT$ + "\PLAYER.D05" FOR INPUT AS #1: INPUT #1, SP1, SP2, SP3, SP4 _
, SP5, SP6, SP7, SP8, SP9, SP10: CLOSE #1
250 CALL AUTOLOAD(".\GRAPHICS\TILES\PLAYER0" + EAR$ + ".SLG", REGISTER%())
260 PUT (100, 80), REGISTER%
270 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY20.SLG", REGISTER%())
280 PUT (180, 80), REGISTER%
290 COLOR 14: LOCATE 18, 1: PRINT "Rynn": COLOR 15
300 LOCATE 19, 1: PRINT "It's over, Darkstar...you're finished.  "
310 LOCATE 20, 1: PRINT "Leave this realm and die in limbo, and  "
320 LOCATE 21, 1: PRINT "may your soul forever contemplate the   "
330 LOCATE 22, 1: PRINT "mistakes you made in coming here and    "
340 LOCATE 23, 1: PRINT "blanketing my homerealm in darkness.    "
350 Z$ = INPUT$(1)
360 COLOR 9: LOCATE 18, 1: PRINT "Darkstar": COLOR 15
370 LOCATE 19, 1: PRINT "Rrrrgghh...your arrogance will cost more"
380 LOCATE 20, 1: PRINT "lives than my own, Rynn...I am destroyed"
390 LOCATE 21, 1: PRINT "this night...but the damage is done, and"
400 LOCATE 22, 1: PRINT "your descendants shall suffer far more  "
410 LOCATE 23, 1: PRINT "than I do now. Goodbye for a millennium."
420 Z$ = INPUT$(1): FOR N = 1 TO 40: LOCATE 18, N: PRINT " ": LOCATE 19, N: PRINT " ": LOCATE 20, N: PRINT " ": LOCATE 21, N: PRINT " ": LOCATE 22, N: PRINT " ": LOCATE 23, N: PRINT " ": NEXT N
430 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY20.SLG", REGISTER%())
440 PUT (178, 80), REGISTER%
450 PLAY "P32": PLAY "P32"
460 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY20.SLG", REGISTER%())
470 PUT (182, 80), REGISTER%
480 PLAY "P32"
490 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY20.SLG", REGISTER%())
500 PUT (176, 80), REGISTER%
510 PLAY "P32"
520 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY20.SLG", REGISTER%())
530 PUT (184, 80), REGISTER%
540 PLAY "P32"
550 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY20.SLG", REGISTER%())
560 PUT (174, 80), REGISTER%
570 PLAY "P32"
580 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY20.SLG", REGISTER%())
590 PUT (186, 80), REGISTER%
600 PLAY "P32"
610 CLS
620 COLOR 32: LOCATE 2, 16: PRINT "EPILOGUE"
630 COLOR 34
640 LOCATE 4, 1: PRINT "And so it was...Rynn vanquished Darkstar"
650 LOCATE 5, 1: PRINT "and ended the spread of darkness upon   "
660 LOCATE 6, 1: PRINT "the realm of Nor. The nameless warrior's"
670 LOCATE 7, 1: PRINT "progeny succeeded where he could not.   "
680 LOCATE 8, 1: PRINT "But what of Darkstar's curse? What of   "
690 LOCATE 9, 1: PRINT "the thousand years of peace without his "
700 LOCATE 10, 1: PRINT "antagonism? And moreso, what of the end "
710 LOCATE 11, 1: PRINT "of that millennium? In the living end,  "
720 LOCATE 12, 1: PRINT "Darkstar released a flash of energy.    "
730 LOCATE 13, 1: PRINT "This energy shall remain benign outside "
740 LOCATE 14, 1: PRINT "of Nor...until the thousand years are   "
750 LOCATE 15, 1: PRINT "over."
760 Z$ = INPUT$(1): CLS
770 IF SN = 1 THEN PlayWav ".\SOUND\ENDING1.WAV" ELSE PLAY "P1"
780 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY01.SLG", REGISTER%())
790 PUT (20, 20), REGISTER%
800 COLOR 32: LOCATE 4, 7: PRINT "Goblin"
810 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY02.SLG", REGISTER%())
820 PUT (20, 50), REGISTER%
830 LOCATE 8, 7: PRINT "Gnome"
840 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY03.SLG", REGISTER%())
850 PUT (20, 80), REGISTER%
860 LOCATE 12, 7: PRINT "Orc"
870 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY04.SLG", REGISTER%())
880 PUT (20, 110), REGISTER%
890 LOCATE 16, 7: PRINT "Lizard"
900 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY05.SLG", REGISTER%())
910 PUT (20, 140), REGISTER%
920 LOCATE 20, 7: PRINT "Hunter"
930 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY06.SLG", REGISTER%())
940 PUT (260, 20), REGISTER%
950 LOCATE 4, 27: PRINT "Statue"
960 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY07.SLG", REGISTER%())
970 PUT (260, 50), REGISTER%
980 LOCATE 8, 26: PRINT "Soldier"
990 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY08.SLG", REGISTER%())
1000 PUT (260, 80), REGISTER%
1010 LOCATE 12, 29: PRINT "Mage"
1020 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY09.SLG", REGISTER%())
1030 PUT (260, 110), REGISTER%
1040 LOCATE 16, 27: PRINT "Cleric"
1050 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY10.SLG", REGISTER%())
1060 PUT (260, 140), REGISTER%
1070 LOCATE 20, 28: PRINT "Blade"
1080 COLOR 9: LOCATE 23, 11: PRINT "CAST OF CHARACTERS"
1090 IF SN = 1 THEN PlayWav ".\SOUND\ENDING2.WAV" ELSE PLAY "P1P1"
1100 CLS : COLOR 32
1110 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY11.SLG", REGISTER%())
1120 PUT (20, 20), REGISTER%
1130 COLOR 32: LOCATE 4, 7: PRINT "Warrior"
1140 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY12.SLG", REGISTER%())
1150 PUT (20, 50), REGISTER%
1160 LOCATE 8, 7: PRINT "Shadow"
1170 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY13.SLG", REGISTER%())
1180 PUT (20, 80), REGISTER%
1190 LOCATE 12, 7: PRINT "Darkling"
1200 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY14.SLG", REGISTER%())
1210 PUT (20, 110), REGISTER%
1220 LOCATE 16, 7: PRINT "Knight"
1230 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY15.SLG", REGISTER%())
1240 PUT (20, 140), REGISTER%
1250 LOCATE 20, 7: PRINT "Sentinel"
1260 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY16.SLG", REGISTER%())
1270 PUT (260, 20), REGISTER%
1280 LOCATE 4, 26: PRINT "Chimera"
1290 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY17.SLG", REGISTER%())
1300 PUT (260, 50), REGISTER%
1310 LOCATE 8, 25: PRINT "Deribbon"
1320 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY18.SLG", REGISTER%())
1330 PUT (260, 80), REGISTER%
1340 LOCATE 12, 29: PRINT "Lich"
1350 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY19.SLG", REGISTER%())
1360 PUT (260, 110), REGISTER%
1370 LOCATE 16, 27: PRINT "Marble"
1380 CALL AUTOLOAD(".\GRAPHICS\TILES\ENEMY20.SLG", REGISTER%())
1390 PUT (260, 140), REGISTER%
1400 LOCATE 20, 25: PRINT "Darkstar"
1410 COLOR 9: LOCATE 23, 11: PRINT "CAST OF CHARACTERS"
1420 IF SN = 1 THEN PlayWav ".\SOUND\ENDING3.WAV" ELSE PLAY "P1P1"
1430 CLS
1440 COLOR 9: LOCATE 23, 11: PRINT "CAST OF CHARACTERS"
1450 CALL AUTOLOAD(".\GRAPHICS\TILES\PLAYER01.SLG", REGISTER%())
1460 PUT (150, 90), REGISTER%
1470 COLOR 32: LOCATE 15, 16: PRINT "And Rynn..."
1480 IF SN = 1 THEN PlayWav ".\SOUND\ENDING4.WAV" ELSE PLAY "P1P1"
1490 CLS : LOCATE 2, 1: PRINT "PROGRAMMED BY Dustin Sklavos": LOCATE 3, 1: PRINT "ENDING MUSIC BY Mick Rippon": LOCATE 23, 11: PRINT "THANKS FOR PLAYING!"
1500 IF SN = 1 THEN PlayWav ".\SOUND\ENDING5.WAV" ELSE PLAY "P1P1"
1510 CLS : IF LEVEL > 80 THEN 1520 ELSE END
1520 IF WP1 + WP2 + WP3 + WP4 + WP5 + WP6 + WP7 + WP8 + WP9 + WP10 + WP11 + WP12 + AR1 + AR2 + AR3 + AR4 + AR5 + AR6 + AR7 + AR8 + SP1 + SP2 + SP3 + SP4 + SP5 + SP6 + SP7 + SP8 + SP9 + SP10 = 30 THEN 1530 ELSE END
1530 COLOR 32: LOCATE 11, 1: PRINT "You have done very well, Rynn...": LOCATE 12, 1: PRINT "But dare you face me...?": Z$ = INPUT$(1): MAP$ = "DARCHON": MX = 6: MY = 6
1540 OPEN ".\SAVEGAME\SLOT" + SLOT$ + "\PLAYER.D01" FOR OUTPUT AS #1: WRITE #1, HP, MAXHP, MP, MAXMP, ST, APOW, DE, DPOW, IN, NLMULT, EP, NEXTL, MAP$, MX, MY: CLOSE #1: RUN "SHGAME.BAS"

REM $STATIC
DEFINT A-Z
'------------------------------------------------------------------------------
SUB delay (tdelay!)
time1! = TIMER
END SUB

'------------------------------------------------------------------------------
FUNCTION GetBlasterAddr%
'Get Blaster Address and DMA channel from Environment Variable
tmp% = 0  'No Environment Variable Set...default
blast$ = UCASE$(ENVIRON$("BLASTER"))
IF LEN(blast$) THEN
   tmp% = INSTR(blast$, "A")
   tmp1$ = MID$(blast$, tmp% + 1, 3)
   tmp% = VAL("&H" + tmp1$)
   IF tmp% = 203 THEN tmp% = -1    'If there is no value assigned
   IF tmp% > 0 THEN
      tmp2% = INSTR(blast$, "D")
      dma% = VAL(MID$(blast$, tmp2% + 1))        'dma% is a global variable
      IF dma% < 0 OR dma% > 7 THEN tmp% = -2
   END IF
END IF
GetBlasterAddr% = tmp%
END FUNCTION

'------------------------------------------------------------------------------
SUB PlayBack (buffer$, size%, freq&, BytesPerSec&, chans%, num%)
size% = size% - 1
segment& = VARSEG(buffer$)
offset& = SADD(buffer$)
IF segment& < 0 THEN segment& = segment& + 65536
IF offset& < 0 THEN offset& = offset& + 65536
baseaddr& = segment& * 16 + offset&
look1% = VARPTR(baseaddr&)
look2% = VARPTR(size%)
SELECT CASE dma%
   CASE 0
      dmapage% = &H87   '135 decimal
      dmaaddr% = 0
      dmalen% = 1
   CASE 1
      dmapage% = &H83   '131 decimal
      dmaaddr% = 2
      dmalen% = 3
   CASE 2
      dmapage% = &H81
      dmaaddr% = 4
      dmalen% = 5
   CASE 3
      dmapage% = &H82
      dmaaddr% = 6
      dmalen% = 7
   CASE 4
      dmapage% = &H8F
      dmaaddr% = &HC0
      dmalen% = &HC2
   CASE 5
      dmapage% = &H8B
      dmaaddr% = &HC4
      dmalen% = &HC6
   CASE 6
      dmapage% = &H89
      dmaaddr% = &HC8
      dmalen% = &HCA
   CASE 7
      dmapage% = &H8A
      dmaaddr% = &HCC
      dmalen% = &HCE
END SELECT
SELECT CASE dma%
   CASE 0 TO 3
      dmamask% = &HA
      dmamode% = &HB
      dmaclear% = &HC
      dmastatus% = &H8
   CASE 4 TO 7
      dmamask% = &HD4
      dmamode% = &HD6
      dmaclear% = &HD8
      dmastatus% = &HD0
END SELECT
SELECT CASE dma%
   CASE 0, 4
      dmaterminal% = 1   'bit 0 of status register (&H08 or &HD0)
   CASE 1, 5
      dmaterminal% = 2   'bit 1
   CASE 2, 6
      dmaterminal% = 4   'bit 2
   CASE 3, 7
      dmaterminal% = 8   'bit 3
END SELECT

OUT dmamask%, dma% + 4   'mask the dma channel
OUT dmaclear%, &H0       '(clear the internal DMA flip/flop)
OUT dmamode%, 72 + dma%  '  72=010010XX where XX=dmachannel%
OUT dmaaddr%, PEEK(look1%)      'bits 0-7 of  the 20bit address
OUT dmaaddr%, PEEK(look1% + 1)  'bits 8-15 of the 20bit address
OUT dmapage%, PEEK(look1% + 2)  'bits 16-19 of the 20 bit address
OUT dmalen%, PEEK(look2%)       'bits 0-7 of size%
OUT dmalen%, PEEK(look2% + 1)   'bits 8-15  of size%
OUT dmamask%, dma%              'enable channel

IF num% = 1 THEN  'only need to Write out time constant once
   timeconst% = 256 - 1000000 / (freq& * chans%)
   CALL WriteToDSP(&H40)
   CALL WriteToDSP(timeconst%)
   'Reset Mixer    DSPmixeraddress = Blasteraddr% + &H4
   OUT BlasterAddr% + &H4, &H0
   OUT BlasterAddr% + &H4 + 1, 0
   'Set Volume to Maximum...255
   OUT BlasterAddr% + &H4, &H22
   OUT BlasterAddr% + &H4 + 1, 255
   IF chans% = 2 THEN
      'Set mixer to Stereo Output
      OUT BlasterAddr% + &H4, &HE
      OUT BlasterAddr% + &H4 + 1, 34      '34=2^5+2^1
   END IF
END IF
IF BytesPerSec& > 22000 THEN
   CALL WriteToDSP(&H48)   'Set Block Size
ELSE
   CALL WriteToDSP(&H14)   'DMA Mode 8-bit DAC
END IF
CALL WriteToDSP(PEEK(look2%))      'Lo byte of address
CALL WriteToDSP(PEEK(look2% + 1))  'High byte of address
IF BytesPerSec& > 22000 THEN CALL WriteToDSP(&H91)  'High Speed DMA mode 8-bit
dummy% = INP(dmastatus%)    'Read status byte once to make sure DMA is going.
WAIT dmastatus%, dmaterminal%   'Loop until terminal count bit set in DMA status register
'DMA Transfer is Now Complete
'Acknowledge the DSP interrupt by reading the DATA AVAILABLE port once
dummy% = INP(BlasterAddr% + &HE)    'DSP Available address
END SUB

DEFSNG A-Z
SUB PlayWav (wavefile$)


repeats% = 1
BlasterAddr% = GetBlasterAddr%
SELECT CASE BlasterAddr%
   CASE -2
      PRINT "Bad DMA Channel specified!"
      END
   CASE -1
      PRINT "No Port Base Address Given!"
      END
   CASE 0
      PRINT "No BLASTER Environment Variable Set!"
      END
   CASE ELSE
      'Assume a valid Address Exists
'      PRINT "Blaster Address = "; HEX$(BlasterAddr%)
END SELECT
IF NOT SBreset% THEN
   PRINT "SoundBlaster Card Would Not Reset!"
   END
END IF

sp% = INSTR(Spec$, " ")
IF sp% THEN
   wavefile$ = LEFT$(Spec$, sp% - 1)
   repeats% = VAL(RIGHT$(Spec$, LEN(Spec$) - sp%))
   IF repeats% = 0 THEN repeats% = 1
ELSE
   IF LEN(Spec$) THEN
      wavefile$ = Spec$
      repeats% = 1
   END IF
END IF

IF LEN(wavefile$) = 0 THEN
END IF
'wavefile$ = "C:\QBASIC\THEME.WAV"
CALL ValidWavHeader(wavefile$, LenHeader%, WavLen&, Channels%, Sampling&, bytes&, ok%)

IF NOT ok% THEN
   PRINT "Bad Wave File Format"
   END
END IF

MaxBuffer% = 7053

CALL WriteToDSP(&HD1)  'Speaker ON
FOR repeat% = 1 TO repeats%    'This can loop to play the file ii% times]
filenum% = FREEFILE
   OPEN wavefile$ FOR BINARY AS filenum%
      num% = 0
      SEEK filenum%, LenHeader% + 1
      Remaining& = WavLen&
      DO
         num% = num% + 1
         IF Remaining& > MaxBuffer% THEN
            BufferLen% = MaxBuffer%
         ELSE
            BufferLen% = Remaining&
         END IF
         Remaining& = Remaining& - BufferLen%
         buffer$ = SPACE$(BufferLen%)
         GET filenum%, , buffer$
         CALL PlayBack(buffer$, BufferLen%, Sampling&, bytes&, Channels%, num%)
      LOOP WHILE Remaining& > 0
      OUT &H20, &H20   'Reset Normal Interrupt Service
   CLOSE filenum%
NEXT repeat%
CALL WriteToDSP(&HD3)  'Speaker OFF

END SUB

DEFINT A-Z
'------------------------------------------------------------------------------
FUNCTION SBreset%
'DSPreset% = address% + &H6
'DSPread% = address% + &HA
'DSPwrite% = address% + &HC
'DSPavail% = address% + &HE
'DSPmixer% = address% + &H4
OUT BlasterAddr% + &H6, 1   'Reset address
delay .1
OUT BlasterAddr% + &H6, 0
time1! = TIMER: noreset% = 0
DO
   'Read Data Available port until bit 7 is set
   'This should take about 100 micro seconds...give it 1 full second
   IF TIMER - time1! > 1! THEN noreset% = -1
LOOP UNTIL ((INP(BlasterAddr% + &HE) AND 128) = 128) OR noreset%
IF NOT noreset% THEN
   IF INP(BlasterAddr% + &HA) = &HAA THEN
      SBreset% = -1
   ELSE
      SBreset% = 0
   END IF
ELSE
   SBreset% = 0
END IF
END FUNCTION

'------------------------------------------------------------------------------
SUB ValidWavHeader (FILE$, LenHeader%, dataLen&, nChannels%, nSamplesPerSec&, nAvgBytesPerSec&, ok%)
rID$ = SPACE$(4)
wID$ = SPACE$(4)
fID$ = SPACE$(4)
dat$ = SPACE$(4)
dummy$ = SPACE$(1)

filenum% = FREEFILE
OPEN FILE$ FOR BINARY AS filenum%
  GET filenum%, , rID$
  GET filenum%, , rLen&
  GET filenum%, , wID$
  GET filenum%, , fID$
  GET filenum%, , fLen&
  GET filenum%, , wFormatTag%       '2 bytes
  GET filenum%, , nChannels%        '2 bytes
  GET filenum%, , nSamplesPerSec&   '4 bytes
  GET filenum%, , nAvgBytesPerSec&  '4 bytes
  GET filenum%, , nBlockAlign%      '2 bytes
  GET filenum%, , FormatSpecific%   '2 bytes
  'Read bytes until have read fLen& total bytes.
  'I have no idea what these next bytes are used for (if they even exist).
  FOR i% = 1 TO fLen& - 16          '16 bytes is what we have read in so far
     GET filenum%, , dummy$         'read in 1 byte at a time
  NEXT i%
  GET filenum%, , dat$
  IF UCASE$(dat$) = "FACT" THEN
     'funny format...
     GET filenum%, , dummy&
     GET filenum%, , dummy&
     GET filenum%, , dat$
  END IF
  GET filenum%, , dataLen&
  LenHeader% = LOC(1)
CLOSE filenum%
'  PRINT rID$;
'  PRINT rLen&;
'  PRINT wID$;
'  PRINT fID$;
'  PRINT fLen&;
'  PRINT wFormatTag%;       '2 bytes
'  PRINT nChannels%;        '2 bytes
'  PRINT nSamplesPerSec&;   '4 bytes
'  PRINT nAvgBytesPerSec&;  '4 bytes
'  PRINT nBlockAlign%;      '2 bytes
'  PRINT FormatSpecific%;   '2 bytes
'  PRINT dat$;
'  PRINT dataLen&;
'  PRINT LenHeader%
IF UCASE$(rID$) = "RIFF" THEN
   IF UCASE$(wID$) = "WAVE" THEN
      IF UCASE$(dat$) = "DATA" THEN
         IF UCASE$(fID$) = "FMT " THEN
           IF FormatSpecific% = 8 THEN ok% = -1
         END IF
      END IF
   END IF
END IF
END SUB

'------------------------------------------------------------------------------
SUB WriteToDSP (v%)
OUT BlasterAddr% + &HC, v%
END SUB

