50 REM *** Shadow Legend, v2.6 ***
60 DECLARE SUB PlayWav (wavefile$)
70 DECLARE SUB ValidWavHeader (FILE$, LenHeader%, dataLen&, nChannels%, nSamplesPerSec&, nAvgBytesPerSec&, ok%)
80 DECLARE SUB WriteToDSP (v%)
90 DECLARE SUB PlayBack (buffer$, size%, freq&, BytesPerSec&, chans%, num%)
100 DECLARE SUB delay (tdelay!)
110 DECLARE FUNCTION GetBlasterAddr% ()
120 DECLARE FUNCTION SBreset% ()
130 COMMON SHARED BlasterAddr%, dma%, repeats%
140 CLS
150 '$DYNAMIC
160 DIM REGISTER%(0), PALT%(0)
170 SCREEN 13
180 CALL AUTOLOAD(".\GRAPHICS\MISC\STARTUP.SLG", REGISTER%())
190 PUT (0, 0), REGISTER%
200 COLOR 55: LOCATE 4, 1: PRINT "Shadow Legend, v2.6"
210 COLOR 4: LOCATE 5, 1: PRINT "*****************WARNING****************": COLOR 15: LOCATE 6, 1: PRINT "Unauthorized distribution of this game": LOCATE 7, 1: PRINT "is strictly prohibited.": COLOR 4: LOCATE 8, 1: PRINT  _
"****************************************"
220 COLOR 15: LOCATE 9, 1: PRINT "NOTE: Some sound cards do not function": LOCATE 10, 1: PRINT "correctly with the sound code of this": LOCATE 11, 1: PRINT "game.": LOCATE 12, 1: PRINT "Select Sound Option:": LOCATE 13, 1: PRINT "1) Sound Blaster": _
                                 LOCATE 14, 1: PRINT "2) No Sound"
230 Z$ = INPUT$(1)
240 IF Z$ = "1" THEN SN = 1: GOTO 260
250 IF Z$ = "2" THEN SN = 0: GOTO 322 ELSE 230
260 LOCATE 15, 1: PRINT "Sound will now initialize. If you do not": LOCATE 16, 1: PRINT "hear a chime, hit Ctrl+Break and restart": LOCATE 17, 1: PRINT "the program. Press any key."
270 Z$ = INPUT$(1)
280 PlayWav ".\SOUND\CHIME.WAV"
290 LOCATE 18, 1: PRINT "Did you hear a chime? (Y/N)"
300 Z$ = INPUT$(1)
310 IF Z$ = "Y" OR Z$ = "y" THEN SN = 1: GOTO 322
320 IF Z$ = "N" OR Z$ = "n" THEN SN = 0 ELSE 300
322 LOCATE 19, 1: PRINT "Skip the introduction sequence? (Y/N)"
324 Z$ = INPUT$(1)
326 IF Z$ = "Y" OR Z$ = "y" THEN INSKIP = 1: GOTO 330
328 IF Z$ = "N" OR Z$ = "n" THEN INSKIP = 0 ELSE 324
330 LOCATE 22, 1: PRINT "The game is ready to run. Press any key."
340 Z$ = INPUT$(1): PLAY "P1": CLS
350 CALL AUTOLOAD(".\GRAPHICS\MISC\LOGO.SLG", REGISTER%())
360 PUT (0, 0), REGISTER%
370 IF SN = 1 THEN PlayWav ".\SOUND\INTRO1.WAV" ELSE PLAY "P1P1"
375 IF INSKIP = 1 THEN 530
380 CLS : CALL AUTOLOAD(".\GRAPHICS\MISC\INTRO1.SLG", REGISTER%())
390 PUT (0, 0), REGISTER%
400 IF SN = 1 THEN PlayWav ".\SOUND\INTRO2.WAV" ELSE PLAY "P1P1"
410 CLS : CALL AUTOLOAD(".\GRAPHICS\MISC\INTRO2.SLG", REGISTER%())
420 PUT (0, 0), REGISTER%
430 IF SN = 1 THEN PlayWav ".\SOUND\INTRO3.WAV" ELSE PLAY "P1P1"
440 CLS : CALL AUTOLOAD(".\GRAPHICS\MISC\INTRO3.SLG", REGISTER%())
450 PUT (0, 0), REGISTER%
460 IF SN = 1 THEN PlayWav ".\SOUND\INTRO4.WAV" ELSE PLAY "P1P1"
470 CLS : CALL AUTOLOAD(".\GRAPHICS\MISC\INTRO4.SLG", REGISTER%())
480 PUT (0, 0), REGISTER%
490 IF SN = 1 THEN PlayWav ".\SOUND\INTRO5.WAV" ELSE PLAY "P1P1"
500 CLS : CALL AUTOLOAD(".\GRAPHICS\MISC\INTRO5.SLG", REGISTER%())
510 PUT (0, 0), REGISTER%
520 IF SN = 1 THEN PlayWav ".\SOUND\INTRO6.WAV" ELSE PLAY "P1P1"
530 CLS : CALL AUTOLOAD(".\GRAPHICS\MISC\TITLE.SLG", REGISTER%())
540 PUT (0, 0), REGISTER%
550 COLOR 15: LOCATE 17, 12: PRINT "Start New Game": LOCATE 18, 12: PRINT "Saved Games": LOCATE 19, 12: PRINT "Item Descriptions": LOCATE 20, 12: PRINT "Quit"
560 COLOR 14: SEL = 1: GOSUB 650
570 GOSUB 650: Z$ = INPUT$(1)
580 IF Z$ = "2" THEN 610 ELSE 590
590 IF Z$ = "8" THEN 630 ELSE 600
600 IF Z$ = CHR$(13) THEN 660 ELSE 570
610 SEL = SEL + 1: IF SEL > 4 THEN SEL = 1: GOTO 570 ELSE 570
630 SEL = SEL - 1: IF SEL < 1 THEN SEL = 4: GOTO 570 ELSE 570
650 FOR N = 17 TO 22: LOCATE N, 11: PRINT " ": NEXT N: LOCATE SEL + 16, 11: PRINT CHR$(16): RETURN
660 IF SEL = 1 THEN 10000
670 IF SEL = 4 THEN 800
680 IF SEL = 3 THEN 3000
690 IF SEL = 2 THEN 1000
800 CLS : SCREEN 0: WIDTH 80: COLOR 9: FOR N = 1 TO 80: LOCATE 1, N: PRINT "": LOCATE 23, N: PRINT "": NEXT N: FOR N = 1 TO 23: LOCATE N, 1: PRINT "": LOCATE N, 80: PRINT "": NEXT N: LOCATE 1, 1: PRINT "": LOCATE 1, 80: PRINT "": LOCATE 23, 1 _
: PRINT "": LOCATE 23, 80: PRINT ""
810 COLOR 1: LOCATE 2, 2: PRINT "SHADOW LEGEND, v2.6": COLOR 7: LOCATE 4, 2: PRINT "SHADOW LEGEND is programmed by:": LOCATE 5, 2: PRINT "Dustin Sklavos": LOCATE 6, 2: PRINT "Ricky Chu (Graphics Code)": LOCATE 8, 2: PRINT  _
"SHADOW LEGEND was planned under the title 'Dungeonscape,' but grew from it to": LOCATE 9, 2: PRINT "be a sequel to an old series of games (The Legendary Warrior I through IV) as": LOCATE 10, 2: PRINT  _
"well as a starting point for a new series. Loose translation: expect sequels"
820 LOCATE 11, 2: PRINT "to SHADOW LEGEND. Sequels will include new and different tiles, enemies,": LOCATE 12, 2: PRINT "spells, and so forth. But it's very doubtful you've seen every corner of": LOCATE 13, 2: PRINT  _
"SHADOW LEGEND itself. Don't forget the breakable walls...and you can walk": LOCATE 14, 2: PRINT "through some walls. Chances are you haven't found the Shadow Cloak or Soul": LOCATE 15, 2: PRINT  _
"Sword yet, either. Probably not even the Drain spell. Start looking! You'll": LOCATE 16, 2: PRINT "need them!"
830 LOCATE 18, 2: PRINT "I put a lot of work into making this game, but it was fun for me and I hope": LOCATE 19, 2: PRINT "you enjoyed playing it. The game IS expandable and new worlds may be made for": LOCATE 20, 2: PRINT  _
"it, so remember to check back at http://members.home.net/rp2k/index.html": LOCATE 21, 2: PRINT "for updates!": END
1000 'Saved Games
1010 CLS : COLOR 15: FOR N = 1 TO 40: LOCATE 1, N: PRINT "": LOCATE 23, N: PRINT "": NEXT N: FOR N = 1 TO 23: LOCATE N, 1: PRINT "": LOCATE N, 40: PRINT "": NEXT N: LOCATE 1, 1: PRINT "": LOCATE 1, 40: PRINT "": LOCATE 23, 1: PRINT "": LOCATE _
 23, 40: PRINT ""
1020 COLOR 14: LOCATE 2, 13: PRINT "LOAD SAVED GAME": COLOR 7: LOCATE 5, 3: PRINT "Save Slot [1]": LOCATE 6, 3: PRINT "Save Slot [2]": LOCATE 7, 3: PRINT "Save Slot [3]": LOCATE 9, 3: PRINT "4 - Cancel"
1030 Z$ = INPUT$(1)
1040 IF Z$ = "1" THEN SLOT$ = "1"
1050 IF Z$ = "2" THEN SLOT$ = "2"
1060 IF Z$ = "3" THEN SLOT$ = "3"
1070 IF Z$ = "4" THEN 530
1080 OPEN ".\DATA\TRANSFER.A" FOR OUTPUT AS #1: WRITE #1, SLOT$, SN: CLOSE #1: RUN "SHGAME.BAS"
3000 'Item Descriptions
3010 CLS : COLOR 15: LOCATE 1, 1: PRINT "Move the selector over the item you": LOCATE 2, 1: PRINT "wish to see for a description."
3020 T$ = "ITEM01": IX = 0: IY = 20: GOSUB 3900: T$ = "ITEM02": IX = 20: GOSUB 3900: T$ = "ITEM03": IX = 40: GOSUB 3900: T$ = "ITEM04": IX = 60: GOSUB 3900: T$ = "ITEM05": IX = 80: GOSUB 3900: T$ = "ITEM06": IX = 100: GOSUB 3900: T$ = "ITEM07": IX  _
= 120: GOSUB 3900: T$ = "ITEM08": IX = 140: GOSUB 3900: T$ = "ITEM09": IX = 160: GOSUB 3900: T$ = "ITEM10": IX = 180: GOSUB 3900: T$ = "ITEM11": IX = 200: GOSUB 3900
3030 T$ = "ITEM12": IX = 220: GOSUB 3900: T$ = "ITEM13": IX = 240: GOSUB 3900: T$ = "SCROLL01": IX = 0: IY = 40: GOSUB 3900: T$ = "SCROLL02": IX = 20: GOSUB 3900: T$ = "SCROLL03": IX = 40: GOSUB 3900: T$ = "SCROLL04": IX = 60: GOSUB 3900: T$ =  _
"SCROLL05": IX = 80: GOSUB 3900: T$ = "SCROLL06": IX = 100: GOSUB 3900: T$ = "SCROLL07": IX = 120: GOSUB 3900: T$ = "SCROLL08": IX = 140: GOSUB 3900: T$ = "SCROLL09": IX = 160: GOSUB 3900: T$ = "SCROLL10": IX = 180: GOSUB 3900: SEL = 1
3040 GOSUB 3800: GOSUB 3100
3050 Z$ = INPUT$(1)
3060 IF Z$ = "6" THEN 3080
3070 IF Z$ = "4" THEN 3090 ELSE 530
3080 GOSUB 3800: SEL = SEL + 1: IF SEL > 23 THEN SEL = 1: GOTO 3040 ELSE 3040
3090 GOSUB 3800: SEL = SEL - 1: IF SEL < 1 THEN SEL = 23: GOTO 3040 ELSE 3040
3100 GOSUB 3700: IF SEL = 1 THEN 3400
3110 IF SEL = 2 THEN 3410
3120 IF SEL = 3 THEN 3420
3130 IF SEL = 4 THEN 3430
3140 IF SEL = 5 THEN 3440
3150 IF SEL = 6 THEN 3450
3160 IF SEL = 7 THEN 3460
3170 IF SEL = 8 THEN 3470
3180 IF SEL = 9 THEN 3480
3190 IF SEL = 10 THEN 3490
3200 IF SEL = 11 THEN 3500
3210 IF SEL = 12 THEN 3510
3220 IF SEL = 13 THEN 3520
3230 IF SEL = 14 THEN 3530
3240 IF SEL = 15 THEN 3540
3250 IF SEL = 16 THEN 3550
3260 IF SEL = 17 THEN 3560
3270 IF SEL = 18 THEN 3570
3280 IF SEL = 19 THEN 3580
3290 IF SEL = 20 THEN 3590
3300 IF SEL = 21 THEN 3600
3310 IF SEL = 22 THEN 3610 ELSE 3620
3400 COLOR 14: LOCATE 11, 2: PRINT "Healing Herb": COLOR 7: LOCATE 12, 2: PRINT "Restores 50 HP.": RETURN
3410 COLOR 14: LOCATE 11, 2: PRINT "Blue Healing Herb": COLOR 7: LOCATE 12, 2: PRINT "Restores 125 HP.": RETURN
3420 COLOR 14: LOCATE 11, 2: PRINT "Red Healing Herb": COLOR 7: LOCATE 12, 2: PRINT "Completely restores your HP.": RETURN
3430 COLOR 14: LOCATE 11, 2: PRINT "Hammer": COLOR 7: LOCATE 12, 2: PRINT "Can destroy cracked walls.": RETURN
3440 COLOR 14: LOCATE 11, 2: PRINT "Megaton Bomb": COLOR 7: LOCATE 12, 2: PRINT "Deals heavy damage to enemies.": RETURN
3450 COLOR 14: LOCATE 11, 2: PRINT "Assassin's Knife": COLOR 7: LOCATE 12, 2: PRINT "Automatically kills most enemies.": RETURN
3460 COLOR 14: LOCATE 11, 2: PRINT "Mana Petal": COLOR 7: LOCATE 12, 2: PRINT "Restores 10 MP.": RETURN
3470 COLOR 14: LOCATE 11, 2: PRINT "Mana Flower": COLOR 7: LOCATE 12, 2: PRINT "Restores 50 MP.": RETURN
3480 COLOR 14: LOCATE 11, 2: PRINT "Mana Crystal": COLOR 7: LOCATE 12, 2: PRINT "Completely restores your MP.": RETURN
3490 COLOR 14: LOCATE 11, 2: PRINT "Elixir": COLOR 7: LOCATE 12, 2: PRINT "Completely restores your HP and MP.": RETURN
3500 COLOR 14: LOCATE 11, 2: PRINT "Blue Key": COLOR 7: LOCATE 12, 2: PRINT "Used to open blue doors.": RETURN
3510 COLOR 14: LOCATE 11, 2: PRINT "Red Key": COLOR 7: LOCATE 12, 2: PRINT "Used to open red doors.": RETURN
3520 COLOR 14: LOCATE 11, 2: PRINT "Green Key": COLOR 7: LOCATE 12, 2: PRINT "Used to open green doors.": RETURN
3530 COLOR 14: LOCATE 11, 2: PRINT "Spell: Cure": COLOR 7: LOCATE 12, 2: PRINT "Restores 50 HP.": RETURN
3540 COLOR 14: LOCATE 11, 2: PRINT "Spell: Megacure": COLOR 7: LOCATE 12, 2: PRINT "Restores 200 HP.": RETURN
3550 COLOR 14: LOCATE 11, 2: PRINT "Spell: Gigacure": COLOR 7: LOCATE 12, 2: PRINT "Completely restores your HP.": RETURN
3560 COLOR 14: LOCATE 11, 2: PRINT "Spell: Drain": COLOR 7: LOCATE 12, 2: PRINT "Drains HP from enemy to you.": RETURN
3570 COLOR 14: LOCATE 11, 2: PRINT "Spell: Fire": COLOR 7: LOCATE 12, 2: PRINT "Damages enemy.": RETURN
3580 COLOR 14: LOCATE 11, 2: PRINT "Spell: Bolt": COLOR 7: LOCATE 12, 2: PRINT "Damages enemy.": RETURN
3590 COLOR 14: LOCATE 11, 2: PRINT "Spell: Ice": COLOR 7: LOCATE 12, 2: PRINT "Damages enemy.": RETURN
3600 COLOR 14: LOCATE 11, 2: PRINT "Spell: Burnout": COLOR 7: LOCATE 12, 2: PRINT "Heavily damages enemy.": RETURN
3610 COLOR 14: LOCATE 11, 2: PRINT "Spell: Storm": COLOR 7: LOCATE 12, 2: PRINT "Heavily damages enemy.": RETURN
3620 COLOR 14: LOCATE 11, 2: PRINT "Spell: Freeze": COLOR 7: LOCATE 12, 2: PRINT "75% instant death to most enemies.": RETURN
3700 COLOR 15: FOR N = 1 TO 40: LOCATE 10, N: PRINT "": LOCATE 13, N: PRINT "": NEXT N: FOR N = 10 TO 13: LOCATE N, 1: PRINT "": LOCATE N, 40: PRINT "": NEXT N: LOCATE 10, 1: PRINT "": LOCATE 10, 40: PRINT "": LOCATE 13, 1: PRINT "": LOCATE  _
13, 40: PRINT "": FOR N = 2 TO 39: LOCATE 11, N: PRINT " ": LOCATE 12, N: PRINT " ": NEXT N: RETURN
3800 IF SEL > 13 THEN 3820 ELSE 3810
3810 T$ = "SELECTOR": IX = (SEL - 1) * 20: IY = 20: GOSUB 3900: RETURN
3820 T$ = "SELECTOR": IX = (SEL - 14) * 20: IY = 40: GOSUB 3900: RETURN
3900 CALL AUTOLOAD(".\GRAPHICS\TILES\" + T$ + ".SLG", REGISTER%())
3910 PUT (IX, IY), REGISTER%: RETURN
10000 'New Game
10010 CLS : COLOR 15: FOR N = 1 TO 40: LOCATE 1, N: PRINT "": LOCATE 23, N: PRINT "": NEXT N: FOR N = 1 TO 23: LOCATE N, 1: PRINT "": LOCATE N, 40: PRINT "": NEXT N: LOCATE 1, 1: PRINT "": LOCATE 1, 40: PRINT "": LOCATE 23, 1: PRINT "": _
                          LOCATE 23, 40: PRINT ""
10020 COLOR 14: LOCATE 2, 11: PRINT "CREATE NEW CHARACTER": COLOR 7
10030 LOCATE 4, 3: PRINT "NOTE: Creating a  new character will"
10040 LOCATE 5, 3: PRINT "erase the  saved game  in the chosen"
10050 LOCATE 6, 3: PRINT "save  slot.  Do  you  still  want to"
10060 LOCATE 7, 3: PRINT "continue? (Y/N)"
10070 Z$ = INPUT$(1)
10080 IF Z$ = "Y" OR Z$ = "y" THEN 10100
10090 IF Z$ = "N" OR Z$ = "n" THEN 530 ELSE 10070
10100 LOCATE 4, 3: PRINT "Characters  shown here  are randomly"
10110 LOCATE 5, 3: PRINT "generated,  and  so you  may want to"
10120 LOCATE 6, 3: PRINT "press [R] to re-roll your character,"
10130 LOCATE 7, 3: PRINT "which will change the statistics.   "
10140 COLOR 8: LOCATE 9, 3: PRINT "Hit Points:": LOCATE 11, 3: PRINT "Strength:": LOCATE 12, 3: PRINT "Defense:": LOCATE 10, 3: PRINT "Magic Power:": LOCATE 14, 3: PRINT "Level Multiplier:": LOCATE 13, 3: PRINT "Intelligence:"
10150 COLOR 10: MAXHP = INT(RND(1) * 10) + 1: MAXHP = MAXHP + 15: LOCATE 9, 25: PRINT MAXHP
10160 MAXMP = INT(RND(1) * 4) + 1: MAXMP = MAXMP + 7: LOCATE 10, 25: PRINT MAXMP
10170 ST = INT(RND(1) * 4) + 1: ST = ST + 4: LOCATE 11, 25: PRINT ST
10180 DE = INT(RND(1) * 4) + 1: LOCATE 12, 25: PRINT DE
10190 NLMULT = INT(RND(1) * 15) + 1: NLMULT = NLMULT + 20: LOCATE 14, 25: PRINT NLMULT
10195 IN = INT(RND(1) * 4) + 1: IN = IN + 2: LOCATE 13, 25: PRINT IN
10200 COLOR 7: LOCATE 16, 3: PRINT "Accept these statistics? (Y/N)"
10210 Z$ = INPUT$(1)
10220 IF Z$ = "Y" OR Z$ = "y" THEN 10240
10230 IF Z$ = "R" OR Z$ = "r" OR Z$ = "N" OR Z$ = "n" THEN 10140 ELSE 10210
10240 CLS : COLOR 15: FOR N = 1 TO 40: LOCATE 1, N: PRINT "": LOCATE 23, N: PRINT "": NEXT N: FOR N = 1 TO 23: LOCATE N, 1: PRINT "": LOCATE N, 40: PRINT "": NEXT N: LOCATE 1, 1: PRINT "": LOCATE 1, 40: PRINT "": LOCATE 23, 1: PRINT "": _
                          LOCATE 23, 40: PRINT ""
10250 COLOR 14: LOCATE 2, 11: PRINT "CREATE NEW CHARACTER": COLOR 7: WP1 = 1: AR1 = 1: APOW = ST + 2: DPOW = DE + 1: NEXTL = NLMULT: MAP$ = "ENTRYWAY": MX = 5: MY = 9: EAR$ = "1": EWP$ = "1": LEVEL = 1
10260 LOCATE 4, 3: PRINT "Choose a save slot."
10270 LOCATE 6, 3: PRINT "Save Slot [1]"
10280 LOCATE 7, 3: PRINT "Save Slot [2]"
10290 LOCATE 8, 3: PRINT "Save Slot [3]"
10300 LOCATE 10, 3: PRINT "4 - Cancel"
10310 HP = MAXHP: MP = MAXMP: Z$ = INPUT$(1)
10320 IF Z$ = "1" THEN 10360
10330 IF Z$ = "2" THEN 10370
10340 IF Z$ = "3" THEN 10380
10350 IF Z$ = "4" THEN 530 ELSE 10310
10360 SHELL "ERASE .\SAVEGAME\SLOT1\*.*": SHELL "COPY .\MAPS\*.* .\SAVEGAME\SLOT1": OPEN ".\SAVEGAME\SLOT1\PLAYER.D01" FOR OUTPUT AS #1: WRITE #1, HP, MAXHP, MP, MAXMP, ST, APOW, DE, DPOW, IN, NLMULT, EP, NEXTL, MAP$, MX, MY: CLOSE #1
10362 OPEN ".\SAVEGAME\SLOT1\PLAYER.D02" FOR OUTPUT AS #1: WRITE #1, WP1, WP2, WP3, WP4, WP5, WP6, WP7, WP8, WP9, WP10, WP11, WP12, EWP$: CLOSE #1: OPEN ".\SAVEGAME\SLOT1\PLAYER.D03" FOR OUTPUT AS #1: WRITE #1, AR1, AR2, AR3, AR4, AR5, AR6, AR7, AR8 _
, EAR$, LEVEL: CLOSE #1
10364 OPEN ".\SAVEGAME\SLOT1\PLAYER.D04" FOR OUTPUT AS #1: WRITE #1, IT1, IT2, IT3, IT4, IT5, IT6, IT7, IT8, IT9, IT10, IT11, IT12, IT13: CLOSE #1: OPEN ".\SAVEGAME\SLOT1\PLAYER.D05" FOR OUTPUT AS #1: WRITE #1, SP1, SP2, SP3, SP4, SP5, SP6, SP7, SP8 _
, SP9, SP10: CLOSE #1: GOTO 10390
10370 SHELL "ERASE .\SAVEGAME\SLOT2\*.*": SHELL "COPY .\MAPS\*.* .\SAVEGAME\SLOT2": OPEN ".\SAVEGAME\SLOT2\PLAYER.D01" FOR OUTPUT AS #1: WRITE #1, HP, MAXHP, MP, MAXMP, ST, APOW, DE, DPOW, IN, NLMULT, EP, NEXTL, MAP$, MX, MY: CLOSE #1
10372 OPEN ".\SAVEGAME\SLOT2\PLAYER.D02" FOR OUTPUT AS #1: WRITE #1, WP1, WP2, WP3, WP4, WP5, WP6, WP7, WP8, WP9, WP10, WP11, WP12, EWP$: CLOSE #1: OPEN ".\SAVEGAME\SLOT2\PLAYER.D03" FOR OUTPUT AS #1: WRITE #1, AR1, AR2, AR3, AR4, AR5, AR6, AR7, AR8 _
, EAR$, LEVEL: CLOSE #1
10374 OPEN ".\SAVEGAME\SLOT2\PLAYER.D04" FOR OUTPUT AS #1: WRITE #1, IT1, IT2, IT3, IT4, IT5, IT6, IT7, IT8, IT9, IT10, IT11, IT12, IT13: CLOSE #1: OPEN ".\SAVEGAME\SLOT2\PLAYER.D05" FOR OUTPUT AS #1: WRITE #1, SP1, SP2, SP3, SP4, SP5, SP6, SP7, SP8 _
, SP9, SP10: CLOSE #1: GOTO 10390
10380 SHELL "ERASE .\SAVEGAME\SLOT3\*.*": SHELL "COPY .\MAPS\*.* .\SAVEGAME\SLOT3": OPEN ".\SAVEGAME\SLOT3\PLAYER.D01" FOR OUTPUT AS #1: WRITE #1, HP, MAXHP, MP, MAXMP, ST, APOW, DE, DPOW, IN, NLMULT, EP, NEXTL, MAP$, MX, MY: CLOSE #1
10382 OPEN ".\SAVEGAME\SLOT3\PLAYER.D02" FOR OUTPUT AS #1: WRITE #1, WP1, WP2, WP3, WP4, WP5, WP6, WP7, WP8, WP9, WP10, WP11, WP12, EWP$: CLOSE #1: OPEN ".\SAVEGAME\SLOT3\PLAYER.D03" FOR OUTPUT AS #1: WRITE #1, AR1, AR2, AR3, AR4, AR5, AR6, AR7, AR8 _
, EAR$, LEVEL: CLOSE #1
10384 OPEN ".\SAVEGAME\SLOT3\PLAYER.D04" FOR OUTPUT AS #1: WRITE #1, IT1, IT2, IT3, IT4, IT5, IT6, IT7, IT8, IT9, IT10, IT11, IT12, IT13: CLOSE #1: OPEN ".\SAVEGAME\SLOT3\PLAYER.D05" FOR OUTPUT AS #1: WRITE #1, SP1, SP2, SP3, SP4, SP5, SP6, SP7, SP8 _
, SP9, SP10: CLOSE #1
10390 OPEN ".\DATA\TRANSFER.A" FOR OUTPUT AS #1: WRITE #1, Z$, SN: CLOSE #1: RUN "SHGAME.BAS"

REM $STATIC
DEFINT A-Z
'------------------------------------------------------------------------------
SUB delay (tdelay!)
time1! = TIMER
END SUB

'------------------------------------------------------------------------------
FUNCTION GetBlasterAddr%
'Get Blaster Address and DMA channel from Environment Variable
tmp% = 0  'No Environment Variable Set...default
blast$ = UCASE$(ENVIRON$("BLASTER"))
IF LEN(blast$) THEN
   tmp% = INSTR(blast$, "A")
   tmp1$ = MID$(blast$, tmp% + 1, 3)
   tmp% = VAL("&H" + tmp1$)
   IF tmp% = 203 THEN tmp% = -1    'If there is no value assigned
   IF tmp% > 0 THEN
      tmp2% = INSTR(blast$, "D")
      dma% = VAL(MID$(blast$, tmp2% + 1))        'dma% is a global variable
      IF dma% < 0 OR dma% > 7 THEN tmp% = -2
   END IF
END IF
GetBlasterAddr% = tmp%
END FUNCTION

'------------------------------------------------------------------------------
SUB PlayBack (buffer$, size%, freq&, BytesPerSec&, chans%, num%)
size% = size% - 1
segment& = VARSEG(buffer$)
offset& = SADD(buffer$)
IF segment& < 0 THEN segment& = segment& + 65536
IF offset& < 0 THEN offset& = offset& + 65536
baseaddr& = segment& * 16 + offset&
look1% = VARPTR(baseaddr&)
look2% = VARPTR(size%)
SELECT CASE dma%
   CASE 0
      dmapage% = &H87   '135 decimal
      dmaaddr% = 0
      dmalen% = 1
   CASE 1
      dmapage% = &H83   '131 decimal
      dmaaddr% = 2
      dmalen% = 3
   CASE 2
      dmapage% = &H81
      dmaaddr% = 4
      dmalen% = 5
   CASE 3
      dmapage% = &H82
      dmaaddr% = 6
      dmalen% = 7
   CASE 4
      dmapage% = &H8F
      dmaaddr% = &HC0
      dmalen% = &HC2
   CASE 5
      dmapage% = &H8B
      dmaaddr% = &HC4
      dmalen% = &HC6
   CASE 6
      dmapage% = &H89
      dmaaddr% = &HC8
      dmalen% = &HCA
   CASE 7
      dmapage% = &H8A
      dmaaddr% = &HCC
      dmalen% = &HCE
END SELECT
SELECT CASE dma%
   CASE 0 TO 3
      dmamask% = &HA
      dmamode% = &HB
      dmaclear% = &HC
      dmastatus% = &H8
   CASE 4 TO 7
      dmamask% = &HD4
      dmamode% = &HD6
      dmaclear% = &HD8
      dmastatus% = &HD0
END SELECT
SELECT CASE dma%
   CASE 0, 4
      dmaterminal% = 1   'bit 0 of status register (&H08 or &HD0)
   CASE 1, 5
      dmaterminal% = 2   'bit 1
   CASE 2, 6
      dmaterminal% = 4   'bit 2
   CASE 3, 7
      dmaterminal% = 8   'bit 3
END SELECT

OUT dmamask%, dma% + 4   'mask the dma channel
OUT dmaclear%, &H0       '(clear the internal DMA flip/flop)
OUT dmamode%, 72 + dma%  '  72=010010XX where XX=dmachannel%
OUT dmaaddr%, PEEK(look1%)      'bits 0-7 of  the 20bit address
OUT dmaaddr%, PEEK(look1% + 1)  'bits 8-15 of the 20bit address
OUT dmapage%, PEEK(look1% + 2)  'bits 16-19 of the 20 bit address
OUT dmalen%, PEEK(look2%)       'bits 0-7 of size%
OUT dmalen%, PEEK(look2% + 1)   'bits 8-15  of size%
OUT dmamask%, dma%              'enable channel

IF num% = 1 THEN  'only need to Write out time constant once
   timeconst% = 256 - 1000000 / (freq& * chans%)
   CALL WriteToDSP(&H40)
   CALL WriteToDSP(timeconst%)
   'Reset Mixer    DSPmixeraddress = Blasteraddr% + &H4
   OUT BlasterAddr% + &H4, &H0
   OUT BlasterAddr% + &H4 + 1, 0
   'Set Volume to Maximum...255
   OUT BlasterAddr% + &H4, &H22
   OUT BlasterAddr% + &H4 + 1, 255
   IF chans% = 2 THEN
      'Set mixer to Stereo Output
      OUT BlasterAddr% + &H4, &HE
      OUT BlasterAddr% + &H4 + 1, 34      '34=2^5+2^1
   END IF
END IF
IF BytesPerSec& > 22000 THEN
   CALL WriteToDSP(&H48)   'Set Block Size
ELSE
   CALL WriteToDSP(&H14)   'DMA Mode 8-bit DAC
END IF
CALL WriteToDSP(PEEK(look2%))      'Lo byte of address
CALL WriteToDSP(PEEK(look2% + 1))  'High byte of address
IF BytesPerSec& > 22000 THEN CALL WriteToDSP(&H91)  'High Speed DMA mode 8-bit
dummy% = INP(dmastatus%)    'Read status byte once to make sure DMA is going.
WAIT dmastatus%, dmaterminal%   'Loop until terminal count bit set in DMA status register
'DMA Transfer is Now Complete
'Acknowledge the DSP interrupt by reading the DATA AVAILABLE port once
dummy% = INP(BlasterAddr% + &HE)    'DSP Available address
END SUB

DEFSNG A-Z
SUB PlayWav (wavefile$)


repeats% = 1
BlasterAddr% = GetBlasterAddr%
SELECT CASE BlasterAddr%
   CASE -2
      PRINT "Bad DMA Channel specified!"
      END
   CASE -1
      PRINT "No Port Base Address Given!"
      END
   CASE 0
      PRINT "No BLASTER Environment Variable Set!"
      END
   CASE ELSE
      'Assume a valid Address Exists
'      PRINT "Blaster Address = "; HEX$(BlasterAddr%)
END SELECT
IF NOT SBreset% THEN
   PRINT "SoundBlaster Card Would Not Reset!"
   END
END IF

sp% = INSTR(Spec$, " ")
IF sp% THEN
   wavefile$ = LEFT$(Spec$, sp% - 1)
   repeats% = VAL(RIGHT$(Spec$, LEN(Spec$) - sp%))
   IF repeats% = 0 THEN repeats% = 1
ELSE
   IF LEN(Spec$) THEN
      wavefile$ = Spec$
      repeats% = 1
   END IF
END IF

IF LEN(wavefile$) = 0 THEN
END IF
'wavefile$ = "C:\QBASIC\THEME.WAV"
CALL ValidWavHeader(wavefile$, LenHeader%, WavLen&, Channels%, Sampling&, bytes&, ok%)

IF NOT ok% THEN
   PRINT "Bad Wave File Format"
   END
END IF

MaxBuffer% = 7053

CALL WriteToDSP(&HD1)  'Speaker ON
FOR repeat% = 1 TO repeats%    'This can loop to play the file ii% times]
filenum% = FREEFILE
   OPEN wavefile$ FOR BINARY AS filenum%
      num% = 0
      SEEK filenum%, LenHeader% + 1
      Remaining& = WavLen&
      DO
         num% = num% + 1
         IF Remaining& > MaxBuffer% THEN
            BufferLen% = MaxBuffer%
         ELSE
            BufferLen% = Remaining&
         END IF
         Remaining& = Remaining& - BufferLen%
         buffer$ = SPACE$(BufferLen%)
         GET filenum%, , buffer$
         CALL PlayBack(buffer$, BufferLen%, Sampling&, bytes&, Channels%, num%)
      LOOP WHILE Remaining& > 0
      OUT &H20, &H20   'Reset Normal Interrupt Service
   CLOSE filenum%
NEXT repeat%
CALL WriteToDSP(&HD3)  'Speaker OFF

END SUB

DEFINT A-Z
'------------------------------------------------------------------------------
FUNCTION SBreset%
'DSPreset% = address% + &H6
'DSPread% = address% + &HA
'DSPwrite% = address% + &HC
'DSPavail% = address% + &HE
'DSPmixer% = address% + &H4
OUT BlasterAddr% + &H6, 1   'Reset address
delay .1
OUT BlasterAddr% + &H6, 0
time1! = TIMER: noreset% = 0
DO
   'Read Data Available port until bit 7 is set
   'This should take about 100 micro seconds...give it 1 full second
   IF TIMER - time1! > 1! THEN noreset% = -1
LOOP UNTIL ((INP(BlasterAddr% + &HE) AND 128) = 128) OR noreset%
IF NOT noreset% THEN
   IF INP(BlasterAddr% + &HA) = &HAA THEN
      SBreset% = -1
   ELSE
      SBreset% = 0
   END IF
ELSE
   SBreset% = 0
END IF
END FUNCTION

'------------------------------------------------------------------------------
SUB ValidWavHeader (FILE$, LenHeader%, dataLen&, nChannels%, nSamplesPerSec&, nAvgBytesPerSec&, ok%)
rID$ = SPACE$(4)
wID$ = SPACE$(4)
fID$ = SPACE$(4)
dat$ = SPACE$(4)
dummy$ = SPACE$(1)

filenum% = FREEFILE
OPEN FILE$ FOR BINARY AS filenum%
  GET filenum%, , rID$
  GET filenum%, , rLen&
  GET filenum%, , wID$
  GET filenum%, , fID$
  GET filenum%, , fLen&
  GET filenum%, , wFormatTag%       '2 bytes
  GET filenum%, , nChannels%        '2 bytes
  GET filenum%, , nSamplesPerSec&   '4 bytes
  GET filenum%, , nAvgBytesPerSec&  '4 bytes
  GET filenum%, , nBlockAlign%      '2 bytes
  GET filenum%, , FormatSpecific%   '2 bytes
  'Read bytes until have read fLen& total bytes.
  'I have no idea what these next bytes are used for (if they even exist).
  FOR i% = 1 TO fLen& - 16          '16 bytes is what we have read in so far
     GET filenum%, , dummy$         'read in 1 byte at a time
  NEXT i%
  GET filenum%, , dat$
  IF UCASE$(dat$) = "FACT" THEN
     'funny format...
     GET filenum%, , dummy&
     GET filenum%, , dummy&
     GET filenum%, , dat$
  END IF
  GET filenum%, , dataLen&
  LenHeader% = LOC(1)
CLOSE filenum%
'  PRINT rID$;
'  PRINT rLen&;
'  PRINT wID$;
'  PRINT fID$;
'  PRINT fLen&;
'  PRINT wFormatTag%;       '2 bytes
'  PRINT nChannels%;        '2 bytes
'  PRINT nSamplesPerSec&;   '4 bytes
'  PRINT nAvgBytesPerSec&;  '4 bytes
'  PRINT nBlockAlign%;      '2 bytes
'  PRINT FormatSpecific%;   '2 bytes
'  PRINT dat$;
'  PRINT dataLen&;
'  PRINT LenHeader%
IF UCASE$(rID$) = "RIFF" THEN
   IF UCASE$(wID$) = "WAVE" THEN
      IF UCASE$(dat$) = "DATA" THEN
         IF UCASE$(fID$) = "FMT " THEN
           IF FormatSpecific% = 8 THEN ok% = -1
         END IF
      END IF
   END IF
END IF
END SUB

'------------------------------------------------------------------------------
SUB WriteToDSP (v%)
OUT BlasterAddr% + &HC, v%
END SUB

