VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "DirectSound for QuickBasic Slave Module"
   ClientHeight    =   2295
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5310
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2295
   ScaleWidth      =   5310
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer tmrBass 
      Interval        =   500
      Left            =   4920
      Top             =   0
   End
   Begin VB.PictureBox Picture1 
      Align           =   1  'Align Top
      Height          =   2295
      Left            =   0
      Picture         =   "frmMain.frx":08CA
      ScaleHeight     =   149
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   350
      TabIndex        =   0
      Top             =   0
      Width           =   5310
      Begin VB.Label CDlabel 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         ForeColor       =   &H00FFFFFF&
         Height          =   495
         Left            =   4320
         TabIndex        =   2
         Top             =   840
         Width           =   615
      End
      Begin VB.Label AudioLabel 
         Alignment       =   2  'Center
         BackStyle       =   0  'Transparent
         ForeColor       =   &H00FFFFFF&
         Height          =   495
         Left            =   240
         TabIndex        =   1
         Top             =   840
         Width           =   615
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'DS4QB Slave Form Sourcecode
'Principle coders: Adam Hoult, Dave Perry, Jon Gilbert
'Additional assistance: NetherGoth, ^DaRk^
'See 'DirectSound for QB.txt' for a full credits list

Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)
Private Declare Sub vbOut Lib "WIN95IO.DLL" (ByVal nPort As Integer, ByVal nData As Integer)
Private Declare Function vbInp Lib "WIN95IO.DLL" (ByVal nPort As Integer) As Integer

Dim STRM As Long
Dim StreamFilename As String
Dim SampleFilename As String
Dim SamplePointer As Integer
Dim SampleScript As String
Dim SampleHandle(1 To 255) As Long
Dim SampleSlot As Integer
Dim CDenabled As Integer
Dim AudioEnabled As Integer
Dim PlayFlag As Integer
Dim FileToLoad As String
Dim ModHandle As Long
Dim CDPlaying As Boolean
Dim IncomingData As Integer

Private Sub cmdCDResume_Click()
' Resume CD
If BASS_ChannelResume(CDCHANNEL) = True Then CDPlaying = True
SitOnClipboard
End Sub

Private Sub cmdCDStop_Click()
' Pause CD
BASS_ChannelPause CDCHANNEL
CDPlaying = False
SitOnClipboard
End Sub

Private Sub cmdMusicAdd_Click()
BASS_MusicFree ModHandle
ModHandle = BASS_MusicLoad(BASSFALSE, FileToLoad, 0, 0, BASS_MUSIC_RAMP + PlayFlag)
If ModHandle = 0 Then
   msgList.AddItem "Module load request denied"
   ThrowError "Can't Load Music"
End If
'play the selected song.
Do
If BASS_MusicPlay(ModHandle) = BASSFALSE Then Exit Do
Loop Until BASS_ChannelIsActive(ModHandle) = BASSTRUE
SitOnClipboard
End Sub

Private Sub cmdMusicRemove_Click()
On Local Error Resume Next
BASS_MusicFree ModHandle
SitOnClipboard
End Sub

Private Sub cmdMusicRestart_Click()
On Error GoTo E_Out
' Play the music from the start
BASS_MusicPlayEx ModHandle, 0, -1, BASSTRUE
E_Out:
SitOnClipboard
End Sub

Private Sub cmdMusicStop_Click()
On Local Error Resume Next
If BASS_ChannelStop(ModHandle) = BASSFALSE Then ThrowError "Can't stop Music"
SitOnClipboard
End Sub

Private Sub cmdResumeAll_Click()
If CDPlaying = True Then BASS_ChannelResume CDCHANNEL
BASS_Start
SitOnClipboard
End Sub

Private Sub cmdSampleAdd_Click()
'This is prolly the most complex part of the whole slave module...
'Loads a script which contains the names of all the sample files
SamplePointer = 1
fh = FreeFile
Open SampleScript For Input As #fh
If Err Then
 Exit Sub
End If
Do
Input #fh, SampleFilename
SampleHandle(SamplePointer) = BASS_SampleLoad(BASSFALSE, SampleFilename, 0, 0, 3, BASS_SAMPLE_OVER_POS)
If SampleHandle(SamplePointer) = 0 Then
    ThrowError "Can't Load Sample"
End If
SamplePointer = SamplePointer + 1
Loop Until EOF(fh) Or SamplePointer = 255
Close fh
SitOnClipboard
End Sub

Private Sub PlaySampleNow()
If BASS_SamplePlayEx(SampleHandle(SampleSlot), 0, -1, 50, Int((201 * Rnd) - 100), BASSFALSE) = BASSFALSE Then ThrowError "Can't play sample"
'add two 0s to the DMA buffer to clear it out
vbOut &H0, 0
vbOut &H0, 0
SitOnClipboard
End Sub

Private Sub cmdSampleRemove_Click()
For SampleSlot = 0 To SamplePointer
  BASS_SampleFree SampleHandle(SampleSlot)
Next SampleSlot
SitOnClipboard
End Sub

Private Sub cmdStopAll_Click()
' Pause digital output and CD
BASS_Pause
BASS_ChannelPause CDCHANNEL
SitOnClipboard
End Sub

Private Sub cmdStreamNew_Click()
On Error Resume Next
BASS_StreamFree STRM
Dim StreamHandle As Long
StreamHandle = BASS_StreamCreateFile(BASSFALSE, StreamFilename, 0, 0, 0)
If StreamHandle = 0 Then
    ThrowError "Can't create stream"
Else
    STRM = StreamHandle
End If
'Play stream, not flushed
Do
If BASS_StreamPlay(STRM, BASSFALSE, PlayFlag) = BASSFALSE Then Exit Do
Loop Until BASS_ChannelIsActive(StreamHandle) = BASSTRUE
SitOnClipboard
End Sub

Private Sub cmdStreamStop_Click()
' Stop the stream
BASS_ChannelStop STRM
SitOnClipboard
End Sub

Private Sub Form_Load()
If App.PrevInstance = True Then End
'clear DMA buffer
vbOut &H0, 0
vbOut &H0, 0
CDenabled = 1
AudioEnabled = 1
' Check that BASS 0.8 was loaded
If BASS_GetStringVersion <> "0.8" Then
  CDenabled = 0
  AudioEnabled = 0
  Exit Sub
End If
' Initialize digital sound - default device, 44100hz, stereo, 16 bits
If BASS_Init(-1, 44100, 0, Me.hWnd) = BASSFALSE Then
  CDenabled = 0
  AudioEnabled = 0
  Exit Sub
End If
' Initialize CD
If BASS_CDInit(Nothing) = BASSFALSE Then
  CDenabled = 0
End If
' Start digital output
If BASS_Start = BASSFALSE Then
 AudioEnabled = 0
End If
'Set the labels
If AudioEnabled = 1 Then AudioLabel.Caption = "Audio Enabled"
If CDenabled = 1 Then CDlabel.Caption = "CD Enabled"
End Sub

Sub ThrowError(Message As String)
Dim ErrorNum As Long
ErrorNum = BASS_ErrorGetCode
SitOnClipboard
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
BASS_Stop
BASS_StreamFree STRM
BASS_MusicFree ModHandle
BASS_Free
BASS_CDFree
End
End Sub

Private Sub SitOnClipboard()
callbackloop:
On Local Error Resume Next
instring$ = ""
Do
 'Sleep 50
 DoEvents
 'give the sfx input higher priority due to the latency of the clipboard
 SampleSlot = vbInp(&H0)
 If SampleSlot > 0 Then PlaySampleNow
 If instring$ <> Clipboard.GetText Then Exit Do
Loop
instring$ = Clipboard.GetText
Clipboard.Clear
Err.Clear
If InStr(instring$, "DS4QB") = 0 Then
  tmrBass.Enabled = True
  Exit Sub
End If
starter% = InStr(instring$, "DS4QB") + 5
If InStr(instring$, "LOADMOD") <> 0 Then
  starter% = starter% + 7
  finalstring$ = Right$(instring$, Len(instring$) - (starter% - 1))
  finisher% = InStr(finalstring$, "|")
  FileToLoad = Left$(finalstring$, finisher% - 1)
  checkflag$ = Mid$(finalstring$, finisher% + 1, 1)
  If checkflag$ = "0" Then PlayFlag = 0 Else PlayFlag = BASS_MUSIC_LOOP
  cmdMusicAdd_Click
End If
If InStr(instring$, "REMOVEMOD") <> 0 Then
  cmdMusicRemove_Click
End If
If InStr(instring$, "LOADSTREAM") <> 0 Then
  starter% = starter% + 10
  finalstring$ = Right$(instring$, Len(instring$) - (starter% - 1))
  finisher% = InStr(finalstring$, "|")
  StreamFilename = Left$(finalstring$, finisher% - 1)
  checkflag$ = Mid$(finalstring$, finisher% + 1, 1)
  If checkflag$ = "0" Then PlayFlag = 0 Else PlayFlag = BASS_SAMPLE_LOOP
  cmdStreamNew_Click
End If
If InStr(instring$, "REMOVESTREAM") <> 0 Then
  cmdStreamStop_Click
End If
If InStr(instring$, "LOADSAMPLES") <> 0 Then
  starter% = starter% + 11
  finalstring$ = Right$(instring$, Len(instring$) - (starter% - 1))
  finisher% = InStr(finalstring$, "|")
  SampleScript = Left$(finalstring$, finisher% - 1)
  cmdSampleAdd_Click
End If
If InStr(instring$, "PLAYCD") <> 0 Then
  starter% = starter% + 6
  finalstring$ = Right$(instring$, Len(instring$) - (starter% - 1))
  finisher% = InStr(finalstring$, "|")
  trackname = Val(Left$(finalstring$, finisher% - 1))
  checkflag = Val(Mid$(finalstring$, finisher% + 1, 1))
  result = BASS_CDPlay(trackname, checkflag, 0)
End If
If InStr(instring$, "REMOVESAMPLES") <> 0 Then
  cmdSampleRemove_Click
End If
If InStr(instring$, "SHUTDOWN") <> 0 Then
  End
End If
GoTo callbackloop
End Sub

Private Sub tmrBass_Timer()
tmrBass.Enabled = False
SitOnClipboard
End Sub
