
' FONT SYSTEM
DECLARE SUB clocate (tempx, tempy)
DECLARE SUB textcolor (tempcol)
DECLARE SUB loadfont (fontname$)
DECLARE SUB cprint (ltext$)
DECLARE SUB centerprint (ctx, cty, ltext$, ctsx)
DECLARE FUNCTION tlen (ltext$)
DECLARE FUNCTION clen (char$)
DECLARE FUNCTION inputg$ (x5, y5, textlen, fcol, BCOL)

' PICTURE LOADING SYSTEM
DECLARE SUB LOADPAK (FLNAME$, px!, py!, ID$)
DECLARE SUB LOADPIC (FLNAME$, px!, py!)
DECLARE SUB showbmp (bmpname$, bmpx, bmpy)

' GRAPHICS MANIPULATION
DECLARE SUB SHIFTLR (X11, Y11, SX11, SY11, WAY)
DECLARE SUB SHIFTUD (X11, Y11, SX11, SY11, WAY)
DECLARE FUNCTION getpal$ (num!)
DECLARE SUB SETPAL (num, red, green, blue)
DECLARE SUB SETPAL2 (num, rgb$)
DECLARE SUB copypal (num1, num2)
DECLARE FUNCTION getpal$ (num)

' OTHERS
DECLARE SUB DELAY (num)
DECLARE FUNCTION TRIMNUM$ (value!)

' MIDI
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE FUNCTION GetSynth% ()
DECLARE SUB LOADMIDI (Filename$)
DECLARE SUB LoopMIDI ()
DECLARE FUNCTION MIDIError$ ()
DECLARE FUNCTION MusicDone% ()
DECLARE SUB PauseMIDI ()
DECLARE SUB ResumeMIDI ()
DECLARE SUB PLAYMIDI ()
DECLARE SUB stopmidi ()
DECLARE FUNCTION TimeMIDI! ()
DECLARE SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
DECLARE SUB IntX (IntNum AS INTEGER, Regs AS ANY)
REM ************************************************
REM **** SHARED DBZ ROUTINES                    ****
REM ************************************************


TYPE Registers
	 AX    AS INTEGER
	 BX    AS INTEGER
	 CX    AS INTEGER
	 DX    AS INTEGER
	 BP    AS INTEGER
	 SI    AS INTEGER
	 DI    AS INTEGER
	 FLAGS AS INTEGER
	 DS    AS INTEGER
	 ES    AS INTEGER
END TYPE
REM *** GLOBAL FONT-ATTRIBUTES ***
COMMON SHARED maxclen, charhigh, BOLD, textcol, currentx, currenty, vspace
COMMON SHARED QMIDIRegs AS Registers, MEM.SEGMENT AS INTEGER
COMMON SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER, PAUSED AS SINGLE
COMMON SHARED SBMIDI.INTERRUPT AS INTEGER, MEM.ALLOCATED AS LONG
COMMON SHARED SBSIM.INTERRUPT AS INTEGER
COMMON SHARED SENSITIVE AS INTEGER, REVERSE.STEREO AS INTEGER
COMMON SHARED SOUND.DISABLED AS INTEGER
DIM SHARED fontdata$(95), starty(95), CHARLEN(95)

IntXCodeData:
DATA  &H55, &H8B, &HEC, &H83, &HEC, &H08, &H56, &H57, &H1E, &H55, &H8B, &H5E
DATA  &H06, &H8B, &H47, &H10, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H10, &H8B, &H47, &H12, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H12, &H8B, &H47, &H08, &H89, &H46, &HF8, &H8B, &H07, &H8B, &H4F, &H04
DATA  &H8B, &H57, &H06, &H8B, &H77, &H0A, &H8B, &H7F, &H0C, &HFF, &H77, &H12
DATA  &H07, &HFF, &H77, &H02, &H1E, &H8F, &H46, &HFA, &HFF, &H77, &H10, &H1F
DATA  &H8B, &H6E, &HF8, &H5B, &HCD, &H21, &H55, &H8B, &HEC, &H8B, &H6E, &H02
DATA  &H89, &H5E, &HFC, &H8B, &H5E, &H06, &H1E, &H8F, &H46, &HFE, &HFF, &H76
DATA  &HFA, &H1F, &H89, &H07, &H8B, &H46, &HFC, &H89, &H47, &H02, &H89, &H4F
DATA  &H04, &H89, &H57, &H06, &H58, &H89, &H47, &H08, &H89, &H77, &H0A, &H89
DATA  &H7F, &H0C, &H9C, &H8F, &H47, &H0E, &H06, &H8F, &H47, &H12, &H8B, &H46
DATA  &HFE, &H89, &H47, &H10, &H5A, &H1F, &H5F, &H5E, &H8B, &HE5, &H5D, &HCA
DATA  &H02, &H00

SUB centerprint (ctx, cty, ltext$, ctsx)
REM *****************************************
REM **** Centers and print the font      ****
REM *****************************************
DIM tempx

tempx = CINT((ctsx - tlen(ltext$)) / 2)
currentx = ctx + tempx
currenty = cty
cprint ltext$


END SUB

FUNCTION clen (char$)
REM ****** RETURN THE LENGTH OF A CHARACTER ******
clen = CHARLEN(ASC(char$) - 32)

END FUNCTION

SUB clocate (tempx, tempy)
currentx = tempx
currenty = tempy
END SUB

SUB copypal (num1, num2)
REM **** COPY PALETTE ****
' GET PALETTE COLOR
OUT &H3C7, num1
red = INP(&H3C9)
green = INP(&H3C9)
blue = INP(&H3C9)
num3 = 65536 * blue + 256 * green + red
' COPY TO num2
PALETTE num2, num3

END SUB

SUB cprint (ltext$)

REM **************************************************
REM **** DISPLAY OUT THE TEXT USING LOADED FONTS  ****
REM **************************************************
GX = 0

FOR G1 = 1 TO LEN(ltext$)
	c$ = MID$(ltext$, G1, 1)
	G2 = ASC(c$) - 32
	IF c$ = "&" THEN
			 c$ = MID$(ltext$, G1 + 1, 1)
			 LINE (currentx + GX, currenty - 1 + charhigh)-STEP(CHARLEN(ASC(c$) - 32) - 1 + BOLD, 0), textcol
			 g3 = -1
		ELSEIF c$ <> " " THEN
			g3 = CHARLEN(G2) + BOLD
			PSET (currentx + GX, currenty - 1 + starty(G2)), textcol: DRAW fontdata$(G2)
			IF BOLD > 0 THEN PSET (currentx + GX + 1, currenty - 1 + starty(G2)), textcol: DRAW fontdata$(G2)
		  ELSE
			g3 = 6 + BOLD
	END IF
	GX = CINT(GX + g3 + 1)
NEXT

currenty = currenty + charhigh + vspace


END SUB

SUB DELAY (num)
FOR g51 = 0 TO 70 * num
	 WAIT &H3DA, 8
	 WAIT &H3DA, 8, 8
NEXT g51
END SUB

REM $DYNAMIC
'DriversLoaded - Attempt to detect if sound drivers are loaded
SUB DriversLoaded (SBMIDI%, SBSIM%)
'Open the data file.
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
FileSize& = LOF(FF%)
NoExist% = 0
'If the file is empty, return an error.
IF FileSize& = 0 THEN
	CLOSE FF%
	KILL "DRIVERS.DAT"
	MIDI.ERROR = 1
	NoExist% = 1
'If the file is not exactly 1,024 bytes in size, return an error.
ELSEIF FileSize& <> 1024 THEN
	CLOSE FF%
	MIDI.ERROR = 9
	NoExist% = 1
END IF

'If DRIVERS.DAT exists, and is 1 kilobyte in size, read the driver
'data from it.
IF NoExist% = 0 THEN
REDIM DRIVERDATA$(1 TO 5)
FOR I% = 1 TO 4
	DRIVERDATA$(I%) = INPUT$(256, #FF%)
NEXT I%
END IF

'Close the data file.
CLOSE #FF%

'Check the interrupt handlers for int 80h-FFh, to see if they are occupied
'by either SBMIDI or SBSIM.
SBMIDI% = 0
SBSIM% = 0
FOR I% = &H80 TO &HFF
	'Get the address of the interrupt handler.
	InternalGetIntVector I%, Segment&, Offset&
	'If the segment returned is 0, that means that the current interrupt
	'is not in use.
	IF Segment& = 0 THEN GOTO Skip:

	'The following code checks for the drivers by looking for the text
	'"SBMIDI" and "SBSIM" at certain locations in the driver code.
	'If it doesn't work, a different method is used.
	IF SBMIDI% = 0 THEN
	  DEF SEG = Segment& - 17
	  TEMP$ = ""
	  FOR J% = 1 TO 6
		TEMP$ = TEMP$ + CHR$(PEEK(271 + J%))
	  NEXT
	  IF TEMP$ = "SBMIDI" THEN SBMIDI% = I%
	END IF
	IF SBSIM% = 0 AND Segment& <> 0 THEN
		DEF SEG = Segment& - 1
		TEMP$ = ""
		FOR J% = 1 TO 5
			TEMP$ = TEMP$ + CHR$(PEEK(274 + J%))
		NEXT
		IF TEMP$ = "SBSIM" THEN SBSIM% = I%
	END IF
 
	'This is the second detection method.  It's more complex than the first
	'method, but not really any more accurate.
	IF NoExist% = 0 THEN
	'Point to the segment of the interrupt handler.
	DEF SEG = Segment&
	'Read 256 bytes of code from the interrupt handler.
	DRIVERDATA$(5) = ""
	FOR J% = 0 TO 255
		Byte% = PEEK(Offset& + J%)
		DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(Byte%)
	NEXT J%
	'Check to see if the code matches any of the data from DRIVERS.DAT.
	FOR J% = 1 TO 4
		MATCH% = 1
		FOR k% = 0 TO 255
			IF MID$(DRIVERDATA$(J%), k% + 1, 1) <> MID$(DRIVERDATA$(5), k% + 1, 1) THEN
				SELECT CASE k%
					CASE IS = 14, 15, 113, 114, 235, 236
					CASE ELSE
						MATCH% = 0
						EXIT FOR
				END SELECT
			END IF
		NEXT k%
		'If there was a match, find out which driver is using the interrupt.
		IF MATCH% THEN
			IF J% = 1 THEN SBSIM% = I%
			IF J% <> 1 THEN SBMIDI% = I%
		END IF
		'If both SBMIDI and SBSIM have been found, exit the loop.
		IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	NEXT J%
   
	'If both SBMIDI and SBSIM have been found, exit the loop.
	IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	END IF
Skip:
NEXT I%
IF NoExist% = 0 THEN MIDI.ERROR = 0
END SUB

REM $STATIC
SUB FLASH (fcolor, tcolor, dur)
REM *** FLASH A COLOR ***
copypal fcolor, 241
copypal tcolor, fcolor
DELAY dur
copypal 241, fcolor


END SUB

FUNCTION getpal$ (num)
REM *** GET PALETTE COLOR ****
OUT &H3C7, num
red = INP(&H3C9)
green = INP(&H3C9)
blue = INP(&H3C9)
getpal$ = CHR$(red) + CHR$(green) + CHR$(blue)

END FUNCTION

FUNCTION GetSynth%
QMIDIRegs.BX = 10
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
GetSynth% = QMIDIRegs.AX
END FUNCTION

FUNCTION inputg$ (x5, y5, textlen, fcol, BCOL)
REM *****************************************************
REM *** KINDA LIKE INPUT STATEMENT...JUST MORE FLEXIBLE!
REM *****************************************************
DIM text$, cpos, X6

text$ = TEXTBUFFER$: cpos = 1: X6 = 0
LINE (x5, y5)-STEP(textlen * (maxclen + BOLD) + 5, charhigh), BCOL, BF
REM **** APPEND TO PREVIOUS INPUT ****
IF text$ <> "" THEN
	X6 = tlen(TEXTBUFFER$) + 1
	cpos = LEN(text$) + 1
	textcol = fcol
	clocate x5 + 1, y5 + 1: cprint text$
END IF

LINE (x5 + X6 + 1, y5)-STEP(0, charhigh), fcol, B


textcol = fcol
DO UNTIL F$ = CHR$(27) OR F$ = CHR$(13)
	TEXTBUFFER$ = text$
	F$ = INPUT$(1)
	IF F$ = "" OR F$ = "&" THEN F$ = CHR$(255)
  
	' Enter the font
	IF ASC(F$) >= 32 AND ASC(F$) <= 127 AND cpos <= textlen THEN
		LINE (x5 + X6 + 1, y5)-STEP(0, charhigh), BCOL, B
		text$ = text$ + F$
		cpos = cpos + 1
		IF F$ <> " " THEN
			clocate x5 + X6 + 1, y5 + 1
			cprint F$
		END IF

		X6 = X6 + CHARLEN(ASC(F$) - 32) + 1 + BOLD
		LINE (x5 + X6 + 1, y5)-STEP(0, charhigh), fcol, B
	END IF

	' Backspace
	IF F$ = CHR$(8) AND cpos > 1 THEN
		LINE (x5 + X6 + 1, y5)-STEP(0, charhigh), BCOL, B
		cpos = cpos - 1
		g22 = CHARLEN(ASC(RIGHT$(text$, 1)) - 32) + 1 + BOLD
		X6 = X6 - g22
		LINE (x5 + X6 + 1, y5)-STEP(g22 - 1, charhigh), BCOL, BF
		LINE (x5 + X6 + 1, y5)-STEP(0, charhigh), fcol, B
		text$ = LEFT$(text$, LEN(text$) - 1)
	END IF

	' Trap user preferred keys
	IF INSTR(1, keytrap$, F$) THEN text$ = "": EXIT DO
LOOP

IF F$ = CHR$(27) THEN text$ = ""
IF text$ = "" THEN inputg$ = F$ ELSE inputg$ = RTRIM$(text$)

END FUNCTION

REM $DYNAMIC
SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
QMIDIRegs.AX = IntNum% + 13568
CALL IntX(&H21, QMIDIRegs)
Segment& = QMIDIRegs.ES
Offset& = QMIDIRegs.BX
END SUB

REM $STATIC
SUB IntX (IntNum AS INTEGER, Regs AS Registers) STATIC

STATIC filenum AS INTEGER, IntOffset AS INTEGER, Loaded AS INTEGER
		   
	' use fixed-length string to fix its position in memory
	' and so we don't mess up string pool before routine
	' gets its pointers from caller

DIM IntCode AS STRING * 200
IF NOT Loaded THEN                     ' loaded will be 0 first time
	RESTORE IntXCodeData:
   
	FOR k% = 1 TO 145
		READ h%
		MID$(IntCode, k%, 1) = CHR$(h%)
	NEXT

	'  determine address of interrupt no. offset in IntCode
  
	IntOffset% = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1
	Loaded% = -1
END IF

SELECT CASE IntNum
  
	CASE &H25, &H26, IS > 255               ' ignore these interrupts
  
	CASE ELSE
		DEF SEG = VARSEG(IntCode)             ' poke interrupt number into
		POKE VARPTR(IntCode) * 1& + IntOffset - 1, IntNum     ' code block
		CALL ABSOLUTE(Regs, VARPTR(IntCode$))               ' call routine
END SELECT

END SUB

SUB loadfont (fontname$)

REM **************************************
REM *** START LOADING THE FILE!       ****
REM **************************************
DIM text$

OPEN "I", #1, fontname$ + ".FNT"

' Load dummy header
LINE INPUT #1, text$
LINE INPUT #1, text$

' Load Character height
LINE INPUT #1, text$
text$ = RTRIM$(text$)
charhigh = VAL(text$)

' Load Font-data
gy = 1
maxclen = 0
CHARLEN(0) = 5
vspace = 2

LINE INPUT #1, text$
text$ = RTRIM$(text$)
DO UNTIL text$ = "[END]" OR EOF(1)
	fontdata$(gy) = RIGHT$(text$, LEN(text$) - 2)
	CHARLEN(gy) = ASC(LEFT$(text$, 1)) - 64
	IF CHARLEN(gy) > maxclen THEN maxclen = CHARLEN(gy)
	starty(gy) = ASC(MID$(text$, 2, 1)) - 64
	gy = gy + 1
	LINE INPUT #1, text$
	text$ = RTRIM$(text$)
LOOP
CLOSE #1


END SUB

REM $DYNAMIC
'LoadMIDI - loads a MIDI file into memory
SUB LOADMIDI (Filename$)
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL Filename$: MIDI.ERROR = 1: EXIT SUB
'Make the filename an ASCIIZ string.
Filename$ = Filename$ + CHR$(0)

'Attempt to allocate a block of conventional memory.
QMIDIRegs.AX = &H4800
QMIDIRegs.BX = (FileLen& \ 16) + 1
CALL IntX(&H21, QMIDIRegs)
'If the block couldn't be allocated, it means there's not enough free
'memory.  To fix this, we need to ask BASIC to release some of the memory
'it's using:
IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
	'Find out how much memory is available, in kilobytes.
	LargestBlock& = QMIDIRegs.BX
	LargestBlock& = LargestBlock& * 16
	'Calculate the amount of memory that BASIC needs to release for us.
	MEM.ALLOCATED = (FileLen& + 2048) - LargestBlock&
	'Attempt to release the memory.
	a& = SETMEM(-MEM.ALLOCATED)
	'Try again to allocate a block of memory
	QMIDIRegs.AX = &H4800
	QMIDIRegs.BX = (FileLen& \ 16) + 1
	CALL IntX(&H21, QMIDIRegs)
	'If the second attempt was unsuccessful, then there just isn't
	'enough memory, and an error needs to be returned.
	IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
		'Give any memory we took back to BASIC.
		a& = SETMEM(MEM.ALLOCATED)
		'Return an error.
		MIDI.ERROR = 2
		MEM.SEGMENT = 0
		'Abort.
		EXIT SUB
	END IF
END IF
'If the memory was allocated successfully, store the segment
'of the memory block.
MEM.SEGMENT = QMIDIRegs.AX
MIDISegment& = QMIDIRegs.AX

'Open the MIDI file using a DOS interrupt.
QMIDIRegs.AX = &H3D00
QMIDIRegs.DX = SADD(Filename$)
QMIDIRegs.DS = VARSEG(Filename$)
CALL IntX(&H21, QMIDIRegs)
'Store the file handle.
Handle% = QMIDIRegs.AX
'Read the data from the file in 16 kilobyte increments.
FOR I& = 1 TO FileLen& STEP 16384
	QMIDIRegs.AX = &H3F00
	QMIDIRegs.CX = 16384
	QMIDIRegs.DX = 0
	QMIDIRegs.DS = VAL("&H" + HEX$(MIDISegment&))
	QMIDIRegs.BX = Handle%
	CALL IntX(&H21, QMIDIRegs)
	MIDISegment& = MIDISegment& + 1024
NEXT I&

'Close the file
QMIDIRegs.AX = &H3E00
QMIDIRegs.BX = Handle%
CALL IntX(&H21, QMIDIRegs)

MIDI.ERROR = 0
END SUB

REM $STATIC
SUB LOADPAK (FLNAME$, px, py, ID$)
REM **** LOAD TXT IMAGE FROM IMAGE PAK ***
DIM INAME$, ID2$, IPATH$, g44

ID$ = UCASE$(LTRIM$(RTRIM$(ID$)))
OPEN "I", #1, FLNAME$ + ".IPK"
INPUT #1, IPATH$
INPUT #1, IPATH$, maxi
DO UNTIL EOF(1) OR ID$ = ID2$
	INPUT #1, ID2$, INAME$
LOOP
CLOSE #1
IF ID2$ = ID$ THEN
	LOADPIC IPATH$ + INAME$, px, py
  ELSE
	PRINT "Image not found!"

END IF


END SUB

SUB LOADPIC (FLNAME$, px, py)
REM **** LOAD TXT IMAGE ***
DIM temppic(200), TEMP11
OPEN "I", #1, FLNAME$ + ".TXT"
INPUT #1, F$
IF LEFT$(F$, 6) = "<DTXT>" THEN INPUT #1, psizeX, psizeY ELSE psizeX = 70: psizeY = 70
IF RIGHT$(F$, 1) = "+" THEN
	TEMP11 = psizeY
	GET (px + psizeX, py)-STEP(0, psizeY - 1), temppic
  ELSE
	TEMP11 = psizeX
	GET (px, py + psizeY)-STEP(psizeX - 1, 0), temppic
END IF

GX = POINT(px, py)
PSET (px, py)
FOR gx1 = 1 TO TEMP11
	 INPUT #1, G1$: DRAW G1$
NEXT
CLOSE #1
PSET (px, py), GX
IF RIGHT$(F$, 1) = "+" AND px + psizeX < 320 THEN PUT (px + psizeX, py), temppic, PSET
IF RIGHT$(F$, 1) <> "+" AND py + psizeY < 200 THEN PUT (px, py + psizeY), temppic, PSET


END SUB

SUB LoopMIDI
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN PLAYMIDI
END SUB

REM $DYNAMIC
'MIDIError - Translates a QMIDI error code into text
FUNCTION MIDIError$
SELECT CASE MIDI.ERROR
		CASE 0: MIDIError$ = "NO ERROR"
		CASE 1: MIDIError$ = "FILE DOES NOT EXIST"
		CASE 2: MIDIError$ = "OUT OF MEMORY"
		CASE 3: MIDIError$ = "NO MIDI FILE PLAYING"
		CASE 4: MIDIError$ = "INVALID SBMIDI INTERRUPT"
		CASE 5: MIDIError$ = "INVALID SBSIM INTERRUPT"
		CASE 6: MIDIError$ = "NO MIXER CHIP"
		CASE 7: MIDIError$ = "COULD NOT DETECT SOUND CARD"
		CASE 8: MIDIError$ = "FEATURE UNAVAILABLE"
		CASE 9: MIDIError$ = "FILE IS CORRUPT"
		CASE 10: MIDIError$ = "INVALID SOUND CARD TYPE"
		CASE 11: MIDIError$ = "COULD NOT PLAY MUSIC"
		CASE ELSE: MIDIError$ = "UNKNOWN ERROR"
END SELECT
END FUNCTION

REM $STATIC
FUNCTION MusicDone%
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT FUNCTION
IF MIDI.PLAYTIME = 0 THEN MIDI.ERROR = 3: EXIT FUNCTION
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN QMIDIRegs.AX = -1 ELSE QMIDIRegs.AX = 0
MusicDone% = QMIDIRegs.AX
END FUNCTION

REM $DYNAMIC
'PauseMIDI - Pauses a MIDI file that is currently playing
SUB PauseMIDI
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
'If no MIDI file is playing, exit now
IF MIDI.PLAYTIME = 0 THEN
	MIDI.ERROR = 3
	EXIT SUB
END IF
'Call the SBSIM driver to pause the music.
QMIDIRegs.BX = &H503
CALL IntX(SBSIM.INTERRUPT, QMIDIRegs)
'Save the number of seconds that the MIDI file has been playing.
PAUSED = TimeMIDI!
'If the music hasn't been playing long enough for TimeMIDI! to return
'a value greater than 0, change PAUSED to a tiny positive value.
IF PAUSED = 0! THEN PAUSED = .00001
'Indicate that the file has stopped playing.
MIDI.PLAYTIME = 0
MIDI.ERROR = 0
END SUB

'PlayMIDI - Begins playing a MIDI file in the background.
SUB PLAYMIDI
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If sound is not disabled....
IF SOUND.DISABLED = 0 THEN
	'Call the SBMIDI driver to begin playing the MIDI file.
	QMIDIRegs.BX = 4
	QMIDIRegs.DX = MEM.SEGMENT
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	QMIDIRegs.BX = 5
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	'If the music could not be started, return an error.
	IF QMIDIRegs.AX <> 0 THEN MIDI.ERROR = 11: EXIT SUB
	'Start the MIDI timer.
	MIDI.PLAYTIME = TIMER
END IF
MIDI.ERROR = 0
END SUB

'ResumeMIDI - Starts playing a MIDI file after it has been paused
SUB ResumeMIDI
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
'If the MIDI file is not paused, exit now
IF PAUSED = 0! THEN EXIT SUB
'Call the SBSIM driver to resume playing.
QMIDIRegs.BX = &H504
CALL IntX(SBSIM.INTERRUPT, QMIDIRegs)
'Update the MIDI timer.
MIDI.PLAYTIME = TIMER - PAUSED
PAUSED = 0!
MIDI.ERROR = 0
END SUB

REM $STATIC
SUB SETPAL (num, red, green, blue)
OUT &H3C8, num
OUT &H3C9, red
OUT &H3C9, green
OUT &H3C9, blue
END SUB

SUB SETPAL2 (num, rgb$)
OUT &H3C8, num
OUT &H3C9, ASC(LEFT$(rgb$, 1))
OUT &H3C9, ASC(MID$(rgb$, 1, 1))
OUT &H3C9, ASC(RIGHT$(rgb$, 1))
END SUB

SUB SHIFTLR (X11, Y11, SX11, SY11, WAY)
REM ******************************************
REM *** SHIFT AND IMAGE L->R OR VICE VERSA ***
REM ******************************************
DIM IM10(3000), IM11(500), SEP
SEP = ABS(WAY)
IF WAY > 0 THEN
	GET (X11, Y11)-STEP(SX11 - SEP - 1, SY11 - 1), IM10
	GET (X11 + SX11 - SEP - 1, Y11)-STEP(SEP, SY11 - 1), IM11
	PUT (X11 + SEP, Y11), IM10, PSET
	PUT (X11, Y11), IM11, PSET
ELSE
	GET (X11 + SEP, Y11)-STEP(SX11 - SEP - 1, SY11 - 1), IM10
	GET (X11, Y11)-STEP(SEP - 1, SY11 - 1), IM11
	PUT (X11, Y11), IM10, PSET
	PUT (X11 + SX11 - SEP, Y11), IM11, PSET
END IF
END SUB

SUB SHIFTUD (X11, Y11, SX11, SY11, WAY)
REM ******************************************
REM *** SHIFT AND IMAGE L->R OR VICE VERSA ***
REM ******************************************
DIM IM10(3000), IM11(500), SEP
SEP = ABS(WAY)
IF WAY > 0 THEN
	GET (X11, Y11)-STEP(SX11 - 1, SY11 - SEP - 1), IM10
	GET (X11, Y11 + SY11 - SEP - 1)-STEP(SX11 - 1, SEP - 1), IM11
	PUT (X11, Y11 + SEP), IM10, PSET
	PUT (X11, Y11), IM11, PSET
ELSE
	GET (X11, Y11 + SEP)-STEP(SX11 - 1, SY11 - SEP - 1), IM10
	GET (X11, Y11)-STEP(SX11 - 1, SEP - 1), IM11
	PUT (X11, Y11), IM10, PSET
	PUT (X11, Y11 + SY11 - SEP - 1), IM11, PSET
END IF

END SUB

SUB showbmp (bmpname$, bmpx, bmpy)
REM ************************************************
REM *** DISPLAY OUT THE BITMAP FILE              ***
REM ************************************************
31900

error1 = 0
OPEN bmpname$ FOR BINARY AS #6

'/* Extracts the first 2 bytes of the file */'
ValidBMP$ = SPACE$(2)
GET #6, 1, ValidBMP$
'/* If the first 2 bytes of the file are not BM then a line of text is printed, */'
'/* and the program ends */'
IF ValidBMP$ <> "BM" THEN
   PRINT bmpname$ + " is NOT a valid bitmap file!"
   error1 = 1
   GOTO 31990
END IF

'/* Extracts the offset of the picture data in the file */'
LocationOfPictureData$ = SPACE$(4)
GET #6, 11, LocationOfPictureData$
LocationOfPictureData = CVL(LocationOfPictureData$)

'/* Extracts the BMP type (Win or OS/2) */'
BMPType$ = SPACE$(4)
GET #6, 15, BMPType$
'/* If the BMPType is for OS/2 then the a line of text is printed, then */'
'/* program ends */'
IF CVL(BMPType$) = 12 OR CVL(BMPType$) = 64 THEN
   PRINT bmpname$ + " is an OS/2 version bitmap file!"
   error1 = 1
   GOTO 31990
END IF

'/* Extracts the Width and Height in Pixels of the Image */'
'/* and also the number of bits per pixel (bpp) */'
psizeX$ = SPACE$(4)
psizeY$ = SPACE$(4)
bitsperpixel$ = SPACE$(2)
Compression$ = SPACE$(4)
GET #6, 19, psizeX$
GET #6, 23, psizeY$
GET #6, 29, bitsperpixel$
GET #6, 31, Compression$
psizeX = CVL(psizeX$)
psizeY = CVL(psizeY$)
bitsperpixel = CVI(bitsperpixel$)
NumberOfColors = 2 ^ bitsperpixel

'/* Changing to suitable screen modes to display the Image */'
IF bitsperpixel <> 4 AND bitsperpixel <> 8 THEN
   PRINT "File is NOT an 8-bit or 4-bit bitmap file!"
   error1 = 1
   GOTO 31990
END IF

IF psizeX > 318 OR psizeY > 198 THEN
	bmpx = 0: bmpy = 0
	VIEW SCREEN (0, 0)-(319, 198)
  ELSE
	VIEW (bmpx, bmpy)-(bmpx + psizeX, bmpy + psizeY)
END IF

'/* If image is not 24-bit then load palette information from file */'
IF bitsperpixel <> 24 THEN
   '/* Extracts Palette information for the colors used in the image */'
   PaletteColors$ = SPACE$(NumberOfColors * 4)
   GET #6, 55, PaletteColors$

   FOR Loops = 0 TO NumberOfColors - 1
   '/* Changes the Palette of each color to the one specified in the file */'
	  IF bitsperpixel = 1 AND Loops = 1 THEN Loops = 15
	  OUT &H3C8, Loops
	  IF bitsperpixel = 1 AND Loops = 15 THEN Loops = 1
	  OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 3, 1)) \ 4 'Red
	  OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 2, 1)) \ 4 'Green
	  OUT &H3C9, ASC(MID$(PaletteColors$, Loops * 4 + 1, 1)) \ 4 'Blue
   NEXT Loops

   '/* Finds correct location of Picture data */'
   IF LocationOfPictureData = 0 THEN
	  LocationOfPictureData = LOC(255) + 1
   ELSE
	  LocationOfPictureData = LocationOfPictureData + 1
   END IF
END IF

IF CVL(Compression$) = 1 THEN
   PixelColors$ = SPACE$(1): NoOfSameColors$ = SPACE$(1)
   RightMovement$ = SPACE$(1):  UpMovement$ = SPACE$(1)
   ActualWidth = psizeX / 320: ActualHeight = psizeY / 200
   IF ActualWidth < 1 THEN ActualWidth = 1
   IF ActualHeight < 1 THEN ActualHeight = 1
   x = 0: y = psizeY - 1
   DO
	  GET #6, , NoOfSameColors$
	  IF ASC(NoOfSameColors$) <> 0 THEN
		 GET #6, , PixelColors$
		 IF x + ASC(NoOfSameColors$) = psizeX THEN NoOfSameColors$ = CHR$(ASC(NoOfSameColors$) - 1)
		 LINE (x / ActualWidth, y / ActualHeight)-STEP(ASC(NoOfSameColors$) / ActualWidth, 0), ASC(PixelColors$)
		 x = x + ASC(NoOfSameColors$)
	  ELSE
		 GET #6, , PixelColors$
		 IF ASC(PixelColors$) = 0 THEN
			x = 0: y = y - 1
			IF y < 0 THEN GOTO 31990
			'/* Used to skip the unnecessary lines in large pictures
			WHILE y MOD ActualHeight <> 0
			   DO
				  GET #6, , NoOfSameColors$
				  IF ASC(NoOfSameColors$) <> 0 THEN
					 GET #6, , PixelColors$
				  ELSE
					 GET #6, , PixelColors$
					 IF ASC(PixelColors$) = 0 THEN
						EXIT DO
					 ELSEIF ASC(PixelColors$) = 1 THEN
						GOTO 31990
					 ELSEIF ASC(PixelColors$) = 2 THEN
						Bytez$ = SPACE$(2)
						GET #6, , Bytez$
						EXIT DO
					 ELSE
						Bytez$ = SPACE$(ASC(PixelColors$))
						IF ASC(PixelColors$) MOD 2 = 1 THEN Bytez$ = Bytez$ + " "
						GET #6, , Bytez$
					 END IF
				  END IF
			   LOOP
			   y = y - 1
			WEND
		 ELSEIF ASC(PixelColors$) = 1 THEN
			EXIT DO
		 ELSEIF ASC(PixelColors$) = 2 THEN
			GET #6, , RightMovement$
			GET #6, , UpMovement$
			x = x + ASC(RightMovement$): y = y + ASC(UpMovement$)
		 ELSE
			PixelColor$ = SPACE$(1)
			FOR Loops = 1 TO ASC(PixelColors$)
			   GET #6, , PixelColor$
			   PSET (x / ActualWidth, y / ActualHeight), ASC(PixelColor$)
			   x = x + 1
			NEXT Loops
			IF ASC(PixelColors$) MOD 2 = 1 THEN GET #6, , PixelColor$
		 END IF
	  END IF
   LOOP
   GOTO 31990
ELSEIF CVL(Compression$) = 2 THEN
   PixelColors$ = SPACE$(1): NoOfSameColors$ = SPACE$(1)
   RightMovement$ = SPACE$(1):  UpMovement$ = SPACE$(1)
   ActualWidth = psizeX / 640: ActualHeight = psizeY / 480
   IF ActualWidth < 1 THEN ActualWidth = 1
   IF ActualHeight < 1 THEN ActualHeight = 1
   x = 0: y = psizeY - 1
   DO
	  GET #6, , NoOfSameColors$
	  IF ASC(NoOfSameColors$) <> 0 THEN
		 GET #6, , PixelColors$
		  FOR Loops = 0 TO ASC(NoOfSameColors$) - 1 STEP 2
			 PSET (x / ActualWidth, y / ActualHeight), ASC(PixelColors$) \ 16
			 x = x + 1
			 IF Loops + 1 <> ASC(NoOfSameColors$) THEN
				PSET (x / ActualWidth, y / ActualHeight), ASC(PixelColors$) AND 15
				x = x + 1
			 END IF
		  NEXT Loops
	  ELSE
		 GET #6, , PixelColors$
		 IF ASC(PixelColors$) = 0 THEN
			x = 0: y = y - 1
			IF y < 0 THEN GOTO 31990
			'/* Used to skip the unnecessary lines in large pictures
			WHILE y MOD ActualHeight <> 0
			   DO
				  GET #6, , NoOfSameColors$
				  IF ASC(NoOfSameColors$) <> 0 THEN
					 GET #6, , PixelColors$
				  ELSE
					 GET #6, , PixelColors$
					 IF ASC(PixelColors$) = 0 THEN
						EXIT DO
					 ELSEIF ASC(PixelColors$) = 1 THEN
						GOTO 31990
					 ELSEIF ASC(PixelColors$) = 2 THEN
						Bytez$ = SPACE$(2)
						GET #6, , Bytez$
						EXIT DO
					 ELSE
						PixelColors = ASC(PixelColors$)
						IF PixelColors MOD 2 = 1 THEN
						   PixelColors = PixelColors + 1
						END IF
						PixelColors = PixelColors / 2
						IF PixelColors MOD 2 = 1 THEN
						   PixelColors = PixelColors + 1
						END IF
						Bytez$ = SPACE$(PixelColors)
						GET #6, , Bytez$
					 END IF
				 END IF
			   LOOP
			   y = y - 1
			WEND
		 ELSEIF ASC(PixelColors$) = 1 THEN
			EXIT DO
		 ELSEIF ASC(PixelColors$) = 2 THEN
			GET #6, , RightMovement$
			GET #6, , UpMovement$
			x = x + ASC(RightMovement$): y = y + ASC(UpMovement$)
		 ELSE
			PixelColor$ = SPACE$(1): PixelColors = ASC(PixelColors$)
			FOR Loops = 0 TO PixelColors - 1
			   IF Loops MOD 2 = 0 THEN
				  GET #6, , PixelColor$
				  PSET (x / ActualWidth, y / ActualHeight), ASC(PixelColor$) \ 16
				  x = x + 1
			   END IF
			   IF Loops MOD 2 = 1 THEN
				  PSET (x / ActualWidth, y / ActualHeight), ASC(PixelColor$) AND 15
				  x = x + 1
			   END IF
			NEXT Loops
			IF PixelColors MOD 2 = 1 THEN
			   PixelColors = PixelColors + 1
			END IF
			NoOfBytes = PixelColors / 2
			IF (NoOfBytes MOD 2) = 1 THEN
			   GET #6, , PixelColor$
			END IF
		 END IF
	  END IF
   LOOP
   GOTO 31990
END IF

IF bitsperpixel = 8 THEN
   LineExtract$ = SPACE$(psizeX)
   IF (4 - (psizeX MOD 4)) <> 4 THEN
	  LineExtract$ = LineExtract$ + SPACE$(4 - (psizeX MOD 4))
   END IF
   LineExtract& = LEN(LineExtract$)
   ActualHeight! = 199 / (psizeY - 1)
   ActualWidth! = 319 / (psizeX - 1)
   IF ActualHeight! > 1 THEN ActualHeight! = 1
   IF ActualWidth! > 1 THEN ActualWidth! = 1
   ActualHeight1! = (psizeY - 1) / 199
   ActualWidth1! = (psizeX - 1) / 319
   IF ActualHeight1! < 1 THEN ActualHeight1! = 1
   IF ActualWidth1! < 1 THEN ActualWidth1! = 1
   IF ActualHeight! = 1 AND ActualWidth! = 1 THEN
	  SEEK #6, LocationOfPictureData
	  FOR y = psizeY - 1 TO 0 STEP -1
		 GET #6, , LineExtract$
		 FOR x = 0 TO psizeX - 1
			PSET (x, y), ASC(MID$(LineExtract$, x + 1, 1))
		 NEXT x
	  NEXT y
   ELSE
	  FOR y = 0 TO psizeY - 1 STEP ActualHeight1!
		 GET #6, LocationOfPictureData + ((psizeY - y - 1) * LineExtract&), LineExtract$
		 FOR x = 0 TO psizeX - 1 STEP ActualWidth1!
			PSET (x * ActualWidth!, y * ActualHeight!), ASC(MID$(LineExtract$, x + 1, 1))
		 NEXT x
	  NEXT y
   END IF
ELSEIF bitsperpixel = 4 THEN
   LineExtract$ = SPACE$(psizeX \ 2)
   IF (4 - ((psizeX MOD 8) / 2)) <> 4 THEN
	  LineExtract$ = LineExtract$ + SPACE$((4 - ((psizeX MOD 8) / 2)))
   END IF
   LineExtract& = LEN(LineExtract$)
   ActualHeight! = 479 / (psizeY - 1)
   ActualWidth! = 639 / (psizeX - 1)
   IF ActualHeight! > 1 THEN ActualHeight! = 1
   IF ActualWidth! > 1 THEN ActualWidth! = 1
   ActualHeight1! = (psizeY - 1) / 479
   ActualWidth1! = (psizeX - 1) / 639
   IF ActualHeight1! < 1 THEN ActualHeight1! = 1
   IF ActualWidth1! < 1 THEN ActualWidth1! = 1
   IF ActualWidth! = 1 AND ActualHeight! = 1 THEN
	  SEEK #6, LocationOfPictureData
	  FOR y = psizeY - 1 TO 0 STEP -1
		 GET #6, , LineExtract$
		 FOR x = 0 TO (psizeX / 2) - 1
			PixelColor = ASC(MID$(LineExtract$, x + 1, 1))
			PSET (x * 2, y), PixelColor \ 16
			IF (x * 2) + 1 < psizeX THEN
			   PSET ((x * 2) + 1, y), PixelColor AND 15
			END IF
		 NEXT x
	  NEXT y
   ELSE
	  FOR y = 0 TO psizeY - 1 STEP ActualHeight1!
		 GET #6, LocationOfPictureData + ((psizeY - 1 - y) * LineExtract&), LineExtract$
		 FOR x = 0 TO (psizeX / 2) - 1 STEP ActualWidth1!
			PixelColor = ASC(MID$(LineExtract$, x + 1, 1))
			PSET (x * ActualWidth! * 2, y * ActualHeight!), PixelColor \ 16
			IF (x * 2) + 1 < psizeX THEN
			   PSET ((x * ActualWidth! * 2) + 1, y * ActualHeight!), PixelColor AND 15
			END IF
		 NEXT x
	  NEXT y
   END IF
ELSEIF bitsperpixel = 1 THEN
   LineExtract$ = SPACE$(psizeX \ 8)
   IF (4 - ((psizeX MOD 32) / 8)) <> 4 THEN
	  LineExtract$ = LineExtract$ + SPACE$((4 - ((psizeX MOD 32) / 8)))
   END IF
   LineExtract& = LEN(LineExtract$)
   FOR y = 0 TO psizeY - 1
	  DEF SEG = &HA000
	  GET #6, LocationOfPictureData + ((psizeY - y - 1) * LineExtract&), LineExtract$
	  FOR x = 0 TO CINT(psizeX / 8) - 1
		 IF y < 409 THEN
			POKE (y * 80 + x), ASC(MID$(LineExtract$, x + 1, 1))
		 ELSE
			DEF SEG = &HA7D0
			POKE ((y - 400) * 80 + x), ASC(MID$(LineExtract$, x + 1, 1))
		 END IF
	  NEXT x
   NEXT y
   DEF SEG
END IF

31990

CLOSE #6
VIEW


END SUB

REM $DYNAMIC
'StopMIDI - Stops playing MIDI file
SUB stopmidi
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Call the SBMIDI driver to stop the music.
IF MIDI.PLAYTIME THEN
	QMIDIRegs.BX = 4
	QMIDIRegs.DX = MEM.SEGMENT
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	MIDI.ERROR = 0
ELSE
	MIDI.ERROR = 3
END IF
'If a block of memory was allocated to hold the MIDI file....
IF MEM.SEGMENT THEN
	'Release the block of memory.
	QMIDIRegs.ES = MEM.SEGMENT
	QMIDIRegs.AX = &H4900
	CALL IntX(&H21, QMIDIRegs)
	'Give back all the memory we took from BASIC.
	a& = SETMEM(MEM.ALLOCATED)
END IF
MEM.SEGMENT = 0
MIDI.PLAYTIME = 0
END SUB

REM $STATIC
SUB textcolor (tempcol)
textcol = tempcol

END SUB

REM $DYNAMIC
FUNCTION TimeMIDI!
'If a MIDI file is paused, lock the current playing time
IF PAUSED > 0! THEN
	TimeMIDI! = PAUSED
	MIDI.ERROR = 0
'If a MIDI file is playing, carry out the timing routine
ELSEIF MIDI.PLAYTIME THEN
	'Get the current time
	CurrentTime! = TIMER
	'If midnight has come since the MIDI file started playing, change
	'CurrentTime! accordingly
	IF CurrentTime! - MIDI.PLAYTIME < 0 THEN
		CurrentTime! = 86400 + CurrentTime!
	END IF
	'Get the final result
	TimeMIDI! = CurrentTime! - MIDI.PLAYTIME
	MIDI.ERROR = 0
ELSE
	MIDI.ERROR = 3
END IF
END FUNCTION

REM $STATIC
FUNCTION tlen (ltext$)
REM *********************************************
REM *** CALCULATE LENGTH OF TEXT IN PIXELS   ****
REM *********************************************
g23 = LEN(ltext$) - 1

FOR g22 = 1 TO LEN(ltext$)
	c$ = MID$(ltext$, g22, 1)
	IF c$ = "&" THEN g23 = g23 - (CHARLEN(ASC(c$) - 32) + BOLD)
	g23 = g23 + CHARLEN(ASC(c$) - 32) + BOLD
NEXT
tlen = g23

END FUNCTION

FUNCTION TRIMNUM$ (value)
TRIMNUM$ = LTRIM$(RTRIM$(STR$(value)))

END FUNCTION

