DECLARE SUB CreateLayers (SumoNumber%, TT%)
DEFINT A-Z
'$INCLUDE: 'SUMOEX.BI'
'$INCLUDE: 'C:\QBASIC\LIBS\DQB\DIRECTQB.BI'
DECLARE SUB PlaceTile (LayerFrom%, Tile%, LayerTo%, X2%, y2%, StepX%, StepY%)
DECLARE SUB DQBprintBack (Layer%, T$, X%, Y%, C1%, C2%)
DECLARE FUNCTION GetSynth% ()
DECLARE FUNCTION LoadMidi% (Filename$)
DECLARE FUNCTION MIDIError$ ()
DECLARE FUNCTION MusicDone% ()
DECLARE SUB PlayMidi (Handle%)
DECLARE FUNCTION TimeMIDI! ()
DECLARE SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
DECLARE SUB IntX (IntNum AS INTEGER, Regs AS ANY)
DECLARE SUB UNLOADMIDI (Handle%)
DECLARE FUNCTION MemUsed& (Handle%)
IntXCodeData:
DATA  &H55, &H8B, &HEC, &H83, &HEC, &H08, &H56, &H57, &H1E, &H55, &H8B, &H5E
DATA  &H06, &H8B, &H47, &H10, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H10, &H8B, &H47, &H12, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H12, &H8B, &H47, &H08, &H89, &H46, &HF8, &H8B, &H07, &H8B, &H4F, &H04
DATA  &H8B, &H57, &H06, &H8B, &H77, &H0A, &H8B, &H7F, &H0C, &HFF, &H77, &H12
DATA  &H07, &HFF, &H77, &H02, &H1E, &H8F, &H46, &HFA, &HFF, &H77, &H10, &H1F
DATA  &H8B, &H6E, &HF8, &H5B, &HCD, &H21, &H55, &H8B, &HEC, &H8B, &H6E, &H02
DATA  &H89, &H5E, &HFC, &H8B, &H5E, &H06, &H1E, &H8F, &H46, &HFE, &HFF, &H76
DATA  &HFA, &H1F, &H89, &H07, &H8B, &H46, &HFC, &H89, &H47, &H02, &H89, &H4F
DATA  &H04, &H89, &H57, &H06, &H58, &H89, &H47, &H08, &H89, &H77, &H0A, &H89
DATA  &H7F, &H0C, &H9C, &H8F, &H47, &H0E, &H06, &H8F, &H47, &H12, &H8B, &H46
DATA  &HFE, &H89, &H47, &H10, &H5A, &H1F, &H5F, &H5E, &H8B, &HE5, &H5D, &HCA
DATA  &H02, &H00

REM $DYNAMIC
DEFSNG A-Z
SUB CLEANUPMIDI
FOR I% = 0 TO 255
	IF MEM.SEGMENT(I%) THEN UNLOADMIDI I%
NEXT I%
MIDI.ERROR = 0
END SUB

REM $STATIC
DEFINT A-Z
SUB DQBprintBack (Layer, T$, X, Y, C1, C2)
 DQBprints Layer, T$, X - 1, Y - 1, C1, BOLD
 DQBprints Layer, T$, X + 1, Y + 1, C1, BOLD
 DQBprints Layer, T$, X, Y, C2, BOLD
END SUB

REM $DYNAMIC
DEFSNG A-Z
'DriversLoaded - Attempt to detect if sound drivers are loaded
SUB DriversLoaded (SBMIDI%, SBSIM%)
'Open the data file.
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
FileSize& = LOF(FF%)
NoExist% = 0
'If the file is empty, return an error.
IF FileSize& = 0 THEN
	CLOSE FF%
	KILL "DRIVERS.DAT"
	MIDI.ERROR = 1
	NoExist% = 1
'If the file is not exactly 1,024 bytes in size, return an error.
ELSEIF FileSize& <> 1024 THEN
	CLOSE FF%
	MIDI.ERROR = 9
	NoExist% = 1
END IF

'If DRIVERS.DAT exists, and is 1 kilobyte in size, read the driver
'data from it.
IF NoExist% = 0 THEN
REDIM DRIVERDATA$(1 TO 5)
FOR I% = 1 TO 4
	DRIVERDATA$(I%) = INPUT$(256, #FF%)
NEXT I%
END IF

'Close the data file.
CLOSE #FF%

'Check the interrupt handlers for int 80h-FFh, to see if they are occupied
'by either SBMIDI or SBSIM.
SBMIDI% = 0
SBSIM% = 0
FOR I% = &H80 TO &HFF
	'Get the address of the interrupt handler.
	InternalGetIntVector I%, Segment&, Offset&
	'If the segment returned is 0, that means that the current interrupt
	'is not in use.
	IF Segment& = 0 THEN GOTO Skip:

	'The following code checks for the drivers by looking for the text
	'"SBMIDI" and "SBSIM" at certain locations in the driver code.
	'If it doesn't work, a different method is used.
	IF SBMIDI% = 0 THEN
	  DEF SEG = Segment& - 17
	  Temp$ = ""
	  FOR J% = 1 TO 6
		Temp$ = Temp$ + CHR$(PEEK(271 + J%))
	  NEXT
	  IF Temp$ = "SBMIDI" THEN SBMIDI% = I%
	END IF
	IF SBSIM% = 0 AND Segment& <> 0 THEN
		DEF SEG = Segment& - 1
		Temp$ = ""
		FOR J% = 1 TO 5
			Temp$ = Temp$ + CHR$(PEEK(274 + J%))
		NEXT
		IF Temp$ = "SBSIM" THEN SBSIM% = I%
	END IF
 
	'This is the second detection method.  It's more complex than the first
	'method, but not really any more accurate.
	IF NoExist% = 0 THEN
	'Point to the segment of the interrupt handler.
	DEF SEG = Segment&
	'Read 256 bytes of code from the interrupt handler.
	DRIVERDATA$(5) = ""
	FOR J% = 0 TO 255
		Byte% = PEEK(Offset& + J%)
		DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(Byte%)
	NEXT J%
	'Check to see if the code matches any of the data from DRIVERS.DAT.
	FOR J% = 1 TO 4
		MATCH% = 1
		FOR k% = 0 TO 255
			IF MID$(DRIVERDATA$(J%), k% + 1, 1) <> MID$(DRIVERDATA$(5), k% + 1, 1) THEN
				SELECT CASE k%
					CASE IS = 14, 15, 113, 114, 235, 236
					CASE ELSE
						MATCH% = 0
						EXIT FOR
				END SELECT
			END IF
		NEXT k%
		'If there was a match, find out which driver is using the interrupt.
		IF MATCH% THEN
			IF J% = 1 THEN SBSIM% = I%
			IF J% <> 1 THEN SBMIDI% = I%
		END IF
		'If both SBMIDI and SBSIM have been found, exit the loop.
		IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	NEXT J%
   
	'If both SBMIDI and SBSIM have been found, exit the loop.
	IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	END IF
Skip:
NEXT I%
IF NoExist% = 0 THEN MIDI.ERROR = 0
END SUB

REM $STATIC
DEFINT A-Z
SUB FilterBox (Layer, x1%, y1%, X2%, y2%, Col%, BG, OutLine)
IF Col% OR BG% THEN
DEF SEG = DQBmapLayer(Layer)
	FOR Y& = y1% TO y2%
	FOR X = x1% TO X2%
	  Offset& = Y& * 320 + X
	  IF BG% THEN
	   POKE Offset&, BG%
	  ELSE
	   POKE Offset&, (((PEEK(Offset&)) MOD 16) + (Col% + 16) * 16)
	  END IF
	NEXT X
	NEXT Y&
DEF SEG
END IF
IF OutLine THEN
 DQBline Layer, x1% + 1, y1%, X2%, y1%, OutLine
 DQBline Layer, x1%, y1% + 1, x1%, y2% - 1, OutLine
 DQBline Layer, X2% + 1, y1% + 1, X2% + 1, y2% - 1, OutLine
 DQBline Layer, x1% + 1, y2%, X2%, y2%, OutLine
END IF
END SUB

DEFSNG A-Z
FUNCTION GetSynth%
QMIDIRegs.BX = 10
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
GetSynth% = QMIDIRegs.AX
END FUNCTION

DEFINT A-Z
SUB InitImageData (Filename$, ImageArray())
REM $DYNAMIC
	IF Filename$ <> "" THEN
		FileNo = FREEFILE
		OPEN Filename$ FOR BINARY AS #FileNo
		Ints = (LOF(FileNo) - 7) \ 2
		CLOSE #FileNo
		'$DYNAMIC
		REDIM ImageArray(1 TO Ints)
		DEF SEG = VARSEG(ImageArray(1))
		BLOAD Filename$, 0
		DEF SEG
	ELSE
		READ IntCount
		REDIM ImageArray(1 TO IntCount)
		FOR n = 1 TO IntCount
			READ X
			ImageArray(n) = X
		NEXT n
	END IF
END SUB

DEFSNG A-Z
SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
QMIDIRegs.AX = IntNum% + 13568
CALL IntX(&H21, QMIDIRegs)
Segment& = QMIDIRegs.ES
Offset& = QMIDIRegs.BX
END SUB

REM $STATIC
SUB IntX (IntNum AS INTEGER, Regs AS Registers) STATIC

STATIC filenum AS INTEGER, IntOffset AS INTEGER, Loaded AS INTEGER
		   
	' use fixed-length string to fix its position in memory
	' and so we don't mess up string pool before routine
	' gets its pointers from caller

DIM IntCode AS STRING * 200
IF NOT Loaded THEN                     ' loaded will be 0 first time
	RESTORE IntXCodeData:
   
	FOR k% = 1 TO 145
		READ h%
		MID$(IntCode, k%, 1) = CHR$(h%)
	NEXT

	'  determine address of interrupt no. offset in IntCode
  
	IntOffset% = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1
	Loaded% = -1
END IF

SELECT CASE IntNum
  
	CASE &H25, &H26, IS > 255               ' ignore these interrupts
  
	CASE ELSE
		DEF SEG = VARSEG(IntCode)             ' poke interrupt number into
		POKE VARPTR(IntCode) * 1& + IntOffset - 1, IntNum     ' code block
		CALL ABSOLUTE(Regs, VARPTR(IntCode$))               ' call routine
END SELECT

END SUB

REM $DYNAMIC
'LoadMIDI - loads a MIDI file into memory
FUNCTION LoadMidi% (Filename$)
LoadMidi% = -1
'See if an extension was supplied, and if not, add one.
IF INSTR(Filename$, ".") = 0 THEN Filename$ = Filename$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL Filename$: MIDI.ERROR = 1: EXIT FUNCTION
'Make the filename an ASCIIZ string.
Filename$ = Filename$ + CHR$(0)

'Find an empty MIDI handle
NewHandle% = -1
FOR I% = 0 TO 255
	IF MEM.SEGMENT(I%) = 0 THEN NewHandle% = I%: EXIT FOR
NEXT I%
'If there are no empty handles, return an error.
IF NewHandle% = -1 THEN MIDI.ERROR = 12: EXIT FUNCTION
'Attempt to allocate a block of conventional memory.
QMIDIRegs.AX = &H4800
QMIDIRegs.BX = (FileLen& \ 16) + 1
CALL IntX(&H21, QMIDIRegs)
'If the block couldn't be allocated, it means there's not enough free
'memory.  To fix this, we need to ask BASIC to release some of the memory
'it's using:
IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
	'Find out how much memory is available, in kilobytes.
	LargestBlock& = QMIDIRegs.BX
	LargestBlock& = LargestBlock& * 16
	'Calculate the amount of memory that BASIC needs to release for us.
	MEM.ALLOCATED(NewHandle%) = (FileLen& + 2048) - LargestBlock&
	'Attempt to release the memory.
	A& = SETMEM(-MEM.ALLOCATED(NewHandle%))
	'Try again to allocate a block of memory
	QMIDIRegs.AX = &H4800
	QMIDIRegs.BX = (FileLen& \ 16) + 1
	CALL IntX(&H21, QMIDIRegs)
	'If the second attempt was unsuccessful, then there just isn't
	'enough memory, and an error needs to be returned.
	IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
		'Give any memory we took back to BASIC.
		A& = SETMEM(650000)
		'Return an error.
		MIDI.ERROR = 2
		MEM.SEGMENT(NewHandle%) = 0
		'Abort.
		EXIT FUNCTION
	END IF
END IF
'If the memory was allocated successfully, store the segment
'of the memory block.
MEM.SEGMENT(NewHandle%) = QMIDIRegs.AX
MIDISegment& = QMIDIRegs.AX

'Open the MIDI file using a DOS interrupt.
QMIDIRegs.AX = &H3D00
QMIDIRegs.dx = SADD(Filename$)
QMIDIRegs.DS = VARSEG(Filename$)
CALL IntX(&H21, QMIDIRegs)
'Store the file handle.
Handle% = QMIDIRegs.AX
'Read the data from the file in 16 kilobyte increments.
FOR I& = 1 TO FileLen& STEP 16384
	QMIDIRegs.AX = &H3F00
	QMIDIRegs.CX = 16384
	QMIDIRegs.dx = 0
	QMIDIRegs.DS = VAL("&H" + HEX$(MIDISegment&))
	QMIDIRegs.BX = Handle%
	CALL IntX(&H21, QMIDIRegs)
	MIDISegment& = MIDISegment& + 1024
NEXT I&

'Close the file
QMIDIRegs.AX = &H3E00
QMIDIRegs.BX = Handle%
CALL IntX(&H21, QMIDIRegs)

MIDI.ERROR = 0
LoadMidi% = NewHandle%
END FUNCTION

REM $STATIC
SUB LoopMidi
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN CALL DQBstopVoice(1): PlayMidi HANDLER%
END SUB

DEFINT A-Z
SUB MakeImageIndex (ImageArray(), IndexArray())
	DIM Temp(1 TO 1000)
	Ptr& = 1: IndexNo = 1: LastInt = UBOUND(ImageArray)
	DO
		Temp(IndexNo) = Ptr&
		IndexNo = IndexNo + 1
		X& = (ImageArray(Ptr&) \ 8) * (ImageArray(Ptr& + 1)) + 4
		IF X& MOD 2 THEN X& = X& + 1
		Ptr& = Ptr& + (X& \ 2)
	LOOP WHILE Ptr& < LastInt
	LastImage = IndexNo - 1
	REDIM IndexArray(1 TO LastImage)
	FOR n = 1 TO LastImage
		IndexArray(n) = Temp(n)
	NEXT n
END SUB

DEFSNG A-Z
FUNCTION MemUsed& (Handle%)
MemUsed& = MEM.ALLOCATED(Handle%)
MIDI.ERROR = 0
END FUNCTION

REM $DYNAMIC
'MIDIError - Translates a QMIDI error code into text
FUNCTION MIDIError$
SELECT CASE MIDI.ERROR
		CASE 0: MIDIError$ = "NO ERROR"
		CASE 1: MIDIError$ = "FILE DOES NOT EXIST"
		CASE 2: MIDIError$ = "OUT OF MEMORY"
		CASE 3: MIDIError$ = "NO MIDI FILE PLAYING"
		CASE 4: MIDIError$ = "INVALID SBMIDI INTERRUPT"
		CASE 5: MIDIError$ = "INVALID SBSIM INTERRUPT"
		CASE 6: MIDIError$ = "NO MIXER CHIP"
		CASE 7: MIDIError$ = "COULD NOT DETECT SOUND CARD"
		CASE 8: MIDIError$ = "FEATURE UNAVAILABLE"
		CASE 9: MIDIError$ = "FILE IS CORRUPT"
		CASE 10: MIDIError$ = "INVALID SOUND CARD TYPE"
		CASE 11: MIDIError$ = "COULD NOT PLAY MUSIC"
		CASE 12: MIDIError$ = "ALL HANDLES IN USE"
		CASE 13: MIDIError$ = "INVALID HANDLE NUMBER"
		CASE ELSE: MIDIError$ = "UNKNOWN ERROR"
END SELECT
END FUNCTION

REM $STATIC
FUNCTION MusicDone%
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT FUNCTION
IF MIDI.PLAYTIME = 0 THEN MIDI.ERROR = 3: EXIT FUNCTION
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN QMIDIRegs.AX = -1 ELSE QMIDIRegs.AX = 0
MusicDone% = QMIDIRegs.AX
MIDI.ERROR = 0
END FUNCTION

REM $DYNAMIC
'PauseMIDI - Pauses a MIDI file that is currently playing
SUB PauseMIDI
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If no MIDI file is playing, exit now
IF MIDI.PLAYTIME = 0 THEN
	MIDI.ERROR = 3
	EXIT SUB
END IF
'Call the SBSIM driver to pause the music.
QMIDIRegs.BX = 7
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
'Save the number of seconds that the MIDI file has been playing.
PAUSED = TimeMIDI!
'If the music hasn't been playing long enough for TimeMIDI! to return
'a value greater than 0, change PAUSED to a tiny positive value.
IF PAUSED = 0! THEN PAUSED = .00001
'Indicate that the file has stopped playing.
MIDI.PLAYTIME = 0
MIDI.ERROR = 0
END SUB

REM $STATIC
DEFINT A-Z
SUB PlaceTile (LayerFrom, Tile, LayerTo, X2, y2, StepX, StepY)
 IF Tile > 28 THEN Tile = 18
 IF Tile = 0 THEN Tile = 18
 IF Tile > 198 THEN Tile = Tile - 198: LayerFrom = LayerFrom + 1
 IF Tile > 198 THEN Tile = Tile - 198: LayerFrom = LayerFrom + 1
 X = ((Tile MOD (319 \ StepX)) * StepX) - StepX
 Y = (INT((Tile \ (319 \ StepX))) * StepX)
 IF Tile MOD (319 \ StepX) = 0 THEN X = (319 \ StepX) * StepX - StepX: Y = Y - (StepY)
 DQBxPut LayerFrom, X, Y, X + StepX - 1, Y + StepY - 1, LayerTo, X2, y2
END SUB

REM $DYNAMIC
DEFSNG A-Z
'PlayMIDI - Begins playing a MIDI file in the background.
SUB PlayMidi (Handle%)
CALL DQBstopVoice(1)
IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If sound is not disabled....
IF SOUND.DISABLED = 0 THEN
	'Call the SBMIDI driver to begin playing the MIDI file.
	QMIDIRegs.BX = 4
	QMIDIRegs.dx = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	QMIDIRegs.BX = 5
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	'If the music could not be started, return an error.
	IF QMIDIRegs.AX <> 0 THEN MIDI.ERROR = 11: EXIT SUB
	'Start the MIDI timer.
	MIDI.PLAYTIME = TIMER
	'Set the current handle.
	CURRENTHANDLE = Handle%
END IF
MIDI.ERROR = 0
END SUB

'ResumeMIDI - Starts playing a MIDI file after it has been paused
SUB ResumeMIDI
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If the MIDI file is not paused, exit now
IF PAUSED = 0! THEN EXIT SUB
'Call the SBSIM driver to resume playing.
QMIDIRegs.BX = 8
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
'Update the MIDI timer.
MIDI.PLAYTIME = TIMER - PAUSED
PAUSED = 0!
MIDI.ERROR = 0
END SUB

'StopMIDI - Stops playing MIDI file
SUB StopMidi
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
CALL DQBstopVoice(1)
'Call the SBMIDI driver to stop the music.
IF MIDI.PLAYTIME THEN
	QMIDIRegs.BX = 4
	QMIDIRegs.dx = MEM.SEGMENT(CURRENTHANDLE)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	MIDI.ERROR = 0
ELSE
	MIDI.ERROR = 3
END IF
MIDI.PLAYTIME = 0
END SUB

REM $STATIC
DEFINT A-Z
SUB SumoEX (File$)
 DIM Pall AS STRING * 768
 DIM Pic(32001) AS INTEGER
 DQBcopyLayer 0, 2
 IF DQBloadImage(5, 0, 0, File$, Pall, 319, 199) THEN PRINT DQBerror$
 DQBget 5, 0, 0, 319, 199, VARSEG(Pic(0)), VARPTR(Pic(0))
 FOR XX = 319 TO 0 STEP -8
  DQBcopyLayer 2, 1
  DQBput 1, XX, 0, VARSEG(Pic(0)), VARPTR(Pic(0))
  DQBcopyLayer 1, 0
  DQBwait 1
 NEXT
 ERASE Pic
END SUB

REM $DYNAMIC
DEFSNG A-Z
FUNCTION TimeMIDI!
'If a MIDI file is paused, lock the current playing time
IF PAUSED > 0! THEN
	TimeMIDI! = PAUSED
	MIDI.ERROR = 0
'If a MIDI file is playing, carry out the timing routine
ELSEIF MIDI.PLAYTIME THEN
	'Get the current time
	CurrentTime! = TIMER
	'If midnight has come since the MIDI file started playing, change
	'CurrentTime! accordingly
	IF CurrentTime! - MIDI.PLAYTIME < 0 THEN
		CurrentTime! = 86400 + CurrentTime!
	END IF
	'Get the final result
	TimeMIDI! = CurrentTime! - MIDI.PLAYTIME
	MIDI.ERROR = 0
ELSE
	MIDI.ERROR = 3
END IF
END FUNCTION

REM $STATIC
DEFINT A-Z
SUB Unleashed (Tile, Text$)
DIM Pall AS STRING * 768
IF DQBloadImage(2, 0, 0, "DATA\UNLEASH.PCX", Pall, 319, 199) THEN PRINT DQBerror$
Tile = Tile + 1
CALL CreateLayers(1, Tile)
n = 90: DQBplaySound 3, 2, 22050, 0
FOR A = 1 TO 360 STEP 6
 IF n > 2 THEN n = n - 2
 DQBcopyLayer 2, 1
 PlaceTile 6, Tile, 1, 137 + (n * SIN(A)), 77 + (n * COS(A)), 51, 51
 PlaceTile 6, Tile, 1, 137 + (n * SIN(A)), 77 + (n * SIN(A)), 51, 51
 PlaceTile 6, Tile, 1, 137 + (n * COS(A)), 77 + (n * COS(A)), 51, 51
 PlaceTile 3, 1, 1, 152, 137, 17, 17
 XX = 160 - (4 + (DQBlen(Text$) / 2))
 DQBprintBack 1, Text$, XX, 64, 9, 15
 DQBwait 1
 DQBcopyLayer 1, 0
NEXT
TTT = Tile
Tile = 1
XX = 160 - (4 + (DQBlen(Text$) / 2))
DQBremoveKeyBoard
DO
 I$ = INKEY$
 IF I$ = CHR$(27) THEN EXIT DO
 DQBboxF 1, 137, 77, 137 + 48, 77 + 48, 0
 PlaceTile 6, TTT, 1, 137, 77, 51, 51
 DQBcopyTransLayer 2, 1
 DQBprintBack 1, Text$, XX, 64, 9, 15
 WWait = WWait + 1
 IF WWait = 6 THEN Frame = Frame + 1: WWait = 0
 IF Frame = 3 THEN
  Frame = 0
  Tile = INT(RND * 7) + 1
  IF Tile = 1 THEN Tile = 1
  IF Tile = 2 THEN Tile = 4
  IF Tile = 3 THEN Tile = 7
  IF Tile = 4 THEN Tile = 10
  IF Tile = 5 THEN Tile = 13
  IF Tile = 6 THEN Tile = 16
  IF Tile = 7 THEN Tile = 19
  IF Tile = 8 THEN Tile = 21
 END IF
 DQBboxF 1, 152, 137, 152 + 16, 137 + 16, 0
 PlaceTile 3, Tile + Frame, 1, 152, 137, 17, 17
 DQBcopyLayer 1, 0
 DQBwait 1
LOOP
DQBfadeto 63, 63, 63
DQBinstallKeyBoard
END SUB

DEFSNG A-Z
SUB UNLOADMIDI (Handle%)
IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
'If a block of memory was allocated to hold the MIDI file....
IF MEM.SEGMENT(Handle%) THEN
	'Release the block of memory.
	QMIDIRegs.ES = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = &H4900
	CALL IntX(&H21, QMIDIRegs)
	'Give back all the memory we took from BASIC.
	A& = SETMEM(650000)
END IF
MEM.SEGMENT(Handle%) = 0
MEM.ALLOCATED(Handle%) = 0
MIDI.ERROR = 0
END SUB

