DEFINT A-Z
'$INCLUDE: 'SUMOEX.BI'
'$INCLUDE: 'DirectQB.BI'
DECLARE SUB Unleashed (Tile%, Text$)
DECLARE SUB SelectSumo (Player%)
DECLARE SUB HighScores ()
DECLARE SUB SUMODIE ()
DECLARE SUB SumoEX (File$)
DECLARE SUB InitImageData (FileName$, ImageArray%())
DECLARE SUB MakeImageIndex (ImageArray%(), IndexArray%())
DECLARE SUB PlaceTile (LayerFrom%, Tile%, LayerTo%, x2%, y2%, StepX%, StepY%)
DECLARE SUB CreateLayers (SumoNumber%, TT)
DECLARE SUB Animations (Layer%)
DECLARE SUB HandleSumo (S%)
DECLARE SUB DrawSumo (S%, Layer%)
DECLARE SUB DrawScreen (Layer%)
DECLARE FUNCTION CheckCollide% (S%, x%, y%)
DECLARE SUB DoKeys (S%, C%)
DECLARE SUB Gui (EXT$)
DECLARE SUB CreateSumo (S%)
DECLARE SUB DQBprintBack (Layer%, T$, x%, y%, c1%, c2%)
DECLARE SUB FilterBox (Layer%, x1%, y1%, x2%, y2%, Col%, BG%, OutLine%)
DECLARE SUB HandleFile (LookFor$)
DECLARE SUB LoopMidi ()
DECLARE SUB DrawButton (Layer%, x1%, y1%, Text$, TCOL%, Tback%, Size%, S2%, C%, P%)
DECLARE SUB InitSumo ()
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE FUNCTION LoadMidi% (FileName$)
DECLARE SUB PlayMidi (Handle%)
DECLARE SUB UNLOADMIDI (Handle%)
DECLARE SUB CLEANUPMIDI ()
DECLARE SUB StopMidi ()
TYPE Sumo
 x               AS INTEGER
 y               AS INTEGER
 x2              AS INTEGER
 y2              AS INTEGER
 Frame           AS INTEGER
 AnimCount       AS INTEGER
 Direction       AS INTEGER
 Action          AS INTEGER
 ActionCount     AS INTEGER
 Special         AS INTEGER
 SpecialBlocks   AS INTEGER
 SpecialCount    AS INTEGER
 Stamina         AS INTEGER
 StaminaCount    AS INTEGER
 Strength        AS INTEGER
 Speed           AS INTEGER
 Weight          AS INTEGER
 Col             AS INTEGER
 CurrentSpeed    AS INTEGER
 CurrentStrength AS INTEGER
 SpeedPowerUp    AS INTEGER
 StrengthPowerUp AS INTEGER
 Pname           AS STRING * 20
 offX            AS INTEGER
 offY            AS INTEGER
 StepOff         AS INTEGER
 HitWPower       AS INTEGER
 Shock           AS INTEGER
 CommonDir       AS INTEGER
 Move1           AS INTEGER
 Move2           AS INTEGER
 SpecialMove     AS INTEGER
 Rank            AS INTEGER
 TileSet         AS INTEGER
END TYPE
TYPE Referee
 x AS INTEGER
 y AS INTEGER
END TYPE
TYPE GAME
 Time     AS INTEGER
 MODE     AS INTEGER
 Players  AS INTEGER
 Winner   AS INTEGER
 FadeUp   AS INTEGER
 FadeDown AS INTEGER
 PowerUp  AS INTEGER
 TimeLeft AS INTEGER
 DIFF     AS INTEGER
END TYPE
TYPE Chart
 WINorLOSE AS INTEGER
END TYPE
TYPE Place
 Strength AS INTEGER
 Speed AS INTEGER
 Col AS INTEGER
END TYPE
TYPE Blood
 x AS INTEGER
 y AS INTEGER
 Xoff AS INTEGER
END TYPE
DIM SHARED Chart(30, 15), Scores(1 TO 5) AS INTEGER, Place(1 TO 21) AS Place
DIM SHARED MEM.SEGMENT(0 TO 255) AS INTEGER, Unleash(1 TO 4), WonGames
DIM SHARED MEM.ALLOCATED(0 TO 255) AS LONG, SOUND.MIDISET, SOUND.WAVSET
DIM SHARED BIT.STORAGE(0 TO 7) AS INTEGER, Fights, Wins, Losses, Handle%
DIM SHARED Sumo(1 TO 2) AS Sumo, Ref AS Referee, GAME AS GAME, Controller(1 TO 2) AS INTEGER
DIM SHARED Pal AS STRING * 768, QuitGame, KeyRequest(1 TO 4), Requests
DIM SHARED Outring, GFX(1 TO 1), GFXINDEX(1 TO 1), FightSumoEx, Names(1 TO 5) AS STRING
DIM SHARED SumoTiles2(1 TO 1), SumoIndex2(1 TO 1), SumoTiles(1 TO 1), SumoIndex(1 TO 1)
RANDOMIZE TIMER
SOUND.WAVSET = -1: SOUND.MIDISET = -1
FirstTime = 0
CALL InitSumo
StartOver:
IF DQBloadImage(2, 0, 0, "DATA\SUMOLOGO.PCX", Pal, 319, 199) THEN PRINT DQBerror$
DQBcopyLayer 2, 0
WonGames = 0
FOR I = 1 TO 2
 Sumo(I).AnimCount = 0: Sumo(I).Action = 0
 Sumo(I).Action = 0: Sumo(I).Frame = 0
 Sumo(I).CommonDir = 0: Sumo(I).offY = 0: Sumo(I).offX = 0
 Sumo(I).HitWPower = 0: Sumo(I).Stamina = 100: Sumo(I).Shock = 0
 Sumo(I).SpecialCount = 0: Sumo(I).SpecialBlocks = 0
NEXT I
DQBsetCol 81, 0, 0, 60: BB = 60: MO = 1
QuitGame = 0: DQBcopyLayer 2, 0
CALL Gui("MAINMNU")
IF QuitGame THEN QuitGame = 0: GOTO StartOver
CALL CreateLayers(1, Sumo(1).TileSet)
CALL CreateLayers(2, Sumo(2).TileSet)
Fight = 1
IF FirstTime = 0 THEN PlayMidi Handle%: FirstTime = -1

NextFight:
 GAME.Winner = 0
 GOSUB InitFight
 DQBinstallKeyBoard
 T! = TIMER

 DO
  LoopMidi
  IF TIMER > T! + 1 THEN
   GAME.TimeLeft = GAME.TimeLeft - 1: T! = TIMER
  END IF
  S = INT(RND * 1) + 1: IF S = 1 THEN S2 = 2 ELSE S2 = 1
  CALL HandleSumo(S)
  CALL HandleSumo(S2)
  CALL Animations(1)
  IF GAME.Winner THEN CALL SUMODIE: EXIT DO
  CALL DQBcopyLayer(1, 0)
  CALL DQBwait(2)
  IF MO = 1 THEN BB = BB - 1: ZZ = ZZ - (BB + 1) MOD (MO + 1)
  IF MO = 0 THEN BB = BB + 1: ZZ = ZZ + (BB + 1) MOD (MO + 1)
  IF BB = 20 THEN MO = 0
  IF BB = 63 THEN MO = 1
  IF ZZ > 63 THEN ZZ = 63
  IF ZZ < 0 THEN ZZ = 0
  DQBsetCol 81, ZZ, ZZ, BB
  IF DQBkey(32) THEN GAME.Winner = 2
 LOOP UNTIL DQBkey(1) OR QuitGame OR GAME.Winner OR GAME.TimeLeft = 0
 IF GAME.TimeLeft = 0 THEN GAME.Winner = 2
 IF DQBkey(1) OR GAME.MODE = 1 OR GAME.MODE = 3 OR GAME.MODE = 2 THEN
   QuitGame = 0
   GAME.Winner = 0
   Fight = 0: Sumo(1).Rank = 1: WonGames = 0
   FOR I = 1 TO 15
    Place(I).Strength = I * 2 \ 4 + INT(RND * 2) + INT(RND * -3): Place(I).Strength = Place(I).Strength + INT(RND * GAME.DIFF + 2)
    IF Place(I).Strength <= 0 THEN Place(I).Strength = 1
    Place(I).Col = INT(RND * 15)
    Place(I).Speed = I MOD 10
    Place(I).Speed = Place(I).Speed \ 2: Place(I).Speed = Place(I).Speed + INT(RND * GAME.DIFF)
    IF Place(I).Speed = 0 THEN Place(I).Speed = 1
   NEXT I
   DQBfadeto 63, 63, 63
   IF DQBloadImage(2, 0, 0, "DATA\SUMOLOGO.PCX", Pal, 319, 199) THEN PRINT "Error Will Robinson!"
   GOTO StartOver
 END IF

IF GAME.MODE = 0 OR GAME.MODE = 4 THEN
 Fight = Fight + 1
 IF GAME.MODE = 0 THEN FightsReq = 16
 IF GAME.MODE = 4 THEN FightsReq = 16
 IF Fight < FightsReq THEN
  Contestant = INT(RND * 28) + 1
  FOR S = 1 TO 29
   IF S <> Contestant THEN
    Result = INT(RND * 1) - 1
    IF Result THEN Wins = Wins + 1
    IF Result AND Wins > 15 THEN Result = 0: Wins = Wins - 1: Losses = Losses + 1
    IF Result = 0 THEN Losses = Losses + 1
    IF Result = 0 AND Losses > 15 THEN Result = -1: Losses = Losses - 1: Wins = Wins + 1
    Chart(S, Fight) = Result
   END IF
  NEXT S
 ELSE
   IF GAME.MODE = 0 THEN
    IF DQBloadImage(2, 0, 0, "DATA\SUMOWIN2.PCX", Pal, 319, 199) THEN PRINT DQBerror$
    T$ = "Your record: " + LTRIM$(RTRIM$(STR$(Sumo(1).Rank))) + "," + LTRIM$(RTRIM$(STR$(15 - Sumo(1).Rank)))
    DQBprintBack 2, T$, 160 - (DQBlen(T$) \ 2), 77, 9, 15
    Score = INT(Sumo(1).Rank * ((GAME.DIFF * 200) + 66.6667))
    IF WonGames >= 10 THEN DQBprintBack 0, "You Won the Tournament!", 160 - (DQBlen("You Won the Tournament") / 2), 97, 9, 15: Score = Score + 1000
    IF Score <= 0 THEN Score = 1
    FOR S = 1 TO Score STEP 8
     DQBcopyLayer 2, 1
     S1$ = "Score: " + STR$(S)
     DQBprintBack 1, "Score: " + STR$(S), 160 - (DQBlen("Score: " + STR$(S)) \ 2) + 1, 87, 9, 15
     DQBcopyLayer 1, 0
     IF SOUND.WAVSET AND DD THEN DQBplaySound 7, 2, 8000, ONCE
    NEXT S
     IF WonGames >= 10 THEN
      IF GAME.DIFF >= 2 THEN
       IF Unleash(1) = 0 AND Sumo(1).TileSet = 1 THEN CALL Unleashed(1, "You unleashed Ryu!"): Unleash(1) = -1: DQBfadeIn Pal
       IF Unleash(2) = 0 AND Sumo(1).TileSet = 2 THEN CALL Unleashed(2, "You unleashed Oni!"): Unleash(2) = -1: DQBfadeIn Pal
      END IF
      IF GAME.DIFF = 3 AND Unleash(3) = 0 AND Sumo(1).TileSet = 3 THEN CALL Unleashed(3, "You unleashed Suki!"): Unleash(3) = -1: DQBfadeIn Pal
     END IF
     OPEN "DATA\UNLEASH.DAT" FOR OUTPUT AS #1
      FOR I = 1 TO 4
       IF I <= 3 THEN PRINT #1, Unleash(I); ",";  ELSE PRINT #1, Unleash(I)
      NEXT
     CLOSE #1
    OPEN "DATA\HIGH.DAT" FOR OUTPUT AS #1
    FOR I = 1 TO 5
     IF Score > Scores(I) AND NotAgain = 0 THEN
      IF SOUND.MIDISET AND SM THEN StopMidi
      DQBprintBack 0, "New High Score!!!", 160 - (DQBlen("New High Score!!!") / 2), 117, 9, 15
      DQBprintBack 0, "Write Your Name", 160 - (DQBlen("Write Your Name") / 2), 127, 9, 15
      FOR O = 5 TO I + 1 STEP -1
       Scores(O) = Scores(O - 1)
       Names(O) = Names(O - 1)
      NEXT O
      Scores(I) = Score
      DQBremoveKeyBoard
      LOCATE 20, 16: INPUT "Your Name:"; Names(I)
      Scores(I) = Score
      DQBinstallKeyBoard
      NotAgain = -1
     END IF
     PRINT #1, Names(I)
     PRINT #1, Scores(I)
    NEXT I
    NotAgain = 0
    CLOSE #1
   ELSE
    IF WonGames >= 11 THEN
     T$ = "You won the Boss Tournament!"
     DQBprintBack 0, T$, 160 - (DQBlen(T$) / 2), 97, 9, 15
     CALL Unleashed(4, "You unleashed Sumo X!")
     Unleash(4) = -1
     OPEN "DATA\UNLEASH.DAT" FOR OUTPUT AS #1
     FOR I = 1 TO 4
      IF I <= 3 THEN PRINT #1, Unleash(I); ",";  ELSE PRINT #1, Unleash(I)
     NEXT
     CLOSE #1
    ELSE
     DQBclearLayer 0: DQBprintBack 0, "You suck!", 140, 97, 9, 15: SLEEP 1
    END IF
   END IF
    DQBfadeto 0, 0, 0
    Fight = 0: Sumo(1).Rank = 1: WonGames = 0
    FOR I = 1 TO 15
     Place(I).Strength = I * 2 \ 4 + INT(RND * 2) + INT(RND * -3): Place(I).Strength = Place(I).Strength + INT(RND * GAME.DIFF + 2)
     IF Place(I).Strength <= 0 THEN Place(I).Strength = 1
     Place(I).Col = INT(RND * 15)
     Place(I).Speed = I MOD 10
     Place(I).Speed = Place(I).Speed \ 2: Place(I).Speed = Place(I).Speed + INT(RND * GAME.DIFF)
     IF Place(I).Speed = 0 THEN Place(I).Speed = 1
    NEXT I
    DQBfadeto 63, 63, 63
    IF DQBloadImage(2, 0, 0, "DATA\SUMOLOGO.PCX", Pal, 319, 199) THEN PRINT "Error Will Robinson!"
    GOTO StartOver
 END IF
 IF GAME.MODE = 0 OR GAME.MODE = 4 THEN
  IF GAME.Winner = 1 THEN
   Chart(30, Fight - 1) = -1
   Chart(Contestant, Fight - 1) = 0
   WonGames = WonGames + 1
   Sumo(1).Rank = Sumo(1).Rank + 1
   GOTO NextFight
  ELSE
   Chart(30, Fight - 1) = 0
   Chart(Contestant, Fight - 1) = -1
   GOTO NextFight
  END IF
 END IF
END IF
Leave:
DQBremoveKeyBoard
GOTO Qgme

InitFight:
 GAME.TimeLeft = GAME.Time
 FOR I = 1 TO 2
  Sumo(I).AnimCount = 0: Sumo(I).Action = 0
  Sumo(I).Action = 0: Sumo(I).Frame = 0
  Sumo(I).CommonDir = 0: Sumo(I).offY = 0: Sumo(I).offX = 0
  Sumo(I).HitWPower = 0: Sumo(I).Stamina = 100: Sumo(I).Shock = 0
  Sumo(I).SpecialCount = 0
 NEXT I
 GAME.Winner = 0
 Sumo(1).x = 148 - 17: Sumo(1).y = 120
 Sumo(2).x = 172: Sumo(2).y = 120
 Ref.x = 162: Ref.y = 120
 Sumo(1).Direction = mRight: Sumo(2).Direction = mLeft
 IF GAME.MODE = 0 OR GAME.MODE = 4 THEN
    Sumo(2).TileSet = 1
    IF HerbertG = 0 THEN
     IF WonGames < 7 THEN
      IF Sumo(1).TileSet = 2 THEN Sumo(1).Strength = 5: Sumo(1).Speed = 2
      IF Sumo(1).TileSet = 3 THEN Sumo(1).Strength = 6: Sumo(1).Speed = 2
      IF Sumo(1).TileSet = 4 THEN Sumo(1).Strength = 8: Sumo(1).Speed = 3
      IF Sumo(1).TileSet = 5 THEN Sumo(1).Strength = 14: Sumo(1).Speed = 3
     ELSE
      Sumo(1).Strength = Sumo(1).Strength + 1
      Sumo(1).Speed = Sumo(1).Speed + 1
      HerbertG = -1
     END IF
    END IF
    IF GAME.MODE = 0 OR GAME.MODE = 4 THEN
     IF GAME.MODE = 4 AND Fight >= 12 THEN
      IF Fight = 12 THEN Sumo(2).TileSet = 2: Sumo(2).Strength = 5: Sumo(2).Speed = 2: Sumo(2).Pname = "Ryu"
      IF Fight = 13 THEN Sumo(2).TileSet = 3: Sumo(2).Strength = 6: Sumo(2).Speed = 2: Sumo(2).Pname = "Oni"
      IF Fight = 14 THEN Sumo(2).TileSet = 4: Sumo(2).Strength = 8: Sumo(2).Speed = 3: Sumo(2).Pname = "Suki"
      IF Fight = 15 THEN Sumo(2).TileSet = 5: Sumo(2).Strength = 14: Sumo(2).Speed = 3: HaLoser = -1: Sumo(2).Pname = "Sumo X"
     ELSE
      Sumo(2).Pname = "Computer"
      Sumo(2).Strength = Place(Fight).Strength
      Sumo(2).Speed = Place(Fight).Speed
      Sumo(2).Col = Place(Fight).Col
      IF Sumo(2).Col = 0 THEN Sumo(2).Col = 14
      HaLoser = INT(RND * 15) + 1
     END IF
     IF FightSumoEx = 0 AND HaLoser = 15 THEN Sumo(2).Strength = 15: Sumo(2).Speed = 5: Sumo(2).Col = 16: FightSumoEx = -1
    END IF
    CALL CreateLayers(1, Sumo(1).TileSet): CALL CreateLayers(2, Sumo(2).TileSet)
    IF DQBloadImage(1, 0, 0, "DATA\STAND.PCX", Pal, 319, 199) THEN PRINT DQBerror$
    DQBboxF 1, 47, 14, 99, 49, Sumo(1).Col
    DQBboxF 1, 217, 14, 269, 49, Sumo(2).Col
    PlaceTile 6, Sumo(1).TileSet, 1, 47, 0, 51, 51
    PlaceTile 6, Sumo(2).TileSet, 1, 217, 0, 51, 51
    IF Sumo(1).TileSet = 1 THEN DQBline 1, 65, 7, 68, 3, Sumo(1).Col
    IF Sumo(2).TileSet = 1 THEN DQBline 1, 235, 7, 239, 3, Sumo(2).Col
   IF Fight > 1 THEN
    W = 0: l = 0
    FOR I = 1 TO Fight - 1
     IF Chart(Contestant, I) = -1 THEN W = W + 1 ELSE l = l + 1
    NEXT I
    FOR I = 1 TO (Fight - 1)
     IF Chart(30, I) = 0 THEN T$ = "Loss": Col = 4: Col2 = 12
     IF Chart(30, I) = -1 THEN T$ = "Win": Col = 1: Col2 = 9
     DQBprint 1, T$, 90 - (DQBlen(T$) \ 2), 63 + I * 9 - 9, Col
     DQBprint 1, T$, 90 - (DQBlen(T$) \ 2) + 1, 63 + I * 9 - 9 + 1, Col2
     WL$ = STR$(Sumo(1).Rank - 1) + ", " + STR$(Fight - Sumo(1).Rank)
     DQBprint 1, WL$, 90 - (DQBlen(WL$) \ 2), 54, Col2
     IF Chart(Contestant, I) = 0 THEN T$ = "Loss": Col = 4: Col2 = 12
     IF Chart(Contestant, I) = -1 THEN T$ = "Win": Col = 1: Col2 = 9
     DQBprint 1, T$, 229 - (DQBlen(T$) \ 2), 63 + I * 9 - 9, Col
     DQBprint 1, T$, 229 - (DQBlen(T$) \ 2) + 1, 63 + I * 9 - 9 + 1, Col2
     WL$ = STR$(W) + ", " + STR$(l)
     DQBprint 1, WL$, 229 - (DQBlen(WL$) \ 2), 54, Col2
    NEXT I
   END IF
   IF Sumo(1).Pname = "                    " THEN Sumo(1).Pname = "Player 1"
   IF Sumo(2).Pname = "                    " AND GAME.MODE = 0 THEN Sumo(2).Pname = "COMPUTER"
   IF Sumo(2).Pname = "                    " AND GAME.MODE = 3 THEN Sumo(2).Pname = "Player 2"
   DQBprint 1, Sumo(1).Pname, 51 - DQBlen(LTRIM$(RTRIM$(Sumo(1).Pname))), 43, 1
   DQBprint 1, Sumo(1).Pname, 52 - DQBlen(LTRIM$(RTRIM$(Sumo(1).Pname))), 44, 15
   DQBprint 1, Sumo(2).Pname, 265, 43, 1
   DQBprint 1, Sumo(2).Pname, 266, 44, 15
   DQBcopyLayer 1, 0
   DQBfadeIn Pal
   DO: LOOP UNTIL DQBinkey$ <> ""
   DQBfadeto 0, 0, 0
 END IF
 IF GAME.MODE > 0 AND GAME.MODE < 4 THEN Sumo(2).Strength = 1: Sumo(2).Speed = 1
 IF GAME.MODE = 3 THEN
  FOR I = 1 TO 2
  Sumo(I).Strength = INT(RND * 2) + 1
  Sumo(I).Speed = INT(RND * 2) + 1
  NEXT I
 END IF
 IF GAME.MODE > 0 AND GAME.MODE < 4 THEN
  IF Sumo(1).TileSet = 2 THEN Sumo(1).Strength = 5: Sumo(1).Speed = 2
  IF Sumo(1).TileSet = 3 THEN Sumo(1).Strength = 6: Sumo(1).Speed = 2
  IF Sumo(1).TileSet = 4 THEN Sumo(1).Strength = 8: Sumo(1).Speed = 2
  IF Sumo(1).TileSet = 5 THEN Sumo(1).Strength = 14: Sumo(1).Speed = 3
  IF Sumo(2).TileSet = 2 THEN Sumo(2).Strength = 5: Sumo(2).Speed = 2
  IF Sumo(2).TileSet = 3 THEN Sumo(2).Strength = 6: Sumo(2).Speed = 2
  IF Sumo(2).TileSet = 4 THEN Sumo(2).Strength = 8: Sumo(2).Speed = 2
  IF Sumo(2).TileSet = 5 THEN Sumo(2).Strength = 14: Sumo(2).Speed = 3
 END IF
 IF DQBloadImage(2, 0, 0, "DATA\SUMO.PCX", Pal, 319, 199) THEN PRINT DQBerror$
 DrawScreen 1
 DQBcopyLayer 1, 0
 MID$(Pal, ((81 * 3) + 1), 1) = STR$(ZZ)
 MID$(Pal, ((81 * 3) + 2), 1) = STR$(ZZ)
 MID$(Pal, ((81 * 3) + 3), 1) = STR$(BB)
 DQBfadeIn Pal
 IF FightSumoEx = -1 THEN FightSumoEx = -2: CALL SumoEX("DATA\SUMOEX.PCX")
 IF DQBloadImage(2, 0, 0, "DATA\SUMO.PCX", Pal, 319, 199) THEN PRINT DQBerror$
 IF SOUND.WAVSET THEN DQBplaySound 5, 1, 8000, ONCE: DQBwait 20
 IF SOUND.WAVSET THEN DQBplaySound 6, 1, 8000, ONCE: DQBwait 20
 IF SOUND.WAVSET THEN DQBplaySound 7, 1, 8000, ONCE: DQBwait 10
 FOR y = 120 TO 80 STEP -1
  Ref.y = Ref.y - 1
  DrawScreen 1
  DQBcopyLayer 1, 0
  DQBwait 1
 NEXT
 DQBsetVoiceVol 1, 63
 FOR I = 1 TO 2
  DQBprint 0, LTRIM$(RTRIM$(STR$(Sumo(I).Strength))) + ", " + RTRIM$(LTRIM$(STR$(Sumo(I).Speed))), Sumo(I).x, Sumo(I).y, 1
  DQBprint 0, LTRIM$(RTRIM$(STR$(Sumo(I).Strength))) + ", " + RTRIM$(LTRIM$(STR$(Sumo(I).Speed))), Sumo(I).x + 1, Sumo(I).y + 1, 15
 NEXT I
 SLEEP 1
RETURN


Qgme:
 DQBfadeto 0, 0, 0
 StopMidi
 UNLOADMIDI Handle%
 CLEANUPMIDI
 DQBclose
 END

REM $DYNAMIC
SUB Animations (Layer)
REM $DYNAMIC
CALL DrawScreen(Layer)
END SUB

FUNCTION CheckCollide (S, x, y)
 IF S = 1 THEN S2 = 2 ELSE S2 = 1
 IF x >= Sumo(S2).x AND y >= Sumo(S2).y AND x <= Sumo(S2).x + 12 AND y <= Sumo(S2).y + 12 THEN CheckCollide = -1
 IF x >= Sumo(S2).x AND y >= Sumo(S2).y AND x + 12 <= Sumo(S2).x + 12 AND y <= Sumo(S2).y + 12 THEN CheckCollide = -1
 IF x >= Sumo(S2).x AND y >= Sumo(S2).y AND x + 12 <= Sumo(S2).x + 12 AND y <= Sumo(S2).y + 12 THEN CheckCollide = -1
 IF x >= Sumo(S2).x AND y >= Sumo(S2).y AND x <= Sumo(S2).x + 12 AND y + 12 <= Sumo(S2).y + 12 THEN CheckCollide = -1
 Outring = 0
 DEF SEG = DQBmapLayer(2)
  IF x < 320 AND y < 200 THEN
   CC = PEEK(y * 320& + x)
   IF CC = 219 OR CC = 15 THEN
    Outring = 0
   ELSE
    Outring = S
   END IF
  END IF
 DEF SEG
 IF x > 319 OR x < 0 OR y > 199 OR y < 0 THEN Outring = S: CheckCollide = -1
END FUNCTION

REM $STATIC
SUB CreateLayers (SumoNumber, TT)
SELECT CASE TT
 CASE 0, 1, 5: F$ = "DATA\SUMO.PUT"
 CASE 2: F$ = "DATA\SUMO3.PUT"
 CASE 3: F$ = "DATA\SUMO4.PUT"
 CASE 4: F$ = "DATA\SUMO2.PUT"
END SELECT
IF SumoNumber = 1 THEN
 InitImageData F$, SumoTiles()
 MakeImageIndex SumoTiles(), SumoIndex()
ELSE
 InitImageData F$, SumoTiles2()
 MakeImageIndex SumoTiles2(), SumoIndex2()
END IF
IF SumoNumber = 1 THEN C = Sumo(1).Col: l = 3
IF SumoNumber = 2 THEN C = Sumo(2).Col: l = 4
DQBclearLayer l
FOR I = 1 TO 28
 O = O + 1
 IF O = 19 THEN
  O = 1: P = P + 1
 END IF
 IF O < 19 THEN
  IF SumoNumber = 1 THEN
    DQBput l, O * 17 - 16, P * 17, VARSEG(SumoTiles(SumoIndex(I))), VARPTR(SumoTiles(SumoIndex(I)))
   ELSE
    DQBput l, O * 17 - 16, P * 17, VARSEG(SumoTiles2(SumoIndex2(I))), VARPTR(SumoTiles2(SumoIndex2(I)))
  END IF
 END IF
 DEF SEG = DQBmapLayer(l)
 FOR x = O * 17 - 16 TO O * 17
 FOR y = P * 17 TO P * 17 + 16
  IF PEEK(y * 320& + x) = 15 THEN POKE y * 320& + x, C
 NEXT y
 NEXT x
NEXT I
END SUB

REM $DYNAMIC
SUB CreateSumo (S)
'FilterBox 3, 0, 0, 319, 198, 2, -1, 0
IF DQBloadImage(3, 0, 0, "DATA\BG.PCX", Pal, 319, 199) THEN PRINT DQBerror$
DQBclearLayer 2
DIM TT(1 TO 7)
DQBremoveKeyBoard
Cursor = 1
TT(2) = 4: TT(3) = 2
TT(4) = 1: TT(5) = 1
T1$ = "Player 1                "
Tpos = LEN(LTRIM$(RTRIM$(T1$)))
GOSUB DrawCreate
T! = TIMER
Points = 0
DO
 GOSUB DrawCreate
 I$ = INKEY$
 IF I$ <> "" THEN
  SELECT CASE I$
   CASE CHR$(0) + CHR$(KEYDOWN): Cursor = Cursor + 1
   CASE CHR$(0) + CHR$(KEYUP): Cursor = Cursor - 1
   CASE CHR$(0) + CHR$(KEYRIGHT)
    SELECT CASE Cursor
     CASE 2: IF TT(2) + TT(3) = 6 AND TT(Cursor) <= 4 THEN TT(3) = TT(3) - 1: TT(2) = TT(2) + 1 ELSE IF TT(2) <= 4 THEN TT(2) = TT(2) + 1
     CASE 3: IF TT(2) + TT(3) = 6 AND TT(Cursor) <= 4 THEN TT(2) = TT(2) - 1: TT(3) = TT(3) + 1 ELSE IF TT(3) <= 4 THEN TT(3) = TT(3) + 1
     CASE ELSE: TT(Cursor) = TT(Cursor) + 1
    END SELECT
   CASE CHR$(0) + CHR$(KEYLEFT)
    SELECT CASE Cursor
     CASE 2: IF TT(2) > 1 THEN TT(3) = TT(3) + 1: TT(2) = TT(2) - 1
     CASE 3: IF TT(3) > 1 THEN TT(2) = TT(2) + 1: TT(3) = TT(3) - 1
     CASE ELSE: TT(Cursor) = TT(Cursor) - 1
    END SELECT
   CASE CHR$(27): EXIT DO
   CASE CHR$(13): IF Cursor = 5 THEN EXIT DO
                  Cursor = Cursor + 1
   CASE CHR$(8): IF Cursor = 1 THEN Tpos = Tpos - 1: MID$(T1$, Tpos + 1, 1) = " ": GOSUB DrawCreate: IF Tpos < 1 THEN Tpos = 1
   CASE ELSE
    IF Cursor = 1 THEN
     IF Tpos > 30 THEN Tpos = 20
     Tpos = Tpos + 1
     MID$(T1$, Tpos, 1) = I$
    END IF
  END SELECT
 END IF
 IF TT(2) < 1 THEN TT(2) = 1
 IF TT(3) > 5 THEN TT(3) = 5
LOOP
DQBinstallKeyBoard
IF DQBloadImage(2, 0, 0, "DATA\SUMO.PCX", Pal, 319, 199) THEN DQBclose: StopMidi: PRINT DQBerror$: END
DQBsetPal Pal
EXIT SUB
DrawCreate:
 DQBcopyLayer 3, 1
 IF Cursor < 1 THEN Cursor = 5
 IF Cursor > 5 THEN Cursor = 1
 IF TT(4) > 255 THEN TT(4) = 0
 IF TT(4) < 0 THEN TT(4) = 255
 Sumo(S).Pname = T1$
 Sumo(S).Strength = TT(2)
 Sumo(S).Speed = TT(3)
 Sumo(S).Col = TT(4)
 T2$ = LTRIM$(RTRIM$(STR$(Sumo(S).Strength)))
 T3$ = LTRIM$(RTRIM$(STR$(Sumo(S).Speed)))
 T4$ = RTRIM$(LTRIM$(STR$(Sumo(S).Col)))
 DQBprintBack 1, "Name:", 4, 14, 9, 15
 DQBprintBack 1, T1$, 75, 14, 9, 15
 DQBprintBack 1, "Strength:", 4, 25, 9, 15
 DQBprintBack 1, T2$, 75, 25, 9, 15
 DQBprintBack 1, "Speed:", 4, 36, 9, 15
 DQBprintBack 1, T3$, 75, 36, 9, 15
 DQBprintBack 1, "Color:", 4, 47, 9, 15
 DQBprintBack 1, T4$, 75, 47, 9, 15
 DQBprintBack 1, ":", 4, 58, 9, 15
 DQBprintBack 1, T5$, 75, 58, 9, 15
 DQBboxF 1, 105, 47, 125, 52, Sumo(S).Col
 DQBboxF 1, 211, 11, 260, 59, Sumo(S).Col
 PlaceTile 6, 1, 1, 210, 11, 51, 48
 T$ = "Create Sumo " + STR$(S)
 FilterBox 1, 0, 0, 318, 10, 4, 0, 15
 DQBprintBack 1, T$, 110, 3, 9, 15
 FilterBox 1, 0, 58, 318, 68, 3, 0, 15
 DQBprintBack 1, "OK", 155, 60, 9, 15
 IF Cursor = 5 THEN
  FilterBox 1, 0, 58, 318, 68, 4, 0, 15
  DQBprintBack 1, "OK", 155, 60, 9, 15
 ELSE
  FilterBox 1, 0, Cursor * 11, 69, Cursor * 11 + 11, 4, 0, 15
  SELECT CASE Cursor
   CASE 1: T$ = "Name:"
   CASE 2: T$ = "Strength:"
   CASE 3: T$ = "Speed:"
   CASE 4: T$ = "Color:"
  END SELECT
  DQBprintBack 1, T$, 4, (Cursor * 11) + 3, 9, 15
 END IF
 SC = SC + 3
 DQBcopyLayer 1, 0
RETURN
END SUB

REM $STATIC
SUB DoKeys (S, C)
REM $DYNAMIC
Outring = 0
Requests = 0
IF DQBkey(1) THEN QuitGame = -1

IF Sumo(S).offX = 0 AND Sumo(S).offY = 0 THEN
 SELECT CASE C
  CASE 1
   IF DQBkey(KEYDOWN) THEN Requests = Requests + 1: KeyRequest(Requests) = 1
   IF DQBkey(KEYRIGHT) THEN Requests = Requests + 1: KeyRequest(Requests) = 2
   IF DQBkey(KEYUP) THEN Requests = Requests + 1: KeyRequest(Requests) = 3
   IF DQBkey(KEYLEFT) THEN Requests = Requests + 1: KeyRequest(Requests) = 4
   IF DQBkey(KEYSPACE) AND Sumo(S).Action = 0 THEN
    IF Sumo(S).SpecialBlocks = 4 THEN
     RANDOMIZE TIMER
     AA = INT((5 - 2 + 1) * RND + 2)
     Sumo(S).Action = AA
    ELSE
     Sumo(S).Action = 1
    END IF
    Sumo(S).Stamina = Sumo(S).Stamina - 1
   END IF
   IF DQBkey(29) AND Sumo(S).Action = 0 AND Sumo(S).SpecialBlocks = 4 THEN Sumo(S).Action = 2: Sumo(S).Stamina = Sumo(S).Stamina - 1
  CASE 2
   DQBpollJoy (JOY1)
   IF DQBjoyMove(JOY1, DOWN) THEN Requests = Requests + 1: KeyRequest(Requests) = 1
   IF DQBjoyMove(JOY1, RIGHT) THEN Requests = Requests + 1: KeyRequest(Requests) = 2
   IF DQBjoyMove(JOY1, UP) THEN Requests = Requests + 1: KeyRequest(Requests) = 3
   IF DQBjoyMove(JOY1, LEFT) THEN Requests = Requests + 1: KeyRequest(Requests) = 4
   IF DQBjoyFire(JOY1, BUTA) AND Sumo(S).Action = 0 THEN
    IF Sumo(S).SpecialBlocks = 4 THEN Sumo(S).Action = 4 ELSE Sumo(S).Action = 1
    Sumo(S).Stamina = Sumo(S).Stamina - 1
   END IF
   IF DQBjoyFire(JOY1, BUTB) AND Sumo(S).Action = 0 AND Sumo(S).SpecialBlocks = 4 THEN Sumo(S).Action = 2: Sumo(S).Stamina = Sumo(S).Stamina - 1
  CASE 3
   IF S = 1 THEN S2 = 2 ELSE S2 = 1
    IF Sumo(S).Action = 0 AND Sumo(S).Shock = 0 THEN
     SELECT CASE Sumo(S).Stamina
      CASE IS < 15
       Sumo(S).Shock = 100 - Sumo(S).Stamina
      CASE ELSE
       IF Sumo(S).x < 80 AND Sumo(S).Direction = 2 THEN
        FOR SSS = Sumo(S).Speed TO 1 STEP -1
         IF KKK THEN EXIT FOR
         IF Sumo(S).x + SSS <> Sumo(S2).x AND Sumo(S).y <> Sumo(S2).y THEN Sumo(S).x = Sumo(S).x + SSS: KKK = -1
         IF Sumo(S).CommonDir = 0 AND Sumo(S).y < 135 THEN Sumo(S).CommonDir = 1
         IF Sumo(S).CommonDir = 0 AND Sumo(S).y > 135 THEN Sumo(S).CommonDir = 2
         IF Sumo(S).CommonDir = 1 THEN IF Sumo(S).y + SSS <> Sumo(S2).y AND CheckCollide(S, Sumo(S).x, Sumo(S).y + SSS) = 0 AND Outring = 0 THEN Sumo(S).y = Sumo(S).y + SSS: M = -1: KKK = -1
         IF Sumo(S).CommonDir = 2 THEN IF Sumo(S).y - SSS <> Sumo(S2).y AND CheckCollide(S, Sumo(S).x, Sumo(S).y - SSS) = 0 AND Outring = 0 THEN Sumo(S).y = Sumo(S).y - SSS: M = -1: KKK = -1
        NEXT
       END IF
       IF Sumo(S).x > 239 AND Sumo(S).Direction = 4 THEN
       FOR SSS = Sumo(S).Speed TO 1 STEP -1
        IF KKK THEN EXIT FOR
        IF Sumo(S).x + SSS <> Sumo(S2).x AND Sumo(S).y <> Sumo(S2).y THEN Sumo(S).x = Sumo(S).x - SSS: KKK = -1
        IF Sumo(S).CommonDir = 0 AND Sumo(S).y < 100 THEN Sumo(S).CommonDir = 1
        IF Sumo(S).CommonDir = 0 AND Sumo(S).y > 150 THEN Sumo(S).CommonDir = 2
        IF Sumo(S).CommonDir = 1 THEN IF Sumo(S).y + SSS <> Sumo(S2).y AND CheckCollide(S, Sumo(S).x, Sumo(S).y + SSS) = 0 AND Outring = 0 THEN Sumo(S).y = Sumo(S).y + SSS: M = -1: KKK = -1
        IF Sumo(S).CommonDir = 2 THEN IF Sumo(S).y - SSS <> Sumo(S2).y AND CheckCollide(S, Sumo(S).x, Sumo(S).y - SSS) = 0 AND Outring = 0 THEN Sumo(S).y = Sumo(S).y - SSS: M = -1: KKK = -1
       NEXT
       END IF
       IF Sumo(S).y < 52 AND Sumo(S).Direction = 1 THEN
        FOR SSS = Sumo(S).Speed TO 1 STEP -1
         IF KKK THEN EXIT FOR
         IF Sumo(S).y + SSS <> Sumo(S2).y AND Sumo(S).x <> Sumo(S2).x THEN Sumo(S).y = Sumo(S).y + SSS: KKK = -1
         MoveSumo = INT(RND * 2)
         IF MoveSumo = 1 THEN
          IF Sumo(S).CommonDir = 0 THEN Sumo(S).CommonDir = INT(RND * 1) + 1
          IF Sumo(S).CommonDir = 1 THEN IF Sumo(S).x - SSS <> Sumo(S2).x AND CheckCollide(S, Sumo(S).x - SSS, Sumo(S).y) = 0 AND Outring = 0 THEN Sumo(S).x = Sumo(S).x - SSS: M = -1: KKK = -1
          IF Sumo(S).CommonDir = 2 THEN IF Sumo(S).x + SSS <> Sumo(S2).x AND CheckCollide(S, Sumo(S).x + SSS, Sumo(S).y) = 0 AND Outring = 0 THEN Sumo(S).x = Sumo(S).x + SSS: M = -1: KKK = -1
         END IF
        NEXT
       END IF
       IF Sumo(S).y > 147 AND Sumo(S).Direction = 3 THEN
       FOR SSS = Sumo(S).Speed TO 1 STEP -1
        IF KKK THEN EXIT FOR
        IF Sumo(S).y - SSS <> Sumo(S2).y AND Sumo(S).x <> Sumo(S2).x THEN Sumo(S).y = Sumo(S).y - SSS: KKK = -1
        IF Sumo(S).CommonDir = 0 THEN Sumo(S).CommonDir = INT(RND * 1) + 1
        IF Sumo(S).CommonDir = 1 THEN IF Sumo(S).x - SSS <> Sumo(S2).x AND CheckCollide(S, Sumo(S).x - SSS, Sumo(S).y) = 0 AND Outring = 0 THEN Sumo(S).x = Sumo(S).x - SSS: M = -1: KKK = -1
        IF Sumo(S).CommonDir = 2 THEN IF Sumo(S).x + SSS <> Sumo(S2).x AND CheckCollide(S, Sumo(S).x + SSS, Sumo(S).y) = 0 AND Outring = 0 THEN Sumo(S).x = Sumo(S).x + SSS: M = -1: KKK = -1
       NEXT
       END IF
       IF M = 0 THEN
        IF Sumo(S2).x > Sumo(S).x THEN Requests = Requests + 1: KeyRequest(Requests) = 2
        IF Sumo(S2).x < Sumo(S).x THEN Requests = Requests + 1: KeyRequest(Requests) = 4
        IF Sumo(S2).y > Sumo(S).y THEN Requests = Requests + 1: KeyRequest(Requests) = 1
        IF Sumo(S2).y < Sumo(S).y THEN Requests = Requests + 1: KeyRequest(Requests) = 3
       END IF
      Z = ABS(Sumo(1).x - Sumo(2).x): Z2 = ABS(Sumo(1).y - Sumo(2).y)
      IF Z < 15 AND Z2 < 15 THEN
        IF Sumo(S).SpecialBlocks = 4 THEN
         RANDOMIZE TIMER
         AA = INT((5 - 2 + 1) * RND + 2)
         Sumo(S).Action = AA
         Sumo(S).SpecialBlocks = 0: Sumo(S).SpecialCount = 0
        ELSE
         Sumo(S).Action = 1: Sumo(S).Stamina = Sumo(S).Stamina - 1
        END IF
      END IF
      M = 0
     END SELECT
   END IF
  END SELECT
END IF

IF Requests THEN
 FOR I = 1 TO Requests
  SELECT CASE KeyRequest(I)
   CASE 1: y = Sumo(S).Speed: x = 0: Sumo(S).Direction = 1
   CASE 2: x = Sumo(S).Speed: y = 0: Sumo(S).Direction = 2
   CASE 3: y = -Sumo(S).Speed: x = 0: Sumo(S).Direction = 3
   CASE 4: x = -Sumo(S).Speed: y = 0: Sumo(S).Direction = 4
  END SELECT
  IF x THEN
  IF x > 0 THEN SS = -1 ELSE SS = 1
  IF x = 1 THEN SS = 1
  YY = 0
  FOR XX = x TO SS STEP SS
   IF x = 0 THEN XX = 0
    IF CheckCollide(S, Sumo(S).x + XX, Sumo(S).y + 12 + YY) = 0 AND CheckCollide(S, Sumo(S).x + 12 + XX, Sumo(S).y + 12 + YY) = 0 THEN
    IF Outring = 0 AND CheckCollide(S, Sumo(S).x + 12 + XX, Sumo(S).y + YY + 12) = 0 AND CheckCollide(S, Sumo(S).x + XX, Sumo(S).y + YY + 12) = 0 THEN
     IF Outring = 0 AND CheckCollide(S, Sumo(S).x + XX, Sumo(S).y + 12 + YY) = 0 THEN
      IF Outring = 0 THEN Sumo(S).x = Sumo(S).x + XX: Sumo(S).y = Sumo(S).y + YY
      IF Sumo(S).Action = 0 THEN
       Sumo(S).ActionCount = Sumo(S).ActionCount + 1
       IF Sumo(S).ActionCount = 3 THEN Sumo(S).Frame = Sumo(S).Frame + 1: Sumo(S).ActionCount = 0
       IF Sumo(S).Frame = 4 THEN Sumo(S).Frame = 0
       GOTO NextFactor
      END IF
      GAME.Winner = Outring
     END IF
    END IF
    END IF
    NoGo = 0
   NEXT
  END IF
  IF y THEN
   XX = 0
   IF y > 0 THEN SS = -1 ELSE SS = 1
   IF y = 1 THEN SS = 1
   FOR YY = y TO SS STEP SS
    IF y = 0 THEN YY = 0
    IF CheckCollide(S, Sumo(S).x + x, Sumo(S).y + 12 + YY) = 0 AND CheckCollide(S, Sumo(S).x + 12 + x, Sumo(S).y + 12 + YY) = 0 THEN
    IF Outring = 0 AND CheckCollide(S, Sumo(S).x + 12 + x, Sumo(S).y + YY + 12) = 0 AND CheckCollide(S, Sumo(S).x + x, Sumo(S).y + YY + 12) = 0 THEN
     IF Outring = 0 AND CheckCollide(S, Sumo(S).x + x, Sumo(S).y + 12 + YY) = 0 THEN
      IF Outring = 0 THEN Sumo(S).x = Sumo(S).x + x: Sumo(S).y = Sumo(S).y + YY
      IF Sumo(S).Action = 0 THEN
       Sumo(S).ActionCount = Sumo(S).ActionCount + 1
       IF Sumo(S).ActionCount = 3 THEN Sumo(S).Frame = Sumo(S).Frame + 1: Sumo(S).ActionCount = 0
       IF Sumo(S).Frame = 4 THEN Sumo(S).Frame = 0
       GOTO NextFactor
      END IF
      GAME.Winner = Outring
     END IF
    END IF
    END IF
    NoGo = 0
   NEXT
  END IF
NextFactor:
 NEXT
END IF
END SUB

REM $STATIC
SUB DrawScreen (Layer)
REM $DYNAMIC
 IF Sumo(1).x < Sumo(2).x THEN x1 = 1: x2 = 2
 IF Sumo(2).x < Sumo(1).x THEN x1 = 2: x2 = 1
 IF x1 = 0 THEN x1 = 1: x2 = 2
 Ref.x = Sumo(x1).x + ((Sumo(x2).x - Sumo(x1).x) / 2)
 DQBcopyLayer 2, Layer
 CALL DrawSumo(1, Layer)
 CALL DrawSumo(2, Layer)
 DQBboxF Layer, 11, 1, 110, 24, Sumo(1).Col
 DQBboxF Layer, 200, 1, 299, 24, Sumo(2).Col
 FilterBox Layer, 10, 0, 110, 25, -1, Sumo(1).Col, 15
 FilterBox Layer, 199, 0, 299, 25, -1, Sumo(2).Col, 15
 FOR x = 1 TO 100
  C = INT(x \ 16) + 248
  IF x MOD 2 = 0 THEN C = 16
  IF Sumo(1).Stamina >= x THEN DQBline Layer, x + 10, 1, x + 10, 10, C
  IF Sumo(2).Stamina >= x THEN DQBline Layer, x + 199, 1, x + 199, 10, C
 NEXT x
 DQBgline Layer, 11, 11, 13 + Sumo(1).StaminaCount, 11, 70, 79
 DQBgline Layer, 200, 11, 200 + Sumo(2).StaminaCount, 11, 70, 79
 DQBline Layer, 10, 10, 110, 10, 15
 DQBline Layer, 199, 10, 299, 10, 15
 FOR x = 1 TO 4
  IF Sumo(1).SpecialBlocks >= x THEN C = 81 ELSE C = Sumo(1).Col
  IF Sumo(2).SpecialBlocks >= x THEN c2 = 81 ELSE c2 = Sumo(2).Col
  FilterBox Layer, 10 + (x * 25) - 25, 12, 10 + (x * 25), 23, 0, C, 15
  FilterBox Layer, 199 + (x * 25) - 25, 12, 199 + (x * 25), 23, 0, c2, 15
  FilterBox Layer, 10 + (x * 25) - 25, 12, 10 + (x * 25), 23, 0, 0, 15
  FilterBox Layer, 199 + (x * 25) - 25, 12, 199 + (x * 25), 23, 0, 0, 15
 NEXT x
 DQBgline Layer, 11, 24, 12 + Sumo(1).SpecialCount, 24, 70, 79
 DQBgline Layer, 200, 24, 200 + Sumo(2).SpecialCount, 24, 70, 79
 T1$ = LTRIM$(RTRIM$(Sumo(1).Pname))
 T2$ = LTRIM$(RTRIM$(Sumo(2).Pname))
 DQBprintBack Layer, T1$, 10, 27, 9, 15
 DQBprintBack Layer, T2$, 200, 27, 9, 15
 x = 155 - (DQBlen("SUMO") / 2)
 DQBprintBack Layer, "SUMO", x, 3, 9, 15
 x = 160 - (DQBlen(STR$(GAME.TimeLeft)) / 2)
 T$ = LTRIM$(RTRIM$(STR$(GAME.TimeLeft)))
 DQBprintBack Layer, T$, x, 13, 9, 15
END SUB

REM $STATIC
SUB DrawSumo (S, Layer)
 DQBcopyLayer 2, Layer
 IF Sumo(1).Direction = mDown AND Sumo(2).Direction = mUp THEN GOSUB DrawSumo2: D2 = -1
 IF Sumo(2).Direction = mDown AND Sumo(1).Direction = mUp THEN GOSUB DrawSumo1: D1 = -1
 IF D1 = 0 AND Sumo(1).y > Sumo(2).y THEN GOSUB DrawSumo1: D1 = -1
 IF D2 = 0 AND Sumo(1).y < Sumo(2).y THEN GOSUB DrawSumo2: D2 = -1
 IF D1 = 0 THEN GOSUB DrawSumo1
 IF D2 = 0 THEN GOSUB DrawSumo2
 D1 = 0: D2 = 0
 DQBput Layer, Ref.x, Ref.y, VARSEG(SumoTiles(SumoIndex(25))), VARPTR(SumoTiles(SumoIndex(25)))
EXIT SUB
DrawSumo1:
  I = 1
  IF Sumo(I).Action = 0 THEN
    IF Sumo(I).Frame = 0 THEN RealFrame = 1
    IF Sumo(I).Frame = 1 THEN RealFrame = 0
    IF Sumo(I).Frame = 2 THEN RealFrame = 1
    IF Sumo(I).Frame = 3 THEN RealFrame = 2
    Tile = ((Sumo(I).Direction * 6) - 5) + RealFrame
   ELSE
    Tile = ((Sumo(I).Direction * 6) - 3) + Sumo(I).Frame
   END IF
   IF Sumo(I).HitWPower THEN
    SELECT CASE Sumo(I).offX
    CASE IS < 0
     FOR y = Sumo(I).y TO Sumo(I).y + 16
      DQBgline Layer, Sumo(I).x + 10, y, Sumo(I).x + 10 + ABS(Sumo(I).offX), Sumo(I).y + 8, 240, 255
     NEXT y
     IF Sumo(I).offX = 0 THEN Sumo(I).HitWPower = 0
    CASE IS > 0
     FOR y = Sumo(I).y TO Sumo(I).y + 16
      DQBgline Layer, Sumo(I).x + 6, y, Sumo(I).x + 6 - ABS(Sumo(I).offX), Sumo(I).y + 8, 240, 255
     NEXT y
     IF ABS(Sumo(I).offX) = 1 THEN Sumo(I).HitWPower = 0
    END SELECT
   END IF
   IF Tile <= 0 THEN Tile = 7
   IF Sumo(I).Shock = 0 THEN
    PlaceTile 3, Tile, Layer, Sumo(I).x, Sumo(I).y, 17, 17
   ELSE
    DQBhPut Layer, Sumo(I).x, Sumo(I).y, VARSEG(SumoTiles(SumoIndex(Tile))), VARPTR(SumoTiles(SumoIndex(Tile))), 73
   END IF
RETURN
DrawSumo2:
  I = 2
  IF Sumo(I).Action = 0 THEN
    IF Sumo(I).Frame = 0 THEN RealFrame = 1
    IF Sumo(I).Frame = 1 THEN RealFrame = 0
    IF Sumo(I).Frame = 2 THEN RealFrame = 1
    IF Sumo(I).Frame = 3 THEN RealFrame = 2
    Tile = ((Sumo(I).Direction * 6) - 5) + RealFrame
   ELSE
    Tile = ((Sumo(I).Direction * 6) - 3) + Sumo(I).Frame
   END IF
   IF Sumo(I).HitWPower THEN
    SELECT CASE Sumo(I).offX
    CASE IS < 0
     FOR y = Sumo(I).y TO Sumo(I).y + 16
      DQBgline Layer, Sumo(I).x + 10, y, Sumo(I).x + 10 + ABS(Sumo(I).offX), Sumo(I).y + 8, 240, 255
     NEXT y
     IF Sumo(I).offX = 0 THEN Sumo(I).HitWPower = 0
    CASE IS > 0
     FOR y = Sumo(I).y TO Sumo(I).y + 16
      DQBgline Layer, Sumo(I).x + 6, y, Sumo(I).x + 6 - ABS(Sumo(I).offX), Sumo(I).y + 8, 240, 255
     NEXT y
     IF ABS(Sumo(I).offX) = 1 THEN Sumo(I).HitWPower = 0
    END SELECT
   END IF
   IF Tile <= 0 THEN Tile = 19
   IF Sumo(I).Shock = 0 THEN
    PlaceTile 4, Tile, Layer, Sumo(I).x, Sumo(I).y, 17, 17
   ELSE
    DQBhPut Layer, Sumo(I).x, Sumo(I).y, VARSEG(SumoTiles2(SumoIndex2(Tile))), VARPTR(SumoTiles2(SumoIndex2(Tile))), 73
   END IF
RETURN


END SUB

REM $DYNAMIC
SUB Gui (EXT$)
DQBremoveKeyBoard
DIM TheGui(1 TO 25, 1 TO 3) AS STRING
DIM TheGuiFrames(1 TO 25)
DIM TheGuiFrame(1 TO 25)
DIM TheGuiStep(1 TO 25)
RedoGui:
IF Unleash(3) THEN
 IF UCASE$(EXT$) = "MAINMNU" THEN EXT$ = "MAINMNU2"
END IF
MaxTextPer = 17
OPEN "DATA\" + LTRIM$(RTRIM$(EXT$)) + LTRIM$(RTRIM$(".DAT")) FOR INPUT AS #1
 INPUT #1, Title$, Rows, HaveGraphBar
 INPUT #1, LeftBar, MidBar, RightBar
 INPUT #1, LeftBar$, MidBar$, RightBar$
 IF HaveGraphBar THEN offY = 11: MaxTextPer = MaxTextPer - 2
 FOR G = 1 TO Rows
  INPUT #1, TheGui(G, 1), TheGui(G, 2), TheGui(G, 3)
  IF GBB = 0 AND TheGui(G, 1) <> "0" THEN GBB = -1: MaxTextPer = 7
  IF TheGui(G, 1) <> "0" THEN
   INPUT #1, TheGuiFrames(G)
  END IF
 NEXT G
CLOSE #1
IF MaxTextPer > Rows THEN MaxTextPer = Rows
x1 = 50: x2 = 270: y1 = 20: y2 = 180
IF LeftBar THEN offX = 20
Locat = 1: Slocat = 0
IF HaveGraphBar THEN
 StepY = INT(140 / MaxTextPer)
ELSE
 StepY = INT(150 / MaxTextPer)
END IF
DQBboxF 2, 50, 20, 270, 180, 172
FOR x = 50 TO 270 STEP 1
FOR y = 20 TO 180 STEP 1
 r = INT(RND * 2): IF r = 1 THEN DQBpset 2, x, y, INT(RND * 5) + 168
NEXT
NEXT
DQBfadeIn Pal
DQBremoveKeyBoard: GOSUB DrawGui

DO
 Angle! = Angle! + .2
 IF Angle! = 6.28 THEN Angle! = 0
 I$ = INKEY$
 IF I$ = CHR$(13) THEN DQBplaySound 2, 1, 22050, ONCE: GOSUB SelectGui
 IF I$ = CHR$(0) + CHR$(KEYDOWN) THEN
  IF Locat < MaxTextPer THEN
   Locat = Locat + 1: DQBplaySound 3, 1, 22050, ONCE
  ELSE
   IF Rows <> MaxTextPer THEN
    IF Slocat + 1 + Locat <= Rows THEN Slocat = Slocat + 1: DQBplaySound 3, 1, 11050, ONCE
    Locat = MaxTextPer
   ELSE
    Locat = Locat + 1: DQBplaySound 3, 1, 22050, ONCE
   END IF
   IF Locat > Rows THEN Locat = Rows
  END IF
  GOSUB DrawGui
 END IF
 IF I$ = CHR$(0) + CHR$(KEYUP) THEN
  IF Slocat > 0 THEN
   IF Locat = 1 THEN
    Slocat = Slocat - 1
    DQBplaySound 3, 1, 22050, ONCE
   ELSE
    IF Locat >= 2 THEN Locat = Locat - 1: DQBplaySound 3, 1, 22050, ONCE
   END IF
  ELSE
   IF Locat >= 2 THEN Locat = Locat - 1: DQBplaySound 3, 1, 22050, ONCE
  END IF
 END IF
 GOSUB DrawGui
 DQBwait 1
 FOR G = 1 TO Rows
   TheGuiStep(G) = TheGuiStep(G) + 1
    IF TheGuiStep(G) = 4 THEN
     TheGuiStep(G) = 0
     TheGuiFrame(G) = TheGuiFrame(G) + 1
     IF TheGuiFrame(G) > TheGuiFrames(G) THEN TheGuiFrame(G) = 0
    END IF
 NEXT G
LOOP
DQBinstallKeyBoard
DO: LOOP UNTIL DQBinkey$ <> ""
ERASE TheGui
EXIT SUB
DrawGui:
IF Locat < 1 THEN Locat = 1
DQBcopyTransLayer 2, 1
IF LeftBar THEN DQBboxF 1, 51, 42, 51 + offX, 179, 172
FOR G = 1 TO MaxTextPer
 IF Locat = G THEN
  GG = G
  IF HaveGraphBar = 0 THEN
   YY2 = 31 + offY + (GG * StepY)
   IF YY2 > 179 THEN YY2 = 179
   FilterBox 1, 51, 31 + offY + (GG * StepY - StepY), 269, YY2, 3, 0, 15
  ELSE
   YY2 = 31 + offY + (GG * StepY)
   IF YY2 > 179 THEN YY2 = 179
   FilterBox 1, 51, 31 + offY + ((GG * StepY) - StepY), 269, YY2, 3, 0, 15
  END IF
 END IF
NEXT
FOR LY = 21 TO 31
 DQBgline 1, 51, LY, 269, LY, 52, 60
NEXT
DQBline 1, 51, 31, 269, 31, 9
DQBprintBack 1, Title$, 160 - (DQBlen(Title$) / 2) + 1, 23, 9, 15
FOR G = Slocat + 1 TO Slocat + 1 + MaxTextPer - 1
 GG = G - (Slocat + 1)
 IF Locat + Slocat = G THEN
   FOR B = 1 TO LEN(RTRIM$(LTRIM$(TheGui(G, 2))))
    DQBprintBack 1, MID$(TheGui(G, 2), B, 1), 160 - (LEN(TheGui(G, 2)) * 3) + B * 7 - 7, 32 + (INT(StepY / 2) - INT(StepY / 5)) + offY + (GG * StepY) + 4 * COS(Angle! + B), 16, 15
   NEXT B
 ELSE
  DQBprintBack 1, TheGui(G, 2), 160 - (LEN(TheGui(G, 2)) * 3), 32 + offY + (GG * StepY) + (StepY / 2) - 4, 16, 15
 END IF
NEXT G
DQBbox 1, 50, 20, 272, 182, 16: DQBbox 1, 50, 20, 273, 183, 16
DQBbox 1, 50, 20, 270, 180, 15: DQBbox 1, 49, 19, 271, 181, 15
DQBcopyLayer 1, 0
RETURN
SelectGui:
 SELECT CASE UCASE$(EXT$)
  CASE "MAINMNU", "MAINMNU2"
   IF Locat + Slocat = 1 THEN
   GAME.MODE = 0
   Sumo(1).Rank = 1
   IF Controller(1) = 3 THEN Controller(1) = 1
   Controller(2) = 3
   FOR I = 1 TO 15
    Place(I).Strength = I * 2 \ 4 + INT(RND * 2) + INT(RND * -3): Place(I).Strength = Place(I).Strength + INT(RND * GAME.DIFF + 2)
    IF Place(I).Strength <= 0 THEN Place(I).Strength = 1
    Place(I).Col = INT(RND * 15)
    Place(I).Speed = I MOD 10
    Place(I).Speed = Place(I).Speed \ 2: Place(I).Speed = Place(I).Speed + INT(RND * GAME.DIFF)
    IF Place(I).Speed = 0 THEN Place(I).Speed = 1
   NEXT I
   CALL SelectSumo(1): IF QuitGame THEN EXIT SUB
   IF Sumo(1).TileSet = 1 THEN
    CALL CreateSumo(1)
   ELSE
    IF Sumo(1).TileSet = 2 THEN Sumo(1).Pname = "Ryu"
    IF Sumo(1).TileSet = 3 THEN Sumo(1).Pname = "Oni"
    IF Sumo(1).TileSet = 4 THEN Sumo(1).Pname = "Suki"
    IF Sumo(1).TileSet = 5 THEN Sumo(1).Pname = "Sumo X": Sumo(1).Col = 16: CALL CreateLayers(1, Sumo(1).TileSet)
   END IF
   DQBinstallKeyBoard
   EXIT SUB
   END IF
   IF Locat + Slocat = 2 THEN
    CALL SelectSumo(1): IF QuitGame THEN EXIT SUB
    IF Sumo(1).TileSet = 1 THEN
     CALL CreateSumo(1)
    ELSE
     IF Sumo(1).TileSet = 2 THEN Sumo(1).Pname = "Ryu"
     IF Sumo(1).TileSet = 3 THEN Sumo(1).Pname = "Oni"
     IF Sumo(1).TileSet = 4 THEN Sumo(1).Pname = "Suki"
     IF Sumo(1).TileSet = 5 THEN Sumo(1).Pname = "Sumo X": Sumo(1).Col = 16: CALL CreateLayers(1, Sumo(1).TileSet)
    END IF
    FOR I = 1 TO 15
     Place(I).Strength = I * 2 \ 4 + INT(RND * 2) + INT(RND * -3): Place(I).Strength = Place(I).Strength + INT(RND * GAME.DIFF + 2)
     IF Place(I).Strength <= 0 THEN Place(I).Strength = 1
     Place(I).Col = INT(RND * 15)
     Place(I).Speed = I MOD 10
     Place(I).Speed = Place(I).Speed \ 2: Place(I).Speed = Place(I).Speed + INT(RND * GAME.DIFF)
     IF Place(I).Speed = 0 THEN Place(I).Speed = 1
    NEXT I
    II = INT(RND * 14) + 1
    Sumo(2).Col = Place(II).Col
    Sumo(2).Strength = Place(II).Strength
    Sumo(2).Speed = Place(II).Speed
    Controller(2) = 3: GAME.MODE = 2
    DQBinstallKeyBoard
    EXIT SUB
   END IF
   IF Locat + Slocat = 3 THEN
    IF Controller(1) = 3 THEN Controller(1) = 1
    IF Controller(1) = 1 THEN Controller(2) = 2 ELSE Controller(2) = 1
    GAME.MODE = 3
    CALL SelectSumo(1): IF QuitGame THEN EXIT SUB
    IF Sumo(1).TileSet = 1 THEN
     CALL CreateSumo(1)
    ELSE
     IF Sumo(1).TileSet = 2 THEN Sumo(1).Pname = "Ryu"
     IF Sumo(1).TileSet = 3 THEN Sumo(1).Pname = "Oni"
     IF Sumo(1).TileSet = 4 THEN Sumo(1).Pname = "Suki"
     IF Sumo(1).TileSet = 5 THEN Sumo(1).Pname = "Sumo X": Sumo(1).Col = 16: CALL CreateLayers(1, Sumo(1).TileSet)
    END IF
    CALL SelectSumo(2): IF QuitGame THEN EXIT SUB
    IF Sumo(2).TileSet = 1 THEN
     CALL CreateSumo(2)
    ELSE
     IF Sumo(2).TileSet = 2 THEN Sumo(2).Pname = "Ryu"
     IF Sumo(2).TileSet = 3 THEN Sumo(2).Pname = "Oni"
     IF Sumo(2).TileSet = 4 THEN Sumo(2).Pname = "Suki"
     IF Sumo(2).TileSet = 5 THEN Sumo(2).Pname = "Sumo X": Sumo(2).Col = 16: CALL CreateLayers(2, Sumo(2).TileSet)
    END IF
    DQBinstallKeyBoard
   EXIT SUB
   END IF
   IF Locat + Slocat = 4 THEN
    Sumo(1).Col = RND * 14 + 1
    Sumo(2).Col = RND * 14 + 1
    GAME.MODE = 3
    CALL CreateLayers(1, Sumo(1).TileSet): CALL CreateLayers(2, Sumo(2).TileSet)
    Controller(1) = 3: Controller(2) = 3
    EXIT SUB
   END IF
   IF EXT$ = "MAINMNU" THEN LFO = 5 ELSE LFO = 6
   IF Locat + Slocat = LFO - 1 AND LFO <> 5 THEN
    GAME.MODE = 4
   FOR I = 1 TO 15
    Place(I).Strength = I * 2 \ 4 + INT(RND * 2) + INT(RND * -3): Place(I).Strength = Place(I).Strength + INT(RND * 1 + 2)
    IF Place(I).Strength <= 0 THEN Place(I).Strength = 1
    Place(I).Col = INT(RND * 15)
    Place(I).Speed = I MOD 10
    Place(I).Speed = Place(I).Speed \ 2: Place(I).Speed = Place(I).Speed + INT(RND * 1)
    IF Place(I).Speed = 0 THEN Place(I).Speed = 1
   NEXT I
    Sumo(1).TileSet = 1
    CALL CreateSumo(1)
    Sumo(2).Col = INT(RND * 15) + 1
    Sumo(2).TileSet = 1
    CALL CreateLayers(1, Sumo(1).TileSet)
    CALL CreateLayers(2, Sumo(2).TileSet)
    Controller(2) = 3
    EXIT SUB
   END IF
   IF Locat + Slocat = LFO THEN CALL HighScores: GOTO RedoGui
   IF Locat + Slocat = LFO + 1 THEN EXT$ = "OPTIONS": GOTO RedoGui
   IF Locat + Slocat = LFO + 2 THEN EXT$ = "QRUSURE": GOTO RedoGui
  CASE "OPTIONS"
   IF Locat + Slocat = 1 THEN EXT$ = "CONTROLS": GOTO RedoGui
   IF Locat + Slocat = 2 THEN EXT$ = "SOUND": GOTO RedoGui
   IF Locat + Slocat = 3 THEN EXT$ = "GAMEOP": GOTO RedoGui
   IF Locat + Slocat = 4 THEN EXT$ = "MAINMNU": GOTO RedoGui
  CASE "P1C"
   IF Locat + Slocat = 1 THEN Controller(1) = 2: EXT$ = "CONTROLS": GOTO RedoGui
   IF Locat + Slocat = 2 THEN Controller(1) = 1: EXT$ = "CONTROLS": GOTO RedoGui
   IF Locat + Slocat = 3 THEN EXT$ = "CONTROLS": GOTO RedoGui
  CASE "P2C"
   IF Locat + Slocat = 1 THEN Controller(2) = 2: EXT$ = "CONTROLS": GOTO RedoGui
   IF Locat + Slocat = 2 THEN Controller(2) = 1: EXT$ = "CONTROLS": GOTO RedoGui
   IF Locat + Slocat = 3 THEN EXT$ = "CONTROLS": GOTO RedoGui
  CASE "DIFF"
   IF Locat + Slocat = 1 THEN GAME.DIFF = 1: EXT$ = "GAMEOP": GOTO RedoGui
   IF Locat + Slocat = 2 THEN GAME.DIFF = 2: EXT$ = "GAMEOP": GOTO RedoGui
   IF Locat + Slocat = 3 THEN GAME.DIFF = 3: EXT$ = "GAMEOP": GOTO RedoGui
   IF Locat + Slocat = 4 THEN EXT$ = "GAMEOP": GOTO RedoGui
  CASE "GAMEOP"
   IF Locat + Slocat = 1 THEN EXT$ = "TIME": GOTO RedoGui
   IF Locat + Slocat = 2 THEN EXT$ = "DIFF": GOTO RedoGui
   IF Locat + Slocat = 3 THEN EXT$ = "OPTIONS": GOTO RedoGui
  CASE "TIME"
   IF Locat + Slocat = 1 THEN GAME.TimeLeft = 999: EXT$ = "GAMEOP": GOTO RedoGui
   IF Locat + Slocat = 2 THEN GAME.TimeLeft = 120: EXT$ = "GAMEOP": GOTO RedoGui
   IF Locat + Slocat = 3 THEN GAME.TimeLeft = 60: EXT$ = "GAMEOP": GOTO RedoGui
   IF Locat + Slocat = 4 THEN GAME.TimeLeft = 30: EXT$ = "GAMEOP": GOTO RedoGui
   IF Locat + Slocat = 5 THEN EXT$ = "GAMEOP": GOTO RedoGui
  CASE "CONTROLS"
   IF Locat + Slocat = 1 THEN EXT$ = "P1C": GOTO RedoGui
   IF Locat + Slocat = 2 THEN EXT$ = "P2C": GOTO RedoGui
   IF Locat + Slocat = 3 THEN EXT$ = "OPTIONS": GOTO RedoGui
  CASE "SOUND"
   IF Locat + Slocat = 1 THEN EXT$ = "SETMIDI": GOTO RedoGui
   IF Locat + Slocat = 2 THEN EXT$ = "SETWAV": GOTO RedoGui
   IF Locat + Slocat = 3 THEN EXT$ = "OPTIONS": GOTO RedoGui
  CASE "SETMIDI"
   IF Locat + Slocat = 1 THEN SOUND.MIDISET = -1: EXT$ = "SOUND": GOTO RedoGui
   IF Locat + Slocat = 2 THEN SOUND.MIDISET = 0: EXT$ = "SOUND": GOTO RedoGui
   IF Locat + Slocat = 3 THEN EXT$ = "SOUND": GOTO RedoGui
  CASE "SETWAV"
   IF Locat + Slocat = 1 THEN SOUND.WAVSET = -1: EXT$ = "SOUND": GOTO RedoGui
   IF Locat + Slocat = 2 THEN SOUND.WAVSET = 0: EXT$ = "SOUND": GOTO RedoGui
   IF Locat + Slocat = 3 THEN EXT$ = "SOUND": GOTO RedoGui
  CASE "QRUSURE"
   IF Locat + Slocat = 1 THEN DQBclose: StopMidi: UNLOADMIDI Handle%: CLEANUPMIDI: END
   IF Locat + Slocat = 2 THEN EXT$ = "MAINMNU": GOTO RedoGui
 END SELECT
RETURN
ExitGuiSub:
 DEF SEG : DQBclearLayer 1: DQBclearLayer 2
 CALL DQBinstallKeyBoard
END SUB

REM $STATIC
SUB HandleSumo (S)
REM $DYNAMIC

SELECT CASE S
 CASE 1
  IF Controller(1) = 1 THEN CALL DoKeys(1, 1)
  IF Controller(1) = 2 THEN CALL DoKeys(1, 2)
  IF Controller(1) = 3 THEN CALL DoKeys(1, 3)
 CASE 2
  IF Controller(2) = 1 THEN CALL DoKeys(2, 1)
  IF Controller(2) = 2 THEN CALL DoKeys(2, 2)
  IF Controller(2) = 3 THEN CALL DoKeys(2, 3)
END SELECT

Sumo(S).StaminaCount = Sumo(S).StaminaCount + 4
IF Sumo(S).StaminaCount >= 100 THEN Sumo(S).Stamina = Sumo(S).Stamina + 1: Sumo(S).StaminaCount = 0
IF Sumo(S).Stamina > 100 THEN Sumo(S).Stamina = 100

IF Sumo(S).SpecialCount >= 100 THEN Sumo(S).SpecialBlocks = Sumo(S).SpecialBlocks + 1: Sumo(S).SpecialCount = 0
IF Sumo(S).SpecialBlocks > 4 THEN Sumo(S).SpecialBlocks = 4

IF Sumo(S).Shock THEN
 Sumo(S).Stamina = Sumo(S).Stamina + 1
 Sumo(S).Shock = Sumo(S).Shock - 1
 Sumo(S).StaminaCount = 0
END IF

IF Sumo(S).HitWPower THEN
 Sumo(S).HitWPower = Sumo(S).HitWPower - 1
 IF Sumo(S).HitWPower = 0 THEN Sumo(S).offX = Sumo(S).offY = 0
 IF S = 1 THEN S2 = 2 ELSE S2 = 1
 F = CheckCollide(S, Sumo(S).x, Sumo(S).y)
 IF Outring = S THEN GAME.Winner = S2
 F = CheckCollide(S, Sumo(S).x + 16, Sumo(S).y + 16)
 IF Outring = S THEN GAME.Winner = S2
 F = CheckCollide(S, Sumo(S).x, Sumo(S).y + 16)
 IF Outring = S THEN GAME.Winner = S2
END IF

IF Sumo(S).offX THEN
 IF Sumo(S).offX < 0 THEN OX = -Sumo(S).StepOff ELSE OX = Sumo(S).StepOff
 Sumo(S).x = Sumo(S).x + OX
 Sumo(S).offX = Sumo(S).offX - OX
 IF S = 1 THEN S2 = 2 ELSE S2 = 1
 F = CheckCollide(S, Sumo(S).x, Sumo(S).y)
 IF Outring = S THEN GAME.Winner = S2
 F = CheckCollide(S, Sumo(S).x + 16, Sumo(S).y + 16)
 IF Outring = S THEN GAME.Winner = S2
END IF

IF Sumo(S).offY THEN
 IF Sumo(S).offY < 0 THEN OY = -Sumo(S).StepOff ELSE OY = Sumo(S).StepOff
 Sumo(S).y = Sumo(S).y + OY
 Sumo(S).offY = Sumo(S).offY - OY
 IF S = 1 THEN S2 = 2 ELSE S2 = 1
 IF OY < 0 THEN YYY = 8 ELSE YYY = 0
 F = CheckCollide(S, Sumo(S).x, Sumo(S).y + YYY)
 IF Outring = S THEN GAME.Winner = S2
 F = CheckCollide(S, Sumo(S).x, Sumo(S).y + 16)
 IF Outring = S THEN GAME.Winner = S2
END IF
IF S = 1 THEN S2 = 2 ELSE S2 = 1

SELECT CASE Sumo(S).Action
 CASE 1
  Sumo(S).ActionCount = Sumo(S).ActionCount + 1
  IF Sumo(S).ActionCount = 3 THEN
  Sumo(S).Frame = Sumo(S).Frame + 1: Sumo(S).ActionCount = 0
  IF Sumo(S).Frame = 4 THEN
   Sumo(S).Action = 0: Sumo(S).Frame = 0
   IF S = 1 THEN S2 = 2 ELSE S2 = 1
   IF Sumo(1).x < Sumo(2).x THEN T1 = 1: T2 = 2
   IF Sumo(2).x < Sumo(1).x THEN T1 = 2: T2 = 1
   IF T1 = 0 THEN T1 = 1: T2 = 2
   IF T2 = 0 THEN T1 = 1: T2 = 2
   Z = ABS(Sumo(T1).x - (Sumo(T2).x - 1))
   Z2 = ABS(Sumo(T1).y - (Sumo(T2).y - 1))
   IF Z < 16 AND Z2 < 16 THEN
    DQBplaySound 1, 1, 8000, ONCE
    IF Sumo(S).Direction = 1 THEN Sumo(S2).offY = INT((INT(RND * Sumo(S).Strength + 1) + 1) + INT(RND * 5)) * 2: Sumo(S2).StepOff = 2
    IF Sumo(S).Direction = 2 THEN Sumo(S2).offX = INT((INT(RND * Sumo(S).Strength + 1) + 1) + INT(RND * 5)) * 2: Sumo(S2).StepOff = 2
    IF Sumo(S).Direction = 3 THEN Sumo(S2).offY = INT((INT(RND * Sumo(S).Strength + 1) + 1) + INT(RND * 5)) * -2: Sumo(S2).StepOff = 2
    IF Sumo(S).Direction = 4 THEN Sumo(S2).offX = INT((INT(RND * Sumo(S).Strength + 1) + 1) + INT(RND * 5)) * -2: Sumo(S2).StepOff = 2
    IF Sumo(S).offX MOD 2 THEN Sumo(S).offX = Sumo(S).offX + Sumo(S).offX MOD 2
    IF Sumo(S).offY MOD 2 THEN Sumo(S).offY = Sumo(S).offY + Sumo(S).offY MOD 2
    Sumo(S).SpecialCount = Sumo(S).SpecialCount + 10
   END IF
  Sumo(S).StaminaCount = 0
  END IF
  END IF
 CASE 2
   IF Sumo(1).x < Sumo(2).x THEN T1 = 1: T2 = 2
   IF Sumo(2).x < Sumo(1).x THEN T1 = 2: T2 = 1
   IF T1 = 0 THEN T1 = 1: T2 = 2
   IF T2 = 0 THEN T1 = 1: T2 = 2
   Z = ABS(Sumo(T1).x - (Sumo(T2).x - 1))
   Z2 = ABS(Sumo(T1).y - (Sumo(T2).y - 1))
   IF Z < 16 AND Z2 < 16 THEN
DeathWelcome:
    DQBplaySound 1, 1, 8000, ONCE
    IF S = 1 THEN S2 = 2
    IF S = 2 THEN S2 = 1
    YY = Sumo(S2).y
       A! = 1.5
       DO
        A! = A! + .2
        SELECT CASE Sumo(S).Direction
         CASE 1, 2: Sumo(S2).x = Sumo(S2).x + 4
         CASE 4, 3: Sumo(S2).x = Sumo(S2).x - 4
        END SELECT
         Sumo(S2).y = YY + (75 * COS(A!))
         IF Sumo(S2).y > YY THEN Sumo(S2).y = YY
         DrawScreen 1
         DQBcopyLayer 1, 0
         DQBwait 1
       LOOP UNTIL A! >= 5.4
       A! = 1.5: YY = 0
       Sumo(S2).Stamina = Sumo(S2).Stamina - (INT(RND * 30) + 15)
       IF Sumo(S2).Stamina < 1 THEN Sumo(S2).Stamina = 1
       Sumo(S).Action = 0
       FF = CheckCollide(2, Sumo(S2).x, Sumo(S2).y)
       IF Outring THEN GAME.Winner = S
       FF = CheckCollide(2, Sumo(S2).x + 16, Sumo(S2).y + 16)
       IF Outring THEN GAME.Winner = S
       FF = CheckCollide(2, Sumo(S2).x, Sumo(S2).y + 16)
       IF Outring THEN GAME.Winner = S
       Sumo(S).StaminaCount = 0
       Sumo(S).SpecialBlocks = 0
       Sumo(S).SpecialCount = 0
      END IF
 CASE 3
  IF S = 1 THEN S2 = 2
  IF S = 2 THEN S2 = 1
  IF Sumo(1).x < Sumo(2).x THEN T1 = 1: T2 = 2
  IF Sumo(2).x < Sumo(1).x THEN T1 = 2: T2 = 1
  IF T1 = 0 THEN T1 = 1: T2 = 2
  IF T2 = 0 THEN T1 = 1: T2 = 2
  Z = ABS(Sumo(T1).x - (Sumo(T2).x - 1))
  Z2 = ABS(Sumo(T1).y - (Sumo(T2).y - 1))
  IF Z < 16 AND Z2 < 16 THEN
   DQBplaySound 1, 1, 8000, ONCE
   FOR Rad = 100 TO 0 STEP -6
    DrawScreen 1
    DQBellipse 1, Sumo(S2).x + 8, Sumo(S2).y + 8, Rad, Rad, 2
    DQBcopyLayer 1, 0
    DQBwait 1
   NEXT
   Sumo(S).StaminaCount = 0
   Sumo(S).SpecialBlocks = 0
   Sumo(S).SpecialCount = 0
   Sumo(S).Action = 0
   Sumo(S2).Stamina = 1
  END IF
 CASE 4
  Sumo(S).ActionCount = Sumo(S).ActionCount + INT(RND * 2) + 1
  IF Sumo(S).ActionCount >= 3 THEN Sumo(S).Frame = Sumo(S).Frame + 1: Sumo(S).ActionCount = 0
  IF Sumo(S).Frame = 4 THEN
   Sumo(S).Action = 0: Sumo(S).Frame = 0
   IF S = 1 THEN S2 = 2 ELSE S2 = 1
   Z = ABS(Sumo(1).x - Sumo(2).x): Z2 = ABS(Sumo(1).y - Sumo(2).y)
   IF Z < 16 AND Z2 < 16 THEN
    DQBplaySound 2, 1, 8000, ONCE
    Sumo(S2).HitWPower = 100
    Sumo(S).SpecialBlocks = 0
    Sumo(S).SpecialCount = 0
    IF Sumo(S).Direction = 1 THEN Sumo(S2).offY = 150: Sumo(S2).StepOff = 10
    IF Sumo(S).Direction = 2 THEN Sumo(S2).offX = 150: Sumo(S2).StepOff = 10
    IF Sumo(S).Direction = 3 THEN Sumo(S2).offY = -150: Sumo(S2).StepOff = 10
    IF Sumo(S).Direction = 4 THEN Sumo(S2).offX = -150: Sumo(S2).StepOff = 10
   END IF
  Sumo(S).StaminaCount = 0
  END IF
 CASE 5
   A! = 0
   Z = ABS(Sumo(1).x - Sumo(2).x): Z2 = ABS(Sumo(1).y - Sumo(2).y)
   IF Z < 16 AND Z2 < 16 THEN
    DO
     Sumo(S).Frame = Sumo(S).Frame + 1
     IF Sumo(S).Frame = 4 THEN
      Sumo(S).Frame = 0
      DQBplaySound 1, 1, 8000, ONCE
      Hiit = Hiit + 1
     END IF
     IF S = 1 THEN S2 = 2 ELSE S2 = 1
     DrawScreen 1
     FF = INT(RND * 2) + 1
     FOR XX = Sumo(S2).x - 5 TO Sumo(S2).x + 20 STEP FF
     FOR YY = Sumo(S2).y - 5 TO Sumo(S2).y + 20 STEP FF
      POP = INT(RND * 12) + 1
      IF POP = 5 THEN DQBpset 1, XX + SIN(FF * INT(RND * 4) + 1), YY + COS(FF * INT(RND * 4) + 1), 4
     NEXT
     NEXT
     DQBcopyLayer 1, 0
     DQBwait 1
    LOOP UNTIL Hiit = 75
    A! = 0
    Sumo(S).StaminaCount = 0
    Sumo(S).SpecialBlocks = 0
    Sumo(S).SpecialCount = 0
    Sumo(S).Action = 0
    Sumo(S2).Stamina = 1
    GOTO DeathWelcome
   END IF
 CASE 6
END SELECT
IF DQBinUse(2) = 0 THEN DQBplaySound INT(RND * 4) + 10, 2, 22050, ONCE
END SUB

REM $STATIC
SUB HighScores
DO: LOOP UNTIL INKEY$ = ""
IF DQBloadImage(2, 0, 0, "DATA\SUMOLOGO.PCX", Pal, 319, 199) THEN PRINT "Error!!!"
WorldMap.Redefine = -1
FilterBox 2, 54, 20, 265, 179, 3, 0, 0
DQBbox 2, 55, 20, 267, 179, 25
DQBbox 2, 54, 21, 266, 178, 28
DQBbox 2, 53, 22, 265, 177, 15
DQBcopyLayer 2, 1
 DO
 y = y + 1
 T$ = Names(y)
 S = Scores(y)
 IF y >= 5 THEN EXIT DO
 S$ = LTRIM$(RTRIM$(STR$(S)))
 OX = DQBlen(T$) \ 2: O2 = DQBlen(S$) \ 2
 IF O2 > OX THEN OX = O2
 IF y > 1 THEN
 DQBbox 1, 160 - 10 - OX, 30 + ((y * 35) - 30) - 5, 160 + OX + 10, 30 + ((y * 35) - 10) + 5, 15
 DQBbox 1, 161 - 10 - OX, 30 + ((y * 35) - 29) - 5, 159 + OX + 10, 30 + ((y * 35) - 11) + 5, 27
 DQBbox 1, 162 - 10 - OX, 30 + ((y * 35) - 28) - 5, 158 + OX + 10, 30 + ((y * 35) - 12) + 5, 25
 DQBprint 1, LTRIM$(T$), 160 - OX + 2, 30 + ((y * 35) - 28) + 2, 23
 DQBprint 1, LTRIM$(T$), 160 - OX + 1, 30 + ((y * 35) - 28) + 1, 25
 DQBprint 1, LTRIM$(T$), 160 - OX, 30 + ((y * 35) - 28), 15
 END IF
 DQBprint 1, S$, 160 - O2, 30 + ((y * 35) - 18), 15
 IF y = 1 THEN Top$ = T$: TopS$ = S$
 LOOP
DQBcopyLayer 1, 0: DQBcopyLayer 1, 2
OX = DQBlen(Top$) \ 2: O2 = DQBlen(TopS$) \ 2
IF O2 > OX THEN OX = O2
x1 = 160 - 10 - OX
x2 = 160 + 10 + OX
y = 1
l = DQBmapLayer(1)
DO
 DQBcopyLayer 2, 1
 IF M = 1 THEN x2 = x2 - 1: x1 = x1 + 1
 IF M = 0 THEN x2 = x2 + 1: x1 = x1 - 1
 IF M2 = 1 THEN TY = TY + 1
 IF M2 = 0 THEN TY = TY - 1
 IF x1 >= 160 - OX THEN M = 0
 IF x1 <= 60 THEN M = 1
 IF TY > 3 THEN M2 = 0
 IF TY < -3 THEN M2 = 1
 DQBbox 1, x1, 30 + ((y * 35) - 30) - 5, x2, 30 + ((y * 35) - 10) + 5, 15
 DQBbox 1, x1 + 1, 30 + ((y * 35) - 29) - 5, x2 - 1, 30 + ((y * 35) - 11) + 5, 27
 DQBbox 1, x1 + 2, 30 + ((y * 35) - 28) - 5, x2 - 2, 30 + ((y * 35) - 12) + 5, 25
 IF M2 = 0 THEN
  FOR I = 0 TO TY STEP -1
   DQBprint 1, LTRIM$(Top$), 160 - OX, 30 + ((y * 35) - 28) + TY - I - 1, 23
   DQBprint 1, LTRIM$(Top$), 160 - OX, 30 + ((y * 35) - 28) + TY - I, 25
  NEXT I
  ELSE
  FOR I = 0 TO TY
   DQBprint 1, LTRIM$(Top$), 160 - OX, 30 + ((y * 35) - 28) + TY - I - 1, 23
   DQBprint 1, LTRIM$(Top$), 160 - OX, 30 + ((y * 35) - 28) + TY - I, 25
  NEXT I
 END IF
 DQBprint 1, LTRIM$(Top$), 160 - OX, 30 + ((y * 35) - 28) + TY, 15
 DQBcopyLayer 1, 0
 DQBwait 1
LOOP UNTIL INKEY$ <> ""
IF DQBloadFont("small.fnt") THEN
  CALL DQBclose
  IF SOUND.MIDI AND SM THEN StopMidi
  PRINT DQBerror$ + " " + STR$(ERR)
  END
 END IF
END SUB

SUB InitSumo
 CLS
 RANDOMIZE TIMER
 DriversLoaded SBMIDI.INTERRUPT, SBSIM.INTERRUPT
 IF SBMIDI.INTERRUPT = 0 THEN
  PRINT "MIDI drivers not loaded! Please use sumo.bat to play..."
  WHILE INKEY$ = "": WEND
  SYSTEM
 END IF
 IF SBMIDI.INTERRUPT = 0 THEN SBMIDI.INTERRUPT = &H80
 IF SBSIM.INTERRUPT = 0 THEN SBSIM.INTERRUPT = &H81
 IF DQBinit(6, 7, 0) THEN PRINT DQBerror$: SLEEP: DQBclose: END
 Handle% = LoadMidi("SOUND\INTENSE.MID")
 dummy& = SETMEM(-17000)
 IF DQBinstallSB(-1, 4, 11050, -1, -1, -1) THEN Init = 1: EXIT SUB
 IF DQBloadSound(1, "SOUND\SUMOPU~1.WAV") THEN PRINT DQBerror$
 IF DQBloadSound(2, "SOUND\SUMOHIT.WAV") THEN PRINT DQBerror$
 IF DQBloadSound(3, "SOUND\SUMOWIN.WAV") THEN PRINT DQBerror$
 IF DQBloadSound(4, "SOUND\SUMODIE.WAV") THEN PRINT DQBerror$
 IF DQBloadSound(5, "SOUND\REF1.WAV") THEN PRINT DQBerror$
 IF DQBloadSound(6, "SOUND\REF2.WAV") THEN PRINT DQBerror$
 IF DQBloadSound(7, "SOUND\REF3.WAV") THEN PRINT DQBerror$
 SCREEN 13
 DQBinitVGA
 IF DQBloadFont("SMALL.FNT") THEN DQBclose: PRINT DQBerror$: END
 DQBpalOff
 IF DQBloadImage(6, 0, 0, "DATA\FACES.PCX", Pal, 319, 199) THEN PRINT DQBerror$
 IF DQBloadImage(0, 0, 50, "DATA\SUMO2.PCX", Pal, 319, 199) THEN PRINT DQBerror$
 DQBfadeIn Pal
 DQBfadeto 63, 63, 63
 IF DQBloadImage(2, 0, 0, "DATA\SUMOLOGO.PCX", Pal, 319, 199) THEN PRINT DQBerror$
 DQBcopyLayer 2, 0: DQBcopyLayer 2, 1
 DQBfadeIn Pal
 Sumo(1).TileSet = 1: Sumo(2).TileSet = 1
 Controller(1) = 1
 Controller(2) = 3
 GAME.DIFF = 1: GAME.Time = 60
 OPEN "DATA\HIGH.DAT" FOR INPUT AS #1
  FOR I = 1 TO 5
   INPUT #1, Names(I), Scores(I)
  NEXT
 CLOSE #1
 Sumo(1).x2 = 15: Sumo(1).y2 = 15
 Sumo(2).x2 = 15: Sumo(2).y2 = 15
 OPEN "DATA\UNLEASH.DAT" FOR INPUT AS #1
  FOR I = 1 TO 4
  INPUT #1, Unleash(I)
  NEXT
 CLOSE #1
END SUB

SUB SelectSumo (Player)
DQBremoveKeyBoard
IF DQBloadImage(2, 0, 0, "DATA\SELECT.PCX", Pal, 319, 199) THEN PRINT ERR
DQBcopyLayer 2, 1: Sel = 1
GOSUB DrawSelect
DO
 I$ = INKEY$
 IF I$ = CHR$(0) + CHR$(KEYRIGHT) THEN Sel = Sel + 1: GOSUB DrawSelect
 IF I$ = CHR$(0) + CHR$(KEYLEFT) THEN Sel = Sel - 1: GOSUB DrawSelect
 IF I$ = CHR$(27) THEN QuitGame = -1: Controller(2) = 3: EXIT SUB
 IF I$ = CHR$(13) THEN
  IF Sel > 1 THEN
   IF Unleash(Sel - 1) THEN Sumo(Player).TileSet = Sel: EXIT DO
  ELSE
   Sumo(Player).TileSet = 1: EXIT DO
  END IF
 END IF
LOOP
EXIT SUB
DrawSelect:
 IF Sel > 5 THEN Sel = 1
 IF Sel < 1 THEN Sel = 5
 DQBcopyLayer 2, 1
 DQBboxF 1, ((Sel * 51) - 51 + 32), 85, ((Sel * 51) - 51 + 32) + 51, 85 + 50, 2
 FOR I = 1 TO 5
  IF I = 1 THEN
   PlaceTile 6, 1, 1, 32, 85, 51, 51
  ELSE
   IF Unleash(I - 1) THEN
    PlaceTile 6, I, 1, ((I * 51) - 51 + 31), 85, 51, 51
   ELSE
    PlaceTile 6, 6, 1, ((I * 51) - 51 + 32), 85, 51, 51
   END IF
  END IF
 NEXT
 DQBcopyTransLayer 2, 1
 IF Player = 1 THEN T$ = "Player 1"
 IF Player = 2 THEN T$ = "Player 2"
 DQBprintBack 1, T$, 160 - (DQBlen(T$) / 2), 189, 9, 15
 FOR I = 1 TO 5
  IF I = 1 THEN
   J = -1
  ELSE
   IF Unleash(I - 1) THEN J = -1 ELSE J = 0
  END IF
  IF Sel = I AND J THEN
   OPEN "DATA\DIS.DAT" FOR INPUT AS #1
    FOR II = 1 TO Sel
     INPUT #1, Disc$
    NEXT
   CLOSE #1
   DQBprintBack 1, Disc$, 160 - (DQBlen(Disc$) / 2), 75, 9, 15
  END IF
 NEXT
 DQBcopyLayer 1, 0
RETURN
END SUB

SUB SUMODIE
DIM Blood(1 TO 80) AS Blood
DQBclearLayer 1
DIM Temp1(129)
IF GAME.Winner = 1 THEN La = 3 ELSE La = 4
IF GAME.Winner = 1 THEN La2 = 4 ELSE La2 = 3
DQBclearLayer 1
PlaceTile La2, 28, 1, 0, 0, 17, 17
DQBget 1, 0, 0, 16, 16, VARSEG(Temp1(0)), VARPTR(Temp1(0))
DQBclearLayer 1
DO: LOOP UNTIL DQBinkey$ = ""
Blowd = 16
YTime! = TIMER
DO
 SoundOver = SoundOver + 1
 IF SoundOver = 501 THEN SoundOver = 0
 Anim = Anim + 1
 IF Anim = 30 THEN Frame = Frame + 1: Anim = 0
 IF Frame = 2 THEN Frame = 0
 DQBcopyLayer 2, 1
 PlaceTile La, 26 + Frame, 1, Sumo(La - 2).x, Sumo(La - 2).y, 17, 17

 SELECT CASE Seq
  CASE 0, 1
   IF SOUND.WAVSET THEN DQBplaySound 4, 1, 8000, ONCE
   IF SOUND.WAVSET THEN DQBwait 55
   Seq = 2
  CASE 2
   IF SOUND.WAVSET THEN DQBplaySound 3, 1, 8000, 0
   Seq = 3
  CASE 3
   Toe = Toe + 1: IF Toe = 2 THEN Blowd = Blowd + 1: Toe = 0: Sumo(La2 - 2).x = Sumo(La2 - 2).x - 1
   IF Blowd = 150 THEN
    IF SOUND.WAVSET THEN DQBplaySound 1, 1, 8000, ONCE
    Seq = 4
    FOR I = 1 TO 80
     Blood(I).x = Sumo(La2 - 2).x + 50 + I + RND * 5
     Blood(I).y = Sumo(La2 - 2).y + 50 + INT(RND * 20)
    NEXT I
   END IF
  CASE 4
   Uway = Uway + 1
   IF Uway = 3 THEN
    FOR I = 1 TO 80
     Blood(I).Xoff = Blood(I).Xoff + 1
    NEXT I
    Sumo(La2 - 2).y = Sumo(La2 - 2).y + 1
    Uway = 0
   END IF
   IF Sumo(La2 - 2).y = 201 THEN Seq = 5
  CASE 5
   TT = TT + 1
   IF TT = 5 THEN
    FOR I = 1 TO 80
     Blood(I).y = Blood(I).y + 1
    NEXT I
    TT = 0
   END IF
 END SELECT
 FOR I = 1 TO 80
  DQBgline 1, Blood(I).x, Blood(I).y, Blood(I).x, Blood(I).y + Blood(I).Xoff, 45, 40
 NEXT I
 DQBsPut 1, Sumo(La2 - 2).x, Sumo(La2 - 2).y, VARSEG(Temp1(0)), VARPTR(Temp1(0)), Blowd, Blowd
 DQBcopyLayer 1, 0
 IF SoundOver = 500 AND SOUND.WAVSET THEN DQBplaySound 1, 1, 8000, ONCE
LOOP UNTIL INKEY$ <> "" OR DQBinkey$ <> "" OR TIMER > YTime! + 10
IF GAME.MODE <> 3 AND GAME.Winner = 1 THEN CALL SumoEX("DATA\WIN.PCX")
IF GAME.MODE <> 3 AND GAME.Winner = 2 THEN CALL SumoEX("DATA\LOSE.PCX")
ERASE Blood
END SUB

