'
'
'
'
'
'
'                             TANKS LEVEL EDITOR
'                         Version 1.1--Updated Edition
'
'
'                       Programming: William VanderPol
'                         Graphics: Joshua Nijenhuis
'
'
'
'
'
'


DECLARE SUB Welcome ()
DECLARE SUB drawbutton (x1%, y1%, Text$, Layer%)
DECLARE SUB showmenu ()
DECLARE SUB editarea ()
DECLARE SUB savearea (file$)
DECLARE SUB Quit ()
DECLARE FUNCTION prompt% (Text$, questiontype%, x1%, y1%, x2%, y2%)
DECLARE SUB compileworld ()
DECLARE FUNCTION getuserdata$ (Text$, maxlenght%)
REM $DYNAMIC
DEFINT A-Z
REM $INCLUDE: 'EDTLEVEL.BI'
DIM SHARED treex(1 TO 50)
DIM SHARED treey(1 TO 50)

DIM SHARED waterx(1 TO 50)
DIM SHARED watery(1 TO 50)

DIM SHARED wallx(1 TO 50)
DIM SHARED wally(1 TO 50)

DIM SHARED buildingx(1 TO 50)
DIM SHARED buildingy(1 TO 50)

DIM SHARED p1tankrf1(SIZE20 \ 2)
'set player 1 tanks that valid down
DIM SHARED P1tankdf1(SIZE20 \ 2)
'set player 1 tanks that valid left
DIM SHARED p1tanklf1(SIZE20 \ 2)
'set player 1 tanks that valid up
DIM SHARED P1tankuf1(SIZE20 \ 2)
'set player 2 tanks that valid right
DIM SHARED p2tankrf1(SIZE20 \ 2)
'set player 2 tanks that valid down
DIM SHARED P2tankdf1(SIZE20 \ 2)
'set player 2 tanks that valid left
DIM SHARED p2tanklf1(SIZE20 \ 2)
'set player 2 tanks that valid up
DIM SHARED P2tankuf1(SIZE20 \ 2)
'dim wall, tree, water, ect.
DIM SHARED wall(SIZE20 \ 2)
DIM SHARED tree(SIZE20)
DIM SHARED water(SIZE20 \ 2)
DIM SHARED building(SIZE20 \ 2)
defaultitem = ITMWALL
curitem = defaultitem
'*****************************************************************************
'code starts here
Init
GetGameData
Welcome
DQBclearLayer 1
dqbmousehide
DQBpaint 1, 1, 1, DQBfindCol(63, 63, 63)
dqbcopylayer 1, VIDEO
DQBsetMouseRange 0, 0, 300, 160
dqbmouseshow
DQBsetSolidPut
editarea

REM $STATIC
SUB compileworld
in$ = getuserdata("NUMBER OF AREAS 1-99", 3)
areas = VAL(in$)
IF areas > 999 THEN areas = 99
IF areas < 1 THEN areas = 1
outfile$ = getuserdata("WORLD FILE NAME", 8)
DO UNTIL Filename = TRUE
 OPEN outfile$ + ".WLD" FOR BINARY AS #1
 IF LOF(1) > 0 THEN
  IF DQBloadFont("HITECH.FNT") THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0): dqbwait 100
  result = prompt("OVERWRITE " + outfile$ + ".WLD", YESNO, 75, 70, 245, 160)
  IF result = NO THEN
   CLOSE #1
   Filename = FALSE
  ELSEIF result = YES THEN
   CLOSE #1
   Filename = TRUE
  END IF
 END IF
 CLOSE #1
 Filename = TRUE
LOOP
Filename = FALSE
OPEN outfile$ + ".WLD" FOR OUTPUT AS #2
'print # of areas
PRINT #2, LTRIM$(STR$(areas))
'start main loop of the compiler
FOR area = 1 TO areas
 DO UNTIL Filename = TRUE
  file$ = getuserdata("FILE NAME " + LTRIM$(STR$(area)), 8)
  OPEN "LEVELS\" + file$ + ".LEV" FOR BINARY AS #1
  IF LOF(1) = 0 THEN
   Filename = FALSE
   CLOSE #1
   KILL "LEVELS\" + file$ + ".LEV"
   IF DQBloadFont("HITECH.FNT") THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0): dqbwait 100
   DQBprint VIDEO, "FILE DOES NOT EXIST", 1, 1, DQBfindPalCol(pal, 63, 0, 0): dqbwait 100
   result = prompt("EXIT COMPILER?", YESNO, 100, 70, 220, 160)
   IF result = YES THEN
    CLOSE
    KILL outfile$ + ".WLD"
    EXIT SUB
   END IF
  ELSE
   Filename = TRUE
   CLOSE #1
  END IF
 LOOP
 CLOSE #1
 OPEN "LEVELS\" + file$ + ".LEV" FOR INPUT AS #1
 'write the level data into the main world file
 PRINT #2, "AREA " + LTRIM$(STR$(area))
 DO UNTIL EOF(1)
  LINE INPUT #1, in$
  PRINT #2, in$
 LOOP
 PRINT #2, "END AREA " + LTRIM$(STR$(area))
 Filename = FALSE
 CLOSE #1
NEXT area
CLOSE
END SUB

SUB drawbutton (x1, y1, Text$, Layer)
IF DQBloadFont("HITECH.FNT") THEN DQBprint VIDEO, DQBerror$ + " HITECH.FNT", 1, 1, DQBfindCol(63, 0, 0): dqbwait 100
x2 = x1 + (LEN(Text$) * 8) + 15
DQBboxf Layer, x1, y1, x2, (y1 + 15), 28
DQBline Layer, x1, y1, x1, (y1 + 14), 29
DQBline Layer, x1, y1, (x2 - 1), y1, 29
DQBline Layer, (x1 + 1), (y1 + 15), x2, (y1 + 15), 27
DQBline Layer, x2, (y1 + 1), x2, (y1 + 15), 27
DQBprint Layer, Text$, (x1 + 8), (y1 + 4), 31
IF DQBloadFont("F6x6A.FNT") THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0): dqbwait 100
END SUB

SUB editarea
valid = TRUE
IF DQBloadFont("F6x6A.FNT") THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0): dqbwait 100
saved = TRUE
DO
  t = t + 1
  IF t = 10000 THEN statusbar: t = 0
  'update mouse status
  IF DQBmouseLB = -1 THEN
   saved = FALSE
   IF curitem = ITMWALL THEN
    wallN = wallN + 1
    IF wallN > 50 THEN valid = FALSE: wallN = 50
    IF valid = TRUE THEN
     wallx(wallN) = DQBmouseX
     wally(wallN) = DQBmouseY
     dqbmousehide
     DQBput 1, wallx(wallN), wally(wallN), VARSEG(wall(0)), VARPTR(wall(0))
     dqbcopylayer 1, VIDEO
     dqbmouseshow
    END IF
    valid = TRUE
    statusbar
    dqbwait 20
   ELSEIF curitem = ITMTREE THEN
    treeN = treeN + 1
    IF treeN > 50 THEN valid = FALSE: treeN = 50
    IF valid = TRUE THEN
     treex(treeN) = DQBmouseX
     treey(treeN) = DQBmouseY
     dqbmousehide
     DQBput 1, treex(treeN), treey(treeN), VARSEG(tree(0)), VARPTR(tree(0))
     dqbcopylayer 1, VIDEO
     dqbmouseshow
    END IF
    valid = TRUE
    statusbar
    dqbwait 20
   ELSEIF curitem = ITMWATER THEN
    waterN = waterN + 1
    IF waterN > 50 THEN valid = FALSE: waterN = 50
    IF valid = TRUE THEN
     waterx(waterN) = DQBmouseX
     watery(waterN) = DQBmouseY
     dqbmousehide
     DQBput 1, waterx(waterN), watery(waterN), VARSEG(water(0)), VARPTR(water(0))
     dqbcopylayer 1, VIDEO
     dqbmouseshow
    END IF
    valid = TRUE
    statusbar
    dqbwait 20
   ELSEIF curitem = ITMBUILDING THEN
    buildingN = buildingN + 1
    IF buildingN > 50 THEN valid = FALSE: buildingN = 50
    IF valid = TRUE THEN
     buildingx(buildingN) = DQBmouseX
     buildingy(buildingN) = DQBmouseY
     dqbmousehide
     DQBput 1, buildingx(buildingN), buildingy(buildingN), VARSEG(building(0)), VARPTR(building(0))
     dqbcopylayer 1, VIDEO
     dqbmouseshow
    END IF
    valid = TRUE
    statusbar
    dqbwait 20
   ELSEIF curitem = ITMP1TANK THEN
    IF p1placed = TRUE THEN
     P1tank.dir = P1tank.dir + 1
     IF P1tank.dir > 3 THEN P1tank.dir = 0
    ELSEIF p1placed = FALSE THEN
     P1tank.posx = DQBmouseX
     P1tank.posy = DQBmouseY
     p1placed = TRUE
     P1tank.dir = UP
    END IF
    dqbmousehide
    IF P1tank.dir = UP THEN
     DQBput 1, P1tank.posx, P1tank.posy, VARSEG(P1tankuf1(0)), VARPTR(P1tankuf1(0))
    ELSEIF P1tank.dir = DOWN THEN
     DQBput 1, P1tank.posx, P1tank.posy, VARSEG(P1tankdf1(0)), VARPTR(P1tankdf1(0))
    ELSEIF P1tank.dir = RIGHT THEN
     DQBput 1, P1tank.posx, P1tank.posy, VARSEG(p1tankrf1(0)), VARPTR(p1tankrf1(0))
    ELSEIF P1tank.dir = LEFT THEN
     DQBput 1, P1tank.posx, P1tank.posy, VARSEG(p1tanklf1(0)), VARPTR(p1tanklf1(0))
    END IF
    dqbcopylayer 1, VIDEO
    dqbmouseshow
    statusbar
    dqbwait 20
   ELSEIF curitem = ITMP2TANK THEN
    IF p2placed = TRUE THEN
     P2tank.dir = P2tank.dir + 1
     IF P2tank.dir > 3 THEN P2tank.dir = 0
    ELSEIF p2placed = FALSE THEN
     P2tank.posx = DQBmouseX
     P2tank.posy = DQBmouseY
     p2placed = TRUE
     P2tank.dir = UP
    END IF
    dqbmousehide
    IF P2tank.dir = UP THEN
     DQBput 1, P2tank.posx, P2tank.posy, VARSEG(P2tankuf1(0)), VARPTR(P2tankuf1(0))
    ELSEIF P2tank.dir = DOWN THEN
     DQBput 1, P2tank.posx, P2tank.posy, VARSEG(P2tankdf1(0)), VARPTR(P2tankdf1(0))
    ELSEIF P2tank.dir = RIGHT THEN
     DQBput 1, P2tank.posx, P2tank.posy, VARSEG(p2tankrf1(0)), VARPTR(p2tankrf1(0))
    ELSEIF P2tank.dir = LEFT THEN
     DQBput 1, P2tank.posx, P2tank.posy, VARSEG(p2tanklf1(0)), VARPTR(p2tanklf1(0))
    END IF
    dqbcopylayer 1, VIDEO
    dqbmouseshow
    statusbar
    dqbwait 20
   END IF
  ELSEIF DQBmouseRB = -1 OR DQBkey(KEYESC) THEN
   showmenu
   dqbmousehide
   IF curitem = ITMTREE THEN
    DQBsetMouseRange 0, 0, 277, 160
   ELSE
    DQBsetMouseRange 0, 0, 300, 160
   END IF
   dqbmouseshow
   dqbwait 30
  END IF
LOOP
END SUB

REM $DYNAMIC
SUB GetGameData
DQBclearLayer VIDEO
DQBprint VIDEO, "LOADING... PLEASE WAIT", CENTERED, 95, DQBfindPalCol(pal, 36, 10, 50)
IF DQBunpackImage(IMGMISC, 3, 0, 0) THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0)
IF DQBunpackPal(PALMISC, pal) THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0)
DQBsetPal pal
'get all the tanks from misc.dat
'player 1 tank, frame 1, facing right
DQBget 3, 0, 0, 19, 19, VARSEG(p1tankrf1(0)), VARPTR(p1tankrf1(0))
'player 1 tank, frame 1, facing down
DQBget 3, 0, 20, 19, 39, VARSEG(P1tankdf1(0)), VARPTR(P1tankdf1(0))
'player 1 tank, frame 1, facing left
DQBget 3, 0, 40, 19, 59, VARSEG(p1tanklf1(0)), VARPTR(p1tanklf1(0))
'player 1 tank, frame 1, facing up
DQBget 3, 0, 60, 19, 79, VARSEG(P1tankuf1(0)), VARPTR(P1tankuf1(0))
'now on to player 2 tanks
'player 2 tank, frame 1, facing right
DQBget 3, 80, 0, 99, 19, VARSEG(p2tankrf1(0)), VARPTR(p2tankrf1(0))
'player 2 tank, frame 1, facing down
DQBget 3, 80, 20, 99, 39, VARSEG(P2tankdf1(0)), VARPTR(P2tankdf1(0))
'player 2 tank, frame 1, facing left
DQBget 3, 80, 40, 99, 59, VARSEG(p2tanklf1(0)), VARPTR(p2tanklf1(0))
'player 2 tank, frame 1, facing up
DQBget 3, 80, 60, 99, 79, VARSEG(P2tankuf1(0)), VARPTR(P2tankuf1(0))
'wall,tree,water,ect.....
DQBget 3, 120, 0, 139, 19, VARSEG(water(0)), VARPTR(water(0))
DQBget 3, 120, 20, 162, 39, VARSEG(tree(0)), VARPTR(tree(0))
DQBget 3, 120, 40, 139, 59, VARSEG(wall(0)), VARPTR(wall(0))
DQBget 3, 120, 60, 139, 79, VARSEG(building(0)), VARPTR(building(0))
END SUB

REM $STATIC
FUNCTION getuserdata$ (Text$, maxlenght)
DQBclearLayer 3
DQBclearLayer VIDEO
dqbmousehide
IF DQBloadFont("HITECH.FNT") THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0): dqbwait 100
DQBbox 3, 50, 70, 270, 150, DQBfindCol(30, 30, 30)
DQBboxf 3, 51, 71, 269, 149, DQBfindCol(0, 0, 40)
DQBprint 3, Text$, CENTERED, 75, DQBfindCol(63, 0, 0)
DQBboxf 3, 55, 90, 265, 100, DQBfindCol(40, 40, 40)
dqbcopylayer 3, VIDEO
DO
 IF LEN(Filename$) > maxlenght THEN
   filenametemp$ = LEFT$(Filename$, LEN(Filename$) - 1)
   Filename$ = filenametemp$
 END IF
 DQBboxf 3, 55, 90, 265, 100, DQBfindPalCol(pal, 40, 40, 40)
 DQBprint 3, Filename$, CENTERED, 92, DQBfindPalCol(pal, 63, 0, 0)
 dqbcopylayer 3, VIDEO
 IF DQBkey(30) THEN
  Filename$ = Filename$ + "A"
  dqbwait 15
 ELSEIF DQBkey(48) THEN
  Filename$ = Filename$ + "B"
  dqbwait 15
 ELSEIF DQBkey(46) THEN
  Filename$ = Filename$ + "C"
  dqbwait 15
 ELSEIF DQBkey(32) THEN
  Filename$ = Filename$ + "D"
  dqbwait 15
 ELSEIF DQBkey(18) THEN
  Filename$ = Filename$ + "E"
  dqbwait 15
 ELSEIF DQBkey(33) THEN
  Filename$ = Filename$ + "F"
  dqbwait 15
 ELSEIF DQBkey(34) THEN
  Filename$ = Filename$ + "G"
  dqbwait 15
 ELSEIF DQBkey(35) THEN
  Filename$ = Filename$ + "H"
  dqbwait 15
 ELSEIF DQBkey(23) THEN
  Filename$ = Filename$ + "I"
  dqbwait 15
 ELSEIF DQBkey(36) THEN
  Filename$ = Filename$ + "J"
  dqbwait 15
 ELSEIF DQBkey(37) THEN
  Filename$ = Filename$ + "K"
  dqbwait 15
 ELSEIF DQBkey(38) THEN
  Filename$ = Filename$ + "L"
  dqbwait 15
 ELSEIF DQBkey(50) THEN
  Filename$ = Filename$ + "M"
  dqbwait 15
 ELSEIF DQBkey(49) THEN
  Filename$ = Filename$ + "N"
  dqbwait 15
 ELSEIF DQBkey(24) THEN
  Filename$ = Filename$ + "O"
  dqbwait 15
 ELSEIF DQBkey(25) THEN
  Filename$ = Filename$ + "P"
  dqbwait 15
 ELSEIF DQBkey(16) THEN
  Filename$ = Filename$ + "Q"
  dqbwait 15
 ELSEIF DQBkey(19) THEN
  Filename$ = Filename$ + "R"
  dqbwait 15
 ELSEIF DQBkey(31) THEN
  Filename$ = Filename$ + "S"
  dqbwait 15
 ELSEIF DQBkey(20) THEN
  Filename$ = Filename$ + "T"
  dqbwait 15
 ELSEIF DQBkey(22) THEN
  Filename$ = Filename$ + "U"
  dqbwait 15
 ELSEIF DQBkey(47) THEN
  Filename$ = Filename$ + "V"
  dqbwait 15
 ELSEIF DQBkey(17) THEN
  Filename$ = Filename$ + "W"
  dqbwait 15
 ELSEIF DQBkey(45) THEN
  Filename$ = Filename$ + "X"
  dqbwait 15
 ELSEIF DQBkey(21) THEN
  Filename$ = Filename$ + "Y"
  dqbwait 15
 ELSEIF DQBkey(44) THEN
  Filename$ = Filename$ + "Z"
  dqbwait 15
 ELSEIF DQBkey(11) THEN
  Filename$ = Filename$ + "0"
  dqbwait 15
 ELSEIF DQBkey(2) THEN
  Filename$ = Filename$ + "1"
  dqbwait 15
 ELSEIF DQBkey(3) THEN
  Filename$ = Filename$ + "2"
  dqbwait 15
 ELSEIF DQBkey(4) THEN
  Filename$ = Filename$ + "3"
  dqbwait 15
 ELSEIF DQBkey(5) THEN
  Filename$ = Filename$ + "4"
  dqbwait 15
 ELSEIF DQBkey(6) THEN
  Filename$ = Filename$ + "5"
  dqbwait 15
 ELSEIF DQBkey(7) THEN
  Filename$ = Filename$ + "6"
  dqbwait 15
 ELSEIF DQBkey(8) THEN
  Filename$ = Filename$ + "7"
  dqbwait 15
 ELSEIF DQBkey(9) THEN
  Filename$ = Filename$ + "8"
  dqbwait 15
 ELSEIF DQBkey(10) THEN
  Filename$ = Filename$ + "9"
  dqbwait 15
 ELSEIF DQBkey(57) THEN
  Filename$ = Filename$ + " "
  dqbwait 15
 ELSEIF DQBkey(28) THEN
  valid = TRUE
  IF Filename$ = "" THEN
   valid = FALSE
  END IF
  IF valid = TRUE THEN
   IF DQBloadFont("F6x6A.FNT") THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0): dqbwait 100
   getuserdata$ = Filename$
   EXIT FUNCTION
  END IF
  dqbwait 15
 ELSEIF DQBkey(14) THEN
  IF LEN(Filename$) > 0 THEN
   filenametemp$ = LEFT$(Filename$, LEN(Filename$) - 1)
   Filename$ = filenametemp$
  END IF
  dqbwait 15
 END IF
LOOP
END FUNCTION

REM $DYNAMIC
'This procedure initalizes the game
SUB Init
CLS
LOCATE 2, 1
PRINT "TANKS LEVEL EDITOR Version 1.1--Updated Version"
'init DirectQB
IF DQBinit(4, 0, 0) THEN
 LOCATE 10, 1
 DQBclose
 PRINT DQBerror$
 PRINT "For Further Info Read README.TXT"
 END
END IF
'Open TANKS.DAT
IF DQBopenDataFile("TANKS.DAT", "TANKS") THEN
 LOCATE 6, 1
 DQBclose
 PRINT DQBerror$ + " TANKS.DAT"
 PRINT "SEE README.TXT FOR HELP"
 END
END IF
IF DQBmouseDetected = 0 THEN
 LOCATE 5, 1
 PRINT "Mouse Not Detected"
 PRINT "For Further Info Read README.TXT"
 END
ELSE
 LOCATE 5, 1
 PRINT "Mouse Detected"
END IF
DQBinitVGA
DQBinstallKeyboard

END SUB

REM $STATIC
FUNCTION loadarea (file$, Layer, area)
OPEN "LEVELS\" + file$ + ".LEV" FOR BINARY AS #1
IF LOF(1) = 0 THEN
 CLOSE #1
 KILL "LEVELS\" + file$ + ".LEV"
 DQBprint VIDEO, "File Does Not Exist", 1, 1, DQBfindCol(63, 0, 0):
 dqbwait 100
 CLOSE
 loadarea = FALSE
 EXIT FUNCTION
END IF
CLOSE
OPEN "LEVELS\" + file$ + ".LEV" FOR INPUT AS #1
DQBclearLayer 1
DQBpaint Layer, 1, 1, DQBfindCol(63, 63, 63)
  LINE INPUT #1, in$
  'get # of trees
  LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): treeN = VAL(LTRIM$(RTRIM$(a$)))
  FOR i = 1 TO treeN
   LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): treex(i) = VAL(LTRIM$(RTRIM$(a$)))
   LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): treey(i) = VAL(LTRIM$(RTRIM$(a$)))
   DQBput Layer, treex(i), treey(i), VARSEG(tree(0)), VARPTR(tree(0))
  NEXT
  'get # of walls
  LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): wallN = VAL(LTRIM$(RTRIM$(a$)))
  FOR i = 1 TO wallN
   LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): wallx(i) = VAL(LTRIM$(RTRIM$(a$)))
   LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): wally(i) = VAL(LTRIM$(RTRIM$(a$)))
   DQBput Layer, wallx(i), wally(i), VARSEG(wall(0)), VARPTR(wall(0))
  NEXT
  'get # of buildings
  LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): buildingN = VAL(LTRIM$(RTRIM$(a$)))
  FOR i = 1 TO buildingN
   LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): buildingx(i) = VAL(LTRIM$(RTRIM$(a$)))
   LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): buildingy(i) = VAL(LTRIM$(RTRIM$(a$)))
   DQBput Layer, buildingx(i), buildingy(i), VARSEG(building(0)), VARPTR(building(0))
  NEXT
  'get # of waters
  LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): waterN = VAL(LTRIM$(RTRIM$(a$)))
  FOR i = 1 TO waterN
   LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): waterx(i) = VAL(LTRIM$(RTRIM$(a$)))
   LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): watery(i) = VAL(LTRIM$(RTRIM$(a$)))
   DQBput Layer, waterx(i), watery(i), VARSEG(water(0)), VARPTR(water(0))
  NEXT
  'get player one
  LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): P1tank.posx = VAL(LTRIM$(RTRIM$(a$)))
  LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): P1tank.posy = VAL(LTRIM$(RTRIM$(a$)))
  LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): P1tank.dir = VAL(LTRIM$(RTRIM$(a$)))
  IF P1tank.dir = UP THEN
   DQBput 1, P1tank.posx, P1tank.posy, VARSEG(P1tankuf1(0)), VARPTR(P1tankuf1(0))
  ELSEIF P1tank.dir = DOWN THEN
   DQBput 1, P1tank.posx, P1tank.posy, VARSEG(P1tankdf1(0)), VARPTR(P1tankdf1(0))
  ELSEIF P1tank.dir = RIGHT THEN
   DQBput 1, P1tank.posx, P1tank.posy, VARSEG(p1tankrf1(0)), VARPTR(p1tankrf1(0))
  ELSEIF P1tank.dir = LEFT THEN
   DQBput 1, P1tank.posx, P1tank.posy, VARSEG(p1tanklf1(0)), VARPTR(p1tanklf1(0))
  END IF
  'get player two
  LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): P2tank.posx = VAL(LTRIM$(RTRIM$(a$)))
  LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): P2tank.posy = VAL(LTRIM$(RTRIM$(a$)))
  LINE INPUT #1, in$: a$ = MID$(in$, 1, 10): P2tank.dir = VAL(LTRIM$(RTRIM$(a$)))
  IF P2tank.dir = UP THEN
   DQBput 1, P2tank.posx, P2tank.posy, VARSEG(P2tankuf1(0)), VARPTR(P2tankuf1(0))
  ELSEIF P2tank.dir = DOWN THEN
    DQBput 1, P2tank.posx, P2tank.posy, VARSEG(P2tankdf1(0)), VARPTR(P2tankdf1(0))
  ELSEIF P2tank.dir = RIGHT THEN
   DQBput 1, P2tank.posx, P2tank.posy, VARSEG(p2tankrf1(0)), VARPTR(p2tankrf1(0))
  ELSEIF P2tank.dir = LEFT THEN
   DQBput 1, P2tank.posx, P2tank.posy, VARSEG(p2tanklf1(0)), VARPTR(p2tanklf1(0))
  END IF
CLOSE
p1placed = TRUE
p2placed = TRUE
loadarea = TRUE
END FUNCTION

FUNCTION prompt (Text$, questiontype, x1, y1, x2, y2)
dqbmousehide
DQBclearLayer 3
DQBclearLayer VIDEO
DQBbox 3, x1, y1, x2, y2, DQBfindPalCol(pal, 0, 0, 0)
DQBboxf 3, x1 + 1, y1 + 1, x2 - 1, y2 - 1, DQBfindPalCol(pal, 0, 0, 50)
DQBprint 3, Text$, CENTERED, ((y1 + y2) \ 2), DQBfindPalCol(pal, 63, 0, 0)
IF questiontype = YESNO THEN
 drawbutton x1 + 10, y1 + 60, "YES", 3
 drawbutton x2 - 50, y1 + 60, "NO ", 3
 dqbcopylayer 3, VIDEO
 dqbmouseshow
 DO
  IF DQBmouseLB = -1 AND DQBmouseX > x1 + 10 AND DQBmouseX < x1 + 35 AND DQBmouseY > y1 + 60 AND DQBmouseY < y1 + 75 THEN
   prompt = YES
   EXIT FUNCTION
  ELSEIF DQBmouseLB = -1 AND DQBmouseX > x2 - 50 AND DQBmouseX < x2 - 25 AND DQBmouseY > y1 + 60 AND DQBmouseY < y1 + 75 THEN
   prompt = NO
   EXIT FUNCTION
  END IF
 LOOP
END IF
END FUNCTION

DEFSNG A-Z
SUB Quit
DQBclearLayer 4
dqbmousehide
IF DQBloadFont("HITECH.FNT") THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0)
DQBboxf 4, 90, 70, 230, 130, DQBfindPalCol(pal, 0, 0, 50)
DQBprint 4, "QUIT?", CENTERED, 95, DQBfindPalCol(pal, 63, 0, 0)
drawbutton 110, 110, "YES", 4
drawbutton 170, 110, "NO!", 4
dqbcopylayer 4, VIDEO
DQBsetMouseRange 90, 70, 230, 130
DQBsetMousePos 160, 100
dqbmouseshow
DO
 IF DQBmouseLB = -1 AND DQBmouseX > 109 AND DQBmouseX < 150 AND DQBmouseY > 110 AND DQBmouseY < 125 THEN
  dqbwait 25
  DQBclose
  END
 END IF
 IF DQBmouseLB = -1 AND DQBmouseX > 169 AND DQBmouseX < 209 AND DQBmouseY > 110 AND DQBmouseY < 125 THEN
  DQBsetMouseRange 0, 0, 300, 160
  dqbwait 25
  dqbmousehide
  EXIT SUB
 END IF
LOOP
END SUB

DEFINT A-Z
SUB savearea (file$)
OPEN "LEVELS\" + file$ + ".LEV" FOR BINARY AS #1
IF LOF(1) > 0 THEN
 IF DQBloadFont("HITECH.FNT") THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0): dqbwait 100
 result = prompt("OVERWRITE " + file$ + ".LEV", YESNO, 75, 70, 245, 160)
 IF result = NO THEN
  CLOSE
  EXIT SUB
 END IF
END IF
CLOSE
worldtitle$ = getuserdata$("Enter Level Title", 25)
OPEN "LEVELS\" + file$ + ".LEV" FOR OUTPUT AS #1
  'save # of trees
   PRINT #1, LTRIM$(worldtitle$)
   PRINT #1, LTRIM$(STR$(treeN)), "TREES"
  FOR i = 1 TO treeN
   PRINT #1, LTRIM$(STR$(treex(i)))
   PRINT #1, LTRIM$(STR$(treey(i)))
  NEXT
  'save # of walls
  PRINT #1, LTRIM$(STR$(wallN)), "WALLS"
  FOR i = 1 TO wallN
   PRINT #1, LTRIM$(STR$(wallx(i)))
   PRINT #1, LTRIM$(STR$(wally(i)))
  NEXT
  'save # of buildings
  PRINT #1, LTRIM$(STR$(buildingN)), "HOUSES"
  FOR i = 1 TO buildingN
   PRINT #1, LTRIM$(STR$(buildingx(i)))
   PRINT #1, LTRIM$(STR$(buildingy(i)))
  NEXT
  'save # of waters
  PRINT #1, LTRIM$(STR$(waterN)), "WATER"
  FOR i = 1 TO waterN
   PRINT #1, LTRIM$(STR$(waterx(i)))
   PRINT #1, LTRIM$(STR$(watery(i)))
  NEXT
  PRINT #1, LTRIM$(STR$(P1tank.posx))
  PRINT #1, LTRIM$(STR$(P1tank.posy))
  PRINT #1, LTRIM$(STR$(P1tank.dir))
  PRINT #1, LTRIM$(STR$(P2tank.posx))
  PRINT #1, LTRIM$(STR$(P2tank.posy))
  PRINT #1, LTRIM$(STR$(P2tank.dir))
CLOSE
IF DQBloadFont("F6x6a.FNT") THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0): dqbwait 100
END SUB

SUB showmenu
DQBclearLayer 2
DQBsetMouseRange 0, 0, 320, 200
DQBput 2, 162, 90, VARSEG(wall(0)), VARPTR(wall(0))
DQBput 2, 160, 111, VARSEG(tree(0)), VARPTR(tree(0))
DQBput 2, 141, 90, VARSEG(water(0)), VARPTR(water(0))
DQBput 2, 141, 111, VARSEG(building(0)), VARPTR(building(0))
DQBput 2, 120, 90, VARSEG(P1tankuf1(0)), VARPTR(P1tankuf1(0))
DQBput 2, 120, 111, VARSEG(P2tankuf1(0)), VARPTR(P2tankuf1(0))
drawbutton 250, 73, "NEW ", 2
drawbutton 250, 90, "LOAD", 2
drawbutton 250, 107, "SAVE", 2
drawbutton 250, 124, "MAKE", 2
drawbutton 250, 141, "QUIT", 2
dqbwait 10
dqbmousehide
dqbcopylayer 2, VIDEO
dqbmouseshow
DO
 dqbwait 2
 IF DQBmouseLB = -1 AND DQBmouseX > 120 AND DQBmouseX < 140 AND DQBmouseY > 90 AND DQBmouseY < 110 THEN
  curitem = ITMP1TANK
  dqbmousehide
  dqbcopylayer 1, VIDEO
  dqbmouseshow
  EXIT SUB
 ELSEIF DQBmouseLB = -1 AND DQBmouseX > 120 AND DQBmouseX < 140 AND DQBmouseY > 110 AND DQBmouseY < 130 THEN
  curitem = ITMP2TANK
  dqbmousehide
  dqbcopylayer 1, VIDEO
  dqbmouseshow
  EXIT SUB
 ELSEIF DQBmouseLB = -1 AND DQBmouseX > 140 AND DQBmouseX < 160 AND DQBmouseY > 90 AND DQBmouseY < 110 THEN
  curitem = ITMWATER
  dqbmousehide
  dqbcopylayer 1, VIDEO
  dqbmouseshow
  EXIT SUB
 ELSEIF DQBmouseLB = -1 AND DQBmouseX > 140 AND DQBmouseX < 160 AND DQBmouseY > 110 AND DQBmouseY < 130 THEN
  curitem = ITMBUILDING
  dqbmousehide
  dqbcopylayer 1, VIDEO
  dqbmouseshow
  EXIT SUB
 ELSEIF DQBmouseLB = -1 AND DQBmouseX > 160 AND DQBmouseX < 180 AND DQBmouseY > 90 AND DQBmouseY < 110 THEN
  curitem = ITMWALL
  dqbmousehide
  dqbcopylayer 1, VIDEO
  dqbmouseshow
  EXIT SUB
 ELSEIF DQBmouseLB = -1 AND DQBmouseX > 160 AND DQBmouseX < 202 AND DQBmouseY > 110 AND DQBmouseY < 130 THEN
  curitem = ITMTREE
  dqbmousehide
  dqbcopylayer 1, VIDEO
  dqbmouseshow
  EXIT SUB
 ELSEIF DQBmouseLB = -1 AND DQBmouseX > 250 AND DQBmouseX < 298 AND DQBmouseY > 141 AND DQBmouseY < 157 THEN
 'Exit level editor
  Quit
  dqbcopylayer 2, VIDEO
  dqbmouseshow
 ELSEIF DQBmouseLB = -1 AND DQBmouseX > 250 AND DQBmouseX < 298 AND DQBmouseY > 107 AND DQBmouseY < 124 THEN
 'save level
  file$ = getuserdata$("ENTER FILENAME", 8)
  savearea file$
  saved = TRUE
  dqbmousehide
  dqbcopylayer 2, VIDEO
  dqbmouseshow
 ELSEIF DQBmouseLB = -1 AND DQBmouseX > 250 AND DQBmouseX < 298 AND DQBmouseY > 90 AND DQBmouseY < 105 THEN
 'load level
  file$ = getuserdata$("ENTER FILENAME", 8)
  result = loadarea(file$, 1, 1)
  IF result = TRUE THEN
   statusbar
   dqbmousehide
   dqbcopylayer 1, VIDEO
   dqbmouseshow
   EXIT SUB
  END IF
  dqbmousehide
  dqbcopylayer 2, VIDEO
  dqbmouseshow
 ELSEIF DQBmouseLB = -1 AND DQBmouseX > 250 AND DQBmouseX < 298 AND DQBmouseY > 73 AND DQBmouseY < 89 THEN
  IF saved = TRUE THEN
   p1placed = FALSE
   p2placed = FALSE
   waterN = 0: wallN = 0: treeN = 0: buildingN = 0
   dqbmousehide
   DQBclearLayer 1
   DQBpaint 1, 1, 1, DQBfindCol(63, 63, 63)
   dqbmouseshow
   EXIT SUB
  ELSEIF saved = FALSE THEN
   IF DQBloadFont("HITECH.FNT") THEN DQBprint VIDEO, DQBerror$, 1, 1, DQBfindCol(63, 0, 0): dqbwait 100
   result = prompt("SAVE FIRST?", YESNO, 100, 70, 220, 160)
   IF result = YES THEN
    file$ = getuserdata$("ENTER FILENAME", 8)
    savearea file$
    saved = TRUE
    waterN = 0: wallN = 0: treeN = 0: buildingN = 0: p1placed = FALSE: p2placed = FALSE
    dqbmousehide
    DQBclearLayer 1
    DQBpaint 1, 1, 1, DQBfindCol(63, 63, 63)
    dqbmouseshow
    EXIT SUB
   ELSEIF result = NO THEN
    waterN = 0: wallN = 0: treeN = 0: buildingN = 0
    dqbmousehide
    DQBclearLayer 1
    DQBpaint 1, 1, 1, DQBfindCol(63, 63, 63)
    dqbmouseshow
    EXIT SUB
   END IF
  END IF
 ELSEIF DQBmouseLB = -1 AND DQBmouseX > 250 AND DQBmouseX < 298 AND DQBmouseY > 123 AND DQBmouseY < 140 THEN
  compileworld
  dqbmousehide
  dqbcopylayer 2, VIDEO
  dqbmouseshow
 END IF
LOOP
END SUB

SUB statusbar
DQBprint 1, "Bricks", 125, 183, DQBfindPalCol(pal, 30, 30, 30)
DQBprint 1, "Gas Plants", 170, 183, DQBfindPalCol(pal, 30, 30, 30)
DQBprint 1, "Waters", 237, 183, DQBfindPalCol(pal, 30, 30, 30)
DQBprint 1, "Houses", 280, 183, DQBfindPalCol(pal, 30, 30, 30)
DQBprint 1, "TANKS Level Editor", 2, 183, DQBfindPalCol(pal, 30, 30, 30)
DQBboxf 1, 0, 190, 320, 200, DQBfindPalCol(pal, 45, 45, 45)
DQBprint 1, "X " + LTRIM$(STR$(DQBmouseX)), 1, 192, DQBfindPalCol(pal, 63, 0, 0)
DQBprint 1, "Y " + LTRIM$(STR$(DQBmouseY)), 50, 192, DQBfindPalCol(pal, 63, 0, 0)
DQBprint 1, LTRIM$(STR$(wallN)), 141, 192, DQBfindPalCol(pal, 30, 10, 63)
DQBprint 1, LTRIM$(STR$(treeN)), 195, 192, DQBfindPalCol(pal, 30, 10, 63)
DQBprint 1, LTRIM$(STR$(waterN)), 252, 192, DQBfindPalCol(pal, 30, 10, 63)
DQBprint 1, LTRIM$(STR$(buildingN)), 295, 192, DQBfindPalCol(pal, 30, 10, 63)
dqbmousehide
dqbcopylayer 1, VIDEO
dqbmouseshow
END SUB

SUB Welcome
DQBclearLayer VIDEO
DQBclearLayer 1
DQBboxf 1, 80, 50, 240, 150, DQBfindPalCol(pal, 63, 0, 0)
DQBprint 1, "Welcome to Tanks", CENTERED, 60, DQBfindPalCol(pal, 0, 63, 0)
DQBprint 1, "Level Editor", CENTERED, 70, DQBfindPalCol(pal, 0, 63, 0)
DQBprint 1, "View README.TXT for", CENTERED, 90, DQBfindPalCol(pal, 0, 63, 63)
DQBprint 1, "Instructions", CENTERED, 100, DQBfindPalCol(pal, 0, 63, 63)
drawbutton 150, 120, "OK", 1
DQBsetMouseRange 150, 120, 180, 135
dqbcopylayer 1, VIDEO
dqbmouseshow
DO: LOOP UNTIL DQBmouseLB = -1

END SUB

