{ HANOI.PAS - Torens van Hanoi

  Titel   : HANOI
  Taal    : Borland Pascal v7.0, Real mode
  Versie  : 1.3
  Datum   : 8 feb 2000
  Auteur  : J R Ferguson
  Download: http://hello.to/ferguson
  E-mail  : j.r.ferguson@iname.com

Dit programma en de bijbehorende source  mag  zonder  vergoeding  worden
gebruikt  en gekopieerd, maar uitsluitend zonder winstoogmerk. De auteur
is niet  aansprakelijk  voor  enige  schade  of  verlies  van  gegevens,
veroorzaakt door het gebruik ervan.
}

{$R+}   {Range checking on}


PROGRAM HANOI;

Uses Crt;

CONST
  schijven         = 9;    {max. 9 i.v.m. enkeltoetsinvoer}
  tijdfaktor       = 5000; {afstellen naar gelang computersnelheid}
  wachttijd        = 100;
  eersteregel      = 1;
  schuifregel      = 5;
  grondregel       = 17;
  foutregel        = 20;
  meldregel        = 21;
  promptregel      = 22;
  laatsteregel     = 22;
  linkerkantlijn   = 2;
  meldkolom        = 33;
  rechterkantlijn  = 77;
  afst             = 25;   {(rechterkantlijn-linkerkantlijn) div 3}
  instrlen         = 20;

TYPE
  regelnr          = eersteregel..laatsteregel;
  kolomnr          = linkerkantlijn..rechterkantlijn;
  schijfnr         = 1..schijven;
  schijfteller     = 0..schijven;
  torennr          = 1..3;
  ptschijf         = ^schijf;
  pttoren          = ^toren;
  schijf           = record
                       nr    : schijfnr;
                       opv   : ptschijf;
                       regel : regelnr
                     end;
  toren            = record
                       nr    : torennr;
                       top   : ptschijf
                     end;

VAR
  t1,t2,t3         : pttoren;
  x                : ptschijf;
  aantal,stapnr,z  : integer;
  uitleg,
  automatisch      : boolean;
  bel              : char;
  witkar           : char;
  grijskar         : char;

{============================================================================}
{ algemeen gereedschap }
{============================================================================}
procedure initglobals;
  begin
    bel     := chr(  7); {piepje}
    grijskar:= chr(177);
    witkar  := chr(219);
  end;

procedure positie (reg: regelnr; kol: kolomnr);
{regel 0 = bovenrand scherm, kolom 0 = linkerrand scherm }
  begin GotoXY(kol+1,reg+1); end;

procedure uitlegtekst;
  const marge = '             ';
  begin
    positie (schuifregel,linkerkantlijn);
    writeln;
    writeln (marge,'Verplaats alle schijven van toren 1 naar toren 3');
    writeln;
    writeln;
    writeln (marge,'           Dit zijn de spelregels :');
    writeln;
    writeln (marge,'Er kan maar 1 schijf tegelijk worden verplaatst.');
    writeln (marge,'Er mag nooit een grotere op een kleinere schijf liggen.')
  end;

procedure wisuitlegtekst;
  const aantalregels = 8;
  var r : regelnr;
  begin
    for r := schuifregel to schuifregel+aantalregels do begin
      positie(r,linkerkantlijn);
      ClrEol;
    end;
  end;

function hoofdletter(c:char):char;
  begin
    if c in ['a'..'z']
      then hoofdletter := chr(ord(c)+ord('A')-ord('a'))
      else hoofdletter := c
  end;

function toets: char;
{direkte invoer van een karakter met hoofdletterconversie
 en echo indien afdrukbaar}
  var c : char;
  begin
    c:= ReadKey;
    if c in [' '..'~'] then write(c);
    toets := hoofdletter(c)
  end;


function aantalstappen (n: schijfnr): integer;
  begin
    if n=1 then aantalstappen := 1
           else aantalstappen := 2*aantalstappen(n-1) + 1
  end;

procedure wacht (t: integer);
  var i,j : integer;
  begin
    for i:= 1 to t do
    for j:= 1 to tijdfaktor do {niets}
  end;

function schijfkolom (t: torennr; b: integer): kolomnr;
{beginkolom van schijf met breedte b op of boven toren t}
  begin
    schijfkolom := linkerkantlijn + (t-1)*afst + ((afst-b) div 2)
  end;

function karakterwaarde (c: char): integer;
{cijferwaarde van karakter c of -1 indien geen cijfer}
  begin
    if c in ['0'..'9']
    then karakterwaarde := ord(c)-ord('0')
    else karakterwaarde := -1
  end;

function nogeens : boolean;
  var c : char;
  begin
    repeat
      positie (promptregel,meldkolom);
      write ('Nog eens? (J/N) : '); ClrEol;
      c := toets
    until (c in ['J','N']);
    nogeens := c ='J'
  end;

procedure beweeghorizontaal (beginkolom,eindkolom: kolomnr; breedte: integer);
  var kn: kolomnr;
  begin
    kn := beginkolom;
    while kn<>eindkolom do
      begin
        if kn<eindkolom then
          begin
            positie (schuifregel,kn)        ; write (' ');
            positie (schuifregel,kn+breedte); write (witkar);
            kn:= kn+1
          end
        else
          begin
            positie (schuifregel,kn-1)        ; write (witkar);
            positie (schuifregel,kn+breedte-1); write (' ');
            kn:= kn-1
          end;
        wacht(z)
      end
  end; {beweeghorizontaal}

procedure beweegvertikaal (kolom: kolomnr;
                           beginregel,eindregel: regelnr; breedte: integer);
  var k : integer;
      r : regelnr;
      v : integer;
  begin
    if eindregel>beginregel then v:= 1 else v:= -1;
    r := beginregel;
    while r <> eindregel do
      begin
        positie (r,kolom);
        for k:= 1 to breedte do write (' ');
        positie (r+v,kolom);
        for k:= 1 to breedte do write (witkar);
        r := r+v;
        wacht(2*z)
      end
  end; {beweegvertikaal}

procedure neemop (trn: torennr; sch: schijfnr; reg: regelnr);
  var breedte,beginkol,eindkol : integer;
  begin
    breedte  := 2*sch+1;
    beginkol := schijfkolom (trn,breedte);
    eindkol  := schijfkolom (2,breedte);
    beweegvertikaal   (beginkol,reg,schuifregel,breedte);
    beweeghorizontaal (beginkol,eindkol,breedte)
  end; {neemop}

procedure zetneer (trn: torennr; sch: schijfnr; reg: regelnr);
  var breedte,beginkol,eindkol : integer;
  begin
    breedte  := 2*sch+1;
    beginkol := schijfkolom (2,breedte);
    eindkol  := schijfkolom (trn,breedte);
    beweeghorizontaal (beginkol,eindkol,breedte);
    beweegvertikaal   (eindkol,schuifregel,reg,breedte)
  end; {zetneer}

procedure verplaats (v,n: pttoren);
  var x,y : ptschijf;
  begin
    wacht (z*wachttijd);
    x := v^.top;
    y := x^.opv;
    v^.top := y;
    neemop (v^.nr,x^.nr,x^.regel);
    x^.opv := n^.top;
    n^.top := x;
    if x^.opv<>nil
      then x^.regel := x^.opv^.regel-1
      else x^.regel := grondregel-1;
    zetneer (n^.nr,x^.nr,x^.regel);
    wacht (z*wachttijd);
  end;

{============================================================================}
procedure bouwom (k: schijfteller; van, hulp, naar: pttoren);
{============================================================================}
{verplaats bovenste k schijven van toren v naar toren n,
 met toren h als tussenstation }
  begin
    if k>0 then
      begin
        bouwom (k-1,van,naar,hulp);
        stapnr := stapnr+1;
        positie (meldregel,meldkolom); write ('stap nr :',stapnr:3);
        positie (promptregel,meldkolom);
        write('van ',van^.nr:1,' naar ',naar^.nr:1);
        verplaats (van,naar);
        bouwom (k-1,hulp,van,naar)
      end
    end; {bouwom}

{============================================================================}
procedure interaktief (van, hulp, naar: pttoren);
{============================================================================}
  var k,a    : integer;
      v,n    : torennr;
      torens : array[torennr] of pttoren;
      ok     : boolean;

  function inok (t:integer): boolean;
    begin inok := t in [1,2,3] end;

  function torenok (top: ptschijf): boolean;
    begin
      if top=nil
      then torenok := true
      else if top^.opv=nil
           then torenok := true
           else torenok := top^.nr < top^.opv^.nr
    end;

  begin {proc interaktief}
    torens[1] := van;
    torens[2] := hulp;
    torens[3] := naar;
    k := 0;
    repeat
      k := k+1;
      positie (meldregel,meldkolom); write ('stap nr :',k:3);
      positie (promptregel,meldkolom); write ('van ');
      repeat
        positie (promptregel,meldkolom+4); ClrEol;
        a := karakterwaarde (toets);
        if not inok (a)
        then
          begin
            ok := false;
            positie (foutregel,meldkolom);
            write (bel); ClrEol;
          end
        else
          begin
            ok := torens[a]^.top<>nil;
            if not ok then
              begin
                positie (foutregel,meldkolom);
                write (bel,'Bij <',a:1,'> ligt geen schijf!'); ClrEol;
              end
          end
    until ok;

    positie (foutregel,meldkolom); ClrEol;
    positie (promptregel,meldkolom+4); write (a:1,' naar ');
    v := a;
    repeat
      positie (promptregel,meldkolom+11); ClrEol;
      a := karakterwaarde (toets);
      if not inok (a) then write (bel);
    until inok (a);
    positie (promptregel,meldkolom+11); write (a:1); ClrEol;
    n := a;
    if v=n then
      begin
        positie (foutregel,meldkolom);
        write (bel,'Die ligt daar al!'); ClrEol;
        k:= k-1
      end
    else
      begin
        verplaats (torens[v],torens[n]);
        if not torenok(torens[n]^.top) then
        begin
          positie (foutregel,meldkolom); write (bel,'Niet toegestaan');
          wacht (5*wachttijd);
          verplaats (torens[n],torens[v]);
          positie (foutregel,meldkolom); ClrEol;
        end
      end
  until (van^.top=nil) and (hulp^.top=nil);

  positie (foutregel,meldkolom);
  write ('  GOED ZO!'); ClrEol;
end; {proc interaktief}

{============================================================================}
procedure dialoog (hulp : boolean;
                   var n: integer; var t1,t2,t3: pttoren; var auto: boolean);
{============================================================================}
  var antw : char;
      z1   : integer;
      r    : regelnr;
      k    : kolomnr;
      t    : torennr;

  procedure initschijven;
    var s       : schijfnr;
        breedte : integer;
        regel   : regelnr;
        kolom   : kolomnr;
    begin
      z := 0;
      new (t1); t1^.nr := 1; t1^.top := nil;
      new (t2); t2^.nr := 2; t2^.top := nil;
      new (t3); t3^.nr := 3; t3^.top := nil;
      for s := n downto 1 do
        begin
          new (x);
          with x^ do
            begin
              nr := s;
              opv := t1^.top;
              t1^.top := x;
              breedte := 2*s+1;
              regel   := (grondregel-1)-n+s;
              kolom   := schijfkolom (1,breedte);
              beweegvertikaal(kolom,regel-1,regel,breedte);
            end
        end
    end; {proc initschijven}

  begin {proc dialoog}

    ClrScr;
    positie (eersteregel,linkerkantlijn+29); write ('TORENS VAN HANOI');
    positie (grondregel,linkerkantlijn);
    for k:= linkerkantlijn to rechterkantlijn do write (grijskar);
    for t:= 1 to 3 do
      begin
        positie (grondregel+1,schijfkolom(t,3));
        write ('<',t:1,'>')
      end;
    if hulp then uitlegtekst;

    {* interaktief of automatisch? }
    repeat
      positie (promptregel,linkerkantlijn);
      write ('Automatisch of Zelf doen? (A of Z): '); ClrEol;
      antw := toets;
    until antw in ['A','Z'];
    auto := antw='A';
    if hulp then wisuitlegtekst;

    {* vraag aantal *}
    repeat
      positie (promptregel,linkerkantlijn);
      write ('aantal schijven ','? (1-',schijven:1,') : ');ClrEol;
      n:= karakterwaarde(toets);
    until (n>=1) and (n<=schijven);
    positie (eersteregel,linkerkantlijn);
    write (n:1,' schijven');
    initschijven;
    positie (eersteregel,rechterkantlijn-15);
    write (aantalstappen(n):3,' stappen nodig');

    if auto then
      begin
        {* vraag snelheid *}
        repeat
          positie (promptregel,linkerkantlijn);
          write ('snelheid ','? (1-9) : '); ClrEol;
          z1:= karakterwaarde(toets)
        until (z1>=1) and (z1<=9);
        positie (foutregel,meldkolom);
        write ('snelheid : ',z1:1); ClrEol;
        z:= 9-z1;
        stapnr := 0;
        wacht (z*wachttijd)
      end
    else z := 0;

    positie (promptregel,linkerkantlijn); ClrEol;
  end; {proc dialoog}

{============================================================================}
BEGIN {program}
{============================================================================}
  initglobals;
  uitleg := true;
  repeat
    dialoog (uitleg,aantal,t1,t2,t3,automatisch);
    uitleg := false;
    if automatisch
      then bouwom (aantal,t1,t2,t3)
      else interaktief (t1,t2,t3)
  until not nogeens
END.
