'Subject: RC4 ENCRYPTION ALGORITHM 
'Author: Scott Spiker (scott_spiker@hypercom.com)
'This is a set of routines to support encryption and decryption using the
'RC4 algorithm. To use it, the key is passed to the initialization routine,
'RC4INIT before doing either encryption or decryption. The key may be up to
'255 bytes long, longer keys are simpy ignored pass the 255th byte.
'This algorithm is easy, fast and secure

DEFINT A-Z
DECLARE FUNCTION Rc4$ (txt$)           'String encryption routine
DECLARE FUNCTION Rc4K% (InitFlag%)     'Get next cipher byte
DECLARE SUB Rc4Init (Key$)             'Initialize the key

DIM SHARED Schedule(0 TO 255)          'S-Box table
DIM SHARED KeySchedule(0 TO 255)       'Key schedule

Key$ = "TEST KEY": Clear$ = "12345678901Aabc"
                                       
                                      
CLS
Rc4Init (Key$)                         'Initialize the key schedule

Encrypted$ = Rc4(Clear$)               'Encrypt the string
PRINT Encrypted$

Rc4Init (Key$)                         're-Initialize the key
Clear$ = Rc4(Encrypted$)               'Decrypt the string

PRINT Clear$

FUNCTION Rc4$ (txt$)
     'This routine encrypts the string

     StringLen = LEN(txt$)
     FOR x = 1 TO StringLen
          c = ASC(MID$(txt$, x, 1))
          k = Rc4K(0)
          r$ = r$ + CHR$(c XOR k)
     NEXT x
     Rc4$ = r$

END FUNCTION

SUB Rc4Init (Key$)
    
     KeyLen = LEN(Key$)

     FOR i = 0 TO 255
          Schedule(i) = i
          KeyPtr = KeyPtr + 1
          KeySchedule(i) = ASC(MID$(Key$, KeyPtr, 1))
          IF KeyPtr = KeyLen THEN KeyPtr = 0
     NEXT i

     FOR i = 0 TO 255
          j = (j + Schedule(i) + KeySchedule(i)) MOD 256
          SWAP Schedule(i), Schedule(j)
     NEXT i
     i = Rc4K(1)                                  'Reset key schedule

END SUB

FUNCTION Rc4K (InitFlag)
     STATIC i, j

     IF InitFlag THEN                   'Reset key schedule
          i = 0: j = 0
     ELSE
          i = (i + 1) MOD 256
          j = (j + Schedule(i)) MOD 256
          SWAP Schedule(i), Schedule(j)
          t = (Schedule(i) + Schedule(j)) MOD 256
          Rc4K = Schedule(t)
     END IF

END FUNCTION

