.286
.model tiny
.code
org 100h
Start:
;*****************************************************************************
;*     稭 .                                    *
;*****************************************************************************
                mov    al,13h
                int    10h
                push   0A000h
                pop    es
                xor    ax,ax
                int    1Ah
                mov    word ptr [Memory+RandCell2],dx

                call   DrawBackground
                call   SetPalettes
                call   InstallKeyboard

                push   offset [ReadyLine]
                push   offset [Memory+CometsBuf]
                push   90 98
                call   SpriteGAP
                add    sp,8
@WaitForAKey:
                test   byte ptr [Memory+Keys+kSPACE],1
                jnz    @BreakKey
                jmp    short @WaitForAKey
@BreakKey:
                push   offset [Memory+CometsBuf]
                push   90 98
                call   PutBlock
                add    sp,6

                xor    ax,ax
                int    1Ah
                mov    word ptr [Timer],dx
                mov    word ptr [Timer+2],cx

; ********************
; ***   ***
; ********************
                call   PrepareLevel
@MainLoop:
                call   ShowStars

                cmp    [ShipLife],0
                jle    @JOver1
                push   offset ShipSprite
                push   offset [Memory+ShipBuf]
                push   XShip YShip
                call   SpriteGAP
                add    sp,8
                call   ShowShield
@JOver1:
                push   20 CometsC
                push   offset [CometSprite]
                push   CometsBuf
                push   62 2 0
                call   ShowLinear
                add    sp,14

                push   140 FoeData
                push   offset [FoeSprites]
                push   FoeBuf
                push   65 7 4
                call   ShowLinear
                add    sp,14

                push   700 FWData
                push   offset [FoeWeapons]
                push   FWBuf
                push   62 7 4
                call   ShowLinear
                add    sp,14

                push   20 BlasterC
                push   offset [BlasterSprite]
                push   BlasterBuf
                push   62 2 0
                call   ShowLinear
                add    sp,14

                call   ShowExplosions

                call   ShowIndicators

                call   WaitRetrace

                call   HideExplosions

                push   20 BlasterC
                push   BlasterBuf
                push   62 2
                call   HideLinear
                add    sp,10

                push   700 FWData
                push   FWBuf
                push   62 7
                call   HideLinear
                add    sp,10

                push   140 FoeData
                push   FoeBuf
                push   65 7
                call   HideLinear
                add    sp,10

                push   20 CometsC
                push   CometsBuf
                push   62 2
                call   HideLinear
                add    sp,10

                cmp    [ShipLife],0
                jle    @JOver2
                push   offset [Memory+ShipBuf]
                push   XShip YShip
                call   PutBlock
                add    sp,6
@JOver2:
                call   HideStars

; *** ᫨ ன ஢ ***
                call   IsEverybodyDead
                or     al,al
                jz     @NoLevelCleared
                inc    [Level]
                mov    al,[Level]
                cmp    al,[LastLevel]
                jnz    @NoWinTheGame
                call   WinTheGame
@NoWinTheGame:
                call   PrepareLevel
@NoLevelCleared:

; ** If 'q' was pressed **
                cmp    byte ptr [Memory+Keys+kQ],1
                jnz    @Key1
                jmp    @Exit
@Key1:
                cmp    byte ptr [Memory+Keys+kLARROW],1
                jnz    @Key2
                cmp    [XShip],2
                jle    @Key2
                dec    [XShip]
@Key2:
                cmp    byte ptr [Memory+Keys+kRARROW],1
                jnz    @Key3
                cmp    [XShip],188
                jge    @Key3
                inc    [XShip]
@Key3:
                cmp    byte ptr [Memory+Keys+kUARROW],1
                jnz    @Key4
                cmp    [YShip],2
                jle    @Key4
                dec    [YShip]
@Key4:
                cmp    byte ptr [Memory+Keys+kDARROW],1
                jnz    @Key5
                cmp    [YShip],188
                jge    @Key5
                inc    [YShip]
@Key5:
                cmp    byte ptr [Memory+Keys+kSPACE],1
                jnz    @Key6
                cmp    [YShip],12
                jb     @Key6
                cmp    [ShipPower],20
                jb     @Key6
                or     [FireCount],0
                jnz    @Key6
                xor    si,si
@FireLoop:
                cmp    byte ptr [Memory+BlasterC+si],0FFh
                jnz    @FireSkip
                sub    [ShipPower],20
                mov    ax,[XShip]
                inc    ax
                mov    byte ptr [Memory+BlasterC+si],al
                mov    ax,[YShip]
                sub    ax,9
                mov    byte ptr [Memory+BlasterC+si+1],al
                mov    [FireCount],7
                jmp    short @Key6
@FireSkip:
                inc    si
                inc    si
                cmp    si,20
                jb     @FireLoop

@Key6:
                cmp    byte ptr [Memory+Keys+kENTER],1
                jnz    @Key7
                mov    [RechargeFlag],1
@Key7:

                call   ShiftComets
                call   ShiftBlaster
                call   ShiftFW
                call   MotionStars
                call   FoesAI

                cmp    [ShipLife],0
                jg     @JOver3
                call   GameOver
@JOver3:

                cmp    [ShipShield],100
                jb     @NoClearFlag
                mov    [RechargeFlag],0
@NoClearFlag:
                test   [RechargeFlag],1
                jz     @NoRecharge
                cmp    [ShipPower],2
                jb     @NoRechargeClear
                sub    [ShipPower],2
                inc    [ShipShield]
                jmp    short @NoRecharge
@NoRechargeClear:
                mov    [RechargeFlag],0
@NoRecharge:
                cmp    [ShipPower],100
                jge    @NoRestore
                inc    [ShipPower]

@NoRestore:
                cmp    [ShipLife],100
                jge    @NoGenerator
                cmp    [ShipShield],0
                jz     @PowerLife
                dec    [ShipShield]
                add    [ShipLife],1
                jmp    short @NoGenerator
@PowerLife:
                cmp    [ShipPower],5
                jl     @NoGenerator
                sub    [ShipPower],5
                inc    [ShipLife]
@NoGenerator:
                or     [FireCount],0
                jz     @NoFireCount
                dec    [FireCount]
@NoFireCount:
                cmp    [ShipLife],100
                jbe    @NoCorrection
                mov    [ShipLife],100
@NoCorrection:

                jmp    @MainLoop
@Exit:
                call   UninstallKeyboard

                mov    ax,4C00h
                int    21h

;*****************************************************************************
;*    㭪権  楤                                             *
;*****************************************************************************

; ****************************************************************************
; * WinTheGame 楤 - ⢨  砥 먣                    *
; *   楤  㦭 㬥                                           *
; *                                                                          *
; ****************************************************************************
WinTheGame proc near
                mov    cx,20
WGELoop:
                push   cx
                mov    bx,170
                call   rand
                add    ax,10
                push   ax
                mov    bx,170
                call   rand
                add    ax,10
                push   ax
                call   CreateExplosion
                add    sp,4
                pop    cx
                loop   WGELoop

                mov    cx,50
WGLoop:
                push   cx
                call   ShowExplosions
                call   WaitRetrace
                call   HideExplosions
                pop    cx
                loop   WGLoop

                push   offset [UWonLine]
                push   90 98
                call   PutSprite
                add    sp,6
WGWaitForAKey:
                test   byte ptr [Memory+Keys+kSPACE],1
                jnz    WGBreakKey
                jmp    short WGWaitForAKey
WGBreakKey:

                call   UninstallKeyboard
                mov    ax,4C00h
                int    21h

                ret
WinTheGame endp
; ****************************************************************************
; * IsEverybodyDead 㭪 - ஢  稥  ⨢         *
; *   頥 祭: al:0 , al:1               *
; *                                                                          *
; ****************************************************************************
IsEverybodyDead proc near
                xor    si,si
IEDLoop:
                cmp    byte ptr [Memory+FoeData+si],0FFh
                jnz    IEDReturn0
                add    si,7
                cmp    si,140
                jb     IEDLoop
                mov    al,1
                ret
IEDReturn0:
                xor    ax,ax
                ret
IsEverybodyDead endp
; ****************************************************************************
; * PrepareLevel 楤 - ⠭ ன ஢                  *
; *  楤  ॡ 㬥                                        *
; *                                                                          *
; ****************************************************************************
PrepareLevel proc near
                push   offset [Memory+CometsBuf]
                push   85 98 30 5
                call   GetSprite
                add    sp,10

                push   offset [Memory+LevelBuf]
                push   95 98 20 5
                call   GetSprite
                add    sp,10

                xor    ax,ax
                mov    al,[Level]
                push   ax
                push   offset [Memory+LevelBuf]
                push   96 98
                call   ShowNumbers
                add    sp,8

                push   offset [LevelLine]
                push   85 98
                call   PutSprite
                add    sp,6

PLWaitKey:
                test   byte ptr [Memory+Keys+kENTER],1
                jnz    PLBreakKey
                jmp    short PLWaitKey
PLBreakKey:

                push   offset [Memory+CometsBuf]
                push   85 98
                call   PutBlock
                add    sp,6

; ***    ࠣ ***

                xor    ax,ax
                mov    di,offset [LevelSetup]
                mov    al,[Level]
PLLoop:
                cmp    ax,0
                jz     PLExit
PLILoop:
                cmp    byte ptr [di+3],0FFh
                jz     PLINext
                add    di,4
                jmp    PLILoop
PLINext:
                add    di,4

                dec    ax
                jmp    short PLLoop
PLExit:
                xor    si,si
PLCrLoop:
                mov    ax,word ptr [di+1]
                mov    word ptr [Memory+FoeData+si],ax
                mov    byte ptr [Memory+FoeData+si+3],0
                mov    bx,75
                call   rand
                add    al,75
                mov    byte ptr [Memory+FoeData+si+2],al
                mov    al,byte ptr [di]
                mov    byte ptr [Memory+FoeData+si+4],al

                cmp    byte ptr [di+3],0FFh
                jz     PLCrBreak
                add    di,4
                add    si,7
                jmp    short PLCrLoop

PLCrBreak:


                ret
PrepareLevel endp
; ****************************************************************************
; * ShowShield 楤 - ⮡ࠦ ࣥ᪮                     *
; *   楤  ॡ 㬥⮢                                        *
; *                                                                          *
; ****************************************************************************
ShowShield proc near
                xor    si,si
SShLoop:
                mov    al,byte ptr [ShipPalData+si]
                mov    byte ptr [Memory+Palette],al
                call   GetColor
                mov    ax,si
                add    al,128
                mov    byte ptr [Memory+Palette],al
                mov    ah,byte ptr [Memory+Palette+1]
                xor    al,al
                call   IntCalc
                mov    byte ptr [Memory+Palette+1],al
                mov    ah,byte ptr [Memory+Palette+2]
                mov    al,63
                call   IntCalc
                mov    byte ptr [Memory+Palette+2],al
                mov    ah,byte ptr [Memory+Palette+3]
                mov    al,63
                call   IntCalc
                mov    byte ptr [Memory+Palette+3],al
                call   SetColor

                inc    si
                cmp    si,7
                jb     SShLoop
                ret

IntCalc:
                xor    dx,dx
                xor    bx,bx
                mov    bl,100

                or     al,al
                jz     ICZero

                sub    al,ah
                xchg   ah,cl
                xor    ah,ah
                mul    [ShipShield]
                div    bx
                add    al,cl
                ret
ICZero:
                mov    bh,100
                sub    bh,[ShipShield]
                mov    al,ah
                xor    ah,ah
                mul    bh
                xor    bh,bh
                div    bx
                ret

ShowShield endp
; ****************************************************************************
; * CheckBlasterHit 㭪 - ஢  㤠७ ꥪ  ஬    *
; *   [Sprite] [X] [Y]                                                       *
; *                                                                          *
; ****************************************************************************
CheckBlasterHit proc near
                push   bp
                mov    bp,sp

                xor    di,di
CBHLoop:
                cmp    byte ptr [Memory+BlasterC+di],0FFh
                jz     CBHNext

                push   offset [BlasterSprite]
                push   word ptr [bp+8]
                xor    ax,ax
                mov    al,byte ptr [Memory+BlasterC+di]
                push   ax
                mov    al,byte ptr [Memory+BlasterC+di+1]
                push   ax
                push   word ptr [bp+6]
                push   word ptr [bp+4]
                call   SpriteCollision
                add    sp,12

                or     al,al
                jnz    CBHReturn1

CBHNext:
                inc    di
                inc    di
                cmp    di,20
                jb     CBHLoop

                xor    ax,ax
                pop    bp
                ret
CBHReturn1:
                mov    al,1
                pop    bp
                ret
CheckBlasterHit endp
; ****************************************************************************
; * ShiftFW 楤 - ࠡ뢠 ⢨ ५ ࠣ               *
; *   楤  ॡ 㬥⮢                                        *
; *                                                                          *
; ****************************************************************************
ShiftFW proc near
                xor    si,si
SFLoop:
                cmp    byte ptr [Memory+FWData+si],0FFh
                jnz    SFCont
                jmp    SFNext
SFCont:
; *** ஢ઠ  㤠७   鸞 ***
                push   offset [FoeWeapons]
                xor    ax,ax
                mov    al,byte ptr [Memory+FWData+si]
                push   ax
                mov    al,byte ptr [Memory+FWData+si+1]
                push   ax
                call   CheckBlasterHit
                add    sp,6

                or     al,al
                jz     SFNoHit

                test   byte ptr [Memory+FWData+si+3],01000000b
                jz     SFLowPower
                test   byte ptr [Memory+FWData+si+3],10000000b
                jz     SFMidPower
                mov    al,byte ptr [Memory+BlasterC+di]
                push   ax
                mov    al,byte ptr [Memory+BlasterC+di+1]
                push   ax
                mov    byte ptr [Memory+BlasterC+di],0FFh
                jmp    short SFEndHit
SFMidPower:
                mov    al,byte ptr [Memory+FWData+si]
                push   ax
                mov    al,byte ptr [Memory+FWData+si+1]
                push   ax
                mov    byte ptr [Memory+BlasterC+di],0FFh
                mov    byte ptr [Memory+FWData+si],0FFh
                jmp    short SFEndHit
SFLowPower:
                mov    al,byte ptr [Memory+FWData+si]
                push   ax
                mov    al,byte ptr [Memory+FWData+si+1]
                push   ax
                mov    byte ptr [Memory+FWData+si],0FFh
SFEndHit:

                call   CreateExplosion
                add    sp,4

                jmp    SFNext
SFNoHit:
                cmp    byte ptr [Memory+FWData+si],0FFh
                jnz    SFOk2
                jmp    SFNext
SFOk2:

; *** ஢ઠ  㤠७ ࠡ  鸞 ***
                push   offset [ShipSprite]
                push   offset [FoeWeapons]
                push   XShip YShip
                xor    ax,ax
                mov    al,byte ptr [Memory+FWData+si]
                push   ax
                mov    al,byte ptr [Memory+FWData+si+1]
                push   ax
                xor    ax,ax
                call   SpriteCollision
                add    sp,12
                or     al,al
                jz     SFNoDamage
                push   XShip YShip
                call   CreateExplosion
                add    sp,4
                mov    al,byte ptr [Memory+FWData+si+2]
                sub    [ShipLife],al
                mov    byte ptr [Memory+FWData+si],0FFh
SFNoDamage:
                cmp    byte ptr [Memory+FWData+si],0FFh
                jnz    SFOk3
                jmp    SFNext
SFOk3:

                push   si
; *** 騩  ? ***
                test   byte ptr [Memory+FWData+si+3],00000001b
                jz     SFNotGuided
                mov    al,byte ptr [Memory+FWData+si+5]
                mov    ah,byte ptr [Memory+FWData+si+6]
                and    al,00001111b
                and    ah,00001111b
                xor    bx,bx
                mov    bl,byte ptr [Memory+FWData+si]
                cmp    bx,[XShip]
                jb     SFGXadd
                jz     SFGNoXadd
                sub    byte ptr [Memory+FWData+si],ah
                jmp    short SFGNoXadd
SFGXadd:
                add    byte ptr [Memory+FWData+si],ah
SFGNoXadd:
                mov    bl,byte ptr [Memory+FWData+si+1]
                cmp    bx,[YShip]
                jb     SFGYadd
                jz     SFGNoYadd
                sub    byte ptr [Memory+FWData+si+1],al
                jmp    short SFGNoYadd
SFGYadd:
                add    byte ptr [Memory+FWData+si+1],al
SFGNoYadd:
                jmp    SFChecks
SFNotGuided:
; *** 筮   Y ***
                mov    al,byte ptr [Memory+FWData+si+5]
                and    al,0Fh
                add    byte ptr [Memory+FWData+si+1],al

; *** ஢ઠ  砭 ***

                mov    al,byte ptr [Memory+FWData+si+3]
                test   al,00100000b
                jz     SFNoSwing

                mov    ah,al
                and    ah,00001110b
                and    al,11110001b

                test   al,00010000b
                jz     SFAddSwing
                sub    ah,2
                sub    byte ptr [Memory+FWData+si],2
                jmp    short SFNoAddSwing
SFAddSwing:
                add    ah,2
                add    byte ptr [Memory+FWData+si],2
SFNoAddSwing:
                or     al,ah
                shr    ah,1
                mov    bl,byte ptr [Memory+FWData+si+6]
                and    bl,00001111b
                cmp    ah,bl
                jb     SFNoXor
                xor    al,00010000b
SFNoXor:
                and    byte ptr [Memory+FWData+si+3],11000001b
                and    al,00111110b
                or     byte ptr [Memory+FWData+si+3],al
                jmp    short SFOk6
SFNoSwing:
                mov    al,byte ptr [Memory+FWData+si+6]
                and    al,00001111b
                test   al,00001000b
                jz     SFXadd
                and    al,00000111b
                sub    byte ptr [Memory+FWData+si],al
                jmp    short SFNoXadd
SFXadd:
                add    byte ptr [Memory+FWData+si],al
SFNoXadd:

SFOk6:

; ***  ஢ન ***
SFChecks:
                cmp    byte ptr [Memory+FWData+si+1],186
                jb     SFOk1
                mov    byte ptr [Memory+FWData+si],0FFh
SFOk1:
                cmp    byte ptr [Memory+FWData+si],3
                ja     SFOk4
                mov    byte ptr [Memory+FWData+si],0FFh
SFOk4:
                cmp    byte ptr [Memory+FWData+si],192
                jb     SFOk5
                mov    byte ptr [Memory+FWData+si],0FFh
SFOk5:
                pop    si
SFNext:
                add    si,7
                cmp    si,700
                jae    SFExit
                jmp    SFLoop
SFExit:
                ret
ShiftFW endp
; ****************************************************************************
; * FoesAI 楤 -  ⢥ ⥫ ࠣ               *
; *   楤  㦤  㬥                                    *
; *                                                                          *
; ****************************************************************************
FoesAI proc near
                xor    si,si
FALoop:
                push   si
                cmp    byte ptr [Memory+FoeData+si],0FFh
                jnz    FAContinue
                jmp    FANext
FAContinue:
; *** ஢ઠ  㤠७   ࠣ ***
                cmp    byte ptr [Memory+FoeData+si],15
                jbe    FANoHit
                push   offset [FoeSprites]
                xor    ax,ax
                mov    al,byte ptr [Memory+FoeData+si]
                push   ax
                mov    al,byte ptr [Memory+FoeData+si+1]
                push   ax
                call   CheckBlasterHit
                add    sp,6

                or     al,al
                jz     FANoHit
                xor    ax,ax
                mov    al,byte ptr [Memory+FoeData+si]
                push   ax
                mov    al,byte ptr [Memory+FoeData+si+1]
                push   ax
                call   CreateExplosion
                add    sp,4
                cmp    byte ptr [Memory+FoeData+si+2],10
                jae    FAIsLife
                mov    byte ptr [Memory+FoeData+si],0FFh
                xor    ax,ax
                mov    al,byte ptr [Memory+FoeData+si+4]
                mov    bx,5
                mul    bx
                add    ax,5
                add    [Score],ax
                jmp    FANext
FAIsLife:
                sub    byte ptr [Memory+FoeData+si+2],10
                mov    byte ptr [Memory+BlasterC+di],0FFh
FANoHit:

                mov    al,byte ptr [Memory+FoeData+si+5]
                cmp    al,0FFh
                jz     FAFindTarget
                cmp    al,byte ptr [Memory+FoeData+si]
                jz     FAxout
                ja     FAxp
                dec    byte ptr [Memory+FoeData+si]
                jmp    short FAxout
FAxp:
                inc    byte ptr [Memory+FoeData+si]
FAxout:
                mov    al,byte ptr [Memory+FoeData+si+6]
                cmp    al,byte ptr [Memory+FoeData+si+1]
                jz     FAeq
                ja     FAyp
                dec    byte ptr [Memory+FoeData+si+1]
                jmp    short FAyout
FAyp:
                inc    byte ptr [Memory+FoeData+si+1]
                jmp    short FAyout
FAeq:
                mov    al,byte ptr [Memory+FoeData+si+5]
                cmp    al,byte ptr [Memory+FoeData+si]
                jnz    FAyout
                mov    byte ptr [Memory+FoeData+si+5],0FFh
FAyout:
                cmp    byte ptr [Memory+FoeData+si+3],0
                jz     FAfire
                dec    byte ptr [Memory+FoeData+si+3]
                jmp    short FAfout
FAfire:
                mov    bx,1000
                call   rand
                cmp    ax,10
                ja     FAfout
                xor    ax,ax
                mov    al,byte ptr [Memory+FoeData+si+4]
                call   IntCreateFire
                mov    byte ptr [Memory+FoeData+si+3],7
FAfout:
                jmp    short FANext
FAFindTarget:

                mov    bx,193
                call   rand
                mov    byte ptr [Memory+FoeData+si+5],al
                mov    bx,100
                call   rand
                mov    byte ptr [Memory+FoeData+si+6],al

FANext:
                pop    si
                add    si,7
                cmp    si,140
                jae    FAExit
                jmp    FALoop
FAExit:
                ret
; *** Sub-楤 ***

IntCreateFire:
                mov    di,offset [FoeWData]
IntCFLoop:
                cmp    ax,0
                jz     IntCFExit
IntCFILoop:
                cmp    byte ptr [di+5],0FFh
                jz     IntCFINext
                add    di,6
                jmp    IntCFILoop
IntCFINext:
                add    di,6

                dec    ax
                jmp    short IntCFLoop
IntCFExit:
                call   CreateFire
                cmp    byte ptr [di+5],0FFh
                jz     IntCFCNext
                add    di,6
                jmp    short IntCFExit
IntCFCNext:

                ret
FoesAI endp
; ****************************************************************************
; * CreateFire 楤 - ᮧ ५ ࠣ                             *
; *   । 맮 ᫥ ⠭ si - 稪 ࠣ, di - 㪠⥫   *
; *      ५                                                   *
; ****************************************************************************
CreateFire proc near
                xor    bx,bx
CFLoop:
                cmp    byte ptr [Memory+FWData+bx],0FFh
                jnz    CFNext
                mov    al,byte ptr [Memory+FoeData+si]
                mov    ah,byte ptr [di+4]
                shr    ah,4
                test   ah,00001000b
                jz     CFPAdd
                and    ah,00000111b
                sub    al,ah
                jmp    short CFPNoAdd
CFPAdd:
                add    al,ah
CFPNoAdd:
                mov    byte ptr [Memory+FWData+bx],al

                mov    al,byte ptr [Memory+FoeData+si+1]
                mov    ah,byte ptr [di+3]
                shr    ah,4
                add    al,ah
                mov    byte ptr [Memory+FWData+bx+1],al
                mov    al,byte ptr [di]
                mov    byte ptr [Memory+FWData+bx+2],al
                mov    al,byte ptr [di+1]
                mov    byte ptr [Memory+FWData+bx+3],al
                mov    al,byte ptr [di+2]
                mov    byte ptr [Memory+FWData+bx+4],al
                mov    al,byte ptr [di+3]
                mov    byte ptr [Memory+FWData+bx+5],al
                mov    al,byte ptr [di+4]
                mov    byte ptr [Memory+FWData+bx+6],al
                jmp    short CFExit
CFNext:
                add    bx,7
                cmp    bx,700
                jb     CFLoop
CFExit:
                ret
CreateFire endp
; ****************************************************************************
; * ShowNumbers 楤 - ⮡ࠦ ᫠  ࠭                       *
; *   [Number] [Buffer] [X] [Y]                                              *
; *                                                                          *
; ****************************************************************************
ShowNumbers proc near
                push   bp
                mov    bp,sp

                push   word ptr [bp+8]
                push   word ptr [bp+6]
                push   word ptr [bp+4]
                call   PutBlock
                add    sp,6

                push   word ptr [bp+8]
                push   word ptr [bp+6]
                push   word ptr [bp+4]
                push   20 5
                call   GetSprite
                add    sp,10

                mov    ax,[bp+10]
                mov    word ptr [Memory+Cells],ax

                xor    cx,cx
                mov    byte ptr [Memory+Cells+3],0
SNLoop:

                push   cx
                mov    ax,10000
                xor    dx,dx
                mov    bx,10
                jmp    short SNCmp
SNDivLoop:
                div    bx
                xor    dx,dx
                dec    cx
SNCmp:
                or     cx,cx
                jnz    SNDivLoop
                pop    cx

                xchg   ax,bx
                mov    ax,word ptr [Memory+Cells]
                div    bx
                mov    word ptr [Memory+Cells],dx

                xor    dx,dx
                mov    bx,17
                mul    bx

                mov    bx,ax

                mov    ax,4
                mul    cx

                add    ax,[bp+6]

                or     bx,bx
                jnz    SNShow
                cmp    cl,4
                jae    SNShow
                cmp    byte ptr [Memory+Cells+3],0
                jz     SNNext
SNShow:
                mov    byte ptr [Memory+Cells+3],1
                push   cx
                mov    dx,offset [NumbersSprite]
                add    dx,bx
                push   dx
                push   ax
                push   word ptr [bp+4]
                call   PutSprite
                add    sp,6
                pop    cx

SNNext:
                inc    cx
                cmp    cx,5
                jb     SNLoop

                pop    bp
                ret
ShowNumbers endp
; ****************************************************************************
; * CreateExplosion 楤 - ᮧ                                 *
; *   [Xexplosion] [Yexplosion]                                              *
; *                                                                          *
; ****************************************************************************
CreateExplosion proc near
                push   bp
                mov    bp,sp

                cmp    word ptr [bp+6],4
                jb     CEBreak
                cmp    word ptr [bp+6],188
                ja     CEBreak
                cmp    word ptr [bp+4],4
                jb     CEBreak
                cmp    word ptr [bp+4],188
                ja     CEBreak

                xor    bx,bx
CELoop:
                cmp    byte ptr [Memory+ExpData+bx],0FFh
                jnz    CENext
                mov    ax,[bp+6]
                mov    byte ptr [Memory+ExpData+bx],al
                mov    ax,[bp+4]
                mov    byte ptr [Memory+ExpData+bx+1],al
                mov    byte ptr [Memory+ExpData+bx+2],1
                jmp    short CEBreak
CENext:
                add    bx,3
                cmp    bx,60
                jb     CELoop
CEBreak:
                pop    bp
                ret
CreateExplosion endp
; ****************************************************************************
; * GameOver 楤 - 뢠  砥 ࠦ                       *
; *    楤  㦤  㬥                                   *
; *                                                                          *
; ****************************************************************************
GameOver proc near
                push   XShip YShip
                call   CreateExplosion
                add    sp,4

                mov    cx,50
GOLoop:
                push   cx
                call   ShowExplosions
                call   WaitRetrace
                call   HideExplosions
                pop    cx
                loop   GOLoop

                push   offset [GameOverLine]
                push   90 98
                call   PutSprite
                add    sp,6
GOWaitForAKey:
                test   byte ptr [Memory+Keys+kSPACE],1
                jnz    GOBreakKey
                jmp    short GOWaitForAKey
GOBreakKey:

                call   UninstallKeyboard
                mov    ax,4C00h
                int    21h

                ret
GameOver endp
; ****************************************************************************
; * ShowExplosions 楤 - ⮡ࠦ                    *
; *    楤  ॡ 㬥⮢                                       *
; *                                                                          *
; ****************************************************************************
ShowExplosions proc near
                xor    si,si
SELoop:
                cmp    byte ptr [Memory+ExpData+si],0FFh
                jnz    SEShow
                jmp    SENext
SEShow:
; ***  䮭 뢠 ***
                push   si
                xor    dx,dx
                mov    ax,si
                mov    bx,3
                div    bx
                xor    dx,dx
                mov    bx,227
                mul    bx
                add    ax,offset [Memory]
                add    ax,ExpBufs
                push   ax
                xor    ax,ax
                mov    al,byte ptr [Memory+ExpData+si]
                sub    al,4
                push   ax
                mov    al,byte ptr [Memory+ExpData+si+1]
                sub    al,4
                push   ax
                push   15 15
                call   GetSprite
                add    sp,10
                pop    si

; *** ᮢ   䠧 ***

                mov    al,byte ptr [Memory+ExpData+si+2]
                and    al,00001111b
                mov    byte ptr [Memory+Cells+2],al
                mov    ah,byte ptr [Memory+ExpData+si]
                sub    ah,al
                mov    byte ptr [Memory+Cells],ah
                mov    ah,byte ptr [Memory+ExpData+si+1]
                sub    ah,al
                mov    byte ptr [Memory+Cells+1],ah

                mov    cx,10
SEILoop:
                push   cx si

                push   offset [BlowupSprite]

                xor    bx,bx
                mov    bl,byte ptr [Memory+Cells+2]
                shl    bx,1
                call   rand
                mov    dx,ax
                add    dl,byte ptr [Memory+Cells]
                push   dx

                xor    bx,bx
                mov    bl,byte ptr [Memory+Cells+2]
                shl    bx,1
                call   rand
                mov    dx,ax
                add    dl,byte ptr [Memory+Cells+1]
                push   dx

                call   PutSprite
                add    sp,6

                pop    si cx
                loop   SEILoop

                mov    al,byte ptr [Memory+ExpData+si+2]
                mov    ah,al
                and    al,00001111b
                shr    ah,4

                inc    ah
                cmp    ah,5
                jb     SENoAnim
                xor    ah,ah
                inc    al
                cmp    al,4
                jb     SENoAnim
                mov    al,0FFh
SENoAnim:
                shl    ah,4
                or     al,ah
                mov    byte ptr [Memory+ExpData+si+2],al
SENext:
                add    si,3
                cmp    si,60
                jae    SEExit
                jmp    SELoop
SEExit:
                ret
ShowExplosions endp
; ****************************************************************************
; * HideExplosions 楤 - 㡨ࠥ   ࠭           *
; *    楤  ॡ 㬥⮢                                       *
; *                                                                          *
; ****************************************************************************
HideExplosions proc near
                mov    si,57
HELoop:
                cmp    byte ptr [Memory+ExpData+si],0FFh
                jz     HENext

                push   si
                xor    dx,dx
                mov    ax,si
                mov    bx,3
                div    bx
                xor    dx,dx
                mov    bx,227
                mul    bx
                add    ax,offset [Memory]
                add    ax,ExpBufs
                push   ax
                xor    ax,ax
                mov    al,byte ptr [Memory+ExpData+si]
                sub    al,4
                push   ax
                mov    al,byte ptr [Memory+ExpData+si+1]
                sub    al,4
                push   ax
                call   PutBlock
                add    sp,6
                pop    si

                cmp    byte ptr [Memory+ExpData+si+2],0FFh
                jnz    HENext
                mov    byte ptr [Memory+ExpData+si],0FFh
HENext:
                sub    si,3
                cmp    si,0
                jge    HELoop

                ret
HideExplosions endp

; ****************************************************************************
; * ShowStars 楤 - ⮡ࠦ ஢ 窨                 *
; *    楤  ॡ 㬥⮢                                       *
; *                                                                          *
; ****************************************************************************
ShowStars proc near
                xor    si,si
@SStLoop:
                xor    bx,bx
                xor    dx,dx
                mov    bl,byte ptr [Memory+StarsData+si+2]
                mov    dl,byte ptr [Memory+StarsData+si+3]
                call   CalcDI
                mov    al,byte ptr es:[di]
                mov    byte ptr [Memory+StarsData+si+1],al
                mov    al,byte ptr [Memory+StarsData+si]
                shr    al,2
                stosb
                add    si,4
                cmp    si,StarsNumX4
                jb     @SStLoop
                ret
ShowStars endp
; ****************************************************************************
; * HideStars 楤 - 㡨ࠥ   窨                       *
; *    楤  ॡ 㬥⮢                                       *
; *                                                                          *
; ****************************************************************************
HideStars proc near
                mov    si,StarsNumX4
                sub    si,4
@HStLoop:
                xor    bx,bx
                xor    dx,dx
                mov    bl,byte ptr [Memory+StarsData+si+2]
                mov    dl,byte ptr [Memory+StarsData+si+3]
                call   CalcDI
                mov    al,byte ptr [Memory+StarsData+si+1]
                stosb
                sub    si,4
                cmp    si,0
                jge    @HStLoop
                ret
HideStars endp

; ****************************************************************************
; * MotionStars 楤 -   ᮧ 窨                      *
; *    楤  ॡ 㬥⮢                                       *
; *                                                                          *
; ****************************************************************************
MotionStars proc near
                xor    si,si
@MStLoop:
                xor    dx,dx
                mov    dl,byte ptr [Memory+StarsData+si+3]
                mov    al,byte ptr [Memory+StarsData+si]
                and    al,00000011b
                inc    dl
                add    dl,al
                mov    byte ptr [Memory+StarsData+si+3],dl

                cmp    dl,198
                jbe    @MStContinue
                mov    bx,199
                call   rand
                mov    byte ptr [Memory+StarsData+si+2],al
                mov    byte ptr [Memory+StarsData+si+3],0
                mov    bx,16
                call   rand
                xor    dx,dx
                add    al,16
                mov    dh,al
                shl    dh,2
                push   dx
                mov    bx,4
                call   rand
                pop    dx
                or     dh,al
                mov    byte ptr [Memory+StarsData+si],dh
                mov    byte ptr [Memory+StarsData+si+1],dl

@MStContinue:
                add    si,4
                cmp    si,StarsNumX4
                jb     @MStLoop

                ret
MotionStars endp
; ****************************************************************************
; * ShiftBlaster 楤 - ᫥⥫쭮  ࠧ         *
; *    楤  ॡ 㬥⮢                                       *
; *                                                                          *
; ****************************************************************************
ShiftBlaster proc near
                xor    si,si
ShBLoop:
                push   si
                cmp    byte ptr [Memory+BlasterC+si],0FFh
                jz     ShBNext
                cmp    byte ptr [Memory+BlasterC+si+1],4
                ja     ShBMove
                mov    byte ptr [Memory+BlasterC+si],0FFh
                jmp    short ShBNext
ShBMove:
                sub    byte ptr [Memory+BlasterC+si+1],3
ShBNext:
                pop    si
                inc    si
                inc    si
                cmp    si,20
                jb     ShBLoop

                ret
ShiftBlaster endp
; ****************************************************************************
; * SpriteCollision 㭪 - ஢ ࠩ  ४뢠              *
; *   [Sprite1] [Sprite2] [X1] [Y1] [X2] [Y2]                                *
; *                                                                          *
; ****************************************************************************
SpriteCollision proc near
                push   bp
                mov    bp,sp

                xor    ax,ax
                mov    bx,[bp+14]
                mov    al,byte ptr [bx]
                add    ax,[bp+10]
                cmp    ax,[bp+6]
                ja     SCl1
                jmp    SClReturn0
SCl1:
                xor    ax,ax
                mov    al,byte ptr [bx+1]
                add    ax,[bp+8]
                cmp    ax,[bp+4]
                ja     SCl2
                jmp    SClReturn0
SCl2:
                xor    ax,ax
                mov    bx,[bp+12]
                mov    al,byte ptr [bx]
                add    ax,[bp+6]
                cmp    ax,[bp+10]
                ja     SCl3
                jmp    SClReturn0
SCl3:
                xor    ax,ax
                mov    al,byte ptr [bx+1]
                add    ax,[bp+4]
                cmp    ax,[bp+8]
                ja     SCl4
                jmp    SClReturn0
SCl4:

                pop    bp
                mov    al,1
                ret
SClReturn0:
                pop    bp
                xor    al,al
                ret
SpriteCollision endp
; ****************************************************************************
; * ShowIndicators 楤 - ⮡ࠦ ﭨ ࠡ                  *
; *    楤  ॡ 㬥⮢                                       *
; *                                                                          *
; ****************************************************************************
ShowIndicators proc near
                push   offset [Memory+LifeBuf]
                push   213 85
                call   PutBlock
                add    sp,6

                push   offset [Memory+PowerBuf]
                push   247 85
                call   PutBlock
                add    sp,6

                push   Score
                push   offset [Memory+ScoreBuf]
                push   230 20
                call   ShowNumbers
                add    sp,8

                xor    ax,ax
                int    1Ah
                sub    dx,word ptr [Timer]
                sbb    cx,word ptr [Timer+2]

                push   dx
                push   offset [Memory+TimeBuf]
                push   230 30
                call   ShowNumbers
                add    sp,8

                cmp    [ShipLife],0
                jle    SINext
                mov    bx,213
                mov    cx,185
                sub    cl,[ShipLife]
                mov    ax,42
                call   SILineproc
                inc    bx
                mov    al,32
                call   SILineproc
                inc    bx
                mov    al,42
                call   SILineproc
SINext:

                mov    bx,247
                mov    cx,185
                sub    cl,[ShipPower]
                mov    ax,74
                call   SILineproc
                inc    bx
                mov    al,64
                call   SILineproc
                inc    bx
                mov    al,74
                call   SILineproc

                jmp    short SIEnd
SILineproc:
                push   bx cx
                push   bx 185 bx cx ax
                call   Line
                add    sp,10
                pop    cx bx
                xor    ax,ax
                ret
SIEnd:

                ret
ShowIndicators endp
; ****************************************************************************
; * ShiftComets 楤 - ᫥⥫쭮   ᮧ          *
; *    楤  ॡ 㬥⮢                                       *
; *                                                                          *
; ****************************************************************************
ShiftComets proc near
                xor    si,si
ShCLoop:
                push   si
                cmp    byte ptr [Memory+CometsC+si],0FFh
                jnz    ShCNoCreate
                jmp    ShCCreate
ShCNoCreate:
                cmp    byte ptr [Memory+CometsC+si+1],185
                jae    ShCJ1
                jmp    ShCMove
ShCJ1:
                mov    byte ptr [Memory+CometsC+si],0FFh
                jmp    ShCNext
ShCMove:
; *** ஢ઠ  㤠७   鸞  ***
                cmp    byte ptr [Memory+CometsC+si+1],16
                jbe    ShCBNext

                push   offset [CometSprite]
                xor    ax,ax
                mov    al,byte ptr [Memory+CometsC+si]
                push   ax
                mov    al,byte ptr [Memory+CometsC+si+1]
                push   ax

                call   CheckBlasterHit
                add    sp,6

                or     al,al
                jz     ShCBNext

                xor    ax,ax
                mov    al,byte ptr [Memory+CometsC+si]
                push   ax
                mov    al,byte ptr [Memory+CometsC+si+1]
                push   ax
                call   CreateExplosion
                add    sp,4

                mov    byte ptr [Memory+CometsC+si],0FFh
                mov    byte ptr [Memory+BlasterC+di],0FFh
                inc    [Score]

ShCBNext:
;                inc    di
;                inc    di
;                cmp    di,20
;                jb     ShCBLoop
ShCShip:
; *** ஢ઠ  㤠७   ᬨ᪮ ࠡ ***

                push   offset [ShipSprite]
                push   offset [CometSprite]
                push   XShip YShip
                xor    ax,ax
                mov    al,byte ptr [Memory+CometsC+si]
                push   ax
                mov    al,byte ptr [Memory+CometsC+si+1]
                push   ax
                call   SpriteCollision
                add    sp,12
                or     al,al
                jz     ShCNoDamage
                mov    bx,10
                call   rand
                sub    [ShipLife],al
ShCNoDamage:
                add    byte ptr [Memory+CometsC+si+1],3
                jmp    short ShCNext
ShCCreate:
                mov    bx,400
                call   rand
                cmp    ax,4
                ja     ShCNext
                mov    bx,194
                call   rand
                mov    byte ptr [Memory+CometsC+si],al
                mov    byte ptr [Memory+CometsC+si+1],0
ShCNext:
                pop    si
                inc    si
                inc    si
                cmp    si,20
                jae    ShCExit
                jmp    ShCLoop
ShCExit:

                ret
ShiftComets endp
; ****************************************************************************
; * ShowLinear 楤 - ᫥⥫쭮         *
; *    ᨢ ArrayC ࠩ⮬ ElSprite  䮭 Backgrnd                     *
; *[ElNumX] [ArrayC] [offset ElSprite] [Backgrnd] [SprSize] [ElSize] [SprAdd]*
; ****************************************************************************
ShowLinear proc near
                push   bp
                mov    bp,sp

                xor    si,si
SLLoop:
                push   si
                mov    bx,offset [Memory]
                add    bx,[bp+14]
                add    bx,si
                cmp    byte ptr [bx],0FFh
                jz     SLSkip

                xor    ax,ax
                cmp    word ptr [bp+4],0
                jz     SLASkip

                xor    bx,bx
                mov    ax,[bp+8]
                mov    di,offset [Memory]
                add    di,word ptr [bp+14]
                add    di,si
                add    di,[bp+4]
                mov    bl,byte ptr [di]
                mul    bx
SLASkip:
                add    ax,[bp+12]
                push   ax

                xor    dx,dx
                mov    ax,si
                mov    bx,[bp+6]
                div    bx
                xchg   ax,bx
                mov    ax,[bp+8]
                mul    bx
                add    ax,offset [Memory]
                add    ax,[bp+10]
                push   ax

                mov    bx,offset [Memory]
                add    bx,[bp+14]
                add    bx,si

                xor    ax,ax
                mov    al,byte ptr [bx]
                push   ax
                mov    al,byte ptr [bx+1]
                push   ax

                call   SpriteGAP
                add    sp,8
SLSkip:
                pop    si
                add    si,[bp+6]
                cmp    si,[bp+16]
                jb     SLLoop

                pop    bp
                ret
ShowLinear endp
; ****************************************************************************
; * HideLinear 楤 - ᫥⥫쭮 㤠       *
; *    ᨢ ArrayC   䮭 Backgrnd                                *
; *         [ElNumX] [ArrayC] [Backgrnd] [SprSize] [ElSize]                  *
; ****************************************************************************
HideLinear proc near
                push   bp
                mov    bp,sp

                mov    si,[bp+12]
                sub    si,[bp+4]
HLLoop:
                push   si
                mov    bx,offset [Memory]
                add    bx,[bp+10]
                add    bx,si
                cmp    byte ptr [bx],0FFh
                jz     HLSkip

                xor    dx,dx
                mov    ax,si
                mov    bx,[bp+4]
                div    bx
                xchg   ax,bx
                mov    ax,[bp+6]
                mul    bx
                add    ax,offset [Memory]
                add    ax,[bp+8]
                push   ax

                mov    bx,offset [Memory]
                add    bx,[bp+10]
                add    bx,si

                xor    ax,ax
                mov    al,byte ptr [bx]
                push   ax
                mov    al,byte ptr [bx+1]
                push   ax

                call   PutBlock
                add    sp,6
HLSkip:
                pop    si
                sub    si,[bp+4]
                cmp    si,0
                jge    HLLoop

                pop    bp
                ret
HideLinear endp

; ****************************************************************************
; * SetPalettes 楤 - ⠭ 砫                   *
; *    楤  ॡ 㬥⮢                                       *
; *                                                                          *
; ****************************************************************************
SetPalettes proc near
; ** ᭮-ୠ  **
                mov    cx,32
                mov    word ptr [Memory+Palette],32
                mov    word ptr [Memory+Palette+1],62
                mov    word ptr [Memory+Palette+2],0
                mov    word ptr [Memory+Palette+3],0
SPLoop1:
                call   SetColor
                inc    word ptr [Memory+Palette]
                sub    word ptr [Memory+Palette+1],2
                loop   SPLoop1

; ** -ୠ  **
                mov    cx,32
                mov    word ptr [Memory+Palette],64
                mov    word ptr [Memory+Palette+1],0
                mov    word ptr [Memory+Palette+2],0
                mov    word ptr [Memory+Palette+3],62
SPLoop2:
                call   SetColor
                inc    word ptr [Memory+Palette]
                sub    word ptr [Memory+Palette+3],2
                loop   SPLoop2

; ** -᭠  **
                mov    cx,32
                mov    word ptr [Memory+Palette],96
                mov    word ptr [Memory+Palette+1],62
                mov    word ptr [Memory+Palette+2],48
                mov    word ptr [Memory+Palette+3],0
SPLoop3:
                call   SetColor
                inc    word ptr [Memory+Palette]
                dec    word ptr [Memory+Palette+2]
                loop   SPLoop3

; ** 㡠  **
                mov    cx,7
                mov    word ptr [Memory+Palette],128
                mov    word ptr [Memory+Palette+1],0
                mov    word ptr [Memory+Palette+2],62
                mov    word ptr [Memory+Palette+3],62
SPLoop4:
                call   SetColor
                inc    word ptr [Memory+Palette]
                loop   SPLoop4


                ret
SetPalettes endp
; ****************************************************************************
; * DrawBackground 楤 -     䮭                  *
; *    楤  ॡ 㬥⮢                                       *
; *                                                                          *
; ****************************************************************************
DrawBackground proc near
                mov    cx,50
DBLoop:
                push   cx
                mov    bx,199
                call   rand
                push   ax
                mov    bx,199
                call   rand
                push   ax
                mov    bx,16
                call   rand
                add    ax,16
                pop    dx bx
                call   CalcDI
                stosb

                pop    cx
                loop   DBLoop

; *** ⠭ 砫 祭 CometsC  BlasterC ***

                push   es
                push   ds
                pop    es

                mov    di,offset [Memory+ExpData]
                mov    cx,30
                mov    ax,0FFFFh
                rep    stosw

                mov    di,offset [Memory+CometsC]
                mov    cx,10
                rep    stosw

                mov    di,offset [Memory+BlasterC]
                mov    cx,10
                rep    stosw

                mov    di,offset [Memory+FoeData]
                mov    cx,70
                rep    stosw

                mov    di,offset [Memory+FWData]
                mov    cx,350
                rep    stosw

                mov    di,offset [Memory+Keys]
                mov    cx,256
                xor    ax,ax
                rep    stosb

                pop    es
; *** ᮢ  ***
                xor    dx,dx
DBMetalY:
                mov    cx,199
DBMetalX:
                push   dx cx

                push   offset [MetalBlock]
                push   cx dx
                call   PutSprite
                add    sp,6

                pop    cx dx
                add    cx,6
                cmp    cx,319
                jb     DBMetalX

                add    dx,6
                cmp    dx,199
                jb     DBMetalY

                push   offset [LifeIndicator]
                push   209 190
                call   PutSprite
                add    sp,6

                push   offset [PowerIndicator]
                push   239 190
                call   PutSprite
                add    sp,6

                push   offset [ShieldIndicator]
                push   277 120
                call   PutSprite
                add    sp,6

                push   offset [ScoreLine]
                push   205 20
                call   PutSprite
                add    sp,6

                push   offset [TimeLine]
                push   205 30
                call   PutSprite
                add    sp,6

                push   offset [Memory+LifeBuf]
                push   213 85 3 100
                call   GetSprite
                add    sp,10

                push   offset [Memory+ScoreBuf]
                push   230 20 20 5
                call   GetSprite
                add    sp,10

                push   offset [Memory+TimeBuf]
                push   230 30 20 5
                call   GetSprite
                add    sp,10

                push   offset [Memory+PowerBuf]
                push   247 85 3 100
                call   GetSprite
                add    sp,10

;                call   ShowIndicators
; *** 樠 祪 ***
                xor    si,si
DSLoop:
                mov    bx,16
                call   rand
                add    al,16
                xor    dx,dx
                xchg   dh,al
                shl    dh,2
                push   dx
                mov    bx,4
                call   rand
                pop    dx
                or     dh,al
                mov    byte ptr [Memory+StarsData+si],dh
                mov    byte ptr [Memory+StarsData+si+1],dl
                mov    bx,199
                call   rand
                mov    dh,al
                push   dx
                mov    bx,199
                call   rand
                pop    dx
                mov    dl,al
                mov    word ptr [Memory+StarsData+si+2],dx

                add    si,4
                cmp    si,StarsNumX4
                jb     DSLoop

; *** ᮢ  ***

                mov    bx,280
                mov    dx,100
                call   CalcDI

                xor    cx,cx
DBsLoopY:
                xor    cl,cl
                push   di
DBsLoopX:
                push   di
                xor    ax,ax
                mov    al,ch
                mov    bl,7
                mul    bl
                add    al,cl
                xchg   bx,ax

                mov    al,byte ptr [ShipSprite+bx+2]
                or     al,al
                jz     DBsNoPut
                call   FindColor
                stosb
                stosb
                add    di,318
                stosb
                stosb
DBsNoPut:
                pop    di
                add    di,2
                inc    cl
                cmp    cl,7
                jb     DBsLoopX

                pop    di
                add    di,640
                inc    ch
                cmp    ch,9
                jb     DBsLoopY


                ret
DrawBackground endp
; ****************************************************************************
; * FindColor 㭪 -  ᮮ⢥騩 梥  al                      *
; *  ax                                                                      *
; *                                                                          *
; ****************************************************************************
FindColor proc near
                xor    bx,bx
FCLoop:
                cmp    byte ptr [ShipPalData+bx],al
                jz     FCExit
                inc    bx
                jmp    short FCLoop
FCExit:
                mov    al,bl
                add    al,128

                ret
FindColor endp
; ****************************************************************************
; * PutSprite 楤 - ⠢ ࠦ  ࠭, ᯮ:         *
; *    [offset] X Y                                                          *
; *                                                                          *
; ****************************************************************************
PutSprite proc near
                push   bp
                mov    bp,sp

                mov    si,[bp+8]
                add    si,2
                mov    bx,[bp+6]
                mov    dx,[bp+4]
                call   CalcDI
                mov    bx,[bp+8]
                mov    dl,byte ptr [bx+1]
PSLoopy:
                xor    cx,cx
                mov    cl,byte ptr [bx]
                push   di
PSLoopx:
                inc    di
                lodsb
                or     al,al
                jz     PSNot
                dec    di
                stosb
PSNot:
                loop   PSLoopx
                pop    di
                add    di,320
                dec    dl
                jnz    PSLoopy

                pop    bp
                ret
PutSprite endp
; ****************************************************************************
; * GetSprite 楤 - ࠥ ࠦ  ࠭, ᯮ:          *
; *    [offset] X Y Width Heigth                                                         *
; *                                                                          *
; ****************************************************************************
GetSprite proc near
                push   bp
                mov    bp,sp

                mov    si,[bp+12]
                mov    ax,[bp+6]
                mov    byte ptr [si],al
                mov    ax,[bp+4]
                mov    byte ptr [si+1],al
                add    si,2

                mov    bx,[bp+10]
                mov    dx,[bp+8]
                call   CalcDI
                mov    dx,[bp+4]
GSLoopy:
                mov    cx,[bp+6]
                push   di
GSLoopx:
                mov    al,byte ptr es:[di]
                mov    byte ptr [si],al
                inc    di
                inc    si
                loop   GSLoopx
                pop    di
                add    di,320
                dec    dx
                jnz    GSLoopy

                pop    bp
                ret
GetSprite endp
; ****************************************************************************
; *  SpriteGAP 楤 ᯮ  饭 ⢨ Get-And-Put     *
; *  [Sprite] [Background] X Y                                               *
; *                                                                          *
; ****************************************************************************
SpriteGAP proc near
                push   bp
                mov    bp,sp
                push   word ptr [bp+8]
                push   word ptr [bp+6]
                push   word ptr [bp+4]
                xor    ax,ax
                mov    bx,[bp+10]
                mov    al,byte ptr [bx]
                push   ax
                mov    al,byte ptr [bx+1]
                push   ax
                call   GetSprite
                add    sp,10
                push   word ptr [bp+10]
                push   word ptr [bp+6]
                push   word ptr [bp+4]
                call   PutSprite
                add    sp,6
                pop    bp
                ret
SpriteGAP endp
; ****************************************************************************
; * PutBlock 楤 - 訢  ࠭ ࠦ, ᯮ: *
; *    [offset] X Y                                                          *
; *                                                                          *
; ****************************************************************************
PutBlock proc near
                push   bp
                mov    bp,sp

                mov    si,[bp+8]
                add    si,2
                mov    bx,[bp+6]
                mov    dx,[bp+4]
                call   CalcDI
                mov    bx,[bp+8]
                mov    dl,byte ptr [bx+1]
PBLoopY:
                push   di
                xor    cx,cx
                mov    cl,byte ptr [bx]
                rep    movsb
                pop    di
                add    di,320
                dec    dl
                jnz    PBLoopY

                pop    bp
                ret
PutBlock endp
; ****************************************************************************
; *                                                                          *
; *  CalcDI 㭪:                             *
; *                                                                          *
; ****************************************************************************
CalcDI proc near
                mov    di,bx
                mov    bx,dx
                mov    dh,dl
                xor    dl,dl
                shl    bx,6
                add    dx,bx
                add    di,dx
                ret
CalcDI endp
; ****************************************************************************
; *                                                                          *
; *  rand 㭪:  砩 ᫮   0-bx               *
; *                                                                          *
; ****************************************************************************
rand proc near
                push   bx
                mov    dx,word ptr [Memory+RandCell1]
                mov    ax,word ptr [Memory+RandCell2]
                mov    cx,0015Ah
                mov    bx,04E35h

                call   randplus

                add    ax,00001h
                adc    dx,000h
                mov    word ptr [Memory+RandCell1],dx
                mov    word ptr [Memory+RandCell2],ax
                xor    dx,dx
                mov    ax,word ptr [Memory+RandCell2]
                and    ax,07FFFh
                pop    bx
                div    bx
                xchg   ax,dx
                ret
rand endp
; ****************************************************************************
; *                                                                          *
; *  randplus 㭪: 㦭  㭪樨 rand                                *
; *                                                                          *
; ****************************************************************************
randplus proc near
                push   si
                xchg   si,ax
                xchg   dx,ax
                test   ax,ax
                je     RPJ1
                mul    bx
RPJ1:
                xchg   cx,ax
                test   ax,ax
                je     RPJ2
                mul    si
                add    cx,ax
RPJ2:
                xchg   si,ax
                mul    bx
                add    dx,cx
                pop    si
                ret
randplus endp
; ****************************************************************************
; *                                                                          *
; *  WaitRetrace 楤:  ⮢                          *
; *                                                                          *
; ****************************************************************************
WaitRetrace proc
                mov    dx,03DAh;
WR1:
                in     al,dx
                and    al,08h
                jnz    WR1

WR2:
                in     al,dx
                and    al,08h
                jz     WR2

                ret
WaitRetrace endp
; ****************************************************************************
; *                                                                          *
; *  GetColor - 砥 梥, ᯮ  Palette                    *
; *                                                                          *
; ****************************************************************************
GetColor proc
                mov    dx,03C7h
                mov    al,byte ptr [Memory+Palette]
                out    dx,al
                inc    dx
                inc    dx
                in     al,dx
                mov    byte ptr [Memory+Palette+1],al
                in     al,dx
                mov    byte ptr [Memory+Palette+2],al
                in     al,dx
                mov    byte ptr [Memory+Palette+3],al
                ret
GetColor endp
; ****************************************************************************
; *                                                                          *
; *  SetColor - ⠭ 梥, ᯮ  Palette              *
; *                                                                          *
; ****************************************************************************
SetColor proc
                mov    dx,03C8h
                mov    al,byte ptr [Memory+Palette]
                out    dx,al
                inc    dx
                mov    al,byte ptr [Memory+Palette+1]
                out    dx,al
                mov    al,byte ptr [Memory+Palette+2]
                out    dx,al
                mov    al,byte ptr [Memory+Palette+3]
                out    dx,al
                ret
SetColor endp
; ****************************************************************************
; *  InstallKeyboard 楤 - ⠭           *
; *  뢠 09h  ணࠬ ⠩  1Ch                              *
; *                                                                          *
; ****************************************************************************
InstallKeyboard proc near
                push   es
                cli
                mov    ax,3509h
                int    21h
                mov    si,offset [oldint9]
                mov    [si],bx
                mov    [si + 2],es

                mov    ax,2509h
                mov    dx,offset KeyboardInt
                int    21h

                sti
                pop    es
                ret
InstallKeyboard endp
; ****************************************************************************
; *  UninstallKeyboard 楤 - ⠭           *
; *   㬮砭  ⥬ ⠩                                         *
; *                                                                          *
; ****************************************************************************
UninstallKeyboard proc near
                push   ds
                cli
                mov    ax,2509h
                mov    si,offset [oldint9]
                mov    dx,[word ptr si]
                mov    ds,[word ptr si+2]
                int    21h

                sti
                pop    ds
                ret
UninstallKeyboard endp
; ****************************************************************************
; *                                                                          *
; *   KeyboardInt 뢠 - ࠡ稪                       *
; *                                                                          *
; ****************************************************************************
KeyboardInt proc near
                cli
                push   ax
                push   bx

                in     al,60h
                cmp    al,0E0h
                jne    KIsetscancode
                mov    [e0flag],128
                mov    al,20h
                out    20h,al
                pop    bx
                pop    ax
                sti
                iret

KIsetscancode:
                mov    bl,al
                and    bl,01111111b
                add    bl,[e0flag]
                xor    bh,bh
                and    al,10000000b
                xor    al,10000000b
                                                                                                                                ;          - 0 means released
                rol    al,1
                mov    byte ptr [Memory + Keys + bx],al
                mov    [e0flag],0

                mov    al,20h
                out    20h,al
                                                                                                         ;  +---------- non-specific EOI command
                pop    bx
                pop    ax
                sti
                iret
KeyboardInt endp
; ****************************************************************************
; * Line 楤 -   , ᯮ:                         *
; *  [Xstart] [Ystart] [Xend] [Yend] [Color]                                 *
; *                                                                          *
; ****************************************************************************
Line proc near
                push   bp
                mov    bp,sp

                mov    bx,[bp+12]
                mov    dx,[bp+10]
                cmp    bx,[bp+8]
                jnz    @Lc
                cmp    dx,[bp+6]
                jnz    @Lc
                jmp    LineEnd
@Lc:
                call   CalcDI
                xor    bx,bx

                mov    cx,[bp+8]
                cmp    cx,[bp+12]
                jae    LineC3
                mov    cx,[bp+12]
                sub    cx,[bp+8]
                inc    cx
                mov    word ptr [Memory+Cells],-2
                jmp    short LineC4
LineC3:
                sub    cx,[bp+12]
                inc    cx
                mov    word ptr [Memory+Cells],0
LineC4:
                mov    dx,[bp+6]
                cmp    dx,[bp+10]
                jae    LineC5
                mov    dx,[bp+10]
                sub    dx,[bp+6]
                inc    dx
                mov    word ptr [Memory+Cells+2],-320
                jmp    short LineC6
LineC5:
                sub    dx,[bp+10]
                inc    dx
                mov    word ptr [Memory+Cells+2],320
LineC6:
                mov    ax,[bp+4]
                mov    word ptr [Memory+Cells+4],cx
                mov    word ptr [Memory+Cells+6],dx
                cmp    cx,dx
                jb     LineYL
LineXL:
                stosb
                add    di,word ptr [Memory+Cells]
                add    bx,dx
                cmp    bx,word ptr [Memory+Cells+4]
                jb     LineXLC
                add    di,word ptr [Memory+Cells+2]
                sub    bx,word ptr [Memory+Cells+4]
LineXLC:
                loop   LineXL
                jmp    short LineEnd
LineYL:
                push   di
                stosb
                pop    di
                add    di,word ptr [Memory+Cells+2]
                add    bx,cx
                cmp    bx,word ptr [Memory+Cells+6]
                jbe    LineYLC
                inc    di
                add    di,word ptr [Memory+Cells]
                sub    bx,word ptr [Memory+Cells+6]
LineYLC:
                dec    dx
                jnz    LineYL
LineEnd:
                pop    bp
                ret
Line endp


;*****************************************************************************
;*  ਫ                                                *
;*****************************************************************************
ShipSprite      db     7,9
                db     00,00,00,09,00,00,00
                db     01,00,00,09,00,00,01
                db     09,00,09,03,09,00,09
                db     03,03,09,11,09,03,03
                db     00,00,09,03,09,00,00
                db     00,01,09,14,09,01,00
                db     00,01,12,14,12,01,00
                db     00,00,04,12,04,00,00
                db     00,00,00,04,00,00,00

FoeSprites      db     7,9
                db     00,02,00,04,00,02,00
                db     00,11,04,12,04,10,00
                db     00,10,03,14,03,10,00
                db     00,02,03,08,03,02,00
                db     11,00,10,08,10,00,11
                db     02,00,10,07,10,00,02
                db     00,00,08,07,08,00,00
                db     00,00,00,10,00,00,00
                db     00,00,00,02,00,00,00
; *** ࠣ 2 ***
                db     7,9
                db     04,04,00,00,00,04,04
                db     08,12,04,08,04,12,08
                db     07,14,02,07,02,14,07
                db     02,10,02,09,02,10,02
                db     02,01,09,03,09,01,02
                db     00,02,09,11,09,02,00
                db     00,01,09,03,09,01,00
                db     00,00,09,03,09,00,00
                db     00,00,01,09,01,00,00
; *** ࠣ 3 ***
                db     7,9
                db     00,04,00,04,00,04,00
                db     04,12,04,12,04,12,04
                db     11,14,11,14,11,14,11
                db     00,07,01,08,01,07,00
                db     07,00,01,09,01,00,07
                db     07,00,08,25,08,00,07
                db     07,00,25,27,25,00,07
                db     00,55,27,30,27,55,00
                db     00,55,25,27,25,55,00
; *** ࠣ 4 ***
                db     7,9
                db     00,00,26,26,26,00,00
                db     00,08,26,30,26,08,00
                db     02,10,02,02,02,10,02
                db     07,00,00,10,00,00,07
                db     08,00,26,30,26,00,08
                db     17,00,00,10,00,00,17
                db     00,00,26,30,26,00,00
                db     00,00,00,10,00,00,00
                db     00,00,00,02,00,00,00
; *** ࠣ 5 ***
                db     7,9
                db     00,00,00,76,00,00,00
                db     00,42,00,72,00,42,00
                db     40,00,07,68,07,00,40
                db     38,00,07,64,07,00,38
                db     36,00,08,27,08,00,36
                db     34,00,27,15,27,00,34
                db     32,04,27,15,27,04,32
                db     04,12,04,15,04,12,04
                db     00,04,12,12,12,04,00
; *** ࠣ 6 ***
                db     7,9
                db     00,00,00,04,00,00,00
                db     00,00,04,12,04,00,00
                db     00,00,07,14,07,00,00
                db     20,26,01,09,01,26,20
                db     00,00,09,03,09,00,00
                db     00,00,03,11,03,00,00
                db     17,26,09,03,09,26,17
                db     20,17,00,26,00,17,20
                db     00,00,00,20,00,00,00
; *** ࠣ 7 ***
                db     7,9
                db     00,00,01,09,01,00,00
                db     01,00,09,03,09,00,01
                db     03,04,03,11,03,04,03
                db     44,40,36,32,36,40,44
                db     02,10,27,15,27,10,02
                db     02,17,27,27,27,17,02
                db     02,00,00,00,00,00,02
                db     07,00,00,00,00,00,07
                db     07,08,00,00,00,08,07
; *** ࠣ 8 ***
                db     7,9
                db     08,04,00,00,00,04,08
                db     04,01,09,00,09,01,04
                db     04,00,26,28,26,00,04
                db     04,08,28,15,28,08,04
                db     04,07,17,30,17,07,04
                db     04,08,00,29,00,08,04
                db     04,00,00,28,00,00,04
                db     04,00,00,27,00,00,04
                db     08,04,00,26,00,04,08
; *** ࠣ 9 ***
                db     7,9
                db     00,00,47,32,47,00,00
                db     00,52,37,02,37,52,00
                db     58,40,02,10,02,40,58
                db     45,01,09,03,09,01,45
                db     00,02,06,06,06,02,00
                db     02,08,00,00,00,08,02
                db     10,00,00,00,00,00,10
                db     10,00,25,29,25,00,10
                db     00,14,29,15,29,14,00
; *** ࠣ 10 ***
                db     7,9
                db     04,04,08,17,08,04,04
                db     06,11,04,07,04,11,06
                db     06,11,03,12,03,11,06
                db     06,03,11,12,11,03,06
                db     08,06,23,28,23,06,08
                db     00,06,28,15,28,06,00
                db     00,06,23,28,23,06,00
                db     00,16,06,27,06,16,00
                db     00,00,16,06,16,00,00

CometSprite     db     5,12
                db     00, 00, 52, 00, 00
                db     00, 00, 51, 00, 00
                db     00, 57, 50, 57, 00
                db     00, 49, 45, 49, 00
                db     00, 48, 43, 48, 00
                db     54, 47, 38, 47, 54
                db     46, 38, 32, 38, 46
                db     45, 35, 32, 35, 45
                db     45, 32,115, 32, 45
                db     45,115,107,115, 45
                db     45, 32,115, 32, 45
                db     00, 45, 32, 45, 00

BlasterSprite   db     5,12
                db     00,66,64,66,00
                db     73,68,64,68,73
                db     67,68,75,68,67
                db     69,73,81,73,69
                db     71,75,00,75,71
                db     73,78,00,78,73
                db     75,81,00,81,75
                db     78,87,00,87,78
                db     81,00,00,00,81
                db     84,00,00,00,84
                db     87,00,00,00,87
                db     90,00,00,00,90

FoeWeapons      db     5,12
                db     00,00,16,00,00
                db     00,00,17,00,00
                db     00,00,08,00,00
                db     00,00,08,00,00
                db     00,00,02,00,00
                db     00,00,02,00,00
                db     00,00,10,00,00
                db     00,02,10,02,00
                db     00,10,14,10,00
                db     02,14,15,14,02
                db     00,10,14,10,00
                db     00,00,02,00,00
; *** 㦨 2 ***
                db     5,12
                db     00,00,08,00,00
                db     00,00,04,00,00
                db     00,00,04,00,00
                db     00,04,12,04,00
                db     20,12,14,12,20
                db     22,24,15,24,22
                db     00,24,28,24,00
                db     00,24,28,24,00
                db     00,24,28,24,00
                db     00,24,28,24,00
                db     00,00,28,00,00
                db     00,00,28,00,00
; *** 㦨 3 ***
                db     5,12
                db     00,00,62,00,00
                db     00,00,04,00,00
                db     00,00,32,00,00
                db     00,62,12,62,00
                db     62,32,14,32,62
                db     12,14,31,14,12
                db     12,14,31,14,12
                db     62,32,14,32,62
                db     00,62,12,62,00
                db     00,00,32,00,00
                db     00,00,04,00,00
                db     00,00,62,00,00
; *** 㦨 4 ***
                db     5,12
                db     00,11,15,11,01
                db     03,11,15,11,00
                db     11,15,11,03,00
                db     11,15,11,00,01
                db     00,11,15,11,00
                db     00,00,11,15,11
                db     00,00,03,11,15
                db     01,00,00,11,15
                db     00,00,11,15,11
                db     01,11,15,11,00
                db     00,03,11,15,11
                db     00,11,15,11,00
; *** 㦨 5 ***
                db     8,7
                db     00,00,00,27,25,22,00,00
                db     22,00,17,02,17,00,00,00
                db     25,17,02,10,02,17,00,00
                db     27,02,10,14,10,02,27,00
                db     00,17,02,10,02,17,25,00
                db     00,00,17,02,17,00,22,00
                db     00,22,25,27,00,00,00,00 ,00,00,00,00 ; ⮪  60-56
; *** 㦨 6 ***
                db     8,7
                db     00,00,00,04,00,00,00,00
                db     00,00,62,12,62,00,00,00
                db     00,62,04,14,04,62,00,00
                db     04,12,14,15,14,12,04,00
                db     00,62,04,14,04,62,00,00
                db     00,00,62,12,62,00,00,00
                db     00,00,00,04,00,00,00,00 ,00,00,00,00 ; ⮪  60-56
; *** 㦨 7 ***
                db     5,12
                db     04,12,14,12,04
                db     04,12,14,12,04
                db     04,12,14,12,04
                db     04,12,14,12,04
                db     04,12,14,12,04
                db     04,12,14,12,04
                db     04,12,14,12,04
                db     04,12,14,12,04
                db     04,12,14,12,04
                db     04,12,14,12,04
                db     04,12,14,12,04
                db     04,12,14,12,04
; *** 㦨 8 ***
                db     12,5
                db     12,14,12,00,12,14,12,00,12,14,12,00
                db     04,27,04,00,04,27,04,00,04,27,04,00
                db     00,25,00,00,00,25,00,00,00,25,00,00
                db     00,23,00,00,00,23,00,00,00,23,00,00
                db     00,21,00,00,00,21,00,00,00,21,00,00
; *** 㦨 9 ***
                db     7,8
                db     01,11,00,00,00,01,11
                db     00,11,11,09,00,11,01
                db     00,09,03,11,03,11,00
                db     01,11,11,15,11,03,00
                db     11,01,03,11,03,11,00
                db     00,00,11,09,00,00,11
                db     00,00,01,11,11,01,00
                db     00,00,00,00,01,11,00 ,00,00,00,00


BlowupSprite    db     7,7
                db     000,000,035,035,035,000,000
                db     000,045,117,111,111,127,000
                db     035,117,117,105,096,111,055
                db     120,111,105,096,105,117,035
                db     035,105,096,096,111,127,035
                db     035,111,105,105,111,127,055
                db     055,035,035,110,035,055,000

MetalBlock      db     6,6
                db     19,18,17,18,19,20
                db     18,17,18,19,20,19
                db     17,18,19,20,19,18
                db     18,19,20,19,18,17
                db     19,20,19,18,17,18
                db     20,19,18,17,18,19

LifeIndicator   db     13,5
                db     44,00,00,00,44,00,44,44,44,00,44,44,44
                db     41,00,00,00,00,00,41,00,00,00,41,00,00
                db     38,00,00,00,38,00,38,38,00,00,38,38,00
                db     35,00,00,00,35,00,35,00,00,00,35,00,00
                db     32,32,32,00,32,00,32,00,00,00,32,32,32

PowerIndicator  db     21,5
                db     44,44,00,00,00,44,00,00,44,00,00,00,44,00,44,44,44,00,44,44,44
                db     41,00,41,00,41,00,41,00,41,00,00,00,41,00,41,00,00,00,41,00,41
                db     38,38,00,00,38,00,38,00,38,00,00,00,38,00,38,38,00,00,38,38,00
                db     35,00,00,00,35,00,35,00,35,00,35,00,35,00,35,00,00,00,35,00,35
                db     32,00,00,00,00,32,00,00,00,32,00,32,00,00,32,32,32,00,32,00,32

ShieldIndicator db     20,5
                db     44,44,44,00,44,00,44,00,44,00,44,44,44,00,44,00,00,44,44,00
                db     41,00,00,00,41,00,41,00,00,00,41,00,00,00,41,00,00,41,00,41
                db     38,38,38,00,38,38,38,00,38,00,38,38,00,00,38,00,00,38,00,38
                db     00,00,35,00,35,00,35,00,35,00,35,00,00,00,35,00,00,35,00,35
                db     32,32,32,00,32,00,32,00,32,00,32,32,32,00,32,32,00,32,32,00

ReadyLine       db     21,5
                db     76,76,76,00,76,76,76,00,00,76,00,00,76,76,00,00,76,00,76,00,76
                db     73,00,73,00,73,00,00,00,73,00,73,00,73,00,73,00,73,00,73,00,73
                db     70,70,00,00,70,70,00,00,70,00,70,00,70,00,70,00,00,70,70,00,70
                db     67,00,67,00,67,00,00,00,67,67,67,00,67,00,67,00,00,00,67,00,00
                db     64,00,64,00,64,64,64,00,64,00,64,00,64,64,00,00,64,64,00,00,64

LevelLine       db     17,5
                db     76,00,00,76,76,76,00,76,00,76,00,76,76,76,00,76,00
                db     73,00,00,73,00,00,00,73,00,73,00,73,00,00,00,73,00
                db     70,00,00,70,70,00,00,70,00,70,00,70,70,00,00,70,00
                db     67,00,00,67,00,00,00,67,00,67,00,67,00,00,00,67,00
                db     64,64,00,64,64,64,00,00,64,00,00,64,64,64,00,64,64

GameOverLine    db     21,5
                db     76,00,76,00,76,00,76,00,00,76,00,00,76,76,76,00,76,76,00,00,76
                db     73,00,73,00,00,00,73,00,00,73,00,00,73,00,00,00,73,00,73,00,73
                db     70,70,00,00,70,00,70,00,00,70,00,00,70,70,00,00,70,00,70,00,70
                db     67,00,67,00,67,00,67,00,00,67,00,00,67,00,00,00,67,00,67,00,00
                db     64,00,64,00,64,00,64,64,00,64,64,00,64,64,64,00,64,64,00,00,64

ScoreLine       db     19,5
                db     7Ch,7Ch,7Ch,00h,00h,7Ch,00h,00h,00h,7Ch,00h,00h,7Ch,7Ch,7Ch,00h,7Ch,7Ch,7Ch
                db     79h,00h,00h,00h,79h,00h,79h,00h,79h,00h,79h,00h,79h,00h,79h,00h,79h,00h,00h
                db     76h,76h,76h,00h,76h,00h,00h,00h,76h,00h,76h,00h,76h,76h,00h,00h,76h,76h,00h
                db     00h,00h,73h,00h,73h,00h,73h,00h,73h,00h,73h,00h,73h,00h,73h,00h,73h,00h,00h
                db     70h,70h,70h,00h,00h,70h,00h,00h,00h,70h,00h,00h,70h,00h,70h,00h,70h,70h,70h

TimeLine        db     15,5
                db     7Ch,7Ch,7Ch,00h,7Ch,00h,7Ch,00h,00h,00h,7Ch,00h,7Ch,7Ch,7Ch
                db     00h,79h,00h,00h,00h,00h,79h,79h,00h,79h,79h,00h,79h,00h,00h
                db     00h,76h,00h,00h,76h,00h,76h,00h,76h,00h,76h,00h,76h,76h,00h
                db     00h,73h,00h,00h,73h,00h,73h,00h,00h,00h,73h,00h,73h,00h,00h
                db     00h,70h,00h,00h,70h,00h,70h,00h,00h,00h,70h,00h,70h,70h,70h

UWonLine        db     21,5
                db     7Ch,00h,7Ch,00h,00h,7Ch,00h,00h,00h,7Ch,00h,00h,7Ch,00h,00h,7Ch,00h,00h,7Ch,00h,7Ch
                db     79h,00h,79h,00h,00h,79h,00h,00h,00h,79h,00h,79h,00h,79h,00h,79h,79h,00h,79h,00h,79h
                db     76h,00h,76h,00h,00h,76h,00h,00h,00h,76h,00h,76h,00h,76h,00h,76h,00h,76h,76h,00h,76h
                db     73h,00h,73h,00h,00h,73h,00h,73h,00h,73h,00h,73h,00h,73h,00h,73h,00h,00h,73h,00h,00h
                db     00h,70h,00h,00h,00h,00h,70h,00h,70h,00h,00h,00h,70h,00h,00h,70h,00h,00h,70h,00h,70h

NumbersSprite   db     3,5,44,44,44,41,00,41,38,00,38,35,00,35,32,32,32
                db     3,5,00,00,44,00,41,41,00,00,38,00,00,35,00,00,32
                db     3,5,44,44,44,00,00,41,00,38,38,35,00,00,32,32,32
                db     3,5,44,44,44,00,00,41,00,38,38,00,00,35,32,32,32
                db     3,5,44,00,44,41,00,41,38,38,38,00,00,35,00,00,32
                db     3,5,44,44,44,41,00,00,38,38,38,00,00,35,32,32,32
                db     3,5,44,44,44,41,00,00,38,38,38,35,00,35,32,32,32
                db     3,5,44,44,44,00,00,41,00,38,00,00,35,00,00,32,00
                db     3,5,44,44,44,41,00,41,38,38,38,35,00,35,32,32,32
                db     3,5,44,44,44,41,00,41,38,38,38,00,00,35,00,00,32

ShipPalData     db     01,03,04,09,11,12,14

FoeWData        db     008h,000h,000h,092h,010h,0FFh
                db     016h,040h,001h,083h,0A0h,0FEh, 016h,040h,001h,083h,040h,0FFh
                db     014h,040h,002h,082h,0AAh,0FEh, 014h,040h,002h,082h,042h,0FEh, 020h,000h,001h,093h,010h,0FFh
                db     017h,0C0h,003h,034h,010h,0FEh, 017h,0C0h,003h,0F4h,010h,0FFh
                db     015h,066h,004h,062h,017h,0FEh, 015h,070h,004h,062h,017h,0FFh
                db     01Ah,0E0h,005h,092h,017h,0FEh, 016h,040h,004h,082h,0A9h,0FEh, 016h,040h,004h,082h,041h,0FEh, 012h,040h,002h,031h,0C9h,0FEh, 012h,040h,002h,031h,061h,0FFh
                db     015h,041h,005h,091h,011h,0FFh
                db     028h,0C0h,006h,034h,010h,0FEh, 028h,0C0h,006h,0F4h,010h,0FFh
                db     014h,0E0h,007h,072h,0F7h,0FEh, 014h,0E0h,007h,072h,057h,0FFh
                db     017h,0C0h,003h,034h,010h,0FEh, 017h,0C0h,003h,0F4h,010h,0FEh, 015h,0C0h,008h,082h,019h,0FEh, 015h,0C0h,008h,082h,011h,0FEh, 015h,0C0h,008h,081h,01Ah,0FEh, 015h,0C0h,008h,081h,012h,0FFh


LevelSetup      db     000h,064h,032h,0FFh
                db     000h,032h,032h,0FEh, 000h,096h,032h,0FFh
                db     001h,032h,032h,0FEh, 001h,096h,032h,0FFh
                db     001h,032h,032h,0FEh, 001h,096h,032h,0FEh, 000h,048h,032h,0FEh, 000h,080h,032h,0FFh
                db     002h,064h,032h,0FFh
                db     003h,064h,032h,0FEh, 000h,032h,032h,0FEh, 000h,096h,032h,0FFh
                db     004h,064h,032h,0FEh, 001h,032h,032h,0FEh, 001h,096h,032h,0FFh
                db     002h,064h,032h,0FEh, 003h,032h,032h,0FEh, 004h,096h,032h,0FFh
                db     005h,064h,032h,0FEh, 003h,032h,032h,0FEh, 003h,096h,032h,0FFh
                db     005h,064h,032h,0FEh, 002h,032h,032h,0FEh, 002h,096h,032h,0FFh
                db     006h,064h,032h,0FFh
                db     007h,032h,032h,0FEh, 007h,096h,032h,0FFh
                db     008h,032h,032h,0FEh, 008h,096h,032h,0FFh
                db     006h,064h,032h,0FEh, 008h,096h,032h,0FFh
                db     005h,064h,032h,0FEh, 007h,032h,032h,0FEh, 007h,096h,032h,0FFh
                db     001h,032h,032h,0FEh, 001h,096h,032h,0FEh, 001h,032h,042h,0FEh, 001h,096h,042h,0FEh, 001h,064h,032h,0FEh, 001h,096h,064h,0FEh, 001h,064h,042h,0FFh
                db     006h,064h,032h,0FEh, 006h,064h,032h,0FFh
                db     007h,032h,032h,0FEh, 008h,096h,032h,0FEh, 004h,064h,032h,0FEh, 004h,064h,048h,0FFh
                db     009h,064h,032h,0FEh, 003h,032h,032h,0FEh, 003h,096h,032h,0FFh

XShip           dw     97
YShip           dw     180

ShipLife        db     100
ShipPower       db     100
ShipShield      db     100

RechargeFlag    db     0

Score           dw     0
Timer           dd     0

FireCount       db     0

Level           db     18
LastLevel       db     19

oldint9         dw     2 dup (?)
e0flag          db     0

kQ              EQU    010h
kLARROW         EQU    0CBh
kRARROW         EQU    0CDh
kUARROW         EQU    0C8h
kDARROW         EQU    0D0h
kSPACE          EQU    039h
kENTER          EQU    01Ch

StarsNumX4      EQU    0C8h

;*****************************************************************************
;*                                                     *
;*****************************************************************************
Memory          db     ?
RandCell1       EQU    0    ;-2
RandCell2       EQU    2    ;-4
ShipBuf         EQU    4    ;-69
Palette         EQU    69   ;-73
CometsBuf       EQU    73   ;-693
Keys            EQU    693  ;-949
CometsC         EQU    949  ;-969   Control byte structure
LifeBuf         EQU    969  ;-1271         7  6  5  4  3  2  1  0
PowerBuf        EQU    1271 ;-1573  Power----            
Cells           EQU    1573 ;-1581     Swing-----      -Guided fire
BlasterBuf      EQU    1581 ;-2201  Swing direction-     Swing phase
BlasterC        EQU    2201 ;-2221
StarsData       EQU    2221 ;-2421                      TargetX
ExpData         EQU    2421 ;-2481   FoeData structure     |  -TargetY
ExpBufs         EQU    2481 ;-7021         00 00 00 00 00 00 00
ScoreBuf        EQU    7021 ;-7123  Xcoord-  |Life|  -Sprite
TimeBuf         EQU    7123 ;-7225  Ycoord----      ----FireCount
FoeData         EQU    7225 ;-7365                       SpeedY+PlaceY
FoeBuf          EQU    7365 ;-8665   FoeWeapons structure  |  -SpeedX or swing phase + PlaceX
FWBuf           EQU    8665 ;-14665        00 00 00 00 00 00 00
FWData          EQU    14665;-15365 Xcoord-  Damage  -Sprite
LevelBuf        EQU    15365;-15467 Ycoord----      --Control byte


End Start
End