DECLARE SUB sprite (x%, y%, file$)
'$DYNAMIC
DECLARE SUB PalLoad (palname$)
DECLARE SUB LoadPic (nfile$, darray() AS INTEGER)
DECLARE SUB FindBytes (nfile$, BytesNeeded%)
DIM Tilename$(50)
DIM ObjectName$(100)
DIM Mappish(128, 128) AS INTEGER
DIM Itemize(128, 128) AS INTEGER
DIM CopyBuffer(128, 128) AS INTEGER
DIM Tiling(4015) AS LONG
DIM Defaultile(50) AS INTEGER

DEFINT A-Z
RANDOMIZE TIMER

'Here I put the keyboard scan codes in so it will be easier to program
'the INKEY$ functions later on
UPKEY$ = CHR$(0) + CHR$(72): LEFTKEY$ = CHR$(0) + CHR$(75)
RIGHTKEY$ = CHR$(0) + CHR$(77): DOWNKEY$ = CHR$(0) + CHR$(80)
HOMEKEY$ = CHR$(0) + CHR$(71): ENDKEY$ = CHR$(0) + CHR$(79)
DELKEY$ = CHR$(0) + CHR$(83): PGDNKEY$ = CHR$(0) + CHR$(81)

'These are the default actions for the items on the map 0 to 4
'I haven't finished the file format or the walking engine yet, but any
'items with these attributes will not make the engine access the scripting
'file of the current map.
MusFile$ = "INNET.MID"
ObjectName$(0) = "Default"             'Uses the tile's default item setting (Walk/Blocker)
ObjectName$(1) = "Walk"                'Normal space that you walk on
ObjectName$(2) = "Blocker"             'Wall tile, restricts movement
ObjectName$(3) = "Walkbehind"          'Give the illusion that you are walking behind the tile
ObjectName$(4) = "Walkbehind Blocker"  'Same as above, but also restricts movement.

IF INSTR(COMMAND$, "/?") OR COMMAND$ = "" THEN
    PRINT "Usage:"
    PRINT : PRINT "MAPMAKE [filename]"
    SYSTEM
END IF

IF UCASE$(RIGHT$(COMMAND$, 3)) <> "ARC" THEN
    PRINT "Invalid file type"
    SYSTEM
END IF

SCREEN 13

'AWDraw stuff
CALL PalLoad("c:\arc2\awdraw.pal")
CALL FindBytes("c:\arc2\tiles\grass.awd", BytesNeeded)
DIM temp(BytesNeeded)

'-=-=-=-=-=-=-=-=-=-=
'LOADING THE MAP FILE
'-=-=-=-=-=-=-=-=-=-=
OPEN COMMAND$ FOR INPUT AS #1
    INPUT #1, InNet
    LINE INPUT #1, MusFile$          'The music file, in the /MUSIC subdirectory
    LINE INPUT #1, BossName$
    IF BossName$ <> "BLANK.BSV" THEN
        INPUT #1, bossx
        INPUT #1, bossy
    END IF
    INPUT #1, maxtiles          'First line tells how many different tiles are used on the map
    FOR x = 1 TO maxtiles
        LINE INPUT #1, curtile$ 'The next section is the filenames of the tiles and...
        Tilename$(x) = curtile$
        INPUT #1, Defaultile(x) '...the default item value of the tile.
        CALL LoadPic("c:\arc2\tiles\" + curtile$, temp())
        PUT (1, 1), temp(0), PSET
        GET (1, 1)-(16, 16), Tiling((x - 1) * 65) 'Loading it into the main tile buffer array (Tiling)
        DEF SEG
    NEXT x
    FOR x = 1 TO 128
        LINE INPUT #1, tempstr$
        FOR y = 1 TO 128
            Mappish(x, y) = ASC(MID$(tempstr$, y, 1)) - 64  'Big 128x128 block of map data
        NEXT y
    NEXT x
    ObjectMax = 4
    FOR x = 1 TO 128
        LINE INPUT #1, tempstr$
        FOR y = 1 TO 128
            Itemize(x, y) = ASC(MID$(tempstr$, y, 1)) - 65  'Big 128x128 block of item data (overlaid on map)
            IF Itemize(x, y) > ObjectMax THEN ObjectMax = Itemize(x, y)
        NEXT y
    NEXT x
    FOR x = 5 TO ObjectMax
        LINE INPUT #1, ObjectName$(x)   'Names and numbers of all items on the map.
    NEXT x                              'The name is the image shown and the number is a pointer to the scripting file (not implemented yet)
CLOSE #1

selx1 = 0: selx2 = 0
sely1 = 0: sely2 = 0
SelHeight = 0: SelWidth = 0
cursorx = 5: cursory = 5
screenx = 1: screeny = 1
trailmode = 0
tilechosen = 1
guyname$ = "cursor.awd"

startloop:
   
    PUT (10, 172), Tiling((tilechosen - 1) * 65), PSET
    LOCATE 23, 5
    COLOR 14
    SELECT CASE Defaultile(tilechosen)
        CASE 1
            PRINT "------"
        CASE 2
            PRINT "-WALL-"
        CASE 3
            PRINT "-WATR-"
        CASE 4
            PRINT "-ANIM-"
        CASE 5
            PRINT "-ANI2-"
        CASE ELSE
            PRINT "-????-"
    END SELECT
    COLOR 7
    LOCATE 23, 14: PRINT cursorx; cursory
    LOCATE 23, 23: PRINT ObjectMax;
    COLOR 14
    PRINT "  "; TIME$

    WAIT &H3DA, 8
    FOR xx = screenx TO (screenx + 19)
        FOR yy = screeny TO (screeny + 9)
            x = xx - screenx + 1
            y = yy - screeny + 1
            PUT ((x - 1) * 16, (y - 1) * 16), Tiling((Mappish(xx, yy) - 1) * 65), PSET
            IF xx = bossx AND yy = bossy THEN LINE ((x - 1) * 16, (y - 1) * 16)-(x * 16 - 1, y * 16 - 1), RND * 200, BF
            SELECT CASE Itemize(xx, yy) 'Draws boxes around different item types
                CASE 1
                    LINE ((x - 1) * 16, (y - 1) * 16)-(x * 16 - 1, y * 16 - 1), 1, B
                CASE 2
                    LINE ((x - 1) * 16, (y - 1) * 16)-(x * 16 - 1, y * 16 - 1), 8, B
                CASE 3
                    LINE ((x - 1) * 16, (y - 1) * 16)-(x * 16 - 1, y * 16 - 1), 13, B
                CASE 4
                    LINE ((x - 1) * 16, (y - 1) * 16)-(x * 16 - 1, y * 16 - 1), 20, B
                CASE IS > 4
                    LINE ((x - 1) * 16, (y - 1) * 16)-(x * 16 - 1, y * 16 - 1), 32, B
            END SELECT
            SELECT CASE Defaultile(Mappish(xx, yy))
                CASE 3
                    DEF SEG = &HA000
                    FOR dots = 1 TO 5
                        xdot = (x - 1) * 16 + (RND * 15)
                        ydot = (y - 1) * 16 + (RND * 15)
                        POKE (ydot * 320&) + xdot, 23
                    NEXT dots
            END SELECT
            'IF cursorx = xx AND cursory = yy THEN LINE ((x - 1) * 16, (y - 1) * 16)-(x * 16 - 1, y * 16 - 1), 13, B
            IF cursorx = xx AND cursory = yy THEN CALL sprite((x - 1) * 16, (y - 1) * 16, guyname$)
            IF xx = selx1 AND yy = sely1 THEN LINE ((x - 1) * 16, (y - 1) * 16)-(x * 16 - 1, y * 16 - 1), RND * 100, B
            IF xx = selx2 AND yy = sely2 THEN LINE ((x - 1) * 16, (y - 1) * 16)-(x * 16 - 1, y * 16 - 1), RND * 100 + 100, B
        NEXT
    NEXT

    ink$ = ""
    Timing! = TIMER
startgetink:
    ink$ = INKEY$
IF ink$ = "" AND TIMER - Timing! < .2 THEN GOTO startgetink

    SELECT CASE ink$
        CASE UPKEY$
            cursory = cursory - 1
            IF cursory < 1 THEN cursory = 1
        CASE DOWNKEY$
            cursory = cursory + 1
            IF cursory > 128 THEN cursory = 128
        CASE LEFTKEY$
            cursorx = cursorx - 1
            IF cursorx < 1 THEN cursorx = 1
        CASE RIGHTKEY$
            cursorx = cursorx + 1
            IF cursorx > 128 THEN cursorx = 128
        CASE HOMEKEY$
            cursory = cursory - 5
            IF cursory < 1 THEN cursory = 1
        CASE ENDKEY$
            cursory = cursory + 5
            IF cursory > 128 THEN cursory = 128
        CASE DELKEY$
            cursorx = cursorx - 5
            IF cursorx < 1 THEN cursorx = 1
        CASE PGDNKEY$
            cursorx = cursorx + 5
            IF cursorx > 128 THEN cursorx = 128
        CASE "["
            tilechosen = tilechosen - 1
            IF tilechosen < 1 THEN tilechosen = maxtiles
        CASE "]"
            tilechosen = tilechosen + 1
            IF tilechosen > maxtiles THEN tilechosen = 1
        CASE " "
            Mappish(cursorx, cursory) = tilechosen
        CASE "g", "G"
            tilechosen = Mappish(cursorx, cursory)
        CASE "b", "B"
            bossx = cursorx
            bossy = cursory
        CASE "x", "X"
            CLS
            PRINT "Innet ="; InNet
            PRINT "Musfile$ = "; MusFile$
            PRINT "BossName$ = "; BossName$
            INPUT "Innet = ", InNet
            INPUT "Musfile$ = ", MusFile$
            INPUT "BossName$ = ", BossName$
        CASE "m", "M"
            FOR x = 1 TO 128
                FOR y = 1 TO 128
                    PSET (x, y), Mappish(x, y)
                NEXT y
            NEXT x
            WHILE INKEY$ = ""
                PSET (cursorx, cursory), RND * 200
            WEND
        CASE "f", "F"
            FOR x = 1 TO 128
                FOR y = 1 TO 128
                    PSET (x, y), Mappish(x, y)
                NEXT y
            NEXT x
            PAINT (cursorx, cursory), tilechosen
            FOR x = 1 TO 128
                FOR y = 1 TO 128
                    Mappish(x, y) = POINT(x, y)
                NEXT y
            NEXT x
        CASE ","
            selx1 = cursorx
            sely1 = cursory
        CASE "."
            selx2 = cursorx
            sely2 = cursory
        CASE ";"
            trailmode = 1
            guyname$ = "cursor2.awd"
        CASE "'"
            trailmode = 0
            guyname$ = "cursor.awd"
        CASE "o", "O"
            CLS
            FOR VariableThatIsVeryLong = 5 TO ObjectMax
                PRINT ObjectName$(VariableThatIsVeryLong)
                IF VariableThatIsVeryLong MOD 10 = 0 THEN
                    WHILE INKEY$ = "": WEND
                END IF
            NEXT VariableThatIsVeryLong
            WHILE INKEY$ = "": WEND
            CLS
        CASE "a", "A"
            CLS
            PRINT Itemize(cursorx, cursory); ":"; ObjectName$(Itemize(cursorx, cursory))
            WHILE INKEY$ = "": WEND
        CASE "0"
            Itemize(cursorx, cursory) = 0
        CASE "1"
            Itemize(cursorx, cursory) = 1
        CASE "2"
            Itemize(cursorx, cursory) = 2
        CASE "3"
            Itemize(cursorx, cursory) = 3
        CASE "4"
            Itemize(cursorx, cursory) = 4
        CASE "5"
            Itemize(cursorx, cursory) = 5
        CASE "6"
            Itemize(cursorx, cursory) = 6
        CASE "c", "C"
            SelWidth = 0
            FOR copyx = selx1 TO selx2
                SelWidth = SelWidth + 1
                SelHeight = 0
                FOR copyy = sely1 TO sely2
                    SelHeight = SelHeight + 1
                    CopyBuffer(SelWidth, SelHeight) = Mappish(copyx, copyy)
                NEXT copyy
            NEXT copyx
        CASE "p", "P"
            FOR pastex = cursorx TO (cursorx + SelWidth - 1)
                FOR pastey = cursory TO (cursory + SelHeight - 1)
                    Mappish(pastex, pastey) = CopyBuffer(pastex - cursorx + 1, pastey - cursory + 1)
                NEXT pastey
            NEXT pastex
        CASE CHR$(13)
            CLS
            INPUT "Object number:", Tempint
            Itemize(cursorx, cursory) = Tempint
            IF Tempint > ObjectMax THEN
                ObjectMax = Tempint
                INPUT "Visible tile"; ObjectName$(Tempint)
            END IF
        CASE "s", "S"
            GOSUB savethemap
        CASE CHR$(27)
            SYSTEM
    END SELECT
    IF trailmode = 1 THEN Mappish(cursorx, cursory) = tilechosen

    IF cursorx - screenx < 0 THEN screenx = cursorx
    IF cursory - screeny < 0 THEN screeny = cursory
    IF cursorx - screenx > 19 THEN screenx = cursorx - 19
    IF cursory - screeny > 9 THEN screeny = cursory - 9

GOTO startloop

savethemap:                        'Basically the same code as the loading routine, but the
    CLS                            'data is flowing in the other direction this time.
    INPUT "Filename:", tempstr$
    OPEN tempstr$ FOR OUTPUT AS #1
        PRINT #1, InNet
        PRINT #1, MusFile$
        PRINT #1, BossName$
        IF BossName$ <> "BLANK.BSV" THEN
            PRINT #1, bossx
            PRINT #1, bossy
        END IF
        PRINT #1, maxtiles
        FOR x = 1 TO maxtiles
            PRINT #1, Tilename$(x)
            PRINT #1, Defaultile(x)
        NEXT x
        FOR x = 1 TO 128
            FOR y = 1 TO 128
                PRINT #1, CHR$(Mappish(x, y) + 64);
            NEXT y
            PRINT #1, ""
        NEXT x
        FOR x = 1 TO 128
            FOR y = 1 TO 128
                PRINT #1, CHR$(Itemize(x, y) + 65);
            NEXT y
            PRINT #1, ""
        NEXT x
        FOR x = 5 TO ObjectMax
            PRINT #1, ObjectName$(x)
        NEXT x
    CLOSE #1
RETURN

REM $STATIC
'*************************************************************************
' nfile$      - file to load from
' BytesNeeded - once bytes needed is calcualted it is stored in
'               this variable
'*************************************************************************
SUB FindBytes (nfile$, BytesNeeded)

 ff = FREEFILE
 OPEN nfile$ FOR BINARY AS ff
  GET ff, , xx: GET ff, , yy
 CLOSE ff
 BytesNeeded = (xx * yy * .55)

END SUB

'*************************************************************************
' nfile$ - file to load from
' darray - array to load into
'*************************************************************************
SUB LoadPic (nfile$, darray() AS INTEGER)

 ff = FREEFILE
 OPEN nfile$ FOR BINARY AS ff
  GET ff, , xx: GET ff, , yy
  lb = LBOUND(darray)
  DEF SEG = VARSEG(darray(lb))
  ptr& = VARPTR(darray(lb))
  pline$ = SPACE$((xx * yy) + 4)
  GET ff, , pline$
  FOR aa = 1 TO ((xx * yy) + 4)
   pl = ASC(MID$(pline$, aa, 1))
   POKE ptr&, pl
   ptr& = ptr& + 1
  NEXT aa
 CLOSE ff
 DEF SEG

END SUB

'*************************************************************************
' palname$ - Name of the palette file to load
'*************************************************************************
SUB PalLoad (palname$)

 Bc$ = " ": ff = FREEFILE
 OPEN palname$ FOR BINARY AS ff
  FOR i% = 0 TO 255
   OUT &H3C8, i%
   GET #1, , Bc$: OUT &H3C9, ASC(Bc$)
   GET #1, , Bc$: OUT &H3C9, ASC(Bc$)
   GET #1, , Bc$: OUT &H3C9, ASC(Bc$)
  NEXT i%
 CLOSE ff

END SUB

DEFSNG A-Z
SUB sprite (x%, y%, file$)
    DIM picture(500) AS INTEGER
    CALL LoadPic(file$, picture())
    DEF SEG = VARSEG(picture(0))
    y% = y% - 16
    FOR tempx% = 0 TO 15
       FOR tempy% = 0 TO 31
          temp% = PEEK(VARPTR(picture(2)) + tempx% + (picture(0) \ 8&) * tempy%)
          IF temp% > 0 AND tempx% + x% >= 0 AND tempx% + x% < 320 AND tempy% + y% >= 0 AND tempy% + y% < 200 THEN
             DEF SEG = &HA000
             POKE ((y% + tempy%) * 320&) + (x% + tempx%), temp%
             DEF SEG = VARSEG(picture(0))
          END IF
       NEXT
    NEXT
    DEF SEG = &HA000
END SUB

