DEFINT A-Z

'$DYNAMIC
'$INCLUDE: 'DIRECTQB.BI'

DECLARE SUB LoadPic (nfile$, darray())
DECLARE SUB PalLoad (palname$)
DECLARE SUB EnterOrSpace ()
DECLARE SUB PopText (TextLayer, TextString$, TextX, TextY, TextColor, OuterBox)
DECLARE SUB DelayNow (DelayTime!)

DECLARE FUNCTION BytesRequired& (FileName$)

DECLARE SUB LoadMIDI (FileName$, MIDISegment%, MIDIOffset%)
DECLARE SUB PlayMIDI (MIDISegment%, MIDIOffset%)
DECLARE SUB StopMIDI ()

REM $STATIC
FUNCTION BytesRequired& (FileName$)
   FF% = FREEFILE
   OPEN FileName$ FOR BINARY AS #FF%
   FileLen& = LOF(FF%)
   CLOSE FF%
   IF FileLen& = 0 THEN KILL FileName$
   BytesRequired& = FileLen&
END FUNCTION

SUB DelayNow (DelayTime!)
   Timer1! = TIMER
   WHILE TIMER - Timer1! < DelayTime! AND DQBinkey$ = "": WEND
END SUB

SUB EnterOrSpace
   WHILE DQBkey(KEYENTER) = 0 AND DQBkey(KEYSPACE) = 0: WEND
   WHILE DQBkey(KEYENTER) OR DQBkey(KEYSPACE): WEND
END SUB

DEFSNG A-Z
SUB LoadMIDI (FileName$, MIDISegment%, MIDIOffset%) STATIC
   IF INSTR(FileName$, ".") = 0 THEN FileName$ = FileName$ + ".MID"
   FF% = FREEFILE
   OPEN FileName$ FOR BINARY AS #FF%
   FileLen& = LOF(FF%)
   CLOSE #FF%
   IF FileLen& = 0 THEN KILL FileName$: EXIT SUB
   IF FileLen& > 65536 THEN EXIT SUB
   FileName$ = FileName$ + CHR$(0)
   IF CodeLoaded% = 0 THEN
      asm$ = asm$ + CHR$(&H1E)
      asm$ = asm$ + CHR$(&H55)
      asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
      asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
      asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
      asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
      asm$ = asm$ + CHR$(&H89) + CHR$(&HC6)
      asm$ = asm$ + CHR$(&HB4) + CHR$(&H3F)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&HF)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
      asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
      asm$ = asm$ + CHR$(&H89) + CHR$(&HF3)
      asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
      asm$ = asm$ + CHR$(&HB4) + CHR$(&H3E)
      asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
      asm$ = asm$ + CHR$(&H5D)
      asm$ = asm$ + CHR$(&H1F)
      asm$ = asm$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
      CodeLoaded% = 1
   END IF
   DEF SEG = VARSEG(asm$)
   CALL ABSOLUTE(VARSEG(FileName$), SADD(FileName$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm$))
END SUB

DEFINT A-Z
SUB LoadPic (nfile$, darray() AS INTEGER)
   FF = FREEFILE
   OPEN nfile$ FOR BINARY AS FF
      GET FF, , xx: GET FF, , yy
      lb = LBOUND(darray)
      DEF SEG = VARSEG(darray(lb))
      ptr& = VARPTR(darray(lb))
      pline$ = SPACE$((xx * yy) + 4)
      GET FF, , pline$
      FOR aa = 1 TO ((xx * yy) + 4)
         pl = ASC(MID$(pline$, aa, 1))
         POKE ptr&, pl
         ptr& = ptr& + 1
      NEXT aa
   CLOSE FF
   DEF SEG
END SUB

SUB PalLoad (palname$)
   Bc$ = " ": FF = FREEFILE
   OPEN palname$ FOR BINARY AS FF
      FOR I% = 0 TO 255
         OUT &H3C8, I%
         GET #FF, , Bc$: OUT &H3C9, ASC(Bc$)
         GET #FF, , Bc$: OUT &H3C9, ASC(Bc$)
         GET #FF, , Bc$: OUT &H3C9, ASC(Bc$)
      NEXT I%
   CLOSE FF
END SUB

DEFSNG A-Z
SUB PlayMIDI (MIDISegment%, MIDIOffset%) STATIC
   IF CodeLoaded% = 0 THEN
      asm$ = asm$ + CHR$(&H55)
      asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
      asm$ = asm$ + CHR$(&H8B) + CHR$(&H7)
      asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
      asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
      asm$ = asm$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
      asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
      asm$ = asm$ + CHR$(&H5D)
      asm$ = asm$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
      CodeLoaded% = 1
   END IF
   DEF SEG = VARSEG(asm$)
   Offset% = SADD(asm$)
   CALL ABSOLUTE(MIDISegment%, MIDIOffset%, Offset%)
END SUB

DEFINT A-Z
SUB PopText (TextLayer, TextString$, TextX, TextY, TextColor, OuterBox)
   IF OuterBox THEN
      DQBbox 0, TextX - 1, TextY - 1, TextX + (LEN(TextString$) * 8), TextY + 8, 90
      DQBbox 0, TextX - 2, TextY - 2, TextX + (LEN(TextString$) * 8) + 1, TextY + 9, 95
      DQBboxf 0, TextX, TextY, TextX + (LEN(TextString$) * 8) - 1, TextY + 7, 88
   END IF
   DQBprint TextLayer, TextString$, TextX + 1, TextY + 1, 0
   DQBprint TextLayer, TextString$, TextX, TextY, TextColor
END SUB

DEFSNG A-Z
SUB StopMIDI
   asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
   asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
   asm$ = asm$ + CHR$(&HCB)
   DEF SEG = VARSEG(asm$)
   Offset% = SADD(asm$)
   CALL ABSOLUTE(Offset%)
END SUB

