DECLARE SUB drag.drop (xx%, yy%, action%)
DECLARE SUB tree.write ()
DECLARE SUB th.mate ()
DECLARE FUNCTION th.genforce% ()
DECLARE SUB tree.sort ()
DECLARE SUB tree.show ()
DECLARE SUB move.pack (mov AS ANY, m%)
DECLARE SUB move.extr (m%, mov AS ANY)
DECLARE SUB win.mouse (action%)
DECLARE SUB win.close ()
DECLARE SUB win.click (menu%, item%)
DECLARE SUB win.text (wnd%)
DECLARE SUB alex.alex ()
DECLARE SUB alex.think ()
DECLARE SUB alex.clock ()
DECLARE SUB alex.move ()
DECLARE FUNCTION alex.notat$ (m AS ANY)
DECLARE SUB alex.newgame ()
DECLARE SUB draw.square (x%, y%)
DECLARE SUB alex.init ()
DECLARE SUB alex.control ()
DECLARE SUB draw.move (h1%, v1%, h2%, v2%)
DECLARE SUB win.show (wnd%)
DECLARE SUB th.newpos ()
DECLARE FUNCTION th.check% (c%)
DECLARE SUB th.down ()
DECLARE SUB th.up ()
DECLARE SUB th.value ()
DECLARE SUB th.newphase ()
DECLARE SUB win.draw (x%, y%, w%, h%, fill%)
DECLARE FUNCTION tree.read% ()
DECLARE FUNCTION th.gen% ()
DECLARE SUB th.improve ()
DECLARE SUB piece.move (x%, y%)
'****************************************************************************
DEFINT A-Z
CONST alex$ = ""
CONST Author$ = "ᠭ ਪ"
CONST pawn = 1, knight = 2, bishop = 3, rook = 4, queen = 5, king = 6
CONST fiPieces = 3, fiReport = 4, fiConfig = 5
CONST xBoard = 16, yBoard = 32, wBoard = 44
CONST lenspt = 402, maxTree = 32760
CONST mainmenu = 1, board = 2, moves = 3, moveback = 4, movenext = 5
CONST book = 6, status = 7, analysis = 8, all = 100
CONST txtMoves = 11, txtClock = 12
CONST txtTimeW1 = 13, txtTimeB1 = 14, txtTimeW2 = 15, txtTimeB2 = 16
CONST txtDepth = 17, txtMove = 18, txtBest = 19
CONST txtLevel = 20, txtStatus = 21, txtAnalysis0 = 22
CONST menu.alex = 1, menu.game = 2, menu.level = 3, menu.display = 4
CONST report = 0
'****************************************************************************
TYPE aMouse
  act AS INTEGER: btn AS INTEGER: x AS INTEGER: y AS INTEGER
  bp AS INTEGER: si AS INTEGER: di AS INTEGER: flags AS INTEGER
END TYPE
TYPE move
  x1 AS INTEGER: y1 AS INTEGER: x2 AS INTEGER: y2 AS INTEGER
  p1 AS INTEGER: p0 AS INTEGER: check AS INTEGER: v AS INTEGER
END TYPE
'****************************************************************************
REDIM SHARED pieces(0 TO 7235) AS INTEGER
REDIM SHARED font(2100) AS INTEGER
REDIM SHARED treeMov(1 TO maxTree)
REDIM SHARED treeChild(1 TO maxTree), treeNext(1 TO maxTree)
REDIM SHARED menuBuf(5000)
REDIM SHARED fon(lenspt) AS INTEGER, pieceBuf(lenspt) AS INTEGER
'****************************************************************************
DIM SHARED game(399) AS move
DIM SHARED valPi(-6 TO 6, 1 TO 8, 1 TO 8)
DIM SHARED mov(30) AS move
DIM SHARED vTree, iTree(-1 TO 30), iTreeP(30), outTree(30)
DIM SHARED po0(1 TO 8, 1 TO 8), po1(1 TO 8, 1 TO 8), toMov0, toMov
DIM SHARED rnd6(99), iRnd
DIM SHARED value(-2 TO 30), value0
DIM SHARED xKing(-1 TO 1), yKing(-1 TO 1), xKing0(-1 TO 1), yKing0(-1 TO 1)
DIM SHARED tiCur(-1 TO 1) AS LONG, tiAll(-1 TO 1) AS LONG
DIM SHARED piece$(0 TO 6, 1 TO 2)
DIM SHARED nMov0, iMov0
DIM SHARED mouse AS aMouse
DIM SHARED gameMode, levelMode, bInvert, bSound, bAnimat, bAnalysis, bBook
DIM SHARED bClock, thinkMode, level
DIM SHARED de, deMin, deMax, deGame
DIM SHARED choice AS move
DIM SHARED tiBest AS LONG, clockGo
DIM SHARED depth$, move$, value$, timer$, bestvar$
DIM SHARED depth0$, move0$, value0$, timer0$, bestvar0$
DIM SHARED iMenu, xMenu, wMenu, hMenu, iItem, menu$(15), dow(15), sep(15)
DIM SHARED notat
DIM SHARED veloc AS LONG, curvel AS LONG, oldvel AS LONG
DIM SHARED nomate
DIM SHARED dragging, xPiece, yPiece, pPiece
DIM SHARED mater(-1 TO 1, 30), valKing(1 TO 8, 1 TO 8)
'****************************************************************************
Menus:
DATA ,,஢,࠭,
DATA ,,஢,⮨_, _,室,
DATA , _, 室, ,
DATA ,,1 ᥪ  室,2 ᥪ  室,5 ᥪ  室,10 ᥪ  室,30 ᥪ  室,1   室,2   室,
DATA , _,,_,뢠 ,뢠 ६,
'****************************************************************************
values:
'pawn
DATA  0 , 0 , 0 , 0
DATA 150,150,150,150
DATA 140,111, 95, 83
DATA 135,108, 94, 82
DATA 130,105, 93, 81
DATA 120,101, 92, 81
DATA 100, 95, 90, 80
DATA  0 , 0 , 0 , 0
'knight
DATA 294,290,285,260
DATA 298,296,290,285
DATA 303,301,295,290
DATA 305,303,300,295
DATA 305,303,300,295
DATA 303,301,295,290
DATA 298,296,290,285
DATA 294,290,285,260
'bishop
DATA 296,293,291,266
DATA 304,301,300,291
DATA 308,306,301,294
DATA 310,308,306,298
DATA 309,307,305,297
DATA 306,305,300,293
DATA 303,300,308,290
DATA 295,292,290,265
'rook
DATA 507,505,504,503
DATA 506,504,503,502
DATA 505,503,502,501
DATA 504,502,501,500
DATA 503,501,500,499
DATA 502,500,499,498
DATA 501,499,498,497
DATA 500,498,497,496
'queen
DATA 900,900,900,900
DATA 900,900,900,900
DATA 900,900,900,900
DATA 901,900,900,900
DATA 901,900,900,900
DATA 900,900,900,900
DATA 900,900,900,900
DATA 900,900,900,900
'king
DATA 30,25,15,00
DATA 45,40,30,15
DATA 55,50,40,25
DATA 60,55,45,30
DATA 60,55,45,30
DATA 55,50,40,25
DATA 45,40,30,15
DATA 30,25,15,00
'****************************************************************************
StartPos: DATA 4,2,3,5,6,3,2,4
'****************************************************************************
DEF fnTime$ (tt&)
 t = tt& \ 10
 t$ = CHR$(48 + t \ 3600): t = t MOD 3600
 t$ = t$ + ":" + CHR$(48 + t \ 600): t = t MOD 600
 t$ = t$ + CHR$(48 + t \ 60): t = t MOD 60
 t$ = t$ + ":" + CHR$(48 + t \ 10): t = t MOD 10
 t$ = t$ + CHR$(48 + t)
 fnTime$ = t$
END DEF
DEF fnX (x) = xBoard + wBoard * (x - 1 - bInvert * (x + x - 9))
DEF fnY (y) = yBoard + wBoard * (8 - y + bInvert * (y + y - 9))
'****************************************************************************
alex.alex

SUB alex.alex

alex.init
DO
  DO
    DO
      IF thinkMode THEN alex.think
      DEF SEG = &H40
    LOOP WHILE PEEK(&H6C) = t
    alex.control
    t = PEEK(&H6C): tact = tact + 1125
  LOOP WHILE tact < 2048
  alex.clock
  tact = tact - 2048
LOOP

END SUB

SUB alex.clock

IF clockGo THEN
  tc& = tiCur(toMov0) + 1: ta& = tiAll(toMov0) + 1
  tiCur(toMov0) = tc&: tiAll(toMov0) = ta&
  IF ta& MOD 10 = 0 AND iMenu = 0 THEN
    IF toMov0 = 1 THEN win.text txtTimeW1 ELSE win.text txtTimeB1
  END IF
  IF tc& MOD 10 = 0 AND iMenu = 0 THEN
    IF toMov0 = 1 THEN win.text txtTimeW2 ELSE win.text txtTimeB2
  END IF
END IF
   
STATIC ii: ii = ii + 1
IF ii = 5 THEN
  ii = 0: veloc = curvel + oldvel: oldvel = curvel: curvel = 0
  win.text txtStatus
END IF

STATIC clock$: t$ = LEFT$(TIME$, 5)
IF t$ <> clock$ AND bClock THEN clock$ = t$: IF bClock THEN win.text txtClock

END SUB

SUB alex.control

DIM buf(700)
 
SELECT CASE INKEY$
CASE CHR$(27): win.click menu.alex, 5
CASE CHR$(0) + "": tree.show
END SELECT

STATIC btnOld
win.mouse 3: xx = mouse.x: yy = mouse.y: x = xx \ 8 + 1: y = yy \ 16 + 1
mouse.btn = mouse.btn AND 1
IF mouse.btn > btnOld THEN mouseDown = 1
IF mouse.btn < btnOld THEN mouseUp = 1
btnOld = mouse.btn

IF iMenu THEN
  IF xx > xMenu AND xx < xMenu + wMenu AND yy > 15 AND yy < 15 + hMenu THEN
    IF y - 1 <> iItem THEN
      win.mouse 2
      IF iItem THEN
        LOCATE 1 + iItem, xMenu \ 8 + 2
        PRINT " "; menu$(iItem); TAB((xMenu + wMenu) \ 8 + 1);
        IF sep(iItem) THEN LINE (xMenu + 1, iItem * 16 + 15)-STEP(wMenu - 2, 0), 8
      END IF
      iItem = y - 1
      LOCATE y, xMenu \ 8 + 2: COLOR 6
      PRINT " "; menu$(iItem); TAB((xMenu + wMenu) \ 8 + 1); : COLOR 7
      GET (xMenu + 1, 16 * iItem)-STEP(wMenu - 2, 15), buf
      PUT (xMenu + 1, 16 * iItem), buf, PRESET
      IF sep(iItem) THEN LINE (xMenu + 1, iItem * 16 + 15)-STEP(wMenu - 2, 0), 8
      win.mouse 1
    END IF
  END IF
END IF

IF dragging THEN
  IF mouseUp THEN drag.drop (xx), (yy), 2 ELSE drag.drop (xx), (yy), 0
END IF
IF mouseDown = 0 THEN EXIT SUB

oldMenu = iMenu
IF iMenu THEN
  m = iMenu: win.close
  IF xx > xMenu AND xx < xMenu + wMenu THEN
    IF yy > 15 AND yy < 15 + hMenu THEN win.click m, y - 1: EXIT SUB
  END IF
ELSEIF thinkMode = 2 AND x > 2 AND x <= 46 AND y > 2 AND y <= 24 THEN
  drag.drop (xx), (yy), 1
END IF
IF y <> 1 THEN EXIT SUB

RESTORE Menus: mx = 2: m = 0: mw = 0
DO
  mx = mx + mw
  m = m + 1: READ m$: mw = LEN(m$) + 2: IF m$ = "" THEN EXIT SUB
LOOP UNTIL x >= mx AND x < mx + mw
IF m = oldMenu THEN EXIT SUB
FOR i = 1 TO 15: dow(i) = 0: sep(i) = 0: NEXT
SELECT CASE m
CASE menu.alex: dow(gameMode) = 1: CASE menu.level: dow(levelMode) = 1
CASE menu.display: dow(1) = bInvert: dow(2) = bSound
  dow(3) = bAnimat: dow(4) = bAnalysis: dow(5) = bClock
END SELECT
    
FOR i = 1 TO m: DO: READ i$: LOOP UNTIL i$ = "": NEXT
READ d$
FOR i = 1 TO 20
  READ i$: IF i$ = "" THEN h = i - 1: EXIT FOR
  IF RIGHT$(i$, 1) = "_" THEN sep(i) = 1: i$ = LEFT$(i$, LEN(i$) - 1)
  IF d$ = "" THEN i$ = CHR$(32 + 219 * dow(i)) + " " + i$
  IF LEN(i$) + 2 > w THEN w = LEN(i$) + 2
  menu$(i) = i$
NEXT
iMenu = m: xMenu = mx * 8 - 9: wMenu = w * 8 + 1: hMenu = h * 16 + 1
win.mouse 2
GET (xMenu, 15)-STEP(wMenu, hMenu), menuBuf
LOCATE 1, mx: COLOR 6: PRINT " "; m$; " "; : COLOR 7
GET (xMenu + 1, 0)-STEP(mw * 8 - 1, 15), buf: PUT (xMenu + 1, 0), buf, PRESET
FOR i = 1 TO h
  LOCATE 1 + i, mx: PRINT " "; menu$(i); SPACE$(w - LEN(menu$(i)) - 1)
  IF sep(i) THEN LINE (xMenu + 1, i * 16 + 15)-STEP(wMenu - 2, 0), 8
NEXT
LINE (xMenu, 15)-STEP(wMenu, hMenu), 0, B
win.mouse 1

END SUB

SUB alex.init

DIM a(17): FOR i = 1 TO 17: a(i) = ASC(MID$(Author$, i)): NEXT: IF LEFT$(Author$, 5) <> alex$ THEN STOP
IF a(1) = 128 AND a(2) = 171 AND a(3) = 165 AND a(4) = 170 AND a(5) = 225 AND a(6) = 160 AND a(7) = 173 AND a(8) = 164 AND a(9) = 224 AND a(10) = 32 THEN a = a ELSE STOP
IF a(11) = 146 AND a(12) = 227 AND a(13) = 224 AND a(14) = 168 AND a(15) = 170 AND a(16) = 174 AND a(17) = 162 THEN a = a ELSE STOP

SCREEN 12: COLOR 7
win.mouse 0: win.mouse 1
DEF SEG = 0: s2& = VARSEG(font(0)): s2& = s2& - (s2& < 0) * 65536
POKE 268, 0: POKE 269, 0: POKE 270, s2& MOD 256: POKE 271, s2& \ 256
DEF SEG = s2&: BLOAD "font3.alx", 0

OPEN "pieces2.alx" FOR RANDOM ACCESS READ AS #fiPieces LEN = 2
FOR i = 0 TO 7235: GET #fiPieces, 1 + i, d: pieces(i) = d: NEXT
CLOSE #fiPieces

notat = 1
piece$(0, 1) = "_": piece$(1, 1) = "": piece$(2, 1) = "": piece$(3, 1) = ""
piece$(4, 1) = "": piece$(5, 1) = "": piece$(6, 1) = ""
piece$(0, 2) = "_": piece$(1, 2) = "": piece$(2, 2) = "": piece$(3, 2) = ""
piece$(4, 2) = "": piece$(5, 2) = "": piece$(6, 2) = ""

RESTORE values
FOR p = pawn TO queen: FOR y = 8 TO 1 STEP -1: FOR x = 5 TO 8
  READ v: valPi(p, x, y) = v: valPi(p, 9 - x, y) = v
  valPi(-p, x, 9 - y) = -v: valPi(-p, 9 - x, 9 - y) = -v
NEXT: NEXT: NEXT
FOR y = 8 TO 1 STEP -1: FOR x = 5 TO 8
  READ v: valKing(x, y) = v: valKing(9 - x, y) = v
NEXT: NEXT
gameMode = 1: levelMode = 3: thinkMode = 2
bSound = 1: bAnimat = 1: bAnalysis = 1: bBook = 1: bClock = 1

OPEN "config.alx" FOR APPEND AS #fiConfig: CLOSE #fiConfig
OPEN "config.alx" FOR INPUT AS #fiConfig
FOR i = 1 TO 8
  IF EOF(fiConfig) THEN EXIT FOR
  LINE INPUT #fiConfig, l$
  s = INSTR(l$, "=")
  IF s THEN
    v = VAL(MID$(l$, s + 1))
    SELECT CASE LCASE$(RTRIM$(LEFT$(l$, s - 1)))
    CASE "mode": win.click menu.alex, v
    CASE "level": win.click menu.level, v
    CASE "invert": bInvert = v
    CASE "sound": bSound = v: CASE "animat": bAnimat = v
    CASE "analysis": bAnalysis = v: CASE "clock": bClock = v
    END SELECT
  END IF
  NEXT
CLOSE #fiConfig

IF report THEN OPEN "report.alx" FOR OUTPUT AS #fiReport

RANDOMIZE TIMER: FOR i = 0 TO 99: rnd6(i) = INT(7 * RND): NEXT

win.show all
alex.newgame

END SUB

SUB alex.move

IF bAnalysis THEN win.text txtMove
IF iMenu THEN win.close

IF thinkMode = 1 THEN
  FOR y = 1 TO 8: FOR x = 1 TO 8: po1(x, y) = po0(x, y): NEXT x, y
  move.extr treeMov(treeChild(1)), choice
END IF

x1 = choice.x1: y1 = choice.y1: x2 = choice.x2: y2 = choice.y2
p1 = po0(x1, y1): choice.p1 = p1

IF thinkMode <> 2 THEN draw.move x1, y1, x2, y2
po0(x1, y1) = 0: po0(x2, y2) = p1
draw.square x2, y2

IF report THEN
  PRINT #fiReport, ""
  notat = 2: PRINT #fiReport, "***** "; alex.notat(choice); " *****"
  notat = 1: deRep = de
END IF
  
'castle
IF ABS(p1) = king THEN
  dx = x2 - x1
  IF dx = 2 THEN
    draw.move 8, y1, 6, y1: po0(8, y1) = 0: po0(6, y1) = toMov0 * rook
    draw.square 6, y1
  ELSEIF dx = -2 THEN
    draw.move 1, y1, 4, y1: po0(1, y1) = 0: po0(4, y1) = toMov0 * rook
    draw.square 4, y1
  END IF
END IF

'promotion
IF ABS(p1) = 1 AND choice.y2 = 4.5 + 3.5 * toMov0 THEN
  po0(choice.x2, choice.y2) = 5 * toMov0: draw.square x2, y2
END IF

game(deGame) = choice: deGame = deGame + 1: toMov0 = -toMov0
clockGo = 1

SELECT CASE gameMode
CASE 1: thinkMode = 3 - thinkMode
CASE 2: thinkMode = 2
CASE 3: thinkMode = 1
END SELECT

th.newpos

END SUB

SUB alex.newgame

RESTORE StartPos
FOR x = 1 TO 8
 READ p
 po0(x, 1) = p: po0(x, 2) = 1: po0(x, 3) = 0: po0(x, 4) = 0
 po0(x, 5) = 0: po0(x, 6) = 0: po0(x, 7) = -1: po0(x, 8) = -p
NEXT
win.show board

depth0$ = ""
toMov0 = 1: deGame = 0: value0 = 0: thinkMode = 2: clockGo = 0
tiAll(1) = 0: tiAll(-1) = 0: tiCur(1) = 0: tiCur(-1) = 0

th.newpos

END SUB

FUNCTION alex.notat$ (m AS move)

p1 = m.p1: IF p1 < -king THEN p1 = 0
IF ABS(p1) = king AND ABS(m.x2 - m.x1) = 2 THEN
  IF m.x2 - m.x1 = 2 THEN n$ = "  O-O" ELSE n$ = " O-O-O"
ELSE
  IF m.p0 = 0 THEN n$ = "-" ELSE n$ = ":"
  n$ = piece$(ABS(p1), notat) + CHR$(96 + m.x1) + CHR$(48 + m.y1) + n$
  n$ = n$ + CHR$(96 + m.x2) + CHR$(48 + m.y2)
END IF
c = m.check
IF c = 0 THEN a$ = "" ELSE IF c = 1 THEN a$ = "+"
IF c = 2 THEN a$ = "#" ELSE IF c = -1 THEN a$ = "@"

alex.notat = n$ + a$
IF m.x1 = 0 OR m.x2 = 0 OR m.y1 = 0 OR m.y2 = 0 THEN alex.notat = ""

END FUNCTION

SUB alex.think

at1:
IF tree.read THEN GOTO at2
IF de >= deMin THEN IF th.genforce THEN GOTO at2 ELSE GOTO at3
IF th.gen = 0 THEN
  IF iTree(de) > 0 THEN treeNext(iTree(de)) = -32768
  GOTO at3
END IF
tree.write
at2:
IF ABS(mov(de).p0) = king THEN
  value(de) = 1000 * (31 - de) * toMov: tree.sort: GOTO at6
END IF
th.down
IF de >= deMax THEN th.value: GOTO at4
IF de >= deMin THEN th.value: value(de + 1) = value(de): GOTO at5
GOTO at1
at3:
IF de = 0 THEN
  IF thinkMode = 1 AND tiCur(toMov0) * 2 >= level THEN
    IF deMin > 2 OR (deMin = 2 AND iMov0 = nMov0) THEN alex.move: EXIT SUB
  END IF
  th.newphase
  EXIT SUB
END IF
at4:
IF de = deMin THEN
  IF nomate = 0 THEN th.mate
ELSEIF value(de) = -1000 * (30 - de) * toMov THEN
  IF th.check(toMov) = 0 THEN value(de) = 0
END IF
at6:
th.up
IF value(de + 1) * toMov > value(de) * toMov THEN th.improve
at5:
IF value(de + 1) * toMov >= value(de - 1) * toMov THEN GOTO at4
IF thinkMode = 1 THEN
  IF value0 * toMov0 > 10000 THEN alex.move: EXIT SUB
  IF deMin > 2 OR (de = 0 AND deMin = 2 AND iMov0 = nMov0) THEN
    IF tiCur(toMov0) >= level + level AND de = 0 THEN alex.move: EXIT SUB
    IF tiAll(toMov0) >= level * (deGame \ 2 + 1) THEN alex.move: EXIT SUB
  END IF
END IF

END SUB

SUB drag.drop (xx, yy, action)

x = (xx - 16 + wBoard) \ wBoard: y = (yy - 32 + wBoard) \ wBoard
IF bInvert THEN x = 9 - x ELSE y = 9 - y

IF action = 1 THEN
  p = po0(x, y): IF p = 0 THEN EXIT SUB
  pPiece = p
  choice.x1 = x: choice.y1 = y
  dragging = 1: xPiece = xx - 20: yPiece = yy - 20
  IF (x + y) AND 1 THEN c = 11 ELSE c = 3
  win.mouse 2
  LINE (fnX(x), fnY(y))-STEP(wBoard - 1, wBoard - 1), c, BF
  GET (xPiece, yPiece)-STEP(39, 39), fon(0)
  piece.move xPiece, yPiece
  win.mouse 1
ELSEIF action = 0 THEN
  xp = xPiece: yp = yPiece
  xp = xx - 20: yp = yy - 20
  IF xp < 2 THEN xp = 2 ELSE IF xp > 342 THEN xp = 342
  IF yp < 18 THEN yp = 18 ELSE IF yp > 358 THEN yp = 358
  IF xPiece = xp AND yPiece = yp THEN EXIT SUB
  piece.move xp, yp
ELSE
  dragging = 0
  x1 = choice.x1: y1 = choice.y1
  IF x < 1 OR x > 8 OR y < 1 OR y > 8 THEN GOTO dd.away
  i = treeChild(1)
  DO
    IF i <= 0 THEN choice.p1 = 0: GOTO dd.away
    move.extr treeMov(i), choice: i = treeNext(i)
  LOOP UNTIL x = choice.x2 AND y = choice.y2 AND x1 = choice.x1 AND y1 = choice.y1
  choice.p1 = po0(x1, y1): choice.p0 = po0(x, y)
  piece.move fnX(x) + 2, fnY(y) + 2
  alex.move
  EXIT SUB
dd.away:
  piece.move fnX(x1) + 2, fnY(y1) + 2
END IF

END SUB

SUB draw.move (h1, v1, h2, v2)

pPiece = po0(h1, v1)

x1 = fnX(h1) + 2: y1 = fnY(v1) + 2: x2 = fnX(h2) + 2: y2 = fnY(v2) + 2

IF bSound AND thinkMode = 1 THEN PLAY "o3d8"
po0(h1, v1) = 0: draw.square h1, v1
IF bAnimat = 0 THEN EXIT SUB
xPiece = x1: yPiece = y1
n = SQR(CLNG(x2 - x1) * CLNG(x2 - x1) + CLNG(y2 - y1) * CLNG(y2 - y1)) \ 11
win.mouse 2
GET (x1, y1)-STEP(39, 39), fon(0)
win.mouse 1
FOR i = 1 TO n
  piece.move x1 + (x2 - x1) * i \ n, y1 + (y2 - y1) * i \ n
  FOR dl& = 1 TO 80000: NEXT
NEXT
piece.move x2, y2

END SUB

SUB draw.square (x, y)

win.mouse 2
IF (x + y) AND 1 THEN c = 11 ELSE c = 3
xx = fnX(x): yy = fnY(y)
LINE (xx, yy)-STEP(wBoard - 1, wBoard - 1), c, BF
p = po0(x, y)
IF p THEN
  xx = xx + 2: yy = yy + 2
  PUT (xx, yy), pieces(lenspt * (2 + 3 * (ABS(p) - 1))), AND
  PUT (xx, yy), pieces(lenspt * (1 + (p > 0) + 3 * (ABS(p) - 1))), XOR
END IF
win.mouse 1

END SUB

SUB move.extr (m, mov AS move)

IF m <= 0 THEN PRINT "me": STOP
v = m: mov.x1 = (v AND 7) + 1: v = v \ 8: mov.y1 = (v AND 7) + 1
v = v \ 32: mov.x2 = (v AND 7) + 1: v = v \ 8: mov.y2 = (v AND 7) + 1
mov.p1 = po1(mov.x1, mov.y1): mov.p0 = po1(mov.x2, mov.y2)

END SUB

SUB move.pack (mov AS move, m)

m = mov.x1 - 1 + 8 * (mov.y1 - 1) + 256 * (mov.x2 - 1) + 2048 * (mov.y2 - 1)

END SUB

SUB piece.move (x, y)

win.mouse 2
PUT (xPiece, yPiece), fon(0), PSET
xPiece = x: yPiece = y
GET (x, y)-STEP(39, 39), fon(0)
p = pPiece
ap = lenspt * (1 + (p > 0) + 3 * (ABS(p) - 1))
am = lenspt * (2 + 3 * (ABS(p) - 1))

pieceBuf(0) = 40: pieceBuf(1) = 40
FOR i = 2 TO lenspt - 1
  pieceBuf(i) = (fon(i) AND pieces(am + i)) XOR pieces(ap + i)
NEXT
PUT (x, y), pieceBuf(0), PSET
win.mouse 1

END SUB

FUNCTION th.check (c)

x = xKing(c): y = yKing(c)

th.check = 1

'pawn
IF y + c >= 2 AND y + c <= 7 THEN
 IF x > 1 THEN IF po1(x - 1, y + c) = -c THEN EXIT FUNCTION
 IF x < 8 THEN IF po1(x + 1, y + c) = -c THEN EXIT FUNCTION
END IF
'knight
p = -c - c
h = 2: v = 1: GOSUB cK: h = -2: GOSUB cK
v = -1: GOSUB cK: h = 2: GOSUB cK
h = 1: v = 2: GOSUB cK: h = -1: GOSUB cK
v = -2: GOSUB cK: h = 1: GOSUB cK
'bishop & queen
p = p - c: q = p - c - c
h = 1: v = 1: GOSUB cQ: h = -1: GOSUB cQ
v = -1: GOSUB cQ: h = 1: GOSUB cQ
'rook & queen
p = p - c
h = 1: v = 0: GOSUB cQ: h = -1: GOSUB cQ
h = 0: v = 1: GOSUB cQ: v = -1: GOSUB cQ
'king
p = p - c - c
FOR h = -1 TO 1: FOR v = -1 TO 1
 IF (h OR v) <> 0 THEN GOSUB cK
NEXT v, h

th.check = 0: EXIT FUNCTION

cQ: xx = x + h: yy = y + v
    DO WHILE xx >= 1 AND xx <= 8 AND yy >= 1 AND yy <= 8
      pp = po1(xx, yy)
      IF pp = p OR pp = q THEN EXIT FUNCTION ELSE IF pp THEN EXIT DO
      xx = xx + h: yy = yy + v
    LOOP
    RETURN

cK: xx = x + h: yy = y + v
    IF xx < 1 OR xx > 8 OR yy < 1 OR yy > 8 THEN RETURN
    IF po1(xx, yy) <> p THEN RETURN

END FUNCTION

SUB th.down

DIM m AS move: m = mov(de)
dm = valPi(m.p1, m.x2, m.y2) - valPi(m.p1, m.x1, m.y1)
mater(toMov, de + 1) = mater(toMov, de) + dm
mater(-toMov, de + 1) = mater(-toMov, de) - valPi(m.p0, m.x2, m.y2)

iTree(de + 1) = 0: iTreeP(de + 1) = 0: outTree(de + 1) = 0
curvel = curvel + 1
IF de = 0 THEN
  iMov0 = iMov0 + 1
  IF bAnalysis AND (deMin > 3 OR iMov0 = nMov0) THEN win.text txtMove
END IF

STATIC deRep
IF report THEN
  IF de <= deRep THEN PRINT #fiReport, "": PRINT #fiReport, SPACE$(1 + de * 8);
  notat = 2: PRINT #fiReport, LEFT$(alex.notat(mov(de)) + "         ", 8);
  notat = 1: deRep = de
END IF

IF SGN(m.p1) = SGN(m.p0) THEN PRINT "td": STOP
po1(m.x1, m.y1) = 0: po1(m.x2, m.y2) = m.p1

SELECT CASE ABS(m.p1)
CASE king
  xKing(toMov) = m.x2: yKing(toMov) = m.y2
  l = m.x2 - m.x1
  IF l = 2 THEN po1(8, m.y1) = 0: po1(6, m.y1) = toMov * rook
  IF l = -2 THEN po1(1, m.y1) = 0: po1(4, m.y1) = toMov * rook
CASE pawn
  IF m.y2 = 1 OR m.y2 = 8 THEN
    pp = toMov * queen: po1(m.x2, m.y2) = pp
    mater(toMov, de + 1) = mater(toMov, de + 1) + valPi(pp, m.x2, m.y2)
  END IF
END SELECT
  
de = de + 1: toMov = -toMov
mov(de).p1 = 0
value(de) = value(de - 2)
IF de = deMin THEN nomate = 0

END SUB

FUNCTION th.gen

DIM m AS move: m = mov(de)
IF iTree(de) = -32768 THEN EXIT FUNCTION
IF m.p1 THEN
  x = m.x1: y = m.y1
  dx = m.x2 - x: dy = m.y2 - y: sx = SGN(dx): sy = SGN(dy)
pieceGen:
  SELECT CASE ABS(po1(x, y))
  CASE pawn: GOTO pawnGen
  CASE knight: GOTO knightGen
  CASE bishop: GOTO tgBishopGen
  CASE rook: GOTO tgRookGen
  CASE queen: GOTO tgQueenGen
  CASE king: IF ABS(dx) <> 2 THEN GOTO kingGen ELSE GOTO castleGen
  END SELECT: PRINT "tg": STOP
END IF

firstSquare:
  x = 0: IF toMov = 1 THEN y = 1 ELSE y = 8
tgNext:
  x = x + 1
  IF x = 9 THEN x = 1: y = y + toMov
  IF y = 0 OR y = 9 THEN EXIT FUNCTION
  IF SGN(po1(x, y)) <> toMov THEN GOTO tgNext

  SELECT CASE ABS(po1(x, y))
  CASE pawn: GOTO pawnGen1
  CASE knight: dx = -1: dy = -2: GOTO knightGen1
  CASE bishop: dx = 0: dy = 0: sx = -1: sy = -1: GOTO tgBishopGen1
  CASE rook: dx = 0: dy = 0: sx = -1: sy = 0: GOTO tgRookGen1
  CASE queen: dx = 0: dy = 0: sx = -1: sy = -1: GOTO tgQueenGen1
  CASE king: dx = -2: dy = -1: GOTO kingGen
  END SELECT: PRINT "tg2": STOP

pawnGen:
  IF dx = -1 THEN GOTO pawnGen2
  IF dx = 1 THEN GOTO pawnGen3
  IF ABS(dy) = 1 THEN GOTO pawnGen4
  GOTO tgNext
pawnGen1:
  dy = toMov
  IF x > 1 THEN IF SGN(po1(x - 1, y + dy)) = -dy THEN dx = -1: GOTO genMove
pawnGen2:
  IF x < 8 THEN IF SGN(po1(x + 1, y + dy)) = -dy THEN dx = 1: GOTO genMove
pawnGen3:
  IF po1(x, y + dy) THEN GOTO tgNext ELSE dx = 0: GOTO genMove
pawnGen4:
  IF y <> 2 AND y <> 7 THEN GOTO tgNext
  dy = toMov + toMov
  IF y + dy < 1 OR y + dy > 8 THEN GOTO tgNext
  IF po1(x, y + dy) THEN GOTO tgNext ELSE dx = 0: GOTO genMove

knightGen:
  IF dx > 0 THEN
    dy = dy + 1: IF dy = 0 THEN dy = 1 ELSE IF dy = 3 THEN GOTO tgNext
    dx = ABS(dy) - 3
  ELSE dx = -dx
  END IF
knightGen1:
  xx = x + dx: yy = y + dy
  IF xx < 1 OR xx > 8 OR yy < 1 OR yy > 8 THEN GOTO knightGen
  IF SGN(po1(xx, yy)) = toMov THEN GOTO knightGen
  GOTO genMove

tgBishopGen:
  IF po1(x + dx, y + dy) = 0 THEN GOTO tgBishopGen1
tgBishopDir:
  IF sx = -1 AND sy = 1 THEN GOTO tgNext
  dx = 0: dy = 0: SWAP sx, sy: sx = -sx
tgBishopGen1:
  dx = dx + sx: dy = dy + sy: xx = x + dx: yy = y + dy
  IF xx = 0 OR xx = 9 OR yy = 0 OR yy = 9 THEN GOTO tgBishopDir
  IF SGN(po1(xx, yy)) = toMov THEN GOTO tgBishopDir
  GOTO genMove

tgRookGen:
  IF po1(x + dx, y + dy) = 0 THEN GOTO tgRookGen1
tgRookDir:
  IF sy = 1 THEN GOTO tgNext
  dx = 0: dy = 0: SWAP sx, sy: sx = -sx
tgRookGen1:
  dx = dx + sx: dy = dy + sy: xx = x + dx: yy = y + dy
  IF xx = 0 OR xx = 9 OR yy = 0 OR yy = 9 THEN GOTO tgRookDir
  IF SGN(po1(xx, yy)) = toMov THEN GOTO tgRookDir
  GOTO genMove

tgQueenGen:
  IF po1(x + dx, y + dy) = 0 THEN GOTO tgQueenGen1
tgQueenDir:
  sx = sx + 1: IF sx = 0 AND sy = 0 THEN sx = 1
  IF sx = 2 THEN sx = -1: sy = sy + 1: IF sy = 2 THEN GOTO tgNext
  dx = 0: dy = 0
tgQueenGen1:
  dx = dx + sx: dy = dy + sy: xx = x + dx: yy = y + dy
  IF xx = 0 OR xx = 9 OR yy = 0 OR yy = 9 THEN GOTO tgQueenDir
  IF SGN(po1(xx, yy)) = toMov THEN GOTO tgQueenDir
  GOTO genMove

kingGen:
  dx = dx + 1
  IF dx = 2 THEN dx = -1: dy = dy + 1: IF dy = 2 THEN GOTO castleGen1
  IF dx = 0 AND dy = 0 THEN dx = 1
  xx = x + dx: yy = y + dy
  IF xx = 0 OR xx = 9 OR yy = 0 OR yy = 9 THEN GOTO kingGen
  IF SGN(po1(xx, yy)) = toMov THEN GOTO kingGen
  GOTO genMove

castleGen1:
  IF x <> 5 THEN GOTO tgNext
  IF (toMov = 1 AND y <> 1) OR (toMov = -1 AND y <> 8) THEN GOTO tgNext
  dx = -6: dy = 0
castleGen:
  dx = dx + 4: IF dx = 6 THEN GOTO tgNext
  xx = x + dx: yy = y: s = SGN(dx): IF s < 0 THEN xr = 1 ELSE xr = 8
  IF po1(xr, y) <> toMov + toMov + toMov + toMov THEN GOTO castleGen
  IF po1(xx, y) <> 0 OR po1(x + s, y) <> 0 THEN GOTO castleGen
  IF dx = -2 AND po1(x - 3, y) <> 0 THEN GOTO castleGen
  IF th.check(toMov) THEN GOTO tgNext
  p1 = po1(x, y)
  po1(x, y) = 0: po1(x + s, y) = p1: xKing(toMov) = x + s
  ch = th.check(toMov)
  po1(x, y) = p1: po1(x + s, y) = 0: xKing(toMov) = x
  IF ch THEN GOTO castleGen
  GOTO genMove

genMove:
  m.x1 = x: m.y1 = y: m.p1 = po1(x, y): m.p0 = po1(x + dx, y + dy)
  m.x2 = x + dx: m.y2 = y + dy
  mov(de) = m
  th.gen = 1

END FUNCTION

FUNCTION th.genforce

DIM m AS move: m = mov(de)
IF m.p1 = 0 THEN
  x = 0: IF toMov = 1 THEN y = 1 ELSE y = 8
forceNext:
  DO
    x = x + 1
    IF x = 9 THEN
      x = 1: y = y + toMov
      IF y = 0 OR y = 9 THEN mov(de).p0 = 0: mov(de).p1 = 0: EXIT FUNCTION
    END IF
  LOOP UNTIL SGN(po1(x, y)) = toMov

  SELECT CASE ABS(po1(x, y))
  CASE pawn: GOTO forcePawn1
  CASE knight: xx = x - 1: yy = y - 2: GOTO forceKnight1
  CASE bishop: xx = x: yy = y: sx = -1: sy = -1: GOTO forceBishop1
  CASE rook: xx = x: yy = y: sx = -1: sy = 0: GOTO forceRook1
  CASE queen: xx = x: yy = y: sx = -1: sy = -1: GOTO forceQueen1
  CASE king: sx = -2: sy = -1: GOTO forceKing
  CASE ELSE: PRINT "tgf2": STOP
  END SELECT
END IF

x = m.x1: y = m.y1: xx = m.x2: yy = m.y2
sx = SGN(xx - x): sy = SGN(yy - y)

SELECT CASE ABS(po1(x, y))
CASE pawn
  IF xx < x THEN GOTO forcePawn2 ELSE IF xx > x THEN GOTO forcePawn3
  GOTO forceNext
forcePawn1:
  yy = y + toMov
  IF x > 1 THEN IF SGN(po1(x - 1, yy)) = -toMov THEN xx = x - 1: GOTO forceGen
forcePawn2:
  IF x < 8 THEN IF SGN(po1(x + 1, yy)) = -toMov THEN xx = x + 1: GOTO forceGen
forcePawn3:
  IF yy <> 1 AND yy <> 8 THEN GOTO forceNext
  IF po1(x, yy) THEN GOTO forceNext
  xx = x
CASE knight
forceKnight:
  IF xx > x THEN
    yy = yy + 1
    IF yy = y THEN yy = y + 1 ELSE IF yy = y + 3 THEN GOTO forceNext
    xx = x + ABS(yy - y) - 3
  ELSE xx = x + x - xx
  END IF
forceKnight1:
  IF xx < 1 OR xx > 8 OR yy < 1 OR yy > 8 THEN GOTO forceKnight
  IF SGN(po1(xx, yy)) <> -toMov THEN GOTO forceKnight
CASE bishop
forceBishop:
  IF sx = -1 AND sy = 1 THEN GOTO forceNext
  SWAP sx, sy: sx = -sx: xx = x: yy = y
forceBishop1:
  xx = xx + sx: yy = yy + sy
  IF xx = 0 OR xx = 9 OR yy = 0 OR yy = 9 THEN GOTO forceBishop
  p = po1(xx, yy): IF p = 0 THEN GOTO forceBishop1
  IF SGN(p) = toMov THEN GOTO forceBishop
CASE rook
forceRook:
  IF sy = 1 THEN GOTO forceNext
  xx = x: yy = y: SWAP sx, sy: sx = -sx
forceRook1:
  xx = xx + sx: yy = yy + sy
  IF xx = 0 OR xx = 9 OR yy = 0 OR yy = 9 THEN GOTO forceRook
  p = po1(xx, yy)
  IF p = 0 THEN GOTO forceRook1 ELSE IF SGN(p) = toMov THEN GOTO forceRook
CASE queen
forceQueen:
  sx = sx + 1: IF (sx OR sy) = 0 THEN sx = 1
  IF sx = 2 THEN sx = -1: sy = sy + 1: IF sy = 2 THEN GOTO forceNext
  xx = x: yy = y
forceQueen1:
  xx = xx + sx: yy = yy + sy
  IF xx = 0 OR xx = 9 OR yy = 0 OR yy = 9 THEN GOTO forceQueen
  p = po1(xx, yy)
  IF p = 0 THEN GOTO forceQueen1 ELSE IF SGN(p) = toMov THEN GOTO forceQueen
CASE king
forceKing:
  sx = sx + 1
  IF sx = 2 THEN sx = -1: sy = sy + 1: IF sy = 2 THEN GOTO forceNext
  IF sx = 0 AND sy = 0 THEN sx = 1
  xx = x + sx: yy = y + sy
  IF xx = 0 OR xx = 9 OR yy = 0 OR yy = 9 THEN GOTO forceKing
  IF SGN(po1(xx, yy)) <> -toMov THEN GOTO forceKing
CASE ELSE: PRINT "tgf": STOP
END SELECT

forceGen:
  m.x1 = x: m.y1 = y: m.x2 = xx: m.y2 = yy
  m.p1 = po1(x, y): m.p0 = po1(xx, yy)
  mov(de) = m
  th.genforce = 1

END FUNCTION

SUB th.improve

value(de) = value(de + 1)
tree.sort
IF de THEN EXIT SUB
value0 = value(0): tiBest = tiCur(toMov0)
IF bAnalysis THEN win.text txtBest

END SUB

SUB th.mate

mov(de).p1 = 0
WHILE th.gen
  IF ABS(mov(de).p0) = king THEN EXIT SUB
  th.down
  ch = th.check(-toMov): th.up
  IF ch = 0 THEN EXIT SUB
WEND

IF th.check(toMov) THEN
  value(de) = -1000 * (30 - de) * toMov
ELSE value(de) = 0
END IF

END SUB

SUB th.newphase

FOR y = 1 TO 8: FOR x = 1 TO 8
  p = po1(x, y): dm = valPi(p, x, y)
  IF p > 0 THEN w = w + dm ELSE B = B + dm
NEXT x, y
mater(toMov, 0) = w: mater(-toMov, 0) = B

deMin = deMin + 1: deMax = deMin + 4
IF deMax > 30 THEN deMax = 30
IF deMin > deMax THEN deMin = deMax

toMov = toMov0
FOR de = -2 TO 0: value(de) = -toMov * 32767: toMov = -toMov: NEXT de
de = 0: toMov = toMov0: iMov0 = 0
mov(0).p1 = 0
iTree(-1) = 1: iTree(0) = 0: iTreeP(0) = 0: outTree(0) = 0
FOR x = 1 TO 8: FOR y = 1 TO 8: po1(x, y) = po0(x, y): NEXT y, x
xKing(1) = xKing0(1): yKing(1) = yKing0(1)
xKing(-1) = xKing0(-1): yKing(-1) = yKing0(-1)

IF bAnalysis THEN win.text txtDepth
IF report THEN PRINT #fiReport, "": PRINT #fiReport, "+++"; deMin; "+++";

END SUB

SUB th.newpos

depth0$ = depth$: move0$ = move$: value0$ = value$: timer0$ = timer$
bestvar0$ = bestvar$
vTree = 1: treeChild(1) = 0: iTree(-1) = 1: iTree(0) = 0: iTreeP(0) = 0
value0 = 0
tiCur(toMov0) = 0
best.p1 = 0: choice.p1 = 0: game(deGame).p1 = 0
FOR y = 1 TO 8: FOR x = 1 TO 8
  po1(x, y) = po0(x, y)
  p = po0(x, y): IF ABS(p) = king THEN xKing0(SGN(p)) = x: yKing0(SGN(p)) = y
NEXT x, y
deMin = 0
th.newphase
n = 0: m = 1
DO WHILE th.gen
  n = n + 1
  th.down
  ch = th.check(-toMov)
  th.up
  IF ch = 0 THEN m = 0
LOOP
nMov0 = n
mov(0).p1 = 0
deMin = 0
th.newphase

IF m THEN
  thinkMode = 0: clockGo = 0
  IF th.check(toMov0) THEN
    game(deGame - 1).check = 2
  ELSE game(deGame - 1).check = -1
  END IF
END IF

win.text txtStatus

IF nMov0 = 0 THEN
  thinkMode = 0
  IF th.check(toMov0) THEN
    game(deGame - 1).check = 2
  ELSE game(deGame - 1).check = -1
  END IF
END IF

win.text txtMoves
IF bAnalysis THEN win.text analysis

END SUB

SUB th.up

de = de - 1: toMov = -toMov

DIM m AS move: m = mov(de)

IF de = deMin THEN
  IF value(de + 1) <> -1000 * (30 - de) * toMov THEN nomate = 1
END IF

po1(m.x1, m.y1) = m.p1: po1(m.x2, m.y2) = m.p0

IF ABS(m.p1) = king THEN
  xKing(toMov) = m.x1: yKing(toMov) = m.y1
  IF ABS(m.x2 - m.x1) = 2 THEN
    IF m.x2 - m.x1 = 2 THEN x1 = 8: x2 = 6 ELSE x1 = 1: x2 = 4
    po1(x2, m.y1) = 0: po1(x1, m.y1) = toMov * rook
  END IF
END IF

END SUB

SUB th.value

value = mater(toMov, de) + mater(-toMov, de) + rnd6(iRnd) - 3
iRnd = iRnd + 1: IF iRnd > 99 THEN iRnd = 0

FOR s = -1 TO 1 STEP 2
  x = xKing(s): y = yKing(s)
  IF ABS(mater(-s, de)) > 1250 THEN
    p = s * king
    dv2 = 5 * s: dv1 = dv2 + dv2
    x1 = x - 1: y1 = y - 1: x2 = x + 1: y2 = y + 1
    IF x1 < 1 THEN x1 = 1 ELSE IF x2 > 8 THEN x2 = 8
    IF y1 < 1 THEN y1 = 1 ELSE IF y2 > 8 THEN y2 = 8
    FOR xx = x1 TO x2: FOR yy = y1 TO y2
      IF po1(xx, yy) = s THEN value = value + dv1
    NEXT yy, xx
    value = value + (9 - (x2 - x1 + 1) * (y2 - y1 + 1)) * dv2
  ELSE
    value = value + s * valKing(x, y)
  END IF
NEXT s

value(de) = value

END SUB

FUNCTION tree.read

IF iTree(de) THEN iTreeP(de) = iTree(de)
IF outTree(de) THEN EXIT FUNCTION
IF iTree(de) <= 0 THEN
  IF iTree(de - 1) = 0 THEN outTree(de) = 1: EXIT FUNCTION
  iTree(de) = treeChild(iTree(de - 1))
  IF iTree(de) = 0 THEN outTree(de) = 1: EXIT FUNCTION
ELSE
  iTree(de) = treeNext(iTree(de))
  IF iTree(de) <= 0 THEN
    IF iTree(de) = -32768 THEN EXIT FUNCTION
    outTree(de) = 1: move.extr -iTree(de), mov(de)
    EXIT FUNCTION
  END IF
END IF
tree.read = 1
move.extr treeMov(iTree(de)), mov(de)

END FUNCTION

SUB tree.show

CONST dmax = 6
win.mouse 2: LINE (0, 0)-(640, 480), 7, BF
FOR y = 1 TO 8: FOR x = 1 TO 8: SWAP po1(x, y), po0(x, y): NEXT x, y
DIM mo(0 TO dmax) AS move, mov AS move
DIM m$(0 TO dmax, 1 TO 30), im(-1 TO dmax, 1 TO 30), cy(-1 TO dmax)
d = 0: im(-1, 1) = 1: cy(-1) = 1: cy(0) = 1
DO
  i = treeChild(im(d - 1, cy(d - 1))): ymax = 0: x = 1 + d * 12
  FOR y = 1 TO 30
    LOCATE y, x: IF y = cy(d) THEN COLOR 9 ELSE COLOR 7
    IF i > 0 THEN
      move.extr treeMov(i), mov: PRINT alex.notat(mov); STR$(i);
      im(d, y) = i: i = treeNext(i): ymax = y
    END IF
    PRINT TAB(x + 11);
  NEXT
 
  DO: k$ = INKEY$: LOOP WHILE k$ = ""
  IF LEN(k$) = 2 THEN k$ = "_" + RIGHT$(k$, 1)
  SELECT CASE UCASE$(k$)
  CASE CHR$(27):
    IF d = 0 THEN
      FOR y = 1 TO 8: FOR x = 1 TO 8: SWAP po1(x, y), po0(x, y): NEXT x, y
      win.mouse 1: win.show all: EXIT SUB
    END IF
  CASE "_H": IF cy(d) > 1 THEN cy(d) = cy(d) - 1
  CASE "_P": IF cy(d) < ymax THEN cy(d) = cy(d) + 1
  CASE "_M":
    IF treeChild(im(d, cy(d))) AND d < dmax THEN
      move.extr treeMov(im(d, cy(d))), mo(d)
      po1(mo(d).x1, mo(d).y1) = 0: po1(mo(d).x2, mo(d).y2) = mo(d).p1
      d = d + 1: cy(d) = 1
    END IF
  CASE "_K":
    IF d THEN
      LINE (d * 96, 0)-(d * 96 + 95, 480), 7, BF: d = d - 1
      po1(mo(d).x1, mo(d).y1) = mo(d).p1: po1(mo(d).x2, mo(d).y2) = mo(d).p0
    END IF
  END SELECT
LOOP

END SUB

SUB tree.sort

IF iTree(de) = 0 OR iTreeP(de) = 0 OR iTree(de - 1) = 0 THEN EXIT SUB
treeNext(iTreeP(de)) = treeNext(iTree(de))
treeNext(iTree(de)) = treeChild(iTree(de - 1))
treeChild(iTree(de - 1)) = iTree(de)
iTree(de) = iTreeP(de)
iTreeP(de) = 0

END SUB

SUB tree.write

IF vTree = maxTree THEN iTreeP(de) = -1: iTree(de) = 0: EXIT SUB
vTree = vTree + 1
move.pack mov(de), treeMov(vTree)
treeNext(vTree) = -treeMov(vTree): treeChild(vTree) = 0
iTree(de) = vTree
IF iTreeP(de) THEN
  treeNext(iTreeP(de)) = vTree
ELSE treeChild(iTree(de - 1)) = vTree
END IF

END SUB

SUB win.click (menu, item)

SELECT CASE menu
CASE menu.alex
  SELECT CASE item
  CASE 1 TO 3
    IF thinkMode THEN gameMode = item: thinkMode = 2: win.text txtMoves
  CASE 4:
    win.mouse 2
    win.draw 4, 10, 40, 5, 1
    LOCATE 12, 7: PRINT "  ணࠬ  " + Author$
    LOCATE 13, 7: PRINT "   몥 Quick Basic 4.5"
    LOCATE 14, 7: PRINT "        -, 1999-2001."
    win.mouse 1
    DO: win.mouse 3: LOOP WHILE mouse.btn
    DO: win.mouse 3: LOOP UNTIL INKEY$ <> "" OR mouse.btn
    win.show board
  CASE 5:
    OPEN "config.alx" FOR OUTPUT AS #fiConfig
    PRINT #fiConfig, "Mode ="; gameMode: PRINT #fiConfig, "Level ="; levelMode
    PRINT #fiConfig, "Invert ="; bInvert
    PRINT #fiConfig, "Sound ="; bSound: PRINT #fiConfig, "Animat ="; bAnimat
    PRINT #fiConfig, "Analysis ="; bAnalysis: PRINT #fiConfig, "Clock ="; bClock
    CLOSE #fiConfig: END
  END SELECT
CASE menu.game
  SELECT CASE item
  CASE 1: alex.newgame
  CASE 2
    IF thinkMode THEN
      thinkMode = 1: clockGo = 1: win.text txtMoves
      IF choice.p1 THEN draw.square choice.x1, choice.y1
    END IF
  CASE 3: IF thinkMode THEN thinkMode = 1: alex.move
  END SELECT
CASE menu.level
  SELECT CASE item
  CASE 1: level = 0: CASE 2: level = 10: CASE 3: level = 20
  CASE 4: level = 50: CASE 5: level = 100: CASE 6: level = 300
  CASE 7: level = 600: CASE 8: level = 1200
  END SELECT
  levelMode = item: win.text txtLevel
CASE menu.display
  SELECT CASE item
  CASE 1: bInvert = -(bInvert = 0): win.show board
  CASE 2: bSound = -(bSound = 0)
  CASE 3: bAnimat = -(bAnimat = 0)
  CASE 4: bAnalysis = -(bAnalysis = 0): win.show analysis
  CASE 5: bClock = -(bClock = 0): win.show mainmenu
  END SELECT
CASE ELSE: PRINT "wc": STOP
END SELECT

END SUB

SUB win.close
 
iMenu = 0: iItem = 0
win.mouse 2
LINE (xMenu, 15)-STEP(wMenu, hMenu), 8, BF
PUT (xMenu, 15), menuBuf, PSET
win.show mainmenu: win.text txtTime
win.mouse 1

END SUB

SUB win.draw (x, y, w, h, fill)

x1 = x * 8: y1 = y * 16
x2 = x1 + w * 8 - 1: y2 = y1 + h * 16 - 1
LINE (x1 - 2, y1 - 2)-(x2 + 2, y2 + 2), 7, B
LINE (x1 - 1, y1 - 1)-(x2 + 1, y2 + 1), 8, B
IF fill THEN LINE (x1, y1)-(x2, y2), 7, BF

END SUB

SUB win.mouse (action)

mouse.act = action
CALL interrupt(&H33, mouse, mouse)

END SUB

SUB win.show (wnd)

win.mouse 2
SELECT CASE wnd
CASE all:
  LINE (0, 0)-(640, 480), 8, BF: COLOR 7: LINE (0, 17)-(639, 479), , B
  win.show mainmenu: win.show board: win.show moves: win.show status
  win.show moveback: win.show movenext: win.show book: win.show analysis
CASE mainmenu:
  win.draw 0, 0, 80, 1, 1
  RESTORE Menus: LOCATE 1, 2
  DO: READ m$: PRINT " "; m$; " "; : LOOP UNTIL m$ = ""
  IF bClock THEN win.text txtClock
CASE board:
  win.draw 2, 2, 44, 22, 0
  FOR y = 8 TO 1 STEP -1: FOR x = 1 TO 8: draw.square x, y: NEXT: NEXT
CASE moves:
  win.draw 48, 2, 19, 18, 1
  win.text txtMoves
CASE moveback:
  win.draw 48, 21, 4, 3, 1: PSET (390, 359), 0
  DRAW "e9d6r9d6l9d6h9bre8bd16h8"
CASE movenext:
  win.draw 74, 21, 4, 3, 1: PSET (599, 359), 0
  DRAW "u3r9u6f9g9u6l9u3 br17h8bd16e7"
CASE status:
  win.draw 54, 21, 18, 3, 1: win.text txtLevel
  LOCATE 23, 64: PRINT "/ᥪ": LOCATE 24, 58: PRINT ":"
  win.text txtStatus
CASE book:
  win.draw 69, 2, 9, 18, 1
CASE analysis:
  win.draw 2, 25, 76, 4, 1: IF bAnalysis THEN win.text analysis
CASE ELSE: PRINT "ws": STOP
END SELECT
win.mouse 1

END SUB

SUB win.text (wnd)

win.mouse 2
SELECT CASE wnd
CASE txtClock
  LOCATE 1, 74: PRINT LEFT$(TIME$, 5)
CASE txtTime
  win.text txtTimeW1: win.text txtTimeB1
  win.text txtTimeW2: win.text txtTimeB2
CASE txtTimeW1: LOCATE 4, 51: PRINT fnTime$(tiAll(1));
CASE txtTimeB1: LOCATE 4, 60: PRINT fnTime$(tiAll(-1));
CASE txtTimeW2: LOCATE 5, 51: PRINT fnTime$(tiCur(1));
CASE txtTimeB2: LOCATE 5, 60: PRINT fnTime$(tiCur(-1));
CASE txtLevel: LOCATE 22, 56: l = level \ 10: IF l < 10 THEN PRINT " ";
  IF l < 60 THEN PRINT l; "ᥪ  室";  ELSE PRINT " "; l \ 60; "  室"
CASE txtStatus
  LOCATE 23, 63 - LEN(STR$(veloc)): PRINT veloc - veloc MOD 1000;
  LOCATE 24, 65: PRINT STR$(100& * vTree \ maxTree); "%  ";
CASE analysis
  LOCATE 26, 4: PRINT ":"; : LOCATE , 30: PRINT "㡨:";
  LOCATE , 47: PRINT "業:"; : LOCATE , 64: PRINT "६:";
  LOCATE 27, 4: PRINT "襥:";
  IF bestvar0$ <> "" THEN
    LOCATE 28, 4: PRINT ":"; : LOCATE , 30: PRINT "㡨:";
    LOCATE , 47: PRINT "業:"; : LOCATE , 64: PRINT "६:";
    LOCATE 29, 4: PRINT "襥:";
  END IF
  win.text txtDepth: win.text txtMove: win.text txtBest
  win.text txtAnalysis0
CASE txtAnalysis0
  IF bestvar0$ <> "" THEN
    LOCATE 28, 12: PRINT move0$; : LOCATE , 39: PRINT depth0$;
    LOCATE , 55: PRINT value0$; : LOCATE , 71: PRINT timer0$;
    LOCATE 29, 12: PRINT bestvar0$; TAB(79);
  END IF
CASE txtDepth
  depth$ = CHR$(48 + deMin \ 10) + CHR$(48 + deMin MOD 10) + CHR$(26)
  depth$ = depth$ + CHR$(48 + deMax \ 10) + CHR$(48 + deMax MOD 10)
  LOCATE 26, 39: PRINT depth$;
CASE txtMove
  move$ = LEFT$(alex.notat$(mov(0)) + "     ", 8)
  move$ = move$ + "(" + CHR$(48 + iMov0 \ 10) + CHR$(48 + iMov0 MOD 10)
  move$ = move$ + "/" + CHR$(48 + nMov0 \ 10) + CHR$(48 + nMov0 MOD 10) + ")"
  LOCATE 26, 12: PRINT move$;
CASE txtBest
  LOCATE 27, 12: bestvar$ = ""
  d = 0: i = treeChild(1)
  DIM mov AS move
  DO WHILE i <> 0 AND d < deMin
    move.extr treeMov(i), mov
    n$ = CHR$(96 + mov.x1) + CHR$(48 + mov.y1) + CHR$(96 + mov.x2) + CHR$(48 + mov.y2)
    bestvar$ = bestvar$ + n$ + " "
    d = d + 1: i = treeChild(i)
  LOOP
  PRINT bestvar$; TAB(79);
  IF SGN(toMov0 * value0) = 1 THEN value$ = "+" ELSE value$ = "-"
  IF ABS(value0) < 10000 THEN
    v = ABS(value0): vh = v \ 100: vl = v MOD 100
    value$ = value$ + CHR$(48 + vh \ 10) + CHR$(48 + vh MOD 10) + "."
    value$ = value$ + CHR$(48 + vl \ 10) + CHR$(48 + vl MOD 10)
  ELSE n = 15 - ABS(value0) \ 2000
    value$ = value$ + "" + CHR$(48 + n \ 10) + CHR$(48 + n MOD 10)
  END IF
  timer$ = fnTime$(tiBest)
  LOCATE 26, 55: PRINT value$; : LOCATE , 71: PRINT timer$;
CASE txtMoves
  SELECT CASE gameMode
  CASE 1:
    IF (toMov0 = 1 AND thinkMode = 2) OR (toMov0 = -1 AND thinkMode = 1) THEN
      opp$ = "ப    " + alex$
    ELSE : opp$ = alex$ + "    ப"
    END IF
  CASE 2: opp$ = "ப    ப"
  CASE 3: opp$ = alex$ + "    " + alex$
  END SELECT
 
  LOCATE 3, 52: PRINT opp$
  win.text txtTime
  m0 = (deGame \ 2) * 2 - 26: IF m0 < 0 THEN m0 = 0
  FOR i = 0 TO 27
    y = i \ 2 + 7
    x = 53 + 8 * (i MOD 2)
    IF m0 + i < deGame THEN t$ = alex.notat(game(m0 + i)) ELSE t$ = ""
    IF (i MOD 2) = 0 THEN
      LOCATE y, 49
      IF m0 + i <= deGame THEN
        PRINT RIGHT$("  " + STR$((m0 + i) \ 2 + 1), 3); "."
      ELSE PRINT "    "
      END IF
    END IF
    LOCATE y, x: PRINT t$; TAB(x + 7);
  NEXT
CASE ELSE: PRINT "wt": STOP
END SELECT

win.mouse 1

END SUB

