{$X+}
Program Arkanoid;
Uses Graph, Crt, Dos;
Const
  Left=75;
  Right=77;
  Up=#72;
  Down=#80;
  Enter=#13;
  Esc=1;
  Space=57;
  MaxLevel=10;
  Tab1: Array[1..14, 1..14] Of Byte =
        ((4,4,4,0,0,0,0,0,0,0,0,4,4,4),
         (0,1,0,0,0,0,0,0,0,0,0,0,1,0),
         (1,2,1,4,4,4,3,3,4,4,4,1,2,1),
         (0,1,0,0,1,0,0,0,0,1,0,0,1,0),
         (4,4,4,1,4,1,0,0,1,4,1,4,4,4),
         (0,0,0,0,1,0,0,0,0,1,0,0,0,0),
         (0,0,0,4,4,4,0,0,4,4,4,0,0,0),
         (0,0,0,0,1,0,0,0,0,1,0,0,0,0),
         (0,0,0,1,4,1,0,0,1,4,1,0,0,0),
         (4,4,4,0,1,0,0,0,0,1,0,4,4,4),
         (0,1,0,4,4,4,3,3,4,4,4,0,1,0),
         (1,2,1,0,0,0,0,0,0,0,0,1,2,1),
         (0,1,0,0,0,0,0,0,0,0,0,0,1,0),
         (4,4,4,0,0,0,0,0,0,0,0,4,4,4));
  Tab2: Array[1..14, 1..14] Of Byte =
        ((0,0,1,0,0,0,0,0,0,0,0,1,0,0),
         (0,1,2,1,0,0,0,0,0,0,1,2,1,0),
         (4,4,4,4,4,0,0,0,0,4,4,4,4,4),
         (0,0,0,0,0,6,0,0,6,0,0,0,0,0),
         (0,0,0,0,0,0,1,1,0,0,0,0,0,0),
         (0,0,0,0,0,1,2,2,1,0,0,0,0,0),
         (0,0,0,0,4,4,4,4,4,4,0,0,0,0),
         (0,0,0,6,0,0,0,0,0,0,6,0,0,0),
         (0,0,1,0,0,0,0,0,0,0,0,1,0,0),
         (0,1,4,1,0,0,0,0,0,0,1,4,1,0),
         (4,4,4,4,4,6,6,6,6,4,4,4,4,4),
         (0,1,6,1,0,0,0,0,0,0,1,6,1,0),
         (0,0,1,0,0,0,0,0,0,0,0,1,0,0),
         (0,0,0,0,0,0,0,0,0,0,0,0,0,0));
  Tab3: Array[1..14, 1..14] Of Byte =
        ((0,1,3,3,3,3,0,0,3,3,3,3,1,0),
         (1,2,1,3,3,0,0,0,0,3,3,1,2,1),
         (0,1,0,0,1,0,0,0,0,1,0,0,1,0),
         (0,0,0,1,2,1,0,0,1,2,1,0,0,0),
         (0,0,0,3,1,3,0,0,3,1,3,0,0,0),
         (0,1,0,0,3,0,0,0,0,3,0,0,1,0),
         (1,2,1,0,3,0,0,0,0,3,0,1,2,1),
         (0,1,0,0,3,0,0,0,0,3,0,0,1,0),
         (0,0,0,1,2,1,0,0,1,2,1,0,0,0),
         (0,0,0,0,1,0,0,0,0,1,0,0,0,0),
         (0,0,0,0,0,0,0,0,0,0,0,0,0,0),
         (1,3,2,3,5,3,3,3,5,3,1,3,2,3),
         (3,3,3,3,3,1,2,1,3,3,3,3,3,3),
         (0,0,0,0,0,0,0,0,0,0,0,0,0,0));
  Tab4: Array[1..14, 1..14] Of Byte =
        ((0,0,0,0,0,0,1,1,0,0,0,0,0,0),
         (0,1,2,1,0,0,1,1,0,0,1,2,1,0),
         (0,0,0,0,0,0,1,1,0,0,0,0,0,0),
         (0,1,2,1,0,0,1,1,0,0,1,2,1,0),
         (0,0,0,0,0,0,1,1,0,0,0,0,0,0),
         (0,1,2,1,0,0,1,1,0,0,1,2,1,0),
         (0,0,0,0,0,0,1,1,0,0,0,0,0,0),
         (0,1,2,1,0,0,1,1,0,0,1,2,1,0),
         (0,0,0,0,0,0,1,1,0,0,0,0,0,0),
         (4,4,4,4,4,6,6,6,6,4,4,4,4,4),
         (0,0,0,0,0,0,0,0,0,0,0,0,0,0),
         (1,6,1,4,4,4,4,4,4,4,4,1,6,1),
         (0,0,0,0,0,0,0,0,0,0,0,0,0,0),
         (0,0,0,0,0,0,0,0,0,0,0,0,0,0));
  Tab5: Array[1..14, 1..14] of Byte =
        ((0,4,4,0,0,0,0,0,0,0,0,4,4,0),
         (0,0,2,2,0,0,0,0,0,0,2,2,0,0),
         (0,0,0,2,2,0,0,0,0,2,2,0,0,0),
         (0,0,0,0,2,2,0,0,2,2,0,0,0,0),
         (0,0,0,0,1,1,1,1,1,1,0,0,0,0),
         (0,0,0,1,1,1,1,1,1,1,1,0,0,0),
         (0,0,1,1,2,2,2,2,2,2,1,1,0,0),
         (0,1,1,2,2,2,2,2,2,2,2,1,1,0),
         (1,1,2,4,2,4,2,4,2,4,2,4,1,1),
         (1,1,2,2,2,2,2,2,2,2,2,2,1,1),
         (0,1,1,2,2,2,2,2,2,2,2,1,1,0),
         (0,0,1,1,2,2,2,2,2,2,1,1,0,0),
         (0,0,0,1,1,1,1,1,1,1,1,0,0,0),
         (0,0,0,0,1,1,1,1,1,1,0,0,0,0));

  Tab6: Array[1..14, 1..14] Of Byte =
        ((0,6,0,0,3,3,3,3,3,3,0,0,6,0),
         (0,0,0,3,3,3,3,3,3,3,3,0,0,0),
         (0,0,0,3,3,5,3,3,5,3,3,0,0,0),
         (0,6,0,3,3,3,3,3,3,3,3,0,6,0),
         (0,6,0,3,3,5,5,5,5,3,3,0,6,0),
         (0,0,0,3,3,3,5,5,3,3,3,0,0,0),
         (0,6,0,0,3,3,3,3,3,3,0,0,0,0),
         (0,6,0,0,0,3,3,3,3,0,0,0,6,0),
         (0,6,0,0,0,0,0,0,0,0,0,0,6,0),
         (0,0,0,0,4,0,0,4,0,4,0,0,0,0),
         (0,6,0,0,4,0,0,4,0,0,0,0,6,0),
         (6,6,6,0,4,4,4,4,0,4,0,6,6,6),
         (0,6,0,0,4,0,0,4,0,4,0,0,6,0),
         (0,0,0,0,4,0,0,4,0,4,0,0,0,0));
  Tab7: Array[1..14, 1..14] Of Byte =
        ((0,1,1,0,1,1,0,1,0,1,0,0,1,1),
         (1,0,1,0,1,0,0,1,0,1,0,1,0,1),
         (1,0,1,0,1,1,0,1,1,1,0,1,1,1),
         (1,0,1,0,1,0,0,1,0,1,0,1,0,1),
         (1,0,1,0,1,1,0,1,0,1,0,1,0,1),
         (0,0,0,0,0,0,0,0,0,0,0,0,0,0),
         (0,0,0,0,4,4,0,4,4,2,0,0,0,0),
         (0,0,0,4,4,4,4,4,4,2,2,0,0,0),
         (0,0,0,4,4,4,4,4,2,4,0,0,0,0),
         (0,0,0,4,4,4,4,2,4,4,0,0,0,0),
         (0,0,0,4,4,4,4,4,4,4,0,0,0,0),
         (0,0,0,0,4,4,4,4,4,0,0,0,0,0),
         (0,0,0,0,2,4,4,4,0,0,0,0,0,0),
         (0,0,0,2,0,0,4,0,0,0,0,0,0,0));
  Tab8: Array[1..14, 1..14] Of Byte =
        ((0,0,0,0,0,0,0,0,5,5,5,5,0,0),
         (0,0,0,0,0,0,0,5,5,5,5,5,5,5),
         (5,0,0,0,0,0,5,5,4,5,5,6,5,5),
         (5,0,5,0,5,5,5,4,4,5,5,6,6,5),
         (0,0,5,5,5,5,5,4,4,5,5,6,6,5),
         (4,0,0,0,0,0,5,4,5,5,5,5,6,5),
         (4,0,4,0,4,4,5,5,5,5,5,5,5,5),
         (0,0,4,4,4,4,5,5,3,5,5,2,5,5),
         (3,0,0,0,0,0,5,3,3,5,5,2,2,5),
         (3,0,3,0,3,3,5,3,3,5,5,2,2,5),
         (0,0,3,3,3,3,5,3,5,5,5,5,2,5),
         (5,0,0,0,0,0,5,5,5,5,5,5,5,5),
         (5,0,5,7,5,5,5,5,0,0,0,0,5,5),
         (0,0,5,5,5,5,0,0,0,0,0,0,0,0));
  Tab9: Array[1..14, 1..14] Of Byte =
        ((3,3,3,0,0,0,6,6,0,0,0,3,3,3),
        (3,3,0,0,0,6,2,2,6,0,0,0,3,3),
        (0,0,0,0,6,6,6,6,6,6,0,0,0,0),
        (0,0,6,6,0,6,6,6,6,0,6,6,0,0),
        (0,6,6,6,6,0,6,6,0,6,6,6,6,0),
        (6,6,6,6,6,6,6,6,6,6,6,6,6,6),
        (0,6,2,2,6,0,2,2,0,6,2,2,6,0),
        (0,0,6,6,0,0,4,4,0,0,6,6,0,0),
        (0,0,0,0,0,0,2,2,0,0,0,0,0,0),
        (0,0,0,0,0,0,4,4,0,0,0,0,0,0),
        (0,0,0,0,0,0,2,2,0,0,0,0,0,0),
        (0,0,0,0,0,0,4,4,0,0,0,0,0,0),
        (0,0,0,0,0,0,2,2,0,0,0,0,0,0),
        (4,4,4,4,4,4,4,4,4,4,4,4,4,4));
  Tab10: Array[1..14, 1..14] Of Byte =
         ((0,0,0,0,0,0,0,0,0,0,0,0,0,0),
         (0,0,2,2,0,0,4,4,0,0,3,3,0,0),
         (0,2,0,0,2,4,0,0,4,3,0,0,3,0),
         (2,0,0,0,4,2,0,0,3,4,0,0,0,3),
         (0,2,0,0,6,4,0,0,5,5,0,0,3,0),
         (0,0,2,6,0,0,4,5,0,0,5,3,0,0),
         (0,0,6,0,0,0,5,6,0,0,0,5,0,0),
         (0,0,0,6,0,0,6,5,0,0,5,0,0,0),
         (0,0,0,0,6,6,0,0,5,5,0,0,0,0),
         (0,0,0,0,0,0,0,0,0,0,0,0,0,0),
         (4,0,0,0,4,0,4,4,4,0,4,0,0,4),
         (4,0,0,0,4,0,0,4,0,0,4,4,0,4),
         (4,0,4,0,4,0,0,4,0,0,4,0,4,4),
         (0,4,0,4,0,0,4,4,4,0,4,0,0,4));

  TextMove: Boolean = True;
  PaddleStep = 15;
  BrickSizeX=28;
  BrickSizeY=12;

Var
    GrDriver, GrMode: Integer;
    BrickCount, Lives, Level, Score: Integer;
    PaddleX, PaddleY, BallX, BallY, Pause, PauseN: Integer;
    SpeedX, SpeedY: ShortInt;
    Paddle, Ball, P1, P2, P3, P4, P5, P6: Pointer;
    EndGame, SoundPro: Boolean;
    Tab: Array[1..14, 1..14] Of Byte;
    Reg: Registers;
    MouseX, MouseY, MouseXOld, MouseYOld, Button: Integer;
    MenuItem, TimeSound: Byte;
    OldTimer: LongInt;
    SysTimer: Longint Absolute $0040:$006C;

Procedure ClearBuffer;
Begin
  Mem[$0040:$001A]:=$1E;
  Mem[$0040:$001C]:=$1E;
End;

Function IsMouse: Boolean;
Var P: Pointer;
    K, X, Y: Integer;
    Is: Boolean;
Begin
  GetIntVec($33, P);
  Is:=P<>NIL;
  If Is Then
    With Reg Do
      Begin
        Ax:=$3;
        Bx:=$FFFF;
        Intr($33, Reg);
        Is:=Bx<>$FFFF;
      End;
  IsMouse:=Is;
End;

Procedure MouseGotoXY(X, Y: Integer);
Begin
  If IsMouse Then
    With Reg Do
      Begin
        Ax:=$4;
        Cx:=X;
        Dx:=Y;
        Intr($33, Reg);
      End;
End;

Procedure GetMouseState(Var Butt, X, Y: Integer);
Begin
  If IsMouse Then
    With Reg Do
      Begin
        Ax:=$3;
        Intr($33, Reg);
        Butt:=Bx;
        X:=Cx;
        Y:=Dx;
      End
  Else
    Begin
      Butt:=0;
      X:=0;
      Y:=0;
    End;
End;

Procedure NormalDelay(MS:LongInt);
Begin
 If MS>0 Then
   Begin
    MS:=SysTimer+MS;
    While SysTimer<=MS Do;
   End;
 End;

Procedure Options;
Const OptionItems: Array[1..4] Of String[15] = (' ', ' ', '', '');
      K = 45;
      X = 450;
Var   NItem: Byte;
      Y:Word;
      Ch: Char;
      Rate: Array[1..3] Of String[3];

Procedure DrawItem(Item: Byte; Stat: Boolean);
Begin
  Y:=GetMaxY Div 5;
  If Stat Then SetColor(Yellow)
  Else SetColor(LightGreen);
  SetTextStyle(2, 0, 8);
  If Item=1 Then OutTextXY(X+60, Y+K, '%');
    OutTextXY(110, Y+(K*Item), OptionItems[Item]);
  If Item=4 Then
    If SoundPro Then
      Begin
        OutTextXY(X, Y+K*Item, '');
        Setcolor(LightGray);
        OutTextXY(X+60, Y+K*Item, '');
      End
    Else
      Begin
        OutTextXY(X+60, Y+K*Item, '');
        Setcolor(LightGray);
        OutTextXY(X, Y+K*Item, '');
      End
  Else
  OutTextXY(X, Y+K*Item, Rate[Item]);
End;

Procedure ChangeOption(Option: Byte; OK: Boolean);
Begin
  Setcolor(Black);
  SetTextStyle(2, 0, 8);
  If Option<4 Then OutTextXY(X, Y+K*Option, Rate[Option]);
  Case Option Of
    1: Begin
         If OK AND (Rate[1]<>'100') Then PauseN:=PauseN-10;
         If NOT OK AND (Rate[1]<>'0') Then PauseN:=PauseN+10;
         Str(100-(PauseN div 10), Rate[1]);
       End;
    2: Begin
         If OK AND (Lives<500) Then Lives:=Lives+2;
         If NOT OK AND (Lives>1) Then Lives:=Lives-2;
         Str(Lives, Rate[2]);
       End;
    3: Begin
         If OK AND (Level<MaxLevel) Then Level:=Level+1;
         If NOT OK AND (Level>1) Then Level:=Level-1;
         Str(Level, Rate[3]);
       End;
    4: Begin
         If SoundPro Then
           Begin
             SoundPro:=False;
             TimeSound:=0;
           End
         Else
           Begin
             SoundPro:=True;
             TimeSound:=65;
           End;
         DrawItem(4, True);
       End;
    End;
    Setcolor(Yellow);
    If Option<4 Then OutTextXY(X, Y+K*Option, Rate[Option]);
End;

Procedure Draw;
Var Y:Word;
Begin
  SetTextStyle(0, 0, 4);
  SetColor(LightGray);
  OutTextXY(185, GetMaxY Div 12, 'Options');
  SetColor(LightRed);
  OutTextXY(180, GetMaxY Div 12, 'Options');
  SetTextStyle(0, 0, 2);
  Str(100-(PauseN div 10), Rate[1]);
  Str(Lives, Rate[2]);
  Str(Level, Rate[3]);
  DrawItem(1, True);
  DrawItem(2, False);
  DrawItem(3, False);
  DrawItem(4, False);
  SetTextStyle(2,0,5);
  SetColor(LightGray);
  Y:=GetMaxY-40;
  OutTextXY(100, Y, ' ࠬ <-  ->, ६饭  ');
  OutTextXY(250, Y+20, '室: Esc  Enter ');
  Line(515, Y, 515, Y+8);
  Line(515, Y, 512, Y+3);
  Line(515, Y, 518, Y+3);
  Line(525, Y, 525, Y+8);
  Line(525, Y+8, 522, Y+5);
  Line(525, Y+8, 528, Y+5);
End;

Begin
  ClearDevice;
  Draw;
  NItem:=1;
  Repeat
    If KeyPressed Then
      Begin
        Ch:=ReadKey;
        If (Ch=Up) Or (Ch=Down) Then
          Begin
            DrawItem(NItem, False);
            If Ch=Up Then
              If NItem>1 Then NItem:=NItem-1 Else NItem:=4;
            If Ch=Down Then
              If NItem<4 Then NItem:=NItem+1 Else NItem:=1;
            DrawItem(NItem, True);
          End;
        If Ch=#75 Then ChangeOption(Nitem, False);
        If Ch=#77 Then ChangeOption(Nitem, True);
      End;
  Until (Ch=#27) OR (Ch=Enter);
  While KeyPressed Do ReadKey;
  Ch:=#0;
End;

Procedure Help;
Var K: Integer;
Begin
  K:=(GetMaxY-240) Div 5;
  ClearDevice;
  SetColor(White);
  SetLineStyle(0, 0, 3);
  Rectangle(15, 15, GetMaxX-15, GetMaxY-15);
  SetLineStyle(0, 0, 0);
  SetColor(LightGray);
  SetFillStyle(1, LightGray);
  Bar(18, 18, GetMaxX-18, GetMaxY-18);
  PutImage(80, 240+K, P1^, CopyPut);
  PutImage(80, 240+(K*2), P2^, CopyPut);
  PutImage(80, 240+(K*3), P3^, CopyPut);
  PutImage(350, 240+K, P4^, CopyPut);
  PutImage(350, 240+(K*2), P5^, CopyPut);
  PutImage(350, 240+(K*3), P6^, CopyPut);
  SetColor(Blue);
  SetTextStyle(2, 0, 5);
  OutTextXY(130, 240+K, '1 㤠');
  OutTextXY(130, 240+(K*2), '2 㤠');
  OutTextXY(130, 240+(K*3), '3 㤠');
  OutTextXY(400, 240+K, '4 㤠');
  OutTextXY(400, 240+(K*2), '5 㤠஢');
  OutTextXY(400, 240+(K*3), '6 㤠஢');
  OutTextXY(20,  40, '                         ARKANOID');
  OutTextXY(20,  80, '  ࠢ ମ: <- ->.  誮.');
  OutTextXY(20, 100, '   稪  : Space    誨.');
  OutTextXY(20, 120, '  室  : Esc.');
  OutTextXY(20, 160, '  ࠢ ମ,   稪 뫥   ࠭ ࠭.');
  OutTextXY(20, 180, '   室  ᫥騩 ஢ 室 롨  ௨稪.');
  OutTextXY(20, 220, '  म ௨稪    梥.');
  OutTextXY(20, 240, '  ᫮  稪   㭨⮦ ௨稪:');
  Repeat
    GetMouseState(Button, MouseX, MouseY);
  Until (KeyPressed) Or ((IsMouse) And (Button<>0));
  While KeyPressed Do ReadKey;
  While (IsMouse) And (Button<>0) Do GetMouseState(Button, MouseX, MouseY);
End;

Procedure Tone(Hz: Integer; Ms: Integer);
Begin
  Sound(Hz);
  NormalDelay(Ms);
  NoSound;
End;

Procedure Tone1(Hz: Integer; Ms: Integer);
Begin
  Sound(Hz);
  Delay(Ms);
  NoSound;
End;

Procedure Intro;
Var X, Y: Integer;
Const
   Notes: Array[1..8] Of Byte =
   (131, 175, 147, 196, 147, 196, 220, 175);
   ArkStr: String[8] = 'Arkanoid';
   ArkPos: Array[1..8] Of Integer =
   (51, 114, 178, 242, 306, 371, 436, 501);
Procedure DrawLetter(N: Byte);
Begin
  OutTextXY(ArkPos[N], 110, ArkStr[N]);
  NormalDelay(3);
  Tone(Notes[N], 2);
End;
Begin
  SetFillStyle(1, 4);
  Bar(0, 0, GetMaxX, GetMaxY);
  SetColor(Black);
  For Y:=1 To ((GetMaxY+1) Div 18) Do Line(0, Y*18, GetMaxX, Y*18);
  X:=0;
  Y:=0;
  Repeat
    Repeat
      Line(X, Y, X, Y+18);
      Line(X-17, Y+18, X-17, Y+36);
      X:=X+35;
    Until X>GetMaxX+18;
    X:=0;
    Y:=Y+36;
  Until Y>GetMaxY+15;
  SetColor(Yellow);
  OutTextXY(200, GetMaxY-80, 'Made by Kropochkina Lena 1999, 2001');
  OutTextXY(240, GetMaxY-60, 'All rights reserved');
  SetTextStyle(0, 0, 8);
  Repeat
    SetColor(LightGray);
    OutTextXY(51, 110, ArkStr);
    NormalDelay(1);
    SetColor(Yellow);
    X:=0;
    Repeat
      GetMouseState(Button, MouseX, MouseY);
      X:=X+1;
      DrawLetter(X);
    Until (KeyPressed) Or (X=8) Or ((IsMouse) And (Button<>0));
  Until (KeyPressed) Or ((IsMouse) And (Button<>0));
  While KeyPressed Do ReadKey;
  While (IsMouse) And (Button<>0) Do GetMouseState(Button, MouseX, MouseY);
End;

Procedure GameOver;
Var Pk, Xg, Color, F: Integer;
    CurPos: Boolean;
    Mass_K: Array[1..6] Of Integer;
Procedure Picture(Yo, Xo: Integer);
Begin
  Xo:=Mass_K[F]-15;
  SetColor(Color);
  Circle(Xo, Yo, 3);
  SetFillStyle(1, Color);
  FloodFill(Xo, Yo, Color);
  SetColor(0);
  Circle(Xo, Yo, 3);
  SetFillStyle(1, 0);
  FloodFill(Xo, Yo, 0);
  If Xo<=0 Then Xo:=GetMaxX;
  Mass_K[F]:=Xo;
  F:=F+1;
  If F=7 Then F:=1;
End;
Begin
  Xg:=GetMaxX-10;
  Pk:=GetMaxX;
  CurPos:=True;
  SetTextStyle(0, 0, 6);
  ClearDevice;
  For F:=1 To 6 Do
    Begin
      Mass_K[F]:=Pk-80;
      If Mass_K[F]<=0 Then Mass_K[F]:=GetMaxX;
      Pk:=Mass_K[F];
    End;
  F:=1;
  Color:=9;
  Repeat
    GetMouseState(Button, MouseX, MouseY);
    Picture(50, Mass_K[1]);
    Picture(100, Mass_K[2]);
    Picture(250, Mass_K[3]);
    Picture(150, Mass_K[4]);
    Picture(400, Mass_K[5]);
    Picture(350, Mass_K[6]);
    If CurPos Then
      Begin
        SetColor(Black);
        OutTextXY(Xg, 130, 'GAME OVER');
        Xg:=Xg-10;
        SetColor(LightBlue);
        OutTextXY(Xg, 130, 'GAME OVER');
        NormalDelay(2);
      End;
    If Xg<=120 Then CurPos:=False;
    SetColor(Red);
    If CurPos=False Then
      Begin
        OutTextXY(Xg, 130, 'GAME OVER');
        Color:=12;
      End;
  Until (KeyPressed) Or ((IsMouse) And (Button<>0));
  While KeyPressed Do ReadKey;
  While (IsMouse) And (Button<>0) Do GetMouseState(Button, MouseX, MouseY);
End;

Procedure PrepeareToLevel;
Var X, Y: Integer;
    I, J: Byte;
Begin
  ClearDevice;
  For I:=1 To 14 Do
    For J:=1 To 14 Do
      Begin
        X:=((J-1)*BrickSizeX+45);
        Y:=((I-1)*BrickSizeY+45);
        Case Level Of
          1: Tab[I, J]:=Tab1[I, J];
          2: Tab[I, J]:=Tab2[I, J];
          3: Tab[I, J]:=Tab3[I, J];
          4: Tab[I, J]:=Tab4[I, J];
          5: Tab[I, J]:=Tab5[I, J];
          6: Tab[I, J]:=Tab6[I, J];
          7: Tab[I, J]:=Tab7[I, J];
          8: Tab[I, J]:=Tab8[I, J];
          9: Tab[I, J]:=Tab9[I, J];
          10: Tab[I, J]:=Tab10[I, J];
        End;

        Case Tab[I, J] Of
          1: PutImage(X, Y, P1^, XorPut);
          2: PutImage(X, Y, P2^, XorPut);
          3: PutImage(X, Y, P3^, XorPut);
          4: PutImage(X, Y, P4^, XorPut);
          5: PutImage(X, Y, P5^, XorPut);
          6: PutImage(X, Y, P6^, XorPut);
        End;
      End;
  BrickCount:=0;
  For I:=1 To 14 Do
    For J:=1 To 14 Do
      If Tab[I, J]<>0 Then BrickCount:=BrickCount+1;
  SetColor(White);
  SetLineStyle(0, 0, 3);
  Rectangle(5, 5, GetMaxX-152, GetMaxY+5);
  SetLineStyle(0, 0, 0);
  SetColor(DarkGray);
  SetFillStyle(1, 8);
  Bar(GetMaxX-130, 5, GetMaxX-5, GetMaxY-5);
  SetTextStyle(0, 0, 2);
  SetColor(Red);
  OutTextXY(GetMaxX-100, 20, 'SCORE');
  OutTextXY(GetMaxX-100, 100, 'LIVES');
  OutTextXY(GetMaxX-100, 180, 'LEVEL');
End;

Procedure WriteCount(Who, N: Integer);
Var S: String[6];
    Y: Integer;
Begin
  Case Who Of
    1: Y:=40;
    2: Y:=120;
    3: Y:=200;
  End;
  Str(N, S);
  SetFillStyle(1, 8);
  Bar(GetMaxX-85, Y, GetMaxX-20, Y+40);
  SetColor(Brown);
  SetTextStyle(0, 0, 2);
  OutTextXY(GetMaxX-85, Y+5, S);
End;

Procedure Collision;
Var HPause: Word;
Begin
HPause:=Round(PauseN/2.5);
  If (BallX>=PaddleX-3) And (BallX<=PaddleX+60-3) And (Abs(BallY-PaddleY)<10) And (SpeedY>0) Then
    Begin
      If ((BallX+3-PaddleX<=10)) Then
        Begin
          SpeedX:=-2;
          SpeedY:=1;
          Pause:=PauseN+HPause;
        End;
      If (((BallX+3)-PaddleX>10) And ((BallX+3)-PaddleX<=20)) Then
        Begin
          SpeedX:=-1;
          SpeedY:=1;
          Pause:=PauseN;
        End;
      If ((BallX+3)-PaddleX>20) And ((BallX+3)-PaddleX<30) Then
        Begin
          SpeedX:=-1;
          SpeedY:=2;
          Pause:=PauseN+HPause;
        End;
      If ((BallX+3)-PaddleX>=30) And ((BallX+3)-PaddleX<40) Then
        Begin
          SpeedX:=1;
          SpeedY:=2;
          Pause:=PauseN+HPause;
        End;
      If ((BallX+3-PaddleX)>=40) And ((BallX+3-PaddleX)<50) Then
        Begin
          SpeedX:=1;
          SpeedY:=1;
          Pause:=PauseN;
        End;
      If (BallX+3-PaddleX>=50) Then
        Begin
          SpeedX:=2;
          SpeedY:=1;
          Pause:=PauseN+HPause;
        End;
      SpeedY:=-SpeedY;
    End;
End;

Procedure MovePaddle;
Begin
   PutImage(PaddleX, PaddleY, Paddle^, XorPut);
   If (Port[$60]=Left) Or ((IsMouse) And (MouseX<MouseXOld)) Then
     If PaddleX>20 Then PaddleX:=PaddleX-PaddleStep;
   If (Port[$60]=Right) Or ((IsMouse) And (MouseX>MouseXOld)) Then
     If PaddleX<GetMaxX-220 Then PaddleX:=PaddleX+PaddleStep;
   If IsMouse Then
     Begin
       MouseGoToXY(PaddleX, GetMaxY);
       GetMouseState(Button, MouseX, MouseY);
       MouseXOld:=MouseX;
     End;
   PutImage(PaddleX, PaddleY, Paddle^, XorPut);
   OldTimer:=SysTimer;
End;

Procedure BallOnPaddle;
Begin
  SpeedX:=1;
  SpeedY:=-1;
  OldTimer:=SysTimer;
  While Button<>0 Do GetMouseState(Button, MouseXOld, MouseYOld);
  MouseGoToXY(GetMaxX Div 2, GetMaxY);
  GetMouseState(Button, MouseXOld, MouseYOld);
  Repeat
    GetMouseState(Button, MouseX, MouseY);
    If ((Port[$60]<$80) And (SysTimer<>OldTimer)) Or
     ((IsMouse) And (MouseX<>MouseXOld)) Then
      Begin
        PutImage(BallX, BallY, Ball^, XorPut);
        PutImage(PaddleX, PaddleY, Paddle^, XorPut);
        If (Port[$60]=Left) Or ((IsMouse) And (MouseX<MouseXOld)) Then
          Begin
            If PaddleX>20 Then
              Begin
                PaddleX:=PaddleX-PaddleStep;
                BallX:=BallX-PaddleStep;
              End;
          End;
        If (Port[$60]=Right) Or ((IsMouse) And (MouseX>MouseXOld)) Then
          Begin
            If PaddleX<GetMaxX-220 Then
              Begin
                PaddleX:=PaddleX+PaddleStep;
                BallX:=BallX+PaddleStep;
              End;
          End;
        MouseGoToXY(PaddleX, GetMaxY);
        GetMouseState(Button, MouseX, MouseY);
        MouseXOld:=MouseX;
        PutImage(BallX, BallY, Ball^, XorPut);
        PutImage(PaddleX, PaddleY, Paddle^, XorPut);
        If Port[$60]<>Esc Then ClearBuffer;
        OldTimer:=SysTimer;
      End;
  Until (Port[$60]=Esc) Or (Port[$60]=Space) Or ((IsMouse) And (Button<>0));
End;

Procedure MoveBall;
Begin
  PutImage(BallX, BallY, Ball^, XorPut);
  BallX:=BallX+SpeedX;
  BallY:=BallY+SpeedY;
  If (BallX>GetMaxX-165) Or (BallX<10) Then
    Begin
      SpeedX:=-SpeedX;
      NormalDelay(1);
    End;
  If (BallY<10) Then
    Begin
      SpeedY:=-SpeedY;
      NormalDelay(1);
    End;
  If BallY>GetMaxY Then
    Begin
      Lives:=Lives-1;
      If Lives=0 Then EndGame:=True
      Else
        Begin
          WriteCount(2, Lives);
          PutImage(BallX, BallY, Ball^, XorPut);
          PutImage(PaddleX, PaddleY, Paddle^, XorPut);
          BallX:=PaddleX+30-3;
          BallY:=PaddleY-8;
          PutImage(BallX, BallY, Ball^, XorPut);
          PutImage(PaddleX, PaddleY, Paddle^, XorPut);
          BallOnPaddle;
        End;
    End
  Else
    Begin
      PutImage(BallX, BallY, Ball^, XorPut);
      Delay(Pause);
    End;
End;

Procedure Win;
Var Y:Word;
Begin
   If Level=MaxLevel Then
     Begin
       ClearDevice;
       SetTextStyle(2, 0, 8);
       SetColor(LightRed);
       Y:=GetmaxY Div 4;
       OutTextXY((GetMaxX Div 4)-10, Y, 'ਬ ࠢ!');
       SetTextStyle(2, 0, 5);
       SetColor(Yellow);
       OutTextXY(200, Y+70, ' 諨  ஢.');
       SetColor(LightGreen);
       OutTextXY(150, Y+100, ' ᥡ , 㪠  ?');
       OutTextXY(150, Y+130, '  㬠襤訬, ⮡ ᤥ ');
       OutTextXY(155, Y+160, '।   ࠧ ᭠砫 :-)');
       SetColor(LightGray);
       OutTextXY(200, GetMaxY-40, '  ');
       While KeyPressed Do ReadKey;
       While (IsMouse) And (Button<>0) Do GetMouseState(Button, MouseX, MouseY);
       Repeat
         GetMouseState(Button, MouseX, MouseY);
       Until (KeyPressed) Or ((IsMouse) And (Button<>0));
       EndGame:=True;
     End
   Else
     Begin
       Level:=Level+1;
       PrepeareToLevel;
       PaddleX:=GetMaxX Div 2;
       BallX:=PaddleX+30-3;
       PaddleY:=GetMaxY-30;
       BallY:=PaddleY-8;
       SpeedX:=1;
       SpeedY:=-1;
       PutImage(PaddleX, PaddleY, Paddle^, XorPut);
       PutImage(BallX, BallY, Ball^, XorPut);
       WriteCount(1, Score);
       WriteCount(2, Lives);
       WriteCount(3, Level);
       BallOnPaddle;
     End;
End;

Procedure Kick;
Var
    Xp, Yp, Xt, Yt, I, J: Integer;
    Kn, Bn, Tr: Boolean;
    Cr, BallRadius: Byte;
Begin
  Cr:=0;
  BallRadius:=7;
  Xt:=BallX-45;
  Yt:=BallY-45;
  Xp:=Xt;
  Yp:=Yt;
  Tr:=True;
  Repeat
    Cr:=Cr+1;
    If (Xp>=0) And (Yp>=0) Then
      Begin
        Case Cr Of
          2: Begin
               Xp:=Xt+BallRadius;
               Yp:=Yt;
             End;
          3: Begin
               Yp:=Yt+BallRadius;
               Xp:=Xt;
             End;
          4: Begin
               Xp:=Xt+BallRadius;
               Yp:=Yt+BallRadius;
             End;
        End;
        J:=(Xp Div BrickSizeX)+1;
        I:=(Yp Div BrickSizeY)+1;
        If ((Xp Mod BrickSizeX)=0) And (J>1) And (SpeedX<0) Then J:=J-1;
        If ((Yp Mod BrickSizeY)=0) And (I>1) And (SpeedY<0) Then I:=I-1;
        If (I>14) And (Yp<169) Then I:=14;
        If (J>14) And (Xp<393) Then J:=14;
        If I<1 Then I:=1;
        If J<1 Then J:=1;
        If (I<15) And (J<15) And (Tab[I, J]<>0) And Tr Then
          Begin
            Tr:=False;
            If ((Xp Mod BrickSizeX)=0) Then SpeedX:=-SpeedX;
            If (((Xp Mod BrickSizeX)=1) Or ((Xp Mod BrickSizeX)=BrickSizeX-1)) And (Abs(SpeedX)=2) Then SpeedX:=-SpeedX;
            If ((Yp Mod BrickSizeY)=0) Then SpeedY:=-SpeedY;
            If (((Yp Mod BrickSizeY)=1) Or ((Yp Mod BrickSizeY)=BrickSizeY-1)) And (Abs(SpeedY)=2) Then SpeedY:=-SpeedY;
            Xp:=(J-1)*(BrickSizeX)+45;
            Yp:=(I-1)*(BrickSizeY)+45;
            PutImage(BallX, BallY, Ball^, XorPut);
            If TimeSound>0 Then Tone1(450, TimeSound);
            Case Tab[I, J] Of
              1: Begin
                   PutImage(Xp, Yp, P1^, XorPut);
                   BrickCount:=BrickCount-1;
                   Score:=Score+3;
                   Tab[I, J]:=0;
                 End;
              2: Begin
                   PutImage(Xp, Yp, P1^, CopyPut);
                   Tab[I, J]:=1;
                   Score:=Score+2;
                 End;
              3: Begin
                   PutImage(Xp, Yp, P2^, CopyPut);
                   Tab[I, J]:=2;
                   Score:=Score+1;
                 End;
              4: Begin
                   PutImage(Xp, Yp, P3^, CopyPut);
                   Tab[I, J]:=3;
                   Score:=Score+1;
                 End;
              5: Begin
                   PutImage(Xp, Yp, P4^, CopyPut);
                   Tab[I, J]:=4;
                   Score:=Score+1;
                 End;
              6: Begin
                   PutImage(Xp, Yp, P5^, CopyPut);
                   Tab[I, J]:=5;
                   Score:=Score+1;
                 End;
            End;
            WriteCount(1, Score);
            PutImage(BallX, BallY, Ball^, XorPut);
            If BrickCount=0 Then Win;
          End;
      End;
  Until Cr=4;
End;

Procedure Game;
Begin
  ClearDevice;
  EndGame:=False;
  PaddleX:=GetMaxX Div 2;
  PaddleY:=GetMaxY-30;
  BallX:=PaddleX+30-3;
  BallY:=PaddleY-8;
  SpeedX:=1;
  SpeedY:=-1;
  Score:=0;
  Pause:=PauseN;
  PrepeareToLevel;
  PutImage(PaddleX, PaddleY, Paddle^, XorPut);
  PutImage(BallX, BallY, Ball^, XorPut);
  WriteCount(1, Score);
  WriteCount(2, Lives);
  WriteCount(3, Level);
  BallOnPaddle;
  Repeat
    GetMouseState(Button, MouseX, MouseY);
    If ((Port[$60]<$80) And (OldTimer<>SysTimer)) Or
    ((IsMouse) And (MouseX<>MouseXOld)) Then MovePaddle;
    MoveBall;
    If ((BallX>38) And (BallX<438) And (BallY>38) And (BallY<214)) Then Kick;
    Collision;
    If Port[$60]<>Esc Then ClearBuffer;
  Until (Port[$60]=Esc) Or (EndGame);
  If Lives=0 Then GameOver;
End;

Procedure Ark;
Var Sa, Xa, Ya: Integer;
Begin
  ClearDevice;
  If TextMove=True Then
    Begin
      Sa:=0;
      Xa:=230;
      Ya:=GetmaxY Div 10;
      Repeat
        SetColor(Black);
        OutTextXY(Xa, Ya, 'Arkanoid');
        SetTextStyle(0, 0, Sa);
        Xa:=Xa-10;
        Ya:=Ya+5;
        Sa:=Sa+1;
        SetColor(LightRed);
        OutTextXY(Xa, Ya, 'Arkanoid');
        NormalDelay(3);
      Until Sa>=6;
      TextMove:=False;
      End;
  SetTextStyle(0, 0, 5);
  SetColor(LightGray);
  OutTextXY(175, (GetmaxY Div 10)+30, 'Arkanoid');
  SetColor(LightRed);
  OutTextXY(170, (GetmaxY Div 10)+30, 'Arkanoid');
  SetTextStyle(0, 0, 2);
End;

Procedure Menu(Var Nv: Byte);
Const
  MenuItems: Array[1..4] Of String[7] = ('GAME', 'HELP', 'OPTIONS', 'EXIT');
Var Ch: Char;
    Mass: Array[1..5, 1..2] Of Integer;
    Io, Zo: Integer;
Procedure DrawItem(Item: Byte; Stat: Boolean);
Begin
  If Stat=True Then
    Begin
      SetFillStyle(1, 14);
      SetColor(Green);
    End
  Else
    Begin
      SetFillStyle(1, 0);
      SetColor(LightGreen);
    End;
  Bar(255, 130+(40*Item)-2, 372, 130+(40*Item)+15);
  if Item=3 Then OutTextXY(260, 130+(40*Item), MenuItems[Item])
  Else
   OutTextXY(280, 130+(40*Item), MenuItems[Item]);
End;
Procedure DrawStars;
Var Xo, Yo: Integer;
Begin
  Repeat
    Xo:=Random(GetMaxX+1);
    Yo:=Random(GetMaxY+1);
  Until Not (((Xo>150) And (Xo<GetMaxX-150)) And ((Yo>90) And (Yo<GetMaxY-290)));
  Mass[Io, 1]:=Xo;
  Mass[Io, 2]:=Yo;
  SetColor(Random(15)+1);
  Circle(Xo, Yo, 1);
  NormalDelay(1);
  SetColor(0);
  Circle(Mass[Zo, 1], Mass[Zo, 2], 1);
  Zo:=Zo+1;
  Io:=Io+1;
  If Io>5 Then Io:=1;
  If Zo>5 Then Zo:=1;
End;
Begin
  Nv:=1;
  Zo:=1;
  Io:=5;
  Ark;
  DrawItem(1, True);
  DrawItem(2, False);
  DrawItem(3, False);
  DrawItem(4, False);
  While KeyPressed Do ReadKey;
  While (IsMouse) And (Button<>0) Do GetMouseState(Button, MouseX, MouseY);
  MouseGoToXY(GetMaxX Div 2, GetMaxY Div 2);
  GetMouseState(Button, MouseX, MouseY);
  MouseYOld:=MouseY;
  Ch:=#0;
  Repeat;
    DrawStars;
    GetMouseState(Button, MouseX, MouseY);
    If (KeyPressed) Or ((IsMouse) And (Abs(MouseY-MouseYOld)>15)) Then
      Begin
        If KeyPressed Then Ch:=ReadKey;
        If (Ch=#0) Or ((IsMouse) And (Abs(MouseY-MouseYOld)>15)) Then
          Begin
            If KeyPressed Then Ch:=ReadKey;
            DrawItem(Nv, False);
            If (Ch=Up) Or ((IsMouse) And (MouseY<MouseYOld)) Then
              If Nv>1 Then Nv:=Nv-1 Else Nv:=4;
            If (Ch=Down) Or ((IsMouse) And (MouseY>MouseYOld)) Then
              If Nv<4 Then Nv:=Nv+1 Else Nv:=1;
            If IsMouse Then
              Begin
                MouseGoToXY(GetMaxX Div 2, GetMaxY Div 2);
                GetMouseState(Button, MouseX, MouseY);
                MouseYOld:=MouseY;
              End;
            DrawItem(Nv, True);
          End;
      End;
  Until (Ch=Enter) Or ((IsMouse) And (Button<>0));
  While (IsMouse) And (Button<>0) Do GetMouseState(Button, MouseX, MouseY);
  While KeyPressed Do ReadKey;
  Ch:=#0;
End;

Procedure Prepeare;
Var PicSize: Integer;
Function Brick(BrickColor: Byte): Pointer;
Var Pic: Pointer;
Begin
  SetFillStyle(1, BrickColor+8);
  Bar(0, 0, 25, 9);
  SetColor(BrickColor);
  Rectangle(26, 0, 27, 11);
  Rectangle(0, 10, 27, 11);
  GetMem(Pic, PicSize);
  GetImage(0, 0, 27, 11, Pic^);
  Brick:=Pic;
End;
Begin
  PicSize:=ImageSize(0, 0, 27, 11);
  P1:=Brick(5);
  P2:=Brick(6);
  P3:=Brick(1);
  P4:=Brick(4);
  P5:=Brick(3);
  P6:=Brick(2);

  ClearDevice;
  SetColor(LightCyan);
  Line(3, 0, 56, 0);
  Line(2, 1, 57, 1);
  Line(1, 2, 58, 2);
  SetFillStyle(1, LightCyan);
  Bar(0, 3, 59, 6);
  Line(1, 7, 58, 7);
  Line(2, 8, 57, 8);
  Line(3, 9, 56, 9);
  SetColor(Red);
  Line(8, 3, 51, 3);
  Line(7, 4, 52, 4);
  Line(7, 5, 52, 5);
  Line(8, 6, 51, 6);
  PicSize:=ImageSize(0, 0, 59, 9);
  GetMem(Paddle, PicSize);
  GetImage(0, 0, 59, 9, Paddle^);
  ClearDevice;
  SetColor(White);
  Circle(3, 3, 3);
  SetFillStyle(1, White);
  FloodFill(3, 3, White);
  PicSize:=ImageSize(0, 0, 6, 6);
  GetMem(Ball, PicSize);
  GetImage(0, 0, 6, 6, Ball^);
  ClearDevice;
End;
{$F+}
Procedure EGAVGADriverProc; External;
{$L EGAVGA}
{$F-}
{$F+}
Procedure SmallFontProc; External;
{$L LITT}
{$F-}
Begin
  If RegisterBGIDriver(@EGAVGADriverProc)<0 Then Halt(1);
  If RegisterBGIFont(@SmallFontProc)<0 Then Halt(1);
  GrDriver:=Detect;
  InitGraph(GrDriver, GrMode, '');
  Randomize;
  Prepeare;
  Intro;
  PauseN:=150;
  Lives:=5;
  Level:=1;
  SoundPro:=True;
  TimeSound:=65;
  Repeat
    Menu(MenuItem);
    Case MenuItem Of
      1: Game;
      2: Help;
      3: Options;
    End;
  Until MenuItem=4;
  Release(Ball);
  Release(Paddle);
  Release(P6);
  Release(P5);
  Release(P4);
  Release(P3);
  Release(P2);
  Release(P1);
  CloseGraph;
End.
