'$DYNAMIC
DECLARE FUNCTION TimerElapsed% (TheTimer%)

TYPE SINGLETimerType
    Duration AS SINGLE
    Start AS SINGLE
    'Elapsed AS SINGLE
END TYPE

DIM SHARED Timers(0 TO 0) AS SINGLETimerType

FUNCTION TimerElapsed% (TheTimer%)
    IF Timers(TheTimer%).Duration = 0 THEN EXIT FUNCTION
    Tim! = TIMER 'Freeze a moving target
    IF Tim! < Timers(TheTimer%).Start THEN
      ElapsedTime! = Tim! + (86400 - Timers(TheTimer%).Start)
    ELSE
      ElapsedTime! = Tim! - Timers(TheTimer%).Start
    END IF
    IF Timers(TheTimer%).Duration <= ElapsedTime! THEN
       Timers(TheTimer%).Duration = 0 'Comment this out if you want
'to stop the timer triggering manually
       TimerElapsed% = -1
    END IF
END FUNCTION

SUB TimersInit (HowMany%)
    SHARED Timers() AS SINGLETimerType
    REDIM Timers(0 TO HowMany%) AS SINGLETimerType
END SUB

SUB TimerStart (TimerToStart%, Duration AS SINGLE)
    IF Timers(TheTimer).Duration <> 0 THEN EXIT SUB 'Trying to start an already
'started timer 
    Timers(TimerToStart%).Start = TIMER
    Timers(TimerToStart%).Duration = Duration
END SUB

SUB TimerStop (TimerToStop%)
    'Stops the timer without triggering
    Timers(TimerToStop%).Duration = 0
END SUB

