'===========================================================================
'Adapted for PB from Fred Sexton Jr's CNTR_ACT.BAS found in "QB GAMES AND
'MORE," 1993 ISBN:1-56529-231-6 by Walt Decker, Nov 2001
'===========================================================================

DEFINT A-Z

'================Structure for setting DCA registers=======================
TYPE Hues
		red AS INTEGER   'red component - 0 to 63
	green AS INTEGER   'green component - 0 to 63
	 blue AS INTEGER   'blue component - 0 to 63
END TYPE

'===============Procedure declarations=====================================

DECLARE SUB PlotText (Text AS STRING, CharSet() AS INTEGER, _
											NumElms AS INTEGER, X AS INTEGER, Y AS INTEGER, _
											Pcolor AS INTEGER)

DECLARE SUB GetImage (strPath AS STRING, NumElms AS INTEGER, _
											CharSet() AS INTEGER)

DECLARE SUB DrwCirc (X AS INTEGER, Y AS INTEGER, Radius AS INTEGER, _
										 MinX AS INTEGER, MinY AS INTEGER, MaxX AS INTEGER, _
										 MaxY AS INTEGER, Pcolor AS INTEGER, Range AS INTEGER)

DECLARE SUB MilliDelay(Msecs AS INTEGER)

DECLARE SUB UpdateKeys (Up AS INTEGER, Down AS INTEGER, ARight AS INTEGER, _
												ALeft AS INTEGER)

DECLARE SUB GetColors (pal() AS Hues, fc AS INTEGER, lc AS INTEGER)
DECLARE SUB SetColors (pal() AS Hues, fc AS INTEGER, lc AS INTEGER)

DECLARE SUB GamePlay(CharSet(), NumElms, Ball(), BkGnd())

DECLARE SUB DisPlay(BYVAL MinX AS INTEGER, BYVAL MinY AS INTEGER, _
					 Image() AS INTEGER, BYVAL Optn AS INTEGER)

DECLARE SUB Capture(BYVAL MinX AS INTEGER, BYVAL MinY AS INTEGER, _
						BYVAL MaxX AS INTEGER, BYVAL MaxY AS INTEGER, _
            Image() AS INTEGER)

DECLARE SUB DrwBox(BYVAL X AS INTEGER, BYVAL Y AS INTEGER, BYVAL X1 AS INTEGER, _
					 BYVAL Y1 AS INTEGER, BYVAL Pcolor AS INTEGER, _
					 BYVAL Fcolor AS INTEGER)

DECLARE FUNCTION YesOrNo() AS INTEGER
DECLARE FUNCTION Azi(BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%) AS INTEGER

'=====================Define variables=====================================

DIM Scn.Ratio AS SHARED SINGLE
DIM ScnAddr 	AS SHARED DWORD
DIM ScnPtr    AS SHARED BYTE PTR       'Pointer to screen
DIM KeyHPtr   AS SHARED BYTE PTR
DIM KeyTPtr   AS SHARED BYTE PTR
DIM DelayPtr  AS SHARED BYTE PTR
DIM Words     AS STRING
DIM Path      AS STRING

DIM SysPal(255) AS Hues
DIM GamPal(255) AS Hues

'====================Initialize some variables=============================
I = 1
DIM CharSet(I) AS INTEGER, Ball(I) AS INTEGER, BkGnd(I) AS INTEGER
Scn.Ratio = 1
ScnAddr = &HA000 * 65536           'address of screen
KeyHPtr = &H40 * 65536 + &H1A      'pointer to keyboard buffer
KeyTPtr = &H40 * 65536 + &H1C      'pointer to keyboard buffer
DelayPtr = &H40 * 65536 + &H6C     'pointer to programable clock

Words = "COUNTER FORCE"
Path = "CHARSET.BSV"

CheckPath: '
CLS

IF DIR$(Path) = "" THEN
	LOCATE 12,12
  COLOR 5, 7
  PRINT "CHARSET.BSV was not found.  Please enter the path for CHARSET.BSV"
  PRINT "Syntax = Drive:\Directory\[Directory\]CHARSET.BSV"
  COLOR 7, 5
  LINE INPUT Words
  IF Words = "" THEN END
  Path = Words
  Words = "COUNTER FORCE"
  GOTO CheckPath
END IF
CALL MilliDelay(0)              'Initialize delay routine

Intensity = 4

FOR I = 16 TO 32                'Set colors 16 - 32 to gray
	GamPal(I).Red = Intensity
  GamPal(I).Green = Intensity
  GamPal(I).Blue = Intensity
  INCR Intensity, 4
NEXT I

CALL GetImage("CharSet.BSV", NumElms, CharSet())   'Get text byte-maps

! mov AX, &H13                  ;Switch to screen mode 13
! int &H10

CALL GetColors(SysPal(), 0, 255)     'get system colors
CALL SetColors(GamPal(), 16, 32)     'set system colors

X = 160 - (LEN(Words) \ 2) * CharSet(1)
CALL PlotText(Words, CharSet(), NumElms,X, 0, 14)  'display title

Y = 100                              'prepare to draw circle
X = 100
Radius = 10

Start: '
Pcolor = 18

CALL DrwCirc(X, Y, (Radius), Xmn, Ymn, Xmx, Ymx, Pcolor, 16)
CALL PlotText("Does this look like a circle Y/N?", CharSet(), _
							NumElms, 0, 25, 1)     'show prompt

IF YesOrNo = 0 THEN                  'get answer
  CALL DrwCirc(X, Y, (Radius), Xmn, Ymn, Xmx, Ymx, 0, -1)
	Scn.Ratio = 4/3 * (200 / 320)      'set screen aspect ratio
  GOTO Start
END IF

CALL Capture(Xmn, Ymn, Xmx, Ymx, Ball())    'capture ball image

CALL Drwcirc(X, Y, Radius, 0, 0, 0, 0, 0, -1)  'erase ball image
CALL Capture(Xmn, Ymn, Xmx, Ymx, BkGnd())      'capture erase mask

CALL DisPlay(100, 100, BkGnd(),0)
CALL DrwBox(0, 25, 319, 33, 0, 0)              'draw playing field

CALL GamePlay(CharSet(), NumElms, Ball(), BkGnd())   'begin play

SCREEN 12                                      'reset screen
SCREEN 0
END

FUNCTION Azi(BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%) AS INTEGER

'calculate the global direction from a given point to a given point
'Azi returns the direction in the range 0 - 360 degrees. 0 degrees is at the
'top of the screen, 180 degrees is at the bottom.

DIM X   AS LOCAL INTEGER
DIM Y   AS LOCAL INTEGER
DIM Pi  AS LOCAL SINGLE
DIM Deg AS LOCAL SINGLE

Pi = 4 * ATN(1)
Deg = 180 / Pi

	X = X2% - X1%
	Y = Y2% - Y1%

SELECT CASE Y
	CASE < 0
		Azi = -ATN(X / Y) * deg                    '0 - 90 degrees
		IF X < 0 THEN Azi = 360 - ATN(X / Y) * deg '270 - 360 degrees
	CASE > 0
		Azi = 180 - ATN(X / Y) * deg               '90 to 270 degrees
	CASE 0
		IF X > 0 THEN Azi = 90
		IF X < 0 THEN Azi = 270
END SELECT

END FUNCTION

SUB DrwBox(BYVAL X AS INTEGER, BYVAL Y AS INTEGER, BYVAL X1 AS INTEGER, _
					 BYVAL Y1 AS INTEGER, BYVAL Pcolor AS INTEGER, _
					 BYVAL Fcolor AS INTEGER)

'draws a box and optionally fills it with color

SHARED ScnAddr                 'screen address
SHARED ScnPtr                  'screen pointer

DIM Offs AS LOCAL LONG
DIM Wide AS LOCAL INTEGER
DIM High AS LOCAL INTEGER
DIM Lx   AS LOCAL INTEGER
DIM Ly   AS LOCAL INTEGER
DIM I    AS LOCAL INTEGER

Wide = X1 - X + 1
High = Y1 - Y + 1

Offs = Y * 320& + X           'calculate screen location
ScnPtr = ScnAddr + Offs       'set pointer to location

GOSUB Horizontal

Offs = Y1 * 320& + X          'calculate screen location
ScnPtr = ScnAddr + Offs       'set pointer to location
GOSUB Horizontal

Lx = X
Ly = Y

GOSUB Vertical

Ly = Y
Lx = X1

GOSUB Vertical

IF Fcolor < 0 THEN EXIT SUB

Lx = X + 1
Ly = Y + 1
Wide = Wide - 2
Pcolor = Fcolor

DO
	Offs = Ly * 320& + Lx
  ScnPtr = ScnAddr + Offs
	GOSUB Horizontal
	INCR Ly
LOOP WHILE Ly < Y1

EXIT SUB

Horizontal: '

FOR I = 1 TO Wide
  @ScnPtr = Pcolor                'display the color
	INCR ScnPtr
NEXT I

RETURN

Vertical: '

FOR I = 1 TO High
	Offs = Ly * 320& + Lx          'calculate location and display color
  ScnPtr = ScnAddr + Offs
	@ScnPtr = Pcolor
	INCR Ly
NEXT I

RETURN

END SUB

SUB DrwCirc (X AS INTEGER, Y AS INTEGER, Radius AS INTEGER, _
						 MinX AS INTEGER, MinY AS INTEGER, MaxX AS INTEGER, _
						 MaxY AS INTEGER, Pcolor AS INTEGER, Range AS INTEGER)

'Plots a circle on the screen with origin at X,Y with size Radius
'Optionally changes color as the circle is plotted
'Returns the size of the square area in which the circle is contained

SHARED Scn.Ratio          'screen aspect ratio

DIM Rad   as LOCAL single
DIM Pi    as LOCAL single
DIM Offs  as LOCAL long
DIM X1    as LOCAL integer
DIM Y1    as LOCAL integer
DIM Srng  as LOCAL integer

Pi = 4 * ATN(1)
Rad = Pi / 180

MinY = 9999
MinX = 9999
MaxY = -9999
MaxX = -9999

IF Range THEN Srng = Pcolor + Range

DEF SEG = &HA000           'set data segment to the screen memory area

DO
FOR I = 0 TO 360
	X1 = X + Radius * SIN(I * Rad)
	Y1 = Y - Radius * COS(I * Rad) * Scn.Ratio

	MinX = MIN(X1, MinX)
	MaxX = MAX(X1, MaxX)
	MinY = MIN(Y1, MinY)
	MaxY = MAX(Y1, MaxY)
	Offs = Y1 * 320& + X1
	POKE (Offs), Pcolor
NEXT I

DECR Radius

IF Range THEN
	IF Pcolor < Srng THEN
		INCR Pcolor
	END IF
END IF

LOOP UNTIL Radius < 0

DEF SEG

END SUB

SUB DrwLine (X, Y, X1, Y1, Pcolor)

'Draws a line from X, Y to X1, Y1 using Pcolor
'Routine is not used in this program

SHARED ScnAddr
SHARED ScnPtr

DIM Pi    AS LOCAL SINGLE
DIM Rad   AS LOCAL SINGLE
DIM Dist  AS LOCAL INTEGER
DIM Lx    AS LOCAL INTEGER
DIM Ly    AS LOCAL INTEGER
DIM Az    AS LOCAL INTEGER
DIM Offs  AS LOCAL LONG
DIM Tdist AS LOCAL INTEGER

Pi = 4 * ATN(1)
Rad = Pi / 180
Dist = SQR((X1 - X) ^ 2 + (Y1 - Y) ^ 2)

Az = Azi(X, Y, X1, Y1)

DO
	Lx = X + Tdist * SIN(Az * Rad)
	Ly = Y - Tdist * COS(Az * Rad)
	Offs = Ly * 320& + Lx
  ScnPtr = ScnAddr + Offs
	@ScnPtr = Pcolor
	INCR Tdist
LOOP UNTIL Tdist > Dist

END SUB

SUB GetImage (strPath AS STRING, NumElms AS INTEGER, CharSet() AS INTEGER)

'Gets a stored image from a file.  It is not a BSAVE file

OPEN strPath FOR BINARY AS #1
TotalElms = LOF(1) \ 2

REDIM CharSet(TotalElms) AS INTEGER
FOR I = 0 TO TotalElms
	GET #1, , CharSet(I)
NEXT I

CLOSE #1

Wide = CharSet(0) \ 8
High = CharSet(1)
NumBytes = Wide * High + 1
NumElms = NumBytes \ 2 + 2

END SUB

SUB PlotText (Text AS STRING, CharSet() AS INTEGER, _
							NumElms AS INTEGER, X AS INTEGER, Y AS INTEGER, _
							Pcolor AS INTEGER)

'Plots text to the screen in Pcolor beginning at X, Y
'The text characters are contained in an array as a memory map

SHARED ScnAddr
SHARED ScnPtr

DIM Set AS LOCAL BYTE PTR     'pointer to array holding text images

DIM I 	 AS LOCAL INTEGER
DIM J 	 AS LOCAL INTEGER
DIM Wide AS LOCAL INTEGER      'width of each image
DIM High AS LOCAL INTEGER      'height of each image
DIM Elm  AS LOCAL INTEGER
DIM Tlen AS LOCAL INTEGER      'length of string to be displayed
DIM Offs AS LOCAL INTEGER
DIM Posn AS LOCAL INTEGER      'position of text image in array
DIM Char AS LOCAL INTEGER
DIM Xn   AS LOCAL INTEGER
DIM Yn   AS LOCAL INTEGER

DIM ScnOffs AS LOCAL LONG      'screen offset

Wide = CharSet(0) \ 8          'calculate actual width of character
High = CharSet(1)              'height of each character
Tlen = LEN(Text)               'length of text to be displayed
Posn = 1                       'initial position in text string
Xn = X
Yn = Y

DO

	Char = ASC(MID$(Text, Posn, 1))    'translate alpha to a number
	Char = Char - 33                   'figure offset into alpha table

	IF Char < 0 THEN                   'space charactr
		IF Xn + Wide > 319 THEN          'text longer than screen width
			Xn = X
			Y = Y + High + 1               'wrap to next line
		END IF
		GOTO NewChar
	END IF
	IF Xn + Wide > 319 THEN
		Xn = X
		Y = Y + High + 1
		Yn = Y
	END IF
	Char = Char * NumElms             'calculate beginning of image
	Set = VARPTR32(CharSet(Char))     'point to image in array
	Offs = 4

	FOR I = 1 TO High                 'plot the text
		ScnOffs = Yn * 320& + Xn
    ScnPtr = ScnAddr + ScnOffs
		FOR J = 1 TO Wide
			IF @Set[Offs] THEN
				@ScnPtr = Pcolor
			END IF
			INCR Offs
			INCR ScnPtr
		NEXT J
		INCR Yn
	NEXT I
	Xn = Xn + Wide + 1
	GOTO NewPos

NewChar: '

	Xn = Xn + Wide \ 2 + 1

NewPos: '

	Yn = Y
	INCR Posn
LOOP UNTIL Posn > Tlen

END SUB

SUB MilliDelay (Msecs AS INTEGER)

'delay timer
SHARED DelayPtr          'pointer to clock

DIM Sysfact  AS STATIC LONG
DIM Count    AS STATIC LONG
DIM Z        AS STATIC INTEGER
DIM T2       AS STATIC INTEGER
DIM T1       AS STATIC INTEGER

IF sysfact THEN                   'Did we calc- system speed yet?
	IF Msecs THEN                  'have to want a delay
		count = (sysfact * Msecs) \ -54    'calc- # of loops needed
		DO
				count = count + 1         'negative - add to get to 0
					IF count = Z THEN EXIT DO  'when its 0 we're done
			LOOP UNTIL T2 = @DelayPtr 'PEEK(&H6C)      'make it the same
		DEF SEG
	END IF
ELSE                               'if sysfact& is 0, calc- system speed
	T1 = @DelayPtr     'PEEK(&H6C)                'get tick count
		DO
			T2 = @DelayPtr 'PEEK(&H6C)            'get tick count
		LOOP UNTIL T2 <> T1            'wait 'til its a new tick
		DO
			sysfact = sysfact + 1         'count number of loops
			IF sysfact = Z THEN EXIT DO    'make it the same
		LOOP UNTIL T2 <> @DelayPtr 'PEEK(&H6C)         'keep going 'til its a new tick
		T2 = 256                            'prevent the delay loop's UNTIL
END IF
END SUB

SUB UpdateKeys (Up AS INTEGER, Down AS INTEGER, ARight AS INTEGER, _
								ALeft AS INTEGER)

'Keyboard routine using scan codes

SHARED KeyHPtr    'head of keyboard buffer
SHARED KeyTPtr    'tail of keyboard buffer

DIM ExtOfs AS LOCAL INTEGER

ExtOfs = INP(&H60)     'check keyboard port
                           'check arrow keys
Up = -1*(ExtOfs = 72)      'see if its scan code 72
Down = -1*(ExtOfs = 80)    'see if its scan code 80
ARight = -1*(ExtOfs = 77)  'scan code 77
ALeft = -1*(ExtOfs = 75)   'scan code 75

@KeyHPtr = @KeyTPtr        'point keyboard buffer head to tail to empty

	 'NOTE: To monitor other keys:                            ****
	 '****        DEF SEG = ExtKeySeg                         ****
	 '****        Key = PEEK(ExtKeyOfs+ScanCodeOfKey)         ****
	 '****   values returned 255 = pressed   0 = not pressed  ****
	 '****   If the key will be tested with "... NOT key ..." ****
	 '****   it must be extended from a byte to a word by     ****
	 '****   copying low byte into high byte:                 ****
	 '****        DEF SEG                                     ****
	 '****        POKE VARPTR(Key) + 1, Key                   ****

END SUB

FUNCTION YesOrNo () AS INTEGER

'another keyboard routine
'works the same as above

SHARED KeyHPtr
SHARED KeyTPtr

DIM ExtKeyOfs AS LOCAL INTEGER
DIM Y         AS LOCAL INTEGER
DIM N         AS LOCAL INTEGER

DO
	ExtKeyOfs = INP(&H60)

	Y = -1*(ExtKeyOfs = 21)           'check scan codes
	N = -1*(ExtKeyOfs = 49)             'ditto

	@KeyHPtr = @KeyTPtr
LOOP UNTIL Y OR N

POKE(VARPTR(Y) + 1), Y             ' Poke low byte into high byte
YesOrNo = Y                         'True if yes

END FUNCTION

SUB GetColors (pal() AS Hues, fc AS INTEGER, lc AS INTEGER)

'get DAC colors

DIM T AS LOCAL INTEGER

OUT &H3C7, fc                       'DAC read port, register fc

FOR T = fc TO lc                    'from first to last
	pal(T).red = INP(&H3C9)          'get red component
	pal(T).green = INP(&H3C9)        'get green component
	pal(T).blue = INP(&H3C9)         'get blue component
NEXT T

END SUB

SUB SetColors (pal() AS Hues, fc AS INTEGER, lc AS INTEGER)

'set DAC colors

DIM T AS LOCAL INTEGER

OUT &H3C8, fc                   ' DAC write port, regiser fc

FOR T = fc TO lc                    'from first to last
	OUT &H3C9, pal(T).red            'send red component
	OUT &H3C9, pal(T).green          'send green component
	OUT &H3C9, pal(T).blue           'send blue component
NEXT T
END SUB

SUB Capture(BYVAL MinX AS INTEGER, BYVAL MinY AS INTEGER, _
						BYVAL MaxX AS INTEGER, BYVAL MaxY AS INTEGER, _
            Image() AS INTEGER)

'captures a screen image and stores it in an array

DIM ImgPtr AS LOCAL BYTE PTR      'pointer to array

DIM Wide   AS LOCAL INTEGER       'width of image
DIM High   AS LOCAL INTEGER       'height of image
DIM ImOfs  AS LOCAL INTEGER
DIM I      AS LOCAL INTEGER
DIM J      AS LOCAL INTEGER
DIM ScOfs  AS LOCAL LONG

Wide = MaxX - MinX + 1            'calculate width in pixels
High = MaxY - MinY + 1            'calculate height in pixels
ImOfs = (Wide * High) \ 2 + 2     'calculate # of elements needed

REDIM Image(ImOfs)                'build the image array

Image(0) = Wide                   'store height and width
Image(1) = High

ImOfs = 4

ImgPtr = VARPTR32(Image(0))        'set pointer to array

DEF SEG = &HA000                   'set data pointer to screen area

FOR I = 1 TO High                  'get the image from the screen area
 	ScOfs = MinY * 320& + MinX       'calculate screen position
	FOR J = 1 TO Wide
    K = PEEK(ScOfs)                'get the pixel
    @ImgPtr[ImOfs] = K             'store it in the array
    INCR ImOfs                     'increase array offset
    INCR ScOfs                     'increase screen offset in x direction
	NEXT J
  INCR MinY                        'increase screen y offset
NEXT I
DEF SEG
END SUB

SUB DisPlay(BYVAL MinX AS INTEGER, BYVAL MinY AS INTEGER, _
					 Image() AS INTEGER, BYVAL Optn AS INTEGER)

'displays an image on the screen

SHARED ScnAddr
SHARED ScnPtr

DIM ImgPtr AS LOCAL BYTE PTR

DIM Wide   AS LOCAL INTEGER
DIM High   AS LOCAL INTEGER
DIM ImOfs  AS LOCAL INTEGER
DIM I      AS LOCAL INTEGER
DIM J      AS LOCAL INTEGER
DIM K      AS LOCAL INTEGER
DIM ScOfs  AS LOCAL LONG

Wide = Image(0)
High = Image(1)

ImgPtr = VARPTR32(Image(0))      'set pointer to image array
ImOfs = 4

FOR I = 1 TO High                'show the image
  ScOfs = MinY * 320& + MinX
  ScnPtr = ScnAddr + ScOfs
	FOR J = 1 TO Wide
    K = @ImgPtr[ImOfs]
  	IF Optn THEN
    	IF K = 0 THEN GOTO Incr.Ofs    'skip color 0
    END IF
		@ScnPtr = K
Incr.Ofs: '

    INCR ScnPtr
    INCR ImOfs
  NEXT J
  INCR MinY
NEXT J

END SUB

SUB GamePlay(CharSet(), NumElms, Ball(), BkGnd())

'main game routine

DIM HighScore AS LOCAL INTEGER
DIM YourScore AS LOCAL INTEGER
DIM LastX     AS LOCAL INTEGER
DIM LastY     AS LOCAL INTEGER
DIM BallX     AS LOCAL INTEGER
DIM BallY     AS LOCAL INTEGER
DIM MaxRand   AS LOCAL INTEGER
DIM Mdelay    AS LOCAL INTEGER
DIM RandX     AS LOCAL INTEGER
DIM RandY     AS LOCAL INTEGER
DIM Uparow    AS LOCAL INTEGER
DIM Dnarow    AS LOCAL INTEGER
DIM Rtarow    AS LOCAL INTEGER
DIM Lfarow    AS LOCAL INTEGER
DIM MinX      AS LOCAL INTEGER
DIM MinY      AS LOCAL INTEGER
DIM MaxX      AS LOCAL INTEGER
DIM MaxY      AS LOCAL INTEGER

DIM Dummy     AS LOCAL BYTE
DIM GameOver  AS LOCAL BYTE

CALL DrwBox(49, 19, 270, 180, 4, -1)     'make colored playing field outline
CALL DrwBox(48, 18, 271, 181, 12, -1)
CALL DrwBox(47, 17, 272, 182, 4, -1)

Begin: '
CALL PlotText("High Score: " + STR$(HighScore), CharSet(), NumElms,0, 0, 1)

MinX = 50                      'limits of playing field
MinY = 20
MaxX = 249
MaxY = 162

MaxRand = 2                   'movement parameter
Mdelay = 50                   'initial delay

BallX = MinX + (MaxX - MinX) \ 2    'center ball in playing field
BallY = MinY + (MaxY - MinY) \ 2
LastX = BallX                       'used to erase ball
LastY = BallY

CALL DisPlay(BallX, BallY, Ball(), 1)      'show the bal

DO

	CALL UpdateKeys (Uparow, Dnarow, Rtarow, Lfarow)  'get arrow key state

	IF Rtarow THEN INCR RandX          'add or subtract 1 to movement
	IF Lfarow THEN DECR RandX
	IF Uparow THEN DECR RandY
	IF Dnarow THEN INCR RandY

	IF RandX = 0 THEN RandX = (RND * MaxRand) - MaxRand \ 2
	IF RandY = 0 THEN RandY = (RND * MaxRand) - MaxRand \ 2

	BallX = BallX + RandX     ' move ball
	BallY = BallY + RandY

  IF BallX <= MinX OR BallX >= MaxX THEN EXIT DO   'ball has hit border
  IF BALLY <= MinY OR BallY >= MaxY THEN EXIT DO

	CALL DisPlay(LastX, LastY, BkGnd(), 0)           'erase ball
	CALL DisPlay(BallX, BallY, Ball(), 1)            'display ball

  LastX = BallX                                    'set to erase ball next
  LastY = BallY                                    ' time

  YourScore = YourScore + 1                        'increase score
  CALL DrwBox(0, 8, 319, 16, 0, 0)                 'sow score
	CALL PlotText("Your Score: " + STR$(YourScore), CharSet(), NumElms,0, 8, 2)

  IF YourScore Mod 100 = 0 THEN
  	IF Mdelay THEN
    	Mdelay = Mdelay - 5                'speed up ball movement
    ELSE
    	MaxRand = MaxRand + 2
    END IF
  END IF

  CALL MilliDelay(Mdelay)               'delay ball movement
LOOP

IF YourScore > HighScore THEN HighScore = YourScore
Score = 0
RandX = 0
RandY = 0

CALL PlotText("Play again? Y/N: ", CharSet(), NumElms, 0, _
							  199 - CharSet(1), 2)

IF YesOrNo THEN

	CALL DrwBox(0, 199 - CharSet(1), 319, 199,0, 0)
	CALL DrwBox(0, 0, 319, 17, 0, 0)
	CALL DisPlay(LastX, LastY, BkGnd(), 0)
  YourScore = 0
	GOTO Begin
END IF
END SUB