                        /*****     FRETRIS SOURCE CODE      *****/
                       /*****  2001 - Grumpy Gnome Software  *****/
                        /***  Website - www.grumpygnome.8m.com  ***/
                         /***   Feedback : frakilk@yahoo.com   ***/


/* this file contains all the functions for creating and manipulating the shapes
   used within the game */

#include <allegro.h>
#include <time.h>
#include <stdio.h>
#include <time.h>
#include "game.h"
#include "shape.h"
#include "blocks.h"
#include "global.h"
#include "display.h"
#include "highscore.h"




int restored_flag = 0;
int fall_time = 0;
int left_right_time = 0;
int rotate_time = 0;
int no_move = 0;  // stops any more movements being applied to the shape
int stop_level_count = 0;
int fall_time_2 = 0;
int start_fall_time_2 = 0;
int restore_rotation_flag = 0;
int no_call_block_collisions = 0;




/******************************************************************************************************/

/* timer interrupt handler for shape fall speed*/
void fall_timer() {
  fall_time++;
  }
END_OF_FUNCTION(fall_timer);




/******************************************************************************************************/

/* timer interrupt handler for shape slide duration*/
void fall_timer_2() {
  fall_time_2++;
  }
END_OF_FUNCTION(fall_timer_2);




/******************************************************************************************************/

/* timer interrupt handler for keyboard input delay
  i.e it slows keyboard input down as otherwise it is unplayable*/
void left_right_timer() {
  left_right_time++;
  }
END_OF_FUNCTION(left_right_timer);




/******************************************************************************************************/

/* timer interrupt handler for keyboard input delay
  i.e it slows keyboard input down as otherwise it is unplayable*/
void rotate_timer() {
  rotate_time++;
  }
END_OF_FUNCTION(rotate_timer);




/******************************************************************************************************/

// initialises the shape
void shape_init() {
  create_next_shape();
  create_new_shape();
  }




/******************************************************************************************************/

// creates shape that will proceed the current shape
void create_next_shape() {
  srand(time(NULL));  // this line needed so "true" random numbers can be generated
  next_shape = random()%7 + 1;  //chooses random number
  }





/******************************************************************************************************/

// allocates four unused blocks for building and builds the shape
void create_new_shape() {
  int i = 0;
  int j = 0;

  for(i=0; i<=max_blocks; i++) {   // for loop to whether there are four available
    if (blocks[i].used == 0) {     // blocks to make up the new shape
      blocks[i].used = 1;
      the_shape.building_blocks[j] = blocks[i].id;
      j++;
      }
    if (j == 4){ break;}  // if there are four blocks exit out of the for loop
    }

  the_shape.current_rotation = 0;  // initial rotation state
  the_shape.landed = 0;      // says the shape has not landed
  no_move = 0;    // says the shape is allowed left/right movement
  the_shape.type = next_shape;   // the type of shape is the same type as shape
                                 // in the "NEXT" box

  switch(the_shape.type) {
    case 1 : {
      build_shape_type_1();
      break;
      }
    case 2 : {
      build_shape_type_2();
      break;
      }
    case 3 : {
      build_shape_type_3();
      break;
      }
    case 4 : {
      build_shape_type_4();
      break;
      }
    case 5 : {
      build_shape_type_5();
      break;
      }
    case 6 : {
      build_shape_type_6();
      break;
      }
    case 7 : {
      build_shape_type_7();
      break;
      }
    }

  create_next_shape();  // create shape that will go into the "NEXT" box
  }




/******************************************************************************************************/

// updates the shape i.e x, y co-ordinates and rotation
void shape_update() {
  int i = 0;
  LOCK_FUNCTION(fall_timer);
  LOCK_VARIABLE(fall_time);
  install_int(fall_timer, fall_speed);  // installs the timer
  LOCK_FUNCTION(fall_timer_2);
  LOCK_VARIABLE(fall_time_2);
  install_int(fall_timer_2, 20);  // installs the timer
  LOCK_FUNCTION(left_right_timer);
  LOCK_VARIABLE(left_right_time);
  install_int(left_right_timer, 10);  // installs the timer
  LOCK_FUNCTION(rotate_timer);
  LOCK_VARIABLE(rotate_time);
  install_int(rotate_timer, 4);  // installs the timer

  no_call_block_collisions = 0;   // says whether or not to call block_collisions().
                                  // Needed for successful rotation

  if ((the_shape.landed == 1) && (fall_time_2 > 5)) {  // if the shape is landed
              														 // and the time permitted for
                                                       // sliding it is over
      for(i=0; i<4; i++) {
        if ((blocks[the_shape.building_blocks[i]].y) == 100) { // if blocks have reached top of screen
          stop_midi();
          game_end_flag = 1;
          draw_gray_blocks = 1;
          remove_int(fall_timer);
          remove_int(fall_timer_2);
          remove_int(left_right_timer);
          remove_int(rotate_timer);
          check_highscore();
          }
        }
      if (game_end_flag != 1) {   // if not end of game
        start_fall_time_2 = 0;    // stop fall_time_2 counter
        fall_time_2 = 0;
        no_move = 1;   // prevents left/right movement of shape
        rest(200);
        check_for_lines();   // checks for completed lines
        create_new_shape();  // creates a new shape
        }
      }


  if ((i_leftkey) || (i_rightkey)) {   // this if statement allows tighter control on
                                       // the left and right movement of the shape
   if (left_right_count == 0) {   // if left or right key has just been pressed
     if (i_leftkey) side_collisions('l');
     else if (i_rightkey) side_collisions('r');
     }
   left_right_count++;
   if (left_right_count >= 10) {  // if left or right key has been held
     if (left_right_time > 10) {  // if true, left/right movement is allowed
        left_right_time = 0;
        if (i_leftkey) side_collisions('l');
        else if (i_rightkey) side_collisions('r');
        }
      if (left_right_count > 200) left_right_count = 10; // prevents left_right_count
                                                         // from getting too high
      }
    }

  if ((!i_leftkey) && (!i_rightkey)) left_right_count = 0;

  if (rotate_time > 10) {
    rotate_time = 0;
    if (i_clockwise) {
      no_call_block_collisions = 1;  // says "do not call block_collisions()"
      if (clockwise_count == 0)
        switch(the_shape.type) {
          case 2: {
            initiate_rotate_2('c');     // note: there is no initiate_rotate_1
            break;                      //       as shape type 1 is a square
            }                           //       and therefore does not need
          case 3: {                     //       to be rotated
            initiate_rotate_3('c');
            break;
            }
          case 4: {
            initiate_rotate_4('c');
            break;
            }
          case 5: {
            initiate_rotate_5('c');
            break;
            }
          case 6: {
            initiate_rotate_6('c');
            break;
            }
          case 7: {
            initiate_rotate_7('c');
            break;
            }
        }
      clockwise_count++;
      if (clockwise_count >= 10)  // stops rotation of shape if key held

      if (clockwise_count > 200) clockwise_count = 10;
    }

    if (!i_clockwise) {     // if key is not pressed
      clockwise_count = 0;
      }

    if (i_anticlockwise) {
      if (anticlockwise_count == 0)
        switch(the_shape.type) {
          case 2: {
            initiate_rotate_2('a');     // note: there is no initiate_rotate_1
            break;                      //       as shape type 1 is a square
            }                           //       and therefore does not need
          case 3: {                     //       to be rotated
            initiate_rotate_3('a');
            break;
            }
          case 4: {
            initiate_rotate_4('a');
            break;
            }
          case 5: {
            initiate_rotate_5('a');
            break;
            }
          case 6: {
            initiate_rotate_6('a');
            break;
            }
          case 7: {
            initiate_rotate_7('a');
            break;
            }
        }
      anticlockwise_count++;
      if (anticlockwise_count >= 10)  // stops rotation of shape if key held

      if (anticlockwise_count > 200) anticlockwise_count = 10;
    }
    if (!i_anticlockwise) {    // if key is not pressed
      anticlockwise_count = 0;
      }
  }

    if (i_downkey) {
      downkey_count++;
      if (downkey_count >= 10) block_collisions();   // needed so that shape will
                                                     // start to fall when the down
                                                     // key is held for a small
                                                     // period of time
      if (downkey_count > 200) downkey_count = 10;
      }

    if (!i_downkey) {
      downkey_count = 0;
      }

    if (no_call_block_collisions != 1)
      if (fall_time >= 2) block_collisions();

 }




/******************************************************************************************************/

// this function checks first to see if the shape has hit the bottom of the
//  game area and if not checks to see if the shape is colliding with any of
//  the other blocks
void block_collisions() {

  int i = 0, j = 0, h = 0, self_blocks = 0;
  fall_time = 0;
  the_shape.landed = 0;

  // loop concentrates on one block of the shape at a time
  for(i=0; i<4; i++) {
    //next line checks if the shape is hitting the bottom of the game area
    if (((blocks[the_shape.building_blocks[i]].y + 15) > boundary_array[3])) {
      if (start_fall_time_2 != 1) {
        start_fall_time_2 = 1;
        fall_time_2 = 0;
        }
      the_shape.landed = 1;
      }

    //loop checks block of the shape against every other block on the screen
    for(j=0; j<=max_blocks; j++) {
      self_blocks = 0;
      // loop checks if current block of the shape is being checked against itself
      for(h=0; h<4; h++)
        if ((blocks[the_shape.building_blocks[h]].id) == blocks[j].id)
          self_blocks = 1;

      if (self_blocks != 1) // if not itself
        if (blocks[j].used == 1)  //if block on-screen
          // next three lines check that if the current block of the shape is
          // moved down by 15 pixels and it is on the same x co-ordinate as
          // the block being examined that the shape is marked as landed
          if (((blocks[the_shape.building_blocks[i]].y + 15) == blocks[j].y)
              && (blocks[the_shape.building_blocks[i]].x == blocks[j].x)) {
            if (start_fall_time_2 != 1) {
              start_fall_time_2 = 1;
              fall_time_2 = 0;
              }
            the_shape.landed = 1;
            }
      }
    }

    if (the_shape.landed != 1) {  // if the shape is not landed move down
      for(i=0; i<4; i++)
        blocks[the_shape.building_blocks[i]].y += 15;
      start_fall_time_2 = 0;
      fall_time_2 = 0;
      }
 }




/******************************************************************************************************/

// sometimes if a shape is rotated and marked as landed it can end up in
// mid-air. This function prevents this. It is very similar in structure
// to block_collisions() except for the final few lines
void rotate_block_collisions() {

  int i = 0, j = 0, h = 0, self_blocks = 0;
  the_shape.landed = 0;

  // loop concentrates on one block of the shape at a time
  for(i=0; i<4; i++) {
    //next line checks if the shape is hitting the bottom of the game area
    if (((blocks[the_shape.building_blocks[i]].y + 15) > boundary_array[3])) {
      if (start_fall_time_2 != 1) {
        start_fall_time_2 = 1;
        fall_time_2 = 0;
        }
      the_shape.landed = 1;
      }

    //loop checks block of the shape against every other block on the screen
    for(j=0; j<=max_blocks; j++) {
      self_blocks = 0;
      // loop checks if current block of the shape is being checked against itself
      for(h=0; h<4; h++)
        if ((blocks[the_shape.building_blocks[h]].id) == blocks[j].id)
          self_blocks = 1;

      if (self_blocks != 1) // if not itself
        if (blocks[j].used == 1)  //if block on-screen
          // next three lines check that if the current block of the shape is
          // moved down by 15 pixels and it is on the same x co-ordinate as
          // the block being examined that the shape is marked as landed
          if (((blocks[the_shape.building_blocks[i]].y + 15) == blocks[j].y)
              && (blocks[the_shape.building_blocks[i]].x == blocks[j].x)) {
            if (start_fall_time_2 != 1) {
              start_fall_time_2 = 1;
              fall_time_2 = 0;
              }
            the_shape.landed = 1;
            }
      }
    }

    if (the_shape.landed != 1) {  // if the shape is not landed move down
      if (fall_time > 2) {
        for(i=0; i<4; i++)
          blocks[the_shape.building_blocks[i]].y += 15;
        start_fall_time_2 = 0;
        fall_time_2 = 0;
        }
      }

 }




/******************************************************************************************************/

// very similar to the block_collisions function
void side_collisions(char direction) {

  int i = 0, j = 0, h = 0, k = 0, self_blocks = 0, move_side_flag = 0;
  move_side_flag = 1;

  if (no_move != 1) {

    // loop concentrates on one block of the shape at a time
    for(i=0; i<4; i++) {
      //loop checks block of the shape against every other block on the screen
      for(j=0; j<=max_blocks; j++) {
        self_blocks = 0;
         // loop checks if current block of the shape is being checked against itself
        for(h=0; h<4; h++)
          if ((blocks[the_shape.building_blocks[h]].id) == blocks[j].id) self_blocks = 1;

        switch(direction) {
          case 'l': {
            if (self_blocks != 1)  // if not itself
              if (blocks[j].used == 1)  //if block on-screen
                // next three lines check that if the current block of the shape is
                // moved left by 15 pixels and it is on the same y co-ordinate as
                // the block being examined that a flag is set disallowing the
                // shape to be moved to the left
                if (((blocks[the_shape.building_blocks[i]].x - 15) == blocks[j].x)
                  && (blocks[the_shape.building_blocks[i]].y == blocks[j].y))
                    move_side_flag = 0;
            break;
            }
          case 'r': {
            if (self_blocks != 1)  // if not itself
              if (blocks[j].used == 1)  //if block on-screen
                // next three lines check that if the current block of the shape is
                // moved right by 15 pixels and it is on the same y co-ordinate as
                // the block being examined that a flag is set disallowing the
                // shape to be moved to the right
                if (((blocks[the_shape.building_blocks[i]].x + 15) == blocks[j].x)
                  && (blocks[the_shape.building_blocks[i]].y == blocks[j].y))
                    move_side_flag = 0;
            break;
            }
          }
        }
      }

      if (move_side_flag == 1)  // can move to the left or right
        switch(direction) {
          case 'l': {
            save_current_coords();
            for(k=0; k<4; k++)
              blocks[the_shape.building_blocks[k]].x -= 15;
            check_out_of_bounds(); // check whether outside of game area
            break;
            }
          case 'r': {
            save_current_coords();
            for(k=0; k<4; k++)
              blocks[the_shape.building_blocks[k]].x += 15;
            check_out_of_bounds(); // check whether outside of game area
            break;
            }
          }
    }
  }




/******************************************************************************************************/

// checks to see whether any lines have been formed. It removes them and move blocks down
void check_for_lines() {

  int i=0;
  int j=0;
  int line_amount = 0;
  int line_flash_array[20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
  int blocks_in_line=0;

  old_lines = lines;

  for(i=0; i<line_count; i++) {    // for each line in the game area
    blocks_in_line = 0;
    for(j=0; j<=max_blocks; j++) {     // for loop to check every block to see if
      											// they form a line on the current line
                                       // being examined
      if (blocks[j].used == 1)
        if (blocks[j].y == line_array[i])
          blocks_in_line++;
      }
    if (blocks_in_line == 14) {   // if there is a line on the current line being examined
      line_flash_array[i] = 1;
      }
    }

  for(i=0; i<line_count; i++) {    // for each line in the game area
    blocks_in_line = 0;

    for(j=0; j<=max_blocks; j++) {     // for loop to check every block to see if
      											// they form a line on the current line
                                       // being examined
      if (blocks[j].used == 1)
        if (blocks[j].y == line_array[i])
          blocks_in_line++;
      }

    if (blocks_in_line == 14) {   // if there is a line on the current line being examined
      lines++;  // increments the line counter
      line_amount++;
      line_flash_array[i] = 1;
      stop_level_count = 0;
      if ((lines%10 == 0) && (lines != 0) && (stop_level_count != 1)) {
          level++;
          stop_level_count = 1;
          if (level > 10) fall_speed -= 10;
          else fall_speed -= 20;
          if (fall_speed<50) fall_speed = 70;
          }

      for(j=0; j<=max_blocks; j++) {   // mark blocks on line as unused so they are not drawn
        if (blocks[j].used == 1)
          if (blocks[j].y == line_array[i])
            blocks[j].used = 0;
        }

      for(j=0; j<=max_blocks; j++) {   // move all blocks above line down
        if ((blocks[j].used == 1) && (blocks[j].y < line_array[i]))
          blocks[j].y += 15;
        }
      }
    if (blocks_in_line == 14) i = 0;
    }

    line_flash(line_flash_array);
    switch(line_amount) {
      case 1 : {
        score += 100;
        break;
        }
      case 2 : {
        score += 400;
        break;
        }
      case 3 : {
        score += 1000;
        break;
        }
      case 4 : {
        score += 2000;
        break;
        }
      }
  }




/******************************************************************************************************/

// function to set the initial x, y block co-ordinates and colour for shape 1.
void build_shape_type_1() {
  blocks[the_shape.building_blocks[0]].x = 190;
  blocks[the_shape.building_blocks[0]].y = 100;
  blocks[the_shape.building_blocks[1]].x = 190;
  blocks[the_shape.building_blocks[1]].y = 115;
  blocks[the_shape.building_blocks[2]].x = 205;
  blocks[the_shape.building_blocks[2]].y = 100;
  blocks[the_shape.building_blocks[3]].x = 205;
  blocks[the_shape.building_blocks[3]].y = 115;
  blocks[the_shape.building_blocks[0]].block_bitmap = 1;
  blocks[the_shape.building_blocks[1]].block_bitmap = 1;
  blocks[the_shape.building_blocks[2]].block_bitmap = 1;
  blocks[the_shape.building_blocks[3]].block_bitmap = 1;
  }




/******************************************************************************************************/

// function to set the initial x, y block co-ordinates and colour for shape 2.
void build_shape_type_2() {
  blocks[the_shape.building_blocks[0]].x = 190;
  blocks[the_shape.building_blocks[0]].y = 100;
  blocks[the_shape.building_blocks[1]].x = 190;
  blocks[the_shape.building_blocks[1]].y = 115;
  blocks[the_shape.building_blocks[2]].x = 175;
  blocks[the_shape.building_blocks[2]].y = 100;
  blocks[the_shape.building_blocks[3]].x = 205;
  blocks[the_shape.building_blocks[3]].y = 100;
  blocks[the_shape.building_blocks[0]].block_bitmap = 2;
  blocks[the_shape.building_blocks[1]].block_bitmap = 2;
  blocks[the_shape.building_blocks[2]].block_bitmap = 2;
  blocks[the_shape.building_blocks[3]].block_bitmap = 2;
  }




/******************************************************************************************************/

// function to set the initial x, y block co-ordinates and colour for shape 3.
void build_shape_type_3() {
  blocks[the_shape.building_blocks[0]].x = 175;
  blocks[the_shape.building_blocks[0]].y = 100;
  blocks[the_shape.building_blocks[1]].x = 190;
  blocks[the_shape.building_blocks[1]].y = 100;
  blocks[the_shape.building_blocks[2]].x = 205;
  blocks[the_shape.building_blocks[2]].y = 100;
  blocks[the_shape.building_blocks[3]].x = 220;
  blocks[the_shape.building_blocks[3]].y = 100;
  blocks[the_shape.building_blocks[0]].block_bitmap = 3;
  blocks[the_shape.building_blocks[1]].block_bitmap = 3;
  blocks[the_shape.building_blocks[2]].block_bitmap = 3;
  blocks[the_shape.building_blocks[3]].block_bitmap = 3;
  }




/******************************************************************************************************/

// function to set the initial x, y block co-ordinates and colour for shape 4.
void build_shape_type_4() {
  blocks[the_shape.building_blocks[0]].x = 190;
  blocks[the_shape.building_blocks[0]].y = 100;
  blocks[the_shape.building_blocks[1]].x = 205;
  blocks[the_shape.building_blocks[1]].y = 100;
  blocks[the_shape.building_blocks[2]].x = 175;
  blocks[the_shape.building_blocks[2]].y = 115;
  blocks[the_shape.building_blocks[3]].x = 190;
  blocks[the_shape.building_blocks[3]].y = 115;
  blocks[the_shape.building_blocks[0]].block_bitmap = 4;
  blocks[the_shape.building_blocks[1]].block_bitmap = 4;
  blocks[the_shape.building_blocks[2]].block_bitmap = 4;
  blocks[the_shape.building_blocks[3]].block_bitmap = 4;
  }




/******************************************************************************************************/

// function to set the initial x, y block co-ordinates and colour for shape 5.
void build_shape_type_5() {
  blocks[the_shape.building_blocks[0]].x = 190;
  blocks[the_shape.building_blocks[0]].y = 100;
  blocks[the_shape.building_blocks[1]].x = 175;
  blocks[the_shape.building_blocks[1]].y = 100;
  blocks[the_shape.building_blocks[2]].x = 205;
  blocks[the_shape.building_blocks[2]].y = 115;
  blocks[the_shape.building_blocks[3]].x = 190;
  blocks[the_shape.building_blocks[3]].y = 115;
  blocks[the_shape.building_blocks[0]].block_bitmap = 5;
  blocks[the_shape.building_blocks[1]].block_bitmap = 5;
  blocks[the_shape.building_blocks[2]].block_bitmap = 5;
  blocks[the_shape.building_blocks[3]].block_bitmap = 5;
  }




/******************************************************************************************************/

// function to set the initial x, y block co-ordinates and colour for shape 6.
void build_shape_type_6() {
  blocks[the_shape.building_blocks[0]].x = 175;
  blocks[the_shape.building_blocks[0]].y = 100;
  blocks[the_shape.building_blocks[1]].x = 190;
  blocks[the_shape.building_blocks[1]].y = 100;
  blocks[the_shape.building_blocks[2]].x = 205;
  blocks[the_shape.building_blocks[2]].y = 100;
  blocks[the_shape.building_blocks[3]].x = 205;
  blocks[the_shape.building_blocks[3]].y = 115;
  blocks[the_shape.building_blocks[0]].block_bitmap = 6;
  blocks[the_shape.building_blocks[1]].block_bitmap = 6;
  blocks[the_shape.building_blocks[2]].block_bitmap = 6;
  blocks[the_shape.building_blocks[3]].block_bitmap = 6;
  }




/******************************************************************************************************/

// function to set the initial x, y block co-ordinates and colour for shape 7.
void build_shape_type_7() {
  blocks[the_shape.building_blocks[0]].x = 175;
  blocks[the_shape.building_blocks[0]].y = 100;
  blocks[the_shape.building_blocks[1]].x = 190;
  blocks[the_shape.building_blocks[1]].y = 100;
  blocks[the_shape.building_blocks[2]].x = 205;
  blocks[the_shape.building_blocks[2]].y = 100;
  blocks[the_shape.building_blocks[3]].x = 175;
  blocks[the_shape.building_blocks[3]].y = 115;
  blocks[the_shape.building_blocks[0]].block_bitmap = 7;
  blocks[the_shape.building_blocks[1]].block_bitmap = 7;
  blocks[the_shape.building_blocks[2]].block_bitmap = 7;
  blocks[the_shape.building_blocks[3]].block_bitmap = 7;
  }




/******************************************************************************************************/

// function which calls the relevant rotation function for shape 2
void initiate_rotate_2(char rot_type) {
  save_current_coords();
  switch(the_shape.current_rotation) {
    case 0: {
      shape_2_rot_0(rot_type);
      break;
      }
    case 1: {
      shape_2_rot_1(rot_type);
      break;
      }
    case 2: {
      shape_2_rot_2(rot_type);
      break;
      }
    case 3: {
      shape_2_rot_3(rot_type);
      break;
      }
    }
  check_out_of_bounds();
  }




/******************************************************************************************************/

// function which calls the relevant rotation function for shape 3
void initiate_rotate_3(char rot_type) {
  save_current_coords();
  switch(the_shape.current_rotation) {
    case 0: {
      shape_3_rot_0(rot_type);
      break;
      }
    case 1: {
      shape_3_rot_1(rot_type);
      break;
      }
    }
  check_out_of_bounds();
  }




/******************************************************************************************************/

// function which calls the relevant rotation function for shape 4
void initiate_rotate_4(char rot_type) {
  save_current_coords();
  switch(the_shape.current_rotation) {
    case 0: {
      shape_4_rot_0(rot_type);
      break;
      }
    case 1: {
      shape_4_rot_1(rot_type);
      break;
      }
    }
  check_out_of_bounds();
  }




/******************************************************************************************************/

// function which calls the relevant rotation function for shape 5
void initiate_rotate_5(char rot_type) {
  save_current_coords();
  switch(the_shape.current_rotation) {
    case 0: {
      shape_5_rot_0(rot_type);
      break;
      }
    case 1: {
      shape_5_rot_1(rot_type);
      break;
      }
    }
  check_out_of_bounds();
  }




/******************************************************************************************************/

// function which calls the relevant rotation function for shape 6
void initiate_rotate_6(char rot_type) {
  save_current_coords();
  switch(the_shape.current_rotation) {
    case 0: {
      shape_6_rot_0(rot_type);
      break;
      }
    case 1: {
      shape_6_rot_1(rot_type);
      break;
      }
    case 2: {
      shape_6_rot_2(rot_type);
      break;
      }
    case 3: {
      shape_6_rot_3(rot_type);
      break;
      }
    }
  check_out_of_bounds();
  }




/******************************************************************************************************/

// function which calls the relevant rotation function for shape 7
void initiate_rotate_7(char rot_type) {
  save_current_coords();
  switch(the_shape.current_rotation) {
    case 0: {
      shape_7_rot_0(rot_type);
      break;
      }
    case 1: {
      shape_7_rot_1(rot_type);
      break;
      }
    case 2: {
      shape_7_rot_2(rot_type);
      break;
      }
    case 3: {
      shape_7_rot_3(rot_type);
      break;
      }
    }
  check_out_of_bounds();
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 0
void shape_2_rot_0(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y -= 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].x -= 15;
    blocks[the_shape.building_blocks[3]].y += 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 1;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y -= 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].x -= 15;
    blocks[the_shape.building_blocks[3]].y -= 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 3;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 1
void shape_2_rot_1(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y -= 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].x -= 15;
    blocks[the_shape.building_blocks[3]].y -= 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 2;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y += 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].x += 15;
    blocks[the_shape.building_blocks[3]].y -= 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 0;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 2
void shape_2_rot_2(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y += 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].x += 15;
    blocks[the_shape.building_blocks[3]].y -= 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 3;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y += 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].x += 15;
    blocks[the_shape.building_blocks[3]].y += 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 1;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 3
void shape_2_rot_3(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y += 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].x += 15;
    blocks[the_shape.building_blocks[3]].y += 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 0;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y -= 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].x -= 15;
    blocks[the_shape.building_blocks[3]].y += 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 2;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 0
void shape_3_rot_0(char direction) {
  if ((direction == 'c') || (direction == 'a')) {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y += 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].x -= 30;
    blocks[the_shape.building_blocks[3]].y -= 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 1;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 1
void shape_3_rot_1(char direction) {
  if ((direction == 'c') || (direction == 'a')) {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y -= 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].x += 30;
    blocks[the_shape.building_blocks[3]].y += 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 0;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 0
void shape_4_rot_0(char direction) {
  if ((direction == 'c') || (direction == 'a')) {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y += 15;
    blocks[the_shape.building_blocks[2]].y -= 30;
    blocks[the_shape.building_blocks[3]].x -= 15;
    blocks[the_shape.building_blocks[3]].y -= 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 1;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 1
void shape_4_rot_1(char direction) {
  if ((direction == 'c') || (direction == 'a')) {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y -= 15;
    blocks[the_shape.building_blocks[2]].y += 30;
    blocks[the_shape.building_blocks[3]].x += 15;
    blocks[the_shape.building_blocks[3]].y += 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 0;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 0
void shape_5_rot_0(char direction) {
  if ((direction == 'c') || (direction == 'a')) {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y += 15;
    blocks[the_shape.building_blocks[2]].y -= 30;
    blocks[the_shape.building_blocks[3]].x += 15;
    blocks[the_shape.building_blocks[3]].y -= 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 1;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 1
void shape_5_rot_1(char direction) {
  if ((direction == 'c') || (direction == 'a')) {
    save_current_coords();
    blocks[the_shape.building_blocks[1]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[1]].y -= 15;
    blocks[the_shape.building_blocks[2]].y += 30;
    blocks[the_shape.building_blocks[3]].x -= 15;
    blocks[the_shape.building_blocks[3]].y += 15;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 0;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 0
void shape_6_rot_0(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y -= 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].x -= 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 1;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y += 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].y -= 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 3;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 1
void shape_6_rot_1(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y += 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].y -= 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 2;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y += 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].x += 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 0;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 2
void shape_6_rot_2(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y += 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].x += 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 3;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y -= 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].y += 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 1;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 3
void shape_6_rot_3(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y -= 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].y += 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 0;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y -= 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].x -= 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 2;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 0
void shape_7_rot_0(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y -= 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].y -= 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 1;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y += 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].x += 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 3;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 1
void shape_7_rot_1(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y += 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].x += 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 2;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y += 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].y += 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 0;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 2
void shape_7_rot_2(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y += 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y -= 15;
    blocks[the_shape.building_blocks[3]].y += 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 3;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y -= 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].x -= 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 1;
    }
  }




/******************************************************************************************************/

// this function rotates the shape clockwise/anticlockwise when
// the current rotation state is 3
void shape_7_rot_3(char direction) {
  if (direction == 'c') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x -= 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y -= 15;
    blocks[the_shape.building_blocks[2]].x += 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].x -= 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 0;
    }
  if (direction == 'a') {
    save_current_coords();
    blocks[the_shape.building_blocks[0]].x += 15;  // co-ordinate translations
    blocks[the_shape.building_blocks[0]].y -= 15;
    blocks[the_shape.building_blocks[2]].x -= 15;
    blocks[the_shape.building_blocks[2]].y += 15;
    blocks[the_shape.building_blocks[3]].y -= 30;
    check_out_of_bounds();
    rotation_collisions();
    rotate_block_collisions();
    if ((restored_flag != 1) && (restore_rotation_flag != 1))
      the_shape.current_rotation = 2;
    }
  }




/******************************************************************************************************/

// saves current x, y co-ordinates of all the blocks in the shape so they can
// be restored after changes
void save_current_coords() {

  int i = 0;
  for(i=0; i<4; i++) {
    blocks[the_shape.building_blocks[i]].old_x = blocks[the_shape.building_blocks[i]].x;
    blocks[the_shape.building_blocks[i]].old_y = blocks[the_shape.building_blocks[i]].y;
    }
  }




/******************************************************************************************************/

// restores old x, y co-ordinates of all the blocks in the shape
void restore_old_coords() {

  int i = 0;
  for(i=0; i<4; i++) {
    blocks[the_shape.building_blocks[i]].x = blocks[the_shape.building_blocks[i]].old_x;
    blocks[the_shape.building_blocks[i]].y = blocks[the_shape.building_blocks[i]].old_y;
    }
  }




/******************************************************************************************************/

// checks whether any of the blocks in the shape are outside of the game boundary
int check_out_of_bounds() {

  int i=0;
  restored_flag = 0;

  for(i=0; i<4; i++) {
    if (restored_flag == 1) break;
      if (blocks[the_shape.building_blocks[i]].x < boundary_array[0]) {
        restore_old_coords();
        restored_flag = 1; // to indicate old co-ordinates have been restored
        break;
        }
      if (blocks[the_shape.building_blocks[i]].x > boundary_array[2]) {
        restore_old_coords();
        restored_flag = 1; // to indicate old co-ordinates have been restored
        break;
        }
      if (blocks[the_shape.building_blocks[i]].y < boundary_array[1]) {
        restore_old_coords();
        restored_flag = 1; // to indicate old co-ordinates have been restored
        break;
        }
      if (blocks[the_shape.building_blocks[i]].y > boundary_array[3]) {
        restore_old_coords();
        restored_flag = 1; // to indicate old co-ordinates have been restored
        break;
        }
    }
  return restored_flag;
  }




/******************************************************************************************************/

// very similar to the block_collisions function
void rotation_collisions() {

  int i = 0, j = 0, h = 0, self_blocks = 0;
  restore_rotation_flag = 0;
  // loop concentrates on one block of the shape at a time

  for(i=0; i<4; i++) {
    //loop checks block of the shape against every other block on the screen

    for(j=0; j<=max_blocks; j++) {
      self_blocks = 0;

      // loop checks if current block of the shape is being checked against itself
      for(h=0; h<4; h++) if ((blocks[the_shape.building_blocks[h]].id) == blocks[j].id) self_blocks = 1;

        if (self_blocks != 1)  // if not itself
          if (blocks[j].used == 1)  //if block on-screen
            // next three lines check if the current block of the shape is
            // colliding with any other blocks which are not within the shape
            if (blocks[the_shape.building_blocks[i]].x == blocks[j].x) {
              if (blocks[the_shape.building_blocks[i]].y == blocks[j].y) {
                restore_rotation_flag = 1;
                restore_old_coords();
                }
              }
       }
    }
  }



