#ifndef gf_included_shape_h
#define gf_included_shape_h

#include <allegro.h>
#include "global.h"

typedef struct SHAPE {
  int type;  // type of shape - appearence
  int building_blocks[4];  // index into BLOCK array to show which blocks
                           // make up the shape
  int current_rotation;  // indicates current rotation state
  int landed;    // to indicate whether the block has landed
  } SHAPE;

SHAPE the_shape;

void shape_init();
void shape_update();
void create_next_shape();
void create_new_shape();
void block_collisions();
void side_collisions(char);
void check_for_lines();
void save_current_coords();
int check_out_of_bounds();
void restore_old_coords();
void rotation_collisions();
void rotate_block_collisions();

void build_shape_type_1();
void build_shape_type_2();
void build_shape_type_3();
void build_shape_type_4();
void build_shape_type_5();
void build_shape_type_6();
void build_shape_type_7();

void shape_1_rot_0(char);
void shape_1_rot_1(char);
void shape_1_rot_2(char);
void shape_1_rot_3(char);

void shape_2_rot_0(char);
void shape_2_rot_1(char);
void shape_2_rot_2(char);
void shape_2_rot_3(char);

void shape_3_rot_0(char);
void shape_3_rot_1(char);

void shape_4_rot_0(char);
void shape_4_rot_1(char);
void shape_4_rot_2(char);
void shape_4_rot_3(char);

void shape_5_rot_0(char);
void shape_5_rot_1(char);
void shape_5_rot_2(char);
void shape_5_rot_3(char);

void shape_6_rot_0(char);
void shape_6_rot_1(char);
void shape_6_rot_2(char);
void shape_6_rot_3(char);

void shape_7_rot_0(char);
void shape_7_rot_1(char);
void shape_7_rot_2(char);
void shape_7_rot_3(char);

void initiate_rotate_1(char);
void initiate_rotate_2(char);
void initiate_rotate_3(char);
void initiate_rotate_4(char);
void initiate_rotate_5(char);
void initiate_rotate_6(char);
void initiate_rotate_7(char);

#endif
