'R O B O T   R O B B E R Y   v0.6
'
'By: KeiProductions
'robotrob@keithkosh.com
'http://robotrobbery.keithkosh.com
'
'A tile-based sidescrolling platform game. To my knowledge, this is the first
'QBasic 1.1 platformer that has little to no flicker, and doesn't have black
'backgrounds! This game uses tile by tile detection, not pixel detection,
'so that way you can use any colors for background and foreground tiles...
'the colors will never have anything to do with the collision detection.
'That means more coding for me, but better, more varied graphics.
'
'To move the character:
'Left - Left Control
'Right - Left Alt
'Jump/enter doors - Right Shift (hold longer to jump higher)
'
'To navigate through the various menus, just use the arrow keys, and [Enter]
'when you want to change or select an option.
'
'W H A T ' S   N E W   I N   T H I S   V E R S I O N ? (v0.6)
'
'- Better colors, slight character redesign, new tiles. Jeff (the main
'  character) now blinks too...wow...
'
'- The whole game loop has been much better organized, allowing for easier
'  changes and less flicker, plus, well, it's more organized. There should
'  be little to no glitches now with jumping through walls and the like.
'
'- PIXEL BY PIXEL MOVEMENT/NEW KEYHANDLER! Jeff can now move pixel by pixel
'  both up and down and left and right, thanks to a new keyhandler. Although
'  this means you have to use Control and Alt and Shift now, it's a vast,
'  vast improvement. For example, the character will only jump as long as you
'  hold down the Shift key. So there's much better control...which you have
'  to have to make a real platform game. What was I thinking of before?...
'
'- A couple of things reorganized in the main menu, and Help is now available
'  (well, at least it tells you what keys to use...)
'
'- New level. Sorry this one is so short but I was under pressure from...
'  er...myself...to get the new version out. Oh, well. It's a lot less
'  tiley-looking, I suppose...
'
'- Press a...uh..certain key, and you can see the sky fade from day to night,
'  and the streetlights come on. This will probably be used in the final
'  version when you get to a certain point in the level..fornow just press
'  the excl-- I mean, the "special key."
'
'W H A T   I   H O P E   T O   H A V E :
'(In the final version)
'  8 levels, through 4 different worlds. The worlds will most likely be a
'   city world, an ice world, a cave world ? [probably not...maybe desert, or
'   jungle], and a future world. Not neccesarily in that order.
'
'  HOPE to have a boss at the end. BUT, with QBasic's limited memory,
'   I might not be able to make a boss how I want it (i.e. being taller than
'   the screen)...so...we'll see.
'
'  Custom font, more items, more interactive levels...things like color-
'   coded switches a'la Super Mario might be coming in the future.
'
'  Cinemas in between worlds. I'm sure I can do this fairly easily...
'
'S T O R Y

'  Jeff was hard at work on his game until the doorbell rang. He ignored it
'at first, but when it rang a few more times Jeff figured it probably wasn't
'a salesman. Maybe it was even someone important. So he reluctantly got up
'from his computer, hopefully not for any long period of time, and walked
'over to the door.
'  Jeff opened the door, and blinked his eyes, dumbfounded, because there
'in front of him was a huge 500 pixel tall robot.
'  "Well...this is slightly unusual," Jeff commented. "And what can I do for
'you?"
'  "I AM V-T-A-F-R ROBOT," the robot said in his metallic monotone voice.
'  "V-T-A-F-R," Jeff repeated. "And that stands for..."
'  "VERY TALL AND FEARSOME ROBOT."
'  "Oh," Jeff replied, "well, that makes sense. Anyway, I'm kind of in the
'middle of a programming project, so if you would tell me why you're
'here..."
'  "THERE WILL BE NO MORE PROGRAMMING!" the robot said, louder, almost in
'an angry tone.
'  "No? Um...but...I'm actually pretty good at it...there's no reason to
'get offended--"
'  Jeff obviously misunderstood the robot, because at that moment a huge
'laser shot from the robot's armor and at Jeff's roof. There was a huge
'explosion and when the smoke cleared, Jeff's house was in pieces! Jeff's
'computer was also mysteriously gone, with no debris or anything to indicate
'that it had been demolished.
'  "So much for my electricity bill! What have you done?! I bet I can program
'better then you could, any day! And where's my computer?...
'  "IT IS IN MY POSSESION! YOU WILL NEVER RETAIN IT!"
'  With that, the robot just walked away. The nerve of it all! Jeff stood
'there, obviously trying to make sense of, well, anything that had happened
'in the last couple of minutes. He came to the conclusion that there was no
'reasonable conclusion.
'  Interrupting Jeff's thoughts, a CTIUTV truck pulled up and a reporter and
'cameraman jumped out.
'  "I'm live from the scene for CTIUTV, coverage that is unparalelled, at the
'scene of what was once a house in one piece. Now all that's left is a whole
'lot of pieces. Ahem. The cause of this has been an giant robot from unknown
'locations, who is obviously bent on destroying houses and stealing
'computers, and seems to be assisted by a lot of smaller type robots -- oh,
'now we have some LIVE shots of the robot destroying many of the other
'houses!.."
'  Jeff ran up to the reporter. "Aren't you going to DO something?!"
'  The reporter turned to Jeff. "Here's the first reported victim, sorry
'but I didn't catch your name--"
'  "Jeff, and I--"
'  "Jeff, the owner of this first house turned scrap heap. How do you feel at
'  a moment like this?..."
'  Jeff paused a moment, thinking things over in his head. `I'm the first
'victim. This robot is stealing computers. I have a chance to get my computer
'back. So this all means...'
'  "I feel like saving the city, that's what I feel like. I'm going to get
'that robot back and get the computers back!"
'  The reporter raised an eyebrow and watched as Jeff left the scene.
'  "...We'll be back after this commercial break..."
'
'This is subject to some slight changes in the final version, but will most
'likely be the same kind of thing. =)
'
'Enjoy the demo...
'
'

DEFINT A-Z

DECLARE SUB fadein ()
DECLARE SUB fadeout ()
DECLARE SUB changecolor (pal, r, g, B)
DECLARE SUB GetColValues ()
DECLARE SUB getcolor (pal, r, g, B)
DECLARE SUB SetColsBlack ()
DECLARE SUB drawtile (scrx, scry, x, y)
DECLARE SUB DrawTile2 (scrx, scry, x, y)
DECLARE SUB GetPixCords (x, y)
DECLARE SUB LoadLevel ()
DECLARE SUB MoveEnemies ()
DECLARE SUB ShowEnemies ()
DECLARE SUB putcharacter ()
DECLARE SUB putenemy (N, x, y, t)
DECLARE SUB EndProgram ()
DECLARE SUB scrollback (What$)
DECLARE SUB MainMenu ()
DECLARE SUB GameOver ()
DECLARE SUB Init ()
DECLARE SUB GameLoop ()
DECLARE SUB SetCPalette ()
DECLARE SUB ScreenWipe ()
DECLARE SUB secondpause (second!)
DECLARE SUB CharMoveHoriz ()
DECLARE SUB CheckForKeyPress ()
DECLARE SUB updatescore ()
DECLARE SUB CharMoveVert ()
DECLARE SUB GetCharStats ()
DECLARE SUB DrawLevel ()
DECLARE SUB CFScreenScroll ()
DECLARE SUB GetItem (x, y)
DECLARE SUB GetTileSet (filename$)

TYPE paldata
 red AS SINGLE
 green AS SINGLE
 blue AS SINGLE
END TYPE

TYPE enemy
 pixelx AS INTEGER
 pixely AS INTEGER
 direction AS INTEGER
 walkstate AS INTEGER
 onscreen AS INTEGER
 alive AS INTEGER
 squished AS INTEGER
END TYPE

RANDOMIZE TIMER

DIM SHARED title&(1485), menuchoice$(6), mainanim, specialmode
DIM SHARED losealife

CONST leftk = 1, rightk = 2, Upk = 3, leftupk = 4, rightupk = 5, esck = 6

DIM SHARED enemy(1 TO 11) AS enemy
DIM SHARED enemy2(1 TO 11) AS enemy
DIM SHARED enemiesinlevel, enemiesinlevel2
DIM SHARED ecoverup&(11 * 65), dontdrawchar, putchar
DIM SHARED ecoverup2&(11 * 65)
DIM SHARED changevalue(1 TO 254) AS paldata
DIM SHARED fadestep, stepx, stepy, originalface
DIM SHARED startx, starty, startscrx, startscry, doesitscrollup, facing
DIM SHARED xpos, ypos, walking, objectx, objecty, wtputx, wtputy, lives
DIM SHARED falling, jumping, bounce, soundison, levelheight, CDs
DIM SHARED levelpixelx, levelpixely, originalx, originaly, gamedelay
DIM SHARED xtilepos!, ytilepos!, charredraw, oldcx, oldcy, scorechanged, score

DIM SHARED scr$(1 TO 50)
DIM SHARED layer2$(1 TO 50)

DIM SHARED cdsmall&(14), charsmall&(16), cd&(66), cdm&(66), backg&(66)
DIM SHARED exitsign&(66)

DIM SHARED bg&(21 * 66), fgwalkon&(11 * 66), fgcgthru&(21 * 66)
DIM SHARED losealife&(6 * 66), objnm&(11 * 66), objwm&(11 * 66)

DIM SHARED enemyp1&(3 * 68), enemyp2&(3 * 68)
DIM SHARED enemyp1m&(3 * 68), enemyp2m&(3 * 68)
DIM SHARED enemyflat&(3 * 68), enemyflatm&(3 * 68)
DIM SHARED spikeb&(3 * 68), spikebm&(3 * 68)

DIM SHARED difr!(12), difg!(12), difb!(12)
DIM SHARED origr(12), origg(12), origb(12)

DIM SHARED charstanding&(3 * 190), charstandmask&(3 * 190), coverup&(190)
DIM SHARED charwalking&(3 * 190), charwalkmask&(3 * 190)
DIM SHARED charjump&(3 * 190), charjumpmask&(3 * 190)

DIM SHARED walkon$, cantgothru$, losealife$, bonusitems$, offsetx, offsety
DIM SHARED keypress, jp, jcount, dir, passlevel

CONST right = 1, left = 2
CONST charheight = 32
walkon$ = "0123456789"  '-----------> These are the tiles you can walk on (go
                                     'on top of)
cantgothru$ = "ABCDEFGHIJKLMNOPQRST" 'These are the tiles you can walk on
                                     'AND can't go thru
bonusitems$ = "C"    '--------------> Items such as lives, CDs, etc...
losealife$ = "VWXYZ"   '------------> These are the tiles that if you walk
                                     'on, you lose a life

fadestep = 20
soundison = 1
gamedelay = 0   'The game *should* be the same speed on all computers but
                'if it's not, you can add to this...

offsetx = 15 'How far the top of the screen is from where the tiles show
offsety = 5 'How far the left of the screen is from where the tiles show

SCREEN 13

Init
SetCPalette

FOR a = 130 TO 142
 getcolor a, r, g, B
 origr(a - 130) = r
 origg(a - 130) = g
 origb(a - 130) = B
NEXT a

CLS

GetColValues

DO

 MainMenu
 GameLoop

LOOP

mmanimstuff:
mainanim = 1
TIMER OFF
RETURN

SUB CFScreenScroll

IF wtputx >= 212 THEN
 IF xpos < LEN(scr$(1)) - 18 THEN
  xpos = xpos + 1
  scr = 1
 END IF
END IF

IF wtputx <= 90 THEN
 IF xpos > 0 THEN
  xpos = xpos - 1
  scr = 1
 END IF
END IF

IF wtputy <= 37 THEN
 IF levelheight - 11 > ypos THEN
  ypos = ypos + 1
  scr = 1
 END IF
END IF

IF wtputy >= 117 THEN
 IF ypos > 0 THEN
 ypos = ypos - 1
 scr = 1
 END IF
END IF

IF scr = 1 THEN
 DrawLevel
 GetCharStats
 GET (wtputx, wtputy)-(wtputx + 15, wtputy + 31), coverup&
 charredraw = 0
END IF

END SUB

SUB changecolor (pal, r, g, B)

OUT &H3C8, pal
OUT &H3C9, r
OUT &H3C9, g
OUT &H3C9, B

END SUB

SUB CharMoveHoriz

IF keypress = rightk OR keypress = rightupk THEN dest = 1: MoveOK = 1
IF keypress = leftk OR keypress = leftupk THEN dest = 0: MoveOK = 1

GetCharStats
yt = INT(ytilepos!)
xt = INT(xtilepos!)

ntcheck = 0
IF levelpixelx MOD 16 = 12 AND dest = 0 THEN ntcheck = 1
IF levelpixelx MOD 16 = 4 AND dest = 1 THEN ntcheck = 1

IF levelpixely = 48 THEN
 bounce = 0: jumping = 0: falling = 1
END IF

IF levelpixely MOD 16 = 0 THEN
 IF levelpixely / 16 = levelheight + 1 THEN
  losealife = 1
  EXIT SUB
 END IF
END IF

IF levelpixelx <= 0 AND dest = 0 THEN
 IF walking > 0 THEN oldcx = wtputx: oldcy = wtputy: charredraw = 1
 walking = 0: ntcheck = 0: MoveOK = 0
END IF

IF dest = 1 AND levelpixelx MOD 16 = 0 AND levelpixelx / 16 = LEN(scr$(1)) - 1 THEN
 IF walking > 0 THEN oldcx = wtputx: oldcy = wtputy: charredraw = 1
 walking = 0: ntcheck = 0: MoveOK = 0
END IF

IF ntcheck = 1 THEN
IF INSTR(cantgothru$, (MID$(scr$(yt - 1), xt + dest, 1))) THEN
 MoveOK = 0
 IF walking > 0 THEN oldcx = wtputx: oldcy = wtputy: charredraw = 1
 walking = 0
ELSEIF INSTR(cantgothru$, (MID$(scr$(yt - 2), xt + dest, 1))) THEN
 MoveOK = 0
 IF walking > 0 THEN oldcx = wtputx: oldcy = wtputy: charredraw = 1
 walking = 0
END IF

IF levelpixely MOD 16 > 0 THEN
  IF INSTR(cantgothru$, (MID$(scr$(yt), xt + dest, 1))) THEN MoveOK = 0
END IF
END IF

IF MoveOK = 1 THEN
 oldcx = wtputx: oldcy = wtputy
 IF dest = 0 THEN dest = -1
 levelpixelx = levelpixelx + dest
 charredraw = 1
ELSE
 oldcx = wtputx: oldcy = wtputy
END IF

FOR a = 1 TO enemiesinlevel2
 IF enemy2(a).onscreen = 1 THEN
  IF levelpixelx >= enemy2(a).pixelx - 11 AND levelpixelx <= enemy2(a).pixelx + 11 THEN
   IF (levelpixely + 16) >= enemy2(a).pixely THEN
    IF (levelpixely - charheight) <= enemy2(a).pixely THEN
     wx = enemy2(a).pixelx - (xpos * 16) + offsetx
     wy = enemy2(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
     PUT (wx, wy), ecoverup2&(a * 65), PSET
     putenemy a, wx, wy, 2
     losealife = 1
     EXIT SUB
    END IF
   END IF
  END IF
 END IF
NEXT a

FOR a = 1 TO enemiesinlevel
 IF enemy(a).onscreen = 1 AND enemy(a).alive = 1 THEN
  IF (levelpixely + 16) >= enemy(a).pixely AND levelpixely <= enemy(a).pixely THEN
   IF enemy(a).pixelx >= (levelpixelx - 13) AND enemy(a).pixelx <= (levelpixelx + 13) THEN
    'see if you jumped on him or not
    IF (levelpixely + 16) = enemy(a).pixely THEN
     IF falling = 1 OR (jumping = 1 AND dir = 0) THEN
      enemy(a).alive = 0: enemy(a).squished = 1
      wx = enemy(a).pixelx - (xpos * 16) + offsetx
      wy = enemy(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
      PUT (wx, wy), ecoverup&(a * 65), PSET
      jumping = 0: falling = 0
      bounce = 1: jcount = 0: jp = levelpixely: goneenemy = a
      IF soundison = 1 THEN SOUND 200, .8: SOUND 150, .8: SOUND 100, .8
      score = score + 50: scorechanged = 1
      END IF
    ELSE
     wx = enemy(a).pixelx - (xpos * 16) + offsetx
     wy = enemy(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
     PUT (wx, wy), ecoverup&(a * 65), PSET
     putenemy a, wx, wy, 1
     losealife = 1
     EXIT SUB
    END IF
   END IF
  END IF
 END IF
NEXT a

END SUB

SUB CharMoveVert

GetCharStats
yt = INT(ytilepos!)
xt = INT(xtilepos!)

IF xtilepos! > xt THEN
 check1tile = 0
 IF levelpixelx MOD 16 >= 12 AND levelpixelx MOD 16 <= 15 THEN
  check1tile = 1: xt = xt + 1
 END IF
IF levelpixelx MOD 16 <= 4 AND levelpixelx MOD 16 >= 1 THEN check1tile = 1
ELSE
 check1tile = 1
END IF

'Check for collision detection with items (such as coins)
IF ytilepos! <> yt THEN check3ytiles = 1
IF check1tile = 0 THEN check2xtiles = 1

FOR a = 0 TO check2xtiles
 cr$ = MID$(layer2$(yt - 1), xt + a, 1)
 IF cr$ = "" THEN cr$ = " "
 IF INSTR(bonusitems$, cr$) THEN GetItem xt + a, yt - 1
 cr$ = MID$(layer2$(yt - 2), xt + a, 1)
 IF cr$ = "" THEN cr$ = " "
 IF INSTR(bonusitems$, cr$) THEN GetItem xt + a, yt - 2
 cr$ = MID$(layer2$(yt), xt + a, 1)
 IF cr$ = "" THEN cr$ = " "
 IF check3ytiles = 1 THEN IF INSTR(bonusitems$, cr$) THEN GetItem xt + a, yt
NEXT a

'Check if the level has been passed (jump pressed when by a door)

IF check2xtiles = 0 AND levelpixely MOD 16 = 0 THEN
 IF MID$(scr$(yt - 1), xt, 1) = "#" AND MID$(scr$(yt - 2), xt, 1) = "#" THEN
  IF keypress = Upk OR keypress = leftupk OR keypress = rightupk THEN
   jumping = 0: passlevel = 1
   levelpixelx = (xt - 1) * 16: charredraw = 1
  END IF
 END IF
END IF

'Other collision detection when falling/jumping/bouncing/etc

MoveOK = 1

IF levelpixely MOD 16 = 0 THEN

IF (jumping = 1 AND dir = 1) OR bounce = 1 THEN
 IF check1tile = 0 AND INSTR(cantgothru$, (MID$(scr$(yt - 3), xt + 1, 1))) THEN
  IF jumping = 1 THEN
   dir = 0: jp = levelpixely - 1
   MoveOK = 0
  ELSE
   bounce = 0: jumping = 1: dir = 0: jp = levelpixely - 1
   MoveOK = 0
  END IF
 END IF
 IF INSTR(cantgothru$, (MID$(scr$(yt - 3), xt, 1))) THEN
  IF jumping = 1 THEN
   dir = 0: jp = levelpixely - 1
   MoveOK = 0
  ELSE
   bounce = 0: jumping = 1: dir = 0: jp = levelpixely - 1
   MoveOK = 0
  END IF
 END IF
ELSEIF falling = 1 OR (jumping = 1 AND dir = 0) THEN
 IF check1tile = 0 AND (INSTR(walkon$, (MID$(scr$(yt), xt + 1, 1))) OR INSTR(cantgothru$, (MID$(scr$(yt), xt + 1, 1)))) THEN
  IF jumping = 1 THEN jumping = 0
  falling = 0: charredraw = 1: MoveOK = 0
 END IF
 IF INSTR(walkon$, (MID$(scr$(yt), xt, 1))) OR INSTR(cantgothru$, (MID$(scr$(yt), xt, 1))) THEN
  IF jumping = 1 THEN jumping = 0
  falling = 0: charredraw = 1: MoveOK = 0
 END IF
ELSEIF falling = 0 AND jumping = 0 AND bounce = 0 THEN
 IF check1tile = 0 THEN
 IF INSTR(walkon$, (MID$(scr$(yt), xt + 1, 1))) = 0 AND INSTR(cantgothru$, (MID$(scr$(yt), xt + 1, 1))) = 0 THEN
  falling = 1: charredraw = 1: MoveOK = 0
 END IF
 END IF
 IF INSTR(walkon$, (MID$(scr$(yt), xt, 1))) = 0 AND INSTR(cantgothru$, (MID$(scr$(yt), xt, 1))) = 0 THEN
  falling = 1: charredraw = 1: MoveOK = 0
 END IF
END IF

 IF check1tile = 0 THEN
 IF INSTR(losealife$, (MID$(scr$(yt), xt + 1, 1))) = 1 THEN
  losealife = 1
 END IF
 END IF
 IF INSTR(losealife$, (MID$(scr$(yt), xt, 1))) = 1 THEN
  losealife = 1
 END IF

END IF

IF MoveOK = 1 THEN
oldcy = wtputy

IF falling = 1 THEN
 walking = 0
 levelpixely = levelpixely + 1: charredraw = 1
END IF

IF bounce = 1 THEN
 jcount = jcount + 1: levelpixely = levelpixely - 1: charredraw = 1
END IF

IF jumping = 1 THEN
 jcount = jcount + 1: charredraw = 1
 SELECT CASE dir
 CASE 1: levelpixely = levelpixely - 1
 CASE 0: levelpixely = levelpixely + 1
 END SELECT
END IF

IF bounce = 1 THEN
 IF levelpixely <= jp - 15 THEN
  IF jcount MOD 2 > 0 THEN levelpixely = levelpixely + 1: EXIT SUB
 END IF
 IF levelpixely <= jp - 21 THEN
  IF jcount MOD 3 > 0 THEN levelpixely = levelpixely + 1: EXIT SUB
 END IF
 IF levelpixely = jp - 23 THEN
  bounce = 0: jumping = 1
  dir = 0: levelpixely = levelpixely + 1: jp = levelpixely - 1: EXIT SUB
 END IF
END IF

IF jumping = 1 THEN
 SELECT CASE dir
 CASE 1
  IF levelpixely <= jp - 15 THEN
   IF jcount MOD 2 > 0 THEN levelpixely = levelpixely + 1: EXIT SUB
  END IF
  IF levelpixely <= jp - 21 THEN
   IF jcount MOD 3 > 0 THEN levelpixely = levelpixely + 1: EXIT SUB
  END IF
  IF levelpixely = jp - 23 THEN
   dir = 0: levelpixely = levelpixely + 1: jp = levelpixely - 1: EXIT SUB
  END IF
 CASE 0
  IF levelpixely <= jp + 1 THEN
   IF jcount MOD 3 > 0 THEN levelpixely = levelpixely - 1: EXIT SUB
  END IF
  IF levelpixely <= jp + 6 THEN
   IF jcount MOD 2 > 0 THEN levelpixely = levelpixely - 1: EXIT SUB
  END IF
 END SELECT
END IF

END IF

END SUB

SUB CheckForKeyPress

z$ = INKEY$
keypress = 0

SELECT CASE z$
CASE CHR$(27)
 keypress = esck
 EXIT SUB
CASE "!"
 specialmode = 1
 'STOP
 EXIT SUB
END SELECT

SELECT CASE PEEK(1048)
CASE 2 'right
 IF facing = left THEN walking = 1
 facing = right
 IF falling = 0 AND jumping = 0 AND bounce = 0 THEN
  walking = walking + 1
  IF walking = 21 THEN walking = 1
  wflag = 1
 END IF
 keypress = rightk
 'STOP
CASE 1 'left
 IF facing = right THEN walking = 1
 facing = left
 IF falling = 0 AND jumping = 0 AND bounce = 0 THEN
  walking = walking + 1
  IF walking = 21 THEN walking = 1
  wflag = 1
 END IF
 keypress = leftk
END SELECT

IF wflag = 0 AND walking > 0 THEN
 walking = 0: charredraw = 1: oldcx = wtputx: oldcy = wtputy
END IF

pkey = PEEK(1047)
SELECT CASE pkey MOD 16
CASE 1, 5, 9, 13
 IF falling = 0 AND jumping = 0 AND bounce = 0 THEN
  jumping = 1
  dir = 1: jcount = 0
  jp = levelpixely
  IF pkey MOD 16 = 1 THEN keypress = Upk
  IF pkey MOD 16 = 5 THEN keypress = leftupk
  IF pkey MOD 16 = 9 THEN keypress = rightupk
 END IF
CASE ELSE
 IF jumping = 1 AND dir = 1 THEN
  dir = 0: jp = levelpixely - 1:  jcount = 0
 END IF
END SELECT

END SUB

SUB DrawLevel

FOR a = 1 TO 11
FOR B = 1 TO 18
 x = (B * 16) - 16 + offsetx
 y = (a * 16) - 16 + offsety
 startx = B + xpos
 starty = (levelheight - 11 + a) - ypos
 drawtile startx, starty, x, y
 DrawTile2 startx, starty, x, y
NEXT B
NEXT a


END SUB

SUB drawtile (levx, levy, x, y)
SELECT CASE MID$(scr$(levy), levx, 1)
 CASE "", " ": LINE (x, y)-(x + 15, y + 15), 0, BF
 CASE "#": LINE (x, y)-(x + 15, y + 15), 223, BF
 CASE "@": PUT (x, y), exitsign&, PSET
 CASE ".": LINE (x, y)-(x + 15, y + 15), 78, BF
 CASE ELSE
  char = ASC(MID$(scr$(levy), levx, 1))
  IF char >= 48 AND char <= 57 THEN
   char = char - 47
   PUT (x, y), fgwalkon&(char * 66), PSET
  ELSEIF char >= 65 AND char <= 84 THEN
   char = char - 64
   PUT (x, y), fgcgthru&(char * 66), PSET
  ELSEIF char >= 86 AND char <= 90 THEN
   char = char - 85
   PUT (x, y), losealife&(char * 66), PSET
  ELSEIF char >= 97 AND char <= 116 THEN
   char = char - 96
   PUT (x, y), bg&(char * 66), PSET
  END IF
END SELECT
END SUB

SUB DrawTile2 (levx, levy, x, y)
SELECT CASE LCASE$(MID$(layer2$(levy), levx, 1))
CASE "c": PUT (x, y), cdm&, AND: PUT (x, y), cd&, OR
CASE " ", "": EXIT SUB
CASE ELSE
  char = ASC(MID$(layer2$(levy), levx, 1))
  IF char >= 48 AND char <= 57 THEN
   char = char - 47
   PUT (x, y), objwm&(char * 66), AND
   PUT (x, y), objnm&(char * 66), OR
  END IF
END SELECT
END SUB

SUB EndProgram

fadeout
SYSTEM

END SUB

SUB fadein
     
FOR a = 1 TO (fadestep + 1)
 FOR c = 1 TO 254
  cred! = changevalue(c).red * (a - 1)
  cgreen! = changevalue(c).green * (a - 1)
  cblue! = changevalue(c).blue * (a - 1)
  changecolor c, CINT(cred!), CINT(cgreen!), CINT(cblue!)
 NEXT c
NEXT a

'FOR c = 1 TO 254


END SUB

SUB fadeout

GetColValues

FOR a = 1 TO fadestep
 FOR c = 1 TO 254
  cred! = (changevalue(c).red * (fadestep - a))
  cgreen! = (changevalue(c).green * (fadestep - a))
  cblue! = (changevalue(c).blue * (fadestep - a))
  changecolor c, CINT(cred!), CINT(cgreen!), CINT(cblue!)
 NEXT c
NEXT a

CLS : PALETTE
SetCPalette

END SUB

SUB GameLoop
CLS

enemiesinlevel2 = 0
enemiesinlevel = 0
walking = 0: jumping = 0: falling = 0: bounce = 0
lives = 5: CDs = 0: score = 0
losealife = 0

GetColValues
SetColsBlack


LoadLevel

originalx = startx - 1
originaly = starty
originalface = facing

levelpixelx = startx - 1: levelpixely = starty
levelpixelx = (levelpixelx * 16)
levelpixely = (levelpixely * 16)
xpos = startscrx: ypos = startscry
specialmode = 0
charredraw = 0

FOR x = 0 TO 19
 FOR y = 0 TO 11
  PUT (x * 16, y * 16), backg&, PSET
 NEXT y
NEXT x

LINE (14, 4)-(303, 4), 1
LINE (303, 4)-(303, 181), 150
LINE (303, 181)-(14, 181), 150
LINE (14, 180)-(14, 4), 1

LOCATE 24, 5: COLOR 7: PRINT "R O B O T   R O B B E R Y   v0.6";

PUT (2, 191), charsmall&, PSET
PUT (273, 192), cdsmall&, PSET


startlev = 1: GetCharStats: DrawLevel: startlev = 0


GET (wtputx, wtputy)-(wtputx + 15, wtputy + 31), coverup&

putcharacter
ShowEnemies
updatescore

fadein

DO
 FOR delay = 1 TO gamedelay: NEXT delay
 WAIT &H3DA, 8
 putcharacter
 IF passlevel = 1 THEN GOTO passlevel
 MoveEnemies
 CheckForKeyPress
 IF specialmode THEN GOSUB specialmode
 IF keypress = esck THEN GOTO startover
 CharMoveHoriz
 IF losealife = 1 THEN scorechanged = 1: GOSUB losealife
 IF scorechanged = 1 THEN updatescore
 scorechanged = 0
 CharMoveVert
 CFScreenScroll
LOOP

specialmode:
                              'STOP
specialmode = specialmode + 1
IF specialmode MOD 15 = 0 THEN
 getcolor 78, r, g, B
 IF specialmode > 500 THEN r = r - 1
 IF r < 0 THEN r = 0
 g = g - 1: IF g < 0 THEN g = 0
 B = B - 1: IF B < 0 THEN B = 0
 IF r = 0 AND g = 0 AND B = 0 THEN specialmode = 0
 changecolor 78, r, g, B
 IF specialmode > 300 THEN
  getcolor 100, r, g, B
  r = r + 1: g = g + 1: B = B - 2
  IF r > 63 THEN r = 63
  IF g > 63 THEN g = 63
  IF B < 0 THEN B = 0
  changecolor 100, r, g, B
  IF specialmode MOD 30 = 0 THEN
   getcolor 101, r, g, B
   r = r + 1: g = g + 1: B = B - 2
   IF B < 0 THEN B = 0
   changecolor 101, r, g, B
  END IF
 END IF
END IF
RETURN

startover:
ScreenWipe
EXIT SUB

losealife:

putcharacter

IF soundison = 1 THEN SOUND 300, 1: SOUND 250, 1: SOUND 200, 1

FOR a = 1 TO 3
 FOR d = 1 TO 2
  FOR c = 130 TO 142
   IF d = 1 THEN
    r = 63: g = 63: B = 63
   ELSE
    r = origr(c - 130)
    B = origb(c - 130)
    g = origg(c - 130)
   END IF
   changecolor c, r, g, B
  NEXT c
  secondpause .25
 NEXT d
secondpause .25
NEXT a

losealife = 0
IF lives = 0 THEN GameOver: EXIT SUB

scrollback "init"
DO
 scrollback "scroll": DrawLevel
LOOP UNTIL ypos = startscry AND xpos = startscrx

levelpixelx = originalx * 16: levelpixely = originaly * 16
facing = originalface: walking = 0: jumping = 0: falling = 0: bounce = 0

lives = lives - 1

GetCharStats

GET (wtputx, wtputy)-(wtputx + 15, wtputy + 31), coverup&

RETURN

passlevel:

passlevel = 0

getcolor 223, r, g, B
doorr = r
doorg = g
doorb = B

FOR a = 130 TO 142
 getcolor a, r, g, B
 difr!(a - 130) = (doorr - r) / 50
 difg!(a - 130) = (doorg - g) / 50
 difb!(a - 130) = (doorb - B) / 50
NEXT a

FOR z = 1 TO 50
 FOR a = 130 TO 142
  getcolor a, r, g, B
  newr = CINT(origr(a - 130) + ((z) * (difr!(a - 130))))
  newg = CINT(origg(a - 130) + ((z) * (difg!(a - 130))))
  newb = CINT(origb(a - 130) + ((z) * (difb!(a - 130))))
  changecolor a, newr, newg, newb
 NEXT a
 WAIT &H3DA, 8, 8: WAIT &H3DA, 8
NEXT z

LINE (wtputx, wtputy)-(wtputx + 15, wtputy + 31), 223, BF

secondpause .5

fadeout

LOCATE 4, 1: COLOR 12
PRINT "  Level completed.": PRINT
COLOR 29
PRINT "  There are no more levels to play"
PRINT "  in this demo version. The latest"
PRINT "  version is always availible at"
PRINT "  Robot Robbery Online,"
COLOR 9: PRINT "  robotrobbery.keithkosh.com";
COLOR 29
PRINT ".": PRINT
PRINT "  Thank you for trying Robot Robbery .6"
PRINT "  and don't forget to e-mail me at"
COLOR 9: PRINT "  robotrob@keithkosh.com"; : COLOR 29
PRINT " with"
PRINT "  any comments or suggestions.": PRINT : PRINT
COLOR 14
PRINT "Press a key to return to the main menu.."

DO: LOOP WHILE INKEY$ = ""

fadeout

END SUB

SUB GameOver
ScreenWipe
LOCATE 12, 1
PRINT "  Game over."
PRINT "  Press [Space] to go to the main menu."
DO
gk:
 z$ = INKEY$: IF z$ = "" THEN GOTO gk
 IF z$ = " " THEN EXIT DO
LOOP
END SUB

SUB GetCharStats

xtilepos! = (levelpixelx / 16) + 1
ytilepos! = levelpixely / 16
wtputx = levelpixelx - (xpos * 16) + offsetx
wtputy = levelpixely - ((levelheight - 10 - ypos) * 16) - charheight + offsety

END SUB

SUB getcolor (pal, r, g, B)

OUT &H3C7, pal
r = INP(&H3C9)
g = INP(&H3C9)
B = INP(&H3C9)

END SUB

SUB GetColValues

FOR a = 1 TO 254
 getcolor a, r, g, B
 changevalue(a).red = r / fadestep
 changevalue(a).green = g / fadestep
 changevalue(a).blue = B / fadestep
NEXT a

END SUB

SUB GetItem (x, y)

SELECT CASE MID$(layer2$(y), x, 1)
CASE "C"
 CDs = CDs + 1
 score = score + 10
 IF soundison = 1 THEN
  SOUND 400, .7
  SOUND 600, .7
 END IF
END SELECT

scorechanged = 1

MID$(layer2$(y), x, 1) = " "
GetPixCords x, y
PUT (oldcx, oldcy), coverup&, PSET
drawtile x, y, objectx, objecty
GET (oldcx, oldcy)-(oldcx + 15, oldcy + 31), coverup&
svalue = charredraw: charredraw = 0: putcharacter
charredraw = svalue

END SUB

SUB GetPixCords (x, y)

xt = ((x - 1) * 16)
yt = ((y + 1) * 16)
objectx = xt - (xpos * 16) + offsetx
objecty = yt - ((levelheight - 10 - ypos) * 16) - 16 + offsety

END SUB

SUB GetTileSet (filename$)

BLOAD filename$

FOR a = 1 TO 20
 x = (a - 1) * 16
 GET (x, 0)-(x + 15, 15), bg&(a * 66)
NEXT a


FOR a = 1 TO 10
 x = (a - 1) * 16
 GET (x, 16)-(x + 15, 31), fgwalkon&(a * 66)
NEXT a

FOR a = 1 TO 20
 x = (a - 1) * 16
 GET (x, 32)-(x + 15, 47), fgcgthru&(a * 66)
NEXT a

FOR a = 1 TO 5
 x = (a - 1) * 16
 GET (x, 48)-(x + 15, 63), losealife&(a * 66)
NEXT a

FOR a = 1 TO 10
 x = (a - 1) * 16
 GET (x, 64)-(x + 15, 79), objnm&(a * 66)
NEXT a

x = 0: xw = 159
y = 64: yw = 15

FOR a = x TO (x + xw)
 FOR B = y TO (y + yw)
  IF POINT(a, B) <> 0 THEN PSET (a, B), 0 ELSE PSET (a, B), 255
 NEXT B
NEXT a

FOR a = 1 TO 10
 x = (a - 1) * 16
 GET (x, 64)-(x + 15, 79), objwm&(a * 66)
NEXT a

CLS

END SUB

SUB Init

FOR a = 1 TO 254
 changecolor a, 0, 0, 0
NEXT a

BLOAD "robotrob.pic"  'General game graphics

GET (0, 0)-(15, 15), backg&
GET (16, 0)-(31, 15), exitsign&
GET (32, 0)-(38, 6), cdsmall&
GET (32, 7)-(38, 15), charsmall&
GET (39, 0)-(54, 15), cd&

x = 39: y = 0: xw = 15: yw = 15
GOSUB dmask
GET (39, 0)-(54, 15), cdm&

BLOAD "chsprite.pic"  'Character graphics

GET (0, 0)-(15, 31), charstanding&(right * 190)
GET (16, 0)-(31, 31), charstanding&(left * 190)
GET (32, 0)-(47, 31), charwalking&(right * 190)
GET (48, 0)-(63, 31), charwalking&(left * 190)
GET (64, 0)-(79, 31), charjump&(right * 190)
GET (80, 0)-(95, 31), charjump&(left * 190)

x = 0: y = 0: xw = 95: yw = 31
GOSUB dmask

GET (0, 0)-(15, 31), charstandmask&(right * 190)
GET (16, 0)-(31, 31), charstandmask&(left * 190)
GET (32, 0)-(47, 31), charwalkmask&(right * 190)
GET (48, 0)-(63, 31), charwalkmask&(left * 190)
GET (64, 0)-(79, 31), charjumpmask&(right * 190)
GET (80, 0)-(95, 31), charjumpmask&(left * 190)

BLOAD "ensprite.pic"  'Enemy sprites

GET (0, 0)-(15, 15), enemyflat&(1 * 68)
GET (16, 0)-(31, 15), enemyflat&(2 * 68)
GET (32, 0)-(47, 15), enemyp1&(2 * 68)
GET (48, 0)-(63, 15), enemyp2&(2 * 68)
GET (64, 0)-(79, 15), enemyp1&(1 * 68)
GET (80, 0)-(95, 15), enemyp2&(1 * 68)

GET (96, 0)-(111, 15), spikeb&(1 * 68)
GET (112, 0)-(127, 15), spikeb&(2 * 68)

x = 0: y = 0: xw = 127: yw = 15
GOSUB dmask

GET (0, 0)-(15, 15), enemyflatm&(1 * 68)
GET (16, 0)-(31, 15), enemyflatm&(2 * 68)
GET (32, 0)-(47, 15), enemyp1m&(2 * 68)
GET (48, 0)-(63, 15), enemyp2m&(2 * 68)
GET (64, 0)-(79, 15), enemyp1m&(1 * 68)
GET (80, 0)-(95, 15), enemyp2m&(1 * 68)

GET (96, 0)-(111, 15), spikebm&(1 * 68)
GET (112, 0)-(127, 15), spikebm&(2 * 68)

BLOAD "robtitle.pic"  'Title

GET (0, 0)-(107, 54), title&

CLS : PALETTE

DEF SEG = 0

EXIT SUB

dmask:
FOR a = x TO (x + xw)
 FOR B = y TO (y + yw)
  IF POINT(a, B) <> 0 THEN PSET (a, B), 0 ELSE PSET (a, B), 255
 NEXT B
NEXT a

RETURN

END SUB

SUB LoadLevel

filename$ = "robotlev.dat"

OPEN filename$ FOR INPUT AS #1

DO
 LINE INPUT #1, comments$
 IF LEFT$(comments$, 1) <> "'" THEN EXIT DO
 comments = comments + 1
LOOP

DO
 LINE INPUT #1, line$
 IF LEFT$(line$, 1) = "'" THEN EXIT DO
 IF EOF(1) THEN EXIT DO
 heightoflevel = heightoflevel + 1
LOOP

CLOSE #1

OPEN filename$ FOR INPUT AS #1
FOR a = 1 TO comments: LINE INPUT #1, ignore$: NEXT a

INPUT #1, startx
INPUT #1, starty
INPUT #1, startscrx
INPUT #1, startscry
INPUT #1, doesitscrollup
INPUT #1, facing
INPUT #1, gtilename$

ERASE scr$

FOR a = 1 TO heightoflevel
 LINE INPUT #1, scr$(a)
NEXT a

LINE INPUT #1, skip$

RANDOMIZE TIMER

FOR a = 1 TO heightoflevel
 LINE INPUT #1, layer2$(a)
 FOR B = 1 TO LEN(layer2$(a))
  snip$ = MID$(layer2$(a), B, 1)
  IF snip$ = "o" THEN
   enemiesinlevel2 = enemiesinlevel2 + 1
   enemy2(enemiesinlevel2).walkstate = INT(RND * 10) + 1
   enemy2(enemiesinlevel2).pixelx = ((B - 1) * 16)
   enemy2(enemiesinlevel2).pixely = ((a + 1) * 16)
   enemy2(enemiesinlevel2).direction = INT(RND * 2) + 1
  ELSEIF snip$ = "<" OR snip$ = ">" THEN
   'Add up the enemies in the level
   enemiesinlevel = enemiesinlevel + 1
   enemy(enemiesinlevel).pixelx = ((B - 1) * 16)
   enemy(enemiesinlevel).pixely = ((a + 1) * 16)
   IF snip$ = "<" THEN enemy(enemiesinlevel).direction = left ELSE enemy(enemiesinlevel).direction = right
   enemy(enemiesinlevel).walkstate = INT(RND * 10) + 1
   enemy(enemiesinlevel).alive = 1
   enemy(enemiesinlevel).squished = 0
  END IF
 NEXT B
NEXT a

CLOSE #1

levelheight = heightoflevel

GetTileSet gtilename$

END SUB

SUB MainMenu
CLS

 scr$(1) = ""
 scr$(2) = ""
 scr$(3) = ""
 scr$(4) = "33333"
 scr$(5) = "aaaaa              2"
 scr$(6) = "aaaaa             22"
 scr$(7) = "aaaaa            222"
 scr$(8) = "aaaaa           1111"
 scr$(9) = "1111a            bhh"
scr$(10) = "aabaA            ihh"
scr$(11) = "eeifAA           ihh"
scr$(12) = "00000000000000000000"

SetColsBlack

GetTileSet "city.pic"

FOR a = 1 TO 12
 FOR B = 1 TO 20
  x = (B * 16) - 16
  y = (a * 16) - 16
  drawtile B, a, x, y
 NEXT B
NEXT a

txpos = (319 - 108) / 2
PUT (txpos, 0), title&, PSET

mselect = 1
oldselect = 6

fadein

astep = 1: x = 305
ON TIMER(8) GOSUB mmanimstuff
TIMER ON

mainanim = 0
whichanim = 1

menuselect:
menuchoice$(1) = "Start new game"
menuchoice$(2) = "Load saved game"
menuchoice$(3) = "Options"
menuchoice$(4) = "Credits"
menuchoice$(5) = "Help"
menuchoice$(6) = "Quit the game"
choices = 6

COLOR 7

FOR a = 1 TO choices
LOCATE 8 + (a * 2), 14: IF a = 2 OR a = 4 THEN COLOR 8 ELSE COLOR 7
PRINT menuchoice$(a)
NEXT a

DO
waitforselect:
 WAIT &H3DA, 8, 8: WAIT &H3DA, 8
 IF mainanim = 1 THEN GOSUB animate
 COLOR 14
 LOCATE 8 + (mselect * 2), 12: PRINT "";
 LOCATE 8 + (mselect * 2), 14: COLOR 30: PRINT menuchoice$(mselect);
 LOCATE 8 + (oldselect * 2), 12: PRINT " ";
 LOCATE 8 + (oldselect * 2), 14: COLOR 7: PRINT menuchoice$(oldselect);
 z$ = INKEY$
 IF z$ = "" GOTO waitforselect
 IF z$ = CHR$(13) THEN EXIT DO
 IF z$ = CHR$(0) + CHR$(72) THEN
  IF mselect > 1 THEN oldselect = mselect: mselect = mselect - 1
  IF mselect = 2 OR mselect = 4 THEN
   mselect = mselect - 1
  END IF
 ELSEIF z$ = CHR$(0) + CHR$(80) THEN
  IF mselect < choices THEN oldselect = mselect: mselect = mselect + 1
  IF mselect = 2 OR mselect = 4 THEN
   mselect = mselect + 1
  END IF
 END IF
LOOP

SELECT CASE mselect
 CASE 1
  ScreenWipe
  TIMER OFF
  EXIT SUB
 CASE 3
  FOR a = 1 TO 6
   LOCATE 8 + (a * 2), 12: PRINT STRING$(17, 255);
  NEXT a
 choices = 3: mselect = 1: oldselect = 2: COLOR 7
options:
  IF soundison = 1 THEN sound$ = "on " ELSE sound$ = "off"
  gamedelay$ = LTRIM$(RTRIM$(STR$(gamedelay)))
  IF gamedelay$ = "0" THEN gamedelay$ = "0    "
  menuchoice$(1) = "Sound: " + sound$
  menuchoice$(2) = "In game delay: " + gamedelay$
  menuchoice$(3) = "Return to main menu"
  FOR a = 1 TO choices
   LOCATE 8 + (a * 2), 14: PRINT menuchoice$(a);
  NEXT a
DO
waitforselect2:
 WAIT &H3DA, 8, 8: WAIT &H3DA, 8
 IF mainanim = 1 THEN GOSUB animate
 COLOR 14
 LOCATE 8 + (mselect * 2), 12: PRINT "";
 LOCATE 8 + (mselect * 2), 14: COLOR 30: PRINT menuchoice$(mselect);
 LOCATE 8 + (oldselect * 2), 12: PRINT " ";
 LOCATE 8 + (oldselect * 2), 14: COLOR 7: PRINT menuchoice$(oldselect);
 z$ = INKEY$
 IF z$ = "" GOTO waitforselect2
 IF z$ = CHR$(13) THEN EXIT DO
 IF z$ = CHR$(0) + CHR$(72) THEN
  IF mselect > 1 THEN oldselect = mselect: mselect = mselect - 1
 ELSEIF z$ = CHR$(0) + CHR$(80) THEN
  IF mselect < choices THEN oldselect = mselect: mselect = mselect + 1
 END IF
LOOP
 SELECT CASE mselect
  CASE 1
   IF soundison = 1 THEN soundison = 0 ELSE soundison = 1
   GOTO options
  CASE 2
   gamedelay = gamedelay + 1000
   IF gamedelay = 21000 THEN gamedelay = 0
   GOTO options
 END SELECT
  FOR a = 1 TO 3
   IF a = 2 THEN lt = 23 ELSE lt = 21
   LOCATE 8 + (a * 2), 12: PRINT STRING$(lt, 255);
  NEXT a
  mselect = 3: oldselect = 1
  GOTO menuselect
 CASE 5
  FOR a = 1 TO 6
   LOCATE 8 + (a * 2), 12: PRINT STRING$(17, 255);
  NEXT a
  COLOR 15: LOCATE 9, 12: PRINT "Move the character"
  LOCATE 10, 12: PRINT "and find the exit!"
  COLOR 9: LOCATE 12, 12: PRINT "Keys:"
  COLOR 29: LOCATE 13, 12: PRINT "[Left Control]"
  COLOR 27: LOCATE 14, 12: PRINT " - Move left"
  COLOR 29: LOCATE 15, 12: PRINT "[Left Alt]"
  COLOR 27: LOCATE 16, 12: PRINT " - Move right"
  COLOR 29: LOCATE 17, 12: PRINT "[Right Shift]"
  COLOR 27: LOCATE 18, 12: PRINT " - Jump/Enter exit"
  COLOR 14: LOCATE 20, 12: PRINT "[Enter] to return"
  DO
  z$ = INKEY$
  WAIT &H3DA, 8, 8: WAIT &H3DA, 8
  IF mainanim = 1 THEN GOSUB animate
  LOOP UNTIL z$ = CHR$(13)
  FOR a = 1 TO 12
   LOCATE 8 + a, 12: PRINT STRING$(18, 255);
  NEXT a
  mselect = 5: oldselect = 3
  GOTO menuselect
 CASE 6
  EndProgram
END SELECT

animate:
SELECT CASE whichanim

CASE 1
moveornot = moveornot + 1
IF moveornot = 3 THEN moveornot = 1
IF moveornot = 2 THEN
SELECT CASE astep
CASE 1
 enemy(1).direction = left
 enemy(1).walkstate = enemy(1).walkstate + 1
 IF enemy(1).walkstate = 10 THEN enemy(1).walkstate = 1
 IF x < 305 THEN PUT (x, 160), ecoverup&(1 * 65), PSET
 x = x - 1
 GET (x, 160)-(x + 15, 175), ecoverup&(1 * 65)
 putenemy 1, x, 160, 1
 IF x = 96 THEN
  enemy(1).direction = right
  astep = 2
 END IF
CASE 2
 enemy(1).walkstate = enemy(1).walkstate + 1
 IF enemy(1).walkstate = 10 THEN enemy(1).walkstate = 1
 PUT (x, 160), ecoverup&(1 * 65), PSET
 x = x + 1
 IF x = 305 THEN
  TIMER ON: mainanim = 0: astep = 1: whichanim = 2
  x = 0
  RETURN
 END IF
 GET (x, 160)-(x + 15, 175), ecoverup&(1 * 65)
 putenemy 1, x, 160, 1
END SELECT
END IF

CASE 2
moveornot = moveornot + 1
IF moveornot = 3 THEN moveornot = 1
IF moveornot = 2 THEN
SELECT CASE astep
CASE 1
 enemy(1).direction = right
 enemy(1).walkstate = enemy(1).walkstate + 1
 IF enemy(1).walkstate = 10 THEN enemy(1).walkstate = 1
 IF x > 0 THEN PUT (x, 32), ecoverup&(1 * 65), PSET
 x = x + 1
 GET (x, 32)-(x + 15, 47), ecoverup&(1 * 65)
 putenemy 1, x, 32, 1
 IF x = 64 THEN
  enemy(1).direction = left
  astep = 2
 END IF
CASE 2
 enemy(1).walkstate = enemy(1).walkstate + 1
 IF enemy(1).walkstate = 10 THEN enemy(1).walkstate = 1
 PUT (x, 32), ecoverup&(1 * 65), PSET
 x = x - 1
 IF x = 0 THEN
  TIMER ON: x = 305
  mainanim = 0: astep = 1: whichanim = 1
  RETURN
 END IF
 GET (x, 32)-(x + 15, 47), ecoverup&(1 * 65)
 putenemy 1, x, 32, 1
END SELECT
END IF

END SELECT

RETURN

END SUB

SUB MoveEnemies

STATIC whentomove
whentomove = whentomove + 1
IF whentomove = 2 THEN whentomove = 0
IF whentomove = 0 THEN EXIT SUB

 FOR a = 1 TO enemiesinlevel
  wx = enemy(a).pixelx - (xpos * 16) + offsetx
  wy = enemy(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
  IF enemy(a).alive = 0 THEN
   IF enemy(a).squished < 40 THEN enemy(a).squished = enemy(a).squished + 1
   IF enemy(a).squished < 40 THEN
    IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
     PUT (wx, wy), enemyflatm&(enemy(a).direction * 68), AND
     PUT (wx, wy), enemyflat&(enemy(a).direction * 68), OR
    END IF
   END IF
   IF enemy(a).squished = 40 THEN
    IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
     PUT (wx, wy), ecoverup&(a * 65), PSET
     enemy(a).squished = enemy(a).squished + 1
    END IF
   END IF
   GOTO nexta
  END IF
  enemy(a).walkstate = enemy(a).walkstate + 1
  IF enemy(a).walkstate = 11 THEN enemy(a).walkstate = 1
   'check for other enemies
   IF enemy(a).direction = right THEN Add = 16 ELSE Add = -16
   FOR B = 1 TO enemiesinlevel
    IF B = a THEN GOTO skipthisone
    IF enemy(B).alive = 0 THEN GOTO skipthisone
    IF enemy(a).pixely = enemy(B).pixely THEN
     IF enemy(B).pixelx >= (enemy(a).pixelx + Add) AND enemy(B).pixelx <= (enemy(a).pixelx + Add + 1) THEN
      IF enemy(B).direction <> enemy(a).direction THEN
       IF enemy(B).direction = right THEN enemy(B).direction = left ELSE enemy(B).direction = right
       IF enemy(a).direction = right THEN enemy(a).direction = left ELSE enemy(a).direction = right
      END IF
     END IF
    END IF
skipthisone:
   NEXT B
  IF (wx - offsetx) MOD 16 = 0 THEN
   tilex = (enemy(a).pixelx / 16) + 1
   tiley = (enemy(a).pixely / 16) - 1
   IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
    drawtile tilex, tiley, wx, wy
    DrawTile2 tilex, tiley, wx, wy
    GET (wx, wy)-(wx + 15, wy + 15), ecoverup&(a * 65)
   END IF
   IF enemy(a).direction = right THEN Move = 1 ELSE Move = -1
   IF tilex + Move <= 0 THEN
    enemy(a).direction = right
   ELSEIF INSTR(cantgothru$, MID$(scr$(tiley), tilex + Move, 1)) THEN
    IF Move = 1 THEN enemy(a).direction = left ELSE enemy(a).direction = right
   ELSEIF INSTR(cantgothru$, MID$(scr$(tiley + 1), tilex + Move, 1)) = 0 THEN
    IF INSTR(walkon$, MID$(scr$(tiley + 1), tilex + Move, 1)) = 0 THEN
    IF Move = 1 THEN enemy(a).direction = left ELSE enemy(a).direction = right
    END IF
   END IF
  END IF
  IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
    IF enemy(a).onscreen = 1 THEN PUT (wx, wy), ecoverup&(a * 65), PSET
   enemy(a).onscreen = 1
  ELSE
   enemy(a).onscreen = 0
  END IF
  IF enemy(a).direction = right THEN
   enemy(a).pixelx = enemy(a).pixelx + 1: wx = wx + 1
  ELSE
   enemy(a).pixelx = enemy(a).pixelx - 1: wx = wx - 1
  END IF
  IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx AND enemy(a).onscreen = 1 THEN
   GET (wx, wy)-(wx + 15, wy + 15), ecoverup&(a * 65)
   putenemy a, wx, wy, 1
  ELSE
   enemy(a).onscreen = 0
  END IF
nexta:
 NEXT a

FOR a = 1 TO enemiesinlevel2
  enemy2(a).walkstate = enemy2(a).walkstate + 1
  IF enemy2(a).walkstate = 11 THEN enemy2(a).walkstate = 1
  wx = enemy2(a).pixelx - (xpos * 16) + offsetx
  wy = enemy2(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
  Move = enemy2(a).direction
  IF (wy - offsety) MOD 16 = 0 THEN
   tilex = (enemy2(a).pixelx / 16) + 1
   tiley = (enemy2(a).pixely / 16) - 1
   IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
    drawtile tilex, tiley, wx, wy
    DrawTile2 tilex, tiley, wx, wy
    GET (wx, wy)-(wx + 15, wy + 15), ecoverup2&(a * 65)
   END IF
   IF tiley = 1 AND Move = -1 THEN enemy2(a).direction = 1: Move = 1
   IF tiley = levelheight THEN enemy2(a).direction = -1: Move = -1
   IF INSTR(cantgothru$, MID$(scr$(tiley + Move), tilex, 1)) THEN
    IF Move = 1 THEN enemy2(a).direction = -1: Move = -1 ELSE enemy2(a).direction = 1: Move = 1
   END IF
  END IF
  IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
    IF enemy2(a).onscreen = 1 THEN PUT (wx, wy), ecoverup2&(a * 65), PSET
   enemy2(a).onscreen = 1
  ELSE
   enemy2(a).onscreen = 0
  END IF
  enemy2(a).pixely = enemy2(a).pixely + Move: wy = wy + Move
  IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx AND enemy2(a).onscreen = 1 THEN
   GET (wx, wy)-(wx + 15, wy + 15), ecoverup2&(a * 65)
   putenemy a, wx, wy, 2
  ELSE
   enemy2(a).onscreen = 0
  END IF
 NEXT a

END SUB

SUB putcharacter
STATIC blink, go

IF blink = 0 THEN
 a = INT(RND * 150) + 1
 go = 100 + a
END IF

blink = blink + 1

IF blink = go + 20 THEN
 blink = 0
END IF

GetCharStats

IF charredraw = 1 THEN
 PUT (oldcx, oldcy), coverup&, PSET
 GET (wtputx, wtputy)-(wtputx + 15, wtputy + 31), coverup&
END IF

charredraw = 0

IF walking >= 10 THEN
 PUT (wtputx, wtputy), charwalkmask&(facing * 190), AND
 PUT (wtputx, wtputy), charwalking&(facing * 190), OR
ELSEIF jumping = 1 OR bounce = 1 THEN
 PUT (wtputx, wtputy), charjumpmask&(facing * 190), AND
 PUT (wtputx, wtputy), charjump&(facing * 190), OR
ELSE
 PUT (wtputx, wtputy), charstandmask&(facing * 190), AND
 PUT (wtputx, wtputy), charstanding&(facing * 190), OR
END IF

ex = wtputx + 4: ey = wtputy + 3
IF facing = right THEN ex = ex + 6

IF blink >= go AND blink <= go + 10 THEN
 LINE (ex, ey)-(ex + 1, ey + 1), 135, BF   'Blink blink
END IF

END SUB

SUB putenemy (N, x, y, t)

SELECT CASE t
CASE 1

SELECT CASE enemy(N).walkstate
CASE 1 TO 5
 PUT (x, y), enemyp1m&(enemy(N).direction * 68), AND
 PUT (x, y), enemyp1&(enemy(N).direction * 68), OR
CASE 6 TO 10
 PUT (x, y), enemyp2m&(enemy(N).direction * 68), AND
 PUT (x, y), enemyp2&(enemy(N).direction * 68), OR
END SELECT

CASE 2

SELECT CASE enemy2(N).walkstate
CASE 1 TO 5
 PUT (x, y), spikebm&(1 * 68), AND
 PUT (x, y), spikeb&(1 * 68), OR
CASE 6 TO 10
 PUT (x, y), spikebm&(2 * 68), AND
 PUT (x, y), spikeb&(2 * 68), OR
END SELECT

END SELECT

END SUB

SUB ScreenWipe

c = 520
d = 199

FOR a = 0 TO 520
 FOR B = 0 TO 198 STEP 2
  PSET ((a - 1) - B, B), 0
  PSET ((c - 1) - d, d), 0
  d = d - 2
 NEXT B
 c = c - 1: d = 199

NEXT a

END SUB

SUB scrollback (What$)

IF What$ = "init" THEN
 IF xpos < startscrx THEN stepx = 1
 IF xpos > startscrx THEN stepx = -1
 IF xpos = startscrx THEN stepx = 0
 IF ypos = startscry THEN stepy = 0
 IF ypos > startscry THEN stepy = -1
 IF ypos < startscry THEN stepy = 1
ELSEIF What$ = "scroll" THEN
 IF xpos <> startscrx THEN xpos = xpos + stepx
 IF ypos <> startscry THEN ypos = ypos + stepy
END IF

END SUB

SUB secondpause (second!)

start! = TIMER
DO: LOOP WHILE TIMER < start! + second!

END SUB

SUB SetColsBlack

FOR a = 1 TO 254
 changecolor a, 0, 0, 0
NEXT a

END SUB

SUB SetCPalette

OPEN "robotrob.pal" FOR BINARY AS #1

DIM pb AS STRING * 1

FOR c = 0 TO 255
 GET #1, , pb: r = ASC(pb)
 GET #1, , pb: g = ASC(pb)
 GET #1, , pb: B = ASC(pb)
 changecolor c, r, g, B
NEXT c

CLOSE #1


END SUB

SUB ShowEnemies
FOR a = 1 TO enemiesinlevel
 wx = enemy(a).pixelx - (xpos * 16) + offsetx
 wy = enemy(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
 IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
  GET (wx, wy)-(wx + 15, wy + 15), ecoverup&(a * 65)
  putenemy a, wx, wy, 1
  enemy(a).onscreen = 1
 ELSE
  enemy(a).onscreen = 0
 END IF
NEXT a
FOR a = 1 TO enemiesinlevel2
 wx = enemy2(a).pixelx - (xpos * 16) + offsetx
 wy = enemy2(a).pixely - ((levelheight - 10 - ypos) * 16) - 16 + offsety
 IF wx > -1 + offsetx AND wy > -1 + offsety AND wy <= 160 + offsety AND wx <= 272 + offsetx THEN
  GET (wx, wy)-(wx + 15, wy + 15), ecoverup2&(a * 65)
  putenemy a, wx, wy, 2
  enemy2(a).onscreen = 1
 ELSE
  enemy2(a).onscreen = 0
 END IF
NEXT a

END SUB

SUB updatescore

LOCATE 25, 3: COLOR 12: PRINT "x"; : COLOR 10: PRINT lives;
LOCATE 25, 18:  COLOR 9: PRINT score;
LOCATE 25, 37: COLOR 12: PRINT "x"; : COLOR 14: PRINT RTRIM$(STR$(CDs));

END SUB

