' Title: "S.W.A.T. Academy"
' Version: 1.0
' Author: Johan F. Ugland
' Library: Direct-QB 1.61
' Created: 01.10.01
' Last Change: 01.12.01
 
  '$INCLUDE: 'DIRECTQB.BI'
  '$INCLUDE: 'INDEX.TXT'

  DECLARE SUB Init ()
  DECLARE SUB Main ()
  DECLARE SUB Setup ()
  DECLARE SUB Engage ()
  DECLARE SUB FrontPage ()
  DECLARE SUB ScoreBoard ()
  DECLARE SUB Message (Text$)
  DECLARE SUB Guard (HeadX1, HeadY1, HeadX2, HeadY2, BodyX1, BodyY1, BodyX2, BodyY2)
  DECLARE SUB PopUp (Sprite, x, y, HeadX1, HeadY1, HeadX2, HeadY2, BodyX1, BodyY1, BodyX2, BodyY2)

  TYPE DiskInfo
    InfoLevel AS INTEGER
    Serial AS LONG
    Label AS STRING * 11
    FileSys AS STRING * 8
  END TYPE
 
  DIM SHARED Pal AS STRING * 768, Cursor AS STRING * 64, KeyPressed AS STRING
  DIM SHARED SoundEnabled, BaseIO, IRQ, DMA, StoredSerial AS LONG, Hit, Quit
  DIM SHARED Ammo, Bodies, Bodied, Heads, Headed, Total, Score, MinDelay, MaxDelay
  DIM SHARED HardDisk AS DiskInfo, PrevShot, Avoided
 
  Init
  IF HardDisk.Serial <> StoredSerial THEN Setup
  DO
    FrontPage
    Main
  LOOP

REM $DYNAMIC
SUB Engage

  FOR Counter = 1 TO Ammo
    R = DQBunpackImage(BULLET, 1, 318 - (Counter * 6), 1)
  NEXT

  FOR Counter = 1 TO Total
    IF Quit THEN EXIT SUB
    Target = INT(RND * 9) + 1
    Hit = FALSE
    SELECT CASE Target
      CASE 1: PopUp TA0, 240, 138, 254, 143, 259, 150, 249, 152, 264, 184
      CASE 2: PopUp TB0, 47, 126, 59, 130, 63, 137, 55, 138, 67, 148
      CASE 3: PopUp TC0, 183, 129, 195, 134, 199, 140, 191, 141, 203, 149
      CASE 4: PopUp TD0, 107, 147, 114, 150, 117, 154, 112, 155, 119, 161
      CASE 5: PopUp TE0, 210, 137, 210, 140, 213, 144, 210, 145, 215, 149
      CASE 6: PopUp TF0, 161, 137, 169, 141, 171, 145, 166, 146, 174, 167
      CASE 7: PopUp TG0, 111, 70, 119, 73, 122, 77, 117, 78, 124, 88
      CASE 8: PopUp TD0, 157, 74, 164, 77, 167, 81, 162, 82, 169, 88
      CASE 9: PopUp TG0, 214, 70, 222, 73, 225, 77, 220, 78, 228, 88
    END SELECT
    IF NOT PrevShot THEN Avoided = Avoided + 1
    IF SoundEnabled AND Avoided = 2 THEN
      DQBplaySound 4, 4, 22050, ONCE
      Avoided = 0
    END IF
    PrevShot = FALSE
  NEXT

END SUB

SUB FrontPage
 
FrontStart:
  'Display Front Page
  IF SoundEnabled AND Quit THEN DQBplaySound 5, 4, 22050, ONCE
  Quit = FALSE
  DQBpalOff
  R = DQBunpackPal(PALETT1, Pal)
  R = DQBunpackImage(FRONT, VIDEO, 0, 0)
  DQBfadeIn Pal
  DO
    IF DQBkey(KEYESC) THEN DQBfadeTo 0, 0, 0: DQBclose: CLOSE : SYSTEM
    IF DQBkey(31) THEN DQBfadeTo 0, 0, 0: Setup: GOTO FrontStart
  LOOP UNTIL DQBmouseLB
  DQBfadeTo 0, 0, 0

END SUB

REM $STATIC
SUB Guard (HeadX1, HeadY1, HeadX2, HeadY2, BodyX1, BodyY1, BodyX2, BodyY2)

  IF DQBinkey$ = CHR$(27) THEN Quit = TRUE
  IF DQBmouseLB AND Ammo > 0 AND NOT DQBinUse(1) THEN
    DQBmouseHide
    Ammo = Ammo - 1
    R = DQBunpackImage(BLANK, 1, 258, 1)
    FOR Counter = 1 TO Ammo
      R = DQBunpackImage(BULLET, 1, 318 - (Counter * 6), 1)
    NEXT
    IF SoundEnabled THEN DQBplaySound 1, 1, 22050, ONCE
    IF SoundEnabled AND DQBmouseX > 0 AND DQBmouseY > 77 AND DQBmouseX < 87 AND DQBmouseY < 134 THEN DQBplaySound 2, 2, 22050, ONCE
    IF HeadX2 <> 0 THEN
      PosX = DQBmouseX: PosY = DQBmouseY
      IF PosX >= HeadX1 AND PosX <= HeadX2 AND PosY >= HeadY1 AND PosY <= HeadY2 AND NOT Hit THEN
        Score = Score + 100
        Heads = Heads + 1
        Headed = Headed + 1
        Hit = TRUE
      END IF
      IF PosX >= BodyX1 AND PosX <= BodyX2 AND PosY >= BodyY1 AND PosY <= BodyY2 AND NOT Hit THEN
        Score = Score + 50
        Bodied = Bodied + 1
        Bodies = Bodies + 1
        Hit = TRUE
      END IF
    END IF
    IF (DQBmouseX > 0 AND DQBmouseY > 149) OR (DQBmouseX > 88 AND DQBmouseY > 34 AND DQBmouseX < 250 AND DQBmouseY < 148) THEN DQBpset 1, DQBmouseX - 1, DQBmouseY, 69
    DQBcopyLayer 1, VIDEO
    DQBmouseShow
    DQBsetMousePos DQBmouseX - 4, DQBmouseY - 12  '\
    DQBwait 5                                     ' > Recoil
    DQBsetMousePos DQBmouseX + 2, DQBmouseY + 4   '/
    DO: LOOP WHILE DQBmouseLB
    PrevShot = TRUE
  END IF
  IF Ammo = 0 THEN PrevShot = TRUE
 
  Scream = INT(RND * 2000) + 1
  IF SoundEnabled AND Scream = 1 THEN DQBplaySound 3, 3, 22050, ONCE

  DQBwait 1

END SUB

REM $DYNAMIC
SUB Init

  'Initialize DirectQB
  IF DQBinit(1, 5, 0) <> 0 THEN DQBclose: PRINT "DirectQB failed to initialize!": SYSTEM
  IF NOT DQBmouseDetected THEN DQBclose: PRINT "Mouse not found!": SYSTEM
 
  'Load data...
  IF DQBopenDataFile("SWATCAD.DAT", "") THEN DQBclose: PRINT "Could not open SWATCAD.DAT": SYSTEM
 
  'Check Disk Serial Number
  DIM ErrCode
  DIM AsmCode AS STRING * 32
  MID$(AsmCode, 1, 4) = CHR$(184) + MKI$(VARSEG(HardDisk)) + CHR$(142)
  MID$(AsmCode, 5, 5) = CHR$(216) + CHR$(184) + CHR$(0) + CHR$(105) + CHR$(187)
  MID$(AsmCode, 10, 3) = CHR$(3) + CHR$(0) + CHR$(186)
  MID$(AsmCode, 13, 4) = MKI$(VARPTR(HardDisk)) + CHR$(205) + CHR$(33)
  MID$(AsmCode, 17, 5) = CHR$(114) + CHR$(1) + CHR$(203) + CHR$(80) + CHR$(184)
  MID$(AsmCode, 22, 4) = MKI$(VARSEG(ErrCode)) + CHR$(142) + CHR$(216)
  MID$(AsmCode, 26, 4) = CHR$(88) + CHR$(187) + MKI$(VARPTR(ErrCode))
  MID$(AsmCode, 30, 3) = CHR$(137) + CHR$(7) + CHR$(203)
  DEF SEG = VARSEG(AsmCode)
  CALL ABSOLUTE(VARPTR(AsmCode))
  DEF SEG
 
  OPEN "SWATCAD.DAT" FOR BINARY AS #1
  GET #1, 206600, StoredSerial
  GET #1, , SoundEnabled
  GET #1, , BaseIO
  GET #1, , IRQ
  GET #1, , DMA
  IF HardDisk.Serial <> StoredSerial THEN
    SoundEnabled = FALSE
    BaseIO = &H220
    IRQ = 5
    DMA = 1
  END IF

  DQBinitVGA
  DQBinstallKeyboard
  DQBpalOff
  DQBsetSolidPut
  DQBresetMouse
  DQBclearLayer VIDEO
  DQBclearLayer 1
  RANDOMIZE TIMER
 
  DQBwait 60

END SUB

SUB Main

  IF SoundEnabled THEN
    R = DQBinstallSB(FALSE, 4, 22050, BaseIO, IRQ, DMA)
    DQBsetVolume 15
    R = DQBloadRawSound(1, "SWATCAD.DAT", 65554, 34464)  'Shot
    R = DQBloadRawSound(2, "SWATCAD.DAT", 100018, 15946) 'Ricochet
    R = DQBloadRawSound(3, "SWATCAD.DAT", 115964, 36505) 'Hawk
    R = DQBloadRawSound(4, "SWATCAD.DAT", 152469, 21871) 'Keep Firing
    R = DQBloadRawSound(5, "SWATCAD.DAT", 174340, 32260) 'Coward
  END IF

  'Display The Area
  R = DQBunpackPal(PALETT3, Pal)
  R = DQBunpackImage(MAINSCRN, 1, 0, 0)
  R = DQBunpackCursor(CROSS, Cursor)
  DQBcopyLayer 1, VIDEO
  DQBsetMouseShape 4, 6, Cursor
  DQBmouseShow
  DQBfadeIn Pal

'Round 1
  Ammo = 8
  Total = 8
  Bodied = 0
  Headed = 0
  Bodies = 0
  Heads = 0
  Score = 0
  Evaded = 0
  MinDelay = 150
  MaxDelay = 100
  Message "Hit 5 targets"
  Engage
  IF Quit THEN DQBmouseHide: EXIT SUB
  IF Bodied + Headed < 5 THEN Message "You are NOT qualified!": ScoreBoard: EXIT SUB
  Message "Well Done!"

'Round 2
  Ammo = 10
  Total = 10
  Bodied = 0
  Headed = 0
  Evaded = 0
  MinDelay = 150
  MaxDelay = 50
  Message "Hit 8 targets"
  Engage
  IF Quit THEN DQBmouseHide: EXIT SUB
  IF Bodied + Headed < 8 THEN Message "You are NOT qualified!": ScoreBoard: EXIT SUB
  Message "Very Good!"

'Round 3
  Ammo = 10
  Total = 10
  Bodied = 0
  Headed = 0
  Evaded = 0
  MinDelay = 120
  MaxDelay = 50
  Message "Hit all targets"
  Engage
  IF Quit THEN DQBmouseHide: EXIT SUB
  IF Bodied + Headed < 10 THEN Message "You are NOT qualified!": ScoreBoard: EXIT SUB
  Message "Good Work!"

'Round 4
  Ammo = 6
  Total = 6
  Bodied = 0
  Headed = 0
  Evaded = 0
  MinDelay = 100
  MaxDelay = 30
  Message "Hit at least 4 heads"
  Engage
  IF Quit THEN DQBmouseHide: EXIT SUB
  IF Headed < 4 THEN Message "You are NOT qualified!": ScoreBoard: EXIT SUB
  Message "Excelent!"

'Round 5
  Ammo = 10
  Total = 10
  Bodied = 0
  Headed = 0
  Evaded = 0
  MinDelay = 100
  MaxDelay = 20
  Message "All targets + 6 heads"
  Engage
  IF Quit THEN DQBmouseHide: EXIT SUB
  IF Bodied + Headed < 10 OR Headed < 6 THEN Message "You are NOT qualified!": ScoreBoard: EXIT SUB
  Message "Nice!"

'Round 5
  Ammo = 10
  Total = 10
  Bodied = 0
  Headed = 0
  Evaded = 0
  MinDelay = 50
  MaxDelay = 10
  Message "Hit ALL targets"
  Engage
  IF Quit THEN DQBmouseHide: EXIT SUB
  IF Bodied + Headed < 10 THEN Message "You are NOT qualified!": ScoreBoard: EXIT SUB
  Message "Congratulations!"
  Message "Sniper course passed!"
  ScoreBoard
END SUB

REM $STATIC
SUB Message (Text$)
 
  DQBwait 30
  DQBmouseHide
  DQBprint VIDEO, Text$, CENTERED, 100, 0
  DQBmouseShow
  DQBwait 60
  DQBmouseHide
  DQBcopyLayer 1, VIDEO
  DQBmouseShow

END SUB

REM $DYNAMIC
SUB PopUp (Sprite, x, y, HeadX1, HeadY1, HeadX2, HeadY2, BodyX1, BodyY1, BodyX2, BodyY2)
 
  DQBmouseHide
  R = DQBunpackImage(Sprite + 1, VIDEO, x, y)
  DQBmouseShow
  DQBwait 7
  DQBmouseHide
  R = DQBunpackImage(Sprite + 2, 1, x, y)
  DQBcopyLayer 1, VIDEO
  DQBmouseShow
 
  Delay = INT(RND * MaxDelay) + MinDelay

  FOR Counter = 1 TO Delay
    Guard HeadX1, HeadY1, HeadX2, HeadY2, BodyX1, BodyY1, BodyX2, BodyY2
  NEXT
 
  DQBmouseHide
  R = DQBunpackImage(Sprite + 1, 1, x, y)
  DQBcopyLayer 1, VIDEO
  DQBmouseShow
  DQBwait 7
  DQBmouseHide
  R = DQBunpackImage(Sprite, 1, x, y)
  DQBcopyLayer 1, VIDEO
  DQBmouseShow
 
  Delay = INT(RND * MaxDelay) + MinDelay
 
  FOR Counter = 1 TO Delay
    Guard 0, 0, 0, 0, 0, 0, 0, 0
  NEXT

END SUB

REM $STATIC
SUB ScoreBoard
 
  DQBfadeTo 0, 0, 0
  DQBmouseHide
  DQBclearLayer VIDEO
  DQBsetPal Pal

  Text$ = "Head shots: " + STR$(Heads)
  DQBprint VIDEO, Text$, 80, 50, 155
  Text$ = "Body shots: " + STR$(Bodies)
  DQBprint VIDEO, Text$, 80, 60, 155
  Text$ = "Total kills: " + STR$(Heads + Bodies)
  DQBprint VIDEO, Text$, 80, 70, 155
  Text$ = "Score: " + STR$(Score)
  DQBprint VIDEO, Text$, 80, 80, 155
  DO: LOOP UNTIL DQBmouseLB
  DQBfadeTo 0, 0, 0

END SUB

SUB Setup

  DQBresetMouse
  DQBpalOff
  R = DQBunpackPal(PALETT2, Pal)
  GOSUB Update
  DQBfadeIn Pal
 
  DO
    DO: LOOP UNTIL DQBmouseLB
   
    IF DQBmouseX > 7 AND DQBmouseY > 46 AND DQBmouseX < 15 AND DQBmouseY < 54 THEN
      IF SoundEnabled THEN SoundEnabled = FALSE:  ELSE SoundEnabled = TRUE
      DO: LOOP WHILE DQBmouseLB
      GOSUB Update
    END IF
   
    IF DQBmouseX > 83 AND DQBmouseY > 62 AND DQBmouseX < 93 AND DQBmouseY < 70 AND SoundEnabled THEN
      Flag = TRUE
      DQBmouseHide
      DQBbox VIDEO, 83, 62, 93, 70, 29
      DQBline VIDEO, 83, 70, 93, 70, 65
      DQBline VIDEO, 93, 63, 93, 70, 65
      IF Flag AND BaseIO = &H210 THEN BaseIO = &H220: Flag = FALSE
      IF Flag AND BaseIO = &H220 THEN BaseIO = &H230: Flag = FALSE
      IF Flag AND BaseIO = &H230 THEN BaseIO = &H240: Flag = FALSE
      IF Flag AND BaseIO = &H240 THEN BaseIO = &H250: Flag = FALSE
      IF Flag AND BaseIO = &H250 THEN BaseIO = &H260: Flag = FALSE
      IF Flag AND BaseIO = &H260 THEN BaseIO = &H270: Flag = FALSE
      IF Flag AND BaseIO = &H270 THEN BaseIO = &H280: Flag = FALSE
      IF Flag AND BaseIO = &H280 THEN BaseIO = &H210: Flag = FALSE
      DQBmouseShow
      DO: LOOP WHILE DQBmouseLB
      GOSUB Update
    END IF

    IF DQBmouseX > 83 AND DQBmouseY > 75 AND DQBmouseX < 93 AND DQBmouseY < 83 AND SoundEnabled THEN
      Flag = TRUE
      DQBmouseHide
      DQBbox VIDEO, 83, 75, 93, 83, 29
      DQBline VIDEO, 83, 83, 93, 83, 65
      DQBline VIDEO, 93, 76, 93, 83, 65
      IF Flag AND IRQ = 2 THEN IRQ = 5: Flag = FALSE
      IF Flag AND IRQ = 5 THEN IRQ = 7: Flag = FALSE
      IF Flag AND IRQ = 7 THEN IRQ = 10: Flag = FALSE
      IF Flag AND IRQ = 10 THEN IRQ = 11: Flag = FALSE
      IF Flag AND IRQ = 11 THEN IRQ = 12: Flag = FALSE
      IF Flag AND IRQ = 12 THEN IRQ = 15: Flag = FALSE
      IF Flag AND IRQ = 15 THEN IRQ = 2: Flag = FALSE
      DQBmouseShow
      DO: LOOP WHILE DQBmouseLB
      GOSUB Update
    END IF

    IF DQBmouseX > 83 AND DQBmouseY > 88 AND DQBmouseX < 93 AND DQBmouseY < 96 AND SoundEnabled THEN
      Flag = TRUE
      DQBmouseHide
      DQBbox VIDEO, 83, 88, 93, 96, 29
      DQBline VIDEO, 83, 96, 93, 96, 65
      DQBline VIDEO, 93, 89, 93, 96, 65
      DQBmouseShow
      DO: LOOP WHILE DQBmouseLB
      IF Flag AND DMA = 1 THEN DMA = 3: Flag = FALSE
      IF Flag AND DMA = 3 THEN DMA = 5: Flag = FALSE
      IF Flag AND DMA = 5 THEN DMA = 6: Flag = FALSE
      IF Flag AND DMA = 6 THEN DMA = 7: Flag = FALSE
      IF Flag AND DMA = 7 THEN DMA = 1: Flag = FALSE
      GOSUB Update
    END IF

    IF DQBmouseX > 7 AND DQBmouseY > 110 AND DQBmouseX < 40 AND DQBmouseY < 124 THEN
      DQBmouseHide
      DQBbox VIDEO, 7, 110, 40, 124, 29
      DQBline VIDEO, 7, 124, 40, 124, 65
      DQBline VIDEO, 40, 111, 40, 124, 65
      DQBmouseShow
      DO: LOOP WHILE DQBmouseLB
      GOSUB Update
      PUT #1, 206600, HardDisk.Serial
      PUT #1, , SoundEnabled
      PUT #1, , BaseIO
      PUT #1, , IRQ
      PUT #1, , DMA
      DQBfadeTo 0, 0, 0
      DQBmouseHide
      EXIT SUB
    END IF
  LOOP

Update:
  DQBmouseHide
  R = DQBunpackImage(SETUPSND, 1, 0, 0)
  IF SoundEnabled THEN
    R = DQBunpackImage(ENABLE, 1, 7, 46)
    R = DQBunpackImage(RESOURCE, 1, 22, 62)
    SELECT CASE BaseIO
      CASE &H210: R = DQBunpackImage(BASE210, 1, 54, 62)
      CASE &H220: R = DQBunpackImage(BASE220, 1, 54, 62)
      CASE &H230: R = DQBunpackImage(BASE230, 1, 54, 62)
      CASE &H240: R = DQBunpackImage(BASE240, 1, 54, 62)
      CASE &H250: R = DQBunpackImage(BASE250, 1, 54, 62)
      CASE &H260: R = DQBunpackImage(BASE260, 1, 54, 62)
      CASE &H270: R = DQBunpackImage(BASE270, 1, 54, 62)
      CASE &H280: R = DQBunpackImage(BASE280, 1, 54, 62)
    END SELECT
    SELECT CASE IRQ
      CASE 2: R = DQBunpackImage(IRQ02, 1, 58, 75)
      CASE 5: R = DQBunpackImage(IRQ05, 1, 58, 75)
      CASE 7: R = DQBunpackImage(IRQ07, 1, 58, 75)
      CASE 10: R = DQBunpackImage(IRQ10, 1, 58, 75)
      CASE 11: R = DQBunpackImage(IRQ11, 1, 58, 75)
      CASE 12: R = DQBunpackImage(IRQ12, 1, 58, 75)
      CASE 15: R = DQBunpackImage(IRQ15, 1, 58, 75)
    END SELECT
    SELECT CASE DMA
      CASE 1: R = DQBunpackImage(DMA1, 1, 64, 88)
      CASE 3: R = DQBunpackImage(DMA3, 1, 64, 88)
      CASE 5: R = DQBunpackImage(DMA5, 1, 64, 88)
      CASE 6: R = DQBunpackImage(DMA6, 1, 64, 88)
      CASE 7: R = DQBunpackImage(DMA7, 1, 64, 88)
    END SELECT
  END IF

  DQBcopyLayer 1, VIDEO
  DQBmouseShow
  RETURN

END SUB

