/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		MONSTER.C												*/
/*	Project :	Tomb of Drewan in 'C'									*/
/*	Author :	Paul Robson												*/
/*	Created :	24th April 2001											*/
/*	Function :	Monster Information, Moving, Attack code				*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "drewan.h"

static void _MONSTCheckActivate(PLAYER *p,ROOM *r);
static void _MONSTMove(MONSTER *m,PLAYER *p);
static int  _MONSTTryMove(MONSTER *m,int x,int y);
static int  _MONSTSpell(PLAYER *p,ROOM *r,MONSTER *m,int mn);

/************************************************************************/
/*																		*/
/*						Get Monster Information							*/
/*																		*/
/************************************************************************/

void MONSTGetInfo(MONSTER *m)
{
	m->NextMove = 0;
	m->Speed = PARAM(PR_DEFMONSTERSPEED,1300);
	switch(m->Type)
	{
	case MT_DKLORD:
		m->Graphic = GR_MAGICMONSTER;m->Colour = COL_BLACK;
		m->Strength = PARAM(PR_DARKLORDSTR,10);
		strcpy(m->Name,"Dark Lord");
		break;
	case MT_SPELLMAKER:
		m->Graphic = GR_MAGICMONSTER;m->Colour = COL_YELLOW;
		m->Strength = PARAM(PR_SPELLMAKERSTR,7);
		strcpy(m->Name,"Spell Maker");
		break;
	case MT_SORCEROR:
		m->Graphic = GR_MAGICMONSTER;m->Colour = COL_BLUE;
		m->Strength = PARAM(PR_SORCERORSTR,4);
		strcpy(m->Name,"Sorceror");
		break;
	case MT_DEATHMASTER:
		m->Graphic = GR_MONSTER;m->Colour = COL_BLACK;
		m->Strength = PARAM(PR_DEATHMASTERSTR,4);
		strcpy(m->Name,"Death Master");
		break;
	case MT_SOULSTEALER:
		m->Graphic = GR_MONSTER;m->Colour = COL_YELLOW;
		m->Strength = PARAM(PR_SOULSTEALERSTR,2);
		strcpy(m->Name,"Soul Stealer");
		break;
	case MT_GUARD:
		m->Graphic = GR_MONSTER;m->Colour = COL_BLUE;
		m->Strength = PARAM(PR_TOMBGUARDSTR,1);
		strcpy(m->Name,"Tomb Guard");
		break;
	}
}

/************************************************************************/
/*																		*/
/*							Do the monster stuff						*/
/*																		*/
/************************************************************************/

void MONSTAction(PLAYER *p,ROOM *r)
{
	int i,Done;
	_MONSTCheckActivate(p,r);				/* Check for activation */
	for (i = 0;i < MCOUNT;i++)
		if (r->Monster[i].State == MS_ACTIVE &&
			IOTimer() > r->Monster[i].NextMove &&
			r->Desc->MonsterDead[i] == 0)
		{
			r->Monster[i].NextMove =		/* Set timer */
						IOTimer()+r->Monster[i].Speed;
			_MONSTMove(&(r->Monster[i]),p);	/* Move towards player */
		}


	for (i = 0;i < MCOUNT;i++)				/* Check if next to us */
	{

		Done = 0;
		if (r->Monster[i].Pos.y == p->Pos.y &&	/* Magic monster firing ? */
			(r->Monster[i].Graphic & 0xFF) == GR_MAGICMONSTER &&
			r->Monster[i].State == MS_ACTIVE)
			{
			Done = _MONSTSpell(p,r,&(r->Monster[i]),i);
			}
		if (abs(r->Monster[i].Pos.x-p->Pos.x) <= 1 &&
			abs(r->Monster[i].Pos.y-p->Pos.y) <= 1 &&
			r->Monster[i].State == MS_ACTIVE && Done == 0)
		{									/* We've bin bashed */
			p->Strength = p->Strength - PARAM(PR_BASHSTRENGTHLOSS,3);
			p->Wounds = p->Wounds + r->Monster[i].Strength;
		}
	}
}

/************************************************************************/
/*																		*/
/*						Check monsters for activation					*/
/*																		*/
/************************************************************************/

static void _MONSTCheckActivate(PLAYER *p,ROOM *r)
{
	static long lNextCheck = 0;
	int i,c,d,d1,d2;

	if (lNextCheck == 0)					/* Give five seconds grace */
			lNextCheck = IOTimer()+5000;
	if (IOTimer() < lNextCheck) return;		/* Not time yet */

	d1 = PARAM(PR_MINCHECKTIME,2000);		/* Calculate next check time */
	d2 = PARAM(PR_MAXCHECKTIME,6000);
	lNextCheck = IOTimer()+d1 + rand()%(d2-d1);
	c = 0;									/* Count number active */
	for (i = 0;i < MCOUNT;i++)
		if (r->Monster[i].State == MS_ACTIVE) c++;
	if (c > 0)								/* Some active maybe just 1 */
	{
		if (IOIsClassic()) return;			/* Not the classic ! */
		if (PARAM(PR_MULTIMONST,1) == 0) return;
	}

	c = -1;d = 9999;						/* Find the nearest */
	for (i = 0;i < 4;i++)
		if (r->Monster[i].State == MS_INACTIVE)
		{
			d1 = (r->Monster[i].Pos.x - p->Pos.x);
			d2 = (r->Monster[i].Pos.y - p->Pos.y);
			d1 = d1*d1 + d2*d2;
			if (d1 < d) { c = i;d = d1; }
		}

	d1 = PARAM(PR_ACTDISTANCE,6);			/* How close you need to be */
	if (d >= d1*d1) return;					/* None close, return */

	r->Monster[c].State = MS_ACTIVE;		/* Set active, draw it */
	DRAWChar(r->Monster[c].Pos.x,			/* and wait for the fun :) */
			 r->Monster[c].Pos.y,
			 r->Monster[c].Graphic,
			 r->Monster[c].Colour);
}

/************************************************************************/
/*																		*/
/*								Move Monsters							*/
/*																		*/
/************************************************************************/

static void _MONSTMove(MONSTER *m,PLAYER *p)
{
	int Moved,dx,dy;
	dx = DRAWToward(m->Pos.x,p->Pos.x)-m->Pos.x;
	dy = DRAWToward(m->Pos.y,p->Pos.y)-m->Pos.y;
	Moved = _MONSTTryMove(m,dx,dy);
	if (Moved == 0) Moved = _MONSTTryMove(m,0,dy);
	if (Moved == 0) Moved = _MONSTTryMove(m,dx,0);
	if (Moved == 0) Moved = _MONSTTryMove(m,dx,0);
	dx = rand()%2*2-1;dy = 0;
	if (rand()%2 == 0) { dy = dx;dx = 0; }
	if (Moved == 0) Moved = _MONSTTryMove(m,dx,dy);
}

/************************************************************************/
/*																		*/
/*					See if a specific move is possible					*/
/*																		*/
/************************************************************************/

static int _MONSTTryMove(MONSTER *m,int x,int y)
{
	POINT p;
	p.x = x + m->Pos.x;p.y = y + m->Pos.y;	/* Calculate new position */
	if (MAP(p.x,p.y) != GR_SPACE) return 0;	/* Can't move there */
	DRAWChar(m->Pos.x,m->Pos.y,' ',0);		/* Erase it */
	DRAWAnimate(&(m->Pos),&p,m->Graphic,m->Colour,m->Speed/15);
	DRAWChar(p.x,p.y,m->Graphic,m->Colour);
	m->Pos = p;
	return 1;
}

/************************************************************************/
/*																		*/
/*					Do Damage to a particular monster					*/
/*																		*/
/************************************************************************/

int MONSTDamage(PLAYER *p,ROOM *r,int x,int y,int Damage)
{
	int i,n = -1;
	for (i = 0;i < MCOUNT;i++)				/* Find the monster */
		if (r->Monster[i].Pos.x == x && r->Monster[i].Pos.y == y) n = i;
	if (n < 0) return 0;					/* Nope..... */
	if (Damage == 999)						/* Petrified ? */
	{
		r->Monster[n].State = MS_FROZEN;
		return 0;
	}
	r->Monster[n].Strength -= Damage;		/* Check for damage */
	if (r->Monster[n].Strength < 0)
	{
		DRAWChar(x,y,' ',0);          		/* Blank */
		r->Monster[n].State = MS_DEAD;		/* Kill it */
		p->Kills++;							/* One more Kill */
		r->Desc->MonsterDead[n] = 1;		/* Mark it killed */
	}
	else
		DRAWChar(x,y,r->Monster[n].Graphic,r->Monster[n].Colour);
	return(r->Monster[n].State == MS_DEAD);
}

/************************************************************************/
/*																		*/
/*						Monster attacks with a spell					*/
/*																		*/
/************************************************************************/

static int _MONSTSpell(PLAYER *p,ROOM *r,MONSTER *m,int mn)
{
	int Mirror,c,n,n1,d;
	POINT p1,p2;
	d =abs(p->Pos.x - m->Pos.x);			/* Calc. distance */
	if (d > 5 || d < 2) return 0;			/* Too far/too close */
	d = 1;if (m->Pos.x > p->Pos.x) d = -1;	/* Calculate distance */
	n = 1;
	while (m->Pos.x + d*n != p->Pos.x)		/* See if possible */
	{
		c = MAP(m->Pos.x+d*n,m->Pos.y);		/* Can go through mirror,space */
		if (c != GR_SPACE && c != GR_MIRROR) return 0;
		n++;
	}
	Mirror = n1 = 0;p1 = m->Pos;			/* Start pos */
	while (n-- > 0)							/* Move up to n times */
	{
		p2.x = p1.x+d;p2.y = p1.y;n1++;		/* Work out next pos */
		DRAWAnimate(&p1,&p2,GR_BOLT,		/* Animate the bolt */
						COL_YELLOW,PARAM(PR_SPELLTIME,300));
		if (IOGet() == 'M' &&				/* Mirror spell ? */
						p->Has[HF_MIRROR] != 0)
		{
			p->Has[HF_MIRROR] = 0;
			DRAWChar(p2.x,p2.y,GR_MIRROR,COL_WHITE);
			d = -d;n = n1;Mirror = 1;
		}
		p1 = p2;
	}
	if (Mirror == 0)         				/* Spell hit ! */
	{
		p->Wounds = p->Wounds+m->Strength;	/* No, do the damage */
		return 1;
	}

	for (n = 0;n < 10;n++)					/* Little bit of animation */
	{
		DRAWChar(m->Pos.x,m->Pos.y,GRX_REFLECTMONSTER,m->Colour);
		DRAWDelay(100);
		DRAWChar(m->Pos.x,m->Pos.y,' ',0);  /* Blank */
		DRAWDelay(100);
	}
	m->State = MS_DEAD;						/* Kill it */
	p->Kills++;								/* One more Kill */
	r->Desc->MonsterDead[mn] = 1;			/* Mark it killed */
	return 1;								/* Monster now dead,no more */
}

/************************************************************************/
/*																		*/
/*							   Vampire Event							*/
/*																		*/
/************************************************************************/

void MONSTVampire(PLAYER *p,ROOM *r)
{
	int i,c,vx;
	POINT p1,p2;
	if (p->Pos.x == 0) return;				/* Not if at left edge */
	c = 0;
	for (i = 0;i < MCOUNT;i++)				/* Count number of others */
		if (r->Monster[i].State == MS_ACTIVE) c++;
	if (c > 0) return;						/* Not if other active monsters */
	c = 0;p1.x = 0;p1.y = p->Pos.y;vx = 1;	/* Set vampire initial posn */

	do
	{
		c = (c+1) & 7;
		p2.x = p1.x+vx;p2.y = p1.y;			/* New position */
		DRAWAnimate(&p1,&p2,GR_VAMPIRE,c,PARAM(PR_VAMPIRESPEED,100));
		p1 = p2;
		if (IOGet() == 'V' &&				/* Vampire Spell ! */
						p->Has[HF_VAMPIRE] != 0)
		{
			p->Has[HF_VAMPIRE] = 0;			/* Spell used */
			IODraw(p1.x*8,p1.y*8,GR_SPLAT,c);
			DRAWDelay(200);
			DRAWRefresh(p1.x*8,p1.y*8);
			p1.x = 0;
		}
		if (p1.x == p->Pos.x)				/* Hit player */
		{
			vx = -1;						/* Go back */
			p->Strength = p->Strength - PARAM(PR_VAMPIREHIT,10);
			PANELRefresh(p);
		}
	}
	while (p1.x != 0);						/* until reached edge/player */
}
