/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		PANEL.C													*/
/*	Project :	Tomb of Drewan in 'C'									*/
/*	Author :	Paul Robson												*/
/*	Created :	23rd April 2001											*/
/*	Function :	Draw the panel (the status bar etc.)					*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "drewan.h"

static void _PANELItem(int Object,int Available,int x);

/************************************************************************/
/*																		*/
/*					  Draw the panel (Classic Version)					*/
/*																		*/
/************************************************************************/

void PANELDraw(PLAYER *p)
{
	int x,y;
	if (!IOIsClassic())          			/* Do we have our own panel */
			if (IOXPanel()) return;			/* drawer ? */
	for (x = 0;x < 22;x++)              	/* Erase it */
		for (y = 18;y < 23;y++)
			DRAWChar(x,y,96,COL_GREEN);
	DRAWPrint(0,22,COL_CYAN+COL_REVTEXT,"TIME");
	DRAWPrint(4,22,COL_CYAN," :  :  ");
	DRAWPrint(12,22,COL_CYAN+COL_REVTEXT,"WND");
	DRAWPrint(15,22,COL_BLACK,"    %  ");
	DRAWPrint(0,21,COL_CYAN+COL_REVTEXT,"GOLD");
	DRAWPrint(4,21,COL_CYAN,"       ");
	DRAWPrint(12,21,COL_CYAN+COL_REVTEXT,"STR");
	DRAWPrint(15,21,COL_BLACK,"       ");
	DRAWPrint(7,20,COL_CYAN+COL_REVTEXT,"               ");
	DRAWPrint(0,19,COL_CYAN+COL_REVTEXT,"OPTIONS");
	DRAWPrint(7,19,COL_CYAN,"ACDEFIJMOPRSTVW");
	_PANELItem(0,1,9);_PANELItem(0,1,12);		/* Light the always on panels */
	_PANELItem(0,1,15);_PANELItem(0,1,18);_PANELItem(0,1,19);
	PANELRefresh(p);
}

/************************************************************************/
/*																		*/
/*					  Update the panel (Classic Version)				*/
/*																		*/
/************************************************************************/

static int PanelPos[HF_FLAGS-5] =			/* Position of panel objects */
			{ 13,17,0,8,10,21,11,0,16,20,14 };

void PANELRefresh(PLAYER *p)
{
	int i;
	long t;
	char Temp[16];
	if (!IOIsClassic())          			/* Do we have our own panel */
		if (IOXPanelRefresh(p)) return;		/* drawer ? */

											/* Draw basic panel stuff */
	sprintf(Temp,"%d",p->Arrows > 9 ? 9 : p->Arrows);
	DRAWPrint(7,20,COL_RED,Temp);
	sprintf(Temp,"%3d",p->Gold > 999 ? 999:p->Gold);
	DRAWPrint(4,21,COL_BLACK,Temp);
	sprintf(Temp,"%3d",p->Strength < 0 ? 0 : p->Strength);
	DRAWPrint(15,21,COL_BLACK,Temp);
	t = (IOTimer()-p->StartTimer)/1000;		/* Calculate elapsed time */
	sprintf(Temp,"%ld:%02ld:%02ld",t/3600,(t/60)%60,t%60);
	DRAWPrint(4,22,COL_BLACK,Temp);
	sprintf(Temp,"%3d",p->Wounds > 100 ? 100 : p->Wounds);
	DRAWPrint(15,22,COL_BLACK,Temp);

	for (i = 0;i < HF_FLAGS;i++)			/* Draw all the objects */
			_PANELItem(i,p->Has[i],PanelPos[i]);
}

/************************************************************************/
/*																		*/
/*							Light the treasures							*/
/*																		*/
/************************************************************************/

											/* Macro to draw treasures */
#define DRAWOBJ(x,y,a,c,co) DRAWChar(x,y,(a)?(c):96,(a)?(co):COL_GREEN)

static void _PANELItem(int Object,int Available,int x)
{
	switch(Object)
	{
		case HF_WATERSTONE:
			DRAWOBJ(3,20,Available,GRX_WATERSTONE,COL_BLACK);
		case HF_AIRSTONE:
			DRAWOBJ(4,20,Available,GRX_AIRSTONE,COL_YELLOW);
		case HF_FIRESTONE:
			DRAWOBJ(5,20,Available,GRX_FIRESTONE,COL_MAGENTA);
		case HF_EARTHSTONE:
			DRAWOBJ(6,20,Available,GRX_EARTHSTONE,COL_WHITE);
		case HF_AMULET:
			DRAWOBJ(1,20,Available,GRX_AMULET,COL_RED);
			break;
		default:
			if (x > 0)
				DRAWChar(x,20,Available ? GRX_HASOBJECT:GRX_NOOBJECT,COL_YELLOW);
			break;
	}
}

