'- Unofficial Tournament Battleground Editor
'- January, 2001 - Created by Joe King

                                        '- declare subs
                                          DECLARE SUB LoadPalette ()
                                          DECLARE SUB Load ()
                                          DECLARE SUB PutUpMap ()
                                          DECLARE SUB Save ()
                                        
                                        '- dimension variables
                                          DIM x AS INTEGER, y AS INTEGER
                                          DIM ox AS INTEGER, oy AS INTEGER
                                          DIM tile AS INTEGER
                                          DIM Trace AS INTEGER
                                          DIM OTrace AS INTEGER
                                          DIM SHARED eps AS INTEGER

                                        '- dimension array variables
                                          DIM SHARED Map(32, 20) AS INTEGER

                                        '- starting variable numbers
                                          x = 1: y = 1
                                          tile = 0
                                          Trace = 0: OTrace = 1
                                          eps = 52

  '- startup
    SCREEN 13
    CLS

  '-temporary
    CHDIR "c:\qb\ut"


  '- load the palette
    LoadPalette


  '- load the sprites
    filename$ = "TILES.PUT"
    FileNo = FREEFILE
    OPEN filename$ FOR BINARY AS #FileNo
    Ints = (LOF(FileNo) - 7) \ 2
    CLOSE #FileNo
    REDIM SHARED sprites%(0 TO Ints)
    DEF SEG = VARSEG(sprites%(0))
    BLOAD filename$, 0
    eps = 52
    DEF SEG


  DO
  '- put cursor on the screen
    PUT (x * 10 - 10, y * 10 - 10), sprites%(eps * tile), PSET
    LINE (x * 10 - 10, y * 10 - 10)-(x * 10 - 10 + 9, y * 10 - 10 + 9), 7, B

  '- get input from user
    DO
      a$ = INKEY$
    LOOP WHILE a$ = ""
      ox = x: oy = y
      IF a$ = CHR$(0) + "M" THEN x = x + 1
      IF a$ = CHR$(0) + "K" THEN x = x - 1
      IF a$ = CHR$(0) + "P" THEN y = y + 1
      IF a$ = CHR$(0) + "H" THEN y = y - 1
      IF a$ = CHR$(0) + "S" THEN Map(x, y) = 0
      IF a$ = CHR$(9) THEN tile = Map(x, y)
      IF a$ = CHR$(27) THEN END
      IF a$ = "+" THEN tile = tile + 1
      IF a$ = "-" THEN tile = tile - 1
      IF a$ = " " THEN Map(x, y) = tile
      IF UCASE$(a$) = "T" THEN SWAP Trace, OTrace
      IF UCASE$(a$) = "S" THEN Save
      IF UCASE$(a$) = "L" THEN Load
    '- check if tile if out of the list of tiles
      IF tile < 0 THEN tile = 31
      IF tile > 31 THEN tile = 0
    '- check if coordinates are of border
      IF x < 1 THEN x = 1
      IF x > 32 THEN x = 32
      IF y < 1 THEN y = 1
      IF y > 20 THEN y = 20
    '- check if trace mode is on and if it is put a tile on the map
      IF Trace = 1 THEN Map(x, y) = tile
    '- erase old spot
      PUT (ox * 10 - 10, oy * 10 - 10), sprites%(eps * Map(ox, oy)), PSET
  LOOP

SUB Load

                                        '- dimension variables
                                          DIM filename AS STRING

  '- clear the screen
    CLS

  '- get the filename from the user
    INPUT "enter filename"; filename

  '- load the map
    OPEN filename + ".UTM" FOR INPUT AS #1
      FOR y = 1 TO 20
        FOR x = 1 TO 32
          INPUT #1, Map(x, y)
        NEXT x
      NEXT y
    CLOSE #1

  '- put up the map
    PutUpMap

END SUB

SUB LoadPalette

DEFINT A-Z
REDIM PaletteArray&(0 TO 255)
FileNo = FREEFILE
OPEN "GRADIENT.PAL" FOR BINARY AS #FileNo
FOR n = 0 TO 255
GET #FileNo, , colour&
PaletteArray&(n) = colour&
NEXT n
CLOSE #FileNo
DIM RGBval(0 TO 255, 0 TO 2)
FOR n = 0 TO 255
c& = PaletteArray&(n)
B = c& \ 65536: c& = c& - B * 65536
g = c& \ 256: c& = c& - g * 256
r = c&
RGBval(n, 0) = r
RGBval(n, 1) = g
RGBval(n, 2) = B
NEXT n
WAIT &H3DA, &H8, &H8: WAIT &H3DA, &H8
FOR n = 0 TO 255
OUT &H3C8, n
OUT &H3C9, RGBval(n, 0)
OUT &H3C9, RGBval(n, 1)
OUT &H3C9, RGBval(n, 2)
NEXT n

END SUB

DEFSNG A-Z
SUB PutUpMap

  '- put the map on the screen
    FOR y = 1 TO 20
      FOR x = 1 TO 32
        PUT (x * 10 - 10, y * 10 - 10), sprites%(eps * Map(x, y)), PSET
      NEXT x
    NEXT y

END SUB

SUB Save

                                        '- dimension variables
                                          DIM filename AS STRING

  '- clear the screen
    CLS

  '- get the filename from the user
    INPUT "enter filename"; filename

  '- save the map
    OPEN filename + ".UTM" FOR OUTPUT AS #1
      FOR y = 1 TO 20
        FOR x = 1 TO 32
          WRITE #1, Map(x, y)
        NEXT x
      NEXT y
    CLOSE #1

  '- put the map back up
    PutUpMap

END SUB

