DECLARE SUB startup ()
DECLARE SUB conclusion ()
DECLARE FUNCTION getkey$ ()
DECLARE SUB playwav (wavefile$, watp%)
DECLARE FUNCTION playlevel% (level$, levnum%, savegame$)
DECLARE SUB Fade2Black (value%, stval%)
DECLARE SUB wigglenow (numwig%, outadd%)
DECLARE SUB loadgame (level$)
DECLARE FUNCTION pause% (numops%, item1 AS STRING, item2 AS STRING, item3 AS STRING, item4 AS STRING, message AS STRING)
DECLARE SUB Font1 (x%, y%, text$, tfont%, scr%)
DECLARE FUNCTION menu% (numops%, ch1 AS STRING, ch2 AS STRING, ch3 AS STRING, ch4 AS STRING, ch5 AS STRING, beginchoice%)
DECLARE SUB handlebdguy ()
DECLARE SUB drawscreen ()
DECLARE SUB handleplayer ()
DECLARE SUB memcopy (fromseg%, fromoff%, toseg%, tooff%, bytes%)
DECLARE SUB makepal (att%, r%, g%, B%)
DECLARE SUB Blastput (dsegment%, doffset%, ssegment%, soffset%, xpos%, ypos%, icol%)
DECLARE SUB Initlib ()
DECLARE FUNCTION NumEMSHandles% ()
DECLARE FUNCTION NumEMSPages% (Handle%)
DECLARE FUNCTION GetEMS% (numpages%)
DECLARE FUNCTION EMSPages% (func%)
DECLARE FUNCTION PageFrame% ()
DECLARE FUNCTION EMSstatus% ()
DECLARE SUB releaseems (Handle%)
DECLARE SUB mapems (Handle%, pageoffset%)
DEFINT A-Z
DIM SHARED emssegment1%
DIM SHARED emshandle1%
'$DYNAMIC

SCREEN 0: WIDTH 80, 25
CLS
IF EMSstatus% THEN
   PRINT "EMS installed."
   emshandle1% = GetEMS%(12)
   emssegment1% = PageFrame%
   PRINT "Free EMS memory (in bytes):"; EMSPages%(1) * 16000#
ELSE
   PRINT "EMS not installed.  Aborting."
   PRINT
   END
END IF

DIM SHARED code1%(14), code3%(76), code4%(76)
Initlib
PRINT "Blast! Graphics Routines loaded: BlastGet, BlastPut"

TYPE tbl
 cosx AS SINGLE
 sinx AS SINGLE
END TYPE

TYPE player
 dir AS INTEGER
 x AS INTEGER
 y AS INTEGER
END TYPE

TYPE enemy
 x AS INTEGER
 y AS INTEGER
 frame AS INTEGER
 dir AS INTEGER
 entype AS INTEGER
END TYPE
                       
TYPE stat
 score AS INTEGER
 tail AS INTEGER
 curball AS INTEGER
 wormdead AS INTEGER
 tailsw AS INTEGER
 curlevel AS STRING * 12
 levnum AS INTEGER
 curitemtype AS INTEGER
 curitemx AS INTEGER
 curitemy AS INTEGER
 flashframe AS INTEGER
 timeset AS LONG
 frameset AS INTEGER
 fps AS INTEGER
END TYPE

TYPE wiggle
 dir AS INTEGER
 x AS INTEGER
 y AS INTEGER
 Segment AS INTEGER
 address AS INTEGER
END TYPE

DIM SHARED byte AS STRING * 1
DIM SHARED xasm AS STRING, masm AS STRING
DIM SHARED me(0 TO 404 * 30) AS STRING * 1
DIM SHARED map(0 TO 15, 0 TO 9) AS INTEGER
DIM SHARED offscr(0 TO 31999) AS INTEGER
DIM SHARED tag AS STRING * 5
DIM SHARED waterpal(0 TO 4)  AS INTEGER
DIM SHARED tbl(0 TO 15) AS tbl
DIM SHARED enemy(0 TO 14) AS enemy
DIM SHARED player(0 TO 50) AS player
DIM SHARED stat AS stat
DIM SHARED longval AS LONG
DIM SHARED yval(0 TO 199) AS INTEGER
DIM SHARED ballx(0 TO 9)  AS player
DIM SHARED font(-1 TO 35, 0 TO 2) AS INTEGER
DIM SHARED Blankspace(0 TO 639)  AS INTEGER
DIM SHARED wiggle(0 TO 14) AS wiggle
DIM SHARED delaybit AS LONG, soundbit AS INTEGER

xasm = ""
xasm = xasm + CHR$(85) + CHR$(137) + CHR$(229) + CHR$(139)
xasm = xasm + CHR$(86) + CHR$(8) + CHR$(139) + CHR$(126) + CHR$(6)
xasm = xasm + CHR$(139) + CHR$(118) + CHR$(10) + CHR$(177) + CHR$(0)
xasm = xasm + CHR$(48) + CHR$(237) + CHR$(180) + CHR$(68) + CHR$(136)
xasm = xasm + CHR$(200) + CHR$(137) + CHR$(243) + CHR$(205) + CHR$(103)
xasm = xasm + CHR$(70) + CHR$(65) + CHR$(57) + CHR$(249) + CHR$(117)
xasm = xasm + CHR$(242) + CHR$(93) + CHR$(203)

masm = ""
masm = masm + CHR$(85) + CHR$(137) + CHR$(229) + CHR$(30)
masm = masm + CHR$(139) + CHR$(70) + CHR$(10) + CHR$(142) + CHR$(192)
masm = masm + CHR$(139) + CHR$(70) + CHR$(14) + CHR$(142) + CHR$(216)
masm = masm + CHR$(139) + CHR$(118) + CHR$(8) + CHR$(139) + CHR$(126)
masm = masm + CHR$(12) + CHR$(139) + CHR$(78) + CHR$(6) + CHR$(243)
masm = masm + CHR$(164) + CHR$(31) + CHR$(93) + CHR$(203)


FOR i = 0 TO 199
 yval(i) = i * 320
NEXT i

CONST true = -1
CONST false = 0

stat.tail = 5

font(-1, 0) = 676
font(-1, 1) = 104
OPEN "wormer.cfg" FOR BINARY AS 1
 FOR a = 0 TO 1
  FOR i = 0 TO 35
   GET #1, , font(i, a)
  NEXT i
 NEXT a

 GET #1, , delaybit
 GET #1, , soundbit
CLOSE 1

mapems emshandle1%, 4

DEF SEG = emssegment1%
BLOAD "Ballgfx.wrm", 0
BLOAD "enemy.gfx", 5657
BLOAD "wormfont.gfx", 8889
BLOAD "wormfnt2.gfx", 33226
BLOAD "numdat.gfx", 36970
BLOAD "plusitem.gfx", 49170

mapems emshandle1%, 0


FOR i = 0 TO 15
 tbl(i).cosx = COS(i * ATN(1) / 2)
 tbl(i).sinx = SIN(i * ATN(1) / 2)
NEXT i

SCREEN 13



5
makepal 0, 63, 63, 63
makepal 1, 0, 40, 0
makepal 2, 0, 0, 0
makepal 3, 0, 63, 0
makepal 4, 63, 32, 0

DEF SEG = VARSEG(me(0))
BLOAD "ttl.wrm", VARPTR(me(0))

DEF SEG = &HA000
BLOAD "wormerbg.bsv", 0
OUT &H3C8, 32
FOR a = 0 TO 191
 OUT &H3C9, PEEK(a + 64000)
NEXT a

mapems emshandle1%, 0
memcopy &HA000, 0, emssegment1%, 0, &HFA00

10
mychoice = menu(5, "NEW GAME", "LOAD GAME", "OPTIONS", "CREDITS", "EXIT", 0)

IF mychoice = 0 THEN
 newchoice = menu(3, "CAMPAIGN", "CUSTUM", "BACK", " ", " ", 0)
 IF newchoice = 0 THEN
  startup
  makepal 0, 0, 0, 0
  results = playlevel("level1.map", 1, "NEW")
  IF results = 1 THEN results = playlevel("level2.map", 2, "NEW")
  IF results = 1 THEN results = playlevel("level3.map", 3, "NEW")
  IF results = 1 THEN results = playlevel("level4.map", 4, "NEW")
  IF results = 1 THEN results = playlevel("level5.map", 5, "NEW")
  IF results = 1 THEN results = playlevel("level6.map", 6, "NEW")
  IF results = 1 THEN results = playlevel("level7.map", 7, "NEW")
  IF results = 1 THEN results = playlevel("level8.map", 8, "NEW")
  IF results = 1 THEN results = playlevel("level9.map", 9, "NEW")
  IF results = 1 THEN conclusion
  stat.score = 0
  GOTO 5
 ELSEIF newchoice = 1 THEN
  DEF SEG = &HA000
  BLOAD "stagescr.gfx", 0
  OUT &H3C8, 0
  FOR a = 0 TO 767
   OUT &H3C9, PEEK(a + 64000)
  NEXT a
  makepal 4, 63, 0, 0
  makepal 16, 63, 0, 0
  Font1 90, 10, "CUSTOM GAME", 0, &HA000
  Font1 145, 60, "ENTER FILENAME", 1, &HA000
  LINE (145, 71)-(260, 83), 0, BF
  LINE (145, 71)-(260, 83), 4, B
  Font1 145, 85, "DO NOT PUT", 1, &HA000
  Font1 145, 97, "EXTENSION", 1, &HA000
 
  CLOSE 1
  message$ = getkey$
  IF message$ <> "" THEN
   OPEN message$ + ".map" FOR BINARY AS 1
   IF LOF(1) = 225 THEN
    filetag$ = "*wrm*"
    FOR i = 1 TO 5
     GET #1, , byte
     IF byte <> MID$(filetag$, i, 1) THEN GOTO 5
    NEXT i
    CLOSE 1
    results = playlevel(message$ + ".map", 0, "NEW")
    GOTO 5
   END IF
   GOTO 5
  END IF
  GOTO 5
  
 ELSEIF newchoice = 2 THEN
  GOTO 10
 END IF
END IF
 
IF mychoice = 1 THEN
 OPEN "save1.wsv" FOR BINARY AS #1
 IF LOF(1) < 10 THEN item1$ = "EMPTY"
 IF LOF(1) > 10 THEN item1$ = "SAVED"
 CLOSE 1
 OPEN "save2.wsv" FOR BINARY AS #1
 IF LOF(1) < 10 THEN item2$ = "EMPTY"
 IF LOF(1) > 10 THEN item2$ = "SAVED"
 CLOSE 1
 OPEN "save3.wsv" FOR BINARY AS #1
 IF LOF(1) < 10 THEN item3$ = "EMPTY"
 IF LOF(1) > 10 THEN item3$ = "SAVED"
 CLOSE 1

 newchoice = menu(4, item1$, item2$, item3$, "BACK", "", 0)

 IF newchoice >= 0 AND newchoice <= 2 THEN
  loadfile$ = "save" + RIGHT$(STR$(newchoice + 1), 1) + ".wsv"
  loadgame loadfile$
  results = playlevel(stat.curlevel, stat.levnum, loadfile$)
 
  IF results = 1 AND stat.levnum > 0 THEN
   stat.levnum = stat.levnum + 1
   FOR i = stat.levnum TO 9
    IF results = 1 THEN results = playlevel("level" + RIGHT$(STR$(stat.levnum), 1) + ".map", stat.levnum, "NEW")
   NEXT i
   IF results = 1 THEN conclusion
   stat.score = 0
   GOTO 5
  END IF

 ELSE
  GOTO 10
 END IF

 GOTO 5
END IF


IF mychoice = 2 THEN
 newchoice = menu(3, "SOUND ON", "SOUND OFF", "BACK", "", "", 0)

 IF newchoice = 0 THEN
  soundbit = 1
  OPEN "wormer.cfg" FOR BINARY AS 1
   FOR a = 0 TO 1
    FOR i = 0 TO 35
     GET #1, , font(i, a)
    NEXT i
   NEXT a

  GET #1, , delaybit
  GET #1, , soundbit
  CLOSE 1
 
  KILL "wormer.cfg"

  OPEN "wormer.cfg" FOR BINARY AS 1
   FOR a = 0 TO 1
    FOR i = 0 TO 35
     PUT #1, , font(i, a)
    NEXT i
   NEXT a

   PUT #1, , delaybit
   PUT #1, , soundbit
   CLOSE 1

 GOTO 5

 ELSEIF newchoice = 1 THEN
  soundbit = 0
  OPEN "wormer.cfg" FOR BINARY AS 1
   FOR a = 0 TO 1
    FOR i = 0 TO 35
     GET #1, , font(i, a)
    NEXT i
   NEXT a

  GET #1, , delaybit
  GET #1, , soundbit
  CLOSE 1
  KILL "wormer.cfg"

  OPEN "wormer.cfg" FOR BINARY AS 1
   FOR a = 0 TO 1
    FOR i = 0 TO 35
     PUT #1, , font(i, a)
    NEXT i
   NEXT a

   PUT #1, , delaybit
   PUT #1, , soundbit
  CLOSE 1
  GOTO 5
 ELSEIF newchoice = 2 THEN
  GOTO 10
 END IF
END IF

IF mychoice = 4 THEN releaseems emshandle1%: GOTO 12



releaseems emshandle1%

12
SCREEN 0: WIDTH 80

PRINT "THANK YOU FOR PLAYING WORMER"
PRINT "Design, graphics and programming were all done by Joe Antoon"
PRINT "Blast! Library is by Andrew Ayers"
PRINT "Single Sub WAV Player by Lord Agnathian, Angel Rift Productions"
PRINT
PRINT "Please recall that for accurate FPS logging you have to have"
PRINT "been playing for a few seconds for it to level out"
PRINT

IF stat.fps < 17 THEN
 PRINT "Looks like your computer is a little slow though, you only logged" + STR$(INT(stat.fps)) + "fps"
 PRINT "Just use setspeed.exe and change the delay to" + STR$(INT((stat.fps / 21) * 100)) + "% to correct"
ELSEIF stat.fps > 25 THEN
 PRINT "Wow, your computer is too damn fast!  It logged" + STR$(INT(stat.fps)) + "fps"
 PRINT "Just use setspeed.exe and change the delay to" + STR$(INT((stat.fps / 21) * 100)) + "% to correct"
ELSE
 PRINT "Well, your speed is just about right :)"
END IF

SLEEP

REM $STATIC
DEFSNG A-Z
SUB blastget (dsegment%, doffset%, ssegment%, soffset%, x1%, y1%, x2%, y2%)
DEF SEG = VARSEG(code4%(0))
CALL ABSOLUTE(BYVAL dsegment%, BYVAL doffset%, BYVAL ssegment%, BYVAL soffset%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, VARPTR(code4%(0)))
DEF SEG
END SUB

SUB Blastput (dsegment%, doffset%, ssegment%, soffset%, xpos%, ypos%, icol%)
  DEF SEG = VARSEG(code3%(0))

  CALL ABSOLUTE(BYVAL dsegment%, BYVAL doffset%, BYVAL ssegment%, BYVAL soffset%, BYVAL xpos%, BYVAL ypos%, BYVAL icol%, VARPTR(code3%(0)))

  DEF SEG
END SUB

DEFINT A-Z
SUB conclusion

OUT &H3C8, 0

FOR a = 0 TO 767
 OUT &H3C9, 0
NEXT a

DEF SEG = &HA000
BLOAD "stagescr.gfx", 0

OUT &H3C8, 0

FOR a = 0 TO 767
 OUT &H3C9, PEEK(a + 64000)
NEXT a

DEF SEG = VARSEG(offscr(0))
BLOAD "winner.gfx", 0

Blastput &HA000, 0, VARSEG(offscr(0)), 0, 9, 8, 0

LINE (177, 8)-(311, 192), 0, B

FOR y = 8 TO 192 STEP 2
 LINE (177, y)-(311, y), 0, , &HAAAA
 LINE (177, y + 1)-(311, y + 1), 0, , &H5555
NEXT y

makepal 16, 63, 0, 0

Font1 179, 10, "WITH ALL 81", 1, &HA000
Font1 179, 20, "ORBS WORMER", 1, &HA000
Font1 179, 30, "NOW GETS", 1, &HA000
Font1 179, 40, "THE RESPECT", 1, &HA000
Font1 179, 50, "HE DESERVES", 1, &HA000
Font1 179, 70, "AFTER A LONG", 1, &HA000
Font1 179, 80, "LIFE HE WAS", 1, &HA000
Font1 179, 90, "LAST SEEN AT", 1, &HA000
Font1 179, 100, "MIAMI BEACH", 1, &HA000
Font1 179, 110, "GETTING SOME", 1, &HA000
Font1 179, 120, "LONG NEEDED", 1, &HA000
Font1 179, 130, "REST", 1, &HA000
Font1 179, 150, "THE END", 1, &HA000

SLEEP
END SUB

SUB drawscreen
waterpal(0) = waterpal(4)

FOR i = 4 TO 1 STEP -1
 waterpal(i) = waterpal(i - 1)
 makepal i + 42, 0, 0, waterpal(i)
NEXT i

memcopy emssegment1%, 0, VARSEG(offscr(0)), 0, &HFA00

mapems emshandle1%, 4

IF ballx(stat.curball).dir >= 4 THEN
  Blastput VARSEG(offscr(0)), 0, emssegment1%, (ballx(stat.curball).dir + stat.curball) * 404, ballx(stat.curball).x * 20, ballx(stat.curball).y * 20, 0
ELSEIF ballx(stat.curball).dir <= 3 THEN
  Blastput VARSEG(offscr(0)), 0, emssegment1%, (3 - ballx(stat.curball).dir) * 404, ballx(stat.curball).x * 20, ballx(stat.curball).y * 20, 0
  Blastput VARSEG(offscr(0)), 0, emssegment1%, (ballx(stat.curball).dir) * 404, ballx(stat.curball - 1).x * 20, ballx(stat.curball - 1).y * 20, 0
 
  ballx(stat.curball).dir = ballx(stat.curball).dir + 1
END IF

FOR i = 0 TO 14
 IF enemy(i).entype <> 0 THEN
  IF enemy(i).entype <= 3 THEN
   Blastput VARSEG(offscr(0)), 0, emssegment1%, 5657 + enemy(i).frame * 404, enemy(i).x, enemy(i).y, 0
  ELSE
   Blastput VARSEG(offscr(0)), 0, emssegment1%, 5657 + (enemy(i).frame + 4) * 404, enemy(i).x, enemy(i).y, 0
  END IF
 END IF
NEXT i

i = stat.curitemtype
h = stat.flashframe

IF h >= 2 OR h = -1 THEN
IF i > -1 AND i < 3 THEN
 Blastput VARSEG(offscr(0)), 0, emssegment1%, 49170 + i * 404, stat.curitemx, stat.curitemy, 0
END IF
END IF

IF h >= 0 THEN Blastput VARSEG(offscr(0)), 0, emssegment1%, 50382 + h * 404, stat.curitemx, stat.curitemy, 0

mapems emshandle1%, 0

FOR i = 2 TO stat.tail - 3 STEP 1
 IF player(i).dir = 0 AND player(i - 1).dir = 15 THEN
  Blastput VARSEG(offscr(0)), 0, VARSEG(me(0)), VARPTR(me(104 * 16 * 1 + ((player(i).dir + 15) MOD 16) * 104)), player(i).x, player(i).y, 0
 ELSEIF player(i).dir = 15 AND player(i - 1).dir = 0 THEN
  Blastput VARSEG(offscr(0)), 0, VARSEG(me(0)), VARPTR(me(104 * 16 * 2 + ((player(i).dir + 9) MOD 16) * 104)), player(i).x, player(i).y, 0
 ELSEIF player(i).dir > player(i - 1).dir THEN
  Blastput VARSEG(offscr(0)), 0, VARSEG(me(0)), VARPTR(me(104 * 16 * 1 + ((player(i).dir + 15) MOD 16) * 104)), player(i).x, player(i).y, 0
 ELSEIF player(i).dir < player(i - 1).dir THEN
  Blastput VARSEG(offscr(0)), 0, VARSEG(me(0)), VARPTR(me(104 * 16 * 2 + ((player(i).dir + 9) MOD 16) * 104)), player(i).x, player(i).y, 0
 ELSEIF player(i).dir = player(i - 1).dir THEN
  Blastput VARSEG(offscr(0)), 0, VARSEG(me(0)), VARPTR(me(((player(i).dir + 4) MOD 16) * 104)), player(i).x, player(i).y, 0
 END IF
NEXT i

Blastput VARSEG(offscr(0)), 0, VARSEG(me(16 * 3 * 104 + player(0).dir * 104)), VARPTR(me(16 * 3 * 104 + player(0).dir * 104)), player(0).x, player(0).y, 0
Blastput VARSEG(offscr(0)), 0, VARSEG(me(16 * 4 * 104)), VARPTR(me(16 * 4 * 104)), player(stat.tail - 2).x, player(stat.tail - 2).y, 0
Blastput VARSEG(offscr(0)), 0, VARSEG(me(16 * 4 * 104 + 1 * 104)), VARPTR(me(16 * 4 * 104 + 1 * 104)), player(stat.tail - 1).x, player(stat.tail - 1).y, 0
Blastput VARSEG(offscr(0)), 0, VARSEG(me(16 * 4 * 104 + 2 * 104)), VARPTR(me(16 * 4 * 104 + 2 * 104)), player(stat.tail).x, player(stat.tail).y, 0


Font1 0, 0, "SCORE:" + STR$(stat.score), 1, 0
Font1 0, 11, STR$(stat.fps), 1, 0


DEF SEG = VARSEG(offscr(0))
memcopy VARSEG(offscr(0)), 0, &HA000, 0, &HFA00

END SUB

DEFSNG A-Z
FUNCTION EMSPages% (func%)

asm$ = ""
asm$ = asm$ + CHR$(85) + CHR$(137) + CHR$(229) + CHR$(180)
asm$ = asm$ + CHR$(66) + CHR$(205) + CHR$(103) + CHR$(139) + CHR$(126)
asm$ = asm$ + CHR$(6) + CHR$(137) + CHR$(29) + CHR$(139) + CHR$(126)
asm$ = asm$ + CHR$(8) + CHR$(137) + CHR$(21) + CHR$(93) + CHR$(203)

TotalPages% = 0: AvailablePages% = 0

DEF SEG = VARSEG(asm$)
   CALL ABSOLUTE(TotalPages%, AvailablePages%, SADD(asm$))
DEF SEG

IF func% = 0 THEN
   EMSPages% = TotalPages%
ELSE
   EMSPages% = AvailablePages%
END IF

END FUNCTION

FUNCTION EMSstatus%

asm$ = ""
asm$ = asm$ + CHR$(85) + CHR$(137) + CHR$(229) + CHR$(180)
asm$ = asm$ + CHR$(64) + CHR$(205) + CHR$(103) + CHR$(176) + CHR$(0)
asm$ = asm$ + CHR$(139) + CHR$(94) + CHR$(6) + CHR$(137) + CHR$(7)
asm$ = asm$ + CHR$(93) + CHR$(203)

EMS% = -1
DEF SEG = VARSEG(asm$)
   CALL ABSOLUTE(EMS%, SADD(asm$))
DEF SEG

IF EMS% = 0 THEN
   EMSstatus = -1         'EMS installed, set to BASIC's TRUE value.
ELSE
   EMSstatus = 0          'EMS not installed, set to FALSE.
END IF

END FUNCTION

DEFINT A-Z
SUB Fade2Black (value, stval)

FOR i = 0 TO value
 FOR a = stval TO 255
  OUT &H3C7, a
  r = INP(&H3C9)
  g = INP(&H3C9)
  B = INP(&H3C9)
  OUT &H3C8, a
  OUT &H3C9, INT(r * .95)
  OUT &H3C9, INT(g * .95)
  OUT &H3C9, INT(B * .95)
 NEXT a
 FOR a& = 0 TO delaybit: NEXT a&
NEXT i
END SUB

SUB Font1 (x, y, text$, tfont, scr)
IF scr = 0 THEN scrbit = VARSEG(offscr(0)) ELSE scrbit = &HA000

mapems emshandle1%, 4

FOR i = 1 TO LEN(text$)
 value = ASC(MID$(text$, i, 1))
 IF value >= 65 AND value <= 90 THEN
  Blastput scrbit, 0, emssegment1%, 8889 + (tfont * 24337) + (value - 65) * font(-1, tfont), x, y, 0
  x = x + font(value - 65, tfont) + 3 + -(tfont - 1) * 5
 ELSEIF value >= 48 AND value <= 57 THEN
  Blastput scrbit, 0, emssegment1%, 8889 + (tfont * 24337) + (value - 22) * font(-1, tfont), x, y, 0
  x = x + font(value - 22, tfont) + 3 + -(tfont - 1) * 5
 ELSE
  x = x + 10
 END IF
NEXT i

mapems emshandle1%, 0
END SUB

DEFSNG A-Z
FUNCTION GetEMS% (numpages%)

'pageoffset% = EMSPages%(0) - EMSPages%(1)

asm$ = ""
asm$ = asm$ + CHR$(85) + CHR$(137) + CHR$(229) + CHR$(139)
asm$ = asm$ + CHR$(94) + CHR$(8) + CHR$(180) + CHR$(67) + CHR$(205)
asm$ = asm$ + CHR$(103) + CHR$(139) + CHR$(94) + CHR$(6) + CHR$(137)
asm$ = asm$ + CHR$(23) + CHR$(93) + CHR$(203)

Handle% = 0
DEF SEG = VARSEG(asm$)
   CALL ABSOLUTE(BYVAL numpages%, Handle%, SADD(asm$))
DEF SEG

'asm$ = ""
'asm$ = asm$ + CHR$(85) + CHR$(137) + CHR$(229) + CHR$(139)
'asm$ = asm$ + CHR$(86) + CHR$(8) + CHR$(139) + CHR$(126) + CHR$(6)
'asm$ = asm$ + CHR$(139) + CHR$(118) + CHR$(10) + CHR$(177) + CHR$(0)
'asm$ = asm$ + CHR$(48) + CHR$(237) + CHR$(180) + CHR$(68) + CHR$(136)
'asm$ = asm$ + CHR$(200) + CHR$(137) + CHR$(243) + CHR$(205) + CHR$(103)
'asm$ = asm$ + CHR$(70) + CHR$(65) + CHR$(57) + CHR$(254) + CHR$(117)
'asm$ = asm$ + CHR$(242) + CHR$(93) + CHR$(203)
'
'DEF SEG = VARSEG(asm$)
'   CALL Absolute(BYVAL pageoffset%, BYVAL Handle%, BYVAL numpages%, SADD(asm$))
'DEF SEG

GetEMS% = Handle%

END FUNCTION

DEFINT A-Z
FUNCTION getkey$
a$ = ""

DO UNTIL keybd$ = CHR$(13)
 keybd$ = INKEY$
 IF keybd$ <> "" THEN
  B = ASC(UCASE$(keybd$))
 
  IF B >= 65 AND B <= 90 THEN
   IF LEN(a$) < 8 THEN
    a$ = a$ + keybd$
    Font1 136 + LEN(a$) * 10, 72, UCASE$(keybd$), 1, &HA000
   END IF
  ELSEIF B >= 48 AND B <= 57 THEN
   IF LEN(a$) < 8 THEN
    a$ = a$ + keybd$
    Font1 136 + LEN(a$) * 10, 72, UCASE$(keybd$), 1, &HA000
   END IF
  ELSEIF B = 8 THEN
   IF LEN(a$) > 0 THEN
    LINE (136 + LEN(a$) * 10, 72)-(156 + LEN(a$) * 10, 82), 0, BF
    a$ = LEFT$(a$, LEN(a$) - 1)
   END IF
  END IF

 
  END IF
LOOP

getkey = a$

END FUNCTION

SUB handlebdguy
 FOR i = 0 TO 14
  enemy(i).frame = (enemy(i).frame + 1) MOD 4
 
  IF enemy(i).entype > 0 AND enemy(i).entype < 4 THEN
  enemy(i).x = enemy(i).x + tbl(enemy(i).dir).cosx * 3
  enemy(i).y = enemy(i).y + tbl(enemy(i).dir).sinx * 3
 
  DEF SEG = VARSEG(offscr(0))
   hex = enemy(i).x + 9 + tbl(enemy(i).dir).cosx * 11
   hey = enemy(i).y + 9 + tbl(enemy(i).dir).sinx * 11
   IF PEEK(hex + yval(hey)) = 47 OR PEEK(hex + yval(hey)) = 48 THEN stat.wormdead = true: playwav "sound2.wav", -1
  
   IF PEEK(hex + yval(hey)) >= 53 OR PEEK(hex + yval(hey)) <= 56 THEN
   IF enemy(i).entype > 0 AND enemy(i).entype < 4 THEN
    FOR a = 0 TO 14
     IF enemy(a).entype = 4 THEN
      IF hex > enemy(a).x AND hex < enemy(a).x + 19 THEN
       IF hey > enemy(a).y AND hey < enemy(a).y + 19 THEN
        RANDOMIZE TIMER
        soundfile% = (RND * 3) MOD 3
        playwav "sound" + RIGHT$(STR$(soundfile% + 6), 1) + ".wav", -1
       
        IF enemy(i).entype = 1 THEN
         enemy(i).dir = (enemy(i).dir + 8) MOD 16
        ELSEIF enemy(i).entype = 2 THEN
         enemy(i).dir = (enemy(i).dir + 4) MOD 16
        ELSEIF enemy(i).entype = 3 THEN
         enemy(i).dir = (enemy(i).dir + 4) MOD 16
        END IF
       END IF
      END IF
     END IF
    NEXT a
   END IF
   END IF
 
  END IF
 NEXT i

END SUB

SUB handleplayer
keybd = INP(&H60)
null$ = INKEY$

IF stat.tailsw <> 0 THEN
 stat.tail = stat.tail + SGN(stat.tailsw)
 stat.tailsw = stat.tailsw - SGN(stat.tailsw)
 IF stat.tail < 5 THEN stat.tail = 5
END IF

IF keybd = 75 OR keybd = 77 THEN player(0).dir = player(0).dir + (keybd - 76)
IF keybd = 1 THEN
9 choice = pause(3, "CONTINUE", "SAVE GAME", "EXIT GAME", "", " WORMER ")
 IF choice = 0 THEN GOTO 27
 IF choice = 1 THEN
  OPEN "save1.wsv" FOR BINARY AS #1
  IF LOF(1) < 10 THEN item1$ = "1. EMPTY"
  IF LOF(1) > 10 THEN item1$ = "1. SAVED"
  CLOSE 1
  OPEN "save2.wsv" FOR BINARY AS #1
  IF LOF(1) < 10 THEN item2$ = "2. EMPTY"
  IF LOF(1) > 10 THEN item2$ = "2. SAVED"
  CLOSE 1
  OPEN "save3.wsv" FOR BINARY AS #1
  IF LOF(1) < 10 THEN item3$ = "3. EMPTY"
  IF LOF(1) > 10 THEN item3$ = "3. SAVED"
  CLOSE 1
  choice2 = pause(4, item1$, item2$, item3$, "BACK", "SAVE GAME")
 
  IF choice2 >= 0 AND choice2 <= 2 THEN
   KILL "save" + RIGHT$(STR$(choice2 + 1), 1) + ".wsv"
   OPEN "save" + RIGHT$(STR$(choice2 + 1), 1) + ".wsv" FOR BINARY AS 1
   PUT #1, , stat.score
   PUT #1, , stattail
   PUT #1, , stat.curball
   PUT #1, , stat.wormdead
   PUT #1, , stat.tailsw
   PUT #1, , stat.curlevel
   PUT #1, , stat.levnum

   FOR i = 0 TO 50
    PUT #1, , player(i).x
    PUT #1, , player(i).y
    PUT #1, , player(i).dir
   NEXT

   FOR i = 0 TO 14
    PUT #1, , enemy(i).x
    PUT #1, , enemy(i).y
    PUT #1, , enemy(i).frame
    PUT #1, , enemy(i).dir
    PUT #1, , enemy(i).entype
   NEXT i
 
   FOR i = 0 TO 9
    PUT #1, , ballx(i).x
    PUT #1, , ballx(i).y
    PUT #1, , ballx(i).dir
   NEXT i
  
   CLOSE 1
  ELSE
   GOTO 9
  END IF
 
  FOR a& = 0 TO delaybit: NEXT a&
  GOTO 9
 END IF

 IF choice = 2 THEN stat.wormdead = true: GOTO 27
END IF



27
IF player(0).dir > 15 THEN player(0).dir = 0
IF player(0).dir < 0 THEN player(0).dir = 15
player(0).x = player(0).x + tbl(player(0).dir).cosx * 5
player(0).y = player(0).y + tbl(player(0).dir).sinx * 5

FOR i = 50 TO 1 STEP -1
 player(i) = player(i - 1)
NEXT i


mapems emshandle1%, 0
DEF SEG = VARSEG(offscr(0))

myx = player(0).x + 4 + tbl(player(0).dir).cosx
myy = player(0).y + 4 + tbl(player(0).dir).sinx

IF PEEK(myx + yval(myy)) >= 40 AND PEEK(myx + yval(myy)) <= 46 THEN stat.wormdead = true: playwav "sound3.wav", -1
IF PEEK(myx + yval(myy)) >= 47 AND PEEK(myx + yval(myy)) <= 48 THEN stat.wormdead = true: playwav "sound9.wav", -1
IF PEEK(myx + yval(myy)) >= 53 AND PEEK(myx + yval(myy)) <= 56 THEN stat.wormdead = true: playwav "sound2.wav", -1

IF myx > ballx(stat.curball).x * 20 AND myx < ballx(stat.curball).x * 20 + 19 THEN
 IF myy > ballx(stat.curball).y * 20 AND myy < ballx(stat.curball).y * 20 + 19 THEN
  IF PEEK(myx + yval(myy)) >= 49 AND PEEK(myx + yval(myy)) <= 52 THEN
   playwav "sound4.wav", -1
   stat.curball = stat.curball + 1
   stat.score = stat.score + (stat.curball) * 100
   stat.tailsw = 2
   ballx(stat.curball).dir = 0
   IF stat.curball = 9 THEN stat.wormdead = 1: playwav "sound1.wav", -1: EXIT SUB
  END IF
 END IF
END IF

IF myx > stat.curitemx AND myy > stat.curitemy THEN
 IF myx < stat.curitemx + 19 AND myy < stat.curitemy + 19 THEN
  IF stat.curitemtype > -1 THEN
   SELECT CASE stat.curitemtype
    CASE 0
     stat.tailsw = stat.tailsw - 2
    CASE 1
     stat.tailsw = stat.tailsw + 2
    CASE 2
     stat.tailsw = stat.tailsw + 4
   END SELECT
  
   stat.curitemtype = -1
  END IF
 END IF
END IF
IF player(0).x < 0 THEN player(0).x = 0
IF player(0).x > 310 THEN player(0).x = 310
0 IF player(0).y < 0 THEN player(0).y = 0
IF player(0).y > 189 THEN player(0).y = 189

IF stat.flashframe > -1 THEN stat.flashframe = stat.flashframe + 1
IF stat.flashframe = 5 THEN stat.flashframe = -1

IF stat.curitemtype = -1 AND stat.flashframe = -1 THEN
 RANDOMIZE TIMER
 decider = INT(RND * 32) - 29
 IF decider > -1 AND decider < 3 THEN
  stat.curitemtype = decider
  IF stat.curitemtype <> -1 THEN stat.flashframe = 0
4 stat.curitemx = 16 * RND
  stat.curitemy = 10 * RND
  IF map(stat.curitemx, stat.curitemy) <> 20 THEN GOTO 4
  stat.curitemx = stat.curitemx * 20
  stat.curitemy = stat.curitemy * 20
  playwav "sound5.wav", -1
 END IF
ELSEIF stat.curitemtype <> -1 THEN
 RANDOMIZE TIMER
 decider = INT(RND * 32)
 IF decider = 31 THEN stat.curitemtype = RND * 4 - 1: stat.flashframe = 0
 
END IF

END SUB

DEFSNG A-Z
SUB Initlib
code$ = "1E5589E58B460E8ED88B760C8B460A8EC08B7E08B9007DF3A55D1FCA0800"
DEF SEG = VARSEG(code1%(0))
FOR i% = 0 TO 29
 d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
 POKE VARPTR(code1%(0)) + i%, d%
NEXT i%

DEF SEG
code$ = "1E5589E58B460C508B460A508B46108ED88B760E8B04B103D3E8508B5EFE"
code$ = code$ + "01C3895EFE8B4402508B5EFC01C3895EFC83C60489760E89E58B46188ED8"
code$ = code$ + "8B76168A04468976163A461074208B5E1C8EDB8B7612B106D3E689F3B102"
code$ = code$ + "D3E601DE8B5E1401DE8B5E1A01DE88048B4614408946148B460639461475"
code$ = code$ + "BE8B46142B46028946148B4612408946128B460439461275A6585858585D"
code$ = code$ + "1FCA0E00"

DEF SEG = VARSEG(code3%(0))
  FOR i% = 0 TO 153
    d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
    POKE VARPTR(code3%(0)) + i%, d%
  NEXT i%
DEF SEG

  code$ = "1E5589E58B460A508B4608508B460A2B460E40508B46082B460C40508B46128ED8"
  code$ = code$ + "8B76108B46FABB0800F7E3890446468B46F88904464689761089E58B5E"
  code$ = code$ + "1E8EDB8B7614B106D3E689F3B102D3E601DE8B5E1601DE8B5E1C01DE8A"
  code$ = code$ + "048B5E1A8EDB8B76188804468976188B4616408946168B460639461676"
  code$ = code$ + "C38B46162B46028946168B4614408946148B460439461476AB58585858"
  code$ = code$ + "5D1FCA1000"
DEF SEG = VARSEG(code4%(0))
FOR i% = 0 TO 153
    d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
    POKE VARPTR(code4%(0)) + i%, d%
  NEXT i%
DEF SEG
'
END SUB

DEFINT A-Z
SUB loadgame (level$)
OPEN level$ FOR BINARY AS 1

GET #1, , stat.score
GET #1, , stattail
GET #1, , stat.curball
GET #1, , stat.wormdead
GET #1, , stat.tailsw
GET #1, , stat.curlevel
GET #1, , stat.levnum

FOR i = 0 TO 50
 GET #1, , player(i).x
 GET #1, , player(i).y
 GET #1, , player(i).dir
NEXT

FOR i = 0 TO 14
 GET #1, , enemy(i).x
 GET #1, , enemy(i).y
 GET #1, , enemy(i).frame
 GET #1, , enemy(i).dir
 GET #1, , enemy(i).entype
NEXT i

FOR i = 0 TO 9
 GET #1, , ballx(i).x
 GET #1, , ballx(i).y
 GET #1, , ballx(i).dir
NEXT


CLOSE 1
END SUB

SUB makepal (att, r, g, B)
OUT &H3C8, att
OUT &H3C9, r
OUT &H3C9, g
OUT &H3C9, B
END SUB

DEFSNG A-Z
SUB mapems (Handle%, pageoffset%)

numpages% = 4

DEF SEG = VARSEG(xasm)
   CALL ABSOLUTE(BYVAL pageoffset%, BYVAL Handle%, BYVAL numpages%, SADD(xasm))
DEF SEG
                                                                               
END SUB

DEFINT A-Z
SUB memcopy (fromseg, fromoff, toseg, tooff, bytes)


DEF SEG = VARSEG(masm)
   CALL ABSOLUTE(BYVAL fromseg, BYVAL tooff, BYVAL toseg, BYVAL fromoff, BYVAL bytes, SADD(masm))
DEF SEG


END SUB

FUNCTION menu (numops, ch1 AS STRING, ch2 AS STRING, ch3 AS STRING, ch4 AS STRING, ch5 AS STRING, beginchoice)

FOR i = 0 TO 5
 wiggle(i).dir = 12 - i * 2: IF wiggle(i).dir <= 4 THEN wiggle(i).dir = 12 - wiggle(i).dir
 wiggle(i + 6).dir = -1
NEXT i

wiggle(0).x = 0: wiggle(0).y = 10: wiggle(0).Segment = VARSEG(me(0)): wiggle(0).address = VARPTR(me(0))
wiggle(1).x = 70: wiggle(1).y = 21: wiggle(1).Segment = VARSEG(me(4564)): wiggle(1).address = VARPTR(me(4564))
wiggle(2).x = 112: wiggle(2).y = 22: wiggle(2).Segment = VARSEG(me(6543)): wiggle(2).address = VARPTR(me(6543))
wiggle(3).x = 137: wiggle(3).y = 20: wiggle(3).Segment = VARSEG(me(7548)): wiggle(3).address = VARPTR(me(7548))
wiggle(4).x = 181: wiggle(4).y = 24: wiggle(4).Segment = VARSEG(me(9401)): wiggle(4).address = VARPTR(me(9401))
wiggle(5).x = 209: wiggle(5).y = 22: wiggle(5).Segment = VARSEG(me(6543)): wiggle(5).address = VARPTR(me(6543))

choice = beginchoice

DO UNTIL null$ = "": null$ = INKEY$: LOOP

DO UNTIL null$ = CHR$(13)

memcopy emssegment1%, 0, VARSEG(offscr(0)), 0, &HFA00

wigglenow 5, VARSEG(offscr(0))

'blastput VARSEG(offscr(0)), 0, VARSEG(me(0)), VARPTR(me(0)), 0, 10 + tbl(player(0).dir).sinx * 4, 0
'blastput VARSEG(offscr(0)), 0, VARSEG(me(4564)), VARPTR(me(4564)), 70, 21 + tbl(wiggle(1).dir).sinx * 4, 0
'blastput VARSEG(offscr(0)), 0, VARSEG(me(6543)), VARPTR(me(6543)), 112, 22 + tbl(wiggle(2).dir).sinx * 4, 0
'blastput VARSEG(offscr(0)), 0, VARSEG(me(7548)), VARPTR(me(7548)), 137, 20 + tbl(wiggle(3).dir).sinx * 4, 0
'blastput VARSEG(offscr(0)), 0, VARSEG(me(9401)), VARPTR(me(9401)), 181, 24 + tbl(wiggle(4).dir).sinx * 4, 0
'blastput VARSEG(offscr(0)), 0, VARSEG(me(6543)), VARPTR(me(6543)), 209, 22 + tbl(wiggle(5).dir).sinx * 4, 0

FOR i = 0 TO numops - 1
 SELECT CASE i
  CASE 0: fttext$ = ch1
  CASE 1: fttext$ = ch2
  CASE 2: fttext$ = ch3
  CASE 3: fttext$ = ch4
  CASE 4: fttext$ = ch5
 END SELECT

 IF choice = i THEN Font1 55 + tbl(wiggle(0).dir).sinx * 4, 70 + i * 25, fttext$, 0, 0 ELSE Font1 55, 70 + i * 25, fttext$, 0, 0

NEXT i

mapems emshandle1%, 4
Blastput VARSEG(offscr(0)), 0, emssegment1%, 0, 35, choice * 25 + 70, 0
mapems emshandle1%, 0

keybd2 = INP(&H60)
null$ = INKEY$
IF null$ <> "" THEN keybd = keybd2 ELSE keybd = 0

IF keybd = 72 OR keybd = 80 THEN
 choice = (choice + (keybd - 76) / 4) MOD numops
 IF choice = -1 THEN choice = numops - 1
END IF

memcopy VARSEG(offscr(0)), 0, &HA000, 0, &HFA00

FOR a& = 0 TO delaybit * .64: NEXT a&
LOOP
'
menu = choice
END FUNCTION

DEFSNG A-Z
FUNCTION NumEMSHandles%

asm$ = ""
asm$ = asm$ + CHR$(85) + CHR$(137) + CHR$(229) + CHR$(180)
asm$ = asm$ + CHR$(75) + CHR$(205) + CHR$(103) + CHR$(139) + CHR$(126)
asm$ = asm$ + CHR$(6) + CHR$(137) + CHR$(29) + CHR$(93) + CHR$(203)

NumHandles% = 0
DEF SEG = VARSEG(asm$)
   CALL ABSOLUTE(NumHandles%, SADD(asm$))
DEF SEG

NumEMSHandles% = NumHandles%

END FUNCTION

FUNCTION NumEMSPages% (Handle%)

asm$ = ""
asm$ = asm$ + CHR$(85) + CHR$(137) + CHR$(229) + CHR$(139)
asm$ = asm$ + CHR$(86) + CHR$(6) + CHR$(180) + CHR$(76) + CHR$(205)
asm$ = asm$ + CHR$(103) + CHR$(139) + CHR$(126) + CHR$(8) + CHR$(137)
asm$ = asm$ + CHR$(29) + CHR$(93) + CHR$(203)

DEF SEG = VARSEG(asm$)
   CALL ABSOLUTE(numpages%, Handle%, SADD(asm$))
DEF SEG

NumEMSPages% = numpages%

END FUNCTION

FUNCTION PageFrame%

asm$ = ""
asm$ = asm$ + CHR$(85) + CHR$(137) + CHR$(229) + CHR$(180)
asm$ = asm$ + CHR$(65) + CHR$(205) + CHR$(103) + CHR$(139) + CHR$(126)
asm$ = asm$ + CHR$(6) + CHR$(137) + CHR$(29) + CHR$(93) + CHR$(203)

PageFrameAddr% = 0
DEF SEG = VARSEG(asm$)
   CALL ABSOLUTE(PageFrameAddr%, SADD(asm$))
DEF SEG

PageFrame% = PageFrameAddr%

END FUNCTION

DEFINT A-Z
FUNCTION pause (numops, item1 AS STRING, item2 AS STRING, item3 AS STRING, item4 AS STRING, message AS STRING)

FOR a& = 0 TO delaybit: NEXT a&
DO UNTIL INKEY$ = "": LOOP
makepal 1, 0, 0, 0

LINE (73, 53)-(246, 133), 1, B
LINE (74, 54)-(245, 132), 15, BF

Font1 124, 55, message, 1, 1

IF numops >= 1 THEN Font1 124, 75, item1, 1, 1
IF numops >= 2 THEN Font1 124, 87, item2, 1, 1
IF numops >= 3 THEN Font1 124, 99, item3, 1, 1
IF numops = 4 THEN Font1 124, 111, item4, 1, 1

mapems emshandle1%, 4
choice = 0
Blastput &HA000, 0, emssegment1%, 4 * 404, 100, choice * 12 + 70, 0

DO UNTIL keybd = 28
FOR a& = 0 TO delaybit: NEXT a&

IF keybd = 72 THEN
 LINE (100, choice * 12 + 70)-(119, choice * 12 + 90), 0, BF
 choice = choice - 1: IF choice = -1 THEN choice = numops - 1
 Blastput &HA000, 0, emssegment1%, (choice + 4) * 404, 100, choice * 12 + 70, 0
ELSEIF keybd = 80 THEN
 LINE (100, choice * 12 + 70)-(119, choice * 12 + 90), 0, BF
 choice = choice + 1: IF choice = numops THEN choice = 0
 Blastput &HA000, 0, emssegment1%, (choice + 4) * 404, 100, choice * 12 + 70, 0
END IF

keybd = INP(&H60)
null$ = INKEY$
LOOP

pause = choice

mapems emshandle1%, 0
END FUNCTION

FUNCTION playlevel (level$, levnum, savegame$)
stat.curlevel = level$
stat.levnum = levnum
stat.frameset = 0


DEF SEG = &HA000
BLOAD "prep.gfx", 0
OUT &H3C8, 0

FOR i = 0 TO 768
 OUT &H3C9, PEEK(i + 64000)
NEXT i

mapems emshandle1%, 4
Blastput &HA000, 0, emssegment1%, 36970 + (1220 * ((levnum + 9) MOD 10)), 142, 80, 0

text1$ = "GETREADY"
32
FOR tb = 1 TO 8
 wiggle(tb - 1).Segment = emssegment1%
 wiggle(tb - 1).address = 8889 + (ASC(MID$(text1$, tb, 1)) - 65) * 676
 wiggle(tb - 1).y = 90
 wiggle(tb - 1).dir = tb
NEXT tb
mapems emshandle1%, 0

memcopy &HA000, 0, emssegment1%, 0, &HFA00

wiggle(0).x = 39
wiggle(1).x = 59
wiggle(2).x = 75

wiggle(3).x = 210
wiggle(4).x = 226
wiggle(5).x = 242
wiggle(6).x = 263
wiggle(7).x = 283

DO UNTIL keybd = 0: keybd = INP(&H60): LOOP

DO UNTIL INKEY$ <> ""
memcopy emssegment1%, 0, VARSEG(offscr(0)), 0, &HFA00
mapems emshandle1%, 4
wigglenow 7, VARSEG(offscr(0))
mapems emshandle1%, 0
memcopy VARSEG(offscr(0)), 0, &HA000, 0, &HFA00
FOR a& = 0 TO delaybit * .64: NEXT a&
LOOP


OPEN stat.curlevel FOR BINARY AS 1
 GET #1, , tag
 IF tag <> "*wrm*" THEN END

 FOR x = 0 TO 15
  FOR y = 0 TO 9
   GET #1, , byte
   map(x, y) = ASC(byte)
  NEXT y
 NEXT x

 FOR i = 0 TO 14
  GET #1, , byte
  enemy(i).entype = ASC(byte)
  GET #1, , byte
  enemy(i).dir = ASC(byte)
  GET #1, , byte
  enemy(i).x = ASC(byte) * 20
  GET #1, , byte
  enemy(i).y = ASC(byte) * 20

  IF enemy(i).entype = 1 THEN
   enemy(i).dir = enemy(i).dir * 4
  ELSEIF enemy(i).entype = 2 THEN
   enemy(i).dir = enemy(i).dir * 4 + 2
  ELSEIF enemy(i).entype = 3 THEN
   enemy(i).dir = enemy(i).dir * 4 + 6
  END IF

 NEXT i
CLOSE 1


RANDOMIZE TIMER
FOR i = 0 TO 9
  RANDOMIZE TIMER
1 ballx(i).x = (RND * 16) MOD 16
  ballx(i).y = (RND * 10) MOD 10
  ballx(i).dir = 4
  IF map(ballx(i).x, ballx(i).y) <> 20 THEN GOTO 1

  FOR a = 0 TO 14
   IF ballx(i).x = enemy(a).x / 20 AND ballx(i).y = enemy(a).y / 20 THEN GOTO 1
  NEXT a
NEXT i
                                    
DEF SEG = VARSEG(me(0))
BLOAD "wormer.bsv", VARPTR(me(0))

FOR x = 0 TO 15
 FOR y = 0 TO 9
  Blastput VARSEG(offscr(0)), 0, VARSEG(me(0)), VARPTR(me(map(x, y) * 404)), x * 20, y * 20, 0
 NEXT y
NEXT x
   
memcopy VARSEG(offscr(0)), 0, emssegment1%, 0, &HFA00
memcopy VARSEG(offscr(0)), 0, &HA000, 0, &HFA00

CLS

FOR x = 39 TO 32 STEP -1
 makepal x, x - 32, (x - 32) * 8, x - 32
NEXT x

makepal 8, 0, 0, 0
FOR i = 16 TO 24: makepal i, 0, 0, 0: NEXT i
makepal 16, 0, 40, 0
makepal 40, 0, 0, 32
makepal 41, 0, 0, 63
makepal 42, 0, 0, 16

makepal 43, 0, 0, 32: waterpal(1) = 32
makepal 44, 0, 0, 32: waterpal(2) = 32
makepal 45, 0, 0, 63: waterpal(3) = 63
makepal 46, 0, 0, 63: waterpal(4) = 63

makepal 47, 0, 0, 0
makepal 48, 0, 40, 0

makepal 49, 0, 0, 0
makepal 50, 0, 15, 63
makepal 51, 0, 0, 45
makepal 52, 63, 63, 63

makepal 53, 0, 0, 0
makepal 54, 15, 15, 15
makepal 55, 45, 45, 45
makepal 56, 63, 63, 63
makepal 57, 0, 0, 32
makepal 58, 0, 0, 63
makepal 59, 40, 0, 0
makepal 60, 63, 0, 0
makepal 61, 30, 30, 30
makepal 62, 63, 63, 63
makepal 63, 0, 0, 0
makepal 64, 63, 63, 63
makepal 65, 63, 63, 40

stat.tail = 5
FOR i = 0 TO 5
 player(i).x = 160 - i * 5
 player(i).y = 140
 player(i).dir = 0
NEXT i

FOR i = 6 TO 25
 player(i).dir = -1
NEXT i

stat.wormdead = false
stat.curball = 0
stat.curitemtype = -1
stat.flashframe = -1

IF savegame$ <> "NEW" THEN loadgame (savegame$)

DEF SEG = VARSEG(me(0))
BLOAD "wormguts.gfx", VARPTR(me(0))

joe! = TIMER

stat.timeset = TIMER

DO
frames& = frames& + 1

FOR a& = 0 TO delaybit: NEXT a&
handlebdguy
handleplayer
drawscreen

IF stat.wormdead = true OR stat.wormdead = 1 THEN GOTO 484
stat.frameset = stat.frameset + 1
IF stat.timeset <> TIMER THEN stat.fps = stat.frameset / (TIMER - stat.timeset)

LOOP

484

IF stat.wormdead = 1 THEN msgfile$ = "endmsg2.gfx": playlevel = 1 ELSE msgfile$ = "endmsg1.gfx": playlevel = 0

FOR a& = 0 TO delaybit: NEXT a&

DO UNTIL stat.tail = 5
 stat.tail = stat.tail - 1
 FOR a& = 0 TO delaybit: NEXT a&
 drawscreen
 stat.score = stat.score + 20
 

LOOP

Fade2Black 14, 32

makepal 4, 0, 63, 0
makepal 1, 0, 63, 0
makepal 2, 0, 40, 0
DEF SEG = VARSEG(me(0))
BLOAD msgfile$, 0
Blastput &HA000, 0, VARSEG(me(0)), 0, 39, 77, 0
SLEEP
Fade2Black 14, 0

null$ = INKEY$
DO UNTIL null$ = "": null$ = INKEY$: LOOP

END FUNCTION

SUB playwav (wavefile$, watp%)
IF soundbit = 1 THEN
mapems emshandle1%, 0

repeats% = 1
tmp% = 0
blast$ = UCASE$(ENVIRON$("BLASTER"))
IF LEN(blast$) THEN
tmp% = INSTR(blast$, "A")
tmp1$ = MID$(blast$, tmp% + 1, 3)
tmp% = VAL("&H" + tmp1$)
IF tmp% = 203 THEN tmp% = -1
IF tmp% > 0 THEN
tmp2% = INSTR(blast$, "D")
dma% = VAL(MID$(blast$, tmp2% + 1))
IF dma% < 0 OR dma% > 7 THEN tmp% = -2
END IF
END IF
BlasterAddr% = tmp%
sp% = INSTR(Spec$, " ")
IF sp% THEN
wavefile$ = LEFT$(Spec$, sp% - 1)
repeats% = VAL(RIGHT$(Spec$, LEN(Spec$) - sp%))
IF repeats% = 0 THEN repeats% = 1
ELSE

IF LEN(Spec$) THEN
wavefile$ = Spec$
repeats% = 1
END IF
END IF
IF LEN(wavefile$) = 0 THEN
END IF
rID$ = SPACE$(4)
wID$ = SPACE$(4)
fID$ = SPACE$(4)
dat$ = SPACE$(4)
dummy$ = SPACE$(1)
filenum% = FREEFILE
OPEN wavefile$ FOR BINARY AS filenum%
watp% = LOF(filenum%)
GET filenum%, , rID$
GET filenum%, , rLen&
GET filenum%, , wID$
GET filenum%, , fID$
GET filenum%, , fLen&
GET filenum%, , wFormatTag%
GET filenum%, , Channels%
GET filenum%, , Sampling&
GET filenum%, , bytes&
GET filenum%, , nBlockAlign%
GET filenum%, , FormatSpecific%
FOR i% = 1 TO fLen& - 16
GET filenum%, , dummy$
NEXT i%
GET filenum%, , dat$
IF UCASE$(dat$) = "FACT" THEN
GET filenum%, , dummy&
GET filenum%, , dummy&
GET filenum%, , dat$
END IF
GET filenum%, , WavLen&
LenHeader% = LOC(1)
CLOSE filenum%
IF UCASE$(rID$) = "RIFF" THEN
IF UCASE$(wID$) = "WAVE" THEN
IF UCASE$(dat$) = "DATA" THEN
IF UCASE$(fID$) = "FMT " THEN
IF FormatSpecific% = 8 THEN ok% = -1
END IF
END IF
END IF
END IF
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, &HD1'Speaker ON
filenum% = FREEFILE
OPEN wavefile$ FOR BINARY AS filenum%
Num% = 0
SEEK filenum%, LenHeader% + 1
Remaining& = WavLen&
Num% = Num% + 1

IF Remaining& > watp% THEN
BufferLen% = watp%
ELSE
BufferLen% = Remaining&
END IF
Remaining& = Remaining& - BufferLen%
buffer$ = SPACE$(BufferLen%)
GET filenum%, , buffer$
BufferLen% = BufferLen% - 1
Segment& = VARSEG(buffer$)
Offset& = SADD(buffer$)
IF Segment& < 0 THEN Segment& = Segment& + 65536
IF Offset& < 0 THEN Offset& = Offset& + 65536
baseaddr& = Segment& * 16 + Offset&
look1% = VARPTR(baseaddr&)
look2% = VARPTR(BufferLen%)
SELECT CASE dma%
CASE 0: dmapage% = &H87: dmaaddr% = 0: dmalen% = 1
CASE 1: dmapage% = &H83: dmaaddr% = 2: dmalen% = 3
CASE 2: dmapage% = &H81: dmaaddr% = 4: dmalen% = 5
CASE 3: dmapage% = &H82: dmaaddr% = 6: dmalen% = 7
CASE 4: dmapage% = &H8F: dmaaddr% = &HC0: dmalen% = &HC2
CASE 5: dmapage% = &H8B: dmaaddr% = &HC4: dmalen% = &HC6
CASE 6: dmapage% = &H89: dmaaddr% = &HC8: dmalen% = &HCA
CASE 7: dmapage% = &H8A: dmaaddr% = &HCC: dmalen% = &HCE
END SELECT
SELECT CASE dma%
CASE 0 TO 3: dmamask% = &HA: dmamode% = &HB: dmaclear% = &HC: dmastatus% = &H8
CASE 4 TO 7: dmamask% = &HD4: dmamode% = &HD6: dmaclear% = &HD8: dmastatus% = &HD0
END SELECT
SELECT CASE dma%
CASE 0, 4: dmaterminal% = 1
CASE 1, 5: dmaterminal% = 2
CASE 2, 6: dmaterminal% = 4
CASE 3, 7: dmaterminal% = 8
END SELECT
OUT dmamask%, dma% + 4
OUT dmaclear%, &H0
OUT dmamode%, 72 + dma%
OUT dmaaddr%, PEEK(look1%)
OUT dmaaddr%, PEEK(look1% + 1)
OUT dmapage%, PEEK(look1% + 2)
OUT dmalen%, PEEK(look2%)
OUT dmalen%, PEEK(look2% + 1)
OUT dmamask%, dma%
IF Num% = 1 THEN
timeconst% = 256 - 1000000 / (Sampling& * Channels%)
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, &H40
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, timeconst%
OUT BlasterAddr% + &H4, &H0
OUT BlasterAddr% + &H4 + 1, 0
OUT BlasterAddr% + &H4, &H22
OUT BlasterAddr% + &H4 + 1, 255
IF Channels% = 2 THEN
OUT BlasterAddr% + &H4, &HE
OUT BlasterAddr% + &H4 + 1, 34
END IF
END IF
IF bytes& > 22000 THEN
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, &H48
ELSE
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, &H14
END IF
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, PEEK(look2%)
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, PEEK(look2% + 1)

IF bytes& > 22000 THEN
DO: LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, &H91
END IF

dummy% = INP(dmastatus%)
dummy% = INP(BlasterAddr% + &HE)
OUT &H20, &H20
CLOSE filenum%
END IF

END SUB

DEFSNG A-Z
SUB releaseems (Handle%)

asm$ = ""
asm$ = asm$ + CHR$(85) + CHR$(137) + CHR$(229) + CHR$(180)
asm$ = asm$ + CHR$(69) + CHR$(139) + CHR$(86) + CHR$(6) + CHR$(205)
asm$ = asm$ + CHR$(103) + CHR$(93) + CHR$(203)

DEF SEG = VARSEG(asm$)
   CALL ABSOLUTE(BYVAL Handle%, SADD(asm$))
DEF SEG

END SUB

DEFINT A-Z
SUB startup
OUT &H3C8, 0

FOR a = 0 TO 767
 OUT &H3C9, 0
NEXT a

DEF SEG = &HA000
BLOAD "stagescr.gfx", 0

OUT &H3C8, 0

FOR a = 0 TO 767
 OUT &H3C9, PEEK(a + 64000)
NEXT a

LINE (177, 8)-(311, 192), 0, B

FOR y = 8 TO 192 STEP 2
 LINE (177, y)-(311, y), 0, , &HAAAA
 LINE (177, y + 1)-(311, y + 1), 0, , &H5555
NEXT y

makepal 16, 63, 0, 0

Font1 179, 10, "WORMER WAS", 1, &HA000
Font1 179, 20, "ALWAYS A BIT", 1, &HA000
Font1 179, 30, "INFERIOR TO HIS", 1, &HA000
Font1 179, 40, "BROTHERS SNAKE", 1, &HA000
Font1 179, 50, "AND NIBBLES", 1, &HA000
Font1 179, 70, "BUT IN THE", 1, &HA000
Font1 179, 80, "WORLD OF VIDEO", 1, &HA000
Font1 179, 90, "GAME SNAKES", 1, &HA000
Font1 179, 100, "THERE ARE 81", 1, &HA000
Font1 179, 110, "ORBS OF GEM", 1, &HA000
Font1 179, 120, "THAT NO ONE ", 1, &HA000
Font1 179, 130, "HAS EVER FOUND", 1, &HA000
Font1 179, 150, "SO NOW WORMER", 1, &HA000
Font1 179, 160, "MUST PROVE HIS", 1, &HA000
Font1 179, 170, "MANHOOD", 1, &HA000
SLEEP
END SUB

SUB wigglenow (numwig, outadd)

FOR i = 0 TO numwig
 wiggle(i).dir = (wiggle(i).dir + 1) MOD 16
 Blastput VARSEG(offscr(0)), 0, wiggle(i).Segment, wiggle(i).address, wiggle(i).x, wiggle(i).y + tbl(wiggle(i).dir).sinx * 4, 0
NEXT i

END SUB

