DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'XGMAE.BI'

REM $STATIC
SUB CloseSocket (Socket%)
   InReg.BX = 1
   InReg.AX = 0
   InReg.DX = Socket
   CALL InterruptX(&H7A, InReg, OutReg)
END SUB

FUNCTION HexToBinary$ (Variable$)
   IF Variable$ = "" THEN
      HexToBinary$ = ""
   ELSE
      a = LEN(Variable$) MOD 2
      IF a = 1 THEN
         HexToBinary$ = ""
      ELSE
         Temp$ = ""
         FOR a = 1 TO LEN(Variable$) STEP 2
            Temp! = VAL("&H" + MID$(Variable$, a, 2))
            Temp$ = Temp$ + CHR$(Temp!)
         NEXT
         HexToBinary$ = Temp$
      END IF
   END IF
END FUNCTION

SUB IPXCancelR (CompleteCode%)
   InReg.BX = 6
   InReg.ES = VARSEG(ECBR)
   InReg.SI = VARPTR(ECBR)
   CALL InterruptX(&H7A, InReg, OutReg)
   CompleteCode = SplitWordLo%(OutReg.AX)
   '
   '                    FC = was canceled
END SUB

SUB IPXCancelS (CompleteCode%)
   InReg.BX = 6
   InReg.ES = VARSEG(ECBS)
   InReg.SI = VARPTR(ECBS)
   CALL InterruptX(&H7A, InReg, OutReg)
   CompleteCode = SplitWordLo%(OutReg.AX)
   '
   '                    FC = was canceled
END SUB

SUB IPXDisconnect (DNet$, DNode$, DSock$)
   Disconnect.NetWork = DNet$
   Disconnect.Node = DNode$
   Disconnect.Socket = DSock$
   InReg.BX = &HB
   InReg.ES = VARSEG(Disconnect)
   InReg.SI = VARPTR(Disconnect)
   CALL InterruptX(&H7A, InReg, OutReg)
END SUB

FUNCTION IPXInstalled%
   InReg.AX = &H7A00
   CALL InterruptX(&H2F, InReg, OutReg)
   AL = SplitWordLo(OutReg.AX)
   IF AL = &HFF THEN IPXInstalled = 1 ELSE IPXInstalled = 0
END FUNCTION

SUB OpenSocket (Socket%, Status%, SocketNumberReturned%)
   InReg.BX = 0
   InReg.AX = 0
   InReg.DX = Socket
   CALL InterruptX(&H7A, InReg, OutReg)
   Status = SplitWordLo(OutReg.AX)
   SocketNumberReturned = OutReg.DX
   '
   '           Completion status
   '                    00 successful
   '                    FF open already
   '                    FE socket table is full
END SUB

SUB RelenquishControl
   DEFINT A-Z
   InReg.AX = 0
   InReg.BX = &HA
   CALL InterruptX(&H7A, InReg, OutReg)
END SUB

SUB SendPacket (CompleteCode%, InUseFlag%)
   InReg.BX = 3
   InReg.ES = VARSEG(ECBS)
   InReg.SI = VARPTR(ECBS)
   CALL InterruptX(&H7A, InReg, OutReg)
   CompleteCode = ASC(ECBS.CompCode)
   InUseFlag = ASC(ECBS.InUse)
   '
   '        Error codes:
   '              00    sent
   '              FC    canceled
   '              FD    malformed packet
   '              FE    no listener (undelivered)
   '              FF    hardware failure
END SUB

SUB SocketListen
   InReg.BX = 4
   InReg.ES = VARSEG(ECBR)
   InReg.SI = VARPTR(ECBR)
   CALL InterruptX(&H7A, InReg, OutReg)
   CompleteCode = ASC(ECBR.CompCode)
   InUseFlag = ASC(ECBR.InUse)
   '
   '        Completion codes:
   '              00    received
   '              FC    canceled
   '              FD    packet overflow
   '              FF    socket was closed
   '              FE    Listening
END SUB

FUNCTION SplitWordHi (TheWord%)
   SplitWordHi = (TheWord% AND &HFF00) / 256
END FUNCTION

FUNCTION SplitWordLo (TheWord%)
   SplitWordLo = (TheWord% AND &HFF)
END FUNCTION

FUNCTION TurnToHex$ (Variable$)
   Temp$ = ""
   FOR Byte = 1 TO LEN(Variable$)
      Value! = ASC(MID$(Variable$, Byte, 1))
      IF Value! < 15 THEN
         Temp$ = Temp$ + "0" + HEX$(Value!)
      ELSE
         Temp$ = Temp$ + HEX$(Value!)
      END IF
   NEXT
   TurnToHex$ = Temp$
END FUNCTION

