DEFINT A-Z
'$DYNAMIC

DECLARE SUB BBoxF (X1%, Y1%, X2%, Y2%, c%)
DECLARE SUB BPset (X%, Y%, c%)

'$INCLUDE: 'XGMAE.BI'

Freemem& = FRE(-1) - 80000
a& = SETMEM(-Freemem&)

DIM basr AS STRING * 2350

CSInitText

CLS

R = CSLoadFont("XGmae.FNT", basr)

PRINT "Initalizing EMS Memory...";
LOAD.EmsSetup
PRINT "Done."

MUSIC.Init
MUSIC.Volume 50

PRINT "Loading Configuration...";
LOAD.LoadINI
PRINT "Done."

PRINT "Loading Graphics Files...";
LOAD.LoadModels
PRINT "Done."

MUSIC.LoadGDM "XGM01.GDM"

PRINT "Buidling Blender Map...";
LOAD.InitBMAP
PRINT "Done."

PRINT "Making Sine and Cosine tables...";
LOAD.SinCosTables
PRINT "Done."

PRINT "Setting up models and objects...";
LOAD.SetUpModels
PRINT "Done."

PRINT : PRINT "Hit any key to continue.."

WHILE INKEY$ <> "": WEND
WHILE INKEY$ = "": WEND

FOR i = 1 TO 64
 Delay .001
 FOR j = 0 TO 255
  CSGetCol j, R, b, G
  R = R - 1: b = b - 1: G = G - 1
  IF R < 0 THEN R = 0
  IF b < 0 THEN b = 0
  IF G < 0 THEN G = 0
  CSSetCol j, R, b, G
 NEXT j
NEXT i

CSInitVGA

LOAD.InitVideo

CSSetFont basr

FOR i = 1 TO MAXSTARS
 Stars(i).X = INT(RND * 320) + 1
 Stars(i).Y = INT(RND * 200) + 1
 Stars(i).AngOff = (INT(RND * 3) + 1)
 Stars(i).scale = (Stars(i).AngOff) / 3 / 8
 Stars(i).Colour = Stars(i).AngOff * (63 / 3) + 127
NEXT i

'MUSIC.Play

CSMapEMSLayer EMS.Handle, 0
CSSetClipBox 0, 0, 319, 199

CSInstallTimer

MENU.Main

CSRemoveTimer
CSInitText
CSDestroyBMap
CSDeallocateEMS EMS.Handle
MUSIC.DeInit

SCREEN 0: WIDTH 80

SUB BBoxF (X1, Y1, X2, Y2, c)
 IF X2 = X1 AND Y2 = Y1 THEN BPset X1, Y1, c: EXIT SUB
 FOR X = X1 TO X2
  FOR Y = Y1 TO Y2
   BPset X, Y, c
  NEXT Y
 NEXT X
END SUB

SUB BPset (X, Y, c)
 bc = CSPoint(EMS.Layer, X, Y)
 h1 = bc MOD 65
 h2 = c MOD 65
 IF h1 = 0 THEN
   c2 = c
  ELSE
   h = h1 + h2
   IF h > 62 THEN h = 62
   c2 = h + (FIX(c / 64) * 64)
 END IF
 CSPset EMS.Layer, X, Y, c2
END SUB

FUNCTION CSLoadWaveSound& (SoundFile$, BufferSeg%, BufferOff&)
  SoundFile$ = SoundFile$ + CHR$(0)
  CSLoadWaveSound& = xCSLoadWavSound(VARSEG(SoundFile$), SADD(SoundFile$), BufferSeg%, BufferOff&)
END FUNCTION

DEFSNG A-Z
SUB Delay (Time AS DOUBLE)
StartTime# = TIMER: DO: LOOP UNTIL TIMER - StartTime# >= Time
END SUB

DEFINT A-Z
SUB DoHighScores (KillEff#, WhatToDo)
DIM PlayerPlace AS SINGLE

 CSSetTimer 0, 25

 WhatToDo2 = WhatToDo
 F = FREEFILE
 OPEN "XGMAE.HSR" FOR INPUT AS #F
  FOR i = 1 TO 10
   INPUT #F, HighScores(i).pName
   INPUT #F, HighScores(i).KillEff
   INPUT #F, HighScores(i).Date
  NEXT i
 CLOSE #F

RestartHighScores:
 SELECT CASE WhatToDo2
  CASE DHS.ADD
   PlayerPlace = 0
   FOR i = 10 TO 1 STEP -1
    eff# = VAL(HighScores(i).KillEff)
    IF KillEff# >= eff# THEN
     PlayerPlace = i
    END IF
   NEXT i
   IF PlayerPlace THEN
    FOR i = 10 TO PlayerPlace STEP -1
     HighScores(i + 1) = HighScores(i)
    NEXT i
    HighScores(PlayerPlace).pName = "[Enter Name]"
    HighScores(PlayerPlace).Date = DATE$
    HighScores(PlayerPlace).KillEff = NumToStr$(KillEff#)
    temp$ = "[Enter Name]"
    WhatToDo2 = DHS.VIEW
    GOTO RestartHighScores
   END IF
  CASE DHS.VIEW
   st# = TIMER
   DO
    CSWaitTimer 0
    CSClear EMS.Layer, 0

    PRT.MoveAndDrawParticles
   
    IF TIMER - st# > .3 AND INT(RND * 30) = 10 THEN
     xr = RND * 320
     yr = RND * 200
     PRT.CircleExp xr, yr, 40, 2, 0
     st# = TIMER
    END IF

    DoStars
    
    TX.Locate 7
     TX.CPrint "         HighScoresĿ          "
     TX.CPrint "Ŀ"
     TX.CPrint "     Name       K-E    Date   "
     TX.CPrint "Ĵ"
    FOR i = 1 TO 10
     TX.CPrint "                                "
    NEXT i
     TX.CPrint ""
   
    k$ = ""
    FOR i = 1 TO 16
     G$ = INKEY$
     IF G$ <> "" AND TIMER - pauseK# > .1 THEN k$ = G$: pauseK# = TIMER
    NEXT i

    TX.Locate 11
    FOR i = 1 TO 10
     IF PlayerPlace = i THEN
      Text.Colour = 230
      SELECT CASE UCASE$(k$)
       CASE "A" TO "Z", "0" TO "9", "_", "-", "!", "@", "#", "$", "%", "^", "&", "*", "~", "\", "/", "|", "?", "[", "{", "]", "}", " "
        friq& = 44050: LoadPlayWav "XGW347.WAV"
        IF temp$ = "[Enter Name]" THEN temp$ = ""
        temp$ = temp$ + k$
        IF LEN(temp$) > 15 THEN temp$ = MID$(temp$, 1, 15)
       CASE CHR$(8)
        friq& = 44050: LoadPlayWav "XGMNS.WAV"
        IF temp$ = "[Enter Name]" THEN temp$ = ""
        IF LEN(temp$) > 1 THEN temp$ = MID$(temp$, 1, LEN(temp$) - 1) ELSE temp$ = ""
       CASE CHR$(13): k$ = "": PlayerPlace = 0: friq& = 22050: LoadPlayWav "XGMS.WAV"
      END SELECT
      HighScores(i).pName = temp$
     END IF
     posx = (20 - (LEN(HighScores(i).pName + "" + HighScores(i).KillEff + "" + HighScores(i).Date) / 2)) * 8
     CSPrint EMS.Layer, posx, Text.y, HighScores(i).pName, Text.Colour
     Text.Colour = 255
     posx = posx + 120
      CSPrint EMS.Layer, posx, Text.y, "" + HighScores(i).KillEff + "" + HighScores(i).Date, Text.Colour
     Text.y = Text.y + 8
    NEXT i

    IF k$ <> "" AND PlayerPlace = 0 THEN EXIT DO
   
    CSPCopy EMS.Layer, &HA000
   LOOP
   friq& = 22050: LoadPlayWav "XGMS.WAV"
 END SELECT

 F = FREEFILE
 OPEN "XGMAE.HSR" FOR OUTPUT AS #F
  FOR i = 1 TO 10
   PRINT #F, HighScores(i).pName
   PRINT #F, HighScores(i).KillEff
   PRINT #F, HighScores(i).Date
  NEXT i
 CLOSE #F
  
END SUB

SUB DoStars
 gOk = 0
 FOR i = 1 TO MAXSTARS
  IF Stars(i).X = 0 AND Stars(i).Y = 0 THEN
    Stars(i).AngOff = (INT(RND * 3) + 1)
    Stars(i).scale = (Stars(i).AngOff) / 3 / 8
    Stars(i).X = 1
    Stars(i).Y = INT(RND * 200) + 1 - (Stars(i).radius * Stars(i).scale)
    IF INT(Stars(i).Y) = 100 AND INT(RND * 100) = 50 THEN
      Stars(i).Colour = Stars(i).AngOff * (63 / 3) + 63
     ELSE
      IF INT(Stars(i).Y) = 100 THEN Stars(i).Y = 101
      Stars(i).Colour = Stars(i).AngOff * (63 / 3) + 127
    END IF
   ELSE
    OldX = Stars(i).X
    OldY = Stars(i).Y
    Stars(i).X = Stars(i).X + (Stars(i).AngOff * 2)
    Stars(i).Ang = Stars(i).Ang + 16
    newx = Stars(i).X
    newy = Stars(i).Y
    IF INT(Stars(i).Y) = 100 THEN c = GREEN: gOk = -1 ELSE c = BLUE
    IF Stars(i).AngOff = 3 THEN PRT.AddPart INT(OldX), INT(OldY - 1), 0, 0, 1, 4, 0, 0, c
    IF Stars(i).AngOff = 2 THEN PRT.AddPart INT(OldX), INT(OldY), 0, 0, 1, 4, -2, 0, c
    IF Stars(i).AngOff = 1 THEN PRT.AddPart INT(OldX), INT(OldY + 1), 0, 0, 0, 4, -2, 0, c
    O2D.Check Stars(i)
    O2D.Draw Stars(i)
    IF Stars(i).X > 320 THEN Stars(i).X = 0: Stars(i).Y = 0
  END IF
 NEXT i
END SUB

SUB FileLists (FList() AS STRING, NumFiles, ContainText AS STRING)
 
 F = FREEFILE
 OPEN "temptemp.tmp" FOR INPUT AS #F
  FOR d = 1 TO 5: INPUT #F, Text$: NEXT
  DO
   FileName$ = ""
   INPUT #F, Text$
   Eotf = INSTR(Text$, "file(s)") > 0
   IF Eotf THEN EXIT DO
   FOR i = 45 TO LEN(Text$)
    FileName$ = FileName$ + MID$(Text$, i, 1)
   NEXT i
   FileName$ = UCASE$(LTRIM$(RTRIM$(FileName$)))
   IF FileName$ <> "" THEN
    FilePass = 0
    F2 = FREEFILE
    OPEN FileName$ FOR INPUT AS #F2
     DO
      IF EOF(F2) THEN EXIT DO
      INPUT #F2, Text$
      IF INSTR(Text$, ContainText) THEN FilePass = -1
     LOOP UNTIL EOF(F2) OR FilePass
    CLOSE #F2
    IF FilePass THEN
     NumFiles = NumFiles + 1
     IF NumFiles > UBOUND(FList, 1) THEN NumFiles = NumFiles - 1: EXIT SUB
     FList(NumFiles) = FileName$
    END IF
   END IF
  LOOP UNTIL EOF(F)
 CLOSE #F
END SUB

FUNCTION FindAngle% (X1%, Y1%, X2%, Y2%)
 DIM Angle AS DOUBLE

 X = X2 - X1
 Y = Y2 - Y1

 IF X > 0 THEN
   Angle = ATN(Y / X)
  ELSEIF X < 0 THEN
   Angle = ATN(Y / X) + 3.14159265358979#
  ELSEIF X = 0 AND Y > 0 THEN
   Angle = 3.14159265358979# * .5
  ELSEIF X = 0 AND Y < 0 THEN
   Angle = 3.14159265358979# * 1.5
 END IF

 FindAngle% = Angle * (180 / PI)
END FUNCTION

SUB FireWeapon (WeaponSelect AS INTEGER)
 DIM temp AS Object2D
 temp = MyShip
 SELECT CASE WeaponSelect
  CASE 0
   PRJ.AddProjectile LLaser(), MyShip, LLaserTemplate, MAXLLASERS
  CASE 1
   PRJ.AddProjectile Missile(), MyShip, MissileTemplate, MAXMISSILES
  CASE 2
   PRJ.AddProjectile Mine(), MyShip, MineTemplate, MAXMINES
  CASE 3
   PRJ.AddProjectile CBomb(), MyShip, CBombTemplate, MAXCBOMBS
  CASE 4
   PRJ.AddProjectile Laser(), MyShip, LaserTemplate, MAXLASERS
  CASE 5
   PRJ.AddProjectile Beam(), MyShip, BeamTemplate, MAXBEAMS
  CASE 6
   FOR i = -5 + 360 TO 5 + 360 STEP 5
    temp.Ang = ((MyShip.Ang + i) MOD 360)
    PRJ.AddProjectile Mini(), temp, MiniTemplate, MAXMINIS
   NEXT i
  CASE 7
   PRJ.AddProjectile Rml5K(), MyShip, Rml5KTemplate, MAXRML5K
 END SELECT

 MakeWeaponSound WeaponSelect
END SUB

SUB GetInput (Index, Up, Left, Down, Right, Brake, Shoot, Quit)
 Up = 0: Down = 0: Right = 0: Left = 0: Brake = 0: Shoot = 0
 IF MIPX.TCP.MODEM = MPLAY.SAMECOMP THEN
   IF XKey(MPlayerC(Index).Left) THEN Left = -1
   IF XKey(MPlayerC(Index).Right) THEN Right = -1
   IF XKey(MPlayerC(Index).Up) THEN Up = -1
   IF XKey(MPlayerC(Index).Down) THEN Down = -1
   IF XKey(MPlayerC(Index).Brake) THEN Brake = -1
   IF XKey(MPlayerC(Index).Shoot) THEN Shoot = -1
   IF XKey(&H1) THEN Quit = -1: TX.CLS: TX.Print "Escape pressed."
  ELSE
   DIM temp AS INTEGER
   DIM SDataG AS STRING * 1
   DIM RDataG AS STRING * 1
   temp = 0
  SELECT CASE Control(Index)
   CASE CONTRL.HERE
    IF XKey(SPlayerC.Left) THEN Left = -1
    IF XKey(SPlayerC.Right) THEN Right = -1
    IF XKey(SPlayerC.Up) THEN Up = -1
    IF XKey(SPlayerC.Down) THEN Down = -1
    IF XKey(SPlayerC.Brake) THEN Brake = -1
    IF XKey(SPlayerC.Shoot) THEN Shoot = -1
    IF XKey(&H1) THEN Quit = -1
    IF Left AND Right THEN Left = 0: Right = 0
    IF Up AND Down THEN Up = 0: Down = 0
    IF Left THEN temp = temp OR 1
    IF Right THEN temp = temp OR 2
    IF Up THEN temp = temp OR 4
    IF Down THEN temp = temp OR 8
    IF Brake THEN temp = temp OR 16
    IF Shoot THEN temp = temp OR 64
    IF Quit THEN temp = 0: temp = temp OR 1: temp = temp OR 2: CLS
    SDataG = CHR$(temp)
    ' Send controls to be processed in other players CONTRL.THERE thingo
    lag# = TIMER
    SELECT CASE MIPX.TCP.MODEM
     CASE MPLAY.IPX     ' Send Control data via IPX/SPX
       SendInUseFlag = ASC(ECBS.InUse)
       IF SendInUseFlag = 0 THEN
        IF Quit THEN
         IPXS.Checksum = 0
         IPXS.Length = LEN(IPXS)
         IPXS.Control = CHR$(0)
         IPXS.PacketType = CHR$(0)
         IPXS.DestNet = DNet$
         IPXS.DestNode = DNode$
         IPXS.DestSocket = MKI$(Send)
         IPXS.SourSock = MKI$(1)
         IPXS.Datagram = CHR$(temp)
             
         ECBS.SockNum = Send
         ECBS.ImmAdd = DIAdd$
         ECBS.FragCount = 1
         ECBS.FragAddOfs = VARPTR(IPXS)
         ECBS.FragAddSeg = VARSEG(IPXS)
         ECBS.FragSize = LEN(IPXS)
         DO
          CALL SendPacket(CompleteCode, SendInUseFlag)
          SendInUseFlag = ASC(ECBS.InUse)
          DO
           CALL RelenquishControl
           SendInUseFlag = ASC(ECBS.InUse)
           IF TIMER - lag# > 3 THEN TX.CLS: TX.Print "Error, Aborting due to lag": Quit = -1: EXIT SUB
          LOOP WHILE SendInUseFlag = &HFF
         LOOP WHILE SendInUseFlag <> 0
         SendInUseFlag = ASC(ECBS.InUse)
        
         CALL IPXDisconnect(DNet$, DNode$, DSock$)
         TX.CLS
         TX.Print "Escape pressed."
         Quit = -1: EXIT SUB
        END IF
             
        IPXS.Checksum = 0
        IPXS.Length = LEN(IPXS)
        IPXS.Control = CHR$(0)
        IPXS.PacketType = CHR$(0)
        IPXS.DestNet = DNet$
        IPXS.DestNode = DNode$
        IPXS.DestSocket = MKI$(Send)
        IPXS.SourSock = MKI$(1)
        IPXS.Datagram = SDataG
             
        ECBS.SockNum = Send
        ECBS.ImmAdd = DIAdd$
        ECBS.FragCount = 1
        ECBS.FragAddOfs = VARPTR(IPXS)
        ECBS.FragAddSeg = VARSEG(IPXS)
        ECBS.FragSize = LEN(IPXS)
              
        DO
         CALL SendPacket(CompleteCode, SendInUseFlag)
         SendInUseFlag = ASC(ECBS.InUse)
         DO
          CALL RelenquishControl
          SendInUseFlag = ASC(ECBS.InUse)
         LOOP WHILE SendInUseFlag = &HFF
         SendInUseFlag = ASC(ECBS.InUse)
        LOOP WHILE SendInUseFlag <> 0
        CALL IPXCancelS(CompleteCode%)
       ELSE
        Up = 0: Down = 0: Right = 0: Left = 0: Brake = 0: Shoot = 0
      END IF
     CASE MPLAY.TCP
     CASE MPLAY.MODEM
    END SELECT
   CASE CONTRL.THERE
    ' Recive controls from other players CONTRL.HERE thingo
    lag# = TIMER
    SELECT CASE MIPX.TCP.MODEM
     CASE MPLAY.IPX
     
      okflag = 0
      DO
       ListenInUseFlag = ASC(ECBR.InUse)
       RDataG = IPXR.Datagram
       IF ListenInUseFlag = 0 THEN
        IF RDataG = CHR$(255) THEN
          Quit = -1
         ELSE
          G$ = RDataG
          okflag = -1
        END IF
       
        ECBR.SockNum = Listen
        ECBR.FragCount = 1
        ECBR.FragAddOfs = VARPTR(IPXR)
        ECBR.FragAddSeg = VARSEG(IPXR)
        ECBR.FragSize = LEN(IPXR)
        CALL SocketListen
       END IF
      IF TIMER - lag# > 3 THEN TX.CLS: TX.Print "Error, Aborting Due to lag.": Quit = -1: EXIT SUB
      LOOP UNTIL okflag
         
     CASE MPLAY.TCP
     CASE MPLAY.MODEM
    END SELECT
    ' Process information
    G$ = LTRIM$(RTRIM$(RDataG))
   
    DEF SEG = VARSEG(G$)
     temp = PEEK(SADD(G$)): DEF SEG
   
    'IF g$ = CHR$(0) THEN temp = 0 ELSE temp = ASC(g$)
    IF temp AND 1 THEN Left = -1
    IF temp AND 2 THEN Right = -1
    IF temp AND 4 THEN Up = -1
    IF temp AND 8 THEN Down = -1
    IF temp AND 16 THEN Brake = -1
    IF temp AND 64 THEN Shoot = -1
    IF (temp AND 1) AND (temp AND 2) THEN Quit = -1
    
  END SELECT
 END IF
END SUB

SUB HandleCBExp (cbm AS INTEGER, X%, Y%)
 c = 0
 FOR i = 1 TO 360 STEP 45
  CBomb(cbm).Object.Ang = i
  PRJ.AddProjectile CMiniBomb(), CBomb(cbm).Object, CMiniBombTemplate, MAXCMINIBOMBS
 NEXT i
END SUB

SUB HandleRML5K
 DIM temp AS Object2D
 FOR i = 1 TO MAXRML5K
  IF Rml5K(i).active THEN
   Rml5K(i).Object.Ang = ((Rml5K(i).Object.Ang + 1) MOD 360)
   IF INT(RND * 50) = 30 THEN
    temp = Rml5K(i).Object
    FOR a = 1 TO 360 STEP 90
     temp.Ang = ((Rml5K(i).Object.Ang + 55 + a) MOD 360)
     temp.AngOff = 90
     PRJ.AddProjectile Rml5KMini(), temp, Rml5KMiniTemplate, MAXRMLMINIS
    NEXT a
    friq& = 22020
    LoadPlayWav "XGW1.WAV"
   END IF
  END IF
 NEXT i
END SUB

DEFLNG A-Z
FUNCTION LineCollide% (Object AS Object2D, Object2 AS Object2D, Line1 AS tLine, Line2 AS tLine, Cx%, cy%)
DIM m1 AS INTEGER, m2 AS INTEGER
DIM X AS LONG, Y AS LONG
DIM X1 AS LONG, Y1 AS LONG, X2 AS LONG, Y2 AS LONG
DIM X3 AS LONG, Y3 AS LONG, x4 AS LONG, y4 AS LONG

X1 = (Line1.X1 * Object.scale) + Object.X: X2 = (Line1.X2 * Object.scale) + Object.X
Y1 = (Line1.Y1 * Object.scale) + Object.Y: Y2 = (Line1.Y2 * Object.scale) + Object.Y
X3 = (Line2.X1 * Object2.scale) + Object2.X: x4 = (Line2.X2 * Object2.scale) + Object2.X
Y3 = (Line2.Y1 * Object2.scale) + Object2.Y: y4 = (Line2.Y2 * Object2.scale) + Object2.Y

IF X1 = X2 THEN X1 = X1 - 1: X2 = X2 + 1 ' Do corrections for othagonal lines
IF Y1 = Y2 THEN Y1 = Y1 - 1: Y2 = Y2 + 1
IF X3 = x4 THEN X3 = X3 - 1: x4 = x4 + 1
IF Y3 = y4 THEN Y3 = Y3 - 1: y4 = y4 + 1

IF Y2 - Y1 <> 0 AND X2 - X1 <> 0 THEN m1 = ((Y2 - Y1)) / ((X2 - X1))
IF y4 - Y3 <> 0 AND x4 - X3 <> 0 THEN m2 = ((y4 - Y3)) / ((x4 - X3))

IF m1 - m2 = 0 THEN EXIT FUNCTION

X = (Y3 - m2 * X3 + m1 * X1 - Y1) / (m1 - m2)
Y = (X3 * m1 * m2 - Y3 * m1 + Y1 * m2 - X1 * m1 * m2) / (m2 - m1)

l1x1 = X1: l1x2 = X2: IF l1x1 > l1x2 THEN SWAP l1x1, l1x2
l2x1 = X3: l2x2 = x4: IF l2x1 > l2x2 THEN SWAP l2x1, l2x2
l1y1 = Y1: l1y2 = Y2: IF l1y1 > l1y2 THEN SWAP l1y1, l1y2
l2y1 = Y3: l2y2 = y4: IF l2y1 > l2y2 THEN SWAP l2y1, l2y2

IF X >= l1x1 AND X <= l1x2 AND Y >= l1y1 AND Y <= l1y2 AND X >= l2x1 AND X <= l2x2 AND Y >= l2y1 AND Y <= l2y2 THEN
  Cx% = X: cy% = Y
  LineCollide = -1
END IF

END FUNCTION

DEFINT A-Z
SUB LOAD.EmsSetup
 IF CSDetectEMS = 0 THEN
  PRINT "Sorry, the EMS manager is not running.": END
 END IF

 EMSPages = 8 + (MAXSOUNDS * 4)
 EMS.Handle = CSAllocateEMS(EMSPages)
 IF EMS.Handle = 0 THEN
  PRINT "Sorry, this programm requires atleast"; (EMSPages * 16); "kb of EMS memory.": END
 END IF

 EMS.Layer = CSGetEMSFrame

 CSMapEMSLayer EMS.Handle, 0
 CSClear EMS.Layer, 0
 CSMapEMSLayer EMS.Handle, 4
 CSClear EMS.Layer, 0

END SUB

SUB LOAD.InitBMAP
 IF CSCreateBMap THEN
  PRINT "Could not create blender-map."
  END
 END IF

 FOR F = 0 TO 3
  FOR i = 1 TO 64
   FOR j = 1 TO 64
    FOR b = 0 TO 3
     CSSetBMap i + (F * 63), j + (b * 63), (F * 63) + ((i + j) / 2)
    NEXT b
   NEXT j
  NEXT i
 NEXT F

END SUB

SUB LOAD.InitVideo

 FOR i = 1 TO 63
  CSSetCol i + 64, 0, i, 0
  CSSetCol i + 128, 0, 0, i
  CSSetCol i + 192, i, i, i
 NEXT i
 FOR i = 1 TO 32
  R = i * 2
  IF R > 63 THEN R = 63
  CSSetCol i, R, 0, 0
 NEXT i
 FOR i = 1 TO 16
  CSSetCol i + 32, 63, (i * 4), 0
  CSSetCol i + 32 + 16, 63, 63, (i * 4)
 NEXT i

 CSSetCol 254, 63, 63, 63
 CSSetCol 255, 63, 63, 63

END SUB

SUB LOAD.LoadINI
 F = FREEFILE
 OPEN "XGMAE.INF" FOR INPUT AS #F
  INPUT #F, MPlay.LevelName
  INPUT #F, SPlayerC.Left, SPlayerC.Right, SPlayerC.Up
  INPUT #F, SPlayerC.Down, SPlayerC.Brake, SPlayerC.Shoot
  FOR i = 1 TO 2
   INPUT #F, MPlayerC(i).Left, MPlayerC(i).Right, MPlayerC(i).Up
   INPUT #F, MPlayerC(i).Down, MPlayerC(i).Brake, MPlayerC(i).Shoot
  NEXT i
 CLOSE #F
END SUB

SUB LOAD.LoadModels

 dIs(1) = 1: dIs(2) = 2
 dIs(3) = 3: dIs(4) = 4
 dIs(5) = 5: dIs(6) = 6
 dIs(7) = 7: dIs(8) = 8
 dIs(9) = 9: dIs(10) = 10
 dIs(11) = 11: dIs(12) = 12
 dIs(13) = 16: dIs(14) = 14
 dIs(15) = 15: dIs(16) = 13
 dIs(17) = 17: dIs(18) = 18
 dIs(19) = 19: dIs(20) = 20
 dIs(21) = 21: dIs(22) = 22
 dIs(23) = 23: dIs(24) = 24
 dIs(25) = 25: dIs(26) = 26
 dIs(27) = 27: dIs(28) = 28

 LoadXSP "Ship.XSP", dIs(1)
 LoadXSP "Asteriod.XSP", dIs(2)
 LoadXSP "Missile.XSP", dIs(3)
 LoadXSP "Laser.XSP", dIs(4)
 LoadXSP "CBomb.XSP", dIs(5)
 LoadXSP "Beam.XSP", dIs(6)
 LoadXSP "Mini.XSP", dIs(7)
 LoadXSP "Rml5K.XSP", dIs(8)
 LoadXSP "Flag1.XSP", dIs(10)
 LoadXSP "Flag2.XSP", dIs(11)
 LoadXSP "Star4.XSP", dIs(12)
 LoadXSP "Ufo.XSP", dIs(13)
 LoadXSP "LLaser.XSP", dIs(14)
 LoadXSP "Turret.XSP", dIs(15)
 LoadXSP "Ufo2.XSP", dIs(16)
 LoadXSP "PWRupM.XSP", dIs(17)
 LoadXSP "PWRupN.XSP", dIs(18)
 LoadXSP "PWRupC.XSP", dIs(19)
 LoadXSP "PWRupH.XSP", dIs(20)
 LoadXSP "PWRupF.XSP", dIs(21)
 LoadXSP "PWRupMI.XSP", dIs(22)
 LoadXSP "PWRupR.XSP", dIs(23)
 LoadXSP "PWRupL.XSP", dIs(24)
 LoadXSP "Ufo3.XSP", dIs(25)
 LoadXSP "Boss1.XSP", dIs(26)
 LoadXSP "Debris.XSP", dIs(27)
 LoadXSP "Station.XSP", dIs(28)

END SUB

SUB LOAD.SetUpModels
MyShip.model = dIs(1)
O2D.GetRadius MyShip

Ufo.model = dIs(13)
O2D.GetRadius Ufo
Ufo.scale = .25
Ufo.speed = 4
Ufo.Colour = 120

Stars(1).model = dIs(12)
O2D.GetRadius Stars(1)
Stars(1).scale = .25

FOR i = 1 TO MAXSTARS
 Stars(i) = Stars(1)
NEXT i

Arena.model = dIs(9)
Arena.radius = 1000
Arena.scale = 1
Arena.X = 160
Arena.Y = 100
Arena.Colour = 250

Asteriods(1).model = dIs(2)
O2D.GetRadius Asteriods(1)

FOR i = 1 TO 2
 Flags(i).model = dIs(9 + i)
 Flags(i).scale = .25
 Flags(i).speed = 0
 O2D.GetRadius Flags(i)
NEXT i

Flags(1).Colour = 4
Flags(2).Colour = 12
MyShip.Colour = 255

MissileTemplate.Object.AngOff = 90
MissileTemplate.Object.model = dIs(3)
MissileTemplate.Object.scale = .5
MissileTemplate.Object.speed = 4
O2D.GetRadius MissileTemplate.Object
MissileTemplate.trail = 1
MissileTemplate.accelerate = .1
MissileTemplate.Si = 1
MissileTemplate.Object.Colour = 255
MissileTemplate.damage = 3

LaserTemplate.Object.AngOff = 90
LaserTemplate.Object.model = dIs(4)
LaserTemplate.Object.scale = .5
LaserTemplate.Object.speed = 9
O2D.GetRadius LaserTemplate.Object
LaserTemplate.Si = 2
LaserTemplate.Object.Colour = 160
LaserTemplate.damage = 0

CBombTemplate.Object.AngOff = 90
CBombTemplate.Object.model = dIs(5)
CBombTemplate.Object.scale = .2
CBombTemplate.Object.speed = 3
O2D.GetRadius CBombTemplate.Object
CBombTemplate.rotate = 6
CBombTemplate.Si = 1
CBombTemplate.Object.Colour = 240
CBombTemplate.damage = 10

CMiniBombTemplate.Object.AngOff = 90
CMiniBombTemplate = CBombTemplate
CMiniBombTemplate.Object.scale = .1
CMiniBombTemplate.Object.speed = 3
CMiniBombTemplate.Si = 4
CMiniBombTemplate.Object.Colour = 230
CMiniBombTemplate.damage = 3

BeamTemplate.Object.AngOff = 90
BeamTemplate.Object.model = dIs(6)
BeamTemplate.Object.scale = .5
BeamTemplate.Object.speed = 2
BeamTemplate.accelmult = -1
O2D.GetRadius BeamTemplate.Object
BeamTemplate.Si = 5
BeamTemplate.Object.Colour = 32
BeamTemplate.damage = 1

MineTemplate.Object.AngOff = 90
MineTemplate.Object.model = dIs(5)
MineTemplate.Object.scale = .1
MineTemplate.Object.speed = 0
MineTemplate.Object.radius = CBombTemplate.Object.radius
MineTemplate.rotate = 2
MineTemplate.depAng = 180
MineTemplate.Si = 3
MineTemplate.Object.Colour = 230
MineTemplate.damage = 3

MiniTemplate.Object.AngOff = 90
MiniTemplate.Object.model = dIs(7)
MiniTemplate.Object.scale = .5
MiniTemplate.Object.speed = 6
O2D.GetRadius MiniTemplate.Object
MiniTemplate.trail = -1
MiniTemplate.Si = 6
MiniTemplate.Object.Colour = 255
MiniTemplate.damage = 6

Rml5KMiniTemplate = MiniTemplate

Rml5KTemplate.Object.AngOff = 90
Rml5KTemplate.Object.model = dIs(8)
Rml5KTemplate.Object.scale = .2
Rml5KTemplate.Object.speed = 1
O2D.GetRadius Rml5KTemplate.Object
Rml5KTemplate.rotate = 10
Rml5KTemplate.Si = 7
Rml5KTemplate.Object.Colour = 90
Rml5KTemplate.damage = 10

LLaserTemplate.Object.AngOff = 90
LLaserTemplate.Object.model = dIs(14)
LLaserTemplate.Object.scale = .15
LLaserTemplate.Object.speed = 5
O2D.GetRadius LLaserTemplate.Object
LLaserTemplate.Si = 2
LLaserTemplate.Object.Colour = 20
LLaserTemplate.damage = 1
LLaserTemplate.trail = -2
LLaserTemplate.invisible = -1

' Setup for Enemy's //-----------------------------------------------//

EnemyTemplate(1).Object = Asteriods(1)   '   Large asteriod
EnemyTemplate(1).Object.scale = 1
EnemyTemplate(1).Object.Colour = 240
EnemyTemplate(1).mhp = 5: EnemyTemplate(1).hp = EnemyTemplate(1).mhp
EnemyTemplate(1).score = 10
EnemyTemplate(1).ai = 1

EnemyTemplate(2) = EnemyTemplate(1)      '   Small asteriod
EnemyTemplate(2).score = 5
EnemyTemplate(2).Object.scale = .5
EnemyTemplate(2).mhp = 3: EnemyTemplate(2).hp = EnemyTemplate(2).mhp

EnemyTemplate(3).score = 20              '   Green ship
EnemyTemplate(3).Object = Ufo
EnemyTemplate(3).mhp = 4: EnemyTemplate(3).hp = EnemyTemplate(3).mhp
EnemyTemplate(3).ai = 2
EnemyTemplate(3).trail = GREEN

EnemyTemplate(4).score = 40             '    Blaster Turret
EnemyTemplate(4).Object.model = dIs(15)
EnemyTemplate(4).Object.AngOff = 90
O2D.GetRadius EnemyTemplate(4).Object
EnemyTemplate(4).Object.Colour = 240
EnemyTemplate(4).Object.scale = .25
EnemyTemplate(4).mhp = 7: EnemyTemplate(4).hp = EnemyTemplate(4).mhp
EnemyTemplate(4).ai = 4
EnemyTemplate(4).trail = GREEN

EnemyTemplate(5).score = 20             '    Blue missile ship
EnemyTemplate(5).Object.model = dIs(16)
O2D.GetRadius EnemyTemplate(5).Object
EnemyTemplate(5).Object.scale = .25
EnemyTemplate(5).mhp = 5: EnemyTemplate(5).hp = EnemyTemplate(5).mhp
EnemyTemplate(5).ai = 5
EnemyTemplate(5).trail = BLUE
EnemyTemplate(5).Object.Colour = 191

EnemyTemplate(6).score = 25             '    Drill Ship
EnemyTemplate(6).Object.model = dIs(25)
O2D.GetRadius EnemyTemplate(6).Object
EnemyTemplate(6).Object.scale = .15
EnemyTemplate(6).mhp = 5: EnemyTemplate(6).hp = EnemyTemplate(6).mhp
EnemyTemplate(6).ai = 6
EnemyTemplate(6).trail = GREEN
EnemyTemplate(6).Object.Colour = 127

EnemyTemplate(7).score = 100
EnemyTemplate(7).Object.model = dIs(26)
O2D.GetRadius EnemyTemplate(7).Object
EnemyTemplate(7).Object.scale = .6
EnemyTemplate(7).mhp = 50: EnemyTemplate(7).hp = EnemyTemplate(7).mhp
EnemyTemplate(7).ai = 7
EnemyTemplate(7).trail = RED
EnemyTemplate(7).Object.Colour = 32
EnemyTemplate(7).Object.AngOff = 180
EnemyTemplate(7).turnspeed = 15

' Setup for Enemy's //-----------------------------------------------//

' Setup for powerup's //---------------------------------------------//

PowerUpTemplate(1).Object.model = dIs(17)  ' Missile Ammo
O2D.GetRadius PowerUpTemplate(1).Object
PowerUpTemplate(1).WeaponN = 2
PowerUpTemplate(1).Ammo = 1

PowerUpTemplate(2).Object.model = dIs(18)  ' Mine's
PowerUpTemplate(2).Object.radius = PowerUpTemplate(1).Object.radius
PowerUpTemplate(2).WeaponN = 3
PowerUpTemplate(2).Ammo = 2

PowerUpTemplate(3).Object.model = dIs(19)  ' Cluster Bomb
PowerUpTemplate(3).Object.radius = PowerUpTemplate(1).Object.radius
PowerUpTemplate(3).WeaponN = 4
PowerUpTemplate(3).Ammo = 1

PowerUpTemplate(4).Object.model = dIs(20)  ' Freze laser
PowerUpTemplate(4).Object.radius = PowerUpTemplate(1).Object.radius
PowerUpTemplate(4).WeaponN = 5
PowerUpTemplate(4).Ammo = 3

PowerUpTemplate(5).Object.model = dIs(21)  ' Hypr Beam
PowerUpTemplate(5).Object.radius = PowerUpTemplate(1).Object.radius
PowerUpTemplate(5).WeaponN = 6
PowerUpTemplate(5).Ammo = 2

PowerUpTemplate(6).Object.model = dIs(22)  ' Mini Ammo
PowerUpTemplate(6).Object.radius = PowerUpTemplate(1).Object.radius
PowerUpTemplate(6).WeaponN = 7
PowerUpTemplate(6).Ammo = 3

PowerUpTemplate(7).Object.model = dIs(23)  ' RML 5000 Drone
PowerUpTemplate(7).Object.radius = PowerUpTemplate(1).Object.radius
PowerUpTemplate(7).WeaponN = 8
PowerUpTemplate(7).Ammo = 1

PowerUpTemplate(8).Object.model = dIs(24)  ' Extra Life
PowerUpTemplate(8).Object.radius = PowerUpTemplate(1).Object.radius
PowerUpTemplate(8).Ammo = 1

' Setup for powerup's //---------------------------------------------//

END SUB

SUB LOAD.SinCosTables
 FOR i = 0 TO 360
  Cosine(i) = COS(i * (PI / 180))
  Sine(i) = SIN(i * (PI / 180))
 NEXT i
END SUB

SUB LoadMPlayLevel (FileName AS STRING)
 F = FREEFILE
 OPEN FileName FOR INPUT AS #F
  INPUT #F, Header$
  IF Header$ <> "-|XGMAEml|-" THEN CLOSE #F: EXIT SUB
  INPUT #F, MPlay.Name
  INPUT #F, MPlay.XSPFile
  INPUT #F, MPlay.GameType
  INPUT #F, MPlaySpawnPoints.X1, MPlaySpawnPoints.Y1
  INPUT #F, MPlaySpawnPoints.X2, MPlaySpawnPoints.Y2
  INPUT #F, MPlay.TimeLimit
  INPUT #F, MPlay.ScoreLimit
 CLOSE #F
 LoadXSP MPlay.XSPFile, Arena.model
 Flags(1).X = MPlaySpawnPoints.X1: Flags(1).Y = MPlaySpawnPoints.Y1
 Flags(2).X = MPlaySpawnPoints.X2: Flags(2).Y = MPlaySpawnPoints.Y2
 FOR i = 1 TO LEN(MPlay.Name)
  c$ = MID$(MPlay.Name, i, 1)
  SELECT CASE c$
   CASE "a" TO "z", "A" TO "Z", "0" TO "9", "-"
   CASE ELSE: c$ = CHR$(32)
  END SELECT
  MID$(MPlay.Name, i, 1) = c$
 NEXT i
END SUB

DEFSNG A-Z
SUB LoadXSP (FileName AS STRING, Number AS INTEGER)
 F = FREEFILE
 OPEN FileName FOR BINARY AS #F
  GET #F, , NofL(Number)
  FOR i = 1 TO NofL(Number)
   GET #F, , Shapes(Number, i)
  NEXT i
 CLOSE #F
END SUB

DEFINT A-Z
SUB MakeWeaponSound (WeaponSelect)
 SELECT CASE WeaponSelect
  CASE 0
   IF okflag THEN friq& = 30000: LoadPlayWav "XGW2.WAV"
  CASE 1
   IF okflag THEN LoadPlayWav "XGW1.WAV"
  CASE 2
   IF okflag THEN friq& = 22020: LoadPlayWav "XGW347.WAV"
  CASE 3
   IF okflag THEN LoadPlayWav "XGW347.WAV"
  CASE 4
   IF okflag THEN LoadPlayWav "XGW2.WAV"
  CASE 5
   IF okflag THEN LoadPlayWav "XGW5.WAV"
  CASE 6
   IF okflag THEN friq& = 22020: LoadPlayWav "XGW1.WAV"
  CASE 7
   IF okflag THEN LoadPlayWav "XGW347.WAV"
 END SELECT
END SUB

SUB MENU.MP.CType
 sel = 1
 seli = 8

 IPX = IPXInstalled%

 st# = TIMER

 CSSetTimer 0, 25

 DO
  CSWaitTimer 0
  CSClear EMS.Layer, 0

  PRT.MoveAndDrawParticles

  IF TIMER - st# > .3 AND INT(RND * 30) = 10 THEN
   xr = RND * 320
   yr = RND * 200
   PRT.CircleExp xr, yr, 40, 2, 0
   st# = TIMER
  END IF

  DoStars

  TX.Locate 10

   TX.CPrint "     MethodĿ      "
   TX.CPrint "Ŀ"
  FOR d = 1 TO 5
   TX.CPrint "                   "
  NEXT
   TX.CPrint ""

  TX.Locate 12

  Text.Colour = 255: TX.CPrint " Two on One PC   "
  Text.Colour = 220: IF IPX THEN Text.Colour = 255
                     TX.CPrint " IPX/SPX         "
  Text.Colour = 220: TX.CPrint " TCP/IP          "
  Text.Colour = 220: TX.CPrint " Modem           "
  Text.Colour = 255: TX.CPrint " Back            "

  sela = seli + (10 * 8)
  CSBox EMS.Layer, 92, sela - 1, 92 + 136, sela + 8, 32
 
  k$ = ""
  FOR i = 1 TO 16
   G$ = UCASE$(INKEY$)
   IF G$ <> "" AND TIMER - pauseK# > .1 THEN k$ = G$: pauseK# = TIMER
  NEXT i
 
  SELECT CASE k$
   CASE CHR$(0) + "P"
    sel = sel + 1
    IF sel > 5 THEN sel = 1
    friq& = 44050: LoadPlayWav "XGW347.WAV"
   CASE CHR$(0) + "H"
    sel = sel - 1
    IF sel < 1 THEN sel = 5
    friq& = 44050: LoadPlayWav "XGW347.WAV"
   CASE CHR$(13), CHR$(32):
    SELECT CASE sel
     CASE 1
      friq& = 22050: LoadPlayWav "XGMS.WAV"
      MIPX.TCP.MODEM = MPLAY.SAMECOMP
      GAME.MultyPlayer
     CASE 2
      IF IPX THEN
        friq& = 22050: LoadPlayWav "XGMS.WAV"
        MIPX.TCP.MODEM = MPLAY.IPX
        GAME.MultyPlayer
       ELSE
        friq& = 44050: LoadPlayWav "XGMNS.WAV"
      END IF
     CASE 5
      friq& = 22050: LoadPlayWav "XGMS.WAV"
      EXIT SUB
     CASE ELSE
      friq& = 44050: LoadPlayWav "XGMNS.WAV"
     END SELECT
   CASE CHR$(27): sel = 5
  END SELECT

  IF sel * 8 > seli THEN seli = seli + 1
  IF sel * 8 < seli THEN seli = seli - 1
   
  CSPCopy EMS.Layer, &HA000
 LOOP
END SUB

SUB MENU.MultyPlayer
 DIM temp AS STRING * 14
 FileLists FListS(), NumFiles, "-|XGMAEml|-"

 sel = 1
 st# = TIMER

 seli = 8

 CSSetTimer 0, 25

 DO
  CSWaitTimer 0

  IF oldsel <> sel THEN LoadMPlayLevel FListS(sel): MPlay.LevelName = FListS(sel)
  oldsel = sel

  CSClear EMS.Layer, 0
  PRT.MoveAndDrawParticles

  IF TIMER - st# > .3 AND INT(RND * 30) = 10 THEN
   xr = RND * 320
   yr = RND * 200
   PRT.CircleExp xr, yr, 40, 2, 0
   st# = TIMER
  END IF

  DoStars

  TX.Locate 4

  TX.CPrint "           LevelSelectĿ          "
  TX.CPrint "Ŀ"
  FOR d = 1 TO 17
   TX.CPrint "                                  "
  NEXT
  TX.CPrint ""

 k$ = ""
 FOR i = 1 TO 16
  G$ = UCASE$(INKEY$)
  IF G$ <> "" AND TIMER - pauseK# > .1 THEN k$ = G$: pauseK# = TIMER
 NEXT i

 TX.Locate 6

 Fview = sel - 9
 IF Fview > (NumFiles - 17) THEN Fview = (NumFiles - 17)
 IF Fview < 0 THEN Fview = 0

 blaher = 0

 FOR i = 1 TO 17
  temp = FListS(i + Fview)
  IF RTRIM$(temp) <> "" THEN temp = "   " + MID$(temp, 1, INSTR(temp, ".") - 1)
  IF sel = i + Fview THEN
   blaher = i
   ty = Text.y
  END IF
  CSPrint EMS.Layer, 20, Text.y, temp, Text.Colour
  Text.y = Text.y + 8
 NEXT i

 IF blaher THEN
  IF blaher * 8 > seli THEN seli = seli + 1
  IF blaher * 8 < seli THEN seli = seli - 1
  sela = seli + (4 * 8)
  CSBox EMS.Layer, 19, sela - 1, 19 + 112, sela + 8, 32
 END IF

 CSBoxF EMS.Layer, 215 - (160 * .35 + 1), 92 - (100 * .35), 215 + (160 * .35 + 1), 92 + (100 * .35), 0

 Arena.scale = .35: Arena.X = 215: Arena.Y = 92
 O2D.Draw Arena
 Arena.scale = 1: Arena.X = 160: Arena.Y = 100

 CSBox EMS.Layer, 215 - (160 * .35), 92 - (100 * .35), 215 + (160 * .35), 92 + (100 * .35), 255

 CSPrint EMS.Layer, 20 * 8, 6 * 8, MPlay.Name, Text.Colour
 IF MPlay.GameType = MPLAYGT.DM THEN
   CSPrint EMS.Layer, 20 * 8, 18 * 8, "Death Match", Text.Colour
  ELSEIF MPlay.GameType = MPLAYGT.CTF THEN
   CSPrint EMS.Layer, 20 * 8, 18 * 8, "Capture The Flag", Text.Colour
 END IF
 IF MPlay.ScoreLimit <> -1 THEN
   CSPrint EMS.Layer, 20 * 8, 20 * 8, "Score Limit:" + STR$(MPlay.ScoreLimit), Text.Colour
  ELSE
   CSPrint EMS.Layer, 20 * 8, 20 * 8, "Score Limit: None", Text.Colour
 END IF
 IF MPlay.TimeLimit <> -1 THEN
   CSPrint EMS.Layer, 20 * 8, 21 * 8, "Time Limit:" + STR$(MPlay.TimeLimit), Text.Colour
  ELSE
   CSPrint EMS.Layer, 20 * 8, 21 * 8, "Time Limit: None", Text.Colour
 END IF

 SELECT CASE k$
  CASE CHR$(0) + "P"
   sel = sel + 1
   IF sel > NumFiles THEN sel = NumFiles
   friq& = 44050: LoadPlayWav "XGW347.WAV"
  CASE CHR$(0) + "H"
   sel = sel - 1
   IF sel < 1 THEN sel = 1
   friq& = 44050: LoadPlayWav "XGW347.WAV"
  CASE CHR$(32), CHR$(13)
   friq& = 22050: LoadPlayWav "XGMS.WAV"
   MENU.MP.CType
  CASE CHR$(27):
   friq& = 22050: LoadPlayWav "XGMS.WAV"
   EXIT SUB
  END SELECT

 CSPCopy EMS.Layer, &HA000
LOOP

END SUB

FUNCTION NumIZE (stringy$)
 FOR i = 1 TO CSLen(stringy$) / 8
  N = N + ASC(MID$(stringy$, i, 1))
 NEXT i
 NumIZE = N
END FUNCTION

FUNCTION NumToStr$ (Num AS DOUBLE)
 DIM tempS AS STRING * 5

 tempS = "0.000"
 blag$ = LTRIM$(STR$(Num))

 IF MID$(blag$, 1, 1) <> "." THEN MID$(tempS, 1, 1) = MID$(blag$, 1, 1): bi = 2 ELSE bi = 1

 FOR i = 3 TO LEN(blag$)
  bi = bi + 1
  MID$(tempS, i, 1) = MID$(blag$, bi, 1)
 NEXT i

 NumToStr$ = tempS
END FUNCTION

DEFSNG A-Z
SUB O2D.Check (Object AS Object2D)
 ta = ((Object.Ang + 720) MOD 360)
 Object.Ang = ta
 ta = ((Object.AngOff + 720) MOD 360)
 Object.AngOff = ta
END SUB

DEFINT A-Z
FUNCTION O2D.Collide (Object AS Object2D, Object2 AS Object2D, Cx%, cy%)
DIM temp AS tLine
DIM temp1 AS tLine
DIM Ang
DIM Ang2
RANDOMIZE TIMER
Ang = ((Object.Ang + Object.AngOff + (720 * 2)) MOD 360)
Ang2 = ((Object2.Ang + Object2.AngOff + (720 * 2)) MOD 360)
o = O2D.RadiusCollide(Object, Object2)
IF o = -1 THEN
 om = NofL(Object2.model)
 FOR i = 1 TO NofL(Object.model)
  FOR j = 1 TO om
   RotateLine Shapes(Object.model, i), temp, Ang
   RotateLine Shapes(Object2.model, j), temp1, Ang2
   IF LineCollide(Object, Object2, temp, temp1, Cx%, cy%) THEN O2D.Collide = -1: EXIT FUNCTION
  NEXT j
 NEXT i
END IF
IF o = -2 THEN
 Cx% = Object.X
 cy% = Object.Y
 O2D.Collide = -1
END IF
END FUNCTION

SUB O2D.Draw (Object AS Object2D)
 DIM temp AS tLine
 Ang = ((Object.Ang + Object.AngOff) MOD 360)
 c = Object.Colour
 IF c = 255 THEN c = 250
 IF c = 192 THEN c = 188
 IF c = 128 THEN c = 122
 IF c = 64 THEN c = 60
 FOR i = 1 TO NofL(Object.model)
  RotateLine Shapes(Object.model, i), temp, Ang
  CSLine EMS.Layer, (temp.X1 * Object.scale) + Object.X, (temp.Y1 * Object.scale) + Object.Y, (temp.X2 * Object.scale) + Object.X, (temp.Y2 * Object.scale) + Object.Y, c
 NEXT i
END SUB

SUB O2D.GetRadius (Object AS Object2D)
 DIM l AS LONG
 DIM currentBest AS LONG
 DIM currentWorst AS LONG
 DIM temp AS tLine
 currentWorst = 100000
 currentBest = Object.radius
 j = Object.model
 a = 45
  FOR i = 1 TO NofL(j)
   RotateLine Shapes(j, i), temp, a
   l = SQR(CLNG(temp.X1) * CLNG(temp.X1) + CLNG(temp.Y1) * CLNG(temp.Y1))
   IF l > currentBest THEN currentBest = l
   IF l < currentWorst THEN currentWorst = l
   l = SQR(CLNG(temp.X2) * CLNG(temp.X2) + CLNG(temp.Y2) * CLNG(temp.Y2))
   IF l > currentBest THEN currentBest = l
   IF l < currentWorst THEN currentWorst = l
  NEXT i
 Object.radius = currentBest
 Object.fillradius = currentWorst * .9
END SUB

SUB O2D.MTScreen (Object AS Object2D)
 IF Object.X > 320 + (Object.scale * Object.radius) THEN Object.X = 1 - (Object.scale * Object.radius)
 IF Object.X < 1 - (Object.scale * Object.radius) THEN Object.X = 320 + (Object.scale * Object.radius)
 IF Object.Y > 200 + (Object.scale * Object.radius) THEN Object.Y = 1 - (Object.scale * Object.radius)
 IF Object.Y < 1 - (Object.scale * Object.radius) THEN Object.Y = 200 + (Object.scale * Object.radius)
END SUB

SUB O2D.MTScreenAK (Object AS Object2D)
 IF Object.X > 319 + (Object.scale * Object.radius) THEN Object.X = 1 - (Object.scale * Object.radius)
 IF Object.X < 0 - (Object.scale * Object.radius) THEN Object.X = 320 + (Object.scale * Object.radius)
 IF Object.Y > 199 + (Object.scale * Object.radius) THEN Object.Y = 1 - (Object.scale * Object.radius)
 IF Object.Y < 0 - (Object.scale * Object.radius) THEN Object.Y = 200 + (Object.scale * Object.radius)
END SUB

SUB O2D.Propell (Object AS Object2D, speed AS SINGLE)
 ta = ((Object.Ang + 720) MOD 360)
 IF ta = 0 THEN ta = 1
 Object.X = Object.X + (speed * Cosine(ta))
 Object.Y = Object.Y + (speed * Sine(ta))
END SUB

FUNCTION O2D.RadiusCollide (Object AS Object2D, Object2 AS Object2D)
DIM xv AS LONG
DIM yv AS LONG
DIM l AS INTEGER
xv = Object2.X - Object.X
yv = Object2.Y - Object.Y
l = SQR((xv) * (xv) + (yv) * (yv))
bla = Object.radius <> 1000 AND Object2.radius <> 1000
IF (((Object.radius * 1.3) * Object.scale) + ((Object2.radius * 1.3) * Object2.scale)) > l THEN
 IF ((Object.fillradius * Object.scale) + (Object2.fillradius * Object2.scale)) > l AND bla THEN
  O2D.RadiusCollide = -2
   ELSE
  O2D.RadiusCollide = -1
 END IF
END IF
END FUNCTION

SUB PRJ.AddProjectile (Projs() AS Projectile, fObject AS Object2D, Template AS Projectile, MAXPROJS AS INTEGER)
 okflag = 0
 FOR i = 1 TO MAXPROJS
  IF Projs(i).active = 0 THEN
   Projs(i) = Template
   ta = ((fObject.Ang + Projs(i).depAng + 720) MOD 360)
   IF ta = 0 THEN ta = 1
   Projs(i).Object.X = fObject.X + ((fObject.scale * fObject.radius) * Cosine(ta))
   Projs(i).Object.Y = fObject.Y + ((fObject.scale * fObject.radius) * Sine(ta))
   Projs(i).Object.Ang = fObject.Ang
   Projs(i).active = 1
   okflag = -1
   EXIT SUB
  END IF
 NEXT i
END SUB

SUB PRJ.CheckCollide (Projs() AS Projectile, Object AS Object2D, MAXPROJS AS INTEGER, rx, ry, rj)
 rj = 0
 FOR j = 1 TO MAXPROJS
  IF Projs(j).active THEN
   IF O2D.Collide(Projs(j).Object, Object, TX, ty) THEN rj = j: rx = TX: ry = ty: EXIT FOR
  END IF
 NEXT j
END SUB

SUB PRJ.ClearProjectiles (Projs() AS Projectile, MAXPROJS AS INTEGER)
 FOR i = 1 TO MAXPROJS
  Projs(i).active = 0
 NEXT i
END SUB

SUB PRJ.MoveAndDrawProjectiles (Projs() AS Projectile, MAXPROJS AS INTEGER)
 DIM test AS INTEGER
 DIM temp AS Object2D
 DIM old AS Object2D
 DIM newx AS SINGLE, newy AS SINGLE, R AS SINGLE
 FOR i = 1 TO MAXPROJS
  IF Projs(i).active = 1 THEN
   temp = Projs(i).Object
   IF Projs(i).accelmult THEN temp.speed = temp.speed * 2
   IF Projs(i).accelerate THEN temp.speed = temp.speed + Projs(i).accelerate
   old = temp
   O2D.Propell temp, temp.speed
   O2D.Check temp
   IF NOT Projs(i).invisible THEN O2D.Draw temp
   IF Projs(i).rotate > 0 THEN temp.AngOff = ((temp.AngOff + Projs(i).rotate) MOD 360)
   IF (temp.X <> old.X OR temp.Y <> old.Y) AND Projs(i).trail THEN
    a = ((temp.Ang + temp.AngOff + 90 + 720) MOD 360)
    IF a = 0 THEN a = 1
    newx = temp.X + (temp.X - old.X) + ((temp.radius * temp.scale) * Cosine(a))
    newy = temp.Y + (temp.Y - old.Y) + ((temp.radius * temp.scale) * Sine(a))
    R = RND
    R = R - (R / 2)
    IF Projs(i).trail = -2 THEN
      PRT.AddPart INT(newx), INT(newy), -((temp.X - old.X) / 5) + R, -((temp.Y - old.Y) / 5) + R, 3, 1, 0, 0, RED
     ELSE
      PRT.AddPart INT(newx), INT(newy), -((temp.X - old.X) / 5) + R, -((temp.Y - old.Y) / 5) + R, 3, 10, 0, 0, RED
    END IF
   END IF
   IF (temp.X > (320 + (temp.radius * temp.scale))) OR (temp.Y > (200 + (temp.radius * temp.scale))) OR (temp.X < (1 - (temp.radius * temp.scale))) OR (temp.Y < (1 - (temp.radius * temp.scale))) THEN
    Projs(i).active = 0:
   END IF
   Projs(i).Object = temp
  END IF
 NEXT i
END SUB

SUB PRT.AddPart (X, Y, xd AS SINGLE, yd AS SINGLE, Size AS INTEGER, ttl AS INTEGER, circ AS INTEGER, SetClr AS INTEGER, Colour AS INTEGER)
 FOR i = 1 TO MAXPARTICLES
  IF Parts(i).used = 0 THEN
   IF X > 320 OR X < 1 OR Y > 200 OR Y < 1 THEN EXIT SUB
   X# = X
   Y# = Y
   IF ttl = -1 THEN ttl = 30
   Parts(i).Fire = Fire: Fire = 0
   Parts(i).Noblend = Noblend: Noblend = 0
   Parts(i).baseColour = Colour
   Parts(i).X = (X# * 128): Parts(i).Y = (Y# * 128)
   Parts(i).xd = (xd * 128): Parts(i).yd = (yd * 128)
   Parts(i).used = 1
   Parts(i).Size = Size
   Parts(i).ttl = ttl
   Parts(i).circ = circ
   IF SetClr = 0 AND Parts(i).circ = 0 THEN Parts(i).circ = -1
   IF Parts(i).circ = -2 THEN Parts(i).circ = 0
   Parts(i).clr = 0
   Parts(i).ottl = ttl
   Parts(i).SetClr = SetClr
   EXIT SUB
  END IF
 NEXT i
END SUB

SUB PRT.CircleExp (X%, Y%, density%, Size%, grav%)
 DIM aStep AS SINGLE, a AS SINGLE
 aStep = 360 / ((density% / 3) + 1)
 a = 0
 FOR i = 1 TO (density% / 3) + 1
  a = a + aStep
  Fire = -1
  PRT.AddPart X%, Y%, Cosine(a) * 2, Sine(a) * 2, Size%, 20, 30, 0, RED
 NEXT i
END SUB

SUB PRT.ClearAllParts
 FOR i = 1 TO MAXPARTICLES
  Parts(i).used = 0
 NEXT i
END SUB

SUB PRT.ImplodeText (Text$, ex%, ey%, Size%)
 DIM tvx AS SINGLE, tvy AS SINGLE
 DIM l AS LONG, vx AS SINGLE, vy AS SINGLE
 
 CSMapEMSLayer EMS.Handle, 4
 CSClear EMS.Layer, 0

 CSPrint EMS.Layer, 0, 0, Text$, 15
 tplen = LEN(Text$) * 8
 NX = ex - (tplen / 2)
 NY = ey - 4
 FOR X = 0 TO tplen
  FOR Y = 0 TO 7
   IF CSPoint(EMS.Layer, X, Y) THEN
    TX = NX + X: ty = NY + Y
    vx = ex - TX: vy = ey - ty
    l = SQR(vx * vx + vy * vy)
    IF vx <> 0 AND l <> 0 THEN tvx = (vx / l)
    IF vy <> 0 AND l <> 0 THEN tvy = (vy / l)
    Noblend = -1
    PRT.AddPart TX + (-tvx * (l * Size)), ty + (-tvy * (l * Size)), tvx, tvy, Size * 2, INT(l * Size) / 1.5, -2, 0, BLUE
   END IF
  NEXT Y
 NEXT X

 CSMapEMSLayer EMS.Handle, 0
END SUB

SUB PRT.MoveAndDrawParticles
 DIM s AS SINGLE, clrStep AS SINGLE
 FOR i = 1 TO MAXPARTICLES
  IF Parts(i).used THEN
  
   clrStep = ((Parts(i).ttl + 1) / (Parts(i).ottl + 1))
   clrStep = clrStep * 63
   Parts(i).clr = clrStep
   Parts(i).ttl = Parts(i).ttl - 1
  
   Colour = Parts(i).baseColour
  
   IF Parts(i).clr > 0 THEN
     IF Colour = RED THEN clr = Parts(i).clr
     IF Colour = GREEN THEN clr = Parts(i).clr + 63
     IF Colour = BLUE THEN clr = Parts(i).clr + 127
     IF Colour = GREY THEN clr = Parts(i).clr + 191
    ELSE
     clr = 0
   END IF
  
   IF Parts(i).SetClr THEN clr = Parts(i).SetClr

   IF clr > 255 THEN clr = 0
  
   OldX = Parts(i).X / 128
   OldY = Parts(i).Y / 128
   
   Parts(i).X = Parts(i).X + (Parts(i).xd * 2)
   Parts(i).Y = Parts(i).Y + (Parts(i).yd * 2)
  
   IF Parts(i).ttl = 0 THEN Parts(i).used = 0
   IF (Parts(i).X > 40960 AND Parts(i).xd > 0) OR (Parts(i).X < 1 AND Parts(i).xd < 0) OR (Parts(i).Y > 25600 AND Parts(i).yd > 0) OR (Parts(i).Y < 1 AND Parts(i).yd < 0) THEN Parts(i).used = 0:
  
   IF Parts(i).circ = 0 THEN
    sz = Parts(i).Size
    X = Parts(i).X / 128 - 1
    Y = Parts(i).Y / 128 - 1
    clr2 = Parts(i).clr

    IF Parts(i).Noblend THEN
      CSBoxF EMS.Layer, X, Y, X + (sz), Y + (sz), clr
     ELSE
      BBoxF X, Y, X + (sz), Y + (sz), clr
    END IF

   END IF

   IF Parts(i).Fire THEN
    X = Parts(i).X / 128
    Y = Parts(i).Y / 128
    IF X = OldX THEN X = X - 1
    IF Y = OldY THEN Y = Y - 1
    R = RND
    R = R - (R / 2)
    PRT.AddPart X, Y, -((X - OldX) / 5) + R, -((Y - OldY) / 5) + R, 3, 5, 0, 0, Parts(i).baseColour
   END IF

    IF clr <> 0 THEN
     IF Parts(i).circ AND Parts(i).Fire = 0 THEN
       X = Parts(i).X / 128 - 2
       Y = Parts(i).Y / 128 - 2
    
       PRT.AddPart OldX, OldY, -((X + 1 - OldX) / 5), -((Y + 1 - OldY) / 5), 1, 2, 0, clr, Parts(i).baseColour
     
       BPset X + 1, Y + 2, clr
       BPset X + 1, Y + 3, clr
       BPset X + 2, Y + 1, clr
       BPset X + 2, Y + 2, clr
       BPset X + 2, Y + 3, clr
       BPset X + 2, Y + 4, clr
       BPset X + 3, Y + 1, clr
       BPset X + 3, Y + 2, clr
       BPset X + 3, Y + 3, clr
       BPset X + 3, Y + 4, clr
       BPset X + 4, Y + 2, clr
       BPset X + 4, Y + 3, clr
      
     END IF
    END IF
   END IF
 NEXT
END SUB

DEFSNG A-Z
SUB RotateLine (Line1 AS tLine, Line2 AS tLine, Angle AS INTEGER)
 Line2.X1 = Line1.X1 * Cosine(Angle) - Line1.Y1 * Sine(Angle)
 Line2.X2 = Line1.X2 * Cosine(Angle) - Line1.Y2 * Sine(Angle)
 Line2.Y1 = Line1.X1 * Sine(Angle) + Line1.Y1 * Cosine(Angle)
 Line2.Y2 = Line1.X2 * Sine(Angle) + Line1.Y2 * Cosine(Angle)
END SUB

DEFINT A-Z
SUB SetNumlocks
 DEF SEG = 0
  temp = PEEK(1047)
  temp = temp OR 32
  POKE (1047), KF
 DEF SEG
END SUB

SUB TX.CLS
 Text.y = 0
 CSClear &HA000, 0
END SUB

SUB TX.CPrint (Text$)
 Text.x = 160 - (CSLen(Text$) / 2)
 CSPrint EMS.Layer, Text.x, Text.y, Text$, Text.Colour
 Text.y = Text.y + 8
END SUB

SUB TX.Locate (Y)
 Text.y = (Y * 8) - 8
END SUB

SUB TX.Print (Text$)
 CSPrint &HA000, Text.x, Text.y, Text$, Text.Colour
 Text.y = Text.y + 8
END SUB

