DEFINT A-Z
'$DYNAMIC

DECLARE SUB MUSIC.LoadGDM (FileName AS STRING)
DECLARE SUB MUSIC.Volume (Level AS INTEGER)
DECLARE FUNCTION NumIZE% (stringy$)

'$INCLUDE: 'BWSB.BI'
'$INCLUDE: 'GDMTYPE.BI'
'$INCLUDE: 'XGMAE.BI'

TYPE MSEConfig
  SoundCard AS INTEGER
  BaseIO AS INTEGER
  IRQ AS INTEGER
  DMA AS INTEGER
  SoundQuality AS INTEGER
END TYPE

DIM SHARED Header AS GDMHeader
DIM SHARED SndDevMSE(6) AS STRING
DIM SHARED MSEConfig AS MSEConfig
DIM SHARED MVolume AS INTEGER
DIM SHARED MUSICON AS INTEGER

SUB LoadPlayWav (FileName AS STRING)

 SELECT CASE LTRIM$(RTRIM$(UCASE$(FileName)))
  CASE "XGE1.WAV": i = 1: chan = 1
  CASE "XGHI.WAV": i = 2: chan = 2
  CASE "XGMNS.WAV": i = 3: chan = 1
  CASE "XGMS.WAV": i = 4: chan = 1
  CASE "XGW1.WAV": i = 5: chan = 3
  CASE "XGW2.WAV": i = 6: chan = 4
  CASE "XGW347.WAV": i = 7: chan = 3
  CASE "XGW5.WAV": i = 8: chan = 3
  CASE ELSE: i = 1
 END SELECT

 IF MUSICON THEN
  IF friq& = 0 THEN friq& = 8363
  IF friq& > 44000 THEN friq& = 44000
  PlaySample chan, i - 1, friq&, 64, 8
  friq& = 0
 END IF
END SUB

SUB MENU.Main

 sel = 1
 seli = 8

 CSSetTimer 0, 25

 st# = TIMER
 DO
  CSWaitTimer 0
 
  CSClear EMS.Layer, 0

  DoStars

  PRT.MoveAndDrawParticles

  IF TIMER - st# > .3 AND INT(RND * 30) = 10 THEN
   xr = RND * 320
   yr = RND * 200
   PRT.CircleExp xr, yr, 40, 2, 0
   st# = TIMER
  END IF

    TX.Locate 6
  Text.Colour = 255

  TX.CPrint "      MenuĿ       "
  TX.CPrint "Ŀ"
  FOR d = 1 TO 6
   TX.CPrint "                   "
  NEXT
  TX.CPrint ""
  TX.CPrint " XGMAE v1.5 by "
  TX.CPrint " Chris Adams @ "
  TX.CPrint " TRINTS Online "
  TX.CPrint "   (C) 2001    "
  TX.CPrint ""

  TX.Locate 8

  Text.Colour = 255: TX.CPrint " Start Game      "
                     TX.CPrint " Training        "
                     TX.CPrint " MultiPlayer     "
                     TX.CPrint " High scores     "
  Text.Colour = 220: TX.CPrint " Options         "
  Text.Colour = 255: TX.CPrint " Exit            "

  sela = seli + (6 * 8)
  CSBox EMS.Layer, 92, sela - 1, 92 + 136, sela + 8, 32

  k$ = ""
  FOR i = 1 TO 16
   G$ = UCASE$(INKEY$)
   IF G$ <> "" AND TIMER - pauseK# > .1 THEN k$ = G$: pauseK# = TIMER
  NEXT i

  SELECT CASE k$
   CASE CHR$(0) + "P"
    sel = sel + 1
    IF sel > 6 THEN sel = 1
   friq& = 44050: LoadPlayWav "XGW347.WAV"
   CASE CHR$(0) + "H"
    sel = sel - 1
    IF sel < 1 THEN sel = 6
    friq& = 44050: LoadPlayWav "XGW347.WAV"
   CASE CHR$(13), CHR$(32):
    SELECT CASE sel
     CASE 1
      friq& = 22050: LoadPlayWav "XGMS.WAV"
      GAME.LevelMode
     CASE 2
      friq& = 22050: LoadPlayWav "XGMS.WAV"
      GAME.ScoreMode score&, KillEff#, TotalTime#: PRT.ClearAllParts
     CASE 3
      friq& = 22050: LoadPlayWav "XGMS.WAV"
      MENU.MultyPlayer
     CASE 4
      friq& = 22050: LoadPlayWav "XGMS.WAV"
      DoHighScores 0, DHS.VIEW
     CASE 6
      friq& = 22050: LoadPlayWav "XGMS.WAV"
      GOTO ExitProg
     CASE ELSE
      friq& = 44050: LoadPlayWav "XGMNS.WAV"
     END SELECT
   CASE CHR$(27): sel = 6
  END SELECT
 
  IF sel * 8 > seli THEN seli = seli + 1
  IF sel * 8 < seli THEN seli = seli - 1
 
  CSPCopy EMS.Layer, &HA000
 LOOP
 
ExitProg:

END SUB

SUB MUSIC.DeInit
 IF MUSICON THEN
  StopMusic
  StopOutput
  UnloadModule
  FreeMSE
 END IF
END SUB

SUB MUSIC.Init

 MUSICON = -1

 SndDevMSE(1) = "GUS"
 SndDevMSE(2) = "SB1X"
 SndDevMSE(3) = "SB2X"
 SndDevMSE(4) = "SBPRO"
 SndDevMSE(5) = "SB16"
 SndDevMSE(6) = "PAS"

 FOR i = 1 TO 8
  SoundF(i) = NumIZE(SoundF$)
 NEXT i

 F = FREEFILE
 OPEN "MSE.CFG" FOR BINARY AS #F
  GET #F, , MSEConfig
 CLOSE #F

 IF MSEConfig.SoundCard = 0 THEN MUSICON = 0: EXIT SUB

 PRINT "Initalizing BWSB Sound/Music Engine...";

 MSE$ = SndDevMSE(MSEConfig.SoundCard) + ".MSE"

 SELECT CASE MSEConfig.SoundQuality
  CASE 0: frq = 16
  CASE 1: frq = 22
  CASE 2: frq = 45
  CASE 3: frq = 8
 END SELECT

 ErrorFlag = LoadMSE(MSE$, 0, frq, 4096, MSEConfig.BaseIO, MSEConfig.IRQ, MSEConfig.DMA)

 IF ErrorFlag THEN PRINT "Error. (Audio is now off)": MUSICON = 0: EXIT SUB

 PRINT "Done."

END SUB

REM $STATIC
SUB MUSIC.LoadGDM (FileName AS STRING)

 IF MUSICON THEN
  ErrorFlag = 1

  File = FREEFILE
  OPEN FileName FOR BINARY AS File

  LoadGDM FILEATTR(File, 2), 0, ErrorFlag, VARSEG(Header), VARPTR(Header)

  IF ErrorFlag THEN PRINT "Error;"; ErrorFlag: END

  MusicChannels = 0
  FOR J = 1 TO 32
   IF ASC(MID$(Header.PanMap, J, 1)) <> &HFF THEN
    MusicChannels = MusicChannels + 1
   END IF
  NEXT

  OverRate& = StartOutput(MusicChannels / 2, 0)
 END IF

END SUB

REM $DYNAMIC
SUB MUSIC.Play
 IF MUSICON THEN StartMusic
END SUB

SUB MUSIC.PlayGDM (FileName AS STRING)
 IF MUSICON THEN
  MUSIC.LoadGDM FileName
  StartMusic
  MUSIC.Volume MVolume
 END IF
END SUB

SUB MUSIC.Stop
 IF MUSICON THEN StopMusic
END SUB

SUB MUSIC.Volume (Level AS INTEGER)
 IF MUSICON THEN arf = MusicVolume(Level): MVolume = Level
END SUB

