' DS4QB++ master moduole -- Header file

' Prototypes

' Internal functions
DECLARE SUB StopSend (Handle AS INTEGER)
DECLARE SUB StopReceive (Handle AS INTEGER)
DECLARE SUB SendMessage ()
DECLARE SUB WaitConfirm ()
DECLARE SUB Unpack ()
DECLARE SUB DeleteFiles ()
DECLARE FUNCTION ReadySend% ()
DECLARE FUNCTION ReadyReceive% ()
DECLARE FUNCTION FileExsist% (File AS STRING)

DECLARE SUB INTERRUPTX (intnum AS INTEGER, inreg AS ANY, outreg AS ANY)

' Constants

' Communication
CONST OUTFILE = "DS4QB.QBW"
CONST INFILE = "DS4QB.VCW"
CONST SENDCONFIRM = "DS4QB.QBS"
CONST RECEIVECONFIRM = "DS4QB.VCS"

' Message id's
CONST CMD.CLOSE = 1
CONST CMD.RESET = 2
CONST CMD.LOADSND = 3
CONST CMD.PLAYSND = 4
CONST CMD.SETSNDATTR = 5
CONST CMD.GETSNDATTR = 6
CONST CMD.LOADMUSIC = 7
CONST CMD.PLAYMUSIC = 8
CONST CMD.SETMUSICATTR = 9
CONST CMD.STOPSND = 11
CONST CMD.PAUSEMUSIC = 12
CONST CMD.RESUMEMUSIC = 13
CONST CMD.STOPMUSIC = 14
CONST CMD.DELETESND = 15
CONST CMD.DELETEMUSIC = 16
CONST CMD.SETVOLUME = 17
CONST CMD.SETGLOBALVOLUMES = 18
CONST CMD.PAUSESND = 19
CONST CMD.RESUMESND = 20
CONST CMD.GETMUSICLENGTH = 21
CONST CMD.SETMUSICPOSITION = 22
CONST CMD.GETMUSICPOSITION = 23

' Types

' RegTypeX
TYPE RegTypeX
     Ax    AS INTEGER
     Bx    AS INTEGER
     Cx    AS INTEGER
     Dx    AS INTEGER
     Bp    AS INTEGER
     Si    AS INTEGER
     Di    AS INTEGER
     Flags AS INTEGER
     Ds    AS INTEGER
     Es    AS INTEGER
END TYPE

' CMD.INITIALIZE chunk
TYPE CHUNKxCMDxINITIALIZE
 ID AS INTEGER
 Quality AS LONG
 Flags AS LONG
END TYPE

' CMD.CLOSE chunk
TYPE CHUNKxCMDxCLOSE
 ID AS INTEGER
END TYPE

' CMD.RESET chunk
TYPE CHUNKxCMDxRESET
 ID AS INTEGER
 What AS INTEGER
END TYPE

' CMD.LOADSND chunk
TYPE CHUNKxCMDxLOADSND
 ID AS INTEGER
 Slot AS INTEGER
 FileName AS STRING * 64
 Flags AS LONG
END TYPE

' CMD.PLAYSND chunk
TYPE CHUNKxCMDxPLAYSND
 ID AS INTEGER
 Slot AS INTEGER
 Freq AS LONG
 Volume AS INTEGER
 Pan AS INTEGER
 Looping AS INTEGER
END TYPE

' CMD.STOPSND chunk
TYPE CHUNKxCMDxSTOPSND
 ID AS INTEGER
 Slot AS INTEGER
END TYPE

' CMD.SETSNDATTR
TYPE CHUNKxCMDxSETSNDATTR
 ID AS INTEGER
 Slot AS INTEGER
 Freq AS LONG
 Volume AS INTEGER
 Pan AS INTEGER
 Looping AS INTEGER
 Flags AS LONG
END TYPE

' CMD.DELETESND chunk
TYPE CHUNKxCMDxDELETESND
 ID AS INTEGER
 Slot AS INTEGER
END TYPE

' CMD.LOADMUSIC chunk
TYPE CHUNKxCMDxLOADMUSIC
 ID AS INTEGER
 Slot AS INTEGER
 FileName AS STRING * 64
 Flags AS LONG
 MusicType AS INTEGER
END TYPE

' CMD.SETVOLUME chunk
TYPE CHUNKxCMDxSETVOLUME
 ID  AS INTEGER
 Volume AS INTEGER
END TYPE

' CMD.SETGLOBALVOLUMES chunk
TYPE CHUNKxCMDxSETGLOBALVOLUMES
 ID  AS INTEGER
 SoundVolume AS INTEGER
 MusicVolume AS INTEGER
END TYPE

' CMD.PAUSEMUSIC chunk
TYPE CHUNKxCMDxPAUSEMUSIC
 ID AS INTEGER
 Slot AS INTEGER
END TYPE

' CMD.RESUMEMUSIC chunk
TYPE CHUNKxCMDxRESUMEMUSIC
 ID AS INTEGER
 Slot AS INTEGER
END TYPE

' CMD.STOPMUSIC chunk
TYPE CHUNKxCMDxSTOPMUSIC
 ID AS INTEGER
 Slot AS INTEGER
END TYPE

' CMD.PLAYMUSIC chunk
TYPE CHUNKxCMDxPLAYMUSIC
 ID AS INTEGER
 Slot AS INTEGER
END TYPE

' CMD.SETMUSICATTR chunk
TYPE CHUNKxCMDxSETMUSICATTR
 ID AS INTEGER
 Slot AS INTEGER
 Pan AS INTEGER
 Amp AS INTEGER
END TYPE

' CMD.DELETEMUSIC chunk
TYPE CHUNKxCMDxDELETEMUSIC
 ID AS INTEGER
 Slot AS INTEGER
END TYPE

' CMD.PAUSESOUND chunk
TYPE CHUNKxCMDxPAUSESOUND
 ID AS INTEGER
 Slot AS INTEGER
END TYPE

' CMD.RESUMESOUND chunk
TYPE CHUNKxCMDxRESUMESOUND
 ID AS INTEGER
 Slot AS INTEGER
END TYPE

' CMD.SETMUSICPOSITION chunk
TYPE CHUNKxCMDxSETMUSICPOSITION
 ID AS INTEGER
 Slot AS INTEGER
 Position AS LONG
END TYPE

' CMD.GETMUSICPOSITION chunk
TYPE CHUNKxCMDxGETMUSICPOSITION
 ID AS INTEGER
 Slot AS INTEGER
END TYPE

' CMD.GETMUSICLENGTH chunk
TYPE CHUNKxCMDxGETMUSICLENGTH
 ID AS INTEGER
 Slot AS INTEGER
END TYPE

