DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'XGMAE.BI'

REM $STATIC
SUB CloseSocket (Socket%)
   InReg.Bx = 1
   InReg.Ax = 0
   InReg.Dx = Socket
   CALL InterruptX(&H7A, InReg, OutReg)
END SUB

FUNCTION HexToBinary$ (Variable$)
   IF Variable$ = "" THEN
      HexToBinary$ = ""
   ELSE
      A = LEN(Variable$) MOD 2
      IF A = 1 THEN
         HexToBinary$ = ""
      ELSE
         Temp$ = ""
         FOR A = 1 TO LEN(Variable$) STEP 2
            Temp! = VAL("&H" + MID$(Variable$, A, 2))
            Temp$ = Temp$ + CHR$(Temp!)
         NEXT
         HexToBinary$ = Temp$
      END IF
   END IF
END FUNCTION

SUB IPXCancelR (CompleteCode%)
   InReg.Bx = 6
   InReg.Es = VARSEG(ECBR)
   InReg.Si = VARPTR(ECBR)
   CALL InterruptX(&H7A, InReg, OutReg)
   CompleteCode = SplitWordLo%(OutReg.Ax)
   '
   '                    FC = was canceled
END SUB

SUB IPXCancelS (CompleteCode%)
   InReg.Bx = 6
   InReg.Es = VARSEG(ECBS)
   InReg.Si = VARPTR(ECBS)
   CALL InterruptX(&H7A, InReg, OutReg)
   CompleteCode = SplitWordLo%(OutReg.Ax)
   '
   '                    FC = was canceled
END SUB

SUB IPXDisconnect (DNet$, DNode$, DSock$)
   Disconnect.NetWork = DNet$
   Disconnect.Node = DNode$
   Disconnect.Socket = DSock$
   InReg.Bx = &HB
   InReg.Es = VARSEG(Disconnect)
   InReg.Si = VARPTR(Disconnect)
   CALL InterruptX(&H7A, InReg, OutReg)
END SUB

FUNCTION IPXInstalled%
   InReg.Ax = &H7A00
   CALL InterruptX(&H2F, InReg, OutReg)
   AL = SplitWordLo(OutReg.Ax)
   IF AL = &HFF THEN IPXInstalled = 1 ELSE IPXInstalled = 0
END FUNCTION

SUB OpenSocket (Socket%, Status%, SocketNumberReturned%)
   InReg.Bx = 0
   InReg.Ax = 0
   InReg.Dx = Socket
   CALL InterruptX(&H7A, InReg, OutReg)
   Status = SplitWordLo(OutReg.Ax)
   SocketNumberReturned = OutReg.Dx
   '
   '           Completion status
   '                    00 successful
   '                    FF open already
   '                    FE socket table is full
END SUB

SUB RelenquishControl
   DEFINT A-Z
   InReg.Ax = 0
   InReg.Bx = &HA
   CALL InterruptX(&H7A, InReg, OutReg)
END SUB

SUB SendPacket (CompleteCode%, InUseFlag%)
   InReg.Bx = 3
   InReg.Es = VARSEG(ECBS)
   InReg.Si = VARPTR(ECBS)
   CALL InterruptX(&H7A, InReg, OutReg)
   CompleteCode = ASC(ECBS.CompCode)
   InUseFlag = ASC(ECBS.InUse)
   '
   '        Error codes:
   '              00    sent
   '              FC    canceled
   '              FD    malformed packet
   '              FE    no listener (undelivered)
   '              FF    hardware failure
END SUB

SUB SocketListen
   InReg.Bx = 4
   InReg.Es = VARSEG(ECBR)
   InReg.Si = VARPTR(ECBR)
   CALL InterruptX(&H7A, InReg, OutReg)
   CompleteCode = ASC(ECBR.CompCode)
   InUseFlag = ASC(ECBR.InUse)
   '
   '        Completion codes:
   '              00    received
   '              FC    canceled
   '              FD    packet overflow
   '              FF    socket was closed
   '              FE    Listening
END SUB

FUNCTION SplitWordHi (TheWord%)
   SplitWordHi = (TheWord% AND &HFF00) / 256
END FUNCTION

FUNCTION SplitWordLo (TheWord%)
   SplitWordLo = (TheWord% AND &HFF)
END FUNCTION

FUNCTION TurnToHex$ (Variable$)
   Temp$ = ""
   FOR Byte = 1 TO LEN(Variable$)
      Value! = ASC(MID$(Variable$, Byte, 1))
      IF Value! < 15 THEN
         Temp$ = Temp$ + "0" + HEX$(Value!)
      ELSE
         Temp$ = Temp$ + HEX$(Value!)
      END IF
   NEXT
   TurnToHex$ = Temp$
END FUNCTION

