DEFINT A-Z
'$DYNAMIC

DECLARE SUB SetCam (X%, Y%, Zoom AS SINGLE)
DECLARE SUB CSFfix ()
DECLARE SUB AddPxLight (X%, Y%, Size%, Colour%)
DECLARE SUB PRT.AddPart (X%, Y%, Xd AS SINGLE, Yd AS SINGLE, Size AS INTEGER, Ttl AS INTEGER, SetClr AS INTEGER, Colour AS INTEGER, Flags AS INTEGER)
DECLARE SUB DrawO2DObjs ()
DECLARE SUB O2D.DrawReal (Object AS ANY)
DECLARE SUB DoLighting ()
DECLARE SUB AddLight (X AS INTEGER, Y AS INTEGER, Size AS INTEGER, Colour AS INTEGER)
DECLARE SUB DrawLight (Layer AS INTEGER, X AS INTEGER, Y AS INTEGER, SSize AS INTEGER, Colour AS INTEGER)
DECLARE SUB Delay (Time AS DOUBLE)
DECLARE SUB DoStars ()
DECLARE SUB FileLists (FList() AS STRING, NumFiles%, ContainText AS STRING)
DECLARE FUNCTION FindAngle% (X1%, Y1%, X2%, Y2%)
DECLARE FUNCTION LineCollide% (Object AS ANY, Object2 AS ANY, Line1 AS ANY, Line2 AS ANY, Cx%, Cy%)
DECLARE SUB LOAD.MemSetup ()
DECLARE SUB LOAD.InitBMAP ()
DECLARE SUB LOAD.InitVideo ()
DECLARE SUB LOAD.LoadINI ()
DECLARE SUB LOAD.LoadModels ()
DECLARE SUB LOAD.SetUpModels ()
DECLARE SUB LOAD.SinCosTables ()
DECLARE SUB LoadMPlayLevel (FileName AS STRING)
DECLARE SUB LoadXSP (FileName AS STRING, Number AS INTEGER)
DECLARE SUB MakeWeaponSound (WeaponSelect%)
DECLARE SUB MENU.MP.CType ()
DECLARE FUNCTION NumIZE% (stringy$)
DECLARE FUNCTION NumToStr$ (Num AS DOUBLE)
DECLARE SUB O2D.Check (Object AS ANY)
DECLARE FUNCTION O2D.Collide% (Object AS ANY, Object2 AS ANY, Cx%, Cy%)
DECLARE SUB O2D.Draw (Object AS ANY)
DECLARE SUB O2D.GetRadius (Object AS ANY)
DECLARE SUB O2D.Propell (Object AS ANY, Speed AS SINGLE)
DECLARE FUNCTION O2D.RadiusCollide% (Object AS ANY, Object2 AS ANY)
DECLARE SUB PRJ.AddProjectile (Projs() AS ANY, fObject AS ANY, Template AS ANY, MAXPROJS AS INTEGER)
DECLARE SUB PRT.MoveAndDrawParticles ()
DECLARE SUB RotateLine (Line1 AS ANY, Line2 AS ANY, Angle AS INTEGER)
DECLARE SUB TX.CLS ()
DECLARE SUB TX.CPrint (Text$)
DECLARE SUB TX.Locate (Y%)
DECLARE SUB TX.Print (Text$)
DECLARE SUB GAME.MultyPlayer ()
DECLARE SUB MENU.Main ()
DECLARE SUB AddFlash (Obj AS ANY, IntLev AS INTEGER, Red AS INTEGER, Blue AS INTEGER, Green AS INTEGER)
DECLARE SUB AntiAliase64 (BYVAL Layer%)
DECLARE SUB PlaySound (SoundN%)
DECLARE SUB Explosions (st#)

DECLARE SUB BPset64 (BYVAL Layer AS INTEGER, BYVAL X AS INTEGER, BYVAL Y AS INTEGER, BYVAL Colour AS INTEGER)
DECLARE SUB BBoxF64 (BYVAL Layer AS INTEGER, BYVAL X1 AS INTEGER, BYVAL Y1 AS INTEGER, BYVAL X2 AS INTEGER, BYVAL Y2 AS INTEGER, BYVAL Colour AS INTEGER)
DECLARE SUB BCircP64 (BYVAL Layer AS INTEGER, BYVAL X AS INTEGER, BYVAL Y AS INTEGER, BYVAL Size AS INTEGER, BYVAL Colour AS INTEGER)
DECLARE SUB BDrawLight64 (BYVAL Layer AS INTEGER, BYVAL X AS INTEGER, BYVAL Y AS INTEGER, BYVAL Size AS INTEGER, BYVAL Colour AS INTEGER, BYVAL ClrSeg AS INTEGER, BYVAL AngSeg AS INTEGER, BYVAL CosSeg AS INTEGER, BYVAL SinSeg AS INTEGER)
DECLARE FUNCTION FindFreePart (BYVAL arrayseg AS INTEGER)

'$INCLUDE: 'DEXTERN.BI'
'$INCLUDE: 'XGMAE.BI'

DIM SHARED SprBuff(32001)       AS INTEGER
DIM SHARED SprOff(128)          AS LONG
DIM SHARED SprHandle            AS INTEGER
DIM SHARED XPal                 AS STRING * 768
DIM Basr                        AS STRING * 2350

DIM SHARED bObject(1024)        AS bObj
DIM SHARED pxLight(512)         AS Light

DIM SHARED pUsed(2000)          AS INTEGER
DIM SHARED AngStep(25)          AS INTEGER
DIM SHARED ClrFix(25, 50)       AS INTEGER
DIM SHARED CosSize(25, 359)     AS INTEGER
DIM SHARED SinSize(25, 359)     AS INTEGER
DIM SHARED BColourLut(-10 TO 0) AS INTEGER

DIM SHARED Cam                  AS Camera

CSFfix

RANDOMIZE TIMER

CSInitText

CLS

R = CSLoadFont("Graphics\Font\XGmae.FNT", Basr)

SHELL "DIR Levels\Mplayer\*.INI >TEMPTEMP.TMP"

PRINT "Initializing Sound Engine...";

'R = DS4QB.Init(CURRENT, DEFAULT)

IF R THEN
  PRINT "Error!"
  IF R = -1 THEN
    PRINT "SOUNDSYS.DAT is missing! Please reinstall XGmae."
   ELSEIF R = -2 THEN
    PRINT "Could not connect to slave! Reboot your computer and try again."
   ELSEIF R = -3 THEN
    PRINT "SOUNDSYS.CFG is missing! Please run SETUP.EXE."
  END IF
  END
 ELSE
  PRINT "Done."
END IF

PRINT "Initializing EMS/XMS Memory...";
LOAD.MemSetup
PRINT "Done."

PRINT "Loading Configuration...";
LOAD.LoadINI
PRINT "Done."

PRINT "Loading Graphics Files...";
LOAD.LoadModels
PRINT "Done."

'PRINT "Loading Sounds...";
' FOR I = 1 TO 8
'  DS4QB.LoadSound I, "Sounds\" + LTRIM$(STR$(I)) + ".Wav", DEFAULT
' NEXT
'PRINT "Done."
'PRINT "Loading Music...";
' FOR I = 1 TO 2
'  DS4QB.LoadMusic I, "Music\" + LTRIM$(STR$(I)) + ".Mo3", DEFAULT
' NEXT
'PRINT "Done."

PRINT "Making Sine and Cosine tables...";
LOAD.SinCosTables
PRINT "Done."

PRINT "Setting up Models and Objects...";
LOAD.SetUpModels
PRINT "Done."

'DS4QB.SetGlobalVolumes 50, 75

PRINT : PRINT LTRIM$(STR$(FRE(-1) \ 1024)); "KBs of conventional memory free."

PRINT : PRINT "Hit any key to continue.."

WHILE INKEY$ <> "": WEND
WHILE INKEY$ = "": WEND

MenuStep = 1

FOR I = 1 TO 64
 Delay .05
 FOR J = 0 TO 15
  CSGetCol J, R, B, G
  R = R - 1: B = B - 1: G = G - 1
  IF R < 0 THEN R = 0
  IF B < 0 THEN B = 0
  IF G < 0 THEN G = 0
  CSSetCol J, R, B, G
 NEXT J
NEXT I

SCREEN 13
CSInitVGA

LOAD.InitVideo

CSSetFont Basr

FOR I = 1 TO MAXSTARS
 Stars(I).X = INT(RND * 320) + 1
 Stars(I).Y = INT(RND * 200) + 1
 Stars(I).AngOff = (INT(RND * 3) + 1)
 Stars(I).Scale = (Stars(I).AngOff) / 3 / 8
 Stars(I).Colour = Stars(I).AngOff * (63 / 3) + 127
NEXT I

CSMapEMSLayer EMS.Handle, 0
CSSetClipBox 0, 0, 319, 199

CSInstallTimer

SetCam 160, 100, 1

MENU.Main

'DS4QB.Close

CSRemoveTimer
CSInitText
CSDeallocateEMS EMS.Handle
CSDeallocateXMS SprHandle

END

REM $STATIC
SUB AddLight (X AS INTEGER, Y AS INTEGER, Size AS INTEGER, Colour AS INTEGER)
 FOR I = 1 TO UBOUND(bObject, 1)
  IF bObject(I).Used = 0 THEN
   bObject(I).Lit.X = X
   bObject(I).Lit.Y = Y
   bObject(I).Lit.Size = Size
   bObject(I).Lit.BaseColour = (Colour \ 64) * 64
   bObject(I).Used = -2
   EXIT SUB
  END IF
 NEXT
END SUB

SUB AddPxLight (X, Y, Size, Colour)
 FOR I = 1 TO UBOUND(pxLight, 1)
  IF pxLight(I).X = 0 THEN
   pxLight(I).X = X
   pxLight(I).Y = Y
   pxLight(I).Size = Size
   pxLight(I).BaseColour = Colour AND 192
   EXIT SUB
  END IF
 NEXT
END SUB

FUNCTION CSSaveBMP (Layer%, X1%, Y1%, X2%, Y2%, File$, Pal$)
 File$ = File$ + CHR$(0)
 CSSaveBMP = xCSSaveBMP%(Layer%, X1%, Y1%, X2%, Y2%, VARSEG(Pal$), SADD(Pal$), VARSEG(File$), SADD(File$))
END FUNCTION

FUNCTION CSSnapShot (File$)
 DIM TempPalette AS STRING * 768
 CSGetPal TempPalette
 CSSnapShot = CSSaveBMP(&HA000, 0, 0, 319, 199, File$, TempPalette)
END FUNCTION

REM $DYNAMIC
DEFSNG A-Z
SUB Delay (Time AS DOUBLE)
StartTime# = TIMER: DO: LOOP UNTIL TIMER - StartTime# >= Time
END SUB

DEFINT A-Z
SUB DoHighScores (KillEff#, WhatToDo)
DIM PlayerPlace AS SINGLE

 CSSetTimer 0, 25

 WhatToDo2 = WhatToDo
 F = FREEFILE
 OPEN "XGMAE.HSR" FOR INPUT AS #F
  FOR I = 1 TO 10
   INPUT #F, HighScores(I).pName
   INPUT #F, HighScores(I).KillEff
   INPUT #F, HighScores(I).Date
  NEXT I
 CLOSE #F

RestartHighScores:
 SELECT CASE WhatToDo2
  CASE DHS.ADD
   PlayerPlace = 0
   FOR I = 10 TO 1 STEP -1
    eff# = VAL(HighScores(I).KillEff)
    IF KillEff# >= eff# THEN
     PlayerPlace = I
    END IF
   NEXT I
   IF PlayerPlace THEN
    FOR I = 10 TO PlayerPlace STEP -1
     HighScores(I + 1) = HighScores(I)
    NEXT I
    HighScores(PlayerPlace).pName = "[Enter Name]"
    HighScores(PlayerPlace).Date = DATE$
    HighScores(PlayerPlace).KillEff = NumToStr$(KillEff#)
    Temp$ = "[Enter Name]"
    WhatToDo2 = DHS.VIEW
    GOTO RestartHighScores
   END IF
  CASE DHS.VIEW
   st# = TIMER
   DO
    CSWaitTimer 0
    CSClear EMS.Layer, 0

    DoStars
    PRT.MoveAndDrawParticles

    BBoxF64 EMS.Layer, 28, 60, 291, 164, 143

    Explosions st#

    TX.Locate 7
     TX.CPrint " HighScores "
     TX.CPrint "Ŀ"
     TX.CPrint "     Name       K-E    Date   "
     TX.CPrint "Ĵ"
    FOR I = 1 TO 10
     TX.CPrint "                                "
    NEXT I
     TX.CPrint ""
   
    K$ = ""
    FOR I = 1 TO 16
     G$ = INKEY$
     IF G$ <> "" AND TIMER - pauseK# > .05 THEN K$ = G$: pauseK# = TIMER
    NEXT I

    TX.Locate 11
    FOR I = 1 TO 10
     IF PlayerPlace = I THEN
      SELECT CASE UCASE$(K$)
       CASE "A" TO "Z", "0" TO "9", "_", "-", "!", "@", "#", "$", "%", "^", "&", "*", "~", "\", "/", "|", "?", "[", "{", "]", "}", " "
        DS4QB.PlaySoundEx 5, 44050, CURRENT, CURRENT, CURRENT
        IF Temp$ = "[Enter Name]" THEN Temp$ = ""
        Temp$ = Temp$ + K$
        IF LEN(Temp$) > 15 THEN Temp$ = MID$(Temp$, 1, 15)
       CASE CHR$(8)
        DS4QB.PlaySoundEx 3, 44050, CURRENT, CURRENT, CURRENT
        IF Temp$ = "[Enter Name]" THEN Temp$ = ""
        IF LEN(Temp$) > 1 THEN Temp$ = MID$(Temp$, 1, LEN(Temp$) - 1) ELSE Temp$ = ""
       CASE CHR$(13)
        K$ = ""
        PlayerPlace = 0
        DS4QB.PlaySoundEx 4, 22050, CURRENT, CURRENT, CURRENT
      END SELECT
      HighScores(I).pName = Temp$
     END IF
     PosX = (20 - (LEN(HighScores(I).pName + "" + HighScores(I).KillEff + "" + HighScores(I).Date) / 2)) * 8
     IF PlayerPlace = I THEN
      BBoxF64 EMS.Layer, PosX - 2, Text.y, CSLen(HighScores(I).pName) + PosX + 1, Text.y + 7, 143
     END IF
     IF I = 1 THEN
      IF TIMER - zT# < .2 THEN Text.Colour = 32
      IF TIMER - zT# >= .2 THEN Text.Colour = 255
      IF TIMER - zT# >= .4 THEN zT# = TIMER
     END IF
     CSPrint EMS.Layer, PosX, Text.y, HighScores(I).pName, Text.Colour
     Text.Colour = 255
     PosX = PosX + 120
      CSPrint EMS.Layer, PosX, Text.y, "" + HighScores(I).KillEff + "" + HighScores(I).Date, Text.Colour
     Text.y = Text.y + 8
    NEXT I

    IF K$ <> "" AND PlayerPlace = 0 THEN EXIT DO
   
    CSPcopy EMS.Layer, &HA000
   LOOP
   DS4QB.PlaySoundEx 4, 22050, CURRENT, CURRENT, CURRENT
 END SELECT

 F = FREEFILE
 OPEN "XGMAE.HSR" FOR OUTPUT AS #F
  FOR I = 1 TO 10
   PRINT #F, HighScores(I).pName
   PRINT #F, HighScores(I).KillEff
   PRINT #F, HighScores(I).Date
  NEXT I
 CLOSE #F
  
END SUB

REM $STATIC
SUB DoLighting
 ' Blah
END SUB

REM $DYNAMIC
SUB DoStars
 gOk = 0
 FOR I = 1 TO MAXSTARS
  IF Stars(I).X = 0 AND Stars(I).Y = 0 THEN
    Stars(I).AngOff = (INT(RND * 3) + 1)
    Stars(I).Scale = (Stars(I).AngOff) / 3 / 8
    Stars(I).X = 1
    Stars(I).Y = INT(RND * 190) + 5
    IF INT(Stars(I).Y) = 100 AND INT(RND * 100) = 50 THEN
      Stars(I).Colour = Stars(I).AngOff * (63 / 3) + 63
     ELSE
      IF INT(Stars(I).Y) = 100 THEN Stars(I).Y = 101
      Stars(I).Colour = Stars(I).AngOff * (63 / 3) + 127
    END IF
   ELSE
    OldX = Stars(I).X
    OldY = Stars(I).Y
    'Stars(I).X = Stars(I).X + (Stars(I).AngOff)
    Stars(I).Ang = Stars(I).Ang + 16
    NewX = Stars(I).X
    NewY = Stars(I).Y
    IF INT(Stars(I).Y) = 100 THEN C = Green: gOk = -1 ELSE C = Blue
    'IF Stars(I).AngOff = 3 THEN PRT.AddPart INT(OldX), INT(OldY - 1), 0, 0, 1, 4, 0, C, 0
    'IF Stars(I).AngOff = 2 THEN PRT.AddPart INT(OldX), INT(OldY), 0, 0, 1, 4, 0, C, PF.NOCIRC
    'IF Stars(I).AngOff = 1 THEN PRT.AddPart INT(OldX), INT(OldY + 1), 0, 0, 0, 4, 0, C, PF.NOCIRC
    O2D.Check Stars(I)
    O2D.Draw Stars(I)
    IF Stars(I).X > 320 THEN Stars(I).X = 0: Stars(I).Y = 0
  END IF
 NEXT I
 DrawO2DObjs
END SUB

REM $STATIC
SUB DrawHUD
 CSMoveFromXMS VARSEG(SprBuff(0)), VARPTR(SprBuff(0)), SprHandle, SprOff(127), 64004
 CSSprite EMS.Layer, 0, 0, VARSEG(SprBuff(0)), VARPTR(SprBuff(0))
END SUB

SUB DrawLight (Layer AS INTEGER, X AS INTEGER, Y AS INTEGER, SSize AS INTEGER, Colour AS INTEGER)
 NewX = (X * Cam.Zoom) - Cam.X
 NewY = (Y * Cam.Zoom) - Cam.Y
 BDrawLight64 Layer, NewX, NewY, (SSize / 1.5) * Cam.Zoom, Colour, VARSEG(ClrFix(0, 0)), VARSEG(AngStep(0)), VARSEG(CosSize(0, 0)), VARSEG(SinSize(0, 0))
 ' SSize / 1.25
END SUB

SUB DrawO2DObjs
 FOR I = 1 TO UBOUND(pxLight, 1)
  IF pxLight(I).X THEN
   DrawLight EMS.Layer, pxLight(I).X, pxLight(I).Y, pxLight(I).Size, pxLight(I).BaseColour
   pxLight(I).X = 0
  END IF
 NEXT
 FOR I = 1 TO UBOUND(bObject, 1)
  IF bObject(I).Used = -1 THEN O2D.DrawReal bObject(I).Obj
  IF bObject(I).Used = -2 THEN DrawLight EMS.Layer, bObject(I).Lit.X, bObject(I).Lit.Y, bObject(I).Lit.Size, bObject(I).Lit.BaseColour
  bObject(I).Used = 0
 NEXT
END SUB

REM $DYNAMIC
SUB FileLists (FList() AS STRING, NumFiles, ContainText AS STRING)
 F = FREEFILE
 OPEN "temptemp.tmp" FOR INPUT AS #F
  FOR D = 1 TO 5: INPUT #F, Text$: NEXT
  DO
   FileName$ = ""
   INPUT #F, Text$
   IF INSTR(Text$, "file(s)") THEN EXIT DO
   FOR I = 45 TO LEN(Text$)
    FileName$ = FileName$ + MID$(Text$, I, 1)
   NEXT I
   FileName$ = UCASE$(LTRIM$(RTRIM$(FileName$)))
   IF FileName$ <> "" THEN
    FilePass = 0
    F2 = FREEFILE
    OPEN "Levels\Mplayer\" + FileName$ FOR INPUT AS #F2
     DO
      IF EOF(F2) THEN EXIT DO
      INPUT #F2, Text$
      IF INSTR(Text$, ContainText) THEN FilePass = -1
     LOOP UNTIL EOF(F2) OR FilePass
    CLOSE #F2
    IF FilePass THEN
     NumFiles = NumFiles + 1
     IF NumFiles > UBOUND(FList, 1) THEN NumFiles = NumFiles - 1: EXIT SUB
     FList(NumFiles) = FileName$
    END IF
   END IF
  LOOP UNTIL EOF(F)
 CLOSE #F
END SUB

FUNCTION FindAngle% (X1%, Y1%, X2%, Y2%)
 DIM Angle AS DOUBLE

 X = X2 - X1
 Y = Y2 - Y1

 IF X > 0 THEN
   Angle = ATN(Y / X)
  ELSEIF X < 0 THEN
   Angle = ATN(Y / X) + 3.14159265358979#
  ELSEIF X = 0 AND Y > 0 THEN
   Angle = 3.14159265358979# * .5
  ELSEIF X = 0 AND Y < 0 THEN
   Angle = 3.14159265358979# * 1.5
 END IF

 FindAngle% = Angle * (180 / PI)
END FUNCTION

SUB FireWeapon (WeaponSelect AS INTEGER)
 DIM Temp AS Object2D
 Temp = MyShip
 SELECT CASE WeaponSelect
  CASE 0
   PRJ.AddProjectile LLaser(), MyShip, LLaserTemplate, MAXLLASERS
  CASE 1
   PRJ.AddProjectile Missile(), MyShip, MissileTemplate, MAXMISSILES
  CASE 2
   PRJ.AddProjectile Mine(), MyShip, MineTemplate, MAXMINES
  CASE 3
   PRJ.AddProjectile CBomb(), MyShip, CBombTemplate, MAXCBOMBS
  CASE 4
   PRJ.AddProjectile Laser(), MyShip, LaserTemplate, MAXLASERS
  CASE 5
   PRJ.AddProjectile Beam(), MyShip, BeamTemplate, MAXBEAMS
  CASE 6
   FOR I = -5 + 360 TO 5 + 360 STEP 5
    Temp.Ang = ((MyShip.Ang + I) MOD 360)
    PRJ.AddProjectile Mini(), Temp, MiniTemplate, MAXMINIS
   NEXT I
  CASE 7
   PRJ.AddProjectile Rml5K(), MyShip, Rml5KTemplate, MAXRML5K
 END SELECT

 MakeWeaponSound WeaponSelect
END SUB

SUB GetInput (Index, Up, Left, Down, Right, Brake, Shoot, Quit)
 Up = 0: Down = 0: Right = 0: Left = 0: Brake = 0: Shoot = 0
 IF MIPX.TCP.MODEM = MPLAY.SAMECOMP THEN
   IF XKey(MPlayerC(Index).Left) THEN Left = -1
   IF XKey(MPlayerC(Index).Right) THEN Right = -1
   IF XKey(MPlayerC(Index).Up) THEN Up = -1
   IF XKey(MPlayerC(Index).Down) THEN Down = -1
   IF XKey(MPlayerC(Index).Brake) THEN Brake = -1
   IF XKey(MPlayerC(Index).Shoot) THEN Shoot = -1
   IF XKey(&H1) THEN Quit = -1: TX.CLS: TX.Print "Escape pressed."
  ELSE
   DIM Temp AS INTEGER
   DIM SDataG AS STRING * 1
   DIM RDataG AS STRING * 1
   Temp = 0
  SELECT CASE Control(Index)
   CASE CONTRL.HERE
    IF XKey(SPlayerC.Left) THEN Left = -1
    IF XKey(SPlayerC.Right) THEN Right = -1
    IF XKey(SPlayerC.Up) THEN Up = -1
    IF XKey(SPlayerC.Down) THEN Down = -1
    IF XKey(SPlayerC.Brake) THEN Brake = -1
    IF XKey(SPlayerC.Shoot) THEN Shoot = -1
    IF XKey(&H1) THEN Quit = -1
    IF Left AND Right THEN Left = 0: Right = 0
    IF Up AND Down THEN Up = 0: Down = 0
    IF Left THEN Temp = Temp OR 1
    IF Right THEN Temp = Temp OR 2
    IF Up THEN Temp = Temp OR 4
    IF Down THEN Temp = Temp OR 8
    IF Brake THEN Temp = Temp OR 16
    IF Shoot THEN Temp = Temp OR 64
    IF Quit THEN Temp = 0: Temp = Temp OR 1: Temp = Temp OR 2: CLS
    SDataG = CHR$(Temp)
    ' Send controls to be processed in other players CONTRL.THERE thingo
    lag# = TIMER
    SELECT CASE MIPX.TCP.MODEM
     CASE MPLAY.IPX     ' Send Control data via IPX/SPX
       SendInUseFlag = ASC(ECBS.InUse)
       IF SendInUseFlag = 0 THEN
        IF Quit THEN
         IPXS.Checksum = 0
         IPXS.Length = LEN(IPXS)
         IPXS.Control = CHR$(0)
         IPXS.PacketType = CHR$(0)
         IPXS.DestNet = DNet$
         IPXS.DestNode = DNode$
         IPXS.DestSocket = MKI$(Send)
         IPXS.SourSock = MKI$(1)
         IPXS.Datagram = CHR$(Temp)
             
         ECBS.SockNum = Send
         ECBS.ImmAdd = DIAdd$
         ECBS.FragCount = 1
         ECBS.FragAddOfs = VARPTR(IPXS)
         ECBS.FragAddSeg = VARSEG(IPXS)
         ECBS.FragSize = LEN(IPXS)
         DO
          CALL SendPacket(CompleteCode, SendInUseFlag)
          SendInUseFlag = ASC(ECBS.InUse)
          DO
           CALL RelenquishControl
           SendInUseFlag = ASC(ECBS.InUse)
           IF TIMER - lag# > 3 THEN TX.CLS: TX.Print "Error, Aborting due to lag": Quit = -1: EXIT SUB
          LOOP WHILE SendInUseFlag = &HFF
         LOOP WHILE SendInUseFlag <> 0
         SendInUseFlag = ASC(ECBS.InUse)
        
         CALL IPXDisconnect(DNet$, DNode$, DSock$)
         TX.CLS
         TX.Print "Escape pressed."
         Quit = -1: EXIT SUB
        END IF
             
        IPXS.Checksum = 0
        IPXS.Length = LEN(IPXS)
        IPXS.Control = CHR$(0)
        IPXS.PacketType = CHR$(0)
        IPXS.DestNet = DNet$
        IPXS.DestNode = DNode$
        IPXS.DestSocket = MKI$(Send)
        IPXS.SourSock = MKI$(1)
        IPXS.Datagram = SDataG
             
        ECBS.SockNum = Send
        ECBS.ImmAdd = DIAdd$
        ECBS.FragCount = 1
        ECBS.FragAddOfs = VARPTR(IPXS)
        ECBS.FragAddSeg = VARSEG(IPXS)
        ECBS.FragSize = LEN(IPXS)
              
        DO
         CALL SendPacket(CompleteCode, SendInUseFlag)
         SendInUseFlag = ASC(ECBS.InUse)
         DO
          CALL RelenquishControl
          SendInUseFlag = ASC(ECBS.InUse)
         LOOP WHILE SendInUseFlag = &HFF
         SendInUseFlag = ASC(ECBS.InUse)
        LOOP WHILE SendInUseFlag <> 0
        CALL IPXCancelS(CompleteCode%)
       ELSE
        Up = 0: Down = 0: Right = 0: Left = 0: Brake = 0: Shoot = 0
      END IF
     CASE MPLAY.TCP
     CASE MPLAY.MODEM
    END SELECT
   CASE CONTRL.THERE
    ' Recive controls from other players CONTRL.HERE thingo
    lag# = TIMER
    SELECT CASE MIPX.TCP.MODEM
     CASE MPLAY.IPX
     
      okflag = 0
      DO
       ListenInUseFlag = ASC(ECBR.InUse)
       RDataG = IPXR.Datagram
       IF ListenInUseFlag = 0 THEN
        IF RDataG = CHR$(255) THEN
          Quit = -1
         ELSE
          G$ = RDataG
          okflag = -1
        END IF
       
        ECBR.SockNum = Listen
        ECBR.FragCount = 1
        ECBR.FragAddOfs = VARPTR(IPXR)
        ECBR.FragAddSeg = VARSEG(IPXR)
        ECBR.FragSize = LEN(IPXR)
        CALL SocketListen
       END IF
      IF TIMER - lag# > 3 THEN TX.CLS: TX.Print "Error, Aborting Due to lag.": Quit = -1: EXIT SUB
      LOOP UNTIL okflag
         
     CASE MPLAY.TCP
     CASE MPLAY.MODEM
    END SELECT
    ' Process information
    G$ = LTRIM$(RTRIM$(RDataG))
   
    DEF SEG = VARSEG(G$)
     Temp = PEEK(SADD(G$)): DEF SEG
   
    'IF g$ = CHR$(0) THEN temp = 0 ELSE temp = ASC(g$)
    IF Temp AND 1 THEN Left = -1
    IF Temp AND 2 THEN Right = -1
    IF Temp AND 4 THEN Up = -1
    IF Temp AND 8 THEN Down = -1
    IF Temp AND 16 THEN Brake = -1
    IF Temp AND 64 THEN Shoot = -1
    IF (Temp AND 1) AND (Temp AND 2) THEN Quit = -1
    
  END SELECT
 END IF
END SUB

SUB HandleCBExp (cbm AS INTEGER, X%, Y%)
 C = 0
 FOR I = 1 TO 360 STEP 45
  CBomb(cbm).Object.Ang = I
  PRJ.AddProjectile CMiniBomb(), CBomb(cbm).Object, CMiniBombTemplate, MAXCMINIBOMBS
 NEXT I
END SUB

SUB HandleRML5K
 DIM Temp AS Object2D
 FOR I = 1 TO MAXRML5K
  IF Rml5K(I).Active THEN
   Rml5K(I).Object.Ang = ((Rml5K(I).Object.Ang + 1) MOD 360)
   IF INT(RND * 50) = 30 THEN
    Temp = Rml5K(I).Object
    FOR A = 1 TO 360 STEP 90
     Temp.Ang = ((Rml5K(I).Object.Ang + 55 + A) MOD 360)
     Temp.AngOff = 90
     PRJ.AddProjectile Rml5KMini(), Temp, Rml5KMiniTemplate, MAXRMLMINIS
    NEXT A
    friq& = 22020
    DS4QB.PlaySoundEx 5, 22050, CURRENT, CURRENT, CURRENT
   END IF
  END IF
 NEXT I
END SUB

DEFLNG A-Z
FUNCTION LineCollide% (Object AS Object2D, Object2 AS Object2D, Line1 AS tLine, Line2 AS tLine, Cx%, Cy%)

 DIM M1 AS INTEGER, M2 AS INTEGER
 DIM X AS LONG, Y AS LONG
 DIM X1 AS LONG, Y1 AS LONG, X2 AS LONG, Y2 AS LONG
 DIM X3 AS LONG, Y3 AS LONG, X4 AS LONG, Y4 AS LONG

 X1 = (Line1.X1 * Object.Scale) + Object.X: X2 = (Line1.X2 * Object.Scale) + Object.X
 Y1 = (Line1.Y1 * Object.Scale) + Object.Y: Y2 = (Line1.Y2 * Object.Scale) + Object.Y
 X3 = (Line2.X1 * Object2.Scale) + Object2.X: X4 = (Line2.X2 * Object2.Scale) + Object2.X
 Y3 = (Line2.Y1 * Object2.Scale) + Object2.Y: Y4 = (Line2.Y2 * Object2.Scale) + Object2.Y

 IF X1 = X2 THEN X1 = X1 - 1: X2 = X2 + 1 ' Do corrections for othagonal lines
 IF Y1 = Y2 THEN Y1 = Y1 - 1: Y2 = Y2 + 1
 IF X3 = X4 THEN X3 = X3 - 1: X4 = X4 + 1
 IF Y3 = Y4 THEN Y3 = Y3 - 1: Y4 = Y4 + 1

 IF Y2 - Y1 <> 0 AND X2 - X1 <> 0 THEN M1 = ((Y2 - Y1)) / ((X2 - X1))
 IF Y4 - Y3 <> 0 AND X4 - X3 <> 0 THEN M2 = ((Y4 - Y3)) / ((X4 - X3))

 IF M1 - M2 = 0 THEN EXIT FUNCTION

 X = (Y3 - M2 * X3 + M1 * X1 - Y1) / (M1 - M2)
 Y = (X3 * M1 * M2 - Y3 * M1 + Y1 * M2 - X1 * M1 * M2) / (M2 - M1)

 L1x1 = X1: L1x2 = X2: IF L1x1 > L1x2 THEN SWAP L1x1, L1x2
 L2x1 = X3: L2x2 = X4: IF L2x1 > L2x2 THEN SWAP L2x1, L2x2
 L1y1 = Y1: L1y2 = Y2: IF L1y1 > L1y2 THEN SWAP L1y1, L1y2
 L2y1 = Y3: L2y2 = Y4: IF lLy1 > L2y2 THEN SWAP L2y1, L2y2

 IF X >= L1x1 AND X <= L1x2 AND Y >= L1y1 AND Y <= L1y2 AND X >= L2x1 AND X <= L2x2 AND Y >= L2y1 AND Y <= L2y2 THEN
   Cx% = X: Cy% = Y
   LineCollide = -1
 END IF

END FUNCTION

DEFINT A-Z
SUB LOAD.InitVideo

 FOR I = 1 TO 32
  R = I * 2
  IF R > 63 THEN R = 63
  CSSetCol I, R, 0, 0
 NEXT I
 FOR I = 1 TO 16
  CSSetCol I + 32, 63, (I * 4), 0
  CSSetCol I + 32 + 16, 63, 63, (I * 4)
 NEXT I
 FOR I = 0 TO 63
  CSSetCol I + 64, 0, I, 0
  CSSetCol I + 128, 0, 0, I
  CSSetCol I + 192, I, I, I
 NEXT I
 
 CSSetCol 254, 63, 63, 63
 CSSetCol 255, 63, 63, 63

 CSGetPal XPal

END SUB

SUB LOAD.LoadINI
 F = FREEFILE
 OPEN "XGMAE.INF" FOR INPUT AS #F
  INPUT #F, MPlay.LevelName
  INPUT #F, SPlayerC.Left, SPlayerC.Right, SPlayerC.Up
  INPUT #F, SPlayerC.Down, SPlayerC.Brake, SPlayerC.Shoot
  FOR I = 1 TO 2
   INPUT #F, MPlayerC(I).Left, MPlayerC(I).Right, MPlayerC(I).Up
   INPUT #F, MPlayerC(I).Down, MPlayerC(I).Brake, MPlayerC(I).Shoot
  NEXT I
 CLOSE #F
END SUB

SUB LOAD.LoadModels

 dIs(1) = 1: dIs(2) = 2
 dIs(3) = 3: dIs(4) = 4
 dIs(5) = 5: dIs(6) = 6
 dIs(7) = 7: dIs(8) = 8
 dIs(9) = 9: dIs(10) = 10
 dIs(11) = 11: dIs(12) = 12
 dIs(13) = 16: dIs(14) = 14
 dIs(15) = 15: dIs(16) = 13
 dIs(17) = 17: dIs(18) = 18
 dIs(19) = 19: dIs(20) = 20
 dIs(21) = 21: dIs(22) = 22
 dIs(23) = 23: dIs(24) = 24
 dIs(25) = 25: dIs(26) = 26
 dIs(27) = 27: dIs(28) = 28
 dIs(29) = 29: dIs(30) = 30

 SprOff(dIs(1)) = (dIs(1) * 64004)
 SprOff(dIs(2)) = (dIs(2) * 64004)
 SprOff(dIs(3)) = (dIs(3) * 64004)
 SprOff(dIs(5)) = (dIs(5) * 64004)
 SprOff(dIs(7)) = (dIs(7) * 64004)
 SprOff(dIs(13)) = (dIs(13) * 64004)
 SprOff(dIs(15)) = (dIs(15) * 64004)
 SprOff(dIs(16)) = (dIs(16) * 64004)
 SprOff(dIs(19)) = (dIs(19) * 64004)
 SprOff(dIs(20)) = (dIs(20) * 64004)
 SprOff(dIs(21)) = (dIs(21) * 64004)
 SprOff(dIs(24)) = (dIs(24) * 64004)
 SprOff(dIs(26)) = (dIs(26) * 64004)
 SprOff(dIs(27)) = (dIs(27) * 64004)
 SprOff(dIs(30)) = (dIs(30) * 64004)
 SprOff(127) = 127 * 64004
 
 DEF SEG = VARSEG(SprBuff(0))
  BLOAD "Graphics\Bitmaps\Ship.BSV", 0:     CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(1)), 64004
  BLOAD "Graphics\Bitmaps\Asteriod.BSV", 0: CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(2)), 64004
  BLOAD "Graphics\Bitmaps\Missile.BSV", 0:  CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(3)), 64004
  BLOAD "Graphics\Bitmaps\CBomb.BSV", 0:    CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(5)), 64004
  BLOAD "Graphics\Bitmaps\Mini.BSV", 0:     CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(7)), 64004
  BLOAD "Graphics\Bitmaps\Ufo.BSV", 0:      CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(13)), 64004
  BLOAD "Graphics\Bitmaps\Turret.BSV", 0:   CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(15)), 64004
  BLOAD "Graphics\Bitmaps\Ufo2.BSV", 0:     CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(16)), 64004
  BLOAD "Graphics\Bitmaps\PwrupC.BSV", 0:   CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(19)), 64004
  BLOAD "Graphics\Bitmaps\PwrupH.BSV", 0:   CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(20)), 64004
  BLOAD "Graphics\Bitmaps\PwrupF.BSV", 0:   CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(21)), 64004
  BLOAD "Graphics\Bitmaps\PwrupL.BSV", 0:   CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(24)), 64004
  BLOAD "Graphics\Bitmaps\Boss1.BSV", 0:    CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(26)), 64004
  BLOAD "Graphics\Bitmaps\Debris.BSV", 0:   CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(27)), 64004
  BLOAD "Graphics\Bitmaps\Turret2.BSV", 0:  CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(dIs(30)), 64004
  BLOAD "Graphics\Bitmaps\HUD.BSV", 0:      CSMoveToXMS VARSEG(SprBuff(0)), 0, SprHandle, SprOff(127), 64004
 DEF SEG
 
 LoadXSP "Ship.XSP", dIs(1)
 LoadXSP "Asteriod.XSP", dIs(2)
 LoadXSP "Missile.XSP", dIs(3)
 LoadXSP "Laser.XSP", dIs(4)
 LoadXSP "CBomb.XSP", dIs(5)
 LoadXSP "Beam.XSP", dIs(6)
 LoadXSP "Mini.XSP", dIs(7)
 LoadXSP "Rml5K.XSP", dIs(8)
 LoadXSP "Flag1.XSP", dIs(10)
 LoadXSP "Flag2.XSP", dIs(11)
 LoadXSP "Star4.XSP", dIs(12)
 LoadXSP "Ufo.XSP", dIs(13)
 LoadXSP "LLaser.XSP", dIs(14)
 LoadXSP "Turret.XSP", dIs(15)
 LoadXSP "Ufo2.XSP", dIs(16)
 LoadXSP "PWRupM.XSP", dIs(17)
 LoadXSP "PWRupN.XSP", dIs(18)
 LoadXSP "PWRupC.XSP", dIs(19)
 LoadXSP "PWRupH.XSP", dIs(20)
 LoadXSP "PWRupF.XSP", dIs(21)
 LoadXSP "PWRupMI.XSP", dIs(22)
 LoadXSP "PWRupR.XSP", dIs(23)
 LoadXSP "PWRupL.XSP", dIs(24)
 LoadXSP "Ufo3.XSP", dIs(25)
 LoadXSP "Boss1.XSP", dIs(26)
 LoadXSP "Debris.XSP", dIs(27)
 LoadXSP "Station.XSP", dIs(28)
 LoadXSP "Ufo4.XSP", dIs(29)
 LoadXSP "Turret2.XSP", dIs(30)

END SUB

SUB LOAD.MemSetup
 IF CSDetectEMS = 0 THEN
  PRINT "Sorry, the EMS manager is not running.": END
 END IF

 IF CSDetectXMS = 0 THEN
  PRINT "Sorry, the XMS manager is not running.": END
 END IF

 EMSPages = 8
 EMS.Handle = CSAllocateEMS(EMSPages)
 IF EMS.Handle = 0 THEN
  PRINT "Sorry, this programm requires atleast"; (EMSPages * 16); "kb of EMS memory.": END
 END IF

 SprHandle = CSAllocateXMS(8192)
 IF SprHandle = 0 THEN
  PRINT "Sorry, this program requires atleast 8MB of XMS memory to run.": END
 END IF

 EMS.Layer = CSGetEMSFrame

 CSMapEMSLayer EMS.Handle, 0
 CSClear EMS.Layer, 0
 CSMapEMSLayer EMS.Handle, 4
 CSClear EMS.Layer, 0
END SUB

SUB LOAD.SetUpModels

 MyShip.Model = dIs(1)
 MyShip.Sprite = -1
 O2D.GetRadius MyShip
 
 Ufo.Model = dIs(13)
 Ufo.Sprite = -1
 O2D.GetRadius Ufo
 Ufo.Scale = .25
 Ufo.Speed = 4
 Ufo.Colour = 120

 Stars(1).Model = dIs(12)
 O2D.GetRadius Stars(1)
 Stars(1).Scale = .25

 FOR I = 1 TO MAXSTARS
  Stars(I) = Stars(1)
 NEXT

 Arena.Model = dIs(9)
 Arena.Radius = 1000
 Arena.Scale = 1
 Arena.X = 160
 Arena.Y = 100
 Arena.Colour = 250
 
 Asteriods(1).Model = dIs(2)
 Asteriods(1).Sprite = -1
 O2D.GetRadius Asteriods(1)

 FOR I = 1 TO 2
  Flags(I).Model = dIs(9 + I)
  Flags(I).Scale = .25
  Flags(I).Speed = 0
  O2D.GetRadius Flags(I)
 NEXT

 Flags(1).Colour = 4
 Flags(2).Colour = 12
 MyShip.Colour = 255
 
 MissileTemplate.Object.AngOff = 90
 MissileTemplate.Object.Model = dIs(3)
 MissileTemplate.Object.Scale = .55
 MissileTemplate.Object.Speed = 4
 MissileTemplate.Object.Sprite = -1
 O2D.GetRadius MissileTemplate.Object
 MissileTemplate.Trail = 1
 MissileTemplate.Accelerate = .1
 MissileTemplate.Si = 1
 MissileTemplate.Object.Colour = 255
 MissileTemplate.Damage = 3
 
 LaserTemplate.Object.AngOff = 90
 LaserTemplate.Object.Model = dIs(4)
 LaserTemplate.Object.Scale = .5
 LaserTemplate.Object.Speed = 9
 O2D.GetRadius LaserTemplate.Object
 LaserTemplate.Si = 2
 LaserTemplate.Object.Colour = 160
 LaserTemplate.Damage = 0
 
 CBombTemplate.Object.AngOff = 90
 CBombTemplate.Object.Model = dIs(5)
 CBombTemplate.Object.Scale = .2
 CBombTemplate.Object.Speed = 3
 CBombTemplate.Object.Sprite = -1
 O2D.GetRadius CBombTemplate.Object
 CBombTemplate.Rotate = 6
 CBombTemplate.Si = 1
 CBombTemplate.Object.Colour = 240
 CBombTemplate.Damage = 10
 
 CMiniBombTemplate.Object.AngOff = 90
 CMiniBombTemplate = CBombTemplate
 CMiniBombTemplate.Object.Scale = .1
 CMiniBombTemplate.Object.Speed = 3
 CMiniBombTemplate.Si = 4
 CMiniBombTemplate.Object.Colour = 230
 CMiniBombTemplate.Damage = 3
 
 BeamTemplate.Object.AngOff = 90
 BeamTemplate.Object.Model = dIs(6)
 BeamTemplate.Object.Scale = .5
 BeamTemplate.Object.Speed = 2
 BeamTemplate.Accelmult = -1
 O2D.GetRadius BeamTemplate.Object
 BeamTemplate.Si = 5
 BeamTemplate.Object.Colour = 32
 BeamTemplate.Damage = 1
 
 MineTemplate.Object.AngOff = 90
 MineTemplate.Object.Model = dIs(5)
 MineTemplate.Object.Scale = .1
 MineTemplate.Object.Speed = 0
 MineTemplate.Object.Sprite = -1
 O2D.GetRadius MineTemplate.Object
 MineTemplate.Rotate = 2
 MineTemplate.DepAng = 180
 MineTemplate.Si = 3
 MineTemplate.Object.Colour = 230
 MineTemplate.Damage = 3
 
 MiniTemplate.Object.AngOff = 90
 MiniTemplate.Object.Model = dIs(7)
 MiniTemplate.Object.Scale = .5
 MiniTemplate.Object.Speed = 6
 MiniTemplate.Object.Sprite = -1
 O2D.GetRadius MiniTemplate.Object
 MiniTemplate.Trail = -1
 MiniTemplate.Si = 6
 MiniTemplate.Object.Colour = 255
 MiniTemplate.Damage = 6
 
 Rml5KMiniTemplate = MiniTemplate
 
 Rml5KTemplate.Object.AngOff = 90
 Rml5KTemplate.Object.Model = dIs(8)
 Rml5KTemplate.Object.Scale = .2
 Rml5KTemplate.Object.Speed = 1
 O2D.GetRadius Rml5KTemplate.Object
 Rml5KTemplate.Rotate = 10
 Rml5KTemplate.Si = 7
 Rml5KTemplate.Object.Colour = 90
 Rml5KTemplate.Damage = 10
 
 LLaserTemplate.Object.AngOff = 90
 LLaserTemplate.Object.Model = dIs(14)
 LLaserTemplate.Object.Scale = .15
 LLaserTemplate.Object.Speed = 5
 O2D.GetRadius LLaserTemplate.Object
 LLaserTemplate.Si = 2
 LLaserTemplate.Object.Colour = 20
 LLaserTemplate.Damage = 1
 LLaserTemplate.Trail = -2
 LLaserTemplate.Invisible = -1
 
 ' Setup for Enemy's //-----------------------------------------------//
 
 EnemyTemplate(1).Object = Asteriods(1)   '   Large asteriod
 EnemyTemplate(1).Object.Scale = .5
 EnemyTemplate(1).Object.Colour = 240
 EnemyTemplate(1).MHp = 5: EnemyTemplate(1).Hp = EnemyTemplate(1).MHp
 EnemyTemplate(1).Score = 10
 EnemyTemplate(1).Ai = 1
 
 EnemyTemplate(2) = EnemyTemplate(1)      '   Small asteriod
 EnemyTemplate(2).Score = 5
 EnemyTemplate(2).Object.Scale = .25
 EnemyTemplate(2).MHp = 3: EnemyTemplate(2).Hp = EnemyTemplate(2).MHp

 EnemyTemplate(3).Score = 20              '   Green ship
 EnemyTemplate(3).Object = Ufo
 EnemyTemplate(3).MHp = 4: EnemyTemplate(3).Hp = EnemyTemplate(3).MHp
 EnemyTemplate(3).Ai = 2
 EnemyTemplate(3).Trail = Green

 EnemyTemplate(4).Score = 40             '    Blaster Turret
 EnemyTemplate(4).Object.Model = dIs(15)
 EnemyTemplate(4).Object.AngOff = 90
 EnemyTemplate(4).Object.Sprite = -1
 O2D.GetRadius EnemyTemplate(4).Object
 EnemyTemplate(4).Object.Colour = 240
 EnemyTemplate(4).Object.Scale = .25
 EnemyTemplate(4).MHp = 7: EnemyTemplate(4).Hp = EnemyTemplate(4).MHp
 EnemyTemplate(4).Ai = 4
 
 EnemyTemplate(5).Score = 20             '    Blue missile ship
 EnemyTemplate(5).Object.Model = dIs(16)
 EnemyTemplate(5).Object.Sprite = -1
 O2D.GetRadius EnemyTemplate(5).Object
 EnemyTemplate(5).Object.Scale = .25
 EnemyTemplate(5).MHp = 5: EnemyTemplate(5).Hp = EnemyTemplate(5).MHp
 EnemyTemplate(5).Ai = 5
 EnemyTemplate(5).Trail = Blue
 EnemyTemplate(5).Object.Colour = 191

 EnemyTemplate(6).Score = 25             '    Drill Ship
 EnemyTemplate(6).Object.Model = dIs(25)
 O2D.GetRadius EnemyTemplate(6).Object
 EnemyTemplate(6).Object.Scale = .15
 EnemyTemplate(6).MHp = 5: EnemyTemplate(6).Hp = EnemyTemplate(6).MHp
 EnemyTemplate(6).Ai = 6
 EnemyTemplate(6).Trail = Green
 EnemyTemplate(6).Object.Colour = 127
 
 EnemyTemplate(7).Score = 100            '    Boss 1
 EnemyTemplate(7).Object.Model = dIs(26)
 EnemyTemplate(7).Object.Sprite = -1
 O2D.GetRadius EnemyTemplate(7).Object
 EnemyTemplate(7).Object.Scale = .6
 EnemyTemplate(7).MHp = 50: EnemyTemplate(7).Hp = EnemyTemplate(7).MHp
 EnemyTemplate(7).Ai = 7
 EnemyTemplate(7).Trail = Red
 EnemyTemplate(7).Object.Colour = 32
 EnemyTemplate(7).Object.AngOff = 180
 EnemyTemplate(7).TurnSpeed = 15

 EnemyTemplate(8).Score = 35             '    Blue missile/destroyer
 EnemyTemplate(8).Object.Model = dIs(29)
 O2D.GetRadius EnemyTemplate(8).Object
 EnemyTemplate(8).Object.Scale = .25
 EnemyTemplate(8).MHp = 10: EnemyTemplate(8).Hp = EnemyTemplate(8).MHp
 EnemyTemplate(8).Ai = 8
 EnemyTemplate(8).Trail = Blue
 EnemyTemplate(8).Object.Colour = 191
 EnemyTemplate(8).TurnSpeed = 13

 EnemyTemplate(9).Score = 50             '    Missile Turret
 EnemyTemplate(9).Object.Model = dIs(30)
 EnemyTemplate(9).Object.AngOff = 90
 EnemyTemplate(9).Object.Sprite = -1
 O2D.GetRadius EnemyTemplate(9).Object
 EnemyTemplate(9).Object.Colour = 240
 EnemyTemplate(9).Object.Scale = .25
 EnemyTemplate(9).MHp = 12: EnemyTemplate(9).Hp = EnemyTemplate(9).MHp
 EnemyTemplate(9).Ai = 9
 
 ' Setup for Enemy's //-----------------------------------------------//

 ' Setup for powerup's //---------------------------------------------//

 PowerUpTemplate(1).Object.Model = dIs(17)  ' Missile Ammo
 O2D.GetRadius PowerUpTemplate(1).Object
 PowerUpTemplate(1).WeaponN = 2
 PowerUpTemplate(1).Ammo = 1
 
 PowerUpTemplate(2).Object.Model = dIs(18)  ' Mine's
 PowerUpTemplate(2).Object.Radius = PowerUpTemplate(1).Object.Radius
 PowerUpTemplate(2).WeaponN = 3
 PowerUpTemplate(2).Ammo = 2

 PowerUpTemplate(3).Object.Model = dIs(19)  ' Cluster Bomb
 PowerUpTemplate(3).Object.Sprite = -1
 PowerUpTemplate(3).Object.Radius = PowerUpTemplate(1).Object.Radius
 PowerUpTemplate(3).WeaponN = 4
 PowerUpTemplate(3).Ammo = 1

 PowerUpTemplate(4).Object.Model = dIs(21)  ' Freze laser
 PowerUpTemplate(4).Object.Sprite = -1
 PowerUpTemplate(4).Object.Radius = PowerUpTemplate(1).Object.Radius
 PowerUpTemplate(4).WeaponN = 5
 PowerUpTemplate(4).Ammo = 3

 PowerUpTemplate(5).Object.Model = dIs(20)  ' Hypr Beam
 PowerUpTemplate(5).Object.Sprite = -1
 PowerUpTemplate(5).Object.Radius = PowerUpTemplate(1).Object.Radius
 PowerUpTemplate(5).WeaponN = 6
 PowerUpTemplate(5).Ammo = 2

 PowerUpTemplate(6).Object.Model = dIs(22)  ' Mini Ammo
 PowerUpTemplate(6).Object.Radius = PowerUpTemplate(1).Object.Radius
 PowerUpTemplate(6).WeaponN = 7
 PowerUpTemplate(6).Ammo = 3

 PowerUpTemplate(7).Object.Model = dIs(23)  ' RML 5000 Drone
 PowerUpTemplate(7).Object.Radius = PowerUpTemplate(1).Object.Radius
 PowerUpTemplate(7).WeaponN = 8
 PowerUpTemplate(7).Ammo = 1

 PowerUpTemplate(8).Object.Model = dIs(24)  ' Extra Life
 PowerUpTemplate(8).Object.Sprite = -1
 PowerUpTemplate(8).Object.Radius = PowerUpTemplate(1).Object.Radius
 PowerUpTemplate(8).Ammo = 1

 ' Setup for powerup's //---------------------------------------------//

END SUB

SUB LOAD.SinCosTables

 BColourLut(Red) = 0
 BColourLut(Green) = 63
 BColourLut(Blue) = 127
 BColourLut(Grey) = 191

 FOR I = 0 TO 360
  Cosine(I) = COS(I * (PI / 180))
  Sine(I) = SIN(I * (PI / 180))
 NEXT I

 AngStep(0) = 360
 FOR I = 1 TO 25
  AngStep(I) = ((PI * (I + I)) / 360) + 1
 NEXT

 FOR I = 1 TO 25
  FOR J = 0 TO I
  NEXT
 NEXT

 FOR I = 0 TO 359
  FOR J = 1 TO 50
   CosSize(J, I) = Cosine(I + 1) * J
   SinSize(J, I) = Sine(I + 1) * J
  NEXT
 NEXT

END SUB

SUB LoadMPlayLevel (FileName AS STRING)
 F = FREEFILE
 OPEN "Levels\Mplayer\" + FileName FOR INPUT AS #F
  INPUT #F, Header$
  IF Header$ <> "-|XGMAEml|-" THEN CLOSE #F: EXIT SUB
  INPUT #F, MPlay.Name
  INPUT #F, MPlay.XSPFile
  INPUT #F, MPlay.GameType
  INPUT #F, MPlaySpawnPoints.X1, MPlaySpawnPoints.Y1
  INPUT #F, MPlaySpawnPoints.X2, MPlaySpawnPoints.Y2
  INPUT #F, MPlay.TimeLimit
  INPUT #F, MPlay.ScoreLimit
 CLOSE #F
 LoadXSP MPlay.XSPFile, Arena.Model
 Flags(1).X = MPlaySpawnPoints.X1: Flags(1).Y = MPlaySpawnPoints.Y1
 Flags(2).X = MPlaySpawnPoints.X2: Flags(2).Y = MPlaySpawnPoints.Y2
 FOR I = 1 TO LEN(MPlay.Name)
  C$ = MID$(MPlay.Name, I, 1)
  SELECT CASE C$
   CASE "a" TO "z", "A" TO "Z", "0" TO "9", "-"
   CASE ELSE: C$ = CHR$(32)
  END SELECT
  MID$(MPlay.Name, I, 1) = C$
 NEXT I
END SUB

DEFSNG A-Z
SUB LoadXSP (FileName AS STRING, Number AS INTEGER)
 F = FREEFILE
 OPEN "Graphics\Vectors\" + FileName FOR BINARY AS #F
  GET #F, , NofL(Number)
  FOR I = 1 TO NofL(Number)
   GET #F, , Shapes(Number, I)
  NEXT I
 CLOSE #F
END SUB

DEFINT A-Z
SUB MakeWeaponSound (WeaponSelect)
 SELECT CASE WeaponSelect
  CASE 0
   IF okflag THEN DS4QB.PlaySoundEx 6, 30000, CURRENT, CURRENT, CURRENT
  CASE 1
   IF okflag THEN DS4QB.PlaySoundEx 5, 11025, CURRENT, CURRENT, CURRENT
  CASE 2
   IF okflag THEN DS4QB.PlaySoundEx 7, 22050, CURRENT, CURRENT, CURRENT
  CASE 3
   IF okflag THEN DS4QB.PlaySoundEx 7, CURRENT, CURRENT, CURRENT, CURRENT
  CASE 4
   IF okflag THEN DS4QB.PlaySoundEx 6, CURRENT, CURRENT, CURRENT, CURRENT
  CASE 5
   IF okflag THEN DS4QB.PlaySoundEx 8, CURRENT, CURRENT, CURRENT, CURRENT
  CASE 6
   IF okflag THEN DS4QB.PlaySoundEx 5, 22050, CURRENT, CURRENT, CURRENT
  CASE 7
   IF okflag THEN DS4QB.PlaySoundEx 7, CURRENT, CURRENT, CURRENT, CURRENT
 END SELECT
END SUB

SUB MENU.MP.CType
 sel = 1
 SelI = 8

 IPX = IPXInstalled%

 st# = TIMER

 CSSetTimer 0, 25

 DO
  CSWaitTimer 0
  CSClear EMS.Layer, 0

  DoStars
  PRT.MoveAndDrawParticles

  Explosions st#

  TX.Locate 10

   TX.CPrint "     MethodĿ      "
   TX.CPrint "Ŀ"
  FOR D = 1 TO 5
   TX.CPrint "                   "
  NEXT
   TX.CPrint ""

  TX.Locate 12

  Text.Colour = 255: TX.CPrint " Two on One PC   "
  Text.Colour = 220: IF IPX THEN Text.Colour = 255
                     TX.CPrint " IPX/SPX         "
  Text.Colour = 220: TX.CPrint " TCP/IP          "
  Text.Colour = 220: TX.CPrint " Modem           "
  Text.Colour = 255: TX.CPrint " Back            "

  SelA = SelI + (10 * 8)
  CSBox EMS.Layer, 92, SelA - 1, 92 + 136, SelA + 8, 32
 
  K$ = ""
  FOR I = 1 TO 16
   G$ = UCASE$(INKEY$)
   IF G$ <> "" AND TIMER - pauseK# > .1 THEN K$ = G$: pauseK# = TIMER
  NEXT I
 
  SELECT CASE K$
   CASE CHR$(0) + "P"
    sel = sel + 1
    IF sel > 5 THEN sel = 1
    DS4QB.PlaySoundEx 7, 44050, CURRENT, CURRENT, CURRENT
   CASE CHR$(0) + "H"
    sel = sel - 1
    IF sel < 1 THEN sel = 5
    DS4QB.PlaySoundEx 7, 44050, CURRENT, CURRENT, CURRENT
   CASE CHR$(13), CHR$(32):
    SELECT CASE sel
     CASE 1
      DS4QB.PlaySoundEx 4, 22050, CURRENT, CURRENT, CURRENT
      MIPX.TCP.MODEM = MPLAY.SAMECOMP
      GAME.MultyPlayer
     CASE 2
      IF IPX THEN
        DS4QB.PlaySoundEx 4, 22050, CURRENT, CURRENT, CURRENT
        MIPX.TCP.MODEM = MPLAY.IPX
        GAME.MultyPlayer
       ELSE
        DS4QB.PlaySoundEx 3, 44050, CURRENT, CURRENT, CURRENT
      END IF
     CASE 5
      DS4QB.PlaySoundEx 4, 22050, CURRENT, CURRENT, CURRENT
      EXIT SUB
     CASE ELSE
      DS4QB.PlaySoundEx 3, 44050, CURRENT, CURRENT, CURRENT
     END SELECT
   CASE CHR$(27): sel = 5
  END SELECT

  IF sel * 8 > SelI THEN SelI = SelI + MenuStep
  IF sel * 8 < SelI THEN SelI = SelI - MenuStep
   
  CSPcopy EMS.Layer, &HA000
 LOOP
END SUB

SUB MENU.MultyPlayer
 DIM Temp AS STRING * 14
 FileLists FListS(), NumFiles, "-|XGMAEml|-"

 sel = 1
 st# = TIMER

 SelI = 8

 CSSetTimer 0, 25

 DO
  CSWaitTimer 0

  IF oldsel <> sel THEN LoadMPlayLevel FListS(sel): MPlay.LevelName = FListS(sel)
  oldsel = sel

  CSClear EMS.Layer, 0
  DoStars
  PRT.MoveAndDrawParticles

  BBoxF64 EMS.Layer, 16, 36, 302, 180, 143

  Explosions st#

  TX.Locate 4

  TX.CPrint " LevelSelect "
  TX.CPrint "Ŀ"
  FOR D = 1 TO 17
   TX.CPrint "                                  "
  NEXT
  TX.CPrint ""

 K$ = ""
 FOR I = 1 TO 16
  G$ = UCASE$(INKEY$)
  IF G$ <> "" AND TIMER - pauseK# > .1 THEN K$ = G$: pauseK# = TIMER
 NEXT I

 TX.Locate 6

 Fview = sel - 9
 IF Fview > (NumFiles - 17) THEN Fview = (NumFiles - 17)
 IF Fview < 0 THEN Fview = 0

 Blaher = 0

 FOR I = 1 TO 17
  Temp = FListS(I + Fview)
  IF RTRIM$(Temp) <> "" THEN Temp = "   " + MID$(Temp, 1, INSTR(Temp, ".") - 1)
  IF sel = I + Fview THEN
   Blaher = I
   Ty = Text.y
  END IF
  CSPrint EMS.Layer, 20, Text.y, Temp, Text.Colour
  Text.y = Text.y + 8
 NEXT I

 IF Blaher THEN
  IF Blaher * 8 > SelI THEN SelI = SelI + MenuStep
  IF Blaher * 8 < SelI THEN SelI = SelI - MenuStep
  SelA = SelI + (4 * 8)
  BBoxF64 EMS.Layer, 19, SelA, 19 + 112, SelA + 7, 143
 END IF

 BBoxF64 EMS.Layer, 215 - (160 * .35 + 1), 92 - (100 * .35), 215 + (160 * .35 + 1), 92 + (100 * .35), 143

 Arena.Scale = .35: Arena.X = 215: Arena.Y = 92
 O2D.Draw Arena
 Arena.Scale = 1: Arena.X = 160: Arena.Y = 100

 CSBox EMS.Layer, 215 - (160 * .35), 92 - (100 * .35), 215 + (160 * .35), 92 + (100 * .35), 255

 CSPrint EMS.Layer, 20 * 8, 6 * 8, MPlay.Name, Text.Colour
 IF MPlay.GameType = MPLAYGT.DM THEN
   CSPrint EMS.Layer, 20 * 8, 18 * 8, "Death Match", Text.Colour
  ELSEIF MPlay.GameType = MPLAYGT.CTF THEN
   CSPrint EMS.Layer, 20 * 8, 18 * 8, "Capture The Flag", Text.Colour
 END IF
 IF MPlay.ScoreLimit <> -1 THEN
   CSPrint EMS.Layer, 20 * 8, 20 * 8, "Score Limit:" + STR$(MPlay.ScoreLimit), Text.Colour
  ELSE
   CSPrint EMS.Layer, 20 * 8, 20 * 8, "Score Limit: None", Text.Colour
 END IF
 IF MPlay.TimeLimit <> -1 THEN
   CSPrint EMS.Layer, 20 * 8, 21 * 8, "Time Limit:" + STR$(MPlay.TimeLimit), Text.Colour
  ELSE
   CSPrint EMS.Layer, 20 * 8, 21 * 8, "Time Limit: None", Text.Colour
 END IF

 SELECT CASE K$
  CASE CHR$(0) + "P"
   sel = sel + 1
   IF sel > NumFiles THEN sel = NumFiles
   DS4QB.PlaySoundEx 7, 44050, CURRENT, CURRENT, CURRENT
  CASE CHR$(0) + "H"
   sel = sel - 1
   IF sel < 1 THEN sel = 1
   DS4QB.PlaySoundEx 7, 44050, CURRENT, CURRENT, CURRENT
  CASE CHR$(32), CHR$(13)
   DS4QB.PlaySoundEx 4, 22050, CURRENT, CURRENT, CURRENT
   MENU.MP.CType
  CASE CHR$(27):
   DS4QB.PlaySoundEx 4, 22050, CURRENT, CURRENT, CURRENT
   EXIT SUB
  END SELECT

 CSPcopy EMS.Layer, &HA000
LOOP

END SUB

FUNCTION NumIZE (stringy$)
 FOR I = 1 TO CSLen(stringy$) / 8
  N = N + ASC(MID$(stringy$, I, 1))
 NEXT I
 NumIZE = N
END FUNCTION

FUNCTION NumToStr$ (Num AS DOUBLE)
 DIM tempS AS STRING * 5

 tempS = "0.000"
 blag$ = LTRIM$(STR$(Num))

 IF MID$(blag$, 1, 1) <> "." THEN MID$(tempS, 1, 1) = MID$(blag$, 1, 1): bi = 2 ELSE bi = 1

 FOR I = 3 TO LEN(blag$)
  bi = bi + 1
  MID$(tempS, I, 1) = MID$(blag$, bi, 1)
 NEXT I

 NumToStr$ = tempS
END FUNCTION

DEFSNG A-Z
SUB O2D.Check (Object AS Object2D)
 ta = ((Object.Ang + 720) MOD 360)
 Object.Ang = ta
 ta = ((Object.AngOff + 720) MOD 360)
 Object.AngOff = ta
END SUB

DEFINT A-Z
FUNCTION O2D.Collide (Object AS Object2D, Object2 AS Object2D, Cx%, Cy%)
DIM Temp AS tLine
DIM temp1 AS tLine
DIM Ang
DIM Ang2
RANDOMIZE TIMER
Ang = ((Object.Ang + Object.AngOff + (720 * 2)) MOD 360)
Ang2 = ((Object2.Ang + Object2.AngOff + (720 * 2)) MOD 360)
o = O2D.RadiusCollide(Object, Object2)
IF o = -1 THEN
 om = NofL(Object2.Model)
 FOR I = 1 TO NofL(Object.Model)
  FOR J = 1 TO om
   RotateLine Shapes(Object.Model, I), Temp, Ang
   RotateLine Shapes(Object2.Model, J), temp1, Ang2
   IF LineCollide(Object, Object2, Temp, temp1, Cx%, Cy%) THEN O2D.Collide = -1: EXIT FUNCTION
  NEXT J
 NEXT I
END IF
IF o = -2 THEN
 Cx% = Object.X
 Cy% = Object.Y
 O2D.Collide = -1
END IF
END FUNCTION

SUB O2D.Draw (Object AS Object2D)
 FOR I = 1 TO UBOUND(bObject)
  IF bObject(I).Used = 0 THEN bObject(I).Obj = Object: bObject(I).Used = -1: EXIT SUB
 NEXT
END SUB

REM $STATIC
SUB O2D.DrawReal (Object AS Object2D)
 DIM Temp AS tLine
 Ang = ((Object.Ang + Object.AngOff) MOD 360)

 IF Cam.Zoom < 1 THEN Cam.Zoom = 1

 C = Object.Colour
 IF C = 255 THEN C = 250
 IF C = 192 THEN C = 188
 IF C = 128 THEN C = 122
 IF C = 64 THEN C = 60

 IF SprOff(Object.Model) THEN
   CSMoveFromXMS VARSEG(SprBuff(0)), VARPTR(SprBuff(0)), SprHandle, SprOff(Object.Model), 64004
   OldBf1 = SprBuff(1)
   Size = (SprBuff(1) * Object.Scale) * Cam.Zoom
   IF Size AND 1 THEN Size = Size + 1
   X = ((Object.X * Cam.Zoom) - (Size \ 2)) - Cam.X
   Y = ((Object.Y * Cam.Zoom) - (Size \ 2)) - Cam.Y
   CSSpriteRZ EMS.Layer, X, Y, Size, Size, Ang, VARSEG(SprBuff(0)), VARPTR(SprBuff(0))
  ELSE
   FOR I = 1 TO NofL(Object.Model)
    RotateLine Shapes(Object.Model, I), Temp, Ang
    Temp.X1 = ((Object.X + (Temp.X1 * Object.Scale)) * Cam.Zoom) - Cam.X
    Temp.Y1 = ((Object.Y + (Temp.Y1 * Object.Scale)) * Cam.Zoom) - Cam.Y
    Temp.X2 = ((Object.X + (Temp.X2 * Object.Scale)) * Cam.Zoom) - Cam.X
    Temp.Y2 = ((Object.Y + (Temp.Y2 * Object.Scale)) * Cam.Zoom) - Cam.Y
    CSLine EMS.Layer, Temp.X1, Temp.Y1, Temp.X2, Temp.Y2, C
   NEXT I
 END IF
END SUB

REM $DYNAMIC
SUB O2D.GetRadius (Object AS Object2D)
 DIM L AS LONG
 DIM CurrentBest AS LONG
 DIM CurrentWorst AS LONG
 DIM Temp AS tLine
 CurrentWorst = 100000
 CurrentBest = Object.Radius
 J = Object.Model
 A = 45
  FOR I = 1 TO NofL(J)
   RotateLine Shapes(J, I), Temp, A
   L = SQR(CLNG(Temp.X1) * CLNG(Temp.X1) + CLNG(Temp.Y1) * CLNG(Temp.Y1))
   IF L > CurrentBest THEN CurrentBest = L
   IF L < CurrentWorst THEN CurrentWorst = L
   L = SQR(CLNG(Temp.X2) * CLNG(Temp.X2) + CLNG(Temp.Y2) * CLNG(Temp.Y2))
   IF L > CurrentBest THEN CurrentBest = L
   IF L < CurrentWorst THEN CurrentWorst = L
  NEXT I
 Object.Radius = CurrentBest
 Object.FillRadius = CurrentWorst * .9
 IF Object.Sprite THEN Object.Sprite = SprOff(Object.Model)
END SUB

SUB O2D.MTScreen (Object AS Object2D)
 IF Object.X > 320 + (Object.Scale * Object.Radius) THEN Object.X = 1 - (Object.Scale * Object.Radius): O2D.Propell Object, 1
 IF Object.X < 1 - (Object.Scale * Object.Radius) THEN Object.X = 320 + (Object.Scale * Object.Radius): O2D.Propell Object, 1
 IF Object.Y > 200 + (Object.Scale * Object.Radius) THEN Object.Y = 1 - (Object.Scale * Object.Radius): O2D.Propell Object, 1
 IF Object.Y < 1 - (Object.Scale * Object.Radius) THEN Object.Y = 200 + (Object.Scale * Object.Radius): O2D.Propell Object, 1
END SUB

SUB O2D.MTScreenAK (Object AS Object2D)
 IF Object.X > 319 + (Object.Scale * Object.Radius) THEN Object.X = 1 - (Object.Scale * Object.Radius)
 IF Object.X < 0 - (Object.Scale * Object.Radius) THEN Object.X = 320 + (Object.Scale * Object.Radius)
 IF Object.Y > 199 + (Object.Scale * Object.Radius) THEN Object.Y = 1 - (Object.Scale * Object.Radius)
 IF Object.Y < 0 - (Object.Scale * Object.Radius) THEN Object.Y = 200 + (Object.Scale * Object.Radius)
END SUB

SUB O2D.Propell (Object AS Object2D, Speed AS SINGLE)
 ta = ((Object.Ang + 720) MOD 360)
 IF ta = 0 THEN ta = 1
 Object.X = Object.X + (Speed * Cosine(ta))
 Object.Y = Object.Y + (Speed * Sine(ta))
END SUB

FUNCTION O2D.RadiusCollide (Object AS Object2D, Object2 AS Object2D)
DIM xv AS LONG
DIM yv AS LONG
DIM L AS INTEGER
xv = Object2.X - Object.X
yv = Object2.Y - Object.Y
L = SQR((xv) * (xv) + (yv) * (yv))
bla = Object.Radius <> 1000 AND Object2.Radius <> 1000
IF (((Object.Radius * 1.3) * Object.Scale) + ((Object2.Radius * 1.3) * Object2.Scale)) > L THEN
 IF ((Object.FillRadius * Object.Scale) + (Object2.FillRadius * Object2.Scale)) > L AND bla THEN
  O2D.RadiusCollide = -2
   ELSE
  O2D.RadiusCollide = -1
 END IF
END IF
END FUNCTION

SUB PRT.AddPart (X, Y, Xd AS SINGLE, Yd AS SINGLE, Size AS INTEGER, Ttl AS INTEGER, SetClr AS INTEGER, Colour AS INTEGER, Flags AS INTEGER)
 I = FindFreePart(VARSEG(pUsed(0))) \ 2
 IF I THEN
  IF X > 320 OR X < 1 OR Y > 200 OR Y < 1 THEN EXIT SUB
  IF Ttl < 0 THEN Ttl = 30
  Parts(I).Flags = Flags
  Parts(I).BaseColour = Colour
  Parts(I).X = (X * 64): Parts(I).Y = (Y * 64)
  Parts(I).Xd = (Xd * 128): Parts(I).Yd = (Yd * 128)
  Parts(I).Size = Size
  Parts(I).Ttl = Ttl
  IF SetClr = 0 THEN Parts(I).Flags = Parts(I).Flags OR PF.CIRC
  IF Parts(I).Flags AND PF.NOCIRC THEN
   Parts(I).Flags = Parts(I).Flags XOR PF.CIRC
   Parts(I).Flags = Parts(I).Flags XOR PF.NOCIRC
  END IF
  Parts(I).Clr = 0
  Parts(I).Ottl = Ttl
  Parts(I).SetClr = SetClr
  pUsed(I) = 1
 END IF
END SUB

SUB PRT.CircleExp (X%, Y%, Density%, Size%, Nothing%)
 DIM aStep AS SINGLE, A AS SINGLE
 DIM Obj AS Object2D: Obj.X = X: Obj.Y = Y
 Ttl = 5 + Density% / 1.25
 IF Density% AND 1 THEN Density% = Density% + 1
 Density% = Density% / 3
 aStep = 360 / Density%
 FOR I# = 1 TO Density%
  PRT.AddPart X%, Y%, Cosine(A) * 1.2, Sine(A) * 1.2, Size%, Ttl, 0, Red, PF.FIRE OR PT.IMPLODE
  A = A + aStep
 NEXT I#
END SUB

SUB PRT.ClearAllParts
 FOR I = 1 TO MAXPARTICLES
  pUsed(I) = 0
 NEXT I
END SUB

SUB PRT.ImplodeText (Text$, Ex%, Ey%, Size%)
 DIM Tvx AS SINGLE, Tvy AS SINGLE
 DIM L AS LONG, Vx AS SINGLE, Vy AS SINGLE
 
 CSMapEMSLayer EMS.Handle, 4
 CSClear EMS.Layer, 0

 CSPrint EMS.Layer, 0, 0, Text$, 15
 tplen = LEN(Text$) * 8
 Nx = Ex - (tplen / 2)
 Ny = Ey - 4
 FOR X = 0 TO tplen
  FOR Y = 0 TO 7
   IF CSPoint(EMS.Layer, X, Y) THEN
    TX = Nx + X: Ty = Ny + Y
    Vx = Ex - TX: Vy = Ey - Ty
    L = SQR(Vx * Vx + Vy * Vy)
    IF Vx <> 0 AND L <> 0 THEN Tvx = (Vx / L)
    IF Vy <> 0 AND L <> 0 THEN Tvy = (Vy / L)
    PRT.AddPart TX + (-Tvx * (L * Size)), Ty + (-Tvy * (L * Size)), Tvx / 1.5, Tvy / 2, 1 + Size * 1.5, INT(L * Size), 0, Blue, PF.NOBLEND OR PF.NOCIRC
   END IF
  NEXT Y
 NEXT X

 CSMapEMSLayer EMS.Handle, 0
END SUB

SUB PRT.MoveAndDrawParticles
 DEF SEG = EMS.Layer

 FOR I = 1 TO MAXPARTICLES
  IF pUsed(I) THEN
  
   Parts(I).Clr = ((Parts(I).Ttl + 1) / (Parts(I).Ottl + 1)) * 63
   Parts(I).Ttl = Parts(I).Ttl - 1
   
   IF Parts(I).Clr THEN
     Colour = Parts(I).BaseColour
     IF Colour < 1 THEN
       Clr = Parts(I).Clr + BColourLut(Colour)
      ELSE
       Clr = Colour
     END IF
    ELSE
     Clr = 0
   END IF

   IF Parts(I).SetClr THEN Clr = Parts(I).SetClr

   ' Update positions
   OldX = Parts(I).X \ 64
   OldY = Parts(I).Y \ 64
   Parts(I).X = Parts(I).X + Parts(I).Xd
   Parts(I).Y = Parts(I).Y + Parts(I).Yd
   NewX = Parts(I).X \ 64
   NewY = Parts(I).Y \ 64

   IF Parts(I).Ttl < 1 THEN pUsed(I) = 0
   IF (Parts(I).X > 20480 AND Parts(I).Xd > 0) OR (Parts(I).X < 1 AND Parts(I).Xd < 0) OR (Parts(I).Y > 128000 AND Parts(I).Yd > 0) OR (Parts(I).Y < 1 AND Parts(I).Yd < 0) THEN pUsed(I) = 0

   IF Clr THEN
    IF (Parts(I).Flags AND PF.CIRC) AND (Parts(I).Flags AND PF.FIRE) = 0 THEN

      X = (NewX * Cam.Zoom) - Cam.X
      Y = (NewY * Cam.Zoom) - Cam.Y
      C3 = Cam.Zoom: CH = C3 / 2
      PRT.AddPart NewX, NewY, Parts(I).Xd \ 64, Parts(I).Yd \ 64, 2, 3, Clr, Parts(I).BaseColour, 0
      IF X > -1 AND Y > -1 AND X < 321 AND Y < 201 THEN BCircP64 EMS.Layer, X - C3 - C3, Y - C3 - C3, C3 + C3, Clr
      
     ELSEIF (Parts(I).Flags AND PF.FIRE) = 0 THEN

      Sz = (Parts(I).Size * Cam.Zoom) / 2
      X = ((NewX - 1) * Cam.Zoom) - Cam.X
      Y = ((NewY - 1) * Cam.Zoom) - Cam.Y
      IF X > -1 AND Y > -1 AND X < 321 AND Y < 201 AND Sz > 0 THEN
       IF Parts(I).Flags AND PF.NOBLEND THEN
         CSBoxF EMS.Layer, X - Sz + 1, Y - Sz + 1, X + Sz, Y + Sz, Clr
        ELSE
         BBoxF64 EMS.Layer, X - Sz + 1, Y - Sz + 1, X + Sz, Y + Sz, Clr
       END IF
      END IF

     ELSEIF Parts(I).Flags AND PF.FIRE THEN

      Distr = INT(RND * 2) - 1
      IF NewX > -1 AND NewY > -1 AND NewX < 321 AND NewY < 201 THEN PRT.AddPart NewX, NewY, -((NewX - OldX) \ 5 + Disrt), -((NewY - OldY) \ 5 + Disrt), 3, 6, 0, Parts(I).Clr, 0

    END IF
   END IF
  END IF
 NEXT

 AntiAliase64 EMS.Layer
 DrawO2DObjs
END SUB

DEFSNG A-Z
SUB RotateLine (Line1 AS tLine, Line2 AS tLine, Angle AS INTEGER)
 Line2.X1 = Line1.X1 * Cosine(Angle) - Line1.Y1 * Sine(Angle)
 Line2.X2 = Line1.X2 * Cosine(Angle) - Line1.Y2 * Sine(Angle)
 Line2.Y1 = Line1.X1 * Sine(Angle) + Line1.Y1 * Cosine(Angle)
 Line2.Y2 = Line1.X2 * Sine(Angle) + Line1.Y2 * Cosine(Angle)
END SUB

REM $STATIC
DEFINT A-Z
SUB SetCam (X, Y, Zoom AS SINGLE)
 STATIC MxX AS INTEGER, MxY AS INTEGER

 IF Zoom > 0 THEN Cam.Zoom = Zoom
 IF Zoom < 1 THEN Zoom = 1
 IF Zoom > 1.75 THEN Zoom = 1.75
 
 Cam.X = (X * Zoom) - 160
 Cam.Y = (Y * Zoom) - 100

 IF Cam.X > (320 * Zoom) - 320 THEN Cam.X = (320 * Zoom) - 320
 IF Cam.Y > (200 * Zoom) - 200 THEN Cam.Y = (200 * Zoom) - 200
 IF Cam.X < 0 THEN Cam.X = 0
 IF Cam.Y < 0 THEN Cam.Y = 0
END SUB

REM $DYNAMIC
SUB SetNumlocks
 DEF SEG = 0
  Temp = PEEK(1047)
  Temp = Temp OR 32
  POKE (1047), KF
 DEF SEG
END SUB

REM $STATIC
SUB SpawnEnemy (Obj AS Object2D)
 FOR A = 0 TO 359 STEP 30
  PRT.AddPart (Obj.X) + (Cosine(A) * 15), (Obj.Y) + (Sine(A) * 15), -Cosine(A) * .2, -Sine(A) * .2, 2, 35, 0, Blue, PF.NOBLEND
 NEXT
END SUB

