.model small,c
.stack 0

mex	equ 80h

charset segment
	assume cs:charset
	assume ds:charset,es:charset
	org 100h
prog:	jmp foprog

irq 	label byte
intr	proc far
	cmp ah,2
	jne next
	int mex
	iret
next:	int mex
	pushf
	push di
	push es
	push dx
	push cx
	push si
	push ds
	cmp ax,7200h
	jne jaja
	cli
	push ax
	push bx
	push bp
	call bekapc
	pop bp
	pop bx
	pop ax
	jmp short invi
jaja:	mov di,cs
	mov ds,di
	mov di,40h
	mov es,di
	mov di,17h
	mov dx,es:[di]
	test dl,16
	jz invi
	mov si,cs
	mov ds,si
	xor si,si
	mov cx,(offset csere - offset ascan)/2
	jcxz invi
cikl:	cmp ax,ascan[si]
	jne tov
	cmp si,36
	jge ok
	test dl,64
	jz ok
	cmp si,18
	jge kivon
	add si,18
	jmp short ok
kivon:	sub si,18
ok:	shr si,1
	mov al,csere[si]
	jmp short invi
tov:	inc si
	inc si
	loop cikl
invi:	pop ds
	pop si
	pop cx
	pop dx
	pop es
	pop di
	popf
	sti
	ret 2
intr	endp

ascan	dw 2827h,273bh,565ch,0d3dh,1b5dh,0b30h,1a5bh,0c2dh,2b5ch,2822h,273ah
	dw 567ch,0d2bh,1b7dh,0b29h,1a7bh,0c5fh,2b7ch,2960h,297eh,0221h,0340h
	dw 0423h,0524h,0625h,075eh,0826h,092ah,0a28h,352fh,333ch,343eh,353fh
	dw 7800h,7900h,7a00h,7b00h,7c00h,7d00h,7e00h,7f00h,8000h,8100h,8200h
	dw 8300h,1000h,1100h,2100h,2200h,2c00h,2d00h,2e00h,2f00h,3000h,3100h
	dw 2c7ah,1579h,2c5ah,1559h,561ch,2c1ah,2d18h,2e03h,2f16h,3002h,3102h
	dw 1011h,1117h,2106h,2207h,1a1bh

csere	db "0",21,"'",34,"+!%/=()-?:_~;^$`.'",34,"*\|[]>"
	db "#&@{}yzYZ<>#&@{}\|[]"

foprog: call savechar		;	***	SAVETER!!!	***
	call bekapc
irqin:	cli
	mov ah,35h
	mov al,16h
	int 21h
	mov dx,bx
	mov ax,es
	mov ds,ax
	mov ah,25h
	mov al,mex
	int 21h
	mov dx,offset irq
	mov ax,cs
	mov ds,ax
	mov ah,25h
	mov al,16h
	int 21h
	sti
	mov dx,3072
	int 27h

bekapc:	mov ax,cs
	mov ds,ax
	mov es,ax
	mov bp,offset code
	xor bx,bx
	mov cx,code-char
	jcxz beveg
elt:	push es
	push bp
	push bx
	push cx
	mov dl,char[bx]
	xor dh,dh
	mov cx,1
	mov bx,16*256
	mov ax,1110h
	int 10h
	pop cx
	pop bx
	pop bp
	pop es
	add bp,16
	inc bx
	loop elt
beveg:	ret

char	db " abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRST"
	db "UVWXYZ0123456789+-'`",34,"()<>.,:;!?_/\@*&%#[]~${}"

code	db 00000000b	;szkz
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b

	db 00000000b	;a
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 01111100b
	db 10000110b
	db 00000110b
	db 01110110b
	db 11001110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 01111011b
	db 00000000b
	db 00000000b

	db 00000000b	;
	db 00011100b
	db 00011000b
	db 00010000b
	db 00000000b
	db 01111100b
	db 10000110b
	db 00000110b
	db 01110110b
	db 11001110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 01111011b
	db 00000000b
	db 00000000b

	db 00000000b	;b
	db 00000000b
	db 11100000b
	db 01100000b
	db 01100000b
	db 01101110b
	db 01110011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100110b
	db 11011100b
	db 00000000b
	db 00000000b

	db 00000000b	;c
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00011110b
	db 00110011b
	db 01100010b
	db 01100000b
	db 01100000b
	db 01100100b
	db 01100010b
	db 00110011b
	db 00011110b
	db 00000000b
	db 00000000b

	db 00000000b	;d
	db 00000000b
	db 00000111b
	db 00000110b
	db 00000110b
	db 01110110b
	db 11001110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 01111011b
	db 00000000b
	db 00000000b

	db 00000000b	;e
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00111110b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01111111b
	db 01100000b
	db 01100010b
	db 01100011b
	db 00111110b
	db 00000000b
	db 00000000b

	db 00000000b	;
	db 00001110b
	db 00001100b
	db 00001000b
	db 00000000b
	db 00111110b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01111111b
	db 01100000b
	db 01100010b
	db 01100011b
	db 00111110b
	db 00000000b
	db 00000000b

	db 00000000b	;f
	db 00000000b
	db 00000000b
	db 00001110b
	db 00011001b
	db 00011010b
	db 00011000b
	db 00011000b
	db 00011001b
	db 00111110b
	db 01011000b
	db 00011000b
	db 00011000b
	db 01011000b
	db 10011000b
	db 01110000b

	db 00000000b	;g
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 01111011b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11001110b
	db 01110110b
	db 00000110b
	db 10000110b
	db 01111100b

	db 00000000b	;h
	db 00000000b
	db 11100000b
	db 01100000b
	db 01100000b
	db 01101100b
	db 01110110b
	db 01100110b
	db 01100110b
	db 01100110b
	db 01100110b
	db 01100110b
	db 01100110b
	db 11100011b
	db 00000000b
	db 00000000b

	db 00000000b	;i
	db 00000000b
	db 00011000b
	db 00011000b
	db 00000000b
	db 00111000b
	db 01011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011010b
	db 10011001b
	db 01111110b
	db 00000000b
	db 00000000b

	db 00000000b	;
	db 00011100b
	db 00011000b
	db 00010000b
	db 00000000b
	db 00111000b
	db 01011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011010b
	db 10011001b
	db 01111110b
	db 00000000b
	db 00000000b

	db 00000000b	;j
	db 00000000b
	db 00000110b
	db 00000110b
	db 00000000b
	db 00001110b
	db 00010110b
	db 00000110b
	db 00000110b
	db 00000110b
	db 00000110b
	db 00000110b
	db 00100110b
	db 01000110b
	db 11001100b
	db 01111000b

	db 00000000b	;k
	db 00000000b
	db 11100000b
	db 01100000b
	db 01100000b
	db 01100011b
	db 01100110b
	db 01100110b
	db 01101100b
	db 01111000b
	db 01101100b
	db 01100110b
	db 01100110b
	db 11100011b
	db 00000000b
	db 00000000b

	db 00000000b	;l
	db 01100000b
	db 10110000b
	db 00110000b
	db 00110000b
	db 00110000b
	db 00110000b
	db 00110000b
	db 00110000b
	db 00110000b
	db 00110000b
	db 00110010b
	db 00011001b
	db 00001110b
	db 00000000b
	db 00000000b

	db 00000000b	;m
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11100110b
	db 11011011b
	db 11011011b
	db 11011011b
	db 11011011b
	db 11011011b
	db 11011011b
	db 11011011b
	db 11000011b
	db 00000000b
	db 00000000b

	db 00000000b	;n
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11011100b
	db 01100110b
	db 01100110b
	db 01100110b
	db 01100110b
	db 01100110b
	db 01100110b
	db 01100110b
	db 11100011b
	db 00000000b
	db 00000000b

	db 00000000b	;o
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00111110b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 00111110b
	db 00000000b
	db 00000000b

	db 00000000b	;
	db 00001110b
	db 00001100b
	db 00001000b
	db 00000000b
	db 00111110b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 00111110b
	db 00000000b
	db 00000000b

	db 00000000b	;
	db 00000000b
	db 01100011b
	db 01100011b
	db 00000000b
	db 00111110b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 00111110b
	db 00000000b
	db 00000000b

	db 00000000b	;
	db 01110111b
	db 01100110b
	db 01000100b
	db 00000000b
	db 00111110b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 00111110b
	db 00000000b
	db 00000000b

	db 00000000b	;p
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11011110b
	db 01110011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01110011b
	db 01101110b
	db 01100000b
	db 01100000b
	db 11110000b

	db 00000000b	;q
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 01111011b
	db 11001110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11001110b
	db 01110110b
	db 00000110b
	db 00000110b
	db 00001111b

	db 00000000b	;r
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11011110b
	db 01110011b
	db 01100010b
	db 01100000b
	db 01100000b
	db 01100000b
	db 01100000b
	db 01100000b
	db 11110000b
	db 00000000b
	db 00000000b

	db 00000000b	;s
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00111110b
	db 01100011b
	db 11000010b
	db 01100000b
	db 00111100b
	db 00000110b
	db 01100011b
	db 11000110b
	db 01111100b
	db 00000000b
	db 00000000b

	db 00000000b	;t
	db 01100000b
	db 10110000b
	db 00110000b
	db 00110000b
	db 00110000b
	db 00110010b
	db 01111100b
	db 10110000b
	db 00110000b
	db 00110000b
	db 00110010b
	db 00110011b
	db 00011110b
	db 00000000b
	db 00000000b

	db 00000000b	;u
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11100111b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 01100110b
	db 00111011b
	db 00000000b
	db 00000000b

	db 00000000b	;
	db 00011100b
	db 00011000b
	db 00010000b
	db 00000000b
	db 11100111b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 01100110b
	db 00111011b
	db 00000000b
	db 00000000b

	db 00000000b	;
	db 00000000b
	db 11000110b
	db 11000110b
	db 00000000b
	db 11100111b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 01100110b
	db 00111011b
	db 00000000b
	db 00000000b

	db 00000000b	;
	db 01110111b
	db 01100110b
	db 01000100b
	db 00000000b
	db 11100111b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 01100110b
	db 00111011b
	db 00000000b
	db 00000000b

	db 00000000b	;v
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11100111b
	db 01100011b
	db 01100011b
	db 01100011b
	db 01100110b
	db 00110110b
	db 00110110b
	db 00011100b
	db 00001000b
	db 00000000b
	db 00000000b

	db 00000000b	;w
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11000011b
	db 11001011b
	db 11011011b
	db 11011011b
	db 11011011b
	db 11011011b
	db 11011011b
	db 11011011b
	db 01100111b
	db 00000000b
	db 00000000b

	db 00000000b	;x
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11100011b
	db 01100011b
	db 01100011b
	db 00110110b
	db 00011000b
	db 00110110b
	db 01100011b
	db 01100011b
	db 11100011b
	db 00000000b
	db 00000000b

	db 00000000b	;y
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11100111b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 11000110b
	db 01100110b
	db 00111110b
	db 00000110b
	db 10000110b
	db 01111100b

	db 00000000b	;z
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 01111111b
	db 01000110b
	db 00000110b
	db 00001100b
	db 00011000b
	db 00011000b
	db 00110000b
	db 00110001b
	db 01111111b
	db 00000000b
	db 00000000b

	db 00000000b	;A
	db 00000000b
	db 01111110b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11111111b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11100111b
	db 00000000b
	db 00000000b

	db 00011100b	;
	db 00011000b
	db 00010000b
	db 00000000b
	db 01111110b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11111111b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11100111b
	db 00000000b
	db 00000000b

	db 00000000b	;B
	db 00000000b
	db 11111100b
	db 11000110b
	db 11000011b
	db 11000011b
	db 11000110b
	db 11111100b
	db 11000110b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000110b
	db 11111100b
	db 00000000b
	db 00000000b

	db 00000000b	;C
	db 00000000b
	db 01111100b
	db 11000110b
	db 11000011b
	db 11000110b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11000110b
	db 11000011b
	db 11000011b
	db 11000110b
	db 01111100b
	db 00000000b
	db 00000000b

	db 00000000b	;D
	db 00000000b
	db 11111100b
	db 11000110b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000110b
	db 11111100b
	db 00000000b
	db 00000000b

	db 00000000b	;E
	db 00000000b
	db 11111111b
	db 11000001b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11000100b
	db 11111100b
	db 11000100b
	db 11000000b
	db 11000000b
	db 11000001b
	db 11111111b
	db 00000000b
	db 00000000b

	db 00011100b	;
	db 00011000b
	db 00010000b
	db 00000000b
	db 11111111b
	db 11000001b
	db 11000000b
	db 11000000b
	db 11000100b
	db 11111100b
	db 11000100b
	db 11000000b
	db 11000001b
	db 11111111b
	db 00000000b
	db 00000000b

	db 00000000b	;F
	db 00000000b
	db 11111111b
	db 11000001b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11000100b
	db 11111100b
	db 11000100b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11100000b
	db 00000000b
	db 00000000b

	db 00000000b	;G
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11000110b
	db 11000000b
	db 11000000b
	db 11001111b
	db 11001011b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;H
	db 00000000b
	db 11100111b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11111111b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11100111b
	db 00000000b
	db 00000000b

	db 00000000b	;I
	db 00000000b
	db 01111110b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 01111110b
	db 00000000b
	db 00000000b

	db 00011100b	;
	db 00011000b
	db 00010000b
	db 00000000b
	db 01111110b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 01111110b
	db 00000000b
	db 00000000b

	db 00000000b	;J
	db 00000000b
	db 11111111b
	db 10000011b
	db 00000011b
	db 00000011b
	db 00000011b
	db 00000011b
	db 00000011b
	db 01110011b
	db 11001011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;K
	db 00000000b
	db 11100011b
	db 11000011b
	db 11000110b
	db 11001100b
	db 11011000b
	db 11110000b
	db 11110000b
	db 11011000b
	db 11001100b
	db 11000110b
	db 11000011b
	db 11100011b
	db 00000000b
	db 00000000b

	db 00000000b	;L
	db 00000000b
	db 11100000b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11000001b
	db 11111111b
	db 00000000b
	db 00000000b

	db 00000000b	;M
	db 00000000b
	db 10000001b
	db 11000011b
	db 11100111b
	db 11100111b
	db 11011011b
	db 11011011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11100111b
	db 00000000b
	db 00000000b

	db 00000000b	;N
	db 00000000b
	db 10000111b
	db 11000011b
	db 11100011b
	db 11110011b
	db 11010011b
	db 11011011b
	db 11011011b
	db 11001111b
	db 11000111b
	db 11000111b
	db 11000011b
	db 11100001b
	db 00000000b
	db 00000000b

	db 00000000b	;O
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00011100b	;
	db 00011000b
	db 00010000b
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 11000011b	;
	db 11000011b
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 01110111b	;
	db 01100110b
	db 01000100b
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;P
	db 00000000b
	db 11111100b
	db 11000110b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000110b
	db 11111100b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11000000b
	db 11100000b
	db 00000000b
	db 00000000b

	db 00000000b	;Q
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11011011b
	db 11001101b
	db 01100110b
	db 00111011b
	db 00000000b
	db 00000000b

	db 00000000b	;R
	db 00000000b
	db 11111100b
	db 11000110b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000110b
	db 11111100b
	db 11001100b
	db 11000110b
	db 11000110b
	db 11000011b
	db 11100011b
	db 00000000b
	db 00000000b

	db 00000000b	;S
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11000110b
	db 01100000b
	db 00111100b
	db 00000110b
	db 01110011b
	db 11001011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;T
	db 00000000b
	db 11111111b
	db 10011001b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;U
	db 00000000b
	db 11100111b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00011100b	;
	db 00011000b
	db 00010000b
	db 00000000b
	db 11100111b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 11000011b	;
	db 11000011b
	db 00000000b
	db 11100111b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 01110111b	;
	db 01100110b
	db 01000100b
	db 00000000b
	db 11100111b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;V
	db 00000000b
	db 11100111b
	db 11000011b
	db 11000011b
	db 11000110b
	db 11000110b
	db 01100110b
	db 01100110b
	db 01101100b
	db 01101100b
	db 00111100b
	db 00011000b
	db 00001000b
	db 00000000b
	db 00000000b

	db 00000000b	;W
	db 00000000b
	db 11100111b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11001011b
	db 11011011b
	db 11011011b
	db 01111110b
	db 01100110b
	db 01100110b
	db 00000000b
	db 00000000b

	db 00000000b	;X
	db 00000000b
	db 11100111b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00110110b
	db 00011000b
	db 00011000b
	db 01101100b
	db 01100110b
	db 11000011b
	db 11000011b
	db 11100111b
	db 00000000b
	db 00000000b

	db 00000000b	;Y
	db 00000000b
	db 11100111b
	db 11000011b
	db 11000011b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;Z
	db 00000000b
	db 11111111b
	db 10000110b
	db 00000110b
	db 00001100b
	db 00001100b
	db 00011000b
	db 00011000b
	db 00110000b
	db 00110000b
	db 01100000b
	db 01100001b
	db 11111111b
	db 00000000b
	db 00000000b

	db 00000000b	;0
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11000011b
	db 11000111b
	db 11001011b
	db 11010011b
	db 11100011b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;1
	db 00000000b
	db 00000100b
	db 00001100b
	db 00011100b
	db 00111100b
	db 01101100b
	db 10001100b
	db 00001100b
	db 00001100b
	db 00001100b
	db 00001100b
	db 00001100b
	db 00111111b
	db 00000000b
	db 00000000b

	db 00000000b	;2
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11010011b
	db 01100011b
	db 00000011b
	db 00000110b
	db 00001100b
	db 00011000b
	db 00110000b
	db 01100001b
	db 11111111b
	db 00000000b
	db 00000000b

	db 00000000b	;3
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11010011b
	db 01100011b
	db 00000110b
	db 00001110b
	db 01100011b
	db 11010011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;4
	db 00000000b
	db 00000010b
	db 00000110b
	db 00001100b
	db 00011000b
	db 00110010b
	db 01100110b
	db 11000110b
	db 11111111b
	db 00000110b
	db 00000110b
	db 00000110b
	db 00001111b
	db 00000000b
	db 00000000b

	db 00000000b	;5
	db 00000000b
	db 11111111b
	db 11000001b
	db 11000000b
	db 11000000b
	db 11011100b
	db 11100110b
	db 00000011b
	db 00000011b
	db 01100011b
	db 11010011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;6
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11001011b
	db 11000110b
	db 11000000b
	db 11111100b
	db 11100110b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;7
	db 00000000b
	db 11111111b
	db 10000110b
	db 00001100b
	db 00001100b
	db 00111110b
	db 00011000b
	db 00110000b
	db 00110000b
	db 01100000b
	db 01100000b
	db 11000000b
	db 10000000b
	db 00000000b
	db 00000000b

	db 00000000b	;8
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;9
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11000011b
	db 01100111b
	db 00111111b
	db 00000011b
	db 01100011b
	db 11010011b
	db 11000011b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;+
	db 00000000b
	db 00000000b
	db 00000000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 01111110b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00011000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b

	db 00000000b	;-
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 01111110b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b

	db 00000000b	;'
	db 00000000b
	db 00000000b
	db 00001110b
	db 00001100b
	db 00001000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b

	db 00000000b	;`
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11101110b
	db 11001100b
	db 10001000b
	db 00000000b

	db 00000000b	;"
	db 00000000b
	db 00000000b
	db 01110111b
	db 01100110b
	db 01000100b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b

	db 00000000b	;(
	db 00000111b
	db 00011100b
	db 00111000b
	db 00110000b
	db 01110000b
	db 01100000b
	db 01100000b
	db 01100000b
	db 01100000b
	db 01110000b
	db 00110000b
	db 00111000b
	db 00011100b
	db 00000111b
	db 00000000b

	db 00000000b	;)
	db 11100000b
	db 00111000b
	db 00011100b
	db 00001100b
	db 00001110b
	db 00000110b
	db 00000110b
	db 00000110b
	db 00000110b
	db 00001110b
	db 00001100b
	db 00011100b
	db 00111000b
	db 11100000b
	db 00000000b

	db 00000000b	;<
	db 00000000b
	db 00000011b
	db 00000110b
	db 00001100b
	db 00011000b
	db 00110000b
	db 01100000b
	db 11000000b
	db 01100000b
	db 00110000b
	db 00011000b
	db 00001100b
	db 00000110b
	db 00000011b
	db 00000000b

	db 00000000b	;>
	db 00000000b
	db 11000000b
	db 01100000b
	db 00110000b
	db 00011000b
	db 00001100b
	db 00000110b
	db 00000011b
	db 00000110b
	db 00001100b
	db 00011000b
	db 00110000b
	db 01100000b
	db 11000000b
	db 00000000b

	db 00000000b	;.
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00111000b
	db 00111000b
	db 00000000b
	db 00000000b

	db 00000000b	;,
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00111000b
	db 00110000b
	db 00100000b
	db 00000000b

	db 00000000b	;:
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00011000b
	db 00011000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00011000b
	db 00011000b
	db 00000000b
	db 00000000b
	db 00000000b

	db 00000000b	;;
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00011000b
	db 00011000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00011000b
	db 00011000b
	db 00010000b
	db 00100000b
	db 00000000b

	db 00000000b	;!
	db 00000000b
	db 00011100b
	db 00011110b
	db 00111110b
	db 00111110b
	db 00111110b
	db 00111100b
	db 00011100b
	db 00011100b
	db 00011000b
	db 00000000b
	db 00000000b
	db 00011100b
	db 00011100b
	db 00000000b

	db 00000000b	;?
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000011b
	db 11010011b
	db 01100011b
	db 00001110b
	db 00111000b
	db 01100000b
	db 01100110b
	db 00111100b
	db 00000000b
	db 00011100b
	db 00011100b
	db 00000000b

	db 00000000b	;_
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11111111b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b

	db 00000000b	;/
	db 00000001b
	db 00000011b
	db 00000110b
	db 00000110b
	db 00001100b
	db 00001100b
	db 00011000b
	db 00011000b
	db 00110000b
	db 00110000b
	db 01100000b
	db 01100000b
	db 11000000b
	db 10000000b
	db 00000000b

	db 00000000b	;\
	db 10000000b
	db 11000000b
	db 01100000b
	db 01100000b
	db 00110000b
	db 00110000b
	db 00011000b
	db 00011000b
	db 00001100b
	db 00001100b
	db 00000110b
	db 00000110b
	db 00000011b
	db 00000001b
	db 00000000b

	db 00000000b	;@
	db 00000000b
	db 00111100b
	db 01000010b
	db 10000001b
	db 10011001b
	db 10100101b
	db 10100001b
	db 10100001b
	db 10100101b
	db 10011001b
	db 10000001b
	db 01000010b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;*
	db 00000000b
	db 00000000b
	db 00000000b
	db 00011000b
	db 11011011b
	db 01111110b
	db 00111100b
	db 11111111b
	db 00111100b
	db 01111110b
	db 11011011b
	db 00011000b
	db 00000000b
	db 00000000b
	db 00000000b

	db 00000000b	;&
	db 00000000b
	db 00000000b
	db 00111100b
	db 01100110b
	db 11000110b
	db 11000110b
	db 01101100b
	db 01110000b
	db 11011001b
	db 11001101b
	db 11000110b
	db 01100011b
	db 00111101b
	db 00000000b
	db 00000000b

	db 00000000b	;%
	db 00000001b
	db 11100011b
	db 11100110b
	db 11100110b
	db 00001100b
	db 00001100b
	db 00011000b
	db 00011000b
	db 00110000b
	db 00110000b
	db 01100111b
	db 01100111b
	db 11000111b
	db 10000000b
	db 00000000b

	db 00000000b	;#
	db 00000000b
	db 00111100b
	db 01000010b
	db 10000001b
	db 10111001b
	db 10100101b
	db 10111001b
	db 10100001b
	db 10100001b
	db 10100001b
	db 10000001b
	db 01000010b
	db 00111100b
	db 00000000b
	db 00000000b

	db 00000000b	;[
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00111111b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b

	db 00000000b	;]
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 11111100b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b

	db 00000000b	;~
	db 00000000b
	db 00000000b
	db 11101010b
	db 01001110b
	db 01001010b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b

	db 00000000b	;$
	db 00000000b
	db 00011000b
	db 00011000b
	db 00111100b
	db 01111110b
	db 11011011b
	db 11011000b
	db 01111110b
	db 00011011b
	db 11011011b
	db 01111110b
	db 00111100b
	db 00011000b
	db 00011000b
	db 00000000b

	db 00000000b	;{
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 01100011b
	db 01100011b
	db 00000000b
	db 00000000b

	db 00000000b	;}
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00000000b
	db 00110000b
	db 00110000b
	db 00000000b
	db 00000000b

savechar:	push	cs		;	***	SAVETER...
		push	cs
		pop	ds
		pop	es
		xor	cx,cx
		lea	dx,filenev
		mov	ah,3ch
		int	21h
		jc	send
		mov	file,ax
		xor	bp,bp
		lea	di,char
scikl1:		mov	cx,128
		lea	si,sasc
scikl2:		push	cx
		push	bp
		push	di
		lodsb
		push	si
		lea	bx,[di+1]
		mov	cx,code-char
		jcxz	spacc
		repne	scasb
		je	smegv
spacc:		mov	di,bx
smegv:		sub	di,bx
		mov	cl,4
		shl	di,cl
		lea	dx,code[di][bp]
		mov	cl,1
		mov	bx,file
		mov	ah,40h
		int	21h
		pop	si
		pop	di
		pop	bp
		pop	cx
		jc	sclose
		loop	scikl2
		inc	bp
		cmp	bp,16
		jb	scikl1
sclose:		mov	bx,file
		mov	ah,3eh
		int	21h
send:		ret

filenev		db	"kaland.tcr",0
file		dw	0
sasc		db	" aouiebcdfghjklmnpqrstvwxyz"
		db	 "AOUIEBCDFGHJKLMNPQRSTVWXYZ"
		db	"0123456789-/\'>$%*`(<[+=&@#]",34," .,;:?!){}_~"
		db	16 dup(0)
					;	...SAVETER!!!	***
vege	label byte

charset ends

end prog
