
egyrut	segment use16
assume	cs:egyrut,ds:adat

;------------------------------------------------------------------------------
proctest	proc	far		;	Processzortesztels meg minden
		mov	ax,512		;	TF, DF = 0
		push	ax
		popf

		call	medmex		;	INT vektorok mentse

		and	mode,247
		test	hexan,16
		sjnz	_86processor

		push	sp		;	Testing 8086...
		pop	ax
		cmp	ax,sp
		sjnz	_86processor
		njmp	proctov

_86processor:	xor	di,di			;	INT 0...INT 7
		mov	cl,8			;	hatstalantsa
		mov	es,di
_86kill:	mov	ax,offset intkiller
		stosw
		mov	ax,cs
		stosw
		loop	_86kill
		mov	ax,offset ivissz	;	BREAK letiltsa
		mov	di,01bh*4
		push	ax
		stosw
		mov	ax,cs
		stosw
		pop	ax
		mov	di,23h*4
		stosw
		mov	ax,cs
		stosw
		mov	ax,offset ioerror	;	"Abort/Retry/Fail?"
		stosw				;	elpuszttsa
		and	kwan,252
		xor	bx,bx
		mov	ax,cs
		or	ewan,2
		or	iwan,3
		or	kwan,4
		stosw
		mov	ax,bx
		mov	dx,bx
		mov	si,bx
		mov	di,bx
		mov	bp,bx
filemon:	and	hexan,111
		test	mode,8
		mov	es,ax
		push	ds
		sjnz	hexix
		or	hexan,16
		or	smode,16
		or	ewan,128
		or	tewan,24
hexix:		test	br es:[417h],16
		pop	es
		sjz	screx
		or	hexan,128
screx:		ret

_86_2:		sjmp	_86processor

proctov:	mov	es,cx		;	INT 6: "unknown instruction"
		mov	di,6*4
		mov	ax,offset new6
		stosw
		mov	ax,cs
		stosw
		mov	ax,-1
		push	ax
		push	ax
		add	sp,4
		mov	bp,sp

		inc	cx		;	Testing 80186 with...
		db	00fh,001h,0e0h	;	SMSW AX
		cmp	wr [bp-2],-1
		sjne	procfound

		inc	cx		;	Testing 80286 with...
		db	00fh,020h,0c0h	;	MOV EAX,CR0
		cmp	wr [bp-2],-1
		sjne	procfound

		inc	cx		;	Testing 80386 with...
		db	00fh,0c1h,0c0h	;	XADD AX,AX
		cmp	wr [bp-2],-1
		sjne	procfound

		inc	cx		;	80486 or above

procfound:	cmp	cx,3
		sjb	_86_2
		or	mode,8

		mov	ax,cs			;	INT 0...INT 7
		shl	eax,16			;	hatstalantsa
		xor	edi,edi
		mov	ax,offset intkiller
		mov	ecx,8
		rep	stosd
		mov	ax,offset ivissz	;	BREAK letiltsa
		mov	di,01bh*4
		stosd
		mov	di,23h*4
		stosd
		mov	ax,offset ioerror	;	"Abort/Retry/Fail?"
		xor	ebx,ebx
		push	ds
		stosd				;	elpuszttsa
		mov	eax,ebx
		pop	fs
		mov	edx,ebx
		mov	esi,ebx
		push	ds
		mov	edi,ebx
		mov	ebp,ebx
		pop	gs
		njmp	filemon

new6:		pop	ax
		add	ax,3
		push	ax
		iret

intkiller:	mov	cs:old6,ax
		pop	ax
		inc	ax
		inc	ax
		push	ax
		mov	ax,cs:old6
ivissz:		iret

ioerror:	pop	ax
		pop	ax
		popf
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	si
		pop	di
		pop	bp
		stc
		pop	ds
		pop	es
		sti
		ret	2

old6		dw	0,0
proctest	endp
;------------------------------------------------------------------------------
		
;------------------------------------------------------------------------------
detect		proc	far		;	Milyen grafikus krtya van a
		push	ds
		mov	ax,1a00h	;	gpben, melyik videomdok
		int	10h		;	llthatk be, van-e VESA BIOS
		cmp	bl,3
		pop	ds
		mov	al,2		;	stb... Ezeket teszteli a rutin.
		sje	mda
		cmp	bl,al
		sjae	cga
mda:		dec	ax
		sjmp	nvga
mcga:		mov	dwan+1,2+64
nvga:		mov	dwan,al
		ret
ega:		mov	dwan+1,6+128
		or	iwan,64
svga:		ret
cga:		test	mode,8
		sjz	nvga
		cmp	bl,4
		sjb	nvga
		cmp	bl,13
		sjae	nvga
		cmp	bl,9
		les	di,vesacim
		sja	mcga
		sje	nvga
		cmp	bl,7
		mov	dwan,6+128
		sjb	ega
		mov	cx,256
		xor	ax,ax
		test	ewan,128
		push	di
		mov	dr dwan+1,64+128*(1+65536)+6*(1+256+65536+16777216)
		rep	stosw
		mov	wr dwan+5,6*(1+256)
		pop	di
		sjnz	svga
		push	ds
		mov	ah,4fh			;	VES-s adatok lekrdezse
		int	10h
		cmp	ax,4fh
		pop	ds
		sjne	svga
		cmp	dr vesa,"ASEV"
		mov	ecx,6
		sjne	svga
		or	dwan,8
		or	dr dwan+1,8*(1+256+65536+16777216)
		or	wr dwan+5,8*(1+256)
felcikl:	mov	ebx,6
vcikl:		push	cx			;	bellthat zemmdokat
		mov	cx,vmode[ebx][8*ecx-8]	;	vgigteszteli
		les	di,vesacim
		push	cx
		xor	ax,ax
		mov	cx,256
		push	di
		rep	stosw
		pop	di
		pop	cx
		or	ch,ch
		mov	ax,4f01h
		sjz	nvesa
		sjs	nvesa
		push	bx
		push	ds
		int	10h
		pop	ds
		pop	bx
nvesa:		cmp	ax,4fh
		pop	cx
		sjne	nincs
		test	vesa,1
		mov	al,br wmaszk[bx]
		sjz	nincs
		or	dwan[ecx],al
		test	ewan,64
		sjz	valag
		ncall	modszam
valag:		dec	bx
		dec	bx
		sjns	vcikl
		loop	felcikl
		ret

nincs:		mov	ax,vmode[ebx][8*ecx-8]
		cmp	al,0eh
		sje	hicdec
		cmp	al,11h
		sje	hicdec
		cmp	al,14h
		sje	hicdec
		cmp	al,17h
		sje	hicdec
		cmp	al,1ah
		sjne	valag
hicdec:		dec	vmode[ebx][8*ecx-8]
		sjmp	vcikl
detect		endp

modszam:	pushad
		mov	dx,cx
		xor	ax,ax
		mov	di,offset vesa+256
		mov	cx,128
		rep	stosw

molop:		push	cx
		mov	ax,4f01h
		push	bx
		mov	di,offset vesa+256
		push	dx
		push	ds
		int	10h
		pop	ds
		pop	dx
		cmp	ax,4fh
		pop	bx
		mov	di,offset vesa+256
		mov	si,offset vesa
		sjne	nemmod
		test	br [di],1
		mov	cx,64
		sjz	nemmod
		pop	ax
		repe	cmpsd
		push	ax
		sjne	nemmod
		mov	hmode[ebx][8*edx-8],ax
nemmod:		pop	cx
		inc	cx
		cmp	cx,100h
		sjb	molop
		popad
		ret
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
setmode		proc	far			;	Kperny mdbellts
		push	ax
		and	koppany,64
		mov	al,vonan
		and	conan,192
		and	al,63
		test	mode,32
		mov	bl,felb
		mov	ah,al
		sjz	sex
		or	conan,al
sex:		and	ax,7+256*56
		test	vonan,64
		mov	aktset,-1
		mov	ch,salap
		sjz	sexx
		or	conan,al
sexx:		and	bl,7
		test	vonan,128
		mov	cl,uzemmod
		sjz	sexxx
		or	conan,ah
sexxx:		add	bl,bl
		mov	bh,mode
		mov	alap,ch
		add	bl,bl
		and	bh,3
		pop	ax
		and	cl,224
		or	bl,bh
		test	uzemmod,16
		mov	ch,sfelb
		sjz	setmo
		mov	bl,24
setmo:		xor	bh,bh
		test	gwan,32
		mov	felb,ch
		mov	gorog[bx],cl
		sjnz	setmodex
		cmp	bl,24
		sjae	setmodex
		mov	bl,24
setmolp:	dec	bx
		mov	gorog[bx],cl
		sjnz	setmolp

setmodex:	mov	bl,sfelb
		and	bl,7
		mov	bh,al
		add	bl,bl
		and	bh,3
		add	bl,bl
		or	bl,bh
		cmp	al,16
		push	ax
		sjb	setmox
		mov	bl,24
setmox:		xor	bh,bh
		xor	ax,ax
		mov	cl,gorog[bx]
		mov	xoffs,ax
		mov	wr lapoz,farret
		mov	yoffs,ax
		and	uzemmod,31
		and	cl,224
		pop	ax
		mov	wr lapoz+2,ds
		or	uzemmod,cl
		cmp	al,16			;	Grafikus mdok
		;mov	smode,al		;	belltsa: 16:
		sjae	chmode			;	szveges kperny,
		njmp	gmode
chmode:		or	boot,1
		ncall	setkofs
		xor	ax,ax			;	<16: grafikus mdok.
		or	uzemmod,16
		test	dwan,2
		mov	smodex,ax
		mov	gsor,160
		mov	xmax,80
		mov	ymax,25
		mov	ah,0b0h
		sjnz	nemda
		mov	chseg,ax
		xor	di,di
		mov	es,ax
		mov	cx,2000
		mov	ax,chures
		rep	stosw
		mov	dx,3b4h			;	MDA/Hercules krtykat
mono:		test	xmode,128
		mov	betcol,mbetcol		;	kln kell kezelni, a
		mov	kekkar,mkekkar		;	mono attributumok s a
		sjz	joszinm
		mov	betcol,mkekkar
		mov	kekkar,mbetcol
joszinm:	mov	bevcol,mbevcol		;	B000 szegmenscm miatt.
		mov	allcol,mallcol
		mov	kurcol,mkurcol
		mov	kockol,mkockol
		mov	nyikol,mnyikol
		mov	stacol,mstacol
		mov	tovcol,mtovcol
		mov	ikncol,mikncol
		mov	ikicol,mikicol
		mov	ax,0ff0eh	;	kurzor eltntetse (MDA/CGA)
cmcga:		cli
		out	dx,al
		inc	dx
		mov	al,ah
		nop
		sjmp	$+2
		out	dx,al
		sti
		ret
smono:		sjmp	mono

nemda:		mov	ah,0b8h
		push	ds
		mov	chseg,ax
		mov	ah,5
		int	10h
		pop	ds
		test	kwan,1
		mov	ax,3
		sjz	cga80
		shr	gsor,1
		shr	xmax,1
		mov	al,1
cga80:		push	ds
		int	10h
		pop	ds
		ncall	setchar
		test	mode,32
		mov	dx,3d4h
		sjnz	smono
		test	xmode,128
		mov	betcol,cbetcol	;	sznes szveges kpernyk
		mov	kekkar,ckekkar
		sjz	joszinc
		mov	betcol,ckekkar
		mov	kekkar,cbetcol
joszinc:	mov	bevcol,cbevcol
		mov	allcol,callcol
		mov	kurcol,ckurcol
		mov	kockol,ckockol
		mov	nyikol,cnyikol
		mov	stacol,cstacol
		mov	tovcol,ctovcol
		mov	ikncol,cikncol
		mov	ikicol,cikicol
		test	dwan,4
		mov	ax,0ff0eh	;	kurzor eltntetse (EGA/VGA)
		sjz	ccga
		out	dx,ax
		ret
ccga:		njmp	cmcga

sjzchr:		njmp	ujchr

gmode:		test	mode,8
		mov	ah,mode
		sjz	sjzchr
		and	ax,3+252*256
		and	uzemmod,239	;	grafikus kpernyk (SVGA/VESA)
		or	al,ah
		mov	ebx,7
		mov	mode,al
		xchg	ax,cx
		mov	wr lapoz,clapre
		and	ecx,3
		mov	wr lapoz+2,ds
		and	owan,127
		add	cx,cx
		and	alap,7
		and	bl,felb
		mov	ax,640
		mov	dx,480
		sjnz	nem320
		shr	ax,1
		mov	dx,200
		or	owan,128
nem320:		cmp	bl,alap
		push	bx
		sjae	nelap
		mov	bl,alap
nelap:		or	cx,cx
		mov	xmax,ax
		sjnz	nem16
		cmp	bl,1
		sje	nem16
		mov	maszk16,ax
		shr	ax,3
		and	maszk16,7
nem16:		mov	gsor,ax
		mov	al,dwan
		mov	ymax,dx
		and	al,15
		or	al,dwan[bx+1]
		pop	bx
		mov	dwan,al
		;jcxz	fecsok
		test	al,br wmaszk[ecx]
		sjnz	beallhat
nmbea:		xchg	ax,cx
		shr	ax,1
		dec	ax
		sjns	ujset
fecsok:		cmp	bl,alap
		mov	al,3
		sjbe	becsok
		or	bl,bl
		sjz	ujchr
		dec	felb
ujset:		njmp	setmodex
becsok:		cmp	bh,alap
		sje	ujchr
		dec	alap
		sjmp	ujset
ujchr:		mov	al,16
		sjmp	ujset
beallhat:	mov	eax,xymax[4*ebx]
		cmp	bl,alap
		mov	dr xmax,eax
		push	bx
		sjae	nyalap
		test	iwan,32
		mov	bl,alap
		sjnz	nyalap
		sub	eax,xymax[4*ebx]
		sar	eax,1
		sub	dr xoffs,eax
nyalap:		mov	ax,hmode[ecx][8*ebx]
		mov	wr laval,ax
		mov	ax,vmode[ecx][8*ebx]
		pop	bx
		or	ax,ax
		sjs	nmbea
		push	cx
		or	ah,ah
		push	ebx
		sjnz	vesam
		cmp	ax,smodex
		mov	wr lapoz,farret
		sjne	nelsa
		njmp	elzett
nelsa:		mov	smodex,ax
		njmp	bios
vesam:		mov	cx,256
		push	ax
		les	di,vesacim
		xor	ax,ax
		push	di
		rep	stosw
		pop	di
		pop	cx
		push	cx
		push	ds
		mov	ax,4f01h
		int	10h
		pop	ds
		mov	dx,wr vesa+4
		or	dl,dl
		mov	ax,1
		sjz	vnemo
		cmp	dx,64
		sjae	vnemo
		mov	al,64
		div	dl
vnemo:		mov	si,offset vesa+12
		mov	vgran,ax
		test	brown,1
		lodsd
		sjnz	ella
		or	eax,eax
		sjz	ella
		mov	lapoz,eax
ella:		and	xmode,252
		lodsw
		test	wr dwan+5,16*(1+256)	;	Ha a videoram > 2 MB,
		mov	gsor,ax			;	akkor 32-bites.
		sjnz	tr32
		cmp	vesa+37,8
		sjne	nem32
tr32:		or	xmode,1
nem32:		cmp	vesa+33,5
		sjne	nemh15
		or	xmode,16
nemh15:		cmp	vesa+32,0
		sje	nembgr
		or	xmode,2
nembgr:		mov	eax,dr vesa+31
		pop	bx
		mov	regr,eax
		cmp	bx,smodex
		mov	ax,wr vesa+35
		mov	si,wr laval
		mov	blub,ax
		sjne	salsa
elzett:		cmp	fbalap,0
		sjne	alset
		sjmp	elset
salsa:		or	si,si
		mov	ax,4f02h
		mov	smodex,bx
		sjz	bios
		mov	bx,si
bios:		push	ds
		int	10h
		pop	ds
alset:		or	huan,128+16
elset:		pop	esi
		mov	cx,16
		mov	bx,si
		mov	fbalap,ch
		shl	si,6
		xor	edi,edi
		add	si,offset pofpos
		or	huan,32
pocikl:		lodsw
		xchg	ax,bp
		lodsw
		push	di
		call	fkoord
		pop	di
		mov	poffs[2*edi+2],ax
		mov	pags[di+1],dl
		inc	di
		loop	pocikl
		mov	di,cx
		inc	cx
		lea	si,dofpos[8*ebx]
		inc	cx
docikl:		lodsw
		xchg	ax,bp
		lodsw
		push	di
		call	fkoord
		pop	di
		mov	doffs[2*edi],ax
		mov	dpags[di],dl
		inc	di
		loop	docikl
		mov	eax,dr gsorsze[4*ebx]
		mov	dr sorsze+1,eax
		mov	eax,dr gkepsor[4*ebx]
		add	bx,bx
		mov	dr kepsor+1,eax
		mov	si,4
kerep:		mov	al,sorsze[si]
		mov	ah,9
		mul	ah
		mov	gorsze[2*esi],ax
		mov	al,kepsor[si]
		cbw
		shl	ax,3
		dec	si
		mov	gepsor[2*esi+2],ax
		sjnz	kerep
		mov	ax,wr gabsze[bx]
		mov	wr dabsze,ax
		mov	ax,skala[bx+2]
		mov	skala,ax
		mov	ax,wr skszmg[bx]
		mov	br skszel,al
		mov	br skmags,ah
		mov	ax,wr skezdyx[bx]
		mov	br skezdy,al
		mov	br reky,al
		shr	ax,8
		mov	br skezdy+1,bh
		neg	ax
		mov	br reky+1,bh
		add	ax,xmax
		pop	bx
		mov	skezdx,ax
		mov	rekx,ax

		mov	eax,ecx
		mov	di,offset vesa
		push	ds
		mov	pags,al
		mov	poffs,ax
		mov	vpage,ax
		pop	es
		test	felb,7
		mov	dr shintx,5+4*65536
		mov	si,offset szin256
		mov	dr vpages,eax
		sjnz	greffa
		mov	dr shintx,3+2*65536
greffa:		push	di
		mov	pag,al
		mov	cl,24
		mov	akhin,ax
		rep	movsw
		sub	si,48

		test	vonan,128
		mov	cl,16
		sjnz	vray
		test	mode,32
		sjz	nogray
vray:		mov	di,si
		push	cx
gray16:		mov	ah,77
		lodsb
		mul	ah
		xchg	ax,bp
		mov	ah,151
		lodsb
		mul	ah
		add	bp,ax
		mov	ah,28
		lodsb
		mul	ah
		add	ax,bp
		test	conan,8
		mov	al,ah
		sjz	red
		shr	al,1
red:		stosb
		test	conan,16
		mov	al,ah
		sjz	green
		shr	al,1
green:		test	conan,32
		sjz	blue
		shr	ah,1
blue:		stosw
		loop	gray16
		pop	ax
		sub	si,48
		xchg	ax,cx

nogray:		push	es
		mov	di,offset szinht
		call	cocugr[bx]
		pop	es
		lea	di,[si-48]
		mov	cl,24
		pop	si
		rep	movsw
		jmp	keret
setmode		endp

setchar:	test	dwan,4		;	EGA/VGA
		mov	ax,1112h
		sjnz	etcha
		ret
etcha:		test	iwan,64		;	Csak VGA:
		mov	bx,800h		;	80*50 karakteres kp
		sjnz	ega25
		test	kwan,2
		mov	cx,512
		sjz	ega25
		mov	ymax,49
		push	ds
		xor	dx,dx
		int	10h
		pop	ds
ega25:		ncall	regkar
		test	iwan,64		;	Csak VGA:
		njnz	evh16		;	sajt karakterkszlet betltse
		test	kwan,4
		njnz	evh16
		ncall	ulykar
		mov	dx,3ceh
		mov	ax,5
		out	dx,ax
		push	0a000h
		xor	bx,bx
		mov	ax,406h
		sjmp	$+2
		out	dx,ax
		pop	es
		mov	dx,3c4h
		mov	ax,402h
		sjmp	$+2
		out	dx,ax
		xor	di,di
		mov	ax,704h
		nop
		sjmp	$+2
		out	dx,ax
ubop:		mov	wr vesa+256,di
		mov	si,256
		push	di
ubork:		dec	si
		mov	vesa[si],bh
		sjnz	ubork
		test	kwan,2
		mov	fs,charset1[di]
		mov	al,1
		sjz	uchap
		mov	fs,chr8set1[di]
		add	al,al
uchap:		pop	bp
		mov	dh,asctabl[bx]
		movzx	di,dh
		cmp	bh,vesa[di]
		push	bp
		sjne	uchut
		inc	vesa[di]
		shl	bp,12
		shl	di,5
		push	ax
		add	di,bp
		test	kwan,2
		push	bx
		mov	cx,8
		push	si
		sjnz	xuff
		add	cx,cx
xuff:		test	al,owan
		mov	bx,256
		sjz	uff
		push	bx
		mov	bx,wr vesa+256
		cmp	br crho1[bx+1],32
		pop	bx
		sjb	uff
		add	bx,bx
uff:		cmp	dh,"}"
		mov	bp,fs:[si]
		mov	dl,8
		sjne	ulop
		cmp	br vesa+256,0
		sje	ulop
		shr	bp,2
ulop:		shld	ax,bp,1
		rol	bp,2
		push	bp
		and	bp,3
		cmp	bp,3
		pop	bp
		sje	ujje
		and	al,254
ujje:		dec	dl
		sjnz	ulop
		stosb
		add	si,bx
		loop	uff
		pop	si
		pop	bx
		pop	ax
uchut:		inc	si
		inc	si
		inc	bl
		sjnz	uchap
		pop	di
		xor	di,2
		njnz	ubop

		test	kwan,2
		mov	bx,16
		mov	bp,offset charax
		sjz	huux
		shr	bx,1
		mov	bp,offset charax8
huux:		mov	si,offset settabl
		mov	dx,setveg-settabl
huncut:		lodsb
		xor	ah,ah
		shl	ax,5
		push	si
		mov	di,ax
		mov	si,bp
		mov	cx,bx
		add	ah,32
		rep	movsb
		xchg	ax,di
		mov	si,bp
		mov	cx,bx
		rep	movsb
		add	bp,bx
		dec	dx
		pop	si
		sjnz	huncut

		mov	dx,3c4h
		mov	ax,302h
		out	dx,ax
		inc	ax
		inc	ax
		nop
		sjmp	$+2
		out	dx,ax
		mov	dx,3ceh
		mov	ax,1005h
		nop
		sjmp	$+2
		out	dx,ax
		mov	ax,0e06h
		nop
		nop
		sjmp	$+2
		out	dx,ax

		mov	dx,3c4h
		mov	al,3
		nop
		sjmp	$+2
		out	dx,al
		inc	dx
		mov	al,32
		nop
		sjmp	$+2
		out	dx,al

evh16:		test	kwan,8
		mov	ax,1003h	;	16 httrszn
		sjnz	vtcha
		push	ds
		xor	bl,bl
		int	10h
		pop	ds
		test	iwan,64		;	Csak VGA:
		mov	dx,3cch		;	8-pixeles szlessg
		sjnz	vtcha
		in	al,dx
		mov	dx,3c2h
		and	al,0f3h
		nop
		sjmp	$+2
		out	dx,al
		mov	dx,3c4h
		mov	al,1
		nop
		sjmp	$+2
		out	dx,al
		inc	dx
		nop
		nop
		sjmp	$+2
		in	al,dx
		or	al,1
		nop
		nop
		sjmp	$+2
		out	dx,al
		mov	dx,3dah
		nop
		nop
		sjmp	$+2
		in	al,dx
		mov	dx,3c0h
		mov	al,13h
		nop
		sjmp	$+2
		out	dx,al
		xor	al,al
		nop
		nop
		sjmp	$+2
		out	dx,al
		mov	al,20h
		nop
		nop
		sjmp	$+2
		out	dx,al
vtcha:		ret

regkar:		mov	asctabl+89,34
		mov	asctabl+92,""
		mov	wr asctabl+96,"PC"
		mov	asctabl+98,"-"
		mov	wr asctabl+108,".."
		ret

ulykar:		test	kwan,4
		sjnz	regkar
		mov	asctabl+89,"`"
		mov	asctabl+92,"["
		mov	wr asctabl+96,"#@"
		mov	asctabl+98,"]"
		mov	wr asctabl+108,"}{"
		ret

co256:		mov	dx,3c8h		;	Hasznlt sznek ellltsa:
		out	dx,al		;	az alapkphez csak az els
		inc	dx		;	16 sznt hasznljuk, gy 240
coc256:		stosb			;	marad a grafiknak.
		stosb			;	Kln kezeljk a 256-szn,
		stosb			;	HICOLOR s TRUECOLOR mdokat!
		stosb
		inc	ax
		loop	coc256
		mov	es,paletta
		xor	di,di
		mov	cl,48
cocikl:		test	boot,3
		lodsb
		sjz	coot
		xor	al,al
		sjmp	schoot
coot:		test	vonan,128
		mov	ah,77
		sjnz	oxnan
		test	mode,32
		sjz	schoot
oxnan:		mul	ah
		push	dx
		xchg	ax,dx
		mov	ah,151
		lodsb
		mul	ah
		add	dx,ax
		mov	ah,28
		lodsb
		mul	ah
		add	ax,dx
		pop	dx
		test	conan,8
		mov	al,ah
		sjz	xon1
		shr	al,1
xon1:		stosb
		shr	al,2
		sjmp	$+2
		out	dx,al
		dec	cx
		test	conan,16
		mov	al,ah
		sjz	xon2
		shr	al,1
xon2:		stosb
		shr	al,2
		sjmp	$+2
		out	dx,al
		dec	cx
		test	conan,32
		mov	al,ah
		sjz	schoot
		shr	al,1
schoot:		stosb
		shr	al,2
		sjmp	$+2
		out	dx,al
		loop	cocikl

		xor	ax,ax
		mov	cl,64
zoll:		test	conan,1
		push	ax
		sjz	zred
		shr	al,1
zred:		stosb
		sjmp	$+2
		out	dx,al
		pop	ax
		test	conan,2
		push	ax
		sjz	zgreen
		shr	al,1
zgreen:		stosb
		sjmp	$+2
		out	dx,al
		pop	ax
		test	conan,4
		push	ax
		sjz	zblue
		shr	al,1
zblue:		stosb
		sjmp	$+2
		out	dx,al
		test	boot,3
		pop	ax
		sjnz	droot
		inc	ax
droot:		loop	zoll

;		xor	ax,ax
;		mov	cl,3*48
;coll:		test	boot,3
;		sjnz	scox
;		test	own,32
;		sjz	scox
;		mov	al,es:[di]
;scox:		stosb
;		shr	al,2
;		sjmp	$+2
;		out	dx,al
;		loop	coll

		xor	ax,ax
		mov	cl,63
coll:		test	conan,8
		push	ax
		sjz	czred
		shr	al,1
czred:		test	cl,3
		sjz	czoot
		test	own,32
		sjz	czox1
		mov	al,es:[di]
czox1:		stosb
		sjmp	$+2
		out	dx,al
		pop	ax
		test	conan,16
		push	ax
		sjz	czgreen
		shr	al,1
czgreen:	test	own,32
		sjz	czox2
		mov	al,es:[di]
czox2:		stosb
		sjmp	$+2
		out	dx,al
		pop	ax
		test	conan,32
		push	ax
		sjz	czblue
		shr	al,1
czblue:		test	own,32
		sjz	czox3
		mov	al,es:[di]
czox3:		stosb
		sjmp	$+2
		out	dx,al
czoot:		test	boot,3
		pop	ax
		sjnz	croot
		inc	ax
croot:		loop	coll

		push	bx
		xor	bx,bx
		mov	cl,128
boll:		test	boot,3
		sjnz	scox1
		test	own,32
		mov	al,bh
		sjz	scox1
		mov	al,es:[di]
scox1:		stosb
		shr	al,2
		test	boot,3
		sjmp	$+2
		out	dx,al
		sjnz	scox2
		test	own,32
		mov	al,bl
		sjz	scox2
		mov	al,es:[di]
scox2:		stosb
		shr	al,2
		test	boot,3
		sjmp	$+2
		out	dx,al
		sjnz	scox3
		test	own,32
		mov	al,ah
		sjz	scox3
		mov	al,es:[di]
scox3:		stosb
		shr	al,2
		sjmp	$+2
		out	dx,al
		add	ah,64
		and	ah,3*64
		sjnz	bobo
		add	bl,32
		and	bl,7*32
		sjnz	bobo
		add	bh,64
		and	bh,3*64
bobo:		loop	boll
		pop	bx
		ret

cohi:		push	cx		;	HICOLOR bellts
		lodsb
		mov	cl,8
		xor	ah,ah
		sub	cl,redsiz
		shr	ax,cl
		mov	cl,redscr
		shl	ax,cl
		xchg	ax,dx
		lodsb
		mov	cl,8
		xor	ah,ah
		sub	cl,gresiz
		shr	ax,cl
		mov	cl,grescr
		shl	ax,cl
		or	dx,ax
		lodsb
		mov	cl,8
		xor	ah,ah
		sub	cl,blusiz
		shr	ax,cl
		mov	cl,bluscr
		shl	ax,cl
		or	ax,dx
		pop	cx
		stosw
		stosw
		loop	cohi
		ret

cotrue:		push	cx		;	TRUECOLOR bellts
		xor	eax,eax
		mov	cl,redscr
		lodsb
		shl	eax,cl
		xchg	eax,edx
		xor	eax,eax
		mov	cl,grescr
		lodsb
		shl	eax,cl
		or	edx,eax
		xor	eax,eax
		mov	cl,bluscr
		lodsb
		shl	eax,cl
		or	eax,edx
		pop	cx
		stosd
		loop	cotrue
		ret
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
billmex		proc	far			;	Billentyzet- s egyb
		push	ds			;	megszaktsok cuccai
		xor	ax,ax
		push	cs
		mov	di,offset irqreg
		push	ax
		loop	bvissza

		push	cs
		mov	si,offset int007
		pop	ds
		mov	cl,8
		push	di
		mov	es,ax
		mov	di,ax
elmex:		movsw
		mov	ax,cs
		stosw
		loop	elmex
		mov	di,24h*4
		movsw
		mov	ax,cs
		stosw
		pop	di

		mov	si,8*4
		push	cs			;	Az INT 9-es megszakts
		mov	ds,cx			;	tirnytsval
		pop	es			;	ivartalantjuk az
		movsw				;	sszes	"veszlyes"
		movsw				;	billentyt (BREAK,
		movsw				;	PAUSE, CONTROL+ALT+DEL,
		movsw				;	PRINT SCREEN... stb.).
		mov	si,16h*4		;	Az INT 16H pedig az
		movsw				;	kezetes betket
		movsw				;	teszi elrhetv.
bvissza:	pop	es
		mov	si,di
		pop	ds
		mov	di,8*4
		cli
		movsw
		movsw
		movsw
		movsw
		mov	di,16h*4
		movsw
		movsw
		;mov	ax,40h
		sti
		;mov	es,ax
		pop	ds
		;mov	br es:[17h],icns
		ret

irq8:		push	ds
		push	bx
		mov 	bx,adat
		mov	ds,bx
		test	boot,2
		mov	bx,3
		sjz	beot
		cmp	bh,bszaml
		sje	creot
		dec	bszaml
		sjnz	beot
creot:		or	boot,128
beot:		cmp	bh,qszaml
		sje	beallit
		dec	qszaml
		sjnz	frisstov
		inc	szaml
beallit:	mov	qszaml,6
frisstov:	cmp	bh,friss
		sje	megfriss
		dec	friss
		sjnz	perctov
tovcik:		test	alabl[bx],3
		sjnz	torvix
		cmp	bh,tovabb[bx]
		mov	tszaml[bx],bh
		sje	torvix
		dec	tovabb[bx]
torvix:		test	hexan,64
		sjnz	tovtov
		cmp	bh,tszaml[bx]
		sje	tovtov
		dec	tszaml[bx]
		sjnz	tocsik
		cmp	bh,tovabb[bx]
		sje	tovtov
		test	gfabl[bx],1
		sjnz	cocsyk
		push	ax
		mov	al,gszel[bx+1]
		cmp	al,sorsze
		sjb	tocsyk
		mov	al,kepsor
		sub	al,gmags[bx+1]
		sjbe	tocsyk
		dec	al
		sjnz	csocsyk
		inc	ax
csocsyk:	cmp	al,tovabb[bx]
		sjae	tocsyk
		mov	tovabb[bx],al
tocsyk:		pop	ax
cocsyk:		dec	tovabb[bx]
tovtov:		mov	tszaml[bx],182
tocsik:		dec	bx
		sjns	tovcik
megfriss:	mov	friss,2
perctov:	test	hexan,32
		sjnz	perceg
		cmp	perc,0
		sje	perceg
		dec	perc
		sjnz	csilltov
		cmp	sperc,0
		sje	perceg
		dec	sperc
		sjnz	sctov
		or	mode,4
		or	gwan,1
perceg:		mov	bx,scszaml
		mov	sperc,bx
sctov:		mov	perc,1092
csilltov:	test	mode,4
		pop	bx
		sjz	irq8tov
		cmp	csillszaml,0
		sje	csillog
		dec	csillszaml
		sjnz	irq8tov
		or	br output,16
csillog:	mov	csillszaml,3
irq8tov:	pop	ds
		jmp	irqreg

xbirtox:	cmp	al,0e2h
		mov	scutolso,ah
		sjae	xbirv
		cmp	al,0e0h
		sjae	xcissz
		or	al,al
		sjns	xbirv
		njmp	birtov
xbvissz:	;mov	smodex,es
		inc	fbalap
		ncall	ormod
xbirv:		njmp	xbirveg
xnumell:	njmp	numell

birq9:		push	ax
		mov	ax,adat
		push	ds
		mov	ds,ax
		push	es
		xor	ax,ax
		test	suan,128
		mov	es,ax
		mov	perc,ax
		mov	sperc,ax
		in	al,60h
		sjnz	xbirveg
		or	al,al
		sjz	xbirtox
		sjs	xbirtox
xcissz:		test	mode,4
		mov	ah,br es:[417h]
		sjnz	xbvissz
		test	ah,3
		sjz	illen
		or	ah,3
illen:		cmp	al,37h		;	PRINT SCREEN/SYS RQ
		mov	scilla,ah
		sje	prtscrn
		cmp	al,45h		;	PAUSE
		sje	pause
		cmp	al,46h		;	BREAK
		sje	break
		cmp	al,52h		;	CONTROL+ALT+INS
		sje	antrol
		cmp	al,53h		;	CONTROL+ALT+DEL
		sjne	xnumell
antrol:		mov	ah,12
		sjmp	valtas
prtscrn:	cmp	scelozo,0e0h
		sjne	birtov
		cmp	al,scutolso
		sje	xbirveg
		cmp	scutolso,38h
		sje	xbirveg
control:	mov	ah,4
valtas:		push	ax
		mov	ax,40h
		mov	es,ax
		pop	ax
		push	ax
		mov	al,br es:[17h]
		and	al,ah
		cmp	al,ah
		pop	ax
		sjne	mirmeg
		cmp	ah,12
		sjne	birveg
		cmp	al,52h
		sjne	nemins
		inc	ax
nemins:		xor	br es:[17h],ah
prtscrn2:	inc	ax
birveg:		mov	scancode,al
		mov	scutolso,al
xbirveg:	mov	scelozo,al
irveg:		in	al,61h
		nop
		push	ax
		nop
		or	al,80h
		nop
		sjmp	$+2
		out	61h,al
		nop
		pop	ax
		nop
		pop	es
		sjmp	$+2
		out	61h,al
		pop	ds
		mov	al,20h
		sjmp	$+2
		out	20h,al
		pop	ax
		iret
pause:		test	ah,4
		sjnz	birtov
		cmp	scelozo,1dh
		sje	birveg
break:		cmp	scelozo,0e0h
		sje	birveg
birtov:		mov	ah,scilla
artov:		and	ah,15
ortov:		or	al,al
		mov	scelozo,al
		sjz	irveg
		push	bx
		mov	bx,nemscv-nemsca-1
scalp:		cmp	al,nemsca[bx]
		sjne	scalc
		cmp	bl,semsca-nemsca
		sjb	axix
		test	ah,12
		sjz	axix
		sjmp	breir
mirmeg:		sjmp	nirmeg
scalc:		dec	bx
		sjns	scalp
breir:		or	al,al
		sjs	nreir
		ncall	billbe
nreir:		cmp	bl,semsca-nemsca
		sjl	axix
		pop	bx
		sjmp	irveg
nirmeg:		cmp	al,37h
		sjne	numell
		sjmp	prtscrn2
axix:		inc	bx
		pop	bx
		sjz	irveg
		pop	es
		pop	ds
		pop	ax
		jmp	billreg
numell:		cmp	al,35h
		mov	ah,scilla
		sjne	numtab
		cmp	scelozo,0e0h
		sjne	birtov
		mov	al,7fh
		sjmp	birtov
numtab:		cmp	scelozo,0e0h
		sje	artov
		test	ah,32
		sjz	artov
		and	ah,15
irtov:		sjnz	ortov
		push	bx
		mov	bx,nuscav-nuscan-1
nulp:		cmp	al,nuscan[bx]
		sjne	nulc
		or	bx,bx
		mov	al,nuscav[bx]
		sjnz	nulc
		test	mode,16
		sjz	nulc
		mov	al,0bh
nulc:		dec	bx
		sjns	nulp
		pop	bx
		sjmp	irtov

birq16:		cmp	ah,2
		sjb	bibibi
		jmp	b16reg
bilvan:		push	bx
		mov	bx,scanv-scans-1
bilcik:		cmp	al,scans[bx]
		sje	bilbo
		dec	bx
		sjns	bilcik
		pop	bx
		sjmp	bili
bilbo:		mov	al,scanv[bx]
		inc	bx
		pop	bx
		pop	ds
		njmp	iret2
bibibi:		xor	al,al
		push	ds
		push	ax
		mov	ax,adat
		mov	ds,ax
		pop	ax
		xchg	al,scancode
		or	al,al
		sjnz	bilvan
bili:		ncall	billki
		sjz	ficcen
		push	cx
		test	mode,16
		push	si
		mov	cx,biri-csiri
		push	di
		mov	si,offset csiriz
		mov	di,offset csiri
		sjz	hanga
		add	di,cx
		mov	cx,bviri-biri
hanga:		push	cx
		mov	cx,egyev-egyeb
		push	si
		mov	si,offset tobbi
		push	di
		mov	di,offset egyeb
hangya:		cmp	ax,[si]
		sjne	higa
		cmp	br [di],-1
		sjae	higa
		mov	al,[di]
		mov	ah,-1
higa:		inc	si
		inc	di
		inc	si
		loop	hangya
		pop	di
		or	ah,ah
		pop	si
		pop	cx
		sjs	szumo
manga:		cmp	ax,[si]
		sjne	lica
		cmp	br [di],-1
		sjae	lica
		mov	al,[di]
		mov	ah,-1
lica:		inc	si
		inc	di
		inc	si
		loop	manga
szumo:		pop	di
		or	ah,ah
		pop	si
		mov	ah,0
		pop	cx
		sjs	cica
		ncall	billki
		xor	ax,ax
		dec	ax
ficcen:		pop	ds
		sjmp	iret2
cica:		pop	ds
		pushf
		push	bx
		mov	bx,40h
		push	ds
		mov	ds,bx
		mov	bl,br ds:[17h]
		and	bl,64
		sjz	megvan
		or	al,al
		sjz	megvan
		cmp	al,71
		sjae	megvan
		cmp	al,36
		sjae	kivon
		add	al,35
		sjmp	megvan
kivon:		sub	al,35
megvan:		pop	ds
		pop	bx
		popf
iret2:		pushf
		push	ax
		mov	ax,adat
		push	ds
		mov	ds,ax
		test	suan,128
		pop	ds
		sjnz	sutty
putty:		pushf
		mov	ah,1
		call	b16reg
		sjz	sutty
		pushf
		xor	ax,ax
		call	b16reg
		sjmp	putty
sutty:		pop	ax
		popf
		sti
		ret	2

ioerr:		pop	ax
		pop	ax
		popf
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	si
		pop	di
		pop	bp
		stc
		pop	ds
		pop	es
		sjmp	iret2

ikil:		mov	cs:oldax,ax
		pop	ax
		inc	ax
		inc	ax
		push	ax
		mov	ax,cs:oldax
iveg:		iret

int3:		iret

oldax		dw	0
int007		dw	ikil,ikil,ikil,int3,ikil,ikil,ikil,ikil,ioerr
irqreg		dd	0
billreg		dd	0
b16reg		dd	0
irqcim		dw	irq8,egyrut,birq9,egyrut,birq16,egyrut
scancim		label	dword
		dw	scancode,adat
billmex		endp

billbe:		xchg	bx,billmut
		cmp	bl,2*billp
		sjae	bilbe
		inc	bx
		inc	bx
		mov	billen[bx-2],ax
bilbe:		mov	billen[bx],0
		xchg	bx,billmut
		ret

billki:		or	ah,ah
		push	billen
		sjnz	bimbo
		push	bx
		xor	bx,bx
		cmp	bx,billmut
		sje	bixxo
bilfi:		inc	bx
		inc	bx
		mov	ax,billen[bx]
		cmp	bx,billmut
		mov	billen[bx-2],ax
		sjb	bilfi
		sub	billmut,2
bixxo:		mov	billen[bx],0
		pop	bx
bimbo:		pop	ax
		or	ax,ax
		ret
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
bevitel		proc	far		;	Beviteli mez szerkesztse:
		ncall	bev		;	ez a kijelzssel prhuzamosan,
		ret			;	folyamatosan trtnik!!!
bevitel		endp

bev:		call	egbevit
		mov	cx,behany
		xor	bx,bx
		jcxz	xebev
		mov	al,behup
buxi:		inc	bx
		mov	ah,behup[bx]
		cmp	bx,cx
		mov	behup[bx-1],ah
		sjb	buxi
		dec	br behany
		xor	ah,ah
		or	al,al
		sjns	zuxi
		neg	al
		inc	ah
zuxi:		cmp	al,113
		sjne	nembeo
		mov	al,146
		sjmp	nembeo
xebev:		mov	ah,1
		int	16h
		sjz	semmic
		or	ah,ah
		sjs	bev
		sjnz	xebbo
		int	16h
nembeo:		or	ax,ax
		sjs	bev
		or	ah,ah
		mov	bx,offset egctabl-1
		sjz	nebbo
		xlat
xebbo:		xor	ah,ah
nebbo:		mov	bl,ablak
		and	bx,3
		mov	cx,40h
		inc	bx
		add	bx,bx
		mov	es,cx
		mov	di,dkurz[bx]
		mov	cx,bhmax
		mov	ah,es:[17h]
		push	ds
		and	ah,128
		or	al,al
		pop	es
		sjs	vezerles
		cmp	al,112
jaebev:		sjae	bev
		or	ah,ah
		sjnz	insert
		cmp	di,cx
		sjae	jmpbev
		add	di,dszcim[bx]
		sjmp	over
semmic:		clc
		ret
jmpbev:		njmp	bev
insert:		mov	cx,dhossz[bx]
		mov	si,cx
		sub	cx,di
		sjb	jmpbev
		add	di,dszcim[bx]
		jcxz	over
		cmp	si,bhmax
		sjb	insok
		dec	cx
		dec	si
insok:		add	si,dszcim[bx]
		mov	di,si
		dec	si
		std
		rep	movsb
		cld
over:		or	br output,16
		stosb
		sub	di,dszcim[bx]
		cmp	di,bhmax
		sjae	beveg
		inc	dkurz[bx]
beveg:		or	ah,ah
		sjnz	nemover
		cmp	di,dhossz[bx]
		sjbe	bevell
nemover:	cmp	dhossz[bx],bhmax
		sjae	bevell
		inc	dhossz[bx]
		sjmp	bevell
vezerles:	cmp	al,235
		sjae	jaebev
		mov	si,ax
		and	si,127
		add	si,si
		mov	bp,dszcim[bx]
		mov	cx,dhossz[bx]
		add	cx,bp
		xor	dx,dx
		mov	honnan,bx
		call	ugr[si]
		mov	bx,honnan
bevell:		mov	si,wr uzemmod
		and	si,16
		mov	cx,3
		shr	si,cl
		mov	cl,dabsze[si]
		dec	cx
		mov	dx,dabpoz[bx]
		mov	ax,dkurz[bx]
		or	ax,ax
		sjs	bevok
		cmp	ax,dx
		sjb	aboda
		sub	ax,cx
		sjbe	bevok
		cmp	ax,dx
		sjbe	bevok
aboda:		mov	dabpoz[bx],ax
bevok:		mov	ax,dhossz[bx]
		cmp	ax,cx
		sja	bebev
		mov	dabpoz[bx],0
bebev:		njmp	bev

ctbsp:		push	di
		ncall	ctbal
		ncall	ctjobb
		ncall	sforw
		cmp	si,ax
		sjb	ctbvok
		lea	ax,[di+1]
		push	ax
		sjmp	ctnker
ctbvok:		push	di
		cmp	si,cx
		sjae	ctnker
		ncall	sbackw
ctnker:		ncall	ctbal
		cmp	si,bp
		sjbe	ctbker
ctujra:		ncall	sforw
ctbker:		pop	bp
		sub	bp,di
		pop	ax
		sja	ctorl
		mov	dkurz[bx],ax
		ret
ctorl:		ncall	torles
		mov	di,dkurz[bx]
		or	di,di
		sjle	semmi
		mov	cx,dhossz[bx]
		cmp	di,cx
		sjb	bal
		mov	bp,dszcim[bx]
		add	cx,bp
		lea	si,[di][bp]
		dec	si
		cmp	dl,[si]
		sje	ujtorl
		cmp	br [si],89
		sjb	semmi
ujtorl:		push	di
		push	di
		ncall	sbackw
		sjmp	ctujra

insf:		push	ds
		mov	ds,dx
		xor	br ds:[417h],128
		pop	ds
		sjmp	outv

bal:		or	di,di
		sjle	semmi
		dec	di
		mov	dkurz[bx],di
outv:		or	br output,16
semmi:		ret

jobb:		cmp	di,dhossz[bx]
		sjae	semmi
		cmp	di,bhmax-1
		sjae	semmi
		inc	dkurz[bx]
		sjmp	outv

endf:		mov	di,dhossz[bx]
		cmp	di,bhmax
		sjb	endben
		dec	di
endben:		mov	dkurz[bx],di
		sjmp	outv

home:		mov	dabpoz[bx],dx
		mov	di,dx
		sjmp	endben

backsp:		cmp	di,bhmax-1
		sjne	bacok
		lea	si,[di][bp]
		cmp	si,cx
		sjae	bacok
		cmp	dl,[si]
		mov	[si],dl
		sjne	delf
bacok:		or	ah,ah
		sjz	bal
		ncall	bal

delf:		mov	bp,1

torles:		mov	cx,dhossz[bx]
		cmp	bp,cx
		sjae	ttorl
		sub	cx,di
		sjbe	semmi
		cmp	bp,cx
		sjb	torok
		mov	bp,cx
		sjmp	tornem
torok:		add	di,dszcim[bx]
		lea	si,[di][bp]
		rep	movsb
tornem:		sub	dhossz[bx],bp
		sjmp	outv

ctdel:		mov	bp,dhossz[bx]
		sub	bp,di
		sjae	torles
outv2:		sjmp	outv

ttorl:		mov	dhossz[bx],dx
		mov	dkurz[bx],dx
		sjmp	outv2

ctins:		lea	si,[di][bp]
		cmp	si,cx
		sjae	ttorl
		lea	ax,[bp+bhmax-1]
		cmp	si,ax
		sjae	ttorl
		mov	bp,di
		xor	di,di
		mov	dkurz[bx],di
		sjmp	torles

ctcaps:		xor	mode,16
		sjmp	outv2

ctbal:		lea	si,[di][bp]
		cmp	si,cx
		sjae	ctjkrb
		cmp	dl,[si]
		sje	ctjkrb
		cmp	br [si],89
		sjb	ctjknb
ctjkrb:		ncall	sbackw
ctjknb:		ncall	sbackw
		cmp	si,bp
		sjbe	ctbjok
		ncall	sbackw
		cmp	dl,[si]
		sje	ctbjok
		cmp	br [si],89
		sjae	ctbjok
		ncall	sforw
		ncall	sforw
		sjmp	sbackw

sforw:		lea	si,[di][bp]
		lea	ax,[bp+bhmax-1]
		cmp	si,cx
		sjae	fbmegv
		cmp	si,ax
		sjae	fbmegv
		cmp	dl,[si]
		sje	fbker
		cmp	br [si],89
		sjae	fbker
fjker:		inc	si
		cmp	si,cx
		sjae	fbmegv
		cmp	dl,[si]
		sje	fbmegv
		cmp	br [si],89
		sjae	fbmegv
		cmp	si,ax
		sjb	fjker
		sjmp	fbmegv
fbker:		inc	si
		cmp	si,cx
		sjae	fbmegv
		cmp	dl,[si]
		sje	fbtov
		cmp	br [si],89
		sjb	fbmegv
fbtov:		cmp	si,ax
		sjb	fbker
fbmegv:		mov	di,si
		sub	di,bp
		mov	dkurz[bx],di
		lea	si,[di][bp]
ctbjok:		njmp	outv

ctjobb:		lea	si,[di][bp]
		cmp	dl,[si]
		sje	ctkerb
		cmp	br [si],89
		sjb	ctnkrb
ctkerb:		ncall	sforw
ctnkrb:		ncall	sforw
		cmp	si,ax
		sjae	ctbjok
		ncall	sforw
		cmp	si,cx
		sjae	ctbjok
		cmp	dl,[si]
		sje	ctbjok
		cmp	br [si],89
		sjae	ctbjok

sbackw:		lea	si,[di][bp]
		lea	ax,[bp+bhmax-1]
		cmp	si,bp
		sjbe	fbmegv
		cmp	si,cx
		sjae	bbker
		cmp	dl,[si]
		sje	bbker
		cmp	br [si],89
		sjae	bbker
bjker:		dec	si
		cmp	dl,[si]
		sje	fbmegv
		cmp	br [si],89
		sjae	fbmegv
		cmp	si,bp
		sja	bjker
		sjmp	fbmegv
bbker:		dec	si
		cmp	dl,[si]
		sje	bbtov
		cmp	br [si],89
		sjb	fbmegv
bbtov:		cmp	si,bp
		sja	bbker
bmegv:		sjmp	fbmegv

ctent:		push	ds
		mov	si,dszcim[bx]
		mov	di,offset bevtar
		mov	cx,bhmax/2
		pop	es
ctcikl:		mov	ax,[di]
		xchg	ax,[si]
		inc	si
		inc	si
		stosw
		loop	ctcikl
		mov	ax,dhtar
		or	ax,ax
		sjnz	csere
		cmp	ax,dhossz[bx]
		sje	outv1
csere:		xchg	ax,dhossz[bx]
		mov	dhtar,ax
		mov	ax,dktar
		xchg	ax,dkurz[bx]
		mov	dktar,ax
		mov	ax,datar
		xchg	ax,dabpoz[bx]
		mov	datar,ax
		xor	mode,64
outv1:		njmp	outv

prscn:		xor	mode,32
ormod:		mov	akhin,0
		or	own,16
		or	mode,128
		and	koppany,64
		ret

emmore:		or	alabl[si],160
		ret

return:		mov	al,ablak
		cbw
aturn:		mov	si,ax
		test	alabl[si],1
		pushf
		and	alabl[si],241
		test	uzemmod,16
		sjz	netcha
		and	alabl[si],254
netcha:		or	alabl[si],32
		test	pufabl[si],32
		sjnz	nemmor
		or	alabl[si],2
		sjmp	xemmor
nemmor:		or	alabl[si],8
		test	pufabl[si],4
		sjnz	pemmor
xemmor:		mov	tovabb[si],ah
		mov	tszaml[si],ah
		mov	scroll[si],-1
		mov	al,fmaszk[si+4]
		not	al
		and	br output+1,al
		mov	al,fmaszk[si]
		mov	ah,al
		or	output,ax
		mov	alass[si],1
pemmor:		popf
		sjnz	emmore
		mov	al,pufabl[si]
		and	ax,3
		mov	puffer,al
		mov	si,ax
		call	pret
		mov	al,85
		call	wchar
		ncall	endf
		or	di,di
		sjz	nemtar
		ncall	home
		push	ds
		mov	si,dszcim[bx]
		mov	di,offset bevtar
		mov	cx,bhmax/2
		pop	es
		rep	movsw
		mov	si,dhossz[bx]
		mov	dhtar,si
		mov	bevtar[si],113
		mov	dktar,cx
		mov	datar,cx
		mov	si,offset bevtar
		mov	cx,dhossz[bx]

		pushad
		push	ds
		push	es

;		mov	es,filepuf
;		xor	di,di
;		mov	bp,1024
;		and	koppany,64
;		push	es
;		call	bpmaxtom
;		mov	ax,adat
;		pop	ds
;		mov	es,ax
;		push	ax
;		xor	ax,ax
;		push	cx
;		mov	cx,92
;		mov	di,offset ziptab
;		mov	es:zelyik,al
;		rep	stosw
;		pop	cx
;		mov	di,offset vesa
;		call	fdunszvip
;		pop	ds

		call	wstring
		call	pont

		call	proba
		pop	es
		pop	ds
		popad

nemtar:		ncall	ttorl
		call	pret
		and	mode,191
reset:		pop	ax
		stc
nemmab:		ret

shtab:		mov	cx,-1
		sjmp	bab

tab:		mov	cx,1
bab:		mov	al,ablak
		and	ax,3
		mov	si,ax
iblak:		add	al,cl
		and	al,3
		test	tewan,1
		sjz	tablak
		test	pufabl[si],8
		sjnz	tablak
		cmp	ax,si
		mov	bx,ax
		sje	nemmab
		test	pufabl[bx],12
		sjnz	iblak
		sjmp	tablak

f1:		xor	al,al
		sjmp	xtab

f2:		mov	al,1
		sjmp	xtab

f3:		mov	al,2
		sjmp	xtab

f4:		mov	al,3
xtab:		push	ax
		mov	al,uzemmod
		and	al,12
		cmp	al,12
		pop	ax
		sje	tablak
		or	br output,15
tablak:		mov	cl,al
		xchg	al,ablak
		xor	cl,al
		cbw
		mov	bx,ax
		and	pufabl[bx],191
		test	xmode,64
		mov	al,fmaszk[bx]
		sjz	traok1
		or	alabl[bx],16
traok1:		and	ablak,3
		or	gfabl[bx],2
		test	xmode,64
		mov	bl,ablak
		sjz	traok2
		or	alabl[bx],16
traok2:		or	al,fmaszk[bx]
		or	gfabl[bx],2
		or	pufabl[bx],64
		or	al,48
		or	br output,al
		mov	al,uzemmod
		and	al,12
		sjz	ablac3
		cmp	al,12
		sje	ablac2
		test	cl,2
		sjz	ablac2
		mov	br output,-1
ablac3:		mov	si,3
abcikl:		test	alabl[si],1
		sjnz	abtov
		or	alabl[si],16
abtov:		dec	si
		sjns	abcikl
ablac2:		njmp	ablac

scesc:		mov	al,uzemmod
		mov	ah,al
		and	al,12
		sub	al,4
		sjmp	eslak

ctesc:		mov	al,uzemmod
		mov	ah,al
		and	al,12
		add	al,4
eslak:		and	al,12
		sjnz	eslok
		mov	xuzmo,12
		sjmp	eslok2
eslok:		mov	xuzmo,al
eslok2:		and	ah,240
		or	al,ah
essex:		test	al,16
		sjnz	vessex
		ncall	ormod
vessex:		mov	uzemmod,al
		mov	br output,-1
		mov	bl,ablak
		xor	bh,bh
bablac:		and	wr pfadat,251*(256+1)
		and	wr pfadat+2,251*(256+1)
		and	pfadat+4,251
		and	wr alabl,240*(256+1)
		and	wr alabl+2,240*(256+1)
		or	wr alabl,4*(256+1)
		or	wr alabl+2,4*(256+1)
		xchg	ax,dx
		mov	wr tovabb,ax
		mov	wr tovabb+2,ax
		mov	wr tszaml,ax
		mov	wr tszaml+2,ax
		mov	br output+1,al
		xchg	ax,dx
		or	wr alabl,16*(256+1)
		or	wr alabl+2,16*(256+1)
ablac:		or	wr pufabl,16*(256+1)
		or	wr pufabl+2,16*(256+1)
		and	pufabl[bx],239
		or	alabl[bx],32
		and	al,12
		sjz	puflac
		cmp	al,12
		sjne	vallac
		and	wr pufabl,239*(256+1)
		and	wr pufabl+2,239*(256+1)
		or	wr alabl,32*(256+1)
		or	wr alabl+2,32*(256+1)
vallac:		xor	bl,1
		and	pufabl[bx],239
		or	alabl[bx],32
puflac:		or	wr pfadat,256+1
		or	wr pfadat+2,256+1
		or	pfadat+4,1
		mov	bl,3
pufcikl:	mov	al,pufabl[bx]
		test	al,24
		sjnz	puftov
		test	al,4
		sjz	pufren
		mov	al,4
		sjmp	pufsje
pufren:		and	al,3
pufsje:		cbw
		mov	si,ax
		and	pfadat[si],254
puftov:		dec	bx
		sjns	pufcikl
		pop	ax
		clc
nemesc:		ret

shesc:
escf:		mov	al,uzemmod
		test	al,12
		sjz	xcser
		mov	xuzmo,al
		and	al,240
		sjmp	essex2
xcser:		and	xuzmo,12
		sjz	nemesc
xxcser:		and	al,240
		or	al,xuzmo
essex2:		njmp	essex

breakf:		ncall	ormod
		or	smode,128
		xor	ax,ax
		mov	lass,-1
		;mov	smodex,ax
		inc	fbalap
		mov	dabpoz+10,ax
		mov	dabpoz+12,ax
		mov	dabpoz+14,ax
		mov	dabpoz+16,ax
		ncall	pausef
		mov	al,uzemmod
		;test	al,12
		;sjnz	bxcser
		;and	xuzmo,12
		;sjnz	xxcser
bxcser:		sjmp	essex2

sctab:		mov	bl,ablak
		and	bx,3
		mov	al,pufabl[bx]
		mov	cl,al
		dec	ax
		sjmp	xsctt

cttab:		mov	bl,ablak
		and	bx,3
		mov	al,pufabl[bx]
		mov	cl,al
		inc	ax
xsctt:		and	al,3
		and	cl,12
		or	al,cl
		sjmp	ufset2

shf9:
f9:		mov	bl,ablak
		and	bx,3
		mov	al,pufabl[bx]
		xor	al,4
		sjmp	pufset2

shf10:
f10:		mov	bl,ablak
		and	bx,3
		mov	al,pufabl[bx]
		xor	al,8
		sjmp	ufset2

shf1:		xor	al,al
		sjmp	shfs

shf2:		mov	al,1
		sjmp	shfs

shf3:		mov	al,2
		sjmp	shfs

shf4:		mov	al,3
shfs:		and	ax,3
		push	ax
		ncall	xxtab
		pop	bx
		mov	al,pufabl[bx]
		and	al,15
		sjmp	pufset2

f5:		xor	al,al
ufset:		mov	bl,ablak
		and	bx,3
ufset2:		or	gfabl[bx],2
		and	gfabl[bx],251
pufset:		mov	bl,ablak
		and	bx,3
pufset2:	and	pufabl[bx],192
		or	pufabl[bx],al
		test	al,4
		sjz	pufog
		mov	al,4
		sjmp	puffog
pufog:		and	al,3
puffog:		cbw
		mov	si,ax
		mov	al,phany[si]
		sub	al,kepsor
		sjae	pifpuf
		mov	al,ah
pifpuf:		cmp	si,4		;	Szjegyzk!!!
		mov	pksor[bx],al
		sje	spiff
spuff:		and	pufabl[bx],223
spucc:		test	alabl[bx],1
		sjz	nemful
		ncall	ormod
nemful:		and	alabl[bx],244
		mov	eltolas[bx],bh
		mov	scroll[bx],bh
		mov	tovabb[bx],bh
		mov	tszaml[bx],bh
		or	alabl[bx],32
		mov	al,fmaszk[bx]
		or	br output,al
		or	br output,32
		or	al,fmaszk[bx+4]
		not	al
		and	br output+1,al
		njmp	puflac

f6:		mov	al,1
puffset:	njmp	ufset

spiff:		test	pfadat[si],8
		sjz	spuff
;		push	si
;		xchg	ax,si
;		xchg	al,ah
;		add	si,si
;		xchg	ax,si
;		mov	ax,sortab[si]
;		cmp	ax,sortab[si+2]
;		pop	si
;		sje	spuff
		;mov	al,phany[si]
		;cmp	al,karsor
		;sjbe	spuff
		mov	pksor[bx],bh
		or	pufabl[bx],32
		sjmp	spucc

f7:		mov	al,2
		sjmp	puffset

f8:		mov	al,3
		sjmp	puffset

shf5:		mov	al,8
		sjmp	puffset

shf6:		mov	al,9
		sjmp	puffset

shf7:		mov	al,10
		sjmp	puffset

shf8:		mov	al,11
		sjmp	puffset

shf12:
f11f:		mov	al,uzemmod
		and	al,224
		add	al,32
		sjmp	lepcso

shf11:
f12f:		mov	al,uzemmod
		and	al,224
		sub	al,32
lepcso:		sjc	semmif
lelenc:		and	al,224
		and	uzemmod,31
		or	br ouikon+14,128
		or	uzemmod,al
outv3:		njmp	outv
xxtab:		ncall	xtab
semmif:		ret

ctrlp:
pausef:		mov	al,lass
		xor	al,16
		and	al,16
		mov	lass,al
		inc	ax
		test	uzemmod,16
		mov	ah,al
		mov	wr alass,ax
		mov	wr alass+2,ax
		sjnz	outv3
		or	wr alabl,32*(256+1)
		or	wr alabl+2,32*(256+1)
		or	br output,15
		ret

ctpgup:		ncall	blkeps
		sjmp	felfel

ctfel:		mov	al,-1
		sjmp	felfel

fel:		mov	al,1
felfel:		push	bx
		shr	bx,1
		mov	ah,fmaszk[bx+3]
		mov	tovabb[bx-1],bh
		test	alabl[bx-1],1
		sjz	vanf
		or	alabl[bx-1],160
		sjmp	vanf

ctpgdn:		ncall	blkeps
		sjmp	lele

ctle:		mov	al,-1
		sjmp	lele

lef:		mov	al,1
lele:		push	bx
		shr	bx,1
		mov	ah,fmaszk[bx-1]
vanf:		cmp	bh,scroll[bx-1]
		sje	fanfan
		cmp	al,scroll[bx-1]
		sjb	fanfan
		cmp	al,2
		sjbe	vanvan
fanfan:		test	gfabl[bx-1],1
		push	ax
		mov	ah,kepsor
		sjnz	lollo
		push	ax
		mov	al,gszel[bx]
		cmp	al,sorsze
		pop	ax
		sjb	lollo
		sub	ah,gmags[bx]
		sja	foffo
		mov	ah,kepsor
		sjmp	lollo
foffo:		dec	ah
		cmp	ah,tovabb[bx-1]
		sjae	lollo
		mov	tovabb[bx-1],ah
lollo:		cmp	al,ah
		sjae	semsem
		sub	tovabb[bx-1],al
		sjae	sansan
semsem:		mov	tovabb[bx-1],bh
sansan:		pop	ax
vanvan:		mov	tszaml[bx-1],bh
		mov	scroll[bx-1],al
		and	alabl[bx-1],247
		mov	al,fmaszk[bx-1]
		push	ax
		or	al,fmaszk[bx+3]
		not	al
		and	br output+1,al
		pop	ax
		or	output,ax
fleok:		mov	alass[bx-1],1
bsemmi:		pop	bx
		ret

pgup:		push	bx
		shr	bx,1
		test	alabl[bx-1],1
		sjz	pgup2
		or	alabl[bx-1],160
pgup2:		and	alabl[bx-1],247
		cmp	dl,pksor[bx-1]
		sje	bsemmi
		or	pufabl[bx-1],32
		mov	tovabb[bx-1],bh
		mov	tszaml[bx-1],bh
		ncall	alkeps
		sub	pksor[bx-1],al
		sjae	pgok
		njmp	cthomx2

pgdn:		push	bx
		shr	bx,1
		mov	al,pufabl[bx-1]
		test	al,4
		sjz	pggg
		mov	al,4
		sjmp	pgggg
pggg:		and	al,3
pgggg:		cbw
		mov	si,ax
		mov	ah,phany[si]
		sub	ah,kepsor
		sjbe	cthomx
		ncall	alkeps
		add	al,pksor[bx-1]
		cmp	al,ah
		sjb	pogow
		mov	al,ah
pogon:		and	pufabl[bx-1],223
pogow:		and	alabl[bx-1],247
		mov	tszaml[bx-1],bh
pogo:		mov	pksor[bx-1],al
pgok:		or	alabl[bx-1],32
		mov	al,fmaszk[bx-1]
		or	br output,al
		or	al,fmaszk[bx+3]
		not	al
		and	br output+1,al
		njmp	fleok

ctend:		push	bx
		shr	bx,1
		mov	al,pufabl[bx-1]
		test	al,4
		sjz	pggg2
		mov	al,4
		sjmp	pgggg2
pggg2:		and	al,3
pgggg2:		cbw
		mov	si,ax
		mov	al,phany[si]
		sub	al,kepsor
		sjae	pogon
bsemmi2:	pop	bx
psemm:		ret

cthom:		push	bx
		shr	bx,1
		and	alabl[bx-1],247
		test	alabl[bx-1],1
		sjz	cthomx
		or	alabl[bx-1],160
cthomx:		cmp	dl,pksor[bx-1]
		sje	bsemmi2
		or	pufabl[bx-1],32
		mov	tovabb[bx-1],bh
		mov	tszaml[bx-1],bh
cthomx2:	mov	ax,dx
		sjmp	pogo

ctpsn:		mov	al,5+0*8
		call	setpath
		xor	si,si
ckeres:		mov	ax,si
		call	sztram4
		mov	wr kernev+4,bx
		mov	wr kernev+6,ax
		mov	dx,offset kernev
		xor	cx,cx
		mov	ah,4eh
		int	21h
		sjc	psmegv
		inc	si
		cmp	si,9999
		sjb	ckeres
psmegv:		mov	ah,3ch
		int	21h
		sjc	psemm
		mov	file,ax
		ncall	regkar
		mov	al,ablak
		cbw
		mov	si,ax
		mov	al,pufabl[si]
		test	al,4
		sjz	psis
		mov	al,4
		sjmp	psiss
psis:		and	al,3
psiss:		mov	bx,ax
		mov	cl,phany[bx]
		mov	ch,bh
		jcxz	uresf
		add	bx,bx
		mov	es,pseg[bx+2]
		xchg	bl,bh
		lea	si,sortab[bx]
		mov	mennyit,13
		mov	bx,file
pricikl:	push	cx
		mov	di,[si]
		mov	cx,[si+2]
		sub	cx,di
		sjbe	sures
		mov	br mennyit+1,10
		mov	dx,offset vesa
psorcikl:	push	cx
		mov	cl,1
		mov	bx,offset asctabl
		mov	al,es:[di]
		cmp	al,109
		sje	nypont
		cmp	al,97
		sje	ypc
		cmp	al,96
ypc:		sje	nypc
		cmp	al,112
		sjae	prorj
		xlat
nyvis:		mov	vesa,al
		mov	bx,file
		mov	ah,40h
		int	21h
		pop	cx
		inc	di
		loop	psorcikl
sures:		cmp	ch,br mennyit+1
		sje	surex
		mov	dx,offset mennyit
		mov	cl,2
		mov	ah,40h
		int	21h
surex:		pop	cx
		inc	si
		inc	si
		loop	pricikl
uresf:		ncall	ulykar
fclose:		mov	bx,file
		mov	ah,3eh
		njmp	dosint

blkeps:		shr	bx,1
		ncall	alkeps
		add	bx,bx
		ret

alkeps:		test	pufabl[bx-1],8
		mov	al,sorsze
		sjnz	alka
		test	gfabl[bx-1],1
		sjnz	alka
		cmp	al,gszel[bx]
		mov	al,kepsor
		sja	alxa
		sub	al,gmags[bx]
		sja	alxa
alka:		mov	al,kepsor
alxa:		sub	al,1
		sja	alma
		inc	al
alma:		ret

farclose	proc	far
		ncall	fclose
		ret
farclose	endp

prorj:		add	bx,36*4
		xlat
		sub	bx,36*4
		sjmp	nyvis

nypont:		xlat
		mov	vesa+1,al
nyvisz:		inc	cx
		sjmp	nyvis

nypc:		xlat
		mov	ah,")"
		mov	wr vesa+1,ax
		mov	al,"("
		inc	cx
		sjmp	nyvisz

scf11:		ncall	ctaa
		mov	al,sfelb
		xor	bh,bh
		and	al,7
scujf:		dec	ax
		and	al,7
		sjz	ssffs
		cmp	al,5
		sjbe	xscffs
		mov	al,5
xscffs:		mov	bl,al
		test	dwan[bx+1],240
		sjz	scujf
ssffs:		sjmp	scffs

ctue:		xor	kwan,1
		sjmp	paffs

ctrlq:		mov	al,salap
		xor	bh,bh
		and	al,7
		cmp	al,sfelb
		sjae	alove
		mov	al,sfelb
alove:		inc	ax
		cmp	al,5
		sjbe	qsaffs
		mov	al,5
qsaffs:		mov	bl,al
		test	dwan[bx+1],240
		sjnz	saffs
		cmp	al,5
		sjb	alove
		sjae	scsokk
saffs:		mov	salap,al
		ncall	ctaa
sorro:		mov	smodex,0
		sjmp	orro

ctrlw:		mov	al,salap
		xor	bh,bh
		and	al,7
scsokk:		dec	ax
		and	al,7
		cmp	al,5
		sja	saffi
		cmp	al,sfelb
		sja	scsakk
saffi:		xor	al,al
		sjmp	saffs
scsakk:		mov	bl,al
		test	dwan[bx+1],240
		sjz	scsokk
		sjmp	saffs

ctf11:		ncall	ctaa
		mov	al,sfelb
		xor	bh,bh
		and	al,7
ctujf:		inc	ax
		and	al,7
		cmp	al,5
		sjbe	xctffs
		xor	al,al
		sjmp	scffs
xctffs:		mov	bl,al
		test	dwan[bx+1],240
		sjz	ctujf
scffs:		mov	sfelb,al
paffs:		mov	smodex,0
pfadd:		xor	ax,ax
		mov	br output+1,al
		mov	dabpoz+10,ax
		mov	dabpoz+12,ax
		mov	dabpoz+14,ax
		mov	dabpoz+16,ax
		mov	ax,251*(1+256)
		and	wr pfadat,ax
		and	wr pfadat+2,ax
		and	pfadat+4,al
		not	ax
		or	wr alabl,ax
		or	wr alabl+2,ax
orro:		sjmp	ormode

ctrlt:		xor	iwan,32
		njmp	sorro

scf12:		mov	al,smode
		and	al,3
		and	smode,252
scism:		dec	ax
		and	al,3
		sjz	scism
		sjmp	scffm

ctf12:		mov	al,smode
		and	al,3
		and	smode,252
smism:		inc	ax
		and	al,3
		sjz	smism
scffm:		or	smode,al
		sjmp	ormode

ctf9:		xor	xmode,128
		mov	aktset,-1
ormode:		njmp	ormod

ctf10:		xor	xmode,64
		sjmp	ormode

ctrlg:		ncall	ctaa
		test	dwan,4
		sjz	rrret
		xor	smode,16
		ncall	dreakf
		njmp	paffs
rrret:		ret

ctrln:		xor	iwan,2
npfad:		njmp	pfadd

ctrlb:		xor	iwan,1
		sjmp	npfad

ctrlf:		xor	owan,64
		and	kwan,253
		test	owan,64
		sjz	npfad
		or	kwan,2
		sjmp	npfad

ctee:		xor	kwan,4
		sjmp	npfad

ctoo:		xor	owan,4
		sjmp	npfad

altfel:		mov	bl,ablak
		and	bx,3
		mov	al,gmags[bx+1]
		dec	al
		sjz	taltol
		sjns	altol
erret:		ret

altle:		mov	bl,ablak
		and	bx,3
		mov	al,gmags[bx+1]
taltol:		inc	ax
		cmp	al,kepsor
		sja	erret
altol:		mov	ah,al
		mov	al,gszel[bx+1]
		sjmp	baltol

altbal:		mov	bl,ablak
		and	bx,3
		mov	al,gszel[bx+1]
xaltol:		inc	ax
		cmp	al,sorsze
		sjbe	bltol
barret:		ret

altjobb:	mov	bl,ablak
		and	bx,3
		mov	al,gszel[bx+1]
		dec	al
		sjs	barret
		sjz	xaltol
bltol:		mov	ah,gmags[bx+1]
baltol:		test	pufabl[bx],24
		sjnz	rret
		test	gfabl[bx],1
		sjnz	rret
rerr:		mov	gszel[bx+1],al
		mov	hszel[bx],al
		mov	al,sorsze
		mov	gmags[bx+1],ah
		mov	xszel[bx],al
		mov	al,kepsor
		mov	hmags[bx],ah
		mov	xmags[bx],al
		njmp	rerrajz

ctrla:		xor	ewan,2
rret:		ret

ctii:		call	fegerki
		xor	kwan,128
		sjmp	ctrie

ctrle:		call	fegerki
		xor	owan,32
ctrie:		call	fegerbe
		ret

ctrls:		or	mode,4
		or	gwan,1
		ret

ctrlr:		xor	tewan,2
		ret

ctrlm:		xor	tewan,8
arret:		ret

ctrld:		mov	bl,ablak
		and	bx,3
		mov	al,pufabl[bx]
		and	al,3
		mov	puffer,al
		call	clrpuf
		ret

aljob:		add	bx,8
		inc	dabpoz[bx]
		sjmp	alret

albal:		add	bx,8
		dec	dabpoz[bx]
		sjs	albom
		sjmp	alret

alhom:		add	bx,8
albom:		mov	dabpoz[bx],dx
alret:		or	br output,32
		ret

altesc:
altent:		or	mode,4
		or	gwan,2
		ret

alttab:		mov	bl,ablak
		and	bx,3
		xor	gfabl[bx],1
		test	pufabl[bx],24
		sjnz	tratab
rerrajz:	or	gfabl[bx],2
		and	gfabl[bx],251
tratab:		mov	al,fmaszk[bx]
		or	alabl[bx],32
		or	br output,al
		or	orutput,al
		ret

ctnum:		xor	suan,64
		ret

ctscrol:	mov	bx,4
csrolp:		test	pufabl[bx-1],4
		sjz	csrok
		test	uan,128
		sjnz	csrok
		add	bx,bx
		ncall	cthom
		sjmp	csorr
csrok:		add	bx,bx
		ncall	ctend
csorr:		shr	bx,1
		dec	bx
		sjnz	csrolp
		ret

ctoe:		xor	suan,4
		;xor	hexan,4
		push	wr suan
		call	freszkik
		;test	felb,7
		pop	ax
		;sjz	giotto
		cmp	al,suan
		sje	smoe
giotto:		ncall	ormod
smoe:		ret

ctrly:
ctrlx:
ctrlc:
ctrlv:
		ret

ctooe:		call	priforg
		sje	uffor
		dec	kiterj+7

ctuu:		call	secforg
uffor:		ret

ctaa:		xor	ax,ax
		test	boot,3
		sjz	goax
		test	smode,16
		sjnz	goax
		test	sfelb,7
		sjnz	goauld
goax:		mov	ntmousx,ax
		mov	ntmousy,ax
goauld:		njmp	ormod

ctuue:		mov	ax,egerx
		push	cx
		mov	cx,ax
		xchg	ax,xmax
		mov	ntmousx,ax
		mov	ax,egery
		push	dx
		mov	dx,ax
		xchg	ax,ymax
		mov	ntmousy,ax
		call	kurucz
		mov	ax,ntmousx
		mov	egery,dx
		xchg	ax,xmax
		pop	dx
		mov	ntmousx,ax
		mov	ax,ntmousy
		mov	egerx,cx
		xchg	ax,ymax
		pop	cx
		mov	ntmousy,ax
		sjmp	goauld

ugr		dw	bal,jobb,fel,lef,ctbal,ctjobb,home,endf
		dw	pgup,pgdn,cthom,ctend,ctpgup,ctpgdn,tab,shtab
		dw	backsp,ctbsp,return,ctent,escf,insf,delf,f1
		dw	f2,f3,f4,f5,f6,f7,f8,f9
		dw	f10,f11f,f12f,pausef,breakf,prscn,ctpsn,ctesc
		dw	cttab,ctcaps,reset,ctfel,ctle,ctins,ctdel,shf1
		dw	shf2,shf3,shf4,shf5,shf6,shf7,shf8,shf9
		dw	shf10,shf11,shf12,shesc,sctab,scesc,ctf9,ctf10
		dw	ctf11,ctf12,albal,aljob,alhom,ctrls,ctrlr,ctrlm
		dw	ctrlg,ctrld,altesc,alttab,altent,scf11,scf12,ctrla
		dw	ctrle,ctrlf,ctrlb,ctrln,ctrlw,ctrlt,ctrlq,altfel
		dw	altle,altbal,altjobb,ctooe,ctuu,ctaa,ctuue,ctee
		dw	ctue,ctoo,ctnum,ctoe,ctrlp,ctscrol,ctii,ctrly
		dw	ctrlx,ctrlc,ctrlv

flele		proc	far
		ncall	lele
		ret
flele		endp

ffelfel		proc	far
		ncall	felfel
		ret
ffelfel		endp

fdreakf		proc	far
		ncall	dreakf
		ret
fdreakf		endp
dreakf:		xor	dx,dx
		ncall	breakf
		ret

fpfadd		proc	far
		ncall	pfadd
		ret
fpfadd		endp

fctf11		proc	far
		ncall	ctf11
		ret
fctf11		endp

fctf12		proc	far
		ncall	ctf12
		ret
fctf12		endp

fscf11		proc	far
		ncall	scf11
		ret
fscf11		endp

fscf12		proc	far
		ncall	scf12
		ret
fscf12		endp

ff11f		proc	far
		ncall	f11f
		ret
ff11f		endp

ff12f		proc	far
		ncall	f12f
		ret
ff12f		endp

fpausef		proc	far
		ncall	pausef
		ret
fpausef		endp

fxtab		proc	far
		ncall	xtab2
		or	br orutput,48
		ret
fxtab		endp
xtab2:		ncall	xtab
		ret

faturn		proc	far
		ncall	aturn
		ret
faturn		endp

fctend		proc	far
		ncall	ctend
		ret
fctend		endp

frerr		proc	far
		ncall	rerr
		ret
frerr		endp

fco256		proc	far
		test	mode,2
		push	ds
		mov	si,offset szin256
		mov	di,offset szinht
		mov	cx,16
		pop	es
		sjnz	focc
		xor	ax,ax
		ncall	co256
focc:		ret
fco256		endp

fdelenc		proc	far
		push	ax
		mov	al,uzemmod
		ncall	lelenc
		pop	ax
		ret
fdelenc		endp

ftablo		proc	far
		push	ax
		dec	ablak
		push	bx
		push	cx
		and	ablak,3
		push	si
		ncall	tattab
		pop	si
		pop	cx
		pop	bx
		pop	ax
		ret
ftablo		endp
tattab:		ncall	tab
		ret

fxsctt		proc	far
		push	wr ablak
		mov	ablak,bl
		push	ax
		xor	bh,bh
		push	cx
		mov	al,pufabl[bx]
		push	si
		test	al,16
		mov	cl,al
		sjnz	fxnel
		ncall	exscett
fxnel:		pop	si
		pop	cx
		pop	ax
		pop	wr ablak
		ret
fxsctt		endp
exscett:	ncall	xsctt
		ret
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
numstring	proc	far		;	DS:[SI]-ben lv CX hosszsg
		clc			;	stringet szmm alaktva adja
		mov	bp,10		;	vissza DX:AX-ben.
		mov	bx,256		;	CF = 1: tlcsorduls vagy hibs
		jcxz	mosst		;	bevitel!
kost:		lodsb	
		or	al,al
		sjz	ckost
		sub	al,71
		sja	kjost
		sjb	crosst
		or	bh,bh
		sjz	ckost
sorst:		mov	bl,cl
ckost:		loop	kost
		or	bl,bl
		sjnz	ghost
crosst:		xor	cx,cx
rosst:		stc
mosst:		mov	ax,cx
		cwd
		ret
kjost:		cmp	al,9
		sja	crosst
		or	bh,bh
		sjz	ckost
		xor	bh,bh
		sjmp	sorst
ghost:		xor	ax,ax
		or	bh,bh
		cwd
		sjnz	vosst
		sub	si,bx
		xchg	bx,cx
koppen:		xchg	ax,bx
		lodsb
		sub	al,71
		xchg	ax,bx
		sjb	haga
		push	ax
		xchg	ax,dx
		mul	bp
		xchg	ax,di
		or	dx,dx
		pop	ax
		sjnz	crosst
		mul	bp
		add	dx,di
		sjc	crosst
		add	ax,bx
		adc	dx,0
		sjc	crosst
haga:		loop	koppen
		clc
vosst:		ret
numstring	endp
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
dxtram		proc	far		;	A DX:AX-ben lv 32-bites
		xor	dx,dx		;	szmbl stringet kpez, s annak
dxtram		endp			;	cmt DS:SI-ben adja vissza.
					;	Ez a string "vegszo"-ban lesz,
sztram		proc	far		;	kezd nullkkal eltolva, s a
		ncall	sram		;	legals hat karakter mg
sztram		endp			;	DX/BX/AX-ben is benne van.
ndax:		retf			;	A string hossza: CX.
					;	CF = 1: tlcsorduls!
sram:		push	ds
		mov	bp,71*(1+256)
		cmp	dx,1525
		mov	cx,4
		mov	di,offset vegszo
		pop	es
		xchg	ax,bp
		rep	stosw
		xchg	ax,bp
		sjb	skes
		sja	tungy
		cmp	ax,57600
		sjb	skes
tungy:		test	mode,8
		sjnz	xt386
		xor	ax,ax
		cwd
		ncall	skes
		stc
		ret		
xt386:		xchg	ax,dx
		mov	ebx,100000000
		shl	eax,16
		dec	di
		xchg	ax,dx
		dec	di
		xor	edx,edx
		div	ebx
		aam
		xchg	al,ah
		add	ax,bp
		stosw
		xchg	eax,edx
		xchg	ax,dx
		shr	eax,16
		xchg	ax,dx
skes:		mov	bx,10000
		sub	bp,"00"
		div	bx
		ncall	szkes
		xchg	ax,dx
		ncall	szkes
		push	ax
		mov	cl,16
		mov	br [di],128
		mov	al,71
		sub	di,cx
		repe	scasb
		inc	cx
		dec	di
		pop	ax
		mov	si,di
		clc
		ret
szkes:		ncall	stram4
		add	ax,bp
		add	bx,bp
		xchg	ax,bx
		stosw
		xchg	ax,bx
		stosw
		ret

sztram4:	cmp	ax,9999
		sjbe	stram4
		xor	ax,ax
stram4:		push	dx
		mov	dl,100
		div	dl
		mov	dh,ah
		ncall	stram2
		mov	bx,ax
		mov	al,dh
		pop	dx
stram2:		aam
		xchg	al,ah
		add	ax,"00"
		ret
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
helyfogl	proc	far		;	Helyfoglals a felhasznlt
		call	mellfog		;	memriablokkok szmra.
		sjc	hiba5

		mov	ax,768		;	Paletta.
		ncall	fogl
hiba5:		sjc	hiba4
		mov	paletta,ax

		cmp	angol,0
		mov	al,"h"
		sje	bree
		mov	al,"e"
bree:		cmp	al,csirke
		mov	kiterj+23,al
		mov	ax,601h		;	Ikonok betltse.
		sjne	beikt
		cmp	ikpuf,0
		sjne	szotar
beikt:		call	fastopen
		sjc	xnhiba2
		ncall	ikobbe
		sjc	xnhiba2
		sjz	hiba4

szotar:		mov	ax,301h		;	Sztr betltse.
		call	fastopen
xnhiba2:	sjc	nhiba2
		mov	dx,offset ziptab
		mov	cx,184+2+2*36
		push	dx
		ncall	fread
		pop	si
		sjc	nhiba2
		push	ds
		mov	cx,92
		mov	di,offset siptab
		pop	es
		mov	dx,offset vesa
		rep	movsw
		mov	cl,2*36
		ncall	fread
		sjc	nhiba2
		mov	dx,offset blokk
		mov	cx,2*1296
		ncall	fread
		sjc	nhiba2
		mov	ax,sorszam
		mov	vgszamb,ax
		add	ax,ujszmax+1
		add	ax,ax
		add	ax,ax
		ncall	fogl
		sjnc	hihib
chiba:		ncall	fclose
hiba4:		njmp	hiba
hihib:		mov	szoseg,ax
		xor	si,si
secikl:		;or	si,si
		mov	ax,dseg[si]
		sjnz	seselj
		mov	vegyesb,ax
		inc	ah
seselj:		or	ax,ax
		sjz	sgures
		push	si
		inc	ax
		ncall	fogl
		pop	si
chiba2:		sjc	chiba
		mov	dseg[si],ax
		mov	cx,wr vesa[si]
		ncall	helell
		jcxz	sgures
		push	cx
		and	koppany,64
		mov	ds,filepuf
		push	si
		ncall	freadx
		pop	si
		pop	cx
nhiba2:		sjc	nhiba4
		push	si
		xor	di,di
		xor	si,si
		call	unpack
		;call	funzip
		;push	es
		;pop	ds
		pop	bx
		mov	ax,adat
		push	bx
		shr	bx,1
		mov	es,ax
		mov	al,72
		mul	bl
		add	ax,offset blokk
		xchg	ax,di
slolp:		mov	ax,-1
		scasw
		sje	bltov
		push	di
		push	es
		mov	es,es:szoseg
blszo:		cmp	si,cx
		sjae	blujb
		mov	bp,si
		lodsw
		or	al,al
		sjs	dlujb
		lodsb
		and	ax,31
		add	si,ax
		lodsw
		add	al,al
		add	ax,ax
		xchg	ax,di
		xchg	ax,bp
		stosw
		mov	ax,bx
		stosw
		sjmp	blszo
chiba3:		sjc	chiba2
dlujb:		dec	si
blujb:		pop	es
		pop	di
bltov:		inc	bh
		cmp	bh,36
		sjb	slolp
		push	es
		pop	ds
		pop	si
sgures:		inc	si
		inc	si
		cmp	si,2*36
		sjae	isex
		njmp	secikl

isex:		ncall	fclose
		mov	ax,0c01h
		call	fastopen
		sjc	nhiba4
		mov	dx,offset libnum
		mov	cx,10
		ncall	fread
		mov	ax,libnum
nhiba4:		sjc	nhiba5
		mov	ebnum,ax
		push	ax
		add	ax,usrmax+1
		sjc	cihi
		ncall	fogl
cihi:		pop	cx
		sjc	chiba3
		mov	ldxpuf,ax
		jcxz	czizi
		ncall	xreads
czizi:		mov	ax,lpmret1
		sjc	nhiba3
		add	ax,ax
		sjz	cxixi
		push	ax
		sjc	xihi
		ncall	fogl
xihi:		pop	cx
		sjc	chiba3
		mov	libpuf1,ax
		ncall	xreads
cxixi:		mov	ax,lpmret2
		sjc	nhiba3
		mov	emret,ax
		add	ax,ax
		push	ax
		sjc	wihi
		inc	ah
		ncall	fogl
wihi:		pop	cx
chiba4:		sjc	chiba3
		mov	libpuf2,ax
		jcxz	mesex
		ncall	xreads
		sjc	nhiba5

mesex:		mov	ax,vonzat
		add	ax,ax
		sjz	wsex
		push	ax
		sjc	chihi
		ncall	fogl
chihi:		pop	cx
		sjc	chiba4
		mov	vnzpuf,ax
		ncall	xreads
wsex:		mov	ax,vonmret
		sjc	nhiba5
		or	ax,ax
		sjz	nesex
		push	ax
		ncall	fogl
		pop	cx
		sjc	chiba4
		mov	vonpuf,ax
		ncall	xreads
nhiba5:		sjc	nhiba3

nesex:		ncall	fclose
		mov	ax,401h		;	Rezidens szvegek betltse.
		call	fastopen
nhiba3:		sjc	nhiba
		mov	dx,offset miptab
		mov	cx,184+2+2
		ncall	fread
		sjc	nhiba
		cmp	uzenet,1
		mov	ax,uzbeg
		sjbe	desex
		or	ax,ax
		sjz	desex
		ncall	fogl
		sjc	chiba4
		mov	useg,ax
		push	ds
		mov	cx,uzbeg
		mov	ds,ax
		ncall	freadx
		pop	ds
		sjc	nhiba

desex:		ncall	fclose
		mov	ax,501h		;	Lemezes szvegtbla betltse.
		mov	zelyik,3
		call	fastopen
		sjc	nhiba
		mov	dx,offset diptab
		mov	cx,184+2
		ncall	fread
		sjc	nhiba

sesex:		ncall	fclose
		test	mode,8		;	Karakterkszletek betltse.
		mov	ax,101h
		sjz	srendb
		call	fastopen
		sjc	cujra
		xor	ax,ax
		ncall	charload
		sjnc	nhibok
		sjz	hiba
cujra:		or	tegan,32
		call	priforg
ehiba:		mov	si,offset filenev
		sjne	nhibok
ehip:		lodsb
		cmp	al,"."
		sjne	ehip
		mov	br [si+2],"r"

nhiba:		mov	dx,offset ntext1
		mov	ah,9
		int	21h
		mov	dx,offset filenev
		mov	ah,9
		int	21h
		mov	dx,offset ntext2
		sjmp	hibix

hiba:		mov	dx,offset htext
hibix:		mov	ah,9
		int	21h
		stc
		ret

nhibok:		mov	ax,201h
		call	fastopen
		sjc	eujra
		mov	ax,2
		ncall	charload
		sjnc	erendb
		sjz	hiba
eujra:		or	tegan,32
		call	secforg
		;sje	ehiba

erendb:		test	ewan,1			;	Egrpuffer.
		mov	ax,28*36*3+4
srendb:		sjz	nrendb

		;mov	es,ikpuf
		;mov	si,wr es:[1*2]
		;mov	ax,wr es:[si]
		;mov	dx,3
		;mul	ah
		;mul	dx
		;inc	ax
		
		ncall	fogl
		sjc	hiba
		mov	egseg,ax

nrendb:		or	tegan,32
		call	dymem
		sjc	hiba

		mov	si,10			;	Szvegpufferok.
		mov	ax,jmeret
hecikl:		mov	pszab[si-2],ax
		push	si
		ncall	fogl
		pop	si
hiba3:		sjc	hiba
		mov	pseg[si],ax
		mov	ax,pmeret
		dec	si
		dec	si
		sjnz	hecikl
		shr	ax,1
		shr	ax,1
		mov	pkmax,ax

		mov	ax,dpszab
		mov	dpszab_max,ax
		ncall	fogl
		sjnc	noffog
		xchg	ax,bx
		sub	ax,32
		mov	cl,4
		sjb	hiba3
		shl	ax,cl
		cmp	ax,512+aptuf+1024+6
		mov	dpszab,ax
		mov	dpszab_max,ax
		sjb	hiba3
		ncall	fogl
		sjc	hiba3
noffog:		mov	duseg,ax
		clc
		ret
helyfogl	endp

mellfog		proc	far		;	Helyfoglals a felhasznlt
		cmp	filepuf,0	;	memriablokkok szmra.
		mov	ax,fmeret
		sjne	elpho
		ncall	helfog
		sjc	xelfo
		mov	filepuf,ax	;	File-puffer (klnfle file-ok
		mov	fmeret,cx	;	rs-olvasshoz).
elpho:		cmp	parpuf,0
		mov	ax,utmret	;	Parancspuffer.
		sjne	xelfo
		ncall	helfog
		sjc	xelfo
		mov	parpuf,ax
		mov	utmret,cx
		mov	inipuf,ax
		mov	inimmax,cx
xelfo:		ret
mellfog		endp

recobbe		proc	far
		cmp	angol,0
		mov	al,"h"
		sje	csee
		mov	al,"e"
csee:		cmp	al,csirke
		mov	kiterj+23,al
		mov	ax,601h		;	Ikonok betltse.
		sjne	reikt
		cmp	ikpuf,0
		sjne	rexxo
reikt:		call	fastopen
		sjc	rexxo
		ncall	ikobbe
rexxo:		ret
recobbe		endp

ycobbe:		mov	dx,offset system
		ncall	chdir
		sjc	xycco
		ncall	xycco
		pushf
		mov	dx,offset vinev
		ncall	chdir
		popf
		sjc	xycco
		ret

xycco:		push	ds
		mov	di,offset filenev
		mov	si,offset advnev
		pop	es
		mov	dx,di
yccy:		lodsb
		or	al,al
		stosb
		sjnz	yccy
		dec	di
		mov	si,offset kiterj+5*4
		mov	ax,"$"
		movsw
		movsw
		dec	si
		cmp	ikpuf,0
		stosw
		lodsb
		sje	gungbao
		cmp	al,csirke
		sjne	gungbao
		njmp	puhano

gungbao:	mov	ax,3d00h
		int	21h
		sjc	xnlyba3
		mov	file,ax

ikobbe:		mov	bx,file		;	Ikonok betltse.
		mov	cx,fmeret
		xor	dx,dx
		push	ds
		and	koppany,64
		mov	ds,filepuf
		mov	ah,3fh
		push	ds
		int	21h
		pop	es
		mov	si,wr es:[0]
		pop	ds
		mov	cx,wr es:[si+22*2]
		pushf
		cmp	ax,cx
		sjae	uvos

		popf
		cmp	ikpuf,0
		mov	ax,cx
		sjne	nyugos
		;test	mode,8
		push	ax
		;sjnz	uano
		;ncall	perfog
uano:		push	dx
		ncall	fogl
		pop	dx
		pop	cx
		sjc	lyba4
		mov	ikpuf,ax
		mov	imret,cx

nyugos:		push	cx
		mov	bx,file
		xor	cx,cx
		xor	dx,dx
		mov	ax,4200h
		int	21h
		pop	cx
		mov	bx,file
		sjc	luvos
		push	ds
		xor	dx,dx
		mov	ds,ikpuf
		mov	ah,3fh
		int	21h
		pop	ds
luvos:		pushf
		xor	ax,ax

uvos:		push	ax
		ncall	fclose
		pop	ax
		popf
xnlyba3:	sjc	xnlyba2
		cmp	ax,2
		sjb	puhano

		cmp	ikpuf,0
		mov	cx,ax
		sjne	huano
		;test	mode,8
		push	ax
		;sjnz	guano
		;ncall	perfog
guano:		push	dx
		ncall	fogl
		pop	dx
		pop	cx
		sjc	lyba4
		mov	ikpuf,ax
		mov	imret,cx

huano:		push	ds
		xor	si,si
		xor	di,di
		;test	mode,8
		mov	es,ikpuf
		mov	ds,filepuf
		;sjnz	muvos
		;ncall	perix
		;sjmp	huvos
muvos:		rep	movsb
huvos:		pop	ds
puhano:		mov	al,kiterj+23
		mov	csirke,al
		xor	ax,ax
		inc	ax
		ret
lyba4:		xor	ax,ax
xnlyba2:	ret

;perfog:	mov	es,filepuf
;		mov	bx,wr es:[0]
;		and	koppany,64
; 		mov	dx,es:[bx]
;		sub	dx,bx
;		sub	dx,16
;		sub	ax,dx
;		ret

;perix:		push	cx
;		movsw
;		mov	cx,38*2
;		xor	ax,ax
;		add	si,cx
;		rep	stosb
;		ncall	psotw
;		mov	cl,51*2
;		xor	ax,ax
;		add	si,cx
;		rep	stosb
;		ncall	psotw
;		mov	cx,wr ds:[0]
;		xor	ax,ax
;		mov	si,cx
;		sub	cx,di
;		push	si
;		rep	stosb
;		mov	cl,8
;szalad:	ncall	psotw
;		loop	szalad
;		pop	si
;		pop	cx
;		mov	si,[si]
;		sub	cx,si
;		rep	movsb
;		ret

;psotw:		lodsw
;		sub	ax,dx
;		sjae	psota
;		xor	ax,ax
;psota:		stosw
;		ret

helell:		cmp	cx,fmeret
		sjbe	hellok
		mov	cx,fmeret
hellok:		ret

helfog:		cmp	ax,64
		mov	cl,10
		sjb	hafa
		mov	ax,-16
		sjmp	hifi
hafa:		or	ax,ax
		sjnz	hefe
		inc	ax
hefe:		shl	ax,cl
hifi:		push	ax
		ncall	fogl
		pop	cx
		ret

fogl:		or	ax,ax
		mov	cl,4
		mov	bx,ax
		sjz	nemfogl
		shr	bx,cl
		;and	al,15
		;sjz	lefogl
		inc	bx
lefogl:		mov	ah,48h
		push	bx
		int	21h
		pop	cx
		sjc	nemfogl
		push	ax
		add	cx,cx
		mov	es,ax
		add	cx,cx
		xor	ax,ax
		test	mode,8
		mov	di,ax
		sjz	ln386
		cwde
		rep	stosd
		pop	ax
		ret
ln386:		add	cx,cx
		rep	stosw
		pop	ax
nemfogl:	ret
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
charload:	mov	pixel,ax	;	Karakterkszlet betltse:
		mov	bx,file		;	AX = 0 : .PCR (charset1),
		mov	cx,12320	;	AX = 2 : .SCR (charset2).
		ncall	helell
		mov	vesa+2,ah
		xor	dx,dx
		push	ds
		mov	ah,3fh
		and	koppany,64
		mov	ds,filepuf
		int	21h
		pop	ds
		pushf
		push	ax
		ncall	fclose
		pop	ax
		popf
		sjc	cfh
		sub	ax,32
		sjb	cfh
		cmp	ah,16
		mov	wr vesa,ax
		sjb	cfh
		test	mode,8
		mov	bx,pixel
		sjz	ccfh
		and	owan,252
		shr	bx,1
		cmp	ah,32
		mov	wr orias[bx],0
		mov	ax,2048
		sjb	ninnor
		add	ax,ax
		mov	wr orias[bx],1+256
		or	owan,1
ninnor:		add	bx,bx
		cmp	cr8ho1[bx],ax
		push	ax
		sjae	elnagy
elngvi:		push	bx
		ncall	fogl
		pop	bx
		pop	cx
		sjnc	jofgl
foghij:		xor	ax,ax
scfh:		stc
		ret
cfh:		test	tegan,32
		sjnz	scfh
		cmp	br pixel,2
ccfh:		ret
nfoghij:	sjmp	foghij
elnagy:		or	bx,bx
		mov	bp,chr8set1[bx]
		sjz	elnbx
		cmp	bp,chr8set1
		sje	elngvi
		clc
elnbx:		xchg	ax,bp
		pop	cx
		mov	es,ax
		sjmp	elmax
lnagy:		or	bx,bx
		mov	bp,charset1[bx]
		sjz	lnbx
		cmp	bp,charset1
		sje	lngvi
		clc
lnbx:		xchg	ax,bp
		pop	cx
		mov	es,ax
		sjmp	lmax
jofgl:		;test	tegan,32
		mov	cr8ho1[bx],cx
		mov	chr8set1[bx],ax
		;sjnz	jofga
		mov	cr8ho2[bx],cx
		mov	chr8set2[bx],ax
jofga:		inc	vesa+2
elmax:		push	ax
		xchg	ax,cx
		add	ax,ax
		cmp	crho1[bx],ax
		push	ax
		sjae	lnagy
lngvi:		push	bx
		ncall	fogl
		pop	bx
		pop	cx
		sjc	lmax
		;test	tegan,32
		mov	crho1[bx],cx
		mov	charset1[bx],ax
		;sjnz	lofga
		mov	crho2[bx],cx
		mov	charset2[bx],ax
lofga:		inc	vesa+2
lmax:		pop	bp
		sjc	nfoghij
		push	es
		add	bx,bx
		mov	es,filepuf
		and	koppany,64
		xor	bl,4
		mov	eax,dr es:[bx]
		mov	dr setsz[bx],eax
		mov	eax,dr es:[bx+8]
		mov	dr setsz2[bx],eax
		mov	eax,dr es:[bx+16]
		mov	dr setsz[bx+8],eax
		mov	eax,dr es:[bx+24]
		mov	dr setsz2[bx+8],eax
		push	cx
		mov	ax,hintcol
		xor	di,di
		mov	wr setsz+6,ax
		mov	wr setsz+14,ax
		mov	cx,16
		xor	ax,ax
		rep	stosw
		pop	cx
		xor	bl,4
		pop	es
		shr	cx,1
		xor	di,di
		shr	bx,1
		mov	si,32
		mov	dx,wr vesa
		mov	vpage,di
		push	ds
		mov	dr vpages,-1
		mov	pag,-1
		push	cx
		mov	ds,filepuf
		rep	movsw
		xor	di,di
		cmp	dh,24
		pop	cx
		mov	es,bp
		sja	ove1
		cmp	dh,20
		sjb	chargen
		cmp	dh,24
		sjmp	ove2
ove1:		cmp	dh,40
		sjb	chargen
		cmp	dh,48
ove2:		sjae	mehhor
		shr	cx,1
mehhor:		rep	movsb
gonblv:		cmp	dh,24
		pop	ds
		sja	gomba
		cmp	dh,20
		sjb	gengon
		cmp	dh,24
		sjmp	gonga
gomba:		cmp	dh,40
		sjb	gengon
		cmp	dh,48
gonga:		sjb	ninnor8
gengon:		mov	al,owan
		and	al,1
		add	al,al
		or	owan,al
ninnor8:	clc
		ret
chargen:	shr	bx,1
		push	ds
		mov	ax,adat
		mov	si,32
		mov	ds,ax
		mov	cl,orias[bx]
		mov	bx,256
		pop	ds
		shl	bx,cl
		mov	cx,8
felelp:		mov	dx,bx
		shr	dx,1
chargelp:	lodsw
		or	ax,[si][bx-2]
		dec	dx
		stosw
		sjnz	chargelp
		add	si,bx
		loop	felelp
		sjmp	gonblv

priforg		proc	far
		xor	bx,bx
priforg		endp

briforg		proc	far
		mov	si,offset kiterj+3
		mov	dx,101h
		xor	ax,ax
		sjmp	chrforg
briforg		endp

secforg		proc	far
		xor	bx,bx
secforg		endp

becforg		proc	far
		mov	si,offset kiterj+7
		mov	dx,201h
		mov	ax,2
becforg		endp

chrforg		proc	far
		mov	bh,[si]
		cmp	bh,"A"
		sjb	vesca
		cmp	bh,"Z"
		sja	vesca
		sub	bh,"A"-"a"
vesca:		cmp	bh,"a"
		sjb	xesca
		cmp	bh,"z"
		sjbe	esca
xesca:		mov	bh,"r"
esca:		cmp	bl,"A"
		sjb	kriszta
		cmp	bl,"Z"
		sja	kriszta
		sub	bl,"A"-"a"
kriszta:	cmp	bl,"a"
		sjb	geszta
		cmp	bl,"z"
		sjbe	seszta
geszta:		mov	bl,bh
sesztak:	inc	bx
		cmp	bl,"z"
		sjbe	seszta
		mov	bl,"a"
seszta:		cmp	bl,bh
		mov	[si],bl
		sje	sezta
		test	tegan,32
		sjz	teszta
		push	es
		push	bp
		push	di
		push	si
		push	dx
		push	cx
		push	bx
		push	pixel
		push	wr vesa
		push	wr vesa+2
		push	ax
		xchg	ax,dx
		call	fastopen
		pop	ax
		sjc	eszta
		push	ax
		ncall	charload
		pop	ax
eszta:		pop	wr vesa+2
		pop	wr vesa
		pop	pixel
		pop	bx
		pop	cx
		pop	dx
		pop	si
		pop	di
		pop	bp
		pop	es
		sjc	sesztak
		ncall	ormod
teszta:		cmp	bl,bh
sezta:		ret
chrforg		endp
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
elpath		proc	far		;	Eredeti elrsi t elmentse,
		cmp	felhany,2
		mov	di,81h		;	valamint a parancssori
		mov	cx,di		;	paramterek ellenrzse
		mov	cl,es:[di-1]	;	(RAMDRIVE megads!).
		sjb	direll
		jcxz	direll
		mov	al,32
		repe	scasb
		sje	direll
		dec	di
		mov	ax,es:[di]
		sub	al,"a"
		sjb	direll
		cmp	al,26
		sjae	direll
		cmp	ah,":"
		sjne	direll
		mov	paths,al
		mov	inipaths,al
		mov	ax,"\"
		or	xmode,32
		mov	wr fastpath,ax
cacasb:		cmp	br es:[di],32
		sjbe	direll
		cmp	br es:[di],"/"
		sje	direll
		scasb
		sje	didir
		loop	cacasb
		sjmp	direll
didir:		cmp	cl,62
		sjbe	masnev
		mov	cl,62
masnev:		xor	si,si
msncikl:	mov	al,es:[di]
		cmp	al,32
		sjbe	direll
		cmp	al,"/"
		sje	direll
		mov	fastpath[si+1],al
		inc	di
		inc	si
		loop	msncikl

direll:		mov	ax,1900h
		cmp	al,pripath
		sjne	pastell
		int	21h
		mov	pissza,al
		mov	si,offset pripath
		mov	paths+1,al
		mov	paths+4,al
		ncall	aktpath
		mov	si,offset elnev
		ncall	aktpath
renpath:	ncall	advdir
		sjnc	pathmegv
		mov	dx,offset vinev
		ncall	chdir
		sjnc	renpath
		call	vipath
		sjc	pastell
		ncall	advmake
		sjnc	renpath
pathmegv:	mov	si,offset pripath
		ncall	aktpath

pastell:	cmp	felhany,2
		sjb	elvegz
		test	xmode,32
		sjz	elveg
		ncall	fastell

elveg:		mov	al,5+0*8
		call	setpath
		sjnc	elvegz
		mov	al,1*8
		call	setpath
		sjc	elvegz
		mov	dx,offset saves
		ncall	mkdir
elvegz:		ret
elpath		endp

aktpath:	xor	dl,dl

readpath:	push	wr [si+63]
		push	si
		mov	br [si],"\"
		inc	si
		mov	ah,47h
		int	21h
		pop	si
		pop	wr [si+63]
		ret

fastdevice:	xor	al,al

device:		or	al,al
		mov	cl,3		;	Elrsi utak belltsa
		sjs	jodev
		shr	al,cl		;	file-okhoz (pl. kp betltse
		cmp	al,6		;	eltt). Ha tbb is lehet,
		cbw
		sjae	nemdev		;	sorban keresi bennk a file-t!
		mov	si,ax
		mov	dl,paths[si]
		or	dl,dl
		mov	hol,al		;	AL > 127  ==> semmi!
		sjs	rosszdev
		push	si
		push	dx
		mov	ah,0eh
		int	21h
		mov	ah,19h
		int	21h
		pop	dx
		cmp	al,dl
		pop	si
		sjne	rosszdev
		mov	cl,6
		push	si
		shl	si,cl
		lea	dx,fastpath[si]
		ncall	chdir
		pop	si
		sjnc	jodev
rosszdev:	mov	paths[si],-1
nemdev:		stc
jodev:		ret

advdir:		mov	dx,offset advnev

chdir:		mov	si,dx
		mov	ax,3b00h
		cmp	al,[si]
		sje	endev
dosint:		int	21h
endev:		ret

advmake:	mov	dx,offset advnev

mkdir:		mov	ah,39h
		sjmp	dosint

advclear:	mov	dx,offset advnev

redir:		mov	ah,3ah
		sjmp	dosint

xreads:		push	ds
		mov	ds,ax
		ncall	freadx
		pop	ds
		ret

freadx:		xor	dx,dx

fread:		push	ds
		mov	ax,adat
		mov	ds,ax
		mov	bx,file
		pop	ds
		mov	ah,3fh
		int	21h
		sjnc	hajh
jajh:		mov	ax,adat
		mov	ds,ax
		ncall	fclose
		stc
		ret
hajh:		cmp	ax,cx
		sjne	jajh
		ret

farread		proc	far
		ncall	fread
		ret
farread		endp
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
setpath		proc	far		;	Alknyvtrak belltsa: ha
		or	al,al		;	egyet nem sikerlt, prblja a
		sjs	devs		;	kvetkezt stb.
		push	ax
		ncall	device		;	AL = 8*device + path.
		pop	ax		;	AL > 127 ==> semmi!
		sjnc	devimegv
devitov:	add	al,8
		cmp	al,5*8
		sjb	setpath
		stc
devs:		ret
devimegv:	push	ax
		and	al,7
		mov	ah,9
		sjz	gyoker
		mul	ah
		xchg	ax,si
		lea	dx,system[si-9]
		ncall	chdir
gyoker:		pop	ax
		sjc	devitov
		ret
setpath		endp
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
writepath	proc	far
		push	si		;	Elrsi utak fellrsa.
		and	ax,3		;	DS:SI/CX = az j path,
		push	cx		;	AX = 	0: fastpath,
		push	ax		;		1: server,
		call	prepare		;		2: secpath,
		call	cleanpath	;		3: terpath.
		pop	bx
		xor	ah,ah
		xor	di,di
		mov	al,xpaths[bx]
		pop	cx
		add	ax,ax
		pop	si
		add	ax,offset xesa
		push	ds
		cmp	cx,63
		xchg	ax,di
		pop	es
		jcxz	zsofi
		sjbe	zsoka
		mov	cx,63
zsoka:		rep	movsb
		mov	inipaths[bx],-1
		stosb
zsofi:		jmp	postset
writepath	endp
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
clearfast	proc	far		;	Fastpath s server trlse.
		ncall	fastdevice
		sjc	sleant
		ncall	flear
		mov	dx,offset system
sleansi:	push	dx
		ncall	chdir
		sjc	slean
		ncall	flear
		mov	dx,offset vinev
		ncall	chdir
		pop	dx
		push	dx
		ncall	redir
slean:		pop	dx
		add	dx,9
		cmp	dx,offset vinev
		sjb	sleansi
sleant:		test	ewan,32
		mov	al,5*8
		sjnz	cleanpath
		ncall	device
		sjc	cleanpath
		ncall	flear
clearfast	endp

cleanpath	proc	far		;	res knyvtrak trlse.
		mov	ax,0ef8h
		mov	dl,2
		push	ax
		int	21h
		mov	ah,19h
		int	21h
		cmp	al,2
		mov	dx,offset rotadv
		sjne	cleant
		ncall	chdir
		sjmp	eanse
cleanse:	push	ax
		ncall	device
eanse:		sjc	cleant
		mov	dx,offset urfile
		xor	cx,cx
		mov	ah,4eh
		int	21h
		mov	dx,offset system
		sjnc	cleant
cleansi:	push	dx
		ncall	chdir
		pop	dx
		sjnc	cleant
		add	dx,9
		cmp	dx,offset vinev
		sjb	cleansi
		ncall	chdir
		ncall	advclear
cleant:		pop	ax
		add	al,8
		cmp	al,6*8
		sjb	cleanse
		ret
cleanpath	endp

flear:		mov	ah,4eh
		sjmp	xear
fear:		call	nevazon
		push	ds
		mov	dx,bx
		push	es
		mov	ah,41h
		pop	ds
		int	21h
		mov	ah,4fh
		pop	ds
xear:		xor	cx,cx
		mov	dx,offset urfile
		int	21h
		sjnc	fear
		ret
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
vipath		proc	far		;	Eredeti elrsi t, nomeg a
		mov	al,pissza
		push	wr paths+4
		mov	paths+4,al
		mov	al,4*8		;	megszaktsok visszalltsa.
		ncall	device
		pop	wr paths+4
		ret
vipath		endp

remegsz		proc	far
		xor	di,di
		mov	cx,16
		mov	si,offset elint
		mov	es,di
		rep	movsw
		mov	di,24h*4
		movsw
		movsw
		jmp	billmex
remegsz		endp

medmex		proc	far
		push	ds		;	INT vektorok mentse
		xor	si,si
		pop	es
		mov	ds,si
		mov	cx,16
		mov	di,offset elint
		rep	movsw
		mov	si,24h*4
		push	es
		movsw
		movsw
		pop	ds
		ret
medmex		endp
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
openwrite	proc	far		;	File megnyitsa rsra:
		or	suan,32		;	AL, AH: ld. openread.
		jmp	openread
openwrite	endp
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
fcopy		proc	far		;	File msolsa. Felttelei:
		mov	dx,-1		;	- openread/openwrite sorrendben
		mov	bx,file		;	  sikeresen vgrehajtva
		mov	ax,4202h	;	- filenev = a clfile neve!
		mov	cx,dx
		int	21h
		sjc	cptorl
		xchg	ax,dx
		xchg	ax,cx
		mov	bx,wile
		mov	ax,4200h
		int	21h
		sjc	optorl
		mov	dx,offset kiterj
		mov	cx,1
		mov	bx,wile
		mov	ah,40h
		int	21h
		sjc	optorl
		dec	ax
		sjnz	optorl
		xchg	ax,dx
		dec	cx
		mov	bx,file
		mov	ax,4200h
		int	21h
		sjc	optorl
		xor	dx,dx
		xor	cx,cx
		mov	bx,wile
		mov	ax,4200h
		int	21h
cptorl:		sjc	optorl
irolv:		call	begbevit
		push	ds
		xor	dx,dx
		mov	cx,fmeret
		mov	bx,file
		mov	fpufs,dx
		and	koppany,64
		mov	ds,filepuf
		mov	ah,3fh
		int	21h
		xchg	ax,cx
		pop	ds
		sjc	optorl
		jcxz	okveg
		call	begbevit
		push	ds
		mov	bx,wile
		xor	dx,dx
		;and	koppany,64
		mov	ds,filepuf
		mov	ah,40h
		int	21h
		pop	ds
		sjc	optorl
		cmp	ax,cx
		sje	irolv
optorl:		ncall	wfclose
		mov	dx,offset filenev
		mov	ah,41h
		int	21h
		stc
		ret
okveg:		ncall	wfclose
		clc
		ret
fcopy		endp
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
wfclose:	mov	bx,adat
		mov	ds,bx
		ncall	fclose
wclose:		mov	bx,adat
		mov	ah,3eh
		mov	ds,bx
		mov	bx,wile
		njmp	dosint
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
fastopen	proc	far		;	File megnyitsa olvassra a
		cmp	ah,8		;	RAMDRIVE-on keresztl:
		sjb	bfast		;	AL, AH: ld. openread.
		cmp	ah,12
		sjb	fast
bfast:		xor	bp,bp
fast:		or	al,al
		sjs	hoppsz
		or	ah,ah
		sjz	hoppsz
		sjs	hoppsz
		and	al,7
		sjz	hoppsz
		push	ax
		push	bp
		call	openread
		pop	bp
		pop	ax
		push	bp
		push	ax
		sjc	opnem
		cmp	paths,-1
		mov	si,2*ramdrp
		sje	opnem
		cmp	hol,0
		mov	bx,ax
		sjne	opszi
		mov	dx,bp
		sjmp	ofra
offen:		mov	bx,ramdrive0[si]
		mov	dx,ramdrive1[si]
		cmp	ax,bx
		mov	ramdrive0[si],cx
		mov	ramdrive1[si],di
		sjne	ofra
		cmp	bp,dx
		sje	opnem
ofra:		dec	si
		mov	cx,bx
		dec	si
		mov	di,dx
		sjns	offen
opvan:		clc
opnem:		pop	ax
		pop	bp
		ret
hoppsz:		njmp	oppsz
opszi:		push	ax
		call	setpath
		pop	ax
		sjc	opvan
		cmp	hol,0
		mov	al,-1
		sjne	opvan
		call	openwrite
		sjc	opvan
		call	fcopy
fontos:		pop	ax
		sjnc	boppsz
		push	ax
		mov	al,4
popszi:		cmp	al,1
		push	ax
		sje	nopszi
		call	setpath
		sjc	nopszi
		cmp	hol,0
		mov	ah,4eh
		sjne	nopszi
		sjmp	prox
ropszi:		mov	ah,4fh
prox:		xor	cx,cx
		mov	dx,offset urfile
		int	21h
		sjc	nopszi
		pop	ax
		call	nevazon
		push	dx
		sjc	ftorl
		ncall	filker
		sjnc	ropszi
ftorl:		push	ds
		mov	dx,bx
		push	es
		mov	ah,41h
		pop	ds
		int	21h
		pop	ds
		sjc	ropszi
		pop	ax
		pop	ax
		pop	bp
		njmp	fastopen
nopszi:		pop	ax
		dec	al
		mov	cx,ramdrp
		sjns	popszi
		xor	si,si
		xor	ax,ax
		jcxz	uppsz
roplya:		cmp	ax,ramdrive0[si]
		mov	ramdrive1[si],ax
		mov	ramdrive0[si],ax
		sjb	fontos
		inc	si
		inc	si
		loop	roplya
uppsz:		pop	ax
		or	al,8
boppsz:		pop	bp
oppsz:
fastopen	endp
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
openread	proc	far		;	File megnyitsa olvassra:
		push	ds		;	AL = 8*device + path,
		or	ah,ah		;	AH = file (kiterjeszts szma).
		pop	es
		sjz	opifi
		sjs	opifi		;	AL > 127 ==> aktulis knyvtr,
		push	ax		;	AH = 0	 ==> filenv: DX-ben.
		cmp	ah,8
		mov	di,offset filenev
		mov	si,offset advnev
		mov	dx,di
		sjb	doppen		;	AH = 8...11:
		cmp	ah,12		;	.16c/.256/.hic/.true s
		sjae	doppen		;	BP fels hrom bit: felbonts,
		mov	ax,bp		;	a tbbi pedig a grafika
		mov	cl,13		;	sorszma: 0...8191.
		shr	ax,cl		;	Pl. a nv: 2GFX0001.256
		add	ax,"g0"		;	(az 1. kp 640*480/256-ban).
		stosw
		mov	ax,"xf"
		stosw
		mov	ax,bp
		and	ax,1fffh
		ncall	sztram4
		xchg	ax,bx
		stosw
		xchg	ax,bx
		stosw
		pop	ax
		push	ax
		xor	al,al
		sjmp	koppen
doppen:		lodsb
oppen:		stosb
		lodsb
		or	al,al
		sjnz	oppen
koppen:		xchg	al,ah
		add	ax,ax
		add	ax,ax
		add	ax,offset kiterj-4
		xchg	ax,si
		movsw
		mov	ax,"$"
		movsw
		stosw
		pop	ax
opifi:		push	ax
opika:		or	al,al
		push	ax
		sjs	stopi
		push	dx
		call	setpath
		pop	dx
		sjc	nopprob
stopi:		xor	cx,cx
		test	suan,32
		push	dx
		mov	ax,3d00h
		sjz	noppa
		dec	ah
noppa:		int	21h
		pop	dx
		sjc	nopprob
noppen:		pushf
		sjnc	pippen
		xor	ax,ax
pippen:		test	suan,32
		sjnz	wippa
		mov	file,ax
oppa:		popf
		pop	ax
		pop	ax
		ret
wippa:		and	suan,223
		mov	wile,ax
		sjmp	oppa
nopprob:	pop	ax
		or	al,al
		sjs	sujpa
		test	al,7
		sjz	ujpa
		dec	ax
		sjmp	opika
ujpa:		pop	ax
		add	al,8
		cmp	al,8*5
		sjb	opifi
		push	ax
sujpa:		push	ax
		stc
		sjmp	noppen
openread	endp
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
nevazon		proc	far
		push	ax		;	A "DTP"-ben lv filenevet
		ncall	nevbeasc	;	azonostja. Be:
		xor	bp,bp		;	AL = aktulis path. Ki:
		push	bx		;	AL = uaz,
addker:		mov	al,advnev[si+1]	;	AH = file (kiterjeszts szma),
		inc	si		;	BP = plusz adat (pl. kpnl),
		or	al,al		;	ES:[BX] = a nv cme (DTP!).
		sjz	admegv		;	Ha CF = 1: idegen file!
		cmp	al,es:[bx][si]
		sje	addker
		mov	al,es:[bx]
		sub	al,"0"
		sjb	idegen
		cmp	al,8
		mov	cl,13
		sjae	idegen
		shl	ax,cl
		cmp	br es:[bx+1],"g"
		xchg	ax,bp
		sjne	idegen
		cmp	wr es:[bx+2],"xf"
		sjne	idegen
		push	bx
		mov	ax,es:[bx+6]
		mov	bx,es:[bx+4]
;		ncall	szamol
		pop	bx
		sjc	idegen
		cmp	ah,32
		mov	si,8
		sjae	idegen
		;cmp	ax,grafika
		;sjae	idegen
		or	bp,ax
admegv:		mov	di,asctabl-kiterj
kitker:		mov	ax,wr kiterj[di-2]
		cmp	ax,es:[bx][si+2]
		mov	ax,wr kiterj[di-4]
		sjne	emnev
		cmp	ax,es:[bx][si]
		sjne	emnev
		xchg	ax,di
		pop	bx
		shr	ax,1
		shr	ax,1
		pop	dx
		xchg	al,ah
		mov	al,dl
		clc
		ret
emnev:		sub	di,4
		sja	kitker
idegen:		pop	bx
		xor	bp,bp
		xor	ax,ax
		pop	dx
		stc
		ret
nevazon		endp

nevbeasc:	mov	ah,2fh
		int	21h
		add	bx,1eh
		mov	si,12
		mov	wr es:[bx][si],"$"
nevep:		mov	al,es:[bx][si]
		cmp	al,"A"
		sjb	nevec
		cmp	al,"Z"
		sja	nevec
		add	br es:[bx][si],"a"-"A"
nevec:		dec	si
		sjns	nevep
		ret

filker:		mov	cx,ramdrp
		xor	si,si
		jcxz	filveg
filp:		cmp	ax,ramdrive0[si]
		sje	stilc
filc:		inc	si
		inc	si
		loop	filp
filveg:		stc
		ret
stilc:		cmp	bp,ramdrive1[si]
		sjne	filc
		ret
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
setkofs:	mov	si,wr kwan
		mov	al,iwan
		push	ds
		and	si,3
		mov	cl,5
		pop	es
		and	ax,12
		push	si
		or	si,ax
		push	ax
		shl	si,cl
		mov	di,offset poffs+34
		add	si,offset kofpos
		mov	cx,16
		rep	movsw
		pop	ax
		pop	si
		push	si
		push	ax
		and	si,1
		add	si,si
		and	al,4
		or	si,ax
		mov	di,offset sorsze+5
		add	si,offset ksorsze
		lodsb
		stosb
		stosb
		lodsb
		stosb
		stosb
		dec	si
		mov	di,offset gorsze+5
		dec	si
		lodsb
		stosb
		stosb
		lodsb
		stosb
		stosb
		pop	ax
		pop	si
		push	si
		push	ax
		and	si,2
		add	si,si
		and	al,8
		or	si,ax
		mov	di,offset kepsor+5
		add	si,offset kkepsor
		movsw
		movsw
		sub	si,4
		mov	di,offset gepsor+5
		lodsw
		add	ax,102h
		stosw
		lodsw
		add	ax,102h
		stosw
		pop	ax
		pop	si
		push	si
		push	ax
		add	si,si
		and	al,8
		or	si,ax
		add	si,si
		mov	di,offset doffs+4
		add	si,offset kofps
		movsw
		movsw
		pop	ax
		pop	si
		and	si,1
		add	si,si
		and	al,8
		shr	ax,1
		or	si,ax
		mov	di,offset dabsze+2
		add	si,offset kabsze
		movsw
		ret
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
saveini		proc	far		;	INI file mentse.
		mov	dx,offset ininame
		xor	ax,ax
		push	dx
		call	openread
		sjc	svihak
		ncall	fclose
		mov	ax,128
		sjmp	svihax
svihak:		ncall	ellstart
		mov	ax,5+1*8
		sjne	svihax
		mov	al,0+1*8
svihax:		pop	dx
		call	openwrite
		mov	ax,inipuf
		sjc	nutti
		xor	dx,dx
		or	ax,ax
		mov	cx,inimret
		stc
		sjz	svorrax
		cmp	cx,inimmax
		mov	bx,wile
		push	ds
		sjbe	inijo
		mov	cx,inimmax
inijo:		mov	ds,ax
		xor	ax,ax
		jcxz	dvorzax
		mov	ah,40h
		int	21h
dvorzax:	pop	ds
svorrax:	push	ax
		pushf
		ncall	wclose
		popf
		pop	ax
		sjc	nutti
		cmp	ax,cx
		sjbe	nutti
		stc
nutti:		njmp	ininutt
saveini		endp

loadini		proc	far		;	INI file tltse.
		push	file
		call	mellfog
		sjnc	frog
		njmp	rorrax

frog:		ncall	wrista
		cmp	al,[di]
		mov	dx,di
		sjne	xreax
		rep	movsb
		mov	ah,3dh
		stosb
		int	21h
		mov	file,ax
		mov	bp,inipuf
		mov	cx,inimmax
		sjmp	xeryx
xreax:		and	koppany,64
		call	openread
		mov	bp,filepuf
		mov	cx,fmeret
xeryx:		sjc	olga
		xor	dx,dx
		or	bp,bp
elga:		stc
		sjz	belga
		or	ch,ch
		mov	bx,file
		sjz	elga
		push	ds
		mov	ah,3fh
		mov	ds,bp
		push	bp
		int	21h
		pop	bp
		pop	ds
belga:		push	bp
		push	ax
		pushf
		ncall	fclose
		popf
		pop	ax
		pop	es
		sjc	olga
		xor	di,di
		cmp	ax,2
		xchg	ax,cx
		sjb	olga

vulva:		mov	al,"["
		repne	scasb
		mov	al,32
		sjne	olga
		cmp	br es:[di-2],"="
		sje	vulva
szolga:		cmp	al,es:[di]
		jcxz	olga
		sjne	hulga
		inc	di
		loop	szolga
hulga:		cmp	cx,mazov-mazon
		mov	si,offset mazon
		sjbe	olga
		mov	kiterj+23,"h"
vulga:		cmp	si,offset mazov
		mov	al,es:[di]
		sjae	volga
		cmp	al,"A"
		sjb	nyulga
		cmp	al,"Z"
		sja	nyulga
		sub	al,"A"-"a"
nyulga:		cmp	al,[si]
		sjne	vulva
		inc	di
		inc	si
		loop	vulga
volga:		mov	kiterj+23,"e"

olga:		ncall	ycobbe
		;sjc	rorrax
		;stc
		;sjz	rorrax
		ncall	wrista
		cmp	al,[di]
		mov	dx,di
		sjne	reax
		rep	movsb
		mov	ah,3dh
		stosb
		int	21h
		mov	file,ax
		mov	bp,inipuf
		mov	cx,inimmax
		sjmp	eryx
reax:		and	koppany,64
		call	openread
		mov	bp,filepuf
		mov	cx,fmeret
eryx:		sjc	rorrax
		xor	dx,dx
		or	bp,bp
orrax:		stc
		sjz	clorrax
		or	ch,ch
		mov	bx,file
		sjz	orrax
		push	ds
		mov	inipuf,bp
		mov	inimret,dx
		mov	inimmax,cx
		mov	ah,3fh
		mov	ds,bp
		int	21h
		pop	ds
clorrax:	push	ax
		pushf
		ncall	fclose
		popf
		pop	ax
		sjc	rorrax
		mov	inimret,ax
rorrax:		pop	file
		;ret
loadini		endp

ininutt		proc	far		;	Ha sikerlt a betlts,
		sjc	ofovi		;	elteszi a nevet, ha nem,
ininutt		endp			;	az eredetit vissza.

ofotert		proc	far		;	File-nv vglegests.
		pushf			;	(Csak, ha nem res!)
		ncall	fista
		cmp	al,[di]
		xchg	si,di
		sje	ofovipf
		rep	movsb
		stosb
ofovipf:	popf
ofotert		endp

ofovi		proc	far		;	File-nv eldobs.
		pushf			;	(Rgi vissza!)
		ncall	fista
		rep	movsb
		popf
		stosb
ofovi		endp

ininell		proc	far		;	Nvellenrzs.
		pushf			;	(Van-e nv + vgzds.)
		ncall	fista
		cmp	al,[di]
		sjne	ninive
		cmp	al,[si]
		sjne	inive
		ncall	wrista
inive:		rep	movsb
		stosb
		ncall	fista
ninive:		cmp	al,[di]
		sje	nixon
		inc	di
		loop	ninive
nixon:		mov	cx,di
		mov	si,di
		sub	cx,offset ininame
		sjbe	nopive
lopive:		dec	si
		mov	al,[si]
		cmp	al,"."
		sje	nopive
		cmp	al,":"
		sje	opive
		cmp	al,"\"
		sje	opive
		cmp	al,"/"
		sje	opive
		loop	lopive
opive:		cmp	di,offset ininame+60
		mov	ax,"i."
		sjae	nopive
		stosw
		mov	ax,"in"
		stosw
		mov	[di],ch
nopive:		popf
		ret
ininell		endp

wristart	proc	far		;	ininame = "start.ini"
		ncall	wrista
		rep	movsb
		stosb
		ret
wristart	endp

ellstart:	ncall	wrista		;	ininame == "start.ini"
		repe	cmpsb
		sjne	nyesta
		scasb
nyesta:		ret

fista:		mov	cx,63
		mov	si,offset inifin
		sjmp	fricska

wrista:		mov	cx,startiniv-startini
		mov	si,offset startini
fricska:	push	ds
		xor	ax,ax
		mov	di,offset ininame
		pop	es
		ret

readini		proc	far
		mov	cx,inipuf
		xor	ax,ax
		xor	di,di
		mov	es,cx
		xchg	ax,inimret
		jcxz	senever
		cmp	ax,inimmax
		sjbe	denex
		mov	ax,inimmax
denex:		cmp	di,ikpuf
		xchg	ax,cx
senever:	cmc
		sje	renever
		jcxz	renever
		call	prepare
denes:		mov	ax," ["
		jcxz	denever
		repne	scasb
		mov	al,ah
		jcxz	denever
		repe	scasb
		jcxz	denever
		dec	di
		inc	cx
		mov	al,"]"
		mov	si,di
		repne	scasb
		mov	dx,di
		jcxz	denever
		dec	dx
deneg:		cmp	br es:[di],"["
		mov	al,"="
		sje	denes
		loop	dover
denever:	push	wr kiterj+6
		push	wr kiterj+4
		push	wr kiterj+2
		push	wr kiterj
		xor	ax,ax
		call	postset
		pop	wr kiterj
		mov	bl,kiterj+3
		pop	wr kiterj+2
		call	briforg
		pop	wr kiterj+4
		mov	bl,kiterj+7
		pop	wr kiterj+6
		sje	efforg
		mov	kiterj+7,"a"
efforg:		call	becforg
		ncall	dreakf
renever:	ret
dover:		scasb
		mov	al,"["
		sjne	deneg
		repne	scasb
		mov	al,ah
		jcxz	denever
		repe	scasb
		jcxz	denever
		dec	di
		inc	cx
		mov	al,"]"
		mov	bp,di
		repne	scasb
		mov	bx,di
		jcxz	denever
seneq:		dec	bx
		cmp	ah,es:[bx-1]
		sje	seneq
		sub	dx,si
		sjbe	ndenes
		sub	bx,bp
		sjbe	ndenes

		push	cx
		mov	cx,dx
		push	es
		mov	dl,48
		push	di
		mov	es,ikpuf
		push	bx
		mov	di,wr es:[0]
		push	bp
		mov	di,wr es:[di+10]
trimpike:	push	cx
		push	si
pimpike:	ncall	korall
		sje	tronb
		mov	al,127
		pop	si
		inc	dx
trimp:		scasb
		sja	trimp
		cmp	dl,216
menes:		pop	cx
		sjb	trimpike
gyenes:		pop	bp
		pop	bx
szenes:		pop	di
		pop	es
		pop	cx
ndenes:		njmp	denes
tronb:		loop	pimpike
		pop	ax
		mov	cl,balsor
		pop	ax
		xor	si,si
		jcxz	gyenes
depri:		cmp	dl,balhint[si]
		sje	deksi
		inc	si
		loop	depri
		sjmp	gyenes
deksi:		mov	dx,si
		call	dakta
		sjz	hatha
		mov	si,bp
		pop	bp
		pop	dx
		jcxz	szenes
		push	ax
prim:		mov	di,wr es:[39*2]
		lodsb
		add	di,128
		or	al,al
		push	cx
		xchg	ax,bx
		push	si
		sjnz	vol
		sjmp	menes
krext:		pop	si
		pop	cx
		add	si,cx
		sjmp	prim
vamzer:		scasb
		sja	vamzer
vol:		dec	bl
		mov	al,127
		sjnz	vamzer
		mov	si,bp
		mov	cx,dx
chrol:		ncall	korall
		sjne	krext
		loop	chrol
		pop	di
		pop	cx
		pop	si
		lodsb
		cmp	al,cl
		sjne	szenes
reol:		lodsw
		xchg	ax,bx
		lodsb
		not	al
		and	[bx],al
		not	al
		and	al,[di]
		inc	di
		or	[bx],al
		loop	reol
szennyes:	sjmp	szenes
hatha:		xchg	ax,si
		lodsb
		and	ax,127
		xchg	ax,dx
		lodsw
		pop	si
		pop	cx
		sjz	szennyes
		cmp	cx,dx
		xchg	ax,di
		sjbe	hatho
		mov	cx,dx
hatho:		push	ds
		mov	ds,inipuf
		xor	ax,ax
		cmp	br [si],"?"
		pop	es
		sje	haxni
		cmp	br [si],"*"
		sje	haxni
		rep	movsb
haxni:		push	es
		stosb
		pop	ds
		sjmp	szennyes
readini		endp

writeini	proc	far
		call	mellfog
		sjc	nworrs
		ncall	ycobbe
		sjc	nworrs
		sjz	sworrs
		call	prepare
                mov	es,filepuf
		xor	di,di
		xor	bx,bx
		and	koppany,64
		mov	inipuf,es
		mov	inimret,di
seclep:		mov	ax,13+256*10
		cmp	bl,9
		mov	cx,-1
		lea	dx,[bx+35]
		sjb	negyeb
		mov	dl,100
negyeb:		stosw
		ncall	kontext
		dec	di
		mov	al,":"
		stosb
		mov	ax,13+256*10
		add	bx,bx
		stosw
		mov	si,sections[bx]
		stosw
		shr	bx,1
altep:		mov	ax,fmeret
                dec	ah
                cmp	ax,di
		mov	inimmax,ax
		lodsb
		sjb	nworrs
		or	al,al
		cbw
		sjs	album
		cmp	al,balsor
		sjae	album
		push	si
		mov	si,ax
		push	ax
		mov	al,balhint[si]
		xchg	ax,dx
		ncall	konvex
		mov	al,"="
		pop	dx
		stosb
		call	aktadat
		mov	ax,13+256*10
		pop	si
		stosw
		sjmp	altep
sworrs:		stc
nworrs:		ret
nseclep:	sjmp	seclep
album:		inc	bx
		cmp	bx,(sectionv-sections)/2
		mov	inimret,di
		sjb	nseclep
worrs:		ret
writeini	endp

korall:		mov	al,es:[di]
		or	al,al
		mov	bx,offset asctabl
		sjns	krone
		xor	ax,ax
		dec	di
krone:		xlat
		ncall	bronerg
		push	ds
		inc	di
		mov	ds,inipuf
		mov	ah,al
		lodsb
		pop	ds

bronerg:	ncall	bronwex
energ:		cmp	al,"A"
		sjb	brinb
		cmp	al,"Z"
		sja	brinb
		sub	al,"A"-"a"
brinb:		cmp	al,ah
		ret

rolex:		ncall	bronwex
		test	brown,4
		sjz	energ
		cmp	al,"a"
		sjb	brinb
		cmp	al,"z"
		sja	brinb
		add	al,"A"-"a"
		sjmp	brinb

aktadat		proc	far
		call	dakta
		sjz	trakta
		mov	cx,-1
trakta:		ncall	konvex
		ret
aktadat		endp

konvex:		test	brown,2
		mov	al,"["
		sjz	bro1
		mov	al,"("
bro1:		or	cx,cx
		mov	bp,ds
		stosb
		jcxz	nontext
		sjns	ontext
kontext:	mov	bp,ikpuf
		push	ds
		mov	ds,bp
		mov	si,wr ds:[39*2]
		add	si,128
hluvv:		dec	dx
		sjz	slepp
		sjs	slepp
slukk:		lodsb
		or	al,al
		sjns	slukk
		sjmp	hluvv
slepp:		pop	ds
		sjs	nontext
ontext:		cmp	bp,ikpuf
		push	ds
		mov	ds,bp
		lodsb
		pop	ds
		sje	vrolk
		or	al,al
		sjz	nontext
		cmp	al,-1
		sje	nontext
		sjmp	brolv
vrolk:		push	bx
		mov	bx,offset asctabl
		or	al,al
		xlat
		pop	bx
		sjs	nontext
brolv:		ncall	krolvex
		sjne	nakonx
		cmp	br es:[di-1],"["
		sje	vakox
		cmp	br es:[di-1],"("
		sje	vakox
nakonx:		stosb
vakox:		loop	ontext
nontext:	dec	di
		mov	ah,es:[di]
		cmp	ah,32
		mov	al,"?"
		sje	nontext
		inc	di
		cmp	ah,"["
		sje	samson
		cmp	ah,"("
		sjne	nikson
samson:		stosb
nikson:		test	brown,2
		mov	al,"]"
		sjz	stoxx
		mov	al,")"
stoxx:		mov	cx,-1
		stosb
		ret

krolvex:	test	brown,2
		sjnz	eggah
bronwex:	push	bx
		mov	bx,(wolfex-volvex)-1
onwex:		cmp	al,volvex[bx]
		sjne	olvex
		mov	al,wolfex[bx]
olvex:		dec	bx
		sjns	onwex
		pop	bx
eggah:		cmp	al,32
		ret
		
dakta		proc	far
		mov	si,offset baladat
		inc	dx
balmax:		lodsb
		dec	dx
		cbw
		sjz	balma
		add	si,ax
		cmp	si,offset baladatv
		sjb	balmax
balma:		push	si
		lodsb
		or	al,al
		xchg	ax,cx
		sjns	bytes
		lodsw
		pop	si
		and	cl,127
		xor	dx,dx
		xchg	ax,si
		ret
bytes:		sjz	balmaz
		push	es
		push	di
		les	di,vesacim
		push	bx
		push	cx
vebyt:		lodsw
		xchg	ax,bx
		lodsb
		and	al,[bx]
		stosb
		loop	vebyt
		pop	cx
		mov	bp,si
		sub	si,cx
		sub	di,cx
		pop	bx
vepci:		add	si,cx
		lodsb
		or	al,al
		mov	dl,al
		sjz	valmaz
		push	cx
		push	si
		push	di
		repe	cmpsb
		pop	di
		pop	si
		pop	cx
		sjne	vepci
valmaz:		pop	di
		dec	si
		pop	es
balmaz:		or	dx,dx
		pop	ax
		sjnz	almaz
		mov	cx,dx
almaz:		ret
dakta		endp

prepare		proc	far
		pushf
		push	ax
		push	bx
		push	cx
		push	dx
		push	si
		push	di
		push	bp
		push	es
		push	ds
		mov	si,offset prhonn
		pop	es
prelp:		lodsw
		xchg	ax,di
		lodsw
		xchg	ax,cx
		lodsw
		push	si
		ncall	broxor
		xchg	si,di
		jcxz	prox
		sjc	prolp
		sjs	prolp
		dec	cx
		dec	cx
		stosw
		jcxz	proli
prolp:		or	si,si
		sjz	proli
prolpl:		lodsb
		ncall	krolvex
		or	al,al
		sjz	proli
		stosb
		loop	prolpl
proli:		pop	si
		xor	ax,ax
		cmp	si,offset prhonnv
		stosb
		sjb	prelp
		ncall	leszed
		or	brown,4
		ncall	angyal

nopret:		and	hexan,127
		and	tegan,63
		xor	ax,ax
		test	hexan,8
		sjz	oxan
		or	tegan,64
oxan:		test	suan,1
		mov	es,ax
		sjz	noxan
		or	tegan,128
noxan:		test	br es:[417h],16
		mov	al,ablak
		sjz	scroxan
		or	hexan,128
scroxan:	and	al,3
		and	wr pufabl,191*(1+256)
		xchg	ax,si
		and	wr pufabl+2,191*(1+256)
		or	pufabl[si],64
		njmp	fruxi

prox:		cmp	si,offset ntmousx
		mov	ax,[si]
		sjne	ntly
		cmp	ax,xmax
		sjbe	ntlxy
		mov	ax,xmax
		sjmp	ntlxy
ntly:		cmp	si,offset ntmousy
		sjne	prolo
		cmp	ax,ymax
		sjbe	ntlxy
		mov	ax,ymax
ntlxy:		xor	si,si
		sjmp	nango
prolo:		cmp	si,offset scszaml
		mov	cx,offset pertz
		lodsb
		sjne	rolice
		inc	cx
		inc	cx
		cmp	al,99
		sjbe	prolice
		mov	al,99
		sjmp	prolice
rolice:		cmp	br [si+7],1
		mov	ah,al
		mov	al,100
		sjbe	prolice
		mul	ah
		div	br [si+7]
		add	ah,ah
		cmp	ah,br [si+7]
		sjb	prolice
		inc	ax
prolice:	or	al,al
		mov	si,cx
		sjns	lilice
		mov	al,100
lilice:		cbw
		sjnz	olice
		inc	ax
olice:		cmp	ah,angol
		sje	nango
		add	si,8
nango:		push	bx
		ncall	stram4
		xchg	ax,bx
		cmp	al,"1"
		sjb	jango
		stosw
jango:		mov	al,ah
		sjae	fango
		cmp	al,"1"
		sjb	fango
		stosb
fango:		xchg	ax,bx
		sjae	mango
		cmp	al,"1"
mango:		pop	bx
		stosw
		sjae	tango
		dec	di
		mov	al,ah
		dec	di
		stosb
tango:		njmp	prolp
prepare		endp

prepost		proc	far
		call	prepare
		xor	ax,ax
prepost		endp

postset		proc	far
		pushf
		push	ax
		push	bx
		push	cx
		push	dx
		push	si
		push	di
		push	bp
		push	es
		push	ds
		or	al,al
		pop	es
		sjnz	nopset
		ncall	leszed
		mov	si,offset prhonn
pselp:		lodsw
		xchg	ax,di
		lodsw
		xchg	ax,cx
		lodsw
		push	si
		ncall	broxor
		jcxz	cpsox
		sjc	psolp
		or	ch,ch
		sjnz	psolp
		cmp	ch,[si]
		mov	br [bx],-1
		sje	psolp
		cmp	ah,[si+1]
		sjne	psolp
		lodsw
		cmp	al,"z"
		sja	psols
		sub	al,"a"
		sjb	psols
		mov	[bx],al
psols:		mov	al,"\"
		cmp	al,[si]
		jcxz	coli
		sje	joli
		dec	cx
coli:		stosb
joli:		jcxz	psoli
psolp:		lodsb
		ncall	krolvex
		or	al,al
		stosb
		sjz	psoli
		loop	psolp
psoli:		pop	si
		xor	ax,ax
		cmp	si,offset prhonn+11*6
		sjbe	tvoli
		cmp	si,offset prhonn+19*6
		sjae	tvoli
		stosb
tvoli:		cmp	si,offset prhonnv
		sjb	pselp
		cmp	al,felhany
		sjne	lehany
		call	elpath
		inc	felhany
lehany:		ncall	felrak
		cmp	felhany,1
		sjne	nopset
		call	vipath
		sjmp	nopset
cpsox:		sjmp	psox

nopset:		mov	al,tegan
		mov	ah,hexan
		push	ax
		and	ax,64+8*256
		sjz	resso
		cmp	ax,64+8*256
		sje	resso
		call	fsorvalt
resso:		pop	ax
		push	ax
		mov	ah,suan
		and	ax,128+1*256
		sjz	rekkix
		cmp	ax,128+1*256
		sje	rekki
		call	fikcser
rekki:		xor	ax,ax
rekkix:		mov	es,ax
		pop	ax
		or	br es:[417h],16
		or	ah,ah
		sjs	scroxi
		and	br es:[417h],239
scroxi:		njmp	fruxi

pxota:		add	br [si],71
		inc	si
		inc	cx
psox:		sub	br [si],"0"
		sjb	xota
		cmp	br [si],9
		sjbe	pxota
xota:		push	bx
		push	dx
		sub	si,cx
		push	di
		push	bp
		call	numstring
		pop	bp
		pop	di
		mov	cx,dx
		pop	dx
		pop	bx
		sjc	xango
		cmp	di,offset ntmousx
		sjne	xmoli
		cmp	ax,xmax
		sjmp	jolee
xmoli:		cmp	di,offset ntmousy
		sjne	czolee
		cmp	ax,ymax
jolee:		sjae	xoli
		test	smode,16
		sjnz	xoli
		test	sfelb,7
		sjz	xoli
		jcxz	smoli
xoli:		xor	ax,ax
smoli:		xor	cx,cx
		or	ax,ax
		sjz	smolee
		mov	egerx,cx
		mov	egery,cx
smolee:		stosw
		sjmp	xango
czolee:		or	cx,cx
		sjnz	xaqqa
		cmp	ax,100
		sjb	qaxxa
xaqqa:		cmp	di,offset scszaml
		mov	al,100
		sjne	qaxxa
		dec	ax
qaxxa:		or	al,al
		sjnz	qaqqa
		inc	ax
qaqqa:		cmp	di,offset scszaml
		stosb
		sje	xango
		mov	br [di+7],100
xango:		njmp	psoli
postset		endp

fruxi		proc	far
		pop	es
		pop	bp
		pop	di
		pop	si
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		popf
		ret
fruxi		endp

angyal:		mov	di,offset xesa+72
		mov	cx,456
isapur:		mov	al,[di]
		ncall	rolex
		stosb
		loop	isapur
		ret

broxor:		cmp	di,offset fastpath
		mov	bx,offset inipaths
		xchg	ax,si
		sje	bath
		inc	bx
		cmp	di,offset server
		sje	bath
		inc	bx
		cmp	di,offset secpath
		sje	bath
		inc	bx
		cmp	di,offset terpath
		sjne	sroxi
bath:		cmp	cl,2
		mov	al,[bx]
		sjb	xroxi
		or	al,al
		mov	ah,":"
		sjs	roxi
		add	al,"a"
roxi:		ret
sroxi:		stc
xroxi:		ret

leszed:		push	wr brown
		and	brown,249
		ncall	angyal
		pop	wr brown
		mov	si,offset xesa+80
		ncall	lecter
		mov	si,offset xesa+144
		ncall	lecter
		mov	si,offset xesa+208
		ncall	lecter
		mov	si,offset xesa+272

lecter:		xor	cx,cx
cecter:		lodsb
		inc	cx
		or	al,al
		sjnz	cecter
		dec	si
		dec	cx
decter:		mov	[si],al
		jcxz	xecter
		dec	si
		dec	cx
		cmp	br [si],32
		sjbe	decter
		cmp	br [si],"\"
		sje	decter
		cmp	br [si],":"
		sje	xecter
		xor	dx,dx
		push	cx
		push	si
hecter:		inc	dx
		jcxz	zecter
		dec	si
		dec	cx
		cmp	br [si],32
		sjbe	vecter
		cmp	br [si],"\"
		sje	vecter
		cmp	br [si],":"
		sjne	hecter
vecter:		inc	si
zecter:		push	ds
		mov	di,offset advnev
		pop	es
		mov	bp,dx
ecter:		cmpsb
		sjne	pecter
		dec	dx
		sjns	ecter
		dec	bp
		pop	si
		pop	cx
		sub	si,bp
		sub	cx,bp
		sjmp	decter
pecter:		pop	si
		pop	cx
xecter:		ret

felrak:		mov	ax,wr inipaths
		test	boot,4
		mov	paths,al
		mov	paths+5,ah
		mov	ax,wr inipaths+2
		mov	si,offset secpath
		mov	wr paths+2,ax
		mov	al,2*8
		sjnz	evar
		ncall	devavar
		mov	al,3*8
		mov	si,offset terpath
		ncall	devavar
evar:		mov	al,4*8
		mov	si,offset elnev
		ncall	devavar
		mov	al,5*8
		mov	si,offset server
		ncall	devavar

fastell:	xor	al,al
		mov	si,offset fastpath
		ncall	devavar
		sjc	xecter
		mov	dx,offset system
		ncall	mkdir
		mov	dx,offset gfx256
		njmp	mkdir
		;mov	dx,offset gfxhi
		;ncall	mkdir
		;mov	dx,offset gfxtru
		;njmp	mkdir

devavar:	push	si
		push	ax
		ncall	device
		pop	ax
		pop	si
		sjc	fastveg
		cmp	al,4*8
		push	ax
		push	si
		sje	fastmegv
fastren:	ncall	advdir
		sjnc	fastmegv
		ncall	advmake
		sjnc	fastren
fastmegv:	pop	si
		ncall	aktpath
		pop	bx
		mov	cl,3
		xor	bh,bh
		mov	di,offset pripath
		shr	bl,cl
		push	ds
		cmp	bl,5
		pop	es
		mov	ah,paths[bx]
		mov	dx,bx
		mov	bl,1
		sja	klamath
		;cmp	dl,4
		;sje	amath
papath:		cmp	bl,4
		sje	mamath
		cmp	dl,bl
		mov	al,paths[bx]
		sje	mamath
		or	al,al
		mov	cx,64
		sjs	mamath
		cmp	al,ah
		sjne	mamath
		push	si
		push	di
pimath:		lodsb
		scasb
		sjne	romath
		or	al,al
		sjz	romath
		loop	pimath
romath:		pop	di
		pop	si
		jcxz	amath
		sjnz	mamath
amath:		mov	bl,dl
		stc
		mov	paths[bx],-1
		ret
mamath:		inc	bx
		add	di,64
		cmp	bl,6
		sjb	papath
klamath:	;clc
fastveg:	ret

secternam	proc	far
		xor	ax,ax
		cmp	inipaths+2,al
		mov	si,offset secpath
		sjns	diree
		cmp	al,[si]
		sjne	diree
		mov	wr [si],":C"
		mov	wr [si+2],"\"
diree:		cmp	inipaths+3,al
		mov	si,offset terpath
		sjns	dirig
		cmp	al,[si]
		sjne	dirig
		mov	ah,19h
		mov	[si+2],al
		int	21h
		add	al,"A"
		mov	ah,":"
		mov	[si],ax
		push	wr [si+63]
		push	wr [si+65]
		inc	si
		inc	si
		ncall	aktpath
		pop	wr terpath+65
		pop	wr terpath+63
dirig:		ret
secternam	endp
;------------------------------------------------------------------------------

egyrut	ends

