\SB.XPL		4-MAY-2002
\Isometric Soko-Ban Game
\ by Loren Blaney		loren_blaney@idcomm.com

inc	\cxpl\codesi;		\intrinsic routine declarations

def	Debug = true;		\enable traps

seg char ScreenBuf(1);		\screen buffer

char	SpTitle(2+255*64),	\sprites: width, height, 32x32 graphic image
	SpFloor(2+32*32),
	SpDock(2+32*32),
	SpWall(2+32*32),
	SpBox(2+32*32),
	SpMan1(2+32*32),	\man facing in four directions
	SpMan2(2+32*32),
	SpMan3(2+32*32),
	SpMan4(2+32*32);

int	FloorPlan(20, 17);	\20 columns by 17 rows

def	StkMax = 30000;		\stack for saving & undoing 30000/11 = 2727 moves
char	Stack(StkMax),
	StkPtr;			\stack pointer (see Push and Pop procs);

char	ColorReg(256*3);	\copy of initial color reg values for Fade

int	Key,			\keystroke's scan code
	Level,			\floor plan level number
	ManI, ManJ,		\man's location in FloorPlan (tiles)
	Nx, Ny,			\possible new man location (tiles)
	Bx, By,			\possible new box location (tiles)
	MoveCtr,		\move counter (number of arrow keystrokes)
	RefI, RefJ,		\reference tile location, for scrolling
	Temp;			\temporary scratch

def	Nul=$00, Bel=$07, BS=$08, Tab=$09, LF=$0A, FF=$0C,	\control chars
	CR=$0D, EOF=$1A, Esc=$1B, Sp=$20, Ctrl=$40;



proc	Exit(Msg);	\Display (error) message and terminate program
char	Msg;
begin
SetVid($03);				\restore normal text mode
Text(0, Msg);
Crlf(0);
exit;
end;	\Exit



proc	Erase(Im, C);	\Erase ScreenBuf
seg int Im;		\write two bytes at a time for speed
int	C;		\color
int	T, I;
begin
C:= C ! C<<8;				\set high & low bytes to same color
T:= (320*8)/2;				\number of words on top 8 scan lines
for I:= 0, T-1 do
	Im(0, I):= $0000;		\black (to match background of text)
for I:= T, 32000-1 do
	Im(0, I):= C;
end;	\Erase



proc	Push(N);	\Push N onto the Stack
int	N;
begin
if StkPtr < StkMax then
	begin
	Stack(StkPtr):= N;
	StkPtr:= StkPtr + 1;
	end;
end;	\Push



func	Pop;		\Pop item from Stack and return it
begin
if StkPtr > 0 then
	StkPtr:= StkPtr - 1;
return Stack(StkPtr);
end;	\Pop



func	CallInt(Int, AX, BX, CX, DX, BP, DS, ES); \Call software interrupt
int	Int, AX, BX, CX, DX, BP, DS, ES; \(unused arguments need not be passed)
int	Cpureg;
begin
Cpureg:= Getreg;
Cpureg(0):= AX;
Cpureg(1):= BX;
Cpureg(2):= CX;
Cpureg(3):= DX;
Cpureg(6):= BP;
Cpureg(9):= DS;
Cpureg(11):= ES;
Softint(Int);
return Cpureg(0);		\return AX register
end;	\CallInt

\-------------------------------------------------------------------------------

proc	Fade(Dn, Spd);	\Fade screen colors up or down
int	Dn,	\flag: fade down to black
	Spd;	\speed: 0=slow, 1=fast, 2=very fast
int	Ints;	\intensity


	proc	Set(I);		\Set intensity of the colors
	int	I;
	int	J;
	begin
	while port($3DA) & $08 do;	\wait for no vertical blank
	repeat until port($3DA) & $08;	\wait for vertical blank

	port($3C8):= 0;			\set color registers
	for J:= 0, 256*3-1 do
		port($3C9):= (ColorReg(J) * I) >>6;
	end;	\Set


begin	\Fade
if Dn then
	for Ints:= -$3F, 0 do [Set(-Ints);   Ints:= Ints +Spd]
else	for Ints:= 1, $40 do [Set(Ints);   Ints:= Ints +Spd];
end;	\Fade

\-------------------------------------------------------------------------------

proc	DrawSprite(X0, Y0, S);	\Draw a sprite
int	X0, Y0;	\coordinates where upper-left corner of sprite is displayed
char	S;	\address of sprite image
int	X, Y, K, Y320, P, W, H;
begin
W:= S(0);	\get width and height
H:= S(1);
K:= 2;
for Y:= Y0, Y0+H-1 do
	begin
	Y320:= Y * 320;
	for X:= X0, X0+W-1 do
		begin
		P:= S(K);			\get pixel's color
		K:= K + 1;
		if P & X>=0 & X<320 then	\background (0) is transparent
		    if Y>=8 & Y<200 then	\clip below text on top line
			ScreenBuf(0, X+Y320):= P;
		end;
	end;
end;	\DrawSprite

\-------------------------------------------------------------------------------

proc	LoadFloorPlan;		\Load next level into FloorPlan
int	I, J, Ch;
begin
for J:= 0, 17-1 do			\all floor plans are 20x17
    for I:= 0, 20-1 do
	begin
	repeat	Ch:= Chin(3);
		if Ch = EOF then Exit("All levels solved!");	\terminate prog
	until Ch>=$20 & Ch<=$7E & Ch#^>;	\skip CR, LF, etc.
	case Ch of
	  ^ :	FloorPlan(I,J):= $01;	\floor
	  ^!:	FloorPlan(I,J):= $02;	\loading dock
	  ^":	FloorPlan(I,J):= $00;	\background
	  ^#:	FloorPlan(I,J):= $03;	\wall
	  ^$:	FloorPlan(I,J):= $11;	\box on floor
	  ^%:	FloorPlan(I,J):= $12;	\box on dock
	  ^&:	begin
		FloorPlan(I,J):= $21;	\man on floor
		ManI:= I;
		ManJ:= J;

		RefI:= 0;
		RefJ:= 0;
		if ManI <  6 then RefI:= RefI + ManI-6;
		if ManI > 13 then RefI:= RefI + ManI-13;
		if ManJ <  6 then RefJ:= RefJ + ManJ-6;
		if ManJ > 13 then RefJ:= RefJ + ManJ-13;
		end
	other	[];			\ignore any other characters
	end;
end;	\LoadFloorPlan

\-------------------------------------------------------------------------------

proc	DrawFloorPlan;
\Draw floor plan for current level, including boxes and man
int	I, J,		\coordinates on floor (tiles)
	X, Y;		\coordinates on screen (pixels)


	func	Tile2PixX(I, J);    \Convert tile position to pixel X coordinate
	int	I, J;
	begin
	I:= I - RefI;
	J:= J - RefJ;
	return J*16 - (19-I)*16 + 160-16;
	end;	\Tile2PixX


	func	Tile2PixY(I, J);    \Convert tile position to pixel Y coordinate
	int	I, J;
	begin
	I:= I - RefI;
	J:= J - RefJ;
	return J*8 - I*8 + 96-8;
	end;	\Tile2PixY


	proc	DrawMan;	\Facing direction of last keystroke
	case Key of
	  $48:	DrawSprite(X, Y, SpMan2);	\up
	  $4B:	DrawSprite(X, Y, SpMan3);	\left
	  $4D:	DrawSprite(X, Y, SpMan4)	\right
	other	DrawSprite(X, Y, SpMan1);	\down


begin	\DrawFloorPlan
Erase(ScreenBuf, 2\green\);

for J:= 0, 17-1 do		\ from top to bottom
    for I:= -19, 0 do		\ from right to left
	begin
	X:= Tile2PixX(-I, J);
	Y:= Tile2PixY(-I, J);
	case FloorPlan(-I, J) of
	  $01:	DrawSprite(X, Y, SpFloor);
	  $02:	DrawSprite(X, Y, SpDock);
	  $00:	[];			\background
	  $03:	DrawSprite(X, Y, SpWall);
	  $11:	[DrawSprite(X, Y, SpFloor);
		 DrawSprite(X, Y, SpBox)];
	  $12:	[DrawSprite(X, Y, SpDock);
		 DrawSprite(X, Y, SpBox)];
	  $21:	[DrawSprite(X, Y, SpFloor);   DrawMan];
	  $22:	[DrawSprite(X, Y, SpDock);   DrawMan]
	other	[if Debug then Exit("Illegal sprite code")];
	end;

Blit(ScreenBuf(0), 0, $A000, 0, 64*1000);	\copy image to screen

\Display level name in upper-left corner
Attrib($07);		\for mode $13: white on background color
Cursor(0, 0);
Text(6, "LEVEL ");
Intout(6, Level);
Cursor(33, 0);
Text(6, "0 MOVES");
end;	\DrawFloorPlan

\-------------------------------------------------------------------------------

func	Solved;		\Return 'true' all the docks have boxes on them
int	I, J;		\(Note: Some levels have more boxes than docks)
begin
for J:= 0, 17-1 do
    for I:= 0, 20-1 do
	begin
	if (FloorPlan(I,J)&$0F) = $02\dock\ then
		if (FloorPlan(I,J)&$F0) # $10\box\ then return false;
	end;
return true;
end;	\Solved



proc	Undo;		\Undo a move
begin
if StkPtr > 0 then			\there is a move saved on the stack
	begin
	RefJ:= extend(Pop);		\restore scroll info
	RefI:= extend(Pop);
	By:= Pop;			\restore new location of box
	Bx:= Pop;
	Ny:= Pop;			\restore new location of man
	Nx:= Pop;
	ManJ:= Pop;			\restore location of man
	ManI:= Pop;
	FloorPlan(Bx,By):= Pop;		\restore contents where box might go
	FloorPlan(Nx,Ny):= Pop;		\restore contents at new man location
	FloorPlan(ManI,ManJ):= Pop;	\restore man and his background
	MoveCtr:= MoveCtr - 1;
	end;
end;	\Undo



proc	DoMove;
\The arrow keys move the man and possibly a box.
\When moving the man or box, preserve background color of floor or dock.


	proc	MoveMan;	\Display man at N and blank out man at ManI,ManJ
	begin
	FloorPlan(Nx,Ny):= (FloorPlan(Nx,Ny) & $0F) ! $20;
	FloorPlan(ManI,ManJ):= FloorPlan(ManI,ManJ) & $0F;
	ManI:= Nx;   ManJ:= Ny;	\set man to new location

	if ManI-RefI <  6 then RefI:= RefI - 1;
	if ManI-RefI > 13 then RefI:= RefI + 1;
	if ManJ-RefJ <  6 then RefJ:= RefJ - 1;
	if ManJ-RefJ > 13 then RefJ:= RefJ + 1;
	end;	\MoveMan


begin	\DoMove
Nx:= ManI;   Ny:= ManJ;
Bx:= ManI;   By:= ManJ;
case Key of	\determine possible new locations for man (N) and box (B)
  $48:	[Ny:= ManJ-1; By:= Ny-1];	\up
  $4B:	[Nx:= ManI-1; Bx:= Nx-1];	\left
  $4D:	[Nx:= ManI+1; Bx:= Nx+1];	\right
  $50:	[Ny:= ManJ+1; By:= Ny+1]	\down
other	[];

\Save state so the move can be undone
Push(FloorPlan(ManI,ManJ));		\save man and his background
Push(FloorPlan(Nx,Ny));			\save contents at new man location
Push(FloorPlan(Bx,By));			\save contents where box might go
Push(ManI);				\save location of man
Push(ManJ);
Push(Nx);				\save new location of man
Push(Ny);
Push(Bx);				\save new location of box
Push(By);
Push(RefI);				\save scroll info
Push(RefJ);

MoveCtr:= MoveCtr + 1;	\increment move counter (even if move is illegal)

if FloorPlan(Nx,Ny)=$01\floor\ ! FloorPlan(Nx,Ny)=$02\dock\ then
	MoveMan
else if (FloorPlan(Nx,Ny) & $F0) = $10\box\ then
    begin
    if FloorPlan(Bx,By)=$01\floor\ ! FloorPlan(Bx,By)=$02\dock\ then
	begin
	FloorPlan(Bx,By):= (FloorPlan(Bx,By) & $0F) ! $10;     \display box at B
	MoveMan;
	end;
    end;
end;	\DoMove

\===============================================================================

proc	LoadSprites;	\Load sprite images from .BMP file
int	Han,		\file handle
	Width, Height,	\dimensions of entire image in .BMP file (pixels)
	R, G, B,	\red, green, blue
	X, Y,		\screen coordinates (pixels)
	Y320,		\Y * 320
	I, K, T;	\indexes and tempory scratch


	proc	LoadSp(X0, Y0, W, H, Sp);	\Load a sprite
	int	X0, Y0,		\coordinates in ScreenBuf to get sprite from
		W, H;		\width and height (pixels)
	char	Sp;		\sprite to load
	int	K, X, Y;
	begin
	Sp(0):= W;
	Sp(1):= H;
	K:= 2;
	for Y:= Y0, Y0+H-1 do
	    for X:= X0, X0+W-1 do
		begin
		Sp(K):= ScreenBuf(0, X+Y*320);
		K:= K + 1;
		end;
	end;	\LoadSp


begin	\LoadSprites
\Read in a 256-color .BMP file
Trap(false);				\don't trap "file not found" error
Han:= FOpen("SPRITES.BMP", 0);		\open file for input
if Geterr \#0\ then Exit("SPRITES.BMP not found");
Trap(Debug);				\turn traps back on if debug mode
FSet(Han, ^I);				\set device 3 to handle
Openi(3);

for Y:= 0, 17 do X:= Chin(3);		\skip unused header info
Width:= Chin(3) + Chin(3)<<8;		\0..32764 (ample range)
for Y:= 0, 2-1 do X:= Chin(3);		\skip
Height:= Chin(3) + Chin(3)<<8;		\0..32767 (ample range)
for Y:= 24, 53 do X:= Chin(3);		\skip

K:= 0;
port($3C8):= 0;				\set color registers
for I:= 0, 255 do
	begin
	B:= Chin(3)>>2;
	G:= Chin(3)>>2;
	R:= Chin(3)>>2;
	T:= Chin(3);
	port($3C9):= R;
	port($3C9):= G;
	port($3C9):= B;

	ColorReg(K):= R;		\save copy for Fade routine
	ColorReg(K+1):= G;
	ColorReg(K+2):= B;
	K:= K + 3;
	end;

\Load .BMP image into ScreenBuf
for Y:= -(Height-1), 0 do		\.BMP files are upside down
	begin
	Y320:= 320 * -Y;
	for X:= 0, Width-1 do
		ScreenBuf(0, X+Y320):= Chin(3);
	end;
FClose(Han);				\close handle so it can be used again

LoadSp( 0,136,255, 64, SpTitle);	\grab individual sprites
LoadSp( 0,  0, 32, 32, SpFloor);
LoadSp(32,  0, 32, 32, SpDock);
LoadSp(64,  0, 32, 32, SpWall);
LoadSp(96,  0, 32, 32, SpBox);
LoadSp( 0, 32, 32, 32, SpMan1);
LoadSp(32, 32, 32, 32, SpMan2);
LoadSp(64, 32, 32, 32, SpMan3);
LoadSp(96, 32, 32, 32, SpMan4);
end;	\LoadSprites

\-------------------------------------------------------------------------------

proc	GetStartingLevel;		\Get starting level
int	I, Ch, Han;
begin
Trap(false);				\don't trap "file not found" error
Han:= FOpen("LEVELS.TXT", 0);		\open file for input
if Geterr \#0\ then Exit("LEVELS.TXT not found");
Trap(Debug);				\restore traps if not debug mode
FSet(Han, ^I);				\set device 3 to handle
Openi(3);

Erase(ScreenBuf, 0\black\);			\show title
DrawSprite(32, 32, SpTitle);
Blit(ScreenBuf(0), 0, $A000, 0, 64*1000);	\copy image to screen

Attrib($20);				\bright red
Cursor(7, 17);
Text(6, "Enter starting level: __");
loop	begin
	Attrib($0F);			\bright white
	Cursor(7+22, 17);
	Level:= Intin(0);
	if Level>=1 & Level<=36 then quit;	\check for valid range
	Cursor(7, 19);
	Attrib($20);
	Text(6, "Please select 1 thru 36");
	repeat until Chkkey;
	Cursor(7+22, 17);		\blank erroneous entry
	Text(6, "__     ");
	end;

\Skip to selected level
for I:= 1, Level do
	repeat	Ch:= Chin(3);
	until Ch = ^>;

Fade(true, 0);					\fade out
end;	\GetStartingLevel

\===============================================================================

begin	\Main
ScreenBuf(0):= Malloc(320/16*200);	\get a 64000 byte buffer

SetVid($13);				\display 320x200x256 graphics
LoadSprites;				\(also sets up color registers)
GetStartingLevel;

loop	begin	\level loop
	LoadFloorPlan;
	DrawFloorPlan;
	Fade(false, 0);			\fade in new level's floor plan

	StkPtr:= 0;			\initialize for Undo command
	MoveCtr:= 0;
	loop	begin	\move loop
		DrawFloorPlan;

		\Display move counter in upper-right corner
		Attrib($07);		\for mode $13: white on backgnd
		Cursor(30, 0);
		Temp:= MoveCtr;		\right-justify the number
		if Temp = 0 then Temp:= 1;
		while Temp < 1000 do [Chout(6, Sp);  Temp:= Temp*10];
		Intout(6, MoveCtr);

		if Solved then
			begin
			Chout(0, Bel);	\beep speaker
			\Wait for keystroke, read and discard character
			Key:= CallInt($16, 0);
			quit;
			end;

		Key:= CallInt($16,0) >> 8;	\read keyboard scan code
		case Key of
		  $01:	begin			\Esc = quit
			Fade(true, 0);		\fade out
			SetVid($03);		\restore 80-column text display
			exit;
			end;
		  $0E:	Undo;			\Backspace = undo previous move
		  $48, $4B, $4D, $50: DoMove
		other	[];			\ignore illegal keystrokes
		end;	\move loop
	Fade(true, 0);				\fade out
	Sound(0, 9, 0);				\pause about 1/2 second
	Openi(1);				\clear any keystroke
	Level:= Level + 1;			\next Level
	end;	\level loop
end;	\Main
